#ifndef __VMLINUX_H__
#define __VMLINUX_H__

#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif

#ifndef __ksym
#define __ksym __attribute__((section(".ksyms")))
#endif

#ifndef __weak
#define __weak __attribute__((weak))
#endif

#ifndef __bpf_fastcall
#if __has_attribute(bpf_fastcall)
#define __bpf_fastcall __attribute__((bpf_fastcall))
#else
#define __bpf_fastcall
#endif
#endif

enum {
	ACOMP_WALK_SLEEP = 1,
	ACOMP_WALK_SRC_LINEAR = 2,
	ACOMP_WALK_DST_LINEAR = 4,
};

enum {
	ACPI_BATTERY_ALARM_PRESENT = 0,
	ACPI_BATTERY_XINFO_PRESENT = 1,
	ACPI_BATTERY_QUIRK_PERCENTAGE_CAPACITY = 2,
	ACPI_BATTERY_QUIRK_THINKPAD_MAH = 3,
	ACPI_BATTERY_QUIRK_DEGRADED_FULL_CHARGE = 4,
};

enum {
	ACPI_BUTTON_LID_INIT_IGNORE = 0,
	ACPI_BUTTON_LID_INIT_OPEN = 1,
	ACPI_BUTTON_LID_INIT_METHOD = 2,
	ACPI_BUTTON_LID_INIT_DISABLED = 3,
};

enum {
	ACPI_GENL_ATTR_UNSPEC = 0,
	ACPI_GENL_ATTR_EVENT = 1,
	__ACPI_GENL_ATTR_MAX = 2,
};

enum {
	ACPI_GENL_CMD_UNSPEC = 0,
	ACPI_GENL_CMD_EVENT = 1,
	__ACPI_GENL_CMD_MAX = 2,
};

enum {
	ACPI_REFCLASS_LOCAL = 0,
	ACPI_REFCLASS_ARG = 1,
	ACPI_REFCLASS_REFOF = 2,
	ACPI_REFCLASS_INDEX = 3,
	ACPI_REFCLASS_TABLE = 4,
	ACPI_REFCLASS_NAME = 5,
	ACPI_REFCLASS_DEBUG = 6,
	ACPI_REFCLASS_MAX = 6,
};

enum {
	ACPI_RSC_INITGET = 0,
	ACPI_RSC_INITSET = 1,
	ACPI_RSC_FLAGINIT = 2,
	ACPI_RSC_1BITFLAG = 3,
	ACPI_RSC_2BITFLAG = 4,
	ACPI_RSC_3BITFLAG = 5,
	ACPI_RSC_6BITFLAG = 6,
	ACPI_RSC_ADDRESS = 7,
	ACPI_RSC_BITMASK = 8,
	ACPI_RSC_BITMASK16 = 9,
	ACPI_RSC_COUNT = 10,
	ACPI_RSC_COUNT16 = 11,
	ACPI_RSC_COUNT_GPIO_PIN = 12,
	ACPI_RSC_COUNT_GPIO_RES = 13,
	ACPI_RSC_COUNT_GPIO_VEN = 14,
	ACPI_RSC_COUNT_SERIAL_RES = 15,
	ACPI_RSC_COUNT_SERIAL_VEN = 16,
	ACPI_RSC_DATA8 = 17,
	ACPI_RSC_EXIT_EQ = 18,
	ACPI_RSC_EXIT_LE = 19,
	ACPI_RSC_EXIT_NE = 20,
	ACPI_RSC_LENGTH = 21,
	ACPI_RSC_MOVE_GPIO_PIN = 22,
	ACPI_RSC_MOVE_GPIO_RES = 23,
	ACPI_RSC_MOVE_SERIAL_RES = 24,
	ACPI_RSC_MOVE_SERIAL_VEN = 25,
	ACPI_RSC_MOVE8 = 26,
	ACPI_RSC_MOVE16 = 27,
	ACPI_RSC_MOVE32 = 28,
	ACPI_RSC_MOVE64 = 29,
	ACPI_RSC_SET8 = 30,
	ACPI_RSC_SOURCE = 31,
	ACPI_RSC_SOURCEX = 32,
};

enum {
	ACTION_FAIL = 0,
	ACTION_REPREP = 1,
	ACTION_DELAYED_REPREP = 2,
	ACTION_RETRY = 3,
	ACTION_DELAYED_RETRY = 4,
};

enum {
	AFFINITY = 0,
	AFFINITY_LIST = 1,
	EFFECTIVE = 2,
	EFFECTIVE_LIST = 3,
};

enum {
	AHCI_MAX_PORTS = 32,
	AHCI_MAX_SG = 168,
	AHCI_DMA_BOUNDARY = 4294967295,
	AHCI_MAX_CMDS = 32,
	AHCI_CMD_SZ = 32,
	AHCI_CMD_SLOT_SZ = 1024,
	AHCI_RX_FIS_SZ = 256,
	AHCI_CMD_TBL_CDB = 64,
	AHCI_CMD_TBL_HDR_SZ = 128,
	AHCI_CMD_TBL_SZ = 2816,
	AHCI_CMD_TBL_AR_SZ = 90112,
	AHCI_PORT_PRIV_DMA_SZ = 91392,
	AHCI_PORT_PRIV_FBS_DMA_SZ = 95232,
	AHCI_IRQ_ON_SG = 2147483648,
	AHCI_CMD_ATAPI = 32,
	AHCI_CMD_WRITE = 64,
	AHCI_CMD_PREFETCH = 128,
	AHCI_CMD_RESET = 256,
	AHCI_CMD_CLR_BUSY = 1024,
	RX_FIS_PIO_SETUP = 32,
	RX_FIS_D2H_REG = 64,
	RX_FIS_SDB = 88,
	RX_FIS_UNK = 96,
	HOST_CAP = 0,
	HOST_CTL = 4,
	HOST_IRQ_STAT = 8,
	HOST_PORTS_IMPL = 12,
	HOST_VERSION = 16,
	HOST_EM_LOC = 28,
	HOST_EM_CTL = 32,
	HOST_CAP2 = 36,
	HOST_RESET = 1,
	HOST_IRQ_EN = 2,
	HOST_MRSM = 4,
	HOST_AHCI_EN = 2147483648,
	HOST_CAP_SXS = 32,
	HOST_CAP_EMS = 64,
	HOST_CAP_CCC = 128,
	HOST_CAP_PART = 8192,
	HOST_CAP_SSC = 16384,
	HOST_CAP_PIO_MULTI = 32768,
	HOST_CAP_FBS = 65536,
	HOST_CAP_PMP = 131072,
	HOST_CAP_ONLY = 262144,
	HOST_CAP_CLO = 16777216,
	HOST_CAP_LED = 33554432,
	HOST_CAP_ALPM = 67108864,
	HOST_CAP_SSS = 134217728,
	HOST_CAP_MPS = 268435456,
	HOST_CAP_SNTF = 536870912,
	HOST_CAP_NCQ = 1073741824,
	HOST_CAP_64 = 2147483648,
	HOST_CAP2_BOH = 1,
	HOST_CAP2_NVMHCI = 2,
	HOST_CAP2_APST = 4,
	HOST_CAP2_SDS = 8,
	HOST_CAP2_SADM = 16,
	HOST_CAP2_DESO = 32,
	PORT_LST_ADDR = 0,
	PORT_LST_ADDR_HI = 4,
	PORT_FIS_ADDR = 8,
	PORT_FIS_ADDR_HI = 12,
	PORT_IRQ_STAT = 16,
	PORT_IRQ_MASK = 20,
	PORT_CMD = 24,
	PORT_TFDATA = 32,
	PORT_SIG = 36,
	PORT_CMD_ISSUE = 56,
	PORT_SCR_STAT = 40,
	PORT_SCR_CTL = 44,
	PORT_SCR_ERR = 48,
	PORT_SCR_ACT = 52,
	PORT_SCR_NTF = 60,
	PORT_FBS = 64,
	PORT_DEVSLP = 68,
	PORT_IRQ_COLD_PRES = 2147483648,
	PORT_IRQ_TF_ERR = 1073741824,
	PORT_IRQ_HBUS_ERR = 536870912,
	PORT_IRQ_HBUS_DATA_ERR = 268435456,
	PORT_IRQ_IF_ERR = 134217728,
	PORT_IRQ_IF_NONFATAL = 67108864,
	PORT_IRQ_OVERFLOW = 16777216,
	PORT_IRQ_BAD_PMP = 8388608,
	PORT_IRQ_PHYRDY = 4194304,
	PORT_IRQ_DMPS = 128,
	PORT_IRQ_CONNECT = 64,
	PORT_IRQ_SG_DONE = 32,
	PORT_IRQ_UNK_FIS = 16,
	PORT_IRQ_SDB_FIS = 8,
	PORT_IRQ_DMAS_FIS = 4,
	PORT_IRQ_PIOS_FIS = 2,
	PORT_IRQ_D2H_REG_FIS = 1,
	PORT_IRQ_FREEZE = 683671632,
	PORT_IRQ_ERROR = 2025848912,
	DEF_PORT_IRQ = 2025848959,
	PORT_CMD_ASP = 134217728,
	PORT_CMD_ALPE = 67108864,
	PORT_CMD_ATAPI = 16777216,
	PORT_CMD_FBSCP = 4194304,
	PORT_CMD_ESP = 2097152,
	PORT_CMD_CPD = 1048576,
	PORT_CMD_MPSP = 524288,
	PORT_CMD_HPCP = 262144,
	PORT_CMD_PMP = 131072,
	PORT_CMD_LIST_ON = 32768,
	PORT_CMD_FIS_ON = 16384,
	PORT_CMD_FIS_RX = 16,
	PORT_CMD_CLO = 8,
	PORT_CMD_POWER_ON = 4,
	PORT_CMD_SPIN_UP = 2,
	PORT_CMD_START = 1,
	PORT_CMD_ICC_MASK = 4026531840,
	PORT_CMD_ICC_ACTIVE = 268435456,
	PORT_CMD_ICC_PARTIAL = 536870912,
	PORT_CMD_ICC_SLUMBER = 1610612736,
	PORT_CMD_CAP = 8126464,
	PORT_FBS_DWE_OFFSET = 16,
	PORT_FBS_ADO_OFFSET = 12,
	PORT_FBS_DEV_OFFSET = 8,
	PORT_FBS_DEV_MASK = 3840,
	PORT_FBS_SDE = 4,
	PORT_FBS_DEC = 2,
	PORT_FBS_EN = 1,
	PORT_DEVSLP_DM_OFFSET = 25,
	PORT_DEVSLP_DM_MASK = 503316480,
	PORT_DEVSLP_DITO_OFFSET = 15,
	PORT_DEVSLP_MDAT_OFFSET = 10,
	PORT_DEVSLP_DETO_OFFSET = 2,
	PORT_DEVSLP_DSP = 2,
	PORT_DEVSLP_ADSE = 1,
	AHCI_HFLAG_NO_NCQ = 1,
	AHCI_HFLAG_IGN_IRQ_IF_ERR = 2,
	AHCI_HFLAG_IGN_SERR_INTERNAL = 4,
	AHCI_HFLAG_32BIT_ONLY = 8,
	AHCI_HFLAG_MV_PATA = 16,
	AHCI_HFLAG_NO_MSI = 32,
	AHCI_HFLAG_NO_PMP = 64,
	AHCI_HFLAG_SECT255 = 256,
	AHCI_HFLAG_YES_NCQ = 512,
	AHCI_HFLAG_NO_SUSPEND = 1024,
	AHCI_HFLAG_SRST_TOUT_IS_OFFLINE = 2048,
	AHCI_HFLAG_NO_SNTF = 4096,
	AHCI_HFLAG_NO_FPDMA_AA = 8192,
	AHCI_HFLAG_YES_FBS = 16384,
	AHCI_HFLAG_DELAY_ENGINE = 32768,
	AHCI_HFLAG_NO_DEVSLP = 131072,
	AHCI_HFLAG_NO_FBS = 262144,
	AHCI_HFLAG_MULTI_MSI = 1048576,
	AHCI_HFLAG_WAKE_BEFORE_STOP = 4194304,
	AHCI_HFLAG_YES_ALPM = 8388608,
	AHCI_HFLAG_NO_WRITE_TO_RO = 16777216,
	AHCI_HFLAG_SUSPEND_PHYS = 33554432,
	AHCI_HFLAG_NO_SXS = 67108864,
	AHCI_HFLAG_43BIT_ONLY = 134217728,
	AHCI_HFLAG_INTEL_PCS_QUIRK = 268435456,
	AHCI_HFLAG_ATAPI_DMA_QUIRK = 536870912,
	AHCI_FLAG_COMMON = 393346,
	ICH_MAP = 144,
	PCS_6 = 146,
	PCS_7 = 148,
	EM_MAX_SLOTS = 15,
	EM_MAX_RETRY = 5,
	EM_CTL_RST = 512,
	EM_CTL_TM = 256,
	EM_CTL_MR = 1,
	EM_CTL_ALHD = 67108864,
	EM_CTL_XMT = 33554432,
	EM_CTL_SMB = 16777216,
	EM_CTL_SGPIO = 524288,
	EM_CTL_SES = 262144,
	EM_CTL_SAFTE = 131072,
	EM_CTL_LED = 65536,
	EM_MSG_TYPE_LED = 1,
	EM_MSG_TYPE_SAFTE = 2,
	EM_MSG_TYPE_SES2 = 4,
	EM_MSG_TYPE_SGPIO = 8,
};

enum {
	AHCI_PCI_BAR_STA2X11 = 0,
	AHCI_PCI_BAR_CAVIUM = 0,
	AHCI_PCI_BAR_LOONGSON = 0,
	AHCI_PCI_BAR_ENMOTUS = 2,
	AHCI_PCI_BAR_CAVIUM_GEN5 = 4,
	AHCI_PCI_BAR_STANDARD = 5,
};

enum {
	ALE_ENT_VID_MEMBER_LIST = 0,
	ALE_ENT_VID_UNREG_MCAST_MSK = 1,
	ALE_ENT_VID_REG_MCAST_MSK = 2,
	ALE_ENT_VID_FORCE_UNTAGGED_MSK = 3,
	ALE_ENT_VID_UNREG_MCAST_IDX = 4,
	ALE_ENT_VID_REG_MCAST_IDX = 5,
	ALE_ENT_VID_LAST = 6,
};

enum {
	AM62A7_EFUSE_M_MPU_OPP = 13,
	AM62A7_EFUSE_N_MPU_OPP = 14,
	AM62A7_EFUSE_O_MPU_OPP = 15,
	AM62A7_EFUSE_P_MPU_OPP = 16,
	AM62A7_EFUSE_Q_MPU_OPP = 17,
	AM62A7_EFUSE_R_MPU_OPP = 18,
	AM62A7_EFUSE_S_MPU_OPP = 19,
	AM62A7_EFUSE_V_MPU_OPP = 20,
	AM62A7_EFUSE_U_MPU_OPP = 21,
	AM62A7_EFUSE_T_MPU_OPP = 22,
};

enum {
	AM65_CPSW_REGDUMP_MOD_NUSS = 1,
	AM65_CPSW_REGDUMP_MOD_RGMII_STATUS = 2,
	AM65_CPSW_REGDUMP_MOD_MDIO = 3,
	AM65_CPSW_REGDUMP_MOD_CPSW = 4,
	AM65_CPSW_REGDUMP_MOD_CPSW_P0 = 5,
	AM65_CPSW_REGDUMP_MOD_CPSW_P1 = 6,
	AM65_CPSW_REGDUMP_MOD_CPSW_CPTS = 7,
	AM65_CPSW_REGDUMP_MOD_CPSW_ALE = 8,
	AM65_CPSW_REGDUMP_MOD_CPSW_ALE_TBL = 9,
	AM65_CPSW_REGDUMP_MOD_LAST = 10,
};

enum {
	AML_FIELD_ACCESS_ANY = 0,
	AML_FIELD_ACCESS_BYTE = 1,
	AML_FIELD_ACCESS_WORD = 2,
	AML_FIELD_ACCESS_DWORD = 3,
	AML_FIELD_ACCESS_QWORD = 4,
	AML_FIELD_ACCESS_BUFFER = 5,
};

enum {
	AML_FIELD_ATTRIB_QUICK = 2,
	AML_FIELD_ATTRIB_SEND_RECEIVE = 4,
	AML_FIELD_ATTRIB_BYTE = 6,
	AML_FIELD_ATTRIB_WORD = 8,
	AML_FIELD_ATTRIB_BLOCK = 10,
	AML_FIELD_ATTRIB_BYTES = 11,
	AML_FIELD_ATTRIB_PROCESS_CALL = 12,
	AML_FIELD_ATTRIB_BLOCK_PROCESS_CALL = 13,
	AML_FIELD_ATTRIB_RAW_BYTES = 14,
	AML_FIELD_ATTRIB_RAW_PROCESS_BYTES = 15,
};

enum {
	AML_FIELD_UPDATE_PRESERVE = 0,
	AML_FIELD_UPDATE_WRITE_AS_ONES = 32,
	AML_FIELD_UPDATE_WRITE_AS_ZEROS = 64,
};

enum {
	ARB_TIMER = 0,
	ARB_BP_CAP_CLR = 1,
	ARB_BP_CAP_HI_ADDR = 2,
	ARB_BP_CAP_ADDR = 3,
	ARB_BP_CAP_STATUS = 4,
	ARB_BP_CAP_MASTER = 5,
	ARB_ERR_CAP_CLR = 6,
	ARB_ERR_CAP_HI_ADDR = 7,
	ARB_ERR_CAP_ADDR = 8,
	ARB_ERR_CAP_STATUS = 9,
	ARB_ERR_CAP_MASTER = 10,
};

enum {
	ASCII_NULL = 0,
	ASCII_BELL = 7,
	ASCII_BACKSPACE = 8,
	ASCII_IGNORE_FIRST = 8,
	ASCII_HTAB = 9,
	ASCII_LINEFEED = 10,
	ASCII_VTAB = 11,
	ASCII_FORMFEED = 12,
	ASCII_CAR_RET = 13,
	ASCII_IGNORE_LAST = 13,
	ASCII_SHIFTOUT = 14,
	ASCII_SHIFTIN = 15,
	ASCII_CANCEL = 24,
	ASCII_SUBSTITUTE = 26,
	ASCII_ESCAPE = 27,
	ASCII_CSI_IGNORE_FIRST = 32,
	ASCII_CSI_IGNORE_LAST = 63,
	ASCII_DEL = 127,
	ASCII_EXT_CSI = 155,
};

enum {
	ASSUME_PERFECT = 255,
	ASSUME_VALID_DTB = 1,
	ASSUME_VALID_INPUT = 2,
	ASSUME_LATEST = 4,
	ASSUME_NO_ROLLBACK = 8,
	ASSUME_LIBFDT_ORDER = 16,
	ASSUME_LIBFDT_FLAWLESS = 32,
};

enum {
	ATA_EH_SPDN_NCQ_OFF = 1,
	ATA_EH_SPDN_SPEED_DOWN = 2,
	ATA_EH_SPDN_FALLBACK_TO_PIO = 4,
	ATA_EH_SPDN_KEEP_ERRORS = 8,
	ATA_EFLAG_IS_IO = 1,
	ATA_EFLAG_DUBIOUS_XFER = 2,
	ATA_EFLAG_OLD_ER = -2147483648,
	ATA_ECAT_NONE = 0,
	ATA_ECAT_ATA_BUS = 1,
	ATA_ECAT_TOUT_HSM = 2,
	ATA_ECAT_UNK_DEV = 3,
	ATA_ECAT_DUBIOUS_NONE = 4,
	ATA_ECAT_DUBIOUS_ATA_BUS = 5,
	ATA_ECAT_DUBIOUS_TOUT_HSM = 6,
	ATA_ECAT_DUBIOUS_UNK_DEV = 7,
	ATA_ECAT_NR = 8,
	ATA_EH_CMD_DFL_TIMEOUT = 5000,
	ATA_EH_RESET_COOL_DOWN = 5000,
	ATA_EH_PRERESET_TIMEOUT = 10000,
	ATA_EH_FASTDRAIN_INTERVAL = 3000,
	ATA_EH_UA_TRIES = 5,
	ATA_EH_PROBE_TRIAL_INTERVAL = 60000,
	ATA_EH_PROBE_TRIALS = 2,
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

enum {
	ATA_READID_POSTRESET = 1,
	ATA_DNXFER_PIO = 0,
	ATA_DNXFER_DMA = 1,
	ATA_DNXFER_40C = 2,
	ATA_DNXFER_FORCE_PIO = 3,
	ATA_DNXFER_FORCE_PIO0 = 4,
	ATA_DNXFER_QUIET = -2147483648,
};

enum {
	AT_PKT_END = -1,
	BEYOND_PKT_END = -2,
};

enum {
	AUTOFS_DEV_IOCTL_VERSION_CMD = 113,
	AUTOFS_DEV_IOCTL_PROTOVER_CMD = 114,
	AUTOFS_DEV_IOCTL_PROTOSUBVER_CMD = 115,
	AUTOFS_DEV_IOCTL_OPENMOUNT_CMD = 116,
	AUTOFS_DEV_IOCTL_CLOSEMOUNT_CMD = 117,
	AUTOFS_DEV_IOCTL_READY_CMD = 118,
	AUTOFS_DEV_IOCTL_FAIL_CMD = 119,
	AUTOFS_DEV_IOCTL_SETPIPEFD_CMD = 120,
	AUTOFS_DEV_IOCTL_CATATONIC_CMD = 121,
	AUTOFS_DEV_IOCTL_TIMEOUT_CMD = 122,
	AUTOFS_DEV_IOCTL_REQUESTER_CMD = 123,
	AUTOFS_DEV_IOCTL_EXPIRE_CMD = 124,
	AUTOFS_DEV_IOCTL_ASKUMOUNT_CMD = 125,
	AUTOFS_DEV_IOCTL_ISMOUNTPOINT_CMD = 126,
};

enum {
	AUTOFS_IOC_READY_CMD = 96,
	AUTOFS_IOC_FAIL_CMD = 97,
	AUTOFS_IOC_CATATONIC_CMD = 98,
	AUTOFS_IOC_PROTOVER_CMD = 99,
	AUTOFS_IOC_SETTIMEOUT_CMD = 100,
	AUTOFS_IOC_EXPIRE_CMD = 101,
};

enum {
	AXP15060_DCDC1 = 0,
	AXP15060_DCDC2 = 1,
	AXP15060_DCDC3 = 2,
	AXP15060_DCDC4 = 3,
	AXP15060_DCDC5 = 4,
	AXP15060_DCDC6 = 5,
	AXP15060_ALDO1 = 6,
	AXP15060_ALDO2 = 7,
	AXP15060_ALDO3 = 8,
	AXP15060_ALDO4 = 9,
	AXP15060_ALDO5 = 10,
	AXP15060_BLDO1 = 11,
	AXP15060_BLDO2 = 12,
	AXP15060_BLDO3 = 13,
	AXP15060_BLDO4 = 14,
	AXP15060_BLDO5 = 15,
	AXP15060_CLDO1 = 16,
	AXP15060_CLDO2 = 17,
	AXP15060_CLDO3 = 18,
	AXP15060_CLDO4 = 19,
	AXP15060_CPUSLDO = 20,
	AXP15060_SW = 21,
	AXP15060_RTC_LDO = 22,
	AXP15060_REG_ID_MAX = 23,
};

enum {
	AXP20X_LDO1 = 0,
	AXP20X_LDO2 = 1,
	AXP20X_LDO3 = 2,
	AXP20X_LDO4 = 3,
	AXP20X_LDO5 = 4,
	AXP20X_DCDC2 = 5,
	AXP20X_DCDC3 = 6,
	AXP20X_REG_ID_MAX = 7,
};

enum {
	AXP22X_DCDC1 = 0,
	AXP22X_DCDC2 = 1,
	AXP22X_DCDC3 = 2,
	AXP22X_DCDC4 = 3,
	AXP22X_DCDC5 = 4,
	AXP22X_DC1SW = 5,
	AXP22X_DC5LDO = 6,
	AXP22X_ALDO1 = 7,
	AXP22X_ALDO2 = 8,
	AXP22X_ALDO3 = 9,
	AXP22X_ELDO1 = 10,
	AXP22X_ELDO2 = 11,
	AXP22X_ELDO3 = 12,
	AXP22X_DLDO1 = 13,
	AXP22X_DLDO2 = 14,
	AXP22X_DLDO3 = 15,
	AXP22X_DLDO4 = 16,
	AXP22X_RTC_LDO = 17,
	AXP22X_LDO_IO0 = 18,
	AXP22X_LDO_IO1 = 19,
	AXP22X_REG_ID_MAX = 20,
};

enum {
	AXP313A_DCDC1 = 0,
	AXP313A_DCDC2 = 1,
	AXP313A_DCDC3 = 2,
	AXP313A_ALDO1 = 3,
	AXP313A_DLDO1 = 4,
	AXP313A_RTC_LDO = 5,
	AXP313A_REG_ID_MAX = 6,
};

enum {
	AXP717_DCDC1 = 0,
	AXP717_DCDC2 = 1,
	AXP717_DCDC3 = 2,
	AXP717_DCDC4 = 3,
	AXP717_ALDO1 = 4,
	AXP717_ALDO2 = 5,
	AXP717_ALDO3 = 6,
	AXP717_ALDO4 = 7,
	AXP717_BLDO1 = 8,
	AXP717_BLDO2 = 9,
	AXP717_BLDO3 = 10,
	AXP717_BLDO4 = 11,
	AXP717_CLDO1 = 12,
	AXP717_CLDO2 = 13,
	AXP717_CLDO3 = 14,
	AXP717_CLDO4 = 15,
	AXP717_CPUSLDO = 16,
	AXP717_BOOST = 17,
	AXP717_REG_ID_MAX = 18,
};

enum {
	AXP803_DCDC1 = 0,
	AXP803_DCDC2 = 1,
	AXP803_DCDC3 = 2,
	AXP803_DCDC4 = 3,
	AXP803_DCDC5 = 4,
	AXP803_DCDC6 = 5,
	AXP803_DC1SW = 6,
	AXP803_ALDO1 = 7,
	AXP803_ALDO2 = 8,
	AXP803_ALDO3 = 9,
	AXP803_DLDO1 = 10,
	AXP803_DLDO2 = 11,
	AXP803_DLDO3 = 12,
	AXP803_DLDO4 = 13,
	AXP803_ELDO1 = 14,
	AXP803_ELDO2 = 15,
	AXP803_ELDO3 = 16,
	AXP803_FLDO1 = 17,
	AXP803_FLDO2 = 18,
	AXP803_RTC_LDO = 19,
	AXP803_LDO_IO0 = 20,
	AXP803_LDO_IO1 = 21,
	AXP803_REG_ID_MAX = 22,
};

enum {
	AXP806_DCDCA = 0,
	AXP806_DCDCB = 1,
	AXP806_DCDCC = 2,
	AXP806_DCDCD = 3,
	AXP806_DCDCE = 4,
	AXP806_ALDO1 = 5,
	AXP806_ALDO2 = 6,
	AXP806_ALDO3 = 7,
	AXP806_BLDO1 = 8,
	AXP806_BLDO2 = 9,
	AXP806_BLDO3 = 10,
	AXP806_BLDO4 = 11,
	AXP806_CLDO1 = 12,
	AXP806_CLDO2 = 13,
	AXP806_CLDO3 = 14,
	AXP806_SW = 15,
	AXP806_REG_ID_MAX = 16,
};

enum {
	AXP809_DCDC1 = 0,
	AXP809_DCDC2 = 1,
	AXP809_DCDC3 = 2,
	AXP809_DCDC4 = 3,
	AXP809_DCDC5 = 4,
	AXP809_DC1SW = 5,
	AXP809_DC5LDO = 6,
	AXP809_ALDO1 = 7,
	AXP809_ALDO2 = 8,
	AXP809_ALDO3 = 9,
	AXP809_ELDO1 = 10,
	AXP809_ELDO2 = 11,
	AXP809_ELDO3 = 12,
	AXP809_DLDO1 = 13,
	AXP809_DLDO2 = 14,
	AXP809_RTC_LDO = 15,
	AXP809_LDO_IO0 = 16,
	AXP809_LDO_IO1 = 17,
	AXP809_SW = 18,
	AXP809_REG_ID_MAX = 19,
};

enum {
	AXP813_DCDC1 = 0,
	AXP813_DCDC2 = 1,
	AXP813_DCDC3 = 2,
	AXP813_DCDC4 = 3,
	AXP813_DCDC5 = 4,
	AXP813_DCDC6 = 5,
	AXP813_DCDC7 = 6,
	AXP813_ALDO1 = 7,
	AXP813_ALDO2 = 8,
	AXP813_ALDO3 = 9,
	AXP813_DLDO1 = 10,
	AXP813_DLDO2 = 11,
	AXP813_DLDO3 = 12,
	AXP813_DLDO4 = 13,
	AXP813_ELDO1 = 14,
	AXP813_ELDO2 = 15,
	AXP813_ELDO3 = 16,
	AXP813_FLDO1 = 17,
	AXP813_FLDO2 = 18,
	AXP813_FLDO3 = 19,
	AXP813_RTC_LDO = 20,
	AXP813_LDO_IO0 = 21,
	AXP813_LDO_IO1 = 22,
	AXP813_SW = 23,
	AXP813_REG_ID_MAX = 24,
};

enum {
	Audit_equal = 0,
	Audit_not_equal = 1,
	Audit_bitmask = 2,
	Audit_bittest = 3,
	Audit_lt = 4,
	Audit_gt = 5,
	Audit_le = 6,
	Audit_ge = 7,
	Audit_bad = 8,
};

enum {
	B28_DPT_INI = 3584,
	B28_DPT_VAL = 3588,
	B28_DPT_CTRL = 3592,
	B28_DPT_TST = 3594,
};

enum {
	B28_Y2_SMB_CONFIG = 3648,
	B28_Y2_SMB_CSD_REG = 3652,
	B28_Y2_ASF_IRQ_V_BASE = 3680,
	B28_Y2_ASF_STAT_CMD = 3688,
	B28_Y2_ASF_HOST_COM = 3692,
	B28_Y2_DATA_REG_1 = 3696,
	B28_Y2_DATA_REG_2 = 3700,
	B28_Y2_DATA_REG_3 = 3704,
	B28_Y2_DATA_REG_4 = 3708,
};

enum {
	B6_EXT_REG = 768,
	B7_CFG_SPC = 896,
	B8_RQ1_REGS = 1024,
	B8_RQ2_REGS = 1152,
	B8_TS1_REGS = 1536,
	B8_TA1_REGS = 1664,
	B8_TS2_REGS = 1792,
	B8_TA2_REGS = 1920,
	B16_RAM_REGS = 2048,
};

enum {
	B8_Q_REGS = 1024,
	Q_D = 0,
	Q_VLAN = 32,
	Q_DONE = 36,
	Q_AC_L = 40,
	Q_AC_H = 44,
	Q_BC = 48,
	Q_CSR = 52,
	Q_TEST = 56,
	Q_WM = 64,
	Q_AL = 66,
	Q_RSP = 68,
	Q_RSL = 70,
	Q_RP = 72,
	Q_RL = 74,
	Q_WP = 76,
	Q_WSP = 77,
	Q_WL = 78,
	Q_WSL = 79,
};

enum {
	BASE_GMAC_1 = 10240,
	BASE_GMAC_2 = 14336,
};

enum {
	BCM_MSG_FUNC_LINK_START = 0,
	BCM_MSG_FUNC_LINK_STOP = 1,
	BCM_MSG_FUNC_SHMEM_TX = 2,
	BCM_MSG_FUNC_SHMEM_RX = 3,
	BCM_MSG_FUNC_SHMEM_STOP = 4,
	BCM_MSG_FUNC_MAX = 5,
};

enum {
	BCM_MSG_SVC_INIT = 0,
	BCM_MSG_SVC_PMC = 1,
	BCM_MSG_SVC_SCMI = 2,
	BCM_MSG_SVC_DPFE = 3,
	BCM_MSG_SVC_MAX = 4,
};

enum {
	BD718XX_BUCK1 = 0,
	BD718XX_BUCK2 = 1,
	BD718XX_BUCK3 = 2,
	BD718XX_BUCK4 = 3,
	BD718XX_BUCK5 = 4,
	BD718XX_BUCK6 = 5,
	BD718XX_BUCK7 = 6,
	BD718XX_BUCK8 = 7,
	BD718XX_LDO1 = 8,
	BD718XX_LDO2 = 9,
	BD718XX_LDO3 = 10,
	BD718XX_LDO4 = 11,
	BD718XX_LDO5 = 12,
	BD718XX_LDO6 = 13,
	BD718XX_LDO7 = 14,
	BD718XX_REGULATOR_AMOUNT = 15,
};

enum {
	BD718XX_INT_STBY_REQ = 0,
	BD718XX_INT_ON_REQ = 1,
	BD718XX_INT_WDOG = 2,
	BD718XX_INT_PWRBTN = 3,
	BD718XX_INT_PWRBTN_L = 4,
	BD718XX_INT_PWRBTN_S = 5,
	BD718XX_INT_SWRST = 6,
};

enum {
	BD718XX_REG_REV = 0,
	BD718XX_REG_SWRESET = 1,
	BD718XX_REG_I2C_DEV = 2,
	BD718XX_REG_PWRCTRL0 = 3,
	BD718XX_REG_PWRCTRL1 = 4,
	BD718XX_REG_BUCK1_CTRL = 5,
	BD718XX_REG_BUCK2_CTRL = 6,
	BD718XX_REG_1ST_NODVS_BUCK_CTRL = 9,
	BD718XX_REG_2ND_NODVS_BUCK_CTRL = 10,
	BD718XX_REG_3RD_NODVS_BUCK_CTRL = 11,
	BD718XX_REG_4TH_NODVS_BUCK_CTRL = 12,
	BD718XX_REG_BUCK1_VOLT_RUN = 13,
	BD718XX_REG_BUCK1_VOLT_IDLE = 14,
	BD718XX_REG_BUCK1_VOLT_SUSP = 15,
	BD718XX_REG_BUCK2_VOLT_RUN = 16,
	BD718XX_REG_BUCK2_VOLT_IDLE = 17,
	BD718XX_REG_1ST_NODVS_BUCK_VOLT = 20,
	BD718XX_REG_2ND_NODVS_BUCK_VOLT = 21,
	BD718XX_REG_3RD_NODVS_BUCK_VOLT = 22,
	BD718XX_REG_4TH_NODVS_BUCK_VOLT = 23,
	BD718XX_REG_LDO1_VOLT = 24,
	BD718XX_REG_LDO2_VOLT = 25,
	BD718XX_REG_LDO3_VOLT = 26,
	BD718XX_REG_LDO4_VOLT = 27,
	BD718XX_REG_LDO5_VOLT = 28,
	BD718XX_REG_LDO6_VOLT = 29,
	BD718XX_REG_TRANS_COND0 = 31,
	BD718XX_REG_TRANS_COND1 = 32,
	BD718XX_REG_VRFAULTEN = 33,
	BD718XX_REG_MVRFLTMASK0 = 34,
	BD718XX_REG_MVRFLTMASK1 = 35,
	BD718XX_REG_MVRFLTMASK2 = 36,
	BD718XX_REG_RCVCFG = 37,
	BD718XX_REG_RCVNUM = 38,
	BD718XX_REG_PWRONCONFIG0 = 39,
	BD718XX_REG_PWRONCONFIG1 = 40,
	BD718XX_REG_RESETSRC = 41,
	BD718XX_REG_MIRQ = 42,
	BD718XX_REG_IRQ = 43,
	BD718XX_REG_IN_MON = 44,
	BD718XX_REG_POW_STATE = 45,
	BD718XX_REG_OUT32K = 46,
	BD718XX_REG_REGLOCK = 47,
	BD718XX_REG_OTPVER = 255,
	BD718XX_MAX_REGISTER = 256,
};

enum {
	BIAS = 2147483648,
};

enum {
	BIOSET_NEED_BVECS = 1,
	BIOSET_NEED_RESCUER = 2,
	BIOSET_PERCPU_CACHE = 4,
};

enum {
	BIO_PAGE_PINNED = 0,
	BIO_CLONED = 1,
	BIO_QUIET = 2,
	BIO_CHAIN = 3,
	BIO_REFFED = 4,
	BIO_BPS_THROTTLED = 5,
	BIO_TRACE_COMPLETION = 6,
	BIO_CGROUP_ACCT = 7,
	BIO_QOS_THROTTLED = 8,
	BIO_TG_BPS_THROTTLED = 8,
	BIO_QOS_MERGED = 9,
	BIO_REMAPPED = 10,
	BIO_ZONE_WRITE_PLUGGING = 11,
	BIO_EMULATES_ZONE_APPEND = 12,
	BIO_FLAG_LAST = 13,
};

enum {
	BLINK_42MS = 0,
	BLINK_84MS = 1,
	BLINK_170MS = 2,
	BLINK_340MS = 3,
	BLINK_670MS = 4,
};

enum {
	BLK_MQ_F_TAG_QUEUE_SHARED = 2,
	BLK_MQ_F_STACKING = 4,
	BLK_MQ_F_TAG_HCTX_SHARED = 8,
	BLK_MQ_F_BLOCKING = 16,
	BLK_MQ_F_TAG_RR = 32,
	BLK_MQ_F_NO_SCHED_BY_DEFAULT = 64,
	BLK_MQ_F_MAX = 128,
};

enum {
	BLK_MQ_NO_TAG = 4294967295,
	BLK_MQ_TAG_MIN = 1,
	BLK_MQ_TAG_MAX = 4294967294,
};

enum {
	BLK_MQ_REQ_NOWAIT = 1,
	BLK_MQ_REQ_RESERVED = 2,
	BLK_MQ_REQ_PM = 4,
};

enum {
	BLK_MQ_S_STOPPED = 0,
	BLK_MQ_S_TAG_ACTIVE = 1,
	BLK_MQ_S_SCHED_RESTART = 2,
	BLK_MQ_S_INACTIVE = 3,
	BLK_MQ_S_MAX = 4,
};

enum {
	BLK_MQ_UNIQUE_TAG_BITS = 16,
	BLK_MQ_UNIQUE_TAG_MASK = 65535,
};

enum {
	BLOCK_BITMAP = 0,
	INODE_BITMAP = 1,
	INODE_TABLE = 2,
	GROUP_TABLE_COUNT = 3,
};

enum {
	BMC_NPCM7XX = 0,
	BMC_NPCM8XX = 1,
};

enum {
	BMU_IDLE = -2147483648,
	BMU_RX_TCP_PKT = 1073741824,
	BMU_RX_IP_PKT = 536870912,
	BMU_ENA_RX_RSS_HASH = 32768,
	BMU_DIS_RX_RSS_HASH = 16384,
	BMU_ENA_RX_CHKSUM = 8192,
	BMU_DIS_RX_CHKSUM = 4096,
	BMU_CLR_IRQ_PAR = 2048,
	BMU_CLR_IRQ_TCP = 2048,
	BMU_CLR_IRQ_CHK = 1024,
	BMU_STOP = 512,
	BMU_START = 256,
	BMU_FIFO_OP_ON = 128,
	BMU_FIFO_OP_OFF = 64,
	BMU_FIFO_ENA = 32,
	BMU_FIFO_RST = 16,
	BMU_OP_ON = 8,
	BMU_OP_OFF = 4,
	BMU_RST_CLR = 2,
	BMU_RST_SET = 1,
	BMU_CLR_RESET = 22,
	BMU_OPER_INIT = 3368,
	BMU_WM_DEFAULT = 1536,
	BMU_WM_PEX = 128,
};

enum {
	BPF_ADJ_ROOM_ENCAP_L2_MASK = 255,
	BPF_ADJ_ROOM_ENCAP_L2_SHIFT = 56,
};

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_CSUM_LEVEL_QUERY = 0,
	BPF_CSUM_LEVEL_INC = 1,
	BPF_CSUM_LEVEL_DEC = 2,
	BPF_CSUM_LEVEL_RESET = 3,
};

enum {
	BPF_FIB_LKUP_RET_SUCCESS = 0,
	BPF_FIB_LKUP_RET_BLACKHOLE = 1,
	BPF_FIB_LKUP_RET_UNREACHABLE = 2,
	BPF_FIB_LKUP_RET_PROHIBIT = 3,
	BPF_FIB_LKUP_RET_NOT_FWDED = 4,
	BPF_FIB_LKUP_RET_FWD_DISABLED = 5,
	BPF_FIB_LKUP_RET_UNSUPP_LWT = 6,
	BPF_FIB_LKUP_RET_NO_NEIGH = 7,
	BPF_FIB_LKUP_RET_FRAG_NEEDED = 8,
	BPF_FIB_LKUP_RET_NO_SRC_ADDR = 9,
};

enum {
	BPF_FIB_LOOKUP_DIRECT = 1,
	BPF_FIB_LOOKUP_OUTPUT = 2,
	BPF_FIB_LOOKUP_SKIP_NEIGH = 4,
	BPF_FIB_LOOKUP_TBID = 8,
	BPF_FIB_LOOKUP_SRC = 16,
	BPF_FIB_LOOKUP_MARK = 32,
};

enum {
	BPF_F_ADJ_ROOM_FIXED_GSO = 1,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV4 = 2,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV6 = 4,
	BPF_F_ADJ_ROOM_ENCAP_L4_GRE = 8,
	BPF_F_ADJ_ROOM_ENCAP_L4_UDP = 16,
	BPF_F_ADJ_ROOM_NO_CSUM_RESET = 32,
	BPF_F_ADJ_ROOM_ENCAP_L2_ETH = 64,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV4 = 128,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV6 = 256,
};

enum {
	BPF_F_HDR_FIELD_MASK = 15,
};

enum {
	BPF_F_INDEX_MASK = 4294967295ULL,
	BPF_F_CURRENT_CPU = 4294967295ULL,
	BPF_F_CTXLEN_MASK = 4503595332403200ULL,
};

enum {
	BPF_F_INGRESS = 1,
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum {
	BPF_F_KPROBE_MULTI_RETURN = 1,
};

enum {
	BPF_F_NEIGH = 65536,
	BPF_F_PEER = 131072,
	BPF_F_NEXTHOP = 262144,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
	BPF_F_VTYPE_BTF_OBJ_FD = 32768,
	BPF_F_TOKEN_FD = 65536,
	BPF_F_SEGV_ON_FAULT = 131072,
	BPF_F_NO_USER_CONV = 262144,
};

enum {
	BPF_F_PSEUDO_HDR = 16,
	BPF_F_MARK_MANGLED_0 = 32,
	BPF_F_MARK_ENFORCE = 64,
	BPF_F_IPV6 = 128,
};

enum {
	BPF_F_RECOMPUTE_CSUM = 1,
	BPF_F_INVALIDATE_HASH = 2,
};

enum {
	BPF_F_SKIP_FIELD_MASK = 255,
	BPF_F_USER_STACK = 256,
	BPF_F_FAST_STACK_CMP = 512,
	BPF_F_REUSE_STACKID = 1024,
	BPF_F_USER_BUILD_ID = 2048,
};

enum {
	BPF_F_SYSCTL_BASE_NAME = 1,
};

enum {
	BPF_F_TIMER_ABS = 1,
	BPF_F_TIMER_CPU_PIN = 2,
};

enum {
	BPF_F_TUNINFO_FLAGS = 16,
};

enum {
	BPF_F_TUNINFO_IPV6 = 1,
};

enum {
	BPF_F_UPROBE_MULTI_RETURN = 1,
};

enum {
	BPF_F_ZERO_CSUM_TX = 2,
	BPF_F_DONT_FRAGMENT = 4,
	BPF_F_SEQ_NUMBER = 8,
	BPF_F_NO_TUNNEL_KEY = 16,
};

enum {
	BPF_LOAD_HDR_OPT_TCP_SYN = 1,
};

enum {
	BPF_LOCAL_STORAGE_GET_F_CREATE = 1,
	BPF_SK_STORAGE_GET_F_CREATE = 1,
};

enum {
	BPF_MAX_LOOPS = 8388608,
	BPF_MAX_TIMED_LOOPS = 65535,
};

enum {
	BPF_MAX_TRAMP_LINKS = 38,
};

enum {
	BPF_RB_AVAIL_DATA = 0,
	BPF_RB_RING_SIZE = 1,
	BPF_RB_CONS_POS = 2,
	BPF_RB_PROD_POS = 3,
};

enum {
	BPF_RB_NO_WAKEUP = 1,
	BPF_RB_FORCE_WAKEUP = 2,
};

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

enum {
	BPF_RINGBUF_BUSY_BIT = 2147483648,
	BPF_RINGBUF_DISCARD_BIT = 1073741824,
	BPF_RINGBUF_HDR_SZ = 8,
};

enum {
	BPF_SKB_TSTAMP_UNSPEC = 0,
	BPF_SKB_TSTAMP_DELIVERY_MONO = 1,
	BPF_SKB_CLOCK_REALTIME = 0,
	BPF_SKB_CLOCK_MONOTONIC = 1,
	BPF_SKB_CLOCK_TAI = 2,
};

enum {
	BPF_SK_LOOKUP_F_REPLACE = 1,
	BPF_SK_LOOKUP_F_NO_REUSEPORT = 2,
};

enum {
	BPF_SOCK_OPS_RTO_CB_FLAG = 1,
	BPF_SOCK_OPS_RETRANS_CB_FLAG = 2,
	BPF_SOCK_OPS_STATE_CB_FLAG = 4,
	BPF_SOCK_OPS_RTT_CB_FLAG = 8,
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG = 16,
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = 32,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG = 64,
	BPF_SOCK_OPS_ALL_CB_FLAGS = 127,
};

enum {
	BPF_SOCK_OPS_VOID = 0,
	BPF_SOCK_OPS_TIMEOUT_INIT = 1,
	BPF_SOCK_OPS_RWND_INIT = 2,
	BPF_SOCK_OPS_TCP_CONNECT_CB = 3,
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB = 4,
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB = 5,
	BPF_SOCK_OPS_NEEDS_ECN = 6,
	BPF_SOCK_OPS_BASE_RTT = 7,
	BPF_SOCK_OPS_RTO_CB = 8,
	BPF_SOCK_OPS_RETRANS_CB = 9,
	BPF_SOCK_OPS_STATE_CB = 10,
	BPF_SOCK_OPS_TCP_LISTEN_CB = 11,
	BPF_SOCK_OPS_RTT_CB = 12,
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB = 13,
	BPF_SOCK_OPS_HDR_OPT_LEN_CB = 14,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB = 15,
	BPF_SOCK_OPS_TSTAMP_SCHED_CB = 16,
	BPF_SOCK_OPS_TSTAMP_SND_SW_CB = 17,
	BPF_SOCK_OPS_TSTAMP_SND_HW_CB = 18,
	BPF_SOCK_OPS_TSTAMP_ACK_CB = 19,
	BPF_SOCK_OPS_TSTAMP_SENDMSG_CB = 20,
};

enum {
	BPF_STREAM_MAX_CAPACITY = 100000,
};

enum {
	BPF_TASK_ITER_ALL_PROCS = 0,
	BPF_TASK_ITER_ALL_THREADS = 1,
	BPF_TASK_ITER_PROC_THREADS = 2,
};

enum {
	BPF_TCP_ESTABLISHED = 1,
	BPF_TCP_SYN_SENT = 2,
	BPF_TCP_SYN_RECV = 3,
	BPF_TCP_FIN_WAIT1 = 4,
	BPF_TCP_FIN_WAIT2 = 5,
	BPF_TCP_TIME_WAIT = 6,
	BPF_TCP_CLOSE = 7,
	BPF_TCP_CLOSE_WAIT = 8,
	BPF_TCP_LAST_ACK = 9,
	BPF_TCP_LISTEN = 10,
	BPF_TCP_CLOSING = 11,
	BPF_TCP_NEW_SYN_RECV = 12,
	BPF_TCP_BOUND_INACTIVE = 13,
	BPF_TCP_MAX_STATES = 14,
};

enum {
	BPF_WRITE_HDR_TCP_CURRENT_MSS = 1,
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE = 2,
};

enum {
	BTF_FIELD_IGNORE = 0,
	BTF_FIELD_FOUND = 1,
};

enum {
	BTF_F_COMPACT = 1,
	BTF_F_NONAME = 2,
	BTF_F_PTR_RAW = 4,
	BTF_F_ZERO = 8,
};

enum {
	BTF_KFUNC_SET_MAX_CNT = 256,
	BTF_DTOR_KFUNC_MAX_CNT = 256,
	BTF_KFUNC_FILTER_MAX_CNT = 16,
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

enum {
	BTF_MODULE_F_LIVE = 1,
};

enum {
	BTF_SOCK_TYPE_INET = 0,
	BTF_SOCK_TYPE_INET_CONN = 1,
	BTF_SOCK_TYPE_INET_REQ = 2,
	BTF_SOCK_TYPE_INET_TW = 3,
	BTF_SOCK_TYPE_REQ = 4,
	BTF_SOCK_TYPE_SOCK = 5,
	BTF_SOCK_TYPE_SOCK_COMMON = 6,
	BTF_SOCK_TYPE_TCP = 7,
	BTF_SOCK_TYPE_TCP_REQ = 8,
	BTF_SOCK_TYPE_TCP_TW = 9,
	BTF_SOCK_TYPE_TCP6 = 10,
	BTF_SOCK_TYPE_UDP = 11,
	BTF_SOCK_TYPE_UDP6 = 12,
	BTF_SOCK_TYPE_UNIX = 13,
	BTF_SOCK_TYPE_MPTCP = 14,
	BTF_SOCK_TYPE_SOCKET = 15,
	MAX_BTF_SOCK_TYPE = 16,
};

enum {
	BTF_TRACING_TYPE_TASK = 0,
	BTF_TRACING_TYPE_FILE = 1,
	BTF_TRACING_TYPE_VMA = 2,
	MAX_BTF_TRACING_TYPE = 3,
};

enum {
	BTF_VAR_STATIC = 0,
	BTF_VAR_GLOBAL_ALLOCATED = 1,
	BTF_VAR_GLOBAL_EXTERN = 2,
};

enum {
	CACHE_VALID = 0,
	CACHE_NEGATIVE = 1,
	CACHE_PENDING = 2,
	CACHE_CLEANED = 3,
};

enum {
	CAP_HWCAP = 1,
	CAP_COMPAT_HWCAP = 2,
	CAP_COMPAT_HWCAP2 = 3,
};

enum {
	CBF_XO_INDEX = 0,
	CBF_PLL_INDEX = 1,
	CBF_DIV_INDEX = 2,
	CBF_APCS_AUX_INDEX = 3,
};

enum {
	CFG_CHIP_R_MSK = 240,
	CFG_DIS_M2_CLK = 2,
	CFG_SNG_MAC = 1,
};

enum {
	CFG_LED_MODE_MSK = 28,
	CFG_LINK_2_AVAIL = 2,
	CFG_LINK_1_AVAIL = 1,
};

enum {
	CFG_PRE_INIT = 0,
	CFG_POST_INIT = 1,
	CFG_PRE_PWR_HS = 2,
	CFG_POST_PWR_HS = 3,
	CFG_TAG_MAX = 4,
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

enum {
	CGROUPSTATS_CMD_ATTR_UNSPEC = 0,
	CGROUPSTATS_CMD_ATTR_FD = 1,
	__CGROUPSTATS_CMD_ATTR_MAX = 2,
};

enum {
	CGROUPSTATS_CMD_UNSPEC = 3,
	CGROUPSTATS_CMD_GET = 4,
	CGROUPSTATS_CMD_NEW = 5,
	__CGROUPSTATS_CMD_MAX = 6,
};

enum {
	CGROUPSTATS_TYPE_UNSPEC = 0,
	CGROUPSTATS_TYPE_CGROUP_STATS = 1,
	__CGROUPSTATS_TYPE_MAX = 2,
};

enum {
	CGRP_NOTIFY_ON_RELEASE = 0,
	CGRP_CPUSET_CLONE_CHILDREN = 1,
	CGRP_FREEZE = 2,
	CGRP_FROZEN = 3,
};

enum {
	CGRP_ROOT_NOPREFIX = 2,
	CGRP_ROOT_XATTR = 4,
	CGRP_ROOT_NS_DELEGATE = 8,
	CGRP_ROOT_FAVOR_DYNMODS = 16,
	CGRP_ROOT_CPUSET_V2_MODE = 65536,
	CGRP_ROOT_MEMORY_LOCAL_EVENTS = 131072,
	CGRP_ROOT_MEMORY_RECURSIVE_PROT = 262144,
	CGRP_ROOT_MEMORY_HUGETLB_ACCOUNTING = 524288,
	CGRP_ROOT_PIDS_LOCAL_EVENTS = 1048576,
};

enum {
	CHIP_ID_YUKON_XL = 179,
	CHIP_ID_YUKON_EC_U = 180,
	CHIP_ID_YUKON_EX = 181,
	CHIP_ID_YUKON_EC = 182,
	CHIP_ID_YUKON_FE = 183,
	CHIP_ID_YUKON_FE_P = 184,
	CHIP_ID_YUKON_SUPR = 185,
	CHIP_ID_YUKON_UL_2 = 186,
	CHIP_ID_YUKON_OPT = 188,
	CHIP_ID_YUKON_PRM = 189,
	CHIP_ID_YUKON_OP_2 = 190,
};

enum {
	CLK_ALPHA_PLL_TYPE_DEFAULT = 0,
	CLK_ALPHA_PLL_TYPE_HUAYRA = 1,
	CLK_ALPHA_PLL_TYPE_HUAYRA_APSS = 2,
	CLK_ALPHA_PLL_TYPE_HUAYRA_2290 = 3,
	CLK_ALPHA_PLL_TYPE_BRAMMO = 4,
	CLK_ALPHA_PLL_TYPE_FABIA = 5,
	CLK_ALPHA_PLL_TYPE_TRION = 6,
	CLK_ALPHA_PLL_TYPE_LUCID = 6,
	CLK_ALPHA_PLL_TYPE_AGERA = 7,
	CLK_ALPHA_PLL_TYPE_ZONDA = 8,
	CLK_ALPHA_PLL_TYPE_REGERA = 8,
	CLK_ALPHA_PLL_TYPE_ZONDA_OLE = 9,
	CLK_ALPHA_PLL_TYPE_LUCID_EVO = 10,
	CLK_ALPHA_PLL_TYPE_LUCID_OLE = 11,
	CLK_ALPHA_PLL_TYPE_PONGO_ELU = 12,
	CLK_ALPHA_PLL_TYPE_TAYCAN_ELU = 13,
	CLK_ALPHA_PLL_TYPE_TAYCAN_EKO_T = 13,
	CLK_ALPHA_PLL_TYPE_RIVIAN_EVO = 14,
	CLK_ALPHA_PLL_TYPE_DEFAULT_EVO = 15,
	CLK_ALPHA_PLL_TYPE_BRAMMO_EVO = 16,
	CLK_ALPHA_PLL_TYPE_STROMER = 17,
	CLK_ALPHA_PLL_TYPE_STROMER_PLUS = 18,
	CLK_ALPHA_PLL_TYPE_NSS_HUAYRA = 19,
	CLK_ALPHA_PLL_TYPE_MAX = 20,
};

enum {
	CLK_QSPI_APB = 0,
	CLK_QSPI_AHB = 1,
	CLK_QSPI_NUM = 2,
};

enum {
	CMD_CLK_GET_RATE = 1,
	CMD_CLK_SET_RATE = 2,
	CMD_CLK_ROUND_RATE = 3,
	CMD_CLK_GET_PARENT = 4,
	CMD_CLK_SET_PARENT = 5,
	CMD_CLK_IS_ENABLED = 6,
	CMD_CLK_ENABLE = 7,
	CMD_CLK_DISABLE = 8,
	CMD_CLK_PROPERTIES = 9,
	CMD_CLK_POSSIBLE_PARENTS = 10,
	CMD_CLK_NUM_POSSIBLE_PARENTS = 11,
	CMD_CLK_GET_POSSIBLE_PARENT = 12,
	CMD_CLK_RESET_REFCOUNTS = 13,
	CMD_CLK_GET_ALL_INFO = 14,
	CMD_CLK_GET_MAX_CLK_ID = 15,
	CMD_CLK_GET_FMAX_AT_VMIN = 16,
	CMD_CLK_MAX = 17,
};

enum {
	CMD_I2C_XFER = 1,
};

enum {
	CMIS_MODULE_LOW_PWR = 1,
	CMIS_MODULE_READY = 3,
};

enum {
	COREDUMP_ACK_SIZE_VER0 = 16,
};

enum {
	COREDUMP_KERNEL = 1,
	COREDUMP_USERSPACE = 2,
	COREDUMP_REJECT = 4,
	COREDUMP_WAIT = 8,
};

enum {
	CP110_CLK_TYPE_CORE = 0,
	CP110_CLK_TYPE_GATABLE = 1,
};

enum {
	CPER_SEV_RECOVERABLE = 0,
	CPER_SEV_FATAL = 1,
	CPER_SEV_CORRECTED = 2,
	CPER_SEV_INFORMATIONAL = 3,
};

enum {
	CPORT_IDLE = 0,
	CPORT_CONNECTED = 1,
};

enum {
	CPSW_ALE_F_STATUS_REG = 1,
	CPSW_ALE_F_HW_AUTOAGING = 2,
	CPSW_ALE_F_COUNT = 3,
};

enum {
	CPSW_SL_CTL_FULLDUPLEX = 1,
	CPSW_SL_CTL_LOOPBACK = 2,
	CPSW_SL_CTL_MTEST = 4,
	CPSW_SL_CTL_RX_FLOW_EN = 8,
	CPSW_SL_CTL_TX_FLOW_EN = 16,
	CPSW_SL_CTL_GMII_EN = 32,
	CPSW_SL_CTL_TX_PACE = 64,
	CPSW_SL_CTL_GIG = 128,
	CPSW_SL_CTL_XGIG = 256,
	CPSW_SL_CTL_TX_SHORT_GAP_EN = 1024,
	CPSW_SL_CTL_CMD_IDLE = 2048,
	CPSW_SL_CTL_CRC_TYPE = 4096,
	CPSW_SL_CTL_XGMII_EN = 8192,
	CPSW_SL_CTL_IFCTL_A = 32768,
	CPSW_SL_CTL_IFCTL_B = 65536,
	CPSW_SL_CTL_GIG_FORCE = 131072,
	CPSW_SL_CTL_EXT_EN = 262144,
	CPSW_SL_CTL_EXT_EN_RX_FLO = 524288,
	CPSW_SL_CTL_EXT_EN_TX_FLO = 1048576,
	CPSW_SL_CTL_TX_SG_LIM_EN = 2097152,
	CPSW_SL_CTL_RX_CEF_EN = 4194304,
	CPSW_SL_CTL_RX_CSF_EN = 8388608,
	CPSW_SL_CTL_RX_CMF_EN = 16777216,
	CPSW_SL_CTL_EXT_EN_XGIG = 33554432,
	CPSW_SL_CTL_FUNCS_COUNT = 33554433,
};

enum {
	CPU_WDOG = 3656,
	CPU_CNTR = 3660,
	CPU_TIM = 3664,
	CPU_AHB_ADDR = 3668,
	CPU_AHB_WDATA = 3672,
	CPU_AHB_RDATA = 3676,
	HCU_MAP_BASE = 3680,
	CPU_AHB_CTRL = 3684,
	HCU_CCSR = 3688,
	HCU_HCSR = 3692,
};

enum {
	CRNG_EMPTY = 0,
	CRNG_EARLY = 1,
	CRNG_READY = 2,
};

enum {
	CRNG_RESEED_START_INTERVAL = 250,
	CRNG_RESEED_INTERVAL = 15000,
};

enum {
	CROS_EC_SENSOR_LAST_TS = 0,
	CROS_EC_SENSOR_NEW_TS = 1,
	CROS_EC_SENSOR_ALL_TS = 2,
};

enum {
	CRYPTOA_UNSPEC = 0,
	CRYPTOA_ALG = 1,
	CRYPTOA_TYPE = 2,
	__CRYPTOA_MAX = 3,
};

enum {
	CRYPTO_AUTHENC_KEYA_UNSPEC = 0,
	CRYPTO_AUTHENC_KEYA_PARAM = 1,
};

enum {
	CRYPTO_KPP_SECRET_TYPE_UNKNOWN = 0,
	CRYPTO_KPP_SECRET_TYPE_DH = 1,
	CRYPTO_KPP_SECRET_TYPE_ECDH = 2,
};

enum {
	CRYPTO_MSG_ALG_REQUEST = 0,
	CRYPTO_MSG_ALG_REGISTER = 1,
	CRYPTO_MSG_ALG_LOADED = 2,
};

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

enum {
	CSI_DEC_hl_CURSOR_KEYS = 1,
	CSI_DEC_hl_132_COLUMNS = 3,
	CSI_DEC_hl_REVERSE_VIDEO = 5,
	CSI_DEC_hl_ORIGIN_MODE = 6,
	CSI_DEC_hl_AUTOWRAP = 7,
	CSI_DEC_hl_AUTOREPEAT = 8,
	CSI_DEC_hl_MOUSE_X10 = 9,
	CSI_DEC_hl_SHOW_CURSOR = 25,
	CSI_DEC_hl_MOUSE_VT200 = 1000,
	CSI_DEC_hl_ALT_SCREEN = 1049,
	CSI_DEC_hl_BRACKETED_PASTE = 2004,
};

enum {
	CSI_K_CURSOR_TO_LINEEND = 0,
	CSI_K_LINESTART_TO_CURSOR = 1,
	CSI_K_LINE = 2,
};

enum {
	CSI_hl_DISPLAY_CTRL = 3,
	CSI_hl_INSERT = 4,
	CSI_hl_AUTO_NL = 20,
};

enum {
	CSI_m_DEFAULT = 0,
	CSI_m_BOLD = 1,
	CSI_m_HALF_BRIGHT = 2,
	CSI_m_ITALIC = 3,
	CSI_m_UNDERLINE = 4,
	CSI_m_BLINK = 5,
	CSI_m_REVERSE = 7,
	CSI_m_PRI_FONT = 10,
	CSI_m_ALT_FONT1 = 11,
	CSI_m_ALT_FONT2 = 12,
	CSI_m_DOUBLE_UNDERLINE = 21,
	CSI_m_NORMAL_INTENSITY = 22,
	CSI_m_NO_ITALIC = 23,
	CSI_m_NO_UNDERLINE = 24,
	CSI_m_NO_BLINK = 25,
	CSI_m_NO_REVERSE = 27,
	CSI_m_FG_COLOR_BEG = 30,
	CSI_m_FG_COLOR_END = 37,
	CSI_m_FG_COLOR = 38,
	CSI_m_DEFAULT_FG_COLOR = 39,
	CSI_m_BG_COLOR_BEG = 40,
	CSI_m_BG_COLOR_END = 47,
	CSI_m_BG_COLOR = 48,
	CSI_m_DEFAULT_BG_COLOR = 49,
	CSI_m_BRIGHT_FG_COLOR_BEG = 90,
	CSI_m_BRIGHT_FG_COLOR_END = 97,
	CSI_m_BRIGHT_FG_COLOR_OFF = 60,
	CSI_m_BRIGHT_BG_COLOR_BEG = 100,
	CSI_m_BRIGHT_BG_COLOR_END = 107,
	CSI_m_BRIGHT_BG_COLOR_OFF = 60,
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

enum {
	CTRL_ATTR_MCAST_GRP_UNSPEC = 0,
	CTRL_ATTR_MCAST_GRP_NAME = 1,
	CTRL_ATTR_MCAST_GRP_ID = 2,
	__CTRL_ATTR_MCAST_GRP_MAX = 3,
};

enum {
	CTRL_ATTR_OP_UNSPEC = 0,
	CTRL_ATTR_OP_ID = 1,
	CTRL_ATTR_OP_FLAGS = 2,
	__CTRL_ATTR_OP_MAX = 3,
};

enum {
	CTRL_ATTR_POLICY_UNSPEC = 0,
	CTRL_ATTR_POLICY_DO = 1,
	CTRL_ATTR_POLICY_DUMP = 2,
	__CTRL_ATTR_POLICY_DUMP_MAX = 3,
	CTRL_ATTR_POLICY_DUMP_MAX = 2,
};

enum {
	CTRL_ATTR_UNSPEC = 0,
	CTRL_ATTR_FAMILY_ID = 1,
	CTRL_ATTR_FAMILY_NAME = 2,
	CTRL_ATTR_VERSION = 3,
	CTRL_ATTR_HDRSIZE = 4,
	CTRL_ATTR_MAXATTR = 5,
	CTRL_ATTR_OPS = 6,
	CTRL_ATTR_MCAST_GROUPS = 7,
	CTRL_ATTR_POLICY = 8,
	CTRL_ATTR_OP_POLICY = 9,
	CTRL_ATTR_OP = 10,
	__CTRL_ATTR_MAX = 11,
};

enum {
	CTRL_CMD_UNSPEC = 0,
	CTRL_CMD_NEWFAMILY = 1,
	CTRL_CMD_DELFAMILY = 2,
	CTRL_CMD_GETFAMILY = 3,
	CTRL_CMD_NEWOPS = 4,
	CTRL_CMD_DELOPS = 5,
	CTRL_CMD_GETOPS = 6,
	CTRL_CMD_NEWMCAST_GRP = 7,
	CTRL_CMD_DELMCAST_GRP = 8,
	CTRL_CMD_GETMCAST_GRP = 9,
	CTRL_CMD_GETPOLICY = 10,
	__CTRL_CMD_MAX = 11,
};

enum {
	DEVLINK_ATTR_STATS_RX_PACKETS = 0,
	DEVLINK_ATTR_STATS_RX_BYTES = 1,
	DEVLINK_ATTR_STATS_RX_DROPPED = 2,
	__DEVLINK_ATTR_STATS_MAX = 3,
	DEVLINK_ATTR_STATS_MAX = 2,
};

enum {
	DEVLINK_ATTR_TRAP_METADATA_TYPE_IN_PORT = 0,
	DEVLINK_ATTR_TRAP_METADATA_TYPE_FA_COOKIE = 1,
};

enum {
	DEV_ID = 0,
	PEER_DEV_ID = 1,
	PEER_CPORT_ID = 0,
	TRAFFIC_CLASS = 0,
};

enum {
	DIO_LOCKING = 1,
	DIO_SKIP_HOLES = 2,
};

enum {
	DIO_SHOULD_DIRTY = 1,
	DIO_IS_SYNC = 2,
};

enum {
	DIR_OFFSET_FIRST = 2,
	DIR_OFFSET_EOD = 2147483647,
};

enum {
	DIR_OFFSET_MIN = 3,
	DIR_OFFSET_MAX = 2147483646,
};

enum {
	DISCOVERED = 16,
	EXPLORED = 32,
	FALLTHROUGH = 1,
	BRANCH = 2,
};

enum {
	DISK_EVENT_FLAG_POLL = 1,
	DISK_EVENT_FLAG_UEVENT = 2,
	DISK_EVENT_FLAG_BLOCK_ON_EXCL_WRITE = 4,
};

enum {
	DISK_EVENT_MEDIA_CHANGE = 1,
	DISK_EVENT_EJECT_REQUEST = 2,
};

enum {
	DMA_TX_ERR_BASE = 0,
	DMA_RX_ERR_BASE = 256,
	TRANS_TX_FAIL_BASE = 512,
	TRANS_RX_FAIL_BASE = 768,
	DMA_TX_DIF_CRC_ERR = 0,
	DMA_TX_DIF_APP_ERR = 1,
	DMA_TX_DIF_RPP_ERR = 2,
	DMA_TX_AXI_BUS_ERR = 3,
	DMA_TX_DATA_SGL_OVERFLOW_ERR = 4,
	DMA_TX_DIF_SGL_OVERFLOW_ERR = 5,
	DMA_TX_UNEXP_XFER_RDY_ERR = 6,
	DMA_TX_XFER_RDY_OFFSET_ERR = 7,
	DMA_TX_DATA_UNDERFLOW_ERR = 8,
	DMA_TX_XFER_RDY_LENGTH_OVERFLOW_ERR = 9,
	DMA_RX_BUFFER_ECC_ERR = 256,
	DMA_RX_DIF_CRC_ERR = 257,
	DMA_RX_DIF_APP_ERR = 258,
	DMA_RX_DIF_RPP_ERR = 259,
	DMA_RX_RESP_BUFFER_OVERFLOW_ERR = 260,
	DMA_RX_AXI_BUS_ERR = 261,
	DMA_RX_DATA_SGL_OVERFLOW_ERR = 262,
	DMA_RX_DIF_SGL_OVERFLOW_ERR = 263,
	DMA_RX_DATA_OFFSET_ERR = 264,
	DMA_RX_UNEXP_RX_DATA_ERR = 265,
	DMA_RX_DATA_OVERFLOW_ERR = 266,
	DMA_RX_DATA_UNDERFLOW_ERR = 267,
	DMA_RX_UNEXP_RETRANS_RESP_ERR = 268,
	TRANS_TX_RSVD0_ERR = 512,
	TRANS_TX_PHY_NOT_ENABLE_ERR = 513,
	TRANS_TX_OPEN_REJCT_WRONG_DEST_ERR = 514,
	TRANS_TX_OPEN_REJCT_ZONE_VIOLATION_ERR = 515,
	TRANS_TX_OPEN_REJCT_BY_OTHER_ERR = 516,
	TRANS_TX_RSVD1_ERR = 517,
	TRANS_TX_OPEN_REJCT_AIP_TIMEOUT_ERR = 518,
	TRANS_TX_OPEN_REJCT_STP_BUSY_ERR = 519,
	TRANS_TX_OPEN_REJCT_PROTOCOL_NOT_SUPPORT_ERR = 520,
	TRANS_TX_OPEN_REJCT_RATE_NOT_SUPPORT_ERR = 521,
	TRANS_TX_OPEN_REJCT_BAD_DEST_ERR = 522,
	TRANS_TX_OPEN_BREAK_RECEIVE_ERR = 523,
	TRANS_TX_LOW_PHY_POWER_ERR = 524,
	TRANS_TX_OPEN_REJCT_PATHWAY_BLOCKED_ERR = 525,
	TRANS_TX_OPEN_TIMEOUT_ERR = 526,
	TRANS_TX_OPEN_REJCT_NO_DEST_ERR = 527,
	TRANS_TX_OPEN_RETRY_ERR = 528,
	TRANS_TX_RSVD2_ERR = 529,
	TRANS_TX_BREAK_TIMEOUT_ERR = 530,
	TRANS_TX_BREAK_REQUEST_ERR = 531,
	TRANS_TX_BREAK_RECEIVE_ERR = 532,
	TRANS_TX_CLOSE_TIMEOUT_ERR = 533,
	TRANS_TX_CLOSE_NORMAL_ERR = 534,
	TRANS_TX_CLOSE_PHYRESET_ERR = 535,
	TRANS_TX_WITH_CLOSE_DWS_TIMEOUT_ERR = 536,
	TRANS_TX_WITH_CLOSE_COMINIT_ERR = 537,
	TRANS_TX_NAK_RECEIVE_ERR = 538,
	TRANS_TX_ACK_NAK_TIMEOUT_ERR = 539,
	TRANS_TX_CREDIT_TIMEOUT_ERR = 540,
	TRANS_TX_IPTT_CONFLICT_ERR = 541,
	TRANS_TX_TXFRM_TYPE_ERR = 542,
	TRANS_TX_TXSMP_LENGTH_ERR = 543,
	TRANS_RX_FRAME_CRC_ERR = 768,
	TRANS_RX_FRAME_DONE_ERR = 769,
	TRANS_RX_FRAME_ERRPRM_ERR = 770,
	TRANS_RX_FRAME_NO_CREDIT_ERR = 771,
	TRANS_RX_RSVD0_ERR = 772,
	TRANS_RX_FRAME_OVERRUN_ERR = 773,
	TRANS_RX_FRAME_NO_EOF_ERR = 774,
	TRANS_RX_LINK_BUF_OVERRUN_ERR = 775,
	TRANS_RX_BREAK_TIMEOUT_ERR = 776,
	TRANS_RX_BREAK_REQUEST_ERR = 777,
	TRANS_RX_BREAK_RECEIVE_ERR = 778,
	TRANS_RX_CLOSE_TIMEOUT_ERR = 779,
	TRANS_RX_CLOSE_NORMAL_ERR = 780,
	TRANS_RX_CLOSE_PHYRESET_ERR = 781,
	TRANS_RX_WITH_CLOSE_DWS_TIMEOUT_ERR = 782,
	TRANS_RX_WITH_CLOSE_COMINIT_ERR = 783,
	TRANS_RX_DATA_LENGTH0_ERR = 784,
	TRANS_RX_BAD_HASH_ERR = 785,
	TRANS_RX_XRDY_ZERO_ERR = 786,
	TRANS_RX_SSP_FRAME_LEN_ERR = 787,
	TRANS_RX_TRANS_RX_RSVD1_ERR = 788,
	TRANS_RX_NO_BALANCE_ERR = 789,
	TRANS_RX_TRANS_RX_RSVD2_ERR = 790,
	TRANS_RX_TRANS_RX_RSVD3_ERR = 791,
	TRANS_RX_BAD_FRAME_TYPE_ERR = 792,
	TRANS_RX_SMP_FRAME_LEN_ERR = 793,
	TRANS_RX_SMP_RESP_TIMEOUT_ERR = 794,
};

enum {
	DONE_EXPLORING = 0,
	KEEP_EXPLORING = 1,
};

enum {
	DOWN = 0,
	UP = 1,
};

enum {
	DP83867_PORT_MIRROING_KEEP = 0,
	DP83867_PORT_MIRROING_EN = 1,
	DP83867_PORT_MIRROING_DIS = 2,
};

enum {
	DPT_START = 2,
	DPT_STOP = 1,
};

enum {
	DQF_INFO_DIRTY_B = 17,
};

enum {
	DQF_ROOT_SQUASH_B = 0,
	DQF_SYS_FILE_B = 16,
	DQF_PRIVATE = 17,
};

enum {
	DQST_LOOKUPS = 0,
	DQST_DROPS = 1,
	DQST_READS = 2,
	DQST_WRITES = 3,
	DQST_CACHE_HITS = 4,
	DQST_ALLOC_DQUOTS = 5,
	DQST_FREE_DQUOTS = 6,
	DQST_SYNCS = 7,
	_DQST_DQSTAT_LAST = 8,
};

enum {
	DSM_FUNC_ERR_HANDLE_MSI = 0,
};

enum {
	DSPI_REGMAP = 0,
	S32G_DSPI_REGMAP = 1,
	DSPI_XSPI_REGMAP = 2,
	S32G_DSPI_XSPI_REGMAP = 3,
	DSPI_PUSHR = 4,
};

enum {
	DUMP_PREFIX_NONE = 0,
	DUMP_PREFIX_ADDRESS = 1,
	DUMP_PREFIX_OFFSET = 2,
};

enum {
	EC_MSG_TX_HEADER_BYTES = 3,
	EC_MSG_TX_TRAILER_BYTES = 1,
	EC_MSG_TX_PROTO_BYTES = 4,
	EC_MSG_RX_PROTO_BYTES = 3,
	EC_PROTO2_MSG_BYTES = 256,
	EC_MAX_MSG_BYTES = 65536,
};

enum {
	EDSR = 0,
	EDMR = 1,
	EDTRR = 2,
	EDRRR = 3,
	EESR = 4,
	EESIPR = 5,
	TDLAR = 6,
	TDFAR = 7,
	TDFXR = 8,
	TDFFR = 9,
	RDLAR = 10,
	RDFAR = 11,
	RDFXR = 12,
	RDFFR = 13,
	TRSCER = 14,
	RMFCR = 15,
	TFTR = 16,
	FDR = 17,
	RMCR = 18,
	EDOCR = 19,
	TFUCR = 20,
	RFOCR = 21,
	RMIIMODE = 22,
	FCFTR = 23,
	RPADIR = 24,
	TRIMD = 25,
	RBWAR = 26,
	TBRAR = 27,
	ECMR = 28,
	ECSR = 29,
	ECSIPR = 30,
	PIR = 31,
	PSR = 32,
	RDMLR = 33,
	PIPR = 34,
	RFLR = 35,
	IPGR = 36,
	APR = 37,
	MPR = 38,
	PFTCR = 39,
	PFRCR = 40,
	RFCR = 41,
	RFCF = 42,
	TPAUSER = 43,
	TPAUSECR = 44,
	BCFR = 45,
	BCFRR = 46,
	GECMR = 47,
	BCULR = 48,
	MAHR = 49,
	MALR = 50,
	TROCR = 51,
	CDCR = 52,
	LCCR = 53,
	CNDCR = 54,
	CEFCR = 55,
	FRECR = 56,
	TSFRCR = 57,
	TLFRCR = 58,
	CERCR = 59,
	CEECR = 60,
	MAFCR = 61,
	RTRATE = 62,
	CSMR = 63,
	RMII_MII = 64,
	ARSTR = 65,
	TSU_CTRST = 66,
	TSU_FWEN0 = 67,
	TSU_FWEN1 = 68,
	TSU_FCM = 69,
	TSU_BSYSL0 = 70,
	TSU_BSYSL1 = 71,
	TSU_PRISL0 = 72,
	TSU_PRISL1 = 73,
	TSU_FWSL0 = 74,
	TSU_FWSL1 = 75,
	TSU_FWSLC = 76,
	TSU_QTAG0 = 77,
	TSU_QTAG1 = 78,
	TSU_QTAGM0 = 79,
	TSU_QTAGM1 = 80,
	TSU_FWSR = 81,
	TSU_FWINMK = 82,
	TSU_ADQT0 = 83,
	TSU_ADQT1 = 84,
	TSU_VTAG0 = 85,
	TSU_VTAG1 = 86,
	TSU_ADSBSY = 87,
	TSU_TEN = 88,
	TSU_POST1 = 89,
	TSU_POST2 = 90,
	TSU_POST3 = 91,
	TSU_POST4 = 92,
	TSU_ADRH0 = 93,
	TXNLCR0 = 94,
	TXALCR0 = 95,
	RXNLCR0 = 96,
	RXALCR0 = 97,
	FWNLCR0 = 98,
	FWALCR0 = 99,
	TXNLCR1 = 100,
	TXALCR1 = 101,
	RXNLCR1 = 102,
	RXALCR1 = 103,
	FWNLCR1 = 104,
	FWALCR1 = 105,
	SH_ETH_MAX_REGISTER_OFFSET = 106,
};

enum {
	EPecma = 0,
	EPdec = 1,
	EPeq = 2,
	EPgt = 3,
	EPlt = 4,
};

enum {
	ERASE = 0,
	WERASE = 1,
	KILL = 2,
};

enum {
	ES_WRITTEN_B = 0,
	ES_UNWRITTEN_B = 1,
	ES_DELAYED_B = 2,
	ES_HOLE_B = 3,
	ES_REFERENCED_B = 4,
	ES_FLAGS = 5,
};

enum {
	ETHTOOL_A_BITSET_BITS_UNSPEC = 0,
	ETHTOOL_A_BITSET_BITS_BIT = 1,
	__ETHTOOL_A_BITSET_BITS_CNT = 2,
	ETHTOOL_A_BITSET_BITS_MAX = 1,
};

enum {
	ETHTOOL_A_BITSET_BIT_UNSPEC = 0,
	ETHTOOL_A_BITSET_BIT_INDEX = 1,
	ETHTOOL_A_BITSET_BIT_NAME = 2,
	ETHTOOL_A_BITSET_BIT_VALUE = 3,
	__ETHTOOL_A_BITSET_BIT_CNT = 4,
	ETHTOOL_A_BITSET_BIT_MAX = 3,
};

enum {
	ETHTOOL_A_BITSET_UNSPEC = 0,
	ETHTOOL_A_BITSET_NOMASK = 1,
	ETHTOOL_A_BITSET_SIZE = 2,
	ETHTOOL_A_BITSET_BITS = 3,
	ETHTOOL_A_BITSET_VALUE = 4,
	ETHTOOL_A_BITSET_MASK = 5,
	__ETHTOOL_A_BITSET_CNT = 6,
	ETHTOOL_A_BITSET_MAX = 5,
};

enum {
	ETHTOOL_A_C33_PSE_PW_LIMIT_UNSPEC = 0,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MIN = 1,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_CNT = 3,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC = 0,
	ETHTOOL_A_CABLE_AMPLITUDE_PAIR = 1,
	ETHTOOL_A_CABLE_AMPLITUDE_mV = 2,
	__ETHTOOL_A_CABLE_AMPLITUDE_CNT = 3,
	ETHTOOL_A_CABLE_AMPLITUDE_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC = 0,
	ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR = 1,
	ETHTOOL_A_CABLE_FAULT_LENGTH_CM = 2,
	ETHTOOL_A_CABLE_FAULT_LENGTH_SRC = 3,
	__ETHTOOL_A_CABLE_FAULT_LENGTH_CNT = 4,
	ETHTOOL_A_CABLE_FAULT_LENGTH_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_INF_SRC_UNSPEC = 0,
	ETHTOOL_A_CABLE_INF_SRC_TDR = 1,
	ETHTOOL_A_CABLE_INF_SRC_ALCD = 2,
};

enum {
	ETHTOOL_A_CABLE_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_NEST_RESULT = 1,
	ETHTOOL_A_CABLE_NEST_FAULT_LENGTH = 2,
	__ETHTOOL_A_CABLE_NEST_CNT = 3,
	ETHTOOL_A_CABLE_NEST_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_PAIR_A = 0,
	ETHTOOL_A_CABLE_PAIR_B = 1,
	ETHTOOL_A_CABLE_PAIR_C = 2,
	ETHTOOL_A_CABLE_PAIR_D = 3,
};

enum {
	ETHTOOL_A_CABLE_PULSE_UNSPEC = 0,
	ETHTOOL_A_CABLE_PULSE_mV = 1,
	__ETHTOOL_A_CABLE_PULSE_CNT = 2,
	ETHTOOL_A_CABLE_PULSE_MAX = 1,
};

enum {
	ETHTOOL_A_CABLE_RESULT_CODE_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_CODE_OK = 1,
	ETHTOOL_A_CABLE_RESULT_CODE_OPEN = 2,
	ETHTOOL_A_CABLE_RESULT_CODE_SAME_SHORT = 3,
	ETHTOOL_A_CABLE_RESULT_CODE_CROSS_SHORT = 4,
	ETHTOOL_A_CABLE_RESULT_CODE_IMPEDANCE_MISMATCH = 5,
	ETHTOOL_A_CABLE_RESULT_CODE_NOISE = 6,
	ETHTOOL_A_CABLE_RESULT_CODE_RESOLUTION_NOT_POSSIBLE = 7,
};

enum {
	ETHTOOL_A_CABLE_RESULT_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_PAIR = 1,
	ETHTOOL_A_CABLE_RESULT_CODE = 2,
	ETHTOOL_A_CABLE_RESULT_SRC = 3,
	__ETHTOOL_A_CABLE_RESULT_CNT = 4,
	ETHTOOL_A_CABLE_RESULT_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_STEP_UNSPEC = 0,
	ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE = 1,
	ETHTOOL_A_CABLE_STEP_LAST_DISTANCE = 2,
	ETHTOOL_A_CABLE_STEP_STEP_DISTANCE = 3,
	__ETHTOOL_A_CABLE_STEP_CNT = 4,
	ETHTOOL_A_CABLE_STEP_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TDR_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TDR_NEST_STEP = 1,
	ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE = 2,
	ETHTOOL_A_CABLE_TDR_NEST_PULSE = 3,
	__ETHTOOL_A_CABLE_TDR_NEST_CNT = 4,
	ETHTOOL_A_CABLE_TDR_NEST_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS = 2,
	ETHTOOL_A_CABLE_TEST_NTF_NEST = 3,
	__ETHTOOL_A_CABLE_TEST_NTF_CNT = 4,
	ETHTOOL_A_CABLE_TEST_NTF_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST = 2,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP = 3,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR = 4,
	__ETHTOOL_A_CABLE_TEST_TDR_CFG_CNT = 5,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX = 4,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG = 2,
	__ETHTOOL_A_CABLE_TEST_TDR_CNT = 3,
	ETHTOOL_A_CABLE_TEST_TDR_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_HEADER = 1,
	__ETHTOOL_A_CABLE_TEST_CNT = 2,
	ETHTOOL_A_CABLE_TEST_MAX = 1,
};

enum {
	ETHTOOL_A_CHANNELS_UNSPEC = 0,
	ETHTOOL_A_CHANNELS_HEADER = 1,
	ETHTOOL_A_CHANNELS_RX_MAX = 2,
	ETHTOOL_A_CHANNELS_TX_MAX = 3,
	ETHTOOL_A_CHANNELS_OTHER_MAX = 4,
	ETHTOOL_A_CHANNELS_COMBINED_MAX = 5,
	ETHTOOL_A_CHANNELS_RX_COUNT = 6,
	ETHTOOL_A_CHANNELS_TX_COUNT = 7,
	ETHTOOL_A_CHANNELS_OTHER_COUNT = 8,
	ETHTOOL_A_CHANNELS_COMBINED_COUNT = 9,
	__ETHTOOL_A_CHANNELS_CNT = 10,
	ETHTOOL_A_CHANNELS_MAX = 9,
};

enum {
	ETHTOOL_A_COALESCE_UNSPEC = 0,
	ETHTOOL_A_COALESCE_HEADER = 1,
	ETHTOOL_A_COALESCE_RX_USECS = 2,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES = 3,
	ETHTOOL_A_COALESCE_RX_USECS_IRQ = 4,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ = 5,
	ETHTOOL_A_COALESCE_TX_USECS = 6,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES = 7,
	ETHTOOL_A_COALESCE_TX_USECS_IRQ = 8,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ = 9,
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS = 10,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX = 11,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX = 12,
	ETHTOOL_A_COALESCE_PKT_RATE_LOW = 13,
	ETHTOOL_A_COALESCE_RX_USECS_LOW = 14,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW = 15,
	ETHTOOL_A_COALESCE_TX_USECS_LOW = 16,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW = 17,
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH = 18,
	ETHTOOL_A_COALESCE_RX_USECS_HIGH = 19,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH = 20,
	ETHTOOL_A_COALESCE_TX_USECS_HIGH = 21,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH = 22,
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL = 23,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX = 24,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX = 25,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_BYTES = 26,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_FRAMES = 27,
	ETHTOOL_A_COALESCE_TX_AGGR_TIME_USECS = 28,
	ETHTOOL_A_COALESCE_RX_PROFILE = 29,
	ETHTOOL_A_COALESCE_TX_PROFILE = 30,
	__ETHTOOL_A_COALESCE_CNT = 31,
	ETHTOOL_A_COALESCE_MAX = 30,
};

enum {
	ETHTOOL_A_DEBUG_UNSPEC = 0,
	ETHTOOL_A_DEBUG_HEADER = 1,
	ETHTOOL_A_DEBUG_MSGMASK = 2,
	__ETHTOOL_A_DEBUG_CNT = 3,
	ETHTOOL_A_DEBUG_MAX = 2,
};

enum {
	ETHTOOL_A_EEE_UNSPEC = 0,
	ETHTOOL_A_EEE_HEADER = 1,
	ETHTOOL_A_EEE_MODES_OURS = 2,
	ETHTOOL_A_EEE_MODES_PEER = 3,
	ETHTOOL_A_EEE_ACTIVE = 4,
	ETHTOOL_A_EEE_ENABLED = 5,
	ETHTOOL_A_EEE_TX_LPI_ENABLED = 6,
	ETHTOOL_A_EEE_TX_LPI_TIMER = 7,
	__ETHTOOL_A_EEE_CNT = 8,
	ETHTOOL_A_EEE_MAX = 7,
};

enum {
	ETHTOOL_A_FEATURES_UNSPEC = 0,
	ETHTOOL_A_FEATURES_HEADER = 1,
	ETHTOOL_A_FEATURES_HW = 2,
	ETHTOOL_A_FEATURES_WANTED = 3,
	ETHTOOL_A_FEATURES_ACTIVE = 4,
	ETHTOOL_A_FEATURES_NOCHANGE = 5,
	__ETHTOOL_A_FEATURES_CNT = 6,
	ETHTOOL_A_FEATURES_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_HIST_PAD = 1,
	ETHTOOL_A_FEC_HIST_BIN_LOW = 2,
	ETHTOOL_A_FEC_HIST_BIN_HIGH = 3,
	ETHTOOL_A_FEC_HIST_BIN_VAL = 4,
	ETHTOOL_A_FEC_HIST_BIN_VAL_PER_LANE = 5,
	__ETHTOOL_A_FEC_HIST_CNT = 6,
	ETHTOOL_A_FEC_HIST_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_STAT_UNSPEC = 0,
	ETHTOOL_A_FEC_STAT_PAD = 1,
	ETHTOOL_A_FEC_STAT_CORRECTED = 2,
	ETHTOOL_A_FEC_STAT_UNCORR = 3,
	ETHTOOL_A_FEC_STAT_CORR_BITS = 4,
	ETHTOOL_A_FEC_STAT_HIST = 5,
	__ETHTOOL_A_FEC_STAT_CNT = 6,
	ETHTOOL_A_FEC_STAT_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_UNSPEC = 0,
	ETHTOOL_A_FEC_HEADER = 1,
	ETHTOOL_A_FEC_MODES = 2,
	ETHTOOL_A_FEC_AUTO = 3,
	ETHTOOL_A_FEC_ACTIVE = 4,
	ETHTOOL_A_FEC_STATS = 5,
	__ETHTOOL_A_FEC_CNT = 6,
	ETHTOOL_A_FEC_MAX = 5,
};

enum {
	ETHTOOL_A_FLOW_ETHER = 1,
	ETHTOOL_A_FLOW_IP4 = 2,
	ETHTOOL_A_FLOW_IP6 = 3,
	ETHTOOL_A_FLOW_TCP4 = 4,
	ETHTOOL_A_FLOW_TCP6 = 5,
	ETHTOOL_A_FLOW_UDP4 = 6,
	ETHTOOL_A_FLOW_UDP6 = 7,
	ETHTOOL_A_FLOW_SCTP4 = 8,
	ETHTOOL_A_FLOW_SCTP6 = 9,
	ETHTOOL_A_FLOW_AH4 = 10,
	ETHTOOL_A_FLOW_AH6 = 11,
	ETHTOOL_A_FLOW_ESP4 = 12,
	ETHTOOL_A_FLOW_ESP6 = 13,
	ETHTOOL_A_FLOW_AH_ESP4 = 14,
	ETHTOOL_A_FLOW_AH_ESP6 = 15,
	ETHTOOL_A_FLOW_GTPU4 = 16,
	ETHTOOL_A_FLOW_GTPU6 = 17,
	ETHTOOL_A_FLOW_GTPC4 = 18,
	ETHTOOL_A_FLOW_GTPC6 = 19,
	ETHTOOL_A_FLOW_GTPC_TEID4 = 20,
	ETHTOOL_A_FLOW_GTPC_TEID6 = 21,
	ETHTOOL_A_FLOW_GTPU_EH4 = 22,
	ETHTOOL_A_FLOW_GTPU_EH6 = 23,
	ETHTOOL_A_FLOW_GTPU_UL4 = 24,
	ETHTOOL_A_FLOW_GTPU_UL6 = 25,
	ETHTOOL_A_FLOW_GTPU_DL4 = 26,
	ETHTOOL_A_FLOW_GTPU_DL6 = 27,
	__ETHTOOL_A_FLOW_CNT = 28,
	ETHTOOL_A_FLOW_MAX = 27,
};

enum {
	ETHTOOL_A_HEADER_UNSPEC = 0,
	ETHTOOL_A_HEADER_DEV_INDEX = 1,
	ETHTOOL_A_HEADER_DEV_NAME = 2,
	ETHTOOL_A_HEADER_FLAGS = 3,
	ETHTOOL_A_HEADER_PHY_INDEX = 4,
	__ETHTOOL_A_HEADER_CNT = 5,
	ETHTOOL_A_HEADER_MAX = 4,
};

enum {
	ETHTOOL_A_IRQ_MODERATION_UNSPEC = 0,
	ETHTOOL_A_IRQ_MODERATION_USEC = 1,
	ETHTOOL_A_IRQ_MODERATION_PKTS = 2,
	ETHTOOL_A_IRQ_MODERATION_COMPS = 3,
	__ETHTOOL_A_IRQ_MODERATION_CNT = 4,
	ETHTOOL_A_IRQ_MODERATION_MAX = 3,
};

enum {
	ETHTOOL_A_LINKINFO_UNSPEC = 0,
	ETHTOOL_A_LINKINFO_HEADER = 1,
	ETHTOOL_A_LINKINFO_PORT = 2,
	ETHTOOL_A_LINKINFO_PHYADDR = 3,
	ETHTOOL_A_LINKINFO_TP_MDIX = 4,
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL = 5,
	ETHTOOL_A_LINKINFO_TRANSCEIVER = 6,
	__ETHTOOL_A_LINKINFO_CNT = 7,
	ETHTOOL_A_LINKINFO_MAX = 6,
};

enum {
	ETHTOOL_A_LINKMODES_UNSPEC = 0,
	ETHTOOL_A_LINKMODES_HEADER = 1,
	ETHTOOL_A_LINKMODES_AUTONEG = 2,
	ETHTOOL_A_LINKMODES_OURS = 3,
	ETHTOOL_A_LINKMODES_PEER = 4,
	ETHTOOL_A_LINKMODES_SPEED = 5,
	ETHTOOL_A_LINKMODES_DUPLEX = 6,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG = 7,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE = 8,
	ETHTOOL_A_LINKMODES_LANES = 9,
	ETHTOOL_A_LINKMODES_RATE_MATCHING = 10,
	__ETHTOOL_A_LINKMODES_CNT = 11,
	ETHTOOL_A_LINKMODES_MAX = 10,
};

enum {
	ETHTOOL_A_LINKSTATE_UNSPEC = 0,
	ETHTOOL_A_LINKSTATE_HEADER = 1,
	ETHTOOL_A_LINKSTATE_LINK = 2,
	ETHTOOL_A_LINKSTATE_SQI = 3,
	ETHTOOL_A_LINKSTATE_SQI_MAX = 4,
	ETHTOOL_A_LINKSTATE_EXT_STATE = 5,
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE = 6,
	ETHTOOL_A_LINKSTATE_EXT_DOWN_CNT = 7,
	__ETHTOOL_A_LINKSTATE_CNT = 8,
	ETHTOOL_A_LINKSTATE_MAX = 7,
};

enum {
	ETHTOOL_A_MM_STAT_UNSPEC = 0,
	ETHTOOL_A_MM_STAT_PAD = 1,
	ETHTOOL_A_MM_STAT_REASSEMBLY_ERRORS = 2,
	ETHTOOL_A_MM_STAT_SMD_ERRORS = 3,
	ETHTOOL_A_MM_STAT_REASSEMBLY_OK = 4,
	ETHTOOL_A_MM_STAT_RX_FRAG_COUNT = 5,
	ETHTOOL_A_MM_STAT_TX_FRAG_COUNT = 6,
	ETHTOOL_A_MM_STAT_HOLD_COUNT = 7,
	__ETHTOOL_A_MM_STAT_CNT = 8,
	ETHTOOL_A_MM_STAT_MAX = 7,
};

enum {
	ETHTOOL_A_MM_UNSPEC = 0,
	ETHTOOL_A_MM_HEADER = 1,
	ETHTOOL_A_MM_PMAC_ENABLED = 2,
	ETHTOOL_A_MM_TX_ENABLED = 3,
	ETHTOOL_A_MM_TX_ACTIVE = 4,
	ETHTOOL_A_MM_TX_MIN_FRAG_SIZE = 5,
	ETHTOOL_A_MM_RX_MIN_FRAG_SIZE = 6,
	ETHTOOL_A_MM_VERIFY_ENABLED = 7,
	ETHTOOL_A_MM_VERIFY_STATUS = 8,
	ETHTOOL_A_MM_VERIFY_TIME = 9,
	ETHTOOL_A_MM_MAX_VERIFY_TIME = 10,
	ETHTOOL_A_MM_STATS = 11,
	__ETHTOOL_A_MM_CNT = 12,
	ETHTOOL_A_MM_MAX = 11,
};

enum {
	ETHTOOL_A_MODULE_EEPROM_UNSPEC = 0,
	ETHTOOL_A_MODULE_EEPROM_HEADER = 1,
	ETHTOOL_A_MODULE_EEPROM_OFFSET = 2,
	ETHTOOL_A_MODULE_EEPROM_LENGTH = 3,
	ETHTOOL_A_MODULE_EEPROM_PAGE = 4,
	ETHTOOL_A_MODULE_EEPROM_BANK = 5,
	ETHTOOL_A_MODULE_EEPROM_I2C_ADDRESS = 6,
	ETHTOOL_A_MODULE_EEPROM_DATA = 7,
	__ETHTOOL_A_MODULE_EEPROM_CNT = 8,
	ETHTOOL_A_MODULE_EEPROM_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_FW_FLASH_UNSPEC = 0,
	ETHTOOL_A_MODULE_FW_FLASH_HEADER = 1,
	ETHTOOL_A_MODULE_FW_FLASH_FILE_NAME = 2,
	ETHTOOL_A_MODULE_FW_FLASH_PASSWORD = 3,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS = 4,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS_MSG = 5,
	ETHTOOL_A_MODULE_FW_FLASH_DONE = 6,
	ETHTOOL_A_MODULE_FW_FLASH_TOTAL = 7,
	__ETHTOOL_A_MODULE_FW_FLASH_CNT = 8,
	ETHTOOL_A_MODULE_FW_FLASH_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_UNSPEC = 0,
	ETHTOOL_A_MODULE_HEADER = 1,
	ETHTOOL_A_MODULE_POWER_MODE_POLICY = 2,
	ETHTOOL_A_MODULE_POWER_MODE = 3,
	__ETHTOOL_A_MODULE_CNT = 4,
	ETHTOOL_A_MODULE_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_STAT_UNSPEC = 0,
	ETHTOOL_A_PAUSE_STAT_PAD = 1,
	ETHTOOL_A_PAUSE_STAT_TX_FRAMES = 2,
	ETHTOOL_A_PAUSE_STAT_RX_FRAMES = 3,
	__ETHTOOL_A_PAUSE_STAT_CNT = 4,
	ETHTOOL_A_PAUSE_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_UNSPEC = 0,
	ETHTOOL_A_PAUSE_HEADER = 1,
	ETHTOOL_A_PAUSE_AUTONEG = 2,
	ETHTOOL_A_PAUSE_RX = 3,
	ETHTOOL_A_PAUSE_TX = 4,
	ETHTOOL_A_PAUSE_STATS = 5,
	ETHTOOL_A_PAUSE_STATS_SRC = 6,
	__ETHTOOL_A_PAUSE_CNT = 7,
	ETHTOOL_A_PAUSE_MAX = 6,
};

enum {
	ETHTOOL_A_PHC_VCLOCKS_UNSPEC = 0,
	ETHTOOL_A_PHC_VCLOCKS_HEADER = 1,
	ETHTOOL_A_PHC_VCLOCKS_NUM = 2,
	ETHTOOL_A_PHC_VCLOCKS_INDEX = 3,
	__ETHTOOL_A_PHC_VCLOCKS_CNT = 4,
	ETHTOOL_A_PHC_VCLOCKS_MAX = 3,
};

enum {
	ETHTOOL_A_PHY_UNSPEC = 0,
	ETHTOOL_A_PHY_HEADER = 1,
	ETHTOOL_A_PHY_INDEX = 2,
	ETHTOOL_A_PHY_DRVNAME = 3,
	ETHTOOL_A_PHY_NAME = 4,
	ETHTOOL_A_PHY_UPSTREAM_TYPE = 5,
	ETHTOOL_A_PHY_UPSTREAM_INDEX = 6,
	ETHTOOL_A_PHY_UPSTREAM_SFP_NAME = 7,
	ETHTOOL_A_PHY_DOWNSTREAM_SFP_NAME = 8,
	__ETHTOOL_A_PHY_CNT = 9,
	ETHTOOL_A_PHY_MAX = 8,
};

enum {
	ETHTOOL_A_PLCA_UNSPEC = 0,
	ETHTOOL_A_PLCA_HEADER = 1,
	ETHTOOL_A_PLCA_VERSION = 2,
	ETHTOOL_A_PLCA_ENABLED = 3,
	ETHTOOL_A_PLCA_STATUS = 4,
	ETHTOOL_A_PLCA_NODE_CNT = 5,
	ETHTOOL_A_PLCA_NODE_ID = 6,
	ETHTOOL_A_PLCA_TO_TMR = 7,
	ETHTOOL_A_PLCA_BURST_CNT = 8,
	ETHTOOL_A_PLCA_BURST_TMR = 9,
	__ETHTOOL_A_PLCA_CNT = 10,
	ETHTOOL_A_PLCA_MAX = 9,
};

enum {
	ETHTOOL_A_PRIVFLAGS_UNSPEC = 0,
	ETHTOOL_A_PRIVFLAGS_HEADER = 1,
	ETHTOOL_A_PRIVFLAGS_FLAGS = 2,
	__ETHTOOL_A_PRIVFLAGS_CNT = 3,
	ETHTOOL_A_PRIVFLAGS_MAX = 2,
};

enum {
	ETHTOOL_A_PROFILE_UNSPEC = 0,
	ETHTOOL_A_PROFILE_IRQ_MODERATION = 1,
	__ETHTOOL_A_PROFILE_CNT = 2,
	ETHTOOL_A_PROFILE_MAX = 1,
};

enum {
	ETHTOOL_A_PSE_NTF_HEADER = 1,
	ETHTOOL_A_PSE_NTF_EVENTS = 2,
	__ETHTOOL_A_PSE_NTF_CNT = 3,
	ETHTOOL_A_PSE_NTF_MAX = 2,
};

enum {
	ETHTOOL_A_PSE_UNSPEC = 0,
	ETHTOOL_A_PSE_HEADER = 1,
	ETHTOOL_A_PODL_PSE_ADMIN_STATE = 2,
	ETHTOOL_A_PODL_PSE_ADMIN_CONTROL = 3,
	ETHTOOL_A_PODL_PSE_PW_D_STATUS = 4,
	ETHTOOL_A_C33_PSE_ADMIN_STATE = 5,
	ETHTOOL_A_C33_PSE_ADMIN_CONTROL = 6,
	ETHTOOL_A_C33_PSE_PW_D_STATUS = 7,
	ETHTOOL_A_C33_PSE_PW_CLASS = 8,
	ETHTOOL_A_C33_PSE_ACTUAL_PW = 9,
	ETHTOOL_A_C33_PSE_EXT_STATE = 10,
	ETHTOOL_A_C33_PSE_EXT_SUBSTATE = 11,
	ETHTOOL_A_C33_PSE_AVAIL_PW_LIMIT = 12,
	ETHTOOL_A_C33_PSE_PW_LIMIT_RANGES = 13,
	ETHTOOL_A_PSE_PW_D_ID = 14,
	ETHTOOL_A_PSE_PRIO_MAX = 15,
	ETHTOOL_A_PSE_PRIO = 16,
	__ETHTOOL_A_PSE_CNT = 17,
	ETHTOOL_A_PSE_MAX = 16,
};

enum {
	ETHTOOL_A_RINGS_UNSPEC = 0,
	ETHTOOL_A_RINGS_HEADER = 1,
	ETHTOOL_A_RINGS_RX_MAX = 2,
	ETHTOOL_A_RINGS_RX_MINI_MAX = 3,
	ETHTOOL_A_RINGS_RX_JUMBO_MAX = 4,
	ETHTOOL_A_RINGS_TX_MAX = 5,
	ETHTOOL_A_RINGS_RX = 6,
	ETHTOOL_A_RINGS_RX_MINI = 7,
	ETHTOOL_A_RINGS_RX_JUMBO = 8,
	ETHTOOL_A_RINGS_TX = 9,
	ETHTOOL_A_RINGS_RX_BUF_LEN = 10,
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT = 11,
	ETHTOOL_A_RINGS_CQE_SIZE = 12,
	ETHTOOL_A_RINGS_TX_PUSH = 13,
	ETHTOOL_A_RINGS_RX_PUSH = 14,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN = 15,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN_MAX = 16,
	ETHTOOL_A_RINGS_HDS_THRESH = 17,
	ETHTOOL_A_RINGS_HDS_THRESH_MAX = 18,
	__ETHTOOL_A_RINGS_CNT = 19,
	ETHTOOL_A_RINGS_MAX = 18,
};

enum {
	ETHTOOL_A_RSS_UNSPEC = 0,
	ETHTOOL_A_RSS_HEADER = 1,
	ETHTOOL_A_RSS_CONTEXT = 2,
	ETHTOOL_A_RSS_HFUNC = 3,
	ETHTOOL_A_RSS_INDIR = 4,
	ETHTOOL_A_RSS_HKEY = 5,
	ETHTOOL_A_RSS_INPUT_XFRM = 6,
	ETHTOOL_A_RSS_START_CONTEXT = 7,
	ETHTOOL_A_RSS_FLOW_HASH = 8,
	__ETHTOOL_A_RSS_CNT = 9,
	ETHTOOL_A_RSS_MAX = 8,
};

enum {
	ETHTOOL_A_STATS_ETH_CTRL_3_TX = 0,
	ETHTOOL_A_STATS_ETH_CTRL_4_RX = 1,
	ETHTOOL_A_STATS_ETH_CTRL_5_RX_UNSUP = 2,
	__ETHTOOL_A_STATS_ETH_CTRL_CNT = 3,
	ETHTOOL_A_STATS_ETH_CTRL_MAX = 2,
};

enum {
	ETHTOOL_A_STATS_ETH_MAC_2_TX_PKT = 0,
	ETHTOOL_A_STATS_ETH_MAC_3_SINGLE_COL = 1,
	ETHTOOL_A_STATS_ETH_MAC_4_MULTI_COL = 2,
	ETHTOOL_A_STATS_ETH_MAC_5_RX_PKT = 3,
	ETHTOOL_A_STATS_ETH_MAC_6_FCS_ERR = 4,
	ETHTOOL_A_STATS_ETH_MAC_7_ALIGN_ERR = 5,
	ETHTOOL_A_STATS_ETH_MAC_8_TX_BYTES = 6,
	ETHTOOL_A_STATS_ETH_MAC_9_TX_DEFER = 7,
	ETHTOOL_A_STATS_ETH_MAC_10_LATE_COL = 8,
	ETHTOOL_A_STATS_ETH_MAC_11_XS_COL = 9,
	ETHTOOL_A_STATS_ETH_MAC_12_TX_INT_ERR = 10,
	ETHTOOL_A_STATS_ETH_MAC_13_CS_ERR = 11,
	ETHTOOL_A_STATS_ETH_MAC_14_RX_BYTES = 12,
	ETHTOOL_A_STATS_ETH_MAC_15_RX_INT_ERR = 13,
	ETHTOOL_A_STATS_ETH_MAC_18_TX_MCAST = 14,
	ETHTOOL_A_STATS_ETH_MAC_19_TX_BCAST = 15,
	ETHTOOL_A_STATS_ETH_MAC_20_XS_DEFER = 16,
	ETHTOOL_A_STATS_ETH_MAC_21_RX_MCAST = 17,
	ETHTOOL_A_STATS_ETH_MAC_22_RX_BCAST = 18,
	ETHTOOL_A_STATS_ETH_MAC_23_IR_LEN_ERR = 19,
	ETHTOOL_A_STATS_ETH_MAC_24_OOR_LEN = 20,
	ETHTOOL_A_STATS_ETH_MAC_25_TOO_LONG_ERR = 21,
	__ETHTOOL_A_STATS_ETH_MAC_CNT = 22,
	ETHTOOL_A_STATS_ETH_MAC_MAX = 21,
};

enum {
	ETHTOOL_A_STATS_ETH_PHY_5_SYM_ERR = 0,
	__ETHTOOL_A_STATS_ETH_PHY_CNT = 1,
	ETHTOOL_A_STATS_ETH_PHY_MAX = 0,
};

enum {
	ETHTOOL_A_STATS_GRP_UNSPEC = 0,
	ETHTOOL_A_STATS_GRP_PAD = 1,
	ETHTOOL_A_STATS_GRP_ID = 2,
	ETHTOOL_A_STATS_GRP_SS_ID = 3,
	ETHTOOL_A_STATS_GRP_STAT = 4,
	ETHTOOL_A_STATS_GRP_HIST_RX = 5,
	ETHTOOL_A_STATS_GRP_HIST_TX = 6,
	ETHTOOL_A_STATS_GRP_HIST_BKT_LOW = 7,
	ETHTOOL_A_STATS_GRP_HIST_BKT_HI = 8,
	ETHTOOL_A_STATS_GRP_HIST_VAL = 9,
	__ETHTOOL_A_STATS_GRP_CNT = 10,
	ETHTOOL_A_STATS_GRP_MAX = 9,
};

enum {
	ETHTOOL_A_STATS_PHY_RX_PKTS = 0,
	ETHTOOL_A_STATS_PHY_RX_BYTES = 1,
	ETHTOOL_A_STATS_PHY_RX_ERRORS = 2,
	ETHTOOL_A_STATS_PHY_TX_PKTS = 3,
	ETHTOOL_A_STATS_PHY_TX_BYTES = 4,
	ETHTOOL_A_STATS_PHY_TX_ERRORS = 5,
	__ETHTOOL_A_STATS_PHY_CNT = 6,
	ETHTOOL_A_STATS_PHY_MAX = 5,
};

enum {
	ETHTOOL_A_STATS_RMON_UNDERSIZE = 0,
	ETHTOOL_A_STATS_RMON_OVERSIZE = 1,
	ETHTOOL_A_STATS_RMON_FRAG = 2,
	ETHTOOL_A_STATS_RMON_JABBER = 3,
	__ETHTOOL_A_STATS_RMON_CNT = 4,
	ETHTOOL_A_STATS_RMON_MAX = 3,
};

enum {
	ETHTOOL_A_STATS_UNSPEC = 0,
	ETHTOOL_A_STATS_PAD = 1,
	ETHTOOL_A_STATS_HEADER = 2,
	ETHTOOL_A_STATS_GROUPS = 3,
	ETHTOOL_A_STATS_GRP = 4,
	ETHTOOL_A_STATS_SRC = 5,
	__ETHTOOL_A_STATS_CNT = 6,
	ETHTOOL_A_STATS_MAX = 5,
};

enum {
	ETHTOOL_A_STRINGSETS_UNSPEC = 0,
	ETHTOOL_A_STRINGSETS_STRINGSET = 1,
	__ETHTOOL_A_STRINGSETS_CNT = 2,
	ETHTOOL_A_STRINGSETS_MAX = 1,
};

enum {
	ETHTOOL_A_STRINGSET_UNSPEC = 0,
	ETHTOOL_A_STRINGSET_ID = 1,
	ETHTOOL_A_STRINGSET_COUNT = 2,
	ETHTOOL_A_STRINGSET_STRINGS = 3,
	__ETHTOOL_A_STRINGSET_CNT = 4,
	ETHTOOL_A_STRINGSET_MAX = 3,
};

enum {
	ETHTOOL_A_STRINGS_UNSPEC = 0,
	ETHTOOL_A_STRINGS_STRING = 1,
	__ETHTOOL_A_STRINGS_CNT = 2,
	ETHTOOL_A_STRINGS_MAX = 1,
};

enum {
	ETHTOOL_A_STRING_UNSPEC = 0,
	ETHTOOL_A_STRING_INDEX = 1,
	ETHTOOL_A_STRING_VALUE = 2,
	__ETHTOOL_A_STRING_CNT = 3,
	ETHTOOL_A_STRING_MAX = 2,
};

enum {
	ETHTOOL_A_STRSET_UNSPEC = 0,
	ETHTOOL_A_STRSET_HEADER = 1,
	ETHTOOL_A_STRSET_STRINGSETS = 2,
	ETHTOOL_A_STRSET_COUNTS_ONLY = 3,
	__ETHTOOL_A_STRSET_CNT = 4,
	ETHTOOL_A_STRSET_MAX = 3,
};

enum {
	ETHTOOL_A_TSCONFIG_UNSPEC = 0,
	ETHTOOL_A_TSCONFIG_HEADER = 1,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_PROVIDER = 2,
	ETHTOOL_A_TSCONFIG_TX_TYPES = 3,
	ETHTOOL_A_TSCONFIG_RX_FILTERS = 4,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_FLAGS = 5,
	__ETHTOOL_A_TSCONFIG_CNT = 6,
	ETHTOOL_A_TSCONFIG_MAX = 5,
};

enum {
	ETHTOOL_A_TSINFO_UNSPEC = 0,
	ETHTOOL_A_TSINFO_HEADER = 1,
	ETHTOOL_A_TSINFO_TIMESTAMPING = 2,
	ETHTOOL_A_TSINFO_TX_TYPES = 3,
	ETHTOOL_A_TSINFO_RX_FILTERS = 4,
	ETHTOOL_A_TSINFO_PHC_INDEX = 5,
	ETHTOOL_A_TSINFO_STATS = 6,
	ETHTOOL_A_TSINFO_HWTSTAMP_PROVIDER = 7,
	ETHTOOL_A_TSINFO_HWTSTAMP_SOURCE = 8,
	ETHTOOL_A_TSINFO_HWTSTAMP_PHYINDEX = 9,
	__ETHTOOL_A_TSINFO_CNT = 10,
	ETHTOOL_A_TSINFO_MAX = 9,
};

enum {
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_UNSPEC = 0,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_INDEX = 1,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_QUALIFIER = 2,
	__ETHTOOL_A_TS_HWTSTAMP_PROVIDER_CNT = 3,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_MAX = 2,
};

enum {
	ETHTOOL_A_TS_STAT_UNSPEC = 0,
	ETHTOOL_A_TS_STAT_TX_PKTS = 1,
	ETHTOOL_A_TS_STAT_TX_LOST = 2,
	ETHTOOL_A_TS_STAT_TX_ERR = 3,
	ETHTOOL_A_TS_STAT_TX_ONESTEP_PKTS_UNCONFIRMED = 4,
	__ETHTOOL_A_TS_STAT_CNT = 5,
	ETHTOOL_A_TS_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_TUNNEL_INFO_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_INFO_HEADER = 1,
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS = 2,
	__ETHTOOL_A_TUNNEL_INFO_CNT = 3,
	ETHTOOL_A_TUNNEL_INFO_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT = 1,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE = 2,
	__ETHTOOL_A_TUNNEL_UDP_ENTRY_CNT = 3,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE = 1,
	ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES = 2,
	ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY = 3,
	__ETHTOOL_A_TUNNEL_UDP_TABLE_CNT = 4,
	ETHTOOL_A_TUNNEL_UDP_TABLE_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE = 1,
	__ETHTOOL_A_TUNNEL_UDP_CNT = 2,
	ETHTOOL_A_TUNNEL_UDP_MAX = 1,
};

enum {
	ETHTOOL_A_WOL_UNSPEC = 0,
	ETHTOOL_A_WOL_HEADER = 1,
	ETHTOOL_A_WOL_MODES = 2,
	ETHTOOL_A_WOL_SOPASS = 3,
	__ETHTOOL_A_WOL_CNT = 4,
	ETHTOOL_A_WOL_MAX = 3,
};

enum {
	ETHTOOL_MSG_KERNEL_NONE = 0,
	ETHTOOL_MSG_STRSET_GET_REPLY = 1,
	ETHTOOL_MSG_LINKINFO_GET_REPLY = 2,
	ETHTOOL_MSG_LINKINFO_NTF = 3,
	ETHTOOL_MSG_LINKMODES_GET_REPLY = 4,
	ETHTOOL_MSG_LINKMODES_NTF = 5,
	ETHTOOL_MSG_LINKSTATE_GET_REPLY = 6,
	ETHTOOL_MSG_DEBUG_GET_REPLY = 7,
	ETHTOOL_MSG_DEBUG_NTF = 8,
	ETHTOOL_MSG_WOL_GET_REPLY = 9,
	ETHTOOL_MSG_WOL_NTF = 10,
	ETHTOOL_MSG_FEATURES_GET_REPLY = 11,
	ETHTOOL_MSG_FEATURES_SET_REPLY = 12,
	ETHTOOL_MSG_FEATURES_NTF = 13,
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY = 14,
	ETHTOOL_MSG_PRIVFLAGS_NTF = 15,
	ETHTOOL_MSG_RINGS_GET_REPLY = 16,
	ETHTOOL_MSG_RINGS_NTF = 17,
	ETHTOOL_MSG_CHANNELS_GET_REPLY = 18,
	ETHTOOL_MSG_CHANNELS_NTF = 19,
	ETHTOOL_MSG_COALESCE_GET_REPLY = 20,
	ETHTOOL_MSG_COALESCE_NTF = 21,
	ETHTOOL_MSG_PAUSE_GET_REPLY = 22,
	ETHTOOL_MSG_PAUSE_NTF = 23,
	ETHTOOL_MSG_EEE_GET_REPLY = 24,
	ETHTOOL_MSG_EEE_NTF = 25,
	ETHTOOL_MSG_TSINFO_GET_REPLY = 26,
	ETHTOOL_MSG_CABLE_TEST_NTF = 27,
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF = 28,
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY = 29,
	ETHTOOL_MSG_FEC_GET_REPLY = 30,
	ETHTOOL_MSG_FEC_NTF = 31,
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY = 32,
	ETHTOOL_MSG_STATS_GET_REPLY = 33,
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY = 34,
	ETHTOOL_MSG_MODULE_GET_REPLY = 35,
	ETHTOOL_MSG_MODULE_NTF = 36,
	ETHTOOL_MSG_PSE_GET_REPLY = 37,
	ETHTOOL_MSG_RSS_GET_REPLY = 38,
	ETHTOOL_MSG_PLCA_GET_CFG_REPLY = 39,
	ETHTOOL_MSG_PLCA_GET_STATUS_REPLY = 40,
	ETHTOOL_MSG_PLCA_NTF = 41,
	ETHTOOL_MSG_MM_GET_REPLY = 42,
	ETHTOOL_MSG_MM_NTF = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_NTF = 44,
	ETHTOOL_MSG_PHY_GET_REPLY = 45,
	ETHTOOL_MSG_PHY_NTF = 46,
	ETHTOOL_MSG_TSCONFIG_GET_REPLY = 47,
	ETHTOOL_MSG_TSCONFIG_SET_REPLY = 48,
	ETHTOOL_MSG_PSE_NTF = 49,
	ETHTOOL_MSG_RSS_NTF = 50,
	ETHTOOL_MSG_RSS_CREATE_ACT_REPLY = 51,
	ETHTOOL_MSG_RSS_CREATE_NTF = 52,
	ETHTOOL_MSG_RSS_DELETE_NTF = 53,
	__ETHTOOL_MSG_KERNEL_CNT = 54,
	ETHTOOL_MSG_KERNEL_MAX = 53,
};

enum {
	ETHTOOL_STATS_ETH_PHY = 0,
	ETHTOOL_STATS_ETH_MAC = 1,
	ETHTOOL_STATS_ETH_CTRL = 2,
	ETHTOOL_STATS_RMON = 3,
	ETHTOOL_STATS_PHY = 4,
	__ETHTOOL_STATS_CNT = 5,
};

enum {
	ETHTOOL_STAT_EEE_WAKEUP = 0,
	ETHTOOL_STAT_SKB_ALLOC_ERR = 1,
	ETHTOOL_STAT_REFILL_ERR = 2,
	ETHTOOL_XDP_REDIRECT = 3,
	ETHTOOL_XDP_PASS = 4,
	ETHTOOL_XDP_DROP = 5,
	ETHTOOL_XDP_TX = 6,
	ETHTOOL_XDP_TX_ERR = 7,
	ETHTOOL_XDP_XMIT = 8,
	ETHTOOL_XDP_XMIT_ERR = 9,
	ETHTOOL_MAX_STATS = 10,
};

enum {
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN = 0,
	ETHTOOL_UDP_TUNNEL_TYPE_GENEVE = 1,
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE = 2,
	__ETHTOOL_UDP_TUNNEL_TYPE_CNT = 3,
	ETHTOOL_UDP_TUNNEL_TYPE_MAX = 2,
};

enum {
	ETHTOOL_XDP_REDIRECT___2 = 0,
	ETHTOOL_XDP_PASS___2 = 1,
	ETHTOOL_XDP_DROP___2 = 2,
	ETHTOOL_XDP_TX___2 = 3,
	ETHTOOL_XDP_TX_ERR___2 = 4,
	ETHTOOL_XDP_XMIT___2 = 5,
	ETHTOOL_XDP_XMIT_ERR___2 = 6,
};

enum {
	ETH_RSS_HASH_TOP_BIT = 0,
	ETH_RSS_HASH_XOR_BIT = 1,
	ETH_RSS_HASH_CRC32_BIT = 2,
	ETH_RSS_HASH_FUNCS_COUNT = 3,
};

enum {
	EVENT_CMD_COMPLETE = 0,
	EVENT_XFER_COMPLETE = 1,
	EVENT_DATA_COMPLETE = 2,
	EVENT_DATA_ERROR = 3,
};

enum {
	EXT4_FC_REASON_XATTR = 0,
	EXT4_FC_REASON_CROSS_RENAME = 1,
	EXT4_FC_REASON_JOURNAL_FLAG_CHANGE = 2,
	EXT4_FC_REASON_NOMEM = 3,
	EXT4_FC_REASON_SWAP_BOOT = 4,
	EXT4_FC_REASON_RESIZE = 5,
	EXT4_FC_REASON_RENAME_DIR = 6,
	EXT4_FC_REASON_FALLOC_RANGE = 7,
	EXT4_FC_REASON_INODE_JOURNAL_DATA = 8,
	EXT4_FC_REASON_ENCRYPTED_FILENAME = 9,
	EXT4_FC_REASON_MAX = 10,
};

enum {
	EXT4_FC_STATUS_OK = 0,
	EXT4_FC_STATUS_INELIGIBLE = 1,
	EXT4_FC_STATUS_SKIPPED = 2,
	EXT4_FC_STATUS_FAILED = 3,
};

enum {
	EXT4_FLAGS_RESIZING = 0,
	EXT4_FLAGS_SHUTDOWN = 1,
	EXT4_FLAGS_BDEV_IS_DAX = 2,
	EXT4_FLAGS_EMERGENCY_RO = 3,
};

enum {
	EXT4_INODE_SECRM = 0,
	EXT4_INODE_UNRM = 1,
	EXT4_INODE_COMPR = 2,
	EXT4_INODE_SYNC = 3,
	EXT4_INODE_IMMUTABLE = 4,
	EXT4_INODE_APPEND = 5,
	EXT4_INODE_NODUMP = 6,
	EXT4_INODE_NOATIME = 7,
	EXT4_INODE_DIRTY = 8,
	EXT4_INODE_COMPRBLK = 9,
	EXT4_INODE_NOCOMPR = 10,
	EXT4_INODE_ENCRYPT = 11,
	EXT4_INODE_INDEX = 12,
	EXT4_INODE_IMAGIC = 13,
	EXT4_INODE_JOURNAL_DATA = 14,
	EXT4_INODE_NOTAIL = 15,
	EXT4_INODE_DIRSYNC = 16,
	EXT4_INODE_TOPDIR = 17,
	EXT4_INODE_HUGE_FILE = 18,
	EXT4_INODE_EXTENTS = 19,
	EXT4_INODE_VERITY = 20,
	EXT4_INODE_EA_INODE = 21,
	EXT4_INODE_DAX = 25,
	EXT4_INODE_INLINE_DATA = 28,
	EXT4_INODE_PROJINHERIT = 29,
	EXT4_INODE_CASEFOLD = 30,
	EXT4_INODE_RESERVED = 31,
};

enum {
	EXT4_MF_MNTDIR_SAMPLED = 0,
	EXT4_MF_FC_INELIGIBLE = 1,
	EXT4_MF_JOURNAL_DESTROY = 2,
};

enum {
	EXT4_STATE_NEW = 0,
	EXT4_STATE_XATTR = 1,
	EXT4_STATE_NO_EXPAND = 2,
	EXT4_STATE_DA_ALLOC_CLOSE = 3,
	EXT4_STATE_EXT_MIGRATE = 4,
	EXT4_STATE_NEWENTRY = 5,
	EXT4_STATE_MAY_INLINE_DATA = 6,
	EXT4_STATE_EXT_PRECACHED = 7,
	EXT4_STATE_LUSTRE_EA_INODE = 8,
	EXT4_STATE_VERITY_IN_PROGRESS = 9,
	EXT4_STATE_FC_COMMITTING = 10,
	EXT4_STATE_FC_FLUSHING_DATA = 11,
	EXT4_STATE_ORPHAN_FILE = 12,
};

enum {
	FAN53526_CHIP_ID_01 = 1,
};

enum {
	FAN53526_CHIP_REV_08 = 8,
};

enum {
	FAN53555_CHIP_ID_00 = 0,
	FAN53555_CHIP_ID_01 = 1,
	FAN53555_CHIP_ID_02 = 2,
	FAN53555_CHIP_ID_03 = 3,
	FAN53555_CHIP_ID_04 = 4,
	FAN53555_CHIP_ID_05 = 5,
	FAN53555_CHIP_ID_08 = 8,
};

enum {
	FAN53555_CHIP_REV_00 = 3,
	FAN53555_CHIP_REV_13 = 15,
};

enum {
	FAN53555_VSEL_ID_0 = 0,
	FAN53555_VSEL_ID_1 = 1,
};

enum {
	FAN_EVENT_INIT = 0,
	FAN_EVENT_REPORTED = 1,
	FAN_EVENT_ANSWERED = 2,
	FAN_EVENT_CANCELED = 3,
};

enum {
	FATTR4_CLONE_BLKSIZE = 77,
	FATTR4_SPACE_FREED = 78,
	FATTR4_CHANGE_ATTR_TYPE = 79,
	FATTR4_SEC_LABEL = 80,
};

enum {
	FATTR4_DIR_NOTIF_DELAY = 56,
	FATTR4_DIRENT_NOTIF_DELAY = 57,
	FATTR4_DACL = 58,
	FATTR4_SACL = 59,
	FATTR4_CHANGE_POLICY = 60,
	FATTR4_FS_STATUS = 61,
	FATTR4_FS_LAYOUT_TYPES = 62,
	FATTR4_LAYOUT_HINT = 63,
	FATTR4_LAYOUT_TYPES = 64,
	FATTR4_LAYOUT_BLKSIZE = 65,
	FATTR4_LAYOUT_ALIGNMENT = 66,
	FATTR4_FS_LOCATIONS_INFO = 67,
	FATTR4_MDSTHRESHOLD = 68,
	FATTR4_RETENTION_GET = 69,
	FATTR4_RETENTION_SET = 70,
	FATTR4_RETENTEVT_GET = 71,
	FATTR4_RETENTEVT_SET = 72,
	FATTR4_RETENTION_HOLD = 73,
	FATTR4_MODE_SET_MASKED = 74,
	FATTR4_SUPPATTR_EXCLCREAT = 75,
	FATTR4_FS_CHARSET_CAP = 76,
};

enum {
	FATTR4_MODE_UMASK = 81,
};

enum {
	FATTR4_OPEN_ARGUMENTS = 86,
};

enum {
	FATTR4_SUPPORTED_ATTRS = 0,
	FATTR4_TYPE = 1,
	FATTR4_FH_EXPIRE_TYPE = 2,
	FATTR4_CHANGE = 3,
	FATTR4_SIZE = 4,
	FATTR4_LINK_SUPPORT = 5,
	FATTR4_SYMLINK_SUPPORT = 6,
	FATTR4_NAMED_ATTR = 7,
	FATTR4_FSID = 8,
	FATTR4_UNIQUE_HANDLES = 9,
	FATTR4_LEASE_TIME = 10,
	FATTR4_RDATTR_ERROR = 11,
	FATTR4_ACL = 12,
	FATTR4_ACLSUPPORT = 13,
	FATTR4_ARCHIVE = 14,
	FATTR4_CANSETTIME = 15,
	FATTR4_CASE_INSENSITIVE = 16,
	FATTR4_CASE_PRESERVING = 17,
	FATTR4_CHOWN_RESTRICTED = 18,
	FATTR4_FILEHANDLE = 19,
	FATTR4_FILEID = 20,
	FATTR4_FILES_AVAIL = 21,
	FATTR4_FILES_FREE = 22,
	FATTR4_FILES_TOTAL = 23,
	FATTR4_FS_LOCATIONS = 24,
	FATTR4_HIDDEN = 25,
	FATTR4_HOMOGENEOUS = 26,
	FATTR4_MAXFILESIZE = 27,
	FATTR4_MAXLINK = 28,
	FATTR4_MAXNAME = 29,
	FATTR4_MAXREAD = 30,
	FATTR4_MAXWRITE = 31,
	FATTR4_MIMETYPE = 32,
	FATTR4_MODE = 33,
	FATTR4_NO_TRUNC = 34,
	FATTR4_NUMLINKS = 35,
	FATTR4_OWNER = 36,
	FATTR4_OWNER_GROUP = 37,
	FATTR4_QUOTA_AVAIL_HARD = 38,
	FATTR4_QUOTA_AVAIL_SOFT = 39,
	FATTR4_QUOTA_USED = 40,
	FATTR4_RAWDEV = 41,
	FATTR4_SPACE_AVAIL = 42,
	FATTR4_SPACE_FREE = 43,
	FATTR4_SPACE_TOTAL = 44,
	FATTR4_SPACE_USED = 45,
	FATTR4_SYSTEM = 46,
	FATTR4_TIME_ACCESS = 47,
	FATTR4_TIME_ACCESS_SET = 48,
	FATTR4_TIME_BACKUP = 49,
	FATTR4_TIME_CREATE = 50,
	FATTR4_TIME_DELTA = 51,
	FATTR4_TIME_METADATA = 52,
	FATTR4_TIME_MODIFY = 53,
	FATTR4_TIME_MODIFY_SET = 54,
	FATTR4_MOUNTED_ON_FILEID = 55,
};

enum {
	FATTR4_TIME_DELEG_ACCESS = 84,
};

enum {
	FATTR4_TIME_DELEG_MODIFY = 85,
};

enum {
	FATTR4_XATTR_SUPPORT = 82,
};

enum {
	FBCON_LOGO_CANSHOW = -1,
	FBCON_LOGO_DRAW = -2,
	FBCON_LOGO_DONTSHOW = -3,
};

enum {
	FB_BLANK_UNBLANK = 0,
	FB_BLANK_NORMAL = 1,
	FB_BLANK_VSYNC_SUSPEND = 2,
	FB_BLANK_HSYNC_SUSPEND = 3,
	FB_BLANK_POWERDOWN = 4,
};

enum {
	FILEID_HIGH_OFF = 0,
	FILEID_LOW_OFF = 1,
	FILE_I_TYPE_OFF = 2,
	EMBED_FH_OFF = 3,
};

enum {
	FOLL_TOUCH = 65536,
	FOLL_TRIED = 131072,
	FOLL_REMOTE = 262144,
	FOLL_PIN = 524288,
	FOLL_FAST_ONLY = 1048576,
	FOLL_UNLOCKABLE = 2097152,
	FOLL_MADV_POPULATE = 4194304,
};

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

enum {
	FRACTION_DENOM = 128,
};

enum {
	FRA_UNSPEC = 0,
	FRA_DST = 1,
	FRA_SRC = 2,
	FRA_IIFNAME = 3,
	FRA_GOTO = 4,
	FRA_UNUSED2 = 5,
	FRA_PRIORITY = 6,
	FRA_UNUSED3 = 7,
	FRA_UNUSED4 = 8,
	FRA_UNUSED5 = 9,
	FRA_FWMARK = 10,
	FRA_FLOW = 11,
	FRA_TUN_ID = 12,
	FRA_SUPPRESS_IFGROUP = 13,
	FRA_SUPPRESS_PREFIXLEN = 14,
	FRA_TABLE = 15,
	FRA_FWMASK = 16,
	FRA_OIFNAME = 17,
	FRA_PAD = 18,
	FRA_L3MDEV = 19,
	FRA_UID_RANGE = 20,
	FRA_PROTOCOL = 21,
	FRA_IP_PROTO = 22,
	FRA_SPORT_RANGE = 23,
	FRA_DPORT_RANGE = 24,
	FRA_DSCP = 25,
	FRA_FLOWLABEL = 26,
	FRA_FLOWLABEL_MASK = 27,
	FRA_SPORT_MASK = 28,
	FRA_DPORT_MASK = 29,
	FRA_DSCP_MASK = 30,
	__FRA_MAX = 31,
};

enum {
	FR_ACT_UNSPEC = 0,
	FR_ACT_TO_TBL = 1,
	FR_ACT_GOTO = 2,
	FR_ACT_NOP = 3,
	FR_ACT_RES3 = 4,
	FR_ACT_RES4 = 5,
	FR_ACT_BLACKHOLE = 6,
	FR_ACT_UNREACHABLE = 7,
	FR_ACT_PROHIBIT = 8,
	__FR_ACT_MAX = 9,
};

enum {
	FR_PERCPU = 0,
	FR_ATOMIC = 1,
};

enum {
	FUSE_I_ADVISE_RDPLUS = 0,
	FUSE_I_INIT_RDPLUS = 1,
	FUSE_I_SIZE_UNSTABLE = 2,
	FUSE_I_BAD = 3,
	FUSE_I_BTIME = 4,
	FUSE_I_CACHE_IO_MODE = 5,
};

enum {
	FUTEX_STATE_OK = 0,
	FUTEX_STATE_EXITING = 1,
	FUTEX_STATE_DEAD = 2,
};

enum {
	F_TX_CHK_AUTO_OFF = -2147483648,
	F_TX_CHK_AUTO_ON = 1073741824,
	F_M_RX_RAM_DIS = 16777216,
};

enum {
	GENHD_FL_REMOVABLE = 1,
	GENHD_FL_HIDDEN = 2,
	GENHD_FL_NO_PART = 4,
};

enum {
	GHES_SEV_NO = 0,
	GHES_SEV_CORRECTED = 1,
	GHES_SEV_RECOVERABLE = 2,
	GHES_SEV_PANIC = 3,
};

enum {
	GLB_GPIO_CLK_DEB_ENA = -2147483648,
	GLB_GPIO_CLK_DBG_MSK = 1006632960,
	GLB_GPIO_INT_RST_D3_DIS = 32768,
	GLB_GPIO_LED_PAD_SPEED_UP = 16384,
	GLB_GPIO_STAT_RACE_DIS = 8192,
	GLB_GPIO_TEST_SEL_MSK = 6144,
	GLB_GPIO_TEST_SEL_BASE = 2048,
	GLB_GPIO_RAND_ENA = 1024,
	GLB_GPIO_RAND_BIT_1 = 512,
};

enum {
	GMAC_CTRL = 3840,
	GPHY_CTRL = 3844,
	GMAC_IRQ_SRC = 3848,
	GMAC_IRQ_MSK = 3852,
	GMAC_LINK_CTRL = 3856,
	WOL_CTRL_STAT = 3872,
	WOL_MATCH_CTL = 3874,
	WOL_MATCH_RES = 3875,
	WOL_MAC_ADDR = 3876,
	WOL_PATT_RPTR = 3884,
	WOL_PATT_LEN_LO = 3888,
	WOL_PATT_LEN_HI = 3892,
	WOL_PATT_CNT_0 = 3896,
	WOL_PATT_CNT_4 = 3900,
};

enum {
	GMAC_TI_ST_VAL = 3604,
	GMAC_TI_ST_CTRL = 3608,
	GMAC_TI_ST_TST = 3610,
};

enum {
	GMC_SET_RST = 32768,
	GMC_SEC_RST_OFF = 16384,
	GMC_BYP_MACSECRX_ON = 8192,
	GMC_BYP_MACSECRX_OFF = 4096,
	GMC_BYP_MACSECTX_ON = 2048,
	GMC_BYP_MACSECTX_OFF = 1024,
	GMC_BYP_RETR_ON = 512,
	GMC_BYP_RETR_OFF = 256,
	GMC_H_BURST_ON = 128,
	GMC_H_BURST_OFF = 64,
	GMC_F_LOOPB_ON = 32,
	GMC_F_LOOPB_OFF = 16,
	GMC_PAUSE_ON = 8,
	GMC_PAUSE_OFF = 4,
	GMC_RST_CLR = 2,
	GMC_RST_SET = 1,
};

enum {
	GMLC_RST_CLR = 2,
	GMLC_RST_SET = 1,
};

enum {
	GMR_FS_LEN = 2147418112,
	GMR_FS_VLAN = 8192,
	GMR_FS_JABBER = 4096,
	GMR_FS_UN_SIZE = 2048,
	GMR_FS_MC = 1024,
	GMR_FS_BC = 512,
	GMR_FS_RX_OK = 256,
	GMR_FS_GOOD_FC = 128,
	GMR_FS_BAD_FC = 64,
	GMR_FS_MII_ERR = 32,
	GMR_FS_LONG_ERR = 16,
	GMR_FS_FRAGMENT = 8,
	GMR_FS_CRC_ERR = 2,
	GMR_FS_RX_FF_OV = 1,
	GMR_FS_ANY_ERR = 6267,
};

enum {
	GMT_ST_START = 4,
	GMT_ST_STOP = 2,
	GMT_ST_CLR_IRQ = 1,
};

enum {
	GM_GPCR_PROM_ENA = 16384,
	GM_GPCR_FC_TX_DIS = 8192,
	GM_GPCR_TX_ENA = 4096,
	GM_GPCR_RX_ENA = 2048,
	GM_GPCR_BURST_ENA = 1024,
	GM_GPCR_LOOP_ENA = 512,
	GM_GPCR_PART_ENA = 256,
	GM_GPCR_GIGS_ENA = 128,
	GM_GPCR_FL_PASS = 64,
	GM_GPCR_DUP_FULL = 32,
	GM_GPCR_FC_RX_DIS = 16,
	GM_GPCR_SPEED_100 = 8,
	GM_GPCR_AU_DUP_DIS = 4,
	GM_GPCR_AU_FCT_DIS = 2,
	GM_GPCR_AU_SPD_DIS = 1,
};

enum {
	GM_GP_STAT = 0,
	GM_GP_CTRL = 4,
	GM_TX_CTRL = 8,
	GM_RX_CTRL = 12,
	GM_TX_FLOW_CTRL = 16,
	GM_TX_PARAM = 20,
	GM_SERIAL_MODE = 24,
	GM_SRC_ADDR_1L = 28,
	GM_SRC_ADDR_1M = 32,
	GM_SRC_ADDR_1H = 36,
	GM_SRC_ADDR_2L = 40,
	GM_SRC_ADDR_2M = 44,
	GM_SRC_ADDR_2H = 48,
	GM_MC_ADDR_H1 = 52,
	GM_MC_ADDR_H2 = 56,
	GM_MC_ADDR_H3 = 60,
	GM_MC_ADDR_H4 = 64,
	GM_TX_IRQ_SRC = 68,
	GM_RX_IRQ_SRC = 72,
	GM_TR_IRQ_SRC = 76,
	GM_TX_IRQ_MSK = 80,
	GM_RX_IRQ_MSK = 84,
	GM_TR_IRQ_MSK = 88,
	GM_SMI_CTRL = 128,
	GM_SMI_DATA = 132,
	GM_PHY_ADDR = 136,
	GM_MIB_CNT_BASE = 256,
	GM_MIB_CNT_END = 604,
};

enum {
	GM_IS_TX_CO_OV = 32,
	GM_IS_RX_CO_OV = 16,
	GM_IS_TX_FF_UR = 8,
	GM_IS_TX_COMPL = 4,
	GM_IS_RX_FF_OR = 2,
	GM_IS_RX_COMPL = 1,
};

enum {
	GM_PAR_MIB_CLR = 32,
	GM_PAR_MIB_TST = 16,
};

enum {
	GM_RXCR_UCF_ENA = 32768,
	GM_RXCR_MCF_ENA = 16384,
	GM_RXCR_CRC_DIS = 8192,
	GM_RXCR_PASS_FC = 4096,
};

enum {
	GM_RXF_UC_OK = 256,
	GM_RXF_BC_OK = 264,
	GM_RXF_MPAUSE = 272,
	GM_RXF_MC_OK = 280,
	GM_RXF_FCS_ERR = 288,
	GM_RXO_OK_LO = 304,
	GM_RXO_OK_HI = 312,
	GM_RXO_ERR_LO = 320,
	GM_RXO_ERR_HI = 328,
	GM_RXF_SHT = 336,
	GM_RXE_FRAG = 344,
	GM_RXF_64B = 352,
	GM_RXF_127B = 360,
	GM_RXF_255B = 368,
	GM_RXF_511B = 376,
	GM_RXF_1023B = 384,
	GM_RXF_1518B = 392,
	GM_RXF_MAX_SZ = 400,
	GM_RXF_LNG_ERR = 408,
	GM_RXF_JAB_PKT = 416,
	GM_RXE_FIFO_OV = 432,
	GM_TXF_UC_OK = 448,
	GM_TXF_BC_OK = 456,
	GM_TXF_MPAUSE = 464,
	GM_TXF_MC_OK = 472,
	GM_TXO_OK_LO = 480,
	GM_TXO_OK_HI = 488,
	GM_TXF_64B = 496,
	GM_TXF_127B = 504,
	GM_TXF_255B = 512,
	GM_TXF_511B = 520,
	GM_TXF_1023B = 528,
	GM_TXF_1518B = 536,
	GM_TXF_MAX_SZ = 544,
	GM_TXF_COL = 560,
	GM_TXF_LAT_COL = 568,
	GM_TXF_ABO_COL = 576,
	GM_TXF_MUL_COL = 584,
	GM_TXF_SNG_COL = 592,
	GM_TXE_FIFO_UR = 600,
};

enum {
	GM_SMI_CT_PHY_A_MSK = 63488,
	GM_SMI_CT_REG_A_MSK = 1984,
	GM_SMI_CT_OP_RD = 32,
	GM_SMI_CT_RD_VAL = 16,
	GM_SMI_CT_BUSY = 8,
};

enum {
	GM_SMOD_DATABL_MSK = 63488,
	GM_SMOD_LIMIT_4 = 1024,
	GM_SMOD_VLAN_ENA = 512,
	GM_SMOD_JUMBO_ENA = 256,
	GM_NEW_FLOW_CTRL = 64,
	GM_SMOD_IPG_MSK = 31,
};

enum {
	GM_TXCR_FORCE_JAM = 32768,
	GM_TXCR_CRC_DIS = 16384,
	GM_TXCR_PAD_DIS = 8192,
	GM_TXCR_COL_THR_MSK = 7168,
};

enum {
	GM_TXPA_JAMLEN_MSK = 49152,
	GM_TXPA_JAMIPG_MSK = 15872,
	GM_TXPA_JAMDAT_MSK = 496,
	GM_TXPA_BO_LIM_MSK = 15,
	TX_JAM_LEN_DEF = 3,
	TX_JAM_IPG_DEF = 11,
	TX_IPG_JAM_DEF = 28,
	TX_BOF_LIM_DEF = 4,
};

enum {
	GPC_TX_PAUSE = 1073741824,
	GPC_RX_PAUSE = 536870912,
	GPC_SPEED = 402653184,
	GPC_LINK = 67108864,
	GPC_DUPLEX = 33554432,
	GPC_CLOCK = 16777216,
	GPC_PDOWN = 8388608,
	GPC_TSTMODE = 4194304,
	GPC_REG18 = 2097152,
	GPC_REG12SEL = 1572864,
	GPC_REG18SEL = 393216,
	GPC_SPILOCK = 65536,
	GPC_LEDMUX = 49152,
	GPC_INTPOL = 8192,
	GPC_DETECT = 4096,
	GPC_1000HD = 2048,
	GPC_SLAVE = 1024,
	GPC_PAUSE = 512,
	GPC_LEDCTL = 192,
	GPC_RST_CLR = 2,
	GPC_RST_SET = 1,
};

enum {
	GP_IDLE = 0,
	GP_ENTER = 1,
	GP_PASSED = 2,
	GP_EXIT = 3,
	GP_REPLAY = 4,
};

enum {
	GP_LAST = 174,
	PIN_DCUTCK_LPDCLK = 175,
	PIN_DCUTDI_LPDI = 176,
	PIN_DCUTMS = 177,
	PIN_DCUTRST_N = 178,
	PIN_DU_DOTCLKIN = 179,
	PIN_EXTALR = 180,
	PIN_FSCLKST = 181,
	PIN_FSCLKST_N = 182,
	PIN_PRESETOUT_N = 183,
	PIN_VDDQ_AVB = 184,
	PIN_VDDQ_GE = 185,
};

enum {
	GP_LAST___2 = 209,
	PIN_ASEBRK = 210,
	PIN_AVB_MDC = 211,
	PIN_AVB_MDIO = 212,
	PIN_AVB_TD0 = 213,
	PIN_AVB_TD1 = 214,
	PIN_AVB_TD2 = 215,
	PIN_AVB_TD3 = 216,
	PIN_AVB_TXC = 217,
	PIN_AVB_TX_CTL = 218,
	PIN_FSCLKST_N___2 = 219,
	PIN_MLB_REF = 220,
	PIN_PRESETOUT_N___2 = 221,
	PIN_TCK = 222,
	PIN_TDI = 223,
	PIN_TMS = 224,
	PIN_TRST_N = 225,
	PIN_VDDQ_AVB0 = 226,
};

enum {
	GP_LAST___3 = 244,
	PIN_VDDQ_AVB0___2 = 245,
	PIN_VDDQ_AVB1 = 246,
	PIN_VDDQ_AVB2 = 247,
};

enum {
	GP_LAST___4 = 269,
	PIN_VDDQ_AVB0___3 = 270,
	PIN_VDDQ_AVB1___2 = 271,
	PIN_VDDQ_AVB2___2 = 272,
	PIN_VDDQ_TSN0 = 273,
};

enum {
	GP_LAST___5 = 205,
	PIN_DU_DOTCLKIN0 = 206,
	PIN_FSCLKST_N___3 = 207,
	PIN_MLB_REF___2 = 208,
	PIN_PRESETOUT_N___3 = 209,
	PIN_TCK___2 = 210,
	PIN_TDI___2 = 211,
	PIN_TMS___2 = 212,
	PIN_TRST_N___2 = 213,
	PIN_VDDQ_AVB0___4 = 214,
};

enum {
	GP_LAST___6 = 174,
	PIN_DU_DOTCLKIN___2 = 175,
	PIN_EXTALR___2 = 176,
	PIN_FSCLKST_N___4 = 177,
	PIN_PRESETOUT_N___4 = 178,
	PIN_TCK___3 = 179,
	PIN_TDI___3 = 180,
	PIN_TMS___3 = 181,
	PIN_TRST_N___3 = 182,
	PIN_VDDQ_AVB0___5 = 183,
};

enum {
	GSSX_NULL = 0,
	GSSX_INDICATE_MECHS = 1,
	GSSX_GET_CALL_CONTEXT = 2,
	GSSX_IMPORT_AND_CANON_NAME = 3,
	GSSX_EXPORT_CRED = 4,
	GSSX_IMPORT_CRED = 5,
	GSSX_ACQUIRE_CRED = 6,
	GSSX_STORE_CRED = 7,
	GSSX_INIT_SEC_CONTEXT = 8,
	GSSX_ACCEPT_SEC_CONTEXT = 9,
	GSSX_RELEASE_HANDLE = 10,
	GSSX_GET_MIC = 11,
	GSSX_VERIFY = 12,
	GSSX_WRAP = 13,
	GSSX_UNWRAP = 14,
	GSSX_WRAP_SIZE_LIMIT = 15,
};

enum {
	HANDSHAKE_A_ACCEPT_SOCKFD = 1,
	HANDSHAKE_A_ACCEPT_HANDLER_CLASS = 2,
	HANDSHAKE_A_ACCEPT_MESSAGE_TYPE = 3,
	HANDSHAKE_A_ACCEPT_TIMEOUT = 4,
	HANDSHAKE_A_ACCEPT_AUTH_MODE = 5,
	HANDSHAKE_A_ACCEPT_PEER_IDENTITY = 6,
	HANDSHAKE_A_ACCEPT_CERTIFICATE = 7,
	HANDSHAKE_A_ACCEPT_PEERNAME = 8,
	HANDSHAKE_A_ACCEPT_KEYRING = 9,
	__HANDSHAKE_A_ACCEPT_MAX = 10,
	HANDSHAKE_A_ACCEPT_MAX = 9,
};

enum {
	HANDSHAKE_A_DONE_STATUS = 1,
	HANDSHAKE_A_DONE_SOCKFD = 2,
	HANDSHAKE_A_DONE_REMOTE_AUTH = 3,
	__HANDSHAKE_A_DONE_MAX = 4,
	HANDSHAKE_A_DONE_MAX = 3,
};

enum {
	HANDSHAKE_A_X509_CERT = 1,
	HANDSHAKE_A_X509_PRIVKEY = 2,
	__HANDSHAKE_A_X509_MAX = 3,
	HANDSHAKE_A_X509_MAX = 2,
};

enum {
	HANDSHAKE_CMD_READY = 1,
	HANDSHAKE_CMD_ACCEPT = 2,
	HANDSHAKE_CMD_DONE = 3,
	__HANDSHAKE_CMD_MAX = 4,
	HANDSHAKE_CMD_MAX = 3,
};

enum {
	HASH_SIZE = 128,
};

enum {
	HASH_TCP_IPV6_EX_CTRL = 32,
	HASH_IPV6_EX_CTRL = 16,
	HASH_TCP_IPV6_CTRL = 8,
	HASH_IPV6_CTRL = 4,
	HASH_TCP_IPV4_CTRL = 2,
	HASH_IPV4_CTRL = 1,
	HASH_ALL = 63,
};

enum {
	HAS_READ = 1,
	HAS_WRITE = 2,
	HAS_LSEEK = 4,
	HAS_POLL = 8,
	HAS_IOCTL = 16,
};

enum {
	HCU_CCSR_SMBALERT_MONITOR = 134217728,
	HCU_CCSR_CPU_SLEEP = 67108864,
	HCU_CCSR_CS_TO = 33554432,
	HCU_CCSR_WDOG = 16777216,
	HCU_CCSR_CLR_IRQ_HOST = 131072,
	HCU_CCSR_SET_IRQ_HCU = 65536,
	HCU_CCSR_AHB_RST = 512,
	HCU_CCSR_CPU_RST_MODE = 256,
	HCU_CCSR_SET_SYNC_CPU = 32,
	HCU_CCSR_CPU_CLK_DIVIDE_MSK = 24,
	HCU_CCSR_CPU_CLK_DIVIDE_BASE = 8,
	HCU_CCSR_OS_PRSNT = 4,
	HCU_CCSR_UC_STATE_MSK = 3,
	HCU_CCSR_UC_STATE_BASE = 1,
	HCU_CCSR_ASF_RESET = 0,
	HCU_CCSR_ASF_HALTED = 2,
	HCU_CCSR_ASF_RUNNING = 1,
};

enum {
	HIBERNATION_INVALID = 0,
	HIBERNATION_PLATFORM = 1,
	HIBERNATION_SHUTDOWN = 2,
	HIBERNATION_REBOOT = 3,
	HIBERNATION_SUSPEND = 4,
	HIBERNATION_TEST_RESUME = 5,
	__HIBERNATION_AFTER_LAST = 6,
};

enum {
	HISI_SAS_BIST_CODE_MODE_PRBS7 = 0,
	HISI_SAS_BIST_CODE_MODE_PRBS23 = 1,
	HISI_SAS_BIST_CODE_MODE_PRBS31 = 2,
	HISI_SAS_BIST_CODE_MODE_JTPAT = 3,
	HISI_SAS_BIST_CODE_MODE_CJTPAT = 4,
	HISI_SAS_BIST_CODE_MODE_SCRAMBED_0 = 5,
	HISI_SAS_BIST_CODE_MODE_TRAIN = 6,
	HISI_SAS_BIST_CODE_MODE_TRAIN_DONE = 7,
	HISI_SAS_BIST_CODE_MODE_HFTP = 8,
	HISI_SAS_BIST_CODE_MODE_MFTP = 9,
	HISI_SAS_BIST_CODE_MODE_LFTP = 10,
	HISI_SAS_BIST_CODE_MODE_FIXED_DATA = 11,
};

enum {
	HISI_SAS_PHY_BCAST_ACK = 0,
	HISI_SAS_PHY_SL_PHY_ENABLED = 1,
	HISI_SAS_PHY_INT_ABNORMAL = 2,
	HISI_SAS_PHY_INT_NR = 3,
};

enum {
	HISI_SAS_PHY_PHY_UPDOWN = 0,
	HISI_SAS_PHY_CHNL_INT = 1,
	HISI_SAS_PHY_INT_NR___2 = 2,
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

enum {
	HTE_TS_REGISTERED = 0,
	HTE_TS_REQ = 1,
	HTE_TS_DISABLE = 2,
	HTE_TS_QUEUE_WK = 3,
};

enum {
	HUF_flags_bmi2 = 1,
	HUF_flags_optimalDepth = 2,
	HUF_flags_preferRepeat = 4,
	HUF_flags_suspectUncompressible = 8,
	HUF_flags_disableAsm = 16,
	HUF_flags_disableFast = 32,
};

enum {
	HUGETLB_SHMFS_INODE = 1,
	HUGETLB_ANONHUGE_INODE = 2,
};

enum {
	HW_BREAKPOINT_EMPTY = 0,
	HW_BREAKPOINT_R = 1,
	HW_BREAKPOINT_W = 2,
	HW_BREAKPOINT_RW = 3,
	HW_BREAKPOINT_X = 4,
	HW_BREAKPOINT_INVALID = 7,
};

enum {
	HW_BREAKPOINT_LEN_1 = 1,
	HW_BREAKPOINT_LEN_2 = 2,
	HW_BREAKPOINT_LEN_3 = 3,
	HW_BREAKPOINT_LEN_4 = 4,
	HW_BREAKPOINT_LEN_5 = 5,
	HW_BREAKPOINT_LEN_6 = 6,
	HW_BREAKPOINT_LEN_7 = 7,
	HW_BREAKPOINT_LEN_8 = 8,
};

enum {
	HW_OWNER = 128,
	OP_TCPWRITE = 17,
	OP_TCPSTART = 18,
	OP_TCPINIT = 20,
	OP_TCPLCK = 24,
	OP_TCPCHKSUM = 18,
	OP_TCPIS = 22,
	OP_TCPLW = 25,
	OP_TCPLSW = 27,
	OP_TCPLISW = 31,
	OP_ADDR64 = 33,
	OP_VLAN = 34,
	OP_ADDR64VLAN = 35,
	OP_LRGLEN = 36,
	OP_LRGLENVLAN = 38,
	OP_MSS = 40,
	OP_MSSVLAN = 42,
	OP_BUFFER = 64,
	OP_PACKET = 65,
	OP_LARGESEND = 67,
	OP_LSOV2 = 69,
	OP_RXSTAT = 96,
	OP_RXTIMESTAMP = 97,
	OP_RXVLAN = 98,
	OP_RXCHKS = 100,
	OP_RXCHKSVLAN = 102,
	OP_RXTIMEVLAN = 99,
	OP_RSS_HASH = 101,
	OP_TXINDEXLE = 104,
	OP_MACSEC = 108,
	OP_PUTIDX = 112,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICQ_EXITED = 4,
	ICQ_DESTROYED = 8,
};

enum {
	IDX_MODULE_ID = 0,
	IDX_ST_OPS_COMMON_VALUE_ID = 1,
};

enum {
	IFA_UNSPEC = 0,
	IFA_ADDRESS = 1,
	IFA_LOCAL = 2,
	IFA_LABEL = 3,
	IFA_BROADCAST = 4,
	IFA_ANYCAST = 5,
	IFA_CACHEINFO = 6,
	IFA_MULTICAST = 7,
	IFA_FLAGS = 8,
	IFA_RT_PRIORITY = 9,
	IFA_TARGET_NETNSID = 10,
	IFA_PROTO = 11,
	__IFA_MAX = 12,
};

enum {
	IFLA_BRIDGE_FLAGS = 0,
	IFLA_BRIDGE_MODE = 1,
	IFLA_BRIDGE_VLAN_INFO = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_INFO = 3,
	IFLA_BRIDGE_MRP = 4,
	IFLA_BRIDGE_CFM = 5,
	IFLA_BRIDGE_MST = 6,
	__IFLA_BRIDGE_MAX = 7,
};

enum {
	IFLA_BRPORT_UNSPEC = 0,
	IFLA_BRPORT_STATE = 1,
	IFLA_BRPORT_PRIORITY = 2,
	IFLA_BRPORT_COST = 3,
	IFLA_BRPORT_MODE = 4,
	IFLA_BRPORT_GUARD = 5,
	IFLA_BRPORT_PROTECT = 6,
	IFLA_BRPORT_FAST_LEAVE = 7,
	IFLA_BRPORT_LEARNING = 8,
	IFLA_BRPORT_UNICAST_FLOOD = 9,
	IFLA_BRPORT_PROXYARP = 10,
	IFLA_BRPORT_LEARNING_SYNC = 11,
	IFLA_BRPORT_PROXYARP_WIFI = 12,
	IFLA_BRPORT_ROOT_ID = 13,
	IFLA_BRPORT_BRIDGE_ID = 14,
	IFLA_BRPORT_DESIGNATED_PORT = 15,
	IFLA_BRPORT_DESIGNATED_COST = 16,
	IFLA_BRPORT_ID = 17,
	IFLA_BRPORT_NO = 18,
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK = 19,
	IFLA_BRPORT_CONFIG_PENDING = 20,
	IFLA_BRPORT_MESSAGE_AGE_TIMER = 21,
	IFLA_BRPORT_FORWARD_DELAY_TIMER = 22,
	IFLA_BRPORT_HOLD_TIMER = 23,
	IFLA_BRPORT_FLUSH = 24,
	IFLA_BRPORT_MULTICAST_ROUTER = 25,
	IFLA_BRPORT_PAD = 26,
	IFLA_BRPORT_MCAST_FLOOD = 27,
	IFLA_BRPORT_MCAST_TO_UCAST = 28,
	IFLA_BRPORT_VLAN_TUNNEL = 29,
	IFLA_BRPORT_BCAST_FLOOD = 30,
	IFLA_BRPORT_GROUP_FWD_MASK = 31,
	IFLA_BRPORT_NEIGH_SUPPRESS = 32,
	IFLA_BRPORT_ISOLATED = 33,
	IFLA_BRPORT_BACKUP_PORT = 34,
	IFLA_BRPORT_MRP_RING_OPEN = 35,
	IFLA_BRPORT_MRP_IN_OPEN = 36,
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT = 37,
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT = 38,
	IFLA_BRPORT_LOCKED = 39,
	IFLA_BRPORT_MAB = 40,
	IFLA_BRPORT_MCAST_N_GROUPS = 41,
	IFLA_BRPORT_MCAST_MAX_GROUPS = 42,
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS = 43,
	IFLA_BRPORT_BACKUP_NHID = 44,
	__IFLA_BRPORT_MAX = 45,
};

enum {
	IFLA_EVENT_NONE = 0,
	IFLA_EVENT_REBOOT = 1,
	IFLA_EVENT_FEATURES = 2,
	IFLA_EVENT_BONDING_FAILOVER = 3,
	IFLA_EVENT_NOTIFY_PEERS = 4,
	IFLA_EVENT_IGMP_RESEND = 5,
	IFLA_EVENT_BONDING_OPTIONS = 6,
};

enum {
	IFLA_INET_UNSPEC = 0,
	IFLA_INET_CONF = 1,
	__IFLA_INET_MAX = 2,
};

enum {
	IFLA_INFO_UNSPEC = 0,
	IFLA_INFO_KIND = 1,
	IFLA_INFO_DATA = 2,
	IFLA_INFO_XSTATS = 3,
	IFLA_INFO_SLAVE_KIND = 4,
	IFLA_INFO_SLAVE_DATA = 5,
	__IFLA_INFO_MAX = 6,
};

enum {
	IFLA_IPTUN_UNSPEC = 0,
	IFLA_IPTUN_LINK = 1,
	IFLA_IPTUN_LOCAL = 2,
	IFLA_IPTUN_REMOTE = 3,
	IFLA_IPTUN_TTL = 4,
	IFLA_IPTUN_TOS = 5,
	IFLA_IPTUN_ENCAP_LIMIT = 6,
	IFLA_IPTUN_FLOWINFO = 7,
	IFLA_IPTUN_FLAGS = 8,
	IFLA_IPTUN_PROTO = 9,
	IFLA_IPTUN_PMTUDISC = 10,
	IFLA_IPTUN_6RD_PREFIX = 11,
	IFLA_IPTUN_6RD_RELAY_PREFIX = 12,
	IFLA_IPTUN_6RD_PREFIXLEN = 13,
	IFLA_IPTUN_6RD_RELAY_PREFIXLEN = 14,
	IFLA_IPTUN_ENCAP_TYPE = 15,
	IFLA_IPTUN_ENCAP_FLAGS = 16,
	IFLA_IPTUN_ENCAP_SPORT = 17,
	IFLA_IPTUN_ENCAP_DPORT = 18,
	IFLA_IPTUN_COLLECT_METADATA = 19,
	IFLA_IPTUN_FWMARK = 20,
	__IFLA_IPTUN_MAX = 21,
};

enum {
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_REQUEST = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_USED = 2,
	__IFLA_OFFLOAD_XSTATS_HW_S_INFO_MAX = 3,
};

enum {
	IFLA_OFFLOAD_XSTATS_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_CPU_HIT = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO = 2,
	IFLA_OFFLOAD_XSTATS_L3_STATS = 3,
	__IFLA_OFFLOAD_XSTATS_MAX = 4,
};

enum {
	IFLA_PORT_UNSPEC = 0,
	IFLA_PORT_VF = 1,
	IFLA_PORT_PROFILE = 2,
	IFLA_PORT_VSI_TYPE = 3,
	IFLA_PORT_INSTANCE_UUID = 4,
	IFLA_PORT_HOST_UUID = 5,
	IFLA_PORT_REQUEST = 6,
	IFLA_PORT_RESPONSE = 7,
	__IFLA_PORT_MAX = 8,
};

enum {
	IFLA_PROTO_DOWN_REASON_UNSPEC = 0,
	IFLA_PROTO_DOWN_REASON_MASK = 1,
	IFLA_PROTO_DOWN_REASON_VALUE = 2,
	__IFLA_PROTO_DOWN_REASON_CNT = 3,
	IFLA_PROTO_DOWN_REASON_MAX = 2,
};

enum {
	IFLA_STATS_GETSET_UNSPEC = 0,
	IFLA_STATS_GET_FILTERS = 1,
	IFLA_STATS_SET_OFFLOAD_XSTATS_L3_STATS = 2,
	__IFLA_STATS_GETSET_MAX = 3,
};

enum {
	IFLA_STATS_UNSPEC = 0,
	IFLA_STATS_LINK_64 = 1,
	IFLA_STATS_LINK_XSTATS = 2,
	IFLA_STATS_LINK_XSTATS_SLAVE = 3,
	IFLA_STATS_LINK_OFFLOAD_XSTATS = 4,
	IFLA_STATS_AF_SPEC = 5,
	__IFLA_STATS_MAX = 6,
};

enum {
	IFLA_UNSPEC = 0,
	IFLA_ADDRESS = 1,
	IFLA_BROADCAST = 2,
	IFLA_IFNAME = 3,
	IFLA_MTU = 4,
	IFLA_LINK = 5,
	IFLA_QDISC = 6,
	IFLA_STATS = 7,
	IFLA_COST = 8,
	IFLA_PRIORITY = 9,
	IFLA_MASTER = 10,
	IFLA_WIRELESS = 11,
	IFLA_PROTINFO = 12,
	IFLA_TXQLEN = 13,
	IFLA_MAP = 14,
	IFLA_WEIGHT = 15,
	IFLA_OPERSTATE = 16,
	IFLA_LINKMODE = 17,
	IFLA_LINKINFO = 18,
	IFLA_NET_NS_PID = 19,
	IFLA_IFALIAS = 20,
	IFLA_NUM_VF = 21,
	IFLA_VFINFO_LIST = 22,
	IFLA_STATS64 = 23,
	IFLA_VF_PORTS = 24,
	IFLA_PORT_SELF = 25,
	IFLA_AF_SPEC = 26,
	IFLA_GROUP = 27,
	IFLA_NET_NS_FD = 28,
	IFLA_EXT_MASK = 29,
	IFLA_PROMISCUITY = 30,
	IFLA_NUM_TX_QUEUES = 31,
	IFLA_NUM_RX_QUEUES = 32,
	IFLA_CARRIER = 33,
	IFLA_PHYS_PORT_ID = 34,
	IFLA_CARRIER_CHANGES = 35,
	IFLA_PHYS_SWITCH_ID = 36,
	IFLA_LINK_NETNSID = 37,
	IFLA_PHYS_PORT_NAME = 38,
	IFLA_PROTO_DOWN = 39,
	IFLA_GSO_MAX_SEGS = 40,
	IFLA_GSO_MAX_SIZE = 41,
	IFLA_PAD = 42,
	IFLA_XDP = 43,
	IFLA_EVENT = 44,
	IFLA_NEW_NETNSID = 45,
	IFLA_IF_NETNSID = 46,
	IFLA_TARGET_NETNSID = 46,
	IFLA_CARRIER_UP_COUNT = 47,
	IFLA_CARRIER_DOWN_COUNT = 48,
	IFLA_NEW_IFINDEX = 49,
	IFLA_MIN_MTU = 50,
	IFLA_MAX_MTU = 51,
	IFLA_PROP_LIST = 52,
	IFLA_ALT_IFNAME = 53,
	IFLA_PERM_ADDRESS = 54,
	IFLA_PROTO_DOWN_REASON = 55,
	IFLA_PARENT_DEV_NAME = 56,
	IFLA_PARENT_DEV_BUS_NAME = 57,
	IFLA_GRO_MAX_SIZE = 58,
	IFLA_TSO_MAX_SIZE = 59,
	IFLA_TSO_MAX_SEGS = 60,
	IFLA_ALLMULTI = 61,
	IFLA_DEVLINK_PORT = 62,
	IFLA_GSO_IPV4_MAX_SIZE = 63,
	IFLA_GRO_IPV4_MAX_SIZE = 64,
	IFLA_DPLL_PIN = 65,
	IFLA_MAX_PACING_OFFLOAD_HORIZON = 66,
	IFLA_NETNS_IMMUTABLE = 67,
	IFLA_HEADROOM = 68,
	IFLA_TAILROOM = 69,
	__IFLA_MAX = 70,
};

enum {
	IFLA_VF_INFO_UNSPEC = 0,
	IFLA_VF_INFO = 1,
	__IFLA_VF_INFO_MAX = 2,
};

enum {
	IFLA_VF_LINK_STATE_AUTO = 0,
	IFLA_VF_LINK_STATE_ENABLE = 1,
	IFLA_VF_LINK_STATE_DISABLE = 2,
	__IFLA_VF_LINK_STATE_MAX = 3,
};

enum {
	IFLA_VF_PORT_UNSPEC = 0,
	IFLA_VF_PORT = 1,
	__IFLA_VF_PORT_MAX = 2,
};

enum {
	IFLA_VF_STATS_RX_PACKETS = 0,
	IFLA_VF_STATS_TX_PACKETS = 1,
	IFLA_VF_STATS_RX_BYTES = 2,
	IFLA_VF_STATS_TX_BYTES = 3,
	IFLA_VF_STATS_BROADCAST = 4,
	IFLA_VF_STATS_MULTICAST = 5,
	IFLA_VF_STATS_PAD = 6,
	IFLA_VF_STATS_RX_DROPPED = 7,
	IFLA_VF_STATS_TX_DROPPED = 8,
	__IFLA_VF_STATS_MAX = 9,
};

enum {
	IFLA_VF_UNSPEC = 0,
	IFLA_VF_MAC = 1,
	IFLA_VF_VLAN = 2,
	IFLA_VF_TX_RATE = 3,
	IFLA_VF_SPOOFCHK = 4,
	IFLA_VF_LINK_STATE = 5,
	IFLA_VF_RATE = 6,
	IFLA_VF_RSS_QUERY_EN = 7,
	IFLA_VF_STATS = 8,
	IFLA_VF_TRUST = 9,
	IFLA_VF_IB_NODE_GUID = 10,
	IFLA_VF_IB_PORT_GUID = 11,
	IFLA_VF_VLAN_LIST = 12,
	IFLA_VF_BROADCAST = 13,
	__IFLA_VF_MAX = 14,
};

enum {
	IFLA_VF_VLAN_INFO_UNSPEC = 0,
	IFLA_VF_VLAN_INFO = 1,
	__IFLA_VF_VLAN_INFO_MAX = 2,
};

enum {
	IFLA_XDP_UNSPEC = 0,
	IFLA_XDP_FD = 1,
	IFLA_XDP_ATTACHED = 2,
	IFLA_XDP_FLAGS = 3,
	IFLA_XDP_PROG_ID = 4,
	IFLA_XDP_DRV_PROG_ID = 5,
	IFLA_XDP_SKB_PROG_ID = 6,
	IFLA_XDP_HW_PROG_ID = 7,
	IFLA_XDP_EXPECTED_FD = 8,
	__IFLA_XDP_MAX = 9,
};

enum {
	IF_ACT_NONE = -1,
	IF_ACT_FILTER = 0,
	IF_ACT_START = 1,
	IF_ACT_STOP = 2,
	IF_SRC_FILE = 3,
	IF_SRC_KERNEL = 4,
	IF_SRC_FILEADDR = 5,
	IF_SRC_KERNELADDR = 6,
};

enum {
	IF_LINK_MODE_DEFAULT = 0,
	IF_LINK_MODE_DORMANT = 1,
	IF_LINK_MODE_TESTING = 2,
};

enum {
	IF_OPER_UNKNOWN = 0,
	IF_OPER_NOTPRESENT = 1,
	IF_OPER_DOWN = 2,
	IF_OPER_LOWERLAYERDOWN = 3,
	IF_OPER_TESTING = 4,
	IF_OPER_DORMANT = 5,
	IF_OPER_UP = 6,
};

enum {
	IF_STATE_ACTION = 0,
	IF_STATE_SOURCE = 1,
	IF_STATE_END = 2,
};

enum {
	INET_DIAG_BC_NOP = 0,
	INET_DIAG_BC_JMP = 1,
	INET_DIAG_BC_S_GE = 2,
	INET_DIAG_BC_S_LE = 3,
	INET_DIAG_BC_D_GE = 4,
	INET_DIAG_BC_D_LE = 5,
	INET_DIAG_BC_AUTO = 6,
	INET_DIAG_BC_S_COND = 7,
	INET_DIAG_BC_D_COND = 8,
	INET_DIAG_BC_DEV_COND = 9,
	INET_DIAG_BC_MARK_COND = 10,
	INET_DIAG_BC_S_EQ = 11,
	INET_DIAG_BC_D_EQ = 12,
	INET_DIAG_BC_CGROUP_COND = 13,
};

enum {
	INET_DIAG_NONE = 0,
	INET_DIAG_MEMINFO = 1,
	INET_DIAG_INFO = 2,
	INET_DIAG_VEGASINFO = 3,
	INET_DIAG_CONG = 4,
	INET_DIAG_TOS = 5,
	INET_DIAG_TCLASS = 6,
	INET_DIAG_SKMEMINFO = 7,
	INET_DIAG_SHUTDOWN = 8,
	INET_DIAG_DCTCPINFO = 9,
	INET_DIAG_PROTOCOL = 10,
	INET_DIAG_SKV6ONLY = 11,
	INET_DIAG_LOCALS = 12,
	INET_DIAG_PEERS = 13,
	INET_DIAG_PAD = 14,
	INET_DIAG_MARK = 15,
	INET_DIAG_BBRINFO = 16,
	INET_DIAG_CLASS_ID = 17,
	INET_DIAG_MD5SIG = 18,
	INET_DIAG_ULP_INFO = 19,
	INET_DIAG_SK_BPF_STORAGES = 20,
	INET_DIAG_CGROUP_ID = 21,
	INET_DIAG_SOCKOPT = 22,
	__INET_DIAG_MAX = 23,
};

enum {
	INET_DIAG_REQ_NONE = 0,
	INET_DIAG_REQ_BYTECODE = 1,
	INET_DIAG_REQ_SK_BPF_STORAGES = 2,
	INET_DIAG_REQ_PROTOCOL = 3,
	__INET_DIAG_REQ_MAX = 4,
};

enum {
	INET_ECN_NOT_ECT = 0,
	INET_ECN_ECT_1 = 1,
	INET_ECN_ECT_0 = 2,
	INET_ECN_CE = 3,
	INET_ECN_MASK = 3,
};

enum {
	INET_FLAGS_PKTINFO = 0,
	INET_FLAGS_TTL = 1,
	INET_FLAGS_TOS = 2,
	INET_FLAGS_RECVOPTS = 3,
	INET_FLAGS_RETOPTS = 4,
	INET_FLAGS_PASSSEC = 5,
	INET_FLAGS_ORIGDSTADDR = 6,
	INET_FLAGS_CHECKSUM = 7,
	INET_FLAGS_RECVFRAGSIZE = 8,
	INET_FLAGS_RECVERR = 9,
	INET_FLAGS_RECVERR_RFC4884 = 10,
	INET_FLAGS_FREEBIND = 11,
	INET_FLAGS_HDRINCL = 12,
	INET_FLAGS_MC_LOOP = 13,
	INET_FLAGS_MC_ALL = 14,
	INET_FLAGS_TRANSPARENT = 15,
	INET_FLAGS_IS_ICSK = 16,
	INET_FLAGS_NODEFRAG = 17,
	INET_FLAGS_BIND_ADDRESS_NO_PORT = 18,
	INET_FLAGS_DEFER_CONNECT = 19,
	INET_FLAGS_MC6_LOOP = 20,
	INET_FLAGS_RECVERR6_RFC4884 = 21,
	INET_FLAGS_MC6_ALL = 22,
	INET_FLAGS_AUTOFLOWLABEL_SET = 23,
	INET_FLAGS_AUTOFLOWLABEL = 24,
	INET_FLAGS_DONTFRAG = 25,
	INET_FLAGS_RECVERR6 = 26,
	INET_FLAGS_REPFLOW = 27,
	INET_FLAGS_RTALERT_ISOLATE = 28,
	INET_FLAGS_SNDFLOW = 29,
	INET_FLAGS_RTALERT = 30,
};

enum {
	INET_FRAG_FIRST_IN = 1,
	INET_FRAG_LAST_IN = 2,
	INET_FRAG_COMPLETE = 4,
	INET_FRAG_HASH_DEAD = 8,
	INET_FRAG_DROP = 16,
};

enum {
	INET_ULP_INFO_UNSPEC = 0,
	INET_ULP_INFO_NAME = 1,
	INET_ULP_INFO_TLS = 2,
	INET_ULP_INFO_MPTCP = 3,
	__INET_ULP_INFO_MAX = 4,
};

enum {
	INSN_F_FRAMENO_MASK = 7,
	INSN_F_SPI_MASK = 63,
	INSN_F_SPI_SHIFT = 3,
	INSN_F_STACK_ACCESS = 512,
	INSN_F_DST_REG_STACK = 1024,
	INSN_F_SRC_REG_STACK = 2048,
};

enum {
	INTERRUPT_MASK_ALL_VER_11 = 204799,
	INTERRUPT_MASK_ALL_VER_21 = 466943,
};

enum {
	IOBL_BUF_RING = 1,
	IOBL_INC = 2,
};

enum {
	IOCB_CMD_PREAD = 0,
	IOCB_CMD_PWRITE = 1,
	IOCB_CMD_FSYNC = 2,
	IOCB_CMD_FDSYNC = 3,
	IOCB_CMD_POLL = 5,
	IOCB_CMD_NOOP = 6,
	IOCB_CMD_PREADV = 7,
	IOCB_CMD_PWRITEV = 8,
};

enum {
	IOMMUFD_ACCESS_RW_READ = 0,
	IOMMUFD_ACCESS_RW_WRITE = 1,
	IOMMUFD_ACCESS_RW_KTHREAD = 2,
	__IOMMUFD_ACCESS_RW_SLOW_PATH = 4,
};

enum {
	IOMMU_PASID_ARRAY_DOMAIN = 0,
	IOMMU_PASID_ARRAY_HANDLE = 1,
};

enum {
	IOMMU_SET_DOMAIN_MUST_SUCCEED = 1,
};

enum {
	IOPRIO_CLASS_NONE = 0,
	IOPRIO_CLASS_RT = 1,
	IOPRIO_CLASS_BE = 2,
	IOPRIO_CLASS_IDLE = 3,
	IOPRIO_CLASS_INVALID = 7,
};

enum {
	IOPRIO_HINT_NONE = 0,
	IOPRIO_HINT_DEV_DURATION_LIMIT_1 = 1,
	IOPRIO_HINT_DEV_DURATION_LIMIT_2 = 2,
	IOPRIO_HINT_DEV_DURATION_LIMIT_3 = 3,
	IOPRIO_HINT_DEV_DURATION_LIMIT_4 = 4,
	IOPRIO_HINT_DEV_DURATION_LIMIT_5 = 5,
	IOPRIO_HINT_DEV_DURATION_LIMIT_6 = 6,
	IOPRIO_HINT_DEV_DURATION_LIMIT_7 = 7,
};

enum {
	IOPRIO_WHO_PROCESS = 1,
	IOPRIO_WHO_PGRP = 2,
	IOPRIO_WHO_USER = 3,
};

enum {
	IORES_DESC_NONE = 0,
	IORES_DESC_CRASH_KERNEL = 1,
	IORES_DESC_ACPI_TABLES = 2,
	IORES_DESC_ACPI_NV_STORAGE = 3,
	IORES_DESC_PERSISTENT_MEMORY = 4,
	IORES_DESC_PERSISTENT_MEMORY_LEGACY = 5,
	IORES_DESC_DEVICE_PRIVATE_MEMORY = 6,
	IORES_DESC_RESERVED = 7,
	IORES_DESC_SOFT_RESERVED = 8,
	IORES_DESC_CXL = 9,
};

enum {
	IORING_MEM_REGION_REG_WAIT_ARG = 1,
};

enum {
	IORING_MEM_REGION_TYPE_USER = 1,
};

enum {
	IORING_REGISTER_SRC_REGISTERED = 1,
	IORING_REGISTER_DST_REPLACE = 2,
};

enum {
	IORING_REG_WAIT_TS = 1,
};

enum {
	IORING_RSRC_FILE = 0,
	IORING_RSRC_BUFFER = 1,
};

enum {
	IOU_COMPLETE = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_RETRY = -11,
	IOU_REQUEUE = -3072,
};

enum {
	IOU_F_TWQ_LAZY_WAKE = 1,
};

enum {
	IOU_POLL_DONE = 0,
	IOU_POLL_NO_ACTION = 1,
	IOU_POLL_REMOVE_POLL_USE_RES = 2,
	IOU_POLL_REISSUE = 3,
	IOU_POLL_REQUEUE = 4,
};

enum {
	IO_ACCT_STALLED_BIT = 0,
};

enum {
	IO_APOLL_OK = 0,
	IO_APOLL_ABORTED = 1,
	IO_APOLL_READY = 2,
};

enum {
	IO_CHECK_CQ_OVERFLOW_BIT = 0,
	IO_CHECK_CQ_DROPPED_BIT = 1,
};

enum {
	IO_EVENTFD_OP_SIGNAL_BIT = 0,
};

enum {
	IO_IMU_DEST = 1,
	IO_IMU_SOURCE = 2,
};

enum {
	IO_REGION_F_VMAP = 1,
	IO_REGION_F_USER_PROVIDED = 2,
	IO_REGION_F_SINGLE_REF = 4,
};

enum {
	IO_SQ_THREAD_SHOULD_STOP = 0,
	IO_SQ_THREAD_SHOULD_PARK = 1,
};

enum {
	IO_URING_QUERY_OPCODES = 0,
	__IO_URING_QUERY_MAX = 1,
};

enum {
	IO_WORKER_F_UP = 0,
	IO_WORKER_F_RUNNING = 1,
	IO_WORKER_F_FREE = 2,
};

enum {
	IO_WQ_ACCT_BOUND = 0,
	IO_WQ_ACCT_UNBOUND = 1,
	IO_WQ_ACCT_NR = 2,
};

enum {
	IO_WQ_BIT_EXIT = 0,
};

enum {
	IO_WQ_WORK_CANCEL = 1,
	IO_WQ_WORK_HASHED = 2,
	IO_WQ_WORK_UNBOUND = 4,
	IO_WQ_WORK_CONCURRENT = 16,
	IO_WQ_HASH_SHIFT = 24,
};

enum {
	IP6_FH_F_FRAG = 1,
	IP6_FH_F_AUTH = 2,
	IP6_FH_F_SKIP_RH = 4,
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_AGGFRAG = 144,
	IPPROTO_RAW = 255,
	IPPROTO_SMC = 256,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_NOECTPKTS = 4,
	IPSTATS_MIB_ECT1PKTS = 5,
	IPSTATS_MIB_ECT0PKTS = 6,
	IPSTATS_MIB_CEPKTS = 7,
	IPSTATS_MIB_OUTREQUESTS = 8,
	IPSTATS_MIB_OUTPKTS = 9,
	IPSTATS_MIB_OUTOCTETS = 10,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 11,
	IPSTATS_MIB_INHDRERRORS = 12,
	IPSTATS_MIB_INTOOBIGERRORS = 13,
	IPSTATS_MIB_INNOROUTES = 14,
	IPSTATS_MIB_INADDRERRORS = 15,
	IPSTATS_MIB_INUNKNOWNPROTOS = 16,
	IPSTATS_MIB_INTRUNCATEDPKTS = 17,
	IPSTATS_MIB_INDISCARDS = 18,
	IPSTATS_MIB_OUTDISCARDS = 19,
	IPSTATS_MIB_OUTNOROUTES = 20,
	IPSTATS_MIB_REASMTIMEOUT = 21,
	IPSTATS_MIB_REASMREQDS = 22,
	IPSTATS_MIB_REASMOKS = 23,
	IPSTATS_MIB_REASMFAILS = 24,
	IPSTATS_MIB_FRAGOKS = 25,
	IPSTATS_MIB_FRAGFAILS = 26,
	IPSTATS_MIB_FRAGCREATES = 27,
	IPSTATS_MIB_INMCASTPKTS = 28,
	IPSTATS_MIB_OUTMCASTPKTS = 29,
	IPSTATS_MIB_INBCASTPKTS = 30,
	IPSTATS_MIB_OUTBCASTPKTS = 31,
	IPSTATS_MIB_INMCASTOCTETS = 32,
	IPSTATS_MIB_OUTMCASTOCTETS = 33,
	IPSTATS_MIB_INBCASTOCTETS = 34,
	IPSTATS_MIB_OUTBCASTOCTETS = 35,
	IPSTATS_MIB_CSUMERRORS = 36,
	IPSTATS_MIB_REASM_OVERLAPS = 37,
	__IPSTATS_MIB_MAX = 38,
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

enum {
	IP_TUNNEL_CSUM_BIT = 0,
	IP_TUNNEL_ROUTING_BIT = 1,
	IP_TUNNEL_KEY_BIT = 2,
	IP_TUNNEL_SEQ_BIT = 3,
	IP_TUNNEL_STRICT_BIT = 4,
	IP_TUNNEL_REC_BIT = 5,
	IP_TUNNEL_VERSION_BIT = 6,
	IP_TUNNEL_NO_KEY_BIT = 7,
	IP_TUNNEL_DONT_FRAGMENT_BIT = 8,
	IP_TUNNEL_OAM_BIT = 9,
	IP_TUNNEL_CRIT_OPT_BIT = 10,
	IP_TUNNEL_GENEVE_OPT_BIT = 11,
	IP_TUNNEL_VXLAN_OPT_BIT = 12,
	IP_TUNNEL_NOCACHE_BIT = 13,
	IP_TUNNEL_ERSPAN_OPT_BIT = 14,
	IP_TUNNEL_GTP_OPT_BIT = 15,
	IP_TUNNEL_VTI_BIT = 16,
	IP_TUNNEL_SIT_ISATAP_BIT = 16,
	IP_TUNNEL_PFCP_OPT_BIT = 17,
	__IP_TUNNEL_FLAG_NUM = 18,
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
	IRQCHIP_MOVE_DEFERRED = 4096,
};

enum {
	IRQC_IS_HARDIRQ = 0,
	IRQC_IS_NESTED = 1,
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_HANDLE_ENFORCE_IRQCTX = 134217728,
	IRQD_AFFINITY_ON_ACTIVATE = 268435456,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 536870912,
	IRQD_RESEND_WHEN_IN_PROGRESS = 1073741824,
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	IRQTF_RUNTHREAD = 0,
	IRQTF_WARNED = 1,
	IRQTF_AFFINITY = 2,
	IRQTF_FORCED_THREAD = 3,
	IRQTF_READY = 4,
};

enum {
	IRQ_DOMAIN_FLAG_HIERARCHY = 1,
	IRQ_DOMAIN_NAME_ALLOCATED = 2,
	IRQ_DOMAIN_FLAG_IPI_PER_CPU = 4,
	IRQ_DOMAIN_FLAG_IPI_SINGLE = 8,
	IRQ_DOMAIN_FLAG_MSI = 16,
	IRQ_DOMAIN_FLAG_ISOLATED_MSI = 32,
	IRQ_DOMAIN_FLAG_NO_MAP = 64,
	IRQ_DOMAIN_FLAG_MSI_PARENT = 256,
	IRQ_DOMAIN_FLAG_MSI_DEVICE = 512,
	IRQ_DOMAIN_FLAG_DESTROY_GC = 1024,
	IRQ_DOMAIN_FLAG_MSI_IMMUTABLE = 2048,
	IRQ_DOMAIN_FLAG_FWNODE_PARENT = 4096,
	IRQ_DOMAIN_FLAG_NONCORE = 65536,
};

enum {
	IRQ_POLL_F_SCHED = 0,
	IRQ_POLL_F_DISABLE = 1,
};

enum {
	IRQ_SET_MASK_OK = 0,
	IRQ_SET_MASK_OK_NOCOPY = 1,
	IRQ_SET_MASK_OK_DONE = 2,
};

enum {
	IRQ_STARTUP_NORMAL = 0,
	IRQ_STARTUP_MANAGED = 1,
	IRQ_STARTUP_ABORT = 2,
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	I_DATA_SEM_NORMAL = 0,
	I_DATA_SEM_OTHER = 1,
	I_DATA_SEM_QUOTA = 2,
	I_DATA_SEM_EA = 3,
};

enum {
	K3_UDMA_GLUE_SRC_TAG_LO_KEEP = 0,
	K3_UDMA_GLUE_SRC_TAG_LO_USE_FLOW_REG = 1,
	K3_UDMA_GLUE_SRC_TAG_LO_USE_REMOTE_FLOW_ID = 2,
	K3_UDMA_GLUE_SRC_TAG_LO_USE_REMOTE_SRC_TAG = 4,
};

enum {
	KBUF_MODE_EXPAND = 1,
	KBUF_MODE_FREE = 2,
};

enum {
	KERNEL_PARAM_FL_UNSAFE = 1,
	KERNEL_PARAM_FL_HWPARAM = 2,
};

enum {
	KERNEL_PARAM_OPS_FL_NOARG = 1,
};

enum {
	KF_ARG_DYNPTR_ID = 0,
	KF_ARG_LIST_HEAD_ID = 1,
	KF_ARG_LIST_NODE_ID = 2,
	KF_ARG_RB_ROOT_ID = 3,
	KF_ARG_RB_NODE_ID = 4,
	KF_ARG_WORKQUEUE_ID = 5,
	KF_ARG_RES_SPIN_LOCK_ID = 6,
	KF_ARG_TASK_WORK_ID = 7,
};

enum {
	KPARAM_MEM = 0,
	KPARAM_WIDTH = 1,
	KPARAM_HEIGHT = 2,
	KPARAM_CNT = 3,
};

enum {
	KPARAM_X = 0,
	KPARAM_Y = 1,
	KPARAM_CNT___2 = 2,
};

enum {
	KTW_FREEZABLE = 1,
};

enum {
	KVM_REG_ARM_STD_BIT_TRNG_V1_0 = 0,
	KVM_REG_ARM_STD_BMAP_BIT_COUNT = 1,
};

enum {
	KVM_REG_ARM_STD_HYP_BIT_PV_TIME = 0,
	KVM_REG_ARM_STD_HYP_BMAP_BIT_COUNT = 1,
};

enum {
	KVM_REG_ARM_VENDOR_HYP_BIT_DISCOVER_IMPL_VER = 0,
	KVM_REG_ARM_VENDOR_HYP_BIT_DISCOVER_IMPL_CPUS = 1,
	KVM_REG_ARM_VENDOR_HYP_BMAP_2_BIT_COUNT = 2,
};

enum {
	KVM_REG_ARM_VENDOR_HYP_BIT_FUNC_FEAT = 0,
	KVM_REG_ARM_VENDOR_HYP_BIT_PTP = 1,
	KVM_REG_ARM_VENDOR_HYP_BMAP_BIT_COUNT = 2,
};

enum {
	KYBER_ASYNC_PERCENT = 75,
};

enum {
	KYBER_LATENCY_SHIFT = 2,
	KYBER_GOOD_BUCKETS = 4,
	KYBER_LATENCY_BUCKETS = 8,
};

enum {
	KYBER_READ = 0,
	KYBER_WRITE = 1,
	KYBER_DISCARD = 2,
	KYBER_OTHER = 3,
	KYBER_NUM_DOMAINS = 4,
};

enum {
	KYBER_TOTAL_LATENCY = 0,
	KYBER_IO_LATENCY = 1,
};

enum {
	LANE_0 = 0,
	LANE_1 = 1,
};

enum {
	LAST_NORM = 0,
	LAST_ROOT = 1,
	LAST_DOT = 2,
	LAST_DOTDOT = 3,
};

enum {
	LED_PAR_CTRL_COLX = 0,
	LED_PAR_CTRL_ERROR = 1,
	LED_PAR_CTRL_DUPLEX = 2,
	LED_PAR_CTRL_DP_COL = 3,
	LED_PAR_CTRL_SPEED = 4,
	LED_PAR_CTRL_LINK = 5,
	LED_PAR_CTRL_TX = 6,
	LED_PAR_CTRL_RX = 7,
	LED_PAR_CTRL_ACT = 8,
	LED_PAR_CTRL_LNK_RX = 9,
	LED_PAR_CTRL_LNK_AC = 10,
	LED_PAR_CTRL_ACT_BL = 11,
	LED_PAR_CTRL_TX_BL = 12,
	LED_PAR_CTRL_RX_BL = 13,
	LED_PAR_CTRL_COL_BL = 14,
	LED_PAR_CTRL_INACT = 15,
};

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_RESUMING = 4194304,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_PRINT_QUIRKS = 2097152,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_QUIRK_DIAGNOSTIC = 1,
	ATA_QUIRK_NODMA = 2,
	ATA_QUIRK_NONCQ = 4,
	ATA_QUIRK_MAX_SEC_128 = 8,
	ATA_QUIRK_BROKEN_HPA = 16,
	ATA_QUIRK_DISABLE = 32,
	ATA_QUIRK_HPA_SIZE = 64,
	ATA_QUIRK_IVB = 128,
	ATA_QUIRK_STUCK_ERR = 256,
	ATA_QUIRK_BRIDGE_OK = 512,
	ATA_QUIRK_ATAPI_MOD16_DMA = 1024,
	ATA_QUIRK_FIRMWARE_WARN = 2048,
	ATA_QUIRK_1_5_GBPS = 4096,
	ATA_QUIRK_NOSETXFER = 8192,
	ATA_QUIRK_BROKEN_FPDMA_AA = 16384,
	ATA_QUIRK_DUMP_ID = 32768,
	ATA_QUIRK_MAX_SEC_LBA48 = 65536,
	ATA_QUIRK_ATAPI_DMADIR = 131072,
	ATA_QUIRK_NO_NCQ_TRIM = 262144,
	ATA_QUIRK_NOLPM = 524288,
	ATA_QUIRK_WD_BROKEN_LPM = 1048576,
	ATA_QUIRK_ZERO_AFTER_TRIM = 2097152,
	ATA_QUIRK_NO_DMA_LOG = 4194304,
	ATA_QUIRK_NOTRIM = 8388608,
	ATA_QUIRK_MAX_SEC_1024 = 16777216,
	ATA_QUIRK_MAX_TRIM_128M = 33554432,
	ATA_QUIRK_NO_NCQ_ON_ATI = 67108864,
	ATA_QUIRK_NO_LPM_ON_ATI = 134217728,
	ATA_QUIRK_NO_ID_DEV_LOG = 268435456,
	ATA_QUIRK_NO_LOG_DIR = 536870912,
	ATA_QUIRK_NO_FUA = 1073741824,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

enum {
	LINKLED_OFF = 1,
	LINKLED_ON = 2,
	LINKLED_LINKSYNC_OFF = 4,
	LINKLED_LINKSYNC_ON = 8,
	LINKLED_BLINK_OFF = 16,
	LINKLED_BLINK_ON = 32,
};

enum {
	LINK_CAPA_10HD = 0,
	LINK_CAPA_10FD = 1,
	LINK_CAPA_100HD = 2,
	LINK_CAPA_100FD = 3,
	LINK_CAPA_1000HD = 4,
	LINK_CAPA_1000FD = 5,
	LINK_CAPA_2500FD = 6,
	LINK_CAPA_5000FD = 7,
	LINK_CAPA_10000FD = 8,
	LINK_CAPA_20000FD = 9,
	LINK_CAPA_25000FD = 10,
	LINK_CAPA_40000FD = 11,
	LINK_CAPA_50000FD = 12,
	LINK_CAPA_56000FD = 13,
	LINK_CAPA_100000FD = 14,
	LINK_CAPA_200000FD = 15,
	LINK_CAPA_400000FD = 16,
	LINK_CAPA_800000FD = 17,
	__LINK_CAPA_MAX = 18,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_BEYOND_WINDOW = 16,
	LINUX_MIB_TSECRREJECTED = 17,
	LINUX_MIB_PAWS_OLD_ACK = 18,
	LINUX_MIB_PAWS_TW_REJECTED = 19,
	LINUX_MIB_DELAYEDACKS = 20,
	LINUX_MIB_DELAYEDACKLOCKED = 21,
	LINUX_MIB_DELAYEDACKLOST = 22,
	LINUX_MIB_LISTENOVERFLOWS = 23,
	LINUX_MIB_LISTENDROPS = 24,
	LINUX_MIB_TCPHPHITS = 25,
	LINUX_MIB_TCPPUREACKS = 26,
	LINUX_MIB_TCPHPACKS = 27,
	LINUX_MIB_TCPRENORECOVERY = 28,
	LINUX_MIB_TCPSACKRECOVERY = 29,
	LINUX_MIB_TCPSACKRENEGING = 30,
	LINUX_MIB_TCPSACKREORDER = 31,
	LINUX_MIB_TCPRENOREORDER = 32,
	LINUX_MIB_TCPTSREORDER = 33,
	LINUX_MIB_TCPFULLUNDO = 34,
	LINUX_MIB_TCPPARTIALUNDO = 35,
	LINUX_MIB_TCPDSACKUNDO = 36,
	LINUX_MIB_TCPLOSSUNDO = 37,
	LINUX_MIB_TCPLOSTRETRANSMIT = 38,
	LINUX_MIB_TCPRENOFAILURES = 39,
	LINUX_MIB_TCPSACKFAILURES = 40,
	LINUX_MIB_TCPLOSSFAILURES = 41,
	LINUX_MIB_TCPFASTRETRANS = 42,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 43,
	LINUX_MIB_TCPTIMEOUTS = 44,
	LINUX_MIB_TCPLOSSPROBES = 45,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 46,
	LINUX_MIB_TCPRENORECOVERYFAIL = 47,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 48,
	LINUX_MIB_TCPRCVCOLLAPSED = 49,
	LINUX_MIB_TCPDSACKOLDSENT = 50,
	LINUX_MIB_TCPDSACKOFOSENT = 51,
	LINUX_MIB_TCPDSACKRECV = 52,
	LINUX_MIB_TCPDSACKOFORECV = 53,
	LINUX_MIB_TCPABORTONDATA = 54,
	LINUX_MIB_TCPABORTONCLOSE = 55,
	LINUX_MIB_TCPABORTONMEMORY = 56,
	LINUX_MIB_TCPABORTONTIMEOUT = 57,
	LINUX_MIB_TCPABORTONLINGER = 58,
	LINUX_MIB_TCPABORTFAILED = 59,
	LINUX_MIB_TCPMEMORYPRESSURES = 60,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 61,
	LINUX_MIB_TCPSACKDISCARD = 62,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 63,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 64,
	LINUX_MIB_TCPSPURIOUSRTOS = 65,
	LINUX_MIB_TCPMD5NOTFOUND = 66,
	LINUX_MIB_TCPMD5UNEXPECTED = 67,
	LINUX_MIB_TCPMD5FAILURE = 68,
	LINUX_MIB_SACKSHIFTED = 69,
	LINUX_MIB_SACKMERGED = 70,
	LINUX_MIB_SACKSHIFTFALLBACK = 71,
	LINUX_MIB_TCPBACKLOGDROP = 72,
	LINUX_MIB_PFMEMALLOCDROP = 73,
	LINUX_MIB_TCPMINTTLDROP = 74,
	LINUX_MIB_TCPDEFERACCEPTDROP = 75,
	LINUX_MIB_IPRPFILTER = 76,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 77,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 78,
	LINUX_MIB_TCPREQQFULLDROP = 79,
	LINUX_MIB_TCPRETRANSFAIL = 80,
	LINUX_MIB_TCPRCVCOALESCE = 81,
	LINUX_MIB_TCPBACKLOGCOALESCE = 82,
	LINUX_MIB_TCPOFOQUEUE = 83,
	LINUX_MIB_TCPOFODROP = 84,
	LINUX_MIB_TCPOFOMERGE = 85,
	LINUX_MIB_TCPCHALLENGEACK = 86,
	LINUX_MIB_TCPSYNCHALLENGE = 87,
	LINUX_MIB_TCPFASTOPENACTIVE = 88,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 89,
	LINUX_MIB_TCPFASTOPENPASSIVE = 90,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 91,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 92,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 93,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 94,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 95,
	LINUX_MIB_BUSYPOLLRXPACKETS = 96,
	LINUX_MIB_TCPAUTOCORKING = 97,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 98,
	LINUX_MIB_TCPTOZEROWINDOWADV = 99,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 100,
	LINUX_MIB_TCPSYNRETRANS = 101,
	LINUX_MIB_TCPORIGDATASENT = 102,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 103,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 104,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 105,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 106,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 107,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 108,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 109,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 110,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 111,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 112,
	LINUX_MIB_TCPWINPROBE = 113,
	LINUX_MIB_TCPKEEPALIVE = 114,
	LINUX_MIB_TCPMTUPFAIL = 115,
	LINUX_MIB_TCPMTUPSUCCESS = 116,
	LINUX_MIB_TCPDELIVERED = 117,
	LINUX_MIB_TCPDELIVEREDCE = 118,
	LINUX_MIB_TCPACKCOMPRESSED = 119,
	LINUX_MIB_TCPZEROWINDOWDROP = 120,
	LINUX_MIB_TCPRCVQDROP = 121,
	LINUX_MIB_TCPWQUEUETOOBIG = 122,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 123,
	LINUX_MIB_TCPTIMEOUTREHASH = 124,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 125,
	LINUX_MIB_TCPDSACKRECVSEGS = 126,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 127,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 128,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 129,
	LINUX_MIB_TCPPLBREHASH = 130,
	LINUX_MIB_TCPAOREQUIRED = 131,
	LINUX_MIB_TCPAOBAD = 132,
	LINUX_MIB_TCPAOKEYNOTFOUND = 133,
	LINUX_MIB_TCPAOGOOD = 134,
	LINUX_MIB_TCPAODROPPEDICMPS = 135,
	__LINUX_MIB_MAX = 136,
};

enum {
	LK_STATE_IN_USE = 0,
	NFS_DELEGATED_STATE = 1,
	NFS_OPEN_STATE = 2,
	NFS_O_RDONLY_STATE = 3,
	NFS_O_WRONLY_STATE = 4,
	NFS_O_RDWR_STATE = 5,
	NFS_STATE_RECLAIM_REBOOT = 6,
	NFS_STATE_RECLAIM_NOGRACE = 7,
	NFS_STATE_POSIX_LOCKS = 8,
	NFS_STATE_RECOVERY_FAILED = 9,
	NFS_STATE_MAY_NOTIFY_LOCK = 10,
	NFS_STATE_CHANGE_WAIT = 11,
	NFS_CLNT_DST_SSC_COPY_STATE = 12,
	NFS_CLNT_SRC_SSC_COPY_STATE = 13,
	NFS_SRV_SSC_COPY_STATE = 14,
};

enum {
	LNK_SYNC_INI = 3120,
	LNK_SYNC_VAL = 3124,
	LNK_SYNC_CTRL = 3128,
	LNK_SYNC_TST = 3129,
	LNK_LED_REG = 3132,
	RX_GMF_EA = 3136,
	RX_GMF_AF_THR = 3140,
	RX_GMF_CTRL_T = 3144,
	RX_GMF_FL_MSK = 3148,
	RX_GMF_FL_THR = 3152,
	RX_GMF_FL_CTRL = 3154,
	RX_GMF_TR_THR = 3156,
	RX_GMF_UP_THR = 3160,
	RX_GMF_LP_THR = 3162,
	RX_GMF_VLAN = 3164,
	RX_GMF_WP = 3168,
	RX_GMF_WLEV = 3176,
	RX_GMF_RP = 3184,
	RX_GMF_RLEV = 3192,
};

enum {
	LOCKD_A_SERVER_GRACETIME = 1,
	LOCKD_A_SERVER_TCP_PORT = 2,
	LOCKD_A_SERVER_UDP_PORT = 3,
	__LOCKD_A_SERVER_MAX = 4,
	LOCKD_A_SERVER_MAX = 3,
};

enum {
	LOGIC_PIO_INDIRECT = 0,
	LOGIC_PIO_CPU_MMIO = 1,
};

enum {
	LO_FLAGS_READ_ONLY = 1,
	LO_FLAGS_AUTOCLEAR = 4,
	LO_FLAGS_PARTSCAN = 8,
	LO_FLAGS_DIRECT_IO = 16,
};

enum {
	LS1021A = 0,
	LS1012A = 1,
	LS1028A = 2,
	LS1043A = 3,
	LS1046A = 4,
	LS2080A = 5,
	LS2085A = 6,
	LX2160A = 7,
	MCF5441X = 8,
	VF610 = 9,
	S32G = 10,
	S32G_TARGET = 11,
};

enum {
	LTSSM_DETECT_QUIET = 0,
	LTSSM_DETECT_ACTIVE = 1,
	LTSSM_POLLING_ACTIVE = 2,
	LTSSM_POLLING_COMPLIANCE = 3,
	LTSSM_POLLING_CONFIGURATION = 4,
	LTSSM_CONFIG_LINKWIDTH_START = 5,
	LTSSM_CONFIG_LINKWIDTH_ACCEPT = 6,
	LTSSM_CONFIG_LANENUM_ACCEPT = 7,
	LTSSM_CONFIG_LANENUM_WAIT = 8,
	LTSSM_CONFIG_COMPLETE = 9,
	LTSSM_CONFIG_IDLE = 10,
	LTSSM_RECOVERY_RCVR_LOCK = 11,
	LTSSM_RECOVERY_SPEED = 12,
	LTSSM_RECOVERY_RCVR_CFG = 13,
	LTSSM_RECOVERY_IDLE = 14,
	LTSSM_L0 = 16,
	LTSSM_RX_L0S_ENTRY = 17,
	LTSSM_RX_L0S_IDLE = 18,
	LTSSM_RX_L0S_FTS = 19,
	LTSSM_TX_L0S_ENTRY = 20,
	LTSSM_TX_L0S_IDLE = 21,
	LTSSM_TX_L0S_FTS = 22,
	LTSSM_L1_ENTRY = 23,
	LTSSM_L1_IDLE = 24,
	LTSSM_L2_IDLE = 25,
	LTSSM_L2_TRANSMIT_WAKE = 26,
	LTSSM_DISABLED = 32,
	LTSSM_LOOPBACK_ENTRY_MASTER = 33,
	LTSSM_LOOPBACK_ACTIVE_MASTER = 34,
	LTSSM_LOOPBACK_EXIT_MASTER = 35,
	LTSSM_LOOPBACK_ENTRY_SLAVE = 36,
	LTSSM_LOOPBACK_ACTIVE_SLAVE = 37,
	LTSSM_LOOPBACK_EXIT_SLAVE = 38,
	LTSSM_HOT_RESET = 39,
	LTSSM_RECOVERY_EQUALIZATION_PHASE0 = 40,
	LTSSM_RECOVERY_EQUALIZATION_PHASE1 = 41,
	LTSSM_RECOVERY_EQUALIZATION_PHASE2 = 42,
	LTSSM_RECOVERY_EQUALIZATION_PHASE3 = 43,
};

enum {
	LWTUNNEL_IP_OPTS_UNSPEC = 0,
	LWTUNNEL_IP_OPTS_GENEVE = 1,
	LWTUNNEL_IP_OPTS_VXLAN = 2,
	LWTUNNEL_IP_OPTS_ERSPAN = 3,
	__LWTUNNEL_IP_OPTS_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_ERSPAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_ERSPAN_VER = 1,
	LWTUNNEL_IP_OPT_ERSPAN_INDEX = 2,
	LWTUNNEL_IP_OPT_ERSPAN_DIR = 3,
	LWTUNNEL_IP_OPT_ERSPAN_HWID = 4,
	__LWTUNNEL_IP_OPT_ERSPAN_MAX = 5,
};

enum {
	LWTUNNEL_IP_OPT_GENEVE_UNSPEC = 0,
	LWTUNNEL_IP_OPT_GENEVE_CLASS = 1,
	LWTUNNEL_IP_OPT_GENEVE_TYPE = 2,
	LWTUNNEL_IP_OPT_GENEVE_DATA = 3,
	__LWTUNNEL_IP_OPT_GENEVE_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_VXLAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_VXLAN_GBP = 1,
	__LWTUNNEL_IP_OPT_VXLAN_MAX = 2,
};

enum {
	LWTUNNEL_XMIT_DONE = 0,
	LWTUNNEL_XMIT_CONTINUE = 256,
};

enum {
	Lo_unbound = 0,
	Lo_bound = 1,
	Lo_rundown = 2,
	Lo_deleting = 3,
};

enum {
	MAC_TX_CLK_0_MHZ = 2,
	MAC_TX_CLK_2_5_MHZ = 6,
	MAC_TX_CLK_25_MHZ = 7,
};

enum {
	MASK_EE_STATUS = 65535,
	MASK_EE_DYNCAP_EVENT = 1,
	MASK_EE_SYSPOOL_EVENT = 2,
	MASK_EE_URGENT_BKOPS = 4,
	MASK_EE_TOO_HIGH_TEMP = 8,
	MASK_EE_TOO_LOW_TEMP = 16,
	MASK_EE_WRITEBOOSTER_EVENT = 32,
	MASK_EE_PERFORMANCE_THROTTLING = 64,
	MASK_EE_DEV_LVL_EXCEPTION = 128,
	MASK_EE_HEALTH_CRITICAL = 512,
};

enum {
	MASK_OCS = 15,
};

enum {
	MASK_TM_SERVICE_RESP = 255,
};

enum {
	MASK_TRANSFER_REQUESTS_SLOTS_SDB = 31,
	MASK_TRANSFER_REQUESTS_SLOTS_MCQ = 255,
	MASK_NUMBER_OUTSTANDING_RTT = 65280,
	MASK_TASK_MANAGEMENT_REQUEST_SLOTS = 458752,
	MASK_EHSLUTRD_SUPPORTED = 4194304,
	MASK_AUTO_HIBERN8_SUPPORT = 8388608,
	MASK_64_ADDRESSING_SUPPORT = 16777216,
	MASK_OUT_OF_ORDER_DATA_DELIVERY_SUPPORT = 33554432,
	MASK_UIC_DME_TEST_MODE_SUPPORT = 67108864,
	MASK_CRYPTO_SUPPORT = 268435456,
	MASK_LSDB_SUPPORT = 536870912,
	MASK_MCQ_SUPPORT = 1073741824,
};

enum {
	MATCH_MTR = 0,
	MATCH_MEQ = 1,
	MATCH_MLE = 2,
	MATCH_MLT = 3,
	MATCH_MGE = 4,
	MATCH_MGT = 5,
};

enum {
	MAX77620_GPIO0 = 0,
	MAX77620_GPIO1 = 1,
	MAX77620_GPIO2 = 2,
	MAX77620_GPIO3 = 3,
	MAX77620_GPIO4 = 4,
	MAX77620_GPIO5 = 5,
	MAX77620_GPIO6 = 6,
	MAX77620_GPIO7 = 7,
	MAX77620_GPIO_NR = 8,
};

enum {
	MAX_IORES_LEVEL = 5,
};

enum {
	MAX_OPT_ARGS = 3,
};

enum {
	MBE_REFERENCED_B = 0,
	MBE_REUSABLE_B = 1,
};

enum {
	MB_INODE_PA = 0,
	MB_GROUP_PA = 1,
};

enum {
	MCT_INT_SPI = 0,
	MCT_INT_PPI = 1,
};

enum {
	MDBA_GET_ENTRY_UNSPEC = 0,
	MDBA_GET_ENTRY = 1,
	MDBA_GET_ENTRY_ATTRS = 2,
	__MDBA_GET_ENTRY_MAX = 3,
};

enum {
	MDBA_SET_ENTRY_UNSPEC = 0,
	MDBA_SET_ENTRY = 1,
	MDBA_SET_ENTRY_ATTRS = 2,
	__MDBA_SET_ENTRY_MAX = 3,
};

enum {
	MEGASAS_HBA_OPERATIONAL = 0,
	MEGASAS_ADPRESET_SM_INFAULT = 1,
	MEGASAS_ADPRESET_SM_FW_RESET_SUCCESS = 2,
	MEGASAS_ADPRESET_SM_OPERATIONAL = 3,
	MEGASAS_HW_CRITICAL_ERROR = 4,
	MEGASAS_ADPRESET_SM_POLLING = 5,
	MEGASAS_ADPRESET_INPROG_SIGN = 3735936685,
};

enum {
	MEMBARRIER_FLAG_SYNC_CORE = 1,
	MEMBARRIER_FLAG_RSEQ = 2,
};

enum {
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_READY = 1,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED = 2,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED_READY = 4,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED = 8,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE_READY = 16,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ_READY = 64,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ = 128,
};

enum {
	MEMMAP_ON_MEMORY_DISABLE = 0,
	MEMMAP_ON_MEMORY_ENABLE = 1,
	MEMMAP_ON_MEMORY_FORCE = 2,
};

enum {
	MEMORY_RECLAIM_SWAPPINESS = 0,
	MEMORY_RECLAIM_SWAPPINESS_MAX = 1,
	MEMORY_RECLAIM_NULL = 2,
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

enum {
	MICRON_ON_DIE_UNSUPPORTED = 0,
	MICRON_ON_DIE_SUPPORTED = 1,
	MICRON_ON_DIE_MANDATORY = 2,
};

enum {
	MIIM_CMD_IDLE = 0,
	MIIM_CMD_LEGACY_WRITE = 1,
	MIIM_CMD_LEGACY_READ = 2,
};

enum {
	MIPI_DCS_NOP = 0,
	MIPI_DCS_SOFT_RESET = 1,
	MIPI_DCS_GET_COMPRESSION_MODE = 3,
	MIPI_DCS_GET_DISPLAY_ID = 4,
	MIPI_DCS_GET_ERROR_COUNT_ON_DSI = 5,
	MIPI_DCS_GET_RED_CHANNEL = 6,
	MIPI_DCS_GET_GREEN_CHANNEL = 7,
	MIPI_DCS_GET_BLUE_CHANNEL = 8,
	MIPI_DCS_GET_DISPLAY_STATUS = 9,
	MIPI_DCS_GET_POWER_MODE = 10,
	MIPI_DCS_GET_ADDRESS_MODE = 11,
	MIPI_DCS_GET_PIXEL_FORMAT = 12,
	MIPI_DCS_GET_DISPLAY_MODE = 13,
	MIPI_DCS_GET_SIGNAL_MODE = 14,
	MIPI_DCS_GET_DIAGNOSTIC_RESULT = 15,
	MIPI_DCS_ENTER_SLEEP_MODE = 16,
	MIPI_DCS_EXIT_SLEEP_MODE = 17,
	MIPI_DCS_ENTER_PARTIAL_MODE = 18,
	MIPI_DCS_ENTER_NORMAL_MODE = 19,
	MIPI_DCS_GET_IMAGE_CHECKSUM_RGB = 20,
	MIPI_DCS_GET_IMAGE_CHECKSUM_CT = 21,
	MIPI_DCS_EXIT_INVERT_MODE = 32,
	MIPI_DCS_ENTER_INVERT_MODE = 33,
	MIPI_DCS_SET_GAMMA_CURVE = 38,
	MIPI_DCS_SET_DISPLAY_OFF = 40,
	MIPI_DCS_SET_DISPLAY_ON = 41,
	MIPI_DCS_SET_COLUMN_ADDRESS = 42,
	MIPI_DCS_SET_PAGE_ADDRESS = 43,
	MIPI_DCS_WRITE_MEMORY_START = 44,
	MIPI_DCS_WRITE_LUT = 45,
	MIPI_DCS_READ_MEMORY_START = 46,
	MIPI_DCS_SET_PARTIAL_ROWS = 48,
	MIPI_DCS_SET_PARTIAL_COLUMNS = 49,
	MIPI_DCS_SET_SCROLL_AREA = 51,
	MIPI_DCS_SET_TEAR_OFF = 52,
	MIPI_DCS_SET_TEAR_ON = 53,
	MIPI_DCS_SET_ADDRESS_MODE = 54,
	MIPI_DCS_SET_SCROLL_START = 55,
	MIPI_DCS_EXIT_IDLE_MODE = 56,
	MIPI_DCS_ENTER_IDLE_MODE = 57,
	MIPI_DCS_SET_PIXEL_FORMAT = 58,
	MIPI_DCS_WRITE_MEMORY_CONTINUE = 60,
	MIPI_DCS_SET_3D_CONTROL = 61,
	MIPI_DCS_READ_MEMORY_CONTINUE = 62,
	MIPI_DCS_GET_3D_CONTROL = 63,
	MIPI_DCS_SET_VSYNC_TIMING = 64,
	MIPI_DCS_SET_TEAR_SCANLINE = 68,
	MIPI_DCS_GET_SCANLINE = 69,
	MIPI_DCS_SET_DISPLAY_BRIGHTNESS = 81,
	MIPI_DCS_GET_DISPLAY_BRIGHTNESS = 82,
	MIPI_DCS_WRITE_CONTROL_DISPLAY = 83,
	MIPI_DCS_GET_CONTROL_DISPLAY = 84,
	MIPI_DCS_WRITE_POWER_SAVE = 85,
	MIPI_DCS_GET_POWER_SAVE = 86,
	MIPI_DCS_SET_CABC_MIN_BRIGHTNESS = 94,
	MIPI_DCS_GET_CABC_MIN_BRIGHTNESS = 95,
	MIPI_DCS_READ_DDB_START = 161,
	MIPI_DCS_READ_PPS_START = 162,
	MIPI_DCS_READ_DDB_CONTINUE = 168,
	MIPI_DCS_READ_PPS_CONTINUE = 169,
};

enum {
	MIPI_DSI_V_SYNC_START = 1,
	MIPI_DSI_V_SYNC_END = 17,
	MIPI_DSI_H_SYNC_START = 33,
	MIPI_DSI_H_SYNC_END = 49,
	MIPI_DSI_COMPRESSION_MODE = 7,
	MIPI_DSI_END_OF_TRANSMISSION = 8,
	MIPI_DSI_COLOR_MODE_OFF = 2,
	MIPI_DSI_COLOR_MODE_ON = 18,
	MIPI_DSI_SHUTDOWN_PERIPHERAL = 34,
	MIPI_DSI_TURN_ON_PERIPHERAL = 50,
	MIPI_DSI_GENERIC_SHORT_WRITE_0_PARAM = 3,
	MIPI_DSI_GENERIC_SHORT_WRITE_1_PARAM = 19,
	MIPI_DSI_GENERIC_SHORT_WRITE_2_PARAM = 35,
	MIPI_DSI_GENERIC_READ_REQUEST_0_PARAM = 4,
	MIPI_DSI_GENERIC_READ_REQUEST_1_PARAM = 20,
	MIPI_DSI_GENERIC_READ_REQUEST_2_PARAM = 36,
	MIPI_DSI_DCS_SHORT_WRITE = 5,
	MIPI_DSI_DCS_SHORT_WRITE_PARAM = 21,
	MIPI_DSI_DCS_READ = 6,
	MIPI_DSI_EXECUTE_QUEUE = 22,
	MIPI_DSI_SET_MAXIMUM_RETURN_PACKET_SIZE = 55,
	MIPI_DSI_NULL_PACKET = 9,
	MIPI_DSI_BLANKING_PACKET = 25,
	MIPI_DSI_GENERIC_LONG_WRITE = 41,
	MIPI_DSI_DCS_LONG_WRITE = 57,
	MIPI_DSI_PICTURE_PARAMETER_SET = 10,
	MIPI_DSI_COMPRESSED_PIXEL_STREAM = 11,
	MIPI_DSI_LOOSELY_PACKED_PIXEL_STREAM_YCBCR20 = 12,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR24 = 28,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR16 = 44,
	MIPI_DSI_PACKED_PIXEL_STREAM_30 = 13,
	MIPI_DSI_PACKED_PIXEL_STREAM_36 = 29,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR12 = 61,
	MIPI_DSI_PACKED_PIXEL_STREAM_16 = 14,
	MIPI_DSI_PACKED_PIXEL_STREAM_18 = 30,
	MIPI_DSI_PIXEL_STREAM_3BYTE_18 = 46,
	MIPI_DSI_PACKED_PIXEL_STREAM_24 = 62,
};

enum {
	MIX_INFLIGHT = 2147483648,
};

enum {
	MLO_PAUSE_NONE = 0,
	MLO_PAUSE_RX = 1,
	MLO_PAUSE_TX = 2,
	MLO_PAUSE_TXRX_MASK = 3,
	MLO_PAUSE_AN = 4,
	MLO_AN_PHY = 0,
	MLO_AN_FIXED = 1,
	MLO_AN_INBAND = 2,
	PHYLINK_PCS_NEG_NONE = 0,
	PHYLINK_PCS_NEG_ENABLED = 16,
	PHYLINK_PCS_NEG_OUTBAND = 32,
	PHYLINK_PCS_NEG_INBAND = 64,
	PHYLINK_PCS_NEG_INBAND_DISABLED = 64,
	PHYLINK_PCS_NEG_INBAND_ENABLED = 80,
	MAC_SYM_PAUSE = 1,
	MAC_ASYM_PAUSE = 2,
	MAC_10HD = 4,
	MAC_10FD = 8,
	MAC_10 = 12,
	MAC_100HD = 16,
	MAC_100FD = 32,
	MAC_100 = 48,
	MAC_1000HD = 64,
	MAC_1000FD = 128,
	MAC_1000 = 192,
	MAC_2500FD = 256,
	MAC_5000FD = 512,
	MAC_10000FD = 1024,
	MAC_20000FD = 2048,
	MAC_25000FD = 4096,
	MAC_40000FD = 8192,
	MAC_50000FD = 16384,
	MAC_56000FD = 32768,
	MAC_100000FD = 65536,
	MAC_200000FD = 131072,
	MAC_400000FD = 262144,
};

enum {
	MMOP_OFFLINE = 0,
	MMOP_ONLINE = 1,
	MMOP_ONLINE_KERNEL = 2,
	MMOP_ONLINE_MOVABLE = 3,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum {
	MOUNTPROC3_NULL = 0,
	MOUNTPROC3_MNT = 1,
	MOUNTPROC3_DUMP = 2,
	MOUNTPROC3_UMNT = 3,
	MOUNTPROC3_UMNTALL = 4,
	MOUNTPROC3_EXPORT = 5,
};

enum {
	MOUNTPROC_NULL = 0,
	MOUNTPROC_MNT = 1,
	MOUNTPROC_DUMP = 2,
	MOUNTPROC_UMNT = 3,
	MOUNTPROC_UMNTALL = 4,
	MOUNTPROC_EXPORT = 5,
};

enum {
	MOXA_SUPP_RS232 = 1,
	MOXA_SUPP_RS422 = 2,
	MOXA_SUPP_RS485 = 4,
};

enum {
	MPOL_DEFAULT = 0,
	MPOL_PREFERRED = 1,
	MPOL_BIND = 2,
	MPOL_INTERLEAVE = 3,
	MPOL_LOCAL = 4,
	MPOL_PREFERRED_MANY = 5,
	MPOL_WEIGHTED_INTERLEAVE = 6,
	MPOL_MAX = 7,
};

enum {
	MSI_CHIP_FLAG_SET_EOI = 1,
	MSI_CHIP_FLAG_SET_ACK = 2,
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_FLAG_USE_DEV_FWNODE = 128,
	MSI_FLAG_PARENT_PM_DEV = 256,
	MSI_FLAG_PCI_MSI_MASK_PARENT = 512,
	MSI_FLAG_PCI_MSI_STARTUP_PARENT = 1024,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
	MSI_FLAG_NO_AFFINITY = 2097152,
	MSI_FLAG_NO_MASK = 4194304,
};

enum {
	MSPI_DONE = 1,
	BSPI_DONE = 2,
	BSPI_ERR = 4,
	MSPI_BSPI_DONE = 7,
};

enum {
	MT6357_ID_VCORE = 0,
	MT6357_ID_VMODEM = 1,
	MT6357_ID_VPA = 2,
	MT6357_ID_VPROC = 3,
	MT6357_ID_VS1 = 4,
	MT6357_ID_VAUX18 = 5,
	MT6357_ID_VAUD28 = 6,
	MT6357_ID_VCAMA = 7,
	MT6357_ID_VCAMD = 8,
	MT6357_ID_VCAMIO = 9,
	MT6357_ID_VCN18 = 10,
	MT6357_ID_VCN28 = 11,
	MT6357_ID_VCN33_BT = 12,
	MT6357_ID_VCN33_WIFI = 13,
	MT6357_ID_VDRAM = 14,
	MT6357_ID_VEFUSE = 15,
	MT6357_ID_VEMC = 16,
	MT6357_ID_VFE28 = 17,
	MT6357_ID_VIBR = 18,
	MT6357_ID_VIO18 = 19,
	MT6357_ID_VIO28 = 20,
	MT6357_ID_VLDO28 = 21,
	MT6357_ID_VMC = 22,
	MT6357_ID_VMCH = 23,
	MT6357_ID_VRF12 = 24,
	MT6357_ID_VRF18 = 25,
	MT6357_ID_VSIM1 = 26,
	MT6357_ID_VSIM2 = 27,
	MT6357_ID_VSRAM_OTHERS = 28,
	MT6357_ID_VSRAM_PROC = 29,
	MT6357_ID_VUSB33 = 30,
	MT6357_ID_VXO22 = 31,
	MT6357_ID_RG_MAX = 32,
};

enum {
	MT6358_ID_VDRAM1 = 0,
	MT6358_ID_VCORE = 1,
	MT6358_ID_VPA = 2,
	MT6358_ID_VPROC11 = 3,
	MT6358_ID_VPROC12 = 4,
	MT6358_ID_VGPU = 5,
	MT6358_ID_VS2 = 6,
	MT6358_ID_VMODEM = 7,
	MT6358_ID_VS1 = 8,
	MT6358_ID_VDRAM2 = 9,
	MT6358_ID_VSIM1 = 10,
	MT6358_ID_VIBR = 11,
	MT6358_ID_VRF12 = 12,
	MT6358_ID_VIO18 = 13,
	MT6358_ID_VUSB = 14,
	MT6358_ID_VCAMIO = 15,
	MT6358_ID_VCAMD = 16,
	MT6358_ID_VCN18 = 17,
	MT6358_ID_VFE28 = 18,
	MT6358_ID_VSRAM_PROC11 = 19,
	MT6358_ID_VCN28 = 20,
	MT6358_ID_VSRAM_OTHERS = 21,
	MT6358_ID_VSRAM_GPU = 22,
	MT6358_ID_VXO22 = 23,
	MT6358_ID_VEFUSE = 24,
	MT6358_ID_VAUX18 = 25,
	MT6358_ID_VMCH = 26,
	MT6358_ID_VBIF28 = 27,
	MT6358_ID_VSRAM_PROC12 = 28,
	MT6358_ID_VCAMA1 = 29,
	MT6358_ID_VEMC = 30,
	MT6358_ID_VIO28 = 31,
	MT6358_ID_VA12 = 32,
	MT6358_ID_VRF18 = 33,
	MT6358_ID_VCN33 = 34,
	MT6358_ID_VCAMA2 = 35,
	MT6358_ID_VMC = 36,
	MT6358_ID_VLDO28 = 37,
	MT6358_ID_VAUD28 = 38,
	MT6358_ID_VSIM2 = 39,
	MT6358_ID_RG_MAX = 40,
};

enum {
	MT6359_ID_VS1 = 0,
	MT6359_ID_VGPU11 = 1,
	MT6359_ID_VMODEM = 2,
	MT6359_ID_VPU = 3,
	MT6359_ID_VCORE = 4,
	MT6359_ID_VS2 = 5,
	MT6359_ID_VPA = 6,
	MT6359_ID_VPROC2 = 7,
	MT6359_ID_VPROC1 = 8,
	MT6359_ID_VCORE_SSHUB = 9,
	MT6359_ID_VGPU11_SSHUB = 9,
	MT6359_ID_VAUD18 = 10,
	MT6359_ID_VSIM1 = 11,
	MT6359_ID_VIBR = 12,
	MT6359_ID_VRF12 = 13,
	MT6359_ID_VUSB = 14,
	MT6359_ID_VSRAM_PROC2 = 15,
	MT6359_ID_VIO18 = 16,
	MT6359_ID_VCAMIO = 17,
	MT6359_ID_VCN18 = 18,
	MT6359_ID_VFE28 = 19,
	MT6359_ID_VCN13 = 20,
	MT6359_ID_VCN33_1_BT = 21,
	MT6359_ID_VCN33_1_WIFI = 22,
	MT6359_ID_VAUX18 = 23,
	MT6359_ID_VSRAM_OTHERS = 24,
	MT6359_ID_VEFUSE = 25,
	MT6359_ID_VXO22 = 26,
	MT6359_ID_VRFCK = 27,
	MT6359_ID_VBIF28 = 28,
	MT6359_ID_VIO28 = 29,
	MT6359_ID_VEMC = 30,
	MT6359_ID_VCN33_2_BT = 31,
	MT6359_ID_VCN33_2_WIFI = 32,
	MT6359_ID_VA12 = 33,
	MT6359_ID_VA09 = 34,
	MT6359_ID_VRF18 = 35,
	MT6359_ID_VSRAM_MD = 36,
	MT6359_ID_VUFS = 37,
	MT6359_ID_VM18 = 38,
	MT6359_ID_VBBCK = 39,
	MT6359_ID_VSRAM_PROC1 = 40,
	MT6359_ID_VSIM2 = 41,
	MT6359_ID_VSRAM_OTHERS_SSHUB = 42,
	MT6359_ID_RG_MAX = 43,
};

enum {
	MT6360_SLAVE_TCPC = 0,
	MT6360_SLAVE_PMIC = 1,
	MT6360_SLAVE_LDO = 2,
	MT6360_SLAVE_PMU = 3,
	MT6360_SLAVE_MAX = 4,
};

enum {
	MT6366_ID_VDRAM1 = 0,
	MT6366_ID_VCORE = 1,
	MT6366_ID_VPA = 2,
	MT6366_ID_VPROC11 = 3,
	MT6366_ID_VPROC12 = 4,
	MT6366_ID_VGPU = 5,
	MT6366_ID_VS2 = 6,
	MT6366_ID_VMODEM = 7,
	MT6366_ID_VS1 = 8,
	MT6366_ID_VDRAM2 = 9,
	MT6366_ID_VSIM1 = 10,
	MT6366_ID_VIBR = 11,
	MT6366_ID_VRF12 = 12,
	MT6366_ID_VIO18 = 13,
	MT6366_ID_VUSB = 14,
	MT6366_ID_VCN18 = 15,
	MT6366_ID_VFE28 = 16,
	MT6366_ID_VSRAM_PROC11 = 17,
	MT6366_ID_VCN28 = 18,
	MT6366_ID_VSRAM_OTHERS = 19,
	MT6366_ID_VSRAM_GPU = 20,
	MT6366_ID_VXO22 = 21,
	MT6366_ID_VEFUSE = 22,
	MT6366_ID_VAUX18 = 23,
	MT6366_ID_VMCH = 24,
	MT6366_ID_VBIF28 = 25,
	MT6366_ID_VSRAM_PROC12 = 26,
	MT6366_ID_VEMC = 27,
	MT6366_ID_VIO28 = 28,
	MT6366_ID_VA12 = 29,
	MT6366_ID_VRF18 = 30,
	MT6366_ID_VCN33 = 31,
	MT6366_ID_VMC = 32,
	MT6366_ID_VAUD28 = 33,
	MT6366_ID_VSIM2 = 34,
	MT6366_ID_VM18 = 35,
	MT6366_ID_VMDDR = 36,
	MT6366_ID_VSRAM_CORE = 37,
	MT6366_ID_RG_MAX = 38,
};

enum {
	MT6397_ID_VPCA15 = 0,
	MT6397_ID_VPCA7 = 1,
	MT6397_ID_VSRAMCA15 = 2,
	MT6397_ID_VSRAMCA7 = 3,
	MT6397_ID_VCORE = 4,
	MT6397_ID_VGPU = 5,
	MT6397_ID_VDRM = 6,
	MT6397_ID_VIO18 = 7,
	MT6397_ID_VTCXO = 8,
	MT6397_ID_VA28 = 9,
	MT6397_ID_VCAMA = 10,
	MT6397_ID_VIO28 = 11,
	MT6397_ID_VUSB = 12,
	MT6397_ID_VMC = 13,
	MT6397_ID_VMCH = 14,
	MT6397_ID_VEMC3V3 = 15,
	MT6397_ID_VGP1 = 16,
	MT6397_ID_VGP2 = 17,
	MT6397_ID_VGP3 = 18,
	MT6397_ID_VGP4 = 19,
	MT6397_ID_VGP5 = 20,
	MT6397_ID_VGP6 = 21,
	MT6397_ID_VIBR = 22,
	MT6397_ID_RG_MAX = 23,
};

enum {
	MTD_OPS_PLACE_OOB = 0,
	MTD_OPS_AUTO_OOB = 1,
	MTD_OPS_RAW = 2,
};

enum {
	MTK_UART_FC_NONE = 0,
	MTK_UART_FC_SW = 1,
	MTK_UART_FC_HW = 2,
};

enum {
	MUSB_CONTROLLER_MHDRC = 0,
	MUSB_CONTROLLER_HDRC = 1,
};

enum {
	MV64XXX_I2C_ACTION_INVALID = 0,
	MV64XXX_I2C_ACTION_CONTINUE = 1,
	MV64XXX_I2C_ACTION_SEND_RESTART = 2,
	MV64XXX_I2C_ACTION_SEND_ADDR_1 = 3,
	MV64XXX_I2C_ACTION_SEND_ADDR_2 = 4,
	MV64XXX_I2C_ACTION_SEND_DATA = 5,
	MV64XXX_I2C_ACTION_RCV_DATA = 6,
	MV64XXX_I2C_ACTION_RCV_DATA_STOP = 7,
	MV64XXX_I2C_ACTION_SEND_STOP = 8,
};

enum {
	MV64XXX_I2C_STATE_INVALID = 0,
	MV64XXX_I2C_STATE_IDLE = 1,
	MV64XXX_I2C_STATE_WAITING_FOR_START_COND = 2,
	MV64XXX_I2C_STATE_WAITING_FOR_RESTART = 3,
	MV64XXX_I2C_STATE_WAITING_FOR_ADDR_1_ACK = 4,
	MV64XXX_I2C_STATE_WAITING_FOR_ADDR_2_ACK = 5,
	MV64XXX_I2C_STATE_WAITING_FOR_TARGET_ACK = 6,
	MV64XXX_I2C_STATE_WAITING_FOR_TARGET_DATA = 7,
};

enum {
	MV_PMA_FW_VER0 = 49169,
	MV_PMA_FW_VER1 = 49170,
	MV_PMA_21X0_PORT_CTRL = 49226,
	MV_PMA_21X0_PORT_CTRL_SWRST = 32768,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_MASK = 7,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_USXGMII = 0,
	MV_PMA_2180_PORT_CTRL_MACTYPE_DXGMII = 1,
	MV_PMA_2180_PORT_CTRL_MACTYPE_QXGMII = 2,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_5GBASER = 4,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_5GBASER_NO_SGMII_AN = 5,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_10GBASER_RATE_MATCH = 6,
	MV_PMA_BOOT = 49232,
	MV_PMA_BOOT_FATAL = 1,
	MV_PCS_BASE_T = 0,
	MV_PCS_BASE_R = 4096,
	MV_PCS_1000BASEX = 8192,
	MV_PCS_CSCR1 = 32768,
	MV_PCS_CSCR1_ED_MASK = 768,
	MV_PCS_CSCR1_ED_OFF = 0,
	MV_PCS_CSCR1_ED_RX = 512,
	MV_PCS_CSCR1_ED_NLP = 768,
	MV_PCS_CSCR1_MDIX_MASK = 96,
	MV_PCS_CSCR1_MDIX_MDI = 0,
	MV_PCS_CSCR1_MDIX_MDIX = 32,
	MV_PCS_CSCR1_MDIX_AUTO = 96,
	MV_PCS_DSC1 = 32771,
	MV_PCS_DSC1_ENABLE = 512,
	MV_PCS_DSC1_10GBT = 448,
	MV_PCS_DSC1_1GBR = 56,
	MV_PCS_DSC1_100BTX = 7,
	MV_PCS_DSC2 = 32772,
	MV_PCS_DSC2_2P5G = 61440,
	MV_PCS_DSC2_5G = 3840,
	MV_PCS_CSSR1 = 32776,
	MV_PCS_CSSR1_SPD1_MASK = 49152,
	MV_PCS_CSSR1_SPD1_SPD2 = 49152,
	MV_PCS_CSSR1_SPD1_1000 = 32768,
	MV_PCS_CSSR1_SPD1_100 = 16384,
	MV_PCS_CSSR1_SPD1_10 = 0,
	MV_PCS_CSSR1_DUPLEX_FULL = 8192,
	MV_PCS_CSSR1_RESOLVED = 2048,
	MV_PCS_CSSR1_MDIX = 64,
	MV_PCS_CSSR1_SPD2_MASK = 12,
	MV_PCS_CSSR1_SPD2_5000 = 8,
	MV_PCS_CSSR1_SPD2_2500 = 4,
	MV_PCS_CSSR1_SPD2_10000 = 0,
	MV_PCS_TEMP = 32834,
	MV_PCS_PORT_INFO = 53261,
	MV_PCS_PORT_INFO_NPORTS_MASK = 896,
	MV_PCS_PORT_INFO_NPORTS_SHIFT = 7,
	MV_AN_21X0_SERDES_CTRL2 = 32783,
	MV_AN_21X0_SERDES_CTRL2_AUTO_INIT_DIS = 8192,
	MV_AN_21X0_SERDES_CTRL2_RUN_INIT = 32768,
	MV_AN_CTRL1000 = 32768,
	MV_AN_STAT1000 = 32769,
	MV_V2_PORT_CTRL = 61441,
	MV_V2_PORT_CTRL_PWRDOWN = 2048,
	MV_V2_33X0_PORT_CTRL_SWRST = 32768,
	MV_V2_33X0_PORT_CTRL_MACTYPE_MASK = 7,
	MV_V2_33X0_PORT_CTRL_MACTYPE_RXAUI = 0,
	MV_V2_3310_PORT_CTRL_MACTYPE_XAUI_RATE_MATCH = 1,
	MV_V2_3340_PORT_CTRL_MACTYPE_RXAUI_NO_SGMII_AN = 1,
	MV_V2_33X0_PORT_CTRL_MACTYPE_RXAUI_RATE_MATCH = 2,
	MV_V2_3310_PORT_CTRL_MACTYPE_XAUI = 3,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER = 4,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER_NO_SGMII_AN = 5,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER_RATE_MATCH = 6,
	MV_V2_33X0_PORT_CTRL_MACTYPE_USXGMII = 7,
	MV_V2_PORT_INTR_STS = 61504,
	MV_V2_PORT_INTR_MASK = 61507,
	MV_V2_PORT_INTR_STS_WOL_EN = 256,
	MV_V2_MAGIC_PKT_WORD0 = 61547,
	MV_V2_MAGIC_PKT_WORD1 = 61548,
	MV_V2_MAGIC_PKT_WORD2 = 61549,
	MV_V2_WOL_CTRL = 61550,
	MV_V2_WOL_CTRL_CLEAR_STS = 32768,
	MV_V2_WOL_CTRL_MAGIC_PKT_EN = 1,
	MV_V2_TEMP_CTRL = 61578,
	MV_V2_TEMP_CTRL_MASK = 49152,
	MV_V2_TEMP_CTRL_SAMPLE = 0,
	MV_V2_TEMP_CTRL_DISABLE = 49152,
	MV_V2_TEMP = 61580,
	MV_V2_TEMP_UNKNOWN = 38400,
};

enum {
	M_I17 = 0,
	M_I20 = 1,
	M_I20_SR = 2,
	M_I24 = 3,
	M_I24_8_1 = 4,
	M_I24_10_1 = 5,
	M_I27_11_1 = 6,
	M_MINI = 7,
	M_MINI_3_1 = 8,
	M_MINI_4_1 = 9,
	M_MB = 10,
	M_MB_2 = 11,
	M_MB_3 = 12,
	M_MB_5_1 = 13,
	M_MB_6_1 = 14,
	M_MB_7_1 = 15,
	M_MB_SR = 16,
	M_MBA = 17,
	M_MBA_3 = 18,
	M_MBP = 19,
	M_MBP_2 = 20,
	M_MBP_2_2 = 21,
	M_MBP_SR = 22,
	M_MBP_4 = 23,
	M_MBP_5_1 = 24,
	M_MBP_5_2 = 25,
	M_MBP_5_3 = 26,
	M_MBP_6_1 = 27,
	M_MBP_6_2 = 28,
	M_MBP_7_1 = 29,
	M_MBP_8_2 = 30,
	M_UNKNOWN = 31,
};

enum {
	NAPIF_STATE_SCHED = 1,
	NAPIF_STATE_MISSED = 2,
	NAPIF_STATE_DISABLE = 4,
	NAPIF_STATE_NPSVC = 8,
	NAPIF_STATE_LISTED = 16,
	NAPIF_STATE_NO_BUSY_POLL = 32,
	NAPIF_STATE_IN_BUSY_POLL = 64,
	NAPIF_STATE_PREFER_BUSY_POLL = 128,
	NAPIF_STATE_THREADED = 256,
	NAPIF_STATE_SCHED_THREADED = 512,
	NAPIF_STATE_HAS_NOTIFIER = 1024,
};

enum {
	NAPI_F_PREFER_BUSY_POLL = 1,
	NAPI_F_END_ON_RESCHED = 2,
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
	NAPI_STATE_HAS_NOTIFIER = 10,
};

enum {
	NDA_UNSPEC = 0,
	NDA_DST = 1,
	NDA_LLADDR = 2,
	NDA_CACHEINFO = 3,
	NDA_PROBES = 4,
	NDA_VLAN = 5,
	NDA_PORT = 6,
	NDA_VNI = 7,
	NDA_IFINDEX = 8,
	NDA_MASTER = 9,
	NDA_LINK_NETNSID = 10,
	NDA_SRC_VNI = 11,
	NDA_PROTOCOL = 12,
	NDA_NH_ID = 13,
	NDA_FDB_EXT_ATTRS = 14,
	NDA_FLAGS_EXT = 15,
	NDA_NDM_STATE_MASK = 16,
	NDA_NDM_FLAGS_MASK = 17,
	__NDA_MAX = 18,
};

enum {
	NDTA_UNSPEC = 0,
	NDTA_NAME = 1,
	NDTA_THRESH1 = 2,
	NDTA_THRESH2 = 3,
	NDTA_THRESH3 = 4,
	NDTA_CONFIG = 5,
	NDTA_PARMS = 6,
	NDTA_STATS = 7,
	NDTA_GC_INTERVAL = 8,
	NDTA_PAD = 9,
	__NDTA_MAX = 10,
};

enum {
	NDTPA_UNSPEC = 0,
	NDTPA_IFINDEX = 1,
	NDTPA_REFCNT = 2,
	NDTPA_REACHABLE_TIME = 3,
	NDTPA_BASE_REACHABLE_TIME = 4,
	NDTPA_RETRANS_TIME = 5,
	NDTPA_GC_STALETIME = 6,
	NDTPA_DELAY_PROBE_TIME = 7,
	NDTPA_QUEUE_LEN = 8,
	NDTPA_APP_PROBES = 9,
	NDTPA_UCAST_PROBES = 10,
	NDTPA_MCAST_PROBES = 11,
	NDTPA_ANYCAST_DELAY = 12,
	NDTPA_PROXY_DELAY = 13,
	NDTPA_PROXY_QLEN = 14,
	NDTPA_LOCKTIME = 15,
	NDTPA_QUEUE_LENBYTES = 16,
	NDTPA_MCAST_REPROBES = 17,
	NDTPA_PAD = 18,
	NDTPA_INTERVAL_PROBE_TIME_MS = 19,
	__NDTPA_MAX = 20,
};

enum {
	NEIGH_ARP_TABLE = 0,
	NEIGH_ND_TABLE = 1,
	NEIGH_NR_TABLES = 2,
	NEIGH_LINK_TABLE = 2,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	NETCONFA_UNSPEC = 0,
	NETCONFA_IFINDEX = 1,
	NETCONFA_FORWARDING = 2,
	NETCONFA_RP_FILTER = 3,
	NETCONFA_MC_FORWARDING = 4,
	NETCONFA_PROXY_NEIGH = 5,
	NETCONFA_IGNORE_ROUTES_WITH_LINKDOWN = 6,
	NETCONFA_INPUT = 7,
	NETCONFA_BC_FORWARDING = 8,
	NETCONFA_FORCE_FORWARDING = 9,
	__NETCONFA_MAX = 10,
};

enum {
	NETDEV_A_DEV_IFINDEX = 1,
	NETDEV_A_DEV_PAD = 2,
	NETDEV_A_DEV_XDP_FEATURES = 3,
	NETDEV_A_DEV_XDP_ZC_MAX_SEGS = 4,
	NETDEV_A_DEV_XDP_RX_METADATA_FEATURES = 5,
	NETDEV_A_DEV_XSK_FEATURES = 6,
	__NETDEV_A_DEV_MAX = 7,
	NETDEV_A_DEV_MAX = 6,
};

enum {
	NETDEV_A_DMABUF_IFINDEX = 1,
	NETDEV_A_DMABUF_QUEUES = 2,
	NETDEV_A_DMABUF_FD = 3,
	NETDEV_A_DMABUF_ID = 4,
	__NETDEV_A_DMABUF_MAX = 5,
	NETDEV_A_DMABUF_MAX = 4,
};

enum {
	NETDEV_A_NAPI_IFINDEX = 1,
	NETDEV_A_NAPI_ID = 2,
	NETDEV_A_NAPI_IRQ = 3,
	NETDEV_A_NAPI_PID = 4,
	NETDEV_A_NAPI_DEFER_HARD_IRQS = 5,
	NETDEV_A_NAPI_GRO_FLUSH_TIMEOUT = 6,
	NETDEV_A_NAPI_IRQ_SUSPEND_TIMEOUT = 7,
	NETDEV_A_NAPI_THREADED = 8,
	__NETDEV_A_NAPI_MAX = 9,
	NETDEV_A_NAPI_MAX = 8,
};

enum {
	NETDEV_A_PAGE_POOL_ID = 1,
	NETDEV_A_PAGE_POOL_IFINDEX = 2,
	NETDEV_A_PAGE_POOL_NAPI_ID = 3,
	NETDEV_A_PAGE_POOL_INFLIGHT = 4,
	NETDEV_A_PAGE_POOL_INFLIGHT_MEM = 5,
	NETDEV_A_PAGE_POOL_DETACH_TIME = 6,
	NETDEV_A_PAGE_POOL_DMABUF = 7,
	NETDEV_A_PAGE_POOL_IO_URING = 8,
	__NETDEV_A_PAGE_POOL_MAX = 9,
	NETDEV_A_PAGE_POOL_MAX = 8,
};

enum {
	NETDEV_A_PAGE_POOL_STATS_INFO = 1,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_FAST = 8,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW = 9,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW_HIGH_ORDER = 10,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_EMPTY = 11,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_REFILL = 12,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_WAIVE = 13,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHED = 14,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHE_FULL = 15,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING = 16,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING_FULL = 17,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RELEASED_REFCNT = 18,
	__NETDEV_A_PAGE_POOL_STATS_MAX = 19,
	NETDEV_A_PAGE_POOL_STATS_MAX = 18,
};

enum {
	NETDEV_A_QSTATS_IFINDEX = 1,
	NETDEV_A_QSTATS_QUEUE_TYPE = 2,
	NETDEV_A_QSTATS_QUEUE_ID = 3,
	NETDEV_A_QSTATS_SCOPE = 4,
	NETDEV_A_QSTATS_RX_PACKETS = 8,
	NETDEV_A_QSTATS_RX_BYTES = 9,
	NETDEV_A_QSTATS_TX_PACKETS = 10,
	NETDEV_A_QSTATS_TX_BYTES = 11,
	NETDEV_A_QSTATS_RX_ALLOC_FAIL = 12,
	NETDEV_A_QSTATS_RX_HW_DROPS = 13,
	NETDEV_A_QSTATS_RX_HW_DROP_OVERRUNS = 14,
	NETDEV_A_QSTATS_RX_CSUM_COMPLETE = 15,
	NETDEV_A_QSTATS_RX_CSUM_UNNECESSARY = 16,
	NETDEV_A_QSTATS_RX_CSUM_NONE = 17,
	NETDEV_A_QSTATS_RX_CSUM_BAD = 18,
	NETDEV_A_QSTATS_RX_HW_GRO_PACKETS = 19,
	NETDEV_A_QSTATS_RX_HW_GRO_BYTES = 20,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_PACKETS = 21,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_BYTES = 22,
	NETDEV_A_QSTATS_RX_HW_DROP_RATELIMITS = 23,
	NETDEV_A_QSTATS_TX_HW_DROPS = 24,
	NETDEV_A_QSTATS_TX_HW_DROP_ERRORS = 25,
	NETDEV_A_QSTATS_TX_CSUM_NONE = 26,
	NETDEV_A_QSTATS_TX_NEEDS_CSUM = 27,
	NETDEV_A_QSTATS_TX_HW_GSO_PACKETS = 28,
	NETDEV_A_QSTATS_TX_HW_GSO_BYTES = 29,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_PACKETS = 30,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_BYTES = 31,
	NETDEV_A_QSTATS_TX_HW_DROP_RATELIMITS = 32,
	NETDEV_A_QSTATS_TX_STOP = 33,
	NETDEV_A_QSTATS_TX_WAKE = 34,
	__NETDEV_A_QSTATS_MAX = 35,
	NETDEV_A_QSTATS_MAX = 34,
};

enum {
	NETDEV_A_QUEUE_ID = 1,
	NETDEV_A_QUEUE_IFINDEX = 2,
	NETDEV_A_QUEUE_TYPE = 3,
	NETDEV_A_QUEUE_NAPI_ID = 4,
	NETDEV_A_QUEUE_DMABUF = 5,
	NETDEV_A_QUEUE_IO_URING = 6,
	NETDEV_A_QUEUE_XSK = 7,
	__NETDEV_A_QUEUE_MAX = 8,
	NETDEV_A_QUEUE_MAX = 7,
};

enum {
	NETDEV_CMD_DEV_GET = 1,
	NETDEV_CMD_DEV_ADD_NTF = 2,
	NETDEV_CMD_DEV_DEL_NTF = 3,
	NETDEV_CMD_DEV_CHANGE_NTF = 4,
	NETDEV_CMD_PAGE_POOL_GET = 5,
	NETDEV_CMD_PAGE_POOL_ADD_NTF = 6,
	NETDEV_CMD_PAGE_POOL_DEL_NTF = 7,
	NETDEV_CMD_PAGE_POOL_CHANGE_NTF = 8,
	NETDEV_CMD_PAGE_POOL_STATS_GET = 9,
	NETDEV_CMD_QUEUE_GET = 10,
	NETDEV_CMD_NAPI_GET = 11,
	NETDEV_CMD_QSTATS_GET = 12,
	NETDEV_CMD_BIND_RX = 13,
	NETDEV_CMD_NAPI_SET = 14,
	NETDEV_CMD_BIND_TX = 15,
	__NETDEV_CMD_MAX = 16,
	NETDEV_CMD_MAX = 15,
};

enum {
	NETDEV_NLGRP_MGMT = 0,
	NETDEV_NLGRP_PAGE_POOL = 1,
};

enum {
	NETDEV_STATS = 0,
	E1000_STATS = 1,
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	__UNUSED_NETIF_F_12 = 12,
	__UNUSED_NETIF_F_13 = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_ACCECN_BIT = 35,
	NETIF_F_GSO_LAST = 35,
	NETIF_F_FCOE_CRC_BIT = 36,
	NETIF_F_SCTP_CRC_BIT = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	NETLINK_F_KERNEL_SOCKET = 0,
	NETLINK_F_RECV_PKTINFO = 1,
	NETLINK_F_BROADCAST_SEND_ERROR = 2,
	NETLINK_F_RECV_NO_ENOBUFS = 3,
	NETLINK_F_LISTEN_ALL_NSID = 4,
	NETLINK_F_CAP_ACK = 5,
	NETLINK_F_EXT_ACK = 6,
	NETLINK_F_STRICT_CHK = 7,
};

enum {
	NETLINK_UNCONNECTED = 0,
	NETLINK_CONNECTED = 1,
};

enum {
	NETNSA_NONE = 0,
	NETNSA_NSID = 1,
	NETNSA_PID = 2,
	NETNSA_FD = 3,
	NETNSA_TARGET_NSID = 4,
	NETNSA_CURRENT_NSID = 5,
	__NETNSA_MAX = 6,
};

enum {
	NET_NS_INDEX = 0,
	UTS_NS_INDEX = 1,
	IPC_NS_INDEX = 2,
	PID_NS_INDEX = 3,
	USER_NS_INDEX = 4,
	MNT_NS_INDEX = 5,
	CGROUP_NS_INDEX = 6,
	NR_NAMESPACES = 7,
};

enum {
	NEXTHOP_GRP_TYPE_MPATH = 0,
	NEXTHOP_GRP_TYPE_RES = 1,
	__NEXTHOP_GRP_TYPE_MAX = 2,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum {
	NFSPROC4_CLNT_NULL = 0,
	NFSPROC4_CLNT_READ = 1,
	NFSPROC4_CLNT_WRITE = 2,
	NFSPROC4_CLNT_COMMIT = 3,
	NFSPROC4_CLNT_OPEN = 4,
	NFSPROC4_CLNT_OPEN_CONFIRM = 5,
	NFSPROC4_CLNT_OPEN_NOATTR = 6,
	NFSPROC4_CLNT_OPEN_DOWNGRADE = 7,
	NFSPROC4_CLNT_CLOSE = 8,
	NFSPROC4_CLNT_SETATTR = 9,
	NFSPROC4_CLNT_FSINFO = 10,
	NFSPROC4_CLNT_RENEW = 11,
	NFSPROC4_CLNT_SETCLIENTID = 12,
	NFSPROC4_CLNT_SETCLIENTID_CONFIRM = 13,
	NFSPROC4_CLNT_LOCK = 14,
	NFSPROC4_CLNT_LOCKT = 15,
	NFSPROC4_CLNT_LOCKU = 16,
	NFSPROC4_CLNT_ACCESS = 17,
	NFSPROC4_CLNT_GETATTR = 18,
	NFSPROC4_CLNT_LOOKUP = 19,
	NFSPROC4_CLNT_LOOKUP_ROOT = 20,
	NFSPROC4_CLNT_REMOVE = 21,
	NFSPROC4_CLNT_RENAME = 22,
	NFSPROC4_CLNT_LINK = 23,
	NFSPROC4_CLNT_SYMLINK = 24,
	NFSPROC4_CLNT_CREATE = 25,
	NFSPROC4_CLNT_PATHCONF = 26,
	NFSPROC4_CLNT_STATFS = 27,
	NFSPROC4_CLNT_READLINK = 28,
	NFSPROC4_CLNT_READDIR = 29,
	NFSPROC4_CLNT_SERVER_CAPS = 30,
	NFSPROC4_CLNT_DELEGRETURN = 31,
	NFSPROC4_CLNT_GETACL = 32,
	NFSPROC4_CLNT_SETACL = 33,
	NFSPROC4_CLNT_FS_LOCATIONS = 34,
	NFSPROC4_CLNT_RELEASE_LOCKOWNER = 35,
	NFSPROC4_CLNT_SECINFO = 36,
	NFSPROC4_CLNT_FSID_PRESENT = 37,
	NFSPROC4_CLNT_EXCHANGE_ID = 38,
	NFSPROC4_CLNT_CREATE_SESSION = 39,
	NFSPROC4_CLNT_DESTROY_SESSION = 40,
	NFSPROC4_CLNT_SEQUENCE = 41,
	NFSPROC4_CLNT_GET_LEASE_TIME = 42,
	NFSPROC4_CLNT_RECLAIM_COMPLETE = 43,
	NFSPROC4_CLNT_LAYOUTGET = 44,
	NFSPROC4_CLNT_GETDEVICEINFO = 45,
	NFSPROC4_CLNT_LAYOUTCOMMIT = 46,
	NFSPROC4_CLNT_LAYOUTRETURN = 47,
	NFSPROC4_CLNT_SECINFO_NO_NAME = 48,
	NFSPROC4_CLNT_TEST_STATEID = 49,
	NFSPROC4_CLNT_FREE_STATEID = 50,
	NFSPROC4_CLNT_GETDEVICELIST = 51,
	NFSPROC4_CLNT_BIND_CONN_TO_SESSION = 52,
	NFSPROC4_CLNT_DESTROY_CLIENTID = 53,
	NFSPROC4_CLNT_SEEK = 54,
	NFSPROC4_CLNT_ALLOCATE = 55,
	NFSPROC4_CLNT_DEALLOCATE = 56,
	NFSPROC4_CLNT_ZERO_RANGE = 57,
	NFSPROC4_CLNT_LAYOUTSTATS = 58,
	NFSPROC4_CLNT_CLONE = 59,
	NFSPROC4_CLNT_COPY = 60,
	NFSPROC4_CLNT_OFFLOAD_CANCEL = 61,
	NFSPROC4_CLNT_LOOKUPP = 62,
	NFSPROC4_CLNT_LAYOUTERROR = 63,
	NFSPROC4_CLNT_COPY_NOTIFY = 64,
	NFSPROC4_CLNT_GETXATTR = 65,
	NFSPROC4_CLNT_SETXATTR = 66,
	NFSPROC4_CLNT_LISTXATTRS = 67,
	NFSPROC4_CLNT_REMOVEXATTR = 68,
	NFSPROC4_CLNT_READ_PLUS = 69,
	NFSPROC4_CLNT_OFFLOAD_STATUS = 70,
};

enum {
	NFS_DELEGATION_NEED_RECLAIM = 0,
	NFS_DELEGATION_RETURN = 1,
	NFS_DELEGATION_RETURN_IF_CLOSED = 2,
	NFS_DELEGATION_REFERENCED = 3,
	NFS_DELEGATION_RETURNING = 4,
	NFS_DELEGATION_REVOKED = 5,
	NFS_DELEGATION_TEST_EXPIRED = 6,
	NFS_DELEGATION_INODE_FREEING = 7,
	NFS_DELEGATION_RETURN_DELAYED = 8,
	NFS_DELEGATION_DELEGTIME = 9,
};

enum {
	NFS_DEVICEID_INVALID = 0,
	NFS_DEVICEID_UNAVAILABLE = 1,
	NFS_DEVICEID_NOCACHE = 2,
};

enum {
	NFS_IOHDR_ERROR = 0,
	NFS_IOHDR_EOF = 1,
	NFS_IOHDR_REDO = 2,
	NFS_IOHDR_STAT = 3,
	NFS_IOHDR_RESEND_PNFS = 4,
	NFS_IOHDR_RESEND_MDS = 5,
	NFS_IOHDR_UNSTABLE_WRITES = 6,
	NFS_IOHDR_ODIRECT = 7,
};

enum {
	NFS_LAYOUT_RO_FAILED = 0,
	NFS_LAYOUT_RW_FAILED = 1,
	NFS_LAYOUT_BULK_RECALL = 2,
	NFS_LAYOUT_RETURN = 3,
	NFS_LAYOUT_RETURN_LOCK = 4,
	NFS_LAYOUT_RETURN_REQUESTED = 5,
	NFS_LAYOUT_INVALID_STID = 6,
	NFS_LAYOUT_FIRST_LAYOUTGET = 7,
	NFS_LAYOUT_INODE_FREEING = 8,
	NFS_LAYOUT_HASHED = 9,
	NFS_LAYOUT_DRAIN = 10,
};

enum {
	NFS_LSEG_VALID = 0,
	NFS_LSEG_ROC = 1,
	NFS_LSEG_LAYOUTCOMMIT = 2,
	NFS_LSEG_LAYOUTRETURN = 3,
	NFS_LSEG_UNAVAILABLE = 4,
};

enum {
	NFS_OWNER_RECLAIM_REBOOT = 0,
	NFS_OWNER_RECLAIM_NOGRACE = 1,
};

enum {
	NHA_GROUP_STATS_ENTRY_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY_ID = 1,
	NHA_GROUP_STATS_ENTRY_PACKETS = 2,
	NHA_GROUP_STATS_ENTRY_PACKETS_HW = 3,
	__NHA_GROUP_STATS_ENTRY_MAX = 4,
};

enum {
	NHA_GROUP_STATS_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY = 1,
	__NHA_GROUP_STATS_MAX = 2,
};

enum {
	NHA_RES_BUCKET_UNSPEC = 0,
	NHA_RES_BUCKET_PAD = 0,
	NHA_RES_BUCKET_INDEX = 1,
	NHA_RES_BUCKET_IDLE_TIME = 2,
	NHA_RES_BUCKET_NH_ID = 3,
	__NHA_RES_BUCKET_MAX = 4,
};

enum {
	NHA_RES_GROUP_UNSPEC = 0,
	NHA_RES_GROUP_PAD = 0,
	NHA_RES_GROUP_BUCKETS = 1,
	NHA_RES_GROUP_IDLE_TIMER = 2,
	NHA_RES_GROUP_UNBALANCED_TIMER = 3,
	NHA_RES_GROUP_UNBALANCED_TIME = 4,
	__NHA_RES_GROUP_MAX = 5,
};

enum {
	NHA_UNSPEC = 0,
	NHA_ID = 1,
	NHA_GROUP = 2,
	NHA_GROUP_TYPE = 3,
	NHA_BLACKHOLE = 4,
	NHA_OIF = 5,
	NHA_GATEWAY = 6,
	NHA_ENCAP_TYPE = 7,
	NHA_ENCAP = 8,
	NHA_GROUPS = 9,
	NHA_MASTER = 10,
	NHA_FDB = 11,
	NHA_RES_GROUP = 12,
	NHA_RES_BUCKET = 13,
	NHA_OP_FLAGS = 14,
	NHA_GROUP_STATS = 15,
	NHA_HW_STATS_ENABLE = 16,
	NHA_HW_STATS_USED = 17,
	__NHA_MAX = 18,
};

enum {
	NLA_UNSPEC = 0,
	NLA_U8 = 1,
	NLA_U16 = 2,
	NLA_U32 = 3,
	NLA_U64 = 4,
	NLA_STRING = 5,
	NLA_FLAG = 6,
	NLA_MSECS = 7,
	NLA_NESTED = 8,
	NLA_NESTED_ARRAY = 9,
	NLA_NUL_STRING = 10,
	NLA_BINARY = 11,
	NLA_S8 = 12,
	NLA_S16 = 13,
	NLA_S32 = 14,
	NLA_S64 = 15,
	NLA_BITFIELD32 = 16,
	NLA_REJECT = 17,
	NLA_BE16 = 18,
	NLA_BE32 = 19,
	NLA_SINT = 20,
	NLA_UINT = 21,
	__NLA_TYPE_MAX = 22,
};

enum {
	NLM_LCK_GRANTED = 0,
	NLM_LCK_DENIED = 1,
	NLM_LCK_DENIED_NOLOCKS = 2,
	NLM_LCK_BLOCKED = 3,
	NLM_LCK_DENIED_GRACE_PERIOD = 4,
	NLM_DEADLCK = 5,
	NLM_ROFS = 6,
	NLM_STALE_FH = 7,
	NLM_FBIG = 8,
	NLM_FAILED = 9,
};

enum {
	NODE_ACCESS_CLASS_GENPORT_SINK_LOCAL = 2,
	NODE_ACCESS_CLASS_GENPORT_SINK_CPU = 3,
	NODE_ACCESS_CLASS_MAX = 4,
};

enum {
	NO_USER_KERNEL = 0,
	NO_USER_USER = 1,
	NO_GUEST_HOST = 2,
	NO_GUEST_GUEST = 3,
	NO_CROSS_THREAD = 4,
	NR_VECTOR_PARAMS = 5,
};

enum {
	NSMPROC_NULL = 0,
	NSMPROC_STAT = 1,
	NSMPROC_MON = 2,
	NSMPROC_UNMON = 3,
	NSMPROC_UNMON_ALL = 4,
	NSMPROC_SIMU_CRASH = 5,
	NSMPROC_NOTIFY = 6,
};

enum {
	NUM_TRIAL_SAMPLES = 8192,
	MAX_SAMPLES_PER_BIT = 16,
};

enum {
	NVMEM_ADD = 1,
	NVMEM_REMOVE = 2,
	NVMEM_CELL_ADD = 3,
	NVMEM_CELL_REMOVE = 4,
	NVMEM_LAYOUT_ADD = 5,
	NVMEM_LAYOUT_REMOVE = 6,
};

enum {
	NVME_AEN_CFG_NS_ATTR = 256,
	NVME_AEN_CFG_FW_ACT = 512,
	NVME_AEN_CFG_ANA_CHANGE = 2048,
	NVME_AEN_CFG_DISC_CHANGE = -2147483648,
};

enum {
	NVME_AER_ERROR = 0,
	NVME_AER_SMART = 1,
	NVME_AER_NOTICE = 2,
	NVME_AER_CSS = 6,
	NVME_AER_VS = 7,
};

enum {
	NVME_AER_ERROR_PERSIST_INT_ERR = 3,
};

enum {
	NVME_AER_NOTICE_NS_CHANGED = 0,
	NVME_AER_NOTICE_FW_ACT_STARTING = 1,
	NVME_AER_NOTICE_ANA = 3,
	NVME_AER_NOTICE_DISC_CHANGED = 240,
};

enum {
	NVME_CAP_CRMS_CRWMS = 576460752303423488ULL,
	NVME_CAP_CRMS_CRIMS = 1152921504606846976ULL,
};

enum {
	NVME_CAP_CSS_NVM = 1,
	NVME_CAP_CSS_CSI = 64,
};

enum {
	NVME_CC_ENABLE = 1,
	NVME_CC_EN_SHIFT = 0,
	NVME_CC_CSS_SHIFT = 4,
	NVME_CC_CSS_MASK = 112,
	NVME_CC_CSS_NVM = 0,
	NVME_CC_CSS_CSI = 96,
	NVME_CC_MPS_SHIFT = 7,
	NVME_CC_MPS_MASK = 1920,
	NVME_CC_AMS_SHIFT = 11,
	NVME_CC_AMS_MASK = 14336,
	NVME_CC_AMS_RR = 0,
	NVME_CC_AMS_WRRU = 2048,
	NVME_CC_AMS_VS = 14336,
	NVME_CC_SHN_SHIFT = 14,
	NVME_CC_SHN_MASK = 49152,
	NVME_CC_SHN_NONE = 0,
	NVME_CC_SHN_NORMAL = 16384,
	NVME_CC_SHN_ABRUPT = 32768,
	NVME_CC_IOSQES_SHIFT = 16,
	NVME_CC_IOSQES_MASK = 983040,
	NVME_CC_IOSQES = 393216,
	NVME_CC_IOCQES_SHIFT = 20,
	NVME_CC_IOCQES_MASK = 15728640,
	NVME_CC_IOCQES = 4194304,
	NVME_CC_CRIME = 16777216,
};

enum {
	NVME_CMBMSC_CRE = 1,
	NVME_CMBMSC_CMSE = 2,
};

enum {
	NVME_CMBSZ_SQS = 1,
	NVME_CMBSZ_CQS = 2,
	NVME_CMBSZ_LISTS = 4,
	NVME_CMBSZ_RDS = 8,
	NVME_CMBSZ_WDS = 16,
	NVME_CMBSZ_SZ_SHIFT = 12,
	NVME_CMBSZ_SZ_MASK = 1048575,
	NVME_CMBSZ_SZU_SHIFT = 8,
	NVME_CMBSZ_SZU_MASK = 15,
};

enum {
	NVME_CMD_EFFECTS_CSUPP = 1,
	NVME_CMD_EFFECTS_LBCC = 2,
	NVME_CMD_EFFECTS_NCC = 4,
	NVME_CMD_EFFECTS_NIC = 8,
	NVME_CMD_EFFECTS_CCC = 16,
	NVME_CMD_EFFECTS_CSER_MASK = 49152,
	NVME_CMD_EFFECTS_CSE_MASK = 458752,
	NVME_CMD_EFFECTS_UUID_SEL = 524288,
	NVME_CMD_EFFECTS_SCOPE_MASK = 4293918720,
};

enum {
	NVME_CMD_FUSE_FIRST = 1,
	NVME_CMD_FUSE_SECOND = 2,
	NVME_CMD_SGL_METABUF = 64,
	NVME_CMD_SGL_METASEG = 128,
	NVME_CMD_SGL_ALL = 192,
};

enum {
	NVME_CSI_NVM = 0,
	NVME_CSI_ZNS = 2,
};

enum {
	NVME_CSTS_RDY = 1,
	NVME_CSTS_CFS = 2,
	NVME_CSTS_NSSRO = 16,
	NVME_CSTS_PP = 32,
	NVME_CSTS_SHST_NORMAL = 0,
	NVME_CSTS_SHST_OCCUR = 4,
	NVME_CSTS_SHST_CMPLT = 8,
	NVME_CSTS_SHST_MASK = 12,
};

enum {
	NVME_CTRL_CMIC_MULTI_PORT = 1,
	NVME_CTRL_CMIC_MULTI_CTRL = 2,
	NVME_CTRL_CMIC_ANA = 8,
	NVME_CTRL_ONCS_COMPARE = 1,
	NVME_CTRL_ONCS_WRITE_UNCORRECTABLE = 2,
	NVME_CTRL_ONCS_DSM = 4,
	NVME_CTRL_ONCS_WRITE_ZEROES = 8,
	NVME_CTRL_ONCS_RESERVATIONS = 32,
	NVME_CTRL_ONCS_TIMESTAMP = 64,
	NVME_CTRL_VWC_PRESENT = 1,
	NVME_CTRL_OACS_SEC_SUPP = 1,
	NVME_CTRL_OACS_NS_MNGT_SUPP = 8,
	NVME_CTRL_OACS_DIRECTIVES = 32,
	NVME_CTRL_OACS_DBBUF_SUPP = 256,
	NVME_CTRL_LPA_CMD_EFFECTS_LOG = 2,
	NVME_CTRL_CTRATT_128_ID = 1,
	NVME_CTRL_CTRATT_NON_OP_PSP = 2,
	NVME_CTRL_CTRATT_NVM_SETS = 4,
	NVME_CTRL_CTRATT_READ_RECV_LVLS = 8,
	NVME_CTRL_CTRATT_ENDURANCE_GROUPS = 16,
	NVME_CTRL_CTRATT_PREDICTABLE_LAT = 32,
	NVME_CTRL_CTRATT_NAMESPACE_GRANULARITY = 128,
	NVME_CTRL_CTRATT_UUID_LIST = 512,
	NVME_CTRL_SGLS_BYTE_ALIGNED = 1,
	NVME_CTRL_SGLS_DWORD_ALIGNED = 2,
	NVME_CTRL_SGLS_KSDBDS = 4,
	NVME_CTRL_SGLS_MSDS = 524288,
	NVME_CTRL_SGLS_SAOS = 1048576,
};

enum {
	NVME_DSMGMT_IDR = 1,
	NVME_DSMGMT_IDW = 2,
	NVME_DSMGMT_AD = 4,
};

enum {
	NVME_ENABLE_ACRE = 1,
	NVME_ENABLE_LBAFEE = 1,
};

enum {
	NVME_HOST_MEM_ENABLE = 1,
	NVME_HOST_MEM_RETURN = 2,
};

enum {
	NVME_ID_CNS_NS = 0,
	NVME_ID_CNS_CTRL = 1,
	NVME_ID_CNS_NS_ACTIVE_LIST = 2,
	NVME_ID_CNS_NS_DESC_LIST = 3,
	NVME_ID_CNS_CS_NS = 5,
	NVME_ID_CNS_CS_CTRL = 6,
	NVME_ID_CNS_NS_ACTIVE_LIST_CS = 7,
	NVME_ID_CNS_NS_CS_INDEP = 8,
	NVME_ID_CNS_NS_PRESENT_LIST = 16,
	NVME_ID_CNS_NS_PRESENT = 17,
	NVME_ID_CNS_CTRL_NS_LIST = 18,
	NVME_ID_CNS_CTRL_LIST = 19,
	NVME_ID_CNS_SCNDRY_CTRL_LIST = 21,
	NVME_ID_CNS_NS_GRANULARITY = 22,
	NVME_ID_CNS_UUID_LIST = 23,
	NVME_ID_CNS_ENDGRP_LIST = 25,
};

enum {
	NVME_ID_NS_NVM_STS_MASK = 127,
	NVME_ID_NS_NVM_GUARD_SHIFT = 7,
	NVME_ID_NS_NVM_GUARD_MASK = 3,
	NVME_ID_NS_NVM_QPIF_SHIFT = 9,
	NVME_ID_NS_NVM_QPIF_MASK = 15,
	NVME_ID_NS_NVM_QPIFS = 8,
};

enum {
	NVME_IOCTL_VEC = 1,
	NVME_IOCTL_PARTITION = 2,
};

enum {
	NVME_IO_MGMT_RECV_MO_RUHS = 1,
};

enum {
	NVME_NIDT_EUI64 = 1,
	NVME_NIDT_NGUID = 2,
	NVME_NIDT_UUID = 3,
	NVME_NIDT_CSI = 4,
};

enum {
	NVME_NSTAT_NRDY = 1,
};

enum {
	NVME_NS_FEAT_THIN = 1,
	NVME_NS_FEAT_ATOMICS = 2,
	NVME_NS_FEAT_IO_OPT = 16,
	NVME_NS_ATTR_RO = 1,
	NVME_NS_FLBAS_LBA_MASK = 15,
	NVME_NS_FLBAS_LBA_UMASK = 96,
	NVME_NS_FLBAS_LBA_SHIFT = 1,
	NVME_NS_FLBAS_META_EXT = 16,
	NVME_NS_NMIC_SHARED = 1,
	NVME_NS_ROTATIONAL = 16,
	NVME_NS_VWC_NOT_PRESENT = 32,
	NVME_LBAF_RP_BEST = 0,
	NVME_LBAF_RP_BETTER = 1,
	NVME_LBAF_RP_GOOD = 2,
	NVME_LBAF_RP_DEGRADED = 3,
	NVME_NS_DPC_PI_LAST = 16,
	NVME_NS_DPC_PI_FIRST = 8,
	NVME_NS_DPC_PI_TYPE3 = 4,
	NVME_NS_DPC_PI_TYPE2 = 2,
	NVME_NS_DPC_PI_TYPE1 = 1,
	NVME_NS_DPS_PI_FIRST = 8,
	NVME_NS_DPS_PI_MASK = 7,
	NVME_NS_DPS_PI_TYPE1 = 1,
	NVME_NS_DPS_PI_TYPE2 = 2,
	NVME_NS_DPS_PI_TYPE3 = 3,
};

enum {
	NVME_NVM_NS_16B_GUARD = 0,
	NVME_NVM_NS_32B_GUARD = 1,
	NVME_NVM_NS_64B_GUARD = 2,
	NVME_NVM_NS_QTYPE_GUARD = 3,
};

enum {
	NVME_PS_FLAGS_MAX_POWER_SCALE = 1,
	NVME_PS_FLAGS_NON_OP_STATE = 2,
};

enum {
	NVME_QUEUE_PHYS_CONTIG = 1,
	NVME_CQ_IRQ_ENABLED = 2,
	NVME_SQ_PRIO_URGENT = 0,
	NVME_SQ_PRIO_HIGH = 2,
	NVME_SQ_PRIO_MEDIUM = 4,
	NVME_SQ_PRIO_LOW = 6,
	NVME_FEAT_ARBITRATION = 1,
	NVME_FEAT_POWER_MGMT = 2,
	NVME_FEAT_LBA_RANGE = 3,
	NVME_FEAT_TEMP_THRESH = 4,
	NVME_FEAT_ERR_RECOVERY = 5,
	NVME_FEAT_VOLATILE_WC = 6,
	NVME_FEAT_NUM_QUEUES = 7,
	NVME_FEAT_IRQ_COALESCE = 8,
	NVME_FEAT_IRQ_CONFIG = 9,
	NVME_FEAT_WRITE_ATOMIC = 10,
	NVME_FEAT_ASYNC_EVENT = 11,
	NVME_FEAT_AUTO_PST = 12,
	NVME_FEAT_HOST_MEM_BUF = 13,
	NVME_FEAT_TIMESTAMP = 14,
	NVME_FEAT_KATO = 15,
	NVME_FEAT_HCTM = 16,
	NVME_FEAT_NOPSC = 17,
	NVME_FEAT_RRL = 18,
	NVME_FEAT_PLM_CONFIG = 19,
	NVME_FEAT_PLM_WINDOW = 20,
	NVME_FEAT_HOST_BEHAVIOR = 22,
	NVME_FEAT_SANITIZE = 23,
	NVME_FEAT_FDP = 29,
	NVME_FEAT_SW_PROGRESS = 128,
	NVME_FEAT_HOST_ID = 129,
	NVME_FEAT_RESV_MASK = 130,
	NVME_FEAT_RESV_PERSIST = 131,
	NVME_FEAT_WRITE_PROTECT = 132,
	NVME_FEAT_VENDOR_START = 192,
	NVME_FEAT_VENDOR_END = 255,
	NVME_LOG_SUPPORTED = 0,
	NVME_LOG_ERROR = 1,
	NVME_LOG_SMART = 2,
	NVME_LOG_FW_SLOT = 3,
	NVME_LOG_CHANGED_NS = 4,
	NVME_LOG_CMD_EFFECTS = 5,
	NVME_LOG_DEVICE_SELF_TEST = 6,
	NVME_LOG_TELEMETRY_HOST = 7,
	NVME_LOG_TELEMETRY_CTRL = 8,
	NVME_LOG_ENDURANCE_GROUP = 9,
	NVME_LOG_ANA = 12,
	NVME_LOG_FEATURES = 18,
	NVME_LOG_RMI = 22,
	NVME_LOG_FDP_CONFIGS = 32,
	NVME_LOG_DISC = 112,
	NVME_LOG_RESERVATION = 128,
	NVME_FWACT_REPL = 0,
	NVME_FWACT_REPL_ACTV = 8,
	NVME_FWACT_ACTV = 16,
};

enum {
	NVME_REG_CAP = 0,
	NVME_REG_VS = 8,
	NVME_REG_INTMS = 12,
	NVME_REG_INTMC = 16,
	NVME_REG_CC = 20,
	NVME_REG_CSTS = 28,
	NVME_REG_NSSR = 32,
	NVME_REG_AQA = 36,
	NVME_REG_ASQ = 40,
	NVME_REG_ACQ = 48,
	NVME_REG_CMBLOC = 56,
	NVME_REG_CMBSZ = 60,
	NVME_REG_BPINFO = 64,
	NVME_REG_BPRSEL = 68,
	NVME_REG_BPMBL = 72,
	NVME_REG_CMBMSC = 80,
	NVME_REG_CRTO = 104,
	NVME_REG_PMRCAP = 3584,
	NVME_REG_PMRCTL = 3588,
	NVME_REG_PMRSTS = 3592,
	NVME_REG_PMREBS = 3596,
	NVME_REG_PMRSWTP = 3600,
	NVME_REG_DBS = 4096,
};

enum {
	NVME_REQ_CANCELLED = 1,
	NVME_REQ_USERCMD = 2,
	NVME_MPATH_IO_STATS = 4,
	NVME_MPATH_CNT_ACTIVE = 8,
};

enum {
	NVME_RW_LR = 32768,
	NVME_RW_FUA = 16384,
	NVME_RW_APPEND_PIREMAP = 512,
	NVME_RW_DSM_FREQ_UNSPEC = 0,
	NVME_RW_DSM_FREQ_TYPICAL = 1,
	NVME_RW_DSM_FREQ_RARE = 2,
	NVME_RW_DSM_FREQ_READS = 3,
	NVME_RW_DSM_FREQ_WRITES = 4,
	NVME_RW_DSM_FREQ_RW = 5,
	NVME_RW_DSM_FREQ_ONCE = 6,
	NVME_RW_DSM_FREQ_PREFETCH = 7,
	NVME_RW_DSM_FREQ_TEMP = 8,
	NVME_RW_DSM_LATENCY_NONE = 0,
	NVME_RW_DSM_LATENCY_IDLE = 16,
	NVME_RW_DSM_LATENCY_NORM = 32,
	NVME_RW_DSM_LATENCY_LOW = 48,
	NVME_RW_DSM_SEQ_REQ = 64,
	NVME_RW_DSM_COMPRESSED = 128,
	NVME_RW_PRINFO_PRCHK_REF = 1024,
	NVME_RW_PRINFO_PRCHK_APP = 2048,
	NVME_RW_PRINFO_PRCHK_GUARD = 4096,
	NVME_RW_PRINFO_PRACT = 8192,
	NVME_RW_DTYPE_STREAMS = 16,
	NVME_RW_DTYPE_DPLCMT = 32,
	NVME_WZ_DEAC = 512,
};

enum {
	NVME_SCT_GENERIC = 0,
	NVME_SC_SUCCESS = 0,
	NVME_SC_INVALID_OPCODE = 1,
	NVME_SC_INVALID_FIELD = 2,
	NVME_SC_CMDID_CONFLICT = 3,
	NVME_SC_DATA_XFER_ERROR = 4,
	NVME_SC_POWER_LOSS = 5,
	NVME_SC_INTERNAL = 6,
	NVME_SC_ABORT_REQ = 7,
	NVME_SC_ABORT_QUEUE = 8,
	NVME_SC_FUSED_FAIL = 9,
	NVME_SC_FUSED_MISSING = 10,
	NVME_SC_INVALID_NS = 11,
	NVME_SC_CMD_SEQ_ERROR = 12,
	NVME_SC_SGL_INVALID_LAST = 13,
	NVME_SC_SGL_INVALID_COUNT = 14,
	NVME_SC_SGL_INVALID_DATA = 15,
	NVME_SC_SGL_INVALID_METADATA = 16,
	NVME_SC_SGL_INVALID_TYPE = 17,
	NVME_SC_CMB_INVALID_USE = 18,
	NVME_SC_PRP_INVALID_OFFSET = 19,
	NVME_SC_ATOMIC_WU_EXCEEDED = 20,
	NVME_SC_OP_DENIED = 21,
	NVME_SC_SGL_INVALID_OFFSET = 22,
	NVME_SC_RESERVED = 23,
	NVME_SC_HOST_ID_INCONSIST = 24,
	NVME_SC_KA_TIMEOUT_EXPIRED = 25,
	NVME_SC_KA_TIMEOUT_INVALID = 26,
	NVME_SC_ABORTED_PREEMPT_ABORT = 27,
	NVME_SC_SANITIZE_FAILED = 28,
	NVME_SC_SANITIZE_IN_PROGRESS = 29,
	NVME_SC_SGL_INVALID_GRANULARITY = 30,
	NVME_SC_CMD_NOT_SUP_CMB_QUEUE = 31,
	NVME_SC_NS_WRITE_PROTECTED = 32,
	NVME_SC_CMD_INTERRUPTED = 33,
	NVME_SC_TRANSIENT_TR_ERR = 34,
	NVME_SC_ADMIN_COMMAND_MEDIA_NOT_READY = 36,
	NVME_SC_INVALID_IO_CMD_SET = 44,
	NVME_SC_LBA_RANGE = 128,
	NVME_SC_CAP_EXCEEDED = 129,
	NVME_SC_NS_NOT_READY = 130,
	NVME_SC_RESERVATION_CONFLICT = 131,
	NVME_SC_FORMAT_IN_PROGRESS = 132,
	NVME_SCT_COMMAND_SPECIFIC = 256,
	NVME_SC_CQ_INVALID = 256,
	NVME_SC_QID_INVALID = 257,
	NVME_SC_QUEUE_SIZE = 258,
	NVME_SC_ABORT_LIMIT = 259,
	NVME_SC_ABORT_MISSING = 260,
	NVME_SC_ASYNC_LIMIT = 261,
	NVME_SC_FIRMWARE_SLOT = 262,
	NVME_SC_FIRMWARE_IMAGE = 263,
	NVME_SC_INVALID_VECTOR = 264,
	NVME_SC_INVALID_LOG_PAGE = 265,
	NVME_SC_INVALID_FORMAT = 266,
	NVME_SC_FW_NEEDS_CONV_RESET = 267,
	NVME_SC_INVALID_QUEUE = 268,
	NVME_SC_FEATURE_NOT_SAVEABLE = 269,
	NVME_SC_FEATURE_NOT_CHANGEABLE = 270,
	NVME_SC_FEATURE_NOT_PER_NS = 271,
	NVME_SC_FW_NEEDS_SUBSYS_RESET = 272,
	NVME_SC_FW_NEEDS_RESET = 273,
	NVME_SC_FW_NEEDS_MAX_TIME = 274,
	NVME_SC_FW_ACTIVATE_PROHIBITED = 275,
	NVME_SC_OVERLAPPING_RANGE = 276,
	NVME_SC_NS_INSUFFICIENT_CAP = 277,
	NVME_SC_NS_ID_UNAVAILABLE = 278,
	NVME_SC_NS_ALREADY_ATTACHED = 280,
	NVME_SC_NS_IS_PRIVATE = 281,
	NVME_SC_NS_NOT_ATTACHED = 282,
	NVME_SC_THIN_PROV_NOT_SUPP = 283,
	NVME_SC_CTRL_LIST_INVALID = 284,
	NVME_SC_SELF_TEST_IN_PROGRESS = 285,
	NVME_SC_BP_WRITE_PROHIBITED = 286,
	NVME_SC_CTRL_ID_INVALID = 287,
	NVME_SC_SEC_CTRL_STATE_INVALID = 288,
	NVME_SC_CTRL_RES_NUM_INVALID = 289,
	NVME_SC_RES_ID_INVALID = 290,
	NVME_SC_PMR_SAN_PROHIBITED = 291,
	NVME_SC_ANA_GROUP_ID_INVALID = 292,
	NVME_SC_ANA_ATTACH_FAILED = 293,
	NVME_SC_BAD_ATTRIBUTES = 384,
	NVME_SC_INVALID_PI = 385,
	NVME_SC_READ_ONLY = 386,
	NVME_SC_CMD_SIZE_LIM_EXCEEDED = 387,
	NVME_SC_CONNECT_FORMAT = 384,
	NVME_SC_CONNECT_CTRL_BUSY = 385,
	NVME_SC_CONNECT_INVALID_PARAM = 386,
	NVME_SC_CONNECT_RESTART_DISC = 387,
	NVME_SC_CONNECT_INVALID_HOST = 388,
	NVME_SC_DISCOVERY_RESTART = 400,
	NVME_SC_AUTH_REQUIRED = 401,
	NVME_SC_ZONE_BOUNDARY_ERROR = 440,
	NVME_SC_ZONE_FULL = 441,
	NVME_SC_ZONE_READ_ONLY = 442,
	NVME_SC_ZONE_OFFLINE = 443,
	NVME_SC_ZONE_INVALID_WRITE = 444,
	NVME_SC_ZONE_TOO_MANY_ACTIVE = 445,
	NVME_SC_ZONE_TOO_MANY_OPEN = 446,
	NVME_SC_ZONE_INVALID_TRANSITION = 447,
	NVME_SCT_MEDIA_ERROR = 512,
	NVME_SC_WRITE_FAULT = 640,
	NVME_SC_READ_ERROR = 641,
	NVME_SC_GUARD_CHECK = 642,
	NVME_SC_APPTAG_CHECK = 643,
	NVME_SC_REFTAG_CHECK = 644,
	NVME_SC_COMPARE_FAILED = 645,
	NVME_SC_ACCESS_DENIED = 646,
	NVME_SC_UNWRITTEN_BLOCK = 647,
	NVME_SCT_PATH = 768,
	NVME_SC_INTERNAL_PATH_ERROR = 768,
	NVME_SC_ANA_PERSISTENT_LOSS = 769,
	NVME_SC_ANA_INACCESSIBLE = 770,
	NVME_SC_ANA_TRANSITION = 771,
	NVME_SC_CTRL_PATH_ERROR = 864,
	NVME_SC_HOST_PATH_ERROR = 880,
	NVME_SC_HOST_ABORTED_CMD = 881,
	NVME_SC_MASK = 255,
	NVME_SCT_MASK = 1792,
	NVME_SCT_SC_MASK = 2047,
	NVME_STATUS_CRD = 6144,
	NVME_STATUS_MORE = 8192,
	NVME_STATUS_DNR = 16384,
};

enum {
	NVME_SGL_FMT_DATA_DESC = 0,
	NVME_SGL_FMT_SEG_DESC = 2,
	NVME_SGL_FMT_LAST_SEG_DESC = 3,
	NVME_KEY_SGL_FMT_DATA_DESC = 4,
	NVME_TRANSPORT_SGL_DATA_DESC = 5,
};

enum {
	NVME_SUBMIT_AT_HEAD = 1,
	NVME_SUBMIT_NOWAIT = 2,
	NVME_SUBMIT_RESERVED = 4,
	NVME_SUBMIT_RETRY = 8,
};

enum {
	OD_NORMAL_SAMPLE = 0,
	OD_SUB_SAMPLE = 1,
};

enum {
	OMAP_I2C_REV_REG = 0,
	OMAP_I2C_IE_REG = 1,
	OMAP_I2C_STAT_REG = 2,
	OMAP_I2C_IV_REG = 3,
	OMAP_I2C_WE_REG = 4,
	OMAP_I2C_SYSS_REG = 5,
	OMAP_I2C_BUF_REG = 6,
	OMAP_I2C_CNT_REG = 7,
	OMAP_I2C_DATA_REG = 8,
	OMAP_I2C_SYSC_REG = 9,
	OMAP_I2C_CON_REG = 10,
	OMAP_I2C_OA_REG = 11,
	OMAP_I2C_SA_REG = 12,
	OMAP_I2C_PSC_REG = 13,
	OMAP_I2C_SCLL_REG = 14,
	OMAP_I2C_SCLH_REG = 15,
	OMAP_I2C_SYSTEST_REG = 16,
	OMAP_I2C_BUFSTAT_REG = 17,
	OMAP_I2C_IP_V2_REVNB_LO = 18,
	OMAP_I2C_IP_V2_REVNB_HI = 19,
	OMAP_I2C_IP_V2_IRQSTATUS_RAW = 20,
	OMAP_I2C_IP_V2_IRQENABLE_SET = 21,
	OMAP_I2C_IP_V2_IRQENABLE_CLR = 22,
};

enum {
	ONLINE_POLICY_CONTIG_ZONES = 0,
	ONLINE_POLICY_AUTO_MOVABLE = 1,
};

enum {
	OPT_SOURCE = 0,
	OPT_SUBTYPE = 1,
	OPT_FD = 2,
	OPT_ROOTMODE = 3,
	OPT_USER_ID = 4,
	OPT_GROUP_ID = 5,
	OPT_DEFAULT_PERMISSIONS = 6,
	OPT_ALLOW_OTHER = 7,
	OPT_MAX_READ = 8,
	OPT_BLKSIZE = 9,
	OPT_ERR = 10,
};

enum {
	OPT_UID = 0,
	OPT_GID = 1,
	OPT_MODE = 2,
	OPT_DELEGATE_CMDS = 3,
	OPT_DELEGATE_MAPS = 4,
	OPT_DELEGATE_PROGS = 5,
	OPT_DELEGATE_ATTACHS = 6,
};

enum {
	OUTSIDE_GUEST_MODE = 0,
	IN_GUEST_MODE = 1,
	EXITING_GUEST_MODE = 2,
	READING_SHADOW_PAGE_TABLES = 3,
};

enum {
	OVERRIDE_NONE = 0,
	OVERRIDE_BASE = 1,
	OVERRIDE_STRIDE = 2,
	OVERRIDE_HEIGHT = 4,
	OVERRIDE_WIDTH = 8,
};

enum {
	Opt_bsd_df = 0,
	Opt_minix_df = 1,
	Opt_grpid = 2,
	Opt_nogrpid = 3,
	Opt_resgid = 4,
	Opt_resuid = 5,
	Opt_sb = 6,
	Opt_nouid32 = 7,
	Opt_debug = 8,
	Opt_removed = 9,
	Opt_user_xattr = 10,
	Opt_acl = 11,
	Opt_auto_da_alloc = 12,
	Opt_noauto_da_alloc = 13,
	Opt_noload = 14,
	Opt_commit = 15,
	Opt_min_batch_time = 16,
	Opt_max_batch_time = 17,
	Opt_journal_dev = 18,
	Opt_journal_path = 19,
	Opt_journal_checksum = 20,
	Opt_journal_async_commit = 21,
	Opt_abort = 22,
	Opt_data_journal = 23,
	Opt_data_ordered = 24,
	Opt_data_writeback = 25,
	Opt_data_err_abort = 26,
	Opt_data_err_ignore = 27,
	Opt_test_dummy_encryption = 28,
	Opt_inlinecrypt = 29,
	Opt_usrjquota = 30,
	Opt_grpjquota = 31,
	Opt_quota = 32,
	Opt_noquota = 33,
	Opt_barrier = 34,
	Opt_nobarrier = 35,
	Opt_err = 36,
	Opt_usrquota = 37,
	Opt_grpquota = 38,
	Opt_prjquota = 39,
	Opt_dax = 40,
	Opt_dax_always = 41,
	Opt_dax_inode = 42,
	Opt_dax_never = 43,
	Opt_stripe = 44,
	Opt_delalloc = 45,
	Opt_nodelalloc = 46,
	Opt_warn_on_error = 47,
	Opt_nowarn_on_error = 48,
	Opt_mblk_io_submit = 49,
	Opt_debug_want_extra_isize = 50,
	Opt_nomblk_io_submit = 51,
	Opt_block_validity = 52,
	Opt_noblock_validity = 53,
	Opt_inode_readahead_blks = 54,
	Opt_journal_ioprio = 55,
	Opt_dioread_nolock = 56,
	Opt_dioread_lock = 57,
	Opt_discard = 58,
	Opt_nodiscard = 59,
	Opt_init_itable = 60,
	Opt_noinit_itable = 61,
	Opt_max_dir_size_kb = 62,
	Opt_nojournal_checksum = 63,
	Opt_nombcache = 64,
	Opt_no_prefetch_block_bitmaps = 65,
	Opt_mb_optimize_scan = 66,
	Opt_errors = 67,
	Opt_data = 68,
	Opt_data_err = 69,
	Opt_jqfmt = 70,
	Opt_dax_type = 71,
};

enum {
	Opt_check = 0,
	Opt_uid = 1,
	Opt_gid = 2,
	Opt_umask = 3,
	Opt_dmask = 4,
	Opt_fmask = 5,
	Opt_allow_utime = 6,
	Opt_codepage = 7,
	Opt_usefree = 8,
	Opt_nocase = 9,
	Opt_quiet = 10,
	Opt_showexec = 11,
	Opt_debug___2 = 12,
	Opt_immutable = 13,
	Opt_dots = 14,
	Opt_dotsOK = 15,
	Opt_charset = 16,
	Opt_shortname = 17,
	Opt_utf8 = 18,
	Opt_utf8_bool = 19,
	Opt_uni_xl = 20,
	Opt_uni_xl_bool = 21,
	Opt_nonumtail = 22,
	Opt_nonumtail_bool = 23,
	Opt_obsolete = 24,
	Opt_flush = 25,
	Opt_tz = 26,
	Opt_rodir = 27,
	Opt_errors___2 = 28,
	Opt_discard___2 = 29,
	Opt_nfs = 30,
	Opt_nfs_enum = 31,
	Opt_time_offset = 32,
	Opt_dos1xfloppy = 33,
};

enum {
	Opt_debug___3 = 0,
	Opt_dfltuid = 1,
	Opt_dfltgid = 2,
	Opt_afid = 3,
	Opt_uname = 4,
	Opt_remotename = 5,
	Opt_cache = 6,
	Opt_cachetag = 7,
	Opt_nodevmap = 8,
	Opt_noxattr = 9,
	Opt_directio = 10,
	Opt_ignoreqv = 11,
	Opt_access = 12,
	Opt_posixacl = 13,
	Opt_locktimeout = 14,
	Opt_err___2 = 15,
};

enum {
	Opt_direct = 0,
	Opt_fd = 1,
	Opt_gid___2 = 2,
	Opt_ignore = 3,
	Opt_indirect = 4,
	Opt_maxproto = 5,
	Opt_minproto = 6,
	Opt_offset = 7,
	Opt_pgrp = 8,
	Opt_strictexpire = 9,
	Opt_uid___2 = 10,
};

enum {
	Opt_err___3 = 0,
	Opt_enc = 1,
	Opt_hash = 2,
};

enum {
	Opt_fatal_neterrors_default = 0,
	Opt_fatal_neterrors_enetunreach = 1,
	Opt_fatal_neterrors_none = 2,
};

enum {
	Opt_find_uid = 0,
	Opt_find_gid = 1,
	Opt_find_user = 2,
	Opt_find_group = 3,
	Opt_find_err = 4,
};

enum {
	Opt_kmsg_bytes = 0,
};

enum {
	Opt_local_lock_all = 0,
	Opt_local_lock_flock = 1,
	Opt_local_lock_none = 2,
	Opt_local_lock_posix = 3,
};

enum {
	Opt_lookupcache_all = 0,
	Opt_lookupcache_none = 1,
	Opt_lookupcache_positive = 2,
};

enum {
	Opt_msize = 0,
	Opt_trans = 1,
	Opt_legacy = 2,
	Opt_version = 3,
	Opt_err___4 = 4,
};

enum {
	Opt_port = 0,
	Opt_rfdno = 1,
	Opt_wfdno = 2,
	Opt_err___5 = 3,
	Opt_privport = 4,
};

enum {
	Opt_sec_krb5 = 0,
	Opt_sec_krb5i = 1,
	Opt_sec_krb5p = 2,
	Opt_sec_lkey = 3,
	Opt_sec_lkeyi = 4,
	Opt_sec_lkeyp = 5,
	Opt_sec_none = 6,
	Opt_sec_spkm = 7,
	Opt_sec_spkmi = 8,
	Opt_sec_spkmp = 9,
	Opt_sec_sys = 10,
	nr__Opt_sec = 11,
};

enum {
	Opt_uid___3 = 0,
	Opt_gid___3 = 1,
};

enum {
	Opt_uid___4 = 0,
	Opt_gid___4 = 1,
	Opt_mode = 2,
	Opt_source = 3,
};

enum {
	Opt_uid___5 = 0,
	Opt_gid___5 = 1,
	Opt_mode___2 = 2,
	Opt_ptmxmode = 3,
	Opt_newinstance = 4,
	Opt_max = 5,
	Opt_err___6 = 6,
};

enum {
	Opt_vers_2 = 0,
	Opt_vers_3 = 1,
	Opt_vers_4 = 2,
	Opt_vers_4_0 = 3,
	Opt_vers_4_1 = 4,
	Opt_vers_4_2 = 5,
};

enum {
	Opt_write_lazy = 0,
	Opt_write_eager = 1,
	Opt_write_wait = 2,
};

enum {
	Opt_xprt_rdma = 0,
	Opt_xprt_rdma6 = 1,
	Opt_xprt_tcp = 2,
	Opt_xprt_tcp6 = 3,
	Opt_xprt_udp = 4,
	Opt_xprt_udp6 = 5,
	nr__Opt_xprt = 6,
};

enum {
	Opt_xprtsec_none = 0,
	Opt_xprtsec_tls = 1,
	Opt_xprtsec_mtls = 2,
	nr__Opt_xprtsec = 3,
};

enum {
	PAGE_REPORTING_IDLE = 0,
	PAGE_REPORTING_REQUESTED = 1,
	PAGE_REPORTING_ACTIVE = 2,
};

enum {
	PAGE_WAS_MAPPED = 1,
	PAGE_WAS_MLOCKED = 2,
	PAGE_OLD_STATES = 3,
};

enum {
	PARSE_INVALID = 1,
	PARSE_NOT_LONGNAME = 2,
	PARSE_EOF = 3,
};

enum {
	PCA9450_DVS_LEVEL_RUN = 0,
	PCA9450_DVS_LEVEL_STANDBY = 1,
	PCA9450_DVS_LEVEL_MAX = 2,
};

enum {
	PCA9450_REG_DEV_ID = 0,
	PCA9450_REG_INT1 = 1,
	PCA9450_REG_INT1_MSK = 2,
	PCA9450_REG_STATUS1 = 3,
	PCA9450_REG_STATUS2 = 4,
	PCA9450_REG_PWRON_STAT = 5,
	PCA9450_REG_SWRST = 6,
	PCA9450_REG_PWRCTRL = 7,
	PCA9450_REG_RESET_CTRL = 8,
	PCA9450_REG_CONFIG1 = 9,
	PCA9450_REG_CONFIG2 = 10,
	PCA9450_REG_BUCK123_DVS = 12,
	PCA9450_REG_BUCK1OUT_LIMIT = 13,
	PCA9450_REG_BUCK2OUT_LIMIT = 14,
	PCA9450_REG_BUCK3OUT_LIMIT = 15,
	PCA9450_REG_BUCK1CTRL = 16,
	PCA9450_REG_BUCK1OUT_DVS0 = 17,
	PCA9450_REG_BUCK1OUT_DVS1 = 18,
	PCA9450_REG_BUCK2CTRL = 19,
	PCA9450_REG_BUCK2OUT_DVS0 = 20,
	PCA9450_REG_BUCK2OUT_DVS1 = 21,
	PCA9450_REG_BUCK3CTRL = 22,
	PCA9450_REG_BUCK3OUT_DVS0 = 23,
	PCA9450_REG_BUCK3OUT_DVS1 = 24,
	PCA9450_REG_BUCK4CTRL = 25,
	PCA9450_REG_BUCK4OUT = 26,
	PCA9450_REG_BUCK5CTRL = 27,
	PCA9450_REG_BUCK5OUT = 28,
	PCA9450_REG_BUCK6CTRL = 29,
	PCA9450_REG_BUCK6OUT = 30,
	PCA9450_REG_LDO_AD_CTRL = 32,
	PCA9450_REG_LDO1CTRL = 33,
	PCA9450_REG_LDO2CTRL = 34,
	PCA9450_REG_LDO3CTRL = 35,
	PCA9450_REG_LDO4CTRL = 36,
	PCA9450_REG_LDO5CTRL_L = 37,
	PCA9450_REG_LDO5CTRL_H = 38,
	PCA9450_REG_LOADSW_CTRL = 42,
	PCA9450_REG_VRFLT1_STS = 43,
	PCA9450_REG_VRFLT2_STS = 44,
	PCA9450_REG_VRFLT1_MASK = 45,
	PCA9450_REG_VRFLT2_MASK = 46,
	PCA9450_MAX_REGISTER = 47,
};

enum {
	PCI_BRIDGE_EMUL_NO_PREFMEM_FORWARD = 1,
	PCI_BRIDGE_EMUL_NO_IO_FORWARD = 2,
};

enum {
	PCI_DEV_REG1 = 64,
	PCI_DEV_REG2 = 68,
	PCI_DEV_STATUS = 124,
	PCI_DEV_REG3 = 128,
	PCI_DEV_REG4 = 132,
	PCI_DEV_REG5 = 136,
	PCI_CFG_REG_0 = 144,
	PCI_CFG_REG_1 = 148,
	PSM_CONFIG_REG0 = 152,
	PSM_CONFIG_REG1 = 156,
	PSM_CONFIG_REG2 = 352,
	PSM_CONFIG_REG3 = 356,
	PSM_CONFIG_REG4 = 360,
	PCI_LDO_CTRL = 188,
};

enum {
	PCI_REASSIGN_ALL_RSRC = 1,
	PCI_REASSIGN_ALL_BUS = 2,
	PCI_PROBE_ONLY = 4,
	PCI_CAN_SKIP_ISA_ALIGN = 8,
	PCI_ENABLE_PROC_DOMAINS = 16,
	PCI_COMPAT_DOMAIN_0 = 32,
	PCI_SCAN_ALL_PCIE_DEVS = 64,
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_IOV_RESOURCES = 7,
	PCI_IOV_RESOURCE_END = 12,
	PCI_BRIDGE_RESOURCES = 13,
	PCI_BRIDGE_RESOURCE_END = 16,
	PCI_NUM_RESOURCES = 17,
	DEVICE_COUNT_RESOURCE = 17,
};

enum {
	PC_VAUX_ENA = 128,
	PC_VAUX_DIS = 64,
	PC_VCC_ENA = 32,
	PC_VCC_DIS = 16,
	PC_VAUX_ON = 8,
	PC_VAUX_OFF = 4,
	PC_VCC_ON = 2,
	PC_VCC_OFF = 1,
};

enum {
	PERCPU_REF_INIT_ATOMIC = 1,
	PERCPU_REF_INIT_DEAD = 2,
	PERCPU_REF_ALLOW_REINIT = 4,
};

enum {
	PERF_BR_NEW_FAULT_ALGN = 0,
	PERF_BR_NEW_FAULT_DATA = 1,
	PERF_BR_NEW_FAULT_INST = 2,
	PERF_BR_NEW_ARCH_1 = 3,
	PERF_BR_NEW_ARCH_2 = 4,
	PERF_BR_NEW_ARCH_3 = 5,
	PERF_BR_NEW_ARCH_4 = 6,
	PERF_BR_NEW_ARCH_5 = 7,
	PERF_BR_NEW_MAX = 8,
};

enum {
	PERF_BR_PRIV_UNKNOWN = 0,
	PERF_BR_PRIV_USER = 1,
	PERF_BR_PRIV_KERNEL = 2,
	PERF_BR_PRIV_HV = 3,
};

enum {
	PERF_BR_SPEC_NA = 0,
	PERF_BR_SPEC_WRONG_PATH = 1,
	PERF_BR_NON_SPEC_CORRECT_PATH = 2,
	PERF_BR_SPEC_CORRECT_PATH = 3,
	PERF_BR_SPEC_MAX = 4,
};

enum {
	PERF_BR_UNKNOWN = 0,
	PERF_BR_COND = 1,
	PERF_BR_UNCOND = 2,
	PERF_BR_IND = 3,
	PERF_BR_CALL = 4,
	PERF_BR_IND_CALL = 5,
	PERF_BR_RET = 6,
	PERF_BR_SYSCALL = 7,
	PERF_BR_SYSRET = 8,
	PERF_BR_COND_CALL = 9,
	PERF_BR_COND_RET = 10,
	PERF_BR_ERET = 11,
	PERF_BR_IRQ = 12,
	PERF_BR_SERROR = 13,
	PERF_BR_NO_TX = 14,
	PERF_BR_EXTEND_ABI = 15,
	PERF_BR_MAX = 16,
};

enum {
	PERF_FC_LEVEL = 0,
	PERF_FC_LIMIT = 1,
	PERF_FC_MAX = 2,
};

enum {
	PER_LINUX = 0,
	PER_LINUX_32BIT = 8388608,
	PER_LINUX_FDPIC = 524288,
	PER_SVR4 = 68157441,
	PER_SVR3 = 83886082,
	PER_SCOSVR3 = 117440515,
	PER_OSR5 = 100663299,
	PER_WYSEV386 = 83886084,
	PER_ISCR4 = 67108869,
	PER_BSD = 6,
	PER_SUNOS = 67108870,
	PER_XENIX = 83886087,
	PER_LINUX32 = 8,
	PER_LINUX32_3GB = 134217736,
	PER_IRIX32 = 67108873,
	PER_IRIXN32 = 67108874,
	PER_IRIX64 = 67108875,
	PER_RISCOS = 12,
	PER_SOLARIS = 67108877,
	PER_UW7 = 68157454,
	PER_OSF4 = 15,
	PER_HPUX = 16,
	PER_MASK = 255,
};

enum {
	PEX_RD_ACCESS = -2147483648,
	PEX_DB_ACCESS = 1073741824,
};

enum {
	PG_BUSY = 0,
	PG_MAPPED = 1,
	PG_FOLIO = 2,
	PG_CLEAN = 3,
	PG_COMMIT_TO_DS = 4,
	PG_INODE_REF = 5,
	PG_HEADLOCK = 6,
	PG_TEARDOWN = 7,
	PG_UNLOCKPAGE = 8,
	PG_UPTODATE = 9,
	PG_WB_END = 10,
	PG_REMOVE = 11,
	PG_CONTENDED1 = 12,
	PG_CONTENDED2 = 13,
};

enum {
	PHYLINK_DISABLE_STOPPED = 0,
	PHYLINK_DISABLE_LINK = 1,
	PHYLINK_DISABLE_MAC_WOL = 2,
	PCS_STATE_DOWN = 0,
	PCS_STATE_STARTING = 1,
	PCS_STATE_STARTED = 2,
};

enum {
	PHY_ADDR_MARV = 0,
};

enum {
	PHY_AN_NXT_PG = 32768,
	PHY_AN_ACK = 16384,
	PHY_AN_RF = 8192,
	PHY_AN_PAUSE_ASYM = 2048,
	PHY_AN_PAUSE_CAP = 1024,
	PHY_AN_100BASE4 = 512,
	PHY_AN_100FULL = 256,
	PHY_AN_100HALF = 128,
	PHY_AN_10FULL = 64,
	PHY_AN_10HALF = 32,
	PHY_AN_CSMA = 1,
	PHY_AN_SEL = 31,
	PHY_AN_FULL = 321,
	PHY_AN_ALL = 480,
};

enum {
	PHY_CT_RESET = 32768,
	PHY_CT_LOOP = 16384,
	PHY_CT_SPS_LSB = 8192,
	PHY_CT_ANE = 4096,
	PHY_CT_PDOWN = 2048,
	PHY_CT_ISOL = 1024,
	PHY_CT_RE_CFG = 512,
	PHY_CT_DUP_MD = 256,
	PHY_CT_COL_TST = 128,
	PHY_CT_SPS_MSB = 64,
};

enum {
	PHY_CT_SP1000 = 64,
	PHY_CT_SP100 = 8192,
	PHY_CT_SP10 = 0,
};

enum {
	PHY_GMII_SEL_PORT_MODE = 0,
	PHY_GMII_SEL_RGMII_ID_MODE = 1,
	PHY_GMII_SEL_RMII_IO_CLK_EN = 2,
	PHY_GMII_SEL_FIXED_TX_DELAY = 3,
	PHY_GMII_SEL_LAST = 4,
};

enum {
	PHY_MARV_CTRL = 0,
	PHY_MARV_STAT = 1,
	PHY_MARV_ID0 = 2,
	PHY_MARV_ID1 = 3,
	PHY_MARV_AUNE_ADV = 4,
	PHY_MARV_AUNE_LP = 5,
	PHY_MARV_AUNE_EXP = 6,
	PHY_MARV_NEPG = 7,
	PHY_MARV_NEPG_LP = 8,
	PHY_MARV_1000T_CTRL = 9,
	PHY_MARV_1000T_STAT = 10,
	PHY_MARV_EXT_STAT = 15,
	PHY_MARV_PHY_CTRL = 16,
	PHY_MARV_PHY_STAT = 17,
	PHY_MARV_INT_MASK = 18,
	PHY_MARV_INT_STAT = 19,
	PHY_MARV_EXT_CTRL = 20,
	PHY_MARV_RXE_CNT = 21,
	PHY_MARV_EXT_ADR = 22,
	PHY_MARV_PORT_IRQ = 23,
	PHY_MARV_LED_CTRL = 24,
	PHY_MARV_LED_OVER = 25,
	PHY_MARV_EXT_CTRL_2 = 26,
	PHY_MARV_EXT_P_STAT = 27,
	PHY_MARV_CABLE_DIAG = 28,
	PHY_MARV_PAGE_ADDR = 29,
	PHY_MARV_PAGE_DATA = 30,
	PHY_MARV_FE_LED_PAR = 22,
	PHY_MARV_FE_LED_SER = 23,
	PHY_MARV_FE_VCT_TX = 26,
	PHY_MARV_FE_VCT_RX = 27,
	PHY_MARV_FE_SPEC_2 = 28,
};

enum {
	PHY_MARV_ID0_VAL = 321,
	PHY_BCOM_ID1_A1 = 24641,
	PHY_BCOM_ID1_B2 = 24643,
	PHY_BCOM_ID1_C0 = 24644,
	PHY_BCOM_ID1_C5 = 24647,
	PHY_MARV_ID1_B0 = 3107,
	PHY_MARV_ID1_B2 = 3109,
	PHY_MARV_ID1_C2 = 3266,
	PHY_MARV_ID1_Y2 = 3217,
	PHY_MARV_ID1_FE = 3203,
	PHY_MARV_ID1_ECU = 3248,
};

enum {
	PHY_M_1000C_TEST = 57344,
	PHY_M_1000C_MSE = 4096,
	PHY_M_1000C_MSC = 2048,
	PHY_M_1000C_MPD = 1024,
	PHY_M_1000C_AFD = 512,
	PHY_M_1000C_AHD = 256,
};

enum {
	PHY_M_AN_ASP_X = 256,
	PHY_M_AN_PC_X = 128,
	PHY_M_AN_1000X_AHD = 64,
	PHY_M_AN_1000X_AFD = 32,
};

enum {
	PHY_M_AN_NXT_PG = 32768,
	PHY_M_AN_ACK = 16384,
	PHY_M_AN_RF = 8192,
	PHY_M_AN_ASP = 2048,
	PHY_M_AN_PC = 1024,
	PHY_M_AN_100_T4 = 512,
	PHY_M_AN_100_FD = 256,
	PHY_M_AN_100_HD = 128,
	PHY_M_AN_10_FD = 64,
	PHY_M_AN_10_HD = 32,
	PHY_M_AN_SEL_MSK = 496,
};

enum {
	PHY_M_EC_ENA_BC_EXT = 32768,
	PHY_M_EC_ENA_LIN_LB = 16384,
	PHY_M_EC_DIS_LINK_P = 4096,
	PHY_M_EC_M_DSC_MSK = 3072,
	PHY_M_EC_S_DSC_MSK = 768,
	PHY_M_EC_M_DSC_MSK2 = 3584,
	PHY_M_EC_DOWN_S_ENA = 256,
	PHY_M_EC_RX_TIM_CT = 128,
	PHY_M_EC_MAC_S_MSK = 112,
	PHY_M_EC_FIB_AN_ENA = 8,
	PHY_M_EC_DTE_D_ENA = 4,
	PHY_M_EC_TX_TIM_CT = 2,
	PHY_M_EC_TRANS_DIS = 1,
	PHY_M_10B_TE_ENABLE = 128,
};

enum {
	PHY_M_FC_AUTO_SEL = 32768,
	PHY_M_FC_AN_REG_ACC = 16384,
	PHY_M_FC_RESOLUTION = 8192,
	PHY_M_SER_IF_AN_BP = 4096,
	PHY_M_SER_IF_BP_ST = 2048,
	PHY_M_IRQ_POLARITY = 1024,
	PHY_M_DIS_AUT_MED = 512,
	PHY_M_UNDOC1 = 128,
	PHY_M_DTE_POW_STAT = 16,
	PHY_M_MODE_MASK = 15,
};

enum {
	PHY_M_FELP_LED2_MSK = 3840,
	PHY_M_FELP_LED1_MSK = 240,
	PHY_M_FELP_LED0_MSK = 15,
};

enum {
	PHY_M_FESC_DIS_WAIT = 4,
	PHY_M_FESC_ENA_MCLK = 2,
	PHY_M_FESC_SEL_CL_A = 1,
};

enum {
	PHY_M_FIB_FORCE_LNK = 1024,
	PHY_M_FIB_SIGD_POL = 512,
	PHY_M_FIB_TX_DIS = 8,
};

enum {
	PHY_M_IS_AN_ERROR = 32768,
	PHY_M_IS_LSP_CHANGE = 16384,
	PHY_M_IS_DUP_CHANGE = 8192,
	PHY_M_IS_AN_PR = 4096,
	PHY_M_IS_AN_COMPL = 2048,
	PHY_M_IS_LST_CHANGE = 1024,
	PHY_M_IS_SYMB_ERROR = 512,
	PHY_M_IS_FALSE_CARR = 256,
	PHY_M_IS_FIFO_ERROR = 128,
	PHY_M_IS_MDI_CHANGE = 64,
	PHY_M_IS_DOWNSH_DET = 32,
	PHY_M_IS_END_CHANGE = 16,
	PHY_M_IS_DTE_CHANGE = 4,
	PHY_M_IS_POL_CHANGE = 2,
	PHY_M_IS_JABBER = 1,
	PHY_M_DEF_MSK = 25600,
	PHY_M_AN_MSK = 34816,
};

enum {
	PHY_M_LEDC_DIS_LED = 32768,
	PHY_M_LEDC_PULS_MSK = 28672,
	PHY_M_LEDC_F_INT = 2048,
	PHY_M_LEDC_BL_R_MSK = 1792,
	PHY_M_LEDC_DP_C_LSB = 128,
	PHY_M_LEDC_TX_C_LSB = 64,
	PHY_M_LEDC_LK_C_MSK = 56,
};

enum {
	PHY_M_LEDC_LINK_MSK = 24,
	PHY_M_LEDC_DP_CTRL = 4,
	PHY_M_LEDC_DP_C_MSB = 4,
	PHY_M_LEDC_RX_CTRL = 2,
	PHY_M_LEDC_TX_CTRL = 1,
	PHY_M_LEDC_TX_C_MSB = 1,
};

enum {
	PHY_M_LEDC_LOS_MSK = 61440,
	PHY_M_LEDC_INIT_MSK = 3840,
	PHY_M_LEDC_STA1_MSK = 240,
	PHY_M_LEDC_STA0_MSK = 15,
};

enum {
	PHY_M_MAC_MD_MSK = 896,
	PHY_M_MAC_GMIF_PUP = 8,
	PHY_M_MAC_MD_AUTO = 3,
	PHY_M_MAC_MD_COPPER = 5,
	PHY_M_MAC_MD_1000BX = 7,
};

enum {
	PHY_M_PC_COP_TX_DIS = 8,
	PHY_M_PC_POW_D_ENA = 4,
};

enum {
	PHY_M_PC_DIS_LINK_Pa = 32768,
	PHY_M_PC_DSC_MSK = 28672,
	PHY_M_PC_DOWN_S_ENA = 2048,
};

enum {
	PHY_M_PC_ENA_DTE_DT = 32768,
	PHY_M_PC_ENA_ENE_DT = 16384,
	PHY_M_PC_DIS_NLP_CK = 8192,
	PHY_M_PC_ENA_LIP_NP = 4096,
	PHY_M_PC_DIS_NLP_GN = 2048,
	PHY_M_PC_DIS_SCRAMB = 512,
	PHY_M_PC_DIS_FEFI = 256,
	PHY_M_PC_SH_TP_SEL = 64,
	PHY_M_PC_RX_FD_MSK = 12,
};

enum {
	PHY_M_PC_MAN_MDI = 0,
	PHY_M_PC_MAN_MDIX = 1,
	PHY_M_PC_ENA_AUTO = 3,
};

enum {
	PHY_M_PC_TX_FFD_MSK = 49152,
	PHY_M_PC_RX_FFD_MSK = 12288,
	PHY_M_PC_ASS_CRS_TX = 2048,
	PHY_M_PC_FL_GOOD = 1024,
	PHY_M_PC_EN_DET_MSK = 768,
	PHY_M_PC_ENA_EXT_D = 128,
	PHY_M_PC_MDIX_MSK = 96,
	PHY_M_PC_DIS_125CLK = 16,
	PHY_M_PC_MAC_POW_UP = 8,
	PHY_M_PC_SQE_T_ENA = 4,
	PHY_M_PC_POL_R_DIS = 2,
	PHY_M_PC_DIS_JABBER = 1,
};

enum {
	PHY_M_POLC_LS1M_MSK = 61440,
	PHY_M_POLC_IS0M_MSK = 3840,
	PHY_M_POLC_LOS_MSK = 192,
	PHY_M_POLC_INIT_MSK = 48,
	PHY_M_POLC_STA1_MSK = 12,
	PHY_M_POLC_STA0_MSK = 3,
};

enum {
	PHY_M_PS_SPEED_MSK = 49152,
	PHY_M_PS_SPEED_1000 = 32768,
	PHY_M_PS_SPEED_100 = 16384,
	PHY_M_PS_SPEED_10 = 0,
	PHY_M_PS_FULL_DUP = 8192,
	PHY_M_PS_PAGE_REC = 4096,
	PHY_M_PS_SPDUP_RES = 2048,
	PHY_M_PS_LINK_UP = 1024,
	PHY_M_PS_CABLE_MSK = 896,
	PHY_M_PS_MDI_X_STAT = 64,
	PHY_M_PS_DOWNS_STAT = 32,
	PHY_M_PS_ENDET_STAT = 16,
	PHY_M_PS_TX_P_EN = 8,
	PHY_M_PS_RX_P_EN = 4,
	PHY_M_PS_POL_REV = 2,
	PHY_M_PS_JABBER = 1,
};

enum {
	PINCTRL_PIN_REG_MODE = 0,
	PINCTRL_PIN_REG_DIR = 1,
	PINCTRL_PIN_REG_DI = 2,
	PINCTRL_PIN_REG_DO = 3,
	PINCTRL_PIN_REG_SR = 4,
	PINCTRL_PIN_REG_SMT = 5,
	PINCTRL_PIN_REG_PD = 6,
	PINCTRL_PIN_REG_PU = 7,
	PINCTRL_PIN_REG_E4 = 8,
	PINCTRL_PIN_REG_E8 = 9,
	PINCTRL_PIN_REG_TDSEL = 10,
	PINCTRL_PIN_REG_RDSEL = 11,
	PINCTRL_PIN_REG_DRV = 12,
	PINCTRL_PIN_REG_PUPD = 13,
	PINCTRL_PIN_REG_R0 = 14,
	PINCTRL_PIN_REG_R1 = 15,
	PINCTRL_PIN_REG_IES = 16,
	PINCTRL_PIN_REG_PULLEN = 17,
	PINCTRL_PIN_REG_PULLSEL = 18,
	PINCTRL_PIN_REG_DRV_EN = 19,
	PINCTRL_PIN_REG_DRV_E0 = 20,
	PINCTRL_PIN_REG_DRV_E1 = 21,
	PINCTRL_PIN_REG_DRV_ADV = 22,
	PINCTRL_PIN_REG_RSEL = 23,
	PINCTRL_PIN_REG_MAX = 24,
};

enum {
	PINMUX_TYPE_NONE = 0,
	PINMUX_TYPE_FUNCTION = 1,
	PINMUX_TYPE_GPIO = 2,
	PINMUX_TYPE_OUTPUT = 3,
	PINMUX_TYPE_INPUT = 4,
};

enum {
	PLAT8250_DEV_LEGACY = -1,
	PLAT8250_DEV_PLATFORM = 0,
	PLAT8250_DEV_PLATFORM1 = 1,
	PLAT8250_DEV_PLATFORM2 = 2,
	PLAT8250_DEV_FOURPORT = 3,
	PLAT8250_DEV_ACCENT = 4,
	PLAT8250_DEV_BOCA = 5,
	PLAT8250_DEV_EXAR_ST16C554 = 6,
	PLAT8250_DEV_HUB6 = 7,
	PLAT8250_DEV_AU1X00 = 8,
	PLAT8250_DEV_SM501 = 9,
};

enum {
	PLL_LOCK_DONE = 0,
	PLL_DIV_S = 1,
	PLL_MOD_EN = 2,
	PLL_SDM_EN = 3,
	PLL_REFIN = 4,
	PLL_IBIAS = 5,
	PLL_N = 6,
	PLL_NINT = 7,
	PLL_KINT = 8,
	PLL_PREDIV = 9,
	PLL_POSTDIV = 10,
	PLL_FACT_MAX = 11,
};

enum {
	PLL_OFF_L_VAL = 0,
	PLL_OFF_CAL_L_VAL = 1,
	PLL_OFF_ALPHA_VAL = 2,
	PLL_OFF_ALPHA_VAL_U = 3,
	PLL_OFF_USER_CTL = 4,
	PLL_OFF_USER_CTL_U = 5,
	PLL_OFF_USER_CTL_U1 = 6,
	PLL_OFF_CONFIG_CTL = 7,
	PLL_OFF_CONFIG_CTL_U = 8,
	PLL_OFF_CONFIG_CTL_U1 = 9,
	PLL_OFF_CONFIG_CTL_U2 = 10,
	PLL_OFF_TEST_CTL = 11,
	PLL_OFF_TEST_CTL_U = 12,
	PLL_OFF_TEST_CTL_U1 = 13,
	PLL_OFF_TEST_CTL_U2 = 14,
	PLL_OFF_TEST_CTL_U3 = 15,
	PLL_OFF_STATE = 16,
	PLL_OFF_STATUS = 17,
	PLL_OFF_OPMODE = 18,
	PLL_OFF_FRAC = 19,
	PLL_OFF_CAL_VAL = 20,
	PLL_OFF_MAX_REGS = 21,
};

enum {
	POOL_BITS = 256,
	POOL_READY_BITS = 256,
	POOL_EARLY_BITS = 128,
};

enum {
	PORT_TYPE_SAS = 2,
	PORT_TYPE_SATA = 1,
};

enum {
	POWERCAP_FC_CAP = 0,
	POWERCAP_FC_PAI = 1,
	POWERCAP_FC_MAX = 2,
};

enum {
	POWER_SUPPLY_CAPACITY_LEVEL_UNKNOWN = 0,
	POWER_SUPPLY_CAPACITY_LEVEL_CRITICAL = 1,
	POWER_SUPPLY_CAPACITY_LEVEL_LOW = 2,
	POWER_SUPPLY_CAPACITY_LEVEL_NORMAL = 3,
	POWER_SUPPLY_CAPACITY_LEVEL_HIGH = 4,
	POWER_SUPPLY_CAPACITY_LEVEL_FULL = 5,
};

enum {
	POWER_SUPPLY_HEALTH_UNKNOWN = 0,
	POWER_SUPPLY_HEALTH_GOOD = 1,
	POWER_SUPPLY_HEALTH_OVERHEAT = 2,
	POWER_SUPPLY_HEALTH_DEAD = 3,
	POWER_SUPPLY_HEALTH_OVERVOLTAGE = 4,
	POWER_SUPPLY_HEALTH_UNDERVOLTAGE = 5,
	POWER_SUPPLY_HEALTH_UNSPEC_FAILURE = 6,
	POWER_SUPPLY_HEALTH_COLD = 7,
	POWER_SUPPLY_HEALTH_WATCHDOG_TIMER_EXPIRE = 8,
	POWER_SUPPLY_HEALTH_SAFETY_TIMER_EXPIRE = 9,
	POWER_SUPPLY_HEALTH_OVERCURRENT = 10,
	POWER_SUPPLY_HEALTH_CALIBRATION_REQUIRED = 11,
	POWER_SUPPLY_HEALTH_WARM = 12,
	POWER_SUPPLY_HEALTH_COOL = 13,
	POWER_SUPPLY_HEALTH_HOT = 14,
	POWER_SUPPLY_HEALTH_NO_BATTERY = 15,
	POWER_SUPPLY_HEALTH_BLOWN_FUSE = 16,
	POWER_SUPPLY_HEALTH_CELL_IMBALANCE = 17,
};

enum {
	POWER_SUPPLY_SCOPE_UNKNOWN = 0,
	POWER_SUPPLY_SCOPE_SYSTEM = 1,
	POWER_SUPPLY_SCOPE_DEVICE = 2,
};

enum {
	POWER_SUPPLY_STATUS_UNKNOWN = 0,
	POWER_SUPPLY_STATUS_CHARGING = 1,
	POWER_SUPPLY_STATUS_DISCHARGING = 2,
	POWER_SUPPLY_STATUS_NOT_CHARGING = 3,
	POWER_SUPPLY_STATUS_FULL = 4,
};

enum {
	POWER_SUPPLY_TECHNOLOGY_UNKNOWN = 0,
	POWER_SUPPLY_TECHNOLOGY_NiMH = 1,
	POWER_SUPPLY_TECHNOLOGY_LION = 2,
	POWER_SUPPLY_TECHNOLOGY_LIPO = 3,
	POWER_SUPPLY_TECHNOLOGY_LiFe = 4,
	POWER_SUPPLY_TECHNOLOGY_NiCd = 5,
	POWER_SUPPLY_TECHNOLOGY_LiMn = 6,
};

enum {
	PREF_UNIT_OP_ON = 8,
	PREF_UNIT_OP_OFF = 4,
	PREF_UNIT_RST_CLR = 2,
	PREF_UNIT_RST_SET = 1,
};

enum {
	PROCESS_BPF_EXIT = 1,
};

enum {
	PROCESS_SPIN_LOCK = 1,
	PROCESS_RES_LOCK = 2,
	PROCESS_LOCK_IRQ = 4,
};

enum {
	PROC_ENTRY_PERMANENT = 1,
	PROC_ENTRY_proc_read_iter = 2,
	PROC_ENTRY_proc_compat_ioctl = 4,
	PROC_ENTRY_proc_lseek = 8,
	PROC_ENTRY_FORCE_LOOKUP = 128,
};

enum {
	PSM_CONFIG_REG4_TIMER_PHY_LINK_DETECT_MSK = 240,
	PSM_CONFIG_REG4_TIMER_PHY_LINK_DETECT_BASE = 4,
	PSM_CONFIG_REG4_DEBUG_TIMER = 2,
	PSM_CONFIG_REG4_RST_PHY_LINK_DETECT = 1,
};

enum {
	PULS_NO_STR = 0,
	PULS_21MS = 1,
	PULS_42MS = 2,
	PULS_84MS = 3,
	PULS_170MS = 4,
	PULS_340MS = 5,
	PULS_670MS = 6,
	PULS_1300MS = 7,
};

enum {
	PWMF_REQUESTED = 0,
	PWMF_EXPORTED = 1,
};

enum {
	PWR_OK = 0,
	PWR_LOCAL = 1,
	PWR_REMOTE = 2,
	PWR_BUSY = 3,
	PWR_ERROR_CAP = 4,
	PWR_FATAL_ERROR = 5,
};

enum {
	P_XO = 0,
	P_GPLL0 = 1,
	P_APSS_PLL_EARLY = 2,
};

enum {
	QIF_BLIMITS_B = 0,
	QIF_SPACE_B = 1,
	QIF_ILIMITS_B = 2,
	QIF_INODES_B = 3,
	QIF_BTIME_B = 4,
	QIF_ITIME_B = 5,
};

enum {
	QUERY_REQ_TIMEOUT_MIN = 1,
	QUERY_REQ_TIMEOUT_DEFAULT = 1500,
	QUERY_REQ_TIMEOUT_MAX = 30000,
};

enum {
	QUEUE_FLAG_DYING = 0,
	QUEUE_FLAG_NOMERGES = 1,
	QUEUE_FLAG_SAME_COMP = 2,
	QUEUE_FLAG_FAIL_IO = 3,
	QUEUE_FLAG_NOXMERGES = 4,
	QUEUE_FLAG_SAME_FORCE = 5,
	QUEUE_FLAG_INIT_DONE = 6,
	QUEUE_FLAG_STATS = 7,
	QUEUE_FLAG_REGISTERED = 8,
	QUEUE_FLAG_QUIESCED = 9,
	QUEUE_FLAG_RQ_ALLOC_TIME = 10,
	QUEUE_FLAG_HCTX_ACTIVE = 11,
	QUEUE_FLAG_SQ_SCHED = 12,
	QUEUE_FLAG_DISABLE_WBT_DEF = 13,
	QUEUE_FLAG_NO_ELV_SWITCH = 14,
	QUEUE_FLAG_QOS_ENABLED = 15,
	QUEUE_FLAG_BIO_ISSUE_TIME = 16,
	QUEUE_FLAG_MAX = 17,
};

enum {
	Q_R1 = 0,
	Q_R2 = 128,
	Q_XS1 = 512,
	Q_XA1 = 640,
	Q_XS2 = 768,
	Q_XA2 = 896,
};

enum {
	Q_REQUEUE_PI_NONE = 0,
	Q_REQUEUE_PI_IGNORE = 1,
	Q_REQUEUE_PI_IN_PROGRESS = 2,
	Q_REQUEUE_PI_WAIT = 3,
	Q_REQUEUE_PI_DONE = 4,
	Q_REQUEUE_PI_LOCKED = 5,
};

enum {
	RADIX_TREE_ITER_TAG_MASK = 15,
	RADIX_TREE_ITER_TAGGED = 16,
	RADIX_TREE_ITER_CONTIG = 32,
};

enum {
	RB_ENA_STFWD = 32,
	RB_DIS_STFWD = 16,
	RB_ENA_OP_MD = 8,
	RB_DIS_OP_MD = 4,
	RB_RST_CLR = 2,
	RB_RST_SET = 1,
};

enum {
	RB_START = 0,
	RB_END = 4,
	RB_WP = 8,
	RB_RP = 12,
	RB_RX_UTPP = 16,
	RB_RX_LTPP = 20,
	RB_RX_UTHP = 24,
	RB_RX_LTHP = 28,
	RB_PC = 32,
	RB_LEV = 36,
	RB_CTRL = 40,
	RB_TST1 = 41,
	RB_TST2 = 42,
};

enum {
	RCAR_PCI_ACCESS_READ = 0,
	RCAR_PCI_ACCESS_WRITE = 1,
};

enum {
	RCD = 0,
	RCH_DP = 1,
	DEVICE = 2,
	LD = 3,
	FMLD = 4,
	RP = 5,
	DSP = 6,
	USP = 7,
};

enum {
	REASON_BOUNDS = -1,
	REASON_TYPE = -2,
	REASON_PATHS = -3,
	REASON_LIMIT = -4,
	REASON_STACK = -5,
};

enum {
	REGION_INTERSECTS = 0,
	REGION_DISJOINT = 1,
	REGION_MIXED = 2,
};

enum {
	REGULATOR_ERROR_CLEARED = 0,
	REGULATOR_FAILED_RETRY = 1,
	REGULATOR_ERROR_ON = 2,
};

enum {
	REG_CONTROLLER_CAPABILITIES = 0,
	REG_MCQCAP = 4,
	REG_UFS_VERSION = 8,
	REG_EXT_CONTROLLER_CAPABILITIES = 12,
	REG_CONTROLLER_PID = 16,
	REG_CONTROLLER_MID = 20,
	REG_AUTO_HIBERNATE_IDLE_TIMER = 24,
	REG_INTERRUPT_STATUS = 32,
	REG_INTERRUPT_ENABLE = 36,
	REG_CONTROLLER_STATUS = 48,
	REG_CONTROLLER_ENABLE = 52,
	REG_UIC_ERROR_CODE_PHY_ADAPTER_LAYER = 56,
	REG_UIC_ERROR_CODE_DATA_LINK_LAYER = 60,
	REG_UIC_ERROR_CODE_NETWORK_LAYER = 64,
	REG_UIC_ERROR_CODE_TRANSPORT_LAYER = 68,
	REG_UIC_ERROR_CODE_DME = 72,
	REG_UTP_TRANSFER_REQ_INT_AGG_CONTROL = 76,
	REG_UTP_TRANSFER_REQ_LIST_BASE_L = 80,
	REG_UTP_TRANSFER_REQ_LIST_BASE_H = 84,
	REG_UTP_TRANSFER_REQ_DOOR_BELL = 88,
	REG_UTP_TRANSFER_REQ_LIST_CLEAR = 92,
	REG_UTP_TRANSFER_REQ_LIST_RUN_STOP = 96,
	REG_UTP_TASK_REQ_LIST_BASE_L = 112,
	REG_UTP_TASK_REQ_LIST_BASE_H = 116,
	REG_UTP_TASK_REQ_DOOR_BELL = 120,
	REG_UTP_TASK_REQ_LIST_CLEAR = 124,
	REG_UTP_TASK_REQ_LIST_RUN_STOP = 128,
	REG_UIC_COMMAND = 144,
	REG_UIC_COMMAND_ARG_1 = 148,
	REG_UIC_COMMAND_ARG_2 = 152,
	REG_UIC_COMMAND_ARG_3 = 156,
	UFSHCI_REG_SPACE_SIZE = 160,
	REG_UFS_CCAP = 256,
	REG_UFS_CRYPTOCAP = 260,
	REG_UFS_MEM_CFG = 768,
	REG_UFS_MCQ_CFG = 896,
	REG_UFS_ESILBA = 900,
	REG_UFS_ESIUBA = 904,
	UFSHCI_CRYPTO_REG_SPACE_SIZE = 1024,
};

enum {
	REG_CON_MOD_TX = 0,
	REG_CON_MOD_REGISTER_TX = 1,
	REG_CON_MOD_RX = 2,
	REG_CON_MOD_REGISTER_RX = 3,
};

enum {
	REG_CQHP = 0,
	REG_CQTP = 4,
};

enum {
	REG_CQIS = 0,
	REG_CQIE = 4,
};

enum {
	REG_DR = 0,
	REG_ST_DMAWM = 1,
	REG_ST_TIMEOUT = 2,
	REG_FR = 3,
	REG_LCRH_RX = 4,
	REG_LCRH_TX = 5,
	REG_IBRD = 6,
	REG_FBRD = 7,
	REG_CR = 8,
	REG_IFLS = 9,
	REG_IMSC = 10,
	REG_RIS = 11,
	REG_MIS = 12,
	REG_ICR = 13,
	REG_DMACR = 14,
	REG_ST_XFCR = 15,
	REG_ST_XON1 = 16,
	REG_ST_XON2 = 17,
	REG_ST_XOFF1 = 18,
	REG_ST_XOFF2 = 19,
	REG_ST_ITCR = 20,
	REG_ST_ITIP = 21,
	REG_ST_ABCR = 22,
	REG_ST_ABIMSC = 23,
	REG_ARRAY_SIZE = 24,
};

enum {
	REG_SQATTR = 0,
	REG_SQLBA = 4,
	REG_SQUBA = 8,
	REG_SQDAO = 12,
	REG_SQISAO = 16,
	REG_CQATTR = 32,
	REG_CQLBA = 36,
	REG_CQUBA = 40,
	REG_CQDAO = 44,
	REG_CQISAO = 48,
};

enum {
	REG_SQHP = 0,
	REG_SQTP = 4,
	REG_SQRTC = 8,
	REG_SQCTI = 12,
	REG_SQRTS = 16,
};

enum {
	RELAY_STATS_BUF_FULL = 1,
	RELAY_STATS_WRT_BIG = 2,
	RELAY_STATS_LAST = 2,
};

enum {
	REQUEST_ANY = 0,
	REQUEST_BY_ID = 1,
	REQUEST_BY_CAP = 2,
	REQUEST_BY_NODE = 3,
};

enum {
	REQ_FSEQ_PREFLUSH = 1,
	REQ_FSEQ_DATA = 2,
	REQ_FSEQ_POSTFLUSH = 4,
	REQ_FSEQ_DONE = 8,
	REQ_FSEQ_ACTIONS = 7,
	FLUSH_PENDING_TIMEOUT = 1250,
};

enum {
	REQ_F_FIXED_FILE = 1ULL,
	REQ_F_IO_DRAIN = 2ULL,
	REQ_F_LINK = 4ULL,
	REQ_F_HARDLINK = 8ULL,
	REQ_F_FORCE_ASYNC = 16ULL,
	REQ_F_BUFFER_SELECT = 32ULL,
	REQ_F_CQE_SKIP = 64ULL,
	REQ_F_FAIL = 256ULL,
	REQ_F_INFLIGHT = 512ULL,
	REQ_F_CUR_POS = 1024ULL,
	REQ_F_NOWAIT = 2048ULL,
	REQ_F_LINK_TIMEOUT = 4096ULL,
	REQ_F_NEED_CLEANUP = 8192ULL,
	REQ_F_POLLED = 16384ULL,
	REQ_F_IOPOLL_STATE = 32768ULL,
	REQ_F_BUFFER_SELECTED = 65536ULL,
	REQ_F_BUFFER_RING = 131072ULL,
	REQ_F_REISSUE = 262144ULL,
	REQ_F_SUPPORT_NOWAIT = 536870912ULL,
	REQ_F_ISREG = 1073741824ULL,
	REQ_F_CREDS = 524288ULL,
	REQ_F_REFCOUNT = 1048576ULL,
	REQ_F_ARM_LTIMEOUT = 2097152ULL,
	REQ_F_ASYNC_DATA = 4194304ULL,
	REQ_F_SKIP_LINK_CQES = 8388608ULL,
	REQ_F_SINGLE_POLL = 16777216ULL,
	REQ_F_DOUBLE_POLL = 33554432ULL,
	REQ_F_MULTISHOT = 67108864ULL,
	REQ_F_APOLL_MULTISHOT = 134217728ULL,
	REQ_F_CLEAR_POLLIN = 268435456ULL,
	REQ_F_POLL_NO_LAZY = 2147483648ULL,
	REQ_F_CAN_POLL = 4294967296ULL,
	REQ_F_BL_EMPTY = 8589934592ULL,
	REQ_F_BL_NO_RECYCLE = 17179869184ULL,
	REQ_F_BUFFERS_COMMIT = 34359738368ULL,
	REQ_F_BUF_NODE = 68719476736ULL,
	REQ_F_HAS_METADATA = 137438953472ULL,
	REQ_F_IMPORT_BUFFER = 274877906944ULL,
	REQ_F_SQE_COPIED = 549755813888ULL,
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_HYBRID_IOPOLL_STATE_BIT = 15,
	REQ_F_BUFFER_SELECTED_BIT = 16,
	REQ_F_BUFFER_RING_BIT = 17,
	REQ_F_REISSUE_BIT = 18,
	REQ_F_CREDS_BIT = 19,
	REQ_F_REFCOUNT_BIT = 20,
	REQ_F_ARM_LTIMEOUT_BIT = 21,
	REQ_F_ASYNC_DATA_BIT = 22,
	REQ_F_SKIP_LINK_CQES_BIT = 23,
	REQ_F_SINGLE_POLL_BIT = 24,
	REQ_F_DOUBLE_POLL_BIT = 25,
	REQ_F_MULTISHOT_BIT = 26,
	REQ_F_APOLL_MULTISHOT_BIT = 27,
	REQ_F_CLEAR_POLLIN_BIT = 28,
	REQ_F_SUPPORT_NOWAIT_BIT = 29,
	REQ_F_ISREG_BIT = 30,
	REQ_F_POLL_NO_LAZY_BIT = 31,
	REQ_F_CAN_POLL_BIT = 32,
	REQ_F_BL_EMPTY_BIT = 33,
	REQ_F_BL_NO_RECYCLE_BIT = 34,
	REQ_F_BUFFERS_COMMIT_BIT = 35,
	REQ_F_BUF_NODE_BIT = 36,
	REQ_F_HAS_METADATA_BIT = 37,
	REQ_F_IMPORT_BUFFER_BIT = 38,
	REQ_F_SQE_COPIED_BIT = 39,
	__REQ_F_LAST_BIT = 40,
};

enum {
	RES_USAGE = 0,
	RES_RSVD_USAGE = 1,
	RES_LIMIT = 2,
	RES_RSVD_LIMIT = 3,
	RES_MAX_USAGE = 4,
	RES_RSVD_MAX_USAGE = 5,
	RES_FAILCNT = 6,
	RES_RSVD_FAILCNT = 7,
};

enum {
	RI_CLR_RD_PERR = 512,
	RI_CLR_WR_PERR = 256,
	RI_RST_CLR = 2,
	RI_RST_SET = 1,
};

enum {
	RK805_ID = 32848,
	RK806_ID = 32864,
	RK808_ID = 0,
	RK809_ID = 32912,
	RK816_ID = 33120,
	RK817_ID = 33136,
	RK818_ID = 33152,
};

enum {
	RK8600_CHIP_ID_08 = 8,
};

enum {
	RK8602_CHIP_ID_10 = 10,
};

enum {
	RNG_OUTPUT_0_REG = 0,
	RNG_OUTPUT_1_REG = 1,
	RNG_OUTPUT_2_REG = 2,
	RNG_OUTPUT_3_REG = 3,
	RNG_STATUS_REG = 4,
	RNG_INTMASK_REG = 5,
	RNG_INTACK_REG = 6,
	RNG_CONTROL_REG = 7,
	RNG_CONFIG_REG = 8,
	RNG_ALARMCNT_REG = 9,
	RNG_FROENABLE_REG = 10,
	RNG_FRODETUNE_REG = 11,
	RNG_ALARMMASK_REG = 12,
	RNG_ALARMSTOP_REG = 13,
	RNG_REV_REG = 14,
	RNG_SYSCONFIG_REG = 15,
};

enum {
	RPCAUTH_lockd = 0,
	RPCAUTH_mount = 1,
	RPCAUTH_nfs = 2,
	RPCAUTH_portmap = 3,
	RPCAUTH_statd = 4,
	RPCAUTH_nfsd4_cb = 5,
	RPCAUTH_cache = 6,
	RPCAUTH_nfsd = 7,
	RPCAUTH_RootEOF = 8,
};

enum {
	RPCBPROC_NULL = 0,
	RPCBPROC_SET = 1,
	RPCBPROC_UNSET = 2,
	RPCBPROC_GETPORT = 3,
	RPCBPROC_GETADDR = 3,
	RPCBPROC_DUMP = 4,
	RPCBPROC_CALLIT = 5,
	RPCBPROC_BCAST = 5,
	RPCBPROC_GETTIME = 6,
	RPCBPROC_UADDR2TADDR = 7,
	RPCBPROC_TADDR2UADDR = 8,
	RPCBPROC_GETVERSADDR = 9,
	RPCBPROC_INDIRECT = 10,
	RPCBPROC_GETADDRLIST = 11,
	RPCBPROC_GETSTAT = 12,
};

enum {
	RPCSVC_MAXPAYLOAD = 4194304,
	RPCSVC_MAXPAYLOAD_TCP = 4194304,
	RPCSVC_MAXPAYLOAD_UDP = 32768,
};

enum {
	RPC_PIPEFS_MOUNT = 0,
	RPC_PIPEFS_UMOUNT = 1,
};

enum {
	RPC_TASK_RUNNING = 0,
	RPC_TASK_QUEUED = 1,
	RPC_TASK_ACTIVE = 2,
	RPC_TASK_NEED_XMIT = 3,
	RPC_TASK_NEED_RECV = 4,
	RPC_TASK_MSG_PIN_WAIT = 5,
};

enum {
	RQ_SECURE = 0,
	RQ_LOCAL = 1,
	RQ_USEDEFERRAL = 2,
	RQ_DROPME = 3,
	RQ_VICTIM = 4,
	RQ_DATA = 5,
};

enum {
	RSC_DRV_TCS_OFFSET = 0,
	RSC_DRV_CMD_OFFSET = 1,
	DRV_SOLVER_CONFIG = 2,
	DRV_PRNT_CHLD_CONFIG = 3,
	RSC_DRV_IRQ_ENABLE = 4,
	RSC_DRV_IRQ_STATUS = 5,
	RSC_DRV_IRQ_CLEAR = 6,
	RSC_DRV_CMD_WAIT_FOR_CMPL = 7,
	RSC_DRV_CONTROL = 8,
	RSC_DRV_STATUS = 9,
	RSC_DRV_CMD_ENABLE = 10,
	RSC_DRV_CMD_MSGID = 11,
	RSC_DRV_CMD_ADDR = 12,
	RSC_DRV_CMD_DATA = 13,
	RSC_DRV_CMD_STATUS = 14,
	RSC_DRV_CMD_RESP_DATA = 15,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	RTC_SEC = 0,
	RTC_MIN = 1,
	RTC_HOUR = 2,
	RTC_WEEKDAY = 3,
	RTC_MONTH = 4,
	RTC_YEAR = 5,
	RTC_MONTHDAY = 6,
	RTC_NR_TIME = 7,
};

enum {
	RTC_SEC___2 = 0,
	RTC_MIN___2 = 1,
	RTC_HOUR___2 = 2,
	RTC_WEEKDAY___2 = 3,
	RTC_DATE = 4,
	RTC_MONTH___2 = 5,
	RTC_YEAR1 = 6,
	RTC_YEAR2 = 7,
	RTC_MAX_NUM_TIME_REGS = 8,
};

enum {
	RTM_BASE = 16,
	RTM_NEWLINK = 16,
	RTM_DELLINK = 17,
	RTM_GETLINK = 18,
	RTM_SETLINK = 19,
	RTM_NEWADDR = 20,
	RTM_DELADDR = 21,
	RTM_GETADDR = 22,
	RTM_NEWROUTE = 24,
	RTM_DELROUTE = 25,
	RTM_GETROUTE = 26,
	RTM_NEWNEIGH = 28,
	RTM_DELNEIGH = 29,
	RTM_GETNEIGH = 30,
	RTM_NEWRULE = 32,
	RTM_DELRULE = 33,
	RTM_GETRULE = 34,
	RTM_NEWQDISC = 36,
	RTM_DELQDISC = 37,
	RTM_GETQDISC = 38,
	RTM_NEWTCLASS = 40,
	RTM_DELTCLASS = 41,
	RTM_GETTCLASS = 42,
	RTM_NEWTFILTER = 44,
	RTM_DELTFILTER = 45,
	RTM_GETTFILTER = 46,
	RTM_NEWACTION = 48,
	RTM_DELACTION = 49,
	RTM_GETACTION = 50,
	RTM_NEWPREFIX = 52,
	RTM_NEWMULTICAST = 56,
	RTM_DELMULTICAST = 57,
	RTM_GETMULTICAST = 58,
	RTM_NEWANYCAST = 60,
	RTM_DELANYCAST = 61,
	RTM_GETANYCAST = 62,
	RTM_NEWNEIGHTBL = 64,
	RTM_GETNEIGHTBL = 66,
	RTM_SETNEIGHTBL = 67,
	RTM_NEWNDUSEROPT = 68,
	RTM_NEWADDRLABEL = 72,
	RTM_DELADDRLABEL = 73,
	RTM_GETADDRLABEL = 74,
	RTM_GETDCB = 78,
	RTM_SETDCB = 79,
	RTM_NEWNETCONF = 80,
	RTM_DELNETCONF = 81,
	RTM_GETNETCONF = 82,
	RTM_NEWMDB = 84,
	RTM_DELMDB = 85,
	RTM_GETMDB = 86,
	RTM_NEWNSID = 88,
	RTM_DELNSID = 89,
	RTM_GETNSID = 90,
	RTM_NEWSTATS = 92,
	RTM_GETSTATS = 94,
	RTM_SETSTATS = 95,
	RTM_NEWCACHEREPORT = 96,
	RTM_NEWCHAIN = 100,
	RTM_DELCHAIN = 101,
	RTM_GETCHAIN = 102,
	RTM_NEWNEXTHOP = 104,
	RTM_DELNEXTHOP = 105,
	RTM_GETNEXTHOP = 106,
	RTM_NEWLINKPROP = 108,
	RTM_DELLINKPROP = 109,
	RTM_GETLINKPROP = 110,
	RTM_NEWVLAN = 112,
	RTM_DELVLAN = 113,
	RTM_GETVLAN = 114,
	RTM_NEWNEXTHOPBUCKET = 116,
	RTM_DELNEXTHOPBUCKET = 117,
	RTM_GETNEXTHOPBUCKET = 118,
	RTM_NEWTUNNEL = 120,
	RTM_DELTUNNEL = 121,
	RTM_GETTUNNEL = 122,
	__RTM_MAX = 123,
};

enum {
	RTN_UNSPEC = 0,
	RTN_UNICAST = 1,
	RTN_LOCAL = 2,
	RTN_BROADCAST = 3,
	RTN_ANYCAST = 4,
	RTN_MULTICAST = 5,
	RTN_BLACKHOLE = 6,
	RTN_UNREACHABLE = 7,
	RTN_PROHIBIT = 8,
	RTN_THROW = 9,
	RTN_NAT = 10,
	RTN_XRESOLVE = 11,
	__RTN_MAX = 12,
};

enum {
	RX_GCLKMAC_ENA = -2147483648,
	RX_GCLKMAC_OFF = 1073741824,
	RX_STFW_DIS = 536870912,
	RX_STFW_ENA = 268435456,
	RX_TRUNC_ON = 134217728,
	RX_TRUNC_OFF = 67108864,
	RX_VLAN_STRIP_ON = 33554432,
	RX_VLAN_STRIP_OFF = 16777216,
	RX_MACSEC_FLUSH_ON = 8388608,
	RX_MACSEC_FLUSH_OFF = 4194304,
	RX_MACSEC_ASF_FLUSH_ON = 2097152,
	RX_MACSEC_ASF_FLUSH_OFF = 1048576,
	GMF_RX_OVER_ON = 524288,
	GMF_RX_OVER_OFF = 262144,
	GMF_ASF_RX_OVER_ON = 131072,
	GMF_ASF_RX_OVER_OFF = 65536,
	GMF_WP_TST_ON = 16384,
	GMF_WP_TST_OFF = 8192,
	GMF_WP_STEP = 4096,
	GMF_RP_TST_ON = 1024,
	GMF_RP_TST_OFF = 512,
	GMF_RP_STEP = 256,
	GMF_RX_F_FL_ON = 128,
	GMF_RX_F_FL_OFF = 64,
	GMF_CLI_RX_FO = 32,
	GMF_CLI_RX_C = 16,
	GMF_OPER_ON = 8,
	GMF_OPER_OFF = 4,
	GMF_RST_CLR = 2,
	GMF_RST_SET = 1,
	RX_GMF_FL_THR_DEF = 10,
	GMF_RX_CTRL_DEF = 136,
};

enum {
	RX_IPV6_SA_MOB_ENA = 512,
	RX_IPV6_SA_MOB_DIS = 256,
	RX_IPV6_DA_MOB_ENA = 128,
	RX_IPV6_DA_MOB_DIS = 64,
	RX_PTR_SYNCDLY_ENA = 32,
	RX_PTR_SYNCDLY_DIS = 16,
	RX_ASF_NEWFLAG_ENA = 8,
	RX_ASF_NEWFLAG_DIS = 4,
	RX_FLSH_MISSPKT_ENA = 2,
	RX_FLSH_MISSPKT_DIS = 1,
};

enum {
	RX_XDP_REDIRECT = 0,
	RX_XDP_PASS = 1,
	RX_XDP_DROP = 2,
	RX_XDP_TX = 3,
	RX_XDP_TX_ERRORS = 4,
	TX_XDP_XMIT = 5,
	TX_XDP_XMIT_ERRORS = 6,
	XDP_STATS_TOTAL = 7,
};

enum {
	Root_NFS = 255,
	Root_CIFS = 254,
	Root_Generic = 253,
	Root_RAM0 = 1048576,
};

enum {
	Rworksched = 1,
	Rpending = 2,
	Wworksched = 4,
	Wpending = 8,
};

enum {
	SAS_DATAPRES_NO_DATA = 0,
	SAS_DATAPRES_RESPONSE_DATA = 1,
	SAS_DATAPRES_SENSE_DATA = 2,
};

enum {
	SAS_DEV_GONE = 0,
	SAS_DEV_FOUND = 1,
	SAS_DEV_DESTROY = 2,
	SAS_DEV_EH_PENDING = 3,
	SAS_DEV_LU_RESET = 4,
	SAS_DEV_RESET = 5,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum {
	SCIx_ERI_IRQ = 0,
	SCIx_RXI_IRQ = 1,
	SCIx_TXI_IRQ = 2,
	SCIx_BRI_IRQ = 3,
	SCIx_DRI_IRQ = 4,
	SCIx_TEI_IRQ = 5,
	SCIx_NR_IRQS = 6,
	SCIx_MUX_IRQ = 6,
};

enum {
	SCIx_PROBE_REGTYPE = 0,
	SCIx_SCI_REGTYPE = 1,
	SCIx_IRDA_REGTYPE = 2,
	SCIx_SCIFA_REGTYPE = 3,
	SCIx_SCIFB_REGTYPE = 4,
	SCIx_SH2_SCIF_FIFODATA_REGTYPE = 5,
	SCIx_SH3_SCIF_REGTYPE = 6,
	SCIx_SH4_SCIF_REGTYPE = 7,
	SCIx_SH4_SCIF_BRG_REGTYPE = 8,
	SCIx_SH4_SCIF_NO_SCSPTR_REGTYPE = 9,
	SCIx_SH4_SCIF_FIFODATA_REGTYPE = 10,
	SCIx_SH7705_SCIF_REGTYPE = 11,
	SCIx_HSCIF_REGTYPE = 12,
	SCIx_RZ_SCIFA_REGTYPE = 13,
	SCIx_RZV2H_SCIF_REGTYPE = 14,
	SCIx_NR_REGTYPES = 15,
};

enum {
	SCM_TSTAMP_SND = 0,
	SCM_TSTAMP_SCHED = 1,
	SCM_TSTAMP_ACK = 2,
	SCM_TSTAMP_COMPLETION = 3,
};

enum {
	SCSMR = 0,
	SCBRR = 1,
	SCSCR = 2,
	SCxSR = 3,
	SCFCR = 4,
	SCFDR = 5,
	SCxTDR = 6,
	SCxRDR = 7,
	SCLSR = 8,
	SCTFDR = 9,
	SCRFDR = 10,
	SCSPTR = 11,
	HSSRR = 12,
	SCPCR = 13,
	SCPDR = 14,
	SCDL = 15,
	SCCKS = 16,
	HSRTRGR = 17,
	HSTTRGR = 18,
	SEMR = 19,
};

enum {
	SC_STAT_CLR_IRQ = 16,
	SC_STAT_OP_ON = 8,
	SC_STAT_OP_OFF = 4,
	SC_STAT_RST_CLR = 2,
	SC_STAT_RST_SET = 1,
};

enum {
	SD_BALANCE_NEWIDLE = 1,
	SD_BALANCE_EXEC = 2,
	SD_BALANCE_FORK = 4,
	SD_BALANCE_WAKE = 8,
	SD_WAKE_AFFINE = 16,
	SD_ASYM_CPUCAPACITY = 32,
	SD_ASYM_CPUCAPACITY_FULL = 64,
	SD_SHARE_CPUCAPACITY = 128,
	SD_CLUSTER = 256,
	SD_SHARE_LLC = 512,
	SD_SERIALIZE = 1024,
	SD_ASYM_PACKING = 2048,
	SD_PREFER_SIBLING = 4096,
	SD_NUMA = 8192,
};

enum {
	SD_DEF_XFER_BLOCKS = 65535,
	SD_MAX_XFER_BLOCKS = 4294967295,
	SD_MAX_WS10_BLOCKS = 65535,
	SD_MAX_WS16_BLOCKS = 8388607,
};

enum {
	SD_EXT_CDB_SIZE = 32,
	SD_MEMPOOL_SIZE = 2,
};

enum {
	SD_LBP_FULL = 0,
	SD_LBP_UNMAP = 1,
	SD_LBP_WS16 = 2,
	SD_LBP_WS10 = 3,
	SD_LBP_ZERO = 4,
	SD_LBP_DISABLE = 5,
};

enum {
	SD_ZERO_WRITE = 0,
	SD_ZERO_WS = 1,
	SD_ZERO_WS16_UNMAP = 2,
	SD_ZERO_WS10_UNMAP = 3,
};

enum {
	SECTION_MARKED_PRESENT_BIT = 0,
	SECTION_HAS_MEM_MAP_BIT = 1,
	SECTION_IS_ONLINE_BIT = 2,
	SECTION_IS_EARLY_BIT = 3,
	SECTION_MAP_LAST_BIT = 4,
};

enum {
	SETWA_FLAGS_APICID = 1,
	SETWA_FLAGS_MEM = 2,
	SETWA_FLAGS_PCIE_SBDF = 4,
	SETWA_FLAGS_EINJV2 = 8,
};

enum {
	SFF8024_ID_UNK = 0,
	SFF8024_ID_SFF_8472 = 2,
	SFF8024_ID_SFP = 3,
	SFF8024_ID_DWDM_SFP = 11,
	SFF8024_ID_QSFP_8438 = 12,
	SFF8024_ID_QSFP_8436_8636 = 13,
	SFF8024_ID_QSFP28_8636 = 17,
	SFF8024_ID_QSFP_DD = 24,
	SFF8024_ID_OSFP = 25,
	SFF8024_ID_DSFP = 27,
	SFF8024_ID_QSFP_PLUS_CMIS = 30,
	SFF8024_ID_SFP_DD_CMIS = 31,
	SFF8024_ID_SFP_PLUS_CMIS = 32,
	SFF8024_ENCODING_UNSPEC = 0,
	SFF8024_ENCODING_8B10B = 1,
	SFF8024_ENCODING_4B5B = 2,
	SFF8024_ENCODING_NRZ = 3,
	SFF8024_ENCODING_8472_MANCHESTER = 4,
	SFF8024_ENCODING_8472_SONET = 5,
	SFF8024_ENCODING_8472_64B66B = 6,
	SFF8024_ENCODING_8436_MANCHESTER = 6,
	SFF8024_ENCODING_8436_SONET = 4,
	SFF8024_ENCODING_8436_64B66B = 5,
	SFF8024_ENCODING_256B257B = 7,
	SFF8024_ENCODING_PAM4 = 8,
	SFF8024_CONNECTOR_UNSPEC = 0,
	SFF8024_CONNECTOR_SC = 1,
	SFF8024_CONNECTOR_FIBERJACK = 6,
	SFF8024_CONNECTOR_LC = 7,
	SFF8024_CONNECTOR_MT_RJ = 8,
	SFF8024_CONNECTOR_MU = 9,
	SFF8024_CONNECTOR_SG = 10,
	SFF8024_CONNECTOR_OPTICAL_PIGTAIL = 11,
	SFF8024_CONNECTOR_MPO_1X12 = 12,
	SFF8024_CONNECTOR_MPO_2X16 = 13,
	SFF8024_CONNECTOR_HSSDC_II = 32,
	SFF8024_CONNECTOR_COPPER_PIGTAIL = 33,
	SFF8024_CONNECTOR_RJ45 = 34,
	SFF8024_CONNECTOR_NOSEPARATE = 35,
	SFF8024_CONNECTOR_MXC_2X16 = 36,
	SFF8024_ECC_UNSPEC = 0,
	SFF8024_ECC_100G_25GAUI_C2M_AOC = 1,
	SFF8024_ECC_100GBASE_SR4_25GBASE_SR = 2,
	SFF8024_ECC_100GBASE_LR4_25GBASE_LR = 3,
	SFF8024_ECC_100GBASE_ER4_25GBASE_ER = 4,
	SFF8024_ECC_100GBASE_SR10 = 5,
	SFF8024_ECC_100GBASE_CR4 = 11,
	SFF8024_ECC_25GBASE_CR_S = 12,
	SFF8024_ECC_25GBASE_CR_N = 13,
	SFF8024_ECC_10GBASE_T_SFI = 22,
	SFF8024_ECC_10GBASE_T_SR = 28,
	SFF8024_ECC_5GBASE_T = 29,
	SFF8024_ECC_2_5GBASE_T = 30,
};

enum {
	SFP_PHYS_ID = 0,
	SFP_PHYS_EXT_ID = 1,
	SFP_PHYS_EXT_ID_SFP = 4,
	SFP_CONNECTOR = 2,
	SFP_COMPLIANCE = 3,
	SFP_ENCODING = 11,
	SFP_BR_NOMINAL = 12,
	SFP_RATE_ID = 13,
	SFF_RID_8079 = 1,
	SFF_RID_8431_RX_ONLY = 2,
	SFF_RID_8431_TX_ONLY = 4,
	SFF_RID_8431 = 6,
	SFF_RID_10G8G = 14,
	SFP_LINK_LEN_SM_KM = 14,
	SFP_LINK_LEN_SM_100M = 15,
	SFP_LINK_LEN_50UM_OM2_10M = 16,
	SFP_LINK_LEN_62_5UM_OM1_10M = 17,
	SFP_LINK_LEN_COPPER_1M = 18,
	SFP_LINK_LEN_50UM_OM4_10M = 18,
	SFP_LINK_LEN_50UM_OM3_10M = 19,
	SFP_VENDOR_NAME = 20,
	SFP_VENDOR_OUI = 37,
	SFP_VENDOR_PN = 40,
	SFP_VENDOR_REV = 56,
	SFP_OPTICAL_WAVELENGTH_MSB = 60,
	SFP_OPTICAL_WAVELENGTH_LSB = 61,
	SFP_CABLE_SPEC = 60,
	SFP_CC_BASE = 63,
	SFP_OPTIONS = 64,
	SFP_OPTIONS_HIGH_POWER_LEVEL = 8192,
	SFP_OPTIONS_PAGING_A2 = 4096,
	SFP_OPTIONS_RETIMER = 2048,
	SFP_OPTIONS_COOLED_XCVR = 1024,
	SFP_OPTIONS_POWER_DECL = 512,
	SFP_OPTIONS_RX_LINEAR_OUT = 256,
	SFP_OPTIONS_RX_DECISION_THRESH = 128,
	SFP_OPTIONS_TUNABLE_TX = 64,
	SFP_OPTIONS_RATE_SELECT = 32,
	SFP_OPTIONS_TX_DISABLE = 16,
	SFP_OPTIONS_TX_FAULT = 8,
	SFP_OPTIONS_LOS_INVERTED = 4,
	SFP_OPTIONS_LOS_NORMAL = 2,
	SFP_BR_MAX = 66,
	SFP_BR_MIN = 67,
	SFP_VENDOR_SN = 68,
	SFP_DATECODE = 84,
	SFP_DIAGMON = 92,
	SFP_DIAGMON_DDM = 64,
	SFP_DIAGMON_INT_CAL = 32,
	SFP_DIAGMON_EXT_CAL = 16,
	SFP_DIAGMON_RXPWR_AVG = 8,
	SFP_DIAGMON_ADDRMODE = 4,
	SFP_ENHOPTS = 93,
	SFP_ENHOPTS_ALARMWARN = 128,
	SFP_ENHOPTS_SOFT_TX_DISABLE = 64,
	SFP_ENHOPTS_SOFT_TX_FAULT = 32,
	SFP_ENHOPTS_SOFT_RX_LOS = 16,
	SFP_ENHOPTS_SOFT_RATE_SELECT = 8,
	SFP_ENHOPTS_APP_SELECT_SFF8079 = 4,
	SFP_ENHOPTS_SOFT_RATE_SFF8431 = 2,
	SFP_SFF8472_COMPLIANCE = 94,
	SFP_SFF8472_COMPLIANCE_NONE = 0,
	SFP_SFF8472_COMPLIANCE_REV9_3 = 1,
	SFP_SFF8472_COMPLIANCE_REV9_5 = 2,
	SFP_SFF8472_COMPLIANCE_REV10_2 = 3,
	SFP_SFF8472_COMPLIANCE_REV10_4 = 4,
	SFP_SFF8472_COMPLIANCE_REV11_0 = 5,
	SFP_SFF8472_COMPLIANCE_REV11_3 = 6,
	SFP_SFF8472_COMPLIANCE_REV11_4 = 7,
	SFP_SFF8472_COMPLIANCE_REV12_0 = 8,
	SFP_CC_EXT = 95,
};

enum {
	SH_ETH_REG_GIGABIT = 0,
	SH_ETH_REG_FAST_RCAR = 1,
	SH_ETH_REG_FAST_SH4 = 2,
	SH_ETH_REG_FAST_SH3_SH2 = 3,
};

enum {
	SIL24_HOST_BAR = 0,
	SIL24_PORT_BAR = 2,
	SIL24_PRB_SZ = 64,
	SIL24_MAX_SGT = 63,
	SIL24_MAX_SGE = 253,
	HOST_SLOT_STAT = 0,
	HOST_CTRL = 64,
	HOST_IRQ_STAT___2 = 68,
	HOST_PHY_CFG = 72,
	HOST_BIST_CTRL = 80,
	HOST_BIST_PTRN = 84,
	HOST_BIST_STAT = 88,
	HOST_MEM_BIST_STAT = 92,
	HOST_FLASH_CMD = 112,
	HOST_FLASH_DATA = 116,
	HOST_TRANSITION_DETECT = 117,
	HOST_GPIO_CTRL = 118,
	HOST_I2C_ADDR = 120,
	HOST_I2C_DATA = 124,
	HOST_I2C_XFER_CNT = 126,
	HOST_I2C_CTRL = 127,
	HOST_SSTAT_ATTN = -2147483648,
	HOST_CTRL_M66EN = 65536,
	HOST_CTRL_TRDY = 131072,
	HOST_CTRL_STOP = 262144,
	HOST_CTRL_DEVSEL = 524288,
	HOST_CTRL_REQ64 = 1048576,
	HOST_CTRL_GLOBAL_RST = -2147483648,
	PORT_REGS_SIZE = 8192,
	PORT_LRAM = 0,
	PORT_LRAM_SLOT_SZ = 128,
	PORT_PMP = 3968,
	PORT_PMP_STATUS = 0,
	PORT_PMP_QACTIVE = 4,
	PORT_PMP_SIZE = 8,
	PORT_CTRL_STAT = 4096,
	PORT_CTRL_CLR = 4100,
	PORT_IRQ_STAT___2 = 4104,
	PORT_IRQ_ENABLE_SET = 4112,
	PORT_IRQ_ENABLE_CLR = 4116,
	PORT_ACTIVATE_UPPER_ADDR = 4124,
	PORT_EXEC_FIFO = 4128,
	PORT_CMD_ERR = 4132,
	PORT_FIS_CFG = 4136,
	PORT_FIFO_THRES = 4140,
	PORT_DECODE_ERR_CNT = 4160,
	PORT_DECODE_ERR_THRESH = 4162,
	PORT_CRC_ERR_CNT = 4164,
	PORT_CRC_ERR_THRESH = 4166,
	PORT_HSHK_ERR_CNT = 4168,
	PORT_HSHK_ERR_THRESH = 4170,
	PORT_PHY_CFG = 4176,
	PORT_SLOT_STAT = 6144,
	PORT_CMD_ACTIVATE = 7168,
	PORT_CONTEXT = 7684,
	PORT_EXEC_DIAG = 7680,
	PORT_PSD_DIAG = 7744,
	PORT_SCONTROL = 7936,
	PORT_SSTATUS = 7940,
	PORT_SERROR = 7944,
	PORT_SACTIVE = 7948,
	PORT_CS_PORT_RST = 1,
	PORT_CS_DEV_RST = 2,
	PORT_CS_INIT = 4,
	PORT_CS_IRQ_WOC = 8,
	PORT_CS_CDB16 = 32,
	PORT_CS_PMP_RESUME = 64,
	PORT_CS_32BIT_ACTV = 1024,
	PORT_CS_PMP_EN = 8192,
	PORT_CS_RDY = -2147483648,
	PORT_IRQ_COMPLETE = 1,
	PORT_IRQ_ERROR___2 = 2,
	PORT_IRQ_PORTRDY_CHG = 4,
	PORT_IRQ_PWR_CHG = 8,
	PORT_IRQ_PHYRDY_CHG = 16,
	PORT_IRQ_COMWAKE = 32,
	PORT_IRQ_UNK_FIS___2 = 64,
	PORT_IRQ_DEV_XCHG = 128,
	PORT_IRQ_8B10B = 256,
	PORT_IRQ_CRC = 512,
	PORT_IRQ_HANDSHAKE = 1024,
	PORT_IRQ_SDB_NOTIFY = 2048,
	DEF_PORT_IRQ___2 = 2259,
	PORT_IRQ_RAW_SHIFT = 16,
	PORT_IRQ_MASKED_MASK = 2047,
	PORT_IRQ_RAW_MASK = 134152192,
	PORT_IRQ_STEER_SHIFT = 30,
	PORT_IRQ_STEER_MASK = -1073741824,
	PORT_CERR_DEV = 1,
	PORT_CERR_SDB = 2,
	PORT_CERR_DATA = 3,
	PORT_CERR_SEND = 4,
	PORT_CERR_INCONSISTENT = 5,
	PORT_CERR_DIRECTION = 6,
	PORT_CERR_UNDERRUN = 7,
	PORT_CERR_OVERRUN = 8,
	PORT_CERR_PKT_PROT = 11,
	PORT_CERR_SGT_BOUNDARY = 16,
	PORT_CERR_SGT_TGTABRT = 17,
	PORT_CERR_SGT_MSTABRT = 18,
	PORT_CERR_SGT_PCIPERR = 19,
	PORT_CERR_CMD_BOUNDARY = 24,
	PORT_CERR_CMD_TGTABRT = 25,
	PORT_CERR_CMD_MSTABRT = 26,
	PORT_CERR_CMD_PCIPERR = 27,
	PORT_CERR_XFR_UNDEF = 32,
	PORT_CERR_XFR_TGTABRT = 33,
	PORT_CERR_XFR_MSTABRT = 34,
	PORT_CERR_XFR_PCIPERR = 35,
	PORT_CERR_SENDSERVICE = 36,
	PRB_CTRL_PROTOCOL = 1,
	PRB_CTRL_PACKET_READ = 16,
	PRB_CTRL_PACKET_WRITE = 32,
	PRB_CTRL_NIEN = 64,
	PRB_CTRL_SRST = 128,
	PRB_PROT_PACKET = 1,
	PRB_PROT_TCQ = 2,
	PRB_PROT_NCQ = 4,
	PRB_PROT_READ = 8,
	PRB_PROT_WRITE = 16,
	PRB_PROT_TRANSPARENT = 32,
	SGE_TRM = -2147483648,
	SGE_LNK = 1073741824,
	SGE_DRD = 536870912,
	SIL24_MAX_CMDS = 31,
	BID_SIL3124 = 0,
	BID_SIL3132 = 1,
	BID_SIL3131 = 2,
	SIL24_COMMON_FLAGS = 918658,
	SIL24_FLAG_PCIX_IRQ_WOC = 16777216,
	IRQ_STAT_4PORTS = 15,
};

enum {
	SILERGY_SYR82X = 8,
	SILERGY_SYR83X = 9,
};

enum {
	SKBFL_ZEROCOPY_ENABLE = 1,
	SKBFL_SHARED_FRAG = 2,
	SKBFL_PURE_ZEROCOPY = 4,
	SKBFL_DONT_ORPHAN = 8,
	SKBFL_MANAGED_FRAG_REFS = 16,
};

enum {
	SKBTX_HW_TSTAMP_NOBPF = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_COMPLETION_TSTAMP = 8,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
	SKBTX_BPF = 128,
};

enum {
	SKB_FCLONE_UNAVAILABLE = 0,
	SKB_FCLONE_ORIG = 1,
	SKB_FCLONE_CLONE = 2,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	__SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
	SKB_GSO_TCP_ACCECN = 524288,
	SKB_GSO_TCP_FIXEDID = 1073741824,
	SKB_GSO_TCP_FIXEDID_INNER = -2147483648,
};

enum {
	SKCIPHER_WALK_SLOW = 1,
	SKCIPHER_WALK_COPY = 2,
	SKCIPHER_WALK_DIFF = 4,
	SKCIPHER_WALK_SLEEP = 8,
};

enum {
	SK_BPF_CB_TX_TIMESTAMPING = 1,
	SK_BPF_CB_MASK = 1,
};

enum {
	SK_DIAG_BPF_STORAGE_NONE = 0,
	SK_DIAG_BPF_STORAGE_PAD = 1,
	SK_DIAG_BPF_STORAGE_MAP_ID = 2,
	SK_DIAG_BPF_STORAGE_MAP_VALUE = 3,
	__SK_DIAG_BPF_STORAGE_MAX = 4,
};

enum {
	SK_DIAG_BPF_STORAGE_REP_NONE = 0,
	SK_DIAG_BPF_STORAGE = 1,
	__SK_DIAG_BPF_STORAGE_REP_MAX = 2,
};

enum {
	SK_DIAG_BPF_STORAGE_REQ_NONE = 0,
	SK_DIAG_BPF_STORAGE_REQ_MAP_FD = 1,
	__SK_DIAG_BPF_STORAGE_REQ_MAX = 2,
};

enum {
	SK_MEMINFO_RMEM_ALLOC = 0,
	SK_MEMINFO_RCVBUF = 1,
	SK_MEMINFO_WMEM_ALLOC = 2,
	SK_MEMINFO_SNDBUF = 3,
	SK_MEMINFO_FWD_ALLOC = 4,
	SK_MEMINFO_WMEM_QUEUED = 5,
	SK_MEMINFO_OPTMEM = 6,
	SK_MEMINFO_BACKLOG = 7,
	SK_MEMINFO_DROPS = 8,
	SK_MEMINFO_VARS = 9,
};

enum {
	SM_EFUSE_READ = 0,
	SM_EFUSE_WRITE = 1,
	SM_EFUSE_USER_MAX = 2,
	SM_GET_CHIP_ID = 3,
	SM_A1_PWRC_SET = 4,
	SM_A1_PWRC_GET = 5,
};

enum {
	SOCK_WAKE_IO = 0,
	SOCK_WAKE_WAITD = 1,
	SOCK_WAKE_SPACE = 2,
	SOCK_WAKE_URG = 3,
};

enum {
	SOF_TIMESTAMPING_TX_HARDWARE = 1,
	SOF_TIMESTAMPING_TX_SOFTWARE = 2,
	SOF_TIMESTAMPING_RX_HARDWARE = 4,
	SOF_TIMESTAMPING_RX_SOFTWARE = 8,
	SOF_TIMESTAMPING_SOFTWARE = 16,
	SOF_TIMESTAMPING_SYS_HARDWARE = 32,
	SOF_TIMESTAMPING_RAW_HARDWARE = 64,
	SOF_TIMESTAMPING_OPT_ID = 128,
	SOF_TIMESTAMPING_TX_SCHED = 256,
	SOF_TIMESTAMPING_TX_ACK = 512,
	SOF_TIMESTAMPING_OPT_CMSG = 1024,
	SOF_TIMESTAMPING_OPT_TSONLY = 2048,
	SOF_TIMESTAMPING_OPT_STATS = 4096,
	SOF_TIMESTAMPING_OPT_PKTINFO = 8192,
	SOF_TIMESTAMPING_OPT_TX_SWHW = 16384,
	SOF_TIMESTAMPING_BIND_PHC = 32768,
	SOF_TIMESTAMPING_OPT_ID_TCP = 65536,
	SOF_TIMESTAMPING_OPT_RX_FILTER = 131072,
	SOF_TIMESTAMPING_TX_COMPLETION = 262144,
	SOF_TIMESTAMPING_LAST = 262144,
	SOF_TIMESTAMPING_MASK = 524287,
};

enum {
	SP_TASK_PENDING = 0,
	SP_NEED_VICTIM = 1,
	SP_VICTIM_REMAINS = 2,
};

enum {
	SQ_START = 0,
	SQ_STOP = 1,
	SQ_ICU = 2,
};

enum {
	SQ_STS = 1,
	SQ_CUS = 2,
};

enum {
	STATE_IDLE = 0,
	STATE_READ = 1,
	STATE_WRITE = 2,
};

enum {
	STAT_CTRL = 3712,
	STAT_LAST_IDX = 3716,
	STAT_LIST_ADDR_LO = 3720,
	STAT_LIST_ADDR_HI = 3724,
	STAT_TXA1_RIDX = 3728,
	STAT_TXS1_RIDX = 3730,
	STAT_TXA2_RIDX = 3732,
	STAT_TXS2_RIDX = 3734,
	STAT_TX_IDX_TH = 3736,
	STAT_PUT_IDX = 3740,
	STAT_FIFO_WP = 3744,
	STAT_FIFO_RP = 3748,
	STAT_FIFO_RSP = 3750,
	STAT_FIFO_LEVEL = 3752,
	STAT_FIFO_SHLVL = 3754,
	STAT_FIFO_WM = 3756,
	STAT_FIFO_ISR_WM = 3757,
	STAT_LEV_TIMER_INI = 3760,
	STAT_LEV_TIMER_CNT = 3764,
	STAT_LEV_TIMER_CTRL = 3768,
	STAT_LEV_TIMER_TEST = 3769,
	STAT_TX_TIMER_INI = 3776,
	STAT_TX_TIMER_CNT = 3780,
	STAT_TX_TIMER_CTRL = 3784,
	STAT_TX_TIMER_TEST = 3785,
	STAT_ISR_TIMER_INI = 3792,
	STAT_ISR_TIMER_CNT = 3796,
	STAT_ISR_TIMER_CTRL = 3800,
	STAT_ISR_TIMER_TEST = 3801,
};

enum {
	SUNXI_SRC_TYPE_LEVEL_LOW = 0,
	SUNXI_SRC_TYPE_EDGE_FALLING = 1,
	SUNXI_SRC_TYPE_LEVEL_HIGH = 2,
	SUNXI_SRC_TYPE_EDGE_RISING = 3,
};

enum {
	SVC_HANDSHAKE_TO = 1250,
};

enum {
	SVC_POOL_AUTO = -1,
	SVC_POOL_GLOBAL = 0,
	SVC_POOL_PERCPU = 1,
	SVC_POOL_PERNODE = 2,
};

enum {
	SWITCHTEC_GAS_MRPC_OFFSET = 0,
	SWITCHTEC_GAS_TOP_CFG_OFFSET = 4096,
	SWITCHTEC_GAS_SW_EVENT_OFFSET = 6144,
	SWITCHTEC_GAS_SYS_INFO_OFFSET = 8192,
	SWITCHTEC_GAS_FLASH_INFO_OFFSET = 8704,
	SWITCHTEC_GAS_PART_CFG_OFFSET = 16384,
	SWITCHTEC_GAS_NTB_OFFSET = 65536,
	SWITCHTEC_GAS_PFF_CSR_OFFSET = 1261568,
};

enum {
	SWITCHTEC_NTB_REG_INFO_OFFSET = 0,
	SWITCHTEC_NTB_REG_CTRL_OFFSET = 16384,
	SWITCHTEC_NTB_REG_DBMSG_OFFSET = 409600,
};

enum {
	SWMII_SPEED_10 = 0,
	SWMII_SPEED_100 = 1,
	SWMII_SPEED_1000 = 2,
	SWMII_DUPLEX_HALF = 0,
	SWMII_DUPLEX_FULL = 1,
};

enum {
	SWP_USED = 1,
	SWP_WRITEOK = 2,
	SWP_DISCARDABLE = 4,
	SWP_DISCARDING = 8,
	SWP_SOLIDSTATE = 16,
	SWP_CONTINUED = 32,
	SWP_BLKDEV = 64,
	SWP_ACTIVATED = 128,
	SWP_FS_OPS = 256,
	SWP_AREA_DISCARD = 512,
	SWP_PAGE_DISCARD = 1024,
	SWP_STABLE_WRITES = 2048,
	SWP_SYNCHRONOUS_IO = 4096,
};

enum {
	SYNC_LEN_G1 = 80000,
	SYNC_LEN_G2 = 40000,
	SYNC_LEN_G3 = 20000,
};

enum {
	TASKLET_STATE_SCHED = 0,
	TASKLET_STATE_RUN = 1,
};

enum {
	TASKSTATS_CMD_ATTR_UNSPEC = 0,
	TASKSTATS_CMD_ATTR_PID = 1,
	TASKSTATS_CMD_ATTR_TGID = 2,
	TASKSTATS_CMD_ATTR_REGISTER_CPUMASK = 3,
	TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK = 4,
	__TASKSTATS_CMD_ATTR_MAX = 5,
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum {
	TASKSTATS_TYPE_UNSPEC = 0,
	TASKSTATS_TYPE_PID = 1,
	TASKSTATS_TYPE_TGID = 2,
	TASKSTATS_TYPE_STATS = 3,
	TASKSTATS_TYPE_AGGR_PID = 4,
	TASKSTATS_TYPE_AGGR_TGID = 5,
	TASKSTATS_TYPE_NULL = 6,
	__TASKSTATS_TYPE_MAX = 7,
};

enum {
	TASK_REQ_UPIU_SIZE_DWORDS = 8,
	TASK_RSP_UPIU_SIZE_DWORDS = 8,
	ALIGNED_UPIU_SIZE = 512,
};

enum {
	TBMU_TEST_BMU_TX_CHK_AUTO_OFF = -2147483648,
	TBMU_TEST_BMU_TX_CHK_AUTO_ON = 1073741824,
	TBMU_TEST_HOME_ADD_PAD_FIX1_EN = 536870912,
	TBMU_TEST_HOME_ADD_PAD_FIX1_DIS = 268435456,
	TBMU_TEST_ROUTING_ADD_FIX_EN = 134217728,
	TBMU_TEST_ROUTING_ADD_FIX_DIS = 67108864,
	TBMU_TEST_HOME_ADD_FIX_EN = 33554432,
	TBMU_TEST_HOME_ADD_FIX_DIS = 16777216,
	TBMU_TEST_TEST_RSPTR_ON = 4194304,
	TBMU_TEST_TEST_RSPTR_OFF = 2097152,
	TBMU_TEST_TESTSTEP_RSPTR = 1048576,
	TBMU_TEST_TEST_RPTR_ON = 262144,
	TBMU_TEST_TEST_RPTR_OFF = 131072,
	TBMU_TEST_TESTSTEP_RPTR = 65536,
	TBMU_TEST_TEST_WSPTR_ON = 16384,
	TBMU_TEST_TEST_WSPTR_OFF = 8192,
	TBMU_TEST_TESTSTEP_WSPTR = 4096,
	TBMU_TEST_TEST_WPTR_ON = 1024,
	TBMU_TEST_TEST_WPTR_OFF = 512,
	TBMU_TEST_TESTSTEP_WPTR = 256,
	TBMU_TEST_TEST_REQ_NB_ON = 64,
	TBMU_TEST_TEST_REQ_NB_OFF = 32,
	TBMU_TEST_TESTSTEP_REQ_NB = 16,
	TBMU_TEST_TEST_DONE_IDX_ON = 4,
	TBMU_TEST_TEST_DONE_IDX_OFF = 2,
	TBMU_TEST_TESTSTEP_DONE_IDX = 1,
};

enum {
	TCA_ACT_UNSPEC = 0,
	TCA_ACT_KIND = 1,
	TCA_ACT_OPTIONS = 2,
	TCA_ACT_INDEX = 3,
	TCA_ACT_STATS = 4,
	TCA_ACT_PAD = 5,
	TCA_ACT_COOKIE = 6,
	TCA_ACT_FLAGS = 7,
	TCA_ACT_HW_STATS = 8,
	TCA_ACT_USED_HW_STATS = 9,
	TCA_ACT_IN_HW_COUNT = 10,
	__TCA_ACT_MAX = 11,
};

enum {
	TCA_EMATCH_TREE_UNSPEC = 0,
	TCA_EMATCH_TREE_HDR = 1,
	TCA_EMATCH_TREE_LIST = 2,
	__TCA_EMATCH_TREE_MAX = 3,
};

enum {
	TCA_FLOWER_KEY_CT_FLAGS_NEW = 1,
	TCA_FLOWER_KEY_CT_FLAGS_ESTABLISHED = 2,
	TCA_FLOWER_KEY_CT_FLAGS_RELATED = 4,
	TCA_FLOWER_KEY_CT_FLAGS_TRACKED = 8,
	TCA_FLOWER_KEY_CT_FLAGS_INVALID = 16,
	TCA_FLOWER_KEY_CT_FLAGS_REPLY = 32,
	__TCA_FLOWER_KEY_CT_FLAGS_MAX = 33,
};

enum {
	TCA_ROOT_UNSPEC = 0,
	TCA_ROOT_TAB = 1,
	TCA_ROOT_FLAGS = 2,
	TCA_ROOT_COUNT = 3,
	TCA_ROOT_TIME_DELTA = 4,
	TCA_ROOT_EXT_WARN_MSG = 5,
	__TCA_ROOT_MAX = 6,
};

enum {
	TCA_STAB_UNSPEC = 0,
	TCA_STAB_BASE = 1,
	TCA_STAB_DATA = 2,
	__TCA_STAB_MAX = 3,
};

enum {
	TCA_STATS_UNSPEC = 0,
	TCA_STATS_BASIC = 1,
	TCA_STATS_RATE_EST = 2,
	TCA_STATS_QUEUE = 3,
	TCA_STATS_APP = 4,
	TCA_STATS_RATE_EST64 = 5,
	TCA_STATS_PAD = 6,
	TCA_STATS_BASIC_HW = 7,
	TCA_STATS_PKT64 = 8,
	__TCA_STATS_MAX = 9,
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

enum {
	TCPF_ESTABLISHED = 2,
	TCPF_SYN_SENT = 4,
	TCPF_SYN_RECV = 8,
	TCPF_FIN_WAIT1 = 16,
	TCPF_FIN_WAIT2 = 32,
	TCPF_TIME_WAIT = 64,
	TCPF_CLOSE = 128,
	TCPF_CLOSE_WAIT = 256,
	TCPF_LAST_ACK = 512,
	TCPF_LISTEN = 1024,
	TCPF_CLOSING = 2048,
	TCPF_NEW_SYN_RECV = 4096,
	TCPF_BOUND_INACTIVE = 8192,
};

enum {
	TCP_BPF_BASE = 0,
	TCP_BPF_TX = 1,
	TCP_BPF_RX = 2,
	TCP_BPF_TXRX = 3,
	TCP_BPF_NUM_CFGS = 4,
};

enum {
	TCP_BPF_IPV4 = 0,
	TCP_BPF_IPV6 = 1,
	TCP_BPF_NUM_PROTS = 2,
};

enum {
	TCP_BPF_IW = 1001,
	TCP_BPF_SNDCWND_CLAMP = 1002,
	TCP_BPF_DELACK_MAX = 1003,
	TCP_BPF_RTO_MIN = 1004,
	TCP_BPF_SYN = 1005,
	TCP_BPF_SYN_IP = 1006,
	TCP_BPF_SYN_MAC = 1007,
	TCP_BPF_SOCK_OPS_CB_FLAGS = 1008,
	SK_BPF_CB_FLAGS = 1009,
};

enum {
	TCP_CMSG_INQ = 1,
	TCP_CMSG_TS = 2,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_BOUND_INACTIVE = 13,
	TCP_MAX_STATES = 14,
};

enum {
	TCP_FLAG_AE = 1,
	TCP_FLAG_CWR = 32768,
	TCP_FLAG_ECE = 16384,
	TCP_FLAG_URG = 8192,
	TCP_FLAG_ACK = 4096,
	TCP_FLAG_PSH = 2048,
	TCP_FLAG_RST = 1024,
	TCP_FLAG_SYN = 512,
	TCP_FLAG_FIN = 256,
	TCP_RESERVED_BITS = 14,
	TCP_DATA_OFFSET = 240,
};

enum {
	TCP_METRICS_ATTR_UNSPEC = 0,
	TCP_METRICS_ATTR_ADDR_IPV4 = 1,
	TCP_METRICS_ATTR_ADDR_IPV6 = 2,
	TCP_METRICS_ATTR_AGE = 3,
	TCP_METRICS_ATTR_TW_TSVAL = 4,
	TCP_METRICS_ATTR_TW_TS_STAMP = 5,
	TCP_METRICS_ATTR_VALS = 6,
	TCP_METRICS_ATTR_FOPEN_MSS = 7,
	TCP_METRICS_ATTR_FOPEN_SYN_DROPS = 8,
	TCP_METRICS_ATTR_FOPEN_SYN_DROP_TS = 9,
	TCP_METRICS_ATTR_FOPEN_COOKIE = 10,
	TCP_METRICS_ATTR_SADDR_IPV4 = 11,
	TCP_METRICS_ATTR_SADDR_IPV6 = 12,
	TCP_METRICS_ATTR_PAD = 13,
	__TCP_METRICS_ATTR_MAX = 14,
};

enum {
	TCP_METRICS_CMD_UNSPEC = 0,
	TCP_METRICS_CMD_GET = 1,
	TCP_METRICS_CMD_DEL = 2,
	__TCP_METRICS_CMD_MAX = 3,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	TCP_NLA_PAD = 0,
	TCP_NLA_BUSY = 1,
	TCP_NLA_RWND_LIMITED = 2,
	TCP_NLA_SNDBUF_LIMITED = 3,
	TCP_NLA_DATA_SEGS_OUT = 4,
	TCP_NLA_TOTAL_RETRANS = 5,
	TCP_NLA_PACING_RATE = 6,
	TCP_NLA_DELIVERY_RATE = 7,
	TCP_NLA_SND_CWND = 8,
	TCP_NLA_REORDERING = 9,
	TCP_NLA_MIN_RTT = 10,
	TCP_NLA_RECUR_RETRANS = 11,
	TCP_NLA_DELIVERY_RATE_APP_LMT = 12,
	TCP_NLA_SNDQ_SIZE = 13,
	TCP_NLA_CA_STATE = 14,
	TCP_NLA_SND_SSTHRESH = 15,
	TCP_NLA_DELIVERED = 16,
	TCP_NLA_DELIVERED_CE = 17,
	TCP_NLA_BYTES_SENT = 18,
	TCP_NLA_BYTES_RETRANS = 19,
	TCP_NLA_DSACK_DUPS = 20,
	TCP_NLA_REORD_SEEN = 21,
	TCP_NLA_SRTT = 22,
	TCP_NLA_TIMEOUT_REHASH = 23,
	TCP_NLA_BYTES_NOTSENT = 24,
	TCP_NLA_EDT = 25,
	TCP_NLA_TTL = 26,
	TCP_NLA_REHASH = 27,
};

enum {
	TCP_NO_QUEUE = 0,
	TCP_RECV_QUEUE = 1,
	TCP_SEND_QUEUE = 2,
	TCP_QUEUES_NR = 3,
};

enum {
	TCP_V4_FLOW = 1,
	UDP_V4_FLOW = 2,
	SCTP_V4_FLOW = 3,
	AH_ESP_V4_FLOW = 4,
	TCP_V6_FLOW = 5,
	UDP_V6_FLOW = 6,
	SCTP_V6_FLOW = 7,
	AH_ESP_V6_FLOW = 8,
	AH_V4_FLOW = 9,
	ESP_V4_FLOW = 10,
	AH_V6_FLOW = 11,
	ESP_V6_FLOW = 12,
	IPV4_USER_FLOW = 13,
	IP_USER_FLOW = 13,
	IPV6_USER_FLOW = 14,
	IPV4_FLOW = 16,
	IPV6_FLOW = 17,
	ETHER_FLOW = 18,
	GTPU_V4_FLOW = 19,
	GTPU_V6_FLOW = 20,
	GTPC_V4_FLOW = 21,
	GTPC_V6_FLOW = 22,
	GTPC_TEID_V4_FLOW = 23,
	GTPC_TEID_V6_FLOW = 24,
	GTPU_EH_V4_FLOW = 25,
	GTPU_EH_V6_FLOW = 26,
	GTPU_UL_V4_FLOW = 27,
	GTPU_UL_V6_FLOW = 28,
	GTPU_DL_V4_FLOW = 29,
	GTPU_DL_V6_FLOW = 30,
	__FLOW_TYPE_COUNT = 31,
};

enum {
	TCS4525_CHIP_ID_12 = 12,
};

enum {
	TC_MQPRIO_HW_OFFLOAD_NONE = 0,
	TC_MQPRIO_HW_OFFLOAD_TCS = 1,
	__TC_MQPRIO_HW_OFFLOAD_MAX = 2,
};

enum {
	TC_MQPRIO_MODE_DCB = 0,
	TC_MQPRIO_MODE_CHANNEL = 1,
	__TC_MQPRIO_MODE_MAX = 2,
};

enum {
	TC_MQPRIO_SHAPER_DCB = 0,
	TC_MQPRIO_SHAPER_BW_RATE = 1,
	__TC_MQPRIO_SHAPER_MAX = 2,
};

enum {
	TC_TAPRIO_CMD_SET_GATES = 0,
	TC_TAPRIO_CMD_SET_AND_HOLD = 1,
	TC_TAPRIO_CMD_SET_AND_RELEASE = 2,
};

enum {
	TEST_NONE = 0,
	TEST_CORE = 1,
	TEST_CPUS = 2,
	TEST_PLATFORM = 3,
	TEST_DEVICES = 4,
	TEST_FREEZER = 5,
	__TEST_AFTER_LAST = 6,
};

enum {
	THRESHOLD_INDEX_0 = 0,
	THRESHOLD_INDEX_1 = 1,
	THRESHOLD_INDEX_COUNT = 2,
};

enum {
	TIM_START = 4,
	TIM_STOP = 2,
	TIM_CLR_IRQ = 1,
};

enum {
	TLS_ALERT_DESC_CLOSE_NOTIFY = 0,
	TLS_ALERT_DESC_UNEXPECTED_MESSAGE = 10,
	TLS_ALERT_DESC_BAD_RECORD_MAC = 20,
	TLS_ALERT_DESC_RECORD_OVERFLOW = 22,
	TLS_ALERT_DESC_HANDSHAKE_FAILURE = 40,
	TLS_ALERT_DESC_BAD_CERTIFICATE = 42,
	TLS_ALERT_DESC_UNSUPPORTED_CERTIFICATE = 43,
	TLS_ALERT_DESC_CERTIFICATE_REVOKED = 44,
	TLS_ALERT_DESC_CERTIFICATE_EXPIRED = 45,
	TLS_ALERT_DESC_CERTIFICATE_UNKNOWN = 46,
	TLS_ALERT_DESC_ILLEGAL_PARAMETER = 47,
	TLS_ALERT_DESC_UNKNOWN_CA = 48,
	TLS_ALERT_DESC_ACCESS_DENIED = 49,
	TLS_ALERT_DESC_DECODE_ERROR = 50,
	TLS_ALERT_DESC_DECRYPT_ERROR = 51,
	TLS_ALERT_DESC_TOO_MANY_CIDS_REQUESTED = 52,
	TLS_ALERT_DESC_PROTOCOL_VERSION = 70,
	TLS_ALERT_DESC_INSUFFICIENT_SECURITY = 71,
	TLS_ALERT_DESC_INTERNAL_ERROR = 80,
	TLS_ALERT_DESC_INAPPROPRIATE_FALLBACK = 86,
	TLS_ALERT_DESC_USER_CANCELED = 90,
	TLS_ALERT_DESC_MISSING_EXTENSION = 109,
	TLS_ALERT_DESC_UNSUPPORTED_EXTENSION = 110,
	TLS_ALERT_DESC_UNRECOGNIZED_NAME = 112,
	TLS_ALERT_DESC_BAD_CERTIFICATE_STATUS_RESPONSE = 113,
	TLS_ALERT_DESC_UNKNOWN_PSK_IDENTITY = 115,
	TLS_ALERT_DESC_CERTIFICATE_REQUIRED = 116,
	TLS_ALERT_DESC_NO_APPLICATION_PROTOCOL = 120,
};

enum {
	TLS_ALERT_LEVEL_WARNING = 1,
	TLS_ALERT_LEVEL_FATAL = 2,
};

enum {
	TLS_NO_KEYRING = 0,
	TLS_NO_PEERID = 0,
	TLS_NO_CERT = 0,
	TLS_NO_PRIVKEY = 0,
};

enum {
	TLS_RECORD_TYPE_CHANGE_CIPHER_SPEC = 20,
	TLS_RECORD_TYPE_ALERT = 21,
	TLS_RECORD_TYPE_HANDSHAKE = 22,
	TLS_RECORD_TYPE_DATA = 23,
	TLS_RECORD_TYPE_HEARTBEAT = 24,
	TLS_RECORD_TYPE_TLS12_CID = 25,
	TLS_RECORD_TYPE_ACK = 26,
};

enum {
	TOKEN_END = 0,
	TOKEN_START = 1,
	TOKEN_SLAVE_ADDR_WRITE = 2,
	TOKEN_SLAVE_ADDR_READ = 3,
	TOKEN_DATA = 4,
	TOKEN_DATA_LAST = 5,
	TOKEN_STOP = 6,
};

enum {
	TRACE_SIGNAL_DELIVERED = 0,
	TRACE_SIGNAL_IGNORED = 1,
	TRACE_SIGNAL_ALREADY_PENDING = 2,
	TRACE_SIGNAL_OVERFLOW_FAIL = 3,
	TRACE_SIGNAL_LOSE_INFO = 4,
};

enum {
	TRANS_MODE_PIO = 0,
	TRANS_MODE_IDMAC = 1,
	TRANS_MODE_EDMAC = 2,
};

enum {
	TRANS_TX_FAIL_BASE___2 = 0,
	TRANS_RX_FAIL_BASE___2 = 32,
	DMA_TX_ERR_BASE___2 = 64,
	SIPC_RX_ERR_BASE = 80,
	DMA_RX_ERR_BASE___2 = 96,
	TRANS_TX_OPEN_FAIL_WITH_IT_NEXUS_LOSS = 0,
	TRANS_TX_ERR_PHY_NOT_ENABLE = 1,
	TRANS_TX_OPEN_CNX_ERR_WRONG_DESTINATION = 2,
	TRANS_TX_OPEN_CNX_ERR_ZONE_VIOLATION = 3,
	TRANS_TX_OPEN_CNX_ERR_BY_OTHER = 4,
	RESERVED0 = 5,
	TRANS_TX_OPEN_CNX_ERR_AIP_TIMEOUT = 6,
	TRANS_TX_OPEN_CNX_ERR_STP_RESOURCES_BUSY = 7,
	TRANS_TX_OPEN_CNX_ERR_PROTOCOL_NOT_SUPPORTED = 8,
	TRANS_TX_OPEN_CNX_ERR_CONNECTION_RATE_NOT_SUPPORTED = 9,
	TRANS_TX_OPEN_CNX_ERR_BAD_DESTINATION = 10,
	TRANS_TX_OPEN_CNX_ERR_BREAK_RCVD = 11,
	TRANS_TX_OPEN_CNX_ERR_LOW_PHY_POWER = 12,
	TRANS_TX_OPEN_CNX_ERR_PATHWAY_BLOCKED = 13,
	TRANS_TX_OPEN_CNX_ERR_OPEN_TIMEOUT = 14,
	TRANS_TX_OPEN_CNX_ERR_NO_DESTINATION = 15,
	TRANS_TX_OPEN_RETRY_ERR_THRESHOLD_REACHED = 16,
	TRANS_TX_ERR_FRAME_TXED = 17,
	TRANS_TX_ERR_WITH_BREAK_TIMEOUT = 18,
	TRANS_TX_ERR_WITH_BREAK_REQUEST = 19,
	TRANS_TX_ERR_WITH_BREAK_RECEVIED = 20,
	TRANS_TX_ERR_WITH_CLOSE_TIMEOUT = 21,
	TRANS_TX_ERR_WITH_CLOSE_NORMAL = 22,
	TRANS_TX_ERR_WITH_CLOSE_PHYDISALE = 23,
	TRANS_TX_ERR_WITH_CLOSE_DWS_TIMEOUT = 24,
	TRANS_TX_ERR_WITH_CLOSE_COMINIT = 25,
	TRANS_TX_ERR_WITH_NAK_RECEVIED = 26,
	TRANS_TX_ERR_WITH_ACK_NAK_TIMEOUT = 27,
	TRANS_TX_ERR_WITH_CREDIT_TIMEOUT = 28,
	TRANS_TX_ERR_WITH_IPTT_CONFLICT = 29,
	TRANS_TX_ERR_WITH_OPEN_BY_DES_OR_OTHERS = 30,
	TRANS_TX_ERR_WITH_WAIT_RECV_TIMEOUT = 31,
	TRANS_RX_ERR_WITH_RXFRAME_CRC_ERR = 32,
	TRANS_RX_ERR_WITH_RXFIS_8B10B_DISP_ERR = 33,
	TRANS_RX_ERR_WITH_RXFRAME_HAVE_ERRPRM = 34,
	TRANS_RX_ERR_WITH_RXFIS_DECODE_ERROR = 35,
	TRANS_RX_ERR_WITH_RXFIS_CRC_ERR = 36,
	TRANS_RX_ERR_WITH_RXFRAME_LENGTH_OVERRUN = 37,
	TRANS_RX_ERR_WITH_RXFIS_RX_SYNCP = 38,
	TRANS_RX_ERR_WITH_LINK_BUF_OVERRUN = 39,
	TRANS_RX_ERR_WITH_BREAK_TIMEOUT = 40,
	TRANS_RX_ERR_WITH_BREAK_REQUEST = 41,
	TRANS_RX_ERR_WITH_BREAK_RECEVIED = 42,
	RESERVED1 = 43,
	TRANS_RX_ERR_WITH_CLOSE_NORMAL = 44,
	TRANS_RX_ERR_WITH_CLOSE_PHY_DISABLE = 45,
	TRANS_RX_ERR_WITH_CLOSE_DWS_TIMEOUT = 46,
	TRANS_RX_ERR_WITH_CLOSE_COMINIT = 47,
	TRANS_RX_ERR_WITH_DATA_LEN0 = 48,
	TRANS_RX_ERR_WITH_BAD_HASH = 49,
	TRANS_RX_XRDY_WLEN_ZERO_ERR = 50,
	TRANS_RX_SSP_FRM_LEN_ERR = 51,
	RESERVED2 = 52,
	RESERVED3 = 53,
	RESERVED4 = 54,
	RESERVED5 = 55,
	TRANS_RX_ERR_WITH_BAD_FRM_TYPE = 56,
	TRANS_RX_SMP_FRM_LEN_ERR = 57,
	TRANS_RX_SMP_RESP_TIMEOUT_ERR___2 = 58,
	RESERVED6 = 59,
	RESERVED7 = 60,
	RESERVED8 = 61,
	RESERVED9 = 62,
	TRANS_RX_R_ERR = 63,
	DMA_TX_DIF_CRC_ERR___2 = 64,
	DMA_TX_DIF_APP_ERR___2 = 65,
	DMA_TX_DIF_RPP_ERR___2 = 66,
	DMA_TX_DATA_SGL_OVERFLOW = 67,
	DMA_TX_DIF_SGL_OVERFLOW = 68,
	DMA_TX_UNEXP_XFER_ERR = 69,
	DMA_TX_UNEXP_RETRANS_ERR = 70,
	DMA_TX_XFER_LEN_OVERFLOW = 71,
	DMA_TX_XFER_OFFSET_ERR = 72,
	DMA_TX_RAM_ECC_ERR = 73,
	DMA_TX_DIF_LEN_ALIGN_ERR = 74,
	DMA_TX_MAX_ERR_CODE = 75,
	SIPC_RX_FIS_STATUS_ERR_BIT_VLD = 80,
	SIPC_RX_PIO_WRSETUP_STATUS_DRQ_ERR = 81,
	SIPC_RX_FIS_STATUS_BSY_BIT_ERR = 82,
	SIPC_RX_WRSETUP_LEN_ODD_ERR = 83,
	SIPC_RX_WRSETUP_LEN_ZERO_ERR = 84,
	SIPC_RX_WRDATA_LEN_NOT_MATCH_ERR = 85,
	SIPC_RX_NCQ_WRSETUP_OFFSET_ERR = 86,
	SIPC_RX_NCQ_WRSETUP_AUTO_ACTIVE_ERR = 87,
	SIPC_RX_SATA_UNEXP_FIS_ERR = 88,
	SIPC_RX_WRSETUP_ESTATUS_ERR = 89,
	SIPC_RX_DATA_UNDERFLOW_ERR = 90,
	SIPC_RX_MAX_ERR_CODE = 91,
	DMA_RX_DIF_CRC_ERR___2 = 96,
	DMA_RX_DIF_APP_ERR___2 = 97,
	DMA_RX_DIF_RPP_ERR___2 = 98,
	DMA_RX_DATA_SGL_OVERFLOW = 99,
	DMA_RX_DIF_SGL_OVERFLOW = 100,
	DMA_RX_DATA_LEN_OVERFLOW = 101,
	DMA_RX_DATA_LEN_UNDERFLOW = 102,
	DMA_RX_DATA_OFFSET_ERR___2 = 103,
	RESERVED10 = 104,
	DMA_RX_SATA_FRAME_TYPE_ERR = 105,
	DMA_RX_RESP_BUF_OVERFLOW = 106,
	DMA_RX_UNEXP_RETRANS_RESP_ERR___2 = 107,
	DMA_RX_UNEXP_NORM_RESP_ERR = 108,
	DMA_RX_UNEXP_RDFRAME_ERR = 109,
	DMA_RX_PIO_DATA_LEN_ERR = 110,
	DMA_RX_RDSETUP_STATUS_ERR = 111,
	DMA_RX_RDSETUP_STATUS_DRQ_ERR = 112,
	DMA_RX_RDSETUP_STATUS_BSY_ERR = 113,
	DMA_RX_RDSETUP_LEN_ODD_ERR = 114,
	DMA_RX_RDSETUP_LEN_ZERO_ERR = 115,
	DMA_RX_RDSETUP_LEN_OVER_ERR = 116,
	DMA_RX_RDSETUP_OFFSET_ERR = 117,
	DMA_RX_RDSETUP_ACTIVE_ERR = 118,
	DMA_RX_RDSETUP_ESTATUS_ERR = 119,
	DMA_RX_RAM_ECC_ERR = 120,
	DMA_RX_UNKNOWN_FRM_ERR = 121,
	DMA_RX_MAX_ERR_CODE = 122,
};

enum {
	TST_FRC_DPERR_MR = 128,
	TST_FRC_DPERR_MW = 64,
	TST_FRC_DPERR_TR = 32,
	TST_FRC_DPERR_TW = 16,
	TST_FRC_APERR_M = 8,
	TST_FRC_APERR_T = 4,
	TST_CFG_WRITE_ON = 2,
	TST_CFG_WRITE_OFF = 1,
};

enum {
	TXA_ENA_FSYNC = 128,
	TXA_DIS_FSYNC = 64,
	TXA_ENA_ALLOC = 32,
	TXA_DIS_ALLOC = 16,
	TXA_START_RC = 8,
	TXA_STOP_RC = 4,
	TXA_ENA_ARB = 2,
	TXA_DIS_ARB = 1,
};

enum {
	TXA_ITI_INI = 512,
	TXA_ITI_VAL = 516,
	TXA_LIM_INI = 520,
	TXA_LIM_VAL = 524,
	TXA_CTRL = 528,
	TXA_TEST = 529,
	TXA_STAT = 530,
	RSS_KEY = 544,
	RSS_CFG = 584,
};

enum {
	TX_DYN_WM_ENA = 3,
};

enum {
	TX_GMF_EA = 3392,
	TX_GMF_AE_THR = 3396,
	TX_GMF_CTRL_T = 3400,
	TX_GMF_WP = 3424,
	TX_GMF_WSP = 3428,
	TX_GMF_WLEV = 3432,
	TX_GMF_RP = 3440,
	TX_GMF_RSTP = 3444,
	TX_GMF_RLEV = 3448,
	ECU_AE_THR = 112,
	ECU_TXFF_LEV = 416,
	ECU_JUMBO_WM = 128,
};

enum {
	TX_STFW_DIS = -2147483648,
	TX_STFW_ENA = 1073741824,
	TX_VLAN_TAG_ON = 33554432,
	TX_VLAN_TAG_OFF = 16777216,
	TX_PCI_JUM_ENA = 8388608,
	TX_PCI_JUM_DIS = 4194304,
	GMF_WSP_TST_ON = 262144,
	GMF_WSP_TST_OFF = 131072,
	GMF_WSP_STEP = 65536,
	GMF_CLI_TX_FU = 64,
	GMF_CLI_TX_FC = 32,
	GMF_CLI_TX_PE = 16,
};

enum {
	T_SHARED = 1,
	T_UNBINDABLE = 2,
	T_MARKED = 4,
	T_UMOUNT_CANDIDATE = 8,
	T_SHARED_MASK = 2,
};

enum {
	UARTDM_1P1 = 1,
	UARTDM_1P2 = 2,
	UARTDM_1P3 = 3,
	UARTDM_1P4 = 4,
};

enum {
	UART_IRQ_SUM = 0,
	UART_RX_IRQ = 0,
	UART_TX_IRQ = 1,
	UART_IRQ_COUNT = 2,
};

enum {
	UDPTCP = 1,
	CALSUM = 2,
	WR_SUM = 4,
	INIT_SUM = 8,
	LOCK_SUM = 16,
	INS_VLAN = 32,
	EOP = 128,
};

enum {
	UDP_BPF_IPV4 = 0,
	UDP_BPF_IPV6 = 1,
	UDP_BPF_NUM_PROTS = 2,
};

enum {
	UDP_FLAGS_CORK = 0,
	UDP_FLAGS_NO_CHECK6_TX = 1,
	UDP_FLAGS_NO_CHECK6_RX = 2,
	UDP_FLAGS_GRO_ENABLED = 3,
	UDP_FLAGS_ACCEPT_FRAGLIST = 4,
	UDP_FLAGS_ACCEPT_L4 = 5,
	UDP_FLAGS_ENCAP_ENABLED = 6,
	UDP_FLAGS_UDPLITE_SEND_CC = 7,
	UDP_FLAGS_UDPLITE_RECV_CC = 8,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	UFSHCD_EH_IN_PROGRESS = 1,
};

enum {
	UFSHCD_MAX_CHANNEL = 0,
	UFSHCD_MAX_ID = 1,
};

enum {
	UFSHCD_NANO_AMP = 0,
	UFSHCD_MICRO_AMP = 1,
	UFSHCD_MILI_AMP = 2,
	UFSHCD_AMP = 3,
};

enum {
	UFSHCD_POLL_FROM_INTERRUPT_CONTEXT = -1,
};

enum {
	UFSHCD_UIC_DL_PA_INIT_ERROR = 1,
	UFSHCD_UIC_DL_NAC_RECEIVED_ERROR = 2,
	UFSHCD_UIC_DL_TCx_REPLAY_ERROR = 4,
	UFSHCD_UIC_NL_ERROR = 8,
	UFSHCD_UIC_TL_ERROR = 16,
	UFSHCD_UIC_DME_ERROR = 32,
	UFSHCD_UIC_PA_GENERIC_ERROR = 64,
};

enum {
	UFS_ABORT_TASK = 1,
	UFS_ABORT_TASK_SET = 2,
	UFS_CLEAR_TASK_SET = 4,
	UFS_LOGICAL_RESET = 8,
	UFS_QUERY_TASK = 128,
	UFS_QUERY_TASK_SET = 129,
};

enum {
	UFS_DEV_HIGH_TEMP_NOTIF = 16,
	UFS_DEV_LOW_TEMP_NOTIF = 32,
	UFS_DEV_EXT_TEMP_NOTIF = 64,
	UFS_DEV_HPB_SUPPORT = 128,
	UFS_DEV_WRITE_BOOSTER_SUP = 256,
	UFS_DEV_LVL_EXCEPTION_SUP = 4096,
	UFS_DEV_HID_SUPPORT = 8192,
};

enum {
	UFS_DEV_WB_BUF_RESIZE = 1,
};

enum {
	UFS_REG_OCPTHRTL = 192,
	UFS_REG_OOCPR = 196,
	UFS_REG_CDACFG = 208,
	UFS_REG_CDATX1 = 212,
	UFS_REG_CDATX2 = 216,
	UFS_REG_CDARX1 = 220,
	UFS_REG_CDARX2 = 224,
	UFS_REG_CDASTA = 228,
	UFS_REG_LBMCFG = 240,
	UFS_REG_LBMSTA = 244,
	UFS_REG_UFSMODE = 248,
	UFS_REG_HCLKDIV = 252,
};

enum {
	UFS_UPIU_REPORT_LUNS_WLUN = 129,
	UFS_UPIU_UFS_DEVICE_WLUN = 208,
	UFS_UPIU_BOOT_WLUN = 176,
	UFS_UPIU_RPMB_WLUN = 196,
};

enum {
	UIC_CMD_TIMEOUT_DEFAULT = 500,
	UIC_CMD_TIMEOUT_MAX = 5000,
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

enum {
	UNIPRO_L1_5 = 0,
	UNIPRO_L2 = 1,
	UNIPRO_L3 = 2,
	UNIPRO_L4 = 3,
	UNIPRO_DME = 4,
};

enum {
	UPIU_CMD_FLAGS_NONE = 0,
	UPIU_CMD_FLAGS_CP = 4,
	UPIU_CMD_FLAGS_WRITE = 32,
	UPIU_CMD_FLAGS_READ = 64,
};

enum {
	UPIU_COMMAND_SET_TYPE_SCSI = 0,
	UPIU_COMMAND_SET_TYPE_UFS = 1,
	UPIU_COMMAND_SET_TYPE_QUERY = 2,
};

enum {
	UPIU_QUERY_FUNC_STANDARD_READ_REQUEST = 1,
	UPIU_QUERY_FUNC_STANDARD_WRITE_REQUEST = 129,
};

enum {
	UPIU_RSP_FLAG_UNDERFLOW = 32,
	UPIU_RSP_FLAG_OVERFLOW = 64,
};

enum {
	UPIU_TASK_MANAGEMENT_FUNC_COMPL = 0,
	UPIU_TASK_MANAGEMENT_FUNC_NOT_SUPPORTED = 4,
	UPIU_TASK_MANAGEMENT_FUNC_SUCCEEDED = 8,
	UPIU_TASK_MANAGEMENT_FUNC_FAILED = 5,
	UPIU_INCORRECT_LOGICAL_UNIT_NO = 9,
};

enum {
	USB_CTRL_SETUP_SCB1_EN_SELECTOR = 0,
	USB_CTRL_SETUP_SCB2_EN_SELECTOR = 1,
	USB_CTRL_SETUP_SS_EHCI64BIT_EN_SELECTOR = 2,
	USB_CTRL_SETUP_STRAP_IPP_SEL_SELECTOR = 3,
	USB_CTRL_SETUP_OC3_DISABLE_PORT0_SELECTOR = 4,
	USB_CTRL_SETUP_OC3_DISABLE_PORT1_SELECTOR = 5,
	USB_CTRL_SETUP_OC3_DISABLE_SELECTOR = 6,
	USB_CTRL_PLL_CTL_PLL_IDDQ_PWRDN_SELECTOR = 7,
	USB_CTRL_USB_PM_BDC_SOFT_RESETB_SELECTOR = 8,
	USB_CTRL_USB_PM_XHC_SOFT_RESETB_SELECTOR = 9,
	USB_CTRL_USB_PM_USB_PWRDN_SELECTOR = 10,
	USB_CTRL_USB30_CTL1_XHC_SOFT_RESETB_SELECTOR = 11,
	USB_CTRL_USB30_CTL1_USB3_IOC_SELECTOR = 12,
	USB_CTRL_USB30_CTL1_USB3_IPP_SELECTOR = 13,
	USB_CTRL_USB_DEVICE_CTL1_PORT_MODE_SELECTOR = 14,
	USB_CTRL_USB_PM_SOFT_RESET_SELECTOR = 15,
	USB_CTRL_SETUP_CC_DRD_MODE_ENABLE_SELECTOR = 16,
	USB_CTRL_SETUP_STRAP_CC_DRD_MODE_ENABLE_SEL_SELECTOR = 17,
	USB_CTRL_USB_PM_USB20_HC_RESETB_SELECTOR = 18,
	USB_CTRL_SETUP_ENDIAN_SELECTOR = 19,
	USB_CTRL_SELECTOR_COUNT = 20,
};

enum {
	US_FL_SINGLE_LUN = 1,
	US_FL_NEED_OVERRIDE = 2,
	US_FL_SCM_MULT_TARG = 4,
	US_FL_FIX_INQUIRY = 8,
	US_FL_FIX_CAPACITY = 16,
	US_FL_IGNORE_RESIDUE = 32,
	US_FL_BULK32 = 64,
	US_FL_NOT_LOCKABLE = 128,
	US_FL_GO_SLOW = 256,
	US_FL_NO_WP_DETECT = 512,
	US_FL_MAX_SECTORS_64 = 1024,
	US_FL_IGNORE_DEVICE = 2048,
	US_FL_CAPACITY_HEURISTICS = 4096,
	US_FL_MAX_SECTORS_MIN = 8192,
	US_FL_BULK_IGNORE_TAG = 16384,
	US_FL_SANE_SENSE = 32768,
	US_FL_CAPACITY_OK = 65536,
	US_FL_BAD_SENSE = 131072,
	US_FL_NO_READ_DISC_INFO = 262144,
	US_FL_NO_READ_CAPACITY_16 = 524288,
	US_FL_INITIAL_READ10 = 1048576,
	US_FL_WRITE_CACHE = 2097152,
	US_FL_NEEDS_CAP16 = 4194304,
	US_FL_IGNORE_UAS = 8388608,
	US_FL_BROKEN_FUA = 16777216,
	US_FL_NO_ATA_1X = 33554432,
	US_FL_NO_REPORT_OPCODES = 67108864,
	US_FL_MAX_SECTORS_240 = 134217728,
	US_FL_NO_REPORT_LUNS = 268435456,
	US_FL_ALWAYS_SYNC = 536870912,
	US_FL_NO_SAME = 1073741824,
	US_FL_SENSE_AFTER_SYNC = 2147483648,
};

enum {
	UTP_CMD_TYPE_UFS_STORAGE = 1,
};

enum {
	VFIO_PCI_BAR0_REGION_INDEX = 0,
	VFIO_PCI_BAR1_REGION_INDEX = 1,
	VFIO_PCI_BAR2_REGION_INDEX = 2,
	VFIO_PCI_BAR3_REGION_INDEX = 3,
	VFIO_PCI_BAR4_REGION_INDEX = 4,
	VFIO_PCI_BAR5_REGION_INDEX = 5,
	VFIO_PCI_ROM_REGION_INDEX = 6,
	VFIO_PCI_CONFIG_REGION_INDEX = 7,
	VFIO_PCI_VGA_REGION_INDEX = 8,
	VFIO_PCI_NUM_REGIONS = 9,
};

enum {
	VFIO_PCI_INTX_IRQ_INDEX = 0,
	VFIO_PCI_MSI_IRQ_INDEX = 1,
	VFIO_PCI_MSIX_IRQ_INDEX = 2,
	VFIO_PCI_ERR_IRQ_INDEX = 3,
	VFIO_PCI_REQ_IRQ_INDEX = 4,
	VFIO_PCI_NUM_IRQS = 5,
};

enum {
	VP_MSIX_CONFIG_VECTOR = 0,
	VP_MSIX_VQ_VECTOR = 1,
};

enum {
	V_ARMADA_7K = 1,
	V_ARMADA_8K_CPM = 2,
	V_ARMADA_8K_CPS = 4,
	V_CP115_STANDALONE = 8,
	V_ARMADA_7K_8K_CPM = 3,
	V_ARMADA_7K_8K_CPS = 5,
};

enum {
	WALK_TRAILING = 1,
	WALK_MORE = 2,
	WALK_NOFOLLOW = 4,
};

enum {
	WB_BUF_MODE_LU_DEDICATED = 0,
	WB_BUF_MODE_SHARED = 1,
};

enum {
	WOL_CTL_LINK_CHG_OCC = 32768,
	WOL_CTL_MAGIC_PKT_OCC = 16384,
	WOL_CTL_PATTERN_OCC = 8192,
	WOL_CTL_CLEAR_RESULT = 4096,
	WOL_CTL_ENA_PME_ON_LINK_CHG = 2048,
	WOL_CTL_DIS_PME_ON_LINK_CHG = 1024,
	WOL_CTL_ENA_PME_ON_MAGIC_PKT = 512,
	WOL_CTL_DIS_PME_ON_MAGIC_PKT = 256,
	WOL_CTL_ENA_PME_ON_PATTERN = 128,
	WOL_CTL_DIS_PME_ON_PATTERN = 64,
	WOL_CTL_ENA_LINK_CHG_UNIT = 32,
	WOL_CTL_DIS_LINK_CHG_UNIT = 16,
	WOL_CTL_ENA_MAGIC_PKT_UNIT = 8,
	WOL_CTL_DIS_MAGIC_PKT_UNIT = 4,
	WOL_CTL_ENA_PATTERN_UNIT = 2,
	WOL_CTL_DIS_PATTERN_UNIT = 1,
};

enum {
	XA_CHECK_SCHED = 4096,
};

enum {
	XDP_ATTACHED_NONE = 0,
	XDP_ATTACHED_DRV = 1,
	XDP_ATTACHED_SKB = 2,
	XDP_ATTACHED_HW = 3,
	XDP_ATTACHED_MULTI = 4,
};

enum {
	XFRM_LOOKUP_ICMP = 1,
	XFRM_LOOKUP_QUEUE = 2,
	XFRM_LOOKUP_KEEP_DST_REF = 4,
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum {
	XPT_BUSY = 0,
	XPT_CONN = 1,
	XPT_CLOSE = 2,
	XPT_DATA = 3,
	XPT_TEMP = 4,
	XPT_DEAD = 5,
	XPT_CHNGBUF = 6,
	XPT_DEFERRED = 7,
	XPT_OLD = 8,
	XPT_LISTENER = 9,
	XPT_CACHE_AUTH = 10,
	XPT_LOCAL = 11,
	XPT_KILL_TEMP = 12,
	XPT_CONG_CTRL = 13,
	XPT_HANDSHAKE = 14,
	XPT_TLS_SESSION = 15,
	XPT_PEER_AUTH = 16,
	XPT_PEER_VALID = 17,
	XPT_RPCB_UNREG = 18,
};

enum {
	Y2_ASF_OS_PRES = 16,
	Y2_ASF_RESET = 8,
	Y2_ASF_RUNNING = 4,
	Y2_ASF_CLR_HSTI = 2,
	Y2_ASF_IRQ = 1,
	Y2_ASF_UC_STATE = 12,
	Y2_ASF_CLK_HALT = 0,
};

enum {
	Y2_B8_PREF_REGS = 1104,
	PREF_UNIT_CTRL = 0,
	PREF_UNIT_LAST_IDX = 4,
	PREF_UNIT_ADDR_LO = 8,
	PREF_UNIT_ADDR_HI = 12,
	PREF_UNIT_GET_IDX = 16,
	PREF_UNIT_PUT_IDX = 20,
	PREF_UNIT_FIFO_WP = 32,
	PREF_UNIT_FIFO_RP = 36,
	PREF_UNIT_FIFO_WM = 40,
	PREF_UNIT_FIFO_LEV = 44,
	PREF_UNIT_MASK_IDX = 4095,
};

enum {
	Y2_CLK_DIV_VAL_MSK = 16711680,
	Y2_CLK_DIV_VAL2_MSK = 14680064,
	Y2_CLK_SELECT2_MSK = 2031616,
	Y2_CLK_DIV_ENA = 2,
	Y2_CLK_DIV_DIS = 1,
};

enum {
	Y2_IS_HW_ERR = -2147483648,
	Y2_IS_STAT_BMU = 1073741824,
	Y2_IS_ASF = 536870912,
	Y2_IS_CPU_TO = 268435456,
	Y2_IS_POLL_CHK = 134217728,
	Y2_IS_TWSI_RDY = 67108864,
	Y2_IS_IRQ_SW = 33554432,
	Y2_IS_TIMINT = 16777216,
	Y2_IS_IRQ_PHY2 = 4096,
	Y2_IS_IRQ_MAC2 = 2048,
	Y2_IS_CHK_RX2 = 1024,
	Y2_IS_CHK_TXS2 = 512,
	Y2_IS_CHK_TXA2 = 256,
	Y2_IS_PSM_ACK = 128,
	Y2_IS_PTP_TIST = 64,
	Y2_IS_PHY_QLNK = 32,
	Y2_IS_IRQ_PHY1 = 16,
	Y2_IS_IRQ_MAC1 = 8,
	Y2_IS_CHK_RX1 = 4,
	Y2_IS_CHK_TXS1 = 2,
	Y2_IS_CHK_TXA1 = 1,
	Y2_IS_BASE = -1073741824,
	Y2_IS_PORT_1 = 29,
	Y2_IS_PORT_2 = 7424,
	Y2_IS_ERROR = -2147480307,
};

enum {
	Y2_IS_TIST_OV = 536870912,
	Y2_IS_SENSOR = 268435456,
	Y2_IS_MST_ERR = 134217728,
	Y2_IS_IRQ_STAT = 67108864,
	Y2_IS_PCI_EXP = 33554432,
	Y2_IS_PCI_NEXP = 16777216,
	Y2_IS_PAR_RD2 = 8192,
	Y2_IS_PAR_WR2 = 4096,
	Y2_IS_PAR_MAC2 = 2048,
	Y2_IS_PAR_RX2 = 1024,
	Y2_IS_TCP_TXS2 = 512,
	Y2_IS_TCP_TXA2 = 256,
	Y2_IS_PAR_RD1 = 32,
	Y2_IS_PAR_WR1 = 16,
	Y2_IS_PAR_MAC1 = 8,
	Y2_IS_PAR_RX1 = 4,
	Y2_IS_TCP_TXS1 = 2,
	Y2_IS_TCP_TXA1 = 1,
	Y2_HWE_L1_MASK = 63,
	Y2_HWE_L2_MASK = 16128,
	Y2_HWE_ALL_MASK = 738213695,
};

enum {
	Y2_STATUS_LNK2_INAC = 128,
	Y2_CLK_GAT_LNK2_DIS = 64,
	Y2_COR_CLK_LNK2_DIS = 32,
	Y2_PCI_CLK_LNK2_DIS = 16,
	Y2_STATUS_LNK1_INAC = 8,
	Y2_CLK_GAT_LNK1_DIS = 4,
	Y2_COR_CLK_LNK1_DIS = 2,
	Y2_PCI_CLK_LNK1_DIS = 1,
};

enum {
	Y2_VMAIN_AVAIL = 131072,
	Y2_VAUX_AVAIL = 65536,
	Y2_HW_WOL_ON = 32768,
	Y2_HW_WOL_OFF = 16384,
	Y2_ASF_ENABLE = 8192,
	Y2_ASF_DISABLE = 4096,
	Y2_CLK_RUN_ENA = 2048,
	Y2_CLK_RUN_DIS = 1024,
	Y2_LED_STAT_ON = 512,
	Y2_LED_STAT_OFF = 256,
	CS_ST_SW_IRQ = 128,
	CS_CL_SW_IRQ = 64,
	CS_STOP_DONE = 32,
	CS_STOP_MAST = 16,
	CS_MRST_CLR = 8,
	CS_MRST_SET = 4,
	CS_RST_CLR = 2,
	CS_RST_SET = 1,
};

enum {
	ZONELIST_FALLBACK = 0,
	ZONELIST_NOFALLBACK = 1,
	MAX_ZONELISTS = 2,
};

enum {
	ZSTDbss_compress = 0,
	ZSTDbss_noCompress = 1,
};

enum {
	_DQUOT_USAGE_ENABLED = 0,
	_DQUOT_LIMITS_ENABLED = 1,
	_DQUOT_SUSPENDED = 2,
	_DQUOT_STATE_FLAGS = 3,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 0,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2080527,
};

enum {
	__MVNETA_DOWN = 0,
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

enum {
	__SCHED_FEAT_PLACE_LAG = 0,
	__SCHED_FEAT_PLACE_DEADLINE_INITIAL = 1,
	__SCHED_FEAT_PLACE_REL_DEADLINE = 2,
	__SCHED_FEAT_RUN_TO_PARITY = 3,
	__SCHED_FEAT_PREEMPT_SHORT = 4,
	__SCHED_FEAT_NEXT_BUDDY = 5,
	__SCHED_FEAT_PICK_BUDDY = 6,
	__SCHED_FEAT_CACHE_HOT_BUDDY = 7,
	__SCHED_FEAT_DELAY_DEQUEUE = 8,
	__SCHED_FEAT_DELAY_ZERO = 9,
	__SCHED_FEAT_WAKEUP_PREEMPTION = 10,
	__SCHED_FEAT_HRTICK = 11,
	__SCHED_FEAT_HRTICK_DL = 12,
	__SCHED_FEAT_NONTASK_CAPACITY = 13,
	__SCHED_FEAT_TTWU_QUEUE = 14,
	__SCHED_FEAT_SIS_UTIL = 15,
	__SCHED_FEAT_WARN_DOUBLE_CLOCK = 16,
	__SCHED_FEAT_RT_PUSH_IPI = 17,
	__SCHED_FEAT_RT_RUNTIME_SHARE = 18,
	__SCHED_FEAT_LB_MIN = 19,
	__SCHED_FEAT_ATTACH_AGE_LOAD = 20,
	__SCHED_FEAT_WA_IDLE = 21,
	__SCHED_FEAT_WA_WEIGHT = 22,
	__SCHED_FEAT_WA_BIAS = 23,
	__SCHED_FEAT_UTIL_EST = 24,
	__SCHED_FEAT_LATENCY_WARN = 25,
	__SCHED_FEAT_NR = 26,
};

enum {
	__SD_BALANCE_NEWIDLE = 0,
	__SD_BALANCE_EXEC = 1,
	__SD_BALANCE_FORK = 2,
	__SD_BALANCE_WAKE = 3,
	__SD_WAKE_AFFINE = 4,
	__SD_ASYM_CPUCAPACITY = 5,
	__SD_ASYM_CPUCAPACITY_FULL = 6,
	__SD_SHARE_CPUCAPACITY = 7,
	__SD_CLUSTER = 8,
	__SD_SHARE_LLC = 9,
	__SD_SERIALIZE = 10,
	__SD_ASYM_PACKING = 11,
	__SD_PREFER_SIBLING = 12,
	__SD_NUMA = 13,
	__SD_FLAG_CNT = 14,
};

enum {
	___GFP_DMA_BIT = 0,
	___GFP_HIGHMEM_BIT = 1,
	___GFP_DMA32_BIT = 2,
	___GFP_MOVABLE_BIT = 3,
	___GFP_RECLAIMABLE_BIT = 4,
	___GFP_HIGH_BIT = 5,
	___GFP_IO_BIT = 6,
	___GFP_FS_BIT = 7,
	___GFP_ZERO_BIT = 8,
	___GFP_UNUSED_BIT = 9,
	___GFP_DIRECT_RECLAIM_BIT = 10,
	___GFP_KSWAPD_RECLAIM_BIT = 11,
	___GFP_WRITE_BIT = 12,
	___GFP_NOWARN_BIT = 13,
	___GFP_RETRY_MAYFAIL_BIT = 14,
	___GFP_NOFAIL_BIT = 15,
	___GFP_NORETRY_BIT = 16,
	___GFP_MEMALLOC_BIT = 17,
	___GFP_COMP_BIT = 18,
	___GFP_NOMEMALLOC_BIT = 19,
	___GFP_HARDWALL_BIT = 20,
	___GFP_THISNODE_BIT = 21,
	___GFP_ACCOUNT_BIT = 22,
	___GFP_ZEROTAGS_BIT = 23,
	___GFP_NO_OBJ_EXT_BIT = 24,
	___GFP_LAST_BIT = 25,
};

enum {
	attr_noop = 0,
	attr_delayed_allocation_blocks = 1,
	attr_session_write_kbytes = 2,
	attr_lifetime_write_kbytes = 3,
	attr_reserved_clusters = 4,
	attr_sra_exceeded_retry_limit = 5,
	attr_inode_readahead = 6,
	attr_trigger_test_error = 7,
	attr_first_error_time = 8,
	attr_last_error_time = 9,
	attr_clusters_in_group = 10,
	attr_mb_order = 11,
	attr_feature = 12,
	attr_pointer_pi = 13,
	attr_pointer_ui = 14,
	attr_pointer_ul = 15,
	attr_pointer_u64 = 16,
	attr_pointer_u8 = 17,
	attr_pointer_string = 18,
	attr_pointer_atomic = 19,
	attr_journal_task = 20,
};

enum {
	blank_off = 0,
	blank_normal_wait = 1,
	blank_vesa_wait = 2,
};

enum {
	cpuset = 0,
	possible = 1,
	fail = 2,
};

enum {
	dns_key_data = 0,
	dns_key_error = 1,
};

enum {
	e1000_10_half = 0,
	e1000_10_full = 1,
	e1000_100_half = 2,
	e1000_100_full = 3,
};

enum {
	e1000_igp_cable_length_10 = 10,
	e1000_igp_cable_length_20 = 20,
	e1000_igp_cable_length_30 = 30,
	e1000_igp_cable_length_40 = 40,
	e1000_igp_cable_length_50 = 50,
	e1000_igp_cable_length_60 = 60,
	e1000_igp_cable_length_70 = 70,
	e1000_igp_cable_length_80 = 80,
	e1000_igp_cable_length_90 = 90,
	e1000_igp_cable_length_100 = 100,
	e1000_igp_cable_length_110 = 110,
	e1000_igp_cable_length_115 = 115,
	e1000_igp_cable_length_120 = 120,
	e1000_igp_cable_length_130 = 130,
	e1000_igp_cable_length_140 = 140,
	e1000_igp_cable_length_150 = 150,
	e1000_igp_cable_length_160 = 160,
	e1000_igp_cable_length_170 = 170,
	e1000_igp_cable_length_180 = 180,
};

enum {
	false = 0,
	true = 1,
};

enum {
	kvm_ioeventfd_flag_nr_datamatch = 0,
	kvm_ioeventfd_flag_nr_pio = 1,
	kvm_ioeventfd_flag_nr_deassign = 2,
	kvm_ioeventfd_flag_nr_virtio_ccw_notify = 3,
	kvm_ioeventfd_flag_nr_fast_mmio = 4,
	kvm_ioeventfd_flag_nr_max = 5,
};

enum {
	none = 0,
	day = 1,
	month = 2,
	year = 3,
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

enum {
	ptr_explicit = 0,
	ptr_ext4_sb_info_offset = 1,
	ptr_ext4_super_block_offset = 2,
};

enum {
	sysctl_hung_task_timeout_secs = 0,
};

enum {
	vfio_noiommu = 0,
};

typedef enum {
	BIT_DStream_unfinished = 0,
	BIT_DStream_endOfBuffer = 1,
	BIT_DStream_completed = 2,
	BIT_DStream_overflow = 3,
} BIT_DStream_status;

typedef enum {
	EfiPciIoWidthUint8 = 0,
	EfiPciIoWidthUint16 = 1,
	EfiPciIoWidthUint32 = 2,
	EfiPciIoWidthUint64 = 3,
	EfiPciIoWidthFifoUint8 = 4,
	EfiPciIoWidthFifoUint16 = 5,
	EfiPciIoWidthFifoUint32 = 6,
	EfiPciIoWidthFifoUint64 = 7,
	EfiPciIoWidthFillUint8 = 8,
	EfiPciIoWidthFillUint16 = 9,
	EfiPciIoWidthFillUint32 = 10,
	EfiPciIoWidthFillUint64 = 11,
	EfiPciIoWidthMaximum = 12,
} EFI_PCI_IO_PROTOCOL_WIDTH;

typedef enum {
	EfiTimerCancel = 0,
	EfiTimerPeriodic = 1,
	EfiTimerRelative = 2,
} EFI_TIMER_DELAY;

typedef enum {
	ZSTD_error_no_error = 0,
	ZSTD_error_GENERIC = 1,
	ZSTD_error_prefix_unknown = 10,
	ZSTD_error_version_unsupported = 12,
	ZSTD_error_frameParameter_unsupported = 14,
	ZSTD_error_frameParameter_windowTooLarge = 16,
	ZSTD_error_corruption_detected = 20,
	ZSTD_error_checksum_wrong = 22,
	ZSTD_error_literals_headerWrong = 24,
	ZSTD_error_dictionary_corrupted = 30,
	ZSTD_error_dictionary_wrong = 32,
	ZSTD_error_dictionaryCreation_failed = 34,
	ZSTD_error_parameter_unsupported = 40,
	ZSTD_error_parameter_combination_unsupported = 41,
	ZSTD_error_parameter_outOfBound = 42,
	ZSTD_error_tableLog_tooLarge = 44,
	ZSTD_error_maxSymbolValue_tooLarge = 46,
	ZSTD_error_maxSymbolValue_tooSmall = 48,
	ZSTD_error_cannotProduce_uncompressedBlock = 49,
	ZSTD_error_stabilityCondition_notRespected = 50,
	ZSTD_error_stage_wrong = 60,
	ZSTD_error_init_missing = 62,
	ZSTD_error_memory_allocation = 64,
	ZSTD_error_workSpace_tooSmall = 66,
	ZSTD_error_dstSize_tooSmall = 70,
	ZSTD_error_srcSize_wrong = 72,
	ZSTD_error_dstBuffer_null = 74,
	ZSTD_error_noForwardProgress_destFull = 80,
	ZSTD_error_noForwardProgress_inputEmpty = 82,
	ZSTD_error_frameIndex_tooLarge = 100,
	ZSTD_error_seekableIO = 102,
	ZSTD_error_dstBuffer_wrong = 104,
	ZSTD_error_srcBuffer_wrong = 105,
	ZSTD_error_sequenceProducer_failed = 106,
	ZSTD_error_externalSequences_invalid = 107,
	ZSTD_error_maxCode = 120,
} ZSTD_ErrorCode;

typedef ZSTD_ErrorCode ERR_enum;

typedef enum {
	FSE_repeat_none = 0,
	FSE_repeat_check = 1,
	FSE_repeat_valid = 2,
} FSE_repeat;

typedef enum {
	trustInput = 0,
	checkMaxSymbolValue = 1,
} HIST_checkInput_e;

typedef enum {
	HUF_singleStream = 0,
	HUF_fourStreams = 1,
} HUF_nbStreams_e;

typedef enum {
	HUF_repeat_none = 0,
	HUF_repeat_check = 1,
	HUF_repeat_valid = 2,
} HUF_repeat;

typedef enum {
	set_basic = 0,
	set_rle = 1,
	set_compressed = 2,
	set_repeat = 3,
} SymbolEncodingType_e;

typedef enum {
	ZSTD_cpm_noAttachDict = 0,
	ZSTD_cpm_attachDict = 1,
	ZSTD_cpm_createCDict = 2,
	ZSTD_cpm_unknown = 3,
} ZSTD_CParamMode_e;

typedef enum {
	ZSTD_defaultDisallowed = 0,
	ZSTD_defaultAllowed = 1,
} ZSTD_DefaultPolicy_e;

typedef enum {
	ZSTD_e_continue = 0,
	ZSTD_e_flush = 1,
	ZSTD_e_end = 2,
} ZSTD_EndDirective;

typedef enum {
	ZSTD_frame = 0,
	ZSTD_skippableFrame = 1,
} ZSTD_FrameType_e;

typedef enum {
	zop_dynamic = 0,
	zop_predef = 1,
} ZSTD_OptPrice_e;

typedef enum {
	ZSTD_ps_auto = 0,
	ZSTD_ps_enable = 1,
	ZSTD_ps_disable = 2,
} ZSTD_ParamSwitch_e;

typedef enum {
	ZSTD_reset_session_only = 1,
	ZSTD_reset_parameters = 2,
	ZSTD_reset_session_and_parameters = 3,
} ZSTD_ResetDirective;

typedef enum {
	ZSTD_sf_noBlockDelimiters = 0,
	ZSTD_sf_explicitBlockDelimiters = 1,
} ZSTD_SequenceFormat_e;

typedef enum {
	ZSTD_bm_buffered = 0,
	ZSTD_bm_stable = 1,
} ZSTD_bufferMode_e;

typedef enum {
	ZSTDb_not_buffered = 0,
	ZSTDb_buffered = 1,
} ZSTD_buffered_policy_e;

typedef enum {
	ZSTD_c_compressionLevel = 100,
	ZSTD_c_windowLog = 101,
	ZSTD_c_hashLog = 102,
	ZSTD_c_chainLog = 103,
	ZSTD_c_searchLog = 104,
	ZSTD_c_minMatch = 105,
	ZSTD_c_targetLength = 106,
	ZSTD_c_strategy = 107,
	ZSTD_c_targetCBlockSize = 130,
	ZSTD_c_enableLongDistanceMatching = 160,
	ZSTD_c_ldmHashLog = 161,
	ZSTD_c_ldmMinMatch = 162,
	ZSTD_c_ldmBucketSizeLog = 163,
	ZSTD_c_ldmHashRateLog = 164,
	ZSTD_c_contentSizeFlag = 200,
	ZSTD_c_checksumFlag = 201,
	ZSTD_c_dictIDFlag = 202,
	ZSTD_c_nbWorkers = 400,
	ZSTD_c_jobSize = 401,
	ZSTD_c_overlapLog = 402,
	ZSTD_c_experimentalParam1 = 500,
	ZSTD_c_experimentalParam2 = 10,
	ZSTD_c_experimentalParam3 = 1000,
	ZSTD_c_experimentalParam4 = 1001,
	ZSTD_c_experimentalParam5 = 1002,
	ZSTD_c_experimentalParam7 = 1004,
	ZSTD_c_experimentalParam8 = 1005,
	ZSTD_c_experimentalParam9 = 1006,
	ZSTD_c_experimentalParam10 = 1007,
	ZSTD_c_experimentalParam11 = 1008,
	ZSTD_c_experimentalParam12 = 1009,
	ZSTD_c_experimentalParam13 = 1010,
	ZSTD_c_experimentalParam14 = 1011,
	ZSTD_c_experimentalParam15 = 1012,
	ZSTD_c_experimentalParam16 = 1013,
	ZSTD_c_experimentalParam17 = 1014,
	ZSTD_c_experimentalParam18 = 1015,
	ZSTD_c_experimentalParam19 = 1016,
	ZSTD_c_experimentalParam20 = 1017,
} ZSTD_cParameter;

typedef enum {
	zcss_init = 0,
	zcss_load = 1,
	zcss_flush = 2,
} ZSTD_cStreamStage;

typedef enum {
	ZSTDcrp_makeClean = 0,
	ZSTDcrp_leaveDirty = 1,
} ZSTD_compResetPolicy_e;

typedef enum {
	ZSTDcs_created = 0,
	ZSTDcs_init = 1,
	ZSTDcs_ongoing = 2,
	ZSTDcs_ending = 3,
} ZSTD_compressionStage_e;

typedef enum {
	ZSTD_cwksp_alloc_objects = 0,
	ZSTD_cwksp_alloc_aligned_init_once = 1,
	ZSTD_cwksp_alloc_aligned = 2,
	ZSTD_cwksp_alloc_buffers = 3,
} ZSTD_cwksp_alloc_phase_e;

typedef enum {
	ZSTD_cwksp_dynamic_alloc = 0,
	ZSTD_cwksp_static_alloc = 1,
} ZSTD_cwksp_static_alloc_e;

typedef enum {
	ZSTD_d_windowLogMax = 100,
	ZSTD_d_experimentalParam1 = 1000,
	ZSTD_d_experimentalParam2 = 1001,
	ZSTD_d_experimentalParam3 = 1002,
	ZSTD_d_experimentalParam4 = 1003,
	ZSTD_d_experimentalParam5 = 1004,
	ZSTD_d_experimentalParam6 = 1005,
} ZSTD_dParameter;

typedef enum {
	ZSTDds_getFrameHeaderSize = 0,
	ZSTDds_decodeFrameHeader = 1,
	ZSTDds_decodeBlockHeader = 2,
	ZSTDds_decompressBlock = 3,
	ZSTDds_decompressLastBlock = 4,
	ZSTDds_checkChecksum = 5,
	ZSTDds_decodeSkippableHeader = 6,
	ZSTDds_skipFrame = 7,
} ZSTD_dStage;

typedef enum {
	zdss_init = 0,
	zdss_loadHeader = 1,
	zdss_read = 2,
	zdss_load = 3,
	zdss_flush = 4,
} ZSTD_dStreamStage;

typedef enum {
	ZSTD_dictDefaultAttach = 0,
	ZSTD_dictForceAttach = 1,
	ZSTD_dictForceCopy = 2,
	ZSTD_dictForceLoad = 3,
} ZSTD_dictAttachPref_e;

typedef enum {
	ZSTD_dct_auto = 0,
	ZSTD_dct_rawContent = 1,
	ZSTD_dct_fullDict = 2,
} ZSTD_dictContentType_e;

typedef enum {
	ZSTD_dlm_byCopy = 0,
	ZSTD_dlm_byRef = 1,
} ZSTD_dictLoadMethod_e;

typedef enum {
	ZSTD_noDict = 0,
	ZSTD_extDict = 1,
	ZSTD_dictMatchState = 2,
	ZSTD_dedicatedDictSearch = 3,
} ZSTD_dictMode_e;

typedef enum {
	ZSTD_dtlm_fast = 0,
	ZSTD_dtlm_full = 1,
} ZSTD_dictTableLoadMethod_e;

typedef enum {
	ZSTD_use_indefinitely = -1,
	ZSTD_dont_use = 0,
	ZSTD_use_once = 1,
} ZSTD_dictUses_e;

typedef enum {
	ZSTD_d_validateChecksum = 0,
	ZSTD_d_ignoreChecksum = 1,
} ZSTD_forceIgnoreChecksum_e;

typedef enum {
	ZSTD_f_zstd1 = 0,
	ZSTD_f_zstd1_magicless = 1,
} ZSTD_format_e;

typedef enum {
	ZSTDirp_continue = 0,
	ZSTDirp_reset = 1,
} ZSTD_indexResetPolicy_e;

typedef enum {
	ZSTD_not_in_dst = 0,
	ZSTD_in_dst = 1,
	ZSTD_split = 2,
} ZSTD_litLocation_e;

typedef enum {
	ZSTD_llt_none = 0,
	ZSTD_llt_literalLength = 1,
	ZSTD_llt_matchLength = 2,
} ZSTD_longLengthType_e;

typedef enum {
	ZSTD_lo_isRegularOffset = 0,
	ZSTD_lo_isLongOffset = 1,
} ZSTD_longOffset_e;

typedef enum {
	ZSTDnit_frameHeader = 0,
	ZSTDnit_blockHeader = 1,
	ZSTDnit_block = 2,
	ZSTDnit_lastBlock = 3,
	ZSTDnit_checksum = 4,
	ZSTDnit_skippableFrame = 5,
} ZSTD_nextInputType_e;

typedef enum {
	ZSTD_no_overlap = 0,
	ZSTD_overlap_src_before_dst = 1,
} ZSTD_overlap_e;

typedef enum {
	ZSTD_rmd_refSingleDDict = 0,
	ZSTD_rmd_refMultipleDDicts = 1,
} ZSTD_refMultipleDDicts_e;

typedef enum {
	ZSTD_resetTarget_CDict = 0,
	ZSTD_resetTarget_CCtx = 1,
} ZSTD_resetTarget_e;

typedef enum {
	ZSTD_fast = 1,
	ZSTD_dfast = 2,
	ZSTD_greedy = 3,
	ZSTD_lazy = 4,
	ZSTD_lazy2 = 5,
	ZSTD_btlazy2 = 6,
	ZSTD_btopt = 7,
	ZSTD_btultra = 8,
	ZSTD_btultra2 = 9,
} ZSTD_strategy;

typedef enum {
	ZSTD_tfp_forCCtx = 0,
	ZSTD_tfp_forCDict = 1,
} ZSTD_tableFillPurpose_e;

typedef enum {
	OSL_GLOBAL_LOCK_HANDLER = 0,
	OSL_NOTIFY_HANDLER = 1,
	OSL_GPE_HANDLER = 2,
	OSL_DEBUGGER_MAIN_THREAD = 3,
	OSL_DEBUGGER_EXEC_THREAD = 4,
	OSL_EC_POLL_HANDLER = 5,
	OSL_EC_BURST_HANDLER = 6,
} acpi_execute_type;

typedef enum {
	ACPI_IMODE_LOAD_PASS1 = 1,
	ACPI_IMODE_LOAD_PASS2 = 2,
	ACPI_IMODE_EXECUTE = 3,
} acpi_interpreter_mode;

typedef enum {
	ACPI_TRACE_AML_METHOD = 0,
	ACPI_TRACE_AML_OPCODE = 1,
	ACPI_TRACE_AML_REGION = 2,
} acpi_trace_event_type;

typedef enum {
	base_0possible = 0,
	base_1guaranteed = 1,
} base_directive_e;

typedef enum {
	bt_raw = 0,
	bt_rle = 1,
	bt_compressed = 2,
	bt_reserved = 3,
} blockType_e;

typedef enum {
	need_more = 0,
	block_done = 1,
	finish_started = 2,
	finish_done = 3,
} block_state;

typedef enum {
	CODES = 0,
	LENS = 1,
	DISTS = 2,
} codetype;

typedef enum {
	FILE_MEMORY_MIGRATE = 0,
	FILE_CPULIST = 1,
	FILE_MEMLIST = 2,
	FILE_EFFECTIVE_CPULIST = 3,
	FILE_EFFECTIVE_MEMLIST = 4,
	FILE_SUBPARTS_CPULIST = 5,
	FILE_EXCLUSIVE_CPULIST = 6,
	FILE_EFFECTIVE_XCPULIST = 7,
	FILE_ISOLATED_CPULIST = 8,
	FILE_CPU_EXCLUSIVE = 9,
	FILE_MEM_EXCLUSIVE = 10,
	FILE_MEM_HARDWALL = 11,
	FILE_SCHED_LOAD_BALANCE = 12,
	FILE_PARTITION_ROOT = 13,
	FILE_SCHED_RELAX_DOMAIN_LEVEL = 14,
	FILE_MEMORY_PRESSURE_ENABLED = 15,
	FILE_MEMORY_PRESSURE = 16,
	FILE_SPREAD_PAGE = 17,
	FILE_SPREAD_SLAB = 18,
} cpuset_filetype_t;

typedef enum {
	CS_CPU_EXCLUSIVE = 0,
	CS_MEM_EXCLUSIVE = 1,
	CS_MEM_HARDWALL = 2,
	CS_MEMORY_MIGRATE = 3,
	CS_SCHED_LOAD_BALANCE = 4,
	CS_SPREAD_PAGE = 5,
	CS_SPREAD_SLAB = 6,
} cpuset_flagbits_t;

typedef enum {
	noDict = 0,
	withPrefix64k = 1,
	usingExtDict = 2,
} dict_directive;

typedef enum {
	EITHER = 0,
	INDEX = 1,
	DIRENT = 2,
	DIRENT_HTREE = 3,
} dirblock_type_t;

typedef enum {
	e1000_1000t_rx_status_not_ok = 0,
	e1000_1000t_rx_status_ok = 1,
	e1000_1000t_rx_status_undefined = 255,
} e1000_1000t_rx_status;

typedef enum {
	e1000_10bt_ext_dist_enable_normal = 0,
	e1000_10bt_ext_dist_enable_lower = 1,
	e1000_10bt_ext_dist_enable_undefined = 255,
} e1000_10bt_ext_dist_enable;

typedef enum {
	e1000_auto_x_mode_manual_mdi = 0,
	e1000_auto_x_mode_manual_mdix = 1,
	e1000_auto_x_mode_auto1 = 2,
	e1000_auto_x_mode_auto2 = 3,
	e1000_auto_x_mode_undefined = 255,
} e1000_auto_x_mode;

typedef enum {
	e1000_bus_speed_unknown = 0,
	e1000_bus_speed_33 = 1,
	e1000_bus_speed_66 = 2,
	e1000_bus_speed_100 = 3,
	e1000_bus_speed_120 = 4,
	e1000_bus_speed_133 = 5,
	e1000_bus_speed_reserved = 6,
} e1000_bus_speed;

typedef enum {
	e1000_bus_type_unknown = 0,
	e1000_bus_type_pci = 1,
	e1000_bus_type_pcix = 2,
	e1000_bus_type_reserved = 3,
} e1000_bus_type;

typedef enum {
	e1000_bus_width_unknown = 0,
	e1000_bus_width_32 = 1,
	e1000_bus_width_64 = 2,
	e1000_bus_width_reserved = 3,
} e1000_bus_width;

typedef enum {
	e1000_cable_length_50 = 0,
	e1000_cable_length_50_80 = 1,
	e1000_cable_length_80_110 = 2,
	e1000_cable_length_110_140 = 3,
	e1000_cable_length_140 = 4,
	e1000_cable_length_undefined = 255,
} e1000_cable_length;

typedef enum {
	e1000_downshift_normal = 0,
	e1000_downshift_activated = 1,
	e1000_downshift_undefined = 255,
} e1000_downshift;

typedef enum {
	e1000_dsp_config_disabled = 0,
	e1000_dsp_config_enabled = 1,
	e1000_dsp_config_activated = 2,
	e1000_dsp_config_undefined = 255,
} e1000_dsp_config;

typedef enum {
	e1000_eeprom_uninitialized = 0,
	e1000_eeprom_spi = 1,
	e1000_eeprom_microwire = 2,
	e1000_eeprom_flash = 3,
	e1000_eeprom_none = 4,
	e1000_num_eeprom_types = 5,
} e1000_eeprom_type;

typedef enum {
	E1000_FC_NONE = 0,
	E1000_FC_RX_PAUSE = 1,
	E1000_FC_TX_PAUSE = 2,
	E1000_FC_FULL = 3,
	E1000_FC_DEFAULT = 255,
} e1000_fc_type;

typedef enum {
	e1000_ffe_config_enabled = 0,
	e1000_ffe_config_active = 1,
	e1000_ffe_config_blocked = 2,
} e1000_ffe_config;

typedef enum {
	e1000_undefined = 0,
	e1000_82542_rev2_0 = 1,
	e1000_82542_rev2_1 = 2,
	e1000_82543 = 3,
	e1000_82544 = 4,
	e1000_82540 = 5,
	e1000_82545 = 6,
	e1000_82545_rev_3 = 7,
	e1000_82546 = 8,
	e1000_ce4100 = 9,
	e1000_82546_rev_3 = 10,
	e1000_82541 = 11,
	e1000_82541_rev_2 = 12,
	e1000_82547 = 13,
	e1000_82547_rev_2 = 14,
	e1000_num_macs = 15,
} e1000_mac_type;

typedef enum {
	e1000_media_type_copper = 0,
	e1000_media_type_fiber = 1,
	e1000_media_type_internal_serdes = 2,
	e1000_num_media_types = 3,
} e1000_media_type;

typedef enum {
	e1000_ms_hw_default = 0,
	e1000_ms_force_master = 1,
	e1000_ms_force_slave = 2,
	e1000_ms_auto = 3,
} e1000_ms_type;

typedef enum {
	e1000_phy_m88 = 0,
	e1000_phy_igp = 1,
	e1000_phy_8211 = 2,
	e1000_phy_8201 = 3,
	e1000_phy_undefined = 255,
} e1000_phy_type;

typedef enum {
	e1000_polarity_reversal_enabled = 0,
	e1000_polarity_reversal_disabled = 1,
	e1000_polarity_reversal_undefined = 255,
} e1000_polarity_reversal;

typedef enum {
	e1000_rev_polarity_normal = 0,
	e1000_rev_polarity_reversed = 1,
	e1000_rev_polarity_undefined = 255,
} e1000_rev_polarity;

typedef enum {
	e1000_smart_speed_default = 0,
	e1000_smart_speed_on = 1,
	e1000_smart_speed_off = 2,
} e1000_smart_speed;

typedef enum {
	decode_full_block = 0,
	partial_decode = 1,
} earlyEnd_directive;

typedef enum {
	endOnOutputSize = 0,
	endOnInputSize = 1,
} endCondition_directive;

typedef enum {
	EXT4_IGET_NORMAL = 0,
	EXT4_IGET_SPECIAL = 1,
	EXT4_IGET_HANDLE = 2,
	EXT4_IGET_BAD = 4,
	EXT4_IGET_EA_INODE = 8,
} ext4_iget_flags;

typedef enum {
	FL_READY = 0,
	FL_STATUS = 1,
	FL_CFI_QUERY = 2,
	FL_JEDEC_QUERY = 3,
	FL_ERASING = 4,
	FL_ERASE_SUSPENDING = 5,
	FL_ERASE_SUSPENDED = 6,
	FL_WRITING = 7,
	FL_WRITING_TO_BUFFER = 8,
	FL_OTP_WRITE = 9,
	FL_WRITE_SUSPENDING = 10,
	FL_WRITE_SUSPENDED = 11,
	FL_PM_SUSPENDED = 12,
	FL_SYNCING = 13,
	FL_UNLOADING = 14,
	FL_LOCKING = 15,
	FL_UNLOCKING = 16,
	FL_POINT = 17,
	FL_XIP_WHILE_ERASING = 18,
	FL_XIP_WHILE_WRITING = 19,
	FL_SHUTDOWN = 20,
	FL_READING = 21,
	FL_CACHEDPRG = 22,
	FL_RESETTING = 23,
	FL_OTPING = 24,
	FL_PREPARING_ERASE = 25,
	FL_VERIFYING_ERASE = 26,
	FL_UNKNOWN = 27,
} flstate_t;

typedef enum {
	HEAD = 0,
	FLAGS = 1,
	TIME = 2,
	OS = 3,
	EXLEN = 4,
	EXTRA = 5,
	NAME = 6,
	COMMENT = 7,
	HCRC = 8,
	DICTID = 9,
	DICT = 10,
	TYPE = 11,
	TYPEDO = 12,
	STORED = 13,
	COPY = 14,
	TABLE = 15,
	LENLENS = 16,
	CODELENS = 17,
	LEN = 18,
	LENEXT = 19,
	DIST = 20,
	DISTEXT = 21,
	MATCH = 22,
	LIT = 23,
	CHECK = 24,
	LENGTH = 25,
	DONE = 26,
	BAD = 27,
	MEM = 28,
	SYNC = 29,
} inflate_mode;

typedef enum {
	ISOLATE_ABORT = 0,
	ISOLATE_NONE = 1,
	ISOLATE_SUCCESS = 2,
} isolate_migrate_t;

typedef enum {
	MAP_CHG_REUSE = 0,
	MAP_CHG_NEEDED = 1,
	MAP_CHG_ENFORCED = 2,
} map_chg_state;

typedef enum {
	PAGE_KEEP = 0,
	PAGE_ACTIVATE = 1,
	PAGE_SUCCESS = 2,
	PAGE_CLEAN = 3,
} pageout_t;

typedef enum {
	PCI_BRIDGE_EMUL_HANDLED = 0,
	PCI_BRIDGE_EMUL_NOT_HANDLED = 1,
} pci_bridge_emul_read_status_t;

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_10G_QXGMII = 33,
	PHY_INTERFACE_MODE_50GBASER = 34,
	PHY_INTERFACE_MODE_LAUI = 35,
	PHY_INTERFACE_MODE_100GBASEP = 36,
	PHY_INTERFACE_MODE_MIILITE = 37,
	PHY_INTERFACE_MODE_MAX = 38,
} phy_interface_t;

typedef enum {
	search_hashChain = 0,
	search_binaryTree = 1,
	search_rowHash = 2,
} searchMethod_e;

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

typedef enum {
	not_streaming = 0,
	is_streaming = 1,
} streaming_operation;

typedef ZSTD_ErrorCode zstd_error_code;

enum APSR_BIT {
	APSR_MEMS = 2,
	APSR_CMSW = 16,
	APSR_RDM = 8192,
	APSR_TDM = 16384,
	APSR_MIISELECT = 16777216,
};

enum ARSTR_BIT {
	ARSTR_ARST = 1,
};

enum CCC_BIT {
	CCC_OPC = 3,
	CCC_OPC_RESET = 0,
	CCC_OPC_CONFIG = 1,
	CCC_OPC_OPERATION = 2,
	CCC_GAC = 128,
	CCC_DTSR = 256,
	CCC_CSEL = 196608,
	CCC_CSEL_HPB = 65536,
	CCC_CSEL_ETH_TX = 131072,
	CCC_CSEL_GMII_REF = 196608,
	CCC_LBME = 16777216,
};

enum CIE_BIT {
	CIE_CRIE = 1,
	CIE_CTIE = 256,
	CIE_RQFM = 65536,
	CIE_CL0M = 131072,
	CIE_RFWL = 262144,
	CIE_RFFL = 524288,
};

enum CMD_RET_VALUES {
	REFIRE_CMD = 1,
	COMPLETE_CMD = 2,
	RETURN_CMD = 3,
};

enum CSI_J {
	CSI_J_CURSOR_TO_END = 0,
	CSI_J_START_TO_CURSOR = 1,
	CSI_J_VISIBLE = 2,
	CSI_J_FULL = 3,
};

enum CSI_right_square_bracket {
	CSI_RSB_COLOR_FOR_UNDERLINE = 1,
	CSI_RSB_COLOR_FOR_HALF_BRIGHT = 2,
	CSI_RSB_MAKE_CUR_COLOR_DEFAULT = 8,
	CSI_RSB_BLANKING_INTERVAL = 9,
	CSI_RSB_BELL_FREQUENCY = 10,
	CSI_RSB_BELL_DURATION = 11,
	CSI_RSB_BRING_CONSOLE_TO_FRONT = 12,
	CSI_RSB_UNBLANK = 13,
	CSI_RSB_VESA_OFF_INTERVAL = 14,
	CSI_RSB_BRING_PREV_CONSOLE_TO_FRONT = 15,
	CSI_RSB_CURSOR_BLINK_INTERVAL = 16,
};

enum CSR0_BIT {
	CSR0_TPE = 16,
	CSR0_RPE = 32,
};

enum CSR1_BIT {
	CSR1_TIP4 = 1,
	CSR1_TTCP4 = 16,
	CSR1_TUDP4 = 32,
	CSR1_TICMP4 = 64,
	CSR1_TTCP6 = 1048576,
	CSR1_TUDP6 = 2097152,
	CSR1_TICMP6 = 4194304,
	CSR1_THOP = 16777216,
	CSR1_TROUT = 33554432,
	CSR1_TAHD = 67108864,
	CSR1_TDHD = 134217728,
};

enum CSR2_BIT {
	CSR2_RIP4 = 1,
	CSR2_RTCP4 = 16,
	CSR2_RUDP4 = 32,
	CSR2_RICMP4 = 64,
	CSR2_RTCP6 = 1048576,
	CSR2_RUDP6 = 2097152,
	CSR2_RICMP6 = 4194304,
	CSR2_RHOP = 16777216,
	CSR2_RROUT = 33554432,
	CSR2_RAHD = 67108864,
	CSR2_RDHD = 134217728,
};

enum CSR_BIT {
	CSR_OPS = 15,
	CSR_OPS_RESET = 1,
	CSR_OPS_CONFIG = 2,
	CSR_OPS_OPERATION = 4,
	CSR_OPS_STANDBY = 8,
	CSR_DTS = 256,
	CSR_TPO0 = 65536,
	CSR_TPO1 = 131072,
	CSR_TPO2 = 262144,
	CSR_TPO3 = 524288,
	CSR_RPO = 1048576,
};

enum CXR31_BIT {
	CXR31_SEL_LINK0 = 1,
	CXR31_SEL_LINK1 = 8,
};

enum CXR35_BIT {
	CXR35_SEL_XMII = 3,
	CXR35_SEL_XMII_RGMII = 0,
	CXR35_SEL_XMII_MII = 2,
	CXR35_HALFCYC_CLKSW = 4294901760,
};

enum DCMD_RETURN_STATUS {
	DCMD_SUCCESS = 0,
	DCMD_TIMEOUT = 1,
	DCMD_FAILED = 2,
	DCMD_BUSY = 3,
	DCMD_INIT = 255,
};

enum DCMD_TIMEOUT_ACTION {
	INITIATE_OCR = 0,
	KILL_ADAPTER = 1,
	IGNORE_TIMEOUT = 2,
};

enum DIE_DT {
	DT_FEMPTY_IS = 16,
	DT_FEMPTY_IC = 32,
	DT_FEMPTY_ND = 48,
	DT_FEMPTY = 64,
	DT_FEMPTY_START = 80,
	DT_FEMPTY_MID = 96,
	DT_FEMPTY_END = 112,
	DT_FSINGLE = 128,
	DT_FSTART = 144,
	DT_FMID = 160,
	DT_FEND = 176,
	DT_LEMPTY = 192,
	DT_EEMPTY = 208,
	DT_LINK = 224,
	DT_EOS = 240,
	DT_MASK = 240,
	D_DIE = 8,
};

enum DIE_DT___2 {
	DT_FSINGLE___2 = 128,
	DT_FSTART___2 = 144,
	DT_FMID___2 = 160,
	DT_FEND___2 = 176,
	DT_LEMPTY___2 = 192,
	DT_EEMPTY___2 = 208,
	DT_LINKFIX = 0,
	DT_LINK___2 = 224,
	DT_EOS___2 = 240,
	DT_FEMPTY___2 = 64,
	DT_FEMPTY_IS___2 = 16,
	DT_FEMPTY_IC___2 = 32,
	DT_FEMPTY_ND___2 = 48,
	DT_FEMPTY_START___2 = 80,
	DT_FEMPTY_MID___2 = 96,
	DT_FEMPTY_END___2 = 112,
	DT_MASK___2 = 240,
	DIE = 8,
};

enum DIE_DT___3 {
	DT_FMID___3 = 64,
	DT_FSTART___3 = 80,
	DT_FEND___3 = 96,
	DT_FSINGLE___3 = 112,
	DT_LINK___3 = 128,
	DT_LINKFIX___2 = 144,
	DT_EOS___3 = 160,
	DT_FEMPTY___3 = 192,
	DT_FEMPTY_IS___3 = 208,
	DT_FEMPTY_IC___3 = 224,
	DT_FEMPTY_ND___3 = 240,
	DT_LEMPTY___3 = 32,
	DT_EEMPTY___3 = 48,
};

enum DMA_REGS_OFFSET {
	OFFSET_INT_FLAG = 0,
	OFFSET_INT_EN = 4,
	OFFSET_EN = 8,
	OFFSET_RST = 12,
	OFFSET_CON = 24,
	OFFSET_TX_MEM_ADDR = 28,
	OFFSET_RX_MEM_ADDR = 32,
	OFFSET_TX_LEN = 36,
	OFFSET_RX_LEN = 40,
	OFFSET_TX_4G_MODE = 84,
	OFFSET_RX_4G_MODE = 88,
};

enum E1000_INVM_STRUCTURE_TYPE {
	E1000_INVM_UNINITIALIZED_STRUCTURE = 0,
	E1000_INVM_WORD_AUTOLOAD_STRUCTURE = 1,
	E1000_INVM_CSR_AUTOLOAD_STRUCTURE = 2,
	E1000_INVM_PHY_REGISTER_AUTOLOAD_STRUCTURE = 3,
	E1000_INVM_RSA_KEY_SHA256_STRUCTURE = 4,
	E1000_INVM_INVALIDATED_STRUCTURE = 15,
};

enum ECMR_BIT {
	ECMR_PRM = 1,
	ECMR_DM = 2,
	ECMR_TE = 32,
	ECMR_RE = 64,
	ECMR_MPDE = 512,
	ECMR_TXF = 65536,
	ECMR_RXF = 131072,
	ECMR_PFR = 262144,
	ECMR_ZPF = 524288,
	ECMR_RZPF = 1048576,
	ECMR_DPAD = 2097152,
	ECMR_RCSC = 8388608,
	ECMR_RCPT = 33554432,
	ECMR_TRCCM = 67108864,
};

enum ECMR_BIT___2 {
	ECMR_TRCCM___2 = 67108864,
	ECMR_RCSC___2 = 8388608,
	ECMR_DPAD___2 = 2097152,
	ECMR_RZPF___2 = 1048576,
	ECMR_ZPF___2 = 524288,
	ECMR_PFR___2 = 262144,
	ECMR_RXF___2 = 131072,
	ECMR_TXF___2 = 65536,
	ECMR_MCT = 8192,
	ECMR_PRCEF = 4096,
	ECMR_MPDE___2 = 512,
	ECMR_RE___2 = 64,
	ECMR_TE___2 = 32,
	ECMR_RTM = 16,
	ECMR_ILB = 8,
	ECMR_ELB = 4,
	ECMR_DM___2 = 2,
	ECMR_PRM___2 = 1,
};

enum ECSIPR_BIT {
	ECSIPR_ICDIP = 1,
	ECSIPR_MPDIP = 2,
	ECSIPR_LCHNGIP = 4,
};

enum ECSIPR_BIT___2 {
	ECSIPR_BRCRXIP = 32,
	ECSIPR_PSRTOIP = 16,
	ECSIPR_LCHNGIP___2 = 4,
	ECSIPR_MPDIP___2 = 2,
	ECSIPR_ICDIP___2 = 1,
};

enum ECSR_BIT {
	ECSR_ICD = 1,
	ECSR_MPD = 2,
	ECSR_LCHNG = 4,
	ECSR_PHYI = 8,
	ECSR_PFRI = 16,
};

enum ECSR_BIT___2 {
	ECSR_BRCRX = 32,
	ECSR_PSRTO = 16,
	ECSR_LCHNG___2 = 4,
	ECSR_MPD___2 = 2,
	ECSR_ICD___2 = 1,
};

enum EDMR_BIT {
	EDMR_NBST = 128,
	EDMR_EL = 64,
	EDMR_DL1 = 32,
	EDMR_DL0 = 16,
	EDMR_SRST_GETHER = 3,
	EDMR_SRST_ETHER = 1,
};

enum EDRRR_BIT {
	EDRRR_R = 1,
};

enum EDSR_BIT {
	EDSR_ENT = 1,
	EDSR_ENR = 2,
};

enum EESIPR_BIT {
	EESIPR_TWB1IP = 2147483648,
	EESIPR_TWBIP = 1073741824,
	EESIPR_TC1IP = 536870912,
	EESIPR_TUCIP = 268435456,
	EESIPR_ROCIP = 134217728,
	EESIPR_TABTIP = 67108864,
	EESIPR_RABTIP = 33554432,
	EESIPR_RFCOFIP = 16777216,
	EESIPR_ADEIP = 8388608,
	EESIPR_ECIIP = 4194304,
	EESIPR_FTCIP = 2097152,
	EESIPR_TDEIP = 1048576,
	EESIPR_TFUFIP = 524288,
	EESIPR_FRIP = 262144,
	EESIPR_RDEIP = 131072,
	EESIPR_RFOFIP = 65536,
	EESIPR_CNDIP = 2048,
	EESIPR_DLCIP = 1024,
	EESIPR_CDIP = 512,
	EESIPR_TROIP = 256,
	EESIPR_RMAFIP = 128,
	EESIPR_CEEFIP = 64,
	EESIPR_CELFIP = 32,
	EESIPR_RRFIP = 16,
	EESIPR_RTLFIP = 8,
	EESIPR_RTSFIP = 4,
	EESIPR_PREIP = 2,
	EESIPR_CERFIP = 1,
};

enum EESR_BIT {
	EESR_TWB1 = 2147483648,
	EESR_TWB = 1073741824,
	EESR_TC1 = 536870912,
	EESR_TUC = 268435456,
	EESR_ROC = 134217728,
	EESR_TABT = 67108864,
	EESR_RABT = 33554432,
	EESR_RFRMER = 16777216,
	EESR_ADE = 8388608,
	EESR_ECI = 4194304,
	EESR_FTC = 2097152,
	EESR_TDE = 1048576,
	EESR_TFE = 524288,
	EESR_FRC = 262144,
	EESR_RDE = 131072,
	EESR_RFE = 65536,
	EESR_CND = 2048,
	EESR_DLC = 1024,
	EESR_CD = 512,
	EESR_TRO = 256,
	EESR_RMAF = 128,
	EESR_CEEF = 64,
	EESR_CELF = 32,
	EESR_RRF = 16,
	EESR_RTLF = 8,
	EESR_RTSF = 4,
	EESR_PRE = 2,
	EESR_CERF = 1,
};

enum EIS_BIT {
	EIS_MREF = 1,
	EIS_MTEF = 2,
	EIS_QEF = 4,
	EIS_SEF = 8,
	EIS_CLLF0 = 16,
	EIS_CLLF1 = 32,
	EIS_CULF0 = 64,
	EIS_CULF1 = 128,
	EIS_TFFF = 256,
	EIS_QFS = 65536,
	EIS_RESERVED = 4294899712,
};

enum EXT_INFO_DS_BIT {
	TXC = 16384,
};

enum FCFTR_BIT {
	FCFTR_RFF2 = 262144,
	FCFTR_RFF1 = 131072,
	FCFTR_RFF0 = 65536,
	FCFTR_RFD2 = 4,
	FCFTR_RFD1 = 2,
	FCFTR_RFD0 = 1,
};

enum FW_BOOT_CONTEXT {
	PROBE_CONTEXT = 0,
	OCR_CONTEXT = 1,
};

enum GCCR_BIT {
	GCCR_TCR = 3,
	GCCR_TCR_NOREQ = 0,
	GCCR_TCR_RESET = 1,
	GCCR_TCR_CAPTURE = 3,
	GCCR_LTO = 4,
	GCCR_LTI = 8,
	GCCR_LPTC = 16,
	GCCR_LMTT = 32,
	GCCR_TCSS = 768,
	GCCR_TCSS_GPTP = 0,
	GCCR_TCSS_ADJGPTP = 256,
	GCCR_TCSS_AVTP = 512,
};

enum GECMR_BIT {
	GECMR_10 = 0,
	GECMR_100 = 4,
	GECMR_1000 = 1,
};

enum GECMR_BIT___2 {
	GECMR_SPEED = 1,
	GECMR_SPEED_100 = 0,
	GECMR_SPEED_1000 = 1,
	GBETH_GECMR_SPEED = 48,
	GBETH_GECMR_SPEED_10 = 0,
	GBETH_GECMR_SPEED_100 = 16,
	GBETH_GECMR_SPEED_1000 = 32,
};

enum GIC_BIT {
	GIC_PTCE = 1,
	GIC_PTME = 4,
};

enum GID_BIT {
	GID_PTCD = 1,
	GID_PTOD = 2,
	GID_PTMD0 = 4,
	GID_PTMD1 = 8,
	GID_PTMD2 = 16,
	GID_PTMD3 = 32,
	GID_PTMD4 = 64,
	GID_PTMD5 = 128,
	GID_PTMD6 = 256,
	GID_PTMD7 = 512,
	GID_ATCD0 = 65536,
	GID_ATCD1 = 131072,
	GID_ATCD2 = 262144,
	GID_ATCD3 = 524288,
	GID_ATCD4 = 1048576,
	GID_ATCD5 = 2097152,
	GID_ATCD6 = 4194304,
	GID_ATCD7 = 8388608,
	GID_ATCD8 = 16777216,
	GID_ATCD9 = 33554432,
	GID_ATCD10 = 67108864,
	GID_ATCD11 = 134217728,
	GID_ATCD12 = 268435456,
	GID_ATCD13 = 536870912,
	GID_ATCD14 = 1073741824,
	GID_ATCD15 = 2147483648,
};

enum GIE_BIT {
	GIE_PTCS = 1,
	GIE_PTOS = 2,
	GIE_PTMS0 = 4,
	GIE_PTMS1 = 8,
	GIE_PTMS2 = 16,
	GIE_PTMS3 = 32,
	GIE_PTMS4 = 64,
	GIE_PTMS5 = 128,
	GIE_PTMS6 = 256,
	GIE_PTMS7 = 512,
	GIE_ATCS0 = 65536,
	GIE_ATCS1 = 131072,
	GIE_ATCS2 = 262144,
	GIE_ATCS3 = 524288,
	GIE_ATCS4 = 1048576,
	GIE_ATCS5 = 2097152,
	GIE_ATCS6 = 4194304,
	GIE_ATCS7 = 8388608,
	GIE_ATCS8 = 16777216,
	GIE_ATCS9 = 33554432,
	GIE_ATCS10 = 67108864,
	GIE_ATCS11 = 134217728,
	GIE_ATCS12 = 268435456,
	GIE_ATCS13 = 536870912,
	GIE_ATCS14 = 1073741824,
	GIE_ATCS15 = 2147483648,
};

enum GIS_BIT {
	GIS_PTCF = 1,
	GIS_PTMF = 4,
	GIS_RESERVED = 64512,
};

enum GTI_BIT {
	GTI_TIV = 268435455,
};

enum HCLGE_COMM_API_CAP_BITS {
	HCLGE_COMM_API_CAP_FLEX_RSS_TBL_B = 0,
};

enum HCLGE_DEV_STATE {
	HCLGE_STATE_REINITING = 0,
	HCLGE_STATE_DOWN = 1,
	HCLGE_STATE_DISABLED = 2,
	HCLGE_STATE_REMOVING = 3,
	HCLGE_STATE_NIC_REGISTERED = 4,
	HCLGE_STATE_ROCE_REGISTERED = 5,
	HCLGE_STATE_SERVICE_INITED = 6,
	HCLGE_STATE_RST_SERVICE_SCHED = 7,
	HCLGE_STATE_RST_HANDLING = 8,
	HCLGE_STATE_MBX_SERVICE_SCHED = 9,
	HCLGE_STATE_MBX_HANDLING = 10,
	HCLGE_STATE_ERR_SERVICE_SCHED = 11,
	HCLGE_STATE_STATISTICS_UPDATING = 12,
	HCLGE_STATE_LINK_UPDATING = 13,
	HCLGE_STATE_RST_FAIL = 14,
	HCLGE_STATE_FD_TBL_CHANGED = 15,
	HCLGE_STATE_FD_CLEAR_ALL = 16,
	HCLGE_STATE_FD_USER_DEF_CHANGED = 17,
	HCLGE_STATE_PTP_EN = 18,
	HCLGE_STATE_PTP_TX_HANDLING = 19,
	HCLGE_STATE_FEC_STATS_UPDATING = 20,
	HCLGE_STATE_MAX = 21,
};

enum HCLGE_FD_ACTION {
	HCLGE_FD_ACTION_SELECT_QUEUE = 0,
	HCLGE_FD_ACTION_DROP_PACKET = 1,
	HCLGE_FD_ACTION_SELECT_TC = 2,
};

enum HCLGE_FD_ACTIVE_RULE_TYPE {
	HCLGE_FD_RULE_NONE = 0,
	HCLGE_FD_ARFS_ACTIVE = 1,
	HCLGE_FD_EP_ACTIVE = 2,
	HCLGE_FD_TC_FLOWER_ACTIVE = 3,
};

enum HCLGE_FD_KEY_OPT {
	KEY_OPT_U8 = 0,
	KEY_OPT_LE16 = 1,
	KEY_OPT_LE32 = 2,
	KEY_OPT_MAC = 3,
	KEY_OPT_IP = 4,
	KEY_OPT_VNI = 5,
};

enum HCLGE_FD_KEY_TYPE {
	HCLGE_FD_KEY_BASE_ON_PTYPE = 0,
	HCLGE_FD_KEY_BASE_ON_TUPLE = 1,
};

enum HCLGE_FD_META_DATA {
	PACKET_TYPE_ID = 0,
	IP_FRAGEMENT = 1,
	ROCE_TYPE = 2,
	NEXT_KEY = 3,
	VLAN_NUMBER = 4,
	SRC_VPORT = 5,
	DST_VPORT = 6,
	TUNNEL_PACKET = 7,
	MAX_META_DATA = 8,
};

enum HCLGE_FD_MODE {
	HCLGE_FD_MODE_DEPTH_2K_WIDTH_400B_STAGE_1 = 0,
	HCLGE_FD_MODE_DEPTH_1K_WIDTH_400B_STAGE_2 = 1,
	HCLGE_FD_MODE_DEPTH_4K_WIDTH_200B_STAGE_1 = 2,
	HCLGE_FD_MODE_DEPTH_2K_WIDTH_200B_STAGE_2 = 3,
};

enum HCLGE_FD_NODE_STATE {
	HCLGE_FD_TO_ADD = 0,
	HCLGE_FD_TO_DEL = 1,
	HCLGE_FD_ACTIVE = 2,
	HCLGE_FD_DELETED = 3,
};

enum HCLGE_FD_PACKET_TYPE {
	NIC_PACKET = 0,
	ROCE_PACKET = 1,
};

enum HCLGE_FD_STAGE {
	HCLGE_FD_STAGE_1 = 0,
	HCLGE_FD_STAGE_2 = 1,
	MAX_STAGE_NUM = 2,
};

enum HCLGE_FD_TUPLE {
	OUTER_DST_MAC = 0,
	OUTER_SRC_MAC = 1,
	OUTER_VLAN_TAG_FST = 2,
	OUTER_VLAN_TAG_SEC = 3,
	OUTER_ETH_TYPE = 4,
	OUTER_L2_RSV = 5,
	OUTER_IP_TOS = 6,
	OUTER_IP_PROTO = 7,
	OUTER_SRC_IP = 8,
	OUTER_DST_IP = 9,
	OUTER_L3_RSV = 10,
	OUTER_SRC_PORT = 11,
	OUTER_DST_PORT = 12,
	OUTER_L4_RSV = 13,
	OUTER_TUN_VNI = 14,
	OUTER_TUN_FLOW_ID = 15,
	INNER_DST_MAC = 16,
	INNER_SRC_MAC = 17,
	INNER_VLAN_TAG_FST = 18,
	INNER_VLAN_TAG_SEC = 19,
	INNER_ETH_TYPE = 20,
	INNER_L2_RSV = 21,
	INNER_IP_TOS = 22,
	INNER_IP_PROTO = 23,
	INNER_SRC_IP = 24,
	INNER_DST_IP = 25,
	INNER_L3_RSV = 26,
	INNER_SRC_PORT = 27,
	INNER_DST_PORT = 28,
	INNER_L4_RSV = 29,
	MAX_TUPLE = 30,
};

enum HCLGE_FD_USER_DEF_LAYER {
	HCLGE_FD_USER_DEF_NONE = 0,
	HCLGE_FD_USER_DEF_L2 = 1,
	HCLGE_FD_USER_DEF_L3 = 2,
	HCLGE_FD_USER_DEF_L4 = 3,
};

enum HCLGE_FIRMWARE_MAC_SPEED {
	HCLGE_FW_MAC_SPEED_1G = 0,
	HCLGE_FW_MAC_SPEED_10G = 1,
	HCLGE_FW_MAC_SPEED_25G = 2,
	HCLGE_FW_MAC_SPEED_40G = 3,
	HCLGE_FW_MAC_SPEED_50G = 4,
	HCLGE_FW_MAC_SPEED_100G = 5,
	HCLGE_FW_MAC_SPEED_10M = 6,
	HCLGE_FW_MAC_SPEED_100M = 7,
	HCLGE_FW_MAC_SPEED_200G = 8,
};

enum HCLGE_MAC_ADDR_TYPE {
	HCLGE_MAC_ADDR_UC = 0,
	HCLGE_MAC_ADDR_MC = 1,
};

enum HCLGE_MAC_DUPLEX {
	HCLGE_MAC_HALF = 0,
	HCLGE_MAC_FULL = 1,
};

enum HCLGE_MAC_NODE_STATE {
	HCLGE_MAC_TO_ADD = 0,
	HCLGE_MAC_TO_DEL = 1,
	HCLGE_MAC_ACTIVE = 2,
};

enum HCLGE_MAC_SPEED {
	HCLGE_MAC_SPEED_UNKNOWN = 0,
	HCLGE_MAC_SPEED_10M = 10,
	HCLGE_MAC_SPEED_100M = 100,
	HCLGE_MAC_SPEED_1G = 1000,
	HCLGE_MAC_SPEED_10G = 10000,
	HCLGE_MAC_SPEED_25G = 25000,
	HCLGE_MAC_SPEED_40G = 40000,
	HCLGE_MAC_SPEED_50G = 50000,
	HCLGE_MAC_SPEED_100G = 100000,
	HCLGE_MAC_SPEED_200G = 200000,
};

enum HCLGE_MBX_OPCODE {
	HCLGE_MBX_RESET = 1,
	HCLGE_MBX_ASSERTING_RESET = 2,
	HCLGE_MBX_SET_UNICAST = 3,
	HCLGE_MBX_SET_MULTICAST = 4,
	HCLGE_MBX_SET_VLAN = 5,
	HCLGE_MBX_MAP_RING_TO_VECTOR = 6,
	HCLGE_MBX_UNMAP_RING_TO_VECTOR = 7,
	HCLGE_MBX_SET_PROMISC_MODE = 8,
	HCLGE_MBX_SET_MACVLAN = 9,
	HCLGE_MBX_API_NEGOTIATE = 10,
	HCLGE_MBX_GET_QINFO = 11,
	HCLGE_MBX_GET_QDEPTH = 12,
	HCLGE_MBX_GET_BASIC_INFO = 13,
	HCLGE_MBX_GET_RETA = 14,
	HCLGE_MBX_GET_RSS_KEY = 15,
	HCLGE_MBX_GET_MAC_ADDR = 16,
	HCLGE_MBX_PF_VF_RESP = 17,
	HCLGE_MBX_GET_BDNUM = 18,
	HCLGE_MBX_GET_BUFSIZE = 19,
	HCLGE_MBX_GET_STREAMID = 20,
	HCLGE_MBX_SET_AESTART = 21,
	HCLGE_MBX_SET_TSOSTATS = 22,
	HCLGE_MBX_LINK_STAT_CHANGE = 23,
	HCLGE_MBX_GET_BASE_CONFIG = 24,
	HCLGE_MBX_BIND_FUNC_QUEUE = 25,
	HCLGE_MBX_GET_LINK_STATUS = 26,
	HCLGE_MBX_QUEUE_RESET = 27,
	HCLGE_MBX_KEEP_ALIVE = 28,
	HCLGE_MBX_SET_ALIVE = 29,
	HCLGE_MBX_SET_MTU = 30,
	HCLGE_MBX_GET_QID_IN_PF = 31,
	HCLGE_MBX_LINK_STAT_MODE = 32,
	HCLGE_MBX_GET_LINK_MODE = 33,
	HCLGE_MBX_PUSH_VLAN_INFO = 34,
	HCLGE_MBX_GET_MEDIA_TYPE = 35,
	HCLGE_MBX_PUSH_PROMISC_INFO = 36,
	HCLGE_MBX_VF_UNINIT = 37,
	HCLGE_MBX_HANDLE_VF_TBL = 38,
	HCLGE_MBX_GET_RING_VECTOR_MAP = 39,
	HCLGE_MBX_GET_VF_FLR_STATUS = 200,
	HCLGE_MBX_PUSH_LINK_STATUS = 201,
	HCLGE_MBX_NCSI_ERROR = 202,
};

enum HCLGE_VPORT_NEED_NOTIFY {
	HCLGE_VPORT_NEED_NOTIFY_RESET = 0,
	HCLGE_VPORT_NEED_NOTIFY_VF_VLAN = 1,
};

enum HCLGE_VPORT_STATE {
	HCLGE_VPORT_STATE_ALIVE = 0,
	HCLGE_VPORT_STATE_MAC_TBL_CHANGE = 1,
	HCLGE_VPORT_STATE_PROMISC_CHANGE = 2,
	HCLGE_VPORT_STATE_VLAN_FLTR_CHANGE = 3,
	HCLGE_VPORT_STATE_INITED = 4,
	HCLGE_VPORT_STATE_MAX = 5,
};

enum HLCGE_PORT_TYPE {
	HOST_PORT = 0,
	NETWORK_PORT = 1,
};

enum HNAE3_DEV_CAP_BITS {
	HNAE3_DEV_SUPPORT_FD_B = 0,
	HNAE3_DEV_SUPPORT_GRO_B = 1,
	HNAE3_DEV_SUPPORT_FEC_B = 2,
	HNAE3_DEV_SUPPORT_UDP_GSO_B = 3,
	HNAE3_DEV_SUPPORT_QB_B = 4,
	HNAE3_DEV_SUPPORT_FD_FORWARD_TC_B = 5,
	HNAE3_DEV_SUPPORT_PTP_B = 6,
	HNAE3_DEV_SUPPORT_INT_QL_B = 7,
	HNAE3_DEV_SUPPORT_HW_TX_CSUM_B = 8,
	HNAE3_DEV_SUPPORT_TX_PUSH_B = 9,
	HNAE3_DEV_SUPPORT_PHY_IMP_B = 10,
	HNAE3_DEV_SUPPORT_TQP_TXRX_INDEP_B = 11,
	HNAE3_DEV_SUPPORT_HW_PAD_B = 12,
	HNAE3_DEV_SUPPORT_STASH_B = 13,
	HNAE3_DEV_SUPPORT_UDP_TUNNEL_CSUM_B = 14,
	HNAE3_DEV_SUPPORT_PAUSE_B = 15,
	HNAE3_DEV_SUPPORT_RAS_IMP_B = 16,
	HNAE3_DEV_SUPPORT_RXD_ADV_LAYOUT_B = 17,
	HNAE3_DEV_SUPPORT_PORT_VLAN_BYPASS_B = 18,
	HNAE3_DEV_SUPPORT_VLAN_FLTR_MDF_B = 19,
	HNAE3_DEV_SUPPORT_MC_MAC_MNG_B = 20,
	HNAE3_DEV_SUPPORT_CQ_B = 21,
	HNAE3_DEV_SUPPORT_FEC_STATS_B = 22,
	HNAE3_DEV_SUPPORT_LANE_NUM_B = 23,
	HNAE3_DEV_SUPPORT_WOL_B = 24,
	HNAE3_DEV_SUPPORT_TM_FLUSH_B = 25,
	HNAE3_DEV_SUPPORT_VF_FAULT_B = 26,
	HNAE3_DEV_SUPPORT_ERR_MOD_GEN_REG_B = 27,
};

enum HNAE3_PF_CAP_BITS {
	HNAE3_PF_SUPPORT_VLAN_FLTR_MDF_B = 0,
};

enum I2C_REGS_OFFSET {
	OFFSET_DATA_PORT = 0,
	OFFSET_SLAVE_ADDR = 1,
	OFFSET_INTR_MASK = 2,
	OFFSET_INTR_STAT = 3,
	OFFSET_CONTROL = 4,
	OFFSET_TRANSFER_LEN = 5,
	OFFSET_TRANSAC_LEN = 6,
	OFFSET_DELAY_LEN = 7,
	OFFSET_TIMING = 8,
	OFFSET_START = 9,
	OFFSET_EXT_CONF = 10,
	OFFSET_FIFO_STAT = 11,
	OFFSET_FIFO_THRESH = 12,
	OFFSET_FIFO_ADDR_CLR = 13,
	OFFSET_IO_CONFIG = 14,
	OFFSET_RSV_DEBUG = 15,
	OFFSET_HS = 16,
	OFFSET_SOFTRESET = 17,
	OFFSET_DCM_EN = 18,
	OFFSET_MULTI_DMA = 19,
	OFFSET_PATH_DIR = 20,
	OFFSET_DEBUGSTAT = 21,
	OFFSET_DEBUGCTRL = 22,
	OFFSET_TRANSFER_LEN_AUX = 23,
	OFFSET_CLOCK_DIV = 24,
	OFFSET_LTIMING = 25,
	OFFSET_SCL_HIGH_LOW_RATIO = 26,
	OFFSET_HS_SCL_HIGH_LOW_RATIO = 27,
	OFFSET_SCL_MIS_COMP_POINT = 28,
	OFFSET_STA_STO_AC_TIMING = 29,
	OFFSET_HS_STA_STO_AC_TIMING = 30,
	OFFSET_SDA_TIMING = 31,
};

enum ISS_BIT {
	ISS_FRS = 1,
	ISS_FTS = 4,
	ISS_ES = 64,
	ISS_MS = 128,
	ISS_TFUS = 256,
	ISS_TFWS = 512,
	ISS_RFWS = 4096,
	ISS_CGIS = 8192,
	ISS_DPS1 = 131072,
	ISS_DPS2 = 262144,
	ISS_DPS3 = 524288,
	ISS_DPS4 = 1048576,
	ISS_DPS5 = 2097152,
	ISS_DPS6 = 4194304,
	ISS_DPS7 = 8388608,
	ISS_DPS8 = 16777216,
	ISS_DPS9 = 33554432,
	ISS_DPS10 = 67108864,
	ISS_DPS11 = 134217728,
	ISS_DPS12 = 268435456,
	ISS_DPS13 = 536870912,
	ISS_DPS14 = 1073741824,
	ISS_DPS15 = 2147483648,
};

enum KTHREAD_BITS {
	KTHREAD_IS_PER_CPU = 0,
	KTHREAD_SHOULD_STOP = 1,
	KTHREAD_SHOULD_PARK = 2,
};

enum LMAC_TYPE {
	BGX_MODE_SGMII = 0,
	BGX_MODE_XAUI = 1,
	BGX_MODE_DXAUI = 1,
	BGX_MODE_RXAUI = 2,
	BGX_MODE_XFI = 3,
	BGX_MODE_XLAUI = 4,
	BGX_MODE_10G_KR = 3,
	BGX_MODE_40G_KR = 4,
	BGX_MODE_RGMII = 5,
	BGX_MODE_QSGMII = 6,
	BGX_MODE_INVALID = 7,
};

enum MAX77686_RTC_OP {
	MAX77686_RTC_WRITE = 0,
	MAX77686_RTC_READ = 1,
};

enum MCAST_MODE {
	MCAST_MODE_REJECT = 0,
	MCAST_MODE_ACCEPT = 1,
	MCAST_MODE_CAM_FILTER = 2,
	RSVD = 3,
};

enum MEGASAS_LD_TARGET_ID_STATUS {
	LD_TARGET_ID_INITIAL = 0,
	LD_TARGET_ID_ACTIVE = 1,
	LD_TARGET_ID_DELETED = 2,
};

enum MEGASAS_OCR_CAUSE {
	FW_FAULT_OCR = 0,
	SCSIIO_TIMEOUT_OCR = 1,
	MFI_IO_TIMEOUT_OCR = 2,
};

enum MFI_CMD_OP {
	MFI_CMD_INIT = 0,
	MFI_CMD_LD_READ = 1,
	MFI_CMD_LD_WRITE = 2,
	MFI_CMD_LD_SCSI_IO = 3,
	MFI_CMD_PD_SCSI_IO = 4,
	MFI_CMD_DCMD = 5,
	MFI_CMD_ABORT = 6,
	MFI_CMD_SMP = 7,
	MFI_CMD_STP = 8,
	MFI_CMD_NVME = 9,
	MFI_CMD_TOOLBOX = 10,
	MFI_CMD_OP_COUNT = 11,
	MFI_CMD_INVALID = 255,
};

enum MFI_STAT {
	MFI_STAT_OK = 0,
	MFI_STAT_INVALID_CMD = 1,
	MFI_STAT_INVALID_DCMD = 2,
	MFI_STAT_INVALID_PARAMETER = 3,
	MFI_STAT_INVALID_SEQUENCE_NUMBER = 4,
	MFI_STAT_ABORT_NOT_POSSIBLE = 5,
	MFI_STAT_APP_HOST_CODE_NOT_FOUND = 6,
	MFI_STAT_APP_IN_USE = 7,
	MFI_STAT_APP_NOT_INITIALIZED = 8,
	MFI_STAT_ARRAY_INDEX_INVALID = 9,
	MFI_STAT_ARRAY_ROW_NOT_EMPTY = 10,
	MFI_STAT_CONFIG_RESOURCE_CONFLICT = 11,
	MFI_STAT_DEVICE_NOT_FOUND = 12,
	MFI_STAT_DRIVE_TOO_SMALL = 13,
	MFI_STAT_FLASH_ALLOC_FAIL = 14,
	MFI_STAT_FLASH_BUSY = 15,
	MFI_STAT_FLASH_ERROR = 16,
	MFI_STAT_FLASH_IMAGE_BAD = 17,
	MFI_STAT_FLASH_IMAGE_INCOMPLETE = 18,
	MFI_STAT_FLASH_NOT_OPEN = 19,
	MFI_STAT_FLASH_NOT_STARTED = 20,
	MFI_STAT_FLUSH_FAILED = 21,
	MFI_STAT_HOST_CODE_NOT_FOUNT = 22,
	MFI_STAT_LD_CC_IN_PROGRESS = 23,
	MFI_STAT_LD_INIT_IN_PROGRESS = 24,
	MFI_STAT_LD_LBA_OUT_OF_RANGE = 25,
	MFI_STAT_LD_MAX_CONFIGURED = 26,
	MFI_STAT_LD_NOT_OPTIMAL = 27,
	MFI_STAT_LD_RBLD_IN_PROGRESS = 28,
	MFI_STAT_LD_RECON_IN_PROGRESS = 29,
	MFI_STAT_LD_WRONG_RAID_LEVEL = 30,
	MFI_STAT_MAX_SPARES_EXCEEDED = 31,
	MFI_STAT_MEMORY_NOT_AVAILABLE = 32,
	MFI_STAT_MFC_HW_ERROR = 33,
	MFI_STAT_NO_HW_PRESENT = 34,
	MFI_STAT_NOT_FOUND = 35,
	MFI_STAT_NOT_IN_ENCL = 36,
	MFI_STAT_PD_CLEAR_IN_PROGRESS = 37,
	MFI_STAT_PD_TYPE_WRONG = 38,
	MFI_STAT_PR_DISABLED = 39,
	MFI_STAT_ROW_INDEX_INVALID = 40,
	MFI_STAT_SAS_CONFIG_INVALID_ACTION = 41,
	MFI_STAT_SAS_CONFIG_INVALID_DATA = 42,
	MFI_STAT_SAS_CONFIG_INVALID_PAGE = 43,
	MFI_STAT_SAS_CONFIG_INVALID_TYPE = 44,
	MFI_STAT_SCSI_DONE_WITH_ERROR = 45,
	MFI_STAT_SCSI_IO_FAILED = 46,
	MFI_STAT_SCSI_RESERVATION_CONFLICT = 47,
	MFI_STAT_SHUTDOWN_FAILED = 48,
	MFI_STAT_TIME_NOT_SET = 49,
	MFI_STAT_WRONG_STATE = 50,
	MFI_STAT_LD_OFFLINE = 51,
	MFI_STAT_PEER_NOTIFICATION_REJECTED = 52,
	MFI_STAT_PEER_NOTIFICATION_FAILED = 53,
	MFI_STAT_RESERVATION_IN_PROGRESS = 54,
	MFI_STAT_I2C_ERRORS_DETECTED = 55,
	MFI_STAT_PCI_ERRORS_DETECTED = 56,
	MFI_STAT_CONFIG_SEQ_MISMATCH = 103,
	MFI_STAT_INVALID_STATUS = 255,
};

enum MR_ADAPTER_TYPE {
	MFI_SERIES = 1,
	THUNDERBOLT_SERIES = 2,
	INVADER_SERIES = 3,
	VENTURA_SERIES = 4,
	AERO_SERIES = 5,
};

enum MR_EVT_CLASS {
	MR_EVT_CLASS_DEBUG = -2,
	MR_EVT_CLASS_PROGRESS = -1,
	MR_EVT_CLASS_INFO = 0,
	MR_EVT_CLASS_WARNING = 1,
	MR_EVT_CLASS_CRITICAL = 2,
	MR_EVT_CLASS_FATAL = 3,
	MR_EVT_CLASS_DEAD = 4,
};

enum MR_EVT_LOCALE {
	MR_EVT_LOCALE_LD = 1,
	MR_EVT_LOCALE_PD = 2,
	MR_EVT_LOCALE_ENCL = 4,
	MR_EVT_LOCALE_BBU = 8,
	MR_EVT_LOCALE_SAS = 16,
	MR_EVT_LOCALE_CTRL = 32,
	MR_EVT_LOCALE_CONFIG = 64,
	MR_EVT_LOCALE_CLUSTER = 128,
	MR_EVT_LOCALE_ALL = 65535,
};

enum MR_FW_CRASH_DUMP_STATE {
	UNAVAILABLE = 0,
	AVAILABLE = 1,
	COPYING = 2,
	COPIED = 3,
	COPY_ERROR = 4,
};

enum MR_LD_QUERY_TYPE {
	MR_LD_QUERY_TYPE_ALL = 0,
	MR_LD_QUERY_TYPE_EXPOSED_TO_HOST = 1,
	MR_LD_QUERY_TYPE_USED_TGT_IDS = 2,
	MR_LD_QUERY_TYPE_CLUSTER_ACCESS = 3,
	MR_LD_QUERY_TYPE_CLUSTER_LOCALE = 4,
};

enum MR_PD_QUERY_TYPE {
	MR_PD_QUERY_TYPE_ALL = 0,
	MR_PD_QUERY_TYPE_STATE = 1,
	MR_PD_QUERY_TYPE_POWER_STATE = 2,
	MR_PD_QUERY_TYPE_MEDIA_TYPE = 3,
	MR_PD_QUERY_TYPE_SPEED = 4,
	MR_PD_QUERY_TYPE_EXPOSED_TO_HOST = 5,
};

enum MR_PD_STATE {
	MR_PD_STATE_UNCONFIGURED_GOOD = 0,
	MR_PD_STATE_UNCONFIGURED_BAD = 1,
	MR_PD_STATE_HOT_SPARE = 2,
	MR_PD_STATE_OFFLINE = 16,
	MR_PD_STATE_FAILED = 17,
	MR_PD_STATE_REBUILD = 20,
	MR_PD_STATE_ONLINE = 24,
	MR_PD_STATE_COPYBACK = 32,
	MR_PD_STATE_SYSTEM = 64,
};

enum MR_PD_TYPE {
	UNKNOWN_DRIVE = 0,
	PARALLEL_SCSI = 1,
	SAS_PD = 2,
	SATA_PD = 3,
	FC_PD = 4,
	NVME_PD = 5,
};

enum MR_PERF_MODE {
	MR_BALANCED_PERF_MODE = 0,
	MR_IOPS_PERF_MODE = 1,
	MR_LATENCY_PERF_MODE = 2,
};

enum MR_RAID_FLAGS_IO_SUB_TYPE {
	MR_RAID_FLAGS_IO_SUB_TYPE_NONE = 0,
	MR_RAID_FLAGS_IO_SUB_TYPE_SYSTEM_PD = 1,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_DATA = 2,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_P = 3,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_Q = 4,
	MR_RAID_FLAGS_IO_SUB_TYPE_CACHE_BYPASS = 6,
	MR_RAID_FLAGS_IO_SUB_TYPE_LDIO_BW_LIMIT = 7,
	MR_RAID_FLAGS_IO_SUB_TYPE_R56_DIV_OFFLOAD = 8,
};

enum MR_RAID_MAP_DESC_TYPE {
	RAID_MAP_DESC_TYPE_DEVHDL_INFO = 0,
	RAID_MAP_DESC_TYPE_TGTID_INFO = 1,
	RAID_MAP_DESC_TYPE_ARRAY_INFO = 2,
	RAID_MAP_DESC_TYPE_SPAN_INFO = 3,
	RAID_MAP_DESC_TYPE_COUNT = 4,
};

enum MR_SCSI_CMD_TYPE {
	READ_WRITE_LDIO = 0,
	NON_READ_WRITE_LDIO = 1,
	READ_WRITE_SYSPDIO = 2,
	NON_READ_WRITE_SYSPDIO = 3,
};

enum MSC_BIT {
	MSC_CRC = 1,
	MSC_RFE = 2,
	MSC_RTSF = 4,
	MSC_RTLF = 8,
	MSC_FRE = 16,
	MSC_CRL = 32,
	MSC_CEEF = 64,
	MSC_MC = 128,
};

enum OID {
	OID_id_dsa_with_sha1 = 0,
	OID_id_dsa = 1,
	OID_id_ecPublicKey = 2,
	OID_id_prime192v1 = 3,
	OID_id_prime256v1 = 4,
	OID_id_ecdsa_with_sha1 = 5,
	OID_id_ecdsa_with_sha224 = 6,
	OID_id_ecdsa_with_sha256 = 7,
	OID_id_ecdsa_with_sha384 = 8,
	OID_id_ecdsa_with_sha512 = 9,
	OID_rsaEncryption = 10,
	OID_sha1WithRSAEncryption = 11,
	OID_sha256WithRSAEncryption = 12,
	OID_sha384WithRSAEncryption = 13,
	OID_sha512WithRSAEncryption = 14,
	OID_sha224WithRSAEncryption = 15,
	OID_data = 16,
	OID_signed_data = 17,
	OID_email_address = 18,
	OID_contentType = 19,
	OID_messageDigest = 20,
	OID_signingTime = 21,
	OID_smimeCapabilites = 22,
	OID_smimeAuthenticatedAttrs = 23,
	OID_mskrb5 = 24,
	OID_krb5 = 25,
	OID_krb5u2u = 26,
	OID_msIndirectData = 27,
	OID_msStatementType = 28,
	OID_msSpOpusInfo = 29,
	OID_msPeImageDataObjId = 30,
	OID_msIndividualSPKeyPurpose = 31,
	OID_msOutlookExpress = 32,
	OID_ntlmssp = 33,
	OID_negoex = 34,
	OID_spnego = 35,
	OID_IAKerb = 36,
	OID_PKU2U = 37,
	OID_Scram = 38,
	OID_certAuthInfoAccess = 39,
	OID_sha1 = 40,
	OID_id_ansip384r1 = 41,
	OID_id_ansip521r1 = 42,
	OID_sha256 = 43,
	OID_sha384 = 44,
	OID_sha512 = 45,
	OID_sha224 = 46,
	OID_commonName = 47,
	OID_surname = 48,
	OID_countryName = 49,
	OID_locality = 50,
	OID_stateOrProvinceName = 51,
	OID_organizationName = 52,
	OID_organizationUnitName = 53,
	OID_title = 54,
	OID_description = 55,
	OID_name = 56,
	OID_givenName = 57,
	OID_initials = 58,
	OID_generationalQualifier = 59,
	OID_subjectKeyIdentifier = 60,
	OID_keyUsage = 61,
	OID_subjectAltName = 62,
	OID_issuerAltName = 63,
	OID_basicConstraints = 64,
	OID_crlDistributionPoints = 65,
	OID_certPolicies = 66,
	OID_authorityKeyIdentifier = 67,
	OID_extKeyUsage = 68,
	OID_NetlogonMechanism = 69,
	OID_appleLocalKdcSupported = 70,
	OID_gostCPSignA = 71,
	OID_gostCPSignB = 72,
	OID_gostCPSignC = 73,
	OID_gost2012PKey256 = 74,
	OID_gost2012PKey512 = 75,
	OID_gost2012Digest256 = 76,
	OID_gost2012Digest512 = 77,
	OID_gost2012Signature256 = 78,
	OID_gost2012Signature512 = 79,
	OID_gostTC26Sign256A = 80,
	OID_gostTC26Sign256B = 81,
	OID_gostTC26Sign256C = 82,
	OID_gostTC26Sign256D = 83,
	OID_gostTC26Sign512A = 84,
	OID_gostTC26Sign512B = 85,
	OID_gostTC26Sign512C = 86,
	OID_sm2 = 87,
	OID_sm3 = 88,
	OID_SM2_with_SM3 = 89,
	OID_sm3WithRSAEncryption = 90,
	OID_TPMLoadableKey = 91,
	OID_TPMImportableKey = 92,
	OID_TPMSealedData = 93,
	OID_sha3_256 = 94,
	OID_sha3_384 = 95,
	OID_sha3_512 = 96,
	OID_id_ecdsa_with_sha3_256 = 97,
	OID_id_ecdsa_with_sha3_384 = 98,
	OID_id_ecdsa_with_sha3_512 = 99,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_256 = 100,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_384 = 101,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_512 = 102,
	OID__NR = 103,
};

enum Opt_errors {
	Opt_errors_continue = 0,
	Opt_errors_panic = 1,
};

enum PIR_BIT {
	PIR_MDI = 8,
	PIR_MDO = 4,
	PIR_MMD = 2,
	PIR_MDC = 1,
};

enum PIR_BIT___2 {
	PIR_MDC___2 = 1,
	PIR_MMD___2 = 2,
	PIR_MDO___2 = 4,
	PIR_MDI___2 = 8,
};

enum PSR_BIT {
	PSR_LMON = 1,
};

enum RAVB_QUEUE {
	RAVB_BE = 0,
	RAVB_NC = 1,
};

enum RCR_BIT {
	RCR_EFFS = 1,
	RCR_ENCF = 2,
	RCR_ESF = 12,
	RCR_ETS0 = 16,
	RCR_ETS2 = 32,
	RCR_RFCL = 536805376,
};

enum RD_LEN_BIT {
	RD_RFL = 65535,
	RD_RBL = 4294901760,
};

enum RD_STS_BIT {
	RD_RACT = 2147483648,
	RD_RDLE = 1073741824,
	RD_RFP1 = 536870912,
	RD_RFP0 = 268435456,
	RD_RFE = 134217728,
	RD_RFS10 = 512,
	RD_RFS9 = 256,
	RD_RFS8 = 128,
	RD_RFS7 = 64,
	RD_RFS6 = 32,
	RD_RFS5 = 16,
	RD_RFS4 = 8,
	RD_RFS3 = 4,
	RD_RFS2 = 2,
	RD_RFS1 = 1,
};

enum REGION_TYPE {
	REGION_TYPE_UNUSED = 0,
	REGION_TYPE_SHARED_READ = 1,
	REGION_TYPE_SHARED_WRITE = 2,
	REGION_TYPE_EXCLUSIVE = 3,
};

enum RIC0_BIT {
	RIC0_FRE0 = 1,
	RIC0_FRE1 = 2,
	RIC0_FRE2 = 4,
	RIC0_FRE3 = 8,
	RIC0_FRE4 = 16,
	RIC0_FRE5 = 32,
	RIC0_FRE6 = 64,
	RIC0_FRE7 = 128,
	RIC0_FRE8 = 256,
	RIC0_FRE9 = 512,
	RIC0_FRE10 = 1024,
	RIC0_FRE11 = 2048,
	RIC0_FRE12 = 4096,
	RIC0_FRE13 = 8192,
	RIC0_FRE14 = 16384,
	RIC0_FRE15 = 32768,
	RIC0_FRE16 = 65536,
	RIC0_FRE17 = 131072,
};

enum RIC2_BIT {
	RIC2_QFE0 = 1,
	RIC2_QFE1 = 2,
	RIC2_QFE2 = 4,
	RIC2_QFE3 = 8,
	RIC2_QFE4 = 16,
	RIC2_QFE5 = 32,
	RIC2_QFE6 = 64,
	RIC2_QFE7 = 128,
	RIC2_QFE8 = 256,
	RIC2_QFE9 = 512,
	RIC2_QFE10 = 1024,
	RIC2_QFE11 = 2048,
	RIC2_QFE12 = 4096,
	RIC2_QFE13 = 8192,
	RIC2_QFE14 = 16384,
	RIC2_QFE15 = 32768,
	RIC2_QFE16 = 65536,
	RIC2_QFE17 = 131072,
	RIC2_RFFE = 2147483648,
};

enum RIS0_BIT {
	RIS0_FRF0 = 1,
	RIS0_FRF1 = 2,
	RIS0_FRF2 = 4,
	RIS0_FRF3 = 8,
	RIS0_FRF4 = 16,
	RIS0_FRF5 = 32,
	RIS0_FRF6 = 64,
	RIS0_FRF7 = 128,
	RIS0_FRF8 = 256,
	RIS0_FRF9 = 512,
	RIS0_FRF10 = 1024,
	RIS0_FRF11 = 2048,
	RIS0_FRF12 = 4096,
	RIS0_FRF13 = 8192,
	RIS0_FRF14 = 16384,
	RIS0_FRF15 = 32768,
	RIS0_FRF16 = 65536,
	RIS0_FRF17 = 131072,
	RIS0_RESERVED = 4294705152,
};

enum RIS2_BIT {
	RIS2_QFF0 = 1,
	RIS2_QFF1 = 2,
	RIS2_QFF2 = 4,
	RIS2_QFF3 = 8,
	RIS2_QFF4 = 16,
	RIS2_QFF5 = 32,
	RIS2_QFF6 = 64,
	RIS2_QFF7 = 128,
	RIS2_QFF8 = 256,
	RIS2_QFF9 = 512,
	RIS2_QFF10 = 1024,
	RIS2_QFF11 = 2048,
	RIS2_QFF12 = 4096,
	RIS2_QFF13 = 8192,
	RIS2_QFF14 = 16384,
	RIS2_QFF15 = 32768,
	RIS2_QFF16 = 65536,
	RIS2_QFF17 = 131072,
	RIS2_RFFF = 2147483648,
	RIS2_RESERVED = 2147221504,
};

enum RMCR_BIT {
	RMCR_RNC = 1,
};

enum RX_DS_CC_BIT {
	RX_DS = 4095,
	RX_TR = 4096,
	RX_EI = 8192,
	RX_PS = 49152,
};

enum S2MPU02_reg {
	S2MPU02_REG_ID = 0,
	S2MPU02_REG_INT1 = 1,
	S2MPU02_REG_INT2 = 2,
	S2MPU02_REG_INT3 = 3,
	S2MPU02_REG_INT1M = 4,
	S2MPU02_REG_INT2M = 5,
	S2MPU02_REG_INT3M = 6,
	S2MPU02_REG_ST1 = 7,
	S2MPU02_REG_ST2 = 8,
	S2MPU02_REG_PWRONSRC = 9,
	S2MPU02_REG_OFFSRC = 10,
	S2MPU02_REG_BU_CHG = 11,
	S2MPU02_REG_RTCCTRL = 12,
	S2MPU02_REG_PMCTRL1 = 13,
	S2MPU02_REG_RSVD1 = 14,
	S2MPU02_REG_RSVD2 = 15,
	S2MPU02_REG_RSVD3 = 16,
	S2MPU02_REG_RSVD4 = 17,
	S2MPU02_REG_RSVD5 = 18,
	S2MPU02_REG_RSVD6 = 19,
	S2MPU02_REG_RSVD7 = 20,
	S2MPU02_REG_WRSTEN = 21,
	S2MPU02_REG_RSVD8 = 22,
	S2MPU02_REG_RSVD9 = 23,
	S2MPU02_REG_RSVD10 = 24,
	S2MPU02_REG_B1CTRL1 = 25,
	S2MPU02_REG_B1CTRL2 = 26,
	S2MPU02_REG_B2CTRL1 = 27,
	S2MPU02_REG_B2CTRL2 = 28,
	S2MPU02_REG_B3CTRL1 = 29,
	S2MPU02_REG_B3CTRL2 = 30,
	S2MPU02_REG_B4CTRL1 = 31,
	S2MPU02_REG_B4CTRL2 = 32,
	S2MPU02_REG_B5CTRL1 = 33,
	S2MPU02_REG_B5CTRL2 = 34,
	S2MPU02_REG_B5CTRL3 = 35,
	S2MPU02_REG_B5CTRL4 = 36,
	S2MPU02_REG_B5CTRL5 = 37,
	S2MPU02_REG_B6CTRL1 = 38,
	S2MPU02_REG_B6CTRL2 = 39,
	S2MPU02_REG_B7CTRL1 = 40,
	S2MPU02_REG_B7CTRL2 = 41,
	S2MPU02_REG_RAMP1 = 42,
	S2MPU02_REG_RAMP2 = 43,
	S2MPU02_REG_L1CTRL = 44,
	S2MPU02_REG_L2CTRL1 = 45,
	S2MPU02_REG_L2CTRL2 = 46,
	S2MPU02_REG_L2CTRL3 = 47,
	S2MPU02_REG_L2CTRL4 = 48,
	S2MPU02_REG_L3CTRL = 49,
	S2MPU02_REG_L4CTRL = 50,
	S2MPU02_REG_L5CTRL = 51,
	S2MPU02_REG_L6CTRL = 52,
	S2MPU02_REG_L7CTRL = 53,
	S2MPU02_REG_L8CTRL = 54,
	S2MPU02_REG_L9CTRL = 55,
	S2MPU02_REG_L10CTRL = 56,
	S2MPU02_REG_L11CTRL = 57,
	S2MPU02_REG_L12CTRL = 58,
	S2MPU02_REG_L13CTRL = 59,
	S2MPU02_REG_L14CTRL = 60,
	S2MPU02_REG_L15CTRL = 61,
	S2MPU02_REG_L16CTRL = 62,
	S2MPU02_REG_L17CTRL = 63,
	S2MPU02_REG_L18CTRL = 64,
	S2MPU02_REG_L19CTRL = 65,
	S2MPU02_REG_L20CTRL = 66,
	S2MPU02_REG_L21CTRL = 67,
	S2MPU02_REG_L22CTRL = 68,
	S2MPU02_REG_L23CTRL = 69,
	S2MPU02_REG_L24CTRL = 70,
	S2MPU02_REG_L25CTRL = 71,
	S2MPU02_REG_L26CTRL = 72,
	S2MPU02_REG_L27CTRL = 73,
	S2MPU02_REG_L28CTRL = 74,
	S2MPU02_REG_LDODSCH1 = 75,
	S2MPU02_REG_LDODSCH2 = 76,
	S2MPU02_REG_LDODSCH3 = 77,
	S2MPU02_REG_LDODSCH4 = 78,
	S2MPU02_REG_SELMIF = 79,
	S2MPU02_REG_RSVD11 = 80,
	S2MPU02_REG_RSVD12 = 81,
	S2MPU02_REG_RSVD13 = 82,
	S2MPU02_REG_DVSSEL = 83,
	S2MPU02_REG_DVSPTR = 84,
	S2MPU02_REG_DVSDATA = 85,
};

enum S2MPU02_regulators {
	S2MPU02_LDO1 = 0,
	S2MPU02_LDO2 = 1,
	S2MPU02_LDO3 = 2,
	S2MPU02_LDO4 = 3,
	S2MPU02_LDO5 = 4,
	S2MPU02_LDO6 = 5,
	S2MPU02_LDO7 = 6,
	S2MPU02_LDO8 = 7,
	S2MPU02_LDO9 = 8,
	S2MPU02_LDO10 = 9,
	S2MPU02_LDO11 = 10,
	S2MPU02_LDO12 = 11,
	S2MPU02_LDO13 = 12,
	S2MPU02_LDO14 = 13,
	S2MPU02_LDO15 = 14,
	S2MPU02_LDO16 = 15,
	S2MPU02_LDO17 = 16,
	S2MPU02_LDO18 = 17,
	S2MPU02_LDO19 = 18,
	S2MPU02_LDO20 = 19,
	S2MPU02_LDO21 = 20,
	S2MPU02_LDO22 = 21,
	S2MPU02_LDO23 = 22,
	S2MPU02_LDO24 = 23,
	S2MPU02_LDO25 = 24,
	S2MPU02_LDO26 = 25,
	S2MPU02_LDO27 = 26,
	S2MPU02_LDO28 = 27,
	S2MPU02_BUCK1 = 28,
	S2MPU02_BUCK2 = 29,
	S2MPU02_BUCK3 = 30,
	S2MPU02_BUCK4 = 31,
	S2MPU02_BUCK5 = 32,
	S2MPU02_BUCK6 = 33,
	S2MPU02_BUCK7 = 34,
	S2MPU02_REGULATOR_MAX = 35,
};

enum SCI_CLKS {
	SCI_FCK = 0,
	SCI_SCK = 1,
	SCI_BRG_INT = 2,
	SCI_SCIF_CLK = 3,
	SCI_NUM_CLKS = 4,
};

enum SCI_PORT_TYPE {
	SCI_PORT_RSCI = 128,
};

enum SHIFT_DIRECTION {
	SHIFT_LEFT = 0,
	SHIFT_RIGHT = 1,
};

enum TCCR_BIT {
	TCCR_TSRQ0 = 1,
	TCCR_TSRQ1 = 2,
	TCCR_TSRQ2 = 4,
	TCCR_TSRQ3 = 8,
	TCCR_TFEN = 256,
	TCCR_TFR = 512,
};

enum TD_STS_BIT {
	TD_TACT = 2147483648,
	TD_TDLE = 1073741824,
	TD_TFP1 = 536870912,
	TD_TFP0 = 268435456,
	TD_TFE = 134217728,
	TD_TWBI = 67108864,
};

enum TFA2_BIT {
	TFA2_TSV = 65535,
	TFA2_TST = 67043328,
};

enum TGC_BIT {
	TGC_TSM0 = 1,
	TGC_TSM1 = 2,
	TGC_TSM2 = 4,
	TGC_TSM3 = 8,
	TGC_TQP = 48,
	TGC_TQP_NONAVB = 0,
	TGC_TQP_AVBMODE1 = 16,
	TGC_TQP_AVBMODE2 = 48,
	TGC_TBD0 = 768,
	TGC_TBD1 = 12288,
	TGC_TBD2 = 196608,
	TGC_TBD3 = 3145728,
};

enum TIC_BIT {
	TIC_FTE0 = 1,
	TIC_FTE1 = 2,
	TIC_TFUE = 256,
	TIC_TFWE = 512,
};

enum TIS_BIT {
	TIS_FTF0 = 1,
	TIS_FTF1 = 2,
	TIS_TFUF = 256,
	TIS_TFWF = 512,
	TIS_RESERVED = 4293980400,
};

enum TPAUSER_BIT {
	TPAUSER_TPAUSE = 65535,
	TPAUSER_UNLIMITED = 0,
};

enum TPM_OPS_FLAGS {
	TPM_OPS_AUTO_STARTUP = 1,
};

enum TRSCER_BIT {
	TRSCER_CNDCE = 2048,
	TRSCER_DLCCE = 1024,
	TRSCER_CDCE = 512,
	TRSCER_TROCE = 256,
	TRSCER_RMAFCE = 128,
	TRSCER_RRFCE = 16,
	TRSCER_RTLFCE = 8,
	TRSCER_RTSFCE = 4,
	TRSCER_PRECE = 2,
	TRSCER_CERFCE = 1,
};

enum TSR_BIT {
	TSR_CCS0 = 3,
	TSR_CCS1 = 12,
	TSR_TFFL = 1792,
};

enum TSU_ADSBSY_BIT {
	TSU_ADSBSY_0 = 1,
};

enum TSU_FWSLC_BIT {
	TSU_FWSLC_POSTENU = 8192,
	TSU_FWSLC_POSTENL = 4096,
	TSU_FWSLC_CAMSEL03 = 128,
	TSU_FWSLC_CAMSEL02 = 64,
	TSU_FWSLC_CAMSEL01 = 32,
	TSU_FWSLC_CAMSEL00 = 16,
	TSU_FWSLC_CAMSEL13 = 8,
	TSU_FWSLC_CAMSEL12 = 4,
	TSU_FWSLC_CAMSEL11 = 2,
	TSU_FWSLC_CAMSEL10 = 1,
};

enum TX_DS_TAGL_BIT {
	TX_DS = 4095,
	TX_TAGL = 61440,
};

enum TX_FS_TAGL_BIT {
	TX_DS___2 = 4095,
	TX_TAGL___2 = 61440,
};

enum TX_TAGH_TSR_BIT {
	TX_TAGH = 63,
	TX_TSR = 64,
};

enum _MR_CRASH_BUF_STATUS {
	MR_CRASH_BUF_TURN_OFF = 0,
	MR_CRASH_BUF_TURN_ON = 1,
};

enum __kvm_host_smccc_func {
	__KVM_HOST_SMCCC_FUNC___pkvm_init = 1,
	__KVM_HOST_SMCCC_FUNC___pkvm_create_private_mapping = 2,
	__KVM_HOST_SMCCC_FUNC___pkvm_cpu_set_vector = 3,
	__KVM_HOST_SMCCC_FUNC___kvm_enable_ssbs = 4,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_init_lrs = 5,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_get_gic_config = 6,
	__KVM_HOST_SMCCC_FUNC___pkvm_prot_finalize = 7,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_share_hyp = 8,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_unshare_hyp = 9,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_share_guest = 10,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_unshare_guest = 11,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_relax_perms_guest = 12,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_wrprotect_guest = 13,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_test_clear_young_guest = 14,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_mkyoung_guest = 15,
	__KVM_HOST_SMCCC_FUNC___kvm_adjust_pc = 16,
	__KVM_HOST_SMCCC_FUNC___kvm_vcpu_run = 17,
	__KVM_HOST_SMCCC_FUNC___kvm_flush_vm_context = 18,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid_ipa = 19,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid_ipa_nsh = 20,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid = 21,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid_range = 22,
	__KVM_HOST_SMCCC_FUNC___kvm_flush_cpu_context = 23,
	__KVM_HOST_SMCCC_FUNC___kvm_timer_set_cntvoff = 24,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_save_vmcr_aprs = 25,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_restore_vmcr_aprs = 26,
	__KVM_HOST_SMCCC_FUNC___pkvm_reserve_vm = 27,
	__KVM_HOST_SMCCC_FUNC___pkvm_unreserve_vm = 28,
	__KVM_HOST_SMCCC_FUNC___pkvm_init_vm = 29,
	__KVM_HOST_SMCCC_FUNC___pkvm_init_vcpu = 30,
	__KVM_HOST_SMCCC_FUNC___pkvm_teardown_vm = 31,
	__KVM_HOST_SMCCC_FUNC___pkvm_vcpu_load = 32,
	__KVM_HOST_SMCCC_FUNC___pkvm_vcpu_put = 33,
	__KVM_HOST_SMCCC_FUNC___pkvm_tlb_flush_vmid = 34,
};

enum __sk_action {
	__SK_DROP = 0,
	__SK_PASS = 1,
	__SK_REDIRECT = 2,
	__SK_NONE = 3,
};

enum _dsm_op_index {
	HNS_OP_RESET_FUNC = 1,
	HNS_OP_SERDES_LP_FUNC = 2,
	HNS_OP_LED_SET_FUNC = 3,
	HNS_OP_GET_PORT_TYPE_FUNC = 4,
	HNS_OP_GET_SFP_STAT_FUNC = 5,
	HNS_OP_LOCATE_LED_SET_FUNC = 6,
};

enum _dsm_rst_type {
	HNS_DSAF_RESET_FUNC = 1,
	HNS_PPE_RESET_FUNC = 2,
	HNS_XGE_RESET_FUNC = 4,
	HNS_GE_RESET_FUNC = 5,
	HNS_DSAF_CHN_RESET_FUNC = 6,
	HNS_ROCE_RESET_FUNC = 7,
};

enum _pmux_input {
	SMUX_INDEX = 0,
	PLL_INDEX = 1,
	ACD_INDEX = 2,
	ALT_INDEX = 3,
	NUM_OF_PMUX_INPUTS = 4,
};

enum _slab_flag_bits {
	_SLAB_CONSISTENCY_CHECKS = 0,
	_SLAB_RED_ZONE = 1,
	_SLAB_POISON = 2,
	_SLAB_KMALLOC = 3,
	_SLAB_HWCACHE_ALIGN = 4,
	_SLAB_CACHE_DMA = 5,
	_SLAB_CACHE_DMA32 = 6,
	_SLAB_STORE_USER = 7,
	_SLAB_PANIC = 8,
	_SLAB_TYPESAFE_BY_RCU = 9,
	_SLAB_TRACE = 10,
	_SLAB_NOLEAKTRACE = 11,
	_SLAB_NO_MERGE = 12,
	_SLAB_ACCOUNT = 13,
	_SLAB_NO_USER_FLAGS = 14,
	_SLAB_RECLAIM_ACCOUNT = 15,
	_SLAB_OBJECT_POISON = 16,
	_SLAB_CMPXCHG_DOUBLE = 17,
	_SLAB_NO_OBJ_EXT = 18,
	_SLAB_FLAGS_LAST_BIT = 19,
};

enum aarch32_map {
	AA32_MAP_VECTORS = 0,
	AA32_MAP_SIGPAGE = 1,
	AA32_MAP_VDSO = 2,
};

enum aarch64_insn_adr_type {
	AARCH64_INSN_ADR_TYPE_ADRP = 0,
	AARCH64_INSN_ADR_TYPE_ADR = 1,
};

enum aarch64_insn_adsb_type {
	AARCH64_INSN_ADSB_ADD = 0,
	AARCH64_INSN_ADSB_SUB = 1,
	AARCH64_INSN_ADSB_ADD_SETFLAGS = 2,
	AARCH64_INSN_ADSB_SUB_SETFLAGS = 3,
};

enum aarch64_insn_bitfield_type {
	AARCH64_INSN_BITFIELD_MOVE = 0,
	AARCH64_INSN_BITFIELD_MOVE_UNSIGNED = 1,
	AARCH64_INSN_BITFIELD_MOVE_SIGNED = 2,
};

enum aarch64_insn_branch_type {
	AARCH64_INSN_BRANCH_NOLINK = 0,
	AARCH64_INSN_BRANCH_LINK = 1,
	AARCH64_INSN_BRANCH_RETURN = 2,
	AARCH64_INSN_BRANCH_COMP_ZERO = 3,
	AARCH64_INSN_BRANCH_COMP_NONZERO = 4,
};

enum aarch64_insn_condition {
	AARCH64_INSN_COND_EQ = 0,
	AARCH64_INSN_COND_NE = 1,
	AARCH64_INSN_COND_CS = 2,
	AARCH64_INSN_COND_CC = 3,
	AARCH64_INSN_COND_MI = 4,
	AARCH64_INSN_COND_PL = 5,
	AARCH64_INSN_COND_VS = 6,
	AARCH64_INSN_COND_VC = 7,
	AARCH64_INSN_COND_HI = 8,
	AARCH64_INSN_COND_LS = 9,
	AARCH64_INSN_COND_GE = 10,
	AARCH64_INSN_COND_LT = 11,
	AARCH64_INSN_COND_GT = 12,
	AARCH64_INSN_COND_LE = 13,
	AARCH64_INSN_COND_AL = 14,
};

enum aarch64_insn_data1_type {
	AARCH64_INSN_DATA1_REVERSE_16 = 0,
	AARCH64_INSN_DATA1_REVERSE_32 = 1,
	AARCH64_INSN_DATA1_REVERSE_64 = 2,
};

enum aarch64_insn_data2_type {
	AARCH64_INSN_DATA2_UDIV = 0,
	AARCH64_INSN_DATA2_SDIV = 1,
	AARCH64_INSN_DATA2_LSLV = 2,
	AARCH64_INSN_DATA2_LSRV = 3,
	AARCH64_INSN_DATA2_ASRV = 4,
	AARCH64_INSN_DATA2_RORV = 5,
};

enum aarch64_insn_data3_type {
	AARCH64_INSN_DATA3_MADD = 0,
	AARCH64_INSN_DATA3_MSUB = 1,
};

enum aarch64_insn_hint_cr_op {
	AARCH64_INSN_HINT_NOP = 0,
	AARCH64_INSN_HINT_YIELD = 32,
	AARCH64_INSN_HINT_WFE = 64,
	AARCH64_INSN_HINT_WFI = 96,
	AARCH64_INSN_HINT_SEV = 128,
	AARCH64_INSN_HINT_SEVL = 160,
	AARCH64_INSN_HINT_XPACLRI = 224,
	AARCH64_INSN_HINT_PACIA_1716 = 256,
	AARCH64_INSN_HINT_PACIB_1716 = 320,
	AARCH64_INSN_HINT_AUTIA_1716 = 384,
	AARCH64_INSN_HINT_AUTIB_1716 = 448,
	AARCH64_INSN_HINT_PACIAZ = 768,
	AARCH64_INSN_HINT_PACIASP = 800,
	AARCH64_INSN_HINT_PACIBZ = 832,
	AARCH64_INSN_HINT_PACIBSP = 864,
	AARCH64_INSN_HINT_AUTIAZ = 896,
	AARCH64_INSN_HINT_AUTIASP = 928,
	AARCH64_INSN_HINT_AUTIBZ = 960,
	AARCH64_INSN_HINT_AUTIBSP = 992,
	AARCH64_INSN_HINT_ESB = 512,
	AARCH64_INSN_HINT_PSB = 544,
	AARCH64_INSN_HINT_TSB = 576,
	AARCH64_INSN_HINT_CSDB = 640,
	AARCH64_INSN_HINT_CLEARBHB = 704,
	AARCH64_INSN_HINT_BTI = 1024,
	AARCH64_INSN_HINT_BTIC = 1088,
	AARCH64_INSN_HINT_BTIJ = 1152,
	AARCH64_INSN_HINT_BTIJC = 1216,
};

enum aarch64_insn_imm_type {
	AARCH64_INSN_IMM_ADR = 0,
	AARCH64_INSN_IMM_26 = 1,
	AARCH64_INSN_IMM_19 = 2,
	AARCH64_INSN_IMM_16 = 3,
	AARCH64_INSN_IMM_14 = 4,
	AARCH64_INSN_IMM_12 = 5,
	AARCH64_INSN_IMM_9 = 6,
	AARCH64_INSN_IMM_7 = 7,
	AARCH64_INSN_IMM_6 = 8,
	AARCH64_INSN_IMM_S = 9,
	AARCH64_INSN_IMM_R = 10,
	AARCH64_INSN_IMM_N = 11,
	AARCH64_INSN_IMM_MAX = 12,
};

enum aarch64_insn_ldst_type {
	AARCH64_INSN_LDST_LOAD_REG_OFFSET = 0,
	AARCH64_INSN_LDST_STORE_REG_OFFSET = 1,
	AARCH64_INSN_LDST_LOAD_IMM_OFFSET = 2,
	AARCH64_INSN_LDST_STORE_IMM_OFFSET = 3,
	AARCH64_INSN_LDST_LOAD_PAIR_PRE_INDEX = 4,
	AARCH64_INSN_LDST_STORE_PAIR_PRE_INDEX = 5,
	AARCH64_INSN_LDST_LOAD_PAIR_POST_INDEX = 6,
	AARCH64_INSN_LDST_STORE_PAIR_POST_INDEX = 7,
	AARCH64_INSN_LDST_LOAD_ACQ = 8,
	AARCH64_INSN_LDST_LOAD_EX = 9,
	AARCH64_INSN_LDST_LOAD_ACQ_EX = 10,
	AARCH64_INSN_LDST_STORE_REL = 11,
	AARCH64_INSN_LDST_STORE_EX = 12,
	AARCH64_INSN_LDST_STORE_REL_EX = 13,
	AARCH64_INSN_LDST_SIGNED_LOAD_IMM_OFFSET = 14,
	AARCH64_INSN_LDST_SIGNED_LOAD_REG_OFFSET = 15,
};

enum aarch64_insn_logic_type {
	AARCH64_INSN_LOGIC_AND = 0,
	AARCH64_INSN_LOGIC_BIC = 1,
	AARCH64_INSN_LOGIC_ORR = 2,
	AARCH64_INSN_LOGIC_ORN = 3,
	AARCH64_INSN_LOGIC_EOR = 4,
	AARCH64_INSN_LOGIC_EON = 5,
	AARCH64_INSN_LOGIC_AND_SETFLAGS = 6,
	AARCH64_INSN_LOGIC_BIC_SETFLAGS = 7,
};

enum aarch64_insn_mb_type {
	AARCH64_INSN_MB_SY = 0,
	AARCH64_INSN_MB_ST = 1,
	AARCH64_INSN_MB_LD = 2,
	AARCH64_INSN_MB_ISH = 3,
	AARCH64_INSN_MB_ISHST = 4,
	AARCH64_INSN_MB_ISHLD = 5,
	AARCH64_INSN_MB_NSH = 6,
	AARCH64_INSN_MB_NSHST = 7,
	AARCH64_INSN_MB_NSHLD = 8,
	AARCH64_INSN_MB_OSH = 9,
	AARCH64_INSN_MB_OSHST = 10,
	AARCH64_INSN_MB_OSHLD = 11,
};

enum aarch64_insn_mem_atomic_op {
	AARCH64_INSN_MEM_ATOMIC_ADD = 0,
	AARCH64_INSN_MEM_ATOMIC_CLR = 1,
	AARCH64_INSN_MEM_ATOMIC_EOR = 2,
	AARCH64_INSN_MEM_ATOMIC_SET = 3,
	AARCH64_INSN_MEM_ATOMIC_SWP = 4,
};

enum aarch64_insn_mem_order_type {
	AARCH64_INSN_MEM_ORDER_NONE = 0,
	AARCH64_INSN_MEM_ORDER_ACQ = 1,
	AARCH64_INSN_MEM_ORDER_REL = 2,
	AARCH64_INSN_MEM_ORDER_ACQREL = 3,
};

enum aarch64_insn_movewide_type {
	AARCH64_INSN_MOVEWIDE_ZERO = 0,
	AARCH64_INSN_MOVEWIDE_KEEP = 1,
	AARCH64_INSN_MOVEWIDE_INVERSE = 2,
};

enum aarch64_insn_movw_imm_type {
	AARCH64_INSN_IMM_MOVNZ = 0,
	AARCH64_INSN_IMM_MOVKZ = 1,
};

enum aarch64_insn_register {
	AARCH64_INSN_REG_0 = 0,
	AARCH64_INSN_REG_1 = 1,
	AARCH64_INSN_REG_2 = 2,
	AARCH64_INSN_REG_3 = 3,
	AARCH64_INSN_REG_4 = 4,
	AARCH64_INSN_REG_5 = 5,
	AARCH64_INSN_REG_6 = 6,
	AARCH64_INSN_REG_7 = 7,
	AARCH64_INSN_REG_8 = 8,
	AARCH64_INSN_REG_9 = 9,
	AARCH64_INSN_REG_10 = 10,
	AARCH64_INSN_REG_11 = 11,
	AARCH64_INSN_REG_12 = 12,
	AARCH64_INSN_REG_13 = 13,
	AARCH64_INSN_REG_14 = 14,
	AARCH64_INSN_REG_15 = 15,
	AARCH64_INSN_REG_16 = 16,
	AARCH64_INSN_REG_17 = 17,
	AARCH64_INSN_REG_18 = 18,
	AARCH64_INSN_REG_19 = 19,
	AARCH64_INSN_REG_20 = 20,
	AARCH64_INSN_REG_21 = 21,
	AARCH64_INSN_REG_22 = 22,
	AARCH64_INSN_REG_23 = 23,
	AARCH64_INSN_REG_24 = 24,
	AARCH64_INSN_REG_25 = 25,
	AARCH64_INSN_REG_26 = 26,
	AARCH64_INSN_REG_27 = 27,
	AARCH64_INSN_REG_28 = 28,
	AARCH64_INSN_REG_29 = 29,
	AARCH64_INSN_REG_FP = 29,
	AARCH64_INSN_REG_30 = 30,
	AARCH64_INSN_REG_LR = 30,
	AARCH64_INSN_REG_ZR = 31,
	AARCH64_INSN_REG_SP = 31,
};

enum aarch64_insn_register_type {
	AARCH64_INSN_REGTYPE_RT = 0,
	AARCH64_INSN_REGTYPE_RN = 1,
	AARCH64_INSN_REGTYPE_RT2 = 2,
	AARCH64_INSN_REGTYPE_RM = 3,
	AARCH64_INSN_REGTYPE_RD = 4,
	AARCH64_INSN_REGTYPE_RA = 5,
	AARCH64_INSN_REGTYPE_RS = 6,
};

enum aarch64_insn_size_type {
	AARCH64_INSN_SIZE_8 = 0,
	AARCH64_INSN_SIZE_16 = 1,
	AARCH64_INSN_SIZE_32 = 2,
	AARCH64_INSN_SIZE_64 = 3,
};

enum aarch64_insn_system_register {
	AARCH64_INSN_SYSREG_TPIDR_EL1 = 18052,
	AARCH64_INSN_SYSREG_TPIDR_EL2 = 26242,
	AARCH64_INSN_SYSREG_SP_EL0 = 16904,
};

enum aarch64_insn_variant {
	AARCH64_INSN_VARIANT_32BIT = 0,
	AARCH64_INSN_VARIANT_64BIT = 1,
};

enum aarch64_reloc_op {
	RELOC_OP_NONE = 0,
	RELOC_OP_ABS = 1,
	RELOC_OP_PREL = 2,
	RELOC_OP_PAGE = 3,
};

enum access_coordinate_class {
	ACCESS_COORDINATE_LOCAL = 0,
	ACCESS_COORDINATE_CPU = 1,
	ACCESS_COORDINATE_MAX = 2,
};

enum acpi_attr_enum {
	ACPI_ATTR_LABEL_SHOW = 0,
	ACPI_ATTR_INDEX_SHOW = 1,
};

enum acpi_bridge_type {
	ACPI_BRIDGE_TYPE_PCIE = 1,
	ACPI_BRIDGE_TYPE_CXL = 2,
};

enum acpi_bus_device_type {
	ACPI_BUS_TYPE_DEVICE = 0,
	ACPI_BUS_TYPE_POWER = 1,
	ACPI_BUS_TYPE_PROCESSOR = 2,
	ACPI_BUS_TYPE_THERMAL = 3,
	ACPI_BUS_TYPE_POWER_BUTTON = 4,
	ACPI_BUS_TYPE_SLEEP_BUTTON = 5,
	ACPI_BUS_TYPE_ECDT_EC = 6,
	ACPI_BUS_DEVICE_TYPE_COUNT = 7,
};

enum acpi_cdat_type {
	ACPI_CDAT_TYPE_DSMAS = 0,
	ACPI_CDAT_TYPE_DSLBIS = 1,
	ACPI_CDAT_TYPE_DSMSCIS = 2,
	ACPI_CDAT_TYPE_DSIS = 3,
	ACPI_CDAT_TYPE_DSEMTS = 4,
	ACPI_CDAT_TYPE_SSLBIS = 5,
	ACPI_CDAT_TYPE_RESERVED = 6,
};

enum acpi_cedt_type {
	ACPI_CEDT_TYPE_CHBS = 0,
	ACPI_CEDT_TYPE_CFMWS = 1,
	ACPI_CEDT_TYPE_CXIMS = 2,
	ACPI_CEDT_TYPE_RDPAS = 3,
	ACPI_CEDT_TYPE_RESERVED = 4,
};

enum acpi_device_swnode_dev_props {
	ACPI_DEVICE_SWNODE_DEV_ROTATION = 0,
	ACPI_DEVICE_SWNODE_DEV_CLOCK_FREQUENCY = 1,
	ACPI_DEVICE_SWNODE_DEV_LED_MAX_MICROAMP = 2,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_MICROAMP = 3,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_TIMEOUT_US = 4,
	ACPI_DEVICE_SWNODE_DEV_NUM_OF = 5,
	ACPI_DEVICE_SWNODE_DEV_NUM_ENTRIES = 6,
};

enum acpi_device_swnode_ep_props {
	ACPI_DEVICE_SWNODE_EP_REMOTE_EP = 0,
	ACPI_DEVICE_SWNODE_EP_BUS_TYPE = 1,
	ACPI_DEVICE_SWNODE_EP_REG = 2,
	ACPI_DEVICE_SWNODE_EP_CLOCK_LANES = 3,
	ACPI_DEVICE_SWNODE_EP_DATA_LANES = 4,
	ACPI_DEVICE_SWNODE_EP_LANE_POLARITIES = 5,
	ACPI_DEVICE_SWNODE_EP_LINK_FREQUENCIES = 6,
	ACPI_DEVICE_SWNODE_EP_NUM_OF = 7,
	ACPI_DEVICE_SWNODE_EP_NUM_ENTRIES = 8,
};

enum acpi_device_swnode_port_props {
	ACPI_DEVICE_SWNODE_PORT_REG = 0,
	ACPI_DEVICE_SWNODE_PORT_NUM_OF = 1,
	ACPI_DEVICE_SWNODE_PORT_NUM_ENTRIES = 2,
};

enum acpi_einj_actions {
	ACPI_EINJ_BEGIN_OPERATION = 0,
	ACPI_EINJ_GET_TRIGGER_TABLE = 1,
	ACPI_EINJ_SET_ERROR_TYPE = 2,
	ACPI_EINJ_GET_ERROR_TYPE = 3,
	ACPI_EINJ_END_OPERATION = 4,
	ACPI_EINJ_EXECUTE_OPERATION = 5,
	ACPI_EINJ_CHECK_BUSY_STATUS = 6,
	ACPI_EINJ_GET_COMMAND_STATUS = 7,
	ACPI_EINJ_SET_ERROR_TYPE_WITH_ADDRESS = 8,
	ACPI_EINJ_GET_EXECUTE_TIMINGS = 9,
	ACPI_EINJV2_GET_ERROR_TYPE = 17,
	ACPI_EINJ_ACTION_RESERVED = 18,
	ACPI_EINJ_TRIGGER_ERROR = 255,
};

enum acpi_einj_instructions {
	ACPI_EINJ_READ_REGISTER = 0,
	ACPI_EINJ_READ_REGISTER_VALUE = 1,
	ACPI_EINJ_WRITE_REGISTER = 2,
	ACPI_EINJ_WRITE_REGISTER_VALUE = 3,
	ACPI_EINJ_NOOP = 4,
	ACPI_EINJ_FLUSH_CACHELINE = 5,
	ACPI_EINJ_INSTRUCTION_RESERVED = 6,
};

enum acpi_erst_actions {
	ACPI_ERST_BEGIN_WRITE = 0,
	ACPI_ERST_BEGIN_READ = 1,
	ACPI_ERST_BEGIN_CLEAR = 2,
	ACPI_ERST_END = 3,
	ACPI_ERST_SET_RECORD_OFFSET = 4,
	ACPI_ERST_EXECUTE_OPERATION = 5,
	ACPI_ERST_CHECK_BUSY_STATUS = 6,
	ACPI_ERST_GET_COMMAND_STATUS = 7,
	ACPI_ERST_GET_RECORD_ID = 8,
	ACPI_ERST_SET_RECORD_ID = 9,
	ACPI_ERST_GET_RECORD_COUNT = 10,
	ACPI_ERST_BEGIN_DUMMY_WRIITE = 11,
	ACPI_ERST_NOT_USED = 12,
	ACPI_ERST_GET_ERROR_RANGE = 13,
	ACPI_ERST_GET_ERROR_LENGTH = 14,
	ACPI_ERST_GET_ERROR_ATTRIBUTES = 15,
	ACPI_ERST_EXECUTE_TIMINGS = 16,
	ACPI_ERST_ACTION_RESERVED = 17,
};

enum acpi_gpio_ignore_list {
	ACPI_GPIO_IGNORE_WAKE = 0,
	ACPI_GPIO_IGNORE_INTERRUPT = 1,
};

enum acpi_gtdt_type {
	ACPI_GTDT_TYPE_TIMER_BLOCK = 0,
	ACPI_GTDT_TYPE_WATCHDOG = 1,
	ACPI_GTDT_TYPE_RESERVED = 2,
};

enum acpi_hest_notify_types {
	ACPI_HEST_NOTIFY_POLLED = 0,
	ACPI_HEST_NOTIFY_EXTERNAL = 1,
	ACPI_HEST_NOTIFY_LOCAL = 2,
	ACPI_HEST_NOTIFY_SCI = 3,
	ACPI_HEST_NOTIFY_NMI = 4,
	ACPI_HEST_NOTIFY_CMCI = 5,
	ACPI_HEST_NOTIFY_MCE = 6,
	ACPI_HEST_NOTIFY_GPIO = 7,
	ACPI_HEST_NOTIFY_SEA = 8,
	ACPI_HEST_NOTIFY_SEI = 9,
	ACPI_HEST_NOTIFY_GSIV = 10,
	ACPI_HEST_NOTIFY_SOFTWARE_DELEGATED = 11,
	ACPI_HEST_NOTIFY_RESERVED = 12,
};

enum acpi_hest_types {
	ACPI_HEST_TYPE_IA32_CHECK = 0,
	ACPI_HEST_TYPE_IA32_CORRECTED_CHECK = 1,
	ACPI_HEST_TYPE_IA32_NMI = 2,
	ACPI_HEST_TYPE_NOT_USED3 = 3,
	ACPI_HEST_TYPE_NOT_USED4 = 4,
	ACPI_HEST_TYPE_NOT_USED5 = 5,
	ACPI_HEST_TYPE_AER_ROOT_PORT = 6,
	ACPI_HEST_TYPE_AER_ENDPOINT = 7,
	ACPI_HEST_TYPE_AER_BRIDGE = 8,
	ACPI_HEST_TYPE_GENERIC_ERROR = 9,
	ACPI_HEST_TYPE_GENERIC_ERROR_V2 = 10,
	ACPI_HEST_TYPE_IA32_DEFERRED_CHECK = 11,
	ACPI_HEST_TYPE_RESERVED = 12,
};

enum acpi_hmat_type {
	ACPI_HMAT_TYPE_PROXIMITY = 0,
	ACPI_HMAT_TYPE_LOCALITY = 1,
	ACPI_HMAT_TYPE_CACHE = 2,
	ACPI_HMAT_TYPE_RESERVED = 3,
};

enum acpi_iort_node_type {
	ACPI_IORT_NODE_ITS_GROUP = 0,
	ACPI_IORT_NODE_NAMED_COMPONENT = 1,
	ACPI_IORT_NODE_PCI_ROOT_COMPLEX = 2,
	ACPI_IORT_NODE_SMMU = 3,
	ACPI_IORT_NODE_SMMU_V3 = 4,
	ACPI_IORT_NODE_PMCG = 5,
	ACPI_IORT_NODE_RMR = 6,
};

enum acpi_irq_model_id {
	ACPI_IRQ_MODEL_PIC = 0,
	ACPI_IRQ_MODEL_IOAPIC = 1,
	ACPI_IRQ_MODEL_IOSAPIC = 2,
	ACPI_IRQ_MODEL_PLATFORM = 3,
	ACPI_IRQ_MODEL_GIC = 4,
	ACPI_IRQ_MODEL_LPIC = 5,
	ACPI_IRQ_MODEL_RINTC = 6,
	ACPI_IRQ_MODEL_COUNT = 7,
};

enum acpi_madt_gic_version {
	ACPI_MADT_GIC_VERSION_NONE = 0,
	ACPI_MADT_GIC_VERSION_V1 = 1,
	ACPI_MADT_GIC_VERSION_V2 = 2,
	ACPI_MADT_GIC_VERSION_V3 = 3,
	ACPI_MADT_GIC_VERSION_V4 = 4,
	ACPI_MADT_GIC_VERSION_RESERVED = 5,
};

enum acpi_madt_multiproc_wakeup_version {
	ACPI_MADT_MP_WAKEUP_VERSION_NONE = 0,
	ACPI_MADT_MP_WAKEUP_VERSION_V1 = 1,
	ACPI_MADT_MP_WAKEUP_VERSION_RESERVED = 2,
};

enum acpi_madt_type {
	ACPI_MADT_TYPE_LOCAL_APIC = 0,
	ACPI_MADT_TYPE_IO_APIC = 1,
	ACPI_MADT_TYPE_INTERRUPT_OVERRIDE = 2,
	ACPI_MADT_TYPE_NMI_SOURCE = 3,
	ACPI_MADT_TYPE_LOCAL_APIC_NMI = 4,
	ACPI_MADT_TYPE_LOCAL_APIC_OVERRIDE = 5,
	ACPI_MADT_TYPE_IO_SAPIC = 6,
	ACPI_MADT_TYPE_LOCAL_SAPIC = 7,
	ACPI_MADT_TYPE_INTERRUPT_SOURCE = 8,
	ACPI_MADT_TYPE_LOCAL_X2APIC = 9,
	ACPI_MADT_TYPE_LOCAL_X2APIC_NMI = 10,
	ACPI_MADT_TYPE_GENERIC_INTERRUPT = 11,
	ACPI_MADT_TYPE_GENERIC_DISTRIBUTOR = 12,
	ACPI_MADT_TYPE_GENERIC_MSI_FRAME = 13,
	ACPI_MADT_TYPE_GENERIC_REDISTRIBUTOR = 14,
	ACPI_MADT_TYPE_GENERIC_TRANSLATOR = 15,
	ACPI_MADT_TYPE_MULTIPROC_WAKEUP = 16,
	ACPI_MADT_TYPE_CORE_PIC = 17,
	ACPI_MADT_TYPE_LIO_PIC = 18,
	ACPI_MADT_TYPE_HT_PIC = 19,
	ACPI_MADT_TYPE_EIO_PIC = 20,
	ACPI_MADT_TYPE_MSI_PIC = 21,
	ACPI_MADT_TYPE_BIO_PIC = 22,
	ACPI_MADT_TYPE_LPC_PIC = 23,
	ACPI_MADT_TYPE_RINTC = 24,
	ACPI_MADT_TYPE_IMSIC = 25,
	ACPI_MADT_TYPE_APLIC = 26,
	ACPI_MADT_TYPE_PLIC = 27,
	ACPI_MADT_TYPE_RESERVED = 28,
	ACPI_MADT_TYPE_OEM_RESERVED = 128,
};

enum acpi_pcct_type {
	ACPI_PCCT_TYPE_GENERIC_SUBSPACE = 0,
	ACPI_PCCT_TYPE_HW_REDUCED_SUBSPACE = 1,
	ACPI_PCCT_TYPE_HW_REDUCED_SUBSPACE_TYPE2 = 2,
	ACPI_PCCT_TYPE_EXT_PCC_MASTER_SUBSPACE = 3,
	ACPI_PCCT_TYPE_EXT_PCC_SLAVE_SUBSPACE = 4,
	ACPI_PCCT_TYPE_HW_REG_COMM_SUBSPACE = 5,
	ACPI_PCCT_TYPE_RESERVED = 6,
};

enum acpi_pptt_type {
	ACPI_PPTT_TYPE_PROCESSOR = 0,
	ACPI_PPTT_TYPE_CACHE = 1,
	ACPI_PPTT_TYPE_ID = 2,
	ACPI_PPTT_TYPE_RESERVED = 3,
};

enum acpi_predicate {
	all_versions = 0,
	less_than_or_equal = 1,
	equal = 2,
	greater_than_or_equal = 3,
};

enum acpi_reconfig_event {
	ACPI_RECONFIG_DEVICE_ADD = 0,
	ACPI_RECONFIG_DEVICE_REMOVE = 1,
};

enum acpi_return_package_types {
	ACPI_PTYPE1_FIXED = 1,
	ACPI_PTYPE1_VAR = 2,
	ACPI_PTYPE1_OPTION = 3,
	ACPI_PTYPE2 = 4,
	ACPI_PTYPE2_COUNT = 5,
	ACPI_PTYPE2_PKG_COUNT = 6,
	ACPI_PTYPE2_FIXED = 7,
	ACPI_PTYPE2_MIN = 8,
	ACPI_PTYPE2_REV_FIXED = 9,
	ACPI_PTYPE2_FIX_VAR = 10,
	ACPI_PTYPE2_VAR_VAR = 11,
	ACPI_PTYPE2_UUID_PAIR = 12,
	ACPI_PTYPE_CUSTOM = 13,
};

enum acpi_srat_type {
	ACPI_SRAT_TYPE_CPU_AFFINITY = 0,
	ACPI_SRAT_TYPE_MEMORY_AFFINITY = 1,
	ACPI_SRAT_TYPE_X2APIC_CPU_AFFINITY = 2,
	ACPI_SRAT_TYPE_GICC_AFFINITY = 3,
	ACPI_SRAT_TYPE_GIC_ITS_AFFINITY = 4,
	ACPI_SRAT_TYPE_GENERIC_AFFINITY = 5,
	ACPI_SRAT_TYPE_GENERIC_PORT_AFFINITY = 6,
	ACPI_SRAT_TYPE_RINTC_AFFINITY = 7,
	ACPI_SRAT_TYPE_RESERVED = 8,
};

enum acpi_subtable_type {
	ACPI_SUBTABLE_COMMON = 0,
	ACPI_SUBTABLE_HMAT = 1,
	ACPI_SUBTABLE_PRMT = 2,
	ACPI_SUBTABLE_CEDT = 3,
	CDAT_SUBTABLE = 4,
};

enum actions {
	REGISTER = 0,
	DEREGISTER = 1,
	CPU_DONT_CARE = 2,
};

enum ahci_qoriq_type {
	AHCI_LS1021A = 0,
	AHCI_LS1028A = 1,
	AHCI_LS1043A = 2,
	AHCI_LS2080A = 3,
	AHCI_LS1046A = 4,
	AHCI_LS1088A = 5,
	AHCI_LS2088A = 6,
	AHCI_LX2160A = 7,
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum ale_fields {
	MINOR_VER = 0,
	MAJOR_VER = 1,
	ALE_ENTRIES = 2,
	ALE_POLICERS = 3,
	POL_PORT_MEN = 4,
	POL_TRUNK_ID = 5,
	POL_PORT_NUM = 6,
	POL_PRI_MEN = 7,
	POL_PRI_VAL = 8,
	POL_OUI_MEN = 9,
	POL_OUI_INDEX = 10,
	POL_DST_MEN = 11,
	POL_DST_INDEX = 12,
	POL_SRC_MEN = 13,
	POL_SRC_INDEX = 14,
	POL_OVLAN_MEN = 15,
	POL_OVLAN_INDEX = 16,
	POL_IVLAN_MEN = 17,
	POL_IVLAN_INDEX = 18,
	POL_ETHERTYPE_MEN = 19,
	POL_ETHERTYPE_INDEX = 20,
	POL_IPSRC_MEN = 21,
	POL_IPSRC_INDEX = 22,
	POL_IPDST_MEN = 23,
	POL_IPDST_INDEX = 24,
	POL_EN = 25,
	POL_RED_DROP_EN = 26,
	POL_YELLOW_DROP_EN = 27,
	POL_YELLOW_THRESH = 28,
	POL_POL_MATCH_MODE = 29,
	POL_PRIORITY_THREAD_EN = 30,
	POL_MAC_ONLY_DEF_DIS = 31,
	POL_TEST_CLR = 32,
	POL_TEST_CLR_RED = 33,
	POL_TEST_CLR_YELLOW = 34,
	POL_TEST_CLR_SELECTED = 35,
	POL_TEST_ENTRY = 36,
	POL_STATUS_HIT = 37,
	POL_STATUS_HIT_RED = 38,
	POL_STATUS_HIT_YELLOW = 39,
	ALE_DEFAULT_THREAD_EN = 40,
	ALE_DEFAULT_THREAD_VAL = 41,
	ALE_THREAD_CLASS_INDEX = 42,
	ALE_THREAD_ENABLE = 43,
	ALE_THREAD_VALUE = 44,
	ALE_FIELDS_MAX = 45,
};

enum altera_pcie_version {
	ALTERA_PCIE_V1 = 0,
	ALTERA_PCIE_V2 = 1,
	ALTERA_PCIE_V3 = 2,
};

enum am65_cpsw_tx_buf_type {
	AM65_CPSW_TX_BUF_TYPE_SKB = 0,
	AM65_CPSW_TX_BUF_TYPE_XDP_TX = 1,
	AM65_CPSW_TX_BUF_TYPE_XDP_NDO = 2,
};

enum aml_pinconf_drv {
	PINCONF_DRV_500UA = 0,
	PINCONF_DRV_2500UA = 1,
	PINCONF_DRV_3000UA = 2,
	PINCONF_DRV_4000UA = 3,
};

enum aqr_fw_src {
	AQR_FW_SRC_NVMEM = 0,
	AQR_FW_SRC_FS = 1,
};

enum aqr_rate_adaptation {
	AQR_RATE_ADAPT_NONE = 0,
	AQR_RATE_ADAPT_USX = 1,
	AQR_RATE_ADAPT_PAUSE = 2,
};

enum arch_timer_access {
	PHYS_ACCESS = 0,
	VIRT_ACCESS = 1,
};

enum arch_timer_erratum_match_type {
	ate_match_dt = 0,
	ate_match_local_cap_id = 1,
	ate_match_acpi_oem_info = 2,
};

enum arch_timer_ppi_nr {
	ARCH_TIMER_PHYS_SECURE_PPI = 0,
	ARCH_TIMER_PHYS_NONSECURE_PPI = 1,
	ARCH_TIMER_VIRT_PPI = 2,
	ARCH_TIMER_HYP_PPI = 3,
	ARCH_TIMER_HYP_VIRT_PPI = 4,
	ARCH_TIMER_MAX_TIMER_PPI = 5,
};

enum arch_timer_reg {
	ARCH_TIMER_REG_CTRL = 0,
	ARCH_TIMER_REG_CVAL = 1,
};

enum arm64_bp_harden_el1_vectors {
	EL1_VECTOR_BHB_LOOP = 0,
	EL1_VECTOR_BHB_FW = 1,
	EL1_VECTOR_BHB_CLEAR_INSN = 2,
	EL1_VECTOR_KPTI = 3,
};

enum arm64_hyp_spectre_vector {
	HYP_VECTOR_DIRECT = 0,
	HYP_VECTOR_SPECTRE_DIRECT = 1,
	HYP_VECTOR_INDIRECT = 2,
	HYP_VECTOR_SPECTRE_INDIRECT = 3,
};

enum arm_smccc_conduit {
	SMCCC_CONDUIT_NONE = 0,
	SMCCC_CONDUIT_SMC = 1,
	SMCCC_CONDUIT_HVC = 2,
};

enum arm_smmu_arch_version {
	ARM_SMMU_V1 = 0,
	ARM_SMMU_V1_64K = 1,
	ARM_SMMU_V2 = 2,
};

enum arm_smmu_cbar_type {
	CBAR_TYPE_S2_TRANS = 0,
	CBAR_TYPE_S1_TRANS_S2_BYPASS = 1,
	CBAR_TYPE_S1_TRANS_S2_FAULT = 2,
	CBAR_TYPE_S1_TRANS_S2_TRANS = 3,
};

enum arm_smmu_context_fmt {
	ARM_SMMU_CTX_FMT_NONE = 0,
	ARM_SMMU_CTX_FMT_AARCH64 = 1,
	ARM_SMMU_CTX_FMT_AARCH32_L = 2,
	ARM_SMMU_CTX_FMT_AARCH32_S = 3,
};

enum arm_smmu_domain_stage {
	ARM_SMMU_DOMAIN_S1 = 0,
	ARM_SMMU_DOMAIN_S2 = 1,
};

enum arm_smmu_domain_stage___2 {
	ARM_SMMU_DOMAIN_S1___2 = 0,
	ARM_SMMU_DOMAIN_S2___2 = 1,
	ARM_SMMU_DOMAIN_NESTED = 2,
};

enum arm_smmu_implementation {
	GENERIC_SMMU = 0,
	ARM_MMU500 = 1,
	CAVIUM_SMMUV2 = 2,
	QCOM_SMMUV2 = 3,
};

enum arm_smmu_msi_index {
	EVTQ_MSI_INDEX = 0,
	GERROR_MSI_INDEX = 1,
	PRIQ_MSI_INDEX = 2,
	ARM_SMMU_MAX_MSIS = 3,
};

enum arm_smmu_s2cr_privcfg {
	S2CR_PRIVCFG_DEFAULT = 0,
	S2CR_PRIVCFG_DIPAN = 1,
	S2CR_PRIVCFG_UNPRIV = 2,
	S2CR_PRIVCFG_PRIV = 3,
};

enum arm_smmu_s2cr_type {
	S2CR_TYPE_TRANS = 0,
	S2CR_TYPE_BYPASS = 1,
	S2CR_TYPE_FAULT = 2,
};

enum armpmu_attr_groups {
	ARMPMU_ATTR_GROUP_COMMON = 0,
	ARMPMU_ATTR_GROUP_EVENTS = 1,
	ARMPMU_ATTR_GROUP_FORMATS = 2,
	ARMPMU_ATTR_GROUP_CAPS = 3,
	ARMPMU_NR_ATTR_GROUPS = 4,
};

enum asn1_class {
	ASN1_UNIV = 0,
	ASN1_APPL = 1,
	ASN1_CONT = 2,
	ASN1_PRIV = 3,
};

enum asn1_method {
	ASN1_PRIM = 0,
	ASN1_CONS = 1,
};

enum asn1_opcode {
	ASN1_OP_MATCH = 0,
	ASN1_OP_MATCH_OR_SKIP = 1,
	ASN1_OP_MATCH_ACT = 2,
	ASN1_OP_MATCH_ACT_OR_SKIP = 3,
	ASN1_OP_MATCH_JUMP = 4,
	ASN1_OP_MATCH_JUMP_OR_SKIP = 5,
	ASN1_OP_MATCH_ANY = 8,
	ASN1_OP_MATCH_ANY_OR_SKIP = 9,
	ASN1_OP_MATCH_ANY_ACT = 10,
	ASN1_OP_MATCH_ANY_ACT_OR_SKIP = 11,
	ASN1_OP_COND_MATCH_OR_SKIP = 17,
	ASN1_OP_COND_MATCH_ACT_OR_SKIP = 19,
	ASN1_OP_COND_MATCH_JUMP_OR_SKIP = 21,
	ASN1_OP_COND_MATCH_ANY = 24,
	ASN1_OP_COND_MATCH_ANY_OR_SKIP = 25,
	ASN1_OP_COND_MATCH_ANY_ACT = 26,
	ASN1_OP_COND_MATCH_ANY_ACT_OR_SKIP = 27,
	ASN1_OP_COND_FAIL = 28,
	ASN1_OP_COMPLETE = 29,
	ASN1_OP_ACT = 30,
	ASN1_OP_MAYBE_ACT = 31,
	ASN1_OP_END_SEQ = 32,
	ASN1_OP_END_SET = 33,
	ASN1_OP_END_SEQ_OF = 34,
	ASN1_OP_END_SET_OF = 35,
	ASN1_OP_END_SEQ_ACT = 36,
	ASN1_OP_END_SET_ACT = 37,
	ASN1_OP_END_SEQ_OF_ACT = 38,
	ASN1_OP_END_SET_OF_ACT = 39,
	ASN1_OP_RETURN = 40,
	ASN1_OP__NR = 41,
};

enum asn1_tag {
	ASN1_EOC = 0,
	ASN1_BOOL = 1,
	ASN1_INT = 2,
	ASN1_BTS = 3,
	ASN1_OTS = 4,
	ASN1_NULL = 5,
	ASN1_OID = 6,
	ASN1_ODE = 7,
	ASN1_EXT = 8,
	ASN1_REAL = 9,
	ASN1_ENUM = 10,
	ASN1_EPDV = 11,
	ASN1_UTF8STR = 12,
	ASN1_RELOID = 13,
	ASN1_SEQ = 16,
	ASN1_SET = 17,
	ASN1_NUMSTR = 18,
	ASN1_PRNSTR = 19,
	ASN1_TEXSTR = 20,
	ASN1_VIDSTR = 21,
	ASN1_IA5STR = 22,
	ASN1_UNITIM = 23,
	ASN1_GENTIM = 24,
	ASN1_GRASTR = 25,
	ASN1_VISSTR = 26,
	ASN1_GENSTR = 27,
	ASN1_UNISTR = 28,
	ASN1_CHRSTR = 29,
	ASN1_BMPSTR = 30,
	ASN1_LONG_TAG = 31,
};

enum asp_netfilt_reg_type {
	ASP_NETFILT_MATCH = 0,
	ASP_NETFILT_MASK = 1,
	ASP_NETFILT_MAX = 2,
};

enum asp_rx_filter_id {
	ASP_RX_FILTER_MDA_PROMISC = 0,
	ASP_RX_FILTER_MDA_ALLMULTI = 1,
	ASP_RX_FILTER_MDA_BROADCAST = 2,
	ASP_RX_FILTER_MDA_OWN_ADDR = 3,
	ASP_RX_FILTER_MDA_RES_MAX = 4,
};

enum asp_rx_net_filter_block {
	ASP_RX_FILTER_NET_L2 = 0,
	ASP_RX_FILTER_NET_L3_0 = 1,
	ASP_RX_FILTER_NET_L3_1 = 2,
	ASP_RX_FILTER_NET_L4 = 3,
	ASP_RX_FILTER_NET_BLOCK_MAX = 4,
};

enum assoc_array_walk_status {
	assoc_array_walk_tree_empty = 0,
	assoc_array_walk_found_terminal_node = 1,
	assoc_array_walk_found_wrong_shortcut = 2,
};

enum asymmetric_payload_bits {
	asym_crypto = 0,
	asym_subtype = 1,
	asym_key_ids = 2,
	asym_auth = 3,
};

enum ata_completion_errors {
	AC_ERR_OK = 0,
	AC_ERR_DEV = 1,
	AC_ERR_HSM = 2,
	AC_ERR_TIMEOUT = 4,
	AC_ERR_MEDIA = 8,
	AC_ERR_ATA_BUS = 16,
	AC_ERR_HOST_BUS = 32,
	AC_ERR_SYSTEM = 64,
	AC_ERR_INVALID = 128,
	AC_ERR_OTHER = 256,
	AC_ERR_NODEV_HINT = 512,
	AC_ERR_NCQ = 1024,
};

enum ata_dev_iter_mode {
	ATA_DITER_ENABLED = 0,
	ATA_DITER_ENABLED_REVERSE = 1,
	ATA_DITER_ALL = 2,
	ATA_DITER_ALL_REVERSE = 3,
};

enum ata_link_iter_mode {
	ATA_LITER_EDGE = 0,
	ATA_LITER_HOST_FIRST = 1,
	ATA_LITER_PMP_FIRST = 2,
};

enum ata_lpm_hints {
	ATA_LPM_EMPTY = 1,
	ATA_LPM_HIPM = 2,
	ATA_LPM_WAKE_ONLY = 4,
};

enum ata_lpm_policy {
	ATA_LPM_UNKNOWN = 0,
	ATA_LPM_MAX_POWER = 1,
	ATA_LPM_MED_POWER = 2,
	ATA_LPM_MED_POWER_WITH_DIPM = 3,
	ATA_LPM_MIN_POWER_WITH_PARTIAL = 4,
	ATA_LPM_MIN_POWER = 5,
};

enum ata_prot_flags {
	ATA_PROT_FLAG_PIO = 1,
	ATA_PROT_FLAG_DMA = 2,
	ATA_PROT_FLAG_NCQ = 4,
	ATA_PROT_FLAG_ATAPI = 8,
	ATA_PROT_UNKNOWN = 255,
	ATA_PROT_NODATA = 0,
	ATA_PROT_PIO = 1,
	ATA_PROT_DMA = 2,
	ATA_PROT_NCQ_NODATA = 4,
	ATA_PROT_NCQ = 6,
	ATAPI_PROT_NODATA = 8,
	ATAPI_PROT_PIO = 9,
	ATAPI_PROT_DMA = 10,
};

enum ata_xfer_mask {
	ATA_MASK_PIO = 127,
	ATA_MASK_MWDMA = 3968,
	ATA_MASK_UDMA = 1044480,
};

enum attr_idn {
	QUERY_ATTR_IDN_BOOT_LU_EN = 0,
	QUERY_ATTR_IDN_MAX_HPB_SINGLE_CMD = 1,
	QUERY_ATTR_IDN_POWER_MODE = 2,
	QUERY_ATTR_IDN_ACTIVE_ICC_LVL = 3,
	QUERY_ATTR_IDN_OOO_DATA_EN = 4,
	QUERY_ATTR_IDN_BKOPS_STATUS = 5,
	QUERY_ATTR_IDN_PURGE_STATUS = 6,
	QUERY_ATTR_IDN_MAX_DATA_IN = 7,
	QUERY_ATTR_IDN_MAX_DATA_OUT = 8,
	QUERY_ATTR_IDN_DYN_CAP_NEEDED = 9,
	QUERY_ATTR_IDN_REF_CLK_FREQ = 10,
	QUERY_ATTR_IDN_CONF_DESC_LOCK = 11,
	QUERY_ATTR_IDN_MAX_NUM_OF_RTT = 12,
	QUERY_ATTR_IDN_EE_CONTROL = 13,
	QUERY_ATTR_IDN_EE_STATUS = 14,
	QUERY_ATTR_IDN_SECONDS_PASSED = 15,
	QUERY_ATTR_IDN_CNTX_CONF = 16,
	QUERY_ATTR_IDN_CORR_PRG_BLK_NUM = 17,
	QUERY_ATTR_IDN_RESERVED2 = 18,
	QUERY_ATTR_IDN_RESERVED3 = 19,
	QUERY_ATTR_IDN_FFU_STATUS = 20,
	QUERY_ATTR_IDN_PSA_STATE = 21,
	QUERY_ATTR_IDN_PSA_DATA_SIZE = 22,
	QUERY_ATTR_IDN_REF_CLK_GATING_WAIT_TIME = 23,
	QUERY_ATTR_IDN_CASE_ROUGH_TEMP = 24,
	QUERY_ATTR_IDN_HIGH_TEMP_BOUND = 25,
	QUERY_ATTR_IDN_LOW_TEMP_BOUND = 26,
	QUERY_ATTR_IDN_WB_FLUSH_STATUS = 28,
	QUERY_ATTR_IDN_AVAIL_WB_BUFF_SIZE = 29,
	QUERY_ATTR_IDN_WB_BUFF_LIFE_TIME_EST = 30,
	QUERY_ATTR_IDN_CURR_WB_BUFF_SIZE = 31,
	QUERY_ATTR_IDN_TIMESTAMP = 48,
	QUERY_ATTR_IDN_DEV_LVL_EXCEPTION_ID = 52,
	QUERY_ATTR_IDN_HID_DEFRAG_OPERATION = 53,
	QUERY_ATTR_IDN_HID_AVAILABLE_SIZE = 54,
	QUERY_ATTR_IDN_HID_SIZE = 55,
	QUERY_ATTR_IDN_HID_PROGRESS_RATIO = 56,
	QUERY_ATTR_IDN_HID_STATE = 57,
	QUERY_ATTR_IDN_WB_BUF_RESIZE_HINT = 60,
	QUERY_ATTR_IDN_WB_BUF_RESIZE_EN = 61,
	QUERY_ATTR_IDN_WB_BUF_RESIZE_STATUS = 62,
};

enum audit_nfcfgop {
	AUDIT_XT_OP_REGISTER = 0,
	AUDIT_XT_OP_REPLACE = 1,
	AUDIT_XT_OP_UNREGISTER = 2,
	AUDIT_NFT_OP_TABLE_REGISTER = 3,
	AUDIT_NFT_OP_TABLE_UNREGISTER = 4,
	AUDIT_NFT_OP_CHAIN_REGISTER = 5,
	AUDIT_NFT_OP_CHAIN_UNREGISTER = 6,
	AUDIT_NFT_OP_RULE_REGISTER = 7,
	AUDIT_NFT_OP_RULE_UNREGISTER = 8,
	AUDIT_NFT_OP_SET_REGISTER = 9,
	AUDIT_NFT_OP_SET_UNREGISTER = 10,
	AUDIT_NFT_OP_SETELEM_REGISTER = 11,
	AUDIT_NFT_OP_SETELEM_UNREGISTER = 12,
	AUDIT_NFT_OP_GEN_REGISTER = 13,
	AUDIT_NFT_OP_OBJ_REGISTER = 14,
	AUDIT_NFT_OP_OBJ_UNREGISTER = 15,
	AUDIT_NFT_OP_OBJ_RESET = 16,
	AUDIT_NFT_OP_FLOWTABLE_REGISTER = 17,
	AUDIT_NFT_OP_FLOWTABLE_UNREGISTER = 18,
	AUDIT_NFT_OP_SETELEM_RESET = 19,
	AUDIT_NFT_OP_RULE_RESET = 20,
	AUDIT_NFT_OP_INVALID = 21,
};

enum audit_nlgrps {
	AUDIT_NLGRP_NONE = 0,
	AUDIT_NLGRP_READLOG = 1,
	__AUDIT_NLGRP_MAX = 2,
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

enum audit_state {
	AUDIT_STATE_DISABLED = 0,
	AUDIT_STATE_BUILD = 1,
	AUDIT_STATE_RECORD = 2,
};

enum auditsc_class_t {
	AUDITSC_NATIVE = 0,
	AUDITSC_COMPAT = 1,
	AUDITSC_OPEN = 2,
	AUDITSC_OPENAT = 3,
	AUDITSC_SOCKETCALL = 4,
	AUDITSC_EXECVE = 5,
	AUDITSC_OPENAT2 = 6,
	AUDITSC_NVALS = 7,
};

enum autofs_notify {
	NFY_NONE = 0,
	NFY_MOUNT = 1,
	NFY_EXPIRE = 2,
};

enum axp20x_variants {
	AXP152_ID = 0,
	AXP192_ID = 1,
	AXP202_ID = 2,
	AXP209_ID = 3,
	AXP221_ID = 4,
	AXP223_ID = 5,
	AXP288_ID = 6,
	AXP313A_ID = 7,
	AXP323_ID = 8,
	AXP717_ID = 9,
	AXP803_ID = 10,
	AXP806_ID = 11,
	AXP809_ID = 12,
	AXP813_ID = 13,
	AXP15060_ID = 14,
	NR_AXP20X_VARIANTS = 15,
};

enum bam_command_type {
	BAM_WRITE_COMMAND = 0,
	BAM_READ_COMMAND = 1,
};

enum bam_reg {
	BAM_CTRL = 0,
	BAM_REVISION = 1,
	BAM_NUM_PIPES = 2,
	BAM_DESC_CNT_TRSHLD = 3,
	BAM_IRQ_SRCS = 4,
	BAM_IRQ_SRCS_MSK = 5,
	BAM_IRQ_SRCS_UNMASKED = 6,
	BAM_IRQ_STTS = 7,
	BAM_IRQ_CLR = 8,
	BAM_IRQ_EN = 9,
	BAM_CNFG_BITS = 10,
	BAM_IRQ_SRCS_EE = 11,
	BAM_IRQ_SRCS_MSK_EE = 12,
	BAM_P_CTRL = 13,
	BAM_P_RST = 14,
	BAM_P_HALT = 15,
	BAM_P_IRQ_STTS = 16,
	BAM_P_IRQ_CLR = 17,
	BAM_P_IRQ_EN = 18,
	BAM_P_EVNT_DEST_ADDR = 19,
	BAM_P_EVNT_REG = 20,
	BAM_P_SW_OFSTS = 21,
	BAM_P_DATA_FIFO_ADDR = 22,
	BAM_P_DESC_FIFO_ADDR = 23,
	BAM_P_EVNT_GEN_TRSHLD = 24,
	BAM_P_FIFO_SIZES = 25,
};

enum base_type {
	MSPI = 0,
	BSPI = 1,
	CHIP_SELECT = 2,
	BASEMAX = 3,
};

enum batadv_packettype {
	BATADV_IV_OGM = 0,
	BATADV_BCAST = 1,
	BATADV_CODED = 2,
	BATADV_ELP = 3,
	BATADV_OGM2 = 4,
	BATADV_MCAST = 5,
	BATADV_UNICAST = 64,
	BATADV_UNICAST_FRAG = 65,
	BATADV_UNICAST_4ADDR = 66,
	BATADV_ICMP = 67,
	BATADV_UNICAST_TVLV = 68,
};

enum bcm2835_fsel {
	BCM2835_FSEL_COUNT = 8,
	BCM2835_FSEL_MASK = 7,
};

enum bcm_iproc_i2c_type {
	IPROC_I2C = 0,
	IPROC_I2C_NIC = 1,
};

enum bcm_usb_phy_ctrl_bits {
	CORERDY = 0,
	PHY_RESETB = 1,
	PHY_PCTL = 2,
};

enum bcm_usb_phy_reg {
	PLL_CTRL = 0,
	PHY_CTRL = 1,
	PHY_PLL_CTRL = 2,
};

enum bcm_usb_phy_type {
	USB_HS_PHY = 0,
	USB_SS_PHY = 1,
};

enum bcm_usb_phy_version {
	BCM_SR_USB_COMBO_PHY = 0,
	BCM_SR_USB_HS_PHY = 1,
};

enum bcma_hosttype {
	BCMA_HOSTTYPE_PCI = 0,
	BCMA_HOSTTYPE_SDIO = 1,
	BCMA_HOSTTYPE_SOC = 2,
};

enum bcmasp_stat_type {
	BCMASP_STAT_RX_CTRL = 0,
	BCMASP_STAT_RX_CTRL_PER_INTF = 1,
	BCMASP_STAT_SOFT = 2,
};

enum bd9571mwv_regulators {
	VD09 = 0,
	VD18 = 1,
	VD25 = 2,
	VD33 = 3,
	DVFS = 4,
};

enum bdcr_cmd_class {
	BDCR_CMD_UNSPEC = 0,
	BDCR_CMD_MAC_FILTER = 1,
	BDCR_CMD_VLAN_FILTER = 2,
	BDCR_CMD_RSS = 3,
	BDCR_CMD_RFS = 4,
	BDCR_CMD_PORT_GCL = 5,
	BDCR_CMD_RECV_CLASSIFIER = 6,
	BDCR_CMD_STREAM_IDENTIFY = 7,
	BDCR_CMD_STREAM_FILTER = 8,
	BDCR_CMD_STREAM_GCL = 9,
	BDCR_CMD_FLOW_METER = 10,
	__BDCR_CMD_MAX_LEN = 11,
	BDCR_CMD_MAX_LEN = 10,
};

enum behavior {
	EXCLUSIVE = 0,
	SHARED = 1,
	DROP = 2,
};

enum bfqq_expiration {
	BFQQE_TOO_IDLE = 0,
	BFQQE_BUDGET_TIMEOUT = 1,
	BFQQE_BUDGET_EXHAUSTED = 2,
	BFQQE_NO_MORE_REQUESTS = 3,
	BFQQE_PREEMPTED = 4,
};

enum bfqq_state_flags {
	BFQQF_just_created = 0,
	BFQQF_busy = 1,
	BFQQF_wait_request = 2,
	BFQQF_non_blocking_wait_rq = 3,
	BFQQF_fifo_expire = 4,
	BFQQF_has_short_ttime = 5,
	BFQQF_sync = 6,
	BFQQF_IO_bound = 7,
	BFQQF_in_large_burst = 8,
	BFQQF_softrt_update = 9,
	BFQQF_coop = 10,
	BFQQF_split_coop = 11,
};

enum bgmac_dma_ring_type {
	BGMAC_DMA_RING_TX = 0,
	BGMAC_DMA_RING_RX = 1,
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_Migrate = 16,
	BH_PrivateStart = 17,
};

enum bhb_mitigation_bits {
	BHB_LOOP = 0,
	BHB_FW = 1,
	BHB_HW = 2,
	BHB_INSN = 3,
};

enum bio_merge_status {
	BIO_MERGE_OK = 0,
	BIO_MERGE_NONE = 1,
	BIO_MERGE_FAILED = 2,
};

enum bio_post_read_step {
	STEP_INITIAL = 0,
	STEP_DECRYPT = 1,
	STEP_VERITY = 2,
	STEP_MAX = 3,
};

enum bios_platform_class {
	BIOS_CLIENT = 0,
	BIOS_SERVER = 1,
};

enum bip_flags {
	BIP_BLOCK_INTEGRITY = 1,
	BIP_MAPPED_INTEGRITY = 2,
	BIP_DISK_NOCHECK = 4,
	BIP_IP_CHECKSUM = 8,
	BIP_COPY_USER = 16,
	BIP_CHECK_GUARD = 32,
	BIP_CHECK_REFTAG = 64,
	BIP_CHECK_APPTAG = 128,
	BIP_P2P_DMA = 256,
};

enum bkops_status {
	BKOPS_STATUS_NO_OP = 0,
	BKOPS_STATUS_NON_CRITICAL = 1,
	BKOPS_STATUS_PERF_IMPACT = 2,
	BKOPS_STATUS_CRITICAL = 3,
	BKOPS_STATUS_MAX = 3,
};

enum blacklist_hash_type {
	BLACKLIST_HASH_X509_TBS = 1,
	BLACKLIST_HASH_BINARY = 2,
};

enum blake2s_iv {
	BLAKE2S_IV0 = 1779033703,
	BLAKE2S_IV1 = 3144134277,
	BLAKE2S_IV2 = 1013904242,
	BLAKE2S_IV3 = 2773480762,
	BLAKE2S_IV4 = 1359893119,
	BLAKE2S_IV5 = 2600822924,
	BLAKE2S_IV6 = 528734635,
	BLAKE2S_IV7 = 1541459225,
};

enum blake2s_lengths {
	BLAKE2S_BLOCK_SIZE = 64,
	BLAKE2S_HASH_SIZE = 32,
	BLAKE2S_KEY_SIZE = 32,
	BLAKE2S_128_HASH_SIZE = 16,
	BLAKE2S_160_HASH_SIZE = 20,
	BLAKE2S_224_HASH_SIZE = 28,
	BLAKE2S_256_HASH_SIZE = 32,
};

enum blk_crypto_key_type {
	BLK_CRYPTO_KEY_TYPE_RAW = 1,
	BLK_CRYPTO_KEY_TYPE_HW_WRAPPED = 2,
};

enum blk_crypto_mode_num {
	BLK_ENCRYPTION_MODE_INVALID = 0,
	BLK_ENCRYPTION_MODE_AES_256_XTS = 1,
	BLK_ENCRYPTION_MODE_AES_128_CBC_ESSIV = 2,
	BLK_ENCRYPTION_MODE_ADIANTUM = 3,
	BLK_ENCRYPTION_MODE_SM4_XTS = 4,
	BLK_ENCRYPTION_MODE_MAX = 5,
};

enum blk_default_limits {
	BLK_MAX_SEGMENTS = 128,
	BLK_SAFE_MAX_SECTORS = 255,
	BLK_MAX_SEGMENT_SIZE = 65536,
	BLK_SEG_BOUNDARY_MASK = 4294967295,
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

enum blk_integrity_checksum {
	BLK_INTEGRITY_CSUM_NONE = 0,
	BLK_INTEGRITY_CSUM_IP = 1,
	BLK_INTEGRITY_CSUM_CRC = 2,
	BLK_INTEGRITY_CSUM_CRC64 = 3,
} __attribute__((mode(byte)));

enum blk_integrity_flags {
	BLK_INTEGRITY_NOVERIFY = 1,
	BLK_INTEGRITY_NOGENERATE = 2,
	BLK_INTEGRITY_DEVICE_CAPABLE = 4,
	BLK_INTEGRITY_REF_TAG = 8,
	BLK_INTEGRITY_STACKED = 16,
};

enum blk_req_status {
	REQ_PROCESSING = 0,
	REQ_WAITING = 1,
	REQ_DONE = 2,
	REQ_ERROR = 3,
	REQ_EOPNOTSUPP = 4,
};

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

enum blkg_iostat_type {
	BLKG_IOSTAT_READ = 0,
	BLKG_IOSTAT_WRITE = 1,
	BLKG_IOSTAT_DISCARD = 2,
	BLKG_IOSTAT_NR = 3,
};

enum blkg_rwstat_type {
	BLKG_RWSTAT_READ = 0,
	BLKG_RWSTAT_WRITE = 1,
	BLKG_RWSTAT_SYNC = 2,
	BLKG_RWSTAT_ASYNC = 3,
	BLKG_RWSTAT_DISCARD = 4,
	BLKG_RWSTAT_NR = 5,
	BLKG_RWSTAT_TOTAL = 5,
};

enum blkif_state {
	BLKIF_STATE_DISCONNECTED = 0,
	BLKIF_STATE_CONNECTED = 1,
	BLKIF_STATE_SUSPENDED = 2,
	BLKIF_STATE_ERROR = 3,
};

enum bm_rcr_cmode {
	bm_rcr_cci = 0,
	bm_rcr_cce = 1,
};

enum bm_rcr_pmode {
	bm_rcr_pci = 0,
	bm_rcr_pce = 1,
	bm_rcr_pvb = 2,
};

enum board_ids {
	board_ahci = 0,
	board_ahci_43bit_dma = 1,
	board_ahci_ign_iferr = 2,
	board_ahci_no_debounce_delay = 3,
	board_ahci_no_msi = 4,
	board_ahci_pcs_quirk = 5,
	board_ahci_pcs_quirk_no_devslp = 6,
	board_ahci_pcs_quirk_no_sntf = 7,
	board_ahci_yes_fbs = 8,
	board_ahci_yes_fbs_atapi_dma = 9,
	board_ahci_al = 10,
	board_ahci_avn = 11,
	board_ahci_mcp65 = 12,
	board_ahci_mcp77 = 13,
	board_ahci_mcp89 = 14,
	board_ahci_mv = 15,
	board_ahci_sb600 = 16,
	board_ahci_sb700 = 17,
	board_ahci_vt8251 = 18,
	board_ahci_mcp_linux = 12,
	board_ahci_mcp67 = 12,
	board_ahci_mcp73 = 12,
	board_ahci_mcp79 = 13,
};

enum bp_state {
	BP_DONE = 0,
	BP_WAIT = 1,
	BP_EAGAIN = 2,
	BP_ECANCELED = 3,
};

enum bp_type_idx {
	TYPE_INST = 0,
	TYPE_DATA = 1,
	TYPE_MAX = 2,
};

enum bpf_access_src {
	ACCESS_DIRECT = 1,
	ACCESS_HELPER = 2,
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

enum bpf_addr_space_cast {
	BPF_ADDR_SPACE_CAST = 1,
};

enum bpf_adj_room_mode {
	BPF_ADJ_ROOM_NET = 0,
	BPF_ADJ_ROOM_MAC = 1,
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_PTR_TO_ARENA = 5,
	ARG_CONST_SIZE = 6,
	ARG_CONST_SIZE_OR_ZERO = 7,
	ARG_PTR_TO_CTX = 8,
	ARG_ANYTHING = 9,
	ARG_PTR_TO_SPIN_LOCK = 10,
	ARG_PTR_TO_SOCK_COMMON = 11,
	ARG_PTR_TO_SOCKET = 12,
	ARG_PTR_TO_BTF_ID = 13,
	ARG_PTR_TO_RINGBUF_MEM = 14,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 15,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 16,
	ARG_PTR_TO_PERCPU_BTF_ID = 17,
	ARG_PTR_TO_FUNC = 18,
	ARG_PTR_TO_STACK = 19,
	ARG_PTR_TO_CONST_STR = 20,
	ARG_PTR_TO_TIMER = 21,
	ARG_KPTR_XCHG_DEST = 22,
	ARG_PTR_TO_DYNPTR = 23,
	__BPF_ARG_TYPE_MAX = 24,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 264,
	ARG_PTR_TO_SOCKET_OR_NULL = 268,
	ARG_PTR_TO_STACK_OR_NULL = 275,
	ARG_PTR_TO_BTF_ID_OR_NULL = 269,
	ARG_PTR_TO_UNINIT_MEM = 67141636,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 268435455,
};

enum bpf_async_type {
	BPF_ASYNC_TYPE_TIMER = 0,
	BPF_ASYNC_TYPE_WQ = 1,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	BPF_CGROUP_UNIX_CONNECT = 49,
	BPF_CGROUP_UNIX_SENDMSG = 50,
	BPF_CGROUP_UNIX_RECVMSG = 51,
	BPF_CGROUP_UNIX_GETPEERNAME = 52,
	BPF_CGROUP_UNIX_GETSOCKNAME = 53,
	BPF_NETKIT_PRIMARY = 54,
	BPF_NETKIT_PEER = 55,
	BPF_TRACE_KPROBE_SESSION = 56,
	BPF_TRACE_UPROBE_SESSION = 57,
	__MAX_BPF_ATTACH_TYPE = 58,
};

enum bpf_audit {
	BPF_AUDIT_LOAD = 0,
	BPF_AUDIT_UNLOAD = 1,
	BPF_AUDIT_MAX = 2,
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

enum bpf_cgroup_storage_type {
	BPF_CGROUP_STORAGE_SHARED = 0,
	BPF_CGROUP_STORAGE_PERCPU = 1,
	__BPF_CGROUP_STORAGE_MAX = 2,
};

enum bpf_check_mtu_flags {
	BPF_MTU_CHK_SEGS = 1,
};

enum bpf_check_mtu_ret {
	BPF_MTU_CHK_RET_SUCCESS = 0,
	BPF_MTU_CHK_RET_FRAG_NEEDED = 1,
	BPF_MTU_CHK_RET_SEGS_TOOBIG = 2,
};

enum bpf_cmd {
	BPF_MAP_CREATE = 0,
	BPF_MAP_LOOKUP_ELEM = 1,
	BPF_MAP_UPDATE_ELEM = 2,
	BPF_MAP_DELETE_ELEM = 3,
	BPF_MAP_GET_NEXT_KEY = 4,
	BPF_PROG_LOAD = 5,
	BPF_OBJ_PIN = 6,
	BPF_OBJ_GET = 7,
	BPF_PROG_ATTACH = 8,
	BPF_PROG_DETACH = 9,
	BPF_PROG_TEST_RUN = 10,
	BPF_PROG_RUN = 10,
	BPF_PROG_GET_NEXT_ID = 11,
	BPF_MAP_GET_NEXT_ID = 12,
	BPF_PROG_GET_FD_BY_ID = 13,
	BPF_MAP_GET_FD_BY_ID = 14,
	BPF_OBJ_GET_INFO_BY_FD = 15,
	BPF_PROG_QUERY = 16,
	BPF_RAW_TRACEPOINT_OPEN = 17,
	BPF_BTF_LOAD = 18,
	BPF_BTF_GET_FD_BY_ID = 19,
	BPF_TASK_FD_QUERY = 20,
	BPF_MAP_LOOKUP_AND_DELETE_ELEM = 21,
	BPF_MAP_FREEZE = 22,
	BPF_BTF_GET_NEXT_ID = 23,
	BPF_MAP_LOOKUP_BATCH = 24,
	BPF_MAP_LOOKUP_AND_DELETE_BATCH = 25,
	BPF_MAP_UPDATE_BATCH = 26,
	BPF_MAP_DELETE_BATCH = 27,
	BPF_LINK_CREATE = 28,
	BPF_LINK_UPDATE = 29,
	BPF_LINK_GET_FD_BY_ID = 30,
	BPF_LINK_GET_NEXT_ID = 31,
	BPF_ENABLE_STATS = 32,
	BPF_ITER_CREATE = 33,
	BPF_LINK_DETACH = 34,
	BPF_PROG_BIND_MAP = 35,
	BPF_TOKEN_CREATE = 36,
	BPF_PROG_STREAM_READ_BY_FD = 37,
	__MAX_BPF_CMD = 38,
};

enum bpf_cond_pseudo_jmp {
	BPF_MAY_GOTO = 0,
};

enum bpf_core_relo_kind {
	BPF_CORE_FIELD_BYTE_OFFSET = 0,
	BPF_CORE_FIELD_BYTE_SIZE = 1,
	BPF_CORE_FIELD_EXISTS = 2,
	BPF_CORE_FIELD_SIGNED = 3,
	BPF_CORE_FIELD_LSHIFT_U64 = 4,
	BPF_CORE_FIELD_RSHIFT_U64 = 5,
	BPF_CORE_TYPE_ID_LOCAL = 6,
	BPF_CORE_TYPE_ID_TARGET = 7,
	BPF_CORE_TYPE_EXISTS = 8,
	BPF_CORE_TYPE_SIZE = 9,
	BPF_CORE_ENUMVAL_EXISTS = 10,
	BPF_CORE_ENUMVAL_VALUE = 11,
	BPF_CORE_TYPE_MATCHES = 12,
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
	BPF_DYNPTR_TYPE_SKB_META = 5,
};

enum bpf_features {
	BPF_FEAT_RDONLY_CAST_TO_VOID = 0,
	BPF_FEAT_STREAMS = 1,
	__MAX_BPF_FEAT = 2,
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

enum bpf_hdr_start_off {
	BPF_HDR_START_MAC = 0,
	BPF_HDR_START_NET = 1,
};

enum bpf_iter_feature {
	BPF_ITER_RESCHED = 1,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

enum bpf_jit_poke_reason {
	BPF_POKE_REASON_TAIL_CALL = 0,
};

enum bpf_kfunc_flags {
	BPF_F_PAD_ZEROS = 1,
};

enum bpf_link_type {
	BPF_LINK_TYPE_UNSPEC = 0,
	BPF_LINK_TYPE_RAW_TRACEPOINT = 1,
	BPF_LINK_TYPE_TRACING = 2,
	BPF_LINK_TYPE_CGROUP = 3,
	BPF_LINK_TYPE_ITER = 4,
	BPF_LINK_TYPE_NETNS = 5,
	BPF_LINK_TYPE_XDP = 6,
	BPF_LINK_TYPE_PERF_EVENT = 7,
	BPF_LINK_TYPE_KPROBE_MULTI = 8,
	BPF_LINK_TYPE_STRUCT_OPS = 9,
	BPF_LINK_TYPE_NETFILTER = 10,
	BPF_LINK_TYPE_TCX = 11,
	BPF_LINK_TYPE_UPROBE_MULTI = 12,
	BPF_LINK_TYPE_NETKIT = 13,
	BPF_LINK_TYPE_SOCKMAP = 14,
	__MAX_BPF_LINK_TYPE = 15,
};

enum bpf_lru_list_type {
	BPF_LRU_LIST_T_ACTIVE = 0,
	BPF_LRU_LIST_T_INACTIVE = 1,
	BPF_LRU_LIST_T_FREE = 2,
	BPF_LRU_LOCAL_LIST_T_FREE = 3,
	BPF_LRU_LOCAL_LIST_T_PENDING = 4,
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE_DEPRECATED = 21,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
	BPF_MAP_TYPE_ARENA = 33,
	__MAX_BPF_MAP_TYPE = 34,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

enum bpf_perf_event_type {
	BPF_PERF_EVENT_UNSPEC = 0,
	BPF_PERF_EVENT_UPROBE = 1,
	BPF_PERF_EVENT_URETPROBE = 2,
	BPF_PERF_EVENT_KPROBE = 3,
	BPF_PERF_EVENT_KRETPROBE = 4,
	BPF_PERF_EVENT_TRACEPOINT = 5,
	BPF_PERF_EVENT_EVENT = 6,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
	__MAX_BPF_PROG_TYPE = 33,
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_ARENA = 18,
	PTR_TO_BUF = 19,
	PTR_TO_FUNC = 20,
	CONST_PTR_TO_DYNPTR = 21,
	__BPF_REG_TYPE_MAX = 22,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 268435455,
};

enum bpf_ret_code {
	BPF_OK = 0,
	BPF_DROP = 2,
	BPF_REDIRECT = 7,
	BPF_LWT_REROUTE = 128,
	BPF_FLOW_DISSECTOR_CONTINUE = 129,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 268435455,
};

enum bpf_stack_build_id_status {
	BPF_STACK_BUILD_ID_EMPTY = 0,
	BPF_STACK_BUILD_ID_VALID = 1,
	BPF_STACK_BUILD_ID_IP = 2,
};

enum bpf_stack_slot_type {
	STACK_INVALID = 0,
	STACK_SPILL = 1,
	STACK_MISC = 2,
	STACK_ZERO = 3,
	STACK_DYNPTR = 4,
	STACK_ITER = 5,
	STACK_IRQ_FLAG = 6,
};

enum bpf_stats_type {
	BPF_STATS_RUN_TIME = 0,
};

enum bpf_stream_id {
	BPF_STDOUT = 1,
	BPF_STDERR = 2,
};

enum bpf_struct_ops_state {
	BPF_STRUCT_OPS_STATE_INIT = 0,
	BPF_STRUCT_OPS_STATE_INUSE = 1,
	BPF_STRUCT_OPS_STATE_TOBEFREE = 2,
	BPF_STRUCT_OPS_STATE_READY = 3,
};

enum bpf_struct_walk_result {
	WALK_SCALAR = 0,
	WALK_PTR = 1,
	WALK_PTR_UNTRUSTED = 2,
	WALK_STRUCT = 3,
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

enum bpf_task_vma_iter_find_op {
	task_vma_iter_first_vma = 0,
	task_vma_iter_next_vma = 1,
	task_vma_iter_find_vma = 2,
};

enum bpf_task_work_state {
	BPF_TW_STANDBY = 0,
	BPF_TW_PENDING = 1,
	BPF_TW_SCHEDULING = 2,
	BPF_TW_SCHEDULED = 3,
	BPF_TW_RUNNING = 4,
	BPF_TW_FREED = 5,
};

enum bpf_text_poke_type {
	BPF_MOD_CALL = 0,
	BPF_MOD_JUMP = 1,
};

enum bpf_tramp_prog_type {
	BPF_TRAMP_FENTRY = 0,
	BPF_TRAMP_FEXIT = 1,
	BPF_TRAMP_MODIFY_RETURN = 2,
	BPF_TRAMP_MAX = 3,
	BPF_TRAMP_REPLACE = 4,
};

enum bpf_type {
	BPF_TYPE_UNSPEC = 0,
	BPF_TYPE_PROG = 1,
	BPF_TYPE_MAP = 2,
	BPF_TYPE_LINK = 3,
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	MEM_ALIGNED = 33554432,
	MEM_WRITE = 67108864,
	DYNPTR_TYPE_SKB_META = 134217728,
	__BPF_TYPE_FLAG_MAX = 134217729,
	__BPF_TYPE_LAST_FLAG = 134217728,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

enum brcm_family_type {
	BRCM_FAMILY_3390A0 = 0,
	BRCM_FAMILY_4908 = 1,
	BRCM_FAMILY_7250B0 = 2,
	BRCM_FAMILY_7271A0 = 3,
	BRCM_FAMILY_7364A0 = 4,
	BRCM_FAMILY_7366C0 = 5,
	BRCM_FAMILY_74371A0 = 6,
	BRCM_FAMILY_7439B0 = 7,
	BRCM_FAMILY_7445D0 = 8,
	BRCM_FAMILY_7260A0 = 9,
	BRCM_FAMILY_7278A0 = 10,
	BRCM_FAMILY_COUNT = 11,
};

enum brcm_sata_phy_rxaeq_mode {
	RXAEQ_MODE_OFF = 0,
	RXAEQ_MODE_AUTO = 1,
	RXAEQ_MODE_MANUAL = 2,
};

enum brcm_sata_phy_version {
	BRCM_SATA_PHY_STB_16NM = 0,
	BRCM_SATA_PHY_STB_28NM = 1,
	BRCM_SATA_PHY_STB_40NM = 2,
	BRCM_SATA_PHY_IPROC_NS2 = 3,
	BRCM_SATA_PHY_IPROC_NSP = 4,
	BRCM_SATA_PHY_IPROC_SR = 5,
	BRCM_SATA_PHY_DSL_28NM = 6,
};

enum brcm_usb_phy_id {
	BRCM_USB_PHY_2_0 = 0,
	BRCM_USB_PHY_3_0 = 1,
	BRCM_USB_PHY_ID_MAX = 2,
};

enum brcmusb_reg_sel {
	BRCM_REGS_CTRL = 0,
	BRCM_REGS_XHCI_EC = 1,
	BRCM_REGS_XHCI_GBL = 2,
	BRCM_REGS_USB_PHY = 3,
	BRCM_REGS_USB_MDIO = 4,
	BRCM_REGS_BDC_EC = 5,
	BRCM_REGS_MAX = 6,
};

enum bsc_xfer_cmd {
	CMD_WR = 0,
	CMD_RD = 1,
	CMD_WR_NOACK = 2,
	CMD_RD_NOACK = 3,
};

enum btf_arg_tag {
	ARG_TAG_CTX = 1,
	ARG_TAG_NONNULL = 2,
	ARG_TAG_TRUSTED = 4,
	ARG_TAG_UNTRUSTED = 8,
	ARG_TAG_NULLABLE = 16,
	ARG_TAG_ARENA = 32,
};

enum btf_field_iter_kind {
	BTF_FIELD_ITER_IDS = 0,
	BTF_FIELD_ITER_STRS = 1,
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR_PERCPU = 16,
	BPF_KPTR = 28,
	BPF_LIST_HEAD = 32,
	BPF_LIST_NODE = 64,
	BPF_RB_ROOT = 128,
	BPF_RB_NODE = 256,
	BPF_GRAPH_NODE = 320,
	BPF_GRAPH_ROOT = 160,
	BPF_REFCOUNT = 512,
	BPF_WORKQUEUE = 1024,
	BPF_UPTR = 2048,
	BPF_RES_SPIN_LOCK = 4096,
	BPF_TASK_WORK = 8192,
};

enum btf_func_linkage {
	BTF_FUNC_STATIC = 0,
	BTF_FUNC_GLOBAL = 1,
	BTF_FUNC_EXTERN = 2,
};

enum btf_kfunc_hook {
	BTF_KFUNC_HOOK_COMMON = 0,
	BTF_KFUNC_HOOK_XDP = 1,
	BTF_KFUNC_HOOK_TC = 2,
	BTF_KFUNC_HOOK_STRUCT_OPS = 3,
	BTF_KFUNC_HOOK_TRACING = 4,
	BTF_KFUNC_HOOK_SYSCALL = 5,
	BTF_KFUNC_HOOK_FMODRET = 6,
	BTF_KFUNC_HOOK_CGROUP = 7,
	BTF_KFUNC_HOOK_SCHED_ACT = 8,
	BTF_KFUNC_HOOK_SK_SKB = 9,
	BTF_KFUNC_HOOK_SOCKET_FILTER = 10,
	BTF_KFUNC_HOOK_LWT = 11,
	BTF_KFUNC_HOOK_NETFILTER = 12,
	BTF_KFUNC_HOOK_KPROBE = 13,
	BTF_KFUNC_HOOK_MAX = 14,
};

enum buf_type {
	TYPE_NETSEC_SKB = 0,
	TYPE_NETSEC_XDP_TX = 1,
	TYPE_NETSEC_XDP_NDO = 2,
};

enum bug_trap_type {
	BUG_TRAP_TYPE_NONE = 0,
	BUG_TRAP_TYPE_WARN = 1,
	BUG_TRAP_TYPE_BUG = 2,
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

enum cache_indexing {
	NODE_CACHE_DIRECT_MAP = 0,
	NODE_CACHE_INDEXED = 1,
	NODE_CACHE_OTHER = 2,
};

enum cache_mode {
	NODE_CACHE_ADDR_MODE_RESERVED = 0,
	NODE_CACHE_ADDR_MODE_EXTENDED_LINEAR = 1,
};

enum cache_type {
	CACHE_TYPE_NOCACHE = 0,
	CACHE_TYPE_INST = 1,
	CACHE_TYPE_DATA = 2,
	CACHE_TYPE_SEPARATE = 3,
	CACHE_TYPE_UNIFIED = 4,
};

enum cache_write_policy {
	NODE_CACHE_WRITE_BACK = 0,
	NODE_CACHE_WRITE_THROUGH = 1,
	NODE_CACHE_WRITE_OTHER = 2,
};

enum cavium_mdiobus_mode {
	UNINIT = 0,
	C22 = 1,
	C45 = 2,
};

enum cc_attr {
	CC_ATTR_MEM_ENCRYPT = 0,
	CC_ATTR_HOST_MEM_ENCRYPT = 1,
	CC_ATTR_GUEST_MEM_ENCRYPT = 2,
	CC_ATTR_GUEST_STATE_ENCRYPT = 3,
	CC_ATTR_GUEST_UNROLL_STRING_IO = 4,
	CC_ATTR_GUEST_SEV_SNP = 5,
	CC_ATTR_GUEST_SNP_SECURE_TSC = 6,
	CC_ATTR_HOST_SEV_SNP = 7,
	CC_ATTR_SNP_SECURE_AVIC = 8,
};

enum cfi_quirks {
	CFI_QUIRK_DQ_TRUE_DATA = 1,
};

enum cgroup1_param {
	Opt_all = 0,
	Opt_clone_children = 1,
	Opt_cpuset_v2_mode = 2,
	Opt_name = 3,
	Opt_none = 4,
	Opt_noprefix = 5,
	Opt_release_agent = 6,
	Opt_xattr = 7,
	Opt_favordynmods = 8,
	Opt_nofavordynmods = 9,
};

enum cgroup2_param {
	Opt_nsdelegate = 0,
	Opt_favordynmods___2 = 1,
	Opt_memory_localevents = 2,
	Opt_memory_recursiveprot = 3,
	Opt_memory_hugetlb_accounting = 4,
	Opt_pids_localevents = 5,
	nr__cgroup2_params = 6,
};

enum cgroup_attach_lock_mode {
	CGRP_ATTACH_LOCK_GLOBAL = 0,
	CGRP_ATTACH_LOCK_NONE = 1,
	CGRP_ATTACH_LOCK_PER_THREADGROUP = 2,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_UNIX_CONNECT = 9,
	CGROUP_INET4_POST_BIND = 10,
	CGROUP_INET6_POST_BIND = 11,
	CGROUP_UDP4_SENDMSG = 12,
	CGROUP_UDP6_SENDMSG = 13,
	CGROUP_UNIX_SENDMSG = 14,
	CGROUP_SYSCTL = 15,
	CGROUP_UDP4_RECVMSG = 16,
	CGROUP_UDP6_RECVMSG = 17,
	CGROUP_UNIX_RECVMSG = 18,
	CGROUP_GETSOCKOPT = 19,
	CGROUP_SETSOCKOPT = 20,
	CGROUP_INET4_GETPEERNAME = 21,
	CGROUP_INET6_GETPEERNAME = 22,
	CGROUP_UNIX_GETPEERNAME = 23,
	CGROUP_INET4_GETSOCKNAME = 24,
	CGROUP_INET6_GETSOCKNAME = 25,
	CGROUP_UNIX_GETSOCKNAME = 26,
	CGROUP_INET_SOCK_RELEASE = 27,
	CGROUP_LSM_START = 28,
	CGROUP_LSM_END = 27,
	MAX_CGROUP_BPF_ATTACH_TYPE = 28,
};

enum cgroup_filetype {
	CGROUP_FILE_PROCS = 0,
	CGROUP_FILE_TASKS = 1,
};

enum cgroup_lifetime_events {
	CGROUP_LIFETIME_ONLINE = 0,
	CGROUP_LIFETIME_OFFLINE = 1,
};

enum cgroup_opt_features {
	OPT_FEATURE_COUNT = 0,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	perf_event_cgrp_id = 7,
	hugetlb_cgrp_id = 8,
	pids_cgrp_id = 9,
	CGROUP_SUBSYS_COUNT = 10,
};

enum cgt_group_id {
	__RESERVED__ = 0,
	CGT_HCR_TID1 = 1,
	CGT_HCR_TID2 = 2,
	CGT_HCR_TID3 = 3,
	CGT_HCR_IMO = 4,
	CGT_HCR_FMO = 5,
	CGT_HCR_TIDCP = 6,
	CGT_HCR_TACR = 7,
	CGT_HCR_TSW = 8,
	CGT_HCR_TPC = 9,
	CGT_HCR_TPU = 10,
	CGT_HCR_TTLB = 11,
	CGT_HCR_TVM = 12,
	CGT_HCR_TDZ = 13,
	CGT_HCR_TRVM = 14,
	CGT_HCR_TLOR = 15,
	CGT_HCR_TERR = 16,
	CGT_HCR_APK = 17,
	CGT_HCR_NV = 18,
	CGT_HCR_NV_nNV2 = 19,
	CGT_HCR_NV1_nNV2 = 20,
	CGT_HCR_AT = 21,
	CGT_HCR_nFIEN = 22,
	CGT_HCR_TID4 = 23,
	CGT_HCR_TICAB = 24,
	CGT_HCR_TOCU = 25,
	CGT_HCR_ENSCXT = 26,
	CGT_HCR_TTLBIS = 27,
	CGT_HCR_TTLBOS = 28,
	CGT_MDCR_TPMCR = 29,
	CGT_MDCR_TPM = 30,
	CGT_MDCR_TDE = 31,
	CGT_MDCR_TDA = 32,
	CGT_MDCR_TDOSA = 33,
	CGT_MDCR_TDRA = 34,
	CGT_MDCR_E2PB = 35,
	CGT_MDCR_TPMS = 36,
	CGT_MDCR_TTRF = 37,
	CGT_MDCR_E2TB = 38,
	CGT_MDCR_TDCC = 39,
	CGT_CPTR_TAM = 40,
	CGT_CPTR_TCPAC = 41,
	CGT_HCRX_EnFPM = 42,
	CGT_HCRX_TCR2En = 43,
	CGT_HCRX_SCTLR2En = 44,
	CGT_CNTHCTL_EL1TVT = 45,
	CGT_CNTHCTL_EL1TVCT = 46,
	CGT_ICH_HCR_TC = 47,
	CGT_ICH_HCR_TALL0 = 48,
	CGT_ICH_HCR_TALL1 = 49,
	CGT_ICH_HCR_TDIR = 50,
	__MULTIPLE_CONTROL_BITS__ = 51,
	CGT_HCR_IMO_FMO_ICH_HCR_TC = 51,
	CGT_HCR_TID2_TID4 = 52,
	CGT_HCR_TTLB_TTLBIS = 53,
	CGT_HCR_TTLB_TTLBOS = 54,
	CGT_HCR_TVM_TRVM = 55,
	CGT_HCR_TVM_TRVM_HCRX_TCR2En = 56,
	CGT_HCR_TVM_TRVM_HCRX_SCTLR2En = 57,
	CGT_HCR_TPU_TICAB = 58,
	CGT_HCR_TPU_TOCU = 59,
	CGT_HCR_NV1_nNV2_ENSCXT = 60,
	CGT_MDCR_TPM_TPMCR = 61,
	CGT_MDCR_TPM_HPMN = 62,
	CGT_MDCR_TDE_TDA = 63,
	CGT_MDCR_TDE_TDOSA = 64,
	CGT_MDCR_TDE_TDRA = 65,
	CGT_MDCR_TDCC_TDE_TDA = 66,
	CGT_ICH_HCR_TC_TDIR = 67,
	__COMPLEX_CONDITIONS__ = 68,
	CGT_CNTHCTL_EL1PCTEN = 68,
	CGT_CNTHCTL_EL1PTEN = 69,
	CGT_CNTHCTL_EL1NVPCT = 70,
	CGT_CNTHCTL_EL1NVVCT = 71,
	CGT_CPTR_TTA = 72,
	CGT_MDCR_HPMN = 73,
	__NR_CGT_GROUP_IDS__ = 74,
};

enum ch_command {
	HIDMA_CH_DISABLE = 0,
	HIDMA_CH_ENABLE = 1,
	HIDMA_CH_SUSPEND = 2,
	HIDMA_CH_RESET = 9,
};

enum ch_state {
	HIDMA_CH_DISABLED = 0,
	HIDMA_CH_ENABLED = 1,
	HIDMA_CH_RUNNING = 2,
	HIDMA_CH_SUSPENDED = 3,
	HIDMA_CH_STOPPED = 4,
};

enum chacha_constants {
	CHACHA_CONSTANT_EXPA = 1634760805,
	CHACHA_CONSTANT_ND_3 = 857760878,
	CHACHA_CONSTANT_2_BY = 2036477234,
	CHACHA_CONSTANT_TE_K = 1797285236,
};

enum chip_id {
	MT6323_CHIP_ID = 35,
	MT6328_CHIP_ID = 48,
	MT6331_CHIP_ID = 32,
	MT6332_CHIP_ID = 32,
	MT6357_CHIP_ID = 87,
	MT6358_CHIP_ID = 88,
	MT6359_CHIP_ID = 89,
	MT6366_CHIP_ID = 102,
	MT6391_CHIP_ID = 145,
	MT6397_CHIP_ID = 151,
};

enum chips {
	PFUZE100 = 0,
	PFUZE200 = 1,
	PFUZE3000 = 3,
	PFUZE3001 = 49,
};

enum cix_mbox_chan_type {
	CIX_MBOX_TYPE_DB = 0,
	CIX_MBOX_TYPE_REG = 1,
	CIX_MBOX_TYPE_FIFO = 2,
	CIX_MBOX_TYPE_FAST = 3,
};

enum clear_refs_types {
	CLEAR_REFS_ALL = 1,
	CLEAR_REFS_ANON = 2,
	CLEAR_REFS_MAPPED = 3,
	CLEAR_REFS_SOFT_DIRTY = 4,
	CLEAR_REFS_MM_HIWATER_RSS = 5,
	CLEAR_REFS_LAST = 6,
};

enum clk_gating_state {
	CLKS_OFF = 0,
	CLKS_ON = 1,
	REQ_CLKS_OFF = 2,
	REQ_CLKS_ON = 3,
};

enum clk_id {
	tegra_clk_actmon = 0,
	tegra_clk_adx = 1,
	tegra_clk_adx1 = 2,
	tegra_clk_afi = 3,
	tegra_clk_amx = 4,
	tegra_clk_amx1 = 5,
	tegra_clk_apb2ape = 6,
	tegra_clk_ahbdma = 7,
	tegra_clk_apbdma = 8,
	tegra_clk_apbif = 9,
	tegra_clk_ape = 10,
	tegra_clk_audio0 = 11,
	tegra_clk_audio0_2x = 12,
	tegra_clk_audio0_mux = 13,
	tegra_clk_audio1 = 14,
	tegra_clk_audio1_2x = 15,
	tegra_clk_audio1_mux = 16,
	tegra_clk_audio2 = 17,
	tegra_clk_audio2_2x = 18,
	tegra_clk_audio2_mux = 19,
	tegra_clk_audio3 = 20,
	tegra_clk_audio3_2x = 21,
	tegra_clk_audio3_mux = 22,
	tegra_clk_audio4 = 23,
	tegra_clk_audio4_2x = 24,
	tegra_clk_audio4_mux = 25,
	tegra_clk_bsea = 26,
	tegra_clk_bsev = 27,
	tegra_clk_cclk_g = 28,
	tegra_clk_cclk_lp = 29,
	tegra_clk_cilab = 30,
	tegra_clk_cilcd = 31,
	tegra_clk_cile = 32,
	tegra_clk_clk_32k = 33,
	tegra_clk_clk72Mhz = 34,
	tegra_clk_clk72Mhz_8 = 35,
	tegra_clk_clk_m = 36,
	tegra_clk_osc = 37,
	tegra_clk_osc_div2 = 38,
	tegra_clk_osc_div4 = 39,
	tegra_clk_cml0 = 40,
	tegra_clk_cml1 = 41,
	tegra_clk_csi = 42,
	tegra_clk_csite = 43,
	tegra_clk_csite_8 = 44,
	tegra_clk_csus = 45,
	tegra_clk_cve = 46,
	tegra_clk_dam0 = 47,
	tegra_clk_dam1 = 48,
	tegra_clk_dam2 = 49,
	tegra_clk_d_audio = 50,
	tegra_clk_dbgapb = 51,
	tegra_clk_dds = 52,
	tegra_clk_dfll_ref = 53,
	tegra_clk_dfll_soc = 54,
	tegra_clk_disp1 = 55,
	tegra_clk_disp1_8 = 56,
	tegra_clk_disp2 = 57,
	tegra_clk_disp2_8 = 58,
	tegra_clk_dp2 = 59,
	tegra_clk_dpaux = 60,
	tegra_clk_dpaux1 = 61,
	tegra_clk_dsialp = 62,
	tegra_clk_dsia_mux = 63,
	tegra_clk_dsiblp = 64,
	tegra_clk_dsib_mux = 65,
	tegra_clk_dtv = 66,
	tegra_clk_emc = 67,
	tegra_clk_entropy = 68,
	tegra_clk_entropy_8 = 69,
	tegra_clk_epp = 70,
	tegra_clk_epp_8 = 71,
	tegra_clk_extern1 = 72,
	tegra_clk_extern2 = 73,
	tegra_clk_extern3 = 74,
	tegra_clk_fuse = 75,
	tegra_clk_fuse_burn = 76,
	tegra_clk_gpu = 77,
	tegra_clk_gr2d = 78,
	tegra_clk_gr2d_8 = 79,
	tegra_clk_gr3d = 80,
	tegra_clk_gr3d_8 = 81,
	tegra_clk_hclk = 82,
	tegra_clk_hda = 83,
	tegra_clk_hda_8 = 84,
	tegra_clk_hda2codec_2x = 85,
	tegra_clk_hda2codec_2x_8 = 86,
	tegra_clk_hda2hdmi = 87,
	tegra_clk_hdmi = 88,
	tegra_clk_hdmi_audio = 89,
	tegra_clk_host1x = 90,
	tegra_clk_host1x_8 = 91,
	tegra_clk_host1x_9 = 92,
	tegra_clk_hsic_trk = 93,
	tegra_clk_i2c1 = 94,
	tegra_clk_i2c2 = 95,
	tegra_clk_i2c3 = 96,
	tegra_clk_i2c4 = 97,
	tegra_clk_i2c5 = 98,
	tegra_clk_i2c6 = 99,
	tegra_clk_i2cslow = 100,
	tegra_clk_i2s0 = 101,
	tegra_clk_i2s0_sync = 102,
	tegra_clk_i2s1 = 103,
	tegra_clk_i2s1_sync = 104,
	tegra_clk_i2s2 = 105,
	tegra_clk_i2s2_sync = 106,
	tegra_clk_i2s3 = 107,
	tegra_clk_i2s3_sync = 108,
	tegra_clk_i2s4 = 109,
	tegra_clk_i2s4_sync = 110,
	tegra_clk_isp = 111,
	tegra_clk_isp_8 = 112,
	tegra_clk_isp_9 = 113,
	tegra_clk_ispb = 114,
	tegra_clk_kbc = 115,
	tegra_clk_kfuse = 116,
	tegra_clk_la = 117,
	tegra_clk_maud = 118,
	tegra_clk_mipi = 119,
	tegra_clk_mipibif = 120,
	tegra_clk_mipi_cal = 121,
	tegra_clk_mpe = 122,
	tegra_clk_mselect = 123,
	tegra_clk_msenc = 124,
	tegra_clk_ndflash = 125,
	tegra_clk_ndflash_8 = 126,
	tegra_clk_ndspeed = 127,
	tegra_clk_ndspeed_8 = 128,
	tegra_clk_nor = 129,
	tegra_clk_nvdec = 130,
	tegra_clk_nvenc = 131,
	tegra_clk_nvjpg = 132,
	tegra_clk_owr = 133,
	tegra_clk_owr_8 = 134,
	tegra_clk_pcie = 135,
	tegra_clk_pclk = 136,
	tegra_clk_pll_a = 137,
	tegra_clk_pll_a_out0 = 138,
	tegra_clk_pll_a1 = 139,
	tegra_clk_pll_c = 140,
	tegra_clk_pll_c2 = 141,
	tegra_clk_pll_c3 = 142,
	tegra_clk_pll_c4 = 143,
	tegra_clk_pll_c4_out0 = 144,
	tegra_clk_pll_c4_out1 = 145,
	tegra_clk_pll_c4_out2 = 146,
	tegra_clk_pll_c4_out3 = 147,
	tegra_clk_pll_c_out1 = 148,
	tegra_clk_pll_d = 149,
	tegra_clk_pll_d2 = 150,
	tegra_clk_pll_d2_out0 = 151,
	tegra_clk_pll_d_out0 = 152,
	tegra_clk_pll_dp = 153,
	tegra_clk_pll_e_out0 = 154,
	tegra_clk_pll_g_ref = 155,
	tegra_clk_pll_m = 156,
	tegra_clk_pll_m_out1 = 157,
	tegra_clk_pll_mb = 158,
	tegra_clk_pll_p = 159,
	tegra_clk_pll_p_out1 = 160,
	tegra_clk_pll_p_out2 = 161,
	tegra_clk_pll_p_out2_int = 162,
	tegra_clk_pll_p_out3 = 163,
	tegra_clk_pll_p_out4 = 164,
	tegra_clk_pll_p_out4_cpu = 165,
	tegra_clk_pll_p_out5 = 166,
	tegra_clk_pll_p_out_hsio = 167,
	tegra_clk_pll_p_out_xusb = 168,
	tegra_clk_pll_p_out_cpu = 169,
	tegra_clk_pll_p_out_adsp = 170,
	tegra_clk_pll_ref = 171,
	tegra_clk_pll_re_out = 172,
	tegra_clk_pll_re_vco = 173,
	tegra_clk_pll_u = 174,
	tegra_clk_pll_u_out = 175,
	tegra_clk_pll_u_out1 = 176,
	tegra_clk_pll_u_out2 = 177,
	tegra_clk_pll_u_12m = 178,
	tegra_clk_pll_u_480m = 179,
	tegra_clk_pll_u_48m = 180,
	tegra_clk_pll_u_60m = 181,
	tegra_clk_pll_x = 182,
	tegra_clk_pll_x_out0 = 183,
	tegra_clk_pwm = 184,
	tegra_clk_qspi = 185,
	tegra_clk_rtc = 186,
	tegra_clk_sata = 187,
	tegra_clk_sata_8 = 188,
	tegra_clk_sata_cold = 189,
	tegra_clk_sata_oob = 190,
	tegra_clk_sata_oob_8 = 191,
	tegra_clk_sbc1 = 192,
	tegra_clk_sbc1_8 = 193,
	tegra_clk_sbc1_9 = 194,
	tegra_clk_sbc2 = 195,
	tegra_clk_sbc2_8 = 196,
	tegra_clk_sbc2_9 = 197,
	tegra_clk_sbc3 = 198,
	tegra_clk_sbc3_8 = 199,
	tegra_clk_sbc3_9 = 200,
	tegra_clk_sbc4 = 201,
	tegra_clk_sbc4_8 = 202,
	tegra_clk_sbc4_9 = 203,
	tegra_clk_sbc5 = 204,
	tegra_clk_sbc5_8 = 205,
	tegra_clk_sbc6 = 206,
	tegra_clk_sbc6_8 = 207,
	tegra_clk_sclk = 208,
	tegra_clk_sdmmc_legacy = 209,
	tegra_clk_sdmmc1 = 210,
	tegra_clk_sdmmc1_8 = 211,
	tegra_clk_sdmmc1_9 = 212,
	tegra_clk_sdmmc2 = 213,
	tegra_clk_sdmmc2_8 = 214,
	tegra_clk_sdmmc3 = 215,
	tegra_clk_sdmmc3_8 = 216,
	tegra_clk_sdmmc3_9 = 217,
	tegra_clk_sdmmc4 = 218,
	tegra_clk_sdmmc4_8 = 219,
	tegra_clk_se = 220,
	tegra_clk_se_10 = 221,
	tegra_clk_soc_therm = 222,
	tegra_clk_soc_therm_8 = 223,
	tegra_clk_sor0 = 224,
	tegra_clk_sor0_out = 225,
	tegra_clk_sor1 = 226,
	tegra_clk_sor1_out = 227,
	tegra_clk_spdif = 228,
	tegra_clk_spdif_2x = 229,
	tegra_clk_spdif_in = 230,
	tegra_clk_spdif_in_8 = 231,
	tegra_clk_spdif_in_sync = 232,
	tegra_clk_spdif_mux = 233,
	tegra_clk_spdif_out = 234,
	tegra_clk_timer = 235,
	tegra_clk_trace = 236,
	tegra_clk_tsec = 237,
	tegra_clk_tsec_8 = 238,
	tegra_clk_tsecb = 239,
	tegra_clk_tsensor = 240,
	tegra_clk_tvdac = 241,
	tegra_clk_tvo = 242,
	tegra_clk_uarta = 243,
	tegra_clk_uarta_8 = 244,
	tegra_clk_uartb = 245,
	tegra_clk_uartb_8 = 246,
	tegra_clk_uartc = 247,
	tegra_clk_uartc_8 = 248,
	tegra_clk_uartd = 249,
	tegra_clk_uartd_8 = 250,
	tegra_clk_uarte = 251,
	tegra_clk_uarte_8 = 252,
	tegra_clk_uartape = 253,
	tegra_clk_usb2 = 254,
	tegra_clk_usb2_hsic_trk = 255,
	tegra_clk_usb2_trk = 256,
	tegra_clk_usb3 = 257,
	tegra_clk_usbd = 258,
	tegra_clk_vcp = 259,
	tegra_clk_vde = 260,
	tegra_clk_vde_8 = 261,
	tegra_clk_vfir = 262,
	tegra_clk_vi = 263,
	tegra_clk_vi_8 = 264,
	tegra_clk_vi_9 = 265,
	tegra_clk_vi_10 = 266,
	tegra_clk_vi_i2c = 267,
	tegra_clk_vic03 = 268,
	tegra_clk_vic03_8 = 269,
	tegra_clk_vim2_clk = 270,
	tegra_clk_vimclk_sync = 271,
	tegra_clk_vi_sensor = 272,
	tegra_clk_vi_sensor_8 = 273,
	tegra_clk_vi_sensor_9 = 274,
	tegra_clk_vi_sensor2 = 275,
	tegra_clk_vi_sensor2_8 = 276,
	tegra_clk_xusb_dev = 277,
	tegra_clk_xusb_dev_src = 278,
	tegra_clk_xusb_dev_src_8 = 279,
	tegra_clk_xusb_falcon_src = 280,
	tegra_clk_xusb_falcon_src_8 = 281,
	tegra_clk_xusb_fs_src = 282,
	tegra_clk_xusb_gate = 283,
	tegra_clk_xusb_host = 284,
	tegra_clk_xusb_host_src = 285,
	tegra_clk_xusb_host_src_8 = 286,
	tegra_clk_xusb_hs_src = 287,
	tegra_clk_xusb_hs_src_4 = 288,
	tegra_clk_xusb_ss = 289,
	tegra_clk_xusb_ss_src = 290,
	tegra_clk_xusb_ss_src_8 = 291,
	tegra_clk_xusb_ss_div2 = 292,
	tegra_clk_xusb_ssp_src = 293,
	tegra_clk_sclk_mux = 294,
	tegra_clk_sor_safe = 295,
	tegra_clk_cec = 296,
	tegra_clk_ispa = 297,
	tegra_clk_dmic1 = 298,
	tegra_clk_dmic2 = 299,
	tegra_clk_dmic3 = 300,
	tegra_clk_dmic1_sync_clk = 301,
	tegra_clk_dmic2_sync_clk = 302,
	tegra_clk_dmic3_sync_clk = 303,
	tegra_clk_dmic1_sync_clk_mux = 304,
	tegra_clk_dmic2_sync_clk_mux = 305,
	tegra_clk_dmic3_sync_clk_mux = 306,
	tegra_clk_iqc1 = 307,
	tegra_clk_iqc2 = 308,
	tegra_clk_pll_a_out_adsp = 309,
	tegra_clk_pll_a_out0_out_adsp = 310,
	tegra_clk_adsp = 311,
	tegra_clk_adsp_neon = 312,
	tegra_clk_max = 313,
};

enum clk_id___2 {
	CLK_NONE = 0,
	CLK_MM = 1,
	CLK_MFG = 2,
	CLK_VENC = 3,
	CLK_VENC_LT = 4,
	CLK_ETHIF = 5,
	CLK_VDEC = 6,
	CLK_HIFSEL = 7,
	CLK_JPGDEC = 8,
	CLK_AUDIO = 9,
	CLK_MAX = 10,
};

enum clk_ids {
	LAST_DT_CORE_CLK = 42,
	CLK_EXTAL = 43,
	CLK_EXTALR = 44,
	CLK_MAIN = 45,
	CLK_PLL1 = 46,
	CLK_PLL20 = 47,
	CLK_PLL21 = 48,
	CLK_PLL30 = 49,
	CLK_PLL31 = 50,
	CLK_PLL5 = 51,
	CLK_PLL1_DIV2 = 52,
	CLK_PLL20_DIV2 = 53,
	CLK_PLL21_DIV2 = 54,
	CLK_PLL30_DIV2 = 55,
	CLK_PLL31_DIV2 = 56,
	CLK_PLL5_DIV2 = 57,
	CLK_PLL5_DIV4 = 58,
	CLK_S1 = 59,
	CLK_S3 = 60,
	CLK_SDSRC = 61,
	CLK_RPCSRC = 62,
	CLK_OCO = 63,
	MOD_CLK_BASE = 64,
};

enum clk_ids___2 {
	LAST_DT_CORE_CLK___2 = 30,
	CLK_EXTAL___2 = 31,
	CLK_EXTALR___2 = 32,
	CLK_MAIN___2 = 33,
	CLK_PLL0 = 34,
	CLK_PLL1___2 = 35,
	CLK_PLL3 = 36,
	CLK_PLL1_DIV2___2 = 37,
	CLK_PLL1_DIV4 = 38,
	MOD_CLK_BASE___2 = 39,
};

enum clk_ids___3 {
	LAST_DT_CORE_CLK___3 = 77,
	CLK_EXTAL___3 = 78,
	CLK_EXTALR___3 = 79,
	CLK_MAIN___3 = 80,
	CLK_PLL1___3 = 81,
	CLK_PLL2 = 82,
	CLK_PLL3___2 = 83,
	CLK_PLL4 = 84,
	CLK_PLL5___2 = 85,
	CLK_PLL6 = 86,
	CLK_PLL1_DIV2___3 = 87,
	CLK_PLL2_DIV2 = 88,
	CLK_PLL3_DIV2 = 89,
	CLK_PLL4_DIV2 = 90,
	CLK_PLL5_DIV2___2 = 91,
	CLK_PLL5_DIV4___2 = 92,
	CLK_PLL6_DIV2 = 93,
	CLK_S0 = 94,
	CLK_S0_VIO = 95,
	CLK_S0_VC = 96,
	CLK_S0_HSC = 97,
	CLK_SASYNCPER = 98,
	CLK_SV_VIP = 99,
	CLK_SV_IR = 100,
	CLK_SDSRC___2 = 101,
	CLK_RPCSRC___2 = 102,
	CLK_VIO = 103,
	CLK_VC = 104,
	CLK_OCO___2 = 105,
	MOD_CLK_BASE___3 = 106,
};

enum clk_ids___4 {
	LAST_DT_CORE_CLK___4 = 49,
	CLK_EXTAL___4 = 50,
	CLK_EXTALR___4 = 51,
	CLK_MAIN___4 = 52,
	CLK_PLL0___2 = 53,
	CLK_PLL1___4 = 54,
	CLK_PLL3___3 = 55,
	CLK_PLL4___2 = 56,
	CLK_PLL1_DIV2___4 = 57,
	CLK_PLL1_DIV4___2 = 58,
	CLK_S0___2 = 59,
	CLK_S1___2 = 60,
	CLK_S2 = 61,
	CLK_S3___2 = 62,
	CLK_SDSRC___3 = 63,
	CLK_SSPSRC = 64,
	CLK_RPCSRC___3 = 65,
	CLK_RINT = 66,
	MOD_CLK_BASE___4 = 67,
};

enum clk_ids___5 {
	LAST_DT_CORE_CLK___5 = 51,
	CLK_EXTAL___5 = 52,
	CLK_EXTALR___5 = 53,
	CLK_MAIN___5 = 54,
	CLK_PLL0___3 = 55,
	CLK_PLL1___5 = 56,
	CLK_PLL2___2 = 57,
	CLK_PLL3___4 = 58,
	CLK_PLL4___3 = 59,
	CLK_PLL1_DIV2___5 = 60,
	CLK_PLL1_DIV4___3 = 61,
	CLK_S0___3 = 62,
	CLK_S1___3 = 63,
	CLK_S2___2 = 64,
	CLK_S3___3 = 65,
	CLK_SDSRC___4 = 66,
	CLK_SSPSRC___2 = 67,
	CLK_RPCSRC___4 = 68,
	CLK_RINT___2 = 69,
	MOD_CLK_BASE___5 = 70,
};

enum clk_ids___6 {
	LAST_DT_CORE_CLK___6 = 52,
	CLK_EXTAL___6 = 53,
	CLK_EXTALR___6 = 54,
	CLK_MAIN___6 = 55,
	CLK_PLL0___4 = 56,
	CLK_PLL1___6 = 57,
	CLK_PLL2___3 = 58,
	CLK_PLL3___5 = 59,
	CLK_PLL4___4 = 60,
	CLK_PLL1_DIV2___6 = 61,
	CLK_PLL1_DIV4___4 = 62,
	CLK_S0___4 = 63,
	CLK_S1___4 = 64,
	CLK_S2___3 = 65,
	CLK_S3___4 = 66,
	CLK_SDSRC___5 = 67,
	CLK_SSPSRC___3 = 68,
	CLK_RPCSRC___5 = 69,
	CLK_RINT___3 = 70,
	MOD_CLK_BASE___6 = 71,
};

enum clk_ids___7 {
	LAST_DT_CORE_CLK___7 = 50,
	CLK_EXTAL___7 = 51,
	CLK_EXTALR___7 = 52,
	CLK_MAIN___7 = 53,
	CLK_PLL1___7 = 54,
	CLK_PLL2___4 = 55,
	CLK_PLL3___6 = 56,
	CLK_PLL5___3 = 57,
	CLK_PLL6___2 = 58,
	CLK_PLL1_DIV2___7 = 59,
	CLK_PLL2_DIV2___2 = 60,
	CLK_PLL3_DIV2___2 = 61,
	CLK_PLL5_DIV2___3 = 62,
	CLK_PLL5_DIV4___3 = 63,
	CLK_PLL6_DIV2___2 = 64,
	CLK_S0___5 = 65,
	CLK_SASYNCPER___2 = 66,
	CLK_SDSRC___6 = 67,
	CLK_RPCSRC___6 = 68,
	CLK_OCO___3 = 69,
	MOD_CLK_BASE___7 = 70,
};

enum clk_ids___8 {
	LAST_DT_CORE_CLK___8 = 46,
	CLK_EXTAL___8 = 47,
	CLK_EXTALR___8 = 48,
	CLK_MAIN___8 = 49,
	CLK_PLL0___5 = 50,
	CLK_PLL1___8 = 51,
	CLK_PLL2___5 = 52,
	CLK_PLL3___7 = 53,
	CLK_PLL4___5 = 54,
	CLK_PLL1_DIV2___8 = 55,
	CLK_PLL1_DIV4___5 = 56,
	CLK_S0___6 = 57,
	CLK_S1___5 = 58,
	CLK_S2___4 = 59,
	CLK_S3___5 = 60,
	CLK_SDSRC___7 = 61,
	CLK_RPCSRC___7 = 62,
	CLK_RINT___4 = 63,
	MOD_CLK_BASE___8 = 64,
};

enum clk_ids___9 {
	LAST_DT_CORE_CLK___9 = 37,
	CLK_EXTAL___9 = 38,
	CLK_EXTALR___9 = 39,
	CLK_MAIN___9 = 40,
	CLK_PLL1___9 = 41,
	CLK_PLL2___6 = 42,
	CLK_PLL3___8 = 43,
	CLK_PLL1_DIV2___9 = 44,
	CLK_PLL1_DIV4___6 = 45,
	CLK_S0___7 = 46,
	CLK_S1___6 = 47,
	CLK_S2___5 = 48,
	CLK_S3___6 = 49,
	CLK_SDSRC___8 = 50,
	CLK_RPCSRC___8 = 51,
	CLK_OCO___4 = 52,
	MOD_CLK_BASE___9 = 53,
};

enum clk_ids___10 {
	LAST_DT_CORE_CLK___10 = 44,
	CLK_EXTAL___10 = 45,
	CLK_EXTALR___10 = 46,
	CLK_MAIN___10 = 47,
	CLK_PLL0___6 = 48,
	CLK_PLL1___10 = 49,
	CLK_PLL3___9 = 50,
	CLK_PLL4___6 = 51,
	CLK_PLL1_DIV2___10 = 52,
	CLK_PLL1_DIV4___7 = 53,
	CLK_S0___8 = 54,
	CLK_S1___7 = 55,
	CLK_S2___6 = 56,
	CLK_S3___7 = 57,
	CLK_SDSRC___9 = 58,
	CLK_RPCSRC___9 = 59,
	CLK_RINT___5 = 60,
	MOD_CLK_BASE___10 = 61,
};

enum clk_ids___11 {
	LAST_DT_CORE_CLK___11 = 82,
	CLK_EXTAL___11 = 83,
	CLK_EXTALR___11 = 84,
	CLK_MAIN___11 = 85,
	CLK_PLL1___11 = 86,
	CLK_PLL2___7 = 87,
	CLK_PLL3___10 = 88,
	CLK_PLL4___7 = 89,
	CLK_PLL5___4 = 90,
	CLK_PLL6___3 = 91,
	CLK_PLL1_DIV2___11 = 92,
	CLK_PLL3_DIV2___3 = 93,
	CLK_PLL4_DIV2___2 = 94,
	CLK_PLL4_DIV5 = 95,
	CLK_PLL5_DIV2___4 = 96,
	CLK_PLL5_DIV4___4 = 97,
	CLK_PLL6_DIV2___3 = 98,
	CLK_S0___9 = 99,
	CLK_S0_VIO___2 = 100,
	CLK_S0_VC___2 = 101,
	CLK_S0_HSC___2 = 102,
	CLK_SASYNCPER___3 = 103,
	CLK_SV_VIP___2 = 104,
	CLK_SV_IR___2 = 105,
	CLK_IMPASRC = 106,
	CLK_IMPBSRC = 107,
	CLK_VIOSRC = 108,
	CLK_VCSRC = 109,
	CLK_SDSRC___10 = 110,
	CLK_RPCSRC___10 = 111,
	CLK_OCO___5 = 112,
	MOD_CLK_BASE___11 = 113,
};

enum clk_reg_layout {
	CLK_REG_LAYOUT_RCAR_GEN2_AND_GEN3 = 0,
	CLK_REG_LAYOUT_RZ_A = 1,
	CLK_REG_LAYOUT_RCAR_GEN4 = 2,
	CLK_REG_LAYOUT_RZ_T2H = 3,
};

enum clk_sel {
	LOW_SPEED_IO_SEL = 0,
	NON_IO_SEL = 1,
	FAST_SEL = 2,
	AUDIO_SEL = 3,
	VIDEO_SEL = 4,
	TPM_SEL = 5,
	CKO1_SEL = 6,
	CKO2_SEL = 7,
	MISC_SEL = 8,
	MAX_SEL = 9,
};

enum clk_state {
	CLK_STATE_DISABLE = 0,
	CLK_STATE_ENABLE = 1,
	CLK_STATE_RESERVED = 2,
	CLK_STATE_UNCHANGED = 3,
};

enum clk_type {
	CLK_TYPE_OUTPUT = 0,
	CLK_TYPE_EXTERNAL = 1,
};

enum clk_type_t {
	CLK_EXT_DIFF = 0,
	CLK_INT_DIFF = 1,
	CLK_INT_SING = 2,
};

enum clk_types {
	CLK_TYPE_IN = 0,
	CLK_TYPE_FF = 1,
	CLK_TYPE_SAM_PLL = 2,
	CLK_TYPE_G3S_PLL = 3,
	CLK_TYPE_DIV = 4,
	CLK_TYPE_G3S_DIV = 5,
	CLK_TYPE_MUX = 6,
	CLK_TYPE_SD_MUX = 7,
	CLK_TYPE_SIPLL5 = 8,
	CLK_TYPE_PLL5_4_MUX = 9,
	CLK_TYPE_DSI_DIV = 10,
};

enum clk_types___2 {
	CLK_TYPE_IN___2 = 0,
	CLK_TYPE_FF___2 = 1,
	CLK_TYPE_FF_MOD_STATUS = 2,
	CLK_TYPE_PLL = 3,
	CLK_TYPE_DDIV = 4,
	CLK_TYPE_SMUX = 5,
};

enum clk_types___3 {
	CLK_TYPE_IN___3 = 0,
	CLK_TYPE_FF___3 = 1,
	CLK_TYPE_DIV6P1 = 2,
	CLK_TYPE_DIV6_RO = 3,
	CLK_TYPE_FR = 4,
	CLK_TYPE_CUSTOM = 5,
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_S390_TOD = 2,
	CSID_X86_TSC_EARLY = 3,
	CSID_X86_TSC = 4,
	CSID_X86_KVM_CLK = 5,
	CSID_X86_ART = 6,
	CSID_MAX = 7,
};

enum cm_batt_temp {
	CM_BATT_OK = 0,
	CM_BATT_OVERHEAT = 1,
	CM_BATT_COLD = 2,
};

enum cma_flags {
	CMA_RESERVE_PAGES_ON_ERROR = 0,
	CMA_ZONES_VALID = 1,
	CMA_ZONES_INVALID = 2,
	CMA_ACTIVATED = 3,
};

enum cmd_db_hw_type {
	CMD_DB_HW_INVALID = 0,
	CMD_DB_HW_MIN = 3,
	CMD_DB_HW_ARC = 3,
	CMD_DB_HW_VRM = 4,
	CMD_DB_HW_BCM = 5,
	CMD_DB_HW_MAX = 5,
	CMD_DB_HW_ALL = 255,
};

enum cmis_cdb_fw_write_mechanism {
	CMIS_CDB_FW_WRITE_MECHANISM_NONE = 0,
	CMIS_CDB_FW_WRITE_MECHANISM_LPL = 1,
	CMIS_CDB_FW_WRITE_MECHANISM_EPL = 16,
	CMIS_CDB_FW_WRITE_MECHANISM_BOTH = 17,
};

enum cmu_type_t {
	REF_CMU = 0,
	PHY_CMU = 1,
};

enum compact_priority {
	COMPACT_PRIO_SYNC_FULL = 0,
	MIN_COMPACT_PRIORITY = 0,
	COMPACT_PRIO_SYNC_LIGHT = 1,
	MIN_COMPACT_COSTLY_PRIORITY = 1,
	DEF_COMPACT_PRIORITY = 1,
	COMPACT_PRIO_ASYNC = 2,
	INIT_COMPACT_PRIORITY = 2,
};

enum compact_result {
	COMPACT_NOT_SUITABLE_ZONE = 0,
	COMPACT_SKIPPED = 1,
	COMPACT_DEFERRED = 2,
	COMPACT_NO_SUITABLE_PAGE = 3,
	COMPACT_CONTINUE = 4,
	COMPACT_COMPLETE = 5,
	COMPACT_PARTIAL_SKIPPED = 6,
	COMPACT_CONTENDED = 7,
	COMPACT_SUCCESS = 8,
};

enum compat_regset {
	REGSET_COMPAT_GPR = 0,
	REGSET_COMPAT_VFP = 1,
};

enum con_flush_mode {
	CONSOLE_FLUSH_PENDING = 0,
	CONSOLE_REPLAY_ALL = 1,
};

enum con_msg_format_flags {
	MSG_FORMAT_DEFAULT = 0,
	MSG_FORMAT_SYSLOG = 1,
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
	CON_NBCON = 256,
};

enum coredump_mark {
	COREDUMP_MARK_REQACK = 0,
	COREDUMP_MARK_MINSIZE = 1,
	COREDUMP_MARK_MAXSIZE = 2,
	COREDUMP_MARK_UNSUPPORTED = 3,
	COREDUMP_MARK_CONFLICTING = 4,
	__COREDUMP_MARK_MAX = 2147483648,
};

enum coredump_type_t {
	COREDUMP_FILE = 1,
	COREDUMP_PIPE = 2,
	COREDUMP_SOCK = 3,
	COREDUMP_SOCK_REQ = 4,
};

enum cpi_algorithm_type {
	CPI_ALG_NONE = 0,
	CPI_ALG_VLAN = 1,
	CPI_ALG_VLAN16 = 2,
	CPI_ALG_DIFF = 3,
};

enum cpio_fields {
	C_MAGIC = 0,
	C_INO = 1,
	C_MODE = 2,
	C_UID = 3,
	C_GID = 4,
	C_NLINK = 5,
	C_MTIME = 6,
	C_FILESIZE = 7,
	C_MAJ = 8,
	C_MIN = 9,
	C_RMAJ = 10,
	C_RMIN = 11,
	C_NAMESIZE = 12,
	C_CHKSUM = 13,
	C_NFIELDS = 14,
};

enum cppc_regs {
	HIGHEST_PERF = 0,
	NOMINAL_PERF = 1,
	LOW_NON_LINEAR_PERF = 2,
	LOWEST_PERF = 3,
	GUARANTEED_PERF = 4,
	DESIRED_PERF = 5,
	MIN_PERF = 6,
	MAX_PERF = 7,
	PERF_REDUC_TOLERANCE = 8,
	TIME_WINDOW = 9,
	CTR_WRAP_TIME = 10,
	REFERENCE_CTR = 11,
	DELIVERED_CTR = 12,
	PERF_LIMITED = 13,
	ENABLE = 14,
	AUTO_SEL_ENABLE = 15,
	AUTO_ACT_WINDOW = 16,
	ENERGY_PERF = 17,
	REFERENCE_PERF = 18,
	LOWEST_FREQ = 19,
	NOMINAL_FREQ = 20,
};

enum cppi5_tr_event_size {
	CPPI5_TR_EVENT_SIZE_COMPLETION = 0,
	CPPI5_TR_EVENT_SIZE_ICNT1_DEC = 1,
	CPPI5_TR_EVENT_SIZE_ICNT2_DEC = 2,
	CPPI5_TR_EVENT_SIZE_ICNT3_DEC = 3,
	CPPI5_TR_EVENT_SIZE_MAX = 4,
};

enum cppi5_tr_trigger {
	CPPI5_TR_TRIGGER_NONE = 0,
	CPPI5_TR_TRIGGER_GLOBAL0 = 1,
	CPPI5_TR_TRIGGER_GLOBAL1 = 2,
	CPPI5_TR_TRIGGER_LOCAL_EVENT = 3,
	CPPI5_TR_TRIGGER_MAX = 4,
};

enum cppi5_tr_trigger_type {
	CPPI5_TR_TRIGGER_TYPE_ICNT1_DEC = 0,
	CPPI5_TR_TRIGGER_TYPE_ICNT2_DEC = 1,
	CPPI5_TR_TRIGGER_TYPE_ICNT3_DEC = 2,
	CPPI5_TR_TRIGGER_TYPE_ALL = 3,
	CPPI5_TR_TRIGGER_TYPE_MAX = 4,
};

enum cppi5_tr_types {
	CPPI5_TR_TYPE0 = 0,
	CPPI5_TR_TYPE1 = 1,
	CPPI5_TR_TYPE2 = 2,
	CPPI5_TR_TYPE3 = 3,
	CPPI5_TR_TYPE4 = 4,
	CPPI5_TR_TYPE5 = 5,
	CPPI5_TR_TYPE8 = 8,
	CPPI5_TR_TYPE9 = 9,
	CPPI5_TR_TYPE10 = 10,
	CPPI5_TR_TYPE11 = 11,
	CPPI5_TR_TYPE15 = 15,
	CPPI5_TR_TYPE_MAX = 16,
};

enum cpsw_ale_control {
	ALE_ENABLE = 0,
	ALE_CLEAR = 1,
	ALE_AGEOUT = 2,
	ALE_P0_UNI_FLOOD = 3,
	ALE_VLAN_NOLEARN = 4,
	ALE_NO_PORT_VLAN = 5,
	ALE_OUI_DENY = 6,
	ALE_BYPASS = 7,
	ALE_RATE_LIMIT_TX = 8,
	ALE_VLAN_AWARE = 9,
	ALE_AUTH_ENABLE = 10,
	ALE_RATE_LIMIT = 11,
	ALE_PORT_STATE = 12,
	ALE_PORT_DROP_UNTAGGED = 13,
	ALE_PORT_DROP_UNKNOWN_VLAN = 14,
	ALE_PORT_NOLEARN = 15,
	ALE_PORT_NO_SA_UPDATE = 16,
	ALE_PORT_UNKNOWN_VLAN_MEMBER = 17,
	ALE_PORT_UNKNOWN_MCAST_FLOOD = 18,
	ALE_PORT_UNKNOWN_REG_MCAST_FLOOD = 19,
	ALE_PORT_UNTAGGED_EGRESS = 20,
	ALE_PORT_MACONLY = 21,
	ALE_PORT_MACONLY_CAF = 22,
	ALE_PORT_BCAST_LIMIT = 23,
	ALE_PORT_MCAST_LIMIT = 24,
	ALE_DEFAULT_THREAD_ID = 25,
	ALE_DEFAULT_THREAD_ENABLE = 26,
	ALE_NUM_CONTROLS = 27,
};

enum cpsw_ale_port_state {
	ALE_PORT_STATE_DISABLE = 0,
	ALE_PORT_STATE_BLOCK = 1,
	ALE_PORT_STATE_LEARN = 2,
	ALE_PORT_STATE_FORWARD = 3,
};

enum cpsw_devlink_param_id {
	AM65_CPSW_DEVLINK_PARAM_ID_BASE = 20,
	AM65_CPSW_DL_PARAM_SWITCH_MODE = 21,
};

enum cpsw_sl_regs {
	CPSW_SL_IDVER = 0,
	CPSW_SL_MACCONTROL = 1,
	CPSW_SL_MACSTATUS = 2,
	CPSW_SL_SOFT_RESET = 3,
	CPSW_SL_RX_MAXLEN = 4,
	CPSW_SL_BOFFTEST = 5,
	CPSW_SL_RX_PAUSE = 6,
	CPSW_SL_TX_PAUSE = 7,
	CPSW_SL_EMCONTROL = 8,
	CPSW_SL_RX_PRI_MAP = 9,
	CPSW_SL_TX_GAP = 10,
};

enum cpu_attack_vectors {
	CPU_MITIGATE_USER_KERNEL = 0,
	CPU_MITIGATE_USER_USER = 1,
	CPU_MITIGATE_GUEST_HOST = 2,
	CPU_MITIGATE_GUEST_GUEST = 3,
	NR_CPU_ATTACK_VECTORS = 4,
};

enum cpu_idle_type {
	__CPU_NOT_IDLE = 0,
	CPU_IDLE = 1,
	CPU_NEWLY_IDLE = 2,
	CPU_MAX_IDLE_TYPES = 3,
};

enum cpu_led_event {
	CPU_LED_IDLE_START = 0,
	CPU_LED_IDLE_END = 1,
	CPU_LED_START = 2,
	CPU_LED_STOP = 3,
	CPU_LED_HALTED = 4,
};

enum cpu_mitigations {
	CPU_MITIGATIONS_OFF = 0,
	CPU_MITIGATIONS_AUTO = 1,
	CPU_MITIGATIONS_AUTO_NOSMT = 2,
};

enum cpu_pm_event {
	CPU_PM_ENTER = 0,
	CPU_PM_ENTER_FAILED = 1,
	CPU_PM_EXIT = 2,
	CPU_CLUSTER_PM_ENTER = 3,
	CPU_CLUSTER_PM_ENTER_FAILED = 4,
	CPU_CLUSTER_PM_EXIT = 5,
};

enum cpu_usage_stat {
	CPUTIME_USER = 0,
	CPUTIME_NICE = 1,
	CPUTIME_SYSTEM = 2,
	CPUTIME_SOFTIRQ = 3,
	CPUTIME_IRQ = 4,
	CPUTIME_IDLE = 5,
	CPUTIME_IOWAIT = 6,
	CPUTIME_STEAL = 7,
	CPUTIME_GUEST = 8,
	CPUTIME_GUEST_NICE = 9,
	NR_STATS = 10,
};

enum cpuacct_stat_index {
	CPUACCT_STAT_USER = 0,
	CPUACCT_STAT_SYSTEM = 1,
	CPUACCT_STAT_NSTATS = 2,
};

enum cpubiuctrl_regs {
	CPU_CREDIT_REG = 0,
	CPU_MCP_FLOW_REG = 1,
	CPU_WRITEBACK_CTRL_REG = 2,
	RAC_CONFIG0_REG = 3,
	RAC_CONFIG1_REG = 4,
	NUM_CPU_BIUCTRL_REGS = 5,
};

enum cpufreq_table_sorting {
	CPUFREQ_TABLE_UNSORTED = 0,
	CPUFREQ_TABLE_SORTED_ASCENDING = 1,
	CPUFREQ_TABLE_SORTED_DESCENDING = 2,
};

enum cpuhp_smt_control {
	CPU_SMT_ENABLED = 0,
	CPU_SMT_DISABLED = 1,
	CPU_SMT_FORCE_DISABLED = 2,
	CPU_SMT_NOT_SUPPORTED = 3,
	CPU_SMT_NOT_IMPLEMENTED = 4,
};

enum cpuhp_state {
	CPUHP_INVALID = -1,
	CPUHP_OFFLINE = 0,
	CPUHP_CREATE_THREADS = 1,
	CPUHP_PERF_X86_PREPARE = 2,
	CPUHP_PERF_X86_AMD_UNCORE_PREP = 3,
	CPUHP_PERF_POWER = 4,
	CPUHP_PERF_SUPERH = 5,
	CPUHP_X86_HPET_DEAD = 6,
	CPUHP_X86_MCE_DEAD = 7,
	CPUHP_VIRT_NET_DEAD = 8,
	CPUHP_IBMVNIC_DEAD = 9,
	CPUHP_SLUB_DEAD = 10,
	CPUHP_DEBUG_OBJ_DEAD = 11,
	CPUHP_MM_WRITEBACK_DEAD = 12,
	CPUHP_MM_VMSTAT_DEAD = 13,
	CPUHP_SOFTIRQ_DEAD = 14,
	CPUHP_NET_MVNETA_DEAD = 15,
	CPUHP_CPUIDLE_DEAD = 16,
	CPUHP_ARM64_FPSIMD_DEAD = 17,
	CPUHP_ARM_OMAP_WAKE_DEAD = 18,
	CPUHP_IRQ_POLL_DEAD = 19,
	CPUHP_BLOCK_SOFTIRQ_DEAD = 20,
	CPUHP_BIO_DEAD = 21,
	CPUHP_ACPI_CPUDRV_DEAD = 22,
	CPUHP_S390_PFAULT_DEAD = 23,
	CPUHP_BLK_MQ_DEAD = 24,
	CPUHP_FS_BUFF_DEAD = 25,
	CPUHP_PRINTK_DEAD = 26,
	CPUHP_MM_MEMCQ_DEAD = 27,
	CPUHP_PERCPU_CNT_DEAD = 28,
	CPUHP_RADIX_DEAD = 29,
	CPUHP_PAGE_ALLOC = 30,
	CPUHP_NET_DEV_DEAD = 31,
	CPUHP_IOMMU_IOVA_DEAD = 32,
	CPUHP_AP_ARM_CACHE_B15_RAC_DEAD = 33,
	CPUHP_PADATA_DEAD = 34,
	CPUHP_AP_DTPM_CPU_DEAD = 35,
	CPUHP_RANDOM_PREPARE = 36,
	CPUHP_WORKQUEUE_PREP = 37,
	CPUHP_POWER_NUMA_PREPARE = 38,
	CPUHP_HRTIMERS_PREPARE = 39,
	CPUHP_X2APIC_PREPARE = 40,
	CPUHP_SMPCFD_PREPARE = 41,
	CPUHP_RELAY_PREPARE = 42,
	CPUHP_MD_RAID5_PREPARE = 43,
	CPUHP_RCUTREE_PREP = 44,
	CPUHP_CPUIDLE_COUPLED_PREPARE = 45,
	CPUHP_POWERPC_PMAC_PREPARE = 46,
	CPUHP_POWERPC_MMU_CTX_PREPARE = 47,
	CPUHP_XEN_PREPARE = 48,
	CPUHP_XEN_EVTCHN_PREPARE = 49,
	CPUHP_ARM_SHMOBILE_SCU_PREPARE = 50,
	CPUHP_SH_SH3X_PREPARE = 51,
	CPUHP_TOPOLOGY_PREPARE = 52,
	CPUHP_NET_IUCV_PREPARE = 53,
	CPUHP_ARM_BL_PREPARE = 54,
	CPUHP_TRACE_RB_PREPARE = 55,
	CPUHP_MM_ZSWP_POOL_PREPARE = 56,
	CPUHP_KVM_PPC_BOOK3S_PREPARE = 57,
	CPUHP_ZCOMP_PREPARE = 58,
	CPUHP_TIMERS_PREPARE = 59,
	CPUHP_TMIGR_PREPARE = 60,
	CPUHP_MIPS_SOC_PREPARE = 61,
	CPUHP_BP_PREPARE_DYN = 62,
	CPUHP_BP_PREPARE_DYN_END = 82,
	CPUHP_BP_KICK_AP = 83,
	CPUHP_BRINGUP_CPU = 84,
	CPUHP_AP_IDLE_DEAD = 85,
	CPUHP_AP_OFFLINE = 86,
	CPUHP_AP_CACHECTRL_STARTING = 87,
	CPUHP_AP_SCHED_STARTING = 88,
	CPUHP_AP_RCUTREE_DYING = 89,
	CPUHP_AP_CPU_PM_STARTING = 90,
	CPUHP_AP_IRQ_GIC_STARTING = 91,
	CPUHP_AP_IRQ_HIP04_STARTING = 92,
	CPUHP_AP_IRQ_APPLE_AIC_STARTING = 93,
	CPUHP_AP_IRQ_ARMADA_XP_STARTING = 94,
	CPUHP_AP_IRQ_BCM2836_STARTING = 95,
	CPUHP_AP_IRQ_MIPS_GIC_STARTING = 96,
	CPUHP_AP_IRQ_EIOINTC_STARTING = 97,
	CPUHP_AP_IRQ_AVECINTC_STARTING = 98,
	CPUHP_AP_IRQ_SIFIVE_PLIC_STARTING = 99,
	CPUHP_AP_IRQ_ACLINT_SSWI_STARTING = 100,
	CPUHP_AP_IRQ_RISCV_IMSIC_STARTING = 101,
	CPUHP_AP_IRQ_RISCV_SBI_IPI_STARTING = 102,
	CPUHP_AP_ARM_MVEBU_COHERENCY = 103,
	CPUHP_AP_PERF_X86_AMD_UNCORE_STARTING = 104,
	CPUHP_AP_PERF_X86_STARTING = 105,
	CPUHP_AP_PERF_X86_AMD_IBS_STARTING = 106,
	CPUHP_AP_PERF_XTENSA_STARTING = 107,
	CPUHP_AP_ARM_VFP_STARTING = 108,
	CPUHP_AP_ARM64_DEBUG_MONITORS_STARTING = 109,
	CPUHP_AP_PERF_ARM_HW_BREAKPOINT_STARTING = 110,
	CPUHP_AP_PERF_ARM_ACPI_STARTING = 111,
	CPUHP_AP_PERF_ARM_STARTING = 112,
	CPUHP_AP_PERF_RISCV_STARTING = 113,
	CPUHP_AP_ARM_L2X0_STARTING = 114,
	CPUHP_AP_EXYNOS4_MCT_TIMER_STARTING = 115,
	CPUHP_AP_ARM_ARCH_TIMER_STARTING = 116,
	CPUHP_AP_ARM_ARCH_TIMER_EVTSTRM_STARTING = 117,
	CPUHP_AP_ARM_GLOBAL_TIMER_STARTING = 118,
	CPUHP_AP_JCORE_TIMER_STARTING = 119,
	CPUHP_AP_ARM_TWD_STARTING = 120,
	CPUHP_AP_QCOM_TIMER_STARTING = 121,
	CPUHP_AP_TEGRA_TIMER_STARTING = 122,
	CPUHP_AP_ARMADA_TIMER_STARTING = 123,
	CPUHP_AP_LOONGARCH_ARCH_TIMER_STARTING = 124,
	CPUHP_AP_MIPS_GIC_TIMER_STARTING = 125,
	CPUHP_AP_ARC_TIMER_STARTING = 126,
	CPUHP_AP_REALTEK_TIMER_STARTING = 127,
	CPUHP_AP_RISCV_TIMER_STARTING = 128,
	CPUHP_AP_CLINT_TIMER_STARTING = 129,
	CPUHP_AP_CSKY_TIMER_STARTING = 130,
	CPUHP_AP_TI_GP_TIMER_STARTING = 131,
	CPUHP_AP_HYPERV_TIMER_STARTING = 132,
	CPUHP_AP_DUMMY_TIMER_STARTING = 133,
	CPUHP_AP_ARM_XEN_STARTING = 134,
	CPUHP_AP_ARM_XEN_RUNSTATE_STARTING = 135,
	CPUHP_AP_ARM_CORESIGHT_STARTING = 136,
	CPUHP_AP_ARM_CORESIGHT_CTI_STARTING = 137,
	CPUHP_AP_ARM64_ISNDEP_STARTING = 138,
	CPUHP_AP_SMPCFD_DYING = 139,
	CPUHP_AP_HRTIMERS_DYING = 140,
	CPUHP_AP_TICK_DYING = 141,
	CPUHP_AP_X86_TBOOT_DYING = 142,
	CPUHP_AP_ARM_CACHE_B15_RAC_DYING = 143,
	CPUHP_AP_ONLINE = 144,
	CPUHP_TEARDOWN_CPU = 145,
	CPUHP_AP_ONLINE_IDLE = 146,
	CPUHP_AP_HYPERV_ONLINE = 147,
	CPUHP_AP_KVM_ONLINE = 148,
	CPUHP_AP_SCHED_WAIT_EMPTY = 149,
	CPUHP_AP_SMPBOOT_THREADS = 150,
	CPUHP_AP_IRQ_AFFINITY_ONLINE = 151,
	CPUHP_AP_BLK_MQ_ONLINE = 152,
	CPUHP_AP_ARM_MVEBU_SYNC_CLOCKS = 153,
	CPUHP_AP_X86_INTEL_EPB_ONLINE = 154,
	CPUHP_AP_PERF_ONLINE = 155,
	CPUHP_AP_PERF_X86_ONLINE = 156,
	CPUHP_AP_PERF_X86_UNCORE_ONLINE = 157,
	CPUHP_AP_PERF_X86_AMD_UNCORE_ONLINE = 158,
	CPUHP_AP_PERF_X86_AMD_POWER_ONLINE = 159,
	CPUHP_AP_PERF_S390_CF_ONLINE = 160,
	CPUHP_AP_PERF_S390_SF_ONLINE = 161,
	CPUHP_AP_PERF_ARM_CCI_ONLINE = 162,
	CPUHP_AP_PERF_ARM_CCN_ONLINE = 163,
	CPUHP_AP_PERF_ARM_HISI_CPA_ONLINE = 164,
	CPUHP_AP_PERF_ARM_HISI_DDRC_ONLINE = 165,
	CPUHP_AP_PERF_ARM_HISI_HHA_ONLINE = 166,
	CPUHP_AP_PERF_ARM_HISI_L3_ONLINE = 167,
	CPUHP_AP_PERF_ARM_HISI_PA_ONLINE = 168,
	CPUHP_AP_PERF_ARM_HISI_SLLC_ONLINE = 169,
	CPUHP_AP_PERF_ARM_HISI_PCIE_PMU_ONLINE = 170,
	CPUHP_AP_PERF_ARM_HNS3_PMU_ONLINE = 171,
	CPUHP_AP_PERF_ARM_L2X0_ONLINE = 172,
	CPUHP_AP_PERF_ARM_QCOM_L2_ONLINE = 173,
	CPUHP_AP_PERF_ARM_QCOM_L3_ONLINE = 174,
	CPUHP_AP_PERF_ARM_APM_XGENE_ONLINE = 175,
	CPUHP_AP_PERF_ARM_CAVIUM_TX2_UNCORE_ONLINE = 176,
	CPUHP_AP_PERF_ARM_MARVELL_CN10K_DDR_ONLINE = 177,
	CPUHP_AP_PERF_ARM_MRVL_PEM_ONLINE = 178,
	CPUHP_AP_PERF_POWERPC_NEST_IMC_ONLINE = 179,
	CPUHP_AP_PERF_POWERPC_CORE_IMC_ONLINE = 180,
	CPUHP_AP_PERF_POWERPC_THREAD_IMC_ONLINE = 181,
	CPUHP_AP_PERF_POWERPC_TRACE_IMC_ONLINE = 182,
	CPUHP_AP_PERF_POWERPC_HV_24x7_ONLINE = 183,
	CPUHP_AP_PERF_POWERPC_HV_GPCI_ONLINE = 184,
	CPUHP_AP_PERF_CSKY_ONLINE = 185,
	CPUHP_AP_TMIGR_ONLINE = 186,
	CPUHP_AP_WATCHDOG_ONLINE = 187,
	CPUHP_AP_WORKQUEUE_ONLINE = 188,
	CPUHP_AP_RANDOM_ONLINE = 189,
	CPUHP_AP_RCUTREE_ONLINE = 190,
	CPUHP_AP_KTHREADS_ONLINE = 191,
	CPUHP_AP_BASE_CACHEINFO_ONLINE = 192,
	CPUHP_AP_ONLINE_DYN = 193,
	CPUHP_AP_ONLINE_DYN_END = 233,
	CPUHP_AP_X86_HPET_ONLINE = 234,
	CPUHP_AP_X86_KVM_CLK_ONLINE = 235,
	CPUHP_AP_ACTIVE = 236,
	CPUHP_ONLINE = 237,
};

enum cpuhp_sync_state {
	SYNC_STATE_DEAD = 0,
	SYNC_STATE_KICKED = 1,
	SYNC_STATE_SHOULD_DIE = 2,
	SYNC_STATE_ALIVE = 3,
	SYNC_STATE_SHOULD_ONLINE = 4,
	SYNC_STATE_ONLINE = 5,
};

enum createmode4 {
	NFS4_CREATE_UNCHECKED = 0,
	NFS4_CREATE_GUARDED = 1,
	NFS4_CREATE_EXCLUSIVE = 2,
	NFS4_CREATE_EXCLUSIVE4_1 = 3,
};

enum criteria {
	CR_POWER2_ALIGNED = 0,
	CR_GOAL_LEN_FAST = 1,
	CR_BEST_AVAIL_LEN = 2,
	CR_GOAL_LEN_SLOW = 3,
	CR_ANY_FREE = 4,
	EXT4_MB_NUM_CRS = 5,
};

enum crypto_attr_type_t {
	CRYPTOCFGA_UNSPEC = 0,
	CRYPTOCFGA_PRIORITY_VAL = 1,
	CRYPTOCFGA_REPORT_LARVAL = 2,
	CRYPTOCFGA_REPORT_HASH = 3,
	CRYPTOCFGA_REPORT_BLKCIPHER = 4,
	CRYPTOCFGA_REPORT_AEAD = 5,
	CRYPTOCFGA_REPORT_COMPRESS = 6,
	CRYPTOCFGA_REPORT_RNG = 7,
	CRYPTOCFGA_REPORT_CIPHER = 8,
	CRYPTOCFGA_REPORT_AKCIPHER = 9,
	CRYPTOCFGA_REPORT_KPP = 10,
	CRYPTOCFGA_REPORT_ACOMP = 11,
	CRYPTOCFGA_STAT_LARVAL = 12,
	CRYPTOCFGA_STAT_HASH = 13,
	CRYPTOCFGA_STAT_BLKCIPHER = 14,
	CRYPTOCFGA_STAT_AEAD = 15,
	CRYPTOCFGA_STAT_COMPRESS = 16,
	CRYPTOCFGA_STAT_RNG = 17,
	CRYPTOCFGA_STAT_CIPHER = 18,
	CRYPTOCFGA_STAT_AKCIPHER = 19,
	CRYPTOCFGA_STAT_KPP = 20,
	CRYPTOCFGA_STAT_ACOMP = 21,
	CRYPTOCFGA_REPORT_SIG = 22,
	__CRYPTOCFGA_MAX = 23,
};

enum csr_regs {
	B0_RAP = 0,
	B0_CTST = 4,
	B0_POWER_CTRL = 7,
	B0_ISRC = 8,
	B0_IMSK = 12,
	B0_HWE_ISRC = 16,
	B0_HWE_IMSK = 20,
	B0_Y2_SP_ISRC2 = 28,
	B0_Y2_SP_ISRC3 = 32,
	B0_Y2_SP_EISR = 36,
	B0_Y2_SP_LISR = 40,
	B0_Y2_SP_ICR = 44,
	B2_MAC_1 = 256,
	B2_MAC_2 = 264,
	B2_MAC_3 = 272,
	B2_CONN_TYP = 280,
	B2_PMD_TYP = 281,
	B2_MAC_CFG = 282,
	B2_CHIP_ID = 283,
	B2_E_0 = 284,
	B2_Y2_CLK_GATE = 285,
	B2_Y2_HW_RES = 286,
	B2_E_3 = 287,
	B2_Y2_CLK_CTRL = 288,
	B2_TI_INI = 304,
	B2_TI_VAL = 308,
	B2_TI_CTRL = 312,
	B2_TI_TEST = 313,
	B2_TST_CTRL1 = 344,
	B2_TST_CTRL2 = 345,
	B2_GP_IO = 348,
	B2_I2C_CTRL = 352,
	B2_I2C_DATA = 356,
	B2_I2C_IRQ = 360,
	B2_I2C_SW = 364,
	Y2_PEX_PHY_DATA = 368,
	Y2_PEX_PHY_ADDR = 370,
	B3_RAM_ADDR = 384,
	B3_RAM_DATA_LO = 388,
	B3_RAM_DATA_HI = 392,
	B3_RI_WTO_R1 = 400,
	B3_RI_WTO_XA1 = 401,
	B3_RI_WTO_XS1 = 402,
	B3_RI_RTO_R1 = 403,
	B3_RI_RTO_XA1 = 404,
	B3_RI_RTO_XS1 = 405,
	B3_RI_WTO_R2 = 406,
	B3_RI_WTO_XA2 = 407,
	B3_RI_WTO_XS2 = 408,
	B3_RI_RTO_R2 = 409,
	B3_RI_RTO_XA2 = 410,
	B3_RI_RTO_XS2 = 411,
	B3_RI_TO_VAL = 412,
	B3_RI_CTRL = 416,
	B3_RI_TEST = 418,
	B3_MA_TOINI_RX1 = 432,
	B3_MA_TOINI_RX2 = 433,
	B3_MA_TOINI_TX1 = 434,
	B3_MA_TOINI_TX2 = 435,
	B3_MA_TOVAL_RX1 = 436,
	B3_MA_TOVAL_RX2 = 437,
	B3_MA_TOVAL_TX1 = 438,
	B3_MA_TOVAL_TX2 = 439,
	B3_MA_TO_CTRL = 440,
	B3_MA_TO_TEST = 442,
	B3_MA_RCINI_RX1 = 448,
	B3_MA_RCINI_RX2 = 449,
	B3_MA_RCINI_TX1 = 450,
	B3_MA_RCINI_TX2 = 451,
	B3_MA_RCVAL_RX1 = 452,
	B3_MA_RCVAL_RX2 = 453,
	B3_MA_RCVAL_TX1 = 454,
	B3_MA_RCVAL_TX2 = 455,
	B3_MA_RC_CTRL = 456,
	B3_MA_RC_TEST = 458,
	B3_PA_TOINI_RX1 = 464,
	B3_PA_TOINI_RX2 = 468,
	B3_PA_TOINI_TX1 = 472,
	B3_PA_TOINI_TX2 = 476,
	B3_PA_TOVAL_RX1 = 480,
	B3_PA_TOVAL_RX2 = 484,
	B3_PA_TOVAL_TX1 = 488,
	B3_PA_TOVAL_TX2 = 492,
	B3_PA_CTRL = 496,
	B3_PA_TEST = 498,
	Y2_CFG_SPC = 7168,
	Y2_CFG_AER = 7424,
};

enum csr_target {
	MACRO_CTRL = 7,
};

enum css_task_iter_flags {
	CSS_TASK_ITER_PROCS = 1,
	CSS_TASK_ITER_THREADED = 2,
	CSS_TASK_ITER_SKIPPED = 65536,
};

enum cti_port_type {
	CTI_PORT_TYPE_NONE = 0,
	CTI_PORT_TYPE_RS232 = 1,
	CTI_PORT_TYPE_RS422_485 = 2,
	CTI_PORT_TYPE_RS232_422_485_HW = 3,
	CTI_PORT_TYPE_RS232_422_485_SW = 4,
	CTI_PORT_TYPE_RS232_422_485_4B = 5,
	CTI_PORT_TYPE_RS232_422_485_2B = 6,
	CTI_PORT_TYPE_MAX = 7,
};

enum ctx_state {
	CT_STATE_DISABLED = -1,
	CT_STATE_KERNEL = 0,
	CT_STATE_IDLE = 1,
	CT_STATE_USER = 2,
	CT_STATE_GUEST = 3,
	CT_STATE_MAX = 4,
};

enum cv1800_pin_io_type {
	IO_TYPE_1V8_ONLY = 0,
	IO_TYPE_1V8_OR_3V3 = 1,
	IO_TYPE_AUDIO = 2,
	IO_TYPE_ETH = 3,
};

enum cxl_event_type {
	CXL_CPER_EVENT_GENERIC = 0,
	CXL_CPER_EVENT_GEN_MEDIA = 1,
	CXL_CPER_EVENT_DRAM = 2,
	CXL_CPER_EVENT_MEM_MODULE = 3,
	CXL_CPER_EVENT_MEM_SPARING = 4,
};

enum d_real_type {
	D_REAL_DATA = 0,
	D_REAL_METADATA = 1,
};

enum d_walk_ret {
	D_WALK_CONTINUE = 0,
	D_WALK_QUIT = 1,
	D_WALK_NORETRY = 2,
	D_WALK_SKIP = 3,
};

enum data_content4 {
	NFS4_CONTENT_DATA = 0,
	NFS4_CONTENT_HOLE = 1,
};

enum data_source {
	CM_BATTERY_PRESENT = 0,
	CM_NO_BATTERY = 1,
	CM_FUEL_GAUGE = 2,
	CM_CHARGER_STAT = 3,
};

enum dbg_active_el {
	DBG_ACTIVE_EL0 = 0,
	DBG_ACTIVE_EL1 = 1,
};

enum dbgfs_get_mode {
	DBGFS_GET_ALREADY = 0,
	DBGFS_GET_REGULAR = 1,
	DBGFS_GET_SHORT = 2,
};

enum dd_data_dir {
	DD_READ = 0,
	DD_WRITE = 1,
};

enum dd_prio {
	DD_RT_PRIO = 0,
	DD_BE_PRIO = 1,
	DD_IDLE_PRIO = 2,
	DD_PRIO_MAX = 2,
};

enum debug_counters {
	SENT_OK = 0,
	SENT_FAIL = 1,
	SENT_FAIL_POLLING_UNSUPPORTED = 2,
	SENT_FAIL_CHANNEL_NOT_FOUND = 3,
	RESPONSE_OK = 4,
	NOTIFICATION_OK = 5,
	DELAYED_RESPONSE_OK = 6,
	XFERS_RESPONSE_TIMEOUT = 7,
	XFERS_RESPONSE_POLLED_TIMEOUT = 8,
	RESPONSE_POLLED_OK = 9,
	ERR_MSG_UNEXPECTED = 10,
	ERR_MSG_INVALID = 11,
	ERR_MSG_NOMEM = 12,
	ERR_PROTOCOL = 13,
	XFERS_INFLIGHT = 14,
	SCMI_DEBUG_COUNTERS_LAST = 15,
};

enum dentry_d_lock_class {
	DENTRY_D_LOCK_NORMAL = 0,
	DENTRY_D_LOCK_NESTED = 1,
};

enum dentry_flags {
	DCACHE_OP_HASH = 1,
	DCACHE_OP_COMPARE = 2,
	DCACHE_OP_REVALIDATE = 4,
	DCACHE_OP_DELETE = 8,
	DCACHE_OP_PRUNE = 16,
	DCACHE_DISCONNECTED = 32,
	DCACHE_REFERENCED = 64,
	DCACHE_DONTCACHE = 128,
	DCACHE_CANT_MOUNT = 256,
	DCACHE_GENOCIDE = 512,
	DCACHE_SHRINK_LIST = 1024,
	DCACHE_OP_WEAK_REVALIDATE = 2048,
	DCACHE_NFSFS_RENAMED = 4096,
	DCACHE_FSNOTIFY_PARENT_WATCHED = 8192,
	DCACHE_DENTRY_KILLED = 16384,
	DCACHE_MOUNTED = 32768,
	DCACHE_NEED_AUTOMOUNT = 65536,
	DCACHE_MANAGE_TRANSIT = 131072,
	DCACHE_LRU_LIST = 262144,
	DCACHE_ENTRY_TYPE = 3670016,
	DCACHE_MISS_TYPE = 0,
	DCACHE_WHITEOUT_TYPE = 524288,
	DCACHE_DIRECTORY_TYPE = 1048576,
	DCACHE_AUTODIR_TYPE = 1572864,
	DCACHE_REGULAR_TYPE = 2097152,
	DCACHE_SPECIAL_TYPE = 2621440,
	DCACHE_SYMLINK_TYPE = 3145728,
	DCACHE_NOKEY_NAME = 4194304,
	DCACHE_OP_REAL = 8388608,
	DCACHE_PAR_LOOKUP = 16777216,
	DCACHE_DENTRY_CURSOR = 33554432,
	DCACHE_NORCU = 67108864,
};

enum depot_counter_id {
	DEPOT_COUNTER_REFD_ALLOCS = 0,
	DEPOT_COUNTER_REFD_FREES = 1,
	DEPOT_COUNTER_REFD_INUSE = 2,
	DEPOT_COUNTER_FREELIST_SIZE = 3,
	DEPOT_COUNTER_PERSIST_COUNT = 4,
	DEPOT_COUNTER_PERSIST_BYTES = 5,
	DEPOT_COUNTER_COUNT = 6,
};

enum desc_header_offset {
	QUERY_DESC_LENGTH_OFFSET = 0,
	QUERY_DESC_DESC_TYPE_OFFSET = 1,
};

enum desc_id {
	AVE_DESCID_RX = 0,
	AVE_DESCID_TX = 1,
};

enum desc_idn {
	QUERY_DESC_IDN_DEVICE = 0,
	QUERY_DESC_IDN_CONFIGURATION = 1,
	QUERY_DESC_IDN_UNIT = 2,
	QUERY_DESC_IDN_RFU_0 = 3,
	QUERY_DESC_IDN_INTERCONNECT = 4,
	QUERY_DESC_IDN_STRING = 5,
	QUERY_DESC_IDN_RFU_1 = 6,
	QUERY_DESC_IDN_GEOMETRY = 7,
	QUERY_DESC_IDN_POWER = 8,
	QUERY_DESC_IDN_HEALTH = 9,
	QUERY_DESC_IDN_MAX = 10,
};

enum desc_state {
	desc_miss = -1,
	desc_reserved = 0,
	desc_committed = 1,
	desc_finalized = 2,
	desc_reusable = 3,
};

enum desc_state___2 {
	AVE_DESC_RX_PERMIT = 0,
	AVE_DESC_RX_SUSPEND = 1,
	AVE_DESC_START = 2,
	AVE_DESC_STOP = 3,
};

enum desc_status {
	FREE = 0,
	PREP = 1,
	BUSY = 2,
	PAUSED = 3,
	DONE___2 = 4,
};

enum dev_cmd_type {
	DEV_CMD_TYPE_NOP = 0,
	DEV_CMD_TYPE_QUERY = 1,
	DEV_CMD_TYPE_RPMB = 2,
};

enum dev_dma_attr {
	DEV_DMA_NOT_SUPPORTED = 0,
	DEV_DMA_NON_COHERENT = 1,
	DEV_DMA_COHERENT = 2,
};

enum dev_pm_opp_event {
	OPP_EVENT_ADD = 0,
	OPP_EVENT_REMOVE = 1,
	OPP_EVENT_ENABLE = 2,
	OPP_EVENT_DISABLE = 3,
	OPP_EVENT_ADJUST_VOLTAGE = 4,
};

enum dev_pm_qos_req_type {
	DEV_PM_QOS_RESUME_LATENCY = 1,
	DEV_PM_QOS_LATENCY_TOLERANCE = 2,
	DEV_PM_QOS_MIN_FREQUENCY = 3,
	DEV_PM_QOS_MAX_FREQUENCY = 4,
	DEV_PM_QOS_FLAGS = 5,
};

enum dev_prop_type {
	DEV_PROP_U8 = 0,
	DEV_PROP_U16 = 1,
	DEV_PROP_U32 = 2,
	DEV_PROP_U64 = 3,
	DEV_PROP_STRING = 4,
	DEV_PROP_REF = 5,
};

enum dev_status {
	HISI_SAS_DEV_INIT = 0,
	HISI_SAS_DEV_NORMAL = 1,
	HISI_SAS_DEV_NCQ_ERR = 2,
};

enum dev_type {
	DEV_UNKNOWN = 0,
	DEV_X1 = 1,
	DEV_X2 = 2,
	DEV_X4 = 3,
	DEV_X8 = 4,
	DEV_X16 = 5,
	DEV_X32 = 6,
	DEV_X64 = 7,
};

enum devcg_behavior {
	DEVCG_DEFAULT_NONE = 0,
	DEVCG_DEFAULT_ALLOW = 1,
	DEVCG_DEFAULT_DENY = 2,
};

enum devfreq_parent_dev_type {
	DEVFREQ_PARENT_DEV = 0,
	CPUFREQ_PARENT_DEV = 1,
};

enum devfreq_timer {
	DEVFREQ_TIMER_DEFERRABLE = 0,
	DEVFREQ_TIMER_DELAYED = 1,
	DEVFREQ_TIMER_NUM = 2,
};

enum device_desc_param {
	DEVICE_DESC_PARAM_LEN = 0,
	DEVICE_DESC_PARAM_TYPE = 1,
	DEVICE_DESC_PARAM_DEVICE_TYPE = 2,
	DEVICE_DESC_PARAM_DEVICE_CLASS = 3,
	DEVICE_DESC_PARAM_DEVICE_SUB_CLASS = 4,
	DEVICE_DESC_PARAM_PRTCL = 5,
	DEVICE_DESC_PARAM_NUM_LU = 6,
	DEVICE_DESC_PARAM_NUM_WLU = 7,
	DEVICE_DESC_PARAM_BOOT_ENBL = 8,
	DEVICE_DESC_PARAM_DESC_ACCSS_ENBL = 9,
	DEVICE_DESC_PARAM_INIT_PWR_MODE = 10,
	DEVICE_DESC_PARAM_HIGH_PR_LUN = 11,
	DEVICE_DESC_PARAM_SEC_RMV_TYPE = 12,
	DEVICE_DESC_PARAM_SEC_LU = 13,
	DEVICE_DESC_PARAM_BKOP_TERM_LT = 14,
	DEVICE_DESC_PARAM_ACTVE_ICC_LVL = 15,
	DEVICE_DESC_PARAM_SPEC_VER = 16,
	DEVICE_DESC_PARAM_MANF_DATE = 18,
	DEVICE_DESC_PARAM_MANF_NAME = 20,
	DEVICE_DESC_PARAM_PRDCT_NAME = 21,
	DEVICE_DESC_PARAM_SN = 22,
	DEVICE_DESC_PARAM_OEM_ID = 23,
	DEVICE_DESC_PARAM_MANF_ID = 24,
	DEVICE_DESC_PARAM_UD_OFFSET = 26,
	DEVICE_DESC_PARAM_UD_LEN = 27,
	DEVICE_DESC_PARAM_RTT_CAP = 28,
	DEVICE_DESC_PARAM_FRQ_RTC = 29,
	DEVICE_DESC_PARAM_UFS_FEAT = 31,
	DEVICE_DESC_PARAM_FFU_TMT = 32,
	DEVICE_DESC_PARAM_Q_DPTH = 33,
	DEVICE_DESC_PARAM_DEV_VER = 34,
	DEVICE_DESC_PARAM_NUM_SEC_WPA = 36,
	DEVICE_DESC_PARAM_PSA_MAX_DATA = 37,
	DEVICE_DESC_PARAM_PSA_TMT = 41,
	DEVICE_DESC_PARAM_PRDCT_REV = 42,
	DEVICE_DESC_PARAM_HPB_VER = 64,
	DEVICE_DESC_PARAM_HPB_CONTROL = 66,
	DEVICE_DESC_PARAM_EXT_WB_SUP = 77,
	DEVICE_DESC_PARAM_EXT_UFS_FEATURE_SUP = 79,
	DEVICE_DESC_PARAM_WB_PRESRV_USRSPC_EN = 83,
	DEVICE_DESC_PARAM_WB_TYPE = 84,
	DEVICE_DESC_PARAM_WB_SHARED_ALLOC_UNITS = 85,
};

enum device_id {
	MAX8973 = 0,
	MAX77621 = 1,
};

enum device_link_state {
	DL_STATE_NONE = -1,
	DL_STATE_DORMANT = 0,
	DL_STATE_AVAILABLE = 1,
	DL_STATE_CONSUMER_PROBE = 2,
	DL_STATE_ACTIVE = 3,
	DL_STATE_SUPPLIER_UNBIND = 4,
};

enum device_physical_location_horizontal_position {
	DEVICE_HORI_POS_LEFT = 0,
	DEVICE_HORI_POS_CENTER = 1,
	DEVICE_HORI_POS_RIGHT = 2,
};

enum device_physical_location_panel {
	DEVICE_PANEL_TOP = 0,
	DEVICE_PANEL_BOTTOM = 1,
	DEVICE_PANEL_LEFT = 2,
	DEVICE_PANEL_RIGHT = 3,
	DEVICE_PANEL_FRONT = 4,
	DEVICE_PANEL_BACK = 5,
	DEVICE_PANEL_UNKNOWN = 6,
};

enum device_physical_location_vertical_position {
	DEVICE_VERT_POS_UPPER = 0,
	DEVICE_VERT_POS_CENTER = 1,
	DEVICE_VERT_POS_LOWER = 2,
};

enum device_removable {
	DEVICE_REMOVABLE_NOT_SUPPORTED = 0,
	DEVICE_REMOVABLE_UNKNOWN = 1,
	DEVICE_FIXED = 2,
	DEVICE_REMOVABLE = 3,
};

enum devkmsg_log_masks {
	DEVKMSG_LOG_MASK_ON = 1,
	DEVKMSG_LOG_MASK_OFF = 2,
	DEVKMSG_LOG_MASK_LOCK = 4,
};

enum devlink_attr {
	DEVLINK_ATTR_UNSPEC = 0,
	DEVLINK_ATTR_BUS_NAME = 1,
	DEVLINK_ATTR_DEV_NAME = 2,
	DEVLINK_ATTR_PORT_INDEX = 3,
	DEVLINK_ATTR_PORT_TYPE = 4,
	DEVLINK_ATTR_PORT_DESIRED_TYPE = 5,
	DEVLINK_ATTR_PORT_NETDEV_IFINDEX = 6,
	DEVLINK_ATTR_PORT_NETDEV_NAME = 7,
	DEVLINK_ATTR_PORT_IBDEV_NAME = 8,
	DEVLINK_ATTR_PORT_SPLIT_COUNT = 9,
	DEVLINK_ATTR_PORT_SPLIT_GROUP = 10,
	DEVLINK_ATTR_SB_INDEX = 11,
	DEVLINK_ATTR_SB_SIZE = 12,
	DEVLINK_ATTR_SB_INGRESS_POOL_COUNT = 13,
	DEVLINK_ATTR_SB_EGRESS_POOL_COUNT = 14,
	DEVLINK_ATTR_SB_INGRESS_TC_COUNT = 15,
	DEVLINK_ATTR_SB_EGRESS_TC_COUNT = 16,
	DEVLINK_ATTR_SB_POOL_INDEX = 17,
	DEVLINK_ATTR_SB_POOL_TYPE = 18,
	DEVLINK_ATTR_SB_POOL_SIZE = 19,
	DEVLINK_ATTR_SB_POOL_THRESHOLD_TYPE = 20,
	DEVLINK_ATTR_SB_THRESHOLD = 21,
	DEVLINK_ATTR_SB_TC_INDEX = 22,
	DEVLINK_ATTR_SB_OCC_CUR = 23,
	DEVLINK_ATTR_SB_OCC_MAX = 24,
	DEVLINK_ATTR_ESWITCH_MODE = 25,
	DEVLINK_ATTR_ESWITCH_INLINE_MODE = 26,
	DEVLINK_ATTR_DPIPE_TABLES = 27,
	DEVLINK_ATTR_DPIPE_TABLE = 28,
	DEVLINK_ATTR_DPIPE_TABLE_NAME = 29,
	DEVLINK_ATTR_DPIPE_TABLE_SIZE = 30,
	DEVLINK_ATTR_DPIPE_TABLE_MATCHES = 31,
	DEVLINK_ATTR_DPIPE_TABLE_ACTIONS = 32,
	DEVLINK_ATTR_DPIPE_TABLE_COUNTERS_ENABLED = 33,
	DEVLINK_ATTR_DPIPE_ENTRIES = 34,
	DEVLINK_ATTR_DPIPE_ENTRY = 35,
	DEVLINK_ATTR_DPIPE_ENTRY_INDEX = 36,
	DEVLINK_ATTR_DPIPE_ENTRY_MATCH_VALUES = 37,
	DEVLINK_ATTR_DPIPE_ENTRY_ACTION_VALUES = 38,
	DEVLINK_ATTR_DPIPE_ENTRY_COUNTER = 39,
	DEVLINK_ATTR_DPIPE_MATCH = 40,
	DEVLINK_ATTR_DPIPE_MATCH_VALUE = 41,
	DEVLINK_ATTR_DPIPE_MATCH_TYPE = 42,
	DEVLINK_ATTR_DPIPE_ACTION = 43,
	DEVLINK_ATTR_DPIPE_ACTION_VALUE = 44,
	DEVLINK_ATTR_DPIPE_ACTION_TYPE = 45,
	DEVLINK_ATTR_DPIPE_VALUE = 46,
	DEVLINK_ATTR_DPIPE_VALUE_MASK = 47,
	DEVLINK_ATTR_DPIPE_VALUE_MAPPING = 48,
	DEVLINK_ATTR_DPIPE_HEADERS = 49,
	DEVLINK_ATTR_DPIPE_HEADER = 50,
	DEVLINK_ATTR_DPIPE_HEADER_NAME = 51,
	DEVLINK_ATTR_DPIPE_HEADER_ID = 52,
	DEVLINK_ATTR_DPIPE_HEADER_FIELDS = 53,
	DEVLINK_ATTR_DPIPE_HEADER_GLOBAL = 54,
	DEVLINK_ATTR_DPIPE_HEADER_INDEX = 55,
	DEVLINK_ATTR_DPIPE_FIELD = 56,
	DEVLINK_ATTR_DPIPE_FIELD_NAME = 57,
	DEVLINK_ATTR_DPIPE_FIELD_ID = 58,
	DEVLINK_ATTR_DPIPE_FIELD_BITWIDTH = 59,
	DEVLINK_ATTR_DPIPE_FIELD_MAPPING_TYPE = 60,
	DEVLINK_ATTR_PAD = 61,
	DEVLINK_ATTR_ESWITCH_ENCAP_MODE = 62,
	DEVLINK_ATTR_RESOURCE_LIST = 63,
	DEVLINK_ATTR_RESOURCE = 64,
	DEVLINK_ATTR_RESOURCE_NAME = 65,
	DEVLINK_ATTR_RESOURCE_ID = 66,
	DEVLINK_ATTR_RESOURCE_SIZE = 67,
	DEVLINK_ATTR_RESOURCE_SIZE_NEW = 68,
	DEVLINK_ATTR_RESOURCE_SIZE_VALID = 69,
	DEVLINK_ATTR_RESOURCE_SIZE_MIN = 70,
	DEVLINK_ATTR_RESOURCE_SIZE_MAX = 71,
	DEVLINK_ATTR_RESOURCE_SIZE_GRAN = 72,
	DEVLINK_ATTR_RESOURCE_UNIT = 73,
	DEVLINK_ATTR_RESOURCE_OCC = 74,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_ID = 75,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_UNITS = 76,
	DEVLINK_ATTR_PORT_FLAVOUR = 77,
	DEVLINK_ATTR_PORT_NUMBER = 78,
	DEVLINK_ATTR_PORT_SPLIT_SUBPORT_NUMBER = 79,
	DEVLINK_ATTR_PARAM = 80,
	DEVLINK_ATTR_PARAM_NAME = 81,
	DEVLINK_ATTR_PARAM_GENERIC = 82,
	DEVLINK_ATTR_PARAM_TYPE = 83,
	DEVLINK_ATTR_PARAM_VALUES_LIST = 84,
	DEVLINK_ATTR_PARAM_VALUE = 85,
	DEVLINK_ATTR_PARAM_VALUE_DATA = 86,
	DEVLINK_ATTR_PARAM_VALUE_CMODE = 87,
	DEVLINK_ATTR_REGION_NAME = 88,
	DEVLINK_ATTR_REGION_SIZE = 89,
	DEVLINK_ATTR_REGION_SNAPSHOTS = 90,
	DEVLINK_ATTR_REGION_SNAPSHOT = 91,
	DEVLINK_ATTR_REGION_SNAPSHOT_ID = 92,
	DEVLINK_ATTR_REGION_CHUNKS = 93,
	DEVLINK_ATTR_REGION_CHUNK = 94,
	DEVLINK_ATTR_REGION_CHUNK_DATA = 95,
	DEVLINK_ATTR_REGION_CHUNK_ADDR = 96,
	DEVLINK_ATTR_REGION_CHUNK_LEN = 97,
	DEVLINK_ATTR_INFO_DRIVER_NAME = 98,
	DEVLINK_ATTR_INFO_SERIAL_NUMBER = 99,
	DEVLINK_ATTR_INFO_VERSION_FIXED = 100,
	DEVLINK_ATTR_INFO_VERSION_RUNNING = 101,
	DEVLINK_ATTR_INFO_VERSION_STORED = 102,
	DEVLINK_ATTR_INFO_VERSION_NAME = 103,
	DEVLINK_ATTR_INFO_VERSION_VALUE = 104,
	DEVLINK_ATTR_SB_POOL_CELL_SIZE = 105,
	DEVLINK_ATTR_FMSG = 106,
	DEVLINK_ATTR_FMSG_OBJ_NEST_START = 107,
	DEVLINK_ATTR_FMSG_PAIR_NEST_START = 108,
	DEVLINK_ATTR_FMSG_ARR_NEST_START = 109,
	DEVLINK_ATTR_FMSG_NEST_END = 110,
	DEVLINK_ATTR_FMSG_OBJ_NAME = 111,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_TYPE = 112,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_DATA = 113,
	DEVLINK_ATTR_HEALTH_REPORTER = 114,
	DEVLINK_ATTR_HEALTH_REPORTER_NAME = 115,
	DEVLINK_ATTR_HEALTH_REPORTER_STATE = 116,
	DEVLINK_ATTR_HEALTH_REPORTER_ERR_COUNT = 117,
	DEVLINK_ATTR_HEALTH_REPORTER_RECOVER_COUNT = 118,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS = 119,
	DEVLINK_ATTR_HEALTH_REPORTER_GRACEFUL_PERIOD = 120,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_RECOVER = 121,
	DEVLINK_ATTR_FLASH_UPDATE_FILE_NAME = 122,
	DEVLINK_ATTR_FLASH_UPDATE_COMPONENT = 123,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_MSG = 124,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_DONE = 125,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TOTAL = 126,
	DEVLINK_ATTR_PORT_PCI_PF_NUMBER = 127,
	DEVLINK_ATTR_PORT_PCI_VF_NUMBER = 128,
	DEVLINK_ATTR_STATS = 129,
	DEVLINK_ATTR_TRAP_NAME = 130,
	DEVLINK_ATTR_TRAP_ACTION = 131,
	DEVLINK_ATTR_TRAP_TYPE = 132,
	DEVLINK_ATTR_TRAP_GENERIC = 133,
	DEVLINK_ATTR_TRAP_METADATA = 134,
	DEVLINK_ATTR_TRAP_GROUP_NAME = 135,
	DEVLINK_ATTR_RELOAD_FAILED = 136,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS_NS = 137,
	DEVLINK_ATTR_NETNS_FD = 138,
	DEVLINK_ATTR_NETNS_PID = 139,
	DEVLINK_ATTR_NETNS_ID = 140,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_DUMP = 141,
	DEVLINK_ATTR_TRAP_POLICER_ID = 142,
	DEVLINK_ATTR_TRAP_POLICER_RATE = 143,
	DEVLINK_ATTR_TRAP_POLICER_BURST = 144,
	DEVLINK_ATTR_PORT_FUNCTION = 145,
	DEVLINK_ATTR_INFO_BOARD_SERIAL_NUMBER = 146,
	DEVLINK_ATTR_PORT_LANES = 147,
	DEVLINK_ATTR_PORT_SPLITTABLE = 148,
	DEVLINK_ATTR_PORT_EXTERNAL = 149,
	DEVLINK_ATTR_PORT_CONTROLLER_NUMBER = 150,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TIMEOUT = 151,
	DEVLINK_ATTR_FLASH_UPDATE_OVERWRITE_MASK = 152,
	DEVLINK_ATTR_RELOAD_ACTION = 153,
	DEVLINK_ATTR_RELOAD_ACTIONS_PERFORMED = 154,
	DEVLINK_ATTR_RELOAD_LIMITS = 155,
	DEVLINK_ATTR_DEV_STATS = 156,
	DEVLINK_ATTR_RELOAD_STATS = 157,
	DEVLINK_ATTR_RELOAD_STATS_ENTRY = 158,
	DEVLINK_ATTR_RELOAD_STATS_LIMIT = 159,
	DEVLINK_ATTR_RELOAD_STATS_VALUE = 160,
	DEVLINK_ATTR_REMOTE_RELOAD_STATS = 161,
	DEVLINK_ATTR_RELOAD_ACTION_INFO = 162,
	DEVLINK_ATTR_RELOAD_ACTION_STATS = 163,
	DEVLINK_ATTR_PORT_PCI_SF_NUMBER = 164,
	DEVLINK_ATTR_RATE_TYPE = 165,
	DEVLINK_ATTR_RATE_TX_SHARE = 166,
	DEVLINK_ATTR_RATE_TX_MAX = 167,
	DEVLINK_ATTR_RATE_NODE_NAME = 168,
	DEVLINK_ATTR_RATE_PARENT_NODE_NAME = 169,
	DEVLINK_ATTR_REGION_MAX_SNAPSHOTS = 170,
	DEVLINK_ATTR_LINECARD_INDEX = 171,
	DEVLINK_ATTR_LINECARD_STATE = 172,
	DEVLINK_ATTR_LINECARD_TYPE = 173,
	DEVLINK_ATTR_LINECARD_SUPPORTED_TYPES = 174,
	DEVLINK_ATTR_NESTED_DEVLINK = 175,
	DEVLINK_ATTR_SELFTESTS = 176,
	DEVLINK_ATTR_RATE_TX_PRIORITY = 177,
	DEVLINK_ATTR_RATE_TX_WEIGHT = 178,
	DEVLINK_ATTR_REGION_DIRECT = 179,
	DEVLINK_ATTR_RATE_TC_BWS = 180,
	DEVLINK_ATTR_HEALTH_REPORTER_BURST_PERIOD = 181,
	__DEVLINK_ATTR_MAX = 182,
	DEVLINK_ATTR_MAX = 181,
};

enum devlink_attr_selftest_id {
	DEVLINK_ATTR_SELFTEST_ID_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_ID_FLASH = 1,
	__DEVLINK_ATTR_SELFTEST_ID_MAX = 2,
	DEVLINK_ATTR_SELFTEST_ID_MAX = 1,
};

enum devlink_attr_selftest_result {
	DEVLINK_ATTR_SELFTEST_RESULT_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_RESULT = 1,
	DEVLINK_ATTR_SELFTEST_RESULT_ID = 2,
	DEVLINK_ATTR_SELFTEST_RESULT_STATUS = 3,
	__DEVLINK_ATTR_SELFTEST_RESULT_MAX = 4,
	DEVLINK_ATTR_SELFTEST_RESULT_MAX = 3,
};

enum devlink_command {
	DEVLINK_CMD_UNSPEC = 0,
	DEVLINK_CMD_GET = 1,
	DEVLINK_CMD_SET = 2,
	DEVLINK_CMD_NEW = 3,
	DEVLINK_CMD_DEL = 4,
	DEVLINK_CMD_PORT_GET = 5,
	DEVLINK_CMD_PORT_SET = 6,
	DEVLINK_CMD_PORT_NEW = 7,
	DEVLINK_CMD_PORT_DEL = 8,
	DEVLINK_CMD_PORT_SPLIT = 9,
	DEVLINK_CMD_PORT_UNSPLIT = 10,
	DEVLINK_CMD_SB_GET = 11,
	DEVLINK_CMD_SB_SET = 12,
	DEVLINK_CMD_SB_NEW = 13,
	DEVLINK_CMD_SB_DEL = 14,
	DEVLINK_CMD_SB_POOL_GET = 15,
	DEVLINK_CMD_SB_POOL_SET = 16,
	DEVLINK_CMD_SB_POOL_NEW = 17,
	DEVLINK_CMD_SB_POOL_DEL = 18,
	DEVLINK_CMD_SB_PORT_POOL_GET = 19,
	DEVLINK_CMD_SB_PORT_POOL_SET = 20,
	DEVLINK_CMD_SB_PORT_POOL_NEW = 21,
	DEVLINK_CMD_SB_PORT_POOL_DEL = 22,
	DEVLINK_CMD_SB_TC_POOL_BIND_GET = 23,
	DEVLINK_CMD_SB_TC_POOL_BIND_SET = 24,
	DEVLINK_CMD_SB_TC_POOL_BIND_NEW = 25,
	DEVLINK_CMD_SB_TC_POOL_BIND_DEL = 26,
	DEVLINK_CMD_SB_OCC_SNAPSHOT = 27,
	DEVLINK_CMD_SB_OCC_MAX_CLEAR = 28,
	DEVLINK_CMD_ESWITCH_GET = 29,
	DEVLINK_CMD_ESWITCH_SET = 30,
	DEVLINK_CMD_DPIPE_TABLE_GET = 31,
	DEVLINK_CMD_DPIPE_ENTRIES_GET = 32,
	DEVLINK_CMD_DPIPE_HEADERS_GET = 33,
	DEVLINK_CMD_DPIPE_TABLE_COUNTERS_SET = 34,
	DEVLINK_CMD_RESOURCE_SET = 35,
	DEVLINK_CMD_RESOURCE_DUMP = 36,
	DEVLINK_CMD_RELOAD = 37,
	DEVLINK_CMD_PARAM_GET = 38,
	DEVLINK_CMD_PARAM_SET = 39,
	DEVLINK_CMD_PARAM_NEW = 40,
	DEVLINK_CMD_PARAM_DEL = 41,
	DEVLINK_CMD_REGION_GET = 42,
	DEVLINK_CMD_REGION_SET = 43,
	DEVLINK_CMD_REGION_NEW = 44,
	DEVLINK_CMD_REGION_DEL = 45,
	DEVLINK_CMD_REGION_READ = 46,
	DEVLINK_CMD_PORT_PARAM_GET = 47,
	DEVLINK_CMD_PORT_PARAM_SET = 48,
	DEVLINK_CMD_PORT_PARAM_NEW = 49,
	DEVLINK_CMD_PORT_PARAM_DEL = 50,
	DEVLINK_CMD_INFO_GET = 51,
	DEVLINK_CMD_HEALTH_REPORTER_GET = 52,
	DEVLINK_CMD_HEALTH_REPORTER_SET = 53,
	DEVLINK_CMD_HEALTH_REPORTER_RECOVER = 54,
	DEVLINK_CMD_HEALTH_REPORTER_DIAGNOSE = 55,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_GET = 56,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_CLEAR = 57,
	DEVLINK_CMD_FLASH_UPDATE = 58,
	DEVLINK_CMD_FLASH_UPDATE_END = 59,
	DEVLINK_CMD_FLASH_UPDATE_STATUS = 60,
	DEVLINK_CMD_TRAP_GET = 61,
	DEVLINK_CMD_TRAP_SET = 62,
	DEVLINK_CMD_TRAP_NEW = 63,
	DEVLINK_CMD_TRAP_DEL = 64,
	DEVLINK_CMD_TRAP_GROUP_GET = 65,
	DEVLINK_CMD_TRAP_GROUP_SET = 66,
	DEVLINK_CMD_TRAP_GROUP_NEW = 67,
	DEVLINK_CMD_TRAP_GROUP_DEL = 68,
	DEVLINK_CMD_TRAP_POLICER_GET = 69,
	DEVLINK_CMD_TRAP_POLICER_SET = 70,
	DEVLINK_CMD_TRAP_POLICER_NEW = 71,
	DEVLINK_CMD_TRAP_POLICER_DEL = 72,
	DEVLINK_CMD_HEALTH_REPORTER_TEST = 73,
	DEVLINK_CMD_RATE_GET = 74,
	DEVLINK_CMD_RATE_SET = 75,
	DEVLINK_CMD_RATE_NEW = 76,
	DEVLINK_CMD_RATE_DEL = 77,
	DEVLINK_CMD_LINECARD_GET = 78,
	DEVLINK_CMD_LINECARD_SET = 79,
	DEVLINK_CMD_LINECARD_NEW = 80,
	DEVLINK_CMD_LINECARD_DEL = 81,
	DEVLINK_CMD_SELFTESTS_GET = 82,
	DEVLINK_CMD_SELFTESTS_RUN = 83,
	DEVLINK_CMD_NOTIFY_FILTER_SET = 84,
	__DEVLINK_CMD_MAX = 85,
	DEVLINK_CMD_MAX = 84,
};

enum devlink_dpipe_action_type {
	DEVLINK_DPIPE_ACTION_TYPE_FIELD_MODIFY = 0,
};

enum devlink_dpipe_field_mapping_type {
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_NONE = 0,
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_IFINDEX = 1,
};

enum devlink_dpipe_match_type {
	DEVLINK_DPIPE_MATCH_TYPE_FIELD_EXACT = 0,
};

enum devlink_eswitch_encap_mode {
	DEVLINK_ESWITCH_ENCAP_MODE_NONE = 0,
	DEVLINK_ESWITCH_ENCAP_MODE_BASIC = 1,
};

enum devlink_health_reporter_state {
	DEVLINK_HEALTH_REPORTER_STATE_HEALTHY = 0,
	DEVLINK_HEALTH_REPORTER_STATE_ERROR = 1,
};

enum devlink_info_version_type {
	DEVLINK_INFO_VERSION_TYPE_NONE = 0,
	DEVLINK_INFO_VERSION_TYPE_COMPONENT = 1,
};

enum devlink_linecard_state {
	DEVLINK_LINECARD_STATE_UNSPEC = 0,
	DEVLINK_LINECARD_STATE_UNPROVISIONED = 1,
	DEVLINK_LINECARD_STATE_UNPROVISIONING = 2,
	DEVLINK_LINECARD_STATE_PROVISIONING = 3,
	DEVLINK_LINECARD_STATE_PROVISIONING_FAILED = 4,
	DEVLINK_LINECARD_STATE_PROVISIONED = 5,
	DEVLINK_LINECARD_STATE_ACTIVE = 6,
	__DEVLINK_LINECARD_STATE_MAX = 7,
	DEVLINK_LINECARD_STATE_MAX = 6,
};

enum devlink_multicast_groups {
	DEVLINK_MCGRP_CONFIG = 0,
};

enum devlink_param_cmode {
	DEVLINK_PARAM_CMODE_RUNTIME = 0,
	DEVLINK_PARAM_CMODE_DRIVERINIT = 1,
	DEVLINK_PARAM_CMODE_PERMANENT = 2,
	__DEVLINK_PARAM_CMODE_MAX = 3,
	DEVLINK_PARAM_CMODE_MAX = 2,
};

enum devlink_param_generic_id {
	DEVLINK_PARAM_GENERIC_ID_INT_ERR_RESET = 0,
	DEVLINK_PARAM_GENERIC_ID_MAX_MACS = 1,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_SRIOV = 2,
	DEVLINK_PARAM_GENERIC_ID_REGION_SNAPSHOT = 3,
	DEVLINK_PARAM_GENERIC_ID_IGNORE_ARI = 4,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MAX = 5,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MIN = 6,
	DEVLINK_PARAM_GENERIC_ID_FW_LOAD_POLICY = 7,
	DEVLINK_PARAM_GENERIC_ID_RESET_DEV_ON_DRV_PROBE = 8,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ROCE = 9,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_REMOTE_DEV_RESET = 10,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ETH = 11,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_RDMA = 12,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_VNET = 13,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_IWARP = 14,
	DEVLINK_PARAM_GENERIC_ID_IO_EQ_SIZE = 15,
	DEVLINK_PARAM_GENERIC_ID_EVENT_EQ_SIZE = 16,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_PHC = 17,
	DEVLINK_PARAM_GENERIC_ID_CLOCK_ID = 18,
	DEVLINK_PARAM_GENERIC_ID_TOTAL_VFS = 19,
	DEVLINK_PARAM_GENERIC_ID_NUM_DOORBELLS = 20,
	__DEVLINK_PARAM_GENERIC_ID_MAX = 21,
	DEVLINK_PARAM_GENERIC_ID_MAX = 20,
};

enum devlink_param_type {
	DEVLINK_PARAM_TYPE_U8 = 1,
	DEVLINK_PARAM_TYPE_U16 = 2,
	DEVLINK_PARAM_TYPE_U32 = 3,
	DEVLINK_PARAM_TYPE_U64 = 4,
	DEVLINK_PARAM_TYPE_STRING = 5,
	DEVLINK_PARAM_TYPE_BOOL = 6,
};

enum devlink_port_flavour {
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0,
	DEVLINK_PORT_FLAVOUR_CPU = 1,
	DEVLINK_PORT_FLAVOUR_DSA = 2,
	DEVLINK_PORT_FLAVOUR_PCI_PF = 3,
	DEVLINK_PORT_FLAVOUR_PCI_VF = 4,
	DEVLINK_PORT_FLAVOUR_VIRTUAL = 5,
	DEVLINK_PORT_FLAVOUR_UNUSED = 6,
	DEVLINK_PORT_FLAVOUR_PCI_SF = 7,
};

enum devlink_port_fn_attr_cap {
	DEVLINK_PORT_FN_ATTR_CAP_ROCE_BIT = 0,
	DEVLINK_PORT_FN_ATTR_CAP_MIGRATABLE_BIT = 1,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_CRYPTO_BIT = 2,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_PACKET_BIT = 3,
	__DEVLINK_PORT_FN_ATTR_CAPS_MAX = 4,
};

enum devlink_port_fn_opstate {
	DEVLINK_PORT_FN_OPSTATE_DETACHED = 0,
	DEVLINK_PORT_FN_OPSTATE_ATTACHED = 1,
};

enum devlink_port_fn_state {
	DEVLINK_PORT_FN_STATE_INACTIVE = 0,
	DEVLINK_PORT_FN_STATE_ACTIVE = 1,
};

enum devlink_port_function_attr {
	DEVLINK_PORT_FUNCTION_ATTR_UNSPEC = 0,
	DEVLINK_PORT_FUNCTION_ATTR_HW_ADDR = 1,
	DEVLINK_PORT_FN_ATTR_STATE = 2,
	DEVLINK_PORT_FN_ATTR_OPSTATE = 3,
	DEVLINK_PORT_FN_ATTR_CAPS = 4,
	DEVLINK_PORT_FN_ATTR_DEVLINK = 5,
	DEVLINK_PORT_FN_ATTR_MAX_IO_EQS = 6,
	__DEVLINK_PORT_FUNCTION_ATTR_MAX = 7,
	DEVLINK_PORT_FUNCTION_ATTR_MAX = 6,
};

enum devlink_port_type {
	DEVLINK_PORT_TYPE_NOTSET = 0,
	DEVLINK_PORT_TYPE_AUTO = 1,
	DEVLINK_PORT_TYPE_ETH = 2,
	DEVLINK_PORT_TYPE_IB = 3,
};

enum devlink_rate_tc_attr {
	DEVLINK_RATE_TC_ATTR_UNSPEC = 0,
	DEVLINK_RATE_TC_ATTR_INDEX = 1,
	DEVLINK_RATE_TC_ATTR_BW = 2,
	__DEVLINK_RATE_TC_ATTR_MAX = 3,
	DEVLINK_RATE_TC_ATTR_MAX = 2,
};

enum devlink_rate_type {
	DEVLINK_RATE_TYPE_LEAF = 0,
	DEVLINK_RATE_TYPE_NODE = 1,
};

enum devlink_reload_action {
	DEVLINK_RELOAD_ACTION_UNSPEC = 0,
	DEVLINK_RELOAD_ACTION_DRIVER_REINIT = 1,
	DEVLINK_RELOAD_ACTION_FW_ACTIVATE = 2,
	__DEVLINK_RELOAD_ACTION_MAX = 3,
	DEVLINK_RELOAD_ACTION_MAX = 2,
};

enum devlink_reload_limit {
	DEVLINK_RELOAD_LIMIT_UNSPEC = 0,
	DEVLINK_RELOAD_LIMIT_NO_RESET = 1,
	__DEVLINK_RELOAD_LIMIT_MAX = 2,
	DEVLINK_RELOAD_LIMIT_MAX = 1,
};

enum devlink_resource_unit {
	DEVLINK_RESOURCE_UNIT_ENTRY = 0,
};

enum devlink_sb_pool_type {
	DEVLINK_SB_POOL_TYPE_INGRESS = 0,
	DEVLINK_SB_POOL_TYPE_EGRESS = 1,
};

enum devlink_sb_threshold_type {
	DEVLINK_SB_THRESHOLD_TYPE_STATIC = 0,
	DEVLINK_SB_THRESHOLD_TYPE_DYNAMIC = 1,
};

enum devlink_selftest_status {
	DEVLINK_SELFTEST_STATUS_SKIP = 0,
	DEVLINK_SELFTEST_STATUS_PASS = 1,
	DEVLINK_SELFTEST_STATUS_FAIL = 2,
};

enum devlink_trap_action {
	DEVLINK_TRAP_ACTION_DROP = 0,
	DEVLINK_TRAP_ACTION_TRAP = 1,
	DEVLINK_TRAP_ACTION_MIRROR = 2,
};

enum devlink_trap_generic_id {
	DEVLINK_TRAP_GENERIC_ID_SMAC_MC = 0,
	DEVLINK_TRAP_GENERIC_ID_VLAN_TAG_MISMATCH = 1,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_VLAN_FILTER = 2,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_STP_FILTER = 3,
	DEVLINK_TRAP_GENERIC_ID_EMPTY_TX_LIST = 4,
	DEVLINK_TRAP_GENERIC_ID_PORT_LOOPBACK_FILTER = 5,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_ROUTE = 6,
	DEVLINK_TRAP_GENERIC_ID_TTL_ERROR = 7,
	DEVLINK_TRAP_GENERIC_ID_TAIL_DROP = 8,
	DEVLINK_TRAP_GENERIC_ID_NON_IP_PACKET = 9,
	DEVLINK_TRAP_GENERIC_ID_UC_DIP_MC_DMAC = 10,
	DEVLINK_TRAP_GENERIC_ID_DIP_LB = 11,
	DEVLINK_TRAP_GENERIC_ID_SIP_MC = 12,
	DEVLINK_TRAP_GENERIC_ID_SIP_LB = 13,
	DEVLINK_TRAP_GENERIC_ID_CORRUPTED_IP_HDR = 14,
	DEVLINK_TRAP_GENERIC_ID_IPV4_SIP_BC = 15,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_RESERVED_SCOPE = 16,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_INTERFACE_LOCAL_SCOPE = 17,
	DEVLINK_TRAP_GENERIC_ID_MTU_ERROR = 18,
	DEVLINK_TRAP_GENERIC_ID_UNRESOLVED_NEIGH = 19,
	DEVLINK_TRAP_GENERIC_ID_RPF = 20,
	DEVLINK_TRAP_GENERIC_ID_REJECT_ROUTE = 21,
	DEVLINK_TRAP_GENERIC_ID_IPV4_LPM_UNICAST_MISS = 22,
	DEVLINK_TRAP_GENERIC_ID_IPV6_LPM_UNICAST_MISS = 23,
	DEVLINK_TRAP_GENERIC_ID_NON_ROUTABLE = 24,
	DEVLINK_TRAP_GENERIC_ID_DECAP_ERROR = 25,
	DEVLINK_TRAP_GENERIC_ID_OVERLAY_SMAC_MC = 26,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_FLOW_ACTION_DROP = 27,
	DEVLINK_TRAP_GENERIC_ID_EGRESS_FLOW_ACTION_DROP = 28,
	DEVLINK_TRAP_GENERIC_ID_STP = 29,
	DEVLINK_TRAP_GENERIC_ID_LACP = 30,
	DEVLINK_TRAP_GENERIC_ID_LLDP = 31,
	DEVLINK_TRAP_GENERIC_ID_IGMP_QUERY = 32,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V1_REPORT = 33,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_REPORT = 34,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V3_REPORT = 35,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_LEAVE = 36,
	DEVLINK_TRAP_GENERIC_ID_MLD_QUERY = 37,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_REPORT = 38,
	DEVLINK_TRAP_GENERIC_ID_MLD_V2_REPORT = 39,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_DONE = 40,
	DEVLINK_TRAP_GENERIC_ID_IPV4_DHCP = 41,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DHCP = 42,
	DEVLINK_TRAP_GENERIC_ID_ARP_REQUEST = 43,
	DEVLINK_TRAP_GENERIC_ID_ARP_RESPONSE = 44,
	DEVLINK_TRAP_GENERIC_ID_ARP_OVERLAY = 45,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_SOLICIT = 46,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_ADVERT = 47,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BFD = 48,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BFD = 49,
	DEVLINK_TRAP_GENERIC_ID_IPV4_OSPF = 50,
	DEVLINK_TRAP_GENERIC_ID_IPV6_OSPF = 51,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BGP = 52,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BGP = 53,
	DEVLINK_TRAP_GENERIC_ID_IPV4_VRRP = 54,
	DEVLINK_TRAP_GENERIC_ID_IPV6_VRRP = 55,
	DEVLINK_TRAP_GENERIC_ID_IPV4_PIM = 56,
	DEVLINK_TRAP_GENERIC_ID_IPV6_PIM = 57,
	DEVLINK_TRAP_GENERIC_ID_UC_LB = 58,
	DEVLINK_TRAP_GENERIC_ID_LOCAL_ROUTE = 59,
	DEVLINK_TRAP_GENERIC_ID_EXTERNAL_ROUTE = 60,
	DEVLINK_TRAP_GENERIC_ID_IPV6_UC_DIP_LINK_LOCAL_SCOPE = 61,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_NODES = 62,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_ROUTERS = 63,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_SOLICIT = 64,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ADVERT = 65,
	DEVLINK_TRAP_GENERIC_ID_IPV6_REDIRECT = 66,
	DEVLINK_TRAP_GENERIC_ID_IPV4_ROUTER_ALERT = 67,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ALERT = 68,
	DEVLINK_TRAP_GENERIC_ID_PTP_EVENT = 69,
	DEVLINK_TRAP_GENERIC_ID_PTP_GENERAL = 70,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_SAMPLE = 71,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_TRAP = 72,
	DEVLINK_TRAP_GENERIC_ID_EARLY_DROP = 73,
	DEVLINK_TRAP_GENERIC_ID_VXLAN_PARSING = 74,
	DEVLINK_TRAP_GENERIC_ID_LLC_SNAP_PARSING = 75,
	DEVLINK_TRAP_GENERIC_ID_VLAN_PARSING = 76,
	DEVLINK_TRAP_GENERIC_ID_PPPOE_PPP_PARSING = 77,
	DEVLINK_TRAP_GENERIC_ID_MPLS_PARSING = 78,
	DEVLINK_TRAP_GENERIC_ID_ARP_PARSING = 79,
	DEVLINK_TRAP_GENERIC_ID_IP_1_PARSING = 80,
	DEVLINK_TRAP_GENERIC_ID_IP_N_PARSING = 81,
	DEVLINK_TRAP_GENERIC_ID_GRE_PARSING = 82,
	DEVLINK_TRAP_GENERIC_ID_UDP_PARSING = 83,
	DEVLINK_TRAP_GENERIC_ID_TCP_PARSING = 84,
	DEVLINK_TRAP_GENERIC_ID_IPSEC_PARSING = 85,
	DEVLINK_TRAP_GENERIC_ID_SCTP_PARSING = 86,
	DEVLINK_TRAP_GENERIC_ID_DCCP_PARSING = 87,
	DEVLINK_TRAP_GENERIC_ID_GTP_PARSING = 88,
	DEVLINK_TRAP_GENERIC_ID_ESP_PARSING = 89,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_NEXTHOP = 90,
	DEVLINK_TRAP_GENERIC_ID_DMAC_FILTER = 91,
	DEVLINK_TRAP_GENERIC_ID_EAPOL = 92,
	DEVLINK_TRAP_GENERIC_ID_LOCKED_PORT = 93,
	__DEVLINK_TRAP_GENERIC_ID_MAX = 94,
	DEVLINK_TRAP_GENERIC_ID_MAX = 93,
};

enum devlink_trap_group_generic_id {
	DEVLINK_TRAP_GROUP_GENERIC_ID_L2_DROPS = 0,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_DROPS = 1,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_EXCEPTIONS = 2,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BUFFER_DROPS = 3,
	DEVLINK_TRAP_GROUP_GENERIC_ID_TUNNEL_DROPS = 4,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_DROPS = 5,
	DEVLINK_TRAP_GROUP_GENERIC_ID_STP = 6,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LACP = 7,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LLDP = 8,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MC_SNOOPING = 9,
	DEVLINK_TRAP_GROUP_GENERIC_ID_DHCP = 10,
	DEVLINK_TRAP_GROUP_GENERIC_ID_NEIGH_DISCOVERY = 11,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BFD = 12,
	DEVLINK_TRAP_GROUP_GENERIC_ID_OSPF = 13,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BGP = 14,
	DEVLINK_TRAP_GROUP_GENERIC_ID_VRRP = 15,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PIM = 16,
	DEVLINK_TRAP_GROUP_GENERIC_ID_UC_LB = 17,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LOCAL_DELIVERY = 18,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EXTERNAL_DELIVERY = 19,
	DEVLINK_TRAP_GROUP_GENERIC_ID_IPV6 = 20,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_EVENT = 21,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_GENERAL = 22,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_SAMPLE = 23,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_TRAP = 24,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PARSER_ERROR_DROPS = 25,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EAPOL = 26,
	__DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 27,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 26,
};

enum devlink_trap_type {
	DEVLINK_TRAP_TYPE_DROP = 0,
	DEVLINK_TRAP_TYPE_EXCEPTION = 1,
	DEVLINK_TRAP_TYPE_CONTROL = 2,
};

enum devlink_var_attr_type {
	DEVLINK_VAR_ATTR_TYPE_U8 = 1,
	DEVLINK_VAR_ATTR_TYPE_U16 = 2,
	DEVLINK_VAR_ATTR_TYPE_U32 = 3,
	DEVLINK_VAR_ATTR_TYPE_U64 = 4,
	DEVLINK_VAR_ATTR_TYPE_STRING = 5,
	DEVLINK_VAR_ATTR_TYPE_FLAG = 6,
	DEVLINK_VAR_ATTR_TYPE_NUL_STRING = 10,
	DEVLINK_VAR_ATTR_TYPE_BINARY = 11,
	__DEVLINK_VAR_ATTR_TYPE_CUSTOM_BASE = 128,
};

enum devm_ioremap_type {
	DEVM_IOREMAP = 0,
	DEVM_IOREMAP_UC = 1,
	DEVM_IOREMAP_WC = 2,
	DEVM_IOREMAP_NP = 3,
};

enum dew_regs {
	PWRAP_DEW_BASE = 0,
	PWRAP_DEW_DIO_EN = 1,
	PWRAP_DEW_READ_TEST = 2,
	PWRAP_DEW_WRITE_TEST = 3,
	PWRAP_DEW_CRC_EN = 4,
	PWRAP_DEW_CRC_VAL = 5,
	PWRAP_DEW_MON_GRP_SEL = 6,
	PWRAP_DEW_CIPHER_KEY_SEL = 7,
	PWRAP_DEW_CIPHER_IV_SEL = 8,
	PWRAP_DEW_CIPHER_RDY = 9,
	PWRAP_DEW_CIPHER_MODE = 10,
	PWRAP_DEW_CIPHER_SWRST = 11,
	PWRAP_DEW_CIPHER_EN = 12,
	PWRAP_DEW_RDDMY_NO = 13,
	PWRAP_SMT_CON1 = 14,
	PWRAP_DRV_CON1 = 15,
	PWRAP_FILTER_CON0 = 16,
	PWRAP_GPIO_PULLEN0_CLR = 17,
	PWRAP_RG_SPI_CON0 = 18,
	PWRAP_RG_SPI_RECORD0 = 19,
	PWRAP_RG_SPI_CON2 = 20,
	PWRAP_RG_SPI_CON3 = 21,
	PWRAP_RG_SPI_CON4 = 22,
	PWRAP_RG_SPI_CON5 = 23,
	PWRAP_RG_SPI_CON6 = 24,
	PWRAP_RG_SPI_CON7 = 25,
	PWRAP_RG_SPI_CON8 = 26,
	PWRAP_RG_SPI_CON13 = 27,
	PWRAP_SPISLV_KEY = 28,
	PWRAP_DEW_CRC_SWRST = 29,
	PWRAP_DEW_RG_EN_RECORD = 30,
	PWRAP_DEW_RECORD_CMD0 = 31,
	PWRAP_DEW_RECORD_CMD1 = 32,
	PWRAP_DEW_RECORD_CMD2 = 33,
	PWRAP_DEW_RECORD_CMD3 = 34,
	PWRAP_DEW_RECORD_CMD4 = 35,
	PWRAP_DEW_RECORD_CMD5 = 36,
	PWRAP_DEW_RECORD_WDATA0 = 37,
	PWRAP_DEW_RECORD_WDATA1 = 38,
	PWRAP_DEW_RECORD_WDATA2 = 39,
	PWRAP_DEW_RECORD_WDATA3 = 40,
	PWRAP_DEW_RECORD_WDATA4 = 41,
	PWRAP_DEW_RECORD_WDATA5 = 42,
	PWRAP_DEW_RG_ADDR_TARGET = 43,
	PWRAP_DEW_RG_ADDR_MASK = 44,
	PWRAP_DEW_RG_WDATA_TARGET = 45,
	PWRAP_DEW_RG_WDATA_MASK = 46,
	PWRAP_DEW_RG_SPI_RECORD_CLR = 47,
	PWRAP_DEW_RG_CMD_ALERT_CLR = 48,
	PWRAP_DEW_EVENT_OUT_EN = 49,
	PWRAP_DEW_EVENT_SRC_EN = 50,
	PWRAP_DEW_EVENT_SRC = 51,
	PWRAP_DEW_EVENT_FLAG = 52,
	PWRAP_DEW_MON_FLAG_SEL = 53,
	PWRAP_DEW_EVENT_TEST = 54,
	PWRAP_DEW_CIPHER_LOAD = 55,
	PWRAP_DEW_CIPHER_START = 56,
};

enum dfll_ctrl_mode {
	DFLL_UNINITIALIZED = 0,
	DFLL_DISABLED = 1,
	DFLL_OPEN_LOOP = 2,
	DFLL_CLOSED_LOOP = 3,
};

enum dfll_tune_range {
	DFLL_TUNE_UNINITIALIZED = 0,
	DFLL_TUNE_LOW = 1,
};

enum die_val {
	DIE_UNUSED = 0,
	DIE_OOPS = 1,
};

enum dim_cq_period_mode {
	DIM_CQ_PERIOD_MODE_START_FROM_EQE = 0,
	DIM_CQ_PERIOD_MODE_START_FROM_CQE = 1,
	DIM_CQ_PERIOD_NUM_MODES = 2,
};

enum dim_state {
	DIM_START_MEASURE = 0,
	DIM_MEASURE_IN_PROGRESS = 1,
	DIM_APPLY_NEW_PROFILE = 2,
};

enum dim_stats_state {
	DIM_STATS_WORSE = 0,
	DIM_STATS_SAME = 1,
	DIM_STATS_BETTER = 2,
};

enum dim_step_result {
	DIM_STEPPED = 0,
	DIM_TOO_TIRED = 1,
	DIM_ON_EDGE = 2,
};

enum dim_tune_state {
	DIM_PARKING_ON_TOP = 0,
	DIM_PARKING_TIRED = 1,
	DIM_GOING_RIGHT = 2,
	DIM_GOING_LEFT = 3,
};

enum discover_event {
	DISCE_DISCOVER_DOMAIN = 0,
	DISCE_REVALIDATE_DOMAIN = 1,
	DISCE_SUSPEND = 2,
	DISCE_RESUME = 3,
	DISC_NUM_EVENTS = 4,
};

enum display_flags {
	DISPLAY_FLAGS_HSYNC_LOW = 1,
	DISPLAY_FLAGS_HSYNC_HIGH = 2,
	DISPLAY_FLAGS_VSYNC_LOW = 4,
	DISPLAY_FLAGS_VSYNC_HIGH = 8,
	DISPLAY_FLAGS_DE_LOW = 16,
	DISPLAY_FLAGS_DE_HIGH = 32,
	DISPLAY_FLAGS_PIXDATA_POSEDGE = 64,
	DISPLAY_FLAGS_PIXDATA_NEGEDGE = 128,
	DISPLAY_FLAGS_INTERLACED = 256,
	DISPLAY_FLAGS_DOUBLESCAN = 512,
	DISPLAY_FLAGS_DOUBLECLK = 1024,
	DISPLAY_FLAGS_SYNC_POSEDGE = 2048,
	DISPLAY_FLAGS_SYNC_NEGEDGE = 4096,
};

enum dl_bw_request {
	dl_bw_req_deactivate = 0,
	dl_bw_req_alloc = 1,
	dl_bw_req_free = 2,
};

enum dl_dev_state {
	DL_DEV_NO_DRIVER = 0,
	DL_DEV_PROBING = 1,
	DL_DEV_DRIVER_BOUND = 2,
	DL_DEV_UNBINDING = 3,
};

enum dl_param {
	DL_RUNTIME = 0,
	DL_PERIOD = 1,
};

enum dma_channel_status {
	MUSB_DMA_STATUS_UNKNOWN = 0,
	MUSB_DMA_STATUS_FREE = 1,
	MUSB_DMA_STATUS_BUSY = 2,
	MUSB_DMA_STATUS_BUS_ABORT = 3,
	MUSB_DMA_STATUS_CORE_ABORT = 4,
};

enum dma_ctrl_flags {
	DMA_PREP_INTERRUPT = 1,
	DMA_CTRL_ACK = 2,
	DMA_PREP_PQ_DISABLE_P = 4,
	DMA_PREP_PQ_DISABLE_Q = 8,
	DMA_PREP_CONTINUE = 16,
	DMA_PREP_FENCE = 32,
	DMA_CTRL_REUSE = 64,
	DMA_PREP_CMD = 128,
	DMA_PREP_REPEAT = 256,
	DMA_PREP_LOAD_EOT = 512,
};

enum dma_data_direction {
	DMA_BIDIRECTIONAL = 0,
	DMA_TO_DEVICE = 1,
	DMA_FROM_DEVICE = 2,
	DMA_NONE = 3,
};

enum dma_desc_metadata_mode {
	DESC_METADATA_NONE = 0,
	DESC_METADATA_CLIENT = 1,
	DESC_METADATA_ENGINE = 2,
};

enum dma_fence_flag_bits {
	DMA_FENCE_FLAG_SEQNO64_BIT = 0,
	DMA_FENCE_FLAG_SIGNALED_BIT = 1,
	DMA_FENCE_FLAG_TIMESTAMP_BIT = 2,
	DMA_FENCE_FLAG_ENABLE_SIGNAL_BIT = 3,
	DMA_FENCE_FLAG_USER_BITS = 4,
};

enum dma_residue_granularity {
	DMA_RESIDUE_GRANULARITY_DESCRIPTOR = 0,
	DMA_RESIDUE_GRANULARITY_SEGMENT = 1,
	DMA_RESIDUE_GRANULARITY_BURST = 2,
};

enum dma_resv_usage {
	DMA_RESV_USAGE_KERNEL = 0,
	DMA_RESV_USAGE_WRITE = 1,
	DMA_RESV_USAGE_READ = 2,
	DMA_RESV_USAGE_BOOKKEEP = 3,
};

enum dma_rx_status {
	DMA_RX_START = 0,
	DMA_RX_RUNNING = 1,
	DMA_RX_SHUTDOWN = 2,
};

enum dma_slave_buswidth {
	DMA_SLAVE_BUSWIDTH_UNDEFINED = 0,
	DMA_SLAVE_BUSWIDTH_1_BYTE = 1,
	DMA_SLAVE_BUSWIDTH_2_BYTES = 2,
	DMA_SLAVE_BUSWIDTH_3_BYTES = 3,
	DMA_SLAVE_BUSWIDTH_4_BYTES = 4,
	DMA_SLAVE_BUSWIDTH_8_BYTES = 8,
	DMA_SLAVE_BUSWIDTH_16_BYTES = 16,
	DMA_SLAVE_BUSWIDTH_32_BYTES = 32,
	DMA_SLAVE_BUSWIDTH_64_BYTES = 64,
	DMA_SLAVE_BUSWIDTH_128_BYTES = 128,
};

enum dma_status {
	DMA_COMPLETE = 0,
	DMA_IN_PROGRESS = 1,
	DMA_PAUSED = 2,
	DMA_ERROR = 3,
	DMA_OUT_OF_ORDER = 4,
};

enum dma_transaction_type {
	DMA_MEMCPY = 0,
	DMA_XOR = 1,
	DMA_PQ = 2,
	DMA_XOR_VAL = 3,
	DMA_PQ_VAL = 4,
	DMA_MEMSET = 5,
	DMA_MEMSET_SG = 6,
	DMA_INTERRUPT = 7,
	DMA_PRIVATE = 8,
	DMA_ASYNC_TX = 9,
	DMA_SLAVE = 10,
	DMA_CYCLIC = 11,
	DMA_INTERLEAVE = 12,
	DMA_COMPLETION_NO_ORDER = 13,
	DMA_REPEAT = 14,
	DMA_LOAD_EOT = 15,
	DMA_TX_TYPE_END = 16,
};

enum dma_transfer_direction {
	DMA_MEM_TO_MEM = 0,
	DMA_MEM_TO_DEV = 1,
	DMA_DEV_TO_MEM = 2,
	DMA_DEV_TO_DEV = 3,
	DMA_TRANS_NONE = 4,
};

enum dmaengine_alignment {
	DMAENGINE_ALIGN_1_BYTE = 0,
	DMAENGINE_ALIGN_2_BYTES = 1,
	DMAENGINE_ALIGN_4_BYTES = 2,
	DMAENGINE_ALIGN_8_BYTES = 3,
	DMAENGINE_ALIGN_16_BYTES = 4,
	DMAENGINE_ALIGN_32_BYTES = 5,
	DMAENGINE_ALIGN_64_BYTES = 6,
	DMAENGINE_ALIGN_128_BYTES = 7,
	DMAENGINE_ALIGN_256_BYTES = 8,
};

enum dmaengine_tx_result {
	DMA_TRANS_NOERROR = 0,
	DMA_TRANS_READ_FAILED = 1,
	DMA_TRANS_WRITE_FAILED = 2,
	DMA_TRANS_ABORTED = 3,
};

enum dmamov_dst {
	SAR = 0,
	CCR = 1,
	DAR = 2,
};

enum dmi_device_type {
	DMI_DEV_TYPE_ANY = 0,
	DMI_DEV_TYPE_OTHER = 1,
	DMI_DEV_TYPE_UNKNOWN = 2,
	DMI_DEV_TYPE_VIDEO = 3,
	DMI_DEV_TYPE_SCSI = 4,
	DMI_DEV_TYPE_ETHERNET = 5,
	DMI_DEV_TYPE_TOKENRING = 6,
	DMI_DEV_TYPE_SOUND = 7,
	DMI_DEV_TYPE_PATA = 8,
	DMI_DEV_TYPE_SATA = 9,
	DMI_DEV_TYPE_SAS = 10,
	DMI_DEV_TYPE_IPMI = -1,
	DMI_DEV_TYPE_OEM_STRING = -2,
	DMI_DEV_TYPE_DEV_ONBOARD = -3,
	DMI_DEV_TYPE_DEV_SLOT = -4,
};

enum dmi_entry_type {
	DMI_ENTRY_BIOS = 0,
	DMI_ENTRY_SYSTEM = 1,
	DMI_ENTRY_BASEBOARD = 2,
	DMI_ENTRY_CHASSIS = 3,
	DMI_ENTRY_PROCESSOR = 4,
	DMI_ENTRY_MEM_CONTROLLER = 5,
	DMI_ENTRY_MEM_MODULE = 6,
	DMI_ENTRY_CACHE = 7,
	DMI_ENTRY_PORT_CONNECTOR = 8,
	DMI_ENTRY_SYSTEM_SLOT = 9,
	DMI_ENTRY_ONBOARD_DEVICE = 10,
	DMI_ENTRY_OEMSTRINGS = 11,
	DMI_ENTRY_SYSCONF = 12,
	DMI_ENTRY_BIOS_LANG = 13,
	DMI_ENTRY_GROUP_ASSOC = 14,
	DMI_ENTRY_SYSTEM_EVENT_LOG = 15,
	DMI_ENTRY_PHYS_MEM_ARRAY = 16,
	DMI_ENTRY_MEM_DEVICE = 17,
	DMI_ENTRY_32_MEM_ERROR = 18,
	DMI_ENTRY_MEM_ARRAY_MAPPED_ADDR = 19,
	DMI_ENTRY_MEM_DEV_MAPPED_ADDR = 20,
	DMI_ENTRY_BUILTIN_POINTING_DEV = 21,
	DMI_ENTRY_PORTABLE_BATTERY = 22,
	DMI_ENTRY_SYSTEM_RESET = 23,
	DMI_ENTRY_HW_SECURITY = 24,
	DMI_ENTRY_SYSTEM_POWER_CONTROLS = 25,
	DMI_ENTRY_VOLTAGE_PROBE = 26,
	DMI_ENTRY_COOLING_DEV = 27,
	DMI_ENTRY_TEMP_PROBE = 28,
	DMI_ENTRY_ELECTRICAL_CURRENT_PROBE = 29,
	DMI_ENTRY_OOB_REMOTE_ACCESS = 30,
	DMI_ENTRY_BIS_ENTRY = 31,
	DMI_ENTRY_SYSTEM_BOOT = 32,
	DMI_ENTRY_MGMT_DEV = 33,
	DMI_ENTRY_MGMT_DEV_COMPONENT = 34,
	DMI_ENTRY_MGMT_DEV_THRES = 35,
	DMI_ENTRY_MEM_CHANNEL = 36,
	DMI_ENTRY_IPMI_DEV = 37,
	DMI_ENTRY_SYS_POWER_SUPPLY = 38,
	DMI_ENTRY_ADDITIONAL = 39,
	DMI_ENTRY_ONBOARD_DEV_EXT = 40,
	DMI_ENTRY_MGMT_CONTROLLER_HOST = 41,
	DMI_ENTRY_INACTIVE = 126,
	DMI_ENTRY_END_OF_TABLE = 127,
};

enum dmi_field {
	DMI_NONE = 0,
	DMI_BIOS_VENDOR = 1,
	DMI_BIOS_VERSION = 2,
	DMI_BIOS_DATE = 3,
	DMI_BIOS_RELEASE = 4,
	DMI_EC_FIRMWARE_RELEASE = 5,
	DMI_SYS_VENDOR = 6,
	DMI_PRODUCT_NAME = 7,
	DMI_PRODUCT_VERSION = 8,
	DMI_PRODUCT_SERIAL = 9,
	DMI_PRODUCT_UUID = 10,
	DMI_PRODUCT_SKU = 11,
	DMI_PRODUCT_FAMILY = 12,
	DMI_BOARD_VENDOR = 13,
	DMI_BOARD_NAME = 14,
	DMI_BOARD_VERSION = 15,
	DMI_BOARD_SERIAL = 16,
	DMI_BOARD_ASSET_TAG = 17,
	DMI_CHASSIS_VENDOR = 18,
	DMI_CHASSIS_TYPE = 19,
	DMI_CHASSIS_VERSION = 20,
	DMI_CHASSIS_SERIAL = 21,
	DMI_CHASSIS_ASSET_TAG = 22,
	DMI_STRING_MAX = 23,
	DMI_OEM_STRING = 24,
};

enum dns_lookup_status {
	DNS_LOOKUP_NOT_DONE = 0,
	DNS_LOOKUP_GOOD = 1,
	DNS_LOOKUP_GOOD_WITH_BAD = 2,
	DNS_LOOKUP_BAD = 3,
	DNS_LOOKUP_GOT_NOT_FOUND = 4,
	DNS_LOOKUP_GOT_LOCAL_FAILURE = 5,
	DNS_LOOKUP_GOT_TEMP_FAILURE = 6,
	DNS_LOOKUP_GOT_NS_FAILURE = 7,
	NR__dns_lookup_status = 8,
};

enum dns_payload_content_type {
	DNS_PAYLOAD_IS_SERVER_LIST = 0,
};

enum dpaa2_eth_fq_type {
	DPAA2_RX_FQ = 0,
	DPAA2_TX_CONF_FQ = 1,
	DPAA2_RX_ERR_FQ = 2,
};

enum dpaa2_eth_rx_dist {
	DPAA2_ETH_RX_DIST_HASH = 0,
	DPAA2_ETH_RX_DIST_CLS = 1,
};

enum dpaa2_eth_swa_type {
	DPAA2_ETH_SWA_SINGLE = 0,
	DPAA2_ETH_SWA_SG = 1,
	DPAA2_ETH_SWA_XDP = 2,
	DPAA2_ETH_SWA_XSK = 3,
	DPAA2_ETH_SWA_SW_TSO = 4,
};

enum dpaa2_fd_format {
	dpaa2_fd_single = 0,
	dpaa2_fd_list = 1,
	dpaa2_fd_sg = 2,
};

enum dpaa_fq_type {
	FQ_TYPE_RX_DEFAULT = 1,
	FQ_TYPE_RX_ERROR = 2,
	FQ_TYPE_RX_PCD = 3,
	FQ_TYPE_TX = 4,
	FQ_TYPE_TX_CONFIRM = 5,
	FQ_TYPE_TX_CONF_MQ = 6,
	FQ_TYPE_TX_ERROR = 7,
};

enum dpfe_commands {
	DPFE_CMD_GET_INFO = 0,
	DPFE_CMD_GET_REFRESH = 1,
	DPFE_CMD_GET_VENDOR = 2,
	DPFE_CMD_MAX = 3,
};

enum dpfe_msg_fields {
	MSG_HEADER = 0,
	MSG_COMMAND = 1,
	MSG_ARG_COUNT = 2,
	MSG_ARG0 = 3,
	MSG_FIELD_MAX = 16,
};

enum dpio_channel_mode {
	DPIO_NO_CHANNEL = 0,
	DPIO_LOCAL_CHANNEL = 1,
};

enum dpkg_extract_from_hdr_type {
	DPKG_FROM_HDR = 0,
	DPKG_FROM_FIELD = 1,
	DPKG_FULL_FIELD = 2,
};

enum dpkg_extract_type {
	DPKG_EXTRACT_FROM_HDR = 0,
	DPKG_EXTRACT_FROM_DATA = 1,
	DPKG_EXTRACT_FROM_PARSE = 3,
};

enum dpll_a {
	DPLL_A_ID = 1,
	DPLL_A_MODULE_NAME = 2,
	DPLL_A_PAD = 3,
	DPLL_A_CLOCK_ID = 4,
	DPLL_A_MODE = 5,
	DPLL_A_MODE_SUPPORTED = 6,
	DPLL_A_LOCK_STATUS = 7,
	DPLL_A_TEMP = 8,
	DPLL_A_TYPE = 9,
	DPLL_A_LOCK_STATUS_ERROR = 10,
	DPLL_A_CLOCK_QUALITY_LEVEL = 11,
	DPLL_A_PHASE_OFFSET_MONITOR = 12,
	DPLL_A_PHASE_OFFSET_AVG_FACTOR = 13,
	__DPLL_A_MAX = 14,
	DPLL_A_MAX = 13,
};

enum dpll_a_pin {
	DPLL_A_PIN_ID = 1,
	DPLL_A_PIN_PARENT_ID = 2,
	DPLL_A_PIN_MODULE_NAME = 3,
	DPLL_A_PIN_PAD = 4,
	DPLL_A_PIN_CLOCK_ID = 5,
	DPLL_A_PIN_BOARD_LABEL = 6,
	DPLL_A_PIN_PANEL_LABEL = 7,
	DPLL_A_PIN_PACKAGE_LABEL = 8,
	DPLL_A_PIN_TYPE = 9,
	DPLL_A_PIN_DIRECTION = 10,
	DPLL_A_PIN_FREQUENCY = 11,
	DPLL_A_PIN_FREQUENCY_SUPPORTED = 12,
	DPLL_A_PIN_FREQUENCY_MIN = 13,
	DPLL_A_PIN_FREQUENCY_MAX = 14,
	DPLL_A_PIN_PRIO = 15,
	DPLL_A_PIN_STATE = 16,
	DPLL_A_PIN_CAPABILITIES = 17,
	DPLL_A_PIN_PARENT_DEVICE = 18,
	DPLL_A_PIN_PARENT_PIN = 19,
	DPLL_A_PIN_PHASE_ADJUST_MIN = 20,
	DPLL_A_PIN_PHASE_ADJUST_MAX = 21,
	DPLL_A_PIN_PHASE_ADJUST = 22,
	DPLL_A_PIN_PHASE_OFFSET = 23,
	DPLL_A_PIN_FRACTIONAL_FREQUENCY_OFFSET = 24,
	DPLL_A_PIN_ESYNC_FREQUENCY = 25,
	DPLL_A_PIN_ESYNC_FREQUENCY_SUPPORTED = 26,
	DPLL_A_PIN_ESYNC_PULSE = 27,
	DPLL_A_PIN_REFERENCE_SYNC = 28,
	__DPLL_A_PIN_MAX = 29,
	DPLL_A_PIN_MAX = 28,
};

enum dpll_clock_quality_level {
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_PRC = 1,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_SSU_A = 2,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_SSU_B = 3,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_EEC1 = 4,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_PRTC = 5,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_EPRTC = 6,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_EEEC = 7,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_EPRC = 8,
	__DPLL_CLOCK_QUALITY_LEVEL_MAX = 9,
	DPLL_CLOCK_QUALITY_LEVEL_MAX = 8,
};

enum dpll_cmd {
	DPLL_CMD_DEVICE_ID_GET = 1,
	DPLL_CMD_DEVICE_GET = 2,
	DPLL_CMD_DEVICE_SET = 3,
	DPLL_CMD_DEVICE_CREATE_NTF = 4,
	DPLL_CMD_DEVICE_DELETE_NTF = 5,
	DPLL_CMD_DEVICE_CHANGE_NTF = 6,
	DPLL_CMD_PIN_ID_GET = 7,
	DPLL_CMD_PIN_GET = 8,
	DPLL_CMD_PIN_SET = 9,
	DPLL_CMD_PIN_CREATE_NTF = 10,
	DPLL_CMD_PIN_DELETE_NTF = 11,
	DPLL_CMD_PIN_CHANGE_NTF = 12,
	__DPLL_CMD_MAX = 13,
	DPLL_CMD_MAX = 12,
};

enum dpll_feature_state {
	DPLL_FEATURE_STATE_DISABLE = 0,
	DPLL_FEATURE_STATE_ENABLE = 1,
};

enum dpll_lock_status {
	DPLL_LOCK_STATUS_UNLOCKED = 1,
	DPLL_LOCK_STATUS_LOCKED = 2,
	DPLL_LOCK_STATUS_LOCKED_HO_ACQ = 3,
	DPLL_LOCK_STATUS_HOLDOVER = 4,
	__DPLL_LOCK_STATUS_MAX = 5,
	DPLL_LOCK_STATUS_MAX = 4,
};

enum dpll_lock_status_error {
	DPLL_LOCK_STATUS_ERROR_NONE = 1,
	DPLL_LOCK_STATUS_ERROR_UNDEFINED = 2,
	DPLL_LOCK_STATUS_ERROR_MEDIA_DOWN = 3,
	DPLL_LOCK_STATUS_ERROR_FRACTIONAL_FREQUENCY_OFFSET_TOO_HIGH = 4,
	__DPLL_LOCK_STATUS_ERROR_MAX = 5,
	DPLL_LOCK_STATUS_ERROR_MAX = 4,
};

enum dpll_mode {
	DPLL_MODE_MANUAL = 1,
	DPLL_MODE_AUTOMATIC = 2,
	__DPLL_MODE_MAX = 3,
	DPLL_MODE_MAX = 2,
};

enum dpll_pin_capabilities {
	DPLL_PIN_CAPABILITIES_DIRECTION_CAN_CHANGE = 1,
	DPLL_PIN_CAPABILITIES_PRIORITY_CAN_CHANGE = 2,
	DPLL_PIN_CAPABILITIES_STATE_CAN_CHANGE = 4,
};

enum dpll_pin_direction {
	DPLL_PIN_DIRECTION_INPUT = 1,
	DPLL_PIN_DIRECTION_OUTPUT = 2,
	__DPLL_PIN_DIRECTION_MAX = 3,
	DPLL_PIN_DIRECTION_MAX = 2,
};

enum dpll_pin_state {
	DPLL_PIN_STATE_CONNECTED = 1,
	DPLL_PIN_STATE_DISCONNECTED = 2,
	DPLL_PIN_STATE_SELECTABLE = 3,
	__DPLL_PIN_STATE_MAX = 4,
	DPLL_PIN_STATE_MAX = 3,
};

enum dpll_pin_type {
	DPLL_PIN_TYPE_MUX = 1,
	DPLL_PIN_TYPE_EXT = 2,
	DPLL_PIN_TYPE_SYNCE_ETH_PORT = 3,
	DPLL_PIN_TYPE_INT_OSCILLATOR = 4,
	DPLL_PIN_TYPE_GNSS = 5,
	__DPLL_PIN_TYPE_MAX = 6,
	DPLL_PIN_TYPE_MAX = 5,
};

enum dpll_type {
	DPLL_TYPE_PPS = 1,
	DPLL_TYPE_EEC = 2,
	__DPLL_TYPE_MAX = 3,
	DPLL_TYPE_MAX = 2,
};

enum dpm_order {
	DPM_ORDER_NONE = 0,
	DPM_ORDER_DEV_AFTER_PARENT = 1,
	DPM_ORDER_PARENT_BEFORE_DEV = 2,
	DPM_ORDER_DEV_LAST = 3,
};

enum dpmac_counter_id {
	DPMAC_CNT_ING_FRAME_64 = 0,
	DPMAC_CNT_ING_FRAME_127 = 1,
	DPMAC_CNT_ING_FRAME_255 = 2,
	DPMAC_CNT_ING_FRAME_511 = 3,
	DPMAC_CNT_ING_FRAME_1023 = 4,
	DPMAC_CNT_ING_FRAME_1518 = 5,
	DPMAC_CNT_ING_FRAME_1519_MAX = 6,
	DPMAC_CNT_ING_FRAG = 7,
	DPMAC_CNT_ING_JABBER = 8,
	DPMAC_CNT_ING_FRAME_DISCARD = 9,
	DPMAC_CNT_ING_ALIGN_ERR = 10,
	DPMAC_CNT_EGR_UNDERSIZED = 11,
	DPMAC_CNT_ING_OVERSIZED = 12,
	DPMAC_CNT_ING_VALID_PAUSE_FRAME = 13,
	DPMAC_CNT_EGR_VALID_PAUSE_FRAME = 14,
	DPMAC_CNT_ING_BYTE = 15,
	DPMAC_CNT_ING_MCAST_FRAME = 16,
	DPMAC_CNT_ING_BCAST_FRAME = 17,
	DPMAC_CNT_ING_ALL_FRAME = 18,
	DPMAC_CNT_ING_UCAST_FRAME = 19,
	DPMAC_CNT_ING_ERR_FRAME = 20,
	DPMAC_CNT_EGR_BYTE = 21,
	DPMAC_CNT_EGR_MCAST_FRAME = 22,
	DPMAC_CNT_EGR_BCAST_FRAME = 23,
	DPMAC_CNT_EGR_UCAST_FRAME = 24,
	DPMAC_CNT_EGR_ERR_FRAME = 25,
	DPMAC_CNT_ING_GOOD_FRAME = 26,
	DPMAC_CNT_EGR_GOOD_FRAME = 27,
};

enum dpmac_eth_if {
	DPMAC_ETH_IF_MII = 0,
	DPMAC_ETH_IF_RMII = 1,
	DPMAC_ETH_IF_SMII = 2,
	DPMAC_ETH_IF_GMII = 3,
	DPMAC_ETH_IF_RGMII = 4,
	DPMAC_ETH_IF_SGMII = 5,
	DPMAC_ETH_IF_QSGMII = 6,
	DPMAC_ETH_IF_XAUI = 7,
	DPMAC_ETH_IF_XFI = 8,
	DPMAC_ETH_IF_CAUI = 9,
	DPMAC_ETH_IF_1000BASEX = 10,
	DPMAC_ETH_IF_USXGMII = 11,
};

enum dpmac_link_type {
	DPMAC_LINK_TYPE_NONE = 0,
	DPMAC_LINK_TYPE_FIXED = 1,
	DPMAC_LINK_TYPE_PHY = 2,
	DPMAC_LINK_TYPE_BACKPLANE = 3,
};

enum dpni_congestion_point {
	DPNI_CP_QUEUE = 0,
	DPNI_CP_GROUP = 1,
};

enum dpni_congestion_unit {
	DPNI_CONGESTION_UNIT_BYTES = 0,
	DPNI_CONGESTION_UNIT_FRAMES = 1,
};

enum dpni_dest {
	DPNI_DEST_NONE = 0,
	DPNI_DEST_DPIO = 1,
	DPNI_DEST_DPCON = 2,
};

enum dpni_dist_mode {
	DPNI_DIST_MODE_NONE = 0,
	DPNI_DIST_MODE_HASH = 1,
	DPNI_DIST_MODE_FS = 2,
};

enum dpni_error_action {
	DPNI_ERROR_ACTION_DISCARD = 0,
	DPNI_ERROR_ACTION_CONTINUE = 1,
	DPNI_ERROR_ACTION_SEND_TO_ERROR_QUEUE = 2,
};

enum dpni_fs_miss_action {
	DPNI_FS_MISS_DROP = 0,
	DPNI_FS_MISS_EXPLICIT_FLOWID = 1,
	DPNI_FS_MISS_HASH = 2,
};

enum dpni_offload {
	DPNI_OFF_RX_L3_CSUM = 0,
	DPNI_OFF_RX_L4_CSUM = 1,
	DPNI_OFF_TX_L3_CSUM = 2,
	DPNI_OFF_TX_L4_CSUM = 3,
};

enum dpni_queue_type {
	DPNI_QUEUE_RX = 0,
	DPNI_QUEUE_TX = 1,
	DPNI_QUEUE_TX_CONFIRM = 2,
	DPNI_QUEUE_RX_ERR = 3,
};

enum dprc_region_type {
	DPRC_REGION_TYPE_MC_PORTAL = 0,
	DPRC_REGION_TYPE_QBMAN_PORTAL = 1,
	DPRC_REGION_TYPE_QBMAN_MEM_BACKED_PORTAL = 2,
};

enum drbg_prefixes {
	DRBG_PREFIX0 = 0,
	DRBG_PREFIX1 = 1,
	DRBG_PREFIX2 = 2,
	DRBG_PREFIX3 = 3,
};

enum drbg_seed_state {
	DRBG_SEED_STATE_UNSEEDED = 0,
	DRBG_SEED_STATE_PARTIAL = 1,
	DRBG_SEED_STATE_FULL = 2,
};

enum drm_panel_orientation {
	DRM_MODE_PANEL_ORIENTATION_UNKNOWN = -1,
	DRM_MODE_PANEL_ORIENTATION_NORMAL = 0,
	DRM_MODE_PANEL_ORIENTATION_BOTTOM_UP = 1,
	DRM_MODE_PANEL_ORIENTATION_LEFT_UP = 2,
	DRM_MODE_PANEL_ORIENTATION_RIGHT_UP = 3,
};

enum drvtype {
	LEGACY = 0,
	SYSCON = 1,
};

enum dsa_db_type {
	DSA_DB_PORT = 0,
	DSA_DB_LAG = 1,
	DSA_DB_BRIDGE = 2,
};

enum dsa_tag_protocol {
	DSA_TAG_PROTO_NONE = 0,
	DSA_TAG_PROTO_BRCM = 1,
	DSA_TAG_PROTO_BRCM_LEGACY = 22,
	DSA_TAG_PROTO_BRCM_LEGACY_FCS = 29,
	DSA_TAG_PROTO_BRCM_PREPEND = 2,
	DSA_TAG_PROTO_DSA = 3,
	DSA_TAG_PROTO_EDSA = 4,
	DSA_TAG_PROTO_GSWIP = 5,
	DSA_TAG_PROTO_KSZ9477 = 6,
	DSA_TAG_PROTO_KSZ9893 = 7,
	DSA_TAG_PROTO_LAN9303 = 8,
	DSA_TAG_PROTO_MTK = 9,
	DSA_TAG_PROTO_QCA = 10,
	DSA_TAG_PROTO_TRAILER = 11,
	DSA_TAG_PROTO_8021Q = 12,
	DSA_TAG_PROTO_SJA1105 = 13,
	DSA_TAG_PROTO_KSZ8795 = 14,
	DSA_TAG_PROTO_OCELOT = 15,
	DSA_TAG_PROTO_AR9331 = 16,
	DSA_TAG_PROTO_RTL4_A = 17,
	DSA_TAG_PROTO_HELLCREEK = 18,
	DSA_TAG_PROTO_XRS700X = 19,
	DSA_TAG_PROTO_OCELOT_8021Q = 20,
	DSA_TAG_PROTO_SEVILLE = 21,
	DSA_TAG_PROTO_SJA1110 = 23,
	DSA_TAG_PROTO_RTL8_4 = 24,
	DSA_TAG_PROTO_RTL8_4T = 25,
	DSA_TAG_PROTO_RZN1_A5PSW = 26,
	DSA_TAG_PROTO_LAN937X = 27,
	DSA_TAG_PROTO_VSC73XX_8021Q = 28,
};

enum dsaf_mode {
	DSAF_MODE_INVALID = 0,
	DSAF_MODE_ENABLE_FIX = 1,
	DSAF_MODE_ENABLE_0VM = 2,
	DSAF_MODE_ENABLE_8VM = 3,
	DSAF_MODE_ENABLE_16VM = 4,
	DSAF_MODE_ENABLE_32VM = 5,
	DSAF_MODE_ENABLE_128VM = 6,
	DSAF_MODE_ENABLE = 7,
	DSAF_MODE_DISABLE_SP = 8,
	DSAF_MODE_DISABLE_FIX = 9,
	DSAF_MODE_DISABLE_2PORT_8VM = 10,
	DSAF_MODE_DISABLE_2PORT_16VM = 11,
	DSAF_MODE_DISABLE_2PORT_64VM = 12,
	DSAF_MODE_DISABLE_6PORT_0VM = 13,
	DSAF_MODE_DISABLE_6PORT_2VM = 14,
	DSAF_MODE_DISABLE_6PORT_4VM = 15,
	DSAF_MODE_DISABLE_6PORT_16VM = 16,
	DSAF_MODE_MAX = 17,
};

enum dsaf_port_rate_mode {
	DSAF_PORT_RATE_1000 = 0,
	DSAF_PORT_RATE_2500 = 1,
	DSAF_PORT_RATE_10000 = 2,
};

enum dsaf_stp_port_type {
	DSAF_STP_PORT_TYPE_DISCARD = 0,
	DSAF_STP_PORT_TYPE_BLOCK = 1,
	DSAF_STP_PORT_TYPE_LISTEN = 2,
	DSAF_STP_PORT_TYPE_LEARN = 3,
	DSAF_STP_PORT_TYPE_FORWARD = 4,
};

enum dsaf_sw_port_type {
	DSAF_SW_PORT_TYPE_NON_VLAN = 0,
	DSAF_SW_PORT_TYPE_ACCESS = 1,
	DSAF_SW_PORT_TYPE_TRUNK = 2,
};

enum dspi_trans_mode {
	DSPI_XSPI_MODE = 0,
	DSPI_DMA_MODE = 1,
};

enum dw_edma_chip_flags {
	DW_EDMA_CHIP_LOCAL = 1,
};

enum dw_edma_map_format {
	EDMA_MF_EDMA_LEGACY = 0,
	EDMA_MF_EDMA_UNROLL = 1,
	EDMA_MF_HDMA_COMPAT = 5,
	EDMA_MF_HDMA_NATIVE = 7,
};

enum dw_mci_cookie {
	COOKIE_UNMAPPED = 0,
	COOKIE_PRE_MAPPED = 1,
	COOKIE_MAPPED = 2,
};

enum dw_mci_exynos_type {
	DW_MCI_TYPE_EXYNOS4210 = 0,
	DW_MCI_TYPE_EXYNOS4412 = 1,
	DW_MCI_TYPE_EXYNOS5250 = 2,
	DW_MCI_TYPE_EXYNOS5420 = 3,
	DW_MCI_TYPE_EXYNOS5420_SMU = 4,
	DW_MCI_TYPE_EXYNOS7 = 5,
	DW_MCI_TYPE_EXYNOS7_SMU = 6,
	DW_MCI_TYPE_EXYNOS7870 = 7,
	DW_MCI_TYPE_EXYNOS7870_SMU = 8,
	DW_MCI_TYPE_ARTPEC8 = 9,
};

enum dw_mci_state {
	STATE_IDLE___2 = 0,
	STATE_SENDING_CMD = 1,
	STATE_SENDING_DATA = 2,
	STATE_DATA_BUSY = 3,
	STATE_SENDING_STOP = 4,
	STATE_DATA_ERROR = 5,
	STATE_SENDING_CMD11 = 6,
	STATE_WAITING_CMD11_DONE = 7,
};

enum dw_pcie_app_clk {
	DW_PCIE_DBI_CLK = 0,
	DW_PCIE_MSTR_CLK = 1,
	DW_PCIE_SLV_CLK = 2,
	DW_PCIE_NUM_APP_CLKS = 3,
};

enum dw_pcie_app_rst {
	DW_PCIE_DBI_RST = 0,
	DW_PCIE_MSTR_RST = 1,
	DW_PCIE_SLV_RST = 2,
	DW_PCIE_NUM_APP_RSTS = 3,
};

enum dw_pcie_core_clk {
	DW_PCIE_PIPE_CLK = 0,
	DW_PCIE_CORE_CLK = 1,
	DW_PCIE_AUX_CLK = 2,
	DW_PCIE_REF_CLK = 3,
	DW_PCIE_NUM_CORE_CLKS = 4,
};

enum dw_pcie_core_rst {
	DW_PCIE_NON_STICKY_RST = 0,
	DW_PCIE_STICKY_RST = 1,
	DW_PCIE_CORE_RST = 2,
	DW_PCIE_PIPE_RST = 3,
	DW_PCIE_PHY_RST = 4,
	DW_PCIE_HOT_RST = 5,
	DW_PCIE_PWR_RST = 6,
	DW_PCIE_NUM_CORE_RSTS = 7,
};

enum dw_pcie_device_mode {
	DW_PCIE_UNKNOWN_TYPE = 0,
	DW_PCIE_EP_TYPE = 1,
	DW_PCIE_LEG_EP_TYPE = 2,
	DW_PCIE_RC_TYPE = 3,
};

enum dw_pcie_ltssm {
	DW_PCIE_LTSSM_DETECT_QUIET = 0,
	DW_PCIE_LTSSM_DETECT_ACT = 1,
	DW_PCIE_LTSSM_POLL_ACTIVE = 2,
	DW_PCIE_LTSSM_POLL_COMPLIANCE = 3,
	DW_PCIE_LTSSM_POLL_CONFIG = 4,
	DW_PCIE_LTSSM_PRE_DETECT_QUIET = 5,
	DW_PCIE_LTSSM_DETECT_WAIT = 6,
	DW_PCIE_LTSSM_CFG_LINKWD_START = 7,
	DW_PCIE_LTSSM_CFG_LINKWD_ACEPT = 8,
	DW_PCIE_LTSSM_CFG_LANENUM_WAI = 9,
	DW_PCIE_LTSSM_CFG_LANENUM_ACEPT = 10,
	DW_PCIE_LTSSM_CFG_COMPLETE = 11,
	DW_PCIE_LTSSM_CFG_IDLE = 12,
	DW_PCIE_LTSSM_RCVRY_LOCK = 13,
	DW_PCIE_LTSSM_RCVRY_SPEED = 14,
	DW_PCIE_LTSSM_RCVRY_RCVRCFG = 15,
	DW_PCIE_LTSSM_RCVRY_IDLE = 16,
	DW_PCIE_LTSSM_L0 = 17,
	DW_PCIE_LTSSM_L0S = 18,
	DW_PCIE_LTSSM_L123_SEND_EIDLE = 19,
	DW_PCIE_LTSSM_L1_IDLE = 20,
	DW_PCIE_LTSSM_L2_IDLE = 21,
	DW_PCIE_LTSSM_L2_WAKE = 22,
	DW_PCIE_LTSSM_DISABLED_ENTRY = 23,
	DW_PCIE_LTSSM_DISABLED_IDLE = 24,
	DW_PCIE_LTSSM_DISABLED = 25,
	DW_PCIE_LTSSM_LPBK_ENTRY = 26,
	DW_PCIE_LTSSM_LPBK_ACTIVE = 27,
	DW_PCIE_LTSSM_LPBK_EXIT = 28,
	DW_PCIE_LTSSM_LPBK_EXIT_TIMEOUT = 29,
	DW_PCIE_LTSSM_HOT_RESET_ENTRY = 30,
	DW_PCIE_LTSSM_HOT_RESET = 31,
	DW_PCIE_LTSSM_RCVRY_EQ0 = 32,
	DW_PCIE_LTSSM_RCVRY_EQ1 = 33,
	DW_PCIE_LTSSM_RCVRY_EQ2 = 34,
	DW_PCIE_LTSSM_RCVRY_EQ3 = 35,
	DW_PCIE_LTSSM_UNKNOWN = 4294967295,
};

enum dw_wdt_rmod {
	DW_WDT_RMOD_RESET = 1,
	DW_WDT_RMOD_IRQ = 2,
};

enum dwc2_control_phase {
	DWC2_CONTROL_SETUP = 0,
	DWC2_CONTROL_DATA = 1,
	DWC2_CONTROL_STATUS = 2,
};

enum dwc2_halt_status {
	DWC2_HC_XFER_NO_HALT_STATUS = 0,
	DWC2_HC_XFER_COMPLETE = 1,
	DWC2_HC_XFER_URB_COMPLETE = 2,
	DWC2_HC_XFER_ACK = 3,
	DWC2_HC_XFER_NAK = 4,
	DWC2_HC_XFER_NYET = 5,
	DWC2_HC_XFER_STALL = 6,
	DWC2_HC_XFER_XACT_ERR = 7,
	DWC2_HC_XFER_FRAME_OVERRUN = 8,
	DWC2_HC_XFER_BABBLE_ERR = 9,
	DWC2_HC_XFER_DATA_TOGGLE_ERR = 10,
	DWC2_HC_XFER_AHB_ERR = 11,
	DWC2_HC_XFER_PERIODIC_INCOMPLETE = 12,
	DWC2_HC_XFER_URB_DEQUEUE = 13,
};

enum dwc2_hsotg_dmamode {
	S3C_HSOTG_DMA_NONE = 0,
	S3C_HSOTG_DMA_ONLY = 1,
	S3C_HSOTG_DMA_DRV = 2,
};

enum dwc2_lx_state {
	DWC2_L0 = 0,
	DWC2_L1 = 1,
	DWC2_L2 = 2,
	DWC2_L3 = 3,
};

enum dwc2_transaction_type {
	DWC2_TRANSACTION_NONE = 0,
	DWC2_TRANSACTION_PERIODIC = 1,
	DWC2_TRANSACTION_NON_PERIODIC = 2,
	DWC2_TRANSACTION_ALL = 3,
};

enum dwc3_ep0_next {
	DWC3_EP0_UNKNOWN = 0,
	DWC3_EP0_COMPLETE = 1,
	DWC3_EP0_NRDY_DATA = 2,
	DWC3_EP0_NRDY_STATUS = 3,
};

enum dwc3_ep0_state {
	EP0_UNCONNECTED = 0,
	EP0_SETUP_PHASE = 1,
	EP0_DATA_PHASE = 2,
	EP0_STATUS_PHASE = 3,
};

enum dwc3_link_state {
	DWC3_LINK_STATE_U0 = 0,
	DWC3_LINK_STATE_U1 = 1,
	DWC3_LINK_STATE_U2 = 2,
	DWC3_LINK_STATE_U3 = 3,
	DWC3_LINK_STATE_SS_DIS = 4,
	DWC3_LINK_STATE_RX_DET = 5,
	DWC3_LINK_STATE_SS_INACT = 6,
	DWC3_LINK_STATE_POLL = 7,
	DWC3_LINK_STATE_RECOV = 8,
	DWC3_LINK_STATE_HRESET = 9,
	DWC3_LINK_STATE_CMPLY = 10,
	DWC3_LINK_STATE_LPBK = 11,
	DWC3_LINK_STATE_RESET = 14,
	DWC3_LINK_STATE_RESUME = 15,
	DWC3_LINK_STATE_MASK = 15,
};

enum e1000_1000t_rx_status {
	e1000_1000t_rx_status_not_ok___2 = 0,
	e1000_1000t_rx_status_ok___2 = 1,
	e1000_1000t_rx_status_undefined___2 = 255,
};

enum e1000_bus_speed {
	e1000_bus_speed_unknown___2 = 0,
	e1000_bus_speed_33___2 = 1,
	e1000_bus_speed_66___2 = 2,
	e1000_bus_speed_100___2 = 3,
	e1000_bus_speed_120___2 = 4,
	e1000_bus_speed_133___2 = 5,
	e1000_bus_speed_2500 = 6,
	e1000_bus_speed_5000 = 7,
	e1000_bus_speed_reserved___2 = 8,
};

enum e1000_bus_type {
	e1000_bus_type_unknown___2 = 0,
	e1000_bus_type_pci___2 = 1,
	e1000_bus_type_pcix___2 = 2,
	e1000_bus_type_pci_express = 3,
	e1000_bus_type_reserved___2 = 4,
};

enum e1000_bus_width {
	e1000_bus_width_unknown___2 = 0,
	e1000_bus_width_pcie_x1 = 1,
	e1000_bus_width_pcie_x2 = 2,
	e1000_bus_width_pcie_x4 = 4,
	e1000_bus_width_pcie_x8 = 8,
	e1000_bus_width_32___2 = 9,
	e1000_bus_width_64___2 = 10,
	e1000_bus_width_reserved___2 = 11,
};

enum e1000_fc_mode {
	e1000_fc_none = 0,
	e1000_fc_rx_pause = 1,
	e1000_fc_tx_pause = 2,
	e1000_fc_full = 3,
	e1000_fc_default = 255,
};

enum e1000_mac_type {
	e1000_undefined___2 = 0,
	e1000_vfadapt = 1,
	e1000_vfadapt_i350 = 2,
	e1000_num_macs___2 = 3,
};

enum e1000_mac_type___2 {
	e1000_82571 = 0,
	e1000_82572 = 1,
	e1000_82573 = 2,
	e1000_82574 = 3,
	e1000_82583 = 4,
	e1000_80003es2lan = 5,
	e1000_ich8lan = 6,
	e1000_ich9lan = 7,
	e1000_ich10lan = 8,
	e1000_pchlan = 9,
	e1000_pch2lan = 10,
	e1000_pch_lpt = 11,
	e1000_pch_spt = 12,
	e1000_pch_cnp = 13,
	e1000_pch_tgp = 14,
	e1000_pch_adp = 15,
	e1000_pch_mtp = 16,
	e1000_pch_lnp = 17,
	e1000_pch_ptp = 18,
	e1000_pch_nvp = 19,
};

enum e1000_mac_type___3 {
	e1000_undefined___3 = 0,
	e1000_82575 = 1,
	e1000_82576 = 2,
	e1000_82580 = 3,
	e1000_i350 = 4,
	e1000_i354 = 5,
	e1000_i210 = 6,
	e1000_i211 = 7,
	e1000_num_macs___3 = 8,
};

enum e1000_media_type {
	e1000_media_type_unknown = 0,
	e1000_media_type_copper___2 = 1,
	e1000_media_type_fiber___2 = 2,
	e1000_media_type_internal_serdes___2 = 3,
	e1000_num_media_types___2 = 4,
};

enum e1000_mng_mode {
	e1000_mng_mode_none = 0,
	e1000_mng_mode_asf = 1,
	e1000_mng_mode_pt = 2,
	e1000_mng_mode_ipmi = 3,
	e1000_mng_mode_host_if_only = 4,
};

enum e1000_ms_type {
	e1000_ms_hw_default___2 = 0,
	e1000_ms_force_master___2 = 1,
	e1000_ms_force_slave___2 = 2,
	e1000_ms_auto___2 = 3,
};

enum e1000_nvm_override {
	e1000_nvm_override_none = 0,
	e1000_nvm_override_spi_small = 1,
	e1000_nvm_override_spi_large = 2,
};

enum e1000_nvm_type {
	e1000_nvm_unknown = 0,
	e1000_nvm_none = 1,
	e1000_nvm_eeprom_spi = 2,
	e1000_nvm_flash_hw = 3,
	e1000_nvm_invm = 4,
	e1000_nvm_flash_sw = 5,
};

enum e1000_nvm_type___2 {
	e1000_nvm_unknown___2 = 0,
	e1000_nvm_none___2 = 1,
	e1000_nvm_eeprom_spi___2 = 2,
	e1000_nvm_flash_hw___2 = 3,
	e1000_nvm_flash_sw___2 = 4,
};

enum e1000_phy_type {
	e1000_phy_unknown = 0,
	e1000_phy_none = 1,
	e1000_phy_m88___2 = 2,
	e1000_phy_igp___2 = 3,
	e1000_phy_igp_2 = 4,
	e1000_phy_gg82563 = 5,
	e1000_phy_igp_3 = 6,
	e1000_phy_ife = 7,
	e1000_phy_bm = 8,
	e1000_phy_82578 = 9,
	e1000_phy_82577 = 10,
	e1000_phy_82579 = 11,
	e1000_phy_i217 = 12,
};

enum e1000_phy_type___2 {
	e1000_phy_unknown___2 = 0,
	e1000_phy_none___2 = 1,
	e1000_phy_m88___3 = 2,
	e1000_phy_igp___3 = 3,
	e1000_phy_igp_2___2 = 4,
	e1000_phy_gg82563___2 = 5,
	e1000_phy_igp_3___2 = 6,
	e1000_phy_ife___2 = 7,
	e1000_phy_82580 = 8,
	e1000_phy_i210 = 9,
	e1000_phy_bcm54616 = 10,
};

enum e1000_rev_polarity {
	e1000_rev_polarity_normal___2 = 0,
	e1000_rev_polarity_reversed___2 = 1,
	e1000_rev_polarity_undefined___2 = 255,
};

enum e1000_ring_flags_t {
	IGB_RING_FLAG_RX_3K_BUFFER = 0,
	IGB_RING_FLAG_RX_BUILD_SKB_ENABLED = 1,
	IGB_RING_FLAG_RX_SCTP_CSUM = 2,
	IGB_RING_FLAG_RX_LB_VLAN_BSWAP = 3,
	IGB_RING_FLAG_TX_CTX_IDX = 4,
	IGB_RING_FLAG_TX_DETECT_HANG = 5,
	IGB_RING_FLAG_TX_DISABLED = 6,
	IGB_RING_FLAG_RX_ALLOC_FAILED = 7,
};

enum e1000_serdes_link_state {
	e1000_serdes_link_down = 0,
	e1000_serdes_link_autoneg_progress = 1,
	e1000_serdes_link_autoneg_complete = 2,
	e1000_serdes_link_forced_up = 3,
};

enum e1000_smart_speed {
	e1000_smart_speed_default___2 = 0,
	e1000_smart_speed_on___2 = 1,
	e1000_smart_speed_off___2 = 2,
};

enum e1000_state_t {
	__E1000_TESTING = 0,
	__E1000_RESETTING = 1,
	__E1000_ACCESS_SHARED_RESOURCE = 2,
	__E1000_DOWN = 3,
};

enum e1000_state_t___2 {
	__E1000_TESTING___2 = 0,
	__E1000_RESETTING___2 = 1,
	__E1000_DOWN___2 = 2,
	__E1000_DISABLED = 3,
};

enum e1000_state_t___3 {
	__IGB_TESTING = 0,
	__IGB_RESETTING = 1,
	__IGB_DOWN = 2,
	__IGB_PTP_TX_IN_PROGRESS = 3,
};

enum e1000_ulp_state {
	e1000_ulp_state_unknown = 0,
	e1000_ulp_state_off = 1,
	e1000_ulp_state_on = 2,
};

enum ec_auto_fan_ctrl_cmd {
	EC_AUTO_FAN_CONTROL_CMD_SET = 0,
	EC_AUTO_FAN_CONTROL_CMD_GET = 1,
};

enum ec_comms_status {
	EC_COMMS_STATUS_PROCESSING = 1,
};

enum ec_console_read_subcmd {
	CONSOLE_READ_NEXT = 0,
	CONSOLE_READ_RECENT = 1,
};

enum ec_feature_code {
	EC_FEATURE_LIMITED = 0,
	EC_FEATURE_FLASH = 1,
	EC_FEATURE_PWM_FAN = 2,
	EC_FEATURE_PWM_KEYB = 3,
	EC_FEATURE_LIGHTBAR = 4,
	EC_FEATURE_LED = 5,
	EC_FEATURE_MOTION_SENSE = 6,
	EC_FEATURE_KEYB = 7,
	EC_FEATURE_PSTORE = 8,
	EC_FEATURE_PORT80 = 9,
	EC_FEATURE_THERMAL = 10,
	EC_FEATURE_BKLIGHT_SWITCH = 11,
	EC_FEATURE_WIFI_SWITCH = 12,
	EC_FEATURE_HOST_EVENTS = 13,
	EC_FEATURE_GPIO = 14,
	EC_FEATURE_I2C = 15,
	EC_FEATURE_CHARGER = 16,
	EC_FEATURE_BATTERY = 17,
	EC_FEATURE_SMART_BATTERY = 18,
	EC_FEATURE_HANG_DETECT = 19,
	EC_FEATURE_PMU = 20,
	EC_FEATURE_SUB_MCU = 21,
	EC_FEATURE_USB_PD = 22,
	EC_FEATURE_USB_MUX = 23,
	EC_FEATURE_MOTION_SENSE_FIFO = 24,
	EC_FEATURE_VSTORE = 25,
	EC_FEATURE_USBC_SS_MUX_VIRTUAL = 26,
	EC_FEATURE_RTC = 27,
	EC_FEATURE_FINGERPRINT = 28,
	EC_FEATURE_TOUCHPAD = 29,
	EC_FEATURE_RWSIG = 30,
	EC_FEATURE_DEVICE_EVENT = 31,
	EC_FEATURE_UNIFIED_WAKE_MASKS = 32,
	EC_FEATURE_HOST_EVENT64 = 33,
	EC_FEATURE_EXEC_IN_RAM = 34,
	EC_FEATURE_CEC = 35,
	EC_FEATURE_MOTION_SENSE_TIGHT_TIMESTAMPS = 36,
	EC_FEATURE_REFINED_TABLET_MODE_HYSTERESIS = 37,
	EC_FEATURE_SCP = 39,
	EC_FEATURE_ISH = 40,
	EC_FEATURE_TYPEC_CMD = 41,
	EC_FEATURE_TYPEC_REQUIRE_AP_MODE_ENTRY = 42,
	EC_FEATURE_TYPEC_MUX_REQUIRE_AP_ACK = 43,
	EC_FEATURE_S4_RESIDENCY = 44,
	EC_FEATURE_TYPEC_AP_MUX_SET = 45,
	EC_FEATURE_TYPEC_AP_VDM_SEND = 46,
	EC_FEATURE_SYSTEM_SAFE_MODE = 47,
	EC_FEATURE_ASSERT_REBOOTS = 48,
	EC_FEATURE_TOKENIZED_LOGGING = 49,
	EC_FEATURE_AMD_STB_DUMP = 50,
	EC_FEATURE_MEMORY_DUMP = 51,
	EC_FEATURE_TYPEC_DP2_1 = 52,
	EC_FEATURE_SCP_C1 = 53,
	EC_FEATURE_UCSI_PPM = 54,
};

enum ec_mkbp_event {
	EC_MKBP_EVENT_KEY_MATRIX = 0,
	EC_MKBP_EVENT_HOST_EVENT = 1,
	EC_MKBP_EVENT_SENSOR_FIFO = 2,
	EC_MKBP_EVENT_BUTTON = 3,
	EC_MKBP_EVENT_SWITCH = 4,
	EC_MKBP_EVENT_FINGERPRINT = 5,
	EC_MKBP_EVENT_SYSRQ = 6,
	EC_MKBP_EVENT_HOST_EVENT64 = 7,
	EC_MKBP_EVENT_CEC_EVENT = 8,
	EC_MKBP_EVENT_CEC_MESSAGE = 9,
	EC_MKBP_EVENT_PCHG = 12,
	EC_MKBP_EVENT_COUNT = 13,
};

enum ec_mkbp_info_type {
	EC_MKBP_INFO_KBD = 0,
	EC_MKBP_INFO_SUPPORTED = 1,
	EC_MKBP_INFO_CURRENT = 2,
};

enum ec_status {
	EC_RES_SUCCESS = 0,
	EC_RES_INVALID_COMMAND = 1,
	EC_RES_ERROR = 2,
	EC_RES_INVALID_PARAM = 3,
	EC_RES_ACCESS_DENIED = 4,
	EC_RES_INVALID_RESPONSE = 5,
	EC_RES_INVALID_VERSION = 6,
	EC_RES_INVALID_CHECKSUM = 7,
	EC_RES_IN_PROGRESS = 8,
	EC_RES_UNAVAILABLE = 9,
	EC_RES_TIMEOUT = 10,
	EC_RES_OVERFLOW = 11,
	EC_RES_INVALID_HEADER = 12,
	EC_RES_REQUEST_TRUNCATED = 13,
	EC_RES_RESPONSE_TOO_BIG = 14,
	EC_RES_BUS_ERROR = 15,
	EC_RES_BUSY = 16,
	EC_RES_INVALID_HEADER_VERSION = 17,
	EC_RES_INVALID_HEADER_CRC = 18,
	EC_RES_INVALID_DATA_CRC = 19,
	EC_RES_DUP_UNAVAILABLE = 20,
};

enum ec_vbnvcontext_op {
	EC_VBNV_CONTEXT_OP_READ = 0,
	EC_VBNV_CONTEXT_OP_WRITE = 1,
};

enum edac_dev_feat {
	RAS_FEAT_SCRUB = 0,
	RAS_FEAT_ECS = 1,
	RAS_FEAT_MEM_REPAIR = 2,
	RAS_FEAT_MAX = 3,
};

enum edac_mc_layer_type {
	EDAC_MC_LAYER_BRANCH = 0,
	EDAC_MC_LAYER_CHANNEL = 1,
	EDAC_MC_LAYER_SLOT = 2,
	EDAC_MC_LAYER_CHIP_SELECT = 3,
	EDAC_MC_LAYER_ALL_MEM = 4,
};

enum edac_type {
	EDAC_UNKNOWN = 0,
	EDAC_NONE = 1,
	EDAC_RESERVED = 2,
	EDAC_PARITY = 3,
	EDAC_EC = 4,
	EDAC_SECDED = 5,
	EDAC_S2ECD2ED = 6,
	EDAC_S4ECD4ED = 7,
	EDAC_S8ECD8ED = 8,
	EDAC_S16ECD16ED = 9,
};

enum efi_cmdline_option {
	EFI_CMDLINE_NONE = 0,
	EFI_CMDLINE_MODE_NUM = 1,
	EFI_CMDLINE_RES = 2,
	EFI_CMDLINE_AUTO = 3,
	EFI_CMDLINE_LIST = 4,
};

enum efi_rts_ids {
	EFI_NONE = 0,
	EFI_GET_TIME = 1,
	EFI_SET_TIME = 2,
	EFI_GET_WAKEUP_TIME = 3,
	EFI_SET_WAKEUP_TIME = 4,
	EFI_GET_VARIABLE = 5,
	EFI_GET_NEXT_VARIABLE = 6,
	EFI_SET_VARIABLE = 7,
	EFI_QUERY_VARIABLE_INFO = 8,
	EFI_GET_NEXT_HIGH_MONO_COUNT = 9,
	EFI_RESET_SYSTEM = 10,
	EFI_UPDATE_CAPSULE = 11,
	EFI_QUERY_CAPSULE_CAPS = 12,
	EFI_ACPI_PRM_HANDLER = 13,
};

enum efi_secureboot_mode {
	efi_secureboot_mode_unset = 0,
	efi_secureboot_mode_unknown = 1,
	efi_secureboot_mode_disabled = 2,
	efi_secureboot_mode_enabled = 3,
};

enum efistub_event_type {
	EFISTUB_EVT_INITRD = 0,
	EFISTUB_EVT_LOAD_OPTIONS = 1,
	EFISTUB_EVT_COUNT = 2,
};

enum ehci_hrtimer_event {
	EHCI_HRTIMER_POLL_ASS = 0,
	EHCI_HRTIMER_POLL_PSS = 1,
	EHCI_HRTIMER_POLL_DEAD = 2,
	EHCI_HRTIMER_UNLINK_INTR = 3,
	EHCI_HRTIMER_FREE_ITDS = 4,
	EHCI_HRTIMER_ACTIVE_UNLINK = 5,
	EHCI_HRTIMER_START_UNLINK_INTR = 6,
	EHCI_HRTIMER_ASYNC_UNLINKS = 7,
	EHCI_HRTIMER_IAA_WATCHDOG = 8,
	EHCI_HRTIMER_DISABLE_PERIODIC = 9,
	EHCI_HRTIMER_DISABLE_ASYNC = 10,
	EHCI_HRTIMER_IO_WATCHDOG = 11,
	EHCI_HRTIMER_NUM_EVENTS = 12,
};

enum ehci_rh_state {
	EHCI_RH_HALTED = 0,
	EHCI_RH_SUSPENDED = 1,
	EHCI_RH_RUNNING = 2,
	EHCI_RH_STOPPING = 3,
};

enum eint_type {
	EINT_TYPE_NONE = 0,
	EINT_TYPE_GPIO = 1,
	EINT_TYPE_WKUP = 2,
	EINT_TYPE_WKUP_MUX = 3,
};

enum elants_chip_id {
	EKTH3500 = 0,
	EKTF3624 = 1,
};

enum elants_iap_mode {
	ELAN_IAP_OPERATIONAL = 0,
	ELAN_IAP_RECOVERY = 1,
};

enum elants_state {
	ELAN_STATE_NORMAL = 0,
	ELAN_WAIT_QUEUE_HEADER = 1,
	ELAN_WAIT_RECALIBRATION = 2,
};

enum elv_merge {
	ELEVATOR_NO_MERGE = 0,
	ELEVATOR_FRONT_MERGE = 1,
	ELEVATOR_BACK_MERGE = 2,
	ELEVATOR_DISCARD_MERGE = 3,
};

enum enable_type {
	undefined = -1,
	user_disabled = 0,
	auto_disabled = 1,
	user_enabled = 2,
	auto_enabled = 3,
};

enum enetc_active_offloads {
	ENETC_F_TX_TSTAMP = 1,
	ENETC_F_TX_ONESTEP_SYNC_TSTAMP = 2,
	ENETC_F_RX_TSTAMP = 256,
	ENETC_F_QBV = 512,
	ENETC_F_QCI = 1024,
	ENETC_F_QBU = 2048,
	ENETC_F_TXCSUM = 4096,
	ENETC_F_LSO = 8192,
};

enum enetc_bdr_type {
	TX = 0,
	RX = 1,
};

enum enetc_errata {
	ENETC_ERR_VLAN_ISOL = 1,
	ENETC_ERR_UCMCSWP = 2,
};

enum enetc_flags_bit {
	ENETC_TX_ONESTEP_TSTAMP_IN_PROGRESS = 0,
	ENETC_TX_DOWN = 1,
};

enum enetc_ic_mode {
	ENETC_IC_NONE = 0,
	ENETC_IC_RX_MANUAL = 1,
	ENETC_IC_TX_MANUAL = 2,
	ENETC_IC_RX_ADAPTIVE = 4,
};

enum enetc_mac_addr_type {
	UC = 0,
	MC = 1,
	MADDR_TYPE = 2,
};

enum enetc_msg_cmd_action_type {
	ENETC_MSG_CMD_MNG_ADD = 1,
	ENETC_MSG_CMD_MNG_REMOVE = 2,
};

enum enetc_msg_cmd_status {
	ENETC_MSG_CMD_STATUS_OK = 0,
	ENETC_MSG_CMD_STATUS_FAIL = 1,
};

enum enetc_msg_cmd_type {
	ENETC_MSG_CMD_MNG_MAC = 1,
	ENETC_MSG_CMD_MNG_RX_MAC_FILTER = 2,
	ENETC_MSG_CMD_MNG_RX_VLAN_FILTER = 3,
};

enum enetc_txbd_flags {
	ENETC_TXBD_FLAGS_L4CS = 1,
	ENETC_TXBD_FLAGS_TSE = 2,
	ENETC_TXBD_FLAGS_LSO = 2,
	ENETC_TXBD_FLAGS_W = 4,
	ENETC_TXBD_FLAGS_CSUM_LSO = 8,
	ENETC_TXBD_FLAGS_TXSTART = 16,
	ENETC_TXBD_FLAGS_EX = 64,
	ENETC_TXBD_FLAGS_F = 128,
};

enum enetc_vf_flags {
	ENETC_VF_FLAG_PF_SET_MAC = 1,
};

enum equalization_preset_type {
	EQ_PRESET_TYPE_8GTS = 0,
	EQ_PRESET_TYPE_16GTS = 1,
	EQ_PRESET_TYPE_32GTS = 2,
	EQ_PRESET_TYPE_64GTS = 3,
	EQ_PRESET_TYPE_MAX = 4,
};

enum err_code {
	HIDMA_EVRE_STATUS_COMPLETE = 1,
	HIDMA_EVRE_STATUS_ERROR = 4,
};

enum error_detector {
	ERROR_DETECTOR_KFENCE = 0,
	ERROR_DETECTOR_KASAN = 1,
	ERROR_DETECTOR_WARN = 2,
};

enum ether_type_algorithm {
	ETYPE_ALG_NONE = 0,
	ETYPE_ALG_SKIP = 1,
	ETYPE_ALG_ENDPARSE = 2,
	ETYPE_ALG_VLAN = 3,
	ETYPE_ALG_VLAN_STRIP = 4,
};

enum ethnl_sock_type {
	ETHTOOL_SOCK_TYPE_MODULE_FW_FLASH = 0,
};

enum ethtool_c33_pse_admin_state {
	ETHTOOL_C33_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_C33_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_C33_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_c33_pse_ext_state {
	ETHTOOL_C33_PSE_EXT_STATE_ERROR_CONDITION = 1,
	ETHTOOL_C33_PSE_EXT_STATE_MR_MPS_VALID = 2,
	ETHTOOL_C33_PSE_EXT_STATE_MR_PSE_ENABLE = 3,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_DETECT_TED = 4,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_VPORT_LIM = 5,
	ETHTOOL_C33_PSE_EXT_STATE_OVLD_DETECTED = 6,
	ETHTOOL_C33_PSE_EXT_STATE_PD_DLL_POWER_TYPE = 7,
	ETHTOOL_C33_PSE_EXT_STATE_POWER_NOT_AVAILABLE = 8,
	ETHTOOL_C33_PSE_EXT_STATE_SHORT_DETECTED = 9,
};

enum ethtool_c33_pse_ext_substate_error_condition {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_NON_EXISTING_PORT = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNDEFINED_PORT = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_INTERNAL_HW_FAULT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_COMM_ERROR_AFTER_FORCE_ON = 4,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNKNOWN_PORT_STATUS = 5,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_TURN_OFF = 6,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_FORCE_SHUTDOWN = 7,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_CONFIG_CHANGE = 8,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_DETECTED_OVER_TEMP = 9,
};

enum ethtool_c33_pse_ext_substate_mr_pse_enable {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_MR_PSE_ENABLE_DISABLE_PIN_ACTIVE = 1,
};

enum ethtool_c33_pse_ext_substate_option_detect_ted {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_DET_IN_PROCESS = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_CONNECTION_CHECK_ERROR = 2,
};

enum ethtool_c33_pse_ext_substate_option_vport_lim {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_HIGH_VOLTAGE = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_LOW_VOLTAGE = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_VOLTAGE_INJECTION = 3,
};

enum ethtool_c33_pse_ext_substate_ovld_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OVLD_DETECTED_OVERLOAD = 1,
};

enum ethtool_c33_pse_ext_substate_power_not_available {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_BUDGET_EXCEEDED = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PORT_PW_LIMIT_EXCEEDS_CONTROLLER_BUDGET = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PD_REQUEST_EXCEEDS_PORT_LIMIT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_HW_PW_LIMIT = 4,
};

enum ethtool_c33_pse_ext_substate_short_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_SHORT_DETECTED_SHORT_CONDITION = 1,
};

enum ethtool_c33_pse_pw_d_status {
	ETHTOOL_C33_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_C33_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_C33_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_C33_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_C33_PSE_PW_D_STATUS_TEST = 5,
	ETHTOOL_C33_PSE_PW_D_STATUS_FAULT = 6,
	ETHTOOL_C33_PSE_PW_D_STATUS_OTHERFAULT = 7,
};

enum ethtool_cmis_cdb_cmd_id {
	ETHTOOL_CMIS_CDB_CMD_QUERY_STATUS = 0,
	ETHTOOL_CMIS_CDB_CMD_MODULE_FEATURES = 64,
	ETHTOOL_CMIS_CDB_CMD_FW_MANAGMENT_FEATURES = 65,
	ETHTOOL_CMIS_CDB_CMD_START_FW_DOWNLOAD = 257,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_LPL = 259,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_EPL = 260,
	ETHTOOL_CMIS_CDB_CMD_COMPLETE_FW_DOWNLOAD = 263,
	ETHTOOL_CMIS_CDB_CMD_RUN_FW_IMAGE = 265,
	ETHTOOL_CMIS_CDB_CMD_COMMIT_FW_IMAGE = 266,
};

enum ethtool_fec_config_bits {
	ETHTOOL_FEC_NONE_BIT = 0,
	ETHTOOL_FEC_AUTO_BIT = 1,
	ETHTOOL_FEC_OFF_BIT = 2,
	ETHTOOL_FEC_RS_BIT = 3,
	ETHTOOL_FEC_BASER_BIT = 4,
	ETHTOOL_FEC_LLRS_BIT = 5,
};

enum ethtool_flags {
	ETH_FLAG_TXVLAN = 128,
	ETH_FLAG_RXVLAN = 256,
	ETH_FLAG_LRO = 32768,
	ETH_FLAG_NTUPLE = 134217728,
	ETH_FLAG_RXHASH = 268435456,
};

enum ethtool_header_flags {
	ETHTOOL_FLAG_COMPACT_BITSETS = 1,
	ETHTOOL_FLAG_OMIT_REPLY = 2,
	ETHTOOL_FLAG_STATS = 4,
};

enum ethtool_link_ext_state {
	ETHTOOL_LINK_EXT_STATE_AUTONEG = 0,
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE = 1,
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH = 2,
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY = 3,
	ETHTOOL_LINK_EXT_STATE_NO_CABLE = 4,
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE = 5,
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE = 6,
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE = 7,
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED = 8,
	ETHTOOL_LINK_EXT_STATE_OVERHEAT = 9,
	ETHTOOL_LINK_EXT_STATE_MODULE = 10,
};

enum ethtool_link_ext_substate_autoneg {
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE = 5,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD = 6,
};

enum ethtool_link_ext_substate_bad_signal_integrity {
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_REFERENCE_CLOCK_LOST = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_ALOS = 4,
};

enum ethtool_link_ext_substate_cable_issue {
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE = 2,
};

enum ethtool_link_ext_substate_link_logical_mismatch {
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED = 5,
};

enum ethtool_link_ext_substate_link_training {
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT = 4,
};

enum ethtool_link_ext_substate_module {
	ETHTOOL_LINK_EXT_SUBSTATE_MODULE_CMIS_NOT_READY = 1,
};

enum ethtool_link_mode_bit_indices {
	ETHTOOL_LINK_MODE_10baseT_Half_BIT = 0,
	ETHTOOL_LINK_MODE_10baseT_Full_BIT = 1,
	ETHTOOL_LINK_MODE_100baseT_Half_BIT = 2,
	ETHTOOL_LINK_MODE_100baseT_Full_BIT = 3,
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT = 4,
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT = 5,
	ETHTOOL_LINK_MODE_Autoneg_BIT = 6,
	ETHTOOL_LINK_MODE_TP_BIT = 7,
	ETHTOOL_LINK_MODE_AUI_BIT = 8,
	ETHTOOL_LINK_MODE_MII_BIT = 9,
	ETHTOOL_LINK_MODE_FIBRE_BIT = 10,
	ETHTOOL_LINK_MODE_BNC_BIT = 11,
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT = 12,
	ETHTOOL_LINK_MODE_Pause_BIT = 13,
	ETHTOOL_LINK_MODE_Asym_Pause_BIT = 14,
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT = 15,
	ETHTOOL_LINK_MODE_Backplane_BIT = 16,
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT = 17,
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT = 18,
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT = 19,
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT = 20,
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT = 21,
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT = 22,
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT = 23,
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT = 24,
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT = 25,
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT = 26,
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT = 27,
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT = 28,
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT = 29,
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT = 30,
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT = 31,
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT = 32,
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT = 33,
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT = 34,
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT = 35,
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT = 36,
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT = 37,
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT = 38,
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT = 39,
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT = 40,
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT = 41,
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT = 42,
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT = 43,
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT = 44,
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT = 45,
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT = 46,
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT = 47,
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT = 48,
	ETHTOOL_LINK_MODE_FEC_NONE_BIT = 49,
	ETHTOOL_LINK_MODE_FEC_RS_BIT = 50,
	ETHTOOL_LINK_MODE_FEC_BASER_BIT = 51,
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT = 52,
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT = 53,
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT = 54,
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT = 55,
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT = 56,
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT = 57,
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT = 58,
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT = 59,
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT = 60,
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT = 61,
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT = 62,
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT = 63,
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT = 64,
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT = 65,
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT = 66,
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT = 67,
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT = 68,
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT = 69,
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT = 70,
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT = 71,
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT = 72,
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT = 73,
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT = 74,
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT = 75,
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT = 76,
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT = 77,
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT = 78,
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT = 79,
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT = 80,
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT = 81,
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT = 82,
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT = 83,
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT = 84,
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT = 85,
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT = 86,
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT = 87,
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT = 88,
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT = 89,
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT = 90,
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT = 91,
	ETHTOOL_LINK_MODE_10baseT1L_Full_BIT = 92,
	ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT = 93,
	ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT = 94,
	ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT = 95,
	ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT = 96,
	ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT = 97,
	ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT = 98,
	ETHTOOL_LINK_MODE_10baseT1S_Full_BIT = 99,
	ETHTOOL_LINK_MODE_10baseT1S_Half_BIT = 100,
	ETHTOOL_LINK_MODE_10baseT1S_P2MP_Half_BIT = 101,
	ETHTOOL_LINK_MODE_10baseT1BRR_Full_BIT = 102,
	ETHTOOL_LINK_MODE_200000baseCR_Full_BIT = 103,
	ETHTOOL_LINK_MODE_200000baseKR_Full_BIT = 104,
	ETHTOOL_LINK_MODE_200000baseDR_Full_BIT = 105,
	ETHTOOL_LINK_MODE_200000baseDR_2_Full_BIT = 106,
	ETHTOOL_LINK_MODE_200000baseSR_Full_BIT = 107,
	ETHTOOL_LINK_MODE_200000baseVR_Full_BIT = 108,
	ETHTOOL_LINK_MODE_400000baseCR2_Full_BIT = 109,
	ETHTOOL_LINK_MODE_400000baseKR2_Full_BIT = 110,
	ETHTOOL_LINK_MODE_400000baseDR2_Full_BIT = 111,
	ETHTOOL_LINK_MODE_400000baseDR2_2_Full_BIT = 112,
	ETHTOOL_LINK_MODE_400000baseSR2_Full_BIT = 113,
	ETHTOOL_LINK_MODE_400000baseVR2_Full_BIT = 114,
	ETHTOOL_LINK_MODE_800000baseCR4_Full_BIT = 115,
	ETHTOOL_LINK_MODE_800000baseKR4_Full_BIT = 116,
	ETHTOOL_LINK_MODE_800000baseDR4_Full_BIT = 117,
	ETHTOOL_LINK_MODE_800000baseDR4_2_Full_BIT = 118,
	ETHTOOL_LINK_MODE_800000baseSR4_Full_BIT = 119,
	ETHTOOL_LINK_MODE_800000baseVR4_Full_BIT = 120,
	__ETHTOOL_LINK_MODE_MASK_NBITS = 121,
};

enum ethtool_mac_stats_src {
	ETHTOOL_MAC_STATS_SRC_AGGREGATE = 0,
	ETHTOOL_MAC_STATS_SRC_EMAC = 1,
	ETHTOOL_MAC_STATS_SRC_PMAC = 2,
};

enum ethtool_mm_verify_status {
	ETHTOOL_MM_VERIFY_STATUS_UNKNOWN = 0,
	ETHTOOL_MM_VERIFY_STATUS_INITIAL = 1,
	ETHTOOL_MM_VERIFY_STATUS_VERIFYING = 2,
	ETHTOOL_MM_VERIFY_STATUS_SUCCEEDED = 3,
	ETHTOOL_MM_VERIFY_STATUS_FAILED = 4,
	ETHTOOL_MM_VERIFY_STATUS_DISABLED = 5,
};

enum ethtool_mmsv_event {
	ETHTOOL_MMSV_LP_SENT_VERIFY_MPACKET = 0,
	ETHTOOL_MMSV_LD_SENT_VERIFY_MPACKET = 1,
	ETHTOOL_MMSV_LP_SENT_RESPONSE_MPACKET = 2,
};

enum ethtool_module_fw_flash_status {
	ETHTOOL_MODULE_FW_FLASH_STATUS_STARTED = 1,
	ETHTOOL_MODULE_FW_FLASH_STATUS_IN_PROGRESS = 2,
	ETHTOOL_MODULE_FW_FLASH_STATUS_COMPLETED = 3,
	ETHTOOL_MODULE_FW_FLASH_STATUS_ERROR = 4,
};

enum ethtool_module_power_mode {
	ETHTOOL_MODULE_POWER_MODE_LOW = 1,
	ETHTOOL_MODULE_POWER_MODE_HIGH = 2,
};

enum ethtool_module_power_mode_policy {
	ETHTOOL_MODULE_POWER_MODE_POLICY_HIGH = 1,
	ETHTOOL_MODULE_POWER_MODE_POLICY_AUTO = 2,
};

enum ethtool_mpacket {
	ETHTOOL_MPACKET_VERIFY = 0,
	ETHTOOL_MPACKET_RESPONSE = 1,
};

enum ethtool_multicast_groups {
	ETHNL_MCGRP_MONITOR = 0,
};

enum ethtool_phys_id_state {
	ETHTOOL_ID_INACTIVE = 0,
	ETHTOOL_ID_ACTIVE = 1,
	ETHTOOL_ID_ON = 2,
	ETHTOOL_ID_OFF = 3,
};

enum ethtool_podl_pse_admin_state {
	ETHTOOL_PODL_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_PODL_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_podl_pse_pw_d_status {
	ETHTOOL_PODL_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SLEEP = 5,
	ETHTOOL_PODL_PSE_PW_D_STATUS_IDLE = 6,
	ETHTOOL_PODL_PSE_PW_D_STATUS_ERROR = 7,
};

enum ethtool_reset_flags {
	ETH_RESET_MGMT = 1,
	ETH_RESET_IRQ = 2,
	ETH_RESET_DMA = 4,
	ETH_RESET_FILTER = 8,
	ETH_RESET_OFFLOAD = 16,
	ETH_RESET_MAC = 32,
	ETH_RESET_PHY = 64,
	ETH_RESET_RAM = 128,
	ETH_RESET_AP = 256,
	ETH_RESET_DEDICATED = 65535,
	ETH_RESET_ALL = 4294967295,
};

enum ethtool_sfeatures_retval_bits {
	ETHTOOL_F_UNSUPPORTED__BIT = 0,
	ETHTOOL_F_WISH__BIT = 1,
	ETHTOOL_F_COMPAT__BIT = 2,
};

enum ethtool_stringset {
	ETH_SS_TEST = 0,
	ETH_SS_STATS = 1,
	ETH_SS_PRIV_FLAGS = 2,
	ETH_SS_NTUPLE_FILTERS = 3,
	ETH_SS_FEATURES = 4,
	ETH_SS_RSS_HASH_FUNCS = 5,
	ETH_SS_TUNABLES = 6,
	ETH_SS_PHY_STATS = 7,
	ETH_SS_PHY_TUNABLES = 8,
	ETH_SS_LINK_MODES = 9,
	ETH_SS_MSG_CLASSES = 10,
	ETH_SS_WOL_MODES = 11,
	ETH_SS_SOF_TIMESTAMPING = 12,
	ETH_SS_TS_TX_TYPES = 13,
	ETH_SS_TS_RX_FILTERS = 14,
	ETH_SS_UDP_TUNNEL_TYPES = 15,
	ETH_SS_STATS_STD = 16,
	ETH_SS_STATS_ETH_PHY = 17,
	ETH_SS_STATS_ETH_MAC = 18,
	ETH_SS_STATS_ETH_CTRL = 19,
	ETH_SS_STATS_RMON = 20,
	ETH_SS_STATS_PHY = 21,
	ETH_SS_TS_FLAGS = 22,
	ETH_SS_COUNT = 23,
};

enum ethtool_supported_ring_param {
	ETHTOOL_RING_USE_RX_BUF_LEN = 1,
	ETHTOOL_RING_USE_CQE_SIZE = 2,
	ETHTOOL_RING_USE_TX_PUSH = 4,
	ETHTOOL_RING_USE_RX_PUSH = 8,
	ETHTOOL_RING_USE_TX_PUSH_BUF_LEN = 16,
	ETHTOOL_RING_USE_TCP_DATA_SPLIT = 32,
	ETHTOOL_RING_USE_HDS_THRS = 64,
};

enum ethtool_tcp_data_split {
	ETHTOOL_TCP_DATA_SPLIT_UNKNOWN = 0,
	ETHTOOL_TCP_DATA_SPLIT_DISABLED = 1,
	ETHTOOL_TCP_DATA_SPLIT_ENABLED = 2,
};

enum ethtool_test_flags {
	ETH_TEST_FL_OFFLINE = 1,
	ETH_TEST_FL_FAILED = 2,
	ETH_TEST_FL_EXTERNAL_LB = 4,
	ETH_TEST_FL_EXTERNAL_LB_DONE = 8,
};

enum event_type_t {
	EVENT_FLEXIBLE = 1,
	EVENT_PINNED = 2,
	EVENT_TIME = 4,
	EVENT_FROZEN = 8,
	EVENT_CPU = 16,
	EVENT_CGROUP = 32,
	EVENT_ALL = 3,
	EVENT_TIME_FROZEN = 12,
};

enum ex_phy_state {
	PHY_EMPTY = 0,
	PHY_VACANT = 1,
	PHY_NOT_PRESENT = 2,
	PHY_DEVICE_DISCOVERED = 3,
};

enum exact_level {
	NOT_EXACT = 0,
	EXACT = 1,
	RANGE_WITHIN = 2,
};

enum exception_type {
	except_type_sync = 0,
	except_type_irq = 128,
	except_type_fiq = 256,
	except_type_serror = 384,
};

enum exec_status {
	SAS_SAM_STAT_GOOD = 0,
	SAS_SAM_STAT_BUSY = 8,
	SAS_SAM_STAT_TASK_ABORTED = 64,
	SAS_SAM_STAT_CHECK_CONDITION = 2,
	SAS_DEV_NO_RESPONSE = 128,
	SAS_DATA_UNDERRUN = 129,
	SAS_DATA_OVERRUN = 130,
	SAS_INTERRUPTED = 131,
	SAS_QUEUE_FULL = 132,
	SAS_DEVICE_UNKNOWN = 133,
	SAS_OPEN_REJECT = 134,
	SAS_OPEN_TO = 135,
	SAS_PROTO_RESPONSE = 136,
	SAS_PHY_DOWN = 137,
	SAS_NAK_R_ERR = 138,
	SAS_PENDING = 139,
	SAS_ABORTED_TASK = 140,
};

enum execmem_range_flags {
	EXECMEM_KASAN_SHADOW = 1,
	EXECMEM_ROX_CACHE = 2,
};

enum execmem_type {
	EXECMEM_DEFAULT = 0,
	EXECMEM_MODULE_TEXT = 0,
	EXECMEM_KPROBES = 1,
	EXECMEM_FTRACE = 2,
	EXECMEM_BPF = 3,
	EXECMEM_MODULE_DATA = 4,
	EXECMEM_TYPE_MAX = 5,
};

enum ext4_journal_trigger_type {
	EXT4_JTR_ORPHAN_FILE = 0,
	EXT4_JTR_NONE = 1,
};

enum ext4_li_mode {
	EXT4_LI_MODE_PREFETCH_BBITMAP = 0,
	EXT4_LI_MODE_ITABLE = 1,
};

enum exynos_cpuclk_layout {
	CPUCLK_LAYOUT_E4210 = 0,
	CPUCLK_LAYOUT_E5433 = 1,
	CPUCLK_LAYOUT_E850_CL0 = 2,
	CPUCLK_LAYOUT_E850_CL1 = 3,
};

enum exynos_mipi_phy_id {
	EXYNOS_MIPI_PHY_ID_NONE = -1,
	EXYNOS_MIPI_PHY_ID_CSIS0 = 0,
	EXYNOS_MIPI_PHY_ID_DSIM0 = 1,
	EXYNOS_MIPI_PHY_ID_CSIS1 = 2,
	EXYNOS_MIPI_PHY_ID_DSIM1 = 3,
	EXYNOS_MIPI_PHY_ID_CSIS2 = 4,
	EXYNOS_MIPI_PHYS_NUM = 5,
};

enum exynos_mipi_phy_regmap_id {
	EXYNOS_MIPI_REGMAP_PMU = 0,
	EXYNOS_MIPI_REGMAP_DISP = 1,
	EXYNOS_MIPI_REGMAP_CAM0 = 2,
	EXYNOS_MIPI_REGMAP_CAM1 = 3,
	EXYNOS_MIPI_REGMAPS_NUM = 4,
};

enum exynos_usi_ver {
	USI_VER1 = 0,
	USI_VER2 = 1,
};

enum fail_dup_mod_reason {
	FAIL_DUP_MOD_BECOMING = 0,
	FAIL_DUP_MOD_LOAD = 1,
};

enum fan53555_vendor {
	FAN53526_VENDOR_FAIRCHILD = 0,
	FAN53555_VENDOR_FAIRCHILD = 1,
	FAN53555_VENDOR_ROCKCHIP = 2,
	RK8602_VENDOR_ROCKCHIP = 3,
	FAN53555_VENDOR_SILERGY = 4,
	FAN53526_VENDOR_TCS = 5,
};

enum fanotify_event_type {
	FANOTIFY_EVENT_TYPE_FID = 0,
	FANOTIFY_EVENT_TYPE_FID_NAME = 1,
	FANOTIFY_EVENT_TYPE_PATH = 2,
	FANOTIFY_EVENT_TYPE_PATH_PERM = 3,
	FANOTIFY_EVENT_TYPE_OVERFLOW = 4,
	FANOTIFY_EVENT_TYPE_FS_ERROR = 5,
	FANOTIFY_EVENT_TYPE_MNT = 6,
	__FANOTIFY_EVENT_TYPE_NUM = 7,
};

enum fault_flag {
	FAULT_FLAG_WRITE = 1,
	FAULT_FLAG_MKWRITE = 2,
	FAULT_FLAG_ALLOW_RETRY = 4,
	FAULT_FLAG_RETRY_NOWAIT = 8,
	FAULT_FLAG_KILLABLE = 16,
	FAULT_FLAG_TRIED = 32,
	FAULT_FLAG_USER = 64,
	FAULT_FLAG_REMOTE = 128,
	FAULT_FLAG_INSTRUCTION = 256,
	FAULT_FLAG_INTERRUPTIBLE = 512,
	FAULT_FLAG_UNSHARE = 1024,
	FAULT_FLAG_ORIG_PTE_VALID = 2048,
	FAULT_FLAG_VMA_LOCK = 4096,
};

enum fbq_type {
	regular = 0,
	remote = 1,
	all = 2,
};

enum fec_txbuf_type {
	FEC_TXBUF_T_SKB = 0,
	FEC_TXBUF_T_XDP_NDO = 1,
	FEC_TXBUF_T_XDP_TX = 2,
};

enum fg_filter_id {
	__NO_FGF__ = 0,
	HCRX_FGTnXS = 1,
	__NR_FG_FILTER_IDS__ = 2,
};

enum fgt_group_id {
	__NO_FGT_GROUP__ = 0,
	HFGRTR_GROUP = 1,
	HFGWTR_GROUP = 1,
	HDFGRTR_GROUP = 2,
	HDFGWTR_GROUP = 2,
	HFGITR_GROUP = 3,
	HAFGRTR_GROUP = 4,
	HFGRTR2_GROUP = 5,
	HFGWTR2_GROUP = 5,
	HDFGRTR2_GROUP = 6,
	HDFGWTR2_GROUP = 6,
	HFGITR2_GROUP = 7,
	__NR_FGT_GROUP_IDS__ = 8,
};

enum fhctl_variant {
	FHCTL_PLLFH_V1 = 0,
	FHCTL_PLLFH_V2 = 1,
};

enum fib_event_type {
	FIB_EVENT_ENTRY_REPLACE = 0,
	FIB_EVENT_ENTRY_APPEND = 1,
	FIB_EVENT_ENTRY_ADD = 2,
	FIB_EVENT_ENTRY_DEL = 3,
	FIB_EVENT_RULE_ADD = 4,
	FIB_EVENT_RULE_DEL = 5,
	FIB_EVENT_NH_ADD = 6,
	FIB_EVENT_NH_DEL = 7,
	FIB_EVENT_VIF_ADD = 8,
	FIB_EVENT_VIF_DEL = 9,
};

enum fid_type {
	FILEID_ROOT = 0,
	FILEID_INO32_GEN = 1,
	FILEID_INO32_GEN_PARENT = 2,
	FILEID_BTRFS_WITHOUT_PARENT = 77,
	FILEID_BTRFS_WITH_PARENT = 78,
	FILEID_BTRFS_WITH_PARENT_ROOT = 79,
	FILEID_UDF_WITHOUT_PARENT = 81,
	FILEID_UDF_WITH_PARENT = 82,
	FILEID_NILFS_WITHOUT_PARENT = 97,
	FILEID_NILFS_WITH_PARENT = 98,
	FILEID_FAT_WITHOUT_PARENT = 113,
	FILEID_FAT_WITH_PARENT = 114,
	FILEID_INO64_GEN = 129,
	FILEID_INO64_GEN_PARENT = 130,
	FILEID_LUSTRE = 151,
	FILEID_BCACHEFS_WITHOUT_PARENT = 177,
	FILEID_BCACHEFS_WITH_PARENT = 178,
	FILEID_NSFS = 241,
	FILEID_KERNFS = 254,
	FILEID_INVALID = 255,
};

enum fifo_dump_mode_v3_hw {
	FIFO_DUMP_FORVER = 1,
	FIFO_DUMP_AFTER_TRIGGER = 2,
	FIFO_DUMP_UNTILL_TRIGGER = 4,
};

enum fifo_trigger_mode_v3_hw {
	FIFO_TRIGGER_EDGE = 1,
	FIFO_TRIGGER_SAME_LEVEL = 2,
	FIFO_TRIGGER_DIFF_LEVEL = 4,
};

enum file_time_flags {
	S_ATIME = 1,
	S_MTIME = 2,
	S_CTIME = 4,
	S_VERSION = 8,
};

enum fiq_hwirq {
	AIC_TMR_EL0_PHYS = 0,
	AIC_TMR_EL0_VIRT = 1,
	AIC_TMR_EL02_PHYS = 2,
	AIC_TMR_EL02_VIRT = 3,
	AIC_CPU_PMU_Effi = 4,
	AIC_CPU_PMU_Perf = 5,
	AIC_VGIC_MI = 6,
	AIC_NR_FIQ = 7,
};

enum fit_type {
	NOTHING_FIT = 0,
	FL_FIT_TYPE = 1,
	LE_FIT_TYPE = 2,
	RE_FIT_TYPE = 3,
	NE_FIT_TYPE = 4,
};

enum fixed_addresses {
	FIX_HOLE = 0,
	FIX_FDT_END = 1,
	FIX_FDT = 514,
	FIX_EARLYCON_MEM_BASE = 515,
	FIX_TEXT_POKE0 = 516,
	FIX_VNCR_END = 517,
	FIX_VNCR = 1029,
	FIX_APEI_GHES_IRQ = 1030,
	FIX_APEI_GHES_SEA = 1031,
	FIX_APEI_GHES_SDEI_NORMAL = 1032,
	FIX_APEI_GHES_SDEI_CRITICAL = 1033,
	FIX_ENTRY_TRAMP_TEXT4 = 1034,
	FIX_ENTRY_TRAMP_TEXT3 = 1035,
	FIX_ENTRY_TRAMP_TEXT2 = 1036,
	FIX_ENTRY_TRAMP_TEXT1 = 1037,
	__end_of_permanent_fixed_addresses = 1038,
	FIX_BTMAP_END = 1038,
	FIX_BTMAP_BEGIN = 1485,
	FIX_PTE = 1486,
	FIX_PMD = 1487,
	FIX_PUD = 1488,
	FIX_P4D = 1489,
	FIX_PGD = 1490,
	__end_of_fixed_addresses = 1491,
};

enum flag_idn {
	QUERY_FLAG_IDN_FDEVICEINIT = 1,
	QUERY_FLAG_IDN_PERMANENT_WPE = 2,
	QUERY_FLAG_IDN_PWR_ON_WPE = 3,
	QUERY_FLAG_IDN_BKOPS_EN = 4,
	QUERY_FLAG_IDN_LIFE_SPAN_MODE_ENABLE = 5,
	QUERY_FLAG_IDN_PURGE_ENABLE = 6,
	QUERY_FLAG_IDN_RESERVED2 = 7,
	QUERY_FLAG_IDN_FPHYRESOURCEREMOVAL = 8,
	QUERY_FLAG_IDN_BUSY_RTC = 9,
	QUERY_FLAG_IDN_RESERVED3 = 10,
	QUERY_FLAG_IDN_PERMANENTLY_DISABLE_FW_UPDATE = 11,
	QUERY_FLAG_IDN_WB_EN = 14,
	QUERY_FLAG_IDN_WB_BUFF_FLUSH_EN = 15,
	QUERY_FLAG_IDN_WB_BUFF_FLUSH_DURING_HIBERN8 = 16,
	QUERY_FLAG_IDN_HPB_RESET = 17,
	QUERY_FLAG_IDN_HPB_EN = 18,
};

enum flow_action_hw_stats {
	FLOW_ACTION_HW_STATS_IMMEDIATE = 1,
	FLOW_ACTION_HW_STATS_DELAYED = 2,
	FLOW_ACTION_HW_STATS_ANY = 3,
	FLOW_ACTION_HW_STATS_DISABLED = 4,
	FLOW_ACTION_HW_STATS_DONT_CARE = 7,
};

enum flow_action_hw_stats_bit {
	FLOW_ACTION_HW_STATS_IMMEDIATE_BIT = 0,
	FLOW_ACTION_HW_STATS_DELAYED_BIT = 1,
	FLOW_ACTION_HW_STATS_DISABLED_BIT = 2,
	FLOW_ACTION_HW_STATS_NUM_BITS = 3,
};

enum flow_action_id {
	FLOW_ACTION_ACCEPT = 0,
	FLOW_ACTION_DROP = 1,
	FLOW_ACTION_TRAP = 2,
	FLOW_ACTION_GOTO = 3,
	FLOW_ACTION_REDIRECT = 4,
	FLOW_ACTION_MIRRED = 5,
	FLOW_ACTION_REDIRECT_INGRESS = 6,
	FLOW_ACTION_MIRRED_INGRESS = 7,
	FLOW_ACTION_VLAN_PUSH = 8,
	FLOW_ACTION_VLAN_POP = 9,
	FLOW_ACTION_VLAN_MANGLE = 10,
	FLOW_ACTION_TUNNEL_ENCAP = 11,
	FLOW_ACTION_TUNNEL_DECAP = 12,
	FLOW_ACTION_MANGLE = 13,
	FLOW_ACTION_ADD = 14,
	FLOW_ACTION_CSUM = 15,
	FLOW_ACTION_MARK = 16,
	FLOW_ACTION_PTYPE = 17,
	FLOW_ACTION_PRIORITY = 18,
	FLOW_ACTION_RX_QUEUE_MAPPING = 19,
	FLOW_ACTION_WAKE = 20,
	FLOW_ACTION_QUEUE = 21,
	FLOW_ACTION_SAMPLE = 22,
	FLOW_ACTION_POLICE = 23,
	FLOW_ACTION_CT = 24,
	FLOW_ACTION_CT_METADATA = 25,
	FLOW_ACTION_MPLS_PUSH = 26,
	FLOW_ACTION_MPLS_POP = 27,
	FLOW_ACTION_MPLS_MANGLE = 28,
	FLOW_ACTION_GATE = 29,
	FLOW_ACTION_PPPOE_PUSH = 30,
	FLOW_ACTION_JUMP = 31,
	FLOW_ACTION_PIPE = 32,
	FLOW_ACTION_VLAN_PUSH_ETH = 33,
	FLOW_ACTION_VLAN_POP_ETH = 34,
	FLOW_ACTION_CONTINUE = 35,
	NUM_FLOW_ACTIONS = 36,
};

enum flow_action_mangle_base {
	FLOW_ACT_MANGLE_UNSPEC = 0,
	FLOW_ACT_MANGLE_HDR_TYPE_ETH = 1,
	FLOW_ACT_MANGLE_HDR_TYPE_IP4 = 2,
	FLOW_ACT_MANGLE_HDR_TYPE_IP6 = 3,
	FLOW_ACT_MANGLE_HDR_TYPE_TCP = 4,
	FLOW_ACT_MANGLE_HDR_TYPE_UDP = 5,
};

enum flow_block_binder_type {
	FLOW_BLOCK_BINDER_TYPE_UNSPEC = 0,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_INGRESS = 1,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_EGRESS = 2,
	FLOW_BLOCK_BINDER_TYPE_RED_EARLY_DROP = 3,
	FLOW_BLOCK_BINDER_TYPE_RED_MARK = 4,
};

enum flow_block_command {
	FLOW_BLOCK_BIND = 0,
	FLOW_BLOCK_UNBIND = 1,
};

enum flow_cls_command {
	FLOW_CLS_REPLACE = 0,
	FLOW_CLS_DESTROY = 1,
	FLOW_CLS_STATS = 2,
	FLOW_CLS_TMPLT_CREATE = 3,
	FLOW_CLS_TMPLT_DESTROY = 4,
};

enum flow_control {
	FC_NONE = 0,
	FC_TX = 1,
	FC_RX = 2,
	FC_BOTH = 3,
};

enum flow_dissect_ret {
	FLOW_DISSECT_RET_OUT_GOOD = 0,
	FLOW_DISSECT_RET_OUT_BAD = 1,
	FLOW_DISSECT_RET_PROTO_AGAIN = 2,
	FLOW_DISSECT_RET_IPPROTO_AGAIN = 3,
	FLOW_DISSECT_RET_CONTINUE = 4,
};

enum flow_dissector_ctrl_flags {
	FLOW_DIS_IS_FRAGMENT = 1,
	FLOW_DIS_FIRST_FRAG = 2,
	FLOW_DIS_F_TUNNEL_CSUM = 4,
	FLOW_DIS_F_TUNNEL_DONT_FRAGMENT = 8,
	FLOW_DIS_F_TUNNEL_OAM = 16,
	FLOW_DIS_F_TUNNEL_CRIT_OPT = 32,
	FLOW_DIS_ENCAPSULATION = 64,
};

enum flow_dissector_key_id {
	FLOW_DISSECTOR_KEY_CONTROL = 0,
	FLOW_DISSECTOR_KEY_BASIC = 1,
	FLOW_DISSECTOR_KEY_IPV4_ADDRS = 2,
	FLOW_DISSECTOR_KEY_IPV6_ADDRS = 3,
	FLOW_DISSECTOR_KEY_PORTS = 4,
	FLOW_DISSECTOR_KEY_PORTS_RANGE = 5,
	FLOW_DISSECTOR_KEY_ICMP = 6,
	FLOW_DISSECTOR_KEY_ETH_ADDRS = 7,
	FLOW_DISSECTOR_KEY_TIPC = 8,
	FLOW_DISSECTOR_KEY_ARP = 9,
	FLOW_DISSECTOR_KEY_VLAN = 10,
	FLOW_DISSECTOR_KEY_FLOW_LABEL = 11,
	FLOW_DISSECTOR_KEY_GRE_KEYID = 12,
	FLOW_DISSECTOR_KEY_MPLS_ENTROPY = 13,
	FLOW_DISSECTOR_KEY_ENC_KEYID = 14,
	FLOW_DISSECTOR_KEY_ENC_IPV4_ADDRS = 15,
	FLOW_DISSECTOR_KEY_ENC_IPV6_ADDRS = 16,
	FLOW_DISSECTOR_KEY_ENC_CONTROL = 17,
	FLOW_DISSECTOR_KEY_ENC_PORTS = 18,
	FLOW_DISSECTOR_KEY_MPLS = 19,
	FLOW_DISSECTOR_KEY_TCP = 20,
	FLOW_DISSECTOR_KEY_IP = 21,
	FLOW_DISSECTOR_KEY_CVLAN = 22,
	FLOW_DISSECTOR_KEY_ENC_IP = 23,
	FLOW_DISSECTOR_KEY_ENC_OPTS = 24,
	FLOW_DISSECTOR_KEY_META = 25,
	FLOW_DISSECTOR_KEY_CT = 26,
	FLOW_DISSECTOR_KEY_HASH = 27,
	FLOW_DISSECTOR_KEY_NUM_OF_VLANS = 28,
	FLOW_DISSECTOR_KEY_PPPOE = 29,
	FLOW_DISSECTOR_KEY_L2TPV3 = 30,
	FLOW_DISSECTOR_KEY_CFM = 31,
	FLOW_DISSECTOR_KEY_IPSEC = 32,
	FLOW_DISSECTOR_KEY_MAX = 33,
};

enum fman_dma_aid_mode {
	FMAN_DMA_AID_OUT_PORT_ID = 0,
	FMAN_DMA_AID_OUT_TNUM = 1,
};

enum fman_event_modules {
	FMAN_MOD_MAC = 0,
	FMAN_MOD_FMAN_CTRL = 1,
	FMAN_MOD_DUMMY_LAST = 2,
};

enum fman_exceptions {
	FMAN_EX_DMA_BUS_ERROR = 0,
	FMAN_EX_DMA_READ_ECC = 1,
	FMAN_EX_DMA_SYSTEM_WRITE_ECC = 2,
	FMAN_EX_DMA_FM_WRITE_ECC = 3,
	FMAN_EX_DMA_SINGLE_PORT_ECC = 4,
	FMAN_EX_FPM_STALL_ON_TASKS = 5,
	FMAN_EX_FPM_SINGLE_ECC = 6,
	FMAN_EX_FPM_DOUBLE_ECC = 7,
	FMAN_EX_QMI_SINGLE_ECC = 8,
	FMAN_EX_QMI_DOUBLE_ECC = 9,
	FMAN_EX_QMI_DEQ_FROM_UNKNOWN_PORTID = 10,
	FMAN_EX_BMI_LIST_RAM_ECC = 11,
	FMAN_EX_BMI_STORAGE_PROFILE_ECC = 12,
	FMAN_EX_BMI_STATISTICS_RAM_ECC = 13,
	FMAN_EX_BMI_DISPATCH_RAM_ECC = 14,
	FMAN_EX_IRAM_ECC = 15,
	FMAN_EX_MURAM_ECC = 16,
};

enum fman_inter_module_event {
	FMAN_EV_ERR_MAC0 = 0,
	FMAN_EV_ERR_MAC1 = 1,
	FMAN_EV_ERR_MAC2 = 2,
	FMAN_EV_ERR_MAC3 = 3,
	FMAN_EV_ERR_MAC4 = 4,
	FMAN_EV_ERR_MAC5 = 5,
	FMAN_EV_ERR_MAC6 = 6,
	FMAN_EV_ERR_MAC7 = 7,
	FMAN_EV_ERR_MAC8 = 8,
	FMAN_EV_ERR_MAC9 = 9,
	FMAN_EV_MAC0 = 10,
	FMAN_EV_MAC1 = 11,
	FMAN_EV_MAC2 = 12,
	FMAN_EV_MAC3 = 13,
	FMAN_EV_MAC4 = 14,
	FMAN_EV_MAC5 = 15,
	FMAN_EV_MAC6 = 16,
	FMAN_EV_MAC7 = 17,
	FMAN_EV_MAC8 = 18,
	FMAN_EV_MAC9 = 19,
	FMAN_EV_FMAN_CTRL_0 = 20,
	FMAN_EV_FMAN_CTRL_1 = 21,
	FMAN_EV_FMAN_CTRL_2 = 22,
	FMAN_EV_FMAN_CTRL_3 = 23,
	FMAN_EV_CNT = 24,
};

enum fman_intr_type {
	FMAN_INTR_TYPE_ERR = 0,
	FMAN_INTR_TYPE_NORMAL = 1,
};

enum fman_mac_exceptions {
	FM_MAC_EX_10G_MDIO_SCAN_EVENT = 0,
	FM_MAC_EX_10G_MDIO_CMD_CMPL = 1,
	FM_MAC_EX_10G_REM_FAULT = 2,
	FM_MAC_EX_10G_LOC_FAULT = 3,
	FM_MAC_EX_10G_TX_ECC_ER = 4,
	FM_MAC_EX_10G_TX_FIFO_UNFL = 5,
	FM_MAC_EX_10G_TX_FIFO_OVFL = 6,
	FM_MAC_EX_10G_TX_ER = 7,
	FM_MAC_EX_10G_RX_FIFO_OVFL = 8,
	FM_MAC_EX_10G_RX_ECC_ER = 9,
	FM_MAC_EX_10G_RX_JAB_FRM = 10,
	FM_MAC_EX_10G_RX_OVRSZ_FRM = 11,
	FM_MAC_EX_10G_RX_RUNT_FRM = 12,
	FM_MAC_EX_10G_RX_FRAG_FRM = 13,
	FM_MAC_EX_10G_RX_LEN_ER = 14,
	FM_MAC_EX_10G_RX_CRC_ER = 15,
	FM_MAC_EX_10G_RX_ALIGN_ER = 16,
	FM_MAC_EX_1G_BAB_RX = 17,
	FM_MAC_EX_1G_RX_CTL = 18,
	FM_MAC_EX_1G_GRATEFUL_TX_STP_COMPLET = 19,
	FM_MAC_EX_1G_BAB_TX = 20,
	FM_MAC_EX_1G_TX_CTL = 21,
	FM_MAC_EX_1G_TX_ERR = 22,
	FM_MAC_EX_1G_LATE_COL = 23,
	FM_MAC_EX_1G_COL_RET_LMT = 24,
	FM_MAC_EX_1G_TX_FIFO_UNDRN = 25,
	FM_MAC_EX_1G_MAG_PCKT = 26,
	FM_MAC_EX_1G_MII_MNG_RD_COMPLET = 27,
	FM_MAC_EX_1G_MII_MNG_WR_COMPLET = 28,
	FM_MAC_EX_1G_GRATEFUL_RX_STP_COMPLET = 29,
	FM_MAC_EX_1G_DATA_ERR = 30,
	FM_MAC_1G_RX_DATA_ERR = 31,
	FM_MAC_EX_1G_1588_TS_RX_ERR = 32,
	FM_MAC_EX_1G_RX_MIB_CNT_OVFL = 33,
	FM_MAC_EX_TS_FIFO_ECC_ERR = 34,
	FM_MAC_EX_MAGIC_PACKET_INDICATION = 26,
};

enum fman_port_color {
	FMAN_PORT_COLOR_GREEN = 0,
	FMAN_PORT_COLOR_YELLOW = 1,
	FMAN_PORT_COLOR_RED = 2,
	FMAN_PORT_COLOR_OVERRIDE = 3,
};

enum fman_port_deq_prefetch {
	FMAN_PORT_DEQ_NO_PREFETCH = 0,
	FMAN_PORT_DEQ_PART_PREFETCH = 1,
	FMAN_PORT_DEQ_FULL_PREFETCH = 2,
};

enum fman_port_deq_type {
	FMAN_PORT_DEQ_BY_PRI = 0,
	FMAN_PORT_DEQ_ACTIVE_FQ = 1,
	FMAN_PORT_DEQ_ACTIVE_FQ_NO_ICS = 2,
};

enum fman_port_dma_swap {
	FMAN_PORT_DMA_NO_SWAP = 0,
	FMAN_PORT_DMA_SWAP_LE = 1,
	FMAN_PORT_DMA_SWAP_BE = 2,
};

enum fman_port_type {
	FMAN_PORT_TYPE_TX = 0,
	FMAN_PORT_TYPE_RX = 1,
};

enum folio_references {
	FOLIOREF_RECLAIM = 0,
	FOLIOREF_RECLAIM_CLEAN = 1,
	FOLIOREF_KEEP = 2,
	FOLIOREF_ACTIVATE = 3,
};

enum folio_walk_level {
	FW_LEVEL_PTE = 0,
	FW_LEVEL_PMD = 1,
	FW_LEVEL_PUD = 2,
};

enum format_state {
	FORMAT_STATE_NONE = 0,
	FORMAT_STATE_NUM = 1,
	FORMAT_STATE_WIDTH = 2,
	FORMAT_STATE_PRECISION = 3,
	FORMAT_STATE_CHAR = 4,
	FORMAT_STATE_STR = 5,
	FORMAT_STATE_PTR = 6,
	FORMAT_STATE_PERCENT_CHAR = 7,
	FORMAT_STATE_INVALID = 8,
};

enum forward_type {
	FILTER_ACTION_TYPE_PSFP = 1,
	FILTER_ACTION_TYPE_ACL = 2,
	FILTER_ACTION_TYPE_BOTH = 3,
};

enum fp_type {
	FP_STATE_CURRENT = 0,
	FP_STATE_FPSIMD = 1,
	FP_STATE_SVE = 2,
};

enum fpga_mgr_states {
	FPGA_MGR_STATE_UNKNOWN = 0,
	FPGA_MGR_STATE_POWER_OFF = 1,
	FPGA_MGR_STATE_POWER_UP = 2,
	FPGA_MGR_STATE_RESET = 3,
	FPGA_MGR_STATE_FIRMWARE_REQ = 4,
	FPGA_MGR_STATE_FIRMWARE_REQ_ERR = 5,
	FPGA_MGR_STATE_PARSE_HEADER = 6,
	FPGA_MGR_STATE_PARSE_HEADER_ERR = 7,
	FPGA_MGR_STATE_WRITE_INIT = 8,
	FPGA_MGR_STATE_WRITE_INIT_ERR = 9,
	FPGA_MGR_STATE_WRITE = 10,
	FPGA_MGR_STATE_WRITE_ERR = 11,
	FPGA_MGR_STATE_WRITE_COMPLETE = 12,
	FPGA_MGR_STATE_WRITE_COMPLETE_ERR = 13,
	FPGA_MGR_STATE_OPERATING = 14,
};

enum freeze_holder {
	FREEZE_HOLDER_KERNEL = 1,
	FREEZE_HOLDER_USERSPACE = 2,
	FREEZE_MAY_NEST = 4,
	FREEZE_EXCL = 8,
};

enum freezer_state_flags {
	CGROUP_FREEZER_ONLINE = 1,
	CGROUP_FREEZING_SELF = 2,
	CGROUP_FREEZING_PARENT = 4,
	CGROUP_FROZEN = 8,
	CGROUP_FREEZING = 6,
};

enum freq_policy {
	FLOOR = 0,
	CEIL = 1,
};

enum freq_qos_req_type {
	FREQ_QOS_MIN = 1,
	FREQ_QOS_MAX = 2,
};

enum fs_context_phase {
	FS_CONTEXT_CREATE_PARAMS = 0,
	FS_CONTEXT_CREATING = 1,
	FS_CONTEXT_AWAITING_MOUNT = 2,
	FS_CONTEXT_AWAITING_RECONF = 3,
	FS_CONTEXT_RECONF_PARAMS = 4,
	FS_CONTEXT_RECONFIGURING = 5,
	FS_CONTEXT_FAILED = 6,
};

enum fs_context_purpose {
	FS_CONTEXT_FOR_MOUNT = 0,
	FS_CONTEXT_FOR_SUBMOUNT = 1,
	FS_CONTEXT_FOR_RECONFIGURE = 2,
};

enum fs_value_type {
	fs_value_is_undefined = 0,
	fs_value_is_flag = 1,
	fs_value_is_string = 2,
	fs_value_is_blob = 3,
	fs_value_is_filename = 4,
	fs_value_is_file = 5,
};

enum fscache_cache_state {
	FSCACHE_CACHE_IS_NOT_PRESENT = 0,
	FSCACHE_CACHE_IS_PREPARING = 1,
	FSCACHE_CACHE_IS_ACTIVE = 2,
	FSCACHE_CACHE_GOT_IOERROR = 3,
	FSCACHE_CACHE_IS_WITHDRAWN = 4,
};

enum fscache_cookie_state {
	FSCACHE_COOKIE_STATE_QUIESCENT = 0,
	FSCACHE_COOKIE_STATE_LOOKING_UP = 1,
	FSCACHE_COOKIE_STATE_CREATING = 2,
	FSCACHE_COOKIE_STATE_ACTIVE = 3,
	FSCACHE_COOKIE_STATE_INVALIDATING = 4,
	FSCACHE_COOKIE_STATE_FAILED = 5,
	FSCACHE_COOKIE_STATE_LRU_DISCARDING = 6,
	FSCACHE_COOKIE_STATE_WITHDRAWING = 7,
	FSCACHE_COOKIE_STATE_RELINQUISHING = 8,
	FSCACHE_COOKIE_STATE_DROPPED = 9,
} __attribute__((mode(byte)));

enum fscache_want_state {
	FSCACHE_WANT_PARAMS = 0,
	FSCACHE_WANT_WRITE = 1,
	FSCACHE_WANT_READ = 2,
};

enum fsconfig_command {
	FSCONFIG_SET_FLAG = 0,
	FSCONFIG_SET_STRING = 1,
	FSCONFIG_SET_BINARY = 2,
	FSCONFIG_SET_PATH = 3,
	FSCONFIG_SET_PATH_EMPTY = 4,
	FSCONFIG_SET_FD = 5,
	FSCONFIG_CMD_CREATE = 6,
	FSCONFIG_CMD_RECONFIGURE = 7,
	FSCONFIG_CMD_CREATE_EXCL = 8,
};

enum fsl_edma_pm_state {
	RUNNING = 0,
	SUSPENDED = 1,
};

enum fsl_mc_pool_type {
	FSL_MC_POOL_DPMCP = 0,
	FSL_MC_POOL_DPBP = 1,
	FSL_MC_POOL_DPCON = 2,
	FSL_MC_POOL_IRQ = 3,
	FSL_MC_NUM_POOL_TYPES = 4,
};

enum fsnotify_data_type {
	FSNOTIFY_EVENT_NONE = 0,
	FSNOTIFY_EVENT_FILE_RANGE = 1,
	FSNOTIFY_EVENT_PATH = 2,
	FSNOTIFY_EVENT_INODE = 3,
	FSNOTIFY_EVENT_DENTRY = 4,
	FSNOTIFY_EVENT_MNT = 5,
	FSNOTIFY_EVENT_ERROR = 6,
};

enum fsnotify_group_prio {
	FSNOTIFY_PRIO_NORMAL = 0,
	FSNOTIFY_PRIO_CONTENT = 1,
	FSNOTIFY_PRIO_PRE_CONTENT = 2,
	__FSNOTIFY_PRIO_NUM = 3,
};

enum fsnotify_iter_type {
	FSNOTIFY_ITER_TYPE_INODE = 0,
	FSNOTIFY_ITER_TYPE_VFSMOUNT = 1,
	FSNOTIFY_ITER_TYPE_SB = 2,
	FSNOTIFY_ITER_TYPE_PARENT = 3,
	FSNOTIFY_ITER_TYPE_INODE2 = 4,
	FSNOTIFY_ITER_TYPE_MNTNS = 5,
	FSNOTIFY_ITER_TYPE_COUNT = 6,
};

enum fsnotify_obj_type {
	FSNOTIFY_OBJ_TYPE_ANY = -1,
	FSNOTIFY_OBJ_TYPE_INODE = 0,
	FSNOTIFY_OBJ_TYPE_VFSMOUNT = 1,
	FSNOTIFY_OBJ_TYPE_SB = 2,
	FSNOTIFY_OBJ_TYPE_MNTNS = 3,
	FSNOTIFY_OBJ_TYPE_COUNT = 4,
	FSNOTIFY_OBJ_TYPE_DETACHED = 4,
};

enum ftr_type {
	FTR_EXACT = 0,
	FTR_LOWER_SAFE = 1,
	FTR_HIGHER_SAFE = 2,
	FTR_HIGHER_OR_ZERO_SAFE = 3,
};

enum ftrace_dump_mode {
	DUMP_NONE = 0,
	DUMP_ALL = 1,
	DUMP_ORIG = 2,
	DUMP_PARAM = 3,
};

enum fuse_dax_mode {
	FUSE_DAX_INODE_DEFAULT = 0,
	FUSE_DAX_ALWAYS = 1,
	FUSE_DAX_NEVER = 2,
	FUSE_DAX_INODE_USER = 3,
};

enum fuse_ext_type {
	FUSE_MAX_NR_SECCTX = 31,
	FUSE_EXT_GROUPS = 32,
};

enum fuse_notify_code {
	FUSE_NOTIFY_POLL = 1,
	FUSE_NOTIFY_INVAL_INODE = 2,
	FUSE_NOTIFY_INVAL_ENTRY = 3,
	FUSE_NOTIFY_STORE = 4,
	FUSE_NOTIFY_RETRIEVE = 5,
	FUSE_NOTIFY_DELETE = 6,
	FUSE_NOTIFY_RESEND = 7,
	FUSE_NOTIFY_INC_EPOCH = 8,
	FUSE_NOTIFY_PRUNE = 9,
};

enum fuse_opcode {
	FUSE_LOOKUP = 1,
	FUSE_FORGET = 2,
	FUSE_GETATTR = 3,
	FUSE_SETATTR = 4,
	FUSE_READLINK = 5,
	FUSE_SYMLINK = 6,
	FUSE_MKNOD = 8,
	FUSE_MKDIR = 9,
	FUSE_UNLINK = 10,
	FUSE_RMDIR = 11,
	FUSE_RENAME = 12,
	FUSE_LINK = 13,
	FUSE_OPEN = 14,
	FUSE_READ = 15,
	FUSE_WRITE = 16,
	FUSE_STATFS = 17,
	FUSE_RELEASE = 18,
	FUSE_FSYNC = 20,
	FUSE_SETXATTR = 21,
	FUSE_GETXATTR = 22,
	FUSE_LISTXATTR = 23,
	FUSE_REMOVEXATTR = 24,
	FUSE_FLUSH = 25,
	FUSE_INIT = 26,
	FUSE_OPENDIR = 27,
	FUSE_READDIR = 28,
	FUSE_RELEASEDIR = 29,
	FUSE_FSYNCDIR = 30,
	FUSE_GETLK = 31,
	FUSE_SETLK = 32,
	FUSE_SETLKW = 33,
	FUSE_ACCESS = 34,
	FUSE_CREATE = 35,
	FUSE_INTERRUPT = 36,
	FUSE_BMAP = 37,
	FUSE_DESTROY = 38,
	FUSE_IOCTL = 39,
	FUSE_POLL = 40,
	FUSE_NOTIFY_REPLY = 41,
	FUSE_BATCH_FORGET = 42,
	FUSE_FALLOCATE = 43,
	FUSE_READDIRPLUS = 44,
	FUSE_RENAME2 = 45,
	FUSE_LSEEK = 46,
	FUSE_COPY_FILE_RANGE = 47,
	FUSE_SETUPMAPPING = 48,
	FUSE_REMOVEMAPPING = 49,
	FUSE_SYNCFS = 50,
	FUSE_TMPFILE = 51,
	FUSE_STATX = 52,
	FUSE_COPY_FILE_RANGE_64 = 53,
	CUSE_INIT = 4096,
	CUSE_INIT_BSWAP_RESERVED = 1048576,
	FUSE_INIT_BSWAP_RESERVED = 436207616,
};

enum fuse_parse_result {
	FOUND_ERR = -1,
	FOUND_NONE = 0,
	FOUND_SOME = 1,
	FOUND_ALL = 2,
};

enum fuse_req_flag {
	FR_ISREPLY = 0,
	FR_FORCE = 1,
	FR_BACKGROUND = 2,
	FR_WAITING = 3,
	FR_ABORTED = 4,
	FR_INTERRUPTED = 5,
	FR_LOCKED = 6,
	FR_PENDING = 7,
	FR_SENT = 8,
	FR_FINISHED = 9,
	FR_PRIVATE = 10,
	FR_ASYNC = 11,
	FR_URING = 12,
};

enum fuse_ring_req_state {
	FRRS_INVALID = 0,
	FRRS_COMMIT = 1,
	FRRS_AVAILABLE = 2,
	FRRS_FUSE_REQ = 3,
	FRRS_USERSPACE = 4,
	FRRS_TEARDOWN = 5,
	FRRS_RELEASED = 6,
};

enum fuse_uring_cmd {
	FUSE_IO_URING_CMD_INVALID = 0,
	FUSE_IO_URING_CMD_REGISTER = 1,
	FUSE_IO_URING_CMD_COMMIT_AND_FETCH = 2,
};

enum futex_access {
	FUTEX_READ = 0,
	FUTEX_WRITE = 1,
};

enum fw_opt {
	FW_OPT_UEVENT = 1,
	FW_OPT_NOWAIT = 2,
	FW_OPT_USERHELPER = 4,
	FW_OPT_NO_WARN = 8,
	FW_OPT_NOCACHE = 16,
	FW_OPT_NOFALLBACK_SYSFS = 32,
	FW_OPT_FALLBACK_PLATFORM = 64,
	FW_OPT_PARTIAL = 128,
};

enum fw_resource_type {
	RSC_CARVEOUT = 0,
	RSC_DEVMEM = 1,
	RSC_TRACE = 2,
	RSC_VDEV = 3,
	RSC_LAST = 4,
	RSC_VENDOR_START = 128,
	RSC_VENDOR_END = 512,
};

enum fw_status {
	FW_STATUS_UNKNOWN = 0,
	FW_STATUS_LOADING = 1,
	FW_STATUS_DONE = 2,
	FW_STATUS_ABORTED = 3,
};

enum fw_upload_err {
	FW_UPLOAD_ERR_NONE = 0,
	FW_UPLOAD_ERR_HW_ERROR = 1,
	FW_UPLOAD_ERR_TIMEOUT = 2,
	FW_UPLOAD_ERR_CANCELED = 3,
	FW_UPLOAD_ERR_BUSY = 4,
	FW_UPLOAD_ERR_INVALID_SIZE = 5,
	FW_UPLOAD_ERR_RW_ERROR = 6,
	FW_UPLOAD_ERR_WEAROUT = 7,
	FW_UPLOAD_ERR_FW_INVALID = 8,
	FW_UPLOAD_ERR_MAX = 9,
};

enum fw_upload_prog {
	FW_UPLOAD_PROG_IDLE = 0,
	FW_UPLOAD_PROG_RECEIVING = 1,
	FW_UPLOAD_PROG_PREPARING = 2,
	FW_UPLOAD_PROG_TRANSFERRING = 3,
	FW_UPLOAD_PROG_PROGRAMMING = 4,
	FW_UPLOAD_PROG_MAX = 5,
};

enum fwh_lock_state {
	FWH_UNLOCKED = 0,
	FWH_DENY_WRITE = 1,
	FWH_IMMUTABLE = 2,
	FWH_DENY_READ = 4,
};

enum gdsc_status {
	GDSC_OFF = 0,
	GDSC_ON = 1,
};

enum geni_icc_path_index {
	GENI_TO_CORE = 0,
	CPU_TO_GENI = 1,
	GENI_TO_DDR = 2,
};

enum geni_se_protocol_type {
	GENI_SE_NONE = 0,
	GENI_SE_SPI = 1,
	GENI_SE_UART = 2,
	GENI_SE_I2C = 3,
	GENI_SE_I3C = 4,
	GENI_SE_SPI_SLAVE = 5,
	GENI_SE_INVALID_PROTO = 255,
};

enum geni_se_xfer_mode {
	GENI_SE_INVALID = 0,
	GENI_SE_FIFO = 1,
	GENI_SE_DMA = 2,
	GENI_GPI_DMA = 3,
};

enum genl_validate_flags {
	GENL_DONT_VALIDATE_STRICT = 1,
	GENL_DONT_VALIDATE_DUMP = 2,
	GENL_DONT_VALIDATE_DUMP_STRICT = 4,
};

enum genpd_notication {
	GENPD_NOTIFY_PRE_OFF = 0,
	GENPD_NOTIFY_OFF = 1,
	GENPD_NOTIFY_PRE_ON = 2,
	GENPD_NOTIFY_ON = 3,
};

enum genpd_sync_state {
	GENPD_SYNC_STATE_OFF = 0,
	GENPD_SYNC_STATE_SIMPLE = 1,
	GENPD_SYNC_STATE_ONECELL = 2,
};

enum geometry_desc_param {
	GEOMETRY_DESC_PARAM_LEN = 0,
	GEOMETRY_DESC_PARAM_TYPE = 1,
	GEOMETRY_DESC_PARAM_DEV_CAP = 4,
	GEOMETRY_DESC_PARAM_MAX_NUM_LUN = 12,
	GEOMETRY_DESC_PARAM_SEG_SIZE = 13,
	GEOMETRY_DESC_PARAM_ALLOC_UNIT_SIZE = 17,
	GEOMETRY_DESC_PARAM_MIN_BLK_SIZE = 18,
	GEOMETRY_DESC_PARAM_OPT_RD_BLK_SIZE = 19,
	GEOMETRY_DESC_PARAM_OPT_WR_BLK_SIZE = 20,
	GEOMETRY_DESC_PARAM_MAX_IN_BUF_SIZE = 21,
	GEOMETRY_DESC_PARAM_MAX_OUT_BUF_SIZE = 22,
	GEOMETRY_DESC_PARAM_RPMB_RW_SIZE = 23,
	GEOMETRY_DESC_PARAM_DYN_CAP_RSRC_PLC = 24,
	GEOMETRY_DESC_PARAM_DATA_ORDER = 25,
	GEOMETRY_DESC_PARAM_MAX_NUM_CTX = 26,
	GEOMETRY_DESC_PARAM_TAG_UNIT_SIZE = 27,
	GEOMETRY_DESC_PARAM_TAG_RSRC_SIZE = 28,
	GEOMETRY_DESC_PARAM_SEC_RM_TYPES = 29,
	GEOMETRY_DESC_PARAM_MEM_TYPES = 30,
	GEOMETRY_DESC_PARAM_SCM_MAX_NUM_UNITS = 32,
	GEOMETRY_DESC_PARAM_SCM_CAP_ADJ_FCTR = 36,
	GEOMETRY_DESC_PARAM_NPM_MAX_NUM_UNITS = 38,
	GEOMETRY_DESC_PARAM_NPM_CAP_ADJ_FCTR = 42,
	GEOMETRY_DESC_PARAM_ENM1_MAX_NUM_UNITS = 44,
	GEOMETRY_DESC_PARAM_ENM1_CAP_ADJ_FCTR = 48,
	GEOMETRY_DESC_PARAM_ENM2_MAX_NUM_UNITS = 50,
	GEOMETRY_DESC_PARAM_ENM2_CAP_ADJ_FCTR = 54,
	GEOMETRY_DESC_PARAM_ENM3_MAX_NUM_UNITS = 56,
	GEOMETRY_DESC_PARAM_ENM3_CAP_ADJ_FCTR = 60,
	GEOMETRY_DESC_PARAM_ENM4_MAX_NUM_UNITS = 62,
	GEOMETRY_DESC_PARAM_ENM4_CAP_ADJ_FCTR = 66,
	GEOMETRY_DESC_PARAM_OPT_LOG_BLK_SIZE = 68,
	GEOMETRY_DESC_PARAM_HPB_REGION_SIZE = 72,
	GEOMETRY_DESC_PARAM_HPB_NUMBER_LU = 73,
	GEOMETRY_DESC_PARAM_HPB_SUBREGION_SIZE = 74,
	GEOMETRY_DESC_PARAM_HPB_MAX_ACTIVE_REGS = 75,
	GEOMETRY_DESC_PARAM_WB_MAX_ALLOC_UNITS = 79,
	GEOMETRY_DESC_PARAM_WB_MAX_WB_LUNS = 83,
	GEOMETRY_DESC_PARAM_WB_BUFF_CAP_ADJ = 84,
	GEOMETRY_DESC_PARAM_WB_SUP_RED_TYPE = 85,
	GEOMETRY_DESC_PARAM_WB_SUP_WB_TYPE = 86,
};

enum gic_intid_range {
	SGI_RANGE = 0,
	PPI_RANGE = 1,
	SPI_RANGE = 2,
	EPPI_RANGE = 3,
	ESPI_RANGE = 4,
	LPI_RANGE = 5,
	__INVALID_RANGE__ = 6,
};

enum gic_type {
	GIC_V2 = 0,
	GIC_V3 = 1,
	GIC_V5 = 2,
};

enum gio_reg_index {
	GIO_REG_ODEN = 0,
	GIO_REG_DATA = 1,
	GIO_REG_IODIR = 2,
	GIO_REG_EC = 3,
	GIO_REG_EI = 4,
	GIO_REG_MASK = 5,
	GIO_REG_LEVEL = 6,
	GIO_REG_STAT = 7,
	NUMBER_OF_GIO_REGISTERS = 8,
};

enum gpd_status {
	GENPD_STATE_ON = 0,
	GENPD_STATE_OFF = 1,
};

enum gpio_lookup_flags {
	GPIO_ACTIVE_HIGH = 0,
	GPIO_ACTIVE_LOW = 1,
	GPIO_OPEN_DRAIN = 2,
	GPIO_OPEN_SOURCE = 4,
	GPIO_PERSISTENT = 0,
	GPIO_TRANSITORY = 8,
	GPIO_PULL_UP = 16,
	GPIO_PULL_DOWN = 32,
	GPIO_PULL_DISABLE = 64,
	GPIO_LOOKUP_FLAGS_DEFAULT = 0,
};

enum gpio_v2_line_attr_id {
	GPIO_V2_LINE_ATTR_ID_FLAGS = 1,
	GPIO_V2_LINE_ATTR_ID_OUTPUT_VALUES = 2,
	GPIO_V2_LINE_ATTR_ID_DEBOUNCE = 3,
};

enum gpio_v2_line_changed_type {
	GPIO_V2_LINE_CHANGED_REQUESTED = 1,
	GPIO_V2_LINE_CHANGED_RELEASED = 2,
	GPIO_V2_LINE_CHANGED_CONFIG = 3,
};

enum gpio_v2_line_event_id {
	GPIO_V2_LINE_EVENT_RISING_EDGE = 1,
	GPIO_V2_LINE_EVENT_FALLING_EDGE = 2,
};

enum gpio_v2_line_flag {
	GPIO_V2_LINE_FLAG_USED = 1,
	GPIO_V2_LINE_FLAG_ACTIVE_LOW = 2,
	GPIO_V2_LINE_FLAG_INPUT = 4,
	GPIO_V2_LINE_FLAG_OUTPUT = 8,
	GPIO_V2_LINE_FLAG_EDGE_RISING = 16,
	GPIO_V2_LINE_FLAG_EDGE_FALLING = 32,
	GPIO_V2_LINE_FLAG_OPEN_DRAIN = 64,
	GPIO_V2_LINE_FLAG_OPEN_SOURCE = 128,
	GPIO_V2_LINE_FLAG_BIAS_PULL_UP = 256,
	GPIO_V2_LINE_FLAG_BIAS_PULL_DOWN = 512,
	GPIO_V2_LINE_FLAG_BIAS_DISABLED = 1024,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_REALTIME = 2048,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_HTE = 4096,
};

enum gpiod_flags {
	GPIOD_ASIS = 0,
	GPIOD_IN = 1,
	GPIOD_OUT_LOW = 3,
	GPIOD_OUT_HIGH = 7,
	GPIOD_OUT_LOW_OPEN_DRAIN = 11,
	GPIOD_OUT_HIGH_OPEN_DRAIN = 15,
};

enum gro_result {
	GRO_MERGED = 0,
	GRO_MERGED_FREE = 1,
	GRO_HELD = 2,
	GRO_NORMAL = 3,
	GRO_CONSUMED = 4,
};

typedef enum gro_result gro_result_t;

enum group_type {
	group_has_spare = 0,
	group_fully_busy = 1,
	group_misfit_task = 2,
	group_smt_balance = 3,
	group_asym_packing = 4,
	group_imbalanced = 5,
	group_overloaded = 6,
};

enum hal_dsaf_mode {
	HRD_DSAF_NO_DSAF_MODE = 0,
	HRD_DSAF_MODE = 1,
};

enum hal_dsaf_tc_mode {
	HRD_DSAF_4TC_MODE = 0,
	HRD_DSAF_8TC_MODE = 1,
};

enum handle_to_path_flags {
	HANDLE_CHECK_PERMS = 1,
	HANDLE_CHECK_SUBTREE = 2,
};

enum handshake_auth {
	HANDSHAKE_AUTH_UNSPEC = 0,
	HANDSHAKE_AUTH_UNAUTH = 1,
	HANDSHAKE_AUTH_PSK = 2,
	HANDSHAKE_AUTH_X509 = 3,
};

enum handshake_handler_class {
	HANDSHAKE_HANDLER_CLASS_NONE = 0,
	HANDSHAKE_HANDLER_CLASS_TLSHD = 1,
	HANDSHAKE_HANDLER_CLASS_MAX = 2,
};

enum handshake_msg_type {
	HANDSHAKE_MSG_TYPE_UNSPEC = 0,
	HANDSHAKE_MSG_TYPE_CLIENTHELLO = 1,
	HANDSHAKE_MSG_TYPE_SERVERHELLO = 2,
};

enum hash_algo {
	HASH_ALGO_MD4 = 0,
	HASH_ALGO_MD5 = 1,
	HASH_ALGO_SHA1 = 2,
	HASH_ALGO_RIPE_MD_160 = 3,
	HASH_ALGO_SHA256 = 4,
	HASH_ALGO_SHA384 = 5,
	HASH_ALGO_SHA512 = 6,
	HASH_ALGO_SHA224 = 7,
	HASH_ALGO_RIPE_MD_128 = 8,
	HASH_ALGO_RIPE_MD_256 = 9,
	HASH_ALGO_RIPE_MD_320 = 10,
	HASH_ALGO_WP_256 = 11,
	HASH_ALGO_WP_384 = 12,
	HASH_ALGO_WP_512 = 13,
	HASH_ALGO_TGR_128 = 14,
	HASH_ALGO_TGR_160 = 15,
	HASH_ALGO_TGR_192 = 16,
	HASH_ALGO_SM3_256 = 17,
	HASH_ALGO_STREEBOG_256 = 18,
	HASH_ALGO_STREEBOG_512 = 19,
	HASH_ALGO_SHA3_256 = 20,
	HASH_ALGO_SHA3_384 = 21,
	HASH_ALGO_SHA3_512 = 22,
	HASH_ALGO__LAST = 23,
};

enum hash_pointers_policy {
	HASH_PTR_AUTO = 0,
	HASH_PTR_ALWAYS = 1,
	HASH_PTR_NEVER = 2,
};

enum hclge_comm_cmd_state {
	HCLGE_COMM_STATE_CMD_DISABLE = 0,
};

enum hclge_comm_cmd_status {
	HCLGE_COMM_STATUS_SUCCESS = 0,
	HCLGE_COMM_ERR_CSQ_FULL = -1,
	HCLGE_COMM_ERR_CSQ_TIMEOUT = -2,
	HCLGE_COMM_ERR_CSQ_ERROR = -3,
};

enum hclge_err_type_list {
	NONE_ERROR = 0,
	FIFO_ERROR = 1,
	MEMORY_ERROR = 2,
	POISON_ERROR = 3,
	MSIX_ECC_ERROR = 4,
	TQP_INT_ECC_ERROR = 5,
	PF_ABNORMAL_INT_ERROR = 6,
	MPF_ABNORMAL_INT_ERROR = 7,
	COMMON_ERROR = 8,
	PORT_ERROR = 9,
	ETS_ERROR = 10,
	NCSI_ERROR = 11,
	GLB_ERROR = 12,
	LINK_ERROR = 13,
	PTP_ERROR = 14,
	ROCEE_NORMAL_ERR = 40,
	ROCEE_OVF_ERR = 41,
	ROCEE_BUS_ERR = 42,
};

enum hclge_evt_cause {
	HCLGE_VECTOR0_EVENT_RST = 0,
	HCLGE_VECTOR0_EVENT_MBX = 1,
	HCLGE_VECTOR0_EVENT_ERR = 2,
	HCLGE_VECTOR0_EVENT_PTP = 3,
	HCLGE_VECTOR0_EVENT_OTHER = 4,
};

enum hclge_fc_mode {
	HCLGE_FC_NONE = 0,
	HCLGE_FC_RX_PAUSE = 1,
	HCLGE_FC_TX_PAUSE = 2,
	HCLGE_FC_FULL = 3,
	HCLGE_FC_PFC = 4,
	HCLGE_FC_DEFAULT = 5,
};

enum hclge_hilink_version {
	HCLGE_HILINK_H32 = 0,
	HCLGE_HILINK_H60 = 1,
};

enum hclge_led_status {
	HCLGE_LED_OFF = 0,
	HCLGE_LED_ON = 1,
	HCLGE_LED_NO_CHANGE = 255,
};

enum hclge_link_fail_code {
	HCLGE_LF_NORMAL = 0,
	HCLGE_LF_REF_CLOCK_LOST = 1,
	HCLGE_LF_XSFP_TX_DISABLE = 2,
	HCLGE_LF_XSFP_ABSENT = 3,
};

enum hclge_mac_vlan_add_resp_code {
	HCLGE_ADD_UC_OVERFLOW = 2,
	HCLGE_ADD_MC_OVERFLOW = 3,
};

enum hclge_mac_vlan_cfg_sel {
	HCLGE_MAC_VLAN_NIC_SEL = 0,
	HCLGE_MAC_VLAN_ROCE_SEL = 1,
};

enum hclge_mac_vlan_tbl_opcode {
	HCLGE_MAC_VLAN_ADD = 0,
	HCLGE_MAC_VLAN_UPDATE = 1,
	HCLGE_MAC_VLAN_REMOVE = 2,
	HCLGE_MAC_VLAN_LKUP = 3,
};

enum hclge_mbx_mac_vlan_subcode {
	HCLGE_MBX_MAC_VLAN_UC_MODIFY = 0,
	HCLGE_MBX_MAC_VLAN_UC_ADD = 1,
	HCLGE_MBX_MAC_VLAN_UC_REMOVE = 2,
	HCLGE_MBX_MAC_VLAN_MC_MODIFY = 3,
	HCLGE_MBX_MAC_VLAN_MC_ADD = 4,
	HCLGE_MBX_MAC_VLAN_MC_REMOVE = 5,
};

enum hclge_mbx_tbl_cfg_subcode {
	HCLGE_MBX_VPORT_LIST_CLEAR = 0,
};

enum hclge_mbx_vlan_cfg_subcode {
	HCLGE_MBX_VLAN_FILTER = 0,
	HCLGE_MBX_VLAN_TX_OFF_CFG = 1,
	HCLGE_MBX_VLAN_RX_OFF_CFG = 2,
	HCLGE_MBX_PORT_BASE_VLAN_CFG = 3,
	HCLGE_MBX_GET_PORT_BASE_VLAN_STATE = 4,
	HCLGE_MBX_ENABLE_VLAN_FILTER = 5,
};

enum hclge_mdio_c22_op_seq {
	HCLGE_MDIO_C22_WRITE = 1,
	HCLGE_MDIO_C22_READ = 2,
};

enum hclge_mod_name_list {
	MODULE_NONE = 0,
	MODULE_BIOS_COMMON = 1,
	MODULE_GE = 2,
	MODULE_IGU_EGU = 3,
	MODULE_LGE = 4,
	MODULE_NCSI = 5,
	MODULE_PPP = 6,
	MODULE_QCN = 7,
	MODULE_RCB_RX = 8,
	MODULE_RTC = 9,
	MODULE_SSU = 10,
	MODULE_TM = 11,
	MODULE_RCB_TX = 12,
	MODULE_TXDMA = 13,
	MODULE_MASTER = 14,
	MODULE_HIMAC = 15,
	MODULE_ROCEE_TOP = 40,
	MODULE_ROCEE_TIMER = 41,
	MODULE_ROCEE_MDB = 42,
	MODULE_ROCEE_TSP = 43,
	MODULE_ROCEE_TRP = 44,
	MODULE_ROCEE_SCC = 45,
	MODULE_ROCEE_CAEP = 46,
	MODULE_ROCEE_GEN_AC = 47,
	MODULE_ROCEE_QMM = 48,
	MODULE_ROCEE_LSAN = 49,
};

enum hclge_opcode_type {
	HCLGE_OPC_QUERY_FW_VER = 1,
	HCLGE_OPC_CFG_RST_TRIGGER = 32,
	HCLGE_OPC_GBL_RST_STATUS = 33,
	HCLGE_OPC_QUERY_FUNC_STATUS = 34,
	HCLGE_OPC_QUERY_PF_RSRC = 35,
	HCLGE_OPC_QUERY_VF_RSRC = 36,
	HCLGE_OPC_GET_CFG_PARAM = 37,
	HCLGE_OPC_PF_RST_DONE = 38,
	HCLGE_OPC_QUERY_VF_RST_RDY = 39,
	HCLGE_OPC_STATS_64_BIT = 48,
	HCLGE_OPC_STATS_32_BIT = 49,
	HCLGE_OPC_STATS_MAC = 50,
	HCLGE_OPC_QUERY_MAC_REG_NUM = 51,
	HCLGE_OPC_STATS_MAC_ALL = 52,
	HCLGE_OPC_QUERY_REG_NUM = 64,
	HCLGE_OPC_QUERY_32_BIT_REG = 65,
	HCLGE_OPC_QUERY_64_BIT_REG = 66,
	HCLGE_OPC_DFX_BD_NUM = 67,
	HCLGE_OPC_DFX_BIOS_COMMON_REG = 68,
	HCLGE_OPC_DFX_SSU_REG_0 = 69,
	HCLGE_OPC_DFX_SSU_REG_1 = 70,
	HCLGE_OPC_DFX_IGU_EGU_REG = 71,
	HCLGE_OPC_DFX_RPU_REG_0 = 72,
	HCLGE_OPC_DFX_RPU_REG_1 = 73,
	HCLGE_OPC_DFX_NCSI_REG = 74,
	HCLGE_OPC_DFX_RTC_REG = 75,
	HCLGE_OPC_DFX_PPP_REG = 76,
	HCLGE_OPC_DFX_RCB_REG = 77,
	HCLGE_OPC_DFX_TQP_REG = 78,
	HCLGE_OPC_DFX_SSU_REG_2 = 79,
	HCLGE_OPC_DFX_GEN_REG = 28728,
	HCLGE_OPC_QUERY_DEV_SPECS = 80,
	HCLGE_OPC_GET_QUEUE_ERR_VF = 103,
	HCLGE_OPC_CONFIG_MAC_MODE = 769,
	HCLGE_OPC_CONFIG_AN_MODE = 772,
	HCLGE_OPC_QUERY_LINK_STATUS = 775,
	HCLGE_OPC_CONFIG_MAX_FRM_SIZE = 776,
	HCLGE_OPC_CONFIG_SPEED_DUP = 777,
	HCLGE_OPC_QUERY_MAC_TNL_INT = 784,
	HCLGE_OPC_MAC_TNL_INT_EN = 785,
	HCLGE_OPC_CLEAR_MAC_TNL_INT = 786,
	HCLGE_OPC_COMMON_LOOPBACK = 789,
	HCLGE_OPC_QUERY_FEC_STATS = 790,
	HCLGE_OPC_CONFIG_FEC_MODE = 794,
	HCLGE_OPC_QUERY_ROH_TYPE_INFO = 905,
	HCLGE_OPC_PTP_INT_EN = 1281,
	HCLGE_OPC_PTP_MODE_CFG = 1287,
	HCLGE_OPC_CFG_MAC_PAUSE_EN = 1793,
	HCLGE_OPC_CFG_PFC_PAUSE_EN = 1794,
	HCLGE_OPC_CFG_MAC_PARA = 1795,
	HCLGE_OPC_CFG_PFC_PARA = 1796,
	HCLGE_OPC_QUERY_MAC_TX_PKT_CNT = 1797,
	HCLGE_OPC_QUERY_MAC_RX_PKT_CNT = 1798,
	HCLGE_OPC_QUERY_PFC_TX_PKT_CNT = 1799,
	HCLGE_OPC_QUERY_PFC_RX_PKT_CNT = 1800,
	HCLGE_OPC_PRI_TO_TC_MAPPING = 1801,
	HCLGE_OPC_QOS_MAP = 1802,
	HCLGE_OPC_TM_PG_TO_PRI_LINK = 2052,
	HCLGE_OPC_TM_QS_TO_PRI_LINK = 2053,
	HCLGE_OPC_TM_NQ_TO_QS_LINK = 2054,
	HCLGE_OPC_TM_RQ_TO_QS_LINK = 2055,
	HCLGE_OPC_TM_PORT_WEIGHT = 2056,
	HCLGE_OPC_TM_PG_WEIGHT = 2057,
	HCLGE_OPC_TM_QS_WEIGHT = 2058,
	HCLGE_OPC_TM_PRI_WEIGHT = 2059,
	HCLGE_OPC_TM_PRI_C_SHAPPING = 2060,
	HCLGE_OPC_TM_PRI_P_SHAPPING = 2061,
	HCLGE_OPC_TM_PG_C_SHAPPING = 2062,
	HCLGE_OPC_TM_PG_P_SHAPPING = 2063,
	HCLGE_OPC_TM_PORT_SHAPPING = 2064,
	HCLGE_OPC_TM_PG_SCH_MODE_CFG = 2066,
	HCLGE_OPC_TM_PRI_SCH_MODE_CFG = 2067,
	HCLGE_OPC_TM_QS_SCH_MODE_CFG = 2068,
	HCLGE_OPC_TM_BP_TO_QSET_MAPPING = 2069,
	HCLGE_OPC_TM_NODES = 2070,
	HCLGE_OPC_ETS_TC_WEIGHT = 2115,
	HCLGE_OPC_QSET_DFX_STS = 2116,
	HCLGE_OPC_PRI_DFX_STS = 2117,
	HCLGE_OPC_PG_DFX_STS = 2118,
	HCLGE_OPC_PORT_DFX_STS = 2119,
	HCLGE_OPC_SCH_NQ_CNT = 2120,
	HCLGE_OPC_SCH_RQ_CNT = 2121,
	HCLGE_OPC_TM_INTERNAL_STS = 2128,
	HCLGE_OPC_TM_INTERNAL_CNT = 2129,
	HCLGE_OPC_TM_INTERNAL_STS_1 = 2130,
	HCLGE_OPC_TM_FLUSH = 2162,
	HCLGE_OPC_TX_BUFF_ALLOC = 2305,
	HCLGE_OPC_RX_PRIV_BUFF_ALLOC = 2306,
	HCLGE_OPC_RX_PRIV_WL_ALLOC = 2307,
	HCLGE_OPC_RX_COM_THRD_ALLOC = 2308,
	HCLGE_OPC_RX_COM_WL_ALLOC = 2309,
	HCLGE_OPC_RX_GBL_PKT_CNT = 2310,
	HCLGE_OPC_SET_TQP_MAP = 2561,
	HCLGE_OPC_CFG_TX_QUEUE = 2817,
	HCLGE_OPC_QUERY_TX_POINTER = 2818,
	HCLGE_OPC_QUERY_TX_STATS = 2819,
	HCLGE_OPC_TQP_TX_QUEUE_TC = 2820,
	HCLGE_OPC_CFG_RX_QUEUE = 2833,
	HCLGE_OPC_QUERY_RX_POINTER = 2834,
	HCLGE_OPC_QUERY_RX_STATS = 2835,
	HCLGE_OPC_STASH_RX_QUEUE_LRO = 2838,
	HCLGE_OPC_CFG_RX_QUEUE_LRO = 2839,
	HCLGE_OPC_CFG_COM_TQP_QUEUE = 2848,
	HCLGE_OPC_RESET_TQP_QUEUE = 2850,
	HCLGE_OPC_PPU_PF_OTHER_INT_DFX = 2890,
	HCLGE_OPC_TSO_GENERIC_CONFIG = 3073,
	HCLGE_OPC_GRO_GENERIC_CONFIG = 3088,
	HCLGE_OPC_RSS_GENERIC_CONFIG = 3329,
	HCLGE_OPC_RSS_INDIR_TABLE = 3335,
	HCLGE_OPC_RSS_TC_MODE = 3336,
	HCLGE_OPC_RSS_INPUT_TUPLE = 3330,
	HCLGE_OPC_CFG_PROMISC_MODE = 3585,
	HCLGE_OPC_VLAN_PORT_TX_CFG = 3841,
	HCLGE_OPC_VLAN_PORT_RX_CFG = 3842,
	HCLGE_OPC_ADD_RING_TO_VECTOR = 5379,
	HCLGE_OPC_DEL_RING_TO_VECTOR = 5380,
	HCLGE_OPC_MAC_VLAN_ADD = 4096,
	HCLGE_OPC_MAC_VLAN_REMOVE = 4097,
	HCLGE_OPC_MAC_VLAN_TYPE_ID = 4098,
	HCLGE_OPC_MAC_VLAN_INSERT = 4099,
	HCLGE_OPC_MAC_VLAN_ALLOCATE = 4100,
	HCLGE_OPC_MAC_ETHTYPE_ADD = 4112,
	HCLGE_OPC_MAC_ETHTYPE_REMOVE = 4113,
	HCLGE_OPC_MAC_VLAN_SWITCH_PARAM = 4147,
	HCLGE_OPC_VLAN_FILTER_CTRL = 4352,
	HCLGE_OPC_VLAN_FILTER_PF_CFG = 4353,
	HCLGE_OPC_VLAN_FILTER_VF_CFG = 4354,
	HCLGE_OPC_PORT_VLAN_BYPASS = 4355,
	HCLGE_OPC_FD_MODE_CTRL = 4608,
	HCLGE_OPC_FD_GET_ALLOCATION = 4609,
	HCLGE_OPC_FD_KEY_CONFIG = 4610,
	HCLGE_OPC_FD_TCAM_OP = 4611,
	HCLGE_OPC_FD_AD_OP = 4612,
	HCLGE_OPC_FD_CNT_OP = 4613,
	HCLGE_OPC_FD_USER_DEF_OP = 4615,
	HCLGE_OPC_FD_QB_CTRL = 4624,
	HCLGE_OPC_FD_QB_AD_OP = 4625,
	HCLGE_OPC_MDIO_CONFIG = 6400,
	HCLGE_OPC_QCN_MOD_CFG = 6657,
	HCLGE_OPC_QCN_GRP_TMPLT_CFG = 6658,
	HCLGE_OPC_QCN_SHAPPING_CFG = 6659,
	HCLGE_OPC_QCN_SHAPPING_BS_CFG = 6660,
	HCLGE_OPC_QCN_QSET_LINK_CFG = 6661,
	HCLGE_OPC_QCN_RP_STATUS_GET = 6662,
	HCLGE_OPC_QCN_AJUST_INIT = 6663,
	HCLGE_OPC_QCN_DFX_CNT_STATUS = 6664,
	HCLGE_OPC_QUERY_SCC_VER = 6788,
	HCLGEVF_OPC_MBX_PF_TO_VF = 8192,
	HCLGEVF_OPC_MBX_VF_TO_PF = 8193,
	HCLGE_OPC_LED_STATUS_CFG = 45056,
	HCLGE_OPC_CLEAR_HW_RESOURCE = 28683,
	HCLGE_OPC_QUERY_NCL_CONFIG = 28689,
	HCLGE_OPC_IMP_STATS_BD = 28690,
	HCLGE_OPC_IMP_STATS_INFO = 28691,
	HCLGE_OPC_IMP_COMPAT_CFG = 28698,
	HCLGE_OPC_GET_SFP_EEPROM = 28928,
	HCLGE_OPC_GET_SFP_EXIST = 28929,
	HCLGE_OPC_GET_SFP_INFO = 28932,
	HCLGE_MAC_COMMON_INT_EN = 782,
	HCLGE_TM_SCH_ECC_INT_EN = 2089,
	HCLGE_SSU_ECC_INT_CMD = 2441,
	HCLGE_SSU_COMMON_INT_CMD = 2444,
	HCLGE_PPU_MPF_ECC_INT_CMD = 2880,
	HCLGE_PPU_MPF_OTHER_INT_CMD = 2881,
	HCLGE_PPU_PF_OTHER_INT_CMD = 2882,
	HCLGE_COMMON_ECC_INT_CFG = 5381,
	HCLGE_QUERY_RAS_INT_STS_BD_NUM = 5392,
	HCLGE_QUERY_CLEAR_MPF_RAS_INT = 5393,
	HCLGE_QUERY_CLEAR_PF_RAS_INT = 5394,
	HCLGE_QUERY_MSIX_INT_STS_BD_NUM = 5395,
	HCLGE_QUERY_CLEAR_ALL_MPF_MSIX_INT = 5396,
	HCLGE_QUERY_CLEAR_ALL_PF_MSIX_INT = 5397,
	HCLGE_QUERY_ALL_ERR_BD_NUM = 5398,
	HCLGE_QUERY_ALL_ERR_INFO = 5399,
	HCLGE_CONFIG_ROCEE_RAS_INT_EN = 5504,
	HCLGE_QUERY_CLEAR_ROCEE_RAS_INT = 5505,
	HCLGE_ROCEE_PF_RAS_INT_CMD = 5508,
	HCLGE_QUERY_ROCEE_ECC_RAS_INFO_CMD = 5509,
	HCLGE_QUERY_ROCEE_AXI_RAS_INFO_CMD = 5510,
	HCLGE_IGU_EGU_TNL_INT_EN = 6147,
	HCLGE_IGU_COMMON_INT_EN = 6150,
	HCLGE_TM_QCN_MEM_INT_CFG = 6676,
	HCLGE_PPP_CMD0_INT_CMD = 8448,
	HCLGE_PPP_CMD1_INT_CMD = 8449,
	HCLGE_MAC_ETHERTYPE_IDX_RD = 8453,
	HCLGE_OPC_WOL_GET_SUPPORTED_MODE = 8705,
	HCLGE_OPC_WOL_CFG = 8706,
	HCLGE_NCSI_INT_EN = 9217,
	HCLGE_OPC_MAC_ADDR_CHECK = 36868,
	HCLGE_OPC_PHY_LINK_KSETTING = 28709,
	HCLGE_OPC_PHY_REG = 28710,
	HCLGE_OPC_QUERY_LINK_DIAGNOSIS = 28714,
};

enum hclge_ptp_msg0_type {
	HCLGE_PTP_MSG0_V2_DELAY_REQ = 1,
	HCLGE_PTP_MSG0_V2_PDELAY_REQ = 2,
	HCLGE_PTP_MSG0_V2_DELAY_RESP = 3,
	HCLGE_PTP_MSG0_V2_EVENT = 15,
};

enum hclge_ptp_msg_type {
	HCLGE_PTP_MSG_TYPE_V2_L2 = 0,
	HCLGE_PTP_MSG_TYPE_V2 = 1,
	HCLGE_PTP_MSG_TYPE_V2_EVENT = 2,
};

enum hclge_ptp_udp_type {
	HCLGE_PTP_UDP_NOT_TYPE = 0,
	HCLGE_PTP_UDP_P13F_TYPE = 1,
	HCLGE_PTP_UDP_P140_TYPE = 2,
	HCLGE_PTP_UDP_FULL_TYPE = 3,
};

enum hclge_reg_tag {
	HCLGE_REG_TAG_CMDQ = 0,
	HCLGE_REG_TAG_COMMON = 1,
	HCLGE_REG_TAG_RING = 2,
	HCLGE_REG_TAG_TQP_INTR = 3,
	HCLGE_REG_TAG_QUERY_32_BIT = 4,
	HCLGE_REG_TAG_QUERY_64_BIT = 5,
	HCLGE_REG_TAG_DFX_BIOS_COMMON = 6,
	HCLGE_REG_TAG_DFX_SSU_0 = 7,
	HCLGE_REG_TAG_DFX_SSU_1 = 8,
	HCLGE_REG_TAG_DFX_IGU_EGU = 9,
	HCLGE_REG_TAG_DFX_RPU_0 = 10,
	HCLGE_REG_TAG_DFX_RPU_1 = 11,
	HCLGE_REG_TAG_DFX_NCSI = 12,
	HCLGE_REG_TAG_DFX_RTC = 13,
	HCLGE_REG_TAG_DFX_PPP = 14,
	HCLGE_REG_TAG_DFX_RCB = 15,
	HCLGE_REG_TAG_DFX_TQP = 16,
	HCLGE_REG_TAG_DFX_SSU_2 = 17,
	HCLGE_REG_TAG_RPU_TNL = 18,
};

enum hclge_shap_bucket {
	HCLGE_TM_SHAP_C_BUCKET = 0,
	HCLGE_TM_SHAP_P_BUCKET = 1,
};

enum hclge_shaper_level {
	HCLGE_SHAPER_LVL_PRI = 0,
	HCLGE_SHAPER_LVL_PG = 1,
	HCLGE_SHAPER_LVL_PORT = 2,
	HCLGE_SHAPER_LVL_QSET = 3,
	HCLGE_SHAPER_LVL_CNT = 4,
	HCLGE_SHAPER_LVL_VF = 0,
	HCLGE_SHAPER_LVL_PF = 1,
};

enum hclge_vlan_fltr_cap {
	HCLGE_VLAN_FLTR_DEF = 0,
	HCLGE_VLAN_FLTR_CAN_MDF = 1,
};

enum hctx_type {
	HCTX_TYPE_DEFAULT = 0,
	HCTX_TYPE_READ = 1,
	HCTX_TYPE_POLL = 2,
	HCTX_MAX_TYPES = 3,
};

enum hdmi_3d_structure {
	HDMI_3D_STRUCTURE_INVALID = -1,
	HDMI_3D_STRUCTURE_FRAME_PACKING = 0,
	HDMI_3D_STRUCTURE_FIELD_ALTERNATIVE = 1,
	HDMI_3D_STRUCTURE_LINE_ALTERNATIVE = 2,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_FULL = 3,
	HDMI_3D_STRUCTURE_L_DEPTH = 4,
	HDMI_3D_STRUCTURE_L_DEPTH_GFX_GFX_DEPTH = 5,
	HDMI_3D_STRUCTURE_TOP_AND_BOTTOM = 6,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_HALF = 8,
};

enum hdmi_active_aspect {
	HDMI_ACTIVE_ASPECT_16_9_TOP = 2,
	HDMI_ACTIVE_ASPECT_14_9_TOP = 3,
	HDMI_ACTIVE_ASPECT_16_9_CENTER = 4,
	HDMI_ACTIVE_ASPECT_PICTURE = 8,
	HDMI_ACTIVE_ASPECT_4_3 = 9,
	HDMI_ACTIVE_ASPECT_16_9 = 10,
	HDMI_ACTIVE_ASPECT_14_9 = 11,
	HDMI_ACTIVE_ASPECT_4_3_SP_14_9 = 13,
	HDMI_ACTIVE_ASPECT_16_9_SP_14_9 = 14,
	HDMI_ACTIVE_ASPECT_16_9_SP_4_3 = 15,
};

enum hdmi_audio_coding_type {
	HDMI_AUDIO_CODING_TYPE_STREAM = 0,
	HDMI_AUDIO_CODING_TYPE_PCM = 1,
	HDMI_AUDIO_CODING_TYPE_AC3 = 2,
	HDMI_AUDIO_CODING_TYPE_MPEG1 = 3,
	HDMI_AUDIO_CODING_TYPE_MP3 = 4,
	HDMI_AUDIO_CODING_TYPE_MPEG2 = 5,
	HDMI_AUDIO_CODING_TYPE_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_DTS = 7,
	HDMI_AUDIO_CODING_TYPE_ATRAC = 8,
	HDMI_AUDIO_CODING_TYPE_DSD = 9,
	HDMI_AUDIO_CODING_TYPE_EAC3 = 10,
	HDMI_AUDIO_CODING_TYPE_DTS_HD = 11,
	HDMI_AUDIO_CODING_TYPE_MLP = 12,
	HDMI_AUDIO_CODING_TYPE_DST = 13,
	HDMI_AUDIO_CODING_TYPE_WMA_PRO = 14,
	HDMI_AUDIO_CODING_TYPE_CXT = 15,
};

enum hdmi_audio_coding_type_ext {
	HDMI_AUDIO_CODING_TYPE_EXT_CT = 0,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC = 1,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC_V2 = 2,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG_SURROUND = 3,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC = 4,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_V2 = 5,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_EXT_DRA = 7,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_SURROUND = 8,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC_SURROUND = 10,
};

enum hdmi_audio_sample_frequency {
	HDMI_AUDIO_SAMPLE_FREQUENCY_STREAM = 0,
	HDMI_AUDIO_SAMPLE_FREQUENCY_32000 = 1,
	HDMI_AUDIO_SAMPLE_FREQUENCY_44100 = 2,
	HDMI_AUDIO_SAMPLE_FREQUENCY_48000 = 3,
	HDMI_AUDIO_SAMPLE_FREQUENCY_88200 = 4,
	HDMI_AUDIO_SAMPLE_FREQUENCY_96000 = 5,
	HDMI_AUDIO_SAMPLE_FREQUENCY_176400 = 6,
	HDMI_AUDIO_SAMPLE_FREQUENCY_192000 = 7,
};

enum hdmi_audio_sample_size {
	HDMI_AUDIO_SAMPLE_SIZE_STREAM = 0,
	HDMI_AUDIO_SAMPLE_SIZE_16 = 1,
	HDMI_AUDIO_SAMPLE_SIZE_20 = 2,
	HDMI_AUDIO_SAMPLE_SIZE_24 = 3,
};

enum hdmi_colorimetry {
	HDMI_COLORIMETRY_NONE = 0,
	HDMI_COLORIMETRY_ITU_601 = 1,
	HDMI_COLORIMETRY_ITU_709 = 2,
	HDMI_COLORIMETRY_EXTENDED = 3,
};

enum hdmi_colorspace {
	HDMI_COLORSPACE_RGB = 0,
	HDMI_COLORSPACE_YUV422 = 1,
	HDMI_COLORSPACE_YUV444 = 2,
	HDMI_COLORSPACE_YUV420 = 3,
	HDMI_COLORSPACE_RESERVED4 = 4,
	HDMI_COLORSPACE_RESERVED5 = 5,
	HDMI_COLORSPACE_RESERVED6 = 6,
	HDMI_COLORSPACE_IDO_DEFINED = 7,
};

enum hdmi_content_type {
	HDMI_CONTENT_TYPE_GRAPHICS = 0,
	HDMI_CONTENT_TYPE_PHOTO = 1,
	HDMI_CONTENT_TYPE_CINEMA = 2,
	HDMI_CONTENT_TYPE_GAME = 3,
};

enum hdmi_eotf {
	HDMI_EOTF_TRADITIONAL_GAMMA_SDR = 0,
	HDMI_EOTF_TRADITIONAL_GAMMA_HDR = 1,
	HDMI_EOTF_SMPTE_ST2084 = 2,
	HDMI_EOTF_BT_2100_HLG = 3,
};

enum hdmi_extended_colorimetry {
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_601 = 0,
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_709 = 1,
	HDMI_EXTENDED_COLORIMETRY_S_YCC_601 = 2,
	HDMI_EXTENDED_COLORIMETRY_OPYCC_601 = 3,
	HDMI_EXTENDED_COLORIMETRY_OPRGB = 4,
	HDMI_EXTENDED_COLORIMETRY_BT2020_CONST_LUM = 5,
	HDMI_EXTENDED_COLORIMETRY_BT2020 = 6,
	HDMI_EXTENDED_COLORIMETRY_RESERVED = 7,
};

enum hdmi_infoframe_type {
	HDMI_INFOFRAME_TYPE_VENDOR = 129,
	HDMI_INFOFRAME_TYPE_AVI = 130,
	HDMI_INFOFRAME_TYPE_SPD = 131,
	HDMI_INFOFRAME_TYPE_AUDIO = 132,
	HDMI_INFOFRAME_TYPE_DRM = 135,
};

enum hdmi_metadata_type {
	HDMI_STATIC_METADATA_TYPE1 = 0,
};

enum hdmi_nups {
	HDMI_NUPS_UNKNOWN = 0,
	HDMI_NUPS_HORIZONTAL = 1,
	HDMI_NUPS_VERTICAL = 2,
	HDMI_NUPS_BOTH = 3,
};

enum hdmi_picture_aspect {
	HDMI_PICTURE_ASPECT_NONE = 0,
	HDMI_PICTURE_ASPECT_4_3 = 1,
	HDMI_PICTURE_ASPECT_16_9 = 2,
	HDMI_PICTURE_ASPECT_64_27 = 3,
	HDMI_PICTURE_ASPECT_256_135 = 4,
	HDMI_PICTURE_ASPECT_RESERVED = 5,
};

enum hdmi_quantization_range {
	HDMI_QUANTIZATION_RANGE_DEFAULT = 0,
	HDMI_QUANTIZATION_RANGE_LIMITED = 1,
	HDMI_QUANTIZATION_RANGE_FULL = 2,
	HDMI_QUANTIZATION_RANGE_RESERVED = 3,
};

enum hdmi_scan_mode {
	HDMI_SCAN_MODE_NONE = 0,
	HDMI_SCAN_MODE_OVERSCAN = 1,
	HDMI_SCAN_MODE_UNDERSCAN = 2,
	HDMI_SCAN_MODE_RESERVED = 3,
};

enum hdmi_spd_sdi {
	HDMI_SPD_SDI_UNKNOWN = 0,
	HDMI_SPD_SDI_DSTB = 1,
	HDMI_SPD_SDI_DVDP = 2,
	HDMI_SPD_SDI_DVHS = 3,
	HDMI_SPD_SDI_HDDVR = 4,
	HDMI_SPD_SDI_DVC = 5,
	HDMI_SPD_SDI_DSC = 6,
	HDMI_SPD_SDI_VCD = 7,
	HDMI_SPD_SDI_GAME = 8,
	HDMI_SPD_SDI_PC = 9,
	HDMI_SPD_SDI_BD = 10,
	HDMI_SPD_SDI_SACD = 11,
	HDMI_SPD_SDI_HDDVD = 12,
	HDMI_SPD_SDI_PMP = 13,
};

enum hdmi_ycc_quantization_range {
	HDMI_YCC_QUANTIZATION_RANGE_LIMITED = 0,
	HDMI_YCC_QUANTIZATION_RANGE_FULL = 1,
};

enum health_desc_param {
	HEALTH_DESC_PARAM_LEN = 0,
	HEALTH_DESC_PARAM_TYPE = 1,
	HEALTH_DESC_PARAM_EOL_INFO = 2,
	HEALTH_DESC_PARAM_LIFE_TIME_EST_A = 3,
	HEALTH_DESC_PARAM_LIFE_TIME_EST_B = 4,
};

enum hest_status {
	HEST_ENABLED = 0,
	HEST_DISABLED = 1,
	HEST_NOT_FOUND = 2,
};

enum hi6220_reset_ctrl_type {
	PERIPHERAL = 0,
	MEDIA = 1,
	AO = 2,
};

enum hi6421_type {
	HI6421 = 0,
	HI6421_V530 = 1,
};

enum hid_class_request {
	HID_REQ_GET_REPORT = 1,
	HID_REQ_GET_IDLE = 2,
	HID_REQ_GET_PROTOCOL = 3,
	HID_REQ_SET_REPORT = 9,
	HID_REQ_SET_IDLE = 10,
	HID_REQ_SET_PROTOCOL = 11,
};

enum hid_report_type {
	HID_INPUT_REPORT = 0,
	HID_OUTPUT_REPORT = 1,
	HID_FEATURE_REPORT = 2,
	HID_REPORT_TYPES = 3,
};

enum hid_type {
	HID_TYPE_OTHER = 0,
	HID_TYPE_USBMOUSE = 1,
	HID_TYPE_USBNONE = 2,
};

enum hidma_cap {
	HIDMA_MSI_CAP = 1,
	HIDMA_IDENTITY_CAP = 2,
};

enum hisi_sas_debugfs_bist_ffe_cfg {
	FFE_SAS_1_5_GBPS = 0,
	FFE_SAS_3_0_GBPS = 1,
	FFE_SAS_6_0_GBPS = 2,
	FFE_SAS_12_0_GBPS = 3,
	FFE_RESV = 4,
	FFE_SATA_1_5_GBPS = 5,
	FFE_SATA_3_0_GBPS = 6,
	FFE_SATA_6_0_GBPS = 7,
	FFE_CFG_MAX = 8,
};

enum hisi_sas_debugfs_bist_fixed_code {
	FIXED_CODE = 0,
	FIXED_CODE_1 = 1,
	FIXED_CODE_MAX = 2,
};

enum hisi_sas_debugfs_cache_type {
	HISI_SAS_ITCT_CACHE = 0,
	HISI_SAS_IOST_CACHE = 1,
};

enum hisi_sas_debugfs_reg_array_member {
	DEBUGFS_GLOBAL = 0,
	DEBUGFS_AXI = 1,
	DEBUGFS_RAS = 2,
	DEBUGFS_REGS_NUM = 3,
};

enum hisi_sas_dev_type {
	HISI_SAS_DEV_TYPE_STP = 0,
	HISI_SAS_DEV_TYPE_SSP = 1,
	HISI_SAS_DEV_TYPE_SATA = 2,
};

enum hisi_sas_phy_event {
	HISI_PHYE_PHY_UP = 0,
	HISI_PHYE_LINK_RESET = 1,
	HISI_PHYE_PHY_UP_PM = 2,
	HISI_PHYES_NUM = 3,
};

enum hk_flags {
	HK_FLAG_DOMAIN = 1,
	HK_FLAG_MANAGED_IRQ = 2,
	HK_FLAG_KERNEL_NOISE = 4,
};

enum hk_type {
	HK_TYPE_DOMAIN = 0,
	HK_TYPE_MANAGED_IRQ = 1,
	HK_TYPE_KERNEL_NOISE = 2,
	HK_TYPE_MAX = 3,
	HK_TYPE_TICK = 2,
	HK_TYPE_TIMER = 2,
	HK_TYPE_RCU = 2,
	HK_TYPE_MISC = 2,
	HK_TYPE_WQ = 2,
	HK_TYPE_KTHREAD = 2,
};

enum hn_flags_bits {
	HANDSHAKE_F_NET_DRAINING = 0,
};

enum hnae3_client_type {
	HNAE3_CLIENT_KNIC = 0,
	HNAE3_CLIENT_ROCE = 1,
};

enum hnae3_dbg_cmd {
	HNAE3_DBG_CMD_TM_NODES = 0,
	HNAE3_DBG_CMD_TM_PRI = 1,
	HNAE3_DBG_CMD_TM_QSET = 2,
	HNAE3_DBG_CMD_TM_MAP = 3,
	HNAE3_DBG_CMD_TM_PG = 4,
	HNAE3_DBG_CMD_TM_PORT = 5,
	HNAE3_DBG_CMD_TC_SCH_INFO = 6,
	HNAE3_DBG_CMD_QOS_PAUSE_CFG = 7,
	HNAE3_DBG_CMD_QOS_PRI_MAP = 8,
	HNAE3_DBG_CMD_QOS_DSCP_MAP = 9,
	HNAE3_DBG_CMD_QOS_BUF_CFG = 10,
	HNAE3_DBG_CMD_DEV_INFO = 11,
	HNAE3_DBG_CMD_TX_BD = 12,
	HNAE3_DBG_CMD_RX_BD = 13,
	HNAE3_DBG_CMD_MAC_UC = 14,
	HNAE3_DBG_CMD_MAC_MC = 15,
	HNAE3_DBG_CMD_MNG_TBL = 16,
	HNAE3_DBG_CMD_LOOPBACK = 17,
	HNAE3_DBG_CMD_PTP_INFO = 18,
	HNAE3_DBG_CMD_INTERRUPT_INFO = 19,
	HNAE3_DBG_CMD_RESET_INFO = 20,
	HNAE3_DBG_CMD_IMP_INFO = 21,
	HNAE3_DBG_CMD_NCL_CONFIG = 22,
	HNAE3_DBG_CMD_REG_BIOS_COMMON = 23,
	HNAE3_DBG_CMD_REG_SSU = 24,
	HNAE3_DBG_CMD_REG_IGU_EGU = 25,
	HNAE3_DBG_CMD_REG_RPU = 26,
	HNAE3_DBG_CMD_REG_NCSI = 27,
	HNAE3_DBG_CMD_REG_RTC = 28,
	HNAE3_DBG_CMD_REG_PPP = 29,
	HNAE3_DBG_CMD_REG_RCB = 30,
	HNAE3_DBG_CMD_REG_TQP = 31,
	HNAE3_DBG_CMD_REG_MAC = 32,
	HNAE3_DBG_CMD_REG_DCB = 33,
	HNAE3_DBG_CMD_VLAN_CONFIG = 34,
	HNAE3_DBG_CMD_QUEUE_MAP = 35,
	HNAE3_DBG_CMD_RX_QUEUE_INFO = 36,
	HNAE3_DBG_CMD_TX_QUEUE_INFO = 37,
	HNAE3_DBG_CMD_FD_TCAM = 38,
	HNAE3_DBG_CMD_FD_COUNTER = 39,
	HNAE3_DBG_CMD_MAC_TNL_STATUS = 40,
	HNAE3_DBG_CMD_SERV_INFO = 41,
	HNAE3_DBG_CMD_UMV_INFO = 42,
	HNAE3_DBG_CMD_PAGE_POOL_INFO = 43,
	HNAE3_DBG_CMD_COAL_INFO = 44,
	HNAE3_DBG_CMD_UNKNOWN = 45,
};

enum hnae3_fec_mode {
	HNAE3_FEC_AUTO = 0,
	HNAE3_FEC_BASER = 1,
	HNAE3_FEC_RS = 2,
	HNAE3_FEC_LLRS = 3,
	HNAE3_FEC_NONE = 4,
	HNAE3_FEC_USER_DEF = 5,
};

enum hnae3_hw_error_type {
	HNAE3_PPU_POISON_ERROR = 0,
	HNAE3_CMDQ_ECC_ERROR = 1,
	HNAE3_IMP_RD_POISON_ERROR = 2,
	HNAE3_ROCEE_AXI_RESP_ERROR = 3,
};

enum hnae3_loop {
	HNAE3_LOOP_EXTERNAL = 0,
	HNAE3_LOOP_APP = 1,
	HNAE3_LOOP_SERIAL_SERDES = 2,
	HNAE3_LOOP_PARALLEL_SERDES = 3,
	HNAE3_LOOP_PHY = 4,
	HNAE3_LOOP_NONE = 5,
};

enum hnae3_media_type {
	HNAE3_MEDIA_TYPE_UNKNOWN = 0,
	HNAE3_MEDIA_TYPE_FIBER = 1,
	HNAE3_MEDIA_TYPE_COPPER = 2,
	HNAE3_MEDIA_TYPE_BACKPLANE = 3,
	HNAE3_MEDIA_TYPE_NONE = 4,
};

enum hnae3_module_type {
	HNAE3_MODULE_TYPE_UNKNOWN = 0,
	HNAE3_MODULE_TYPE_FIBRE_LR = 1,
	HNAE3_MODULE_TYPE_FIBRE_SR = 2,
	HNAE3_MODULE_TYPE_AOC = 3,
	HNAE3_MODULE_TYPE_CR = 4,
	HNAE3_MODULE_TYPE_KR = 5,
	HNAE3_MODULE_TYPE_TP = 6,
};

enum hnae3_pflag {
	HNAE3_PFLAG_LIMIT_PROMISC = 0,
	HNAE3_PFLAG_MAX = 1,
};

enum hnae3_port_base_vlan_state {
	HNAE3_PORT_BASE_VLAN_DISABLE = 0,
	HNAE3_PORT_BASE_VLAN_ENABLE = 1,
	HNAE3_PORT_BASE_VLAN_MODIFY = 2,
	HNAE3_PORT_BASE_VLAN_NOCHANGE = 3,
};

enum hnae3_reset_notify_type {
	HNAE3_UP_CLIENT = 0,
	HNAE3_DOWN_CLIENT = 1,
	HNAE3_INIT_CLIENT = 2,
	HNAE3_UNINIT_CLIENT = 3,
};

enum hnae3_reset_type {
	HNAE3_VF_RESET = 0,
	HNAE3_VF_FUNC_RESET = 1,
	HNAE3_VF_PF_FUNC_RESET = 2,
	HNAE3_VF_FULL_RESET = 3,
	HNAE3_FLR_RESET = 4,
	HNAE3_FUNC_RESET = 5,
	HNAE3_GLOBAL_RESET = 6,
	HNAE3_IMP_RESET = 7,
	HNAE3_NONE_RESET = 8,
	HNAE3_VF_EXP_RESET = 9,
	HNAE3_MAX_RESET = 10,
};

enum hnae3_tc_map_mode {
	HNAE3_TC_MAP_MODE_PRIO = 0,
	HNAE3_TC_MAP_MODE_DSCP = 1,
};

enum hnae_led_state {
	HNAE_LED_INACTIVE = 0,
	HNAE_LED_ACTIVE = 1,
	HNAE_LED_ON = 2,
	HNAE_LED_OFF = 3,
};

enum hnae_loop {
	MAC_INTERNALLOOP_MAC = 0,
	MAC_INTERNALLOOP_SERDES = 1,
	MAC_INTERNALLOOP_PHY = 2,
	MAC_LOOP_PHY_NONE = 3,
	MAC_LOOP_NONE = 4,
};

enum hnae_media_type {
	HNAE_MEDIA_TYPE_UNKNOWN = 0,
	HNAE_MEDIA_TYPE_FIBER = 1,
	HNAE_MEDIA_TYPE_COPPER = 2,
	HNAE_MEDIA_TYPE_BACKPLANE = 3,
};

enum hnae_port_type {
	HNAE_PORT_SERVICE = 0,
	HNAE_PORT_DEBUG = 1,
};

enum hns3_dbg_dentry_type {
	HNS3_DBG_DENTRY_TM = 0,
	HNS3_DBG_DENTRY_TX_BD = 1,
	HNS3_DBG_DENTRY_RX_BD = 2,
	HNS3_DBG_DENTRY_MAC = 3,
	HNS3_DBG_DENTRY_REG = 4,
	HNS3_DBG_DENTRY_QUEUE = 5,
	HNS3_DBG_DENTRY_FD = 6,
	HNS3_DBG_DENTRY_COMMON = 7,
};

enum hns3_desc_type {
	DESC_TYPE_UNKNOWN = 0,
	DESC_TYPE_SKB = 1,
	DESC_TYPE_FRAGLIST_SKB = 2,
	DESC_TYPE_PAGE = 4,
	DESC_TYPE_BOUNCE_ALL = 8,
	DESC_TYPE_BOUNCE_HEAD = 16,
	DESC_TYPE_SGL_SKB = 32,
	DESC_TYPE_PP_FRAG = 64,
};

enum hns3_flow_level_range {
	HNS3_FLOW_LOW = 0,
	HNS3_FLOW_MID = 1,
	HNS3_FLOW_HIGH = 2,
	HNS3_FLOW_ULTRA = 3,
};

enum hns3_nic_state {
	HNS3_NIC_STATE_TESTING = 0,
	HNS3_NIC_STATE_RESETTING = 1,
	HNS3_NIC_STATE_INITED = 2,
	HNS3_NIC_STATE_DOWN = 3,
	HNS3_NIC_STATE_DISABLED = 4,
	HNS3_NIC_STATE_REMOVING = 5,
	HNS3_NIC_STATE_SERVICE_INITED = 6,
	HNS3_NIC_STATE_SERVICE_SCHED = 7,
	HNS3_NIC_STATE2_RESET_REQUESTED = 8,
	HNS3_NIC_STATE_HW_TX_CSUM_ENABLE = 9,
	HNS3_NIC_STATE_RXD_ADV_LAYOUT_ENABLE = 10,
	HNS3_NIC_STATE_TX_PUSH_ENABLE = 11,
	HNS3_NIC_STATE_MAX = 12,
};

enum hns3_pkt_l2t_type {
	HNS3_L2_TYPE_UNICAST = 0,
	HNS3_L2_TYPE_MULTICAST = 1,
	HNS3_L2_TYPE_BROADCAST = 2,
	HNS3_L2_TYPE_INVALID = 3,
};

enum hns3_pkt_l3t_type {
	HNS3_L3T_NONE = 0,
	HNS3_L3T_IPV6 = 1,
	HNS3_L3T_IPV4 = 2,
	HNS3_L3T_RESERVED = 3,
};

enum hns3_pkt_l3type {
	HNS3_L3_TYPE_IPV4 = 0,
	HNS3_L3_TYPE_IPV6 = 1,
	HNS3_L3_TYPE_ARP = 2,
	HNS3_L3_TYPE_RARP = 3,
	HNS3_L3_TYPE_IPV4_OPT = 4,
	HNS3_L3_TYPE_IPV6_EXT = 5,
	HNS3_L3_TYPE_LLDP = 6,
	HNS3_L3_TYPE_BPDU = 7,
	HNS3_L3_TYPE_MAC_PAUSE = 8,
	HNS3_L3_TYPE_PFC_PAUSE = 9,
	HNS3_L3_TYPE_CNM = 12,
	HNS3_L3_TYPE_PARSE_FAIL = 15,
};

enum hns3_pkt_l4t_type {
	HNS3_L4T_UNKNOWN = 0,
	HNS3_L4T_TCP = 1,
	HNS3_L4T_UDP = 2,
	HNS3_L4T_SCTP = 3,
};

enum hns3_pkt_l4type {
	HNS3_L4_TYPE_UDP = 0,
	HNS3_L4_TYPE_TCP = 1,
	HNS3_L4_TYPE_GRE = 2,
	HNS3_L4_TYPE_SCTP = 3,
	HNS3_L4_TYPE_IGMP = 4,
	HNS3_L4_TYPE_ICMP = 5,
	HNS3_L4_TYPE_PARSE_FAIL = 15,
};

enum hns3_pkt_ol3t_type {
	HNS3_OL3T_NONE = 0,
	HNS3_OL3T_IPV6 = 1,
	HNS3_OL3T_IPV4_NO_CSUM = 2,
	HNS3_OL3T_IPV4_CSUM = 3,
};

enum hns3_pkt_ol4type {
	HNS3_OL4_TYPE_NO_TUN = 0,
	HNS3_OL4_TYPE_MAC_IN_UDP = 1,
	HNS3_OL4_TYPE_NVGRE = 2,
	HNS3_OL4_TYPE_UNKNOWN = 3,
};

enum hns3_pkt_tun_type {
	HNS3_TUN_NONE = 0,
	HNS3_TUN_MAC_IN_UDP = 1,
	HNS3_TUN_NVGRE = 2,
	HNS3_TUN_OTHER = 3,
};

enum hns_desc_type {
	DESC_TYPE_SKB___2 = 0,
	DESC_TYPE_PAGE___2 = 1,
};

enum hns_gmac_duplex_mdoe {
	GMAC_HALF_DUPLEX_MODE = 0,
	GMAC_FULL_DUPLEX_MODE = 1,
};

enum hns_nic_state {
	NIC_STATE_TESTING = 0,
	NIC_STATE_RESETTING = 1,
	NIC_STATE_REINITING = 2,
	NIC_STATE_DOWN = 3,
	NIC_STATE_DISABLED = 4,
	NIC_STATE_REMOVING = 5,
	NIC_STATE_SERVICE_INITED = 6,
	NIC_STATE_SERVICE_SCHED = 7,
	NIC_STATE2_RESET_REQUESTED = 8,
	NIC_STATE_MAX = 9,
};

enum hns_port_mode {
	GMAC_10M_MII = 0,
	GMAC_100M_MII = 1,
	GMAC_1000M_GMII = 2,
	GMAC_10M_RGMII = 3,
	GMAC_100M_RGMII = 4,
	GMAC_1000M_RGMII = 5,
	GMAC_10M_SGMII = 6,
	GMAC_100M_SGMII = 7,
	GMAC_1000M_SGMII = 8,
	GMAC_10000M_SGMII = 9,
};

enum host_event_code {
	EC_HOST_EVENT_LID_CLOSED = 1,
	EC_HOST_EVENT_LID_OPEN = 2,
	EC_HOST_EVENT_POWER_BUTTON = 3,
	EC_HOST_EVENT_AC_CONNECTED = 4,
	EC_HOST_EVENT_AC_DISCONNECTED = 5,
	EC_HOST_EVENT_BATTERY_LOW = 6,
	EC_HOST_EVENT_BATTERY_CRITICAL = 7,
	EC_HOST_EVENT_BATTERY = 8,
	EC_HOST_EVENT_THERMAL_THRESHOLD = 9,
	EC_HOST_EVENT_DEVICE = 10,
	EC_HOST_EVENT_THERMAL = 11,
	EC_HOST_EVENT_USB_CHARGER = 12,
	EC_HOST_EVENT_KEY_PRESSED = 13,
	EC_HOST_EVENT_INTERFACE_READY = 14,
	EC_HOST_EVENT_KEYBOARD_RECOVERY = 15,
	EC_HOST_EVENT_THERMAL_SHUTDOWN = 16,
	EC_HOST_EVENT_BATTERY_SHUTDOWN = 17,
	EC_HOST_EVENT_THROTTLE_START = 18,
	EC_HOST_EVENT_THROTTLE_STOP = 19,
	EC_HOST_EVENT_HANG_DETECT = 20,
	EC_HOST_EVENT_HANG_REBOOT = 21,
	EC_HOST_EVENT_PD_MCU = 22,
	EC_HOST_EVENT_BATTERY_STATUS = 23,
	EC_HOST_EVENT_PANIC = 24,
	EC_HOST_EVENT_KEYBOARD_FASTBOOT = 25,
	EC_HOST_EVENT_RTC = 26,
	EC_HOST_EVENT_MKBP = 27,
	EC_HOST_EVENT_USB_MUX = 28,
	EC_HOST_EVENT_MODE_CHANGE = 29,
	EC_HOST_EVENT_KEYBOARD_RECOVERY_HW_REINIT = 30,
	EC_HOST_EVENT_WOV = 31,
	EC_HOST_EVENT_INVALID = 32,
};

enum host_sleep_event {
	HOST_SLEEP_EVENT_S3_SUSPEND = 1,
	HOST_SLEEP_EVENT_S3_RESUME = 2,
	HOST_SLEEP_EVENT_S0IX_SUSPEND = 3,
	HOST_SLEEP_EVENT_S0IX_RESUME = 4,
	HOST_SLEEP_EVENT_S3_WAKEABLE_SUSPEND = 5,
};

enum hp_flags_bits {
	HANDSHAKE_F_PROTO_NOTIFY = 0,
};

enum hpx_type3_cfg_loc {
	HPX_CFG_PCICFG = 0,
	HPX_CFG_PCIE_CAP = 1,
	HPX_CFG_PCIE_CAP_EXT = 2,
	HPX_CFG_VEND_CAP = 3,
	HPX_CFG_DVSEC = 4,
	HPX_CFG_MAX = 5,
};

enum hpx_type3_fn_type {
	HPX_FN_NORMAL = 1,
	HPX_FN_SRIOV_PHYS = 2,
	HPX_FN_SRIOV_VIRT = 4,
};

enum hr_flags_bits {
	HANDSHAKE_F_REQ_COMPLETED = 0,
	HANDSHAKE_F_REQ_SESSION = 1,
};

enum hrtimer_base_type {
	HRTIMER_BASE_MONOTONIC = 0,
	HRTIMER_BASE_REALTIME = 1,
	HRTIMER_BASE_BOOTTIME = 2,
	HRTIMER_BASE_TAI = 3,
	HRTIMER_BASE_MONOTONIC_SOFT = 4,
	HRTIMER_BASE_REALTIME_SOFT = 5,
	HRTIMER_BASE_BOOTTIME_SOFT = 6,
	HRTIMER_BASE_TAI_SOFT = 7,
	HRTIMER_MAX_CLOCK_BASES = 8,
};

enum hrtimer_mode {
	HRTIMER_MODE_ABS = 0,
	HRTIMER_MODE_REL = 1,
	HRTIMER_MODE_PINNED = 2,
	HRTIMER_MODE_SOFT = 4,
	HRTIMER_MODE_HARD = 8,
	HRTIMER_MODE_ABS_PINNED = 2,
	HRTIMER_MODE_REL_PINNED = 3,
	HRTIMER_MODE_ABS_SOFT = 4,
	HRTIMER_MODE_REL_SOFT = 5,
	HRTIMER_MODE_ABS_PINNED_SOFT = 6,
	HRTIMER_MODE_REL_PINNED_SOFT = 7,
	HRTIMER_MODE_ABS_HARD = 8,
	HRTIMER_MODE_REL_HARD = 9,
	HRTIMER_MODE_ABS_PINNED_HARD = 10,
	HRTIMER_MODE_REL_PINNED_HARD = 11,
};

enum hrtimer_restart {
	HRTIMER_NORESTART = 0,
	HRTIMER_RESTART = 1,
};

enum hsm_task_states {
	HSM_ST_IDLE = 0,
	HSM_ST_FIRST = 1,
	HSM_ST = 2,
	HSM_ST_LAST = 3,
	HSM_ST_ERR = 4,
};

enum hte_edge {
	HTE_EDGE_NO_SETUP = 1,
	HTE_RISING_EDGE_TS = 2,
	HTE_FALLING_EDGE_TS = 4,
};

enum hte_return {
	HTE_CB_HANDLED = 0,
	HTE_RUN_SECOND_CB = 1,
};

enum hub_activation_type {
	HUB_INIT = 0,
	HUB_INIT2 = 1,
	HUB_INIT3 = 2,
	HUB_POST_RESET = 3,
	HUB_RESUME = 4,
	HUB_RESET_RESUME = 5,
};

enum hub_led_mode {
	INDICATOR_AUTO = 0,
	INDICATOR_CYCLE = 1,
	INDICATOR_GREEN_BLINK = 2,
	INDICATOR_GREEN_BLINK_OFF = 3,
	INDICATOR_AMBER_BLINK = 4,
	INDICATOR_AMBER_BLINK_OFF = 5,
	INDICATOR_ALT_BLINK = 6,
	INDICATOR_ALT_BLINK_OFF = 7,
} __attribute__((mode(byte)));

enum hub_quiescing_type {
	HUB_DISCONNECT = 0,
	HUB_PRE_RESET = 1,
	HUB_SUSPEND = 2,
};

enum hugetlb_memory_event {
	HUGETLB_MAX = 0,
	HUGETLB_NR_MEMORY_EVENTS = 1,
};

enum hugetlb_page_flags {
	HPG_restore_reserve = 0,
	HPG_migratable = 1,
	HPG_temporary = 2,
	HPG_freed = 3,
	HPG_vmemmap_optimized = 4,
	HPG_raw_hwp_unreliable = 5,
	HPG_cma = 6,
	__NR_HPAGEFLAGS = 7,
};

enum hugetlb_param {
	Opt_gid___6 = 0,
	Opt_min_size = 1,
	Opt_mode___3 = 2,
	Opt_nr_inodes = 3,
	Opt_pagesize = 4,
	Opt_size = 5,
	Opt_uid___6 = 6,
};

enum hugetlbfs_size_type {
	NO_SIZE = 0,
	SIZE_STD = 1,
	SIZE_PERCENT = 2,
};

enum hw_breakpoint_ops {
	HW_BREAKPOINT_INSTALL = 0,
	HW_BREAKPOINT_UNINSTALL = 1,
	HW_BREAKPOINT_RESTORE = 2,
};

enum hw_event_mc_err_type {
	HW_EVENT_ERR_CORRECTED = 0,
	HW_EVENT_ERR_UNCORRECTED = 1,
	HW_EVENT_ERR_DEFERRED = 2,
	HW_EVENT_ERR_FATAL = 3,
	HW_EVENT_ERR_INFO = 4,
};

enum hw_protection_action {
	HWPROT_ACT_DEFAULT = 0,
	HWPROT_ACT_SHUTDOWN = 1,
	HWPROT_ACT_REBOOT = 2,
};

enum hwmon_chip_attributes {
	hwmon_chip_temp_reset_history = 0,
	hwmon_chip_in_reset_history = 1,
	hwmon_chip_curr_reset_history = 2,
	hwmon_chip_power_reset_history = 3,
	hwmon_chip_register_tz = 4,
	hwmon_chip_update_interval = 5,
	hwmon_chip_alarms = 6,
	hwmon_chip_samples = 7,
	hwmon_chip_curr_samples = 8,
	hwmon_chip_in_samples = 9,
	hwmon_chip_power_samples = 10,
	hwmon_chip_temp_samples = 11,
	hwmon_chip_beep_enable = 12,
	hwmon_chip_pec = 13,
};

enum hwmon_curr_attributes {
	hwmon_curr_enable = 0,
	hwmon_curr_input = 1,
	hwmon_curr_min = 2,
	hwmon_curr_max = 3,
	hwmon_curr_lcrit = 4,
	hwmon_curr_crit = 5,
	hwmon_curr_average = 6,
	hwmon_curr_lowest = 7,
	hwmon_curr_highest = 8,
	hwmon_curr_reset_history = 9,
	hwmon_curr_label = 10,
	hwmon_curr_alarm = 11,
	hwmon_curr_min_alarm = 12,
	hwmon_curr_max_alarm = 13,
	hwmon_curr_lcrit_alarm = 14,
	hwmon_curr_crit_alarm = 15,
	hwmon_curr_rated_min = 16,
	hwmon_curr_rated_max = 17,
	hwmon_curr_beep = 18,
};

enum hwmon_energy_attributes {
	hwmon_energy_enable = 0,
	hwmon_energy_input = 1,
	hwmon_energy_label = 2,
};

enum hwmon_fan_attributes {
	hwmon_fan_enable = 0,
	hwmon_fan_input = 1,
	hwmon_fan_label = 2,
	hwmon_fan_min = 3,
	hwmon_fan_max = 4,
	hwmon_fan_div = 5,
	hwmon_fan_pulses = 6,
	hwmon_fan_target = 7,
	hwmon_fan_alarm = 8,
	hwmon_fan_min_alarm = 9,
	hwmon_fan_max_alarm = 10,
	hwmon_fan_fault = 11,
	hwmon_fan_beep = 12,
};

enum hwmon_humidity_attributes {
	hwmon_humidity_enable = 0,
	hwmon_humidity_input = 1,
	hwmon_humidity_label = 2,
	hwmon_humidity_min = 3,
	hwmon_humidity_min_hyst = 4,
	hwmon_humidity_max = 5,
	hwmon_humidity_max_hyst = 6,
	hwmon_humidity_alarm = 7,
	hwmon_humidity_fault = 8,
	hwmon_humidity_rated_min = 9,
	hwmon_humidity_rated_max = 10,
	hwmon_humidity_min_alarm = 11,
	hwmon_humidity_max_alarm = 12,
};

enum hwmon_in_attributes {
	hwmon_in_enable = 0,
	hwmon_in_input = 1,
	hwmon_in_min = 2,
	hwmon_in_max = 3,
	hwmon_in_lcrit = 4,
	hwmon_in_crit = 5,
	hwmon_in_average = 6,
	hwmon_in_lowest = 7,
	hwmon_in_highest = 8,
	hwmon_in_reset_history = 9,
	hwmon_in_label = 10,
	hwmon_in_alarm = 11,
	hwmon_in_min_alarm = 12,
	hwmon_in_max_alarm = 13,
	hwmon_in_lcrit_alarm = 14,
	hwmon_in_crit_alarm = 15,
	hwmon_in_rated_min = 16,
	hwmon_in_rated_max = 17,
	hwmon_in_beep = 18,
	hwmon_in_fault = 19,
};

enum hwmon_power_attributes {
	hwmon_power_enable = 0,
	hwmon_power_average = 1,
	hwmon_power_average_interval = 2,
	hwmon_power_average_interval_max = 3,
	hwmon_power_average_interval_min = 4,
	hwmon_power_average_highest = 5,
	hwmon_power_average_lowest = 6,
	hwmon_power_average_max = 7,
	hwmon_power_average_min = 8,
	hwmon_power_input = 9,
	hwmon_power_input_highest = 10,
	hwmon_power_input_lowest = 11,
	hwmon_power_reset_history = 12,
	hwmon_power_accuracy = 13,
	hwmon_power_cap = 14,
	hwmon_power_cap_hyst = 15,
	hwmon_power_cap_max = 16,
	hwmon_power_cap_min = 17,
	hwmon_power_min = 18,
	hwmon_power_max = 19,
	hwmon_power_crit = 20,
	hwmon_power_lcrit = 21,
	hwmon_power_label = 22,
	hwmon_power_alarm = 23,
	hwmon_power_cap_alarm = 24,
	hwmon_power_min_alarm = 25,
	hwmon_power_max_alarm = 26,
	hwmon_power_lcrit_alarm = 27,
	hwmon_power_crit_alarm = 28,
	hwmon_power_rated_min = 29,
	hwmon_power_rated_max = 30,
};

enum hwmon_pwm_attributes {
	hwmon_pwm_input = 0,
	hwmon_pwm_enable = 1,
	hwmon_pwm_mode = 2,
	hwmon_pwm_freq = 3,
	hwmon_pwm_auto_channels_temp = 4,
};

enum hwmon_sensor_types {
	hwmon_chip = 0,
	hwmon_temp = 1,
	hwmon_in = 2,
	hwmon_curr = 3,
	hwmon_power = 4,
	hwmon_energy = 5,
	hwmon_energy64 = 6,
	hwmon_humidity = 7,
	hwmon_fan = 8,
	hwmon_pwm = 9,
	hwmon_intrusion = 10,
	hwmon_max = 11,
};

enum hwmon_temp_attributes {
	hwmon_temp_enable = 0,
	hwmon_temp_input = 1,
	hwmon_temp_type = 2,
	hwmon_temp_lcrit = 3,
	hwmon_temp_lcrit_hyst = 4,
	hwmon_temp_min = 5,
	hwmon_temp_min_hyst = 6,
	hwmon_temp_max = 7,
	hwmon_temp_max_hyst = 8,
	hwmon_temp_crit = 9,
	hwmon_temp_crit_hyst = 10,
	hwmon_temp_emergency = 11,
	hwmon_temp_emergency_hyst = 12,
	hwmon_temp_alarm = 13,
	hwmon_temp_lcrit_alarm = 14,
	hwmon_temp_min_alarm = 15,
	hwmon_temp_max_alarm = 16,
	hwmon_temp_crit_alarm = 17,
	hwmon_temp_emergency_alarm = 18,
	hwmon_temp_fault = 19,
	hwmon_temp_offset = 20,
	hwmon_temp_label = 21,
	hwmon_temp_lowest = 22,
	hwmon_temp_highest = 23,
	hwmon_temp_reset_history = 24,
	hwmon_temp_rated_min = 25,
	hwmon_temp_rated_max = 26,
	hwmon_temp_beep = 27,
};

enum hwtstamp_flags {
	HWTSTAMP_FLAG_BONDED_PHC_INDEX = 1,
	HWTSTAMP_FLAG_LAST = 1,
	HWTSTAMP_FLAG_MASK = 1,
};

enum hwtstamp_provider_qualifier {
	HWTSTAMP_PROVIDER_QUALIFIER_PRECISE = 0,
	HWTSTAMP_PROVIDER_QUALIFIER_APPROX = 1,
	HWTSTAMP_PROVIDER_QUALIFIER_CNT = 2,
};

enum hwtstamp_rx_filters {
	HWTSTAMP_FILTER_NONE = 0,
	HWTSTAMP_FILTER_ALL = 1,
	HWTSTAMP_FILTER_SOME = 2,
	HWTSTAMP_FILTER_PTP_V1_L4_EVENT = 3,
	HWTSTAMP_FILTER_PTP_V1_L4_SYNC = 4,
	HWTSTAMP_FILTER_PTP_V1_L4_DELAY_REQ = 5,
	HWTSTAMP_FILTER_PTP_V2_L4_EVENT = 6,
	HWTSTAMP_FILTER_PTP_V2_L4_SYNC = 7,
	HWTSTAMP_FILTER_PTP_V2_L4_DELAY_REQ = 8,
	HWTSTAMP_FILTER_PTP_V2_L2_EVENT = 9,
	HWTSTAMP_FILTER_PTP_V2_L2_SYNC = 10,
	HWTSTAMP_FILTER_PTP_V2_L2_DELAY_REQ = 11,
	HWTSTAMP_FILTER_PTP_V2_EVENT = 12,
	HWTSTAMP_FILTER_PTP_V2_SYNC = 13,
	HWTSTAMP_FILTER_PTP_V2_DELAY_REQ = 14,
	HWTSTAMP_FILTER_NTP_ALL = 15,
	__HWTSTAMP_FILTER_CNT = 16,
};

enum hwtstamp_source {
	HWTSTAMP_SOURCE_NETDEV = 1,
	HWTSTAMP_SOURCE_PHYLIB = 2,
};

enum hwtstamp_tx_types {
	HWTSTAMP_TX_OFF = 0,
	HWTSTAMP_TX_ON = 1,
	HWTSTAMP_TX_ONESTEP_SYNC = 2,
	HWTSTAMP_TX_ONESTEP_P2P = 3,
	__HWTSTAMP_TX_CNT = 4,
};

enum i2c_alert_protocol {
	I2C_PROTOCOL_SMBUS_ALERT = 0,
	I2C_PROTOCOL_SMBUS_HOST_NOTIFY = 1,
};

enum i2c_chip_type {
	SLB9635 = 0,
	SLB9645 = 1,
	UNKNOWN = 2,
};

enum i2c_driver_flags {
	I2C_DRV_ACPI_WAIVE_D0_PROBE = 1,
};

enum i2c_mt65xx_clks {
	I2C_MT65XX_CLK_MAIN = 0,
	I2C_MT65XX_CLK_DMA = 1,
	I2C_MT65XX_CLK_PMIC = 2,
	I2C_MT65XX_CLK_ARB = 3,
	I2C_MT65XX_CLK_MAX = 4,
};

enum i2c_slave_event {
	I2C_SLAVE_READ_REQUESTED = 0,
	I2C_SLAVE_WRITE_REQUESTED = 1,
	I2C_SLAVE_READ_PROCESSED = 2,
	I2C_SLAVE_WRITE_RECEIVED = 3,
	I2C_SLAVE_STOP = 4,
};

enum i2c_slave_read_status {
	I2C_SLAVE_RX_FIFO_EMPTY = 0,
	I2C_SLAVE_RX_START = 1,
	I2C_SLAVE_RX_DATA = 2,
	I2C_SLAVE_RX_END = 3,
};

enum i2c_type_exynos {
	I2C_TYPE_EXYNOS5 = 0,
	I2C_TYPE_EXYNOS7 = 1,
	I2C_TYPE_EXYNOSAUTOV9 = 2,
	I2C_TYPE_EXYNOS8895 = 3,
};

enum ib_atomic_cap {
	IB_ATOMIC_NONE = 0,
	IB_ATOMIC_HCA = 1,
	IB_ATOMIC_GLOB = 2,
};

enum ib_cq_notify_flags {
	IB_CQ_SOLICITED = 1,
	IB_CQ_NEXT_COMP = 2,
	IB_CQ_SOLICITED_MASK = 3,
	IB_CQ_REPORT_MISSED_EVENTS = 4,
};

enum ib_event_type {
	IB_EVENT_CQ_ERR = 0,
	IB_EVENT_QP_FATAL = 1,
	IB_EVENT_QP_REQ_ERR = 2,
	IB_EVENT_QP_ACCESS_ERR = 3,
	IB_EVENT_COMM_EST = 4,
	IB_EVENT_SQ_DRAINED = 5,
	IB_EVENT_PATH_MIG = 6,
	IB_EVENT_PATH_MIG_ERR = 7,
	IB_EVENT_DEVICE_FATAL = 8,
	IB_EVENT_PORT_ACTIVE = 9,
	IB_EVENT_PORT_ERR = 10,
	IB_EVENT_LID_CHANGE = 11,
	IB_EVENT_PKEY_CHANGE = 12,
	IB_EVENT_SM_CHANGE = 13,
	IB_EVENT_SRQ_ERR = 14,
	IB_EVENT_SRQ_LIMIT_REACHED = 15,
	IB_EVENT_QP_LAST_WQE_REACHED = 16,
	IB_EVENT_CLIENT_REREGISTER = 17,
	IB_EVENT_GID_CHANGE = 18,
	IB_EVENT_WQ_FATAL = 19,
};

enum ib_flow_action_type {
	IB_FLOW_ACTION_UNSPECIFIED = 0,
	IB_FLOW_ACTION_ESP = 1,
};

enum ib_flow_attr_type {
	IB_FLOW_ATTR_NORMAL = 0,
	IB_FLOW_ATTR_ALL_DEFAULT = 1,
	IB_FLOW_ATTR_MC_DEFAULT = 2,
	IB_FLOW_ATTR_SNIFFER = 3,
};

enum ib_flow_spec_type {
	IB_FLOW_SPEC_ETH = 32,
	IB_FLOW_SPEC_IB = 34,
	IB_FLOW_SPEC_IPV4 = 48,
	IB_FLOW_SPEC_IPV6 = 49,
	IB_FLOW_SPEC_ESP = 52,
	IB_FLOW_SPEC_TCP = 64,
	IB_FLOW_SPEC_UDP = 65,
	IB_FLOW_SPEC_VXLAN_TUNNEL = 80,
	IB_FLOW_SPEC_GRE = 81,
	IB_FLOW_SPEC_MPLS = 96,
	IB_FLOW_SPEC_INNER = 256,
	IB_FLOW_SPEC_ACTION_TAG = 4096,
	IB_FLOW_SPEC_ACTION_DROP = 4097,
	IB_FLOW_SPEC_ACTION_HANDLE = 4098,
	IB_FLOW_SPEC_ACTION_COUNT = 4099,
};

enum ib_gid_type {
	IB_GID_TYPE_IB = 0,
	IB_GID_TYPE_ROCE = 1,
	IB_GID_TYPE_ROCE_UDP_ENCAP = 2,
	IB_GID_TYPE_SIZE = 3,
};

enum ib_mig_state {
	IB_MIG_MIGRATED = 0,
	IB_MIG_REARM = 1,
	IB_MIG_ARMED = 2,
};

enum ib_mr_type {
	IB_MR_TYPE_MEM_REG = 0,
	IB_MR_TYPE_SG_GAPS = 1,
	IB_MR_TYPE_DM = 2,
	IB_MR_TYPE_USER = 3,
	IB_MR_TYPE_DMA = 4,
	IB_MR_TYPE_INTEGRITY = 5,
};

enum ib_mtu {
	IB_MTU_256 = 1,
	IB_MTU_512 = 2,
	IB_MTU_1024 = 3,
	IB_MTU_2048 = 4,
	IB_MTU_4096 = 5,
};

enum ib_mw_type {
	IB_MW_TYPE_1 = 1,
	IB_MW_TYPE_2 = 2,
};

enum ib_poll_context {
	IB_POLL_SOFTIRQ = 0,
	IB_POLL_WORKQUEUE = 1,
	IB_POLL_UNBOUND_WORKQUEUE = 2,
	IB_POLL_LAST_POOL_TYPE = 2,
	IB_POLL_DIRECT = 3,
};

enum ib_port_state {
	IB_PORT_NOP = 0,
	IB_PORT_DOWN = 1,
	IB_PORT_INIT = 2,
	IB_PORT_ARMED = 3,
	IB_PORT_ACTIVE = 4,
	IB_PORT_ACTIVE_DEFER = 5,
};

enum ib_qp_state {
	IB_QPS_RESET = 0,
	IB_QPS_INIT = 1,
	IB_QPS_RTR = 2,
	IB_QPS_RTS = 3,
	IB_QPS_SQD = 4,
	IB_QPS_SQE = 5,
	IB_QPS_ERR = 6,
};

enum ib_qp_type {
	IB_QPT_SMI = 0,
	IB_QPT_GSI = 1,
	IB_QPT_RC = 2,
	IB_QPT_UC = 3,
	IB_QPT_UD = 4,
	IB_QPT_RAW_IPV6 = 5,
	IB_QPT_RAW_ETHERTYPE = 6,
	IB_QPT_RAW_PACKET = 8,
	IB_QPT_XRC_INI = 9,
	IB_QPT_XRC_TGT = 10,
	IB_QPT_MAX = 11,
	IB_QPT_DRIVER = 255,
	IB_QPT_RESERVED1 = 4096,
	IB_QPT_RESERVED2 = 4097,
	IB_QPT_RESERVED3 = 4098,
	IB_QPT_RESERVED4 = 4099,
	IB_QPT_RESERVED5 = 4100,
	IB_QPT_RESERVED6 = 4101,
	IB_QPT_RESERVED7 = 4102,
	IB_QPT_RESERVED8 = 4103,
	IB_QPT_RESERVED9 = 4104,
	IB_QPT_RESERVED10 = 4105,
};

enum ib_sig_err_type {
	IB_SIG_BAD_GUARD = 0,
	IB_SIG_BAD_REFTAG = 1,
	IB_SIG_BAD_APPTAG = 2,
};

enum ib_sig_type {
	IB_SIGNAL_ALL_WR = 0,
	IB_SIGNAL_REQ_WR = 1,
};

enum ib_signature_type {
	IB_SIG_TYPE_NONE = 0,
	IB_SIG_TYPE_T10_DIF = 1,
};

enum ib_srq_attr_mask {
	IB_SRQ_MAX_WR = 1,
	IB_SRQ_LIMIT = 2,
};

enum ib_srq_type {
	IB_SRQT_BASIC = 0,
	IB_SRQT_XRC = 1,
	IB_SRQT_TM = 2,
};

enum ib_t10_dif_bg_type {
	IB_T10DIF_CRC = 0,
	IB_T10DIF_CSUM = 1,
};

enum ib_uverbs_advise_mr_advice {
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH = 0,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_WRITE = 1,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_NO_FAULT = 2,
};

enum ib_wc_opcode {
	IB_WC_SEND = 0,
	IB_WC_RDMA_WRITE = 1,
	IB_WC_RDMA_READ = 2,
	IB_WC_COMP_SWAP = 3,
	IB_WC_FETCH_ADD = 4,
	IB_WC_BIND_MW = 5,
	IB_WC_LOCAL_INV = 6,
	IB_WC_LSO = 7,
	IB_WC_ATOMIC_WRITE = 9,
	IB_WC_REG_MR = 10,
	IB_WC_MASKED_COMP_SWAP = 11,
	IB_WC_MASKED_FETCH_ADD = 12,
	IB_WC_FLUSH = 8,
	IB_WC_RECV = 128,
	IB_WC_RECV_RDMA_WITH_IMM = 129,
};

enum ib_wc_status {
	IB_WC_SUCCESS = 0,
	IB_WC_LOC_LEN_ERR = 1,
	IB_WC_LOC_QP_OP_ERR = 2,
	IB_WC_LOC_EEC_OP_ERR = 3,
	IB_WC_LOC_PROT_ERR = 4,
	IB_WC_WR_FLUSH_ERR = 5,
	IB_WC_MW_BIND_ERR = 6,
	IB_WC_BAD_RESP_ERR = 7,
	IB_WC_LOC_ACCESS_ERR = 8,
	IB_WC_REM_INV_REQ_ERR = 9,
	IB_WC_REM_ACCESS_ERR = 10,
	IB_WC_REM_OP_ERR = 11,
	IB_WC_RETRY_EXC_ERR = 12,
	IB_WC_RNR_RETRY_EXC_ERR = 13,
	IB_WC_LOC_RDD_VIOL_ERR = 14,
	IB_WC_REM_INV_RD_REQ_ERR = 15,
	IB_WC_REM_ABORT_ERR = 16,
	IB_WC_INV_EECN_ERR = 17,
	IB_WC_INV_EEC_STATE_ERR = 18,
	IB_WC_FATAL_ERR = 19,
	IB_WC_RESP_TIMEOUT_ERR = 20,
	IB_WC_GENERAL_ERR = 21,
};

enum ib_wq_state {
	IB_WQS_RESET = 0,
	IB_WQS_RDY = 1,
	IB_WQS_ERR = 2,
};

enum ib_wq_type {
	IB_WQT_RQ = 0,
};

enum ib_wr_opcode {
	IB_WR_RDMA_WRITE = 0,
	IB_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_WR_SEND = 2,
	IB_WR_SEND_WITH_IMM = 3,
	IB_WR_RDMA_READ = 4,
	IB_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_WR_BIND_MW = 8,
	IB_WR_LSO = 10,
	IB_WR_SEND_WITH_INV = 9,
	IB_WR_RDMA_READ_WITH_INV = 11,
	IB_WR_LOCAL_INV = 7,
	IB_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_WR_FLUSH = 14,
	IB_WR_ATOMIC_WRITE = 15,
	IB_WR_REG_MR = 32,
	IB_WR_REG_MR_INTEGRITY = 33,
	IB_WR_RESERVED1 = 240,
	IB_WR_RESERVED2 = 241,
	IB_WR_RESERVED3 = 242,
	IB_WR_RESERVED4 = 243,
	IB_WR_RESERVED5 = 244,
	IB_WR_RESERVED6 = 245,
	IB_WR_RESERVED7 = 246,
	IB_WR_RESERVED8 = 247,
	IB_WR_RESERVED9 = 248,
	IB_WR_RESERVED10 = 249,
};

enum ifc_nand_fir_opcodes {
	IFC_FIR_OP_NOP = 0,
	IFC_FIR_OP_CA0 = 1,
	IFC_FIR_OP_CA1 = 2,
	IFC_FIR_OP_CA2 = 3,
	IFC_FIR_OP_CA3 = 4,
	IFC_FIR_OP_RA0 = 5,
	IFC_FIR_OP_RA1 = 6,
	IFC_FIR_OP_RA2 = 7,
	IFC_FIR_OP_RA3 = 8,
	IFC_FIR_OP_CMD0 = 9,
	IFC_FIR_OP_CMD1 = 10,
	IFC_FIR_OP_CMD2 = 11,
	IFC_FIR_OP_CMD3 = 12,
	IFC_FIR_OP_CMD4 = 13,
	IFC_FIR_OP_CMD5 = 14,
	IFC_FIR_OP_CMD6 = 15,
	IFC_FIR_OP_CMD7 = 16,
	IFC_FIR_OP_CW0 = 17,
	IFC_FIR_OP_CW1 = 18,
	IFC_FIR_OP_CW2 = 19,
	IFC_FIR_OP_CW3 = 20,
	IFC_FIR_OP_CW4 = 21,
	IFC_FIR_OP_CW5 = 22,
	IFC_FIR_OP_CW6 = 23,
	IFC_FIR_OP_CW7 = 24,
	IFC_FIR_OP_WBCD = 25,
	IFC_FIR_OP_RBCD = 26,
	IFC_FIR_OP_BTRD = 27,
	IFC_FIR_OP_RDSTAT = 28,
	IFC_FIR_OP_NWAIT = 29,
	IFC_FIR_OP_WFR = 30,
	IFC_FIR_OP_SBRD = 31,
	IFC_FIR_OP_UA = 32,
	IFC_FIR_OP_RB = 33,
};

enum igb_diagnostics_results {
	TEST_REG = 0,
	TEST_EEP = 1,
	TEST_IRQ = 2,
	TEST_LOOP = 3,
	TEST_LINK = 4,
};

enum igb_filter_match_flags {
	IGB_FILTER_FLAG_ETHER_TYPE = 1,
	IGB_FILTER_FLAG_VLAN_TCI = 2,
	IGB_FILTER_FLAG_SRC_MAC_ADDR = 4,
	IGB_FILTER_FLAG_DST_MAC_ADDR = 8,
};

enum igb_tx_buf_type {
	IGB_TYPE_SKB = 0,
	IGB_TYPE_XDP = 1,
	IGB_TYPE_XSK = 2,
};

enum igb_tx_flags {
	IGB_TX_FLAGS_VLAN = 1,
	IGB_TX_FLAGS_TSO = 2,
	IGB_TX_FLAGS_TSTAMP = 4,
	IGB_TX_FLAGS_IPV4 = 16,
	IGB_TX_FLAGS_CSUM = 32,
};

enum igbvf_state_t {
	__IGBVF_TESTING = 0,
	__IGBVF_RESETTING = 1,
	__IGBVF_DOWN = 2,
};

enum iio_available_type {
	IIO_AVAIL_LIST = 0,
	IIO_AVAIL_RANGE = 1,
};

enum iio_buffer_direction {
	IIO_BUFFER_DIRECTION_IN = 0,
	IIO_BUFFER_DIRECTION_OUT = 1,
};

enum iio_chan_info_enum {
	IIO_CHAN_INFO_RAW = 0,
	IIO_CHAN_INFO_PROCESSED = 1,
	IIO_CHAN_INFO_SCALE = 2,
	IIO_CHAN_INFO_OFFSET = 3,
	IIO_CHAN_INFO_CALIBSCALE = 4,
	IIO_CHAN_INFO_CALIBBIAS = 5,
	IIO_CHAN_INFO_PEAK = 6,
	IIO_CHAN_INFO_PEAK_SCALE = 7,
	IIO_CHAN_INFO_QUADRATURE_CORRECTION_RAW = 8,
	IIO_CHAN_INFO_AVERAGE_RAW = 9,
	IIO_CHAN_INFO_LOW_PASS_FILTER_3DB_FREQUENCY = 10,
	IIO_CHAN_INFO_HIGH_PASS_FILTER_3DB_FREQUENCY = 11,
	IIO_CHAN_INFO_SAMP_FREQ = 12,
	IIO_CHAN_INFO_FREQUENCY = 13,
	IIO_CHAN_INFO_PHASE = 14,
	IIO_CHAN_INFO_HARDWAREGAIN = 15,
	IIO_CHAN_INFO_HYSTERESIS = 16,
	IIO_CHAN_INFO_HYSTERESIS_RELATIVE = 17,
	IIO_CHAN_INFO_INT_TIME = 18,
	IIO_CHAN_INFO_ENABLE = 19,
	IIO_CHAN_INFO_CALIBHEIGHT = 20,
	IIO_CHAN_INFO_CALIBWEIGHT = 21,
	IIO_CHAN_INFO_DEBOUNCE_COUNT = 22,
	IIO_CHAN_INFO_DEBOUNCE_TIME = 23,
	IIO_CHAN_INFO_CALIBEMISSIVITY = 24,
	IIO_CHAN_INFO_OVERSAMPLING_RATIO = 25,
	IIO_CHAN_INFO_THERMOCOUPLE_TYPE = 26,
	IIO_CHAN_INFO_CALIBAMBIENT = 27,
	IIO_CHAN_INFO_ZEROPOINT = 28,
	IIO_CHAN_INFO_TROUGH = 29,
	IIO_CHAN_INFO_CONVDELAY = 30,
	IIO_CHAN_INFO_POWERFACTOR = 31,
};

enum iio_chan_type {
	IIO_VOLTAGE = 0,
	IIO_CURRENT = 1,
	IIO_POWER = 2,
	IIO_ACCEL = 3,
	IIO_ANGL_VEL = 4,
	IIO_MAGN = 5,
	IIO_LIGHT = 6,
	IIO_INTENSITY = 7,
	IIO_PROXIMITY = 8,
	IIO_TEMP = 9,
	IIO_INCLI = 10,
	IIO_ROT = 11,
	IIO_ANGL = 12,
	IIO_TIMESTAMP = 13,
	IIO_CAPACITANCE = 14,
	IIO_ALTVOLTAGE = 15,
	IIO_CCT = 16,
	IIO_PRESSURE = 17,
	IIO_HUMIDITYRELATIVE = 18,
	IIO_ACTIVITY = 19,
	IIO_STEPS = 20,
	IIO_ENERGY = 21,
	IIO_DISTANCE = 22,
	IIO_VELOCITY = 23,
	IIO_CONCENTRATION = 24,
	IIO_RESISTANCE = 25,
	IIO_PH = 26,
	IIO_UVINDEX = 27,
	IIO_ELECTRICALCONDUCTIVITY = 28,
	IIO_COUNT = 29,
	IIO_INDEX = 30,
	IIO_GRAVITY = 31,
	IIO_POSITIONRELATIVE = 32,
	IIO_PHASE = 33,
	IIO_MASSCONCENTRATION = 34,
	IIO_DELTA_ANGL = 35,
	IIO_DELTA_VELOCITY = 36,
	IIO_COLORTEMP = 37,
	IIO_CHROMATICITY = 38,
	IIO_ATTENTION = 39,
	IIO_ALTCURRENT = 40,
};

enum iio_endian {
	IIO_CPU = 0,
	IIO_BE = 1,
	IIO_LE = 2,
};

enum iio_event_direction {
	IIO_EV_DIR_EITHER = 0,
	IIO_EV_DIR_RISING = 1,
	IIO_EV_DIR_FALLING = 2,
	IIO_EV_DIR_NONE = 3,
	IIO_EV_DIR_SINGLETAP = 4,
	IIO_EV_DIR_DOUBLETAP = 5,
	IIO_EV_DIR_FAULT_OPENWIRE = 6,
};

enum iio_event_info {
	IIO_EV_INFO_ENABLE = 0,
	IIO_EV_INFO_VALUE = 1,
	IIO_EV_INFO_HYSTERESIS = 2,
	IIO_EV_INFO_PERIOD = 3,
	IIO_EV_INFO_HIGH_PASS_FILTER_3DB = 4,
	IIO_EV_INFO_LOW_PASS_FILTER_3DB = 5,
	IIO_EV_INFO_TIMEOUT = 6,
	IIO_EV_INFO_RESET_TIMEOUT = 7,
	IIO_EV_INFO_TAP2_MIN_DELAY = 8,
	IIO_EV_INFO_RUNNING_PERIOD = 9,
	IIO_EV_INFO_RUNNING_COUNT = 10,
};

enum iio_event_type {
	IIO_EV_TYPE_THRESH = 0,
	IIO_EV_TYPE_MAG = 1,
	IIO_EV_TYPE_ROC = 2,
	IIO_EV_TYPE_THRESH_ADAPTIVE = 3,
	IIO_EV_TYPE_MAG_ADAPTIVE = 4,
	IIO_EV_TYPE_CHANGE = 5,
	IIO_EV_TYPE_MAG_REFERENCED = 6,
	IIO_EV_TYPE_GESTURE = 7,
	IIO_EV_TYPE_FAULT = 8,
};

enum iio_shared_by {
	IIO_SEPARATE = 0,
	IIO_SHARED_BY_TYPE = 1,
	IIO_SHARED_BY_DIR = 2,
	IIO_SHARED_BY_ALL = 3,
};

enum imx8_pcie_phy_type {
	IMX8MM = 0,
	IMX8MP = 1,
};

enum imx_i2c_state {
	IMX_I2C_STATE_DONE = 0,
	IMX_I2C_STATE_FAILED = 1,
	IMX_I2C_STATE_WRITE = 2,
	IMX_I2C_STATE_DMA = 3,
	IMX_I2C_STATE_READ = 4,
	IMX_I2C_STATE_READ_CONTINUE = 5,
	IMX_I2C_STATE_READ_BLOCK_DATA = 6,
	IMX_I2C_STATE_READ_BLOCK_DATA_LEN = 7,
};

enum imx_i2c_type {
	IMX1_I2C = 0,
	IMX21_I2C = 1,
	S32G_I2C = 2,
	VF610_I2C = 3,
};

enum imx_misc_func {
	IMX_SC_MISC_FUNC_UNKNOWN = 0,
	IMX_SC_MISC_FUNC_SET_CONTROL = 1,
	IMX_SC_MISC_FUNC_GET_CONTROL = 2,
	IMX_SC_MISC_FUNC_SET_MAX_DMA_GROUP = 4,
	IMX_SC_MISC_FUNC_SET_DMA_GROUP = 5,
	IMX_SC_MISC_FUNC_SECO_IMAGE_LOAD = 8,
	IMX_SC_MISC_FUNC_SECO_AUTHENTICATE = 9,
	IMX_SC_MISC_FUNC_DEBUG_OUT = 10,
	IMX_SC_MISC_FUNC_WAVEFORM_CAPTURE = 6,
	IMX_SC_MISC_FUNC_BUILD_INFO = 15,
	IMX_SC_MISC_FUNC_UNIQUE_ID = 19,
	IMX_SC_MISC_FUNC_SET_ARI = 3,
	IMX_SC_MISC_FUNC_BOOT_STATUS = 7,
	IMX_SC_MISC_FUNC_BOOT_DONE = 14,
	IMX_SC_MISC_FUNC_OTP_FUSE_READ = 11,
	IMX_SC_MISC_FUNC_OTP_FUSE_WRITE = 17,
	IMX_SC_MISC_FUNC_SET_TEMP = 12,
	IMX_SC_MISC_FUNC_GET_TEMP = 13,
	IMX_SC_MISC_FUNC_GET_BOOT_DEV = 16,
	IMX_SC_MISC_FUNC_GET_BUTTON_STATUS = 18,
};

enum imx_mu_chan_type {
	IMX_MU_TYPE_TX = 0,
	IMX_MU_TYPE_RX = 1,
	IMX_MU_TYPE_TXDB = 2,
	IMX_MU_TYPE_RXDB = 3,
	IMX_MU_TYPE_RST = 4,
	IMX_MU_TYPE_TXDB_V2 = 5,
};

enum imx_mu_type {
	IMX_MU_V1 = 0,
	IMX_MU_V2 = 2,
	IMX_MU_V2_S4 = 32768,
	IMX_MU_V2_IRQ = 65536,
};

enum imx_mu_xcr {
	IMX_MU_CR = 0,
	IMX_MU_GIER = 1,
	IMX_MU_GCR = 2,
	IMX_MU_TCR = 3,
	IMX_MU_RCR = 4,
	IMX_MU_xCR_MAX = 5,
};

enum imx_mu_xsr {
	IMX_MU_SR = 0,
	IMX_MU_GSR = 1,
	IMX_MU_TSR = 2,
	IMX_MU_RSR = 3,
	IMX_MU_xSR_MAX = 4,
};

enum imx_pcie_variants {
	IMX6Q = 0,
	IMX6SX = 1,
	IMX6QP = 2,
	IMX7D = 3,
	IMX8MQ = 4,
	IMX8MM___2 = 5,
	IMX8MP___2 = 6,
	IMX8Q = 7,
	IMX95 = 8,
	IMX8MQ_EP = 9,
	IMX8MM_EP = 10,
	IMX8MP_EP = 11,
	IMX8Q_EP = 12,
	IMX95_EP = 13,
};

enum imx_pfdv2_type {
	IMX_PFDV2_IMX7ULP = 0,
	IMX_PFDV2_IMX8ULP = 1,
};

enum imx_pll14xx_type {
	PLL_1416X = 0,
	PLL_1443X = 1,
};

enum imx_pllv1_type {
	IMX_PLLV1_IMX1 = 0,
	IMX_PLLV1_IMX21 = 1,
	IMX_PLLV1_IMX25 = 2,
	IMX_PLLV1_IMX27 = 3,
	IMX_PLLV1_IMX31 = 4,
	IMX_PLLV1_IMX35 = 5,
};

enum imx_pllv3_type {
	IMX_PLLV3_GENERIC = 0,
	IMX_PLLV3_SYS = 1,
	IMX_PLLV3_USB = 2,
	IMX_PLLV3_USB_VF610 = 3,
	IMX_PLLV3_AV = 4,
	IMX_PLLV3_ENET = 5,
	IMX_PLLV3_ENET_IMX7 = 6,
	IMX_PLLV3_SYS_VF610 = 7,
	IMX_PLLV3_DDR_IMX7 = 8,
	IMX_PLLV3_AV_IMX7 = 9,
};

enum imx_pllv4_type {
	IMX_PLLV4_IMX7ULP = 0,
	IMX_PLLV4_IMX8ULP = 1,
	IMX_PLLV4_IMX8ULP_1GHZ = 2,
};

enum imx_rproc_method {
	IMX_RPROC_NONE = 0,
	IMX_RPROC_MMIO = 1,
	IMX_RPROC_SMC = 2,
	IMX_RPROC_SCU_API = 3,
	IMX_RPROC_RESET_CONTROLLER = 4,
};

enum imx_sc_error_codes {
	IMX_SC_ERR_NONE = 0,
	IMX_SC_ERR_VERSION = 1,
	IMX_SC_ERR_CONFIG = 2,
	IMX_SC_ERR_PARM = 3,
	IMX_SC_ERR_NOACCESS = 4,
	IMX_SC_ERR_LOCKED = 5,
	IMX_SC_ERR_UNAVAILABLE = 6,
	IMX_SC_ERR_NOTFOUND = 7,
	IMX_SC_ERR_NOPOWER = 8,
	IMX_SC_ERR_IPC = 9,
	IMX_SC_ERR_BUSY = 10,
	IMX_SC_ERR_FAIL = 11,
	IMX_SC_ERR_LAST = 12,
};

enum imx_sc_pm_func {
	IMX_SC_PM_FUNC_UNKNOWN = 0,
	IMX_SC_PM_FUNC_SET_SYS_POWER_MODE = 19,
	IMX_SC_PM_FUNC_SET_PARTITION_POWER_MODE = 1,
	IMX_SC_PM_FUNC_GET_SYS_POWER_MODE = 2,
	IMX_SC_PM_FUNC_SET_RESOURCE_POWER_MODE = 3,
	IMX_SC_PM_FUNC_GET_RESOURCE_POWER_MODE = 4,
	IMX_SC_PM_FUNC_REQ_LOW_POWER_MODE = 16,
	IMX_SC_PM_FUNC_SET_CPU_RESUME_ADDR = 17,
	IMX_SC_PM_FUNC_REQ_SYS_IF_POWER_MODE = 18,
	IMX_SC_PM_FUNC_SET_CLOCK_RATE = 5,
	IMX_SC_PM_FUNC_GET_CLOCK_RATE = 6,
	IMX_SC_PM_FUNC_CLOCK_ENABLE = 7,
	IMX_SC_PM_FUNC_SET_CLOCK_PARENT = 14,
	IMX_SC_PM_FUNC_GET_CLOCK_PARENT = 15,
	IMX_SC_PM_FUNC_RESET = 13,
	IMX_SC_PM_FUNC_RESET_REASON = 10,
	IMX_SC_PM_FUNC_BOOT = 8,
	IMX_SC_PM_FUNC_REBOOT = 9,
	IMX_SC_PM_FUNC_REBOOT_PARTITION = 12,
	IMX_SC_PM_FUNC_CPU_START = 11,
};

enum imx_sc_rm_func {
	IMX_SC_RM_FUNC_UNKNOWN = 0,
	IMX_SC_RM_FUNC_PARTITION_ALLOC = 1,
	IMX_SC_RM_FUNC_SET_CONFIDENTIAL = 31,
	IMX_SC_RM_FUNC_PARTITION_FREE = 2,
	IMX_SC_RM_FUNC_GET_DID = 26,
	IMX_SC_RM_FUNC_PARTITION_STATIC = 3,
	IMX_SC_RM_FUNC_PARTITION_LOCK = 4,
	IMX_SC_RM_FUNC_GET_PARTITION = 5,
	IMX_SC_RM_FUNC_SET_PARENT = 6,
	IMX_SC_RM_FUNC_MOVE_ALL = 7,
	IMX_SC_RM_FUNC_ASSIGN_RESOURCE = 8,
	IMX_SC_RM_FUNC_SET_RESOURCE_MOVABLE = 9,
	IMX_SC_RM_FUNC_SET_SUBSYS_RSRC_MOVABLE = 28,
	IMX_SC_RM_FUNC_SET_MASTER_ATTRIBUTES = 10,
	IMX_SC_RM_FUNC_SET_MASTER_SID = 11,
	IMX_SC_RM_FUNC_SET_PERIPHERAL_PERMISSIONS = 12,
	IMX_SC_RM_FUNC_IS_RESOURCE_OWNED = 13,
	IMX_SC_RM_FUNC_GET_RESOURCE_OWNER = 33,
	IMX_SC_RM_FUNC_IS_RESOURCE_MASTER = 14,
	IMX_SC_RM_FUNC_IS_RESOURCE_PERIPHERAL = 15,
	IMX_SC_RM_FUNC_GET_RESOURCE_INFO = 16,
	IMX_SC_RM_FUNC_MEMREG_ALLOC = 17,
	IMX_SC_RM_FUNC_MEMREG_SPLIT = 29,
	IMX_SC_RM_FUNC_MEMREG_FRAG = 32,
	IMX_SC_RM_FUNC_MEMREG_FREE = 18,
	IMX_SC_RM_FUNC_FIND_MEMREG = 30,
	IMX_SC_RM_FUNC_ASSIGN_MEMREG = 19,
	IMX_SC_RM_FUNC_SET_MEMREG_PERMISSIONS = 20,
	IMX_SC_RM_FUNC_IS_MEMREG_OWNED = 21,
	IMX_SC_RM_FUNC_GET_MEMREG_INFO = 22,
	IMX_SC_RM_FUNC_ASSIGN_PAD = 23,
	IMX_SC_RM_FUNC_SET_PAD_MOVABLE = 24,
	IMX_SC_RM_FUNC_IS_PAD_OWNED = 25,
	IMX_SC_RM_FUNC_DUMP = 27,
};

enum imx_sc_rpc_svc {
	IMX_SC_RPC_SVC_UNKNOWN = 0,
	IMX_SC_RPC_SVC_RETURN = 1,
	IMX_SC_RPC_SVC_PM = 2,
	IMX_SC_RPC_SVC_RM = 3,
	IMX_SC_RPC_SVC_TIMER = 5,
	IMX_SC_RPC_SVC_PAD = 6,
	IMX_SC_RPC_SVC_MISC = 7,
	IMX_SC_RPC_SVC_IRQ = 8,
};

enum imx_tx_state {
	OFF = 0,
	WAIT_AFTER_RTS = 1,
	SEND = 2,
	WAIT_AFTER_SEND = 3,
};

enum imx_uart_type {
	IMX1_UART = 0,
	IMX21_UART = 1,
};

enum inband_type {
	INBAND_NONE = 0,
	INBAND_CISCO_SGMII = 1,
	INBAND_BASEX = 2,
};

enum inet_csk_ack_state_t {
	ICSK_ACK_SCHED = 1,
	ICSK_ACK_TIMER = 2,
	ICSK_ACK_PUSHED = 4,
	ICSK_ACK_PUSHED2 = 8,
	ICSK_ACK_NOW = 16,
	ICSK_ACK_NOMEM = 32,
};

enum init_ns_ino {
	IPC_NS_INIT_INO = 4026531839,
	UTS_NS_INIT_INO = 4026531838,
	USER_NS_INIT_INO = 4026531837,
	PID_NS_INIT_INO = 4026531836,
	CGROUP_NS_INIT_INO = 4026531835,
	TIME_NS_INIT_INO = 4026531834,
	NET_NS_INIT_INO = 4026531833,
	MNT_NS_INIT_INO = 4026531832,
	MNT_NS_ANON_INO = 4026531831,
};

enum inode_i_mutex_lock_class {
	I_MUTEX_NORMAL = 0,
	I_MUTEX_PARENT = 1,
	I_MUTEX_CHILD = 2,
	I_MUTEX_XATTR = 3,
	I_MUTEX_NONDIR2 = 4,
	I_MUTEX_PARENT2 = 5,
};

enum inode_state_bits {
	__I_NEW = 0,
	__I_SYNC = 1,
	__I_LRU_ISOLATING = 2,
};

enum inode_state_flags_t {
	I_NEW = 1,
	I_SYNC = 2,
	I_LRU_ISOLATING = 4,
	I_DIRTY_SYNC = 16,
	I_DIRTY_DATASYNC = 32,
	I_DIRTY_PAGES = 64,
	I_WILL_FREE = 128,
	I_FREEING = 256,
	I_CLEAR = 512,
	I_REFERENCED = 1024,
	I_LINKABLE = 2048,
	I_DIRTY_TIME = 4096,
	I_WB_SWITCH = 8192,
	I_OVL_INUSE = 16384,
	I_CREATING = 32768,
	I_DONTCACHE = 65536,
	I_SYNC_QUEUED = 131072,
	I_PINNING_NETFS_WB = 262144,
};

enum input_clock_type {
	INPUT_CLK_REAL = 0,
	INPUT_CLK_MONO = 1,
	INPUT_CLK_BOOT = 2,
	INPUT_CLK_MAX = 3,
};

enum interconnect_desc_param {
	INTERCONNECT_DESC_PARAM_LEN = 0,
	INTERCONNECT_DESC_PARAM_TYPE = 1,
	INTERCONNECT_DESC_PARAM_UNIPRO_VER = 2,
	INTERCONNECT_DESC_PARAM_MPHY_VER = 4,
};

enum io_pgtable_caps {
	IO_PGTABLE_CAP_CUSTOM_ALLOCATOR = 1,
};

enum io_pgtable_fmt {
	ARM_32_LPAE_S1 = 0,
	ARM_32_LPAE_S2 = 1,
	ARM_64_LPAE_S1 = 2,
	ARM_64_LPAE_S2 = 3,
	ARM_V7S = 4,
	ARM_MALI_LPAE = 5,
	AMD_IOMMU_V1 = 6,
	AMD_IOMMU_V2 = 7,
	APPLE_DART = 8,
	APPLE_DART2 = 9,
	IO_PGTABLE_NUM_FMTS = 10,
};

enum io_uring_cmd_flags {
	IO_URING_F_COMPLETE_DEFER = 1,
	IO_URING_F_UNLOCKED = 2,
	IO_URING_F_MULTISHOT = 4,
	IO_URING_F_IOWQ = 8,
	IO_URING_F_INLINE = 16,
	IO_URING_F_NONBLOCK = -2147483648,
	IO_URING_F_SQE128 = 256,
	IO_URING_F_CQE32 = 512,
	IO_URING_F_IOPOLL = 1024,
	IO_URING_F_CANCEL = 2048,
	IO_URING_F_COMPAT = 4096,
	IO_URING_F_TASK_DEAD = 8192,
};

enum io_uring_msg_ring_flags {
	IORING_MSG_DATA = 0,
	IORING_MSG_SEND_FD = 1,
};

enum io_uring_napi_op {
	IO_URING_NAPI_REGISTER_OP = 0,
	IO_URING_NAPI_STATIC_ADD_ID = 1,
	IO_URING_NAPI_STATIC_DEL_ID = 2,
};

enum io_uring_napi_tracking_strategy {
	IO_URING_NAPI_TRACKING_DYNAMIC = 0,
	IO_URING_NAPI_TRACKING_STATIC = 1,
	IO_URING_NAPI_TRACKING_INACTIVE = 255,
};

enum io_uring_op {
	IORING_OP_NOP = 0,
	IORING_OP_READV = 1,
	IORING_OP_WRITEV = 2,
	IORING_OP_FSYNC = 3,
	IORING_OP_READ_FIXED = 4,
	IORING_OP_WRITE_FIXED = 5,
	IORING_OP_POLL_ADD = 6,
	IORING_OP_POLL_REMOVE = 7,
	IORING_OP_SYNC_FILE_RANGE = 8,
	IORING_OP_SENDMSG = 9,
	IORING_OP_RECVMSG = 10,
	IORING_OP_TIMEOUT = 11,
	IORING_OP_TIMEOUT_REMOVE = 12,
	IORING_OP_ACCEPT = 13,
	IORING_OP_ASYNC_CANCEL = 14,
	IORING_OP_LINK_TIMEOUT = 15,
	IORING_OP_CONNECT = 16,
	IORING_OP_FALLOCATE = 17,
	IORING_OP_OPENAT = 18,
	IORING_OP_CLOSE = 19,
	IORING_OP_FILES_UPDATE = 20,
	IORING_OP_STATX = 21,
	IORING_OP_READ = 22,
	IORING_OP_WRITE = 23,
	IORING_OP_FADVISE = 24,
	IORING_OP_MADVISE = 25,
	IORING_OP_SEND = 26,
	IORING_OP_RECV = 27,
	IORING_OP_OPENAT2 = 28,
	IORING_OP_EPOLL_CTL = 29,
	IORING_OP_SPLICE = 30,
	IORING_OP_PROVIDE_BUFFERS = 31,
	IORING_OP_REMOVE_BUFFERS = 32,
	IORING_OP_TEE = 33,
	IORING_OP_SHUTDOWN = 34,
	IORING_OP_RENAMEAT = 35,
	IORING_OP_UNLINKAT = 36,
	IORING_OP_MKDIRAT = 37,
	IORING_OP_SYMLINKAT = 38,
	IORING_OP_LINKAT = 39,
	IORING_OP_MSG_RING = 40,
	IORING_OP_FSETXATTR = 41,
	IORING_OP_SETXATTR = 42,
	IORING_OP_FGETXATTR = 43,
	IORING_OP_GETXATTR = 44,
	IORING_OP_SOCKET = 45,
	IORING_OP_URING_CMD = 46,
	IORING_OP_SEND_ZC = 47,
	IORING_OP_SENDMSG_ZC = 48,
	IORING_OP_READ_MULTISHOT = 49,
	IORING_OP_WAITID = 50,
	IORING_OP_FUTEX_WAIT = 51,
	IORING_OP_FUTEX_WAKE = 52,
	IORING_OP_FUTEX_WAITV = 53,
	IORING_OP_FIXED_FD_INSTALL = 54,
	IORING_OP_FTRUNCATE = 55,
	IORING_OP_BIND = 56,
	IORING_OP_LISTEN = 57,
	IORING_OP_RECV_ZC = 58,
	IORING_OP_EPOLL_WAIT = 59,
	IORING_OP_READV_FIXED = 60,
	IORING_OP_WRITEV_FIXED = 61,
	IORING_OP_PIPE = 62,
	IORING_OP_LAST = 63,
};

enum io_uring_register_op {
	IORING_REGISTER_BUFFERS = 0,
	IORING_UNREGISTER_BUFFERS = 1,
	IORING_REGISTER_FILES = 2,
	IORING_UNREGISTER_FILES = 3,
	IORING_REGISTER_EVENTFD = 4,
	IORING_UNREGISTER_EVENTFD = 5,
	IORING_REGISTER_FILES_UPDATE = 6,
	IORING_REGISTER_EVENTFD_ASYNC = 7,
	IORING_REGISTER_PROBE = 8,
	IORING_REGISTER_PERSONALITY = 9,
	IORING_UNREGISTER_PERSONALITY = 10,
	IORING_REGISTER_RESTRICTIONS = 11,
	IORING_REGISTER_ENABLE_RINGS = 12,
	IORING_REGISTER_FILES2 = 13,
	IORING_REGISTER_FILES_UPDATE2 = 14,
	IORING_REGISTER_BUFFERS2 = 15,
	IORING_REGISTER_BUFFERS_UPDATE = 16,
	IORING_REGISTER_IOWQ_AFF = 17,
	IORING_UNREGISTER_IOWQ_AFF = 18,
	IORING_REGISTER_IOWQ_MAX_WORKERS = 19,
	IORING_REGISTER_RING_FDS = 20,
	IORING_UNREGISTER_RING_FDS = 21,
	IORING_REGISTER_PBUF_RING = 22,
	IORING_UNREGISTER_PBUF_RING = 23,
	IORING_REGISTER_SYNC_CANCEL = 24,
	IORING_REGISTER_FILE_ALLOC_RANGE = 25,
	IORING_REGISTER_PBUF_STATUS = 26,
	IORING_REGISTER_NAPI = 27,
	IORING_UNREGISTER_NAPI = 28,
	IORING_REGISTER_CLOCK = 29,
	IORING_REGISTER_CLONE_BUFFERS = 30,
	IORING_REGISTER_SEND_MSG_RING = 31,
	IORING_REGISTER_ZCRX_IFQ = 32,
	IORING_REGISTER_RESIZE_RINGS = 33,
	IORING_REGISTER_MEM_REGION = 34,
	IORING_REGISTER_QUERY = 35,
	IORING_REGISTER_LAST = 36,
	IORING_REGISTER_USE_REGISTERED_RING = 2147483648,
};

enum io_uring_register_pbuf_ring_flags {
	IOU_PBUF_RING_MMAP = 1,
	IOU_PBUF_RING_INC = 2,
};

enum io_uring_register_restriction_op {
	IORING_RESTRICTION_REGISTER_OP = 0,
	IORING_RESTRICTION_SQE_OP = 1,
	IORING_RESTRICTION_SQE_FLAGS_ALLOWED = 2,
	IORING_RESTRICTION_SQE_FLAGS_REQUIRED = 3,
	IORING_RESTRICTION_LAST = 4,
};

enum io_uring_socket_op {
	SOCKET_URING_OP_SIOCINQ = 0,
	SOCKET_URING_OP_SIOCOUTQ = 1,
	SOCKET_URING_OP_GETSOCKOPT = 2,
	SOCKET_URING_OP_SETSOCKOPT = 3,
	SOCKET_URING_OP_TX_TIMESTAMP = 4,
};

enum io_uring_sqe_flags_bit {
	IOSQE_FIXED_FILE_BIT = 0,
	IOSQE_IO_DRAIN_BIT = 1,
	IOSQE_IO_LINK_BIT = 2,
	IOSQE_IO_HARDLINK_BIT = 3,
	IOSQE_ASYNC_BIT = 4,
	IOSQE_BUFFER_SELECT_BIT = 5,
	IOSQE_CQE_SKIP_SUCCESS_BIT = 6,
};

enum io_uring_zcrx_area_flags {
	IORING_ZCRX_AREA_DMABUF = 1,
};

enum io_wq_cancel {
	IO_WQ_CANCEL_OK = 0,
	IO_WQ_CANCEL_RUNNING = 1,
	IO_WQ_CANCEL_NOTFOUND = 2,
};

enum ioctrl_regs {
	POC0 = 0,
	POC1 = 1,
	POC3 = 2,
	POC4 = 3,
	POC5 = 4,
	POC6 = 5,
	POC7 = 6,
	POC8 = 7,
};

enum ioctrl_regs___2 {
	POC0___2 = 0,
	POC1___2 = 1,
	POC2 = 2,
	POC4___2 = 3,
	POC5___2 = 4,
	POC6___2 = 5,
	POC7___2 = 6,
	POC8___2 = 7,
	POC9 = 8,
	TD1SEL0 = 9,
};

enum ioctrl_regs___3 {
	POC0___3 = 0,
	POC1___3 = 1,
	POC3___2 = 2,
	POC4___3 = 3,
	POC5___3 = 4,
	POC6___3 = 5,
	POC7___3 = 6,
};

enum ioctrl_regs___4 {
	POCCTRL = 0,
	TDSELCTRL = 1,
};

enum ioctrl_regs___5 {
	POCCTRL0 = 0,
	POCCTRL1 = 1,
	POCCTRL2 = 2,
	POCCTRL3 = 3,
	TDSELCTRL___2 = 4,
};

enum ioctrl_regs___6 {
	POCCTRL0___2 = 0,
	POCCTRL2___2 = 1,
	TDSELCTRL___3 = 2,
};

enum ioctrl_regs___7 {
	POC0___4 = 0,
	POC1___4 = 1,
	POC3___3 = 2,
	TD0SEL1 = 3,
};

enum ioctrl_regs___8 {
	POCCTRL0___3 = 0,
	POCCTRL1___2 = 1,
	POCCTRL2___3 = 2,
	TDSELCTRL___4 = 3,
};

enum iodev_type {
	IODEV_CPUIF = 0,
	IODEV_DIST = 1,
	IODEV_REDIST = 2,
	IODEV_ITS = 3,
};

enum iommu_atf_cmd {
	IOMMU_ATF_CMD_CONFIG_SMI_LARB = 0,
	IOMMU_ATF_CMD_CONFIG_INFRA_IOMMU = 1,
	IOMMU_ATF_CMD_MAX = 2,
};

enum iommu_cap {
	IOMMU_CAP_CACHE_COHERENCY = 0,
	IOMMU_CAP_NOEXEC = 1,
	IOMMU_CAP_PRE_BOOT_PROTECTION = 2,
	IOMMU_CAP_ENFORCE_CACHE_COHERENCY = 3,
	IOMMU_CAP_DEFERRED_FLUSH = 4,
	IOMMU_CAP_DIRTY_TRACKING = 5,
};

enum iommu_dma_queue_type {
	IOMMU_DMA_OPTS_PER_CPU_QUEUE = 0,
	IOMMU_DMA_OPTS_SINGLE_QUEUE = 1,
};

enum iommu_domain_cookie_type {
	IOMMU_COOKIE_NONE = 0,
	IOMMU_COOKIE_DMA_IOVA = 1,
	IOMMU_COOKIE_DMA_MSI = 2,
	IOMMU_COOKIE_FAULT_HANDLER = 3,
	IOMMU_COOKIE_SVA = 4,
	IOMMU_COOKIE_IOMMUFD = 5,
};

enum iommu_fault_type {
	IOMMU_FAULT_PAGE_REQ = 1,
};

enum iommu_hw_info_type {
	IOMMU_HW_INFO_TYPE_NONE = 0,
	IOMMU_HW_INFO_TYPE_DEFAULT = 0,
	IOMMU_HW_INFO_TYPE_INTEL_VTD = 1,
	IOMMU_HW_INFO_TYPE_ARM_SMMUV3 = 2,
	IOMMU_HW_INFO_TYPE_TEGRA241_CMDQV = 3,
};

enum iommu_hw_queue_type {
	IOMMU_HW_QUEUE_TYPE_DEFAULT = 0,
	IOMMU_HW_QUEUE_TYPE_TEGRA241_CMDQV = 1,
};

enum iommu_page_response_code {
	IOMMU_PAGE_RESP_SUCCESS = 0,
	IOMMU_PAGE_RESP_INVALID = 1,
	IOMMU_PAGE_RESP_FAILURE = 2,
};

enum iommu_resv_type {
	IOMMU_RESV_DIRECT = 0,
	IOMMU_RESV_DIRECT_RELAXABLE = 1,
	IOMMU_RESV_RESERVED = 2,
	IOMMU_RESV_MSI = 3,
	IOMMU_RESV_SW_MSI = 4,
};

enum iommu_viommu_type {
	IOMMU_VIOMMU_TYPE_DEFAULT = 0,
	IOMMU_VIOMMU_TYPE_ARM_SMMUV3 = 1,
	IOMMU_VIOMMU_TYPE_TEGRA241_CMDQV = 2,
};

enum iommufd_hwpt_alloc_flags {
	IOMMU_HWPT_ALLOC_NEST_PARENT = 1,
	IOMMU_HWPT_ALLOC_DIRTY_TRACKING = 2,
	IOMMU_HWPT_FAULT_ID_VALID = 4,
	IOMMU_HWPT_ALLOC_PASID = 8,
};

enum iommufd_object_type {
	IOMMUFD_OBJ_NONE = 0,
	IOMMUFD_OBJ_ANY = 0,
	IOMMUFD_OBJ_DEVICE = 1,
	IOMMUFD_OBJ_HWPT_PAGING = 2,
	IOMMUFD_OBJ_HWPT_NESTED = 3,
	IOMMUFD_OBJ_IOAS = 4,
	IOMMUFD_OBJ_ACCESS = 5,
	IOMMUFD_OBJ_FAULT = 6,
	IOMMUFD_OBJ_VIOMMU = 7,
	IOMMUFD_OBJ_VDEVICE = 8,
	IOMMUFD_OBJ_VEVENTQ = 9,
	IOMMUFD_OBJ_HW_QUEUE = 10,
	IOMMUFD_OBJ_MAX = 11,
};

enum ip_conntrack_dir {
	IP_CT_DIR_ORIGINAL = 0,
	IP_CT_DIR_REPLY = 1,
	IP_CT_DIR_MAX = 2,
};

enum ip_conntrack_info {
	IP_CT_ESTABLISHED = 0,
	IP_CT_RELATED = 1,
	IP_CT_NEW = 2,
	IP_CT_IS_REPLY = 3,
	IP_CT_ESTABLISHED_REPLY = 3,
	IP_CT_RELATED_REPLY = 4,
	IP_CT_NUMBER = 5,
	IP_CT_UNTRACKED = 7,
};

enum ip_conntrack_status {
	IPS_EXPECTED_BIT = 0,
	IPS_EXPECTED = 1,
	IPS_SEEN_REPLY_BIT = 1,
	IPS_SEEN_REPLY = 2,
	IPS_ASSURED_BIT = 2,
	IPS_ASSURED = 4,
	IPS_CONFIRMED_BIT = 3,
	IPS_CONFIRMED = 8,
	IPS_SRC_NAT_BIT = 4,
	IPS_SRC_NAT = 16,
	IPS_DST_NAT_BIT = 5,
	IPS_DST_NAT = 32,
	IPS_NAT_MASK = 48,
	IPS_SEQ_ADJUST_BIT = 6,
	IPS_SEQ_ADJUST = 64,
	IPS_SRC_NAT_DONE_BIT = 7,
	IPS_SRC_NAT_DONE = 128,
	IPS_DST_NAT_DONE_BIT = 8,
	IPS_DST_NAT_DONE = 256,
	IPS_NAT_DONE_MASK = 384,
	IPS_DYING_BIT = 9,
	IPS_DYING = 512,
	IPS_FIXED_TIMEOUT_BIT = 10,
	IPS_FIXED_TIMEOUT = 1024,
	IPS_TEMPLATE_BIT = 11,
	IPS_TEMPLATE = 2048,
	IPS_UNTRACKED_BIT = 12,
	IPS_UNTRACKED = 4096,
	IPS_NAT_CLASH_BIT = 12,
	IPS_NAT_CLASH = 4096,
	IPS_HELPER_BIT = 13,
	IPS_HELPER = 8192,
	IPS_OFFLOAD_BIT = 14,
	IPS_OFFLOAD = 16384,
	IPS_HW_OFFLOAD_BIT = 15,
	IPS_HW_OFFLOAD = 32768,
	IPS_UNCHANGEABLE_MASK = 56313,
	__IPS_MAX_BIT = 16,
};

enum ip_defrag_users {
	IP_DEFRAG_LOCAL_DELIVER = 0,
	IP_DEFRAG_CALL_RA_CHAIN = 1,
	IP_DEFRAG_CONNTRACK_IN = 2,
	__IP_DEFRAG_CONNTRACK_IN_END = 65537,
	IP_DEFRAG_CONNTRACK_OUT = 65538,
	__IP_DEFRAG_CONNTRACK_OUT_END = 131073,
	IP_DEFRAG_CONNTRACK_BRIDGE_IN = 131074,
	__IP_DEFRAG_CONNTRACK_BRIDGE_IN = 196609,
	IP_DEFRAG_VS_IN = 196610,
	IP_DEFRAG_VS_OUT = 196611,
	IP_DEFRAG_VS_FWD = 196612,
	IP_DEFRAG_AF_PACKET = 196613,
	IP_DEFRAG_MACVLAN = 196614,
};

enum ipi_msg_type {
	IPI_RESCHEDULE = 0,
	IPI_CALL_FUNC = 1,
	IPI_CPU_STOP = 2,
	IPI_CPU_STOP_NMI = 3,
	IPI_TIMER = 4,
	IPI_IRQ_WORK = 5,
	NR_IPI = 6,
	IPI_CPU_BACKTRACE = 6,
	IPI_KGDB_ROUNDUP = 7,
	MAX_IPI = 8,
};

enum ipi_vector {
	XEN_PLACEHOLDER_VECTOR = 0,
	XEN_NR_IPIS = 1,
};

enum ipmi_addr_space {
	IPMI_IO_ADDR_SPACE = 0,
	IPMI_MEM_ADDR_SPACE = 1,
};

enum ipmi_addr_src {
	SI_INVALID = 0,
	SI_HOTMOD = 1,
	SI_HARDCODED = 2,
	SI_SPMI = 3,
	SI_ACPI = 4,
	SI_SMBIOS = 5,
	SI_PCI = 6,
	SI_DEVICETREE = 7,
	SI_PLATFORM = 8,
	SI_LAST = 9,
};

enum ipmi_plat_interface_type {
	IPMI_PLAT_IF_SI = 0,
	IPMI_PLAT_IF_SSIF = 1,
};

enum ipq806x_versions {
	IPQ8062_VERSION = 0,
	IPQ8064_VERSION = 1,
	IPQ8065_VERSION = 2,
};

enum ipq8074_versions {
	IPQ8074_HAWKEYE_VERSION = 0,
	IPQ8074_ACORN_VERSION = 1,
};

enum iproc_arm_pll_fid {
	ARM_PLL_FID_CRYSTAL_CLK = 0,
	ARM_PLL_FID_SYS_CLK = 2,
	ARM_PLL_FID_CH0_SLOW_CLK = 6,
	ARM_PLL_FID_CH1_FAST_CLK = 7,
};

enum iproc_msi_reg {
	IPROC_MSI_EQ_PAGE = 0,
	IPROC_MSI_EQ_PAGE_UPPER = 1,
	IPROC_MSI_PAGE = 2,
	IPROC_MSI_PAGE_UPPER = 3,
	IPROC_MSI_CTRL = 4,
	IPROC_MSI_EQ_HEAD = 5,
	IPROC_MSI_EQ_TAIL = 6,
	IPROC_MSI_INTS_EN = 7,
	IPROC_MSI_REG_SIZE = 8,
};

enum iproc_pcie_ib_map_type {
	IPROC_PCIE_IB_MAP_MEM = 0,
	IPROC_PCIE_IB_MAP_IO = 1,
	IPROC_PCIE_IB_MAP_INVALID = 2,
};

enum iproc_pcie_reg {
	IPROC_PCIE_CLK_CTRL = 0,
	IPROC_PCIE_MSI_GIC_MODE = 1,
	IPROC_PCIE_MSI_BASE_ADDR = 2,
	IPROC_PCIE_MSI_WINDOW_SIZE = 3,
	IPROC_PCIE_MSI_ADDR_LO = 4,
	IPROC_PCIE_MSI_ADDR_HI = 5,
	IPROC_PCIE_MSI_EN_CFG = 6,
	IPROC_PCIE_CFG_IND_ADDR = 7,
	IPROC_PCIE_CFG_IND_DATA = 8,
	IPROC_PCIE_CFG_ADDR = 9,
	IPROC_PCIE_CFG_DATA = 10,
	IPROC_PCIE_INTX_EN = 11,
	IPROC_PCIE_OARR0 = 12,
	IPROC_PCIE_OMAP0 = 13,
	IPROC_PCIE_OARR1 = 14,
	IPROC_PCIE_OMAP1 = 15,
	IPROC_PCIE_OARR2 = 16,
	IPROC_PCIE_OMAP2 = 17,
	IPROC_PCIE_OARR3 = 18,
	IPROC_PCIE_OMAP3 = 19,
	IPROC_PCIE_IARR0 = 20,
	IPROC_PCIE_IMAP0 = 21,
	IPROC_PCIE_IARR1 = 22,
	IPROC_PCIE_IMAP1 = 23,
	IPROC_PCIE_IARR2 = 24,
	IPROC_PCIE_IMAP2 = 25,
	IPROC_PCIE_IARR3 = 26,
	IPROC_PCIE_IMAP3 = 27,
	IPROC_PCIE_IARR4 = 28,
	IPROC_PCIE_IMAP4 = 29,
	IPROC_PCIE_CFG_RD_STATUS = 30,
	IPROC_PCIE_LINK_STATUS = 31,
	IPROC_PCIE_APB_ERR_EN = 32,
	IPROC_PCIE_MAX_NUM_REG = 33,
};

enum iproc_pcie_type {
	IPROC_PCIE_PAXB_BCMA = 0,
	IPROC_PCIE_PAXB = 1,
	IPROC_PCIE_PAXB_V2 = 2,
	IPROC_PCIE_PAXC = 3,
	IPROC_PCIE_PAXC_V2 = 4,
};

enum iproc_pinconf_ctrl_type {
	IOCTRL_TYPE_AON = 1,
	IOCTRL_TYPE_CDRU = 2,
	IOCTRL_TYPE_INVALID = 3,
};

enum iproc_pinconf_param {
	IPROC_PINCONF_DRIVE_STRENGTH = 0,
	IPROC_PINCONF_BIAS_DISABLE = 1,
	IPROC_PINCONF_BIAS_PULL_UP = 2,
	IPROC_PINCONF_BIAS_PULL_DOWN = 3,
	IPROC_PINCON_MAX = 4,
};

enum irq_domain_bus_token {
	DOMAIN_BUS_ANY = 0,
	DOMAIN_BUS_WIRED = 1,
	DOMAIN_BUS_GENERIC_MSI = 2,
	DOMAIN_BUS_PCI_MSI = 3,
	DOMAIN_BUS_PLATFORM_MSI = 4,
	DOMAIN_BUS_NEXUS = 5,
	DOMAIN_BUS_IPI = 6,
	DOMAIN_BUS_FSL_MC_MSI = 7,
	DOMAIN_BUS_TI_SCI_INTA_MSI = 8,
	DOMAIN_BUS_WAKEUP = 9,
	DOMAIN_BUS_VMD_MSI = 10,
	DOMAIN_BUS_PCI_DEVICE_MSI = 11,
	DOMAIN_BUS_PCI_DEVICE_MSIX = 12,
	DOMAIN_BUS_DMAR = 13,
	DOMAIN_BUS_AMDVI = 14,
	DOMAIN_BUS_DEVICE_MSI = 15,
	DOMAIN_BUS_WIRED_TO_MSI = 16,
};

enum irq_gc_flags {
	IRQ_GC_INIT_MASK_CACHE = 1,
	IRQ_GC_INIT_NESTED_LOCK = 2,
	IRQ_GC_MASK_CACHE_PER_TYPE = 4,
	IRQ_GC_NO_MASK = 8,
	IRQ_GC_BE_IO = 16,
};

enum irq_source {
	SINGLE_L2 = 0,
	MUXED_L1 = 1,
};

enum irqchip_irq_state {
	IRQCHIP_STATE_PENDING = 0,
	IRQCHIP_STATE_ACTIVE = 1,
	IRQCHIP_STATE_MASKED = 2,
	IRQCHIP_STATE_LINE_LEVEL = 3,
};

enum irqreturn {
	IRQ_NONE = 0,
	IRQ_HANDLED = 1,
	IRQ_WAKE_THREAD = 2,
};

typedef enum irqreturn irqreturn_t;

enum isp1760_ctrl_state {
	ISP1760_CTRL_SETUP = 0,
	ISP1760_CTRL_DATA_IN = 1,
	ISP1760_CTRL_DATA_OUT = 2,
	ISP1760_CTRL_STATUS = 3,
};

enum isp1760_queue_head_types {
	QH_CONTROL = 0,
	QH_BULK = 1,
	QH_INTERRUPT = 2,
	QH_END = 3,
};

enum isp176x_device_controller_fields {
	DC_DEVEN = 0,
	DC_DEVADDR = 1,
	DC_VBUSSTAT = 2,
	DC_SFRESET = 3,
	DC_GLINTENA = 4,
	DC_CDBGMOD_ACK = 5,
	DC_DDBGMODIN_ACK = 6,
	DC_DDBGMODOUT_ACK = 7,
	DC_INTPOL = 8,
	DC_IEPRXTX_7 = 9,
	DC_IEPRXTX_6 = 10,
	DC_IEPRXTX_5 = 11,
	DC_IEPRXTX_4 = 12,
	DC_IEPRXTX_3 = 13,
	DC_IEPRXTX_2 = 14,
	DC_IEPRXTX_1 = 15,
	DC_IEPRXTX_0 = 16,
	DC_IEP0SETUP = 17,
	DC_IEVBUS = 18,
	DC_IEHS_STA = 19,
	DC_IERESM = 20,
	DC_IESUSP = 21,
	DC_IEBRST = 22,
	DC_EP0SETUP = 23,
	DC_ENDPIDX = 24,
	DC_EPDIR = 25,
	DC_CLBUF = 26,
	DC_VENDP = 27,
	DC_DSEN = 28,
	DC_STATUS = 29,
	DC_STALL = 30,
	DC_BUFLEN = 31,
	DC_FFOSZ = 32,
	DC_EPENABLE = 33,
	DC_ENDPTYP = 34,
	DC_FRAMENUM = 35,
	DC_UFRAMENUM = 36,
	DC_CHIP_ID_HIGH = 37,
	DC_CHIP_ID_LOW = 38,
	DC_SCRATCH = 39,
	DC_FIELD_MAX = 40,
};

enum isp176x_host_controller_fields {
	PORT_OWNER = 0,
	PORT_POWER = 1,
	PORT_LSTATUS = 2,
	PORT_RESET = 3,
	PORT_SUSPEND = 4,
	PORT_RESUME = 5,
	PORT_PE = 6,
	PORT_CSC = 7,
	PORT_CONNECT = 8,
	HCS_PPC = 9,
	HCS_N_PORTS = 10,
	HCC_ISOC_CACHE = 11,
	HCC_ISOC_THRES = 12,
	CMD_LRESET = 13,
	CMD_RESET = 14,
	CMD_RUN = 15,
	STS_PCD = 16,
	HC_FRINDEX = 17,
	FLAG_CF = 18,
	HC_ISO_PTD_DONEMAP = 19,
	HC_ISO_PTD_SKIPMAP = 20,
	HC_ISO_PTD_LASTPTD = 21,
	HC_INT_PTD_DONEMAP = 22,
	HC_INT_PTD_SKIPMAP = 23,
	HC_INT_PTD_LASTPTD = 24,
	HC_ATL_PTD_DONEMAP = 25,
	HC_ATL_PTD_SKIPMAP = 26,
	HC_ATL_PTD_LASTPTD = 27,
	ALL_ATX_RESET = 28,
	HW_ANA_DIGI_OC = 29,
	HW_DEV_DMA = 30,
	HW_COMN_IRQ = 31,
	HW_COMN_DMA = 32,
	HW_DATA_BUS_WIDTH = 33,
	HW_DACK_POL_HIGH = 34,
	HW_DREQ_POL_HIGH = 35,
	HW_INTR_HIGH_ACT = 36,
	HW_INTF_LOCK = 37,
	HW_INTR_EDGE_TRIG = 38,
	HW_GLOBAL_INTR_EN = 39,
	HC_CHIP_ID_HIGH = 40,
	HC_CHIP_ID_LOW = 41,
	HC_CHIP_REV = 42,
	HC_SCRATCH = 43,
	SW_RESET_RESET_ATX = 44,
	SW_RESET_RESET_HC = 45,
	SW_RESET_RESET_ALL = 46,
	ISO_BUF_FILL = 47,
	INT_BUF_FILL = 48,
	ATL_BUF_FILL = 49,
	MEM_BANK_SEL = 50,
	MEM_START_ADDR = 51,
	HC_DATA = 52,
	HC_INTERRUPT = 53,
	HC_INT_IRQ_ENABLE = 54,
	HC_ATL_IRQ_ENABLE = 55,
	HC_ISO_IRQ_MASK_OR = 56,
	HC_INT_IRQ_MASK_OR = 57,
	HC_ATL_IRQ_MASK_OR = 58,
	HC_ISO_IRQ_MASK_AND = 59,
	HC_INT_IRQ_MASK_AND = 60,
	HC_ATL_IRQ_MASK_AND = 61,
	HW_OTG_DISABLE = 62,
	HW_SW_SEL_HC_DC = 63,
	HW_VBUS_DRV = 64,
	HW_SEL_CP_EXT = 65,
	HW_DM_PULLDOWN = 66,
	HW_DP_PULLDOWN = 67,
	HW_DP_PULLUP = 68,
	HW_HC_2_DIS = 69,
	HW_OTG_DISABLE_CLEAR = 70,
	HW_SW_SEL_HC_DC_CLEAR = 71,
	HW_VBUS_DRV_CLEAR = 72,
	HW_SEL_CP_EXT_CLEAR = 73,
	HW_DM_PULLDOWN_CLEAR = 74,
	HW_DP_PULLDOWN_CLEAR = 75,
	HW_DP_PULLUP_CLEAR = 76,
	HW_HC_2_DIS_CLEAR = 77,
	HC_FIELD_MAX = 78,
};

enum iter_type {
	ITER_UBUF = 0,
	ITER_IOVEC = 1,
	ITER_BVEC = 2,
	ITER_KVEC = 3,
	ITER_FOLIOQ = 4,
	ITER_XARRAY = 5,
	ITER_DISCARD = 6,
};

enum its_vcpu_info_cmd_type {
	MAP_VLPI = 0,
	GET_VLPI = 1,
	PROP_UPDATE_VLPI = 2,
	PROP_UPDATE_AND_INV_VLPI = 3,
	SCHEDULE_VPE = 4,
	DESCHEDULE_VPE = 5,
	COMMIT_VPE = 6,
	INVALL_VPE = 7,
	PROP_UPDATE_VSGI = 8,
};

enum jbd2_shrink_type {
	JBD2_SHRINK_DESTROY = 0,
	JBD2_SHRINK_BUSY_STOP = 1,
	JBD2_SHRINK_BUSY_SKIP = 2,
};

enum jbd_state_bits {
	BH_JBD = 17,
	BH_JWrite = 18,
	BH_Freed = 19,
	BH_Revoked = 20,
	BH_RevokeValid = 21,
	BH_JBDDirty = 22,
	BH_JournalHead = 23,
	BH_Shadow = 24,
	BH_Verified = 25,
	BH_JBDPrivateStart = 26,
};

enum jump_label_type {
	JUMP_LABEL_NOP = 0,
	JUMP_LABEL_JMP = 1,
};

enum k3_dma_type {
	DMA_TYPE_UDMA = 0,
	DMA_TYPE_BCDMA = 1,
	DMA_TYPE_PKTDMA = 2,
};

enum k3_ring_mode {
	K3_RINGACC_RING_MODE_RING = 0,
	K3_RINGACC_RING_MODE_MESSAGE = 1,
	K3_RINGACC_RING_MODE_CREDENTIALS = 2,
	K3_RINGACC_RING_MODE_INVALID = 3,
};

enum k3_ring_size {
	K3_RINGACC_RING_ELSIZE_4 = 0,
	K3_RINGACC_RING_ELSIZE_8 = 1,
	K3_RINGACC_RING_ELSIZE_16 = 2,
	K3_RINGACC_RING_ELSIZE_32 = 3,
	K3_RINGACC_RING_ELSIZE_64 = 4,
	K3_RINGACC_RING_ELSIZE_128 = 5,
	K3_RINGACC_RING_ELSIZE_256 = 6,
	K3_RINGACC_RING_ELSIZE_INVALID = 7,
};

enum k3_ringacc_access_mode {
	K3_RINGACC_ACCESS_MODE_PUSH_HEAD = 0,
	K3_RINGACC_ACCESS_MODE_POP_HEAD = 1,
	K3_RINGACC_ACCESS_MODE_PUSH_TAIL = 2,
	K3_RINGACC_ACCESS_MODE_POP_TAIL = 3,
	K3_RINGACC_ACCESS_MODE_PEEK_HEAD = 4,
	K3_RINGACC_ACCESS_MODE_PEEK_TAIL = 5,
};

enum k3_ringacc_proxy_access_mode {
	PROXY_ACCESS_MODE_HEAD = 0,
	PROXY_ACCESS_MODE_TAIL = 1,
	PROXY_ACCESS_MODE_PEEK_HEAD = 2,
	PROXY_ACCESS_MODE_PEEK_TAIL = 3,
};

enum kcmp_type {
	KCMP_FILE = 0,
	KCMP_VM = 1,
	KCMP_FILES = 2,
	KCMP_FS = 3,
	KCMP_SIGHAND = 4,
	KCMP_IO = 5,
	KCMP_SYSVSEM = 6,
	KCMP_EPOLL_TFD = 7,
	KCMP_TYPES = 8,
};

enum kernel_load_data_id {
	LOADING_UNKNOWN = 0,
	LOADING_FIRMWARE = 1,
	LOADING_MODULE = 2,
	LOADING_KEXEC_IMAGE = 3,
	LOADING_KEXEC_INITRAMFS = 4,
	LOADING_POLICY = 5,
	LOADING_X509_CERTIFICATE = 6,
	LOADING_MAX_ID = 7,
};

enum kernel_pkey_operation {
	kernel_pkey_encrypt = 0,
	kernel_pkey_decrypt = 1,
	kernel_pkey_sign = 2,
	kernel_pkey_verify = 3,
};

enum kernel_read_file_id {
	READING_UNKNOWN = 0,
	READING_FIRMWARE = 1,
	READING_MODULE = 2,
	READING_KEXEC_IMAGE = 3,
	READING_KEXEC_INITRAMFS = 4,
	READING_POLICY = 5,
	READING_X509_CERTIFICATE = 6,
	READING_MAX_ID = 7,
};

enum kernfs_node_flag {
	KERNFS_ACTIVATED = 16,
	KERNFS_NS = 32,
	KERNFS_HAS_SEQ_SHOW = 64,
	KERNFS_HAS_MMAP = 128,
	KERNFS_LOCKDEP = 256,
	KERNFS_HIDDEN = 512,
	KERNFS_SUICIDAL = 1024,
	KERNFS_SUICIDED = 2048,
	KERNFS_EMPTY_DIR = 4096,
	KERNFS_HAS_RELEASE = 8192,
	KERNFS_REMOVING = 16384,
};

enum kernfs_node_type {
	KERNFS_DIR = 1,
	KERNFS_FILE = 2,
	KERNFS_LINK = 4,
};

enum kernfs_root_flag {
	KERNFS_ROOT_CREATE_DEACTIVATED = 1,
	KERNFS_ROOT_EXTRA_OPEN_PERM_CHECK = 2,
	KERNFS_ROOT_SUPPORT_EXPORTOP = 4,
	KERNFS_ROOT_SUPPORT_USER_XATTR = 8,
	KERNFS_ROOT_INVARIANT_PARENT = 16,
};

enum key_being_used_for {
	VERIFYING_MODULE_SIGNATURE = 0,
	VERIFYING_FIRMWARE_SIGNATURE = 1,
	VERIFYING_KEXEC_PE_SIGNATURE = 2,
	VERIFYING_KEY_SIGNATURE = 3,
	VERIFYING_KEY_SELF_SIGNATURE = 4,
	VERIFYING_UNSPECIFIED_SIGNATURE = 5,
	VERIFYING_BPF_SIGNATURE = 6,
	NR__KEY_BEING_USED_FOR = 7,
};

enum key_lookup_flag {
	KEY_LOOKUP_CREATE = 1,
	KEY_LOOKUP_PARTIAL = 2,
	KEY_LOOKUP_ALL = 3,
};

enum key_need_perm {
	KEY_NEED_UNSPECIFIED = 0,
	KEY_NEED_VIEW = 1,
	KEY_NEED_READ = 2,
	KEY_NEED_WRITE = 3,
	KEY_NEED_SEARCH = 4,
	KEY_NEED_LINK = 5,
	KEY_NEED_SETATTR = 6,
	KEY_NEED_UNLINK = 7,
	KEY_SYSADMIN_OVERRIDE = 8,
	KEY_AUTHTOKEN_OVERRIDE = 9,
	KEY_DEFER_PERM_CHECK = 10,
};

enum key_notification_subtype {
	NOTIFY_KEY_INSTANTIATED = 0,
	NOTIFY_KEY_UPDATED = 1,
	NOTIFY_KEY_LINKED = 2,
	NOTIFY_KEY_UNLINKED = 3,
	NOTIFY_KEY_CLEARED = 4,
	NOTIFY_KEY_REVOKED = 5,
	NOTIFY_KEY_INVALIDATED = 6,
	NOTIFY_KEY_SETATTR = 7,
};

enum key_state {
	KEY_IS_UNINSTANTIATED = 0,
	KEY_IS_POSITIVE = 1,
};

enum kfunc_ptr_arg_type {
	KF_ARG_PTR_TO_CTX = 0,
	KF_ARG_PTR_TO_ALLOC_BTF_ID = 1,
	KF_ARG_PTR_TO_REFCOUNTED_KPTR = 2,
	KF_ARG_PTR_TO_DYNPTR = 3,
	KF_ARG_PTR_TO_ITER = 4,
	KF_ARG_PTR_TO_LIST_HEAD = 5,
	KF_ARG_PTR_TO_LIST_NODE = 6,
	KF_ARG_PTR_TO_BTF_ID = 7,
	KF_ARG_PTR_TO_MEM = 8,
	KF_ARG_PTR_TO_MEM_SIZE = 9,
	KF_ARG_PTR_TO_CALLBACK = 10,
	KF_ARG_PTR_TO_RB_ROOT = 11,
	KF_ARG_PTR_TO_RB_NODE = 12,
	KF_ARG_PTR_TO_NULL = 13,
	KF_ARG_PTR_TO_CONST_STR = 14,
	KF_ARG_PTR_TO_MAP = 15,
	KF_ARG_PTR_TO_WORKQUEUE = 16,
	KF_ARG_PTR_TO_IRQ_FLAG = 17,
	KF_ARG_PTR_TO_RES_SPIN_LOCK = 18,
	KF_ARG_PTR_TO_TASK_WORK = 19,
};

enum kmalloc_cache_type {
	KMALLOC_NORMAL = 0,
	KMALLOC_RANDOM_START = 0,
	KMALLOC_RANDOM_END = 0,
	KMALLOC_RECLAIM = 1,
	KMALLOC_DMA = 2,
	KMALLOC_CGROUP = 3,
	NR_KMALLOC_TYPES = 4,
};

enum kmsg_dump_reason {
	KMSG_DUMP_UNDEF = 0,
	KMSG_DUMP_PANIC = 1,
	KMSG_DUMP_OOPS = 2,
	KMSG_DUMP_EMERG = 3,
	KMSG_DUMP_SHUTDOWN = 4,
	KMSG_DUMP_MAX = 5,
};

enum kobj_ns_type {
	KOBJ_NS_TYPE_NONE = 0,
	KOBJ_NS_TYPE_NET = 1,
	KOBJ_NS_TYPES = 2,
};

enum kobject_action {
	KOBJ_ADD = 0,
	KOBJ_REMOVE = 1,
	KOBJ_CHANGE = 2,
	KOBJ_MOVE = 3,
	KOBJ_ONLINE = 4,
	KOBJ_OFFLINE = 5,
	KOBJ_BIND = 6,
	KOBJ_UNBIND = 7,
};

enum kp_band {
	KP_BAND_MID = 0,
	KP_BAND_HIGH = 1,
	KP_BAND_HIGH_HIGH = 2,
};

enum kpage_operation {
	KPAGE_FLAGS = 0,
	KPAGE_COUNT = 1,
	KPAGE_CGROUP = 2,
};

enum ksm_advisor_type {
	KSM_ADVISOR_NONE = 0,
	KSM_ADVISOR_SCAN_TIME = 1,
};

enum ksm_get_folio_flags {
	KSM_GET_FOLIO_NOLOCK = 0,
	KSM_GET_FOLIO_LOCK = 1,
	KSM_GET_FOLIO_TRYLOCK = 2,
};

enum kunwind_source {
	KUNWIND_SOURCE_UNKNOWN = 0,
	KUNWIND_SOURCE_FRAME = 1,
	KUNWIND_SOURCE_CALLER = 2,
	KUNWIND_SOURCE_TASK = 3,
	KUNWIND_SOURCE_REGS_PC = 4,
};

enum kvm_arch_timer_regs {
	TIMER_REG_CNT = 0,
	TIMER_REG_CVAL = 1,
	TIMER_REG_TVAL = 2,
	TIMER_REG_CTL = 3,
	TIMER_REG_VOFF = 4,
};

enum kvm_arch_timers {
	TIMER_PTIMER = 0,
	TIMER_VTIMER = 1,
	NR_KVM_EL0_TIMERS = 2,
	TIMER_HVTIMER = 2,
	TIMER_HPTIMER = 3,
	NR_KVM_TIMERS = 4,
};

enum kvm_bus {
	KVM_MMIO_BUS = 0,
	KVM_PIO_BUS = 1,
	KVM_VIRTIO_CCW_NOTIFY_BUS = 2,
	KVM_FAST_MMIO_BUS = 3,
	KVM_IOCSR_BUS = 4,
	KVM_NR_BUSES = 5,
};

enum kvm_device_type {
	KVM_DEV_TYPE_FSL_MPIC_20 = 1,
	KVM_DEV_TYPE_FSL_MPIC_42 = 2,
	KVM_DEV_TYPE_XICS = 3,
	KVM_DEV_TYPE_VFIO = 4,
	KVM_DEV_TYPE_ARM_VGIC_V2 = 5,
	KVM_DEV_TYPE_FLIC = 6,
	KVM_DEV_TYPE_ARM_VGIC_V3 = 7,
	KVM_DEV_TYPE_ARM_VGIC_ITS = 8,
	KVM_DEV_TYPE_XIVE = 9,
	KVM_DEV_TYPE_ARM_PV_TIME = 10,
	KVM_DEV_TYPE_RISCV_AIA = 11,
	KVM_DEV_TYPE_LOONGARCH_IPI = 12,
	KVM_DEV_TYPE_LOONGARCH_EIOINTC = 13,
	KVM_DEV_TYPE_LOONGARCH_PCHPIC = 14,
	KVM_DEV_TYPE_MAX = 15,
};

enum kvm_gfn_range_filter {
	KVM_FILTER_SHARED = 1,
	KVM_FILTER_PRIVATE = 2,
};

enum kvm_mode {
	KVM_MODE_DEFAULT = 0,
	KVM_MODE_PROTECTED = 1,
	KVM_MODE_NV = 2,
	KVM_MODE_NONE = 3,
};

enum kvm_mr_change {
	KVM_MR_CREATE = 0,
	KVM_MR_DELETE = 1,
	KVM_MR_MOVE = 2,
	KVM_MR_FLAGS_ONLY = 3,
};

enum kvm_pgtable_prot {
	KVM_PGTABLE_PROT_X = 1ULL,
	KVM_PGTABLE_PROT_W = 2ULL,
	KVM_PGTABLE_PROT_R = 4ULL,
	KVM_PGTABLE_PROT_DEVICE = 8ULL,
	KVM_PGTABLE_PROT_NORMAL_NC = 16ULL,
	KVM_PGTABLE_PROT_SW0 = 36028797018963968ULL,
	KVM_PGTABLE_PROT_SW1 = 72057594037927936ULL,
	KVM_PGTABLE_PROT_SW2 = 144115188075855872ULL,
	KVM_PGTABLE_PROT_SW3 = 288230376151711744ULL,
};

enum kvm_pgtable_stage2_flags {
	KVM_PGTABLE_S2_NOFWB = 1,
	KVM_PGTABLE_S2_IDMAP = 2,
};

enum kvm_pgtable_walk_flags {
	KVM_PGTABLE_WALK_LEAF = 1,
	KVM_PGTABLE_WALK_TABLE_PRE = 2,
	KVM_PGTABLE_WALK_TABLE_POST = 4,
	KVM_PGTABLE_WALK_SHARED = 8,
	KVM_PGTABLE_WALK_HANDLE_FAULT = 16,
	KVM_PGTABLE_WALK_SKIP_BBM_TLBI = 32,
	KVM_PGTABLE_WALK_SKIP_CMO = 64,
};

enum kvm_smccc_filter_action {
	KVM_SMCCC_FILTER_HANDLE = 0,
	KVM_SMCCC_FILTER_DENY = 1,
	KVM_SMCCC_FILTER_FWD_TO_USER = 2,
	NR_SMCCC_FILTER_ACTIONS = 3,
};

enum kvm_stat_kind {
	KVM_STAT_VM = 0,
	KVM_STAT_VCPU = 1,
};

enum kvm_wfx_trap_policy {
	KVM_WFX_NOTRAP_SINGLE_TASK = 0,
	KVM_WFX_NOTRAP = 1,
	KVM_WFX_TRAP = 2,
};

enum latency_range {
	lowest_latency = 0,
	low_latency = 1,
	bulk_latency = 2,
	latency_invalid = 255,
};

enum layoutdriver_policy_flags {
	PNFS_LAYOUTRET_ON_SETATTR = 1,
	PNFS_LAYOUTRET_ON_ERROR = 2,
	PNFS_READ_WHOLE_PAGE = 4,
	PNFS_LAYOUTGET_ON_OPEN = 8,
};

enum led_brightness {
	LED_OFF = 0,
	LED_ON = 1,
	LED_HALF = 127,
	LED_FULL = 255,
};

enum led_default_state {
	LEDS_DEFSTATE_OFF = 0,
	LEDS_DEFSTATE_ON = 1,
	LEDS_DEFSTATE_KEEP = 2,
};

enum led_mode {
	MO_LED_NORM = 0,
	MO_LED_BLINK = 1,
	MO_LED_OFF = 2,
	MO_LED_ON = 3,
};

enum led_trigger_netdev_modes {
	TRIGGER_NETDEV_LINK = 0,
	TRIGGER_NETDEV_LINK_10 = 1,
	TRIGGER_NETDEV_LINK_100 = 2,
	TRIGGER_NETDEV_LINK_1000 = 3,
	TRIGGER_NETDEV_LINK_2500 = 4,
	TRIGGER_NETDEV_LINK_5000 = 5,
	TRIGGER_NETDEV_LINK_10000 = 6,
	TRIGGER_NETDEV_HALF_DUPLEX = 7,
	TRIGGER_NETDEV_FULL_DUPLEX = 8,
	TRIGGER_NETDEV_TX = 9,
	TRIGGER_NETDEV_RX = 10,
	TRIGGER_NETDEV_TX_ERR = 11,
	TRIGGER_NETDEV_RX_ERR = 12,
	__TRIGGER_NETDEV_MAX = 13,
};

enum legacy_fs_param {
	LEGACY_FS_UNSET_PARAMS = 0,
	LEGACY_FS_MONOLITHIC_PARAMS = 1,
	LEGACY_FS_INDIVIDUAL_PARAMS = 2,
};

enum lightbar_command {
	LIGHTBAR_CMD_DUMP = 0,
	LIGHTBAR_CMD_OFF = 1,
	LIGHTBAR_CMD_ON = 2,
	LIGHTBAR_CMD_INIT = 3,
	LIGHTBAR_CMD_SET_BRIGHTNESS = 4,
	LIGHTBAR_CMD_SEQ = 5,
	LIGHTBAR_CMD_REG = 6,
	LIGHTBAR_CMD_SET_RGB = 7,
	LIGHTBAR_CMD_GET_SEQ = 8,
	LIGHTBAR_CMD_DEMO = 9,
	LIGHTBAR_CMD_GET_PARAMS_V0 = 10,
	LIGHTBAR_CMD_SET_PARAMS_V0 = 11,
	LIGHTBAR_CMD_VERSION = 12,
	LIGHTBAR_CMD_GET_BRIGHTNESS = 13,
	LIGHTBAR_CMD_GET_RGB = 14,
	LIGHTBAR_CMD_GET_DEMO = 15,
	LIGHTBAR_CMD_GET_PARAMS_V1 = 16,
	LIGHTBAR_CMD_SET_PARAMS_V1 = 17,
	LIGHTBAR_CMD_SET_PROGRAM = 18,
	LIGHTBAR_CMD_MANUAL_SUSPEND_CTRL = 19,
	LIGHTBAR_CMD_SUSPEND = 20,
	LIGHTBAR_CMD_RESUME = 21,
	LIGHTBAR_CMD_GET_PARAMS_V2_TIMING = 22,
	LIGHTBAR_CMD_SET_PARAMS_V2_TIMING = 23,
	LIGHTBAR_CMD_GET_PARAMS_V2_TAP = 24,
	LIGHTBAR_CMD_SET_PARAMS_V2_TAP = 25,
	LIGHTBAR_CMD_GET_PARAMS_V2_OSCILLATION = 26,
	LIGHTBAR_CMD_SET_PARAMS_V2_OSCILLATION = 27,
	LIGHTBAR_CMD_GET_PARAMS_V2_BRIGHTNESS = 28,
	LIGHTBAR_CMD_SET_PARAMS_V2_BRIGHTNESS = 29,
	LIGHTBAR_CMD_GET_PARAMS_V2_THRESHOLDS = 30,
	LIGHTBAR_CMD_SET_PARAMS_V2_THRESHOLDS = 31,
	LIGHTBAR_CMD_GET_PARAMS_V2_COLORS = 32,
	LIGHTBAR_CMD_SET_PARAMS_V2_COLORS = 33,
	LIGHTBAR_NUM_CMDS = 34,
};

enum limit_by4 {
	NFS4_LIMIT_SIZE = 1,
	NFS4_LIMIT_BLOCKS = 2,
};

enum link_inband_signalling {
	LINK_INBAND_DISABLE = 1,
	LINK_INBAND_ENABLE = 2,
	LINK_INBAND_BYPASS = 4,
};

enum locality_types {
	WRITE_LATENCY = 0,
	READ_LATENCY = 1,
	WRITE_BANDWIDTH = 2,
	READ_BANDWIDTH = 3,
};

enum lock_type4 {
	NFS4_UNLOCK_LT = 0,
	NFS4_READ_LT = 1,
	NFS4_WRITE_LT = 2,
	NFS4_READW_LT = 3,
	NFS4_WRITEW_LT = 4,
};

enum lockdep_ok {
	LOCKDEP_STILL_OK = 0,
	LOCKDEP_NOW_UNRELIABLE = 1,
};

enum lockdown_reason {
	LOCKDOWN_NONE = 0,
	LOCKDOWN_MODULE_SIGNATURE = 1,
	LOCKDOWN_DEV_MEM = 2,
	LOCKDOWN_EFI_TEST = 3,
	LOCKDOWN_KEXEC = 4,
	LOCKDOWN_HIBERNATION = 5,
	LOCKDOWN_PCI_ACCESS = 6,
	LOCKDOWN_IOPORT = 7,
	LOCKDOWN_MSR = 8,
	LOCKDOWN_ACPI_TABLES = 9,
	LOCKDOWN_DEVICE_TREE = 10,
	LOCKDOWN_PCMCIA_CIS = 11,
	LOCKDOWN_TIOCSSERIAL = 12,
	LOCKDOWN_MODULE_PARAMETERS = 13,
	LOCKDOWN_MMIOTRACE = 14,
	LOCKDOWN_DEBUGFS = 15,
	LOCKDOWN_XMON_WR = 16,
	LOCKDOWN_BPF_WRITE_USER = 17,
	LOCKDOWN_DBG_WRITE_KERNEL = 18,
	LOCKDOWN_RTAS_ERROR_INJECTION = 19,
	LOCKDOWN_INTEGRITY_MAX = 20,
	LOCKDOWN_KCORE = 21,
	LOCKDOWN_KPROBES = 22,
	LOCKDOWN_BPF_READ_KERNEL = 23,
	LOCKDOWN_DBG_READ_KERNEL = 24,
	LOCKDOWN_PERF = 25,
	LOCKDOWN_TRACEFS = 26,
	LOCKDOWN_XMON_RW = 27,
	LOCKDOWN_XFRM_SECRET = 28,
	LOCKDOWN_CONFIDENTIALITY_MAX = 29,
};

enum lpi2c_imx_mode {
	STANDARD = 0,
	FAST = 1,
	FAST_PLUS = 2,
	HS = 3,
	ULTRA_FAST = 4,
};

enum lpi2c_imx_pincfg {
	TWO_PIN_OD = 0,
	TWO_PIN_OO = 1,
	TWO_PIN_PP = 2,
	FOUR_PIN_PP = 3,
};

enum lpuart_type {
	VF610_LPUART = 0,
	LS1021A_LPUART = 1,
	LS1028A_LPUART = 2,
	IMX7ULP_LPUART = 3,
	IMX8ULP_LPUART = 4,
	IMX8QXP_LPUART = 5,
	IMXRT1050_LPUART = 6,
};

enum lru_list {
	LRU_INACTIVE_ANON = 0,
	LRU_ACTIVE_ANON = 1,
	LRU_INACTIVE_FILE = 2,
	LRU_ACTIVE_FILE = 3,
	LRU_UNEVICTABLE = 4,
	NR_LRU_LISTS = 5,
};

enum lru_status {
	LRU_REMOVED = 0,
	LRU_REMOVED_RETRY = 1,
	LRU_ROTATE = 2,
	LRU_SKIP = 3,
	LRU_RETRY = 4,
	LRU_STOP = 5,
};

enum lruvec_flags {
	LRUVEC_CGROUP_CONGESTED = 0,
	LRUVEC_NODE_CONGESTED = 1,
};

enum lsm_event {
	LSM_POLICY_CHANGE = 0,
};

enum lsm_integrity_type {
	LSM_INT_DMVERITY_SIG_VALID = 0,
	LSM_INT_DMVERITY_ROOTHASH = 1,
	LSM_INT_FSVERITY_BUILTINSIG_VALID = 2,
};

enum lsm_order {
	LSM_ORDER_FIRST = -1,
	LSM_ORDER_MUTABLE = 0,
	LSM_ORDER_LAST = 1,
};

enum lw_bits {
	LW_URGENT = 0,
};

enum lwtunnel_encap_types {
	LWTUNNEL_ENCAP_NONE = 0,
	LWTUNNEL_ENCAP_MPLS = 1,
	LWTUNNEL_ENCAP_IP = 2,
	LWTUNNEL_ENCAP_ILA = 3,
	LWTUNNEL_ENCAP_IP6 = 4,
	LWTUNNEL_ENCAP_SEG6 = 5,
	LWTUNNEL_ENCAP_BPF = 6,
	LWTUNNEL_ENCAP_SEG6_LOCAL = 7,
	LWTUNNEL_ENCAP_RPL = 8,
	LWTUNNEL_ENCAP_IOAM6 = 9,
	LWTUNNEL_ENCAP_XFRM = 10,
	__LWTUNNEL_ENCAP_MAX = 11,
};

enum lwtunnel_ip6_t {
	LWTUNNEL_IP6_UNSPEC = 0,
	LWTUNNEL_IP6_ID = 1,
	LWTUNNEL_IP6_DST = 2,
	LWTUNNEL_IP6_SRC = 3,
	LWTUNNEL_IP6_HOPLIMIT = 4,
	LWTUNNEL_IP6_TC = 5,
	LWTUNNEL_IP6_FLAGS = 6,
	LWTUNNEL_IP6_PAD = 7,
	LWTUNNEL_IP6_OPTS = 8,
	__LWTUNNEL_IP6_MAX = 9,
};

enum lwtunnel_ip_t {
	LWTUNNEL_IP_UNSPEC = 0,
	LWTUNNEL_IP_ID = 1,
	LWTUNNEL_IP_DST = 2,
	LWTUNNEL_IP_SRC = 3,
	LWTUNNEL_IP_TTL = 4,
	LWTUNNEL_IP_TOS = 5,
	LWTUNNEL_IP_FLAGS = 6,
	LWTUNNEL_IP_PAD = 7,
	LWTUNNEL_IP_OPTS = 8,
	__LWTUNNEL_IP_MAX = 9,
};

enum lzma2_seq {
	SEQ_CONTROL = 0,
	SEQ_UNCOMPRESSED_1 = 1,
	SEQ_UNCOMPRESSED_2 = 2,
	SEQ_COMPRESSED_0 = 3,
	SEQ_COMPRESSED_1 = 4,
	SEQ_PROPERTIES = 5,
	SEQ_LZMA_PREPARE = 6,
	SEQ_LZMA_RUN = 7,
	SEQ_COPY = 8,
};

enum lzma_state {
	STATE_LIT_LIT = 0,
	STATE_MATCH_LIT_LIT = 1,
	STATE_REP_LIT_LIT = 2,
	STATE_SHORTREP_LIT_LIT = 3,
	STATE_MATCH_LIT = 4,
	STATE_REP_LIT = 5,
	STATE_SHORTREP_LIT = 6,
	STATE_LIT_MATCH = 7,
	STATE_LIT_LONGREP = 8,
	STATE_LIT_SHORTREP = 9,
	STATE_NONLIT_MATCH = 10,
	STATE_NONLIT_REP = 11,
};

enum mac_commom_mode {
	MAC_COMM_MODE_NONE = 0,
	MAC_COMM_MODE_RX = 1,
	MAC_COMM_MODE_TX = 2,
	MAC_COMM_MODE_RX_AND_TX = 3,
};

enum mac_mode {
	MAC_MODE_INVALID = 0,
	MAC_MODE_MII_10 = 65546,
	MAC_MODE_MII_100 = 65636,
	MAC_MODE_RMII_10 = 131082,
	MAC_MODE_RMII_100 = 131172,
	MAC_MODE_SMII_10 = 196618,
	MAC_MODE_SMII_100 = 196708,
	MAC_MODE_GMII_1000 = 263144,
	MAC_MODE_RGMII_10 = 327690,
	MAC_MODE_RGMII_100 = 327780,
	MAC_MODE_RGMII_1000 = 328680,
	MAC_MODE_TBI_1000 = 394216,
	MAC_MODE_RTBI_1000 = 459752,
	MAC_MODE_SGMII_10 = 524298,
	MAC_MODE_SGMII_100 = 524388,
	MAC_MODE_SGMII_1000 = 525288,
	MAC_MODE_XGMII_10000 = 599824,
	MAC_MODE_QSGMII_1000 = 656360,
};

enum mac_speed {
	MAC_SPEED_10 = 10,
	MAC_SPEED_100 = 100,
	MAC_SPEED_1000 = 1000,
	MAC_SPEED_10000 = 10000,
};

enum macb_bd_control {
	TSTAMP_DISABLED = 0,
	TSTAMP_FRAME_PTP_EVENT_ONLY = 1,
	TSTAMP_ALL_PTP_FRAMES = 2,
	TSTAMP_ALL_FRAMES = 3,
};

enum madvise_lock_mode {
	MADVISE_NO_LOCK = 0,
	MADVISE_MMAP_READ_LOCK = 1,
	MADVISE_MMAP_WRITE_LOCK = 2,
	MADVISE_VMA_READ_LOCK = 3,
};

enum maple_status {
	ma_active = 0,
	ma_start = 1,
	ma_root = 2,
	ma_none = 3,
	ma_pause = 4,
	ma_overflow = 5,
	ma_underflow = 6,
	ma_error = 7,
};

enum maple_type {
	maple_dense = 0,
	maple_leaf_64 = 1,
	maple_range_64 = 2,
	maple_arange_64 = 3,
};

enum mapping_flags {
	AS_EIO = 0,
	AS_ENOSPC = 1,
	AS_MM_ALL_LOCKS = 2,
	AS_UNEVICTABLE = 3,
	AS_EXITING = 4,
	AS_NO_WRITEBACK_TAGS = 5,
	AS_RELEASE_ALWAYS = 6,
	AS_STABLE_WRITES = 7,
	AS_INACCESSIBLE = 8,
	AS_WRITEBACK_MAY_DEADLOCK_ON_RECLAIM = 9,
	AS_KERNEL_FILE = 10,
	AS_FOLIO_ORDER_BITS = 5,
	AS_FOLIO_ORDER_MIN = 16,
	AS_FOLIO_ORDER_MAX = 21,
};

enum max77620_alternate_pinmux_option {
	MAX77620_PINMUX_GPIO = 0,
	MAX77620_PINMUX_LOW_POWER_MODE_CONTROL_IN = 1,
	MAX77620_PINMUX_FLEXIBLE_POWER_SEQUENCER_OUT = 2,
	MAX77620_PINMUX_32K_OUT1 = 3,
	MAX77620_PINMUX_SD0_DYNAMIC_VOLTAGE_SCALING_IN = 4,
	MAX77620_PINMUX_SD1_DYNAMIC_VOLTAGE_SCALING_IN = 5,
	MAX77620_PINMUX_REFERENCE_OUT = 6,
};

enum max77620_chip_id {
	MAX77620 = 0,
	MAX20024 = 1,
	MAX77663 = 2,
};

enum max77620_fps_src {
	MAX77620_FPS_SRC_0 = 0,
	MAX77620_FPS_SRC_1 = 1,
	MAX77620_FPS_SRC_2 = 2,
	MAX77620_FPS_SRC_NONE = 3,
	MAX77620_FPS_SRC_DEF = 4,
};

enum max77620_pin_ppdrv {
	MAX77620_PIN_UNCONFIG_DRV = 0,
	MAX77620_PIN_OD_DRV = 1,
	MAX77620_PIN_PP_DRV = 2,
};

enum max77620_regulator_type {
	MAX77620_REGULATOR_TYPE_SD = 0,
	MAX77620_REGULATOR_TYPE_LDO_N = 1,
	MAX77620_REGULATOR_TYPE_LDO_P = 2,
};

enum max77620_regulators {
	MAX77620_REGULATOR_ID_SD0 = 0,
	MAX77620_REGULATOR_ID_SD1 = 1,
	MAX77620_REGULATOR_ID_SD2 = 2,
	MAX77620_REGULATOR_ID_SD3 = 3,
	MAX77620_REGULATOR_ID_SD4 = 4,
	MAX77620_REGULATOR_ID_LDO0 = 5,
	MAX77620_REGULATOR_ID_LDO1 = 6,
	MAX77620_REGULATOR_ID_LDO2 = 7,
	MAX77620_REGULATOR_ID_LDO3 = 8,
	MAX77620_REGULATOR_ID_LDO4 = 9,
	MAX77620_REGULATOR_ID_LDO5 = 10,
	MAX77620_REGULATOR_ID_LDO6 = 11,
	MAX77620_REGULATOR_ID_LDO7 = 12,
	MAX77620_REGULATOR_ID_LDO8 = 13,
	MAX77620_NUM_REGS = 14,
};

enum max77686_irq {
	MAX77686_PMICIRQ_PWRONF = 0,
	MAX77686_PMICIRQ_PWRONR = 1,
	MAX77686_PMICIRQ_JIGONBF = 2,
	MAX77686_PMICIRQ_JIGONBR = 3,
	MAX77686_PMICIRQ_ACOKBF = 4,
	MAX77686_PMICIRQ_ACOKBR = 5,
	MAX77686_PMICIRQ_ONKEY1S = 6,
	MAX77686_PMICIRQ_MRSTB = 7,
	MAX77686_PMICIRQ_140C = 8,
	MAX77686_PMICIRQ_120C = 9,
	MAX77686_RTCIRQ_RTC60S = 0,
	MAX77686_RTCIRQ_RTCA1 = 1,
	MAX77686_RTCIRQ_RTCA2 = 2,
	MAX77686_RTCIRQ_SMPL = 3,
	MAX77686_RTCIRQ_RTC1S = 4,
	MAX77686_RTCIRQ_WTSR = 5,
};

enum max77686_rtc_reg_offset {
	REG_RTC_CONTROLM = 0,
	REG_RTC_CONTROL = 1,
	REG_RTC_UPDATE0 = 2,
	REG_WTSR_SMPL_CNTL = 3,
	REG_RTC_SEC = 4,
	REG_RTC_MIN = 5,
	REG_RTC_HOUR = 6,
	REG_RTC_WEEKDAY = 7,
	REG_RTC_MONTH = 8,
	REG_RTC_YEAR = 9,
	REG_RTC_MONTHDAY = 10,
	REG_ALARM1_SEC = 11,
	REG_ALARM1_MIN = 12,
	REG_ALARM1_HOUR = 13,
	REG_ALARM1_WEEKDAY = 14,
	REG_ALARM1_MONTH = 15,
	REG_ALARM1_YEAR = 16,
	REG_ALARM1_DATE = 17,
	REG_ALARM2_SEC = 18,
	REG_ALARM2_MIN = 19,
	REG_ALARM2_HOUR = 20,
	REG_ALARM2_WEEKDAY = 21,
	REG_ALARM2_MONTH = 22,
	REG_ALARM2_YEAR = 23,
	REG_ALARM2_DATE = 24,
	REG_RTC_AE1 = 25,
	REG_RTC_END = 26,
};

enum mc_cmd_status {
	MC_CMD_STATUS_OK = 0,
	MC_CMD_STATUS_READY = 1,
	MC_CMD_STATUS_AUTH_ERR = 3,
	MC_CMD_STATUS_NO_PRIVILEGE = 4,
	MC_CMD_STATUS_DMA_ERR = 5,
	MC_CMD_STATUS_CONFIG_ERR = 6,
	MC_CMD_STATUS_TIMEOUT = 7,
	MC_CMD_STATUS_NO_RESOURCE = 8,
	MC_CMD_STATUS_NO_MEMORY = 9,
	MC_CMD_STATUS_BUSY = 10,
	MC_CMD_STATUS_UNSUPPORTED_OP = 11,
	MC_CMD_STATUS_INVALID_STATE = 12,
};

enum mctrl_gpio_idx {
	UART_GPIO_CTS = 0,
	UART_GPIO_DSR = 1,
	UART_GPIO_DCD = 2,
	UART_GPIO_RNG = 3,
	UART_GPIO_RI = 3,
	UART_GPIO_RTS = 4,
	UART_GPIO_DTR = 5,
	UART_GPIO_MAX = 6,
};

enum mdio_c22_op_seq {
	MDIO_C22_WRITE = 1,
	MDIO_C22_READ = 2,
};

enum mdio_c45_op_seq {
	MDIO_C45_WRITE_ADDR = 0,
	MDIO_C45_WRITE_DATA = 1,
	MDIO_C45_READ_INCREMENT = 2,
	MDIO_C45_READ = 3,
};

enum mdio_st_clause {
	MDIO_ST_CLAUSE_45 = 0,
	MDIO_ST_CLAUSE_22 = 1,
};

enum mem_type {
	MEM_EMPTY = 0,
	MEM_RESERVED = 1,
	MEM_UNKNOWN = 2,
	MEM_FPM = 3,
	MEM_EDO = 4,
	MEM_BEDO = 5,
	MEM_SDR = 6,
	MEM_RDR = 7,
	MEM_DDR = 8,
	MEM_RDDR = 9,
	MEM_RMBS = 10,
	MEM_DDR2 = 11,
	MEM_FB_DDR2 = 12,
	MEM_RDDR2 = 13,
	MEM_XDR = 14,
	MEM_DDR3 = 15,
	MEM_RDDR3 = 16,
	MEM_LRDDR3 = 17,
	MEM_LPDDR3 = 18,
	MEM_DDR4 = 19,
	MEM_RDDR4 = 20,
	MEM_LRDDR4 = 21,
	MEM_LPDDR4 = 22,
	MEM_DDR5 = 23,
	MEM_RDDR5 = 24,
	MEM_LRDDR5 = 25,
	MEM_NVDIMM = 26,
	MEM_WIO2 = 27,
	MEM_HBM2 = 28,
	MEM_HBM3 = 29,
};

enum membarrier_cmd {
	MEMBARRIER_CMD_QUERY = 0,
	MEMBARRIER_CMD_GLOBAL = 1,
	MEMBARRIER_CMD_GLOBAL_EXPEDITED = 2,
	MEMBARRIER_CMD_REGISTER_GLOBAL_EXPEDITED = 4,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED = 8,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED = 16,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_SYNC_CORE = 64,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_RSEQ = 128,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_RSEQ = 256,
	MEMBARRIER_CMD_GET_REGISTRATIONS = 512,
	MEMBARRIER_CMD_SHARED = 1,
};

enum membarrier_cmd_flag {
	MEMBARRIER_CMD_FLAG_CPU = 1,
};

enum memblock_flags {
	MEMBLOCK_NONE = 0,
	MEMBLOCK_HOTPLUG = 1,
	MEMBLOCK_MIRROR = 2,
	MEMBLOCK_NOMAP = 4,
	MEMBLOCK_DRIVER_MANAGED = 8,
	MEMBLOCK_RSRV_NOINIT = 16,
	MEMBLOCK_RSRV_KERN = 32,
	MEMBLOCK_KHO_SCRATCH = 64,
};

enum memcg_memory_event {
	MEMCG_LOW = 0,
	MEMCG_HIGH = 1,
	MEMCG_MAX = 2,
	MEMCG_OOM = 3,
	MEMCG_OOM_KILL = 4,
	MEMCG_OOM_GROUP_KILL = 5,
	MEMCG_SWAP_HIGH = 6,
	MEMCG_SWAP_MAX = 7,
	MEMCG_SWAP_FAIL = 8,
	MEMCG_NR_MEMORY_EVENTS = 9,
};

enum memcg_stat_item {
	MEMCG_SWAP = 51,
	MEMCG_SOCK = 52,
	MEMCG_PERCPU_B = 53,
	MEMCG_VMALLOC = 54,
	MEMCG_KMEM = 55,
	MEMCG_ZSWAP_B = 56,
	MEMCG_ZSWAPPED = 57,
	MEMCG_NR_STAT = 58,
};

enum meminit_context {
	MEMINIT_EARLY = 0,
	MEMINIT_HOTPLUG = 1,
};

enum memory_type {
	MEMORY_DEVICE_PRIVATE = 1,
	MEMORY_DEVICE_COHERENT = 2,
	MEMORY_DEVICE_FS_DAX = 3,
	MEMORY_DEVICE_GENERIC = 4,
	MEMORY_DEVICE_PCI_P2PDMA = 5,
};

enum meson_pinconf_drv {
	MESON_PINCONF_DRV_500UA = 0,
	MESON_PINCONF_DRV_2500UA = 1,
	MESON_PINCONF_DRV_3000UA = 2,
	MESON_PINCONF_DRV_4000UA = 3,
};

enum meson_reg_type {
	MESON_REG_PULLEN = 0,
	MESON_REG_PULL = 1,
	MESON_REG_DIR = 2,
	MESON_REG_OUT = 3,
	MESON_REG_IN = 4,
	MESON_REG_DS = 5,
	MESON_NUM_REG = 6,
};

enum meson_sar_adc_avg_mode {
	NO_AVERAGING = 0,
	MEAN_AVERAGING = 1,
	MEDIAN_AVERAGING = 2,
};

enum meson_sar_adc_chan7_mux_sel {
	CHAN7_MUX_VSS = 0,
	CHAN7_MUX_VDD_DIV4 = 1,
	CHAN7_MUX_VDD_DIV2 = 2,
	CHAN7_MUX_VDD_MUL3_DIV4 = 3,
	CHAN7_MUX_VDD = 4,
	CHAN7_MUX_CH7_INPUT = 7,
};

enum meson_sar_adc_channel_index {
	NUM_CHAN_0 = 0,
	NUM_CHAN_1 = 1,
	NUM_CHAN_2 = 2,
	NUM_CHAN_3 = 3,
	NUM_CHAN_4 = 4,
	NUM_CHAN_5 = 5,
	NUM_CHAN_6 = 6,
	NUM_CHAN_7 = 7,
	NUM_CHAN_TEMP = 8,
	NUM_MUX_0_VSS = 9,
	NUM_MUX_1_VDD_DIV4 = 10,
	NUM_MUX_2_VDD_DIV2 = 11,
	NUM_MUX_3_VDD_MUL3_DIV4 = 12,
	NUM_MUX_4_VDD = 13,
};

enum meson_sar_adc_num_samples {
	ONE_SAMPLE = 0,
	TWO_SAMPLES = 1,
	FOUR_SAMPLES = 2,
	EIGHT_SAMPLES = 3,
};

enum meson_sar_adc_vref_sel {
	VREF_CALIBATION_VOLTAGE = 0,
	VREF_VDDA = 1,
};

enum meson_soc_id {
	MESON_SOC_G12A = 0,
	MESON_SOC_A1 = 1,
};

enum metadata_type {
	METADATA_IP_TUNNEL = 0,
	METADATA_HW_PORT_MUX = 1,
	METADATA_MACSEC = 2,
	METADATA_XFRM = 3,
};

enum mf_action_page_type {
	MF_MSG_KERNEL = 0,
	MF_MSG_KERNEL_HIGH_ORDER = 1,
	MF_MSG_DIFFERENT_COMPOUND = 2,
	MF_MSG_HUGE = 3,
	MF_MSG_FREE_HUGE = 4,
	MF_MSG_GET_HWPOISON = 5,
	MF_MSG_UNMAP_FAILED = 6,
	MF_MSG_DIRTY_SWAPCACHE = 7,
	MF_MSG_CLEAN_SWAPCACHE = 8,
	MF_MSG_DIRTY_MLOCKED_LRU = 9,
	MF_MSG_CLEAN_MLOCKED_LRU = 10,
	MF_MSG_DIRTY_UNEVICTABLE_LRU = 11,
	MF_MSG_CLEAN_UNEVICTABLE_LRU = 12,
	MF_MSG_DIRTY_LRU = 13,
	MF_MSG_CLEAN_LRU = 14,
	MF_MSG_TRUNCATED_LRU = 15,
	MF_MSG_BUDDY = 16,
	MF_MSG_DAX = 17,
	MF_MSG_UNSPLIT_THP = 18,
	MF_MSG_ALREADY_POISONED = 19,
	MF_MSG_UNKNOWN = 20,
};

enum mf_flags {
	MF_COUNT_INCREASED = 1,
	MF_ACTION_REQUIRED = 2,
	MF_MUST_KILL = 4,
	MF_SOFT_OFFLINE = 8,
	MF_UNPOISON = 16,
	MF_SW_SIMULATED = 32,
	MF_NO_RETRY = 64,
	MF_MEM_PRE_REMOVE = 128,
};

enum mf_result {
	MF_IGNORED = 0,
	MF_FAILED = 1,
	MF_DELAYED = 2,
	MF_RECOVERED = 3,
};

enum mfi_evt_class {
	MFI_EVT_CLASS_DEBUG = -2,
	MFI_EVT_CLASS_PROGRESS = -1,
	MFI_EVT_CLASS_INFO = 0,
	MFI_EVT_CLASS_WARNING = 1,
	MFI_EVT_CLASS_CRITICAL = 2,
	MFI_EVT_CLASS_FATAL = 3,
	MFI_EVT_CLASS_DEAD = 4,
};

enum migrate_mode {
	MIGRATE_ASYNC = 0,
	MIGRATE_SYNC_LIGHT = 1,
	MIGRATE_SYNC = 2,
};

enum migrate_reason {
	MR_COMPACTION = 0,
	MR_MEMORY_FAILURE = 1,
	MR_MEMORY_HOTPLUG = 2,
	MR_SYSCALL = 3,
	MR_MEMPOLICY_MBIND = 4,
	MR_NUMA_MISPLACED = 5,
	MR_CONTIG_RANGE = 6,
	MR_LONGTERM_PIN = 7,
	MR_DEMOTION = 8,
	MR_DAMON = 9,
	MR_TYPES = 10,
};

enum migratetype {
	MIGRATE_UNMOVABLE = 0,
	MIGRATE_MOVABLE = 1,
	MIGRATE_RECLAIMABLE = 2,
	MIGRATE_PCPTYPES = 3,
	MIGRATE_HIGHATOMIC = 3,
	MIGRATE_CMA = 4,
	__MIGRATE_TYPE_END = 4,
	MIGRATE_ISOLATE = 5,
	MIGRATE_TYPES = 6,
};

enum migration_type {
	migrate_load = 0,
	migrate_util = 1,
	migrate_task = 2,
	migrate_misfit = 3,
};

enum mipi_dsi_compression_algo {
	MIPI_DSI_COMPRESSION_DSC = 0,
	MIPI_DSI_COMPRESSION_VENDOR = 3,
};

enum mipi_dsi_dcs_tear_mode {
	MIPI_DSI_DCS_TEAR_MODE_VBLANK = 0,
	MIPI_DSI_DCS_TEAR_MODE_VHBLANK = 1,
};

enum mipi_dsi_pixel_format {
	MIPI_DSI_FMT_RGB888 = 0,
	MIPI_DSI_FMT_RGB666 = 1,
	MIPI_DSI_FMT_RGB666_PACKED = 2,
	MIPI_DSI_FMT_RGB565 = 3,
};

enum mitigation_state {
	SPECTRE_UNAFFECTED = 0,
	SPECTRE_MITIGATED = 1,
	SPECTRE_VULNERABLE = 2,
};

enum mm_cid_state {
	MM_CID_UNSET = 4294967295,
	MM_CID_LAZY_PUT = 2147483648,
};

enum mmc_busy_cmd {
	MMC_BUSY_CMD6 = 0,
	MMC_BUSY_ERASE = 1,
	MMC_BUSY_HPI = 2,
	MMC_BUSY_EXTR_SINGLE = 3,
	MMC_BUSY_IO = 4,
};

enum mmc_drv_op {
	MMC_DRV_OP_IOCTL = 0,
	MMC_DRV_OP_IOCTL_RPMB = 1,
	MMC_DRV_OP_BOOT_WP = 2,
	MMC_DRV_OP_GET_CARD_STATUS = 3,
	MMC_DRV_OP_GET_EXT_CSD = 4,
};

enum mmc_err_stat {
	MMC_ERR_CMD_TIMEOUT = 0,
	MMC_ERR_CMD_CRC = 1,
	MMC_ERR_DAT_TIMEOUT = 2,
	MMC_ERR_DAT_CRC = 3,
	MMC_ERR_AUTO_CMD = 4,
	MMC_ERR_ADMA = 5,
	MMC_ERR_TUNING = 6,
	MMC_ERR_CMDQ_RED = 7,
	MMC_ERR_CMDQ_GCE = 8,
	MMC_ERR_CMDQ_ICCE = 9,
	MMC_ERR_REQ_TIMEOUT = 10,
	MMC_ERR_CMDQ_REQ_TIMEOUT = 11,
	MMC_ERR_ICE_CFG = 12,
	MMC_ERR_CTRL_TIMEOUT = 13,
	MMC_ERR_UNEXPECTED_IRQ = 14,
	MMC_ERR_MAX = 15,
};

enum mmc_issue_type {
	MMC_ISSUE_SYNC = 0,
	MMC_ISSUE_DCMD = 1,
	MMC_ISSUE_ASYNC = 2,
	MMC_ISSUE_MAX = 3,
};

enum mmc_issued {
	MMC_REQ_STARTED = 0,
	MMC_REQ_BUSY = 1,
	MMC_REQ_FAILED_TO_START = 2,
	MMC_REQ_FINISHED = 3,
};

enum mmc_poweroff_type {
	MMC_POWEROFF_SUSPEND = 0,
	MMC_POWEROFF_SHUTDOWN = 1,
	MMC_POWEROFF_UNDERVOLTAGE = 2,
	MMC_POWEROFF_UNBIND = 3,
};

enum mmci_busy_state {
	MMCI_BUSY_WAITING_FOR_START_IRQ = 0,
	MMCI_BUSY_WAITING_FOR_END_IRQ = 1,
	MMCI_BUSY_DONE = 2,
};

enum mminit_level {
	MMINIT_WARNING = 0,
	MMINIT_VERIFY = 1,
	MMINIT_TRACE = 2,
};

enum mmu_notifier_event {
	MMU_NOTIFY_UNMAP = 0,
	MMU_NOTIFY_CLEAR = 1,
	MMU_NOTIFY_PROTECTION_VMA = 2,
	MMU_NOTIFY_PROTECTION_PAGE = 3,
	MMU_NOTIFY_SOFT_DIRTY = 4,
	MMU_NOTIFY_RELEASE = 5,
	MMU_NOTIFY_MIGRATE = 6,
	MMU_NOTIFY_EXCLUSIVE = 7,
};

enum mnt_tree_flags_t {
	MNT_TREE_BENEATH = 1,
	MNT_TREE_PROPAGATION = 2,
};

enum mod_license {
	NOT_GPL_ONLY = 0,
	GPL_ONLY = 1,
};

enum mod_mem_type {
	MOD_TEXT = 0,
	MOD_DATA = 1,
	MOD_RODATA = 2,
	MOD_RO_AFTER_INIT = 3,
	MOD_INIT_TEXT = 4,
	MOD_INIT_DATA = 5,
	MOD_INIT_RODATA = 6,
	MOD_MEM_NUM_TYPES = 7,
	MOD_INVALID = -1,
};

enum module_state {
	MODULE_STATE_LIVE = 0,
	MODULE_STATE_COMING = 1,
	MODULE_STATE_GOING = 2,
	MODULE_STATE_UNFORMED = 3,
};

enum motionsense_command {
	MOTIONSENSE_CMD_DUMP = 0,
	MOTIONSENSE_CMD_INFO = 1,
	MOTIONSENSE_CMD_EC_RATE = 2,
	MOTIONSENSE_CMD_SENSOR_ODR = 3,
	MOTIONSENSE_CMD_SENSOR_RANGE = 4,
	MOTIONSENSE_CMD_KB_WAKE_ANGLE = 5,
	MOTIONSENSE_CMD_DATA = 6,
	MOTIONSENSE_CMD_FIFO_INFO = 7,
	MOTIONSENSE_CMD_FIFO_FLUSH = 8,
	MOTIONSENSE_CMD_FIFO_READ = 9,
	MOTIONSENSE_CMD_PERFORM_CALIB = 10,
	MOTIONSENSE_CMD_SENSOR_OFFSET = 11,
	MOTIONSENSE_CMD_LIST_ACTIVITIES = 12,
	MOTIONSENSE_CMD_SET_ACTIVITY = 13,
	MOTIONSENSE_CMD_LID_ANGLE = 14,
	MOTIONSENSE_CMD_FIFO_INT_ENABLE = 15,
	MOTIONSENSE_CMD_SPOOF = 16,
	MOTIONSENSE_CMD_TABLET_MODE_LID_ANGLE = 17,
	MOTIONSENSE_CMD_SENSOR_SCALE = 18,
	MOTIONSENSE_CMD_GET_ACTIVITY = 20,
	MOTIONSENSE_NUM_CMDS = 21,
};

enum motionsensor_type {
	MOTIONSENSE_TYPE_ACCEL = 0,
	MOTIONSENSE_TYPE_GYRO = 1,
	MOTIONSENSE_TYPE_MAG = 2,
	MOTIONSENSE_TYPE_PROX = 3,
	MOTIONSENSE_TYPE_LIGHT = 4,
	MOTIONSENSE_TYPE_ACTIVITY = 5,
	MOTIONSENSE_TYPE_BARO = 6,
	MOTIONSENSE_TYPE_SYNC = 7,
	MOTIONSENSE_TYPE_MAX = 8,
};

enum mount_flags {
	MNT_NOSUID = 1,
	MNT_NODEV = 2,
	MNT_NOEXEC = 4,
	MNT_NOATIME = 8,
	MNT_NODIRATIME = 16,
	MNT_RELATIME = 32,
	MNT_READONLY = 64,
	MNT_NOSYMFOLLOW = 128,
	MNT_SHRINKABLE = 256,
	MNT_INTERNAL = 16384,
	MNT_LOCK_ATIME = 262144,
	MNT_LOCK_NOEXEC = 524288,
	MNT_LOCK_NOSUID = 1048576,
	MNT_LOCK_NODEV = 2097152,
	MNT_LOCK_READONLY = 4194304,
	MNT_LOCKED = 8388608,
	MNT_DOOMED = 16777216,
	MNT_SYNC_UMOUNT = 33554432,
	MNT_UMOUNT = 134217728,
	MNT_USER_SETTABLE_MASK = 255,
	MNT_ATIME_MASK = 56,
	MNT_INTERNAL_FLAGS = 58736640,
};

enum mount_kattr_flags_t {
	MOUNT_KATTR_RECURSE = 1,
	MOUNT_KATTR_IDMAP_REPLACE = 2,
};

enum mousedev_emul {
	MOUSEDEV_EMUL_PS2 = 0,
	MOUSEDEV_EMUL_IMPS = 1,
	MOUSEDEV_EMUL_EXPS = 2,
};

enum mq_rq_state {
	MQ_RQ_IDLE = 0,
	MQ_RQ_IN_FLIGHT = 1,
	MQ_RQ_COMPLETE = 2,
};

enum mremap_type {
	MREMAP_INVALID = 0,
	MREMAP_NO_RESIZE = 1,
	MREMAP_SHRINK = 2,
	MREMAP_EXPAND = 3,
};

enum mrq_bwmgr_int_cmd {
	CMD_BWMGR_INT_QUERY_ABI = 1,
	CMD_BWMGR_INT_CALC_AND_SET = 2,
	CMD_BWMGR_INT_CAP_SET = 3,
};

enum mrq_debug_commands {
	CMD_DEBUG_OPEN_RO = 0,
	CMD_DEBUG_OPEN_WO = 1,
	CMD_DEBUG_READ = 2,
	CMD_DEBUG_WRITE = 3,
	CMD_DEBUG_CLOSE = 4,
	CMD_DEBUG_MAX = 5,
};

enum mrq_debugfs_commands {
	CMD_DEBUGFS_READ = 1,
	CMD_DEBUGFS_WRITE = 2,
	CMD_DEBUGFS_DUMPDIR = 3,
	CMD_DEBUGFS_MAX = 4,
};

enum mrq_pg_cmd {
	CMD_PG_QUERY_ABI = 0,
	CMD_PG_SET_STATE = 1,
	CMD_PG_GET_STATE = 2,
	CMD_PG_GET_NAME = 3,
	CMD_PG_GET_MAX_ID = 4,
};

enum mrq_reset_commands {
	CMD_RESET_ASSERT = 1,
	CMD_RESET_DEASSERT = 2,
	CMD_RESET_MODULE = 3,
	CMD_RESET_GET_MAX_ID = 4,
	CMD_RESET_MAX = 5,
};

enum msdos_sys_ind {
	DOS_EXTENDED_PARTITION = 5,
	LINUX_EXTENDED_PARTITION = 133,
	WIN98_EXTENDED_PARTITION = 15,
	LINUX_DATA_PARTITION = 131,
	LINUX_LVM_PARTITION = 142,
	LINUX_RAID_PARTITION = 253,
	SOLARIS_X86_PARTITION = 130,
	NEW_SOLARIS_X86_PARTITION = 191,
	DM6_AUX1PARTITION = 81,
	DM6_AUX3PARTITION = 83,
	DM6_PARTITION = 84,
	EZD_PARTITION = 85,
	FREEBSD_PARTITION = 165,
	OPENBSD_PARTITION = 166,
	NETBSD_PARTITION = 169,
	BSDI_PARTITION = 183,
	MINIX_PARTITION = 129,
	UNIXWARE_PARTITION = 99,
};

enum msg_end_type {
	MSG_END_STOP = 0,
	MSG_END_REPEAT_START = 1,
	MSG_END_CONTINUE = 2,
};

enum msi_desc_filter {
	MSI_DESC_ALL = 0,
	MSI_DESC_NOTASSOCIATED = 1,
	MSI_DESC_ASSOCIATED = 2,
};

enum msi_domain_ids {
	MSI_DEFAULT_DOMAIN = 0,
	MSI_MAX_DEVICE_IRQDOMAINS = 1,
};

enum mt6397_irq_numbers {
	MT6397_IRQ_SPKL_AB = 0,
	MT6397_IRQ_SPKR_AB = 1,
	MT6397_IRQ_SPKL = 2,
	MT6397_IRQ_SPKR = 3,
	MT6397_IRQ_BAT_L = 4,
	MT6397_IRQ_BAT_H = 5,
	MT6397_IRQ_FG_BAT_L = 6,
	MT6397_IRQ_FG_BAT_H = 7,
	MT6397_IRQ_WATCHDOG = 8,
	MT6397_IRQ_PWRKEY = 9,
	MT6397_IRQ_THR_L = 10,
	MT6397_IRQ_THR_H = 11,
	MT6397_IRQ_VBATON_UNDET = 12,
	MT6397_IRQ_BVALID_DET = 13,
	MT6397_IRQ_CHRDET = 14,
	MT6397_IRQ_OV = 15,
	MT6397_IRQ_LDO = 16,
	MT6397_IRQ_HOMEKEY = 17,
	MT6397_IRQ_ACCDET = 18,
	MT6397_IRQ_AUDIO = 19,
	MT6397_IRQ_RTC = 20,
	MT6397_IRQ_PWRKEY_RSTB = 21,
	MT6397_IRQ_HDMI_SIFM = 22,
	MT6397_IRQ_HDMI_CEC = 23,
	MT6397_IRQ_VCA15 = 24,
	MT6397_IRQ_VSRMCA15 = 25,
	MT6397_IRQ_VCORE = 26,
	MT6397_IRQ_VGPU = 27,
	MT6397_IRQ_VIO18 = 28,
	MT6397_IRQ_VPCA7 = 29,
	MT6397_IRQ_VSRMCA7 = 30,
	MT6397_IRQ_VDRM = 31,
	MT6397_IRQ_NR = 32,
};

enum mtd_file_modes {
	MTD_FILE_MODE_NORMAL = 0,
	MTD_FILE_MODE_OTP_FACTORY = 1,
	MTD_FILE_MODE_OTP_USER = 2,
	MTD_FILE_MODE_RAW = 3,
};

enum mthp_stat_item {
	MTHP_STAT_ANON_FAULT_ALLOC = 0,
	MTHP_STAT_ANON_FAULT_FALLBACK = 1,
	MTHP_STAT_ANON_FAULT_FALLBACK_CHARGE = 2,
	MTHP_STAT_ZSWPOUT = 3,
	MTHP_STAT_SWPIN = 4,
	MTHP_STAT_SWPIN_FALLBACK = 5,
	MTHP_STAT_SWPIN_FALLBACK_CHARGE = 6,
	MTHP_STAT_SWPOUT = 7,
	MTHP_STAT_SWPOUT_FALLBACK = 8,
	MTHP_STAT_SHMEM_ALLOC = 9,
	MTHP_STAT_SHMEM_FALLBACK = 10,
	MTHP_STAT_SHMEM_FALLBACK_CHARGE = 11,
	MTHP_STAT_SPLIT = 12,
	MTHP_STAT_SPLIT_FAILED = 13,
	MTHP_STAT_SPLIT_DEFERRED = 14,
	MTHP_STAT_NR_ANON = 15,
	MTHP_STAT_NR_ANON_PARTIALLY_MAPPED = 16,
	__MTHP_STAT_COUNT = 17,
};

enum mtk_cirq_regoffs_index {
	CIRQ_STA = 0,
	CIRQ_ACK = 1,
	CIRQ_MASK_SET = 2,
	CIRQ_MASK_CLR = 3,
	CIRQ_SENS_SET = 4,
	CIRQ_SENS_CLR = 5,
	CIRQ_POL_SET = 6,
	CIRQ_POL_CLR = 7,
	CIRQ_CONTROL = 8,
};

enum mtk_iommu_plat {
	M4U_MT2712 = 0,
	M4U_MT6779 = 1,
	M4U_MT6795 = 2,
	M4U_MT8167 = 3,
	M4U_MT8173 = 4,
	M4U_MT8183 = 5,
	M4U_MT8186 = 6,
	M4U_MT8188 = 7,
	M4U_MT8192 = 8,
	M4U_MT8195 = 9,
	M4U_MT8365 = 10,
};

enum mtk_phy_version {
	MTK_PHY_V1 = 1,
	MTK_PHY_V2 = 2,
	MTK_PHY_V3 = 3,
};

enum mtk_reset_version {
	MTK_RST_SIMPLE = 0,
	MTK_RST_SET_CLR = 1,
	MTK_RST_MAX = 2,
};

enum mtk_smi_type {
	MTK_SMI_GEN1 = 0,
	MTK_SMI_GEN2 = 1,
	MTK_SMI_GEN2_SUB_COMM = 2,
};

enum mtk_trans_op {
	I2C_MASTER_WR = 1,
	I2C_MASTER_RD = 2,
	I2C_MASTER_WRRD = 3,
};

enum mtu3_dr_force_mode {
	MTU3_DR_FORCE_NONE = 0,
	MTU3_DR_FORCE_HOST = 1,
	MTU3_DR_FORCE_DEVICE = 2,
};

enum mtu3_g_ep0_state {
	MU3D_EP0_STATE_SETUP = 1,
	MU3D_EP0_STATE_TX = 2,
	MU3D_EP0_STATE_RX = 3,
	MU3D_EP0_STATE_TX_END = 4,
	MU3D_EP0_STATE_STALL = 5,
};

enum multi_stop_state {
	MULTI_STOP_NONE = 0,
	MULTI_STOP_PREPARE = 1,
	MULTI_STOP_DISABLE_IRQ = 2,
	MULTI_STOP_RUN = 3,
	MULTI_STOP_EXIT = 4,
};

enum musb_buf_mode {
	BUF_SINGLE = 0,
	BUF_DOUBLE = 1,
} __attribute__((mode(byte)));

enum musb_fifo_style {
	FIFO_RXTX = 0,
	FIFO_TX = 1,
	FIFO_RX = 2,
} __attribute__((mode(byte)));

enum musb_g_ep0_state {
	MUSB_EP0_STAGE_IDLE = 0,
	MUSB_EP0_STAGE_SETUP = 1,
	MUSB_EP0_STAGE_TX = 2,
	MUSB_EP0_STAGE_RX = 3,
	MUSB_EP0_STAGE_STATUSIN = 4,
	MUSB_EP0_STAGE_STATUSOUT = 5,
	MUSB_EP0_STAGE_ACKWAIT = 6,
} __attribute__((mode(byte)));

enum musb_h_ep0_state {
	MUSB_EP0_IDLE = 0,
	MUSB_EP0_START = 1,
	MUSB_EP0_IN = 2,
	MUSB_EP0_OUT = 3,
	MUSB_EP0_STATUS = 4,
} __attribute__((mode(byte)));

enum musb_mode {
	MUSB_UNDEFINED = 0,
	MUSB_HOST = 1,
	MUSB_PERIPHERAL = 2,
	MUSB_OTG = 3,
};

enum musb_vbus_id_status {
	MUSB_UNKNOWN = 0,
	MUSB_ID_GROUND = 1,
	MUSB_ID_FLOAT = 2,
	MUSB_VBUS_VALID = 3,
	MUSB_VBUS_OFF = 4,
};

enum mv_xor_mode {
	XOR_MODE_IN_REG = 0,
	XOR_MODE_IN_DESC = 1,
};

enum mv_xor_type {
	XOR_ORION = 0,
	XOR_ARMADA_38X = 1,
	XOR_ARMADA_37XX = 2,
};

enum mvneta_bm_type {
	MVNETA_BM_FREE = 0,
	MVNETA_BM_LONG = 1,
	MVNETA_BM_SHORT = 2,
};

enum mvneta_tx_buf_type {
	MVNETA_TYPE_TSO = 0,
	MVNETA_TYPE_SKB = 1,
	MVNETA_TYPE_XDP_TX = 2,
	MVNETA_TYPE_XDP_NDO = 3,
};

enum mvpp22_cls_c2_action {
	MVPP22_C2_NO_UPD = 0,
	MVPP22_C2_NO_UPD_LOCK = 1,
	MVPP22_C2_UPD = 2,
	MVPP22_C2_UPD_LOCK = 3,
};

enum mvpp22_cls_c2_color_action {
	MVPP22_C2_COL_NO_UPD = 0,
	MVPP22_C2_COL_NO_UPD_LOCK = 1,
	MVPP22_C2_COL_GREEN = 2,
	MVPP22_C2_COL_GREEN_LOCK = 3,
	MVPP22_C2_COL_YELLOW = 4,
	MVPP22_C2_COL_YELLOW_LOCK = 5,
	MVPP22_C2_COL_RED = 6,
	MVPP22_C2_COL_RED_LOCK = 7,
};

enum mvpp22_cls_c2_fwd_action {
	MVPP22_C2_FWD_NO_UPD = 0,
	MVPP22_C2_FWD_NO_UPD_LOCK = 1,
	MVPP22_C2_FWD_SW = 2,
	MVPP22_C2_FWD_SW_LOCK = 3,
	MVPP22_C2_FWD_HW = 4,
	MVPP22_C2_FWD_HW_LOCK = 5,
	MVPP22_C2_FWD_HW_LOW_LAT = 6,
	MVPP22_C2_FWD_HW_LOW_LAT_LOCK = 7,
};

enum mvpp22_ptp_action {
	MVPP22_PTP_ACTION_NONE = 0,
	MVPP22_PTP_ACTION_FORWARD = 1,
	MVPP22_PTP_ACTION_CAPTURE = 3,
	MVPP22_PTP_ACTION_ADDTIME = 4,
	MVPP22_PTP_ACTION_ADDCORRECTEDTIME = 5,
	MVPP22_PTP_ACTION_CAPTUREADDTIME = 6,
	MVPP22_PTP_ACTION_CAPTUREADDCORRECTEDTIME = 7,
	MVPP22_PTP_ACTION_ADDINGRESSTIME = 8,
	MVPP22_PTP_ACTION_CAPTUREADDINGRESSTIME = 9,
	MVPP22_PTP_ACTION_CAPTUREINGRESSTIME = 10,
};

enum mvpp22_ptp_packet_format {
	MVPP22_PTP_PKT_FMT_PTPV2 = 0,
	MVPP22_PTP_PKT_FMT_PTPV1 = 1,
	MVPP22_PTP_PKT_FMT_Y1731 = 2,
	MVPP22_PTP_PKT_FMT_NTPTS = 3,
	MVPP22_PTP_PKT_FMT_NTPRX = 4,
	MVPP22_PTP_PKT_FMT_NTPTX = 5,
	MVPP22_PTP_PKT_FMT_TWAMP = 6,
};

enum mvpp2_bm_pool_log_num {
	MVPP2_BM_SHORT = 0,
	MVPP2_BM_LONG = 1,
	MVPP2_BM_JUMBO = 2,
	MVPP2_BM_POOLS_NUM = 3,
};

enum mvpp2_cls_engine {
	MVPP22_CLS_ENGINE_C2 = 1,
	MVPP22_CLS_ENGINE_C3A = 2,
	MVPP22_CLS_ENGINE_C3B = 3,
	MVPP22_CLS_ENGINE_C4 = 4,
	MVPP22_CLS_ENGINE_C3HA = 6,
	MVPP22_CLS_ENGINE_C3HB = 7,
};

enum mvpp2_cls_field_id {
	MVPP22_CLS_FIELD_MAC_DA = 3,
	MVPP22_CLS_FIELD_VLAN_PRI = 5,
	MVPP22_CLS_FIELD_VLAN = 6,
	MVPP22_CLS_FIELD_L3_PROTO = 15,
	MVPP22_CLS_FIELD_IP4SA = 16,
	MVPP22_CLS_FIELD_IP4DA = 17,
	MVPP22_CLS_FIELD_IP6SA = 23,
	MVPP22_CLS_FIELD_IP6DA = 26,
	MVPP22_CLS_FIELD_L4SIP = 29,
	MVPP22_CLS_FIELD_L4DIP = 30,
};

enum mvpp2_cls_lu_type {
	MVPP22_CLS_LU_TYPE_ALL = 63,
};

enum mvpp2_prs_flow {
	MVPP2_FL_START = 8,
	MVPP2_FL_IP4_TCP_NF_UNTAG = 8,
	MVPP2_FL_IP4_UDP_NF_UNTAG = 9,
	MVPP2_FL_IP4_TCP_NF_TAG = 10,
	MVPP2_FL_IP4_UDP_NF_TAG = 11,
	MVPP2_FL_IP6_TCP_NF_UNTAG = 12,
	MVPP2_FL_IP6_UDP_NF_UNTAG = 13,
	MVPP2_FL_IP6_TCP_NF_TAG = 14,
	MVPP2_FL_IP6_UDP_NF_TAG = 15,
	MVPP2_FL_IP4_TCP_FRAG_UNTAG = 16,
	MVPP2_FL_IP4_UDP_FRAG_UNTAG = 17,
	MVPP2_FL_IP4_TCP_FRAG_TAG = 18,
	MVPP2_FL_IP4_UDP_FRAG_TAG = 19,
	MVPP2_FL_IP6_TCP_FRAG_UNTAG = 20,
	MVPP2_FL_IP6_UDP_FRAG_UNTAG = 21,
	MVPP2_FL_IP6_TCP_FRAG_TAG = 22,
	MVPP2_FL_IP6_UDP_FRAG_TAG = 23,
	MVPP2_FL_IP4_UNTAG = 24,
	MVPP2_FL_IP4_TAG = 25,
	MVPP2_FL_IP6_UNTAG = 26,
	MVPP2_FL_IP6_TAG = 27,
	MVPP2_FL_NON_IP_UNTAG = 28,
	MVPP2_FL_NON_IP_TAG = 29,
	MVPP2_FL_LAST = 30,
};

enum mvpp2_prs_l2_cast {
	MVPP2_PRS_L2_UNI_CAST = 0,
	MVPP2_PRS_L2_MULTI_CAST = 1,
};

enum mvpp2_prs_l3_cast {
	MVPP2_PRS_L3_UNI_CAST = 0,
	MVPP2_PRS_L3_MULTI_CAST = 1,
	MVPP2_PRS_L3_BROAD_CAST = 2,
};

enum mvpp2_prs_lookup {
	MVPP2_PRS_LU_MH = 0,
	MVPP2_PRS_LU_MAC = 1,
	MVPP2_PRS_LU_DSA = 2,
	MVPP2_PRS_LU_VLAN = 3,
	MVPP2_PRS_LU_VID = 4,
	MVPP2_PRS_LU_L2 = 5,
	MVPP2_PRS_LU_PPPOE = 6,
	MVPP2_PRS_LU_IP4 = 7,
	MVPP2_PRS_LU_IP6 = 8,
	MVPP2_PRS_LU_FLOWS = 9,
	MVPP2_PRS_LU_LAST = 10,
};

enum mvpp2_prs_udf {
	MVPP2_PRS_UDF_MAC_DEF = 0,
	MVPP2_PRS_UDF_MAC_RANGE = 1,
	MVPP2_PRS_UDF_L2_DEF = 2,
	MVPP2_PRS_UDF_L2_DEF_COPY = 3,
	MVPP2_PRS_UDF_L2_USER = 4,
};

enum mvpp2_tag_type {
	MVPP2_TAG_TYPE_NONE = 0,
	MVPP2_TAG_TYPE_MH = 1,
	MVPP2_TAG_TYPE_DSA = 2,
	MVPP2_TAG_TYPE_EDSA = 3,
	MVPP2_TAG_TYPE_VLAN = 4,
	MVPP2_TAG_TYPE_LAST = 5,
};

enum mvpp2_tx_buf_type {
	MVPP2_TYPE_SKB = 0,
	MVPP2_TYPE_XDP_TX = 1,
	MVPP2_TYPE_XDP_NDO = 2,
};

enum nand_bbt_block_status {
	NAND_BBT_BLOCK_STATUS_UNKNOWN = 0,
	NAND_BBT_BLOCK_GOOD = 1,
	NAND_BBT_BLOCK_WORN = 2,
	NAND_BBT_BLOCK_RESERVED = 3,
	NAND_BBT_BLOCK_FACTORY_BAD = 4,
	NAND_BBT_BLOCK_NUM_STATUS = 5,
};

enum nand_ecc_algo {
	NAND_ECC_ALGO_UNKNOWN = 0,
	NAND_ECC_ALGO_HAMMING = 1,
	NAND_ECC_ALGO_BCH = 2,
	NAND_ECC_ALGO_RS = 3,
};

enum nand_ecc_engine_integration {
	NAND_ECC_ENGINE_INTEGRATION_INVALID = 0,
	NAND_ECC_ENGINE_INTEGRATION_PIPELINED = 1,
	NAND_ECC_ENGINE_INTEGRATION_EXTERNAL = 2,
};

enum nand_ecc_engine_type {
	NAND_ECC_ENGINE_TYPE_INVALID = 0,
	NAND_ECC_ENGINE_TYPE_NONE = 1,
	NAND_ECC_ENGINE_TYPE_SOFT = 2,
	NAND_ECC_ENGINE_TYPE_ON_HOST = 3,
	NAND_ECC_ENGINE_TYPE_ON_DIE = 4,
};

enum nand_ecc_legacy_mode {
	NAND_ECC_INVALID = 0,
	NAND_ECC_NONE = 1,
	NAND_ECC_SOFT = 2,
	NAND_ECC_SOFT_BCH = 3,
	NAND_ECC_HW = 4,
	NAND_ECC_HW_SYNDROME = 5,
	NAND_ECC_ON_DIE = 6,
};

enum nand_ecc_placement {
	NAND_ECC_PLACEMENT_UNKNOWN = 0,
	NAND_ECC_PLACEMENT_OOB = 1,
	NAND_ECC_PLACEMENT_INTERLEAVED = 2,
};

enum nand_interface_type {
	NAND_SDR_IFACE = 0,
	NAND_NVDDR_IFACE = 1,
};

enum nand_op_instr_type {
	NAND_OP_CMD_INSTR = 0,
	NAND_OP_ADDR_INSTR = 1,
	NAND_OP_DATA_IN_INSTR = 2,
	NAND_OP_DATA_OUT_INSTR = 3,
	NAND_OP_WAITRDY_INSTR = 4,
};

enum nand_page_io_req_type {
	NAND_PAGE_READ = 0,
	NAND_PAGE_WRITE = 1,
};

enum nbcon_prio {
	NBCON_PRIO_NONE = 0,
	NBCON_PRIO_NORMAL = 1,
	NBCON_PRIO_EMERGENCY = 2,
	NBCON_PRIO_PANIC = 3,
	NBCON_PRIO_MAX = 4,
};

enum net_device_flags {
	IFF_UP = 1,
	IFF_BROADCAST = 2,
	IFF_DEBUG = 4,
	IFF_LOOPBACK = 8,
	IFF_POINTOPOINT = 16,
	IFF_NOTRAILERS = 32,
	IFF_RUNNING = 64,
	IFF_NOARP = 128,
	IFF_PROMISC = 256,
	IFF_ALLMULTI = 512,
	IFF_MASTER = 1024,
	IFF_SLAVE = 2048,
	IFF_MULTICAST = 4096,
	IFF_PORTSEL = 8192,
	IFF_AUTOMEDIA = 16384,
	IFF_DYNAMIC = 32768,
	IFF_LOWER_UP = 65536,
	IFF_DORMANT = 131072,
	IFF_ECHO = 262144,
};

enum net_device_path_type {
	DEV_PATH_ETHERNET = 0,
	DEV_PATH_VLAN = 1,
	DEV_PATH_BRIDGE = 2,
	DEV_PATH_PPPOE = 3,
	DEV_PATH_DSA = 4,
	DEV_PATH_MTK_WDMA = 5,
};

enum net_iov_type {
	NET_IOV_DMABUF = 0ULL,
	NET_IOV_IOURING = 1ULL,
	NET_IOV_MAX = 18446744073709551615ULL,
};

enum net_prot {
	NET_PROT_NONE = 0,
	NET_PROT_PAYLOAD = 1,
	NET_PROT_ETH = 2,
	NET_PROT_VLAN = 3,
	NET_PROT_IPV4 = 4,
	NET_PROT_IPV6 = 5,
	NET_PROT_IP = 6,
	NET_PROT_TCP = 7,
	NET_PROT_UDP = 8,
	NET_PROT_UDP_LITE = 9,
	NET_PROT_IPHC = 10,
	NET_PROT_SCTP = 11,
	NET_PROT_SCTP_CHUNK_DATA = 12,
	NET_PROT_PPPOE = 13,
	NET_PROT_PPP = 14,
	NET_PROT_PPPMUX = 15,
	NET_PROT_PPPMUX_SUBFRM = 16,
	NET_PROT_L2TPV2 = 17,
	NET_PROT_L2TPV3_CTRL = 18,
	NET_PROT_L2TPV3_SESS = 19,
	NET_PROT_LLC = 20,
	NET_PROT_LLC_SNAP = 21,
	NET_PROT_NLPID = 22,
	NET_PROT_SNAP = 23,
	NET_PROT_MPLS = 24,
	NET_PROT_IPSEC_AH = 25,
	NET_PROT_IPSEC_ESP = 26,
	NET_PROT_UDP_ENC_ESP = 27,
	NET_PROT_MACSEC = 28,
	NET_PROT_GRE = 29,
	NET_PROT_MINENCAP = 30,
	NET_PROT_DCCP = 31,
	NET_PROT_ICMP = 32,
	NET_PROT_IGMP = 33,
	NET_PROT_ARP = 34,
	NET_PROT_CAPWAP_DATA = 35,
	NET_PROT_CAPWAP_CTRL = 36,
	NET_PROT_RFC2684 = 37,
	NET_PROT_ICMPV6 = 38,
	NET_PROT_FCOE = 39,
	NET_PROT_FIP = 40,
	NET_PROT_ISCSI = 41,
	NET_PROT_GTP = 42,
	NET_PROT_USER_DEFINED_L2 = 43,
	NET_PROT_USER_DEFINED_L3 = 44,
	NET_PROT_USER_DEFINED_L4 = 45,
	NET_PROT_USER_DEFINED_L5 = 46,
	NET_PROT_USER_DEFINED_SHIM1 = 47,
	NET_PROT_USER_DEFINED_SHIM2 = 48,
	NET_PROT_DUMMY_LAST = 49,
};

enum net_xmit_qdisc_t {
	__NET_XMIT_STOLEN = 65536,
	__NET_XMIT_BYPASS = 131072,
};

enum netdev_cmd {
	NETDEV_UP = 1,
	NETDEV_DOWN = 2,
	NETDEV_REBOOT = 3,
	NETDEV_CHANGE = 4,
	NETDEV_REGISTER = 5,
	NETDEV_UNREGISTER = 6,
	NETDEV_CHANGEMTU = 7,
	NETDEV_CHANGEADDR = 8,
	NETDEV_PRE_CHANGEADDR = 9,
	NETDEV_GOING_DOWN = 10,
	NETDEV_CHANGENAME = 11,
	NETDEV_FEAT_CHANGE = 12,
	NETDEV_BONDING_FAILOVER = 13,
	NETDEV_PRE_UP = 14,
	NETDEV_PRE_TYPE_CHANGE = 15,
	NETDEV_POST_TYPE_CHANGE = 16,
	NETDEV_POST_INIT = 17,
	NETDEV_PRE_UNINIT = 18,
	NETDEV_RELEASE = 19,
	NETDEV_NOTIFY_PEERS = 20,
	NETDEV_JOIN = 21,
	NETDEV_CHANGEUPPER = 22,
	NETDEV_RESEND_IGMP = 23,
	NETDEV_PRECHANGEMTU = 24,
	NETDEV_CHANGEINFODATA = 25,
	NETDEV_BONDING_INFO = 26,
	NETDEV_PRECHANGEUPPER = 27,
	NETDEV_CHANGELOWERSTATE = 28,
	NETDEV_UDP_TUNNEL_PUSH_INFO = 29,
	NETDEV_UDP_TUNNEL_DROP_INFO = 30,
	NETDEV_CHANGE_TX_QUEUE_LEN = 31,
	NETDEV_CVLAN_FILTER_PUSH_INFO = 32,
	NETDEV_CVLAN_FILTER_DROP_INFO = 33,
	NETDEV_SVLAN_FILTER_PUSH_INFO = 34,
	NETDEV_SVLAN_FILTER_DROP_INFO = 35,
	NETDEV_OFFLOAD_XSTATS_ENABLE = 36,
	NETDEV_OFFLOAD_XSTATS_DISABLE = 37,
	NETDEV_OFFLOAD_XSTATS_REPORT_USED = 38,
	NETDEV_OFFLOAD_XSTATS_REPORT_DELTA = 39,
	NETDEV_XDP_FEAT_CHANGE = 40,
};

enum netdev_lag_hash {
	NETDEV_LAG_HASH_NONE = 0,
	NETDEV_LAG_HASH_L2 = 1,
	NETDEV_LAG_HASH_L34 = 2,
	NETDEV_LAG_HASH_L23 = 3,
	NETDEV_LAG_HASH_E23 = 4,
	NETDEV_LAG_HASH_E34 = 5,
	NETDEV_LAG_HASH_VLAN_SRCMAC = 6,
	NETDEV_LAG_HASH_UNKNOWN = 7,
};

enum netdev_lag_tx_type {
	NETDEV_LAG_TX_TYPE_UNKNOWN = 0,
	NETDEV_LAG_TX_TYPE_RANDOM = 1,
	NETDEV_LAG_TX_TYPE_BROADCAST = 2,
	NETDEV_LAG_TX_TYPE_ROUNDROBIN = 3,
	NETDEV_LAG_TX_TYPE_ACTIVEBACKUP = 4,
	NETDEV_LAG_TX_TYPE_HASH = 5,
};

enum netdev_ml_priv_type {
	ML_PRIV_NONE = 0,
	ML_PRIV_CAN = 1,
};

enum netdev_napi_threaded {
	NETDEV_NAPI_THREADED_DISABLED = 0,
	NETDEV_NAPI_THREADED_ENABLED = 1,
};

enum netdev_offload_xstats_type {
	NETDEV_OFFLOAD_XSTATS_TYPE_L3 = 1,
};

enum netdev_priv_flags {
	IFF_802_1Q_VLAN = 1,
	IFF_EBRIDGE = 2,
	IFF_BONDING = 4,
	IFF_ISATAP = 8,
	IFF_WAN_HDLC = 16,
	IFF_XMIT_DST_RELEASE = 32,
	IFF_DONT_BRIDGE = 64,
	IFF_DISABLE_NETPOLL = 128,
	IFF_MACVLAN_PORT = 256,
	IFF_BRIDGE_PORT = 512,
	IFF_OVS_DATAPATH = 1024,
	IFF_TX_SKB_SHARING = 2048,
	IFF_UNICAST_FLT = 4096,
	IFF_TEAM_PORT = 8192,
	IFF_SUPP_NOFCS = 16384,
	IFF_LIVE_ADDR_CHANGE = 32768,
	IFF_MACVLAN = 65536,
	IFF_XMIT_DST_RELEASE_PERM = 131072,
	IFF_L3MDEV_MASTER = 262144,
	IFF_NO_QUEUE = 524288,
	IFF_OPENVSWITCH = 1048576,
	IFF_L3MDEV_SLAVE = 2097152,
	IFF_TEAM = 4194304,
	IFF_RXFH_CONFIGURED = 8388608,
	IFF_PHONY_HEADROOM = 16777216,
	IFF_MACSEC = 33554432,
	IFF_NO_RX_HANDLER = 67108864,
	IFF_FAILOVER = 134217728,
	IFF_FAILOVER_SLAVE = 268435456,
	IFF_L3MDEV_RX_HANDLER = 536870912,
	IFF_NO_ADDRCONF = 1073741824,
	IFF_TX_SKB_NO_LINEAR = 2147483648,
};

enum netdev_qstats_scope {
	NETDEV_QSTATS_SCOPE_QUEUE = 1,
};

enum netdev_queue_state_t {
	__QUEUE_STATE_DRV_XOFF = 0,
	__QUEUE_STATE_STACK_XOFF = 1,
	__QUEUE_STATE_FROZEN = 2,
};

enum netdev_queue_type {
	NETDEV_QUEUE_TYPE_RX = 0,
	NETDEV_QUEUE_TYPE_TX = 1,
};

enum netdev_reg_state {
	NETREG_UNINITIALIZED = 0,
	NETREG_REGISTERED = 1,
	NETREG_UNREGISTERING = 2,
	NETREG_UNREGISTERED = 3,
	NETREG_RELEASED = 4,
	NETREG_DUMMY = 5,
};

enum netdev_stat_type {
	NETDEV_PCPU_STAT_NONE = 0,
	NETDEV_PCPU_STAT_LSTATS = 1,
	NETDEV_PCPU_STAT_TSTATS = 2,
	NETDEV_PCPU_STAT_DSTATS = 3,
};

enum netdev_state_t {
	__LINK_STATE_START = 0,
	__LINK_STATE_PRESENT = 1,
	__LINK_STATE_NOCARRIER = 2,
	__LINK_STATE_LINKWATCH_PENDING = 3,
	__LINK_STATE_DORMANT = 4,
	__LINK_STATE_TESTING = 5,
};

enum netdev_tx {
	__NETDEV_TX_MIN = -2147483648,
	NETDEV_TX_OK = 0,
	NETDEV_TX_BUSY = 16,
};

typedef enum netdev_tx netdev_tx_t;

enum netdev_xdp_act {
	NETDEV_XDP_ACT_BASIC = 1,
	NETDEV_XDP_ACT_REDIRECT = 2,
	NETDEV_XDP_ACT_NDO_XMIT = 4,
	NETDEV_XDP_ACT_XSK_ZEROCOPY = 8,
	NETDEV_XDP_ACT_HW_OFFLOAD = 16,
	NETDEV_XDP_ACT_RX_SG = 32,
	NETDEV_XDP_ACT_NDO_XMIT_SG = 64,
	NETDEV_XDP_ACT_MASK = 127,
};

enum netdev_xdp_rx_metadata {
	NETDEV_XDP_RX_METADATA_TIMESTAMP = 1,
	NETDEV_XDP_RX_METADATA_HASH = 2,
	NETDEV_XDP_RX_METADATA_VLAN_TAG = 4,
};

enum netdev_xsk_flags {
	NETDEV_XSK_FLAGS_TX_TIMESTAMP = 1,
	NETDEV_XSK_FLAGS_TX_CHECKSUM = 2,
	NETDEV_XSK_FLAGS_TX_LAUNCH_TIME_FIFO = 4,
};

enum netevent_notif_type {
	NETEVENT_NEIGH_UPDATE = 1,
	NETEVENT_REDIRECT = 2,
	NETEVENT_DELAY_PROBE_TIME_UPDATE = 3,
	NETEVENT_IPV4_MPATH_HASH_UPDATE = 4,
	NETEVENT_IPV6_MPATH_HASH_UPDATE = 5,
	NETEVENT_IPV4_FWD_UPDATE_PRIORITY_UPDATE = 6,
};

enum netfs_failure {
	netfs_fail_check_write_begin = 0,
	netfs_fail_copy_to_cache = 1,
	netfs_fail_dio_read_short = 2,
	netfs_fail_dio_read_zero = 3,
	netfs_fail_read = 4,
	netfs_fail_short_read = 5,
	netfs_fail_prepare_write = 6,
	netfs_fail_write = 7,
} __attribute__((mode(byte)));

enum netfs_folio_trace {
	netfs_folio_is_uptodate = 0,
	netfs_just_prefetch = 1,
	netfs_whole_folio_modify = 2,
	netfs_modify_and_clear = 3,
	netfs_streaming_write = 4,
	netfs_streaming_write_cont = 5,
	netfs_flush_content = 6,
	netfs_streaming_filled_page = 7,
	netfs_streaming_cont_filled_page = 8,
	netfs_folio_trace_abandon = 9,
	netfs_folio_trace_alloc_buffer = 10,
	netfs_folio_trace_cancel_copy = 11,
	netfs_folio_trace_cancel_store = 12,
	netfs_folio_trace_clear = 13,
	netfs_folio_trace_clear_cc = 14,
	netfs_folio_trace_clear_g = 15,
	netfs_folio_trace_clear_s = 16,
	netfs_folio_trace_copy_to_cache = 17,
	netfs_folio_trace_end_copy = 18,
	netfs_folio_trace_filled_gaps = 19,
	netfs_folio_trace_kill = 20,
	netfs_folio_trace_kill_cc = 21,
	netfs_folio_trace_kill_g = 22,
	netfs_folio_trace_kill_s = 23,
	netfs_folio_trace_mkwrite = 24,
	netfs_folio_trace_mkwrite_plus = 25,
	netfs_folio_trace_not_under_wback = 26,
	netfs_folio_trace_not_locked = 27,
	netfs_folio_trace_put = 28,
	netfs_folio_trace_read = 29,
	netfs_folio_trace_read_done = 30,
	netfs_folio_trace_read_gaps = 31,
	netfs_folio_trace_read_unlock = 32,
	netfs_folio_trace_redirtied = 33,
	netfs_folio_trace_store = 34,
	netfs_folio_trace_store_copy = 35,
	netfs_folio_trace_store_plus = 36,
	netfs_folio_trace_wthru = 37,
	netfs_folio_trace_wthru_plus = 38,
} __attribute__((mode(byte)));

enum netfs_folioq_trace {
	netfs_trace_folioq_alloc_buffer = 0,
	netfs_trace_folioq_clear = 1,
	netfs_trace_folioq_delete = 2,
	netfs_trace_folioq_make_space = 3,
	netfs_trace_folioq_rollbuf_init = 4,
	netfs_trace_folioq_read_progress = 5,
} __attribute__((mode(byte)));

enum netfs_io_origin {
	NETFS_READAHEAD = 0,
	NETFS_READPAGE = 1,
	NETFS_READ_GAPS = 2,
	NETFS_READ_SINGLE = 3,
	NETFS_READ_FOR_WRITE = 4,
	NETFS_UNBUFFERED_READ = 5,
	NETFS_DIO_READ = 6,
	NETFS_WRITEBACK = 7,
	NETFS_WRITEBACK_SINGLE = 8,
	NETFS_WRITETHROUGH = 9,
	NETFS_UNBUFFERED_WRITE = 10,
	NETFS_DIO_WRITE = 11,
	NETFS_PGPRIV2_COPY_TO_CACHE = 12,
	nr__netfs_io_origin = 13,
} __attribute__((mode(byte)));

enum netfs_io_source {
	NETFS_SOURCE_UNKNOWN = 0,
	NETFS_FILL_WITH_ZEROES = 1,
	NETFS_DOWNLOAD_FROM_SERVER = 2,
	NETFS_READ_FROM_CACHE = 3,
	NETFS_INVALID_READ = 4,
	NETFS_UPLOAD_TO_SERVER = 5,
	NETFS_WRITE_TO_CACHE = 6,
} __attribute__((mode(byte)));

enum netfs_read_from_hole {
	NETFS_READ_HOLE_IGNORE = 0,
	NETFS_READ_HOLE_FAIL = 1,
};

enum netfs_read_trace {
	netfs_read_trace_dio_read = 0,
	netfs_read_trace_expanded = 1,
	netfs_read_trace_readahead = 2,
	netfs_read_trace_readpage = 3,
	netfs_read_trace_read_gaps = 4,
	netfs_read_trace_read_single = 5,
	netfs_read_trace_prefetch_for_write = 6,
	netfs_read_trace_write_begin = 7,
} __attribute__((mode(byte)));

enum netfs_rreq_ref_trace {
	netfs_rreq_trace_get_for_outstanding = 0,
	netfs_rreq_trace_get_subreq = 1,
	netfs_rreq_trace_put_complete = 2,
	netfs_rreq_trace_put_discard = 3,
	netfs_rreq_trace_put_failed = 4,
	netfs_rreq_trace_put_no_submit = 5,
	netfs_rreq_trace_put_return = 6,
	netfs_rreq_trace_put_subreq = 7,
	netfs_rreq_trace_put_work_ip = 8,
	netfs_rreq_trace_see_work = 9,
	netfs_rreq_trace_see_work_complete = 10,
	netfs_rreq_trace_new = 11,
} __attribute__((mode(byte)));

enum netfs_rreq_trace {
	netfs_rreq_trace_assess = 0,
	netfs_rreq_trace_collect = 1,
	netfs_rreq_trace_complete = 2,
	netfs_rreq_trace_copy = 3,
	netfs_rreq_trace_dirty = 4,
	netfs_rreq_trace_done = 5,
	netfs_rreq_trace_end_copy_to_cache = 6,
	netfs_rreq_trace_free = 7,
	netfs_rreq_trace_ki_complete = 8,
	netfs_rreq_trace_recollect = 9,
	netfs_rreq_trace_redirty = 10,
	netfs_rreq_trace_resubmit = 11,
	netfs_rreq_trace_set_abandon = 12,
	netfs_rreq_trace_set_pause = 13,
	netfs_rreq_trace_unlock = 14,
	netfs_rreq_trace_unlock_pgpriv2 = 15,
	netfs_rreq_trace_unmark = 16,
	netfs_rreq_trace_unpause = 17,
	netfs_rreq_trace_wait_ip = 18,
	netfs_rreq_trace_wait_pause = 19,
	netfs_rreq_trace_wait_quiesce = 20,
	netfs_rreq_trace_waited_ip = 21,
	netfs_rreq_trace_waited_pause = 22,
	netfs_rreq_trace_waited_quiesce = 23,
	netfs_rreq_trace_wake_ip = 24,
	netfs_rreq_trace_wake_queue = 25,
	netfs_rreq_trace_write_done = 26,
} __attribute__((mode(byte)));

enum netfs_sreq_ref_trace {
	netfs_sreq_trace_get_copy_to_cache = 0,
	netfs_sreq_trace_get_resubmit = 1,
	netfs_sreq_trace_get_submit = 2,
	netfs_sreq_trace_get_short_read = 3,
	netfs_sreq_trace_new = 4,
	netfs_sreq_trace_put_abandon = 5,
	netfs_sreq_trace_put_cancel = 6,
	netfs_sreq_trace_put_clear = 7,
	netfs_sreq_trace_put_consumed = 8,
	netfs_sreq_trace_put_done = 9,
	netfs_sreq_trace_put_failed = 10,
	netfs_sreq_trace_put_merged = 11,
	netfs_sreq_trace_put_no_copy = 12,
	netfs_sreq_trace_put_oom = 13,
	netfs_sreq_trace_put_wip = 14,
	netfs_sreq_trace_put_work = 15,
	netfs_sreq_trace_put_terminated = 16,
} __attribute__((mode(byte)));

enum netfs_sreq_trace {
	netfs_sreq_trace_abandoned = 0,
	netfs_sreq_trace_add_donations = 1,
	netfs_sreq_trace_added = 2,
	netfs_sreq_trace_cache_nowrite = 3,
	netfs_sreq_trace_cache_prepare = 4,
	netfs_sreq_trace_cache_write = 5,
	netfs_sreq_trace_cancel = 6,
	netfs_sreq_trace_clear = 7,
	netfs_sreq_trace_consumed = 8,
	netfs_sreq_trace_discard = 9,
	netfs_sreq_trace_donate_to_prev = 10,
	netfs_sreq_trace_donate_to_next = 11,
	netfs_sreq_trace_download_instead = 12,
	netfs_sreq_trace_fail = 13,
	netfs_sreq_trace_free = 14,
	netfs_sreq_trace_hit_eof = 15,
	netfs_sreq_trace_io_bad = 16,
	netfs_sreq_trace_io_malformed = 17,
	netfs_sreq_trace_io_unknown = 18,
	netfs_sreq_trace_io_progress = 19,
	netfs_sreq_trace_io_req_submitted = 20,
	netfs_sreq_trace_io_retry_needed = 21,
	netfs_sreq_trace_limited = 22,
	netfs_sreq_trace_need_clear = 23,
	netfs_sreq_trace_partial_read = 24,
	netfs_sreq_trace_need_retry = 25,
	netfs_sreq_trace_prepare = 26,
	netfs_sreq_trace_prep_failed = 27,
	netfs_sreq_trace_progress = 28,
	netfs_sreq_trace_reprep_failed = 29,
	netfs_sreq_trace_retry = 30,
	netfs_sreq_trace_short = 31,
	netfs_sreq_trace_split = 32,
	netfs_sreq_trace_submit = 33,
	netfs_sreq_trace_superfluous = 34,
	netfs_sreq_trace_terminated = 35,
	netfs_sreq_trace_wait_for = 36,
	netfs_sreq_trace_write = 37,
	netfs_sreq_trace_write_skip = 38,
	netfs_sreq_trace_write_term = 39,
} __attribute__((mode(byte)));

enum netfs_write_trace {
	netfs_write_trace_copy_to_cache = 0,
	netfs_write_trace_dio_write = 1,
	netfs_write_trace_unbuffered_write = 2,
	netfs_write_trace_writeback = 3,
	netfs_write_trace_writeback_single = 4,
	netfs_write_trace_writethrough = 5,
} __attribute__((mode(byte)));

enum netlink_attribute_type {
	NL_ATTR_TYPE_INVALID = 0,
	NL_ATTR_TYPE_FLAG = 1,
	NL_ATTR_TYPE_U8 = 2,
	NL_ATTR_TYPE_U16 = 3,
	NL_ATTR_TYPE_U32 = 4,
	NL_ATTR_TYPE_U64 = 5,
	NL_ATTR_TYPE_S8 = 6,
	NL_ATTR_TYPE_S16 = 7,
	NL_ATTR_TYPE_S32 = 8,
	NL_ATTR_TYPE_S64 = 9,
	NL_ATTR_TYPE_BINARY = 10,
	NL_ATTR_TYPE_STRING = 11,
	NL_ATTR_TYPE_NUL_STRING = 12,
	NL_ATTR_TYPE_NESTED = 13,
	NL_ATTR_TYPE_NESTED_ARRAY = 14,
	NL_ATTR_TYPE_BITFIELD32 = 15,
	NL_ATTR_TYPE_SINT = 16,
	NL_ATTR_TYPE_UINT = 17,
};

enum netlink_policy_type_attr {
	NL_POLICY_TYPE_ATTR_UNSPEC = 0,
	NL_POLICY_TYPE_ATTR_TYPE = 1,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_S = 2,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_S = 3,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_U = 4,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_U = 5,
	NL_POLICY_TYPE_ATTR_MIN_LENGTH = 6,
	NL_POLICY_TYPE_ATTR_MAX_LENGTH = 7,
	NL_POLICY_TYPE_ATTR_POLICY_IDX = 8,
	NL_POLICY_TYPE_ATTR_POLICY_MAXTYPE = 9,
	NL_POLICY_TYPE_ATTR_BITFIELD32_MASK = 10,
	NL_POLICY_TYPE_ATTR_PAD = 11,
	NL_POLICY_TYPE_ATTR_MASK = 12,
	__NL_POLICY_TYPE_ATTR_MAX = 13,
	NL_POLICY_TYPE_ATTR_MAX = 12,
};

enum netlink_skb_flags {
	NETLINK_SKB_DST = 8,
};

enum netlink_validation {
	NL_VALIDATE_LIBERAL = 0,
	NL_VALIDATE_TRAILING = 1,
	NL_VALIDATE_MAXTYPE = 2,
	NL_VALIDATE_UNSPEC = 4,
	NL_VALIDATE_STRICT_ATTRS = 8,
	NL_VALIDATE_NESTED = 16,
};

enum netloc_type4 {
	NL4_NAME = 1,
	NL4_URL = 2,
	NL4_NETADDR = 3,
};

enum netns_bpf_attach_type {
	NETNS_BPF_INVALID = -1,
	NETNS_BPF_FLOW_DISSECTOR = 0,
	NETNS_BPF_SK_LOOKUP = 1,
	MAX_NETNS_BPF_ATTACH_TYPE = 2,
};

enum nexthop_event_type {
	NEXTHOP_EVENT_DEL = 0,
	NEXTHOP_EVENT_REPLACE = 1,
	NEXTHOP_EVENT_RES_TABLE_PRE_REPLACE = 2,
	NEXTHOP_EVENT_BUCKET_REPLACE = 3,
	NEXTHOP_EVENT_HW_STATS_REPORT_DELTA = 4,
};

enum nf_dev_hooks {
	NF_NETDEV_INGRESS = 0,
	NF_NETDEV_EGRESS = 1,
	NF_NETDEV_NUMHOOKS = 2,
};

enum nf_hook_ops_type {
	NF_HOOK_OP_UNDEFINED = 0,
	NF_HOOK_OP_NF_TABLES = 1,
	NF_HOOK_OP_BPF = 2,
	NF_HOOK_OP_NFT_FT = 3,
};

enum nf_inet_hooks {
	NF_INET_PRE_ROUTING = 0,
	NF_INET_LOCAL_IN = 1,
	NF_INET_FORWARD = 2,
	NF_INET_LOCAL_OUT = 3,
	NF_INET_POST_ROUTING = 4,
	NF_INET_NUMHOOKS = 5,
	NF_INET_INGRESS = 5,
};

enum nf_ip_hook_priorities {
	NF_IP_PRI_FIRST = -2147483648,
	NF_IP_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP_PRI_RAW = -300,
	NF_IP_PRI_SELINUX_FIRST = -225,
	NF_IP_PRI_CONNTRACK = -200,
	NF_IP_PRI_MANGLE = -150,
	NF_IP_PRI_NAT_DST = -100,
	NF_IP_PRI_FILTER = 0,
	NF_IP_PRI_SECURITY = 50,
	NF_IP_PRI_NAT_SRC = 100,
	NF_IP_PRI_SELINUX_LAST = 225,
	NF_IP_PRI_CONNTRACK_HELPER = 300,
	NF_IP_PRI_CONNTRACK_CONFIRM = 2147483647,
	NF_IP_PRI_LAST = 2147483647,
};

enum nf_log_type {
	NF_LOG_TYPE_LOG = 0,
	NF_LOG_TYPE_ULOG = 1,
	NF_LOG_TYPE_MAX = 2,
};

enum nf_nat_manip_type;

enum nfs3_createmode {
	NFS3_CREATE_UNCHECKED = 0,
	NFS3_CREATE_GUARDED = 1,
	NFS3_CREATE_EXCLUSIVE = 2,
};

enum nfs3_ftype {
	NF3NON = 0,
	NF3REG = 1,
	NF3DIR = 2,
	NF3BLK = 3,
	NF3CHR = 4,
	NF3LNK = 5,
	NF3SOCK = 6,
	NF3FIFO = 7,
	NF3BAD = 8,
};

enum nfs3_stable_how {
	NFS_UNSTABLE = 0,
	NFS_DATA_SYNC = 1,
	NFS_FILE_SYNC = 2,
	NFS_INVALID_STABLE_HOW = -1,
};

enum nfs4_acl_type {
	NFS4ACL_NONE = 0,
	NFS4ACL_ACL = 1,
	NFS4ACL_DACL = 2,
	NFS4ACL_SACL = 3,
};

enum nfs4_callback_procnum {
	CB_NULL = 0,
	CB_COMPOUND = 1,
};

enum nfs4_change_attr_type {
	NFS4_CHANGE_TYPE_IS_MONOTONIC_INCR = 0,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER = 1,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER_NOPNFS = 2,
	NFS4_CHANGE_TYPE_IS_TIME_METADATA = 3,
	NFS4_CHANGE_TYPE_IS_UNDEFINED = 4,
};

enum nfs4_client_state {
	NFS4CLNT_MANAGER_RUNNING = 0,
	NFS4CLNT_CHECK_LEASE = 1,
	NFS4CLNT_LEASE_EXPIRED = 2,
	NFS4CLNT_RECLAIM_REBOOT = 3,
	NFS4CLNT_RECLAIM_NOGRACE = 4,
	NFS4CLNT_DELEGRETURN = 5,
	NFS4CLNT_SESSION_RESET = 6,
	NFS4CLNT_LEASE_CONFIRM = 7,
	NFS4CLNT_SERVER_SCOPE_MISMATCH = 8,
	NFS4CLNT_PURGE_STATE = 9,
	NFS4CLNT_BIND_CONN_TO_SESSION = 10,
	NFS4CLNT_MOVED = 11,
	NFS4CLNT_LEASE_MOVED = 12,
	NFS4CLNT_DELEGATION_EXPIRED = 13,
	NFS4CLNT_RUN_MANAGER = 14,
	NFS4CLNT_MANAGER_AVAILABLE = 15,
	NFS4CLNT_RECALL_RUNNING = 16,
	NFS4CLNT_RECALL_ANY_LAYOUT_READ = 17,
	NFS4CLNT_RECALL_ANY_LAYOUT_RW = 18,
	NFS4CLNT_DELEGRETURN_DELAYED = 19,
};

enum nfs4_ff_op_type {
	NFS4_FF_OP_LAYOUTSTATS = 0,
	NFS4_FF_OP_LAYOUTRETURN = 1,
};

enum nfs4_open_delegation_type4 {
	NFS4_OPEN_DELEGATE_NONE = 0,
	NFS4_OPEN_DELEGATE_READ = 1,
	NFS4_OPEN_DELEGATE_WRITE = 2,
	NFS4_OPEN_DELEGATE_NONE_EXT = 3,
	NFS4_OPEN_DELEGATE_READ_ATTRS_DELEG = 4,
	NFS4_OPEN_DELEGATE_WRITE_ATTRS_DELEG = 5,
};

enum nfs4_session_state {
	NFS4_SESSION_INITING = 0,
	NFS4_SESSION_ESTABLISHED = 1,
};

enum nfs4_slot_tbl_state {
	NFS4_SLOT_TBL_DRAINING = 0,
};

enum nfs_cb_opnum4 {
	OP_CB_GETATTR = 3,
	OP_CB_RECALL = 4,
	OP_CB_LAYOUTRECALL = 5,
	OP_CB_NOTIFY = 6,
	OP_CB_PUSH_DELEG = 7,
	OP_CB_RECALL_ANY = 8,
	OP_CB_RECALLABLE_OBJ_AVAIL = 9,
	OP_CB_RECALL_SLOT = 10,
	OP_CB_SEQUENCE = 11,
	OP_CB_WANTS_CANCELLED = 12,
	OP_CB_NOTIFY_LOCK = 13,
	OP_CB_NOTIFY_DEVICEID = 14,
	OP_CB_OFFLOAD = 15,
	OP_CB_ILLEGAL = 10044,
};

enum nfs_ftype4 {
	NF4BAD = 0,
	NF4REG = 1,
	NF4DIR = 2,
	NF4BLK = 3,
	NF4CHR = 4,
	NF4LNK = 5,
	NF4SOCK = 6,
	NF4FIFO = 7,
	NF4ATTRDIR = 8,
	NF4NAMEDATTR = 9,
};

enum nfs_lock_status {
	NFS_LOCK_NOT_SET = 0,
	NFS_LOCK_LOCK = 1,
	NFS_LOCK_NOLOCK = 2,
};

enum nfs_opnum4 {
	OP_ACCESS = 3,
	OP_CLOSE = 4,
	OP_COMMIT = 5,
	OP_CREATE = 6,
	OP_DELEGPURGE = 7,
	OP_DELEGRETURN = 8,
	OP_GETATTR = 9,
	OP_GETFH = 10,
	OP_LINK = 11,
	OP_LOCK = 12,
	OP_LOCKT = 13,
	OP_LOCKU = 14,
	OP_LOOKUP = 15,
	OP_LOOKUPP = 16,
	OP_NVERIFY = 17,
	OP_OPEN = 18,
	OP_OPENATTR = 19,
	OP_OPEN_CONFIRM = 20,
	OP_OPEN_DOWNGRADE = 21,
	OP_PUTFH = 22,
	OP_PUTPUBFH = 23,
	OP_PUTROOTFH = 24,
	OP_READ = 25,
	OP_READDIR = 26,
	OP_READLINK = 27,
	OP_REMOVE = 28,
	OP_RENAME = 29,
	OP_RENEW = 30,
	OP_RESTOREFH = 31,
	OP_SAVEFH = 32,
	OP_SECINFO = 33,
	OP_SETATTR = 34,
	OP_SETCLIENTID = 35,
	OP_SETCLIENTID_CONFIRM = 36,
	OP_VERIFY = 37,
	OP_WRITE = 38,
	OP_RELEASE_LOCKOWNER = 39,
	OP_BACKCHANNEL_CTL = 40,
	OP_BIND_CONN_TO_SESSION = 41,
	OP_EXCHANGE_ID = 42,
	OP_CREATE_SESSION = 43,
	OP_DESTROY_SESSION = 44,
	OP_FREE_STATEID = 45,
	OP_GET_DIR_DELEGATION = 46,
	OP_GETDEVICEINFO = 47,
	OP_GETDEVICELIST = 48,
	OP_LAYOUTCOMMIT = 49,
	OP_LAYOUTGET = 50,
	OP_LAYOUTRETURN = 51,
	OP_SECINFO_NO_NAME = 52,
	OP_SEQUENCE = 53,
	OP_SET_SSV = 54,
	OP_TEST_STATEID = 55,
	OP_WANT_DELEGATION = 56,
	OP_DESTROY_CLIENTID = 57,
	OP_RECLAIM_COMPLETE = 58,
	OP_ALLOCATE = 59,
	OP_COPY = 60,
	OP_COPY_NOTIFY = 61,
	OP_DEALLOCATE = 62,
	OP_IO_ADVISE = 63,
	OP_LAYOUTERROR = 64,
	OP_LAYOUTSTATS = 65,
	OP_OFFLOAD_CANCEL = 66,
	OP_OFFLOAD_STATUS = 67,
	OP_READ_PLUS = 68,
	OP_SEEK = 69,
	OP_WRITE_SAME = 70,
	OP_CLONE = 71,
	OP_GETXATTR = 72,
	OP_SETXATTR = 73,
	OP_LISTXATTRS = 74,
	OP_REMOVEXATTR = 75,
	OP_ILLEGAL = 10044,
};

enum nfs_param {
	Opt_ac = 0,
	Opt_acdirmax = 1,
	Opt_acdirmin = 2,
	Opt_acl___2 = 3,
	Opt_acregmax = 4,
	Opt_acregmin = 5,
	Opt_actimeo = 6,
	Opt_addr = 7,
	Opt_bg = 8,
	Opt_bsize = 9,
	Opt_clientaddr = 10,
	Opt_cto = 11,
	Opt_alignwrite = 12,
	Opt_fatal_neterrors = 13,
	Opt_fg = 14,
	Opt_fscache = 15,
	Opt_fscache_flag = 16,
	Opt_hard = 17,
	Opt_intr = 18,
	Opt_local_lock = 19,
	Opt_lock = 20,
	Opt_lookupcache = 21,
	Opt_migration = 22,
	Opt_minorversion = 23,
	Opt_mountaddr = 24,
	Opt_mounthost = 25,
	Opt_mountport = 26,
	Opt_mountproto = 27,
	Opt_mountvers = 28,
	Opt_namelen = 29,
	Opt_nconnect = 30,
	Opt_max_connect = 31,
	Opt_port___2 = 32,
	Opt_posix = 33,
	Opt_proto = 34,
	Opt_rdirplus = 35,
	Opt_rdirplus_none = 36,
	Opt_rdirplus_force = 37,
	Opt_rdma = 38,
	Opt_resvport = 39,
	Opt_retrans = 40,
	Opt_retry = 41,
	Opt_rsize = 42,
	Opt_sec = 43,
	Opt_sharecache = 44,
	Opt_sloppy = 45,
	Opt_soft = 46,
	Opt_softerr = 47,
	Opt_softreval = 48,
	Opt_source___2 = 49,
	Opt_tcp = 50,
	Opt_timeo = 51,
	Opt_trunkdiscovery = 52,
	Opt_udp = 53,
	Opt_v = 54,
	Opt_vers = 55,
	Opt_wsize = 56,
	Opt_write = 57,
	Opt_xprtsec = 58,
	Opt_cert_serial = 59,
	Opt_privkey_serial = 60,
};

enum nfs_stat {
	NFS_OK = 0,
	NFSERR_PERM = 1,
	NFSERR_NOENT = 2,
	NFSERR_IO = 5,
	NFSERR_NXIO = 6,
	NFSERR_EAGAIN = 11,
	NFSERR_ACCES = 13,
	NFSERR_EXIST = 17,
	NFSERR_XDEV = 18,
	NFSERR_NODEV = 19,
	NFSERR_NOTDIR = 20,
	NFSERR_ISDIR = 21,
	NFSERR_INVAL = 22,
	NFSERR_FBIG = 27,
	NFSERR_NOSPC = 28,
	NFSERR_ROFS = 30,
	NFSERR_MLINK = 31,
	NFSERR_NAMETOOLONG = 63,
	NFSERR_NOTEMPTY = 66,
	NFSERR_DQUOT = 69,
	NFSERR_STALE = 70,
	NFSERR_REMOTE = 71,
	NFSERR_WFLUSH = 99,
	NFSERR_BADHANDLE = 10001,
	NFSERR_NOT_SYNC = 10002,
	NFSERR_BAD_COOKIE = 10003,
	NFSERR_NOTSUPP = 10004,
	NFSERR_TOOSMALL = 10005,
	NFSERR_SERVERFAULT = 10006,
	NFSERR_BADTYPE = 10007,
	NFSERR_JUKEBOX = 10008,
	NFSERR_SAME = 10009,
	NFSERR_DENIED = 10010,
	NFSERR_EXPIRED = 10011,
	NFSERR_LOCKED = 10012,
	NFSERR_GRACE = 10013,
	NFSERR_FHEXPIRED = 10014,
	NFSERR_SHARE_DENIED = 10015,
	NFSERR_WRONGSEC = 10016,
	NFSERR_CLID_INUSE = 10017,
	NFSERR_RESOURCE = 10018,
	NFSERR_MOVED = 10019,
	NFSERR_NOFILEHANDLE = 10020,
	NFSERR_MINOR_VERS_MISMATCH = 10021,
	NFSERR_STALE_CLIENTID = 10022,
	NFSERR_STALE_STATEID = 10023,
	NFSERR_OLD_STATEID = 10024,
	NFSERR_BAD_STATEID = 10025,
	NFSERR_BAD_SEQID = 10026,
	NFSERR_NOT_SAME = 10027,
	NFSERR_LOCK_RANGE = 10028,
	NFSERR_SYMLINK = 10029,
	NFSERR_RESTOREFH = 10030,
	NFSERR_LEASE_MOVED = 10031,
	NFSERR_ATTRNOTSUPP = 10032,
	NFSERR_NO_GRACE = 10033,
	NFSERR_RECLAIM_BAD = 10034,
	NFSERR_RECLAIM_CONFLICT = 10035,
	NFSERR_BAD_XDR = 10036,
	NFSERR_LOCKS_HELD = 10037,
	NFSERR_OPENMODE = 10038,
	NFSERR_BADOWNER = 10039,
	NFSERR_BADCHAR = 10040,
	NFSERR_BADNAME = 10041,
	NFSERR_BAD_RANGE = 10042,
	NFSERR_LOCK_NOTSUPP = 10043,
	NFSERR_OP_ILLEGAL = 10044,
	NFSERR_DEADLOCK = 10045,
	NFSERR_FILE_OPEN = 10046,
	NFSERR_ADMIN_REVOKED = 10047,
	NFSERR_CB_PATH_DOWN = 10048,
};

enum nfs_stat_bytecounters {
	NFSIOS_NORMALREADBYTES = 0,
	NFSIOS_NORMALWRITTENBYTES = 1,
	NFSIOS_DIRECTREADBYTES = 2,
	NFSIOS_DIRECTWRITTENBYTES = 3,
	NFSIOS_SERVERREADBYTES = 4,
	NFSIOS_SERVERWRITTENBYTES = 5,
	NFSIOS_READPAGES = 6,
	NFSIOS_WRITEPAGES = 7,
	__NFSIOS_BYTESMAX = 8,
};

enum nfs_stat_eventcounters {
	NFSIOS_INODEREVALIDATE = 0,
	NFSIOS_DENTRYREVALIDATE = 1,
	NFSIOS_DATAINVALIDATE = 2,
	NFSIOS_ATTRINVALIDATE = 3,
	NFSIOS_VFSOPEN = 4,
	NFSIOS_VFSLOOKUP = 5,
	NFSIOS_VFSACCESS = 6,
	NFSIOS_VFSUPDATEPAGE = 7,
	NFSIOS_VFSREADPAGE = 8,
	NFSIOS_VFSREADPAGES = 9,
	NFSIOS_VFSWRITEPAGE = 10,
	NFSIOS_VFSWRITEPAGES = 11,
	NFSIOS_VFSGETDENTS = 12,
	NFSIOS_VFSSETATTR = 13,
	NFSIOS_VFSFLUSH = 14,
	NFSIOS_VFSFSYNC = 15,
	NFSIOS_VFSLOCK = 16,
	NFSIOS_VFSRELEASE = 17,
	NFSIOS_CONGESTIONWAIT = 18,
	NFSIOS_SETATTRTRUNC = 19,
	NFSIOS_EXTENDWRITE = 20,
	NFSIOS_SILLYRENAME = 21,
	NFSIOS_SHORTREAD = 22,
	NFSIOS_SHORTWRITE = 23,
	NFSIOS_DELAY = 24,
	NFSIOS_PNFS_READ = 25,
	NFSIOS_PNFS_WRITE = 26,
	__NFSIOS_COUNTSMAX = 27,
};

enum nfsstat4 {
	NFS4_OK = 0,
	NFS4ERR_PERM = 1,
	NFS4ERR_NOENT = 2,
	NFS4ERR_IO = 5,
	NFS4ERR_NXIO = 6,
	NFS4ERR_ACCESS = 13,
	NFS4ERR_EXIST = 17,
	NFS4ERR_XDEV = 18,
	NFS4ERR_NOTDIR = 20,
	NFS4ERR_ISDIR = 21,
	NFS4ERR_INVAL = 22,
	NFS4ERR_FBIG = 27,
	NFS4ERR_NOSPC = 28,
	NFS4ERR_ROFS = 30,
	NFS4ERR_MLINK = 31,
	NFS4ERR_NAMETOOLONG = 63,
	NFS4ERR_NOTEMPTY = 66,
	NFS4ERR_DQUOT = 69,
	NFS4ERR_STALE = 70,
	NFS4ERR_BADHANDLE = 10001,
	NFS4ERR_BAD_COOKIE = 10003,
	NFS4ERR_NOTSUPP = 10004,
	NFS4ERR_TOOSMALL = 10005,
	NFS4ERR_SERVERFAULT = 10006,
	NFS4ERR_BADTYPE = 10007,
	NFS4ERR_DELAY = 10008,
	NFS4ERR_SAME = 10009,
	NFS4ERR_DENIED = 10010,
	NFS4ERR_EXPIRED = 10011,
	NFS4ERR_LOCKED = 10012,
	NFS4ERR_GRACE = 10013,
	NFS4ERR_FHEXPIRED = 10014,
	NFS4ERR_SHARE_DENIED = 10015,
	NFS4ERR_WRONGSEC = 10016,
	NFS4ERR_CLID_INUSE = 10017,
	NFS4ERR_RESOURCE = 10018,
	NFS4ERR_MOVED = 10019,
	NFS4ERR_NOFILEHANDLE = 10020,
	NFS4ERR_MINOR_VERS_MISMATCH = 10021,
	NFS4ERR_STALE_CLIENTID = 10022,
	NFS4ERR_STALE_STATEID = 10023,
	NFS4ERR_OLD_STATEID = 10024,
	NFS4ERR_BAD_STATEID = 10025,
	NFS4ERR_BAD_SEQID = 10026,
	NFS4ERR_NOT_SAME = 10027,
	NFS4ERR_LOCK_RANGE = 10028,
	NFS4ERR_SYMLINK = 10029,
	NFS4ERR_RESTOREFH = 10030,
	NFS4ERR_LEASE_MOVED = 10031,
	NFS4ERR_ATTRNOTSUPP = 10032,
	NFS4ERR_NO_GRACE = 10033,
	NFS4ERR_RECLAIM_BAD = 10034,
	NFS4ERR_RECLAIM_CONFLICT = 10035,
	NFS4ERR_BADXDR = 10036,
	NFS4ERR_LOCKS_HELD = 10037,
	NFS4ERR_OPENMODE = 10038,
	NFS4ERR_BADOWNER = 10039,
	NFS4ERR_BADCHAR = 10040,
	NFS4ERR_BADNAME = 10041,
	NFS4ERR_BAD_RANGE = 10042,
	NFS4ERR_LOCK_NOTSUPP = 10043,
	NFS4ERR_OP_ILLEGAL = 10044,
	NFS4ERR_DEADLOCK = 10045,
	NFS4ERR_FILE_OPEN = 10046,
	NFS4ERR_ADMIN_REVOKED = 10047,
	NFS4ERR_CB_PATH_DOWN = 10048,
	NFS4ERR_BADIOMODE = 10049,
	NFS4ERR_BADLAYOUT = 10050,
	NFS4ERR_BAD_SESSION_DIGEST = 10051,
	NFS4ERR_BADSESSION = 10052,
	NFS4ERR_BADSLOT = 10053,
	NFS4ERR_COMPLETE_ALREADY = 10054,
	NFS4ERR_CONN_NOT_BOUND_TO_SESSION = 10055,
	NFS4ERR_DELEG_ALREADY_WANTED = 10056,
	NFS4ERR_BACK_CHAN_BUSY = 10057,
	NFS4ERR_LAYOUTTRYLATER = 10058,
	NFS4ERR_LAYOUTUNAVAILABLE = 10059,
	NFS4ERR_NOMATCHING_LAYOUT = 10060,
	NFS4ERR_RECALLCONFLICT = 10061,
	NFS4ERR_UNKNOWN_LAYOUTTYPE = 10062,
	NFS4ERR_SEQ_MISORDERED = 10063,
	NFS4ERR_SEQUENCE_POS = 10064,
	NFS4ERR_REQ_TOO_BIG = 10065,
	NFS4ERR_REP_TOO_BIG = 10066,
	NFS4ERR_REP_TOO_BIG_TO_CACHE = 10067,
	NFS4ERR_RETRY_UNCACHED_REP = 10068,
	NFS4ERR_UNSAFE_COMPOUND = 10069,
	NFS4ERR_TOO_MANY_OPS = 10070,
	NFS4ERR_OP_NOT_IN_SESSION = 10071,
	NFS4ERR_HASH_ALG_UNSUPP = 10072,
	NFS4ERR_CLIENTID_BUSY = 10074,
	NFS4ERR_PNFS_IO_HOLE = 10075,
	NFS4ERR_SEQ_FALSE_RETRY = 10076,
	NFS4ERR_BAD_HIGH_SLOT = 10077,
	NFS4ERR_DEADSESSION = 10078,
	NFS4ERR_ENCR_ALG_UNSUPP = 10079,
	NFS4ERR_PNFS_NO_LAYOUT = 10080,
	NFS4ERR_NOT_ONLY_OP = 10081,
	NFS4ERR_WRONG_CRED = 10082,
	NFS4ERR_WRONG_TYPE = 10083,
	NFS4ERR_DIRDELEG_UNAVAIL = 10084,
	NFS4ERR_REJECT_DELEG = 10085,
	NFS4ERR_RETURNCONFLICT = 10086,
	NFS4ERR_DELEG_REVOKED = 10087,
	NFS4ERR_PARTNER_NOTSUPP = 10088,
	NFS4ERR_PARTNER_NO_AUTH = 10089,
	NFS4ERR_UNION_NOTSUPP = 10090,
	NFS4ERR_OFFLOAD_DENIED = 10091,
	NFS4ERR_WRONG_LFS = 10092,
	NFS4ERR_BADLABEL = 10093,
	NFS4ERR_OFFLOAD_NO_REQS = 10094,
	NFS4ERR_NOXATTR = 10095,
	NFS4ERR_XATTR2BIG = 10096,
	NFS4ERR_FIRST_FREE = 10097,
};

enum nh_notifier_info_type {
	NH_NOTIFIER_INFO_TYPE_SINGLE = 0,
	NH_NOTIFIER_INFO_TYPE_GRP = 1,
	NH_NOTIFIER_INFO_TYPE_RES_TABLE = 2,
	NH_NOTIFIER_INFO_TYPE_RES_BUCKET = 3,
	NH_NOTIFIER_INFO_TYPE_GRP_HW_STATS = 4,
};

enum nla_policy_validation {
	NLA_VALIDATE_NONE = 0,
	NLA_VALIDATE_RANGE = 1,
	NLA_VALIDATE_RANGE_WARN_TOO_LONG = 2,
	NLA_VALIDATE_MIN = 3,
	NLA_VALIDATE_MAX = 4,
	NLA_VALIDATE_MASK = 5,
	NLA_VALIDATE_RANGE_PTR = 6,
	NLA_VALIDATE_FUNCTION = 7,
};

enum nlmsgerr_attrs {
	NLMSGERR_ATTR_UNUSED = 0,
	NLMSGERR_ATTR_MSG = 1,
	NLMSGERR_ATTR_OFFS = 2,
	NLMSGERR_ATTR_COOKIE = 3,
	NLMSGERR_ATTR_POLICY = 4,
	NLMSGERR_ATTR_MISS_TYPE = 5,
	NLMSGERR_ATTR_MISS_NEST = 6,
	__NLMSGERR_ATTR_MAX = 7,
	NLMSGERR_ATTR_MAX = 6,
};

enum node_stat_item {
	NR_LRU_BASE = 0,
	NR_INACTIVE_ANON = 0,
	NR_ACTIVE_ANON = 1,
	NR_INACTIVE_FILE = 2,
	NR_ACTIVE_FILE = 3,
	NR_UNEVICTABLE = 4,
	NR_SLAB_RECLAIMABLE_B = 5,
	NR_SLAB_UNRECLAIMABLE_B = 6,
	NR_ISOLATED_ANON = 7,
	NR_ISOLATED_FILE = 8,
	WORKINGSET_NODES = 9,
	WORKINGSET_REFAULT_BASE = 10,
	WORKINGSET_REFAULT_ANON = 10,
	WORKINGSET_REFAULT_FILE = 11,
	WORKINGSET_ACTIVATE_BASE = 12,
	WORKINGSET_ACTIVATE_ANON = 12,
	WORKINGSET_ACTIVATE_FILE = 13,
	WORKINGSET_RESTORE_BASE = 14,
	WORKINGSET_RESTORE_ANON = 14,
	WORKINGSET_RESTORE_FILE = 15,
	WORKINGSET_NODERECLAIM = 16,
	NR_ANON_MAPPED = 17,
	NR_FILE_MAPPED = 18,
	NR_FILE_PAGES = 19,
	NR_FILE_DIRTY = 20,
	NR_WRITEBACK = 21,
	NR_SHMEM = 22,
	NR_SHMEM_THPS = 23,
	NR_SHMEM_PMDMAPPED = 24,
	NR_FILE_THPS = 25,
	NR_FILE_PMDMAPPED = 26,
	NR_ANON_THPS = 27,
	NR_VMSCAN_WRITE = 28,
	NR_VMSCAN_IMMEDIATE = 29,
	NR_DIRTIED = 30,
	NR_WRITTEN = 31,
	NR_THROTTLED_WRITTEN = 32,
	NR_KERNEL_MISC_RECLAIMABLE = 33,
	NR_FOLL_PIN_ACQUIRED = 34,
	NR_FOLL_PIN_RELEASED = 35,
	NR_KERNEL_STACK_KB = 36,
	NR_PAGETABLE = 37,
	NR_SECONDARY_PAGETABLE = 38,
	NR_IOMMU_PAGES = 39,
	NR_SWAPCACHE = 40,
	PGPROMOTE_SUCCESS = 41,
	PGPROMOTE_CANDIDATE = 42,
	PGPROMOTE_CANDIDATE_NRL = 43,
	PGDEMOTE_KSWAPD = 44,
	PGDEMOTE_DIRECT = 45,
	PGDEMOTE_KHUGEPAGED = 46,
	PGDEMOTE_PROACTIVE = 47,
	NR_HUGETLB = 48,
	NR_BALLOON_PAGES = 49,
	NR_KERNEL_FILE_PAGES = 50,
	NR_VM_NODE_STAT_ITEMS = 51,
};

enum node_states {
	N_POSSIBLE = 0,
	N_ONLINE = 1,
	N_NORMAL_MEMORY = 2,
	N_HIGH_MEMORY = 2,
	N_MEMORY = 3,
	N_CPU = 4,
	N_GENERIC_INITIATOR = 5,
	NR_NODE_STATES = 6,
};

enum notify_state {
	SECCOMP_NOTIFY_INIT = 0,
	SECCOMP_NOTIFY_SENT = 1,
	SECCOMP_NOTIFY_REPLIED = 2,
};

enum numa_faults_stats {
	NUMA_MEM = 0,
	NUMA_CPU = 1,
	NUMA_MEMBUF = 2,
	NUMA_CPUBUF = 3,
};

enum numa_stat_item {
	NUMA_HIT = 0,
	NUMA_MISS = 1,
	NUMA_FOREIGN = 2,
	NUMA_INTERLEAVE_HIT = 3,
	NUMA_LOCAL = 4,
	NUMA_OTHER = 5,
	NR_VM_NUMA_EVENT_ITEMS = 6,
};

enum numa_topology_type {
	NUMA_DIRECT = 0,
	NUMA_GLUELESS_MESH = 1,
	NUMA_BACKPLANE = 2,
};

enum numa_type {
	node_has_spare = 0,
	node_fully_busy = 1,
	node_overloaded = 2,
};

enum numa_vmaskip_reason {
	NUMAB_SKIP_UNSUITABLE = 0,
	NUMAB_SKIP_SHARED_RO = 1,
	NUMAB_SKIP_INACCESSIBLE = 2,
	NUMAB_SKIP_SCAN_DELAY = 3,
	NUMAB_SKIP_PID_INACTIVE = 4,
	NUMAB_SKIP_IGNORE_PID = 5,
	NUMAB_SKIP_SEQ_COMPLETED = 6,
};

enum nvme_admin_opcode {
	nvme_admin_delete_sq = 0,
	nvme_admin_create_sq = 1,
	nvme_admin_get_log_page = 2,
	nvme_admin_delete_cq = 4,
	nvme_admin_create_cq = 5,
	nvme_admin_identify = 6,
	nvme_admin_abort_cmd = 8,
	nvme_admin_set_features = 9,
	nvme_admin_get_features = 10,
	nvme_admin_async_event = 12,
	nvme_admin_ns_mgmt = 13,
	nvme_admin_activate_fw = 16,
	nvme_admin_download_fw = 17,
	nvme_admin_dev_self_test = 20,
	nvme_admin_ns_attach = 21,
	nvme_admin_keep_alive = 24,
	nvme_admin_directive_send = 25,
	nvme_admin_directive_recv = 26,
	nvme_admin_virtual_mgmt = 28,
	nvme_admin_nvme_mi_send = 29,
	nvme_admin_nvme_mi_recv = 30,
	nvme_admin_dbbuf = 124,
	nvme_admin_format_nvm = 128,
	nvme_admin_security_send = 129,
	nvme_admin_security_recv = 130,
	nvme_admin_sanitize_nvm = 132,
	nvme_admin_get_lba_status = 134,
	nvme_admin_vendor_start = 192,
};

enum nvme_ana_state {
	NVME_ANA_OPTIMIZED = 1,
	NVME_ANA_NONOPTIMIZED = 2,
	NVME_ANA_INACCESSIBLE = 3,
	NVME_ANA_PERSISTENT_LOSS = 4,
	NVME_ANA_CHANGE = 15,
};

enum nvme_ctrl_attr {
	NVME_CTRL_ATTR_HID_128_BIT = 1,
	NVME_CTRL_ATTR_TBKAS = 64,
	NVME_CTRL_ATTR_ELBAS = 32768,
	NVME_CTRL_ATTR_RHII = 262144,
	NVME_CTRL_ATTR_FDPS = 524288,
};

enum nvme_ctrl_flags {
	NVME_CTRL_FAILFAST_EXPIRED = 0,
	NVME_CTRL_ADMIN_Q_STOPPED = 1,
	NVME_CTRL_STARTED_ONCE = 2,
	NVME_CTRL_STOPPED = 3,
	NVME_CTRL_SKIP_ID_CNS_CS = 4,
	NVME_CTRL_DIRTY_CAPABILITY = 5,
	NVME_CTRL_FROZEN = 6,
};

enum nvme_ctrl_state {
	NVME_CTRL_NEW = 0,
	NVME_CTRL_LIVE = 1,
	NVME_CTRL_RESETTING = 2,
	NVME_CTRL_CONNECTING = 3,
	NVME_CTRL_DELETING = 4,
	NVME_CTRL_DELETING_NOIO = 5,
	NVME_CTRL_DEAD = 6,
};

enum nvme_ctrl_type {
	NVME_CTRL_IO = 1,
	NVME_CTRL_DISC = 2,
	NVME_CTRL_ADMIN = 3,
};

enum nvme_dctype {
	NVME_DCTYPE_NOT_REPORTED = 0,
	NVME_DCTYPE_DDC = 1,
	NVME_DCTYPE_CDC = 2,
};

enum nvme_disposition {
	COMPLETE = 0,
	RETRY = 1,
	FAILOVER = 2,
	AUTHENTICATE = 3,
};

enum nvme_eds {
	NVME_EXTENDED_DATA_STRUCT = 1,
};

enum nvme_iod_flags {
	IOD_ABORTED = 1,
	IOD_SMALL_DESCRIPTOR = 2,
	IOD_SINGLE_SEGMENT = 4,
	IOD_SINGLE_META_SEGMENT = 32,
};

enum nvme_iopolicy {
	NVME_IOPOLICY_NUMA = 0,
	NVME_IOPOLICY_RR = 1,
	NVME_IOPOLICY_QD = 2,
};

enum nvme_ns_features {
	NVME_NS_EXT_LBAS = 1,
	NVME_NS_METADATA_SUPPORTED = 2,
	NVME_NS_DEAC = 4,
};

enum nvme_opcode {
	nvme_cmd_flush = 0,
	nvme_cmd_write = 1,
	nvme_cmd_read = 2,
	nvme_cmd_write_uncor = 4,
	nvme_cmd_compare = 5,
	nvme_cmd_write_zeroes = 8,
	nvme_cmd_dsm = 9,
	nvme_cmd_verify = 12,
	nvme_cmd_resv_register = 13,
	nvme_cmd_resv_report = 14,
	nvme_cmd_resv_acquire = 17,
	nvme_cmd_io_mgmt_recv = 18,
	nvme_cmd_resv_release = 21,
	nvme_cmd_zone_mgmt_send = 121,
	nvme_cmd_zone_mgmt_recv = 122,
	nvme_cmd_zone_append = 125,
	nvme_cmd_vendor_start = 128,
};

enum nvme_pr_acquire_action {
	NVME_PR_ACQUIRE_ACT_ACQUIRE = 0,
	NVME_PR_ACQUIRE_ACT_PREEMPT = 1,
	NVME_PR_ACQUIRE_ACT_PREEMPT_AND_ABORT = 2,
};

enum nvme_pr_change_ptpl {
	NVME_PR_CPTPL_NO_CHANGE = 0,
	NVME_PR_CPTPL_RESV = 1073741824,
	NVME_PR_CPTPL_CLEARED = -2147483648,
	NVME_PR_CPTPL_PERSIST = -1073741824,
};

enum nvme_pr_register_action {
	NVME_PR_REGISTER_ACT_REG = 0,
	NVME_PR_REGISTER_ACT_UNREG = 1,
	NVME_PR_REGISTER_ACT_REPLACE = 2,
};

enum nvme_pr_release_action {
	NVME_PR_RELEASE_ACT_RELEASE = 0,
	NVME_PR_RELEASE_ACT_CLEAR = 1,
};

enum nvme_pr_type {
	NVME_PR_WRITE_EXCLUSIVE = 1,
	NVME_PR_EXCLUSIVE_ACCESS = 2,
	NVME_PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	NVME_PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	NVME_PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	NVME_PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum nvme_quirks {
	NVME_QUIRK_STRIPE_SIZE = 1,
	NVME_QUIRK_IDENTIFY_CNS = 2,
	NVME_QUIRK_DEALLOCATE_ZEROES = 4,
	NVME_QUIRK_DELAY_BEFORE_CHK_RDY = 8,
	NVME_QUIRK_NO_APST = 16,
	NVME_QUIRK_NO_DEEPEST_PS = 32,
	NVME_QUIRK_QDEPTH_ONE = 64,
	NVME_QUIRK_MEDIUM_PRIO_SQ = 128,
	NVME_QUIRK_IGNORE_DEV_SUBNQN = 256,
	NVME_QUIRK_DISABLE_WRITE_ZEROES = 512,
	NVME_QUIRK_SIMPLE_SUSPEND = 1024,
	NVME_QUIRK_SINGLE_VECTOR = 2048,
	NVME_QUIRK_128_BYTES_SQES = 4096,
	NVME_QUIRK_SHARED_TAGS = 8192,
	NVME_QUIRK_NO_TEMP_THRESH_CHANGE = 16384,
	NVME_QUIRK_NO_NS_DESC_LIST = 32768,
	NVME_QUIRK_DMA_ADDRESS_BITS_48 = 65536,
	NVME_QUIRK_SKIP_CID_GEN = 131072,
	NVME_QUIRK_BOGUS_NID = 262144,
	NVME_QUIRK_NO_SECONDARY_TEMP_THRESH = 524288,
	NVME_QUIRK_FORCE_NO_SIMPLE_SUSPEND = 1048576,
	NVME_QUIRK_BROKEN_MSI = 2097152,
	NVME_QUIRK_DMAPOOL_ALIGN_512 = 4194304,
};

enum nvme_subsys_type {
	NVME_NQN_DISC = 1,
	NVME_NQN_NVME = 2,
	NVME_NQN_CURR = 3,
};

enum nvme_use_sgl {
	SGL_UNSUPPORTED = 0,
	SGL_SUPPORTED = 1,
	SGL_FORCED = 2,
};

enum nvme_zone_mgmt_action {
	NVME_ZONE_CLOSE = 1,
	NVME_ZONE_FINISH = 2,
	NVME_ZONE_OPEN = 3,
	NVME_ZONE_RESET = 4,
	NVME_ZONE_OFFLINE = 5,
	NVME_ZONE_SET_DESC_EXT = 16,
};

enum nvmem_type {
	NVMEM_TYPE_UNKNOWN = 0,
	NVMEM_TYPE_EEPROM = 1,
	NVMEM_TYPE_OTP = 2,
	NVMEM_TYPE_BATTERY_BACKED = 3,
	NVMEM_TYPE_FRAM = 4,
};

enum nvmf_capsule_command {
	nvme_fabrics_type_property_set = 0,
	nvme_fabrics_type_connect = 1,
	nvme_fabrics_type_property_get = 4,
	nvme_fabrics_type_auth_send = 5,
	nvme_fabrics_type_auth_receive = 6,
};

enum nvmf_fabrics_opcode {
	nvme_fabrics_command = 127,
};

enum objext_flags {
	OBJEXTS_ALLOC_FAIL = 1,
	OBJEXTS_NOSPIN_ALLOC = 4,
	__NR_OBJEXTS_FLAGS = 8,
};

enum of_gpio_flags {
	OF_GPIO_ACTIVE_LOW = 1,
	OF_GPIO_SINGLE_ENDED = 2,
	OF_GPIO_OPEN_DRAIN = 4,
	OF_GPIO_TRANSITORY = 8,
	OF_GPIO_PULL_UP = 16,
	OF_GPIO_PULL_DOWN = 32,
	OF_GPIO_PULL_DISABLE = 64,
};

enum of_overlay_notify_action {
	OF_OVERLAY_INIT = 0,
	OF_OVERLAY_PRE_APPLY = 1,
	OF_OVERLAY_POST_APPLY = 2,
	OF_OVERLAY_PRE_REMOVE = 3,
	OF_OVERLAY_POST_REMOVE = 4,
};

enum of_pci_prop_compatible {
	PROP_COMPAT_PCI_VVVV_DDDD = 0,
	PROP_COMPAT_PCICLASS_CCSSPP = 1,
	PROP_COMPAT_PCICLASS_CCSS = 2,
	PROP_COMPAT_NUM = 3,
};

enum of_reconfig_change {
	OF_RECONFIG_NO_CHANGE = 0,
	OF_RECONFIG_CHANGE_ADD = 1,
	OF_RECONFIG_CHANGE_REMOVE = 2,
};

enum offload_act_command {
	FLOW_ACT_REPLACE = 0,
	FLOW_ACT_DESTROY = 1,
	FLOW_ACT_STATS = 2,
};

enum ohci_rh_state {
	OHCI_RH_HALTED = 0,
	OHCI_RH_SUSPENDED = 1,
	OHCI_RH_RUNNING = 2,
};

enum oom_constraint {
	CONSTRAINT_NONE = 0,
	CONSTRAINT_CPUSET = 1,
	CONSTRAINT_MEMORY_POLICY = 2,
	CONSTRAINT_MEMCG = 3,
};

enum open_claim_type4 {
	NFS4_OPEN_CLAIM_NULL = 0,
	NFS4_OPEN_CLAIM_PREVIOUS = 1,
	NFS4_OPEN_CLAIM_DELEGATE_CUR = 2,
	NFS4_OPEN_CLAIM_DELEGATE_PREV = 3,
	NFS4_OPEN_CLAIM_FH = 4,
	NFS4_OPEN_CLAIM_DELEG_CUR_FH = 5,
	NFS4_OPEN_CLAIM_DELEG_PREV_FH = 6,
};

enum opentype4 {
	NFS4_OPEN_NOCREATE = 0,
	NFS4_OPEN_CREATE = 1,
};

enum opp_table_access {
	OPP_TABLE_ACCESS_UNKNOWN = 0,
	OPP_TABLE_ACCESS_EXCLUSIVE = 1,
	OPP_TABLE_ACCESS_SHARED = 2,
};

enum orion_ehci_phy_ver {
	EHCI_PHY_ORION = 0,
	EHCI_PHY_DD = 1,
	EHCI_PHY_KW = 2,
	EHCI_PHY_NA = 3,
};

enum orion_mdio_bus_type {
	BUS_TYPE_SMI = 0,
	BUS_TYPE_XSMI = 1,
};

enum orion_spi_type {
	ORION_SPI = 0,
	ARMADA_SPI = 1,
};

enum ospi_mux_select_type {
	PM_OSPI_MUX_SEL_DMA = 0,
	PM_OSPI_MUX_SEL_LINEAR = 1,
};

enum owl_dma_id {
	S900_DMA = 0,
	S700_DMA = 1,
};

enum owl_dmadesc_offsets {
	OWL_DMADESC_NEXT_LLI = 0,
	OWL_DMADESC_SADDR = 1,
	OWL_DMADESC_DADDR = 2,
	OWL_DMADESC_FLEN = 3,
	OWL_DMADESC_SRC_STRIDE = 4,
	OWL_DMADESC_DST_STRIDE = 5,
	OWL_DMADESC_CTRLA = 6,
	OWL_DMADESC_CTRLB = 7,
	OWL_DMADESC_CONST_NUM = 8,
	OWL_DMADESC_SIZE = 9,
};

enum owl_pinconf_drv {
	OWL_PINCONF_DRV_2MA = 0,
	OWL_PINCONF_DRV_4MA = 1,
	OWL_PINCONF_DRV_8MA = 2,
	OWL_PINCONF_DRV_12MA = 3,
};

enum owner_state {
	OWNER_NULL = 1,
	OWNER_WRITER = 2,
	OWNER_READER = 4,
	OWNER_NONSPINNABLE = 8,
};

enum p9_cache_bits {
	CACHE_NONE = 0,
	CACHE_FILE = 1,
	CACHE_META = 2,
	CACHE_WRITEBACK = 4,
	CACHE_LOOSE = 8,
	CACHE_FSCACHE = 128,
};

enum p9_cache_shortcuts {
	CACHE_SC_NONE = 0,
	CACHE_SC_READAHEAD = 1,
	CACHE_SC_MMAP = 5,
	CACHE_SC_LOOSE = 15,
	CACHE_SC_FSCACHE = 143,
};

enum p9_fid_reftype {
	P9_FID_REF_CREATE = 0,
	P9_FID_REF_GET = 1,
	P9_FID_REF_PUT = 2,
	P9_FID_REF_DESTROY = 3,
} __attribute__((mode(byte)));

enum p9_msg_t {
	P9_TLERROR = 6,
	P9_RLERROR = 7,
	P9_TSTATFS = 8,
	P9_RSTATFS = 9,
	P9_TLOPEN = 12,
	P9_RLOPEN = 13,
	P9_TLCREATE = 14,
	P9_RLCREATE = 15,
	P9_TSYMLINK = 16,
	P9_RSYMLINK = 17,
	P9_TMKNOD = 18,
	P9_RMKNOD = 19,
	P9_TRENAME = 20,
	P9_RRENAME = 21,
	P9_TREADLINK = 22,
	P9_RREADLINK = 23,
	P9_TGETATTR = 24,
	P9_RGETATTR = 25,
	P9_TSETATTR = 26,
	P9_RSETATTR = 27,
	P9_TXATTRWALK = 30,
	P9_RXATTRWALK = 31,
	P9_TXATTRCREATE = 32,
	P9_RXATTRCREATE = 33,
	P9_TREADDIR = 40,
	P9_RREADDIR = 41,
	P9_TFSYNC = 50,
	P9_RFSYNC = 51,
	P9_TLOCK = 52,
	P9_RLOCK = 53,
	P9_TGETLOCK = 54,
	P9_RGETLOCK = 55,
	P9_TLINK = 70,
	P9_RLINK = 71,
	P9_TMKDIR = 72,
	P9_RMKDIR = 73,
	P9_TRENAMEAT = 74,
	P9_RRENAMEAT = 75,
	P9_TUNLINKAT = 76,
	P9_RUNLINKAT = 77,
	P9_TVERSION = 100,
	P9_RVERSION = 101,
	P9_TAUTH = 102,
	P9_RAUTH = 103,
	P9_TATTACH = 104,
	P9_RATTACH = 105,
	P9_TERROR = 106,
	P9_RERROR = 107,
	P9_TFLUSH = 108,
	P9_RFLUSH = 109,
	P9_TWALK = 110,
	P9_RWALK = 111,
	P9_TOPEN = 112,
	P9_ROPEN = 113,
	P9_TCREATE = 114,
	P9_RCREATE = 115,
	P9_TREAD = 116,
	P9_RREAD = 117,
	P9_TWRITE = 118,
	P9_RWRITE = 119,
	P9_TCLUNK = 120,
	P9_RCLUNK = 121,
	P9_TREMOVE = 122,
	P9_RREMOVE = 123,
	P9_TSTAT = 124,
	P9_RSTAT = 125,
	P9_TWSTAT = 126,
	P9_RWSTAT = 127,
};

enum p9_open_mode_t {
	P9_OREAD = 0,
	P9_OWRITE = 1,
	P9_ORDWR = 2,
	P9_OEXEC = 3,
	P9_OTRUNC = 16,
	P9_OREXEC = 32,
	P9_ORCLOSE = 64,
	P9_OAPPEND = 128,
	P9_OEXCL = 4096,
	P9L_MODE_MASK = 8191,
	P9L_DIRECT = 8192,
	P9L_NOWRITECACHE = 16384,
	P9L_LOOSE = 32768,
};

enum p9_perm_t {
	P9_DMDIR = 2147483648,
	P9_DMAPPEND = 1073741824,
	P9_DMEXCL = 536870912,
	P9_DMMOUNT = 268435456,
	P9_DMAUTH = 134217728,
	P9_DMTMP = 67108864,
	P9_DMSYMLINK = 33554432,
	P9_DMLINK = 16777216,
	P9_DMDEVICE = 8388608,
	P9_DMNAMEDPIPE = 2097152,
	P9_DMSOCKET = 1048576,
	P9_DMSETUID = 524288,
	P9_DMSETGID = 262144,
	P9_DMSETVTX = 65536,
};

enum p9_proto_versions {
	p9_proto_legacy = 0,
	p9_proto_2000u = 1,
	p9_proto_2000L = 2,
};

enum p9_req_status_t {
	REQ_STATUS_ALLOC = 0,
	REQ_STATUS_UNSENT = 1,
	REQ_STATUS_SENT = 2,
	REQ_STATUS_RCVD = 3,
	REQ_STATUS_FLSHD = 4,
	REQ_STATUS_ERROR = 5,
};

enum p9_session_flags {
	V9FS_PROTO_2000U = 1,
	V9FS_PROTO_2000L = 2,
	V9FS_ACCESS_SINGLE = 4,
	V9FS_ACCESS_USER = 8,
	V9FS_ACCESS_CLIENT = 16,
	V9FS_POSIX_ACL = 32,
	V9FS_NO_XATTR = 64,
	V9FS_IGNORE_QV = 128,
	V9FS_DIRECT_IO = 256,
	V9FS_SYNC = 512,
};

enum p9_trans_status {
	Connected = 0,
	BeginDisconnect = 1,
	Disconnected = 2,
	Hung = 3,
};

enum packet_sock_flags {
	PACKET_SOCK_ORIGDEV = 0,
	PACKET_SOCK_AUXDATA = 1,
	PACKET_SOCK_TX_HAS_OFF = 2,
	PACKET_SOCK_TP_LOSS = 3,
	PACKET_SOCK_RUNNING = 4,
	PACKET_SOCK_PRESSURE = 5,
	PACKET_SOCK_QDISC_BYPASS = 6,
};

enum packing_op {
	PACK = 0,
	UNPACK = 1,
};

enum pad_func_e {
	IMX_SC_PAD_FUNC_SET = 15,
	IMX_SC_PAD_FUNC_GET = 16,
};

enum page_memcg_data_flags {
	MEMCG_DATA_OBJEXTS = 1,
	MEMCG_DATA_KMEM = 2,
	__NR_MEMCG_DATA_FLAGS = 4,
};

enum page_size_enum {
	__PAGE_SIZE = 4096,
};

enum page_walk_action {
	ACTION_SUBTREE = 0,
	ACTION_CONTINUE = 1,
	ACTION_AGAIN = 2,
};

enum page_walk_lock {
	PGWALK_RDLOCK = 0,
	PGWALK_WRLOCK = 1,
	PGWALK_WRLOCK_VERIFY = 2,
	PGWALK_VMA_RDLOCK_VERIFY = 3,
};

enum pageblock_bits {
	PB_migrate_0 = 0,
	PB_migrate_1 = 1,
	PB_migrate_2 = 2,
	PB_compact_skip = 3,
	PB_migrate_isolate = 4,
	__NR_PAGEBLOCK_BITS = 5,
};

enum pageflags {
	PG_locked = 0,
	PG_writeback = 1,
	PG_referenced = 2,
	PG_uptodate = 3,
	PG_dirty = 4,
	PG_lru = 5,
	PG_head = 6,
	PG_waiters = 7,
	PG_active = 8,
	PG_workingset = 9,
	PG_owner_priv_1 = 10,
	PG_owner_2 = 11,
	PG_arch_1 = 12,
	PG_reserved = 13,
	PG_private = 14,
	PG_private_2 = 15,
	PG_reclaim = 16,
	PG_swapbacked = 17,
	PG_unevictable = 18,
	PG_dropbehind = 19,
	PG_mlocked = 20,
	PG_hwpoison = 21,
	PG_arch_2 = 22,
	PG_arch_3 = 23,
	__NR_PAGEFLAGS = 24,
	PG_readahead = 16,
	PG_swapcache = 10,
	PG_checked = 10,
	PG_anon_exclusive = 11,
	PG_mappedtodisk = 11,
	PG_fscache = 15,
	PG_pinned = 10,
	PG_savepinned = 4,
	PG_foreign = 10,
	PG_xen_remapped = 10,
	PG_movable_ops_isolated = 16,
	PG_movable_ops = 3,
	PG_reported = 3,
	PG_vmemmap_self_hosted = 10,
	PG_has_hwpoisoned = 8,
	PG_large_rmappable = 9,
	PG_partially_mapped = 16,
};

enum pagetype {
	PGTY_buddy = 240,
	PGTY_offline = 241,
	PGTY_table = 242,
	PGTY_guard = 243,
	PGTY_hugetlb = 244,
	PGTY_slab = 245,
	PGTY_zsmalloc = 246,
	PGTY_unaccepted = 247,
	PGTY_large_kmalloc = 248,
	PGTY_mapcount_underflow = 255,
};

enum partition_cmd {
	partcmd_enable = 0,
	partcmd_enablei = 1,
	partcmd_disable = 2,
	partcmd_update = 3,
	partcmd_invalidate = 4,
};

enum passtype {
	PASS_SCAN = 0,
	PASS_REVOKE = 1,
	PASS_REPLAY = 2,
};

enum pb_isolate_mode {
	PB_ISOLATE_MODE_MEM_OFFLINE = 0,
	PB_ISOLATE_MODE_CMA_ALLOC = 1,
	PB_ISOLATE_MODE_OTHER = 2,
};

enum pca9450_chip_type {
	PCA9450_TYPE_PCA9450A = 0,
	PCA9450_TYPE_PCA9450BC = 1,
	PCA9450_TYPE_PCA9451A = 2,
	PCA9450_TYPE_PCA9452 = 3,
	PCA9450_TYPE_AMOUNT = 4,
};

enum pce_status {
	PCE_STATUS_NONE = 0,
	PCE_STATUS_ACQUIRED = 1,
	PCE_STATUS_PREPARED = 2,
	PCE_STATUS_ENABLED = 3,
	PCE_STATUS_ERROR = 4,
};

enum pci_bar_type {
	pci_bar_unknown = 0,
	pci_bar_io = 1,
	pci_bar_mem32 = 2,
	pci_bar_mem64 = 3,
};

enum pci_barno {
	NO_BAR = -1,
	BAR_0 = 0,
	BAR_1 = 1,
	BAR_2 = 2,
	BAR_3 = 3,
	BAR_4 = 4,
	BAR_5 = 5,
};

enum pci_board_num_t {
	pbn_default = 0,
	pbn_b0_1_115200 = 1,
	pbn_b0_2_115200 = 2,
	pbn_b0_4_115200 = 3,
	pbn_b0_5_115200 = 4,
	pbn_b0_8_115200 = 5,
	pbn_b0_1_921600 = 6,
	pbn_b0_2_921600 = 7,
	pbn_b0_4_921600 = 8,
	pbn_b0_2_1130000 = 9,
	pbn_b0_4_1152000 = 10,
	pbn_b0_4_1250000 = 11,
	pbn_b0_2_1843200 = 12,
	pbn_b0_4_1843200 = 13,
	pbn_b0_1_15625000 = 14,
	pbn_b0_bt_1_115200 = 15,
	pbn_b0_bt_2_115200 = 16,
	pbn_b0_bt_4_115200 = 17,
	pbn_b0_bt_8_115200 = 18,
	pbn_b0_bt_1_460800 = 19,
	pbn_b0_bt_2_460800 = 20,
	pbn_b0_bt_4_460800 = 21,
	pbn_b0_bt_1_921600 = 22,
	pbn_b0_bt_2_921600 = 23,
	pbn_b0_bt_4_921600 = 24,
	pbn_b0_bt_8_921600 = 25,
	pbn_b1_1_115200 = 26,
	pbn_b1_2_115200 = 27,
	pbn_b1_4_115200 = 28,
	pbn_b1_8_115200 = 29,
	pbn_b1_16_115200 = 30,
	pbn_b1_1_921600 = 31,
	pbn_b1_2_921600 = 32,
	pbn_b1_4_921600 = 33,
	pbn_b1_8_921600 = 34,
	pbn_b1_2_1250000 = 35,
	pbn_b1_bt_1_115200 = 36,
	pbn_b1_bt_2_115200 = 37,
	pbn_b1_bt_4_115200 = 38,
	pbn_b1_bt_2_921600 = 39,
	pbn_b1_1_1382400 = 40,
	pbn_b1_2_1382400 = 41,
	pbn_b1_4_1382400 = 42,
	pbn_b1_8_1382400 = 43,
	pbn_b2_1_115200 = 44,
	pbn_b2_2_115200 = 45,
	pbn_b2_4_115200 = 46,
	pbn_b2_8_115200 = 47,
	pbn_b2_1_460800 = 48,
	pbn_b2_4_460800 = 49,
	pbn_b2_8_460800 = 50,
	pbn_b2_16_460800 = 51,
	pbn_b2_1_921600 = 52,
	pbn_b2_4_921600 = 53,
	pbn_b2_8_921600 = 54,
	pbn_b2_8_1152000 = 55,
	pbn_b2_bt_1_115200 = 56,
	pbn_b2_bt_2_115200 = 57,
	pbn_b2_bt_4_115200 = 58,
	pbn_b2_bt_2_921600 = 59,
	pbn_b2_bt_4_921600 = 60,
	pbn_b3_2_115200 = 61,
	pbn_b3_4_115200 = 62,
	pbn_b3_8_115200 = 63,
	pbn_b4_bt_2_921600 = 64,
	pbn_b4_bt_4_921600 = 65,
	pbn_b4_bt_8_921600 = 66,
	pbn_panacom = 67,
	pbn_panacom2 = 68,
	pbn_panacom4 = 69,
	pbn_plx_romulus = 70,
	pbn_oxsemi = 71,
	pbn_oxsemi_1_15625000 = 72,
	pbn_oxsemi_2_15625000 = 73,
	pbn_oxsemi_4_15625000 = 74,
	pbn_oxsemi_8_15625000 = 75,
	pbn_intel_i960 = 76,
	pbn_sgi_ioc3 = 77,
	pbn_computone_4 = 78,
	pbn_computone_6 = 79,
	pbn_computone_8 = 80,
	pbn_sbsxrsio = 81,
	pbn_pasemi_1682M = 82,
	pbn_ni8430_2 = 83,
	pbn_ni8430_4 = 84,
	pbn_ni8430_8 = 85,
	pbn_ni8430_16 = 86,
	pbn_ADDIDATA_PCIe_1_3906250 = 87,
	pbn_ADDIDATA_PCIe_2_3906250 = 88,
	pbn_ADDIDATA_PCIe_4_3906250 = 89,
	pbn_ADDIDATA_PCIe_8_3906250 = 90,
	pbn_ce4100_1_115200 = 91,
	pbn_omegapci = 92,
	pbn_NETMOS9900_2s_115200 = 93,
	pbn_brcm_trumanage = 94,
	pbn_fintek_4 = 95,
	pbn_fintek_8 = 96,
	pbn_fintek_12 = 97,
	pbn_fintek_F81504A = 98,
	pbn_fintek_F81508A = 99,
	pbn_fintek_F81512A = 100,
	pbn_wch382_2 = 101,
	pbn_wch384_4 = 102,
	pbn_wch384_8 = 103,
	pbn_sunix_pci_1s = 104,
	pbn_sunix_pci_2s = 105,
	pbn_sunix_pci_4s = 106,
	pbn_sunix_pci_8s = 107,
	pbn_sunix_pci_16s = 108,
	pbn_titan_1_4000000 = 109,
	pbn_titan_2_4000000 = 110,
	pbn_titan_4_4000000 = 111,
	pbn_titan_8_4000000 = 112,
	pbn_moxa_2 = 113,
	pbn_moxa_4 = 114,
	pbn_moxa_8 = 115,
};

enum pci_bus_flags {
	PCI_BUS_FLAGS_NO_MSI = 1,
	PCI_BUS_FLAGS_NO_MMRBC = 2,
	PCI_BUS_FLAGS_NO_AERSID = 4,
	PCI_BUS_FLAGS_NO_EXTCFG = 8,
};

enum pci_bus_speed {
	PCI_SPEED_33MHz = 0,
	PCI_SPEED_66MHz = 1,
	PCI_SPEED_66MHz_PCIX = 2,
	PCI_SPEED_100MHz_PCIX = 3,
	PCI_SPEED_133MHz_PCIX = 4,
	PCI_SPEED_66MHz_PCIX_ECC = 5,
	PCI_SPEED_100MHz_PCIX_ECC = 6,
	PCI_SPEED_133MHz_PCIX_ECC = 7,
	PCI_SPEED_66MHz_PCIX_266 = 9,
	PCI_SPEED_100MHz_PCIX_266 = 10,
	PCI_SPEED_133MHz_PCIX_266 = 11,
	AGP_UNKNOWN = 12,
	AGP_1X = 13,
	AGP_2X = 14,
	AGP_4X = 15,
	AGP_8X = 16,
	PCI_SPEED_66MHz_PCIX_533 = 17,
	PCI_SPEED_100MHz_PCIX_533 = 18,
	PCI_SPEED_133MHz_PCIX_533 = 19,
	PCIE_SPEED_2_5GT = 20,
	PCIE_SPEED_5_0GT = 21,
	PCIE_SPEED_8_0GT = 22,
	PCIE_SPEED_16_0GT = 23,
	PCIE_SPEED_32_0GT = 24,
	PCIE_SPEED_64_0GT = 25,
	PCI_SPEED_UNKNOWN = 255,
};

enum pci_dev_flags {
	PCI_DEV_FLAGS_MSI_INTX_DISABLE_BUG = 1,
	PCI_DEV_FLAGS_NO_D3 = 2,
	PCI_DEV_FLAGS_ASSIGNED = 4,
	PCI_DEV_FLAGS_ACS_ENABLED_QUIRK = 8,
	PCI_DEV_FLAG_PCIE_BRIDGE_ALIAS = 32,
	PCI_DEV_FLAGS_NO_BUS_RESET = 64,
	PCI_DEV_FLAGS_NO_PM_RESET = 128,
	PCI_DEV_FLAGS_VPD_REF_F0 = 256,
	PCI_DEV_FLAGS_BRIDGE_XLATE_ROOT = 512,
	PCI_DEV_FLAGS_NO_FLR_RESET = 1024,
	PCI_DEV_FLAGS_NO_RELAXED_ORDERING = 2048,
	PCI_DEV_FLAGS_HAS_MSI_MASKING = 4096,
	PCI_DEV_FLAGS_MSIX_TOUCH_ENTRY_DATA_FIRST = 8192,
};

enum pci_dev_reg_1 {
	PCI_Y2_PIG_ENA = -2147483648,
	PCI_Y2_DLL_DIS = 1073741824,
	PCI_SW_PWR_ON_RST = 1073741824,
	PCI_Y2_PHY2_COMA = 536870912,
	PCI_Y2_PHY1_COMA = 268435456,
	PCI_Y2_PHY2_POWD = 134217728,
	PCI_Y2_PHY1_POWD = 67108864,
	PCI_Y2_PME_LEGACY = 32768,
	PCI_PHY_LNK_TIM_MSK = 768,
	PCI_ENA_L1_EVENT = 128,
	PCI_ENA_GPHY_LNK = 64,
	PCI_FORCE_PEX_L1 = 32,
};

enum pci_dev_reg_2 {
	PCI_VPD_WR_THR = 4278190080,
	PCI_DEV_SEL = 16646144,
	PCI_VPD_ROM_SZ = 114688,
	PCI_PATCH_DIR = 3840,
	PCI_EXT_PATCHS = 240,
	PCI_EN_DUMMY_RD = 8,
	PCI_REV_DESC = 4,
	PCI_USEDATA64 = 1,
};

enum pci_dev_reg_3 {
	P_CLK_ASF_REGS_DIS = 262144,
	P_CLK_COR_REGS_D0_DIS = 131072,
	P_CLK_MACSEC_DIS = 131072,
	P_CLK_PCI_REGS_D0_DIS = 65536,
	P_CLK_COR_YTB_ARB_DIS = 32768,
	P_CLK_MAC_LNK1_D3_DIS = 16384,
	P_CLK_COR_LNK1_D0_DIS = 8192,
	P_CLK_MAC_LNK1_D0_DIS = 4096,
	P_CLK_COR_LNK1_D3_DIS = 2048,
	P_CLK_PCI_MST_ARB_DIS = 1024,
	P_CLK_COR_REGS_D3_DIS = 512,
	P_CLK_PCI_REGS_D3_DIS = 256,
	P_CLK_REF_LNK1_GM_DIS = 128,
	P_CLK_COR_LNK1_GM_DIS = 64,
	P_CLK_PCI_COMMON_DIS = 32,
	P_CLK_COR_COMMON_DIS = 16,
	P_CLK_PCI_LNK1_BMU_DIS = 8,
	P_CLK_COR_LNK1_BMU_DIS = 4,
	P_CLK_PCI_LNK1_BIU_DIS = 2,
	P_CLK_COR_LNK1_BIU_DIS = 1,
	PCIE_OUR3_WOL_D3_COLD_SET = 406548,
};

enum pci_dev_reg_4 {
	P_PEX_LTSSM_STAT_MSK = 4261412864,
	P_PEX_LTSSM_L1_STAT = 52,
	P_PEX_LTSSM_DET_STAT = 1,
	P_TIMER_VALUE_MSK = 16711680,
	P_FORCE_ASPM_REQUEST = 32768,
	P_ASPM_GPHY_LINK_DOWN = 16384,
	P_ASPM_INT_FIFO_EMPTY = 8192,
	P_ASPM_CLKRUN_REQUEST = 4096,
	P_ASPM_FORCE_CLKREQ_ENA = 16,
	P_ASPM_CLKREQ_PAD_CTL = 8,
	P_ASPM_A1_MODE_SELECT = 4,
	P_CLK_GATE_PEX_UNIT_ENA = 2,
	P_CLK_GATE_ROOT_COR_ENA = 1,
	P_ASPM_CONTROL_MSK = 61440,
};

enum pci_dev_reg_5 {
	P_CTL_DIV_CORE_CLK_ENA = -2147483648,
	P_CTL_SRESET_VMAIN_AV = 1073741824,
	P_CTL_BYPASS_VMAIN_AV = 536870912,
	P_CTL_TIM_VMAIN_AV_MSK = 402653184,
	P_REL_PCIE_RST_DE_ASS = 67108864,
	P_REL_GPHY_REC_PACKET = 33554432,
	P_REL_INT_FIFO_N_EMPTY = 16777216,
	P_REL_MAIN_PWR_AVAIL = 8388608,
	P_REL_CLKRUN_REQ_REL = 4194304,
	P_REL_PCIE_RESET_ASS = 2097152,
	P_REL_PME_ASSERTED = 1048576,
	P_REL_PCIE_EXIT_L1_ST = 524288,
	P_REL_LOADER_NOT_FIN = 262144,
	P_REL_PCIE_RX_EX_IDLE = 131072,
	P_REL_GPHY_LINK_UP = 65536,
	P_GAT_PCIE_RST_ASSERTED = 1024,
	P_GAT_GPHY_N_REC_PACKET = 512,
	P_GAT_INT_FIFO_EMPTY = 256,
	P_GAT_MAIN_PWR_N_AVAIL = 128,
	P_GAT_CLKRUN_REQ_REL = 64,
	P_GAT_PCIE_RESET_ASS = 32,
	P_GAT_PME_DE_ASSERTED = 16,
	P_GAT_PCIE_ENTER_L1_ST = 8,
	P_GAT_LOADER_FINISHED = 4,
	P_GAT_PCIE_RX_EL_IDLE = 2,
	P_GAT_GPHY_LINK_DOWN = 1,
	PCIE_OUR5_EVENT_CLK_D3_SET = 50987786,
};

enum pci_epc_bar_type {
	BAR_PROGRAMMABLE = 0,
	BAR_FIXED = 1,
	BAR_RESIZABLE = 2,
	BAR_RESERVED = 3,
};

enum pci_epc_interface_type {
	UNKNOWN_INTERFACE = -1,
	PRIMARY_INTERFACE = 0,
	SECONDARY_INTERFACE = 1,
};

enum pci_ers_result {
	PCI_ERS_RESULT_NONE = 1,
	PCI_ERS_RESULT_CAN_RECOVER = 2,
	PCI_ERS_RESULT_NEED_RESET = 3,
	PCI_ERS_RESULT_DISCONNECT = 4,
	PCI_ERS_RESULT_RECOVERED = 5,
	PCI_ERS_RESULT_NO_AER_DRIVER = 6,
};

enum pci_fixup_pass {
	pci_fixup_early = 0,
	pci_fixup_header = 1,
	pci_fixup_final = 2,
	pci_fixup_enable = 3,
	pci_fixup_resume = 4,
	pci_fixup_suspend = 5,
	pci_fixup_resume_early = 6,
	pci_fixup_suspend_late = 7,
};

enum pci_interrupt_pin {
	PCI_INTERRUPT_UNKNOWN = 0,
	PCI_INTERRUPT_INTA = 1,
	PCI_INTERRUPT_INTB = 2,
	PCI_INTERRUPT_INTC = 3,
	PCI_INTERRUPT_INTD = 4,
};

enum pci_mmap_api {
	PCI_MMAP_SYSFS = 0,
	PCI_MMAP_PROCFS = 1,
};

enum pci_mmap_state {
	pci_mmap_io = 0,
	pci_mmap_mem = 1,
};

enum pci_p2pdma_map_type {
	PCI_P2PDMA_MAP_UNKNOWN = 0,
	PCI_P2PDMA_MAP_NONE = 1,
	PCI_P2PDMA_MAP_NOT_SUPPORTED = 2,
	PCI_P2PDMA_MAP_BUS_ADDR = 3,
	PCI_P2PDMA_MAP_THRU_HOST_BRIDGE = 4,
};

enum pcie_bus_config_types {
	PCIE_BUS_TUNE_OFF = 0,
	PCIE_BUS_DEFAULT = 1,
	PCIE_BUS_SAFE = 2,
	PCIE_BUS_PERFORMANCE = 3,
	PCIE_BUS_PEER2PEER = 4,
};

enum pcie_kirin_phy_type {
	PCIE_KIRIN_INTERNAL_PHY = 0,
	PCIE_KIRIN_EXTERNAL_PHY = 1,
};

enum pcie_link_width {
	PCIE_LNK_WIDTH_RESRV = 0,
	PCIE_LNK_X1 = 1,
	PCIE_LNK_X2 = 2,
	PCIE_LNK_X4 = 4,
	PCIE_LNK_X8 = 8,
	PCIE_LNK_X12 = 12,
	PCIE_LNK_X16 = 16,
	PCIE_LNK_X32 = 32,
	PCIE_LNK_WIDTH_UNKNOWN = 255,
};

enum pcie_reset_state {
	pcie_deassert_reset = 1,
	pcie_warm_reset = 2,
	pcie_hot_reset = 3,
};

enum pcim_addr_devres_type {
	PCIM_ADDR_DEVRES_TYPE_INVALID = 0,
	PCIM_ADDR_DEVRES_TYPE_REGION = 1,
	PCIM_ADDR_DEVRES_TYPE_REGION_MAPPING = 2,
	PCIM_ADDR_DEVRES_TYPE_MAPPING = 3,
};

enum pcpu_fc {
	PCPU_FC_AUTO = 0,
	PCPU_FC_EMBED = 1,
	PCPU_FC_PAGE = 2,
	PCPU_FC_NR = 3,
};

enum pdc_irq_config_bits {
	PDC_LEVEL_LOW = 0,
	PDC_EDGE_FALLING = 2,
	PDC_LEVEL_HIGH = 4,
	PDC_EDGE_RISING = 6,
	PDC_EDGE_DUAL = 7,
};

enum pedit_cmd {
	TCA_PEDIT_KEY_EX_CMD_SET = 0,
	TCA_PEDIT_KEY_EX_CMD_ADD = 1,
	__PEDIT_CMD_MAX = 2,
};

enum pedit_header_type {
	TCA_PEDIT_KEY_EX_HDR_TYPE_NETWORK = 0,
	TCA_PEDIT_KEY_EX_HDR_TYPE_ETH = 1,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP4 = 2,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP6 = 3,
	TCA_PEDIT_KEY_EX_HDR_TYPE_TCP = 4,
	TCA_PEDIT_KEY_EX_HDR_TYPE_UDP = 5,
	__PEDIT_HDR_TYPE_MAX = 6,
};

enum perf_addr_filter_action_t {
	PERF_ADDR_FILTER_ACTION_STOP = 0,
	PERF_ADDR_FILTER_ACTION_START = 1,
	PERF_ADDR_FILTER_ACTION_FILTER = 2,
};

enum perf_bpf_event_type {
	PERF_BPF_EVENT_UNKNOWN = 0,
	PERF_BPF_EVENT_PROG_LOAD = 1,
	PERF_BPF_EVENT_PROG_UNLOAD = 2,
	PERF_BPF_EVENT_MAX = 3,
};

enum perf_branch_sample_type {
	PERF_SAMPLE_BRANCH_USER = 1,
	PERF_SAMPLE_BRANCH_KERNEL = 2,
	PERF_SAMPLE_BRANCH_HV = 4,
	PERF_SAMPLE_BRANCH_ANY = 8,
	PERF_SAMPLE_BRANCH_ANY_CALL = 16,
	PERF_SAMPLE_BRANCH_ANY_RETURN = 32,
	PERF_SAMPLE_BRANCH_IND_CALL = 64,
	PERF_SAMPLE_BRANCH_ABORT_TX = 128,
	PERF_SAMPLE_BRANCH_IN_TX = 256,
	PERF_SAMPLE_BRANCH_NO_TX = 512,
	PERF_SAMPLE_BRANCH_COND = 1024,
	PERF_SAMPLE_BRANCH_CALL_STACK = 2048,
	PERF_SAMPLE_BRANCH_IND_JUMP = 4096,
	PERF_SAMPLE_BRANCH_CALL = 8192,
	PERF_SAMPLE_BRANCH_NO_FLAGS = 16384,
	PERF_SAMPLE_BRANCH_NO_CYCLES = 32768,
	PERF_SAMPLE_BRANCH_TYPE_SAVE = 65536,
	PERF_SAMPLE_BRANCH_HW_INDEX = 131072,
	PERF_SAMPLE_BRANCH_PRIV_SAVE = 262144,
	PERF_SAMPLE_BRANCH_COUNTERS = 524288,
	PERF_SAMPLE_BRANCH_MAX = 1048576,
};

enum perf_callchain_context {
	PERF_CONTEXT_HV = 18446744073709551584ULL,
	PERF_CONTEXT_KERNEL = 18446744073709551488ULL,
	PERF_CONTEXT_USER = 18446744073709551104ULL,
	PERF_CONTEXT_GUEST = 18446744073709549568ULL,
	PERF_CONTEXT_GUEST_KERNEL = 18446744073709549440ULL,
	PERF_CONTEXT_GUEST_USER = 18446744073709549056ULL,
	PERF_CONTEXT_MAX = 18446744073709547521ULL,
};

enum perf_event_arm_regs {
	PERF_REG_ARM64_X0 = 0,
	PERF_REG_ARM64_X1 = 1,
	PERF_REG_ARM64_X2 = 2,
	PERF_REG_ARM64_X3 = 3,
	PERF_REG_ARM64_X4 = 4,
	PERF_REG_ARM64_X5 = 5,
	PERF_REG_ARM64_X6 = 6,
	PERF_REG_ARM64_X7 = 7,
	PERF_REG_ARM64_X8 = 8,
	PERF_REG_ARM64_X9 = 9,
	PERF_REG_ARM64_X10 = 10,
	PERF_REG_ARM64_X11 = 11,
	PERF_REG_ARM64_X12 = 12,
	PERF_REG_ARM64_X13 = 13,
	PERF_REG_ARM64_X14 = 14,
	PERF_REG_ARM64_X15 = 15,
	PERF_REG_ARM64_X16 = 16,
	PERF_REG_ARM64_X17 = 17,
	PERF_REG_ARM64_X18 = 18,
	PERF_REG_ARM64_X19 = 19,
	PERF_REG_ARM64_X20 = 20,
	PERF_REG_ARM64_X21 = 21,
	PERF_REG_ARM64_X22 = 22,
	PERF_REG_ARM64_X23 = 23,
	PERF_REG_ARM64_X24 = 24,
	PERF_REG_ARM64_X25 = 25,
	PERF_REG_ARM64_X26 = 26,
	PERF_REG_ARM64_X27 = 27,
	PERF_REG_ARM64_X28 = 28,
	PERF_REG_ARM64_X29 = 29,
	PERF_REG_ARM64_LR = 30,
	PERF_REG_ARM64_SP = 31,
	PERF_REG_ARM64_PC = 32,
	PERF_REG_ARM64_MAX = 33,
	PERF_REG_ARM64_VG = 46,
	PERF_REG_ARM64_EXTENDED_MAX = 47,
};

enum perf_event_ioc_flags {
	PERF_IOC_FLAG_GROUP = 1,
};

enum perf_event_read_format {
	PERF_FORMAT_TOTAL_TIME_ENABLED = 1,
	PERF_FORMAT_TOTAL_TIME_RUNNING = 2,
	PERF_FORMAT_ID = 4,
	PERF_FORMAT_GROUP = 8,
	PERF_FORMAT_LOST = 16,
	PERF_FORMAT_MAX = 32,
};

enum perf_event_sample_format {
	PERF_SAMPLE_IP = 1,
	PERF_SAMPLE_TID = 2,
	PERF_SAMPLE_TIME = 4,
	PERF_SAMPLE_ADDR = 8,
	PERF_SAMPLE_READ = 16,
	PERF_SAMPLE_CALLCHAIN = 32,
	PERF_SAMPLE_ID = 64,
	PERF_SAMPLE_CPU = 128,
	PERF_SAMPLE_PERIOD = 256,
	PERF_SAMPLE_STREAM_ID = 512,
	PERF_SAMPLE_RAW = 1024,
	PERF_SAMPLE_BRANCH_STACK = 2048,
	PERF_SAMPLE_REGS_USER = 4096,
	PERF_SAMPLE_STACK_USER = 8192,
	PERF_SAMPLE_WEIGHT = 16384,
	PERF_SAMPLE_DATA_SRC = 32768,
	PERF_SAMPLE_IDENTIFIER = 65536,
	PERF_SAMPLE_TRANSACTION = 131072,
	PERF_SAMPLE_REGS_INTR = 262144,
	PERF_SAMPLE_PHYS_ADDR = 524288,
	PERF_SAMPLE_AUX = 1048576,
	PERF_SAMPLE_CGROUP = 2097152,
	PERF_SAMPLE_DATA_PAGE_SIZE = 4194304,
	PERF_SAMPLE_CODE_PAGE_SIZE = 8388608,
	PERF_SAMPLE_WEIGHT_STRUCT = 16777216,
	PERF_SAMPLE_MAX = 33554432,
};

enum perf_event_state {
	PERF_EVENT_STATE_DEAD = -5,
	PERF_EVENT_STATE_REVOKED = -4,
	PERF_EVENT_STATE_EXIT = -3,
	PERF_EVENT_STATE_ERROR = -2,
	PERF_EVENT_STATE_OFF = -1,
	PERF_EVENT_STATE_INACTIVE = 0,
	PERF_EVENT_STATE_ACTIVE = 1,
};

enum perf_event_task_context {
	perf_invalid_context = -1,
	perf_hw_context = 0,
	perf_sw_context = 1,
	perf_nr_task_contexts = 2,
};

enum perf_event_type {
	PERF_RECORD_MMAP = 1,
	PERF_RECORD_LOST = 2,
	PERF_RECORD_COMM = 3,
	PERF_RECORD_EXIT = 4,
	PERF_RECORD_THROTTLE = 5,
	PERF_RECORD_UNTHROTTLE = 6,
	PERF_RECORD_FORK = 7,
	PERF_RECORD_READ = 8,
	PERF_RECORD_SAMPLE = 9,
	PERF_RECORD_MMAP2 = 10,
	PERF_RECORD_AUX = 11,
	PERF_RECORD_ITRACE_START = 12,
	PERF_RECORD_LOST_SAMPLES = 13,
	PERF_RECORD_SWITCH = 14,
	PERF_RECORD_SWITCH_CPU_WIDE = 15,
	PERF_RECORD_NAMESPACES = 16,
	PERF_RECORD_KSYMBOL = 17,
	PERF_RECORD_BPF_EVENT = 18,
	PERF_RECORD_CGROUP = 19,
	PERF_RECORD_TEXT_POKE = 20,
	PERF_RECORD_AUX_OUTPUT_HW_ID = 21,
	PERF_RECORD_MAX = 22,
};

enum perf_hw_cache_id {
	PERF_COUNT_HW_CACHE_L1D = 0,
	PERF_COUNT_HW_CACHE_L1I = 1,
	PERF_COUNT_HW_CACHE_LL = 2,
	PERF_COUNT_HW_CACHE_DTLB = 3,
	PERF_COUNT_HW_CACHE_ITLB = 4,
	PERF_COUNT_HW_CACHE_BPU = 5,
	PERF_COUNT_HW_CACHE_NODE = 6,
	PERF_COUNT_HW_CACHE_MAX = 7,
};

enum perf_hw_cache_op_id {
	PERF_COUNT_HW_CACHE_OP_READ = 0,
	PERF_COUNT_HW_CACHE_OP_WRITE = 1,
	PERF_COUNT_HW_CACHE_OP_PREFETCH = 2,
	PERF_COUNT_HW_CACHE_OP_MAX = 3,
};

enum perf_hw_cache_op_result_id {
	PERF_COUNT_HW_CACHE_RESULT_ACCESS = 0,
	PERF_COUNT_HW_CACHE_RESULT_MISS = 1,
	PERF_COUNT_HW_CACHE_RESULT_MAX = 2,
};

enum perf_hw_id {
	PERF_COUNT_HW_CPU_CYCLES = 0,
	PERF_COUNT_HW_INSTRUCTIONS = 1,
	PERF_COUNT_HW_CACHE_REFERENCES = 2,
	PERF_COUNT_HW_CACHE_MISSES = 3,
	PERF_COUNT_HW_BRANCH_INSTRUCTIONS = 4,
	PERF_COUNT_HW_BRANCH_MISSES = 5,
	PERF_COUNT_HW_BUS_CYCLES = 6,
	PERF_COUNT_HW_STALLED_CYCLES_FRONTEND = 7,
	PERF_COUNT_HW_STALLED_CYCLES_BACKEND = 8,
	PERF_COUNT_HW_REF_CPU_CYCLES = 9,
	PERF_COUNT_HW_MAX = 10,
};

enum perf_pmu_scope {
	PERF_PMU_SCOPE_NONE = 0,
	PERF_PMU_SCOPE_CORE = 1,
	PERF_PMU_SCOPE_DIE = 2,
	PERF_PMU_SCOPE_CLUSTER = 3,
	PERF_PMU_SCOPE_PKG = 4,
	PERF_PMU_SCOPE_SYS_WIDE = 5,
	PERF_PMU_MAX_SCOPE = 6,
};

enum perf_record_ksymbol_type {
	PERF_RECORD_KSYMBOL_TYPE_UNKNOWN = 0,
	PERF_RECORD_KSYMBOL_TYPE_BPF = 1,
	PERF_RECORD_KSYMBOL_TYPE_OOL = 2,
	PERF_RECORD_KSYMBOL_TYPE_MAX = 3,
};

enum perf_sample_regs_abi {
	PERF_SAMPLE_REGS_ABI_NONE = 0,
	PERF_SAMPLE_REGS_ABI_32 = 1,
	PERF_SAMPLE_REGS_ABI_64 = 2,
};

enum perf_sw_ids {
	PERF_COUNT_SW_CPU_CLOCK = 0,
	PERF_COUNT_SW_TASK_CLOCK = 1,
	PERF_COUNT_SW_PAGE_FAULTS = 2,
	PERF_COUNT_SW_CONTEXT_SWITCHES = 3,
	PERF_COUNT_SW_CPU_MIGRATIONS = 4,
	PERF_COUNT_SW_PAGE_FAULTS_MIN = 5,
	PERF_COUNT_SW_PAGE_FAULTS_MAJ = 6,
	PERF_COUNT_SW_ALIGNMENT_FAULTS = 7,
	PERF_COUNT_SW_EMULATION_FAULTS = 8,
	PERF_COUNT_SW_DUMMY = 9,
	PERF_COUNT_SW_BPF_OUTPUT = 10,
	PERF_COUNT_SW_CGROUP_SWITCHES = 11,
	PERF_COUNT_SW_MAX = 12,
};

enum perf_type_id {
	PERF_TYPE_HARDWARE = 0,
	PERF_TYPE_SOFTWARE = 1,
	PERF_TYPE_TRACEPOINT = 2,
	PERF_TYPE_HW_CACHE = 3,
	PERF_TYPE_RAW = 4,
	PERF_TYPE_BREAKPOINT = 5,
	PERF_TYPE_MAX = 6,
};

enum pf8x00_buck_states {
	SW_CONFIG1 = 0,
	SW_CONFIG2 = 1,
	SW_PWRUP = 2,
	SW_MODE1 = 3,
	SW_RUN_VOLT = 4,
	SW_STBY_VOLT = 5,
};

enum pf8x00_devid {
	PF8100 = 0,
	PF8121A = 2,
	PF8200 = 8,
};

enum pf8x00_regulators {
	PF8X00_LDO1 = 0,
	PF8X00_LDO2 = 1,
	PF8X00_LDO3 = 2,
	PF8X00_LDO4 = 3,
	PF8X00_BUCK1 = 4,
	PF8X00_BUCK2 = 5,
	PF8X00_BUCK3 = 6,
	PF8X00_BUCK4 = 7,
	PF8X00_BUCK5 = 8,
	PF8X00_BUCK6 = 9,
	PF8X00_BUCK7 = 10,
	PF8X00_VSNVS = 11,
	PF8X00_MAX_REGULATORS = 12,
};

enum pg_states {
	PG_STATE_OFF = 0,
	PG_STATE_ON = 1,
	PG_STATE_RUNNING = 2,
};

enum pgdat_flags {
	PGDAT_DIRTY = 0,
	PGDAT_WRITEBACK = 1,
	PGDAT_RECLAIM_LOCKED = 2,
};

enum pgt_entry {
	NORMAL_PMD = 0,
	HPAGE_PMD = 1,
	NORMAL_PUD = 2,
	HPAGE_PUD = 3,
};

enum pgtable_level {
	PGTABLE_LEVEL_PTE = 0,
	PGTABLE_LEVEL_PMD = 1,
	PGTABLE_LEVEL_PUD = 2,
	PGTABLE_LEVEL_P4D = 3,
	PGTABLE_LEVEL_PGD = 4,
};

enum pgtable_type {
	TABLE_PTE = 0,
	TABLE_PMD = 1,
	TABLE_PUD = 2,
	TABLE_P4D = 3,
};

enum phy_event {
	PHYE_LOSS_OF_SIGNAL = 0,
	PHYE_OOB_DONE = 1,
	PHYE_OOB_ERROR = 2,
	PHYE_SPINUP_HOLD = 3,
	PHYE_RESUME_TIMEOUT = 4,
	PHYE_SHUTDOWN = 5,
	PHY_NUM_EVENTS = 6,
};

enum phy_func {
	PHY_FUNC_NOP = 0,
	PHY_FUNC_LINK_RESET = 1,
	PHY_FUNC_HARD_RESET = 2,
	PHY_FUNC_DISABLE = 3,
	PHY_FUNC_CLEAR_ERROR_LOG = 5,
	PHY_FUNC_CLEAR_AFFIL = 6,
	PHY_FUNC_TX_SATA_PS_SIGNAL = 7,
	PHY_FUNC_RELEASE_SPINUP_HOLD = 16,
	PHY_FUNC_SET_LINK_RATE = 17,
	PHY_FUNC_GET_EVENTS = 18,
};

enum phy_led_modes {
	PHY_LED_ACTIVE_HIGH = 0,
	PHY_LED_ACTIVE_LOW = 1,
	PHY_LED_INACTIVE_HIGH_IMPEDANCE = 2,
	__PHY_LED_MODES_NUM = 3,
};

enum phy_media {
	PHY_MEDIA_DEFAULT = 0,
	PHY_MEDIA_SR = 1,
	PHY_MEDIA_DAC = 2,
};

enum phy_mode {
	PHY_MODE_INVALID = 0,
	PHY_MODE_USB_HOST = 1,
	PHY_MODE_USB_HOST_LS = 2,
	PHY_MODE_USB_HOST_FS = 3,
	PHY_MODE_USB_HOST_HS = 4,
	PHY_MODE_USB_HOST_SS = 5,
	PHY_MODE_USB_DEVICE = 6,
	PHY_MODE_USB_DEVICE_LS = 7,
	PHY_MODE_USB_DEVICE_FS = 8,
	PHY_MODE_USB_DEVICE_HS = 9,
	PHY_MODE_USB_DEVICE_SS = 10,
	PHY_MODE_USB_OTG = 11,
	PHY_MODE_UFS_HS_A = 12,
	PHY_MODE_UFS_HS_B = 13,
	PHY_MODE_PCIE = 14,
	PHY_MODE_ETHERNET = 15,
	PHY_MODE_MIPI_DPHY = 16,
	PHY_MODE_SATA = 17,
	PHY_MODE_LVDS = 18,
	PHY_MODE_DP = 19,
	PHY_MODE_HDMI = 20,
};

enum phy_reset_delays {
	PRE_DELAY = 0,
	PULSE = 1,
	POST_DELAY = 2,
	DELAYS_NUM = 3,
};

enum phy_state {
	PHY_DOWN = 0,
	PHY_READY = 1,
	PHY_HALTED = 2,
	PHY_ERROR = 3,
	PHY_UP = 4,
	PHY_RUNNING = 5,
	PHY_NOLINK = 6,
	PHY_CABLETEST = 7,
};

enum phy_state_work {
	PHY_STATE_WORK_NONE = 0,
	PHY_STATE_WORK_ANEG = 1,
	PHY_STATE_WORK_SUSPEND = 2,
};

enum phy_tunable_id {
	ETHTOOL_PHY_ID_UNSPEC = 0,
	ETHTOOL_PHY_DOWNSHIFT = 1,
	ETHTOOL_PHY_FAST_LINK_DOWN = 2,
	ETHTOOL_PHY_EDPD = 3,
	__ETHTOOL_PHY_TUNABLE_COUNT = 4,
};

enum phy_upstream {
	PHY_UPSTREAM_MAC = 0,
	PHY_UPSTREAM_PHY = 1,
};

enum phylink_op_type {
	PHYLINK_NETDEV = 0,
	PHYLINK_DEV = 1,
};

enum pid_type {
	PIDTYPE_PID = 0,
	PIDTYPE_TGID = 1,
	PIDTYPE_PGID = 2,
	PIDTYPE_SID = 3,
	PIDTYPE_MAX = 4,
};

enum pidcg_event {
	PIDCG_MAX = 0,
	PIDCG_FORKFAIL = 1,
	NR_PIDCG_EVENTS = 2,
};

enum pin_config_param {
	PIN_CONFIG_BIAS_BUS_HOLD = 0,
	PIN_CONFIG_BIAS_DISABLE = 1,
	PIN_CONFIG_BIAS_HIGH_IMPEDANCE = 2,
	PIN_CONFIG_BIAS_PULL_DOWN = 3,
	PIN_CONFIG_BIAS_PULL_PIN_DEFAULT = 4,
	PIN_CONFIG_BIAS_PULL_UP = 5,
	PIN_CONFIG_DRIVE_OPEN_DRAIN = 6,
	PIN_CONFIG_DRIVE_OPEN_SOURCE = 7,
	PIN_CONFIG_DRIVE_PUSH_PULL = 8,
	PIN_CONFIG_DRIVE_STRENGTH = 9,
	PIN_CONFIG_DRIVE_STRENGTH_UA = 10,
	PIN_CONFIG_INPUT_DEBOUNCE = 11,
	PIN_CONFIG_INPUT_ENABLE = 12,
	PIN_CONFIG_INPUT_SCHMITT = 13,
	PIN_CONFIG_INPUT_SCHMITT_ENABLE = 14,
	PIN_CONFIG_INPUT_SCHMITT_UV = 15,
	PIN_CONFIG_MODE_LOW_POWER = 16,
	PIN_CONFIG_MODE_PWM = 17,
	PIN_CONFIG_LEVEL = 18,
	PIN_CONFIG_OUTPUT_ENABLE = 19,
	PIN_CONFIG_OUTPUT_IMPEDANCE_OHMS = 20,
	PIN_CONFIG_PERSIST_STATE = 21,
	PIN_CONFIG_POWER_SOURCE = 22,
	PIN_CONFIG_SKEW_DELAY = 23,
	PIN_CONFIG_SLEEP_HARDWARE_STATE = 24,
	PIN_CONFIG_SLEW_RATE = 25,
	PIN_CONFIG_END = 127,
	PIN_CONFIG_MAX = 255,
};

enum pincfg_type {
	PINCFG_TYPE_FUNC = 0,
	PINCFG_TYPE_DAT = 1,
	PINCFG_TYPE_PUD = 2,
	PINCFG_TYPE_DRV = 3,
	PINCFG_TYPE_CON_PDN = 4,
	PINCFG_TYPE_PUD_PDN = 5,
	PINCFG_TYPE_NUM = 6,
};

enum pinctrl_map_type {
	PIN_MAP_TYPE_INVALID = 0,
	PIN_MAP_TYPE_DUMMY_STATE = 1,
	PIN_MAP_TYPE_MUX_GROUP = 2,
	PIN_MAP_TYPE_CONFIGS_PIN = 3,
	PIN_MAP_TYPE_CONFIGS_GROUP = 4,
};

enum pkt_hash_types {
	PKT_HASH_TYPE_NONE = 0,
	PKT_HASH_TYPE_L2 = 1,
	PKT_HASH_TYPE_L3 = 2,
	PKT_HASH_TYPE_L4 = 3,
};

enum pkvm_component_id {
	PKVM_ID_HOST = 0,
	PKVM_ID_HYP = 1,
	PKVM_ID_FFA = 2,
};

enum pkvm_page_state {
	PKVM_PAGE_OWNED = 0,
	PKVM_PAGE_SHARED_OWNED = 1,
	PKVM_PAGE_SHARED_BORROWED = 2,
	PKVM_NOPAGE = 3,
};

enum pl011_rs485_tx_state {
	OFF___2 = 0,
	WAIT_AFTER_RTS___2 = 1,
	SEND___2 = 2,
	WAIT_AFTER_SEND___2 = 3,
};

enum pl330_byteswap {
	SWAP_NO = 0,
	SWAP_2 = 1,
	SWAP_4 = 2,
	SWAP_8 = 3,
	SWAP_16 = 4,
};

enum pl330_cachectrl {
	CCTRL0 = 0,
	CCTRL1 = 1,
	CCTRL2 = 2,
	CCTRL3 = 3,
	INVALID1 = 4,
	INVALID2 = 5,
	CCTRL6 = 6,
	CCTRL7 = 7,
};

enum pl330_cond {
	SINGLE = 0,
	BURST = 1,
	ALWAYS = 2,
};

enum pl330_dmac_state {
	UNINIT___2 = 0,
	INIT = 1,
	DYING = 2,
};

enum pl330_op_err {
	PL330_ERR_NONE = 0,
	PL330_ERR_ABORT = 1,
	PL330_ERR_FAIL = 2,
};

enum pll_ctrl_bits {
	PLL_RESETB = 0,
	SSPLL_SUSPEND_EN = 1,
	PLL_SEQ_START = 2,
	PLL_LOCK = 3,
};

enum pll_mode {
	PLL_MODE_INT = 0,
	PLL_MODE_FRAC = 1,
	PLL_MODE_ERROR = 2,
};

enum pm_api_cb_id {
	PM_INIT_SUSPEND_CB = 30,
	PM_ACKNOWLEDGE_CB = 31,
	PM_NOTIFY_CB = 32,
};

enum pm_api_id {
	PM_API_FEATURES = 0,
	PM_GET_API_VERSION = 1,
	PM_REGISTER_NOTIFIER = 5,
	PM_FORCE_POWERDOWN = 8,
	PM_REQUEST_WAKEUP = 10,
	PM_SYSTEM_SHUTDOWN = 12,
	PM_REQUEST_NODE = 13,
	PM_RELEASE_NODE = 14,
	PM_SET_REQUIREMENT = 15,
	PM_RESET_ASSERT = 17,
	PM_RESET_GET_STATUS = 18,
	PM_MMIO_WRITE = 19,
	PM_MMIO_READ = 20,
	PM_PM_INIT_FINALIZE = 21,
	PM_FPGA_LOAD = 22,
	PM_FPGA_GET_STATUS = 23,
	PM_GET_CHIPID = 24,
	PM_SECURE_SHA = 26,
	PM_PINCTRL_REQUEST = 28,
	PM_PINCTRL_RELEASE = 29,
	PM_PINCTRL_SET_FUNCTION = 31,
	PM_PINCTRL_CONFIG_PARAM_GET = 32,
	PM_PINCTRL_CONFIG_PARAM_SET = 33,
	PM_IOCTL = 34,
	PM_QUERY_DATA = 35,
	PM_CLOCK_ENABLE = 36,
	PM_CLOCK_DISABLE = 37,
	PM_CLOCK_GETSTATE = 38,
	PM_CLOCK_SETDIVIDER = 39,
	PM_CLOCK_GETDIVIDER = 40,
	PM_CLOCK_SETPARENT = 43,
	PM_CLOCK_GETPARENT = 44,
	PM_FPGA_READ = 46,
	PM_SECURE_AES = 47,
	PM_EFUSE_ACCESS = 53,
	PM_FEATURE_CHECK = 63,
};

enum pm_feature_config_id {
	PM_FEATURE_INVALID = 0,
	PM_FEATURE_OVERTEMP_STATUS = 1,
	PM_FEATURE_OVERTEMP_VALUE = 2,
	PM_FEATURE_EXTWDT_STATUS = 3,
	PM_FEATURE_EXTWDT_VALUE = 4,
};

enum pm_gem_config_type {
	GEM_CONFIG_SGMII_MODE = 1,
	GEM_CONFIG_FIXED = 2,
};

enum pm_ioctl_id {
	IOCTL_GET_RPU_OPER_MODE = 0,
	IOCTL_SET_RPU_OPER_MODE = 1,
	IOCTL_RPU_BOOT_ADDR_CONFIG = 2,
	IOCTL_TCM_COMB_CONFIG = 3,
	IOCTL_SET_TAPDELAY_BYPASS = 4,
	IOCTL_SD_DLL_RESET = 6,
	IOCTL_SET_SD_TAPDELAY = 7,
	IOCTL_SET_PLL_FRAC_MODE = 8,
	IOCTL_GET_PLL_FRAC_MODE = 9,
	IOCTL_SET_PLL_FRAC_DATA = 10,
	IOCTL_GET_PLL_FRAC_DATA = 11,
	IOCTL_WRITE_GGS = 12,
	IOCTL_READ_GGS = 13,
	IOCTL_WRITE_PGGS = 14,
	IOCTL_READ_PGGS = 15,
	IOCTL_SET_BOOT_HEALTH_STATUS = 17,
	IOCTL_OSPI_MUX_SELECT = 21,
	IOCTL_REGISTER_SGI = 25,
	IOCTL_SET_FEATURE_CONFIG = 26,
	IOCTL_GET_FEATURE_CONFIG = 27,
	IOCTL_READ_REG = 28,
	IOCTL_SET_SD_CONFIG = 30,
	IOCTL_SET_GEM_CONFIG = 31,
	IOCTL_GET_QOS = 34,
};

enum pm_module_id {
	PM_MODULE_ID = 0,
	XPM_MODULE_ID = 2,
	XSEM_MODULE_ID = 3,
	TF_A_MODULE_ID = 10,
};

enum pm_node_id {
	NODE_SD_0 = 39,
	NODE_SD_1 = 40,
};

enum pm_pinctrl_bias_status {
	PM_PINCTRL_BIAS_DISABLE = 0,
	PM_PINCTRL_BIAS_ENABLE = 1,
};

enum pm_pinctrl_config_param {
	PM_PINCTRL_CONFIG_SLEW_RATE = 0,
	PM_PINCTRL_CONFIG_BIAS_STATUS = 1,
	PM_PINCTRL_CONFIG_PULL_CTRL = 2,
	PM_PINCTRL_CONFIG_SCHMITT_CMOS = 3,
	PM_PINCTRL_CONFIG_DRIVE_STRENGTH = 4,
	PM_PINCTRL_CONFIG_VOLTAGE_STATUS = 5,
	PM_PINCTRL_CONFIG_TRI_STATE = 6,
	PM_PINCTRL_CONFIG_MAX = 7,
};

enum pm_pinctrl_drive_strength {
	PM_PINCTRL_DRIVE_STRENGTH_2MA = 0,
	PM_PINCTRL_DRIVE_STRENGTH_4MA = 1,
	PM_PINCTRL_DRIVE_STRENGTH_8MA = 2,
	PM_PINCTRL_DRIVE_STRENGTH_12MA = 3,
};

enum pm_pinctrl_pull_ctrl {
	PM_PINCTRL_BIAS_PULL_DOWN = 0,
	PM_PINCTRL_BIAS_PULL_UP = 1,
};

enum pm_pinctrl_tri_state {
	PM_PINCTRL_TRI_STATE_DISABLE = 0,
	PM_PINCTRL_TRI_STATE_ENABLE = 1,
};

enum pm_qos_flags_status {
	PM_QOS_FLAGS_UNDEFINED = -1,
	PM_QOS_FLAGS_NONE = 0,
	PM_QOS_FLAGS_SOME = 1,
	PM_QOS_FLAGS_ALL = 2,
};

enum pm_qos_req_action {
	PM_QOS_ADD_REQ = 0,
	PM_QOS_UPDATE_REQ = 1,
	PM_QOS_REMOVE_REQ = 2,
};

enum pm_qos_type {
	PM_QOS_UNITIALIZED = 0,
	PM_QOS_MAX = 1,
	PM_QOS_MIN = 2,
};

enum pm_query_id {
	PM_QID_INVALID = 0,
	PM_QID_CLOCK_GET_NAME = 1,
	PM_QID_CLOCK_GET_TOPOLOGY = 2,
	PM_QID_CLOCK_GET_FIXEDFACTOR_PARAMS = 3,
	PM_QID_CLOCK_GET_PARENTS = 4,
	PM_QID_CLOCK_GET_ATTRIBUTES = 5,
	PM_QID_PINCTRL_GET_NUM_PINS = 6,
	PM_QID_PINCTRL_GET_NUM_FUNCTIONS = 7,
	PM_QID_PINCTRL_GET_NUM_FUNCTION_GROUPS = 8,
	PM_QID_PINCTRL_GET_FUNCTION_NAME = 9,
	PM_QID_PINCTRL_GET_FUNCTION_GROUPS = 10,
	PM_QID_PINCTRL_GET_PIN_GROUPS = 11,
	PM_QID_CLOCK_GET_NUM_CLOCKS = 12,
	PM_QID_CLOCK_GET_MAX_DIVISOR = 13,
	PM_QID_PINCTRL_GET_ATTRIBUTES = 15,
};

enum pm_ret_status {
	XST_PM_SUCCESS = 0,
	XST_PM_INVALID_VERSION = 4,
	XST_PM_NO_FEATURE = 19,
	XST_PM_INVALID_CRC = 301,
	XST_PM_INTERNAL = 2000,
	XST_PM_CONFLICT = 2001,
	XST_PM_NO_ACCESS = 2002,
	XST_PM_INVALID_NODE = 2003,
	XST_PM_DOUBLE_REQ = 2004,
	XST_PM_ABORT_SUSPEND = 2005,
	XST_PM_MULT_USER = 2008,
};

enum pm_sd_config_type {
	SD_CONFIG_EMMC_SEL = 1,
	SD_CONFIG_BASECLK = 2,
	SD_CONFIG_8BIT = 3,
	SD_CONFIG_FIXED = 4,
};

enum pm_suspend_mode {
	PM_SUSPEND_MODE_FIRST = 0,
	PM_SUSPEND_MODE_STD = 0,
	PM_SUSPEND_MODE_POWER_OFF = 1,
};

enum pmic_arb_channel {
	PMIC_ARB_CHANNEL_RW = 0,
	PMIC_ARB_CHANNEL_OBS = 1,
};

enum pmic_arb_chnl_status {
	PMIC_ARB_STATUS_DONE = 1,
	PMIC_ARB_STATUS_FAILURE = 2,
	PMIC_ARB_STATUS_DENIED = 4,
	PMIC_ARB_STATUS_DROPPED = 8,
};

enum pmic_arb_cmd_op_code {
	PMIC_ARB_OP_EXT_WRITEL = 0,
	PMIC_ARB_OP_EXT_READL = 1,
	PMIC_ARB_OP_EXT_WRITE = 2,
	PMIC_ARB_OP_RESET = 3,
	PMIC_ARB_OP_SLEEP = 4,
	PMIC_ARB_OP_SHUTDOWN = 5,
	PMIC_ARB_OP_WAKEUP = 6,
	PMIC_ARB_OP_AUTHENTICATE = 7,
	PMIC_ARB_OP_MSTR_READ = 8,
	PMIC_ARB_OP_MSTR_WRITE = 9,
	PMIC_ARB_OP_EXT_READ = 13,
	PMIC_ARB_OP_WRITE = 14,
	PMIC_ARB_OP_READ = 15,
	PMIC_ARB_OP_ZERO_WRITE = 16,
};

enum pmic_gpio_func_index {
	PMIC_GPIO_FUNC_INDEX_NORMAL = 0,
	PMIC_GPIO_FUNC_INDEX_PAIRED = 1,
	PMIC_GPIO_FUNC_INDEX_FUNC1 = 2,
	PMIC_GPIO_FUNC_INDEX_FUNC2 = 3,
	PMIC_GPIO_FUNC_INDEX_FUNC3 = 4,
	PMIC_GPIO_FUNC_INDEX_FUNC4 = 5,
	PMIC_GPIO_FUNC_INDEX_DTEST1 = 6,
	PMIC_GPIO_FUNC_INDEX_DTEST2 = 7,
	PMIC_GPIO_FUNC_INDEX_DTEST3 = 8,
	PMIC_GPIO_FUNC_INDEX_DTEST4 = 9,
};

enum pmic_id {
	TPS65214 = 0,
	TPS65215 = 1,
	TPS65219 = 2,
};

enum pmic_type {
	PMIC_MT6323 = 0,
	PMIC_MT6331 = 1,
	PMIC_MT6332 = 2,
	PMIC_MT6351 = 3,
	PMIC_MT6357 = 4,
	PMIC_MT6358 = 5,
	PMIC_MT6359 = 6,
	PMIC_MT6380 = 7,
	PMIC_MT6397 = 8,
};

enum pnfs_iomode {
	IOMODE_READ = 1,
	IOMODE_RW = 2,
	IOMODE_ANY = 3,
};

enum pnfs_layout_destroy_mode {
	PNFS_LAYOUT_INVALIDATE = 0,
	PNFS_LAYOUT_BULK_RETURN = 1,
	PNFS_LAYOUT_FILE_BULK_RETURN = 2,
};

enum pnfs_layoutreturn_type {
	RETURN_FILE = 1,
	RETURN_FSID = 2,
	RETURN_ALL = 3,
};

enum pnfs_layouttype {
	LAYOUT_NFSV4_1_FILES = 1,
	LAYOUT_OSD2_OBJECTS = 2,
	LAYOUT_BLOCK_VOLUME = 3,
	LAYOUT_FLEX_FILES = 4,
	LAYOUT_SCSI = 5,
	LAYOUT_TYPE_MAX = 6,
};

enum pnfs_notify_deviceid_type4 {
	NOTIFY_DEVICEID4_CHANGE = 2,
	NOTIFY_DEVICEID4_DELETE = 4,
};

enum pnfs_try_status {
	PNFS_ATTEMPTED = 0,
	PNFS_NOT_ATTEMPTED = 1,
	PNFS_TRY_AGAIN = 2,
};

enum pnfs_update_layout_reason {
	PNFS_UPDATE_LAYOUT_UNKNOWN = 0,
	PNFS_UPDATE_LAYOUT_NO_PNFS = 1,
	PNFS_UPDATE_LAYOUT_RD_ZEROLEN = 2,
	PNFS_UPDATE_LAYOUT_MDSTHRESH = 3,
	PNFS_UPDATE_LAYOUT_NOMEM = 4,
	PNFS_UPDATE_LAYOUT_BULK_RECALL = 5,
	PNFS_UPDATE_LAYOUT_IO_TEST_FAIL = 6,
	PNFS_UPDATE_LAYOUT_FOUND_CACHED = 7,
	PNFS_UPDATE_LAYOUT_RETURN = 8,
	PNFS_UPDATE_LAYOUT_RETRY = 9,
	PNFS_UPDATE_LAYOUT_BLOCKED = 10,
	PNFS_UPDATE_LAYOUT_INVALID_OPEN = 11,
	PNFS_UPDATE_LAYOUT_SEND_LAYOUTGET = 12,
	PNFS_UPDATE_LAYOUT_EXIT = 13,
};

enum poll_time_type {
	PT_TIMEVAL = 0,
	PT_OLD_TIMEVAL = 1,
	PT_TIMESPEC = 2,
	PT_OLD_TIMESPEC = 3,
};

enum polling_modes {
	CM_POLL_DISABLE = 0,
	CM_POLL_ALWAYS = 1,
	CM_POLL_EXTERNAL_POWER_ONLY = 2,
	CM_POLL_CHARGING_ONLY = 3,
};

enum pool_workqueue_stats {
	PWQ_STAT_STARTED = 0,
	PWQ_STAT_COMPLETED = 1,
	PWQ_STAT_CPU_TIME = 2,
	PWQ_STAT_CPU_INTENSIVE = 3,
	PWQ_STAT_CM_WAKEUP = 4,
	PWQ_STAT_REPATRIATED = 5,
	PWQ_STAT_MAYDAY = 6,
	PWQ_STAT_RESCUED = 7,
	PWQ_NR_STATS = 8,
};

enum port_event {
	PORTE_BYTES_DMAED = 0,
	PORTE_BROADCAST_RCVD = 1,
	PORTE_LINK_RESET_ERR = 2,
	PORTE_TIMER_EVENT = 3,
	PORTE_HARD_RESET = 4,
	PORT_NUM_EVENTS = 5,
};

enum port_pkey_state {
	IB_PORT_PKEY_NOT_VALID = 0,
	IB_PORT_PKEY_VALID = 1,
	IB_PORT_PKEY_LISTED = 2,
};

enum port_type {
	RX___2 = 0,
	TX___2 = 1,
};

enum positive_aop_returns {
	AOP_WRITEPAGE_ACTIVATE = 524288,
	AOP_TRUNCATED_PAGE = 524289,
};

enum posix_timer_state {
	POSIX_TIMER_DISARMED = 0,
	POSIX_TIMER_ARMED = 1,
	POSIX_TIMER_REQUEUE_PENDING = 2,
};

enum power_desc_param_offset {
	PWR_DESC_LEN = 0,
	PWR_DESC_TYPE = 1,
	PWR_DESC_ACTIVE_LVLS_VCC_0 = 2,
	PWR_DESC_ACTIVE_LVLS_VCCQ_0 = 34,
	PWR_DESC_ACTIVE_LVLS_VCCQ2_0 = 66,
};

enum power_supply_charge_behaviour {
	POWER_SUPPLY_CHARGE_BEHAVIOUR_AUTO = 0,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE = 1,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE_AWAKE = 2,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_FORCE_DISCHARGE = 3,
};

enum power_supply_charge_type {
	POWER_SUPPLY_CHARGE_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_CHARGE_TYPE_NONE = 1,
	POWER_SUPPLY_CHARGE_TYPE_TRICKLE = 2,
	POWER_SUPPLY_CHARGE_TYPE_FAST = 3,
	POWER_SUPPLY_CHARGE_TYPE_STANDARD = 4,
	POWER_SUPPLY_CHARGE_TYPE_ADAPTIVE = 5,
	POWER_SUPPLY_CHARGE_TYPE_CUSTOM = 6,
	POWER_SUPPLY_CHARGE_TYPE_LONGLIFE = 7,
	POWER_SUPPLY_CHARGE_TYPE_BYPASS = 8,
};

enum power_supply_notifier_events {
	PSY_EVENT_PROP_CHANGED = 0,
};

enum power_supply_property {
	POWER_SUPPLY_PROP_STATUS = 0,
	POWER_SUPPLY_PROP_CHARGE_TYPE = 1,
	POWER_SUPPLY_PROP_CHARGE_TYPES = 2,
	POWER_SUPPLY_PROP_HEALTH = 3,
	POWER_SUPPLY_PROP_PRESENT = 4,
	POWER_SUPPLY_PROP_ONLINE = 5,
	POWER_SUPPLY_PROP_AUTHENTIC = 6,
	POWER_SUPPLY_PROP_TECHNOLOGY = 7,
	POWER_SUPPLY_PROP_CYCLE_COUNT = 8,
	POWER_SUPPLY_PROP_VOLTAGE_MAX = 9,
	POWER_SUPPLY_PROP_VOLTAGE_MIN = 10,
	POWER_SUPPLY_PROP_VOLTAGE_MAX_DESIGN = 11,
	POWER_SUPPLY_PROP_VOLTAGE_MIN_DESIGN = 12,
	POWER_SUPPLY_PROP_VOLTAGE_NOW = 13,
	POWER_SUPPLY_PROP_VOLTAGE_AVG = 14,
	POWER_SUPPLY_PROP_VOLTAGE_OCV = 15,
	POWER_SUPPLY_PROP_VOLTAGE_BOOT = 16,
	POWER_SUPPLY_PROP_CURRENT_MAX = 17,
	POWER_SUPPLY_PROP_CURRENT_NOW = 18,
	POWER_SUPPLY_PROP_CURRENT_AVG = 19,
	POWER_SUPPLY_PROP_CURRENT_BOOT = 20,
	POWER_SUPPLY_PROP_POWER_NOW = 21,
	POWER_SUPPLY_PROP_POWER_AVG = 22,
	POWER_SUPPLY_PROP_CHARGE_FULL_DESIGN = 23,
	POWER_SUPPLY_PROP_CHARGE_EMPTY_DESIGN = 24,
	POWER_SUPPLY_PROP_CHARGE_FULL = 25,
	POWER_SUPPLY_PROP_CHARGE_EMPTY = 26,
	POWER_SUPPLY_PROP_CHARGE_NOW = 27,
	POWER_SUPPLY_PROP_CHARGE_AVG = 28,
	POWER_SUPPLY_PROP_CHARGE_COUNTER = 29,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT = 30,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT_MAX = 31,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE = 32,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE_MAX = 33,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT = 34,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT_MAX = 35,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_START_THRESHOLD = 36,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_END_THRESHOLD = 37,
	POWER_SUPPLY_PROP_CHARGE_BEHAVIOUR = 38,
	POWER_SUPPLY_PROP_INPUT_CURRENT_LIMIT = 39,
	POWER_SUPPLY_PROP_INPUT_VOLTAGE_LIMIT = 40,
	POWER_SUPPLY_PROP_INPUT_POWER_LIMIT = 41,
	POWER_SUPPLY_PROP_ENERGY_FULL_DESIGN = 42,
	POWER_SUPPLY_PROP_ENERGY_EMPTY_DESIGN = 43,
	POWER_SUPPLY_PROP_ENERGY_FULL = 44,
	POWER_SUPPLY_PROP_ENERGY_EMPTY = 45,
	POWER_SUPPLY_PROP_ENERGY_NOW = 46,
	POWER_SUPPLY_PROP_ENERGY_AVG = 47,
	POWER_SUPPLY_PROP_CAPACITY = 48,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MIN = 49,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MAX = 50,
	POWER_SUPPLY_PROP_CAPACITY_ERROR_MARGIN = 51,
	POWER_SUPPLY_PROP_CAPACITY_LEVEL = 52,
	POWER_SUPPLY_PROP_TEMP = 53,
	POWER_SUPPLY_PROP_TEMP_MAX = 54,
	POWER_SUPPLY_PROP_TEMP_MIN = 55,
	POWER_SUPPLY_PROP_TEMP_ALERT_MIN = 56,
	POWER_SUPPLY_PROP_TEMP_ALERT_MAX = 57,
	POWER_SUPPLY_PROP_TEMP_AMBIENT = 58,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MIN = 59,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MAX = 60,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_NOW = 61,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_AVG = 62,
	POWER_SUPPLY_PROP_TIME_TO_FULL_NOW = 63,
	POWER_SUPPLY_PROP_TIME_TO_FULL_AVG = 64,
	POWER_SUPPLY_PROP_TYPE = 65,
	POWER_SUPPLY_PROP_USB_TYPE = 66,
	POWER_SUPPLY_PROP_SCOPE = 67,
	POWER_SUPPLY_PROP_PRECHARGE_CURRENT = 68,
	POWER_SUPPLY_PROP_CHARGE_TERM_CURRENT = 69,
	POWER_SUPPLY_PROP_CALIBRATE = 70,
	POWER_SUPPLY_PROP_MANUFACTURE_YEAR = 71,
	POWER_SUPPLY_PROP_MANUFACTURE_MONTH = 72,
	POWER_SUPPLY_PROP_MANUFACTURE_DAY = 73,
	POWER_SUPPLY_PROP_INTERNAL_RESISTANCE = 74,
	POWER_SUPPLY_PROP_STATE_OF_HEALTH = 75,
	POWER_SUPPLY_PROP_MODEL_NAME = 76,
	POWER_SUPPLY_PROP_MANUFACTURER = 77,
	POWER_SUPPLY_PROP_SERIAL_NUMBER = 78,
};

enum power_supply_type {
	POWER_SUPPLY_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_TYPE_BATTERY = 1,
	POWER_SUPPLY_TYPE_UPS = 2,
	POWER_SUPPLY_TYPE_MAINS = 3,
	POWER_SUPPLY_TYPE_USB = 4,
	POWER_SUPPLY_TYPE_USB_DCP = 5,
	POWER_SUPPLY_TYPE_USB_CDP = 6,
	POWER_SUPPLY_TYPE_USB_ACA = 7,
	POWER_SUPPLY_TYPE_USB_TYPE_C = 8,
	POWER_SUPPLY_TYPE_USB_PD = 9,
	POWER_SUPPLY_TYPE_USB_PD_DRP = 10,
	POWER_SUPPLY_TYPE_APPLE_BRICK_ID = 11,
	POWER_SUPPLY_TYPE_WIRELESS = 12,
};

enum ppe_common_mode {
	PPE_COMMON_MODE_DEBUG = 0,
	PPE_COMMON_MODE_SERVICE = 1,
	PPE_COMMON_MODE_MAX = 2,
};

enum ppe_port_mode {
	PPE_MODE_GE = 0,
	PPE_MODE_XGE = 1,
};

enum ppe_qid_mode {
	PPE_QID_MODE0 = 0,
	PPE_QID_MODE1 = 1,
	PPE_QID_MODE2 = 2,
	PPE_QID_MODE3 = 3,
	PPE_QID_MODE4 = 4,
	PPE_QID_MODE5 = 5,
	PPE_QID_MODE6 = 6,
	PPE_QID_MODE7 = 7,
	PPE_QID_MODE8 = 8,
	PPE_QID_MODE9 = 9,
	PPE_QID_MODE10 = 10,
	PPE_QID_MODE11 = 11,
};

enum ppi_reg {
	PPI_PENDING = 0,
	PPI_ACTIVE = 1,
	PPI_HM = 2,
};

enum pr_status {
	PR_STS_SUCCESS = 0,
	PR_STS_IOERR = 2,
	PR_STS_RESERVATION_CONFLICT = 24,
	PR_STS_RETRY_PATH_FAILURE = 917504,
	PR_STS_PATH_FAST_FAILED = 983040,
	PR_STS_PATH_FAILED = 65536,
};

enum pr_type {
	PR_WRITE_EXCLUSIVE = 1,
	PR_EXCLUSIVE_ACCESS = 2,
	PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum prep_dispatch {
	PREP_DISPATCH_OK = 0,
	PREP_DISPATCH_NO_TAG = 1,
	PREP_DISPATCH_NO_BUDGET = 2,
};

enum pri_resp {
	PRI_RESP_DENY = 0,
	PRI_RESP_FAIL = 1,
	PRI_RESP_SUCC = 2,
};

enum printk_info_flags {
	LOG_FORCE_CON = 1,
	LOG_NEWLINE = 2,
	LOG_CONT = 8,
};

enum priv_stack_mode {
	PRIV_STACK_UNKNOWN = 0,
	NO_PRIV_STACK = 1,
	PRIV_STACK_ADAPTIVE = 2,
};

enum probe_type {
	PROBE_DEFAULT_STRATEGY = 0,
	PROBE_PREFER_ASYNCHRONOUS = 1,
	PROBE_FORCE_SYNCHRONOUS = 2,
};

enum proc_cn_event {
	PROC_EVENT_NONE = 0,
	PROC_EVENT_FORK = 1,
	PROC_EVENT_EXEC = 2,
	PROC_EVENT_UID = 4,
	PROC_EVENT_GID = 64,
	PROC_EVENT_SID = 128,
	PROC_EVENT_PTRACE = 256,
	PROC_EVENT_COMM = 512,
	PROC_EVENT_NONZERO_EXIT = 536870912,
	PROC_EVENT_COREDUMP = 1073741824,
	PROC_EVENT_EXIT = 2147483648,
};

enum proc_hidepid {
	HIDEPID_OFF = 0,
	HIDEPID_NO_ACCESS = 1,
	HIDEPID_INVISIBLE = 2,
	HIDEPID_NOT_PTRACEABLE = 4,
};

enum proc_mem_force {
	PROC_MEM_FORCE_ALWAYS = 0,
	PROC_MEM_FORCE_PTRACE = 1,
	PROC_MEM_FORCE_NEVER = 2,
};

enum proc_param {
	Opt_gid___7 = 0,
	Opt_hidepid = 1,
	Opt_subset = 2,
	Opt_pidns = 3,
};

enum proc_pidonly {
	PROC_PIDONLY_OFF = 0,
	PROC_PIDONLY_ON = 1,
};

enum procmap_query_flags {
	PROCMAP_QUERY_VMA_READABLE = 1,
	PROCMAP_QUERY_VMA_WRITABLE = 2,
	PROCMAP_QUERY_VMA_EXECUTABLE = 4,
	PROCMAP_QUERY_VMA_SHARED = 8,
	PROCMAP_QUERY_COVERING_OR_NEXT_VMA = 16,
	PROCMAP_QUERY_FILE_BACKED_VMA = 32,
};

enum prs_errcode {
	PERR_NONE = 0,
	PERR_INVCPUS = 1,
	PERR_INVPARENT = 2,
	PERR_NOTPART = 3,
	PERR_NOTEXCL = 4,
	PERR_NOCPUS = 5,
	PERR_HOTPLUG = 6,
	PERR_CPUSEMPTY = 7,
	PERR_HKEEPING = 8,
	PERR_ACCESS = 9,
	PERR_REMOTE = 10,
};

enum ps2_disposition {
	PS2_PROCESS = 0,
	PS2_IGNORE = 1,
	PS2_ERROR = 2,
};

enum psil_endpoint_type {
	PSIL_EP_NATIVE = 0,
	PSIL_EP_PDMA_XY = 1,
	PSIL_EP_PDMA_MCAN = 2,
	PSIL_EP_PDMA_AASRC = 3,
};

enum pstore_type_id {
	PSTORE_TYPE_DMESG = 0,
	PSTORE_TYPE_MCE = 1,
	PSTORE_TYPE_CONSOLE = 2,
	PSTORE_TYPE_FTRACE = 3,
	PSTORE_TYPE_PPC_RTAS = 4,
	PSTORE_TYPE_PPC_OF = 5,
	PSTORE_TYPE_PPC_COMMON = 6,
	PSTORE_TYPE_PMSG = 7,
	PSTORE_TYPE_PPC_OPAL = 8,
	PSTORE_TYPE_MAX = 9,
};

enum ptp_clock_events {
	PTP_CLOCK_ALARM = 0,
	PTP_CLOCK_EXTTS = 1,
	PTP_CLOCK_EXTOFF = 2,
	PTP_CLOCK_PPS = 3,
	PTP_CLOCK_PPSUSR = 4,
};

enum ptp_pin_function {
	PTP_PF_NONE = 0,
	PTP_PF_EXTTS = 1,
	PTP_PF_PEROUT = 2,
	PTP_PF_PHYSYNC = 3,
};

enum ptrace_syscall_dir {
	PTRACE_SYSCALL_ENTER = 0,
	PTRACE_SYSCALL_EXIT = 1,
};

enum pud_index {
	PUD_PULL_DISABLE = 0,
	PUD_PULL_DOWN = 1,
	PUD_PULL_UP = 2,
	PUD_MAX = 3,
};

enum pwm_polarity {
	PWM_POLARITY_NORMAL = 0,
	PWM_POLARITY_INVERSED = 1,
};

enum pwrap_regs {
	PWRAP_MUX_SEL = 0,
	PWRAP_WRAP_EN = 1,
	PWRAP_DIO_EN = 2,
	PWRAP_SIDLY = 3,
	PWRAP_CSHEXT_WRITE = 4,
	PWRAP_CSHEXT_READ = 5,
	PWRAP_CSLEXT_START = 6,
	PWRAP_CSLEXT_END = 7,
	PWRAP_STAUPD_PRD = 8,
	PWRAP_STAUPD_GRPEN = 9,
	PWRAP_STAUPD_MAN_TRIG = 10,
	PWRAP_STAUPD_STA = 11,
	PWRAP_WRAP_STA = 12,
	PWRAP_HARB_INIT = 13,
	PWRAP_HARB_HPRIO = 14,
	PWRAP_HIPRIO_ARB_EN = 15,
	PWRAP_HARB_STA0 = 16,
	PWRAP_HARB_STA1 = 17,
	PWRAP_MAN_EN = 18,
	PWRAP_MAN_CMD = 19,
	PWRAP_MAN_RDATA = 20,
	PWRAP_MAN_VLDCLR = 21,
	PWRAP_WACS0_EN = 22,
	PWRAP_INIT_DONE0 = 23,
	PWRAP_WACS0_CMD = 24,
	PWRAP_WACS0_RDATA = 25,
	PWRAP_WACS0_VLDCLR = 26,
	PWRAP_WACS1_EN = 27,
	PWRAP_INIT_DONE1 = 28,
	PWRAP_WACS1_CMD = 29,
	PWRAP_WACS1_RDATA = 30,
	PWRAP_WACS1_VLDCLR = 31,
	PWRAP_WACS2_EN = 32,
	PWRAP_INIT_DONE2 = 33,
	PWRAP_WACS2_CMD = 34,
	PWRAP_WACS2_RDATA = 35,
	PWRAP_WACS2_VLDCLR = 36,
	PWRAP_INT_EN = 37,
	PWRAP_INT_FLG_RAW = 38,
	PWRAP_INT_FLG = 39,
	PWRAP_INT_CLR = 40,
	PWRAP_SIG_ADR = 41,
	PWRAP_SIG_MODE = 42,
	PWRAP_SIG_VALUE = 43,
	PWRAP_SIG_ERRVAL = 44,
	PWRAP_CRC_EN = 45,
	PWRAP_TIMER_EN = 46,
	PWRAP_TIMER_STA = 47,
	PWRAP_WDT_UNIT = 48,
	PWRAP_WDT_SRC_EN = 49,
	PWRAP_WDT_FLG = 50,
	PWRAP_DEBUG_INT_SEL = 51,
	PWRAP_CIPHER_KEY_SEL = 52,
	PWRAP_CIPHER_IV_SEL = 53,
	PWRAP_CIPHER_RDY = 54,
	PWRAP_CIPHER_MODE = 55,
	PWRAP_CIPHER_SWRST = 56,
	PWRAP_DCM_EN = 57,
	PWRAP_DCM_DBC_PRD = 58,
	PWRAP_EINT_STA0_ADR = 59,
	PWRAP_EINT_STA1_ADR = 60,
	PWRAP_SWINF_2_WDATA_31_0 = 61,
	PWRAP_SWINF_2_RDATA_31_0 = 62,
	PWRAP_ADC_CMD_ADDR = 63,
	PWRAP_PWRAP_ADC_CMD = 64,
	PWRAP_ADC_RDY_ADDR = 65,
	PWRAP_ADC_RDATA_ADDR1 = 66,
	PWRAP_ADC_RDATA_ADDR2 = 67,
	PWRAP_STA = 68,
	PWRAP_CLR = 69,
	PWRAP_DVFS_ADR8 = 70,
	PWRAP_DVFS_WDATA8 = 71,
	PWRAP_DVFS_ADR9 = 72,
	PWRAP_DVFS_WDATA9 = 73,
	PWRAP_DVFS_ADR10 = 74,
	PWRAP_DVFS_WDATA10 = 75,
	PWRAP_DVFS_ADR11 = 76,
	PWRAP_DVFS_WDATA11 = 77,
	PWRAP_DVFS_ADR12 = 78,
	PWRAP_DVFS_WDATA12 = 79,
	PWRAP_DVFS_ADR13 = 80,
	PWRAP_DVFS_WDATA13 = 81,
	PWRAP_DVFS_ADR14 = 82,
	PWRAP_DVFS_WDATA14 = 83,
	PWRAP_DVFS_ADR15 = 84,
	PWRAP_DVFS_WDATA15 = 85,
	PWRAP_EXT_CK = 86,
	PWRAP_ADC_RDATA_ADDR = 87,
	PWRAP_GPS_STA = 88,
	PWRAP_SW_RST = 89,
	PWRAP_DVFS_STEP_CTRL0 = 90,
	PWRAP_DVFS_STEP_CTRL1 = 91,
	PWRAP_DVFS_STEP_CTRL2 = 92,
	PWRAP_SPI2_CTRL = 93,
	PWRAP_CSHEXT = 94,
	PWRAP_EVENT_IN_EN = 95,
	PWRAP_EVENT_DST_EN = 96,
	PWRAP_RRARB_INIT = 97,
	PWRAP_RRARB_EN = 98,
	PWRAP_RRARB_STA0 = 99,
	PWRAP_RRARB_STA1 = 100,
	PWRAP_EVENT_STA = 101,
	PWRAP_EVENT_STACLR = 102,
	PWRAP_CIPHER_LOAD = 103,
	PWRAP_CIPHER_START = 104,
	PWRAP_RDDMY = 105,
	PWRAP_SI_CK_CON = 106,
	PWRAP_DVFS_ADR0 = 107,
	PWRAP_DVFS_WDATA0 = 108,
	PWRAP_DVFS_ADR1 = 109,
	PWRAP_DVFS_WDATA1 = 110,
	PWRAP_DVFS_ADR2 = 111,
	PWRAP_DVFS_WDATA2 = 112,
	PWRAP_DVFS_ADR3 = 113,
	PWRAP_DVFS_WDATA3 = 114,
	PWRAP_DVFS_ADR4 = 115,
	PWRAP_DVFS_WDATA4 = 116,
	PWRAP_DVFS_ADR5 = 117,
	PWRAP_DVFS_WDATA5 = 118,
	PWRAP_DVFS_ADR6 = 119,
	PWRAP_DVFS_WDATA6 = 120,
	PWRAP_DVFS_ADR7 = 121,
	PWRAP_DVFS_WDATA7 = 122,
	PWRAP_SPMINF_STA = 123,
	PWRAP_CIPHER_EN = 124,
	PWRAP_SI_SAMPLE_CTRL = 125,
	PWRAP_CSLEXT_WRITE = 126,
	PWRAP_CSLEXT_READ = 127,
	PWRAP_EXT_CK_WRITE = 128,
	PWRAP_STAUPD_CTRL = 129,
	PWRAP_WACS_P2P_EN = 130,
	PWRAP_INIT_DONE_P2P = 131,
	PWRAP_WACS_MD32_EN = 132,
	PWRAP_INIT_DONE_MD32 = 133,
	PWRAP_INT1_EN = 134,
	PWRAP_INT1_FLG = 135,
	PWRAP_INT1_CLR = 136,
	PWRAP_WDT_SRC_EN_1 = 137,
	PWRAP_INT_GPS_AUXADC_CMD_ADDR = 138,
	PWRAP_INT_GPS_AUXADC_CMD = 139,
	PWRAP_INT_GPS_AUXADC_RDATA_ADDR = 140,
	PWRAP_EXT_GPS_AUXADC_RDATA_ADDR = 141,
	PWRAP_GPSINF_0_STA = 142,
	PWRAP_GPSINF_1_STA = 143,
	PWRAP_OP_TYPE = 144,
	PWRAP_MSB_FIRST = 145,
};

enum pwrap_type {
	PWRAP_MT2701 = 0,
	PWRAP_MT6765 = 1,
	PWRAP_MT6779 = 2,
	PWRAP_MT6795 = 3,
	PWRAP_MT6797 = 4,
	PWRAP_MT6873 = 5,
	PWRAP_MT7622 = 6,
	PWRAP_MT8135 = 7,
	PWRAP_MT8173 = 8,
	PWRAP_MT8183 = 9,
	PWRAP_MT8186 = 10,
	PWRAP_MT8195 = 11,
	PWRAP_MT8365 = 12,
	PWRAP_MT8516 = 13,
};

enum pxa_i2c_types {
	REGS_PXA2XX = 0,
	REGS_PXA3XX = 1,
	REGS_CE4100 = 2,
	REGS_PXA910 = 3,
	REGS_A3700 = 4,
};

enum qb_enqueue_commands {
	enqueue_empty = 0,
	enqueue_response_always = 1,
	enqueue_rejects_to_fq = 2,
};

enum qb_pull_dt_e {
	qb_pull_dt_channel = 0,
	qb_pull_dt_workqueue = 1,
	qb_pull_dt_framequeue = 2,
};

enum qbman_pull_type_e {
	qbman_pull_type_prio = 1,
	qbman_pull_type_active = 2,
	qbman_pull_type_active_noics = 3,
};

enum qbman_sdqcr_dct {
	qbman_sdqcr_dct_null = 0,
	qbman_sdqcr_dct_prio_ics = 1,
	qbman_sdqcr_dct_active_ics = 2,
	qbman_sdqcr_dct_active = 3,
};

enum qbman_sdqcr_fc {
	qbman_sdqcr_fc_one = 0,
	qbman_sdqcr_fc_up_to_3 = 1,
};

enum qcom_icc_type {
	QCOM_ICC_NOC = 0,
	QCOM_ICC_BIMC = 1,
	QCOM_ICC_QNOC = 2,
};

enum qcom_iommu_clk {
	CLK_IFACE = 0,
	CLK_BUS = 1,
	CLK_TBU = 2,
	CLK_NUM = 3,
};

enum qcom_scm_arg_types {
	QCOM_SCM_VAL = 0,
	QCOM_SCM_RO = 1,
	QCOM_SCM_RW = 2,
	QCOM_SCM_BUFVAL = 3,
};

enum qcom_scm_convention {
	SMC_CONVENTION_UNKNOWN = 0,
	SMC_CONVENTION_LEGACY = 1,
	SMC_CONVENTION_ARM_32 = 2,
	SMC_CONVENTION_ARM_64 = 3,
};

enum qcom_scm_ice_cipher {
	QCOM_SCM_ICE_CIPHER_AES_128_XTS = 0,
	QCOM_SCM_ICE_CIPHER_AES_128_CBC = 1,
	QCOM_SCM_ICE_CIPHER_AES_256_XTS = 3,
	QCOM_SCM_ICE_CIPHER_AES_256_CBC = 4,
};

enum qcom_scm_ocmem_client {
	QCOM_SCM_OCMEM_UNUSED_ID = 0,
	QCOM_SCM_OCMEM_GRAPHICS_ID = 1,
	QCOM_SCM_OCMEM_VIDEO_ID = 2,
	QCOM_SCM_OCMEM_LP_AUDIO_ID = 3,
	QCOM_SCM_OCMEM_SENSORS_ID = 4,
	QCOM_SCM_OCMEM_OTHER_OS_ID = 5,
	QCOM_SCM_OCMEM_DEBUG_ID = 6,
};

enum qcom_scm_qseecom_resp_type {
	QSEECOM_SCM_RES_APP_ID = 60929,
	QSEECOM_SCM_RES_QSEOS_LISTENER_ID = 60930,
};

enum qcom_scm_qseecom_result {
	QSEECOM_RESULT_SUCCESS = 0,
	QSEECOM_RESULT_INCOMPLETE = 1,
	QSEECOM_RESULT_BLOCKED_ON_LISTENER = 2,
	QSEECOM_RESULT_FAILURE = 4294967295,
};

enum qcom_scm_qseecom_tz_cmd_app {
	QSEECOM_TZ_CMD_APP_SEND = 1,
	QSEECOM_TZ_CMD_APP_LOOKUP = 3,
};

enum qcom_scm_qseecom_tz_cmd_info {
	QSEECOM_TZ_CMD_INFO_VERSION = 3,
};

enum qcom_scm_qseecom_tz_owner {
	QSEECOM_TZ_OWNER_SIP = 2,
	QSEECOM_TZ_OWNER_TZ_APPS = 48,
	QSEECOM_TZ_OWNER_QSEE_OS = 50,
};

enum qcom_scm_qseecom_tz_svc {
	QSEECOM_TZ_SVC_APP_ID_PLACEHOLDER = 0,
	QSEECOM_TZ_SVC_APP_MGR = 1,
	QSEECOM_TZ_SVC_INFO = 6,
};

enum qcom_socinfo_feature_code {
	SOCINFO_FC_UNKNOWN = 0,
	SOCINFO_FC_AA = 1,
	SOCINFO_FC_AB = 2,
	SOCINFO_FC_AC = 3,
	SOCINFO_FC_AD = 4,
	SOCINFO_FC_AE = 5,
	SOCINFO_FC_AF = 6,
	SOCINFO_FC_AG = 7,
	SOCINFO_FC_AH = 8,
};

enum qcom_tzmem_policy {
	QCOM_TZMEM_POLICY_STATIC = 1,
	QCOM_TZMEM_POLICY_MULTIPLIER = 2,
	QCOM_TZMEM_POLICY_ON_DEMAND = 3,
};

enum qdisc_class_ops_flags {
	QDISC_CLASS_OPS_DOIT_UNLOCKED = 1,
};

enum qdisc_state2_t {
	__QDISC_STATE2_RUNNING = 0,
};

enum qdisc_state_t {
	__QDISC_STATE_SCHED = 0,
	__QDISC_STATE_DEACTIVATED = 1,
	__QDISC_STATE_MISSED = 2,
	__QDISC_STATE_DRAINING = 3,
};

enum qm_dc_portal {
	qm_dc_portal_fman0 = 0,
	qm_dc_portal_fman1 = 1,
};

enum qm_dqrr_cmode {
	qm_dqrr_cci = 0,
	qm_dqrr_cce = 1,
	qm_dqrr_cdc = 2,
};

enum qm_dqrr_dmode {
	qm_dqrr_dpush = 0,
	qm_dqrr_dpull = 1,
};

enum qm_dqrr_pmode {
	qm_dqrr_pci = 0,
	qm_dqrr_pce = 1,
	qm_dqrr_pvb = 2,
};

enum qm_eqcr_pmode {
	qm_eqcr_pci = 0,
	qm_eqcr_pce = 1,
	qm_eqcr_pvb = 2,
};

enum qm_fd_format {
	qm_fd_contig = 0,
	qm_fd_contig_big = 1073741824,
	qm_fd_sg = 2147483648,
	qm_fd_sg_big = 3221225472,
	qm_fd_compound = 536870912,
};

enum qm_memory {
	qm_memory_fqd = 0,
	qm_memory_pfdr = 1,
};

enum qm_mr_cmode {
	qm_mr_cci = 0,
	qm_mr_cce = 1,
};

enum qm_mr_pmode {
	qm_mr_pci = 0,
	qm_mr_pce = 1,
	qm_mr_pvb = 2,
};

enum qm_wq_class {
	qm_wq_portal = 0,
	qm_wq_pool = 1,
	qm_wq_fman0 = 2,
	qm_wq_fman1 = 3,
	qm_wq_caam = 4,
	qm_wq_pme = 5,
	qm_wq_first = 0,
	qm_wq_last = 5,
};

enum qman_cb_dqrr_result {
	qman_cb_dqrr_consume = 0,
	qman_cb_dqrr_park = 1,
	qman_cb_dqrr_defer = 2,
	qman_cb_dqrr_stop = 3,
	qman_cb_dqrr_consume_stop = 4,
};

enum qman_fq_state {
	qman_fq_state_oos = 0,
	qman_fq_state_parked = 1,
	qman_fq_state_sched = 2,
	qman_fq_state_retired = 3,
};

enum qos_mode {
	NOC_QOS_MODE_INVALID = 0,
	NOC_QOS_MODE_FIXED = 1,
	NOC_QOS_MODE_BYPASS = 2,
};

enum qpnpint_regs {
	QPNPINT_REG_RT_STS = 16,
	QPNPINT_REG_SET_TYPE = 17,
	QPNPINT_REG_POLARITY_HIGH = 18,
	QPNPINT_REG_POLARITY_LOW = 19,
	QPNPINT_REG_LATCHED_CLR = 20,
	QPNPINT_REG_EN_SET = 21,
	QPNPINT_REG_EN_CLR = 22,
	QPNPINT_REG_LATCHED_STS = 24,
};

enum query_opcode {
	UPIU_QUERY_OPCODE_NOP = 0,
	UPIU_QUERY_OPCODE_READ_DESC = 1,
	UPIU_QUERY_OPCODE_WRITE_DESC = 2,
	UPIU_QUERY_OPCODE_READ_ATTR = 3,
	UPIU_QUERY_OPCODE_WRITE_ATTR = 4,
	UPIU_QUERY_OPCODE_READ_FLAG = 5,
	UPIU_QUERY_OPCODE_SET_FLAG = 6,
	UPIU_QUERY_OPCODE_CLEAR_FLAG = 7,
	UPIU_QUERY_OPCODE_TOGGLE_FLAG = 8,
};

enum queue_mode {
	QUEUE_MODE_STRICT_PRIORITY = 0,
	QUEUE_MODE_STREAM_RESERVATION = 1,
};

enum quota_type {
	USRQUOTA = 0,
	GRPQUOTA = 1,
	PRJQUOTA = 2,
};

enum r8a77970_clk_types {
	CLK_TYPE_R8A77970_SD0H = 23,
	CLK_TYPE_R8A77970_SD0 = 24,
};

enum ramfs_param {
	Opt_mode___4 = 0,
};

enum ravb_reg {
	CCC = 0,
	DBAT = 4,
	DLR = 8,
	CSR = 12,
	CDAR0 = 16,
	CDAR1 = 20,
	CDAR2 = 24,
	CDAR3 = 28,
	CDAR4 = 32,
	CDAR5 = 36,
	CDAR6 = 40,
	CDAR7 = 44,
	CDAR8 = 48,
	CDAR9 = 52,
	CDAR10 = 56,
	CDAR11 = 60,
	CDAR12 = 64,
	CDAR13 = 68,
	CDAR14 = 72,
	CDAR15 = 76,
	CDAR16 = 80,
	CDAR17 = 84,
	CDAR18 = 88,
	CDAR19 = 92,
	CDAR20 = 96,
	CDAR21 = 100,
	ESR = 136,
	APSR = 140,
	RCR = 144,
	RQC0 = 148,
	RQC1 = 152,
	RQC2 = 156,
	RQC3 = 160,
	RQC4 = 164,
	RPC = 176,
	RTC = 180,
	UFCW = 188,
	UFCS = 192,
	UFCV0 = 196,
	UFCV1 = 200,
	UFCV2 = 204,
	UFCV3 = 208,
	UFCV4 = 212,
	UFCD0 = 224,
	UFCD1 = 228,
	UFCD2 = 232,
	UFCD3 = 236,
	UFCD4 = 240,
	SFO = 252,
	SFP0 = 256,
	SFP1 = 260,
	SFP2 = 264,
	SFP3 = 268,
	SFP4 = 272,
	SFP5 = 276,
	SFP6 = 280,
	SFP7 = 284,
	SFP8 = 288,
	SFP9 = 292,
	SFP10 = 296,
	SFP11 = 300,
	SFP12 = 304,
	SFP13 = 308,
	SFP14 = 312,
	SFP15 = 316,
	SFP16 = 320,
	SFP17 = 324,
	SFP18 = 328,
	SFP19 = 332,
	SFP20 = 336,
	SFP21 = 340,
	SFP22 = 344,
	SFP23 = 348,
	SFP24 = 352,
	SFP25 = 356,
	SFP26 = 360,
	SFP27 = 364,
	SFP28 = 368,
	SFP29 = 372,
	SFP30 = 376,
	SFP31 = 380,
	SFM0 = 448,
	SFM1 = 452,
	TGC = 768,
	TCCR = 772,
	TSR = 776,
	TFA0 = 784,
	TFA1 = 788,
	TFA2 = 792,
	CIVR0 = 800,
	CIVR1 = 804,
	CDVR0 = 808,
	CDVR1 = 812,
	CUL0 = 816,
	CUL1 = 820,
	CLL0 = 824,
	CLL1 = 828,
	DIC = 848,
	DIS = 852,
	EIC = 856,
	EIS = 860,
	RIC0 = 864,
	RIS0 = 868,
	RIC1 = 872,
	RIS1 = 876,
	RIC2 = 880,
	RIS2 = 884,
	TIC = 888,
	TIS = 892,
	ISS = 896,
	CIE = 900,
	GCCR = 912,
	GMTT = 916,
	GPTC = 920,
	GTI = 924,
	GTO0 = 928,
	GTO1 = 932,
	GTO2 = 936,
	GIC = 940,
	GIS = 944,
	GCPT = 948,
	GCT0 = 952,
	GCT1 = 956,
	GCT2 = 960,
	GIE = 972,
	GID = 976,
	DIL = 1088,
	RIE0 = 1120,
	RID0 = 1124,
	RIE2 = 1136,
	RID2 = 1140,
	TIE = 1144,
	TID = 1148,
	ECMR___2 = 1280,
	RFLR___2 = 1288,
	ECSR___2 = 1296,
	ECSIPR___2 = 1304,
	PIR___2 = 1312,
	PSR___2 = 1320,
	PIPR___2 = 1324,
	CXR31 = 1328,
	CXR35 = 1344,
	MPR___2 = 1368,
	PFTCR___2 = 1372,
	PFRCR___2 = 1376,
	GECMR___2 = 1456,
	MAHR___2 = 1472,
	MALR___2 = 1480,
	TROCR___2 = 1792,
	CXR41 = 1800,
	CXR42 = 1808,
	CEFCR___2 = 1856,
	FRECR___2 = 1864,
	TSFRCR___2 = 1872,
	TLFRCR___2 = 1880,
	RFCR___2 = 1888,
	MAFCR___2 = 1912,
	CSR0 = 2048,
	CSR1 = 2052,
	CSR2 = 2056,
};

enum rcar_gen3_clk_types {
	CLK_TYPE_GEN3_MAIN = 5,
	CLK_TYPE_GEN3_PLL0 = 6,
	CLK_TYPE_GEN3_PLL1 = 7,
	CLK_TYPE_GEN3_PLL2 = 8,
	CLK_TYPE_GEN3_PLL3 = 9,
	CLK_TYPE_GEN3_PLL4 = 10,
	CLK_TYPE_GEN3_SDH = 11,
	CLK_TYPE_GEN3_SD = 12,
	CLK_TYPE_GEN3_R = 13,
	CLK_TYPE_GEN3_MDSEL = 14,
	CLK_TYPE_GEN3_Z = 15,
	CLK_TYPE_GEN3_ZG = 16,
	CLK_TYPE_GEN3_OSC = 17,
	CLK_TYPE_GEN3_RCKSEL = 18,
	CLK_TYPE_GEN3_RPCSRC = 19,
	CLK_TYPE_GEN3_E3_RPCSRC = 20,
	CLK_TYPE_GEN3_RPC = 21,
	CLK_TYPE_GEN3_RPCD2 = 22,
	CLK_TYPE_GEN3_SOC_BASE = 23,
};

enum rcar_gen3_phy_index {
	PHY_INDEX_BOTH_HC = 0,
	PHY_INDEX_OHCI = 1,
	PHY_INDEX_EHCI = 2,
	PHY_INDEX_HSUSB = 3,
};

enum rcar_gen4_clk_types {
	CLK_TYPE_GEN4_MAIN = 5,
	CLK_TYPE_GEN4_PLL1 = 6,
	CLK_TYPE_GEN4_PLL2X_3X = 7,
	CLK_TYPE_GEN4_PLL5 = 8,
	CLK_TYPE_GEN4_PLL_F8_25 = 9,
	CLK_TYPE_GEN4_PLL_V8_25 = 10,
	CLK_TYPE_GEN4_PLL_F9_24 = 11,
	CLK_TYPE_GEN4_PLL_V9_24 = 12,
	CLK_TYPE_GEN4_SDSRC = 13,
	CLK_TYPE_GEN4_SDH = 14,
	CLK_TYPE_GEN4_SD = 15,
	CLK_TYPE_GEN4_MDSEL = 16,
	CLK_TYPE_GEN4_Z = 17,
	CLK_TYPE_GEN4_OSC = 18,
	CLK_TYPE_GEN4_RPCSRC = 19,
	CLK_TYPE_GEN4_RPC = 20,
	CLK_TYPE_GEN4_RPCD2 = 21,
	CLK_TYPE_GEN4_SOC_BASE = 22,
};

enum rcar_i2c_type {
	I2C_RCAR_GEN1 = 0,
	I2C_RCAR_GEN2 = 1,
	I2C_RCAR_GEN3 = 2,
	I2C_RCAR_GEN4 = 3,
};

enum rcb_int_flag {
	RCB_INT_FLAG_TX = 1,
	RCB_INT_FLAG_RX = 2,
	RCB_INT_FLAG_MAX = 4,
};

enum rdma_ah_attr_type {
	RDMA_AH_ATTR_TYPE_UNDEFINED = 0,
	RDMA_AH_ATTR_TYPE_IB = 1,
	RDMA_AH_ATTR_TYPE_ROCE = 2,
	RDMA_AH_ATTR_TYPE_OPA = 3,
};

enum rdma_driver_id {
	RDMA_DRIVER_UNKNOWN = 0,
	RDMA_DRIVER_MLX5 = 1,
	RDMA_DRIVER_MLX4 = 2,
	RDMA_DRIVER_CXGB3 = 3,
	RDMA_DRIVER_CXGB4 = 4,
	RDMA_DRIVER_MTHCA = 5,
	RDMA_DRIVER_BNXT_RE = 6,
	RDMA_DRIVER_OCRDMA = 7,
	RDMA_DRIVER_NES = 8,
	RDMA_DRIVER_I40IW = 9,
	RDMA_DRIVER_IRDMA = 9,
	RDMA_DRIVER_VMW_PVRDMA = 10,
	RDMA_DRIVER_QEDR = 11,
	RDMA_DRIVER_HNS = 12,
	RDMA_DRIVER_USNIC = 13,
	RDMA_DRIVER_RXE = 14,
	RDMA_DRIVER_HFI1 = 15,
	RDMA_DRIVER_QIB = 16,
	RDMA_DRIVER_EFA = 17,
	RDMA_DRIVER_SIW = 18,
	RDMA_DRIVER_ERDMA = 19,
	RDMA_DRIVER_MANA = 20,
	RDMA_DRIVER_IONIC = 21,
};

enum rdma_link_layer {
	IB_LINK_LAYER_UNSPECIFIED = 0,
	IB_LINK_LAYER_INFINIBAND = 1,
	IB_LINK_LAYER_ETHERNET = 2,
};

enum rdma_netdev_t {
	RDMA_NETDEV_OPA_VNIC = 0,
	RDMA_NETDEV_IPOIB = 1,
};

enum rdma_nl_counter_mask {
	RDMA_COUNTER_MASK_QP_TYPE = 1,
	RDMA_COUNTER_MASK_PID = 2,
};

enum rdma_nl_counter_mode {
	RDMA_COUNTER_MODE_NONE = 0,
	RDMA_COUNTER_MODE_AUTO = 1,
	RDMA_COUNTER_MODE_MANUAL = 2,
	RDMA_COUNTER_MODE_MAX = 3,
};

enum rdma_nl_dev_type {
	RDMA_DEVICE_TYPE_SMI = 1,
};

enum rdma_nl_name_assign_type {
	RDMA_NAME_ASSIGN_TYPE_UNKNOWN = 0,
	RDMA_NAME_ASSIGN_TYPE_USER = 1,
};

enum rdma_restrack_type {
	RDMA_RESTRACK_PD = 0,
	RDMA_RESTRACK_CQ = 1,
	RDMA_RESTRACK_QP = 2,
	RDMA_RESTRACK_CM_ID = 3,
	RDMA_RESTRACK_MR = 4,
	RDMA_RESTRACK_CTX = 5,
	RDMA_RESTRACK_COUNTER = 6,
	RDMA_RESTRACK_SRQ = 7,
	RDMA_RESTRACK_DMAH = 8,
	RDMA_RESTRACK_MAX = 9,
};

enum reboot_mode {
	REBOOT_UNDEFINED = -1,
	REBOOT_COLD = 0,
	REBOOT_WARM = 1,
	REBOOT_HARD = 2,
	REBOOT_SOFT = 3,
	REBOOT_GPIO = 4,
};

enum reboot_type {
	BOOT_TRIPLE = 116,
	BOOT_KBD = 107,
	BOOT_BIOS = 98,
	BOOT_ACPI = 97,
	BOOT_EFI = 101,
	BOOT_CF9_FORCE = 112,
	BOOT_CF9_SAFE = 113,
};

enum ref_state_type {
	REF_TYPE_PTR = 2,
	REF_TYPE_IRQ = 4,
	REF_TYPE_LOCK = 8,
	REF_TYPE_RES_LOCK = 16,
	REF_TYPE_RES_LOCK_IRQ = 32,
	REF_TYPE_LOCK_MASK = 56,
};

enum refcount_saturation_type {
	REFCOUNT_ADD_NOT_ZERO_OVF = 0,
	REFCOUNT_ADD_OVF = 1,
	REFCOUNT_ADD_UAF = 2,
	REFCOUNT_SUB_UAF = 3,
	REFCOUNT_DEC_LEAK = 4,
};

enum reg_arg_type {
	SRC_OP = 0,
	DST_OP = 1,
	DST_OP_NO_MARK = 2,
};

enum regcache_type {
	REGCACHE_NONE = 0,
	REGCACHE_RBTREE = 1,
	REGCACHE_FLAT = 2,
	REGCACHE_MAPLE = 3,
};

enum regfield_ids {
	VER_MAJOR = 0,
	VER_MINOR = 1,
	VER_STEP = 2,
	TSENS_EN = 3,
	TSENS_SW_RST = 4,
	SENSOR_EN = 5,
	CODE_OR_TEMP = 6,
	MAIN_MEASURE_PERIOD = 7,
	TRDY = 8,
	INT_EN = 9,
	LAST_TEMP_0 = 10,
	LAST_TEMP_1 = 11,
	LAST_TEMP_2 = 12,
	LAST_TEMP_3 = 13,
	LAST_TEMP_4 = 14,
	LAST_TEMP_5 = 15,
	LAST_TEMP_6 = 16,
	LAST_TEMP_7 = 17,
	LAST_TEMP_8 = 18,
	LAST_TEMP_9 = 19,
	LAST_TEMP_10 = 20,
	LAST_TEMP_11 = 21,
	LAST_TEMP_12 = 22,
	LAST_TEMP_13 = 23,
	LAST_TEMP_14 = 24,
	LAST_TEMP_15 = 25,
	VALID_0 = 26,
	VALID_1 = 27,
	VALID_2 = 28,
	VALID_3 = 29,
	VALID_4 = 30,
	VALID_5 = 31,
	VALID_6 = 32,
	VALID_7 = 33,
	VALID_8 = 34,
	VALID_9 = 35,
	VALID_10 = 36,
	VALID_11 = 37,
	VALID_12 = 38,
	VALID_13 = 39,
	VALID_14 = 40,
	VALID_15 = 41,
	LOWER_STATUS_0 = 42,
	LOWER_STATUS_1 = 43,
	LOWER_STATUS_2 = 44,
	LOWER_STATUS_3 = 45,
	LOWER_STATUS_4 = 46,
	LOWER_STATUS_5 = 47,
	LOWER_STATUS_6 = 48,
	LOWER_STATUS_7 = 49,
	LOWER_STATUS_8 = 50,
	LOWER_STATUS_9 = 51,
	LOWER_STATUS_10 = 52,
	LOWER_STATUS_11 = 53,
	LOWER_STATUS_12 = 54,
	LOWER_STATUS_13 = 55,
	LOWER_STATUS_14 = 56,
	LOWER_STATUS_15 = 57,
	LOW_INT_STATUS_0 = 58,
	LOW_INT_STATUS_1 = 59,
	LOW_INT_STATUS_2 = 60,
	LOW_INT_STATUS_3 = 61,
	LOW_INT_STATUS_4 = 62,
	LOW_INT_STATUS_5 = 63,
	LOW_INT_STATUS_6 = 64,
	LOW_INT_STATUS_7 = 65,
	LOW_INT_STATUS_8 = 66,
	LOW_INT_STATUS_9 = 67,
	LOW_INT_STATUS_10 = 68,
	LOW_INT_STATUS_11 = 69,
	LOW_INT_STATUS_12 = 70,
	LOW_INT_STATUS_13 = 71,
	LOW_INT_STATUS_14 = 72,
	LOW_INT_STATUS_15 = 73,
	LOW_INT_CLEAR_0 = 74,
	LOW_INT_CLEAR_1 = 75,
	LOW_INT_CLEAR_2 = 76,
	LOW_INT_CLEAR_3 = 77,
	LOW_INT_CLEAR_4 = 78,
	LOW_INT_CLEAR_5 = 79,
	LOW_INT_CLEAR_6 = 80,
	LOW_INT_CLEAR_7 = 81,
	LOW_INT_CLEAR_8 = 82,
	LOW_INT_CLEAR_9 = 83,
	LOW_INT_CLEAR_10 = 84,
	LOW_INT_CLEAR_11 = 85,
	LOW_INT_CLEAR_12 = 86,
	LOW_INT_CLEAR_13 = 87,
	LOW_INT_CLEAR_14 = 88,
	LOW_INT_CLEAR_15 = 89,
	LOW_INT_MASK_0 = 90,
	LOW_INT_MASK_1 = 91,
	LOW_INT_MASK_2 = 92,
	LOW_INT_MASK_3 = 93,
	LOW_INT_MASK_4 = 94,
	LOW_INT_MASK_5 = 95,
	LOW_INT_MASK_6 = 96,
	LOW_INT_MASK_7 = 97,
	LOW_INT_MASK_8 = 98,
	LOW_INT_MASK_9 = 99,
	LOW_INT_MASK_10 = 100,
	LOW_INT_MASK_11 = 101,
	LOW_INT_MASK_12 = 102,
	LOW_INT_MASK_13 = 103,
	LOW_INT_MASK_14 = 104,
	LOW_INT_MASK_15 = 105,
	LOW_THRESH_0 = 106,
	LOW_THRESH_1 = 107,
	LOW_THRESH_2 = 108,
	LOW_THRESH_3 = 109,
	LOW_THRESH_4 = 110,
	LOW_THRESH_5 = 111,
	LOW_THRESH_6 = 112,
	LOW_THRESH_7 = 113,
	LOW_THRESH_8 = 114,
	LOW_THRESH_9 = 115,
	LOW_THRESH_10 = 116,
	LOW_THRESH_11 = 117,
	LOW_THRESH_12 = 118,
	LOW_THRESH_13 = 119,
	LOW_THRESH_14 = 120,
	LOW_THRESH_15 = 121,
	UPPER_STATUS_0 = 122,
	UPPER_STATUS_1 = 123,
	UPPER_STATUS_2 = 124,
	UPPER_STATUS_3 = 125,
	UPPER_STATUS_4 = 126,
	UPPER_STATUS_5 = 127,
	UPPER_STATUS_6 = 128,
	UPPER_STATUS_7 = 129,
	UPPER_STATUS_8 = 130,
	UPPER_STATUS_9 = 131,
	UPPER_STATUS_10 = 132,
	UPPER_STATUS_11 = 133,
	UPPER_STATUS_12 = 134,
	UPPER_STATUS_13 = 135,
	UPPER_STATUS_14 = 136,
	UPPER_STATUS_15 = 137,
	UP_INT_STATUS_0 = 138,
	UP_INT_STATUS_1 = 139,
	UP_INT_STATUS_2 = 140,
	UP_INT_STATUS_3 = 141,
	UP_INT_STATUS_4 = 142,
	UP_INT_STATUS_5 = 143,
	UP_INT_STATUS_6 = 144,
	UP_INT_STATUS_7 = 145,
	UP_INT_STATUS_8 = 146,
	UP_INT_STATUS_9 = 147,
	UP_INT_STATUS_10 = 148,
	UP_INT_STATUS_11 = 149,
	UP_INT_STATUS_12 = 150,
	UP_INT_STATUS_13 = 151,
	UP_INT_STATUS_14 = 152,
	UP_INT_STATUS_15 = 153,
	UP_INT_CLEAR_0 = 154,
	UP_INT_CLEAR_1 = 155,
	UP_INT_CLEAR_2 = 156,
	UP_INT_CLEAR_3 = 157,
	UP_INT_CLEAR_4 = 158,
	UP_INT_CLEAR_5 = 159,
	UP_INT_CLEAR_6 = 160,
	UP_INT_CLEAR_7 = 161,
	UP_INT_CLEAR_8 = 162,
	UP_INT_CLEAR_9 = 163,
	UP_INT_CLEAR_10 = 164,
	UP_INT_CLEAR_11 = 165,
	UP_INT_CLEAR_12 = 166,
	UP_INT_CLEAR_13 = 167,
	UP_INT_CLEAR_14 = 168,
	UP_INT_CLEAR_15 = 169,
	UP_INT_MASK_0 = 170,
	UP_INT_MASK_1 = 171,
	UP_INT_MASK_2 = 172,
	UP_INT_MASK_3 = 173,
	UP_INT_MASK_4 = 174,
	UP_INT_MASK_5 = 175,
	UP_INT_MASK_6 = 176,
	UP_INT_MASK_7 = 177,
	UP_INT_MASK_8 = 178,
	UP_INT_MASK_9 = 179,
	UP_INT_MASK_10 = 180,
	UP_INT_MASK_11 = 181,
	UP_INT_MASK_12 = 182,
	UP_INT_MASK_13 = 183,
	UP_INT_MASK_14 = 184,
	UP_INT_MASK_15 = 185,
	UP_THRESH_0 = 186,
	UP_THRESH_1 = 187,
	UP_THRESH_2 = 188,
	UP_THRESH_3 = 189,
	UP_THRESH_4 = 190,
	UP_THRESH_5 = 191,
	UP_THRESH_6 = 192,
	UP_THRESH_7 = 193,
	UP_THRESH_8 = 194,
	UP_THRESH_9 = 195,
	UP_THRESH_10 = 196,
	UP_THRESH_11 = 197,
	UP_THRESH_12 = 198,
	UP_THRESH_13 = 199,
	UP_THRESH_14 = 200,
	UP_THRESH_15 = 201,
	CRITICAL_STATUS_0 = 202,
	CRITICAL_STATUS_1 = 203,
	CRITICAL_STATUS_2 = 204,
	CRITICAL_STATUS_3 = 205,
	CRITICAL_STATUS_4 = 206,
	CRITICAL_STATUS_5 = 207,
	CRITICAL_STATUS_6 = 208,
	CRITICAL_STATUS_7 = 209,
	CRITICAL_STATUS_8 = 210,
	CRITICAL_STATUS_9 = 211,
	CRITICAL_STATUS_10 = 212,
	CRITICAL_STATUS_11 = 213,
	CRITICAL_STATUS_12 = 214,
	CRITICAL_STATUS_13 = 215,
	CRITICAL_STATUS_14 = 216,
	CRITICAL_STATUS_15 = 217,
	CRIT_INT_STATUS_0 = 218,
	CRIT_INT_STATUS_1 = 219,
	CRIT_INT_STATUS_2 = 220,
	CRIT_INT_STATUS_3 = 221,
	CRIT_INT_STATUS_4 = 222,
	CRIT_INT_STATUS_5 = 223,
	CRIT_INT_STATUS_6 = 224,
	CRIT_INT_STATUS_7 = 225,
	CRIT_INT_STATUS_8 = 226,
	CRIT_INT_STATUS_9 = 227,
	CRIT_INT_STATUS_10 = 228,
	CRIT_INT_STATUS_11 = 229,
	CRIT_INT_STATUS_12 = 230,
	CRIT_INT_STATUS_13 = 231,
	CRIT_INT_STATUS_14 = 232,
	CRIT_INT_STATUS_15 = 233,
	CRIT_INT_CLEAR_0 = 234,
	CRIT_INT_CLEAR_1 = 235,
	CRIT_INT_CLEAR_2 = 236,
	CRIT_INT_CLEAR_3 = 237,
	CRIT_INT_CLEAR_4 = 238,
	CRIT_INT_CLEAR_5 = 239,
	CRIT_INT_CLEAR_6 = 240,
	CRIT_INT_CLEAR_7 = 241,
	CRIT_INT_CLEAR_8 = 242,
	CRIT_INT_CLEAR_9 = 243,
	CRIT_INT_CLEAR_10 = 244,
	CRIT_INT_CLEAR_11 = 245,
	CRIT_INT_CLEAR_12 = 246,
	CRIT_INT_CLEAR_13 = 247,
	CRIT_INT_CLEAR_14 = 248,
	CRIT_INT_CLEAR_15 = 249,
	CRIT_INT_MASK_0 = 250,
	CRIT_INT_MASK_1 = 251,
	CRIT_INT_MASK_2 = 252,
	CRIT_INT_MASK_3 = 253,
	CRIT_INT_MASK_4 = 254,
	CRIT_INT_MASK_5 = 255,
	CRIT_INT_MASK_6 = 256,
	CRIT_INT_MASK_7 = 257,
	CRIT_INT_MASK_8 = 258,
	CRIT_INT_MASK_9 = 259,
	CRIT_INT_MASK_10 = 260,
	CRIT_INT_MASK_11 = 261,
	CRIT_INT_MASK_12 = 262,
	CRIT_INT_MASK_13 = 263,
	CRIT_INT_MASK_14 = 264,
	CRIT_INT_MASK_15 = 265,
	CRIT_THRESH_0 = 266,
	CRIT_THRESH_1 = 267,
	CRIT_THRESH_2 = 268,
	CRIT_THRESH_3 = 269,
	CRIT_THRESH_4 = 270,
	CRIT_THRESH_5 = 271,
	CRIT_THRESH_6 = 272,
	CRIT_THRESH_7 = 273,
	CRIT_THRESH_8 = 274,
	CRIT_THRESH_9 = 275,
	CRIT_THRESH_10 = 276,
	CRIT_THRESH_11 = 277,
	CRIT_THRESH_12 = 278,
	CRIT_THRESH_13 = 279,
	CRIT_THRESH_14 = 280,
	CRIT_THRESH_15 = 281,
	WDOG_BARK_STATUS = 282,
	WDOG_BARK_CLEAR = 283,
	WDOG_BARK_MASK = 284,
	WDOG_BARK_COUNT = 285,
	CC_MON_STATUS = 286,
	CC_MON_CLEAR = 287,
	CC_MON_MASK = 288,
	MIN_STATUS_0 = 289,
	MIN_STATUS_1 = 290,
	MIN_STATUS_2 = 291,
	MIN_STATUS_3 = 292,
	MIN_STATUS_4 = 293,
	MIN_STATUS_5 = 294,
	MIN_STATUS_6 = 295,
	MIN_STATUS_7 = 296,
	MIN_STATUS_8 = 297,
	MIN_STATUS_9 = 298,
	MIN_STATUS_10 = 299,
	MIN_STATUS_11 = 300,
	MIN_STATUS_12 = 301,
	MIN_STATUS_13 = 302,
	MIN_STATUS_14 = 303,
	MIN_STATUS_15 = 304,
	MAX_STATUS_0 = 305,
	MAX_STATUS_1 = 306,
	MAX_STATUS_2 = 307,
	MAX_STATUS_3 = 308,
	MAX_STATUS_4 = 309,
	MAX_STATUS_5 = 310,
	MAX_STATUS_6 = 311,
	MAX_STATUS_7 = 312,
	MAX_STATUS_8 = 313,
	MAX_STATUS_9 = 314,
	MAX_STATUS_10 = 315,
	MAX_STATUS_11 = 316,
	MAX_STATUS_12 = 317,
	MAX_STATUS_13 = 318,
	MAX_STATUS_14 = 319,
	MAX_STATUS_15 = 320,
	MAX_REGFIELDS = 321,
};

enum regmap_endian {
	REGMAP_ENDIAN_DEFAULT = 0,
	REGMAP_ENDIAN_BIG = 1,
	REGMAP_ENDIAN_LITTLE = 2,
	REGMAP_ENDIAN_NATIVE = 3,
};

enum regulator_active_discharge {
	REGULATOR_ACTIVE_DISCHARGE_DEFAULT = 0,
	REGULATOR_ACTIVE_DISCHARGE_DISABLE = 1,
	REGULATOR_ACTIVE_DISCHARGE_ENABLE = 2,
};

enum regulator_detection_severity {
	REGULATOR_SEVERITY_PROT = 0,
	REGULATOR_SEVERITY_ERR = 1,
	REGULATOR_SEVERITY_WARN = 2,
};

enum regulator_get_type {
	NORMAL_GET = 0,
	EXCLUSIVE_GET = 1,
	OPTIONAL_GET = 2,
	MAX_GET_TYPE = 3,
};

enum regulator_status {
	REGULATOR_STATUS_OFF = 0,
	REGULATOR_STATUS_ON = 1,
	REGULATOR_STATUS_ERROR = 2,
	REGULATOR_STATUS_FAST = 3,
	REGULATOR_STATUS_NORMAL = 4,
	REGULATOR_STATUS_IDLE = 5,
	REGULATOR_STATUS_STANDBY = 6,
	REGULATOR_STATUS_BYPASS = 7,
	REGULATOR_STATUS_UNDEFINED = 8,
};

enum regulator_type {
	REGULATOR_VOLTAGE = 0,
	REGULATOR_CURRENT = 1,
};

enum release_type {
	leaf_only = 0,
	whole_subtree = 1,
};

enum renesas_sdhi_dma_cookie {
	COOKIE_UNMAPPED___2 = 0,
	COOKIE_PRE_MAPPED___2 = 1,
	COOKIE_MAPPED___2 = 2,
};

enum req_flag_bits {
	__REQ_FAILFAST_DEV = 8,
	__REQ_FAILFAST_TRANSPORT = 9,
	__REQ_FAILFAST_DRIVER = 10,
	__REQ_SYNC = 11,
	__REQ_META = 12,
	__REQ_PRIO = 13,
	__REQ_NOMERGE = 14,
	__REQ_IDLE = 15,
	__REQ_INTEGRITY = 16,
	__REQ_FUA = 17,
	__REQ_PREFLUSH = 18,
	__REQ_RAHEAD = 19,
	__REQ_BACKGROUND = 20,
	__REQ_NOWAIT = 21,
	__REQ_POLLED = 22,
	__REQ_ALLOC_CACHE = 23,
	__REQ_SWAP = 24,
	__REQ_DRV = 25,
	__REQ_FS_PRIVATE = 26,
	__REQ_ATOMIC = 27,
	__REQ_P2PDMA = 28,
	__REQ_NOUNMAP = 29,
	__REQ_NR_BITS = 30,
};

enum req_op {
	REQ_OP_READ = 0,
	REQ_OP_WRITE = 1,
	REQ_OP_FLUSH = 2,
	REQ_OP_DISCARD = 3,
	REQ_OP_SECURE_ERASE = 5,
	REQ_OP_ZONE_APPEND = 7,
	REQ_OP_WRITE_ZEROES = 9,
	REQ_OP_ZONE_OPEN = 11,
	REQ_OP_ZONE_CLOSE = 13,
	REQ_OP_ZONE_FINISH = 15,
	REQ_OP_ZONE_RESET = 17,
	REQ_OP_ZONE_RESET_ALL = 19,
	REQ_OP_DRV_IN = 34,
	REQ_OP_DRV_OUT = 35,
	REQ_OP_LAST = 36,
};

enum reset_control_flags {
	RESET_CONTROL_EXCLUSIVE = 4,
	RESET_CONTROL_EXCLUSIVE_DEASSERTED = 12,
	RESET_CONTROL_EXCLUSIVE_RELEASED = 0,
	RESET_CONTROL_SHARED = 1,
	RESET_CONTROL_SHARED_DEASSERTED = 9,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE = 6,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_DEASSERTED = 14,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_RELEASED = 2,
	RESET_CONTROL_OPTIONAL_SHARED = 3,
	RESET_CONTROL_OPTIONAL_SHARED_DEASSERTED = 11,
};

enum resolve_mode {
	RESOLVE_TBD = 0,
	RESOLVE_PTR = 1,
	RESOLVE_STRUCT_OR_ARRAY = 2,
};

enum rgmii_clock_delay {
	RGMII_CLK_DELAY_0_2_NS = 0,
	RGMII_CLK_DELAY_0_8_NS = 1,
	RGMII_CLK_DELAY_1_1_NS = 2,
	RGMII_CLK_DELAY_1_7_NS = 3,
	RGMII_CLK_DELAY_2_0_NS = 4,
	RGMII_CLK_DELAY_2_3_NS = 5,
	RGMII_CLK_DELAY_2_6_NS = 6,
	RGMII_CLK_DELAY_3_4_NS = 7,
};

enum riic_reg_list {
	RIIC_ICCR1 = 0,
	RIIC_ICCR2 = 1,
	RIIC_ICMR1 = 2,
	RIIC_ICMR3 = 3,
	RIIC_ICFER = 4,
	RIIC_ICSER = 5,
	RIIC_ICIER = 6,
	RIIC_ICSR2 = 7,
	RIIC_ICBRL = 8,
	RIIC_ICBRH = 9,
	RIIC_ICDRT = 10,
	RIIC_ICDRR = 11,
	RIIC_REG_END = 12,
};

enum ring_id {
	NETSEC_RING_TX = 0,
	NETSEC_RING_RX = 1,
};

enum ripas {
	RSI_RIPAS_EMPTY = 0,
	RSI_RIPAS_RAM = 1,
	RSI_RIPAS_DESTROYED = 2,
	RSI_RIPAS_DEV = 3,
};

enum rk3x_i2c_state {
	STATE_IDLE___3 = 0,
	STATE_START = 1,
	STATE_READ___2 = 2,
	STATE_WRITE___2 = 3,
	STATE_STOP = 4,
};

enum rk809_reg_id {
	RK809_ID_DCDC5 = 13,
	RK809_ID_SW1 = 14,
	RK809_ID_SW2 = 15,
	RK809_NUM_REGULATORS = 16,
};

enum rk817_reg_id {
	RK817_ID_DCDC1 = 0,
	RK817_ID_DCDC2 = 1,
	RK817_ID_DCDC3 = 2,
	RK817_ID_DCDC4 = 3,
	RK817_ID_LDO1 = 4,
	RK817_ID_LDO2 = 5,
	RK817_ID_LDO3 = 6,
	RK817_ID_LDO4 = 7,
	RK817_ID_LDO5 = 8,
	RK817_ID_LDO6 = 9,
	RK817_ID_LDO7 = 10,
	RK817_ID_LDO8 = 11,
	RK817_ID_LDO9 = 12,
	RK817_ID_BOOST = 13,
	RK817_ID_BOOST_OTG_SW = 14,
	RK817_NUM_REGULATORS = 15,
};

enum rlimit_type {
	UCOUNT_RLIMIT_NPROC = 0,
	UCOUNT_RLIMIT_MSGQUEUE = 1,
	UCOUNT_RLIMIT_SIGPENDING = 2,
	UCOUNT_RLIMIT_MEMLOCK = 3,
	UCOUNT_RLIMIT_COUNTS = 4,
};

enum rmp_flags {
	RMP_LOCKED = 1,
	RMP_USE_SHARED_ZEROPAGE = 2,
};

enum rmqueue_mode {
	RMQUEUE_NORMAL = 0,
	RMQUEUE_CMA = 1,
	RMQUEUE_CLAIM = 2,
	RMQUEUE_STEAL = 3,
};

enum rockchip_clk_branch_type {
	branch_composite = 0,
	branch_mux = 1,
	branch_grf_mux = 2,
	branch_divider = 3,
	branch_fraction_divider = 4,
	branch_gate = 5,
	branch_grf_gate = 6,
	branch_linked_gate = 7,
	branch_mmc = 8,
	branch_grf_mmc = 9,
	branch_inverter = 10,
	branch_factor = 11,
	branch_ddrclk = 12,
	branch_half_divider = 13,
};

enum rockchip_grf_type {
	grf_type_sys = 0,
	grf_type_pmu0 = 1,
	grf_type_pmu1 = 2,
	grf_type_ioc = 3,
	grf_type_vo = 4,
	grf_type_vpu = 5,
};

enum rockchip_mux_route_location {
	ROCKCHIP_ROUTE_SAME = 0,
	ROCKCHIP_ROUTE_PMU = 1,
	ROCKCHIP_ROUTE_GRF = 2,
};

enum rockchip_pin_drv_type {
	DRV_TYPE_IO_DEFAULT = 0,
	DRV_TYPE_IO_1V8_OR_3V0 = 1,
	DRV_TYPE_IO_1V8_ONLY = 2,
	DRV_TYPE_IO_1V8_3V0_AUTO = 3,
	DRV_TYPE_IO_3V3_ONLY = 4,
	DRV_TYPE_MAX = 5,
};

enum rockchip_pin_pull_type {
	PULL_TYPE_IO_DEFAULT = 0,
	PULL_TYPE_IO_1V8_ONLY = 1,
	PULL_TYPE_MAX = 2,
};

enum rockchip_pinctrl_type {
	PX30 = 0,
	RV1108 = 1,
	RV1126 = 2,
	RK2928 = 3,
	RK3066B = 4,
	RK3128 = 5,
	RK3188 = 6,
	RK3288 = 7,
	RK3308 = 8,
	RK3328 = 9,
	RK3368 = 10,
	RK3399 = 11,
	RK3528 = 12,
	RK3562 = 13,
	RK3568 = 14,
	RK3576 = 15,
	RK3588 = 16,
};

enum rockchip_pll_type {
	pll_rk3036 = 0,
	pll_rk3066 = 1,
	pll_rk3328 = 2,
	pll_rk3399 = 3,
	pll_rk3588 = 4,
	pll_rk3588_core = 5,
	pll_rk3588_ddr = 6,
};

enum rockchip_usb2phy_host_state {
	PHY_STATE_HS_ONLINE = 0,
	PHY_STATE_DISCONNECT = 1,
	PHY_STATE_CONNECT = 2,
	PHY_STATE_FS_LS_ONLINE = 4,
};

enum rockchip_usb2phy_port_id {
	USB2PHY_PORT_OTG = 0,
	USB2PHY_PORT_HOST = 1,
	USB2PHY_NUM_PORTS = 2,
};

enum rohm_chip_type {
	ROHM_CHIP_TYPE_BD9571 = 0,
	ROHM_CHIP_TYPE_BD9573 = 1,
	ROHM_CHIP_TYPE_BD9574 = 2,
	ROHM_CHIP_TYPE_BD9576 = 3,
	ROHM_CHIP_TYPE_BD71815 = 4,
	ROHM_CHIP_TYPE_BD71828 = 5,
	ROHM_CHIP_TYPE_BD71837 = 6,
	ROHM_CHIP_TYPE_BD71847 = 7,
	ROHM_CHIP_TYPE_BD96801 = 8,
	ROHM_CHIP_TYPE_BD96802 = 9,
	ROHM_CHIP_TYPE_BD96805 = 10,
	ROHM_CHIP_TYPE_BD96806 = 11,
	ROHM_CHIP_TYPE_AMOUNT = 12,
};

enum routing_attribute {
	DIRECT_ROUTING = 0,
	SUBTRACTIVE_ROUTING = 1,
	TABLE_ROUTING = 2,
};

enum rpc_accept_stat {
	RPC_SUCCESS = 0,
	RPC_PROG_UNAVAIL = 1,
	RPC_PROG_MISMATCH = 2,
	RPC_PROC_UNAVAIL = 3,
	RPC_GARBAGE_ARGS = 4,
	RPC_SYSTEM_ERR = 5,
	RPC_DROP_REPLY = 60000,
};

enum rpc_auth_flavors {
	RPC_AUTH_NULL = 0,
	RPC_AUTH_UNIX = 1,
	RPC_AUTH_SHORT = 2,
	RPC_AUTH_DES = 3,
	RPC_AUTH_KRB = 4,
	RPC_AUTH_GSS = 6,
	RPC_AUTH_TLS = 7,
	RPC_AUTH_MAXFLAVOR = 8,
	RPC_AUTH_GSS_KRB5 = 390003,
	RPC_AUTH_GSS_KRB5I = 390004,
	RPC_AUTH_GSS_KRB5P = 390005,
	RPC_AUTH_GSS_LKEY = 390006,
	RPC_AUTH_GSS_LKEYI = 390007,
	RPC_AUTH_GSS_LKEYP = 390008,
	RPC_AUTH_GSS_SPKM = 390009,
	RPC_AUTH_GSS_SPKMI = 390010,
	RPC_AUTH_GSS_SPKMP = 390011,
};

enum rpc_auth_stat {
	RPC_AUTH_OK = 0,
	RPC_AUTH_BADCRED = 1,
	RPC_AUTH_REJECTEDCRED = 2,
	RPC_AUTH_BADVERF = 3,
	RPC_AUTH_REJECTEDVERF = 4,
	RPC_AUTH_TOOWEAK = 5,
	RPC_AUTH_INVALIDRESP = 6,
	RPC_AUTH_FAILED = 7,
	RPCSEC_GSS_CREDPROBLEM = 13,
	RPCSEC_GSS_CTXPROBLEM = 14,
};

enum rpc_display_format_t {
	RPC_DISPLAY_ADDR = 0,
	RPC_DISPLAY_PORT = 1,
	RPC_DISPLAY_PROTO = 2,
	RPC_DISPLAY_HEX_ADDR = 3,
	RPC_DISPLAY_HEX_PORT = 4,
	RPC_DISPLAY_NETID = 5,
	RPC_DISPLAY_MAX = 6,
};

enum rpc_gss_proc {
	RPC_GSS_PROC_DATA = 0,
	RPC_GSS_PROC_INIT = 1,
	RPC_GSS_PROC_CONTINUE_INIT = 2,
	RPC_GSS_PROC_DESTROY = 3,
};

enum rpc_gss_svc {
	RPC_GSS_SVC_NONE = 1,
	RPC_GSS_SVC_INTEGRITY = 2,
	RPC_GSS_SVC_PRIVACY = 3,
};

enum rpc_msg_type {
	RPC_CALL = 0,
	RPC_REPLY = 1,
};

enum rpc_reject_stat {
	RPC_MISMATCH = 0,
	RPC_AUTH_ERROR = 1,
};

enum rpc_reply_stat {
	RPC_MSG_ACCEPTED = 0,
	RPC_MSG_DENIED = 1,
};

enum rpi_firmware_clk_id {
	RPI_FIRMWARE_EMMC_CLK_ID = 1,
	RPI_FIRMWARE_UART_CLK_ID = 2,
	RPI_FIRMWARE_ARM_CLK_ID = 3,
	RPI_FIRMWARE_CORE_CLK_ID = 4,
	RPI_FIRMWARE_V3D_CLK_ID = 5,
	RPI_FIRMWARE_H264_CLK_ID = 6,
	RPI_FIRMWARE_ISP_CLK_ID = 7,
	RPI_FIRMWARE_SDRAM_CLK_ID = 8,
	RPI_FIRMWARE_PIXEL_CLK_ID = 9,
	RPI_FIRMWARE_PWM_CLK_ID = 10,
	RPI_FIRMWARE_HEVC_CLK_ID = 11,
	RPI_FIRMWARE_EMMC2_CLK_ID = 12,
	RPI_FIRMWARE_M2MC_CLK_ID = 13,
	RPI_FIRMWARE_PIXEL_BVB_CLK_ID = 14,
	RPI_FIRMWARE_VEC_CLK_ID = 15,
	RPI_FIRMWARE_DISP_CLK_ID = 16,
	RPI_FIRMWARE_NUM_CLK_ID = 17,
};

enum rpi_firmware_property_status {
	RPI_FIRMWARE_STATUS_REQUEST = 0,
	RPI_FIRMWARE_STATUS_SUCCESS = 2147483648,
	RPI_FIRMWARE_STATUS_ERROR = 2147483649,
};

enum rpi_firmware_property_tag {
	RPI_FIRMWARE_PROPERTY_END = 0,
	RPI_FIRMWARE_GET_FIRMWARE_REVISION = 1,
	RPI_FIRMWARE_SET_CURSOR_INFO = 32784,
	RPI_FIRMWARE_SET_CURSOR_STATE = 32785,
	RPI_FIRMWARE_GET_BOARD_MODEL = 65537,
	RPI_FIRMWARE_GET_BOARD_REVISION = 65538,
	RPI_FIRMWARE_GET_BOARD_MAC_ADDRESS = 65539,
	RPI_FIRMWARE_GET_BOARD_SERIAL = 65540,
	RPI_FIRMWARE_GET_ARM_MEMORY = 65541,
	RPI_FIRMWARE_GET_VC_MEMORY = 65542,
	RPI_FIRMWARE_GET_CLOCKS = 65543,
	RPI_FIRMWARE_GET_POWER_STATE = 131073,
	RPI_FIRMWARE_GET_TIMING = 131074,
	RPI_FIRMWARE_SET_POWER_STATE = 163841,
	RPI_FIRMWARE_GET_CLOCK_STATE = 196609,
	RPI_FIRMWARE_GET_CLOCK_RATE = 196610,
	RPI_FIRMWARE_GET_VOLTAGE = 196611,
	RPI_FIRMWARE_GET_MAX_CLOCK_RATE = 196612,
	RPI_FIRMWARE_GET_MAX_VOLTAGE = 196613,
	RPI_FIRMWARE_GET_TEMPERATURE = 196614,
	RPI_FIRMWARE_GET_MIN_CLOCK_RATE = 196615,
	RPI_FIRMWARE_GET_MIN_VOLTAGE = 196616,
	RPI_FIRMWARE_GET_TURBO = 196617,
	RPI_FIRMWARE_GET_MAX_TEMPERATURE = 196618,
	RPI_FIRMWARE_GET_STC = 196619,
	RPI_FIRMWARE_ALLOCATE_MEMORY = 196620,
	RPI_FIRMWARE_LOCK_MEMORY = 196621,
	RPI_FIRMWARE_UNLOCK_MEMORY = 196622,
	RPI_FIRMWARE_RELEASE_MEMORY = 196623,
	RPI_FIRMWARE_EXECUTE_CODE = 196624,
	RPI_FIRMWARE_EXECUTE_QPU = 196625,
	RPI_FIRMWARE_SET_ENABLE_QPU = 196626,
	RPI_FIRMWARE_GET_DISPMANX_RESOURCE_MEM_HANDLE = 196628,
	RPI_FIRMWARE_GET_EDID_BLOCK = 196640,
	RPI_FIRMWARE_GET_CUSTOMER_OTP = 196641,
	RPI_FIRMWARE_GET_DOMAIN_STATE = 196656,
	RPI_FIRMWARE_GET_THROTTLED = 196678,
	RPI_FIRMWARE_GET_CLOCK_MEASURED = 196679,
	RPI_FIRMWARE_NOTIFY_REBOOT = 196680,
	RPI_FIRMWARE_SET_CLOCK_STATE = 229377,
	RPI_FIRMWARE_SET_CLOCK_RATE = 229378,
	RPI_FIRMWARE_SET_VOLTAGE = 229379,
	RPI_FIRMWARE_SET_TURBO = 229385,
	RPI_FIRMWARE_SET_CUSTOMER_OTP = 229409,
	RPI_FIRMWARE_SET_DOMAIN_STATE = 229424,
	RPI_FIRMWARE_GET_GPIO_STATE = 196673,
	RPI_FIRMWARE_SET_GPIO_STATE = 229441,
	RPI_FIRMWARE_SET_SDHOST_CLOCK = 229442,
	RPI_FIRMWARE_GET_GPIO_CONFIG = 196675,
	RPI_FIRMWARE_SET_GPIO_CONFIG = 229443,
	RPI_FIRMWARE_GET_PERIPH_REG = 196677,
	RPI_FIRMWARE_SET_PERIPH_REG = 229445,
	RPI_FIRMWARE_GET_POE_HAT_VAL = 196681,
	RPI_FIRMWARE_SET_POE_HAT_VAL = 196688,
	RPI_FIRMWARE_NOTIFY_XHCI_RESET = 196696,
	RPI_FIRMWARE_NOTIFY_DISPLAY_DONE = 196710,
	RPI_FIRMWARE_FRAMEBUFFER_ALLOCATE = 262145,
	RPI_FIRMWARE_FRAMEBUFFER_BLANK = 262146,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PHYSICAL_WIDTH_HEIGHT = 262147,
	RPI_FIRMWARE_FRAMEBUFFER_GET_VIRTUAL_WIDTH_HEIGHT = 262148,
	RPI_FIRMWARE_FRAMEBUFFER_GET_DEPTH = 262149,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PIXEL_ORDER = 262150,
	RPI_FIRMWARE_FRAMEBUFFER_GET_ALPHA_MODE = 262151,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PITCH = 262152,
	RPI_FIRMWARE_FRAMEBUFFER_GET_VIRTUAL_OFFSET = 262153,
	RPI_FIRMWARE_FRAMEBUFFER_GET_OVERSCAN = 262154,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PALETTE = 262155,
	RPI_FIRMWARE_FRAMEBUFFER_GET_TOUCHBUF = 262159,
	RPI_FIRMWARE_FRAMEBUFFER_GET_GPIOVIRTBUF = 262160,
	RPI_FIRMWARE_FRAMEBUFFER_RELEASE = 294913,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_PHYSICAL_WIDTH_HEIGHT = 278531,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_VIRTUAL_WIDTH_HEIGHT = 278532,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_DEPTH = 278533,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_PIXEL_ORDER = 278534,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_ALPHA_MODE = 278535,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_VIRTUAL_OFFSET = 278537,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_OVERSCAN = 278538,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_PALETTE = 278539,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_VSYNC = 278542,
	RPI_FIRMWARE_FRAMEBUFFER_SET_PHYSICAL_WIDTH_HEIGHT = 294915,
	RPI_FIRMWARE_FRAMEBUFFER_SET_VIRTUAL_WIDTH_HEIGHT = 294916,
	RPI_FIRMWARE_FRAMEBUFFER_SET_DEPTH = 294917,
	RPI_FIRMWARE_FRAMEBUFFER_SET_PIXEL_ORDER = 294918,
	RPI_FIRMWARE_FRAMEBUFFER_SET_ALPHA_MODE = 294919,
	RPI_FIRMWARE_FRAMEBUFFER_SET_VIRTUAL_OFFSET = 294921,
	RPI_FIRMWARE_FRAMEBUFFER_SET_OVERSCAN = 294922,
	RPI_FIRMWARE_FRAMEBUFFER_SET_PALETTE = 294923,
	RPI_FIRMWARE_FRAMEBUFFER_SET_TOUCHBUF = 294943,
	RPI_FIRMWARE_FRAMEBUFFER_SET_GPIOVIRTBUF = 294944,
	RPI_FIRMWARE_FRAMEBUFFER_SET_VSYNC = 294926,
	RPI_FIRMWARE_FRAMEBUFFER_SET_BACKLIGHT = 294927,
	RPI_FIRMWARE_VCHIQ_INIT = 294928,
	RPI_FIRMWARE_GET_COMMAND_LINE = 327681,
	RPI_FIRMWARE_GET_DMA_CHANNELS = 393217,
};

enum rpm_request {
	RPM_REQ_NONE = 0,
	RPM_REQ_IDLE = 1,
	RPM_REQ_SUSPEND = 2,
	RPM_REQ_AUTOSUSPEND = 3,
	RPM_REQ_RESUME = 4,
};

enum rpm_status {
	RPM_INVALID = -1,
	RPM_ACTIVE = 0,
	RPM_RESUMING = 1,
	RPM_SUSPENDED = 2,
	RPM_SUSPENDING = 3,
	RPM_BLOCKED = 4,
};

enum rpmb_type {
	RPMB_TYPE_EMMC = 0,
	RPMB_TYPE_UFS = 1,
	RPMB_TYPE_NVME = 2,
};

enum rpmb_unit_desc_param {
	RPMB_UNIT_DESC_PARAM_LEN = 0,
	RPMB_UNIT_DESC_PARAM_TYPE = 1,
	RPMB_UNIT_DESC_PARAM_UNIT_INDEX = 2,
	RPMB_UNIT_DESC_PARAM_LU_ENABLE = 3,
	RPMB_UNIT_DESC_PARAM_BOOT_LUN_ID = 4,
	RPMB_UNIT_DESC_PARAM_LU_WR_PROTECT = 5,
	RPMB_UNIT_DESC_PARAM_LU_Q_DEPTH = 6,
	RPMB_UNIT_DESC_PARAM_PSA_SENSITIVE = 7,
	RPMB_UNIT_DESC_PARAM_MEM_TYPE = 8,
	RPMB_UNIT_DESC_PARAM_REGION_EN = 9,
	RPMB_UNIT_DESC_PARAM_LOGICAL_BLK_SIZE = 10,
	RPMB_UNIT_DESC_PARAM_LOGICAL_BLK_COUNT = 11,
	RPMB_UNIT_DESC_PARAM_REGION0_SIZE = 19,
	RPMB_UNIT_DESC_PARAM_REGION1_SIZE = 20,
	RPMB_UNIT_DESC_PARAM_REGION2_SIZE = 21,
	RPMB_UNIT_DESC_PARAM_REGION3_SIZE = 22,
	RPMB_UNIT_DESC_PARAM_PROVISIONING_TYPE = 23,
	RPMB_UNIT_DESC_PARAM_PHY_MEM_RSRC_CNT = 24,
};

enum rpmh_regulator_type {
	VRM = 0,
	XOB = 1,
};

enum rpmh_state {
	RPMH_SLEEP_STATE = 0,
	RPMH_WAKE_ONLY_STATE = 1,
	RPMH_ACTIVE_ONLY_STATE = 2,
};

enum rpmsg_ns_flags {
	RPMSG_NS_CREATE = 0,
	RPMSG_NS_DESTROY = 1,
};

enum rproc_crash_type {
	RPROC_MMUFAULT = 0,
	RPROC_WATCHDOG = 1,
	RPROC_FATAL_ERROR = 2,
};

enum rproc_dump_mechanism {
	RPROC_COREDUMP_DISABLED = 0,
	RPROC_COREDUMP_ENABLED = 1,
	RPROC_COREDUMP_INLINE = 2,
};

enum rproc_features {
	RPROC_FEAT_ATTACH_ON_RECOVERY = 0,
	RPROC_MAX_FEATURES = 1,
};

enum rproc_state {
	RPROC_OFFLINE = 0,
	RPROC_SUSPENDED = 1,
	RPROC_RUNNING = 2,
	RPROC_CRASHED = 3,
	RPROC_DELETED = 4,
	RPROC_ATTACHED = 5,
	RPROC_DETACHED = 6,
	RPROC_LAST = 7,
};

enum rpu_oper_mode {
	PM_RPU_MODE_LOCKSTEP = 0,
	PM_RPU_MODE_SPLIT = 1,
};

enum rpu_tcm_comb {
	PM_RPU_TCM_SPLIT = 0,
	PM_RPU_TCM_COMB = 1,
};

enum rq_end_io_ret {
	RQ_END_IO_NONE = 0,
	RQ_END_IO_FREE = 1,
};

enum rq_qos_id {
	RQ_QOS_WBT = 0,
	RQ_QOS_LATENCY = 1,
	RQ_QOS_COST = 2,
};

enum rqf_flags {
	__RQF_STARTED = 0,
	__RQF_FLUSH_SEQ = 1,
	__RQF_MIXED_MERGE = 2,
	__RQF_DONTPREP = 3,
	__RQF_SCHED_TAGS = 4,
	__RQF_USE_SCHED = 5,
	__RQF_FAILED = 6,
	__RQF_QUIET = 7,
	__RQF_IO_STAT = 8,
	__RQF_PM = 9,
	__RQF_HASHED = 10,
	__RQF_STATS = 11,
	__RQF_SPECIAL_PAYLOAD = 12,
	__RQF_ZONE_WRITE_PLUGGING = 13,
	__RQF_TIMED_OUT = 14,
	__RQF_RESV = 15,
	__RQF_BITS = 16,
};

enum rsc_handling_status {
	RSC_HANDLED = 0,
	RSC_IGNORED = 1,
};

enum rseq_cpu_id_state {
	RSEQ_CPU_ID_UNINITIALIZED = -1,
	RSEQ_CPU_ID_REGISTRATION_FAILED = -2,
};

enum rseq_cs_flags {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL = 2,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE = 4,
};

enum rseq_event_mask_bits {
	RSEQ_EVENT_PREEMPT_BIT = 0,
	RSEQ_EVENT_SIGNAL_BIT = 1,
	RSEQ_EVENT_MIGRATE_BIT = 2,
};

enum rseq_flags {
	RSEQ_FLAG_UNREGISTER = 1,
};

enum rswitch_etha_mode {
	EAMC_OPC_RESET = 0,
	EAMC_OPC_DISABLE = 1,
	EAMC_OPC_CONFIG = 2,
	EAMC_OPC_OPERATION = 3,
};

enum rswitch_gwca_mode {
	GWMC_OPC_RESET = 0,
	GWMC_OPC_DISABLE = 1,
	GWMC_OPC_CONFIG = 2,
	GWMC_OPC_OPERATION = 3,
};

enum rswitch_reg {
	FWGC = 0,
	FWTTC0 = 16,
	FWTTC1 = 20,
	FWLBMC = 24,
	FWCEPTC = 32,
	FWCEPRC0 = 36,
	FWCEPRC1 = 40,
	FWCEPRC2 = 44,
	FWCLPTC = 48,
	FWCLPRC = 52,
	FWCMPTC = 64,
	FWEMPTC = 68,
	FWSDMPTC = 80,
	FWSDMPVC = 84,
	FWLBWMC0 = 128,
	FWPC00 = 256,
	FWPC10 = 260,
	FWPC20 = 264,
	FWCTGC00 = 1024,
	FWCTGC10 = 1028,
	FWCTTC00 = 1032,
	FWCTTC10 = 1036,
	FWCTTC200 = 1040,
	FWCTSC00 = 1056,
	FWCTSC10 = 1060,
	FWCTSC20 = 1064,
	FWCTSC30 = 1068,
	FWCTSC40 = 1072,
	FWTWBFC0 = 4096,
	FWTWBFVC0 = 4100,
	FWTHBFC0 = 5120,
	FWTHBFV0C0 = 5124,
	FWTHBFV1C0 = 5128,
	FWFOBFC0 = 6144,
	FWFOBFV0C0 = 6148,
	FWFOBFV1C0 = 6152,
	FWRFC0 = 7168,
	FWRFVC0 = 7172,
	FWCFC0 = 8192,
	FWCFMC00 = 8196,
	FWIP4SC = 16392,
	FWIP6SC = 16408,
	FWIP6OC = 16412,
	FWL2SC = 16416,
	FWSFHEC = 16432,
	FWSHCR0 = 16448,
	FWSHCR1 = 16452,
	FWSHCR2 = 16456,
	FWSHCR3 = 16460,
	FWSHCR4 = 16464,
	FWSHCR5 = 16468,
	FWSHCR6 = 16472,
	FWSHCR7 = 16476,
	FWSHCR8 = 16480,
	FWSHCR9 = 16484,
	FWSHCR10 = 16488,
	FWSHCR11 = 16492,
	FWSHCR12 = 16496,
	FWSHCR13 = 16500,
	FWSHCRR = 16504,
	FWLTHHEC = 16528,
	FWLTHHC = 16532,
	FWLTHTL0 = 16544,
	FWLTHTL1 = 16548,
	FWLTHTL2 = 16552,
	FWLTHTL3 = 16556,
	FWLTHTL4 = 16560,
	FWLTHTL5 = 16564,
	FWLTHTL6 = 16568,
	FWLTHTL7 = 16572,
	FWLTHTL80 = 16576,
	FWLTHTL9 = 16592,
	FWLTHTLR = 16596,
	FWLTHTIM = 16608,
	FWLTHTEM = 16612,
	FWLTHTS0 = 16640,
	FWLTHTS1 = 16644,
	FWLTHTS2 = 16648,
	FWLTHTS3 = 16652,
	FWLTHTS4 = 16656,
	FWLTHTSR0 = 16672,
	FWLTHTSR1 = 16676,
	FWLTHTSR2 = 16680,
	FWLTHTSR3 = 16684,
	FWLTHTSR40 = 16688,
	FWLTHTSR5 = 16704,
	FWLTHTR = 16720,
	FWLTHTRR0 = 16724,
	FWLTHTRR1 = 16728,
	FWLTHTRR2 = 16732,
	FWLTHTRR3 = 16736,
	FWLTHTRR4 = 16740,
	FWLTHTRR5 = 16744,
	FWLTHTRR6 = 16748,
	FWLTHTRR7 = 16752,
	FWLTHTRR8 = 16756,
	FWLTHTRR9 = 16768,
	FWLTHTRR10 = 16784,
	FWIPHEC = 16916,
	FWIPHC = 16920,
	FWIPTL0 = 16928,
	FWIPTL1 = 16932,
	FWIPTL2 = 16936,
	FWIPTL3 = 16940,
	FWIPTL4 = 16944,
	FWIPTL5 = 16948,
	FWIPTL6 = 16952,
	FWIPTL7 = 16960,
	FWIPTL8 = 16976,
	FWIPTLR = 16980,
	FWIPTIM = 16992,
	FWIPTEM = 16996,
	FWIPTS0 = 17008,
	FWIPTS1 = 17012,
	FWIPTS2 = 17016,
	FWIPTS3 = 17020,
	FWIPTS4 = 17024,
	FWIPTSR0 = 17028,
	FWIPTSR1 = 17032,
	FWIPTSR2 = 17036,
	FWIPTSR3 = 17040,
	FWIPTSR4 = 17056,
	FWIPTR = 17072,
	FWIPTRR0 = 17076,
	FWIPTRR1 = 17080,
	FWIPTRR2 = 17084,
	FWIPTRR3 = 17088,
	FWIPTRR4 = 17092,
	FWIPTRR5 = 17096,
	FWIPTRR6 = 17100,
	FWIPTRR7 = 17104,
	FWIPTRR8 = 17120,
	FWIPTRR9 = 17136,
	FWIPHLEC = 17152,
	FWIPAGUSPC = 17664,
	FWIPAGC = 17668,
	FWIPAGM0 = 17680,
	FWIPAGM1 = 17684,
	FWIPAGM2 = 17688,
	FWIPAGM3 = 17692,
	FWIPAGM4 = 17696,
	FWMACHEC = 17952,
	FWMACHC = 17956,
	FWMACTL0 = 17968,
	FWMACTL1 = 17972,
	FWMACTL2 = 17976,
	FWMACTL3 = 17980,
	FWMACTL4 = 17984,
	FWMACTL5 = 18000,
	FWMACTLR = 18004,
	FWMACTIM = 18016,
	FWMACTEM = 18020,
	FWMACTS0 = 18032,
	FWMACTS1 = 18036,
	FWMACTSR0 = 18040,
	FWMACTSR1 = 18044,
	FWMACTSR2 = 18048,
	FWMACTSR3 = 18064,
	FWMACTR = 18080,
	FWMACTRR0 = 18084,
	FWMACTRR1 = 18088,
	FWMACTRR2 = 18092,
	FWMACTRR3 = 18096,
	FWMACTRR4 = 18100,
	FWMACTRR5 = 18112,
	FWMACTRR6 = 18128,
	FWMACHLEC = 18176,
	FWMACAGUSPC = 18560,
	FWMACAGC = 18564,
	FWMACAGM0 = 18568,
	FWMACAGM1 = 18572,
	FWVLANTEC = 18688,
	FWVLANTL0 = 18704,
	FWVLANTL1 = 18708,
	FWVLANTL2 = 18712,
	FWVLANTL3 = 18720,
	FWVLANTL4 = 18736,
	FWVLANTLR = 18740,
	FWVLANTIM = 18752,
	FWVLANTEM = 18756,
	FWVLANTS = 18768,
	FWVLANTSR0 = 18772,
	FWVLANTSR1 = 18776,
	FWVLANTSR2 = 18784,
	FWVLANTSR3 = 18800,
	FWPBFC0 = 18944,
	FWPBFCSDC00 = 18948,
	FWL23URL0 = 19968,
	FWL23URL1 = 19972,
	FWL23URL2 = 19976,
	FWL23URL3 = 19980,
	FWL23URLR = 19984,
	FWL23UTIM = 20000,
	FWL23URR = 20016,
	FWL23URRR0 = 20020,
	FWL23URRR1 = 20024,
	FWL23URRR2 = 20028,
	FWL23URRR3 = 20032,
	FWL23URMC0 = 20224,
	FWPMFGC0 = 20480,
	FWPGFC0 = 20736,
	FWPGFIGSC0 = 20740,
	FWPGFENC0 = 20744,
	FWPGFENM0 = 20748,
	FWPGFCSTC00 = 20752,
	FWPGFCSTC10 = 20756,
	FWPGFCSTM00 = 20760,
	FWPGFCSTM10 = 20764,
	FWPGFCTC0 = 20768,
	FWPGFCTM0 = 20772,
	FWPGFHCC0 = 20776,
	FWPGFSM0 = 20780,
	FWPGFGC0 = 20784,
	FWPGFGL0 = 21760,
	FWPGFGL1 = 21764,
	FWPGFGLR = 21784,
	FWPGFGR = 21776,
	FWPGFGRR0 = 21780,
	FWPGFGRR1 = 21784,
	FWPGFRIM = 21792,
	FWPMTRFC0 = 22016,
	FWPMTRCBSC0 = 22020,
	FWPMTRC0RC0 = 22024,
	FWPMTREBSC0 = 22028,
	FWPMTREIRC0 = 22032,
	FWPMTRFM0 = 22036,
	FWFTL0 = 24576,
	FWFTL1 = 24580,
	FWFTLR = 24584,
	FWFTOC = 24592,
	FWFTOPC = 24596,
	FWFTIM = 24608,
	FWFTR = 24624,
	FWFTRR0 = 24628,
	FWFTRR1 = 24632,
	FWFTRR2 = 24636,
	FWSEQNGC0 = 24832,
	FWSEQNGM0 = 24836,
	FWSEQNRC = 25088,
	FWCTFDCN0 = 25344,
	FWLTHFDCN0 = 25348,
	FWIPFDCN0 = 25352,
	FWLTWFDCN0 = 25356,
	FWPBFDCN0 = 25360,
	FWMHLCN0 = 25364,
	FWIHLCN0 = 25368,
	FWICRDCN0 = 25856,
	FWWMRDCN0 = 25860,
	FWCTRDCN0 = 25864,
	FWLTHRDCN0 = 25868,
	FWIPRDCN0 = 25872,
	FWLTWRDCN0 = 25876,
	FWPBRDCN0 = 25880,
	FWPMFDCN0 = 26368,
	FWPGFDCN0 = 26496,
	FWPMGDCN0 = 26624,
	FWPMYDCN0 = 26628,
	FWPMRDCN0 = 26632,
	FWFRPPCN0 = 27136,
	FWFRDPCN0 = 27140,
	FWEIS00 = 30976,
	FWEIE00 = 30980,
	FWEID00 = 30984,
	FWEIS1 = 31232,
	FWEIE1 = 31236,
	FWEID1 = 31240,
	FWEIS2 = 31248,
	FWEIE2 = 31252,
	FWEID2 = 31256,
	FWEIS3 = 31264,
	FWEIE3 = 31268,
	FWEID3 = 31272,
	FWEIS4 = 31280,
	FWEIE4 = 31284,
	FWEID4 = 31288,
	FWEIS5 = 31296,
	FWEIE5 = 31300,
	FWEID5 = 31304,
	FWEIS60 = 31312,
	FWEIE60 = 31316,
	FWEID60 = 31320,
	FWEIS61 = 31328,
	FWEIE61 = 31332,
	FWEID61 = 31336,
	FWEIS62 = 31344,
	FWEIE62 = 31348,
	FWEID62 = 31352,
	FWEIS63 = 31360,
	FWEIE63 = 31364,
	FWEID63 = 31368,
	FWEIS70 = 31376,
	FWEIE70 = 31380,
	FWEID70 = 31384,
	FWEIS71 = 31392,
	FWEIE71 = 31396,
	FWEID71 = 31400,
	FWEIS72 = 31408,
	FWEIE72 = 31412,
	FWEID72 = 31416,
	FWEIS73 = 31424,
	FWEIE73 = 31428,
	FWEID73 = 31432,
	FWEIS80 = 31440,
	FWEIE80 = 31444,
	FWEID80 = 31448,
	FWEIS81 = 31456,
	FWEIE81 = 31460,
	FWEID81 = 31464,
	FWEIS82 = 31472,
	FWEIE82 = 31476,
	FWEID82 = 31480,
	FWEIS83 = 31488,
	FWEIE83 = 31492,
	FWEID83 = 31496,
	FWMIS0 = 31744,
	FWMIE0 = 31748,
	FWMID0 = 31752,
	FWSCR0 = 32000,
	FWSCR1 = 32004,
	FWSCR2 = 32008,
	FWSCR3 = 32012,
	FWSCR4 = 32016,
	FWSCR5 = 32020,
	FWSCR6 = 32024,
	FWSCR7 = 32028,
	FWSCR8 = 32032,
	FWSCR9 = 32036,
	FWSCR10 = 32040,
	FWSCR11 = 32044,
	FWSCR12 = 32048,
	FWSCR13 = 32052,
	FWSCR14 = 32056,
	FWSCR15 = 32060,
	FWSCR16 = 32064,
	FWSCR17 = 32068,
	FWSCR18 = 32072,
	FWSCR19 = 32076,
	FWSCR20 = 32080,
	FWSCR21 = 32084,
	FWSCR22 = 32088,
	FWSCR23 = 32092,
	FWSCR24 = 32096,
	FWSCR25 = 32100,
	FWSCR26 = 32104,
	FWSCR27 = 32108,
	FWSCR28 = 32112,
	FWSCR29 = 32116,
	FWSCR30 = 32120,
	FWSCR31 = 32124,
	FWSCR32 = 32128,
	FWSCR33 = 32132,
	FWSCR34 = 32136,
	FWSCR35 = 32140,
	FWSCR36 = 32144,
	FWSCR37 = 32148,
	FWSCR38 = 32152,
	FWSCR39 = 32156,
	FWSCR40 = 32160,
	FWSCR41 = 32164,
	FWSCR42 = 32168,
	FWSCR43 = 32172,
	FWSCR44 = 32176,
	FWSCR45 = 32180,
	FWSCR46 = 32184,
	TPEMIMC0 = 32768,
	TPEMIMC1 = 32772,
	TPEMIMC2 = 32776,
	TPEMIMC3 = 32780,
	TPEMIMC4 = 32784,
	TPEMIMC5 = 32788,
	TPEMIMC60 = 32896,
	TPEMIMC70 = 33024,
	TSIM = 34560,
	TFIM = 34564,
	TCIM = 34568,
	TGIM0 = 34576,
	TGIM1 = 34580,
	TEIM0 = 34592,
	TEIM1 = 34596,
	TEIM2 = 34600,
	RIPV = 36864,
	RRC = 36868,
	RCEC = 36872,
	RCDC = 36876,
	RSSIS = 36880,
	RSSIE = 36884,
	RSSID = 36888,
	CABPIBWMC = 36896,
	CABPWMLC = 36928,
	CABPPFLC0 = 36944,
	CABPPWMLC0 = 36960,
	CABPPPFLC00 = 37024,
	CABPULC = 37120,
	CABPIRM = 37184,
	CABPPCM = 37188,
	CABPLCM = 37192,
	CABPCPM = 37248,
	CABPMCPM = 37376,
	CARDNM = 37504,
	CARDMNM = 37508,
	CARDCN = 37520,
	CAEIS0 = 37632,
	CAEIE0 = 37636,
	CAEID0 = 37640,
	CAEIS1 = 37648,
	CAEIE1 = 37652,
	CAEID1 = 37656,
	CAMIS0 = 37696,
	CAMIE0 = 37700,
	CAMID0 = 37704,
	CAMIS1 = 37712,
	CAMIE1 = 37716,
	CAMID1 = 37720,
	CASCR = 37760,
	EAMC = 0,
	EAMS = 4,
	EAIRC = 16,
	EATDQSC = 20,
	EATDQC = 24,
	EATDQAC = 28,
	EATPEC = 32,
	EATMFSC0 = 64,
	EATDQDC0 = 96,
	EATDQM0 = 128,
	EATDQMLM0 = 160,
	EACTQC = 256,
	EACTDQDC = 260,
	EACTDQM = 264,
	EACTDQMLM = 268,
	EAVCC = 304,
	EAVTC = 308,
	EATTFC = 312,
	EACAEC = 512,
	EACC = 516,
	EACAIVC0 = 544,
	EACAULC0 = 576,
	EACOEM = 608,
	EACOIVM0 = 640,
	EACOULM0 = 672,
	EACGSM = 704,
	EATASC = 768,
	EATASENC0 = 800,
	EATASCTENC = 832,
	EATASENM0 = 864,
	EATASCTENM = 896,
	EATASCSTC0 = 928,
	EATASCSTC1 = 932,
	EATASCSTM0 = 936,
	EATASCSTM1 = 940,
	EATASCTC = 944,
	EATASCTM = 948,
	EATASGL0 = 960,
	EATASGL1 = 964,
	EATASGLR = 968,
	EATASGR = 976,
	EATASGRR = 980,
	EATASHCC = 992,
	EATASRIRM = 996,
	EATASSM = 1000,
	EAUSMFSECN = 1024,
	EATFECN = 1028,
	EAFSECN = 1032,
	EADQOECN = 1036,
	EADQSECN = 1040,
	EACKSECN = 1044,
	EAEIS0 = 1280,
	EAEIE0 = 1284,
	EAEID0 = 1288,
	EAEIS1 = 1296,
	EAEIE1 = 1300,
	EAEID1 = 1304,
	EAEIS2 = 1312,
	EAEIE2 = 1316,
	EAEID2 = 1320,
	EASCR = 1408,
	MPSM = 4096,
	MPIC = 4100,
	MPIM = 4104,
	MIOC = 4112,
	MIOM = 4116,
	MXMS = 4120,
	MTFFC = 4128,
	MTPFC = 4132,
	MTPFC2 = 4136,
	MTPFC30 = 4144,
	MTATC0 = 4176,
	MTIM = 4192,
	MRGC = 4224,
	MRMAC0 = 4228,
	MRMAC1 = 4232,
	MRAFC = 4236,
	MRSCE = 4240,
	MRSCP = 4244,
	MRSCC = 4248,
	MRFSCE = 4252,
	MRFSCP = 4256,
	MTRC = 4260,
	MRIM = 4264,
	MRPFM = 4268,
	MPFC0 = 4352,
	MLVC = 4480,
	MEEEC = 4484,
	MLBC = 4488,
	MXGMIIC = 4496,
	MPCH = 4500,
	MANC = 4504,
	MANM = 4508,
	MPLCA1 = 4512,
	MPLCA2 = 4516,
	MPLCA3 = 4520,
	MPLCA4 = 4524,
	MPLCAM = 4528,
	MHDC1 = 4544,
	MHDC2 = 4548,
	MEIS = 4608,
	MEIE = 4612,
	MEID = 4616,
	MMIS0 = 4624,
	MMIE0 = 4628,
	MMID0 = 4632,
	MMIS1 = 4640,
	MMIE1 = 4644,
	MMID1 = 4648,
	MMIS2 = 4656,
	MMIE2 = 4660,
	MMID2 = 4664,
	MMPFTCT = 4864,
	MAPFTCT = 4868,
	MPFRCT = 4872,
	MFCICT = 4876,
	MEEECT = 4880,
	MMPCFTCT0 = 4896,
	MAPCFTCT0 = 4912,
	MPCFRCT0 = 4928,
	MHDCC = 4944,
	MROVFC = 4948,
	MRHCRCEC = 4952,
	MRXBCE = 5120,
	MRXBCP = 5124,
	MRGFCE = 5128,
	MRGFCP = 5132,
	MRBFC = 5136,
	MRMFC = 5140,
	MRUFC = 5144,
	MRPEFC = 5148,
	MRNEFC = 5152,
	MRFMEFC = 5156,
	MRFFMEFC = 5160,
	MRCFCEFC = 5164,
	MRFCEFC = 5168,
	MRRCFEFC = 5172,
	MRUEFC = 5180,
	MROEFC = 5184,
	MRBOEC = 5188,
	MTXBCE = 5376,
	MTXBCP = 5380,
	MTGFCE = 5384,
	MTGFCP = 5388,
	MTBFC = 5392,
	MTMFC = 5396,
	MTUFC = 5400,
	MTEFC = 5404,
	GWMC = 65536,
	GWMS = 65540,
	GWIRC = 65552,
	GWRDQSC = 65556,
	GWRDQC = 65560,
	GWRDQAC = 65564,
	GWRGC = 65568,
	GWRMFSC0 = 65600,
	GWRDQDC0 = 65632,
	GWRDQM0 = 65664,
	GWRDQMLM0 = 65696,
	GWMTIRM = 65792,
	GWMSTLS = 65796,
	GWMSTLR = 65800,
	GWMSTSS = 65804,
	GWMSTSR = 65808,
	GWMAC0 = 65824,
	GWMAC1 = 65828,
	GWVCC = 65840,
	GWVTC = 65844,
	GWTTFC = 65848,
	GWTDCAC00 = 65856,
	GWTDCAC10 = 65860,
	GWTSDCC0 = 65888,
	GWTNM = 65920,
	GWTMNM = 65924,
	GWAC = 65936,
	GWDCBAC0 = 65940,
	GWDCBAC1 = 65944,
	GWIICBSC = 65948,
	GWMDNC = 65952,
	GWTRC0 = 66048,
	GWTPC0 = 66304,
	GWARIRM = 66432,
	GWDCC0 = 66560,
	GWAARSS = 67584,
	GWAARSR0 = 67588,
	GWAARSR1 = 67592,
	GWIDAUAS0 = 67648,
	GWIDASM0 = 67712,
	GWIDASAM00 = 67840,
	GWIDASAM10 = 67844,
	GWIDACAM00 = 67968,
	GWIDACAM10 = 67972,
	GWGRLC = 68096,
	GWGRLULC = 68100,
	GWRLIVC0 = 68224,
	GWRLULC0 = 68228,
	GWIDPC = 68352,
	GWIDC0 = 68608,
	GWDIS0 = 69888,
	GWDIE0 = 69892,
	GWDID0 = 69896,
	GWTSDIS = 70016,
	GWTSDIE = 70020,
	GWTSDID = 70024,
	GWEIS0 = 70032,
	GWEIE0 = 70036,
	GWEID0 = 70040,
	GWEIS1 = 70048,
	GWEIE1 = 70052,
	GWEID1 = 70056,
	GWEIS20 = 70144,
	GWEIE20 = 70148,
	GWEID20 = 70152,
	GWEIS3 = 70272,
	GWEIE3 = 70276,
	GWEID3 = 70280,
	GWEIS4 = 70288,
	GWEIE4 = 70292,
	GWEID4 = 70296,
	GWEIS5 = 70304,
	GWEIE5 = 70308,
	GWEID5 = 70312,
	GWSCR0 = 71680,
	GWSCR1 = 71936,
};

enum rt_class_t {
	RT_TABLE_UNSPEC = 0,
	RT_TABLE_COMPAT = 252,
	RT_TABLE_DEFAULT = 253,
	RT_TABLE_MAIN = 254,
	RT_TABLE_LOCAL = 255,
	RT_TABLE_MAX = 4294967295,
};

enum rt_scope_t {
	RT_SCOPE_UNIVERSE = 0,
	RT_SCOPE_SITE = 200,
	RT_SCOPE_LINK = 253,
	RT_SCOPE_HOST = 254,
	RT_SCOPE_NOWHERE = 255,
};

enum rtattr_type_t {
	RTA_UNSPEC = 0,
	RTA_DST = 1,
	RTA_SRC = 2,
	RTA_IIF = 3,
	RTA_OIF = 4,
	RTA_GATEWAY = 5,
	RTA_PRIORITY = 6,
	RTA_PREFSRC = 7,
	RTA_METRICS = 8,
	RTA_MULTIPATH = 9,
	RTA_PROTOINFO = 10,
	RTA_FLOW = 11,
	RTA_CACHEINFO = 12,
	RTA_SESSION = 13,
	RTA_MP_ALGO = 14,
	RTA_TABLE = 15,
	RTA_MARK = 16,
	RTA_MFC_STATS = 17,
	RTA_VIA = 18,
	RTA_NEWDST = 19,
	RTA_PREF = 20,
	RTA_ENCAP_TYPE = 21,
	RTA_ENCAP = 22,
	RTA_EXPIRES = 23,
	RTA_PAD = 24,
	RTA_UID = 25,
	RTA_TTL_PROPAGATE = 26,
	RTA_IP_PROTO = 27,
	RTA_SPORT = 28,
	RTA_DPORT = 29,
	RTA_NH_ID = 30,
	RTA_FLOWLABEL = 31,
	__RTA_MAX = 32,
};

enum rtmutex_chainwalk {
	RT_MUTEX_MIN_CHAINWALK = 0,
	RT_MUTEX_FULL_CHAINWALK = 1,
};

enum rtnetlink_groups {
	RTNLGRP_NONE = 0,
	RTNLGRP_LINK = 1,
	RTNLGRP_NOTIFY = 2,
	RTNLGRP_NEIGH = 3,
	RTNLGRP_TC = 4,
	RTNLGRP_IPV4_IFADDR = 5,
	RTNLGRP_IPV4_MROUTE = 6,
	RTNLGRP_IPV4_ROUTE = 7,
	RTNLGRP_IPV4_RULE = 8,
	RTNLGRP_IPV6_IFADDR = 9,
	RTNLGRP_IPV6_MROUTE = 10,
	RTNLGRP_IPV6_ROUTE = 11,
	RTNLGRP_IPV6_IFINFO = 12,
	RTNLGRP_DECnet_IFADDR = 13,
	RTNLGRP_NOP2 = 14,
	RTNLGRP_DECnet_ROUTE = 15,
	RTNLGRP_DECnet_RULE = 16,
	RTNLGRP_NOP4 = 17,
	RTNLGRP_IPV6_PREFIX = 18,
	RTNLGRP_IPV6_RULE = 19,
	RTNLGRP_ND_USEROPT = 20,
	RTNLGRP_PHONET_IFADDR = 21,
	RTNLGRP_PHONET_ROUTE = 22,
	RTNLGRP_DCB = 23,
	RTNLGRP_IPV4_NETCONF = 24,
	RTNLGRP_IPV6_NETCONF = 25,
	RTNLGRP_MDB = 26,
	RTNLGRP_MPLS_ROUTE = 27,
	RTNLGRP_NSID = 28,
	RTNLGRP_MPLS_NETCONF = 29,
	RTNLGRP_IPV4_MROUTE_R = 30,
	RTNLGRP_IPV6_MROUTE_R = 31,
	RTNLGRP_NEXTHOP = 32,
	RTNLGRP_BRVLAN = 33,
	RTNLGRP_MCTP_IFADDR = 34,
	RTNLGRP_TUNNEL = 35,
	RTNLGRP_STATS = 36,
	RTNLGRP_IPV4_MCADDR = 37,
	RTNLGRP_IPV6_MCADDR = 38,
	RTNLGRP_IPV6_ACADDR = 39,
	__RTNLGRP_MAX = 40,
};

enum rtnl_kinds {
	RTNL_KIND_NEW = 0,
	RTNL_KIND_DEL = 1,
	RTNL_KIND_GET = 2,
	RTNL_KIND_SET = 3,
};

enum rtnl_link_flags {
	RTNL_FLAG_DOIT_UNLOCKED = 1,
	RTNL_FLAG_BULK_DEL_SUPPORTED = 2,
	RTNL_FLAG_DUMP_UNLOCKED = 4,
	RTNL_FLAG_DUMP_SPLIT_NLM_DONE = 8,
};

enum rtsn_mode {
	OCR_OPC_DISABLE = 0,
	OCR_OPC_CONFIG = 1,
	OCR_OPC_OPERATION = 2,
};

enum rtsn_reg {
	AXIWC = 0,
	AXIRC = 4,
	TDPC0 = 16,
	TFT = 144,
	TATLS0 = 160,
	TATLS1 = 164,
	TATLR = 168,
	RATLS0 = 176,
	RATLS1 = 180,
	RATLR = 184,
	TSA0 = 192,
	TSS0 = 196,
	TRCR0 = 320,
	RIDAUAS0 = 384,
	RR = 512,
	TATS = 528,
	TATSR0 = 532,
	TATSR1 = 536,
	TATSR2 = 540,
	RATS = 544,
	RATSR0 = 548,
	RATSR1 = 552,
	RATSR2 = 556,
	RIDASM0 = 576,
	RIDASAM0 = 580,
	RIDACAM0 = 584,
	EIS0 = 768,
	EIE0 = 772,
	EID0 = 776,
	EIS1 = 784,
	EIE1 = 788,
	EID1 = 792,
	TCEIS0 = 832,
	TCEIE0 = 836,
	TCEID0 = 840,
	RFSEIS0 = 1216,
	RFSEIE0 = 1220,
	RFSEID0 = 1224,
	RFEIS0 = 1344,
	RFEIE0 = 1348,
	RFEID0 = 1352,
	RCEIS0 = 1472,
	RCEIE0 = 1476,
	RCEID0 = 1480,
	RIDAOIS = 1600,
	RIDAOIE = 1604,
	RIDAOID = 1608,
	TSFEIS = 1728,
	TSFEIE = 1732,
	TSFEID = 1736,
	TSCEIS = 1744,
	TSCEIE = 1748,
	TSCEID = 1752,
	DIS___2 = 2816,
	DIE___2 = 2820,
	DID = 2824,
	TDIS0 = 2832,
	TDIE0 = 2836,
	TDID0 = 2840,
	RDIS0 = 2960,
	RDIE0 = 2964,
	RDID0 = 2968,
	TSDIS = 3088,
	TSDIE = 3092,
	TSDID = 3096,
	GPOUT = 24576,
	OCR = 4096,
	OSR = 4100,
	SWR = 4104,
	SIS = 4108,
	GIS___2 = 4112,
	GIE___2 = 4116,
	GID___2 = 4120,
	TIS1 = 4128,
	TIE1 = 4132,
	TID1 = 4136,
	TIS2 = 4144,
	TIE2 = 4148,
	TID2 = 4152,
	RIS = 4160,
	RIE = 4164,
	RID = 4168,
	TGC1 = 4176,
	TGC2 = 4180,
	TFS0 = 4192,
	TCF0 = 4208,
	TCR1 = 4224,
	TCR2 = 4228,
	TCR3 = 4232,
	TCR4 = 4236,
	TMS0 = 4240,
	TSR1 = 4272,
	TSR2 = 4276,
	TSR3 = 4280,
	TSR4 = 4284,
	TSR5 = 4288,
	RGC = 4304,
	RDFCR = 4308,
	RCFCR = 4312,
	REFCNCR = 4316,
	RSR1 = 4320,
	RSR2 = 4324,
	RSR3 = 4328,
	TCIS = 4576,
	TCIE = 4580,
	TCID = 4584,
	TPTPC = 4592,
	TTML = 4596,
	TTJ = 4600,
	TCC = 4608,
	TCS = 4612,
	TGS = 4620,
	TACST0 = 4624,
	TACST1 = 4628,
	TACST2 = 4632,
	TALIT0 = 4640,
	TALIT1 = 4644,
	TALIT2 = 4648,
	TAEN0 = 4656,
	TAEN1 = 4660,
	TASFE = 4672,
	TACLL0 = 4688,
	TACLL1 = 4692,
	TACLL2 = 4696,
	CACC = 4704,
	CCS = 4708,
	CAIV0 = 4720,
	CAUL0 = 4752,
	TOCST0 = 4864,
	TOCST1 = 4868,
	TOCST2 = 4872,
	TOLIT0 = 4880,
	TOLIT1 = 4884,
	TOLIT2 = 4888,
	TOEN0 = 4896,
	TOEN1 = 4900,
	TOSFE = 4912,
	TCLR0 = 4928,
	TCLR1 = 4932,
	TCLR2 = 4936,
	TSMS = 4944,
	COCC = 4960,
	COIV0 = 5040,
	COUL0 = 5072,
	QSTMACU0 = 5120,
	QSTMACD0 = 5124,
	QSTMAMU0 = 5128,
	QSTMAMD0 = 5132,
	QSFTVL0 = 5136,
	QSFTVLM0 = 5140,
	QSFTMSD0 = 5144,
	QSFTGMI0 = 5148,
	QSFTLS = 5632,
	QSFTLIS = 5636,
	QSFTLIE = 5640,
	QSFTLID = 5644,
	QSMSMC = 5648,
	QSGTMC = 5652,
	QSEIS = 5656,
	QSEIE = 5660,
	QSEID = 5664,
	QGACST0 = 5680,
	QGACST1 = 5684,
	QGACST2 = 5688,
	QGALIT1 = 5696,
	QGALIT2 = 5700,
	QGAEN0 = 5704,
	QGAEN1 = 5964,
	QGIGS = 5712,
	QGGC = 5716,
	QGATL0 = 5732,
	QGATL1 = 5736,
	QGATL2 = 5740,
	QGOCST0 = 5744,
	QGOCST1 = 5748,
	QGOCST2 = 5752,
	QGOLIT0 = 5756,
	QGOLIT1 = 5760,
	QGOLIT2 = 5764,
	QGOEN0 = 5768,
	QGOEN1 = 5772,
	QGTRO = 5776,
	QGTR1 = 5780,
	QGTR2 = 5784,
	QGFSMS = 5788,
	QTMIS = 5856,
	QTMIE = 5860,
	QTMID = 5864,
	QMEC = 5888,
	QMMC = 5892,
	QRFDC = 5896,
	QYFDC = 5900,
	QVTCMC0 = 5904,
	QMCBSC0 = 5968,
	QMCIRC0 = 6032,
	QMEBSC0 = 6096,
	QMEIRC0 = 5904,
	QMCFC = 6224,
	QMEIS = 6240,
	QMEIE = 6244,
	QMEID = 6252,
	QSMFC0 = 6256,
	QMSPPC0 = 6320,
	QMSRPC0 = 6384,
	QGPPC0 = 6448,
	QGRPC0 = 6480,
	QMDPC0 = 6512,
	QMGPC0 = 6576,
	QMYPC0 = 6640,
	QMRPC0 = 6704,
	MQSTMACU = 6768,
	MQSTMACD = 6772,
	MQSTMAMU = 6776,
	MQSTMAMD = 6780,
	MQSFTVL = 6784,
	MQSFTVLM = 6788,
	MQSFTMSD = 6792,
	MQSFTGMI = 6796,
	CFCR0 = 10240,
	FMSCR = 11280,
	MMC = 14336,
	MPSM___2 = 14352,
	MPIC___2 = 14356,
	MTFFC___2 = 14368,
	MTPFC___2 = 14372,
	MTATC0___2 = 14400,
	MRGC___2 = 14464,
	MRMAC0___2 = 14468,
	MRMAC1___2 = 14472,
	MRAFC___2 = 14476,
	MRSCE___2 = 14480,
	MRSCP___2 = 14484,
	MRSCC___2 = 14488,
	MRFSCE___2 = 14492,
	MRFSCP___2 = 14496,
	MTRC___2 = 14500,
	MPFC = 14592,
	MLVC___2 = 15168,
	MEEEC___2 = 15184,
	MLBC___2 = 15200,
	MGMR = 15360,
	MMPFTCT___2 = 15376,
	MAPFTCT___2 = 15380,
	MPFRCT___2 = 15384,
	MFCICT___2 = 15388,
	MEEECT___2 = 15392,
	MEIS___2 = 15616,
	MEIE___2 = 15620,
	MEID___2 = 15624,
	MMIS0___2 = 15632,
	MMIE0___2 = 15636,
	MMID0___2 = 15640,
	MMIS1___2 = 15648,
	MMIE1___2 = 15652,
	MMID1___2 = 15656,
	MMIS2___2 = 15664,
	MMIE2___2 = 15668,
	MMID2___2 = 15672,
	MXMS___2 = 15872,
};

enum rw_hint {
	WRITE_LIFE_NOT_SET = 0,
	WRITE_LIFE_NONE = 1,
	WRITE_LIFE_SHORT = 2,
	WRITE_LIFE_MEDIUM = 3,
	WRITE_LIFE_LONG = 4,
	WRITE_LIFE_EXTREME = 5,
	WRITE_LIFE_HINT_NR = 6,
} __attribute__((mode(byte)));

enum rwsem_waiter_type {
	RWSEM_WAITING_FOR_WRITE = 0,
	RWSEM_WAITING_FOR_READ = 1,
};

enum rwsem_wake_type {
	RWSEM_WAKE_ANY = 0,
	RWSEM_WAKE_READERS = 1,
	RWSEM_WAKE_READ_OWNED = 2,
};

enum rwsig_action {
	RWSIG_ACTION_ABORT = 0,
	RWSIG_ACTION_CONTINUE = 1,
};

enum rx_handler_result {
	RX_HANDLER_CONSUMED = 0,
	RX_HANDLER_ANOTHER = 1,
	RX_HANDLER_EXACT = 2,
	RX_HANDLER_PASS = 3,
};

typedef enum rx_handler_result rx_handler_result_t;

enum rx_stats_reg_offset {
	RX_OCTS = 0,
	RX_UCAST = 1,
	RX_BCAST = 2,
	RX_MCAST = 3,
	RX_RED = 4,
	RX_RED_OCTS = 5,
	RX_ORUN = 6,
	RX_ORUN_OCTS = 7,
	RX_FCS = 8,
	RX_L2ERR = 9,
	RX_DRP_BCAST = 10,
	RX_DRP_MCAST = 11,
	RX_DRP_L3BCAST = 12,
	RX_DRP_L3MCAST = 13,
	RX_STATS_ENUM_LAST = 14,
};

enum rz_dmac_prep_type {
	RZ_DMAC_DESC_MEMCPY = 0,
	RZ_DMAC_DESC_SLAVE_SG = 1,
};

enum rz_mtu3_channels {
	RZ_MTU3_CHAN_0 = 0,
	RZ_MTU3_CHAN_1 = 1,
	RZ_MTU3_CHAN_2 = 2,
	RZ_MTU3_CHAN_3 = 3,
	RZ_MTU3_CHAN_4 = 4,
	RZ_MTU3_CHAN_5 = 5,
	RZ_MTU3_CHAN_6 = 6,
	RZ_MTU3_CHAN_7 = 7,
	RZ_MTU3_CHAN_8 = 8,
	RZ_MTU_NUM_CHANNELS = 9,
};

enum rz_wdt_type {
	WDT_RZG2L = 0,
	WDT_RZV2M = 1,
};

enum rzg2l_iolh_index {
	RZG2L_IOLH_IDX_1V8 = 0,
	RZG2L_IOLH_IDX_2V5 = 4,
	RZG2L_IOLH_IDX_3V3 = 8,
	RZG2L_IOLH_IDX_MAX = 12,
};

enum rzt2h_clk_types {
	CLK_TYPE_RZT2H_DIV = 5,
	CLK_TYPE_RZT2H_MUX = 6,
};

enum rzv2h_wdt_count_source {
	COUNT_SOURCE_LOCO = 0,
	COUNT_SOURCE_PCLK = 1,
};

enum s2idle_states {
	S2IDLE_STATE_NONE = 0,
	S2IDLE_STATE_ENTER = 1,
	S2IDLE_STATE_WAKE = 2,
};

enum s2mpa01_reg {
	S2MPA01_REG_ID = 0,
	S2MPA01_REG_INT1 = 1,
	S2MPA01_REG_INT2 = 2,
	S2MPA01_REG_INT3 = 3,
	S2MPA01_REG_INT1M = 4,
	S2MPA01_REG_INT2M = 5,
	S2MPA01_REG_INT3M = 6,
	S2MPA01_REG_ST1 = 7,
	S2MPA01_REG_ST2 = 8,
	S2MPA01_REG_PWRONSRC = 9,
	S2MPA01_REG_OFFSRC = 10,
	S2MPA01_REG_RTC_BUF = 11,
	S2MPA01_REG_CTRL1 = 12,
	S2MPA01_REG_ETC_TEST = 13,
	S2MPA01_REG_RSVD1 = 14,
	S2MPA01_REG_BU_CHG = 15,
	S2MPA01_REG_RAMP1 = 16,
	S2MPA01_REG_RAMP2 = 17,
	S2MPA01_REG_LDO_DSCH1 = 18,
	S2MPA01_REG_LDO_DSCH2 = 19,
	S2MPA01_REG_LDO_DSCH3 = 20,
	S2MPA01_REG_LDO_DSCH4 = 21,
	S2MPA01_REG_OTP_ADRL = 22,
	S2MPA01_REG_OTP_ADRH = 23,
	S2MPA01_REG_OTP_DATA = 24,
	S2MPA01_REG_MON1SEL = 25,
	S2MPA01_REG_MON2SEL = 26,
	S2MPA01_REG_LEE = 27,
	S2MPA01_REG_RSVD2 = 28,
	S2MPA01_REG_RSVD3 = 29,
	S2MPA01_REG_RSVD4 = 30,
	S2MPA01_REG_RSVD5 = 31,
	S2MPA01_REG_RSVD6 = 32,
	S2MPA01_REG_TOP_RSVD = 33,
	S2MPA01_REG_DVS_SEL = 34,
	S2MPA01_REG_DVS_PTR = 35,
	S2MPA01_REG_DVS_DATA = 36,
	S2MPA01_REG_RSVD_NO = 37,
	S2MPA01_REG_UVLO = 38,
	S2MPA01_REG_LEE_NO = 39,
	S2MPA01_REG_B1CTRL1 = 40,
	S2MPA01_REG_B1CTRL2 = 41,
	S2MPA01_REG_B2CTRL1 = 42,
	S2MPA01_REG_B2CTRL2 = 43,
	S2MPA01_REG_B3CTRL1 = 44,
	S2MPA01_REG_B3CTRL2 = 45,
	S2MPA01_REG_B4CTRL1 = 46,
	S2MPA01_REG_B4CTRL2 = 47,
	S2MPA01_REG_B5CTRL1 = 48,
	S2MPA01_REG_B5CTRL2 = 49,
	S2MPA01_REG_B5CTRL3 = 50,
	S2MPA01_REG_B5CTRL4 = 51,
	S2MPA01_REG_B5CTRL5 = 52,
	S2MPA01_REG_B5CTRL6 = 53,
	S2MPA01_REG_B6CTRL1 = 54,
	S2MPA01_REG_B6CTRL2 = 55,
	S2MPA01_REG_B7CTRL1 = 56,
	S2MPA01_REG_B7CTRL2 = 57,
	S2MPA01_REG_B8CTRL1 = 58,
	S2MPA01_REG_B8CTRL2 = 59,
	S2MPA01_REG_B9CTRL1 = 60,
	S2MPA01_REG_B9CTRL2 = 61,
	S2MPA01_REG_B10CTRL1 = 62,
	S2MPA01_REG_B10CTRL2 = 63,
	S2MPA01_REG_L1CTRL = 64,
	S2MPA01_REG_L2CTRL = 65,
	S2MPA01_REG_L3CTRL = 66,
	S2MPA01_REG_L4CTRL = 67,
	S2MPA01_REG_L5CTRL = 68,
	S2MPA01_REG_L6CTRL = 69,
	S2MPA01_REG_L7CTRL = 70,
	S2MPA01_REG_L8CTRL = 71,
	S2MPA01_REG_L9CTRL = 72,
	S2MPA01_REG_L10CTRL = 73,
	S2MPA01_REG_L11CTRL = 74,
	S2MPA01_REG_L12CTRL = 75,
	S2MPA01_REG_L13CTRL = 76,
	S2MPA01_REG_L14CTRL = 77,
	S2MPA01_REG_L15CTRL = 78,
	S2MPA01_REG_L16CTRL = 79,
	S2MPA01_REG_L17CTRL = 80,
	S2MPA01_REG_L18CTRL = 81,
	S2MPA01_REG_L19CTRL = 82,
	S2MPA01_REG_L20CTRL = 83,
	S2MPA01_REG_L21CTRL = 84,
	S2MPA01_REG_L22CTRL = 85,
	S2MPA01_REG_L23CTRL = 86,
	S2MPA01_REG_L24CTRL = 87,
	S2MPA01_REG_L25CTRL = 88,
	S2MPA01_REG_L26CTRL = 89,
	S2MPA01_REG_LDO_OVCB1 = 90,
	S2MPA01_REG_LDO_OVCB2 = 91,
	S2MPA01_REG_LDO_OVCB3 = 92,
	S2MPA01_REG_LDO_OVCB4 = 93,
};

enum s2mpg10_irq {
	S2MPG10_IRQ_PWRONF = 0,
	S2MPG10_IRQ_PWRONR = 1,
	S2MPG10_IRQ_JIGONBF = 2,
	S2MPG10_IRQ_JIGONBR = 3,
	S2MPG10_IRQ_ACOKBF = 4,
	S2MPG10_IRQ_ACOKBR = 5,
	S2MPG10_IRQ_PWRON1S = 6,
	S2MPG10_IRQ_MRB = 7,
	S2MPG10_IRQ_RTC60S = 8,
	S2MPG10_IRQ_RTCA1 = 9,
	S2MPG10_IRQ_RTCA0 = 10,
	S2MPG10_IRQ_RTC1S = 11,
	S2MPG10_IRQ_WTSR_COLDRST = 12,
	S2MPG10_IRQ_WTSR = 13,
	S2MPG10_IRQ_WRST = 14,
	S2MPG10_IRQ_SMPL = 15,
	S2MPG10_IRQ_120C = 16,
	S2MPG10_IRQ_140C = 17,
	S2MPG10_IRQ_TSD = 18,
	S2MPG10_IRQ_PIF_TIMEOUT1 = 19,
	S2MPG10_IRQ_PIF_TIMEOUT2 = 20,
	S2MPG10_IRQ_SPD_PARITY_ERR = 21,
	S2MPG10_IRQ_SPD_ABNORMAL_STOP = 22,
	S2MPG10_IRQ_PMETER_OVERF = 23,
	S2MPG10_IRQ_OCP_B1M = 24,
	S2MPG10_IRQ_OCP_B2M = 25,
	S2MPG10_IRQ_OCP_B3M = 26,
	S2MPG10_IRQ_OCP_B4M = 27,
	S2MPG10_IRQ_OCP_B5M = 28,
	S2MPG10_IRQ_OCP_B6M = 29,
	S2MPG10_IRQ_OCP_B7M = 30,
	S2MPG10_IRQ_OCP_B8M = 31,
	S2MPG10_IRQ_OCP_B9M = 32,
	S2MPG10_IRQ_OCP_B10M = 33,
	S2MPG10_IRQ_WLWP_ACC = 34,
	S2MPG10_IRQ_SMPL_TIMEOUT = 35,
	S2MPG10_IRQ_WTSR_TIMEOUT = 36,
	S2MPG10_IRQ_SPD_SRP_PKT_RST = 37,
	S2MPG10_IRQ_PWR_WARN_CH0 = 38,
	S2MPG10_IRQ_PWR_WARN_CH1 = 39,
	S2MPG10_IRQ_PWR_WARN_CH2 = 40,
	S2MPG10_IRQ_PWR_WARN_CH3 = 41,
	S2MPG10_IRQ_PWR_WARN_CH4 = 42,
	S2MPG10_IRQ_PWR_WARN_CH5 = 43,
	S2MPG10_IRQ_PWR_WARN_CH6 = 44,
	S2MPG10_IRQ_PWR_WARN_CH7 = 45,
	S2MPG10_IRQ_NR = 46,
};

enum s2mpg10_pmic_reg {
	S2MPG10_PMIC_INT1 = 0,
	S2MPG10_PMIC_INT2 = 1,
	S2MPG10_PMIC_INT3 = 2,
	S2MPG10_PMIC_INT4 = 3,
	S2MPG10_PMIC_INT5 = 4,
	S2MPG10_PMIC_INT6 = 5,
	S2MPG10_PMIC_INT1M = 6,
	S2MPG10_PMIC_INT2M = 7,
	S2MPG10_PMIC_INT3M = 8,
	S2MPG10_PMIC_INT4M = 9,
	S2MPG10_PMIC_INT5M = 10,
	S2MPG10_PMIC_INT6M = 11,
	S2MPG10_PMIC_STATUS1 = 12,
	S2MPG10_PMIC_STATUS2 = 13,
	S2MPG10_PMIC_PWRONSRC = 14,
	S2MPG10_PMIC_OFFSRC = 15,
	S2MPG10_PMIC_BU_CHG = 16,
	S2MPG10_PMIC_RTCBUF = 17,
	S2MPG10_PMIC_COMMON_CTRL1 = 18,
	S2MPG10_PMIC_COMMON_CTRL2 = 19,
	S2MPG10_PMIC_COMMON_CTRL3 = 20,
	S2MPG10_PMIC_COMMON_CTRL4 = 21,
	S2MPG10_PMIC_SMPL_WARN_CTRL = 22,
	S2MPG10_PMIC_MIMICKING_CTRL = 23,
	S2MPG10_PMIC_B1M_CTRL = 24,
	S2MPG10_PMIC_B1M_OUT1 = 25,
	S2MPG10_PMIC_B1M_OUT2 = 26,
	S2MPG10_PMIC_B2M_CTRL = 27,
	S2MPG10_PMIC_B2M_OUT1 = 28,
	S2MPG10_PMIC_B2M_OUT2 = 29,
	S2MPG10_PMIC_B3M_CTRL = 30,
	S2MPG10_PMIC_B3M_OUT1 = 31,
	S2MPG10_PMIC_B3M_OUT2 = 32,
	S2MPG10_PMIC_B4M_CTRL = 33,
	S2MPG10_PMIC_B4M_OUT1 = 34,
	S2MPG10_PMIC_B4M_OUT2 = 35,
	S2MPG10_PMIC_B5M_CTRL = 36,
	S2MPG10_PMIC_B5M_OUT1 = 37,
	S2MPG10_PMIC_B5M_OUT2 = 38,
	S2MPG10_PMIC_B6M_CTRL = 39,
	S2MPG10_PMIC_B6M_OUT1 = 40,
	S2MPG10_PMIC_B6M_OUT2 = 41,
	S2MPG10_PMIC_B7M_CTRL = 42,
	S2MPG10_PMIC_B7M_OUT1 = 43,
	S2MPG10_PMIC_B7M_OUT2 = 44,
	S2MPG10_PMIC_B8M_CTRL = 45,
	S2MPG10_PMIC_B8M_OUT1 = 46,
	S2MPG10_PMIC_B8M_OUT2 = 47,
	S2MPG10_PMIC_B9M_CTRL = 48,
	S2MPG10_PMIC_B9M_OUT1 = 49,
	S2MPG10_PMIC_B9M_OUT2 = 50,
	S2MPG10_PMIC_B10M_CTRL = 51,
	S2MPG10_PMIC_B10M_OUT1 = 52,
	S2MPG10_PMIC_B10M_OUT2 = 53,
	S2MPG10_PMIC_BUCK1M_USONIC = 54,
	S2MPG10_PMIC_BUCK2M_USONIC = 55,
	S2MPG10_PMIC_BUCK3M_USONIC = 56,
	S2MPG10_PMIC_BUCK4M_USONIC = 57,
	S2MPG10_PMIC_BUCK5M_USONIC = 58,
	S2MPG10_PMIC_BUCK6M_USONIC = 59,
	S2MPG10_PMIC_BUCK7M_USONIC = 60,
	S2MPG10_PMIC_BUCK8M_USONIC = 61,
	S2MPG10_PMIC_BUCK9M_USONIC = 62,
	S2MPG10_PMIC_BUCK10M_USONIC = 63,
	S2MPG10_PMIC_L1M_CTRL = 64,
	S2MPG10_PMIC_L2M_CTRL = 65,
	S2MPG10_PMIC_L3M_CTRL = 66,
	S2MPG10_PMIC_L4M_CTRL = 67,
	S2MPG10_PMIC_L5M_CTRL = 68,
	S2MPG10_PMIC_L6M_CTRL = 69,
	S2MPG10_PMIC_L7M_CTRL = 70,
	S2MPG10_PMIC_L8M_CTRL = 71,
	S2MPG10_PMIC_L9M_CTRL = 72,
	S2MPG10_PMIC_L10M_CTRL = 73,
	S2MPG10_PMIC_L11M_CTRL1 = 74,
	S2MPG10_PMIC_L11M_CTRL2 = 75,
	S2MPG10_PMIC_L12M_CTRL1 = 76,
	S2MPG10_PMIC_L12M_CTRL2 = 77,
	S2MPG10_PMIC_L13M_CTRL1 = 78,
	S2MPG10_PMIC_L13M_CTRL2 = 79,
	S2MPG10_PMIC_L14M_CTRL = 80,
	S2MPG10_PMIC_L15M_CTRL1 = 81,
	S2MPG10_PMIC_L15M_CTRL2 = 82,
	S2MPG10_PMIC_L16M_CTRL = 83,
	S2MPG10_PMIC_L17M_CTRL = 84,
	S2MPG10_PMIC_L18M_CTRL = 85,
	S2MPG10_PMIC_L19M_CTRL = 86,
	S2MPG10_PMIC_L20M_CTRL = 87,
	S2MPG10_PMIC_L21M_CTRL = 88,
	S2MPG10_PMIC_L22M_CTRL = 89,
	S2MPG10_PMIC_L23M_CTRL = 90,
	S2MPG10_PMIC_L24M_CTRL = 91,
	S2MPG10_PMIC_L25M_CTRL = 92,
	S2MPG10_PMIC_L26M_CTRL = 93,
	S2MPG10_PMIC_L27M_CTRL = 94,
	S2MPG10_PMIC_L28M_CTRL = 95,
	S2MPG10_PMIC_L29M_CTRL = 96,
	S2MPG10_PMIC_L30M_CTRL = 97,
	S2MPG10_PMIC_L31M_CTRL = 98,
	S2MPG10_PMIC_LDO_CTRL1 = 99,
	S2MPG10_PMIC_LDO_CTRL2 = 100,
	S2MPG10_PMIC_LDO_DSCH1 = 101,
	S2MPG10_PMIC_LDO_DSCH2 = 102,
	S2MPG10_PMIC_LDO_DSCH3 = 103,
	S2MPG10_PMIC_LDO_DSCH4 = 104,
	S2MPG10_PMIC_LDO_BUCK7M_HLIMIT = 105,
	S2MPG10_PMIC_LDO_BUCK7M_LLIMIT = 106,
	S2MPG10_PMIC_LDO_LDO21M_HLIMIT = 107,
	S2MPG10_PMIC_LDO_LDO21M_LLIMIT = 108,
	S2MPG10_PMIC_LDO_LDO11M_HLIMIT = 109,
	S2MPG10_PMIC_DVS_RAMP1 = 110,
	S2MPG10_PMIC_DVS_RAMP2 = 111,
	S2MPG10_PMIC_DVS_RAMP3 = 112,
	S2MPG10_PMIC_DVS_RAMP4 = 113,
	S2MPG10_PMIC_DVS_RAMP5 = 114,
	S2MPG10_PMIC_DVS_RAMP6 = 115,
	S2MPG10_PMIC_DVS_SYNC_CTRL1 = 116,
	S2MPG10_PMIC_DVS_SYNC_CTRL2 = 117,
	S2MPG10_PMIC_DVS_SYNC_CTRL3 = 118,
	S2MPG10_PMIC_DVS_SYNC_CTRL4 = 119,
	S2MPG10_PMIC_DVS_SYNC_CTRL5 = 120,
	S2MPG10_PMIC_DVS_SYNC_CTRL6 = 121,
	S2MPG10_PMIC_OFF_CTRL1 = 122,
	S2MPG10_PMIC_OFF_CTRL2 = 123,
	S2MPG10_PMIC_OFF_CTRL3 = 124,
	S2MPG10_PMIC_OFF_CTRL4 = 125,
	S2MPG10_PMIC_SEQ_CTRL1 = 126,
	S2MPG10_PMIC_SEQ_CTRL2 = 127,
	S2MPG10_PMIC_SEQ_CTRL3 = 128,
	S2MPG10_PMIC_SEQ_CTRL4 = 129,
	S2MPG10_PMIC_SEQ_CTRL5 = 130,
	S2MPG10_PMIC_SEQ_CTRL6 = 131,
	S2MPG10_PMIC_SEQ_CTRL7 = 132,
	S2MPG10_PMIC_SEQ_CTRL8 = 133,
	S2MPG10_PMIC_SEQ_CTRL9 = 134,
	S2MPG10_PMIC_SEQ_CTRL10 = 135,
	S2MPG10_PMIC_SEQ_CTRL11 = 136,
	S2MPG10_PMIC_SEQ_CTRL12 = 137,
	S2MPG10_PMIC_SEQ_CTRL13 = 138,
	S2MPG10_PMIC_SEQ_CTRL14 = 139,
	S2MPG10_PMIC_SEQ_CTRL15 = 140,
	S2MPG10_PMIC_SEQ_CTRL16 = 141,
	S2MPG10_PMIC_SEQ_CTRL17 = 142,
	S2MPG10_PMIC_SEQ_CTRL18 = 143,
	S2MPG10_PMIC_SEQ_CTRL19 = 144,
	S2MPG10_PMIC_SEQ_CTRL20 = 145,
	S2MPG10_PMIC_SEQ_CTRL21 = 146,
	S2MPG10_PMIC_SEQ_CTRL22 = 147,
	S2MPG10_PMIC_SEQ_CTRL23 = 148,
	S2MPG10_PMIC_SEQ_CTRL24 = 149,
	S2MPG10_PMIC_SEQ_CTRL25 = 150,
	S2MPG10_PMIC_SEQ_CTRL26 = 151,
	S2MPG10_PMIC_SEQ_CTRL27 = 152,
	S2MPG10_PMIC_SEQ_CTRL28 = 153,
	S2MPG10_PMIC_SEQ_CTRL29 = 154,
	S2MPG10_PMIC_SEQ_CTRL30 = 155,
	S2MPG10_PMIC_SEQ_CTRL31 = 156,
	S2MPG10_PMIC_SEQ_CTRL32 = 157,
	S2MPG10_PMIC_SEQ_CTRL33 = 158,
	S2MPG10_PMIC_SEQ_CTRL34 = 159,
	S2MPG10_PMIC_SEQ_CTRL35 = 160,
	S2MPG10_PMIC_OFF_SEQ_CTRL1 = 161,
	S2MPG10_PMIC_OFF_SEQ_CTRL2 = 162,
	S2MPG10_PMIC_OFF_SEQ_CTRL3 = 163,
	S2MPG10_PMIC_OFF_SEQ_CTRL4 = 164,
	S2MPG10_PMIC_OFF_SEQ_CTRL5 = 165,
	S2MPG10_PMIC_OFF_SEQ_CTRL6 = 166,
	S2MPG10_PMIC_OFF_SEQ_CTRL7 = 167,
	S2MPG10_PMIC_OFF_SEQ_CTRL8 = 168,
	S2MPG10_PMIC_OFF_SEQ_CTRL9 = 169,
	S2MPG10_PMIC_OFF_SEQ_CTRL10 = 170,
	S2MPG10_PMIC_OFF_SEQ_CTRL11 = 171,
	S2MPG10_PMIC_OFF_SEQ_CTRL12 = 172,
	S2MPG10_PMIC_OFF_SEQ_CTRL13 = 173,
	S2MPG10_PMIC_OFF_SEQ_CTRL14 = 174,
	S2MPG10_PMIC_OFF_SEQ_CTRL15 = 175,
	S2MPG10_PMIC_OFF_SEQ_CTRL16 = 176,
	S2MPG10_PMIC_OFF_SEQ_CTRL17 = 177,
	S2MPG10_PMIC_OFF_SEQ_CTRL18 = 178,
	S2MPG10_PMIC_PCTRLSEL1 = 179,
	S2MPG10_PMIC_PCTRLSEL2 = 180,
	S2MPG10_PMIC_PCTRLSEL3 = 181,
	S2MPG10_PMIC_PCTRLSEL4 = 182,
	S2MPG10_PMIC_PCTRLSEL5 = 183,
	S2MPG10_PMIC_PCTRLSEL6 = 184,
	S2MPG10_PMIC_PCTRLSEL7 = 185,
	S2MPG10_PMIC_PCTRLSEL8 = 186,
	S2MPG10_PMIC_PCTRLSEL9 = 187,
	S2MPG10_PMIC_PCTRLSEL10 = 188,
	S2MPG10_PMIC_PCTRLSEL11 = 189,
	S2MPG10_PMIC_PCTRLSEL12 = 190,
	S2MPG10_PMIC_PCTRLSEL13 = 191,
	S2MPG10_PMIC_DCTRLSEL1 = 192,
	S2MPG10_PMIC_DCTRLSEL2 = 193,
	S2MPG10_PMIC_DCTRLSEL3 = 194,
	S2MPG10_PMIC_DCTRLSEL4 = 195,
	S2MPG10_PMIC_DCTRLSEL5 = 196,
	S2MPG10_PMIC_DCTRLSEL6 = 197,
	S2MPG10_PMIC_DCTRLSEL7 = 198,
	S2MPG10_PMIC_GPIO_CTRL1 = 199,
	S2MPG10_PMIC_GPIO_CTRL2 = 200,
	S2MPG10_PMIC_GPIO_CTRL3 = 201,
	S2MPG10_PMIC_GPIO_CTRL4 = 202,
	S2MPG10_PMIC_GPIO_CTRL5 = 203,
	S2MPG10_PMIC_GPIO_CTRL6 = 204,
	S2MPG10_PMIC_GPIO_CTRL7 = 205,
	S2MPG10_PMIC_B2M_OCP_WARN = 206,
	S2MPG10_PMIC_B2M_OCP_WARN_X = 207,
	S2MPG10_PMIC_B2M_OCP_WARN_Y = 208,
	S2MPG10_PMIC_B2M_OCP_WARN_Z = 209,
	S2MPG10_PMIC_B3M_OCP_WARN = 210,
	S2MPG10_PMIC_B3M_OCP_WARN_X = 211,
	S2MPG10_PMIC_B3M_OCP_WARN_Y = 212,
	S2MPG10_PMIC_B3M_OCP_WARN_Z = 213,
	S2MPG10_PMIC_B10M_OCP_WARN = 214,
	S2MPG10_PMIC_B10M_OCP_WARN_X = 215,
	S2MPG10_PMIC_B10M_OCP_WARN_Y = 216,
	S2MPG10_PMIC_B10M_OCP_WARN_Z = 217,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN = 218,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN_X = 219,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN_Y = 220,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN_Z = 221,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN = 222,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN_X = 223,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN_Y = 224,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN_Z = 225,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN = 226,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN_X = 227,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN_Y = 228,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN_Z = 229,
	S2MPG10_PMIC_BUCK_OCP_EN1 = 230,
	S2MPG10_PMIC_BUCK_OCP_EN2 = 231,
	S2MPG10_PMIC_BUCK_OCP_PD_EN1 = 232,
	S2MPG10_PMIC_BUCK_OCP_PD_EN2 = 233,
	S2MPG10_PMIC_BUCK_OCP_CTRL1 = 234,
	S2MPG10_PMIC_BUCK_OCP_CTRL2 = 235,
	S2MPG10_PMIC_BUCK_OCP_CTRL3 = 236,
	S2MPG10_PMIC_BUCK_OCP_CTRL4 = 237,
	S2MPG10_PMIC_BUCK_OCP_CTRL5 = 238,
	S2MPG10_PMIC_PIF_CTRL = 239,
	S2MPG10_PMIC_BUCK_HR_MODE1 = 240,
	S2MPG10_PMIC_BUCK_HR_MODE2 = 241,
	S2MPG10_PMIC_FAULTOUT_CTRL = 242,
	S2MPG10_PMIC_LDO_SENSE1 = 243,
	S2MPG10_PMIC_LDO_SENSE2 = 244,
	S2MPG10_PMIC_LDO_SENSE3 = 245,
	S2MPG10_PMIC_LDO_SENSE4 = 246,
};

enum s2mpg10_rtc_reg {
	S2MPG10_RTC_CTRL = 0,
	S2MPG10_RTC_UPDATE = 1,
	S2MPG10_RTC_SMPL = 2,
	S2MPG10_RTC_WTSR = 3,
	S2MPG10_RTC_CAP_SEL = 4,
	S2MPG10_RTC_MSEC = 5,
	S2MPG10_RTC_SEC = 6,
	S2MPG10_RTC_MIN = 7,
	S2MPG10_RTC_HOUR = 8,
	S2MPG10_RTC_WEEK = 9,
	S2MPG10_RTC_DAY = 10,
	S2MPG10_RTC_MON = 11,
	S2MPG10_RTC_YEAR = 12,
	S2MPG10_RTC_A0SEC = 13,
	S2MPG10_RTC_A0MIN = 14,
	S2MPG10_RTC_A0HOUR = 15,
	S2MPG10_RTC_A0WEEK = 16,
	S2MPG10_RTC_A0DAY = 17,
	S2MPG10_RTC_A0MON = 18,
	S2MPG10_RTC_A0YEAR = 19,
	S2MPG10_RTC_A1SEC = 20,
	S2MPG10_RTC_A1MIN = 21,
	S2MPG10_RTC_A1HOUR = 22,
	S2MPG10_RTC_A1WEEK = 23,
	S2MPG10_RTC_A1DAY = 24,
	S2MPG10_RTC_A1MON = 25,
	S2MPG10_RTC_A1YEAR = 26,
	S2MPG10_RTC_OSC_CTRL = 27,
};

enum s2mps11_reg {
	S2MPS11_REG_ID = 0,
	S2MPS11_REG_INT1 = 1,
	S2MPS11_REG_INT2 = 2,
	S2MPS11_REG_INT3 = 3,
	S2MPS11_REG_INT1M = 4,
	S2MPS11_REG_INT2M = 5,
	S2MPS11_REG_INT3M = 6,
	S2MPS11_REG_ST1 = 7,
	S2MPS11_REG_ST2 = 8,
	S2MPS11_REG_OFFSRC = 9,
	S2MPS11_REG_PWRONSRC = 10,
	S2MPS11_REG_RTC_CTRL = 11,
	S2MPS11_REG_CTRL1 = 12,
	S2MPS11_REG_ETC_TEST = 13,
	S2MPS11_REG_RSVD3 = 14,
	S2MPS11_REG_BU_CHG = 15,
	S2MPS11_REG_RAMP = 16,
	S2MPS11_REG_RAMP_BUCK = 17,
	S2MPS11_REG_LDO1_8 = 18,
	S2MPS11_REG_LDO9_16 = 19,
	S2MPS11_REG_LDO17_24 = 20,
	S2MPS11_REG_LDO25_32 = 21,
	S2MPS11_REG_LDO33_38 = 22,
	S2MPS11_REG_LDO1_8_1 = 23,
	S2MPS11_REG_LDO9_16_1 = 24,
	S2MPS11_REG_LDO17_24_1 = 25,
	S2MPS11_REG_LDO25_32_1 = 26,
	S2MPS11_REG_LDO33_38_1 = 27,
	S2MPS11_REG_OTP_ADRL = 28,
	S2MPS11_REG_OTP_ADRH = 29,
	S2MPS11_REG_OTP_DATA = 30,
	S2MPS11_REG_MON1SEL = 31,
	S2MPS11_REG_MON2SEL = 32,
	S2MPS11_REG_LEE = 33,
	S2MPS11_REG_RSVD_NO = 34,
	S2MPS11_REG_UVLO = 35,
	S2MPS11_REG_LEE_NO = 36,
	S2MPS11_REG_B1CTRL1 = 37,
	S2MPS11_REG_B1CTRL2 = 38,
	S2MPS11_REG_B2CTRL1 = 39,
	S2MPS11_REG_B2CTRL2 = 40,
	S2MPS11_REG_B3CTRL1 = 41,
	S2MPS11_REG_B3CTRL2 = 42,
	S2MPS11_REG_B4CTRL1 = 43,
	S2MPS11_REG_B4CTRL2 = 44,
	S2MPS11_REG_B5CTRL1 = 45,
	S2MPS11_REG_BUCK5_SW = 46,
	S2MPS11_REG_B5CTRL2 = 47,
	S2MPS11_REG_B5CTRL3 = 48,
	S2MPS11_REG_B5CTRL4 = 49,
	S2MPS11_REG_B5CTRL5 = 50,
	S2MPS11_REG_B6CTRL1 = 51,
	S2MPS11_REG_B6CTRL2 = 52,
	S2MPS11_REG_B7CTRL1 = 53,
	S2MPS11_REG_B7CTRL2 = 54,
	S2MPS11_REG_B8CTRL1 = 55,
	S2MPS11_REG_B8CTRL2 = 56,
	S2MPS11_REG_B9CTRL1 = 57,
	S2MPS11_REG_B9CTRL2 = 58,
	S2MPS11_REG_B10CTRL1 = 59,
	S2MPS11_REG_B10CTRL2 = 60,
	S2MPS11_REG_L1CTRL = 61,
	S2MPS11_REG_L2CTRL = 62,
	S2MPS11_REG_L3CTRL = 63,
	S2MPS11_REG_L4CTRL = 64,
	S2MPS11_REG_L5CTRL = 65,
	S2MPS11_REG_L6CTRL = 66,
	S2MPS11_REG_L7CTRL = 67,
	S2MPS11_REG_L8CTRL = 68,
	S2MPS11_REG_L9CTRL = 69,
	S2MPS11_REG_L10CTRL = 70,
	S2MPS11_REG_L11CTRL = 71,
	S2MPS11_REG_L12CTRL = 72,
	S2MPS11_REG_L13CTRL = 73,
	S2MPS11_REG_L14CTRL = 74,
	S2MPS11_REG_L15CTRL = 75,
	S2MPS11_REG_L16CTRL = 76,
	S2MPS11_REG_L17CTRL = 77,
	S2MPS11_REG_L18CTRL = 78,
	S2MPS11_REG_L19CTRL = 79,
	S2MPS11_REG_L20CTRL = 80,
	S2MPS11_REG_L21CTRL = 81,
	S2MPS11_REG_L22CTRL = 82,
	S2MPS11_REG_L23CTRL = 83,
	S2MPS11_REG_L24CTRL = 84,
	S2MPS11_REG_L25CTRL = 85,
	S2MPS11_REG_L26CTRL = 86,
	S2MPS11_REG_L27CTRL = 87,
	S2MPS11_REG_L28CTRL = 88,
	S2MPS11_REG_L29CTRL = 89,
	S2MPS11_REG_L30CTRL = 90,
	S2MPS11_REG_L31CTRL = 91,
	S2MPS11_REG_L32CTRL = 92,
	S2MPS11_REG_L33CTRL = 93,
	S2MPS11_REG_L34CTRL = 94,
	S2MPS11_REG_L35CTRL = 95,
	S2MPS11_REG_L36CTRL = 96,
	S2MPS11_REG_L37CTRL = 97,
	S2MPS11_REG_L38CTRL = 98,
};

enum s2mps11_regulators {
	S2MPS11_LDO1 = 0,
	S2MPS11_LDO2 = 1,
	S2MPS11_LDO3 = 2,
	S2MPS11_LDO4 = 3,
	S2MPS11_LDO5 = 4,
	S2MPS11_LDO6 = 5,
	S2MPS11_LDO7 = 6,
	S2MPS11_LDO8 = 7,
	S2MPS11_LDO9 = 8,
	S2MPS11_LDO10 = 9,
	S2MPS11_LDO11 = 10,
	S2MPS11_LDO12 = 11,
	S2MPS11_LDO13 = 12,
	S2MPS11_LDO14 = 13,
	S2MPS11_LDO15 = 14,
	S2MPS11_LDO16 = 15,
	S2MPS11_LDO17 = 16,
	S2MPS11_LDO18 = 17,
	S2MPS11_LDO19 = 18,
	S2MPS11_LDO20 = 19,
	S2MPS11_LDO21 = 20,
	S2MPS11_LDO22 = 21,
	S2MPS11_LDO23 = 22,
	S2MPS11_LDO24 = 23,
	S2MPS11_LDO25 = 24,
	S2MPS11_LDO26 = 25,
	S2MPS11_LDO27 = 26,
	S2MPS11_LDO28 = 27,
	S2MPS11_LDO29 = 28,
	S2MPS11_LDO30 = 29,
	S2MPS11_LDO31 = 30,
	S2MPS11_LDO32 = 31,
	S2MPS11_LDO33 = 32,
	S2MPS11_LDO34 = 33,
	S2MPS11_LDO35 = 34,
	S2MPS11_LDO36 = 35,
	S2MPS11_LDO37 = 36,
	S2MPS11_LDO38 = 37,
	S2MPS11_BUCK1 = 38,
	S2MPS11_BUCK2 = 39,
	S2MPS11_BUCK3 = 40,
	S2MPS11_BUCK4 = 41,
	S2MPS11_BUCK5 = 42,
	S2MPS11_BUCK6 = 43,
	S2MPS11_BUCK7 = 44,
	S2MPS11_BUCK8 = 45,
	S2MPS11_BUCK9 = 46,
	S2MPS11_BUCK10 = 47,
	S2MPS11_REGULATOR_MAX = 48,
};

enum s2mps13_reg {
	S2MPS13_REG_ID = 0,
	S2MPS13_REG_INT1 = 1,
	S2MPS13_REG_INT2 = 2,
	S2MPS13_REG_INT3 = 3,
	S2MPS13_REG_INT1M = 4,
	S2MPS13_REG_INT2M = 5,
	S2MPS13_REG_INT3M = 6,
	S2MPS13_REG_ST1 = 7,
	S2MPS13_REG_ST2 = 8,
	S2MPS13_REG_PWRONSRC = 9,
	S2MPS13_REG_OFFSRC = 10,
	S2MPS13_REG_BU_CHG = 11,
	S2MPS13_REG_RTCCTRL = 12,
	S2MPS13_REG_CTRL1 = 13,
	S2MPS13_REG_CTRL2 = 14,
	S2MPS13_REG_RSVD1 = 15,
	S2MPS13_REG_RSVD2 = 16,
	S2MPS13_REG_RSVD3 = 17,
	S2MPS13_REG_RSVD4 = 18,
	S2MPS13_REG_RSVD5 = 19,
	S2MPS13_REG_RSVD6 = 20,
	S2MPS13_REG_CTRL3 = 21,
	S2MPS13_REG_RSVD7 = 22,
	S2MPS13_REG_RSVD8 = 23,
	S2MPS13_REG_WRSTBI = 24,
	S2MPS13_REG_B1CTRL = 25,
	S2MPS13_REG_B1OUT = 26,
	S2MPS13_REG_B2CTRL = 27,
	S2MPS13_REG_B2OUT = 28,
	S2MPS13_REG_B3CTRL = 29,
	S2MPS13_REG_B3OUT = 30,
	S2MPS13_REG_B4CTRL = 31,
	S2MPS13_REG_B4OUT = 32,
	S2MPS13_REG_B5CTRL = 33,
	S2MPS13_REG_B5OUT = 34,
	S2MPS13_REG_B6CTRL = 35,
	S2MPS13_REG_B6OUT = 36,
	S2MPS13_REG_B7CTRL = 37,
	S2MPS13_REG_B7SW = 38,
	S2MPS13_REG_B7OUT = 39,
	S2MPS13_REG_B8CTRL = 40,
	S2MPS13_REG_B8OUT = 41,
	S2MPS13_REG_B9CTRL = 42,
	S2MPS13_REG_B9OUT = 43,
	S2MPS13_REG_B10CTRL = 44,
	S2MPS13_REG_B10OUT = 45,
	S2MPS13_REG_BB1CTRL = 46,
	S2MPS13_REG_BB1OUT = 47,
	S2MPS13_REG_BUCK_RAMP1 = 48,
	S2MPS13_REG_BUCK_RAMP2 = 49,
	S2MPS13_REG_LDO_DVS1 = 50,
	S2MPS13_REG_LDO_DVS2 = 51,
	S2MPS13_REG_LDO_DVS3 = 52,
	S2MPS13_REG_B6OUT2 = 53,
	S2MPS13_REG_L1CTRL = 54,
	S2MPS13_REG_L2CTRL = 55,
	S2MPS13_REG_L3CTRL = 56,
	S2MPS13_REG_L4CTRL = 57,
	S2MPS13_REG_L5CTRL = 58,
	S2MPS13_REG_L6CTRL = 59,
	S2MPS13_REG_L7CTRL = 60,
	S2MPS13_REG_L8CTRL = 61,
	S2MPS13_REG_L9CTRL = 62,
	S2MPS13_REG_L10CTRL = 63,
	S2MPS13_REG_L11CTRL = 64,
	S2MPS13_REG_L12CTRL = 65,
	S2MPS13_REG_L13CTRL = 66,
	S2MPS13_REG_L14CTRL = 67,
	S2MPS13_REG_L15CTRL = 68,
	S2MPS13_REG_L16CTRL = 69,
	S2MPS13_REG_L17CTRL = 70,
	S2MPS13_REG_L18CTRL = 71,
	S2MPS13_REG_L19CTRL = 72,
	S2MPS13_REG_L20CTRL = 73,
	S2MPS13_REG_L21CTRL = 74,
	S2MPS13_REG_L22CTRL = 75,
	S2MPS13_REG_L23CTRL = 76,
	S2MPS13_REG_L24CTRL = 77,
	S2MPS13_REG_L25CTRL = 78,
	S2MPS13_REG_L26CTRL = 79,
	S2MPS13_REG_L27CTRL = 80,
	S2MPS13_REG_L28CTRL = 81,
	S2MPS13_REG_L29CTRL = 82,
	S2MPS13_REG_L30CTRL = 83,
	S2MPS13_REG_L31CTRL = 84,
	S2MPS13_REG_L32CTRL = 85,
	S2MPS13_REG_L33CTRL = 86,
	S2MPS13_REG_L34CTRL = 87,
	S2MPS13_REG_L35CTRL = 88,
	S2MPS13_REG_L36CTRL = 89,
	S2MPS13_REG_L37CTRL = 90,
	S2MPS13_REG_L38CTRL = 91,
	S2MPS13_REG_L39CTRL = 92,
	S2MPS13_REG_L40CTRL = 93,
	S2MPS13_REG_LDODSCH1 = 94,
	S2MPS13_REG_LDODSCH2 = 95,
	S2MPS13_REG_LDODSCH3 = 96,
	S2MPS13_REG_LDODSCH4 = 97,
	S2MPS13_REG_LDODSCH5 = 98,
};

enum s2mps14_irq {
	S2MPS14_IRQ_PWRONF = 0,
	S2MPS14_IRQ_PWRONR = 1,
	S2MPS14_IRQ_JIGONBF = 2,
	S2MPS14_IRQ_JIGONBR = 3,
	S2MPS14_IRQ_ACOKBF = 4,
	S2MPS14_IRQ_ACOKBR = 5,
	S2MPS14_IRQ_PWRON1S = 6,
	S2MPS14_IRQ_MRB = 7,
	S2MPS14_IRQ_RTC60S = 8,
	S2MPS14_IRQ_RTCA1 = 9,
	S2MPS14_IRQ_RTCA0 = 10,
	S2MPS14_IRQ_SMPL = 11,
	S2MPS14_IRQ_RTC1S = 12,
	S2MPS14_IRQ_WTSR = 13,
	S2MPS14_IRQ_INT120C = 14,
	S2MPS14_IRQ_INT140C = 15,
	S2MPS14_IRQ_TSD = 16,
	S2MPS14_IRQ_NR = 17,
};

enum s2mps14_reg {
	S2MPS14_REG_ID = 0,
	S2MPS14_REG_INT1 = 1,
	S2MPS14_REG_INT2 = 2,
	S2MPS14_REG_INT3 = 3,
	S2MPS14_REG_INT1M = 4,
	S2MPS14_REG_INT2M = 5,
	S2MPS14_REG_INT3M = 6,
	S2MPS14_REG_ST1 = 7,
	S2MPS14_REG_ST2 = 8,
	S2MPS14_REG_PWRONSRC = 9,
	S2MPS14_REG_OFFSRC = 10,
	S2MPS14_REG_BU_CHG = 11,
	S2MPS14_REG_RTCCTRL = 12,
	S2MPS14_REG_CTRL1 = 13,
	S2MPS14_REG_CTRL2 = 14,
	S2MPS14_REG_RSVD1 = 15,
	S2MPS14_REG_RSVD2 = 16,
	S2MPS14_REG_RSVD3 = 17,
	S2MPS14_REG_RSVD4 = 18,
	S2MPS14_REG_RSVD5 = 19,
	S2MPS14_REG_RSVD6 = 20,
	S2MPS14_REG_CTRL3 = 21,
	S2MPS14_REG_RSVD7 = 22,
	S2MPS14_REG_RSVD8 = 23,
	S2MPS14_REG_WRSTBI = 24,
	S2MPS14_REG_B1CTRL1 = 25,
	S2MPS14_REG_B1CTRL2 = 26,
	S2MPS14_REG_B2CTRL1 = 27,
	S2MPS14_REG_B2CTRL2 = 28,
	S2MPS14_REG_B3CTRL1 = 29,
	S2MPS14_REG_B3CTRL2 = 30,
	S2MPS14_REG_B4CTRL1 = 31,
	S2MPS14_REG_B4CTRL2 = 32,
	S2MPS14_REG_B5CTRL1 = 33,
	S2MPS14_REG_B5CTRL2 = 34,
	S2MPS14_REG_L1CTRL = 35,
	S2MPS14_REG_L2CTRL = 36,
	S2MPS14_REG_L3CTRL = 37,
	S2MPS14_REG_L4CTRL = 38,
	S2MPS14_REG_L5CTRL = 39,
	S2MPS14_REG_L6CTRL = 40,
	S2MPS14_REG_L7CTRL = 41,
	S2MPS14_REG_L8CTRL = 42,
	S2MPS14_REG_L9CTRL = 43,
	S2MPS14_REG_L10CTRL = 44,
	S2MPS14_REG_L11CTRL = 45,
	S2MPS14_REG_L12CTRL = 46,
	S2MPS14_REG_L13CTRL = 47,
	S2MPS14_REG_L14CTRL = 48,
	S2MPS14_REG_L15CTRL = 49,
	S2MPS14_REG_L16CTRL = 50,
	S2MPS14_REG_L17CTRL = 51,
	S2MPS14_REG_L18CTRL = 52,
	S2MPS14_REG_L19CTRL = 53,
	S2MPS14_REG_L20CTRL = 54,
	S2MPS14_REG_L21CTRL = 55,
	S2MPS14_REG_L22CTRL = 56,
	S2MPS14_REG_L23CTRL = 57,
	S2MPS14_REG_L24CTRL = 58,
	S2MPS14_REG_L25CTRL = 59,
	S2MPS14_REG_LDODSCH1 = 60,
	S2MPS14_REG_LDODSCH2 = 61,
	S2MPS14_REG_LDODSCH3 = 62,
};

enum s2mps14_regulators {
	S2MPS14_LDO1 = 0,
	S2MPS14_LDO2 = 1,
	S2MPS14_LDO3 = 2,
	S2MPS14_LDO4 = 3,
	S2MPS14_LDO5 = 4,
	S2MPS14_LDO6 = 5,
	S2MPS14_LDO7 = 6,
	S2MPS14_LDO8 = 7,
	S2MPS14_LDO9 = 8,
	S2MPS14_LDO10 = 9,
	S2MPS14_LDO11 = 10,
	S2MPS14_LDO12 = 11,
	S2MPS14_LDO13 = 12,
	S2MPS14_LDO14 = 13,
	S2MPS14_LDO15 = 14,
	S2MPS14_LDO16 = 15,
	S2MPS14_LDO17 = 16,
	S2MPS14_LDO18 = 17,
	S2MPS14_LDO19 = 18,
	S2MPS14_LDO20 = 19,
	S2MPS14_LDO21 = 20,
	S2MPS14_LDO22 = 21,
	S2MPS14_LDO23 = 22,
	S2MPS14_LDO24 = 23,
	S2MPS14_LDO25 = 24,
	S2MPS14_BUCK1 = 25,
	S2MPS14_BUCK2 = 26,
	S2MPS14_BUCK3 = 27,
	S2MPS14_BUCK4 = 28,
	S2MPS14_BUCK5 = 29,
	S2MPS14_REGULATOR_MAX = 30,
};

enum s3c24xx_i2c_state {
	STATE_IDLE___4 = 0,
	STATE_START___2 = 1,
	STATE_READ___3 = 2,
	STATE_WRITE___3 = 3,
	STATE_STOP___2 = 4,
};

enum s3c24xx_port_type {
	TYPE_S3C6400 = 0,
	TYPE_APPLE_S5L = 1,
};

enum s5m8767_irq {
	S5M8767_IRQ_PWRR = 0,
	S5M8767_IRQ_PWRF = 1,
	S5M8767_IRQ_PWR1S = 2,
	S5M8767_IRQ_JIGR = 3,
	S5M8767_IRQ_JIGF = 4,
	S5M8767_IRQ_LOWBAT2 = 5,
	S5M8767_IRQ_LOWBAT1 = 6,
	S5M8767_IRQ_MRB = 7,
	S5M8767_IRQ_DVSOK2 = 8,
	S5M8767_IRQ_DVSOK3 = 9,
	S5M8767_IRQ_DVSOK4 = 10,
	S5M8767_IRQ_RTC60S = 11,
	S5M8767_IRQ_RTCA1 = 12,
	S5M8767_IRQ_RTCA2 = 13,
	S5M8767_IRQ_SMPL = 14,
	S5M8767_IRQ_RTC1S = 15,
	S5M8767_IRQ_WTSR = 16,
	S5M8767_IRQ_NR = 17,
};

enum s5m8767_reg {
	S5M8767_REG_ID = 0,
	S5M8767_REG_INT1 = 1,
	S5M8767_REG_INT2 = 2,
	S5M8767_REG_INT3 = 3,
	S5M8767_REG_INT1M = 4,
	S5M8767_REG_INT2M = 5,
	S5M8767_REG_INT3M = 6,
	S5M8767_REG_STATUS1 = 7,
	S5M8767_REG_STATUS2 = 8,
	S5M8767_REG_STATUS3 = 9,
	S5M8767_REG_CTRL1 = 10,
	S5M8767_REG_CTRL2 = 11,
	S5M8767_REG_LOWBAT1 = 12,
	S5M8767_REG_LOWBAT2 = 13,
	S5M8767_REG_BUCHG = 14,
	S5M8767_REG_DVSRAMP = 15,
	S5M8767_REG_DVSTIMER2 = 16,
	S5M8767_REG_DVSTIMER3 = 17,
	S5M8767_REG_DVSTIMER4 = 18,
	S5M8767_REG_LDO1 = 19,
	S5M8767_REG_LDO2 = 20,
	S5M8767_REG_LDO3 = 21,
	S5M8767_REG_LDO4 = 22,
	S5M8767_REG_LDO5 = 23,
	S5M8767_REG_LDO6 = 24,
	S5M8767_REG_LDO7 = 25,
	S5M8767_REG_LDO8 = 26,
	S5M8767_REG_LDO9 = 27,
	S5M8767_REG_LDO10 = 28,
	S5M8767_REG_LDO11 = 29,
	S5M8767_REG_LDO12 = 30,
	S5M8767_REG_LDO13 = 31,
	S5M8767_REG_LDO14 = 32,
	S5M8767_REG_LDO15 = 33,
	S5M8767_REG_LDO16 = 34,
	S5M8767_REG_LDO17 = 35,
	S5M8767_REG_LDO18 = 36,
	S5M8767_REG_LDO19 = 37,
	S5M8767_REG_LDO20 = 38,
	S5M8767_REG_LDO21 = 39,
	S5M8767_REG_LDO22 = 40,
	S5M8767_REG_LDO23 = 41,
	S5M8767_REG_LDO24 = 42,
	S5M8767_REG_LDO25 = 43,
	S5M8767_REG_LDO26 = 44,
	S5M8767_REG_LDO27 = 45,
	S5M8767_REG_LDO28 = 46,
	S5M8767_REG_UVLO = 49,
	S5M8767_REG_BUCK1CTRL1 = 50,
	S5M8767_REG_BUCK1CTRL2 = 51,
	S5M8767_REG_BUCK2CTRL = 52,
	S5M8767_REG_BUCK2DVS1 = 53,
	S5M8767_REG_BUCK2DVS2 = 54,
	S5M8767_REG_BUCK2DVS3 = 55,
	S5M8767_REG_BUCK2DVS4 = 56,
	S5M8767_REG_BUCK2DVS5 = 57,
	S5M8767_REG_BUCK2DVS6 = 58,
	S5M8767_REG_BUCK2DVS7 = 59,
	S5M8767_REG_BUCK2DVS8 = 60,
	S5M8767_REG_BUCK3CTRL = 61,
	S5M8767_REG_BUCK3DVS1 = 62,
	S5M8767_REG_BUCK3DVS2 = 63,
	S5M8767_REG_BUCK3DVS3 = 64,
	S5M8767_REG_BUCK3DVS4 = 65,
	S5M8767_REG_BUCK3DVS5 = 66,
	S5M8767_REG_BUCK3DVS6 = 67,
	S5M8767_REG_BUCK3DVS7 = 68,
	S5M8767_REG_BUCK3DVS8 = 69,
	S5M8767_REG_BUCK4CTRL = 70,
	S5M8767_REG_BUCK4DVS1 = 71,
	S5M8767_REG_BUCK4DVS2 = 72,
	S5M8767_REG_BUCK4DVS3 = 73,
	S5M8767_REG_BUCK4DVS4 = 74,
	S5M8767_REG_BUCK4DVS5 = 75,
	S5M8767_REG_BUCK4DVS6 = 76,
	S5M8767_REG_BUCK4DVS7 = 77,
	S5M8767_REG_BUCK4DVS8 = 78,
	S5M8767_REG_BUCK5CTRL1 = 79,
	S5M8767_REG_BUCK5CTRL2 = 80,
	S5M8767_REG_BUCK5CTRL3 = 81,
	S5M8767_REG_BUCK5CTRL4 = 82,
	S5M8767_REG_BUCK5CTRL5 = 83,
	S5M8767_REG_BUCK6CTRL1 = 84,
	S5M8767_REG_BUCK6CTRL2 = 85,
	S5M8767_REG_BUCK7CTRL1 = 86,
	S5M8767_REG_BUCK7CTRL2 = 87,
	S5M8767_REG_BUCK8CTRL1 = 88,
	S5M8767_REG_BUCK8CTRL2 = 89,
	S5M8767_REG_BUCK9CTRL1 = 90,
	S5M8767_REG_BUCK9CTRL2 = 91,
	S5M8767_REG_LDO1CTRL = 92,
	S5M8767_REG_LDO2_1CTRL = 93,
	S5M8767_REG_LDO2_2CTRL = 94,
	S5M8767_REG_LDO2_3CTRL = 95,
	S5M8767_REG_LDO2_4CTRL = 96,
	S5M8767_REG_LDO3CTRL = 97,
	S5M8767_REG_LDO4CTRL = 98,
	S5M8767_REG_LDO5CTRL = 99,
	S5M8767_REG_LDO6CTRL = 100,
	S5M8767_REG_LDO7CTRL = 101,
	S5M8767_REG_LDO8CTRL = 102,
	S5M8767_REG_LDO9CTRL = 103,
	S5M8767_REG_LDO10CTRL = 104,
	S5M8767_REG_LDO11CTRL = 105,
	S5M8767_REG_LDO12CTRL = 106,
	S5M8767_REG_LDO13CTRL = 107,
	S5M8767_REG_LDO14CTRL = 108,
	S5M8767_REG_LDO15CTRL = 109,
	S5M8767_REG_LDO16CTRL = 110,
	S5M8767_REG_LDO17CTRL = 111,
	S5M8767_REG_LDO18CTRL = 112,
	S5M8767_REG_LDO19CTRL = 113,
	S5M8767_REG_LDO20CTRL = 114,
	S5M8767_REG_LDO21CTRL = 115,
	S5M8767_REG_LDO22CTRL = 116,
	S5M8767_REG_LDO23CTRL = 117,
	S5M8767_REG_LDO24CTRL = 118,
	S5M8767_REG_LDO25CTRL = 119,
	S5M8767_REG_LDO26CTRL = 120,
	S5M8767_REG_LDO27CTRL = 121,
	S5M8767_REG_LDO28CTRL = 122,
};

enum s5m_rtc_reg {
	S5M_RTC_SEC = 0,
	S5M_RTC_MIN = 1,
	S5M_RTC_HOUR = 2,
	S5M_RTC_WEEKDAY = 3,
	S5M_RTC_DATE = 4,
	S5M_RTC_MONTH = 5,
	S5M_RTC_YEAR1 = 6,
	S5M_RTC_YEAR2 = 7,
	S5M_ALARM0_SEC = 8,
	S5M_ALARM0_MIN = 9,
	S5M_ALARM0_HOUR = 10,
	S5M_ALARM0_WEEKDAY = 11,
	S5M_ALARM0_DATE = 12,
	S5M_ALARM0_MONTH = 13,
	S5M_ALARM0_YEAR1 = 14,
	S5M_ALARM0_YEAR2 = 15,
	S5M_ALARM1_SEC = 16,
	S5M_ALARM1_MIN = 17,
	S5M_ALARM1_HOUR = 18,
	S5M_ALARM1_WEEKDAY = 19,
	S5M_ALARM1_DATE = 20,
	S5M_ALARM1_MONTH = 21,
	S5M_ALARM1_YEAR1 = 22,
	S5M_ALARM1_YEAR2 = 23,
	S5M_ALARM0_CONF = 24,
	S5M_ALARM1_CONF = 25,
	S5M_RTC_STATUS = 26,
	S5M_WTSR_SMPL_CNTL = 27,
	S5M_RTC_UDR_CON = 28,
	S5M_RTC_REG_MAX = 29,
};

enum s700_pinconf_pull {
	OWL_PINCONF_PULL_DOWN = 0,
	OWL_PINCONF_PULL_UP = 1,
};

enum s900_pinconf_pull {
	OWL_PINCONF_PULL_HIZ = 0,
	OWL_PINCONF_PULL_DOWN___2 = 1,
	OWL_PINCONF_PULL_UP___2 = 2,
	OWL_PINCONF_PULL_HOLD = 3,
};

enum s_alloc {
	sa_rootdomain = 0,
	sa_sd = 1,
	sa_sd_storage = 2,
	sa_none = 3,
};

enum sam_status {
	SAM_STAT_GOOD = 0,
	SAM_STAT_CHECK_CONDITION = 2,
	SAM_STAT_CONDITION_MET = 4,
	SAM_STAT_BUSY = 8,
	SAM_STAT_INTERMEDIATE = 16,
	SAM_STAT_INTERMEDIATE_CONDITION_MET = 20,
	SAM_STAT_RESERVATION_CONFLICT = 24,
	SAM_STAT_COMMAND_TERMINATED = 34,
	SAM_STAT_TASK_SET_FULL = 40,
	SAM_STAT_ACA_ACTIVE = 48,
	SAM_STAT_TASK_ABORTED = 64,
};

enum samsung_pll_type {
	pll_2126 = 0,
	pll_3000 = 1,
	pll_35xx = 2,
	pll_36xx = 3,
	pll_2550 = 4,
	pll_2650 = 5,
	pll_4500 = 6,
	pll_4502 = 7,
	pll_4508 = 8,
	pll_4600 = 9,
	pll_4650 = 10,
	pll_4650c = 11,
	pll_6552 = 12,
	pll_6552_s3c2416 = 13,
	pll_6553 = 14,
	pll_2550x = 15,
	pll_2550xx = 16,
	pll_2650x = 17,
	pll_2650xx = 18,
	pll_1417x = 19,
	pll_1418x = 20,
	pll_1450x = 21,
	pll_1451x = 22,
	pll_1452x = 23,
	pll_1460x = 24,
	pll_0818x = 25,
	pll_0822x = 26,
	pll_0831x = 27,
	pll_142xx = 28,
	pll_0516x = 29,
	pll_0517x = 30,
	pll_0518x = 31,
	pll_531x = 32,
	pll_1051x = 33,
	pll_1052x = 34,
	pll_0717x = 35,
	pll_0718x = 36,
	pll_0732x = 37,
	pll_4311 = 38,
	pll_1017x = 39,
	pll_1031x = 40,
};

enum sas_device_type {
	SAS_PHY_UNUSED = 0,
	SAS_END_DEVICE = 1,
	SAS_EDGE_EXPANDER_DEVICE = 2,
	SAS_FANOUT_EXPANDER_DEVICE = 3,
	SAS_HA = 4,
	SAS_SATA_DEV = 5,
	SAS_SATA_PM = 7,
	SAS_SATA_PM_PORT = 8,
	SAS_SATA_PENDING = 9,
};

enum sas_gpio_reg_type {
	SAS_GPIO_REG_CFG = 0,
	SAS_GPIO_REG_RX = 1,
	SAS_GPIO_REG_RX_GP = 2,
	SAS_GPIO_REG_TX = 3,
	SAS_GPIO_REG_TX_GP = 4,
};

enum sas_ha_state {
	SAS_HA_REGISTERED = 0,
	SAS_HA_DRAINING = 1,
	SAS_HA_ATA_EH_ACTIVE = 2,
	SAS_HA_FROZEN = 3,
	SAS_HA_RESUMING = 4,
};

enum sas_internal_abort {
	SAS_INTERNAL_ABORT_SINGLE = 0,
	SAS_INTERNAL_ABORT_DEV = 1,
};

enum sas_linkrate {
	SAS_LINK_RATE_UNKNOWN = 0,
	SAS_PHY_DISABLED = 1,
	SAS_PHY_RESET_PROBLEM = 2,
	SAS_SATA_SPINUP_HOLD = 3,
	SAS_SATA_PORT_SELECTOR = 4,
	SAS_PHY_RESET_IN_PROGRESS = 5,
	SAS_LINK_RATE_1_5_GBPS = 8,
	SAS_LINK_RATE_G1 = 8,
	SAS_LINK_RATE_3_0_GBPS = 9,
	SAS_LINK_RATE_G2 = 9,
	SAS_LINK_RATE_6_0_GBPS = 10,
	SAS_LINK_RATE_12_0_GBPS = 11,
	SAS_LINK_RATE_22_5_GBPS = 12,
	SAS_LINK_RATE_FAILED = 16,
	SAS_PHY_VIRTUAL = 17,
};

enum sas_oob_mode {
	OOB_NOT_CONNECTED = 0,
	SATA_OOB_MODE = 1,
	SAS_OOB_MODE = 2,
};

enum sas_open_rej_reason {
	SAS_OREJ_UNKNOWN = 0,
	SAS_OREJ_BAD_DEST = 1,
	SAS_OREJ_CONN_RATE = 2,
	SAS_OREJ_EPROTO = 3,
	SAS_OREJ_RESV_AB0 = 4,
	SAS_OREJ_RESV_AB1 = 5,
	SAS_OREJ_RESV_AB2 = 6,
	SAS_OREJ_RESV_AB3 = 7,
	SAS_OREJ_WRONG_DEST = 8,
	SAS_OREJ_STP_NORES = 9,
	SAS_OREJ_NO_DEST = 10,
	SAS_OREJ_PATH_BLOCKED = 11,
	SAS_OREJ_RSVD_CONT0 = 12,
	SAS_OREJ_RSVD_CONT1 = 13,
	SAS_OREJ_RSVD_INIT0 = 14,
	SAS_OREJ_RSVD_INIT1 = 15,
	SAS_OREJ_RSVD_STOP0 = 16,
	SAS_OREJ_RSVD_STOP1 = 17,
	SAS_OREJ_RSVD_RETRY = 18,
};

enum sas_phy_role {
	PHY_ROLE_NONE = 0,
	PHY_ROLE_TARGET = 64,
	PHY_ROLE_INITIATOR = 128,
};

enum sas_protocol {
	SAS_PROTOCOL_NONE = 0,
	SAS_PROTOCOL_SATA = 1,
	SAS_PROTOCOL_SMP = 2,
	SAS_PROTOCOL_STP = 4,
	SAS_PROTOCOL_SSP = 8,
	SAS_PROTOCOL_ALL = 14,
	SAS_PROTOCOL_STP_ALL = 5,
	SAS_PROTOCOL_INTERNAL_ABORT = 16,
};

enum sata_phy_ctrl_regs {
	PHY_CTRL_1 = 0,
	PHY_CTRL_1_RESET = 1,
};

enum sata_phy_regs {
	BLOCK0_REG_BANK = 0,
	BLOCK0_XGXSSTATUS = 129,
	BLOCK0_XGXSSTATUS_PLL_LOCK = 4096,
	BLOCK0_SPARE = 141,
	BLOCK0_SPARE_OOB_CLK_SEL_MASK = 3,
	BLOCK0_SPARE_OOB_CLK_SEL_REFBY2 = 1,
	BLOCK1_REG_BANK = 16,
	BLOCK1_TEST_TX = 131,
	BLOCK1_TEST_TX_AMP_SHIFT = 12,
	PLL_REG_BANK_0 = 80,
	PLL_REG_BANK_0_PLLCONTROL_0 = 129,
	PLLCONTROL_0_FREQ_DET_RESTART = 8192,
	PLLCONTROL_0_FREQ_MONITOR = 4096,
	PLLCONTROL_0_SEQ_START = 32768,
	PLL_CAP_CHARGE_TIME = 131,
	PLL_VCO_CAL_THRESH = 132,
	PLL_CAP_CONTROL = 133,
	PLL_FREQ_DET_TIME = 134,
	PLL_ACTRL2 = 139,
	PLL_ACTRL2_SELDIV_MASK = 31,
	PLL_ACTRL2_SELDIV_SHIFT = 9,
	PLL_ACTRL6 = 134,
	PLL1_REG_BANK = 96,
	PLL1_ACTRL2 = 130,
	PLL1_ACTRL3 = 131,
	PLL1_ACTRL4 = 132,
	PLL1_ACTRL5 = 133,
	PLL1_ACTRL6 = 134,
	PLL1_ACTRL7 = 135,
	PLL1_ACTRL8 = 136,
	TX_REG_BANK = 112,
	TX_ACTRL0 = 128,
	TX_ACTRL0_TXPOL_FLIP = 64,
	TX_ACTRL5 = 133,
	TX_ACTRL5_SSC_EN = 2048,
	AEQRX_REG_BANK_0 = 208,
	AEQ_CONTROL1 = 129,
	AEQ_CONTROL1_ENABLE = 4,
	AEQ_CONTROL1_FREEZE = 8,
	AEQ_FRC_EQ = 131,
	AEQ_FRC_EQ_FORCE = 1,
	AEQ_FRC_EQ_FORCE_VAL = 2,
	AEQ_RFZ_FRC_VAL = 256,
	AEQRX_REG_BANK_1 = 224,
	AEQRX_SLCAL0_CTRL0 = 130,
	AEQRX_SLCAL1_CTRL0 = 134,
	OOB_REG_BANK = 336,
	OOB1_REG_BANK = 352,
	OOB_CTRL1 = 128,
	OOB_CTRL1_BURST_MAX_MASK = 15,
	OOB_CTRL1_BURST_MAX_SHIFT = 12,
	OOB_CTRL1_BURST_MIN_MASK = 15,
	OOB_CTRL1_BURST_MIN_SHIFT = 8,
	OOB_CTRL1_WAKE_IDLE_MAX_MASK = 15,
	OOB_CTRL1_WAKE_IDLE_MAX_SHIFT = 4,
	OOB_CTRL1_WAKE_IDLE_MIN_MASK = 15,
	OOB_CTRL1_WAKE_IDLE_MIN_SHIFT = 0,
	OOB_CTRL2 = 129,
	OOB_CTRL2_SEL_ENA_SHIFT = 15,
	OOB_CTRL2_SEL_ENA_RC_SHIFT = 14,
	OOB_CTRL2_RESET_IDLE_MAX_MASK = 63,
	OOB_CTRL2_RESET_IDLE_MAX_SHIFT = 8,
	OOB_CTRL2_BURST_CNT_MASK = 3,
	OOB_CTRL2_BURST_CNT_SHIFT = 6,
	OOB_CTRL2_RESET_IDLE_MIN_MASK = 63,
	OOB_CTRL2_RESET_IDLE_MIN_SHIFT = 0,
	TXPMD_REG_BANK = 416,
	TXPMD_CONTROL1 = 129,
	TXPMD_CONTROL1_TX_SSC_EN_FRC = 1,
	TXPMD_CONTROL1_TX_SSC_EN_FRC_VAL = 2,
	TXPMD_TX_FREQ_CTRL_CONTROL1 = 130,
	TXPMD_TX_FREQ_CTRL_CONTROL2 = 131,
	TXPMD_TX_FREQ_CTRL_CONTROL2_FMIN_MASK = 1023,
	TXPMD_TX_FREQ_CTRL_CONTROL3 = 132,
	TXPMD_TX_FREQ_CTRL_CONTROL3_FMAX_MASK = 1023,
	RXPMD_REG_BANK = 448,
	RXPMD_RX_CDR_CONTROL1 = 129,
	RXPMD_RX_PPM_VAL_MASK = 511,
	RXPMD_RXPMD_EN_FRC = 4096,
	RXPMD_RXPMD_EN_FRC_VAL = 8192,
	RXPMD_RX_CDR_CDR_PROP_BW = 130,
	RXPMD_G_CDR_PROP_BW_MASK = 7,
	RXPMD_G1_CDR_PROP_BW_SHIFT = 0,
	RXPMD_G2_CDR_PROP_BW_SHIFT = 3,
	RXPMD_G3_CDR_PROB_BW_SHIFT = 6,
	RXPMD_RX_CDR_CDR_ACQ_INTEG_BW = 131,
	RXPMD_G_CDR_ACQ_INT_BW_MASK = 7,
	RXPMD_G1_CDR_ACQ_INT_BW_SHIFT = 0,
	RXPMD_G2_CDR_ACQ_INT_BW_SHIFT = 3,
	RXPMD_G3_CDR_ACQ_INT_BW_SHIFT = 6,
	RXPMD_RX_CDR_CDR_LOCK_INTEG_BW = 132,
	RXPMD_G_CDR_LOCK_INT_BW_MASK = 7,
	RXPMD_G1_CDR_LOCK_INT_BW_SHIFT = 0,
	RXPMD_G2_CDR_LOCK_INT_BW_SHIFT = 3,
	RXPMD_G3_CDR_LOCK_INT_BW_SHIFT = 6,
	RXPMD_RX_FREQ_MON_CONTROL1 = 135,
	RXPMD_MON_CORRECT_EN = 256,
	RXPMD_MON_MARGIN_VAL_MASK = 255,
};

enum sata_rcar_type {
	RCAR_GEN1_SATA = 0,
	RCAR_GEN2_SATA = 1,
	RCAR_GEN3_SATA = 2,
	RCAR_R8A7790_ES1_SATA = 3,
};

enum scale_freq_source {
	SCALE_FREQ_SOURCE_CPUFREQ = 0,
	SCALE_FREQ_SOURCE_ARCH = 1,
	SCALE_FREQ_SOURCE_CPPC = 2,
	SCALE_FREQ_SOURCE_VIRT = 3,
};

enum scan_balance {
	SCAN_EQUAL = 0,
	SCAN_FRACT = 1,
	SCAN_ANON = 2,
	SCAN_FILE = 3,
};

enum scan_result {
	SCAN_FAIL = 0,
	SCAN_SUCCEED = 1,
	SCAN_PMD_NULL = 2,
	SCAN_PMD_NONE = 3,
	SCAN_PMD_MAPPED = 4,
	SCAN_EXCEED_NONE_PTE = 5,
	SCAN_EXCEED_SWAP_PTE = 6,
	SCAN_EXCEED_SHARED_PTE = 7,
	SCAN_PTE_NON_PRESENT = 8,
	SCAN_PTE_UFFD_WP = 9,
	SCAN_PTE_MAPPED_HUGEPAGE = 10,
	SCAN_LACK_REFERENCED_PAGE = 11,
	SCAN_PAGE_NULL = 12,
	SCAN_SCAN_ABORT = 13,
	SCAN_PAGE_COUNT = 14,
	SCAN_PAGE_LRU = 15,
	SCAN_PAGE_LOCK = 16,
	SCAN_PAGE_ANON = 17,
	SCAN_PAGE_COMPOUND = 18,
	SCAN_ANY_PROCESS = 19,
	SCAN_VMA_NULL = 20,
	SCAN_VMA_CHECK = 21,
	SCAN_ADDRESS_RANGE = 22,
	SCAN_DEL_PAGE_LRU = 23,
	SCAN_ALLOC_HUGE_PAGE_FAIL = 24,
	SCAN_CGROUP_CHARGE_FAIL = 25,
	SCAN_TRUNCATED = 26,
	SCAN_PAGE_HAS_PRIVATE = 27,
	SCAN_STORE_FAILED = 28,
	SCAN_COPY_MC = 29,
	SCAN_PAGE_FILLED = 30,
};

enum sched_tunable_scaling {
	SCHED_TUNABLESCALING_NONE = 0,
	SCHED_TUNABLESCALING_LOG = 1,
	SCHED_TUNABLESCALING_LINEAR = 2,
	SCHED_TUNABLESCALING_END = 3,
};

enum scmi_bad_msg {
	MSG_UNEXPECTED = -1,
	MSG_INVALID = -2,
	MSG_UNKNOWN = -3,
	MSG_NOMEM = -4,
	MSG_MBOX_SPURIOUS = -5,
};

enum scmi_base_protocol_cmd {
	BASE_DISCOVER_VENDOR = 3,
	BASE_DISCOVER_SUB_VENDOR = 4,
	BASE_DISCOVER_IMPLEMENT_VERSION = 5,
	BASE_DISCOVER_LIST_PROTOCOLS = 6,
	BASE_DISCOVER_AGENT = 7,
	BASE_NOTIFY_ERRORS = 8,
	BASE_SET_DEVICE_PERMISSIONS = 9,
	BASE_SET_PROTOCOL_PERMISSIONS = 10,
	BASE_RESET_AGENT_CONFIGURATION = 11,
};

enum scmi_clk_feats {
	SCMI_CLK_ATOMIC_SUPPORTED = 0,
	SCMI_CLK_STATE_CTRL_SUPPORTED = 1,
	SCMI_CLK_RATE_CTRL_SUPPORTED = 2,
	SCMI_CLK_PARENT_CTRL_SUPPORTED = 3,
	SCMI_CLK_DUTY_CYCLE_SUPPORTED = 4,
	SCMI_CLK_FEATS_COUNT = 5,
};

enum scmi_clock_oem_config {
	SCMI_CLOCK_CFG_DUTY_CYCLE = 1,
	SCMI_CLOCK_CFG_PHASE = 2,
	SCMI_CLOCK_CFG_OEM_START = 128,
	SCMI_CLOCK_CFG_OEM_END = 255,
};

enum scmi_clock_protocol_cmd {
	CLOCK_ATTRIBUTES = 3,
	CLOCK_DESCRIBE_RATES = 4,
	CLOCK_RATE_SET = 5,
	CLOCK_RATE_GET = 6,
	CLOCK_CONFIG_SET = 7,
	CLOCK_NAME_GET = 8,
	CLOCK_RATE_NOTIFY = 9,
	CLOCK_RATE_CHANGE_REQUESTED_NOTIFY = 10,
	CLOCK_CONFIG_GET = 11,
	CLOCK_POSSIBLE_PARENTS_GET = 12,
	CLOCK_PARENT_SET = 13,
	CLOCK_PARENT_GET = 14,
	CLOCK_GET_PERMISSIONS = 15,
};

enum scmi_common_cmd {
	PROTOCOL_VERSION = 0,
	PROTOCOL_ATTRIBUTES = 1,
	PROTOCOL_MESSAGE_ATTRIBUTES = 2,
	NEGOTIATE_PROTOCOL_VERSION = 16,
};

enum scmi_error_codes {
	SCMI_SUCCESS = 0,
	SCMI_ERR_SUPPORT = -1,
	SCMI_ERR_PARAMS = -2,
	SCMI_ERR_ACCESS = -3,
	SCMI_ERR_ENTRY = -4,
	SCMI_ERR_RANGE = -5,
	SCMI_ERR_BUSY = -6,
	SCMI_ERR_COMMS = -7,
	SCMI_ERR_GENERIC = -8,
	SCMI_ERR_HARDWARE = -9,
	SCMI_ERR_PROTOCOL = -10,
};

enum scmi_imx_bbm_protocol_cmd {
	IMX_BBM_GPR_SET = 3,
	IMX_BBM_GPR_GET = 4,
	IMX_BBM_RTC_ATTRIBUTES = 5,
	IMX_BBM_RTC_TIME_SET = 6,
	IMX_BBM_RTC_TIME_GET = 7,
	IMX_BBM_RTC_ALARM_SET = 8,
	IMX_BBM_BUTTON_GET = 9,
	IMX_BBM_RTC_NOTIFY = 10,
	IMX_BBM_BUTTON_NOTIFY = 11,
};

enum scmi_imx_cpu_protocol_cmd {
	SCMI_IMX_CPU_ATTRIBUTES = 3,
	SCMI_IMX_CPU_START = 4,
	SCMI_IMX_CPU_STOP = 5,
	SCMI_IMX_CPU_RESET_VECTOR_SET = 6,
	SCMI_IMX_CPU_INFO_GET = 12,
};

enum scmi_imx_lmm_op {
	SCMI_IMX_LMM_BOOT = 0,
	SCMI_IMX_LMM_POWER_ON = 1,
	SCMI_IMX_LMM_SHUTDOWN = 2,
};

enum scmi_imx_lmm_protocol_cmd {
	SCMI_IMX_LMM_ATTRIBUTES = 3,
	SCMI_IMX_LMM_BOOT___2 = 4,
	SCMI_IMX_LMM_RESET = 5,
	SCMI_IMX_LMM_SHUTDOWN___2 = 6,
	SCMI_IMX_LMM_WAKE = 7,
	SCMI_IMX_LMM_SUSPEND = 8,
	SCMI_IMX_LMM_NOTIFY = 9,
	SCMI_IMX_LMM_RESET_REASON = 10,
	SCMI_IMX_LMM_POWER_ON___2 = 11,
	SCMI_IMX_LMM_RESET_VECTOR_SET = 12,
};

enum scmi_imx_lmm_state {
	LMM_STATE_LM_OFF = 0,
	LMM_STATE_LM_ON = 1,
	LMM_STATE_LM_SUSPEND = 2,
	LMM_STATE_LM_POWERED = 3,
};

enum scmi_imx_misc_protocol_cmd {
	SCMI_IMX_MISC_CTRL_SET = 3,
	SCMI_IMX_MISC_CTRL_GET = 4,
	SCMI_IMX_MISC_DISCOVER_BUILD_INFO = 6,
	SCMI_IMX_MISC_CTRL_NOTIFY = 8,
	SCMI_IMX_MISC_CFG_INFO_GET = 12,
	SCMI_IMX_MISC_BOARD_INFO = 14,
};

enum scmi_notification_events {
	SCMI_EVENT_POWER_STATE_CHANGED = 0,
	SCMI_EVENT_CLOCK_RATE_CHANGED = 0,
	SCMI_EVENT_CLOCK_RATE_CHANGE_REQUESTED = 1,
	SCMI_EVENT_PERFORMANCE_LIMITS_CHANGED = 0,
	SCMI_EVENT_PERFORMANCE_LEVEL_CHANGED = 1,
	SCMI_EVENT_SENSOR_TRIP_POINT_EVENT = 0,
	SCMI_EVENT_SENSOR_UPDATE = 1,
	SCMI_EVENT_RESET_ISSUED = 0,
	SCMI_EVENT_BASE_ERROR_EVENT = 0,
	SCMI_EVENT_SYSTEM_POWER_STATE_NOTIFIER = 0,
	SCMI_EVENT_POWERCAP_CAP_CHANGED = 0,
	SCMI_EVENT_POWERCAP_MEASUREMENTS_CHANGED = 1,
};

enum scmi_nxp_notification_events {
	SCMI_EVENT_IMX_BBM_RTC = 0,
	SCMI_EVENT_IMX_BBM_BUTTON = 1,
	SCMI_EVENT_IMX_MISC_CONTROL = 0,
};

enum scmi_optee_pta_cmd {
	PTA_SCMI_CMD_CAPABILITIES = 0,
	PTA_SCMI_CMD_PROCESS_SMT_CHANNEL = 1,
	PTA_SCMI_CMD_PROCESS_SMT_CHANNEL_MESSAGE = 2,
	PTA_SCMI_CMD_GET_CHANNEL = 3,
	PTA_SCMI_CMD_PROCESS_MSG_CHANNEL = 4,
};

enum scmi_performance_protocol_cmd {
	PERF_DOMAIN_ATTRIBUTES = 3,
	PERF_DESCRIBE_LEVELS = 4,
	PERF_LIMITS_SET = 5,
	PERF_LIMITS_GET = 6,
	PERF_LEVEL_SET = 7,
	PERF_LEVEL_GET = 8,
	PERF_NOTIFY_LIMITS = 9,
	PERF_NOTIFY_LEVEL = 10,
	PERF_DESCRIBE_FASTCHANNEL = 11,
	PERF_DOMAIN_NAME_GET = 12,
};

enum scmi_pinctrl_conf_type {
	SCMI_PIN_DEFAULT = 0,
	SCMI_PIN_BIAS_BUS_HOLD = 1,
	SCMI_PIN_BIAS_DISABLE = 2,
	SCMI_PIN_BIAS_HIGH_IMPEDANCE = 3,
	SCMI_PIN_BIAS_PULL_UP = 4,
	SCMI_PIN_BIAS_PULL_DEFAULT = 5,
	SCMI_PIN_BIAS_PULL_DOWN = 6,
	SCMI_PIN_DRIVE_OPEN_DRAIN = 7,
	SCMI_PIN_DRIVE_OPEN_SOURCE = 8,
	SCMI_PIN_DRIVE_PUSH_PULL = 9,
	SCMI_PIN_DRIVE_STRENGTH = 10,
	SCMI_PIN_INPUT_DEBOUNCE = 11,
	SCMI_PIN_INPUT_MODE = 12,
	SCMI_PIN_PULL_MODE = 13,
	SCMI_PIN_INPUT_VALUE = 14,
	SCMI_PIN_INPUT_SCHMITT = 15,
	SCMI_PIN_LOW_POWER_MODE = 16,
	SCMI_PIN_OUTPUT_MODE = 17,
	SCMI_PIN_OUTPUT_VALUE = 18,
	SCMI_PIN_POWER_SOURCE = 19,
	SCMI_PIN_SLEW_RATE = 20,
	SCMI_PIN_OEM_START = 192,
	SCMI_PIN_OEM_END = 255,
};

enum scmi_pinctrl_protocol_cmd {
	PINCTRL_ATTRIBUTES = 3,
	PINCTRL_LIST_ASSOCIATIONS = 4,
	PINCTRL_SETTINGS_GET = 5,
	PINCTRL_SETTINGS_CONFIGURE = 6,
	PINCTRL_REQUEST = 7,
	PINCTRL_RELEASE = 8,
	PINCTRL_NAME_GET = 9,
	PINCTRL_SET_PERMISSIONS = 10,
};

enum scmi_pinctrl_selector_type {
	PIN_TYPE = 0,
	GROUP_TYPE = 1,
	FUNCTION_TYPE = 2,
};

enum scmi_power_protocol_cmd {
	POWER_DOMAIN_ATTRIBUTES = 3,
	POWER_STATE_SET = 4,
	POWER_STATE_GET = 5,
	POWER_STATE_NOTIFY = 6,
	POWER_DOMAIN_NAME_GET = 8,
};

enum scmi_power_scale {
	SCMI_POWER_BOGOWATTS = 0,
	SCMI_POWER_MILLIWATTS = 1,
	SCMI_POWER_MICROWATTS = 2,
};

enum scmi_powercap_protocol_cmd {
	POWERCAP_DOMAIN_ATTRIBUTES = 3,
	POWERCAP_CAP_GET = 4,
	POWERCAP_CAP_SET = 5,
	POWERCAP_PAI_GET = 6,
	POWERCAP_PAI_SET = 7,
	POWERCAP_DOMAIN_NAME_GET = 8,
	POWERCAP_MEASUREMENTS_GET = 9,
	POWERCAP_CAP_NOTIFY = 10,
	POWERCAP_MEASUREMENTS_NOTIFY = 11,
	POWERCAP_DESCRIBE_FASTCHANNEL = 12,
};

enum scmi_reset_protocol_cmd {
	RESET_DOMAIN_ATTRIBUTES = 3,
	RESET = 4,
	RESET_NOTIFY = 5,
	RESET_DOMAIN_NAME_GET = 6,
};

enum scmi_sensor_class {
	NONE = 0,
	UNSPEC = 1,
	TEMPERATURE_C = 2,
	TEMPERATURE_F = 3,
	TEMPERATURE_K = 4,
	VOLTAGE = 5,
	CURRENT = 6,
	POWER = 7,
	ENERGY = 8,
	CHARGE = 9,
	VOLTAMPERE = 10,
	NITS = 11,
	LUMENS = 12,
	LUX = 13,
	CANDELAS = 14,
	KPA = 15,
	PSI = 16,
	NEWTON = 17,
	CFM = 18,
	RPM = 19,
	HERTZ = 20,
	SECS = 21,
	MINS = 22,
	HOURS = 23,
	DAYS = 24,
	WEEKS = 25,
	MILS = 26,
	INCHES = 27,
	FEET = 28,
	CUBIC_INCHES = 29,
	CUBIC_FEET = 30,
	METERS = 31,
	CUBIC_CM = 32,
	CUBIC_METERS = 33,
	LITERS = 34,
	FLUID_OUNCES = 35,
	RADIANS = 36,
	STERADIANS = 37,
	REVOLUTIONS = 38,
	CYCLES = 39,
	GRAVITIES = 40,
	OUNCES = 41,
	POUNDS = 42,
	FOOT_POUNDS = 43,
	OUNCE_INCHES = 44,
	GAUSS = 45,
	GILBERTS = 46,
	HENRIES = 47,
	FARADS = 48,
	OHMS = 49,
	SIEMENS = 50,
	MOLES = 51,
	BECQUERELS = 52,
	PPM = 53,
	DECIBELS = 54,
	DBA = 55,
	DBC = 56,
	GRAYS = 57,
	SIEVERTS = 58,
	COLOR_TEMP_K = 59,
	BITS = 60,
	BYTES = 61,
	WORDS = 62,
	DWORDS = 63,
	QWORDS = 64,
	PERCENTAGE = 65,
	PASCALS = 66,
	COUNTS = 67,
	GRAMS = 68,
	NEWTON_METERS = 69,
	HITS = 70,
	MISSES = 71,
	RETRIES = 72,
	OVERRUNS = 73,
	UNDERRUNS = 74,
	COLLISIONS = 75,
	PACKETS = 76,
	MESSAGES = 77,
	CHARS = 78,
	ERRORS = 79,
	CORRECTED_ERRS = 80,
	UNCORRECTABLE_ERRS = 81,
	SQ_MILS = 82,
	SQ_INCHES = 83,
	SQ_FEET = 84,
	SQ_CM = 85,
	SQ_METERS = 86,
	RADIANS_SEC = 87,
	BPM = 88,
	METERS_SEC_SQUARED = 89,
	METERS_SEC = 90,
	CUBIC_METERS_SEC = 91,
	MM_MERCURY = 92,
	RADIANS_SEC_SQUARED = 93,
	OEM_UNIT = 255,
};

enum scmi_sensor_protocol_cmd {
	SENSOR_DESCRIPTION_GET = 3,
	SENSOR_TRIP_POINT_NOTIFY = 4,
	SENSOR_TRIP_POINT_CONFIG = 5,
	SENSOR_READING_GET = 6,
	SENSOR_AXIS_DESCRIPTION_GET = 7,
	SENSOR_LIST_UPDATE_INTERVALS = 8,
	SENSOR_CONFIG_GET = 9,
	SENSOR_CONFIG_SET = 10,
	SENSOR_CONTINUOUS_UPDATE_NOTIFY = 11,
	SENSOR_NAME_GET = 12,
	SENSOR_AXIS_NAME_GET = 13,
};

enum scmi_std_protocol {
	SCMI_PROTOCOL_BASE = 16,
	SCMI_PROTOCOL_POWER = 17,
	SCMI_PROTOCOL_SYSTEM = 18,
	SCMI_PROTOCOL_PERF = 19,
	SCMI_PROTOCOL_CLOCK = 20,
	SCMI_PROTOCOL_SENSOR = 21,
	SCMI_PROTOCOL_RESET = 22,
	SCMI_PROTOCOL_VOLTAGE = 23,
	SCMI_PROTOCOL_POWERCAP = 24,
	SCMI_PROTOCOL_PINCTRL = 25,
};

enum scmi_system_events {
	SCMI_SYSTEM_SHUTDOWN = 0,
	SCMI_SYSTEM_COLDRESET = 1,
	SCMI_SYSTEM_WARMRESET = 2,
	SCMI_SYSTEM_POWERUP = 3,
	SCMI_SYSTEM_SUSPEND = 4,
	SCMI_SYSTEM_MAX = 5,
};

enum scmi_system_protocol_cmd {
	SYSTEM_POWER_STATE_NOTIFY = 5,
};

enum scmi_voltage_level_mode {
	SCMI_VOLTAGE_LEVEL_SET_AUTO = 0,
	SCMI_VOLTAGE_LEVEL_SET_SYNC = 1,
};

enum scmi_voltage_protocol_cmd {
	VOLTAGE_DOMAIN_ATTRIBUTES = 3,
	VOLTAGE_DESCRIBE_LEVELS = 4,
	VOLTAGE_CONFIG_SET = 5,
	VOLTAGE_CONFIG_GET = 6,
	VOLTAGE_LEVEL_SET = 7,
	VOLTAGE_LEVEL_GET = 8,
	VOLTAGE_DOMAIN_NAME_GET = 9,
};

enum scpi_drv_cmds {
	CMD_SCPI_CAPABILITIES = 0,
	CMD_GET_CLOCK_INFO = 1,
	CMD_GET_CLOCK_VALUE = 2,
	CMD_SET_CLOCK_VALUE = 3,
	CMD_GET_DVFS = 4,
	CMD_SET_DVFS = 5,
	CMD_GET_DVFS_INFO = 6,
	CMD_SENSOR_CAPABILITIES = 7,
	CMD_SENSOR_INFO = 8,
	CMD_SENSOR_VALUE = 9,
	CMD_SET_DEVICE_PWR_STATE = 10,
	CMD_GET_DEVICE_PWR_STATE = 11,
	CMD_MAX_COUNT = 12,
};

enum scpi_error_codes {
	SCPI_SUCCESS = 0,
	SCPI_ERR_PARAM = 1,
	SCPI_ERR_ALIGN = 2,
	SCPI_ERR_SIZE = 3,
	SCPI_ERR_HANDLER = 4,
	SCPI_ERR_ACCESS = 5,
	SCPI_ERR_RANGE = 6,
	SCPI_ERR_TIMEOUT = 7,
	SCPI_ERR_NOMEM = 8,
	SCPI_ERR_PWRSTATE = 9,
	SCPI_ERR_SUPPORT = 10,
	SCPI_ERR_DEVICE = 11,
	SCPI_ERR_BUSY = 12,
	SCPI_ERR_MAX = 13,
};

enum scpi_power_domain_state {
	SCPI_PD_STATE_ON = 0,
	SCPI_PD_STATE_OFF = 3,
};

enum scpi_sensor_class {
	TEMPERATURE = 0,
	VOLTAGE___2 = 1,
	CURRENT___2 = 2,
	POWER___2 = 3,
	ENERGY___2 = 4,
};

enum scpsys_bus_prot_block {
	BUS_PROT_BLOCK_INFRA = 0,
	BUS_PROT_BLOCK_INFRA_NAO = 1,
	BUS_PROT_BLOCK_SMI = 2,
	BUS_PROT_BLOCK_COUNT = 3,
};

enum scpsys_bus_prot_flags {
	BUS_PROT_REG_UPDATE = 2,
	BUS_PROT_IGNORE_CLR_ACK = 4,
	BUS_PROT_INVERTED = 8,
};

enum scpsys_rtff_type {
	SCPSYS_RTFF_NONE = 0,
	SCPSYS_RTFF_TYPE_GENERIC = 1,
	SCPSYS_RTFF_TYPE_PCIE_PHY = 2,
	SCPSYS_RTFF_TYPE_STOR_UFS = 3,
	SCPSYS_RTFF_TYPE_MAX = 4,
};

enum scrub_type {
	SCRUB_UNKNOWN = 0,
	SCRUB_NONE = 1,
	SCRUB_SW_PROG = 2,
	SCRUB_SW_SRC = 3,
	SCRUB_SW_PROG_SRC = 4,
	SCRUB_SW_TUNABLE = 5,
	SCRUB_HW_PROG = 6,
	SCRUB_HW_SRC = 7,
	SCRUB_HW_PROG_SRC = 8,
	SCRUB_HW_TUNABLE = 9,
};

enum scsi_cmnd_submitter {
	SUBMITTED_BY_BLOCK_LAYER = 0,
	SUBMITTED_BY_SCSI_ERROR_HANDLER = 1,
	SUBMITTED_BY_SCSI_RESET_IOCTL = 2,
} __attribute__((mode(byte)));

enum scsi_device_event {
	SDEV_EVT_MEDIA_CHANGE = 1,
	SDEV_EVT_INQUIRY_CHANGE_REPORTED = 2,
	SDEV_EVT_CAPACITY_CHANGE_REPORTED = 3,
	SDEV_EVT_SOFT_THRESHOLD_REACHED_REPORTED = 4,
	SDEV_EVT_MODE_PARAMETER_CHANGE_REPORTED = 5,
	SDEV_EVT_LUN_CHANGE_REPORTED = 6,
	SDEV_EVT_ALUA_STATE_CHANGE_REPORTED = 7,
	SDEV_EVT_POWER_ON_RESET_OCCURRED = 8,
	SDEV_EVT_FIRST = 1,
	SDEV_EVT_LAST = 8,
	SDEV_EVT_MAXBITS = 9,
};

enum scsi_device_state {
	SDEV_CREATED = 1,
	SDEV_RUNNING = 2,
	SDEV_CANCEL = 3,
	SDEV_DEL = 4,
	SDEV_QUIESCE = 5,
	SDEV_OFFLINE = 6,
	SDEV_TRANSPORT_OFFLINE = 7,
	SDEV_BLOCK = 8,
	SDEV_CREATED_BLOCK = 9,
};

enum scsi_devinfo_key {
	SCSI_DEVINFO_GLOBAL = 0,
	SCSI_DEVINFO_SPI = 1,
};

enum scsi_disposition {
	NEEDS_RETRY = 8193,
	SUCCESS = 8194,
	FAILED = 8195,
	QUEUED = 8196,
	SOFT_ERROR = 8197,
	ADD_TO_MLQUEUE = 8198,
	TIMEOUT_ERROR = 8199,
	SCSI_RETURN_NOT_HANDLED = 8200,
	FAST_IO_FAIL = 8201,
};

enum scsi_host_guard_type {
	SHOST_DIX_GUARD_CRC = 1,
	SHOST_DIX_GUARD_IP = 2,
};

enum scsi_host_prot_capabilities {
	SHOST_DIF_TYPE1_PROTECTION = 1,
	SHOST_DIF_TYPE2_PROTECTION = 2,
	SHOST_DIF_TYPE3_PROTECTION = 4,
	SHOST_DIX_TYPE0_PROTECTION = 8,
	SHOST_DIX_TYPE1_PROTECTION = 16,
	SHOST_DIX_TYPE2_PROTECTION = 32,
	SHOST_DIX_TYPE3_PROTECTION = 64,
};

enum scsi_host_state {
	SHOST_CREATED = 1,
	SHOST_RUNNING = 2,
	SHOST_CANCEL = 3,
	SHOST_DEL = 4,
	SHOST_RECOVERY = 5,
	SHOST_CANCEL_RECOVERY = 6,
	SHOST_DEL_RECOVERY = 7,
};

enum scsi_host_status {
	DID_OK = 0,
	DID_NO_CONNECT = 1,
	DID_BUS_BUSY = 2,
	DID_TIME_OUT = 3,
	DID_BAD_TARGET = 4,
	DID_ABORT = 5,
	DID_PARITY = 6,
	DID_ERROR = 7,
	DID_RESET = 8,
	DID_BAD_INTR = 9,
	DID_PASSTHROUGH = 10,
	DID_SOFT_ERROR = 11,
	DID_IMM_RETRY = 12,
	DID_REQUEUE = 13,
	DID_TRANSPORT_DISRUPTED = 14,
	DID_TRANSPORT_FAILFAST = 15,
	DID_TRANSPORT_MARGINAL = 20,
};

enum scsi_ml_status {
	SCSIML_STAT_OK = 0,
	SCSIML_STAT_RESV_CONFLICT = 1,
	SCSIML_STAT_NOSPC = 2,
	SCSIML_STAT_MED_ERROR = 3,
	SCSIML_STAT_TGT_FAILURE = 4,
	SCSIML_STAT_DL_TIMEOUT = 5,
};

enum scsi_msg_byte {
	COMMAND_COMPLETE = 0,
	EXTENDED_MESSAGE = 1,
	SAVE_POINTERS = 2,
	RESTORE_POINTERS = 3,
	DISCONNECT = 4,
	INITIATOR_ERROR = 5,
	ABORT_TASK_SET = 6,
	MESSAGE_REJECT = 7,
	NOP = 8,
	MSG_PARITY_ERROR = 9,
	LINKED_CMD_COMPLETE = 10,
	LINKED_FLG_CMD_COMPLETE = 11,
	TARGET_RESET = 12,
	ABORT_TASK = 13,
	CLEAR_TASK_SET = 14,
	INITIATE_RECOVERY = 15,
	RELEASE_RECOVERY = 16,
	TERMINATE_IO_PROC = 17,
	CLEAR_ACA = 22,
	LOGICAL_UNIT_RESET = 23,
	SIMPLE_QUEUE_TAG = 32,
	HEAD_OF_QUEUE_TAG = 33,
	ORDERED_QUEUE_TAG = 34,
	IGNORE_WIDE_RESIDUE = 35,
	ACA = 36,
	QAS_REQUEST = 85,
	BUS_DEVICE_RESET = 12,
	ABORT = 6,
};

enum scsi_pr_type {
	SCSI_PR_WRITE_EXCLUSIVE = 1,
	SCSI_PR_EXCLUSIVE_ACCESS = 3,
	SCSI_PR_WRITE_EXCLUSIVE_REG_ONLY = 5,
	SCSI_PR_EXCLUSIVE_ACCESS_REG_ONLY = 6,
	SCSI_PR_WRITE_EXCLUSIVE_ALL_REGS = 7,
	SCSI_PR_EXCLUSIVE_ACCESS_ALL_REGS = 8,
};

enum scsi_prot_flags {
	SCSI_PROT_TRANSFER_PI = 1,
	SCSI_PROT_GUARD_CHECK = 2,
	SCSI_PROT_REF_CHECK = 4,
	SCSI_PROT_REF_INCREMENT = 8,
	SCSI_PROT_IP_CHECKSUM = 16,
};

enum scsi_prot_operations {
	SCSI_PROT_NORMAL = 0,
	SCSI_PROT_READ_INSERT = 1,
	SCSI_PROT_WRITE_STRIP = 2,
	SCSI_PROT_READ_STRIP = 3,
	SCSI_PROT_WRITE_INSERT = 4,
	SCSI_PROT_READ_PASS = 5,
	SCSI_PROT_WRITE_PASS = 6,
};

enum scsi_scan_mode {
	SCSI_SCAN_INITIAL = 0,
	SCSI_SCAN_RESCAN = 1,
	SCSI_SCAN_MANUAL = 2,
};

enum scsi_target_state {
	STARGET_CREATED = 1,
	STARGET_RUNNING = 2,
	STARGET_REMOVE = 3,
	STARGET_CREATED_REMOVE = 4,
	STARGET_DEL = 5,
};

enum scsi_timeout_action {
	SCSI_EH_DONE = 0,
	SCSI_EH_RESET_TIMER = 1,
	SCSI_EH_NOT_HANDLED = 2,
};

enum scsi_timeouts {
	SCSI_DEFAULT_EH_TIMEOUT = 2500,
};

enum scsi_vpd_parameters {
	SCSI_VPD_HEADER_SIZE = 4,
	SCSI_VPD_LIST_SIZE = 36,
};

enum sctp_conntrack {
	SCTP_CONNTRACK_NONE = 0,
	SCTP_CONNTRACK_CLOSED = 1,
	SCTP_CONNTRACK_COOKIE_WAIT = 2,
	SCTP_CONNTRACK_COOKIE_ECHOED = 3,
	SCTP_CONNTRACK_ESTABLISHED = 4,
	SCTP_CONNTRACK_SHUTDOWN_SENT = 5,
	SCTP_CONNTRACK_SHUTDOWN_RECD = 6,
	SCTP_CONNTRACK_SHUTDOWN_ACK_SENT = 7,
	SCTP_CONNTRACK_HEARTBEAT_SENT = 8,
	SCTP_CONNTRACK_HEARTBEAT_ACKED = 9,
	SCTP_CONNTRACK_MAX = 10,
};

enum sd_uhs2_operation {
	UHS2_PHY_INIT = 0,
	UHS2_SET_CONFIG = 1,
	UHS2_ENABLE_INT = 2,
	UHS2_DISABLE_INT = 3,
	UHS2_ENABLE_CLK = 4,
	UHS2_DISABLE_CLK = 5,
	UHS2_CHECK_DORMANT = 6,
	UHS2_SET_IOS = 7,
};

enum sec_device_type {
	S5M8767X = 0,
	S2DOS05 = 1,
	S2MPA01 = 2,
	S2MPG10 = 3,
	S2MPS11X = 4,
	S2MPS13X = 5,
	S2MPS14X = 6,
	S2MPS15X = 7,
	S2MPU02 = 8,
	S2MPU05 = 9,
};

enum serdev_parity {
	SERDEV_PARITY_NONE = 0,
	SERDEV_PARITY_EVEN = 1,
	SERDEV_PARITY_ODD = 2,
};

enum serio_event_type {
	SERIO_RESCAN_PORT = 0,
	SERIO_RECONNECT_PORT = 1,
	SERIO_RECONNECT_SUBTREE = 2,
	SERIO_REGISTER_PORT = 3,
	SERIO_ATTACH_DRIVER = 4,
};

enum service_response {
	SAS_TASK_COMPLETE = 0,
	SAS_TASK_UNDELIVERED = -1,
};

enum sgmii_speed {
	SGMII_SPEED_10 = 0,
	SGMII_SPEED_100 = 1,
	SGMII_SPEED_1000 = 2,
	SGMII_SPEED_2500 = 2,
};

enum sgp_type {
	SGP_READ = 0,
	SGP_NOALLOC = 1,
	SGP_CACHE = 2,
	SGP_WRITE = 3,
	SGP_FALLOC = 4,
};

enum sh_cmt_model {
	SH_CMT_16BIT = 0,
	SH_CMT_32BIT = 1,
	SH_CMT_48BIT = 2,
	SH_CMT0_RCAR_GEN2 = 3,
	SH_CMT1_RCAR_GEN2 = 4,
};

enum sh_mobile_i2c_op {
	OP_START = 0,
	OP_TX_FIRST = 1,
	OP_TX = 2,
	OP_TX_STOP = 3,
	OP_TX_TO_RX = 4,
	OP_RX = 5,
	OP_RX_STOP = 6,
	OP_RX_STOP_DATA = 7,
};

enum sh_tmu_model {
	SH_TMU = 0,
	SH_TMU_SH3 = 1,
};

enum shmem_param {
	Opt_gid___8 = 0,
	Opt_huge = 1,
	Opt_mode___5 = 2,
	Opt_mpol = 3,
	Opt_nr_blocks = 4,
	Opt_nr_inodes___2 = 5,
	Opt_size___2 = 6,
	Opt_uid___7 = 7,
	Opt_inode32 = 8,
	Opt_inode64 = 9,
	Opt_noswap = 10,
	Opt_quota___2 = 11,
	Opt_usrquota___2 = 12,
	Opt_grpquota___2 = 13,
	Opt_usrquota_block_hardlimit = 14,
	Opt_usrquota_inode_hardlimit = 15,
	Opt_grpquota_block_hardlimit = 16,
	Opt_grpquota_inode_hardlimit = 17,
	Opt_casefold_version = 18,
	Opt_casefold = 19,
	Opt_strict_encoding = 20,
};

enum shutdown_state {
	SHUTDOWN_INVALID = -1,
	SHUTDOWN_POWEROFF = 0,
	SHUTDOWN_SUSPEND = 2,
	SHUTDOWN_HALT = 4,
};

enum si_type {
	SI_TYPE_INVALID = 0,
	SI_KCS = 1,
	SI_SMIC = 2,
	SI_BT = 3,
	SI_TYPE_MAX = 4,
};

enum sig_handler {
	HANDLER_CURRENT = 0,
	HANDLER_SIG_DFL = 1,
	HANDLER_EXIT = 2,
};

enum siginfo_layout {
	SIL_KILL = 0,
	SIL_TIMER = 1,
	SIL_POLL = 2,
	SIL_FAULT = 3,
	SIL_FAULT_TRAPNO = 4,
	SIL_FAULT_MCEERR = 5,
	SIL_FAULT_BNDERR = 6,
	SIL_FAULT_PKUERR = 7,
	SIL_FAULT_PERF_EVENT = 8,
	SIL_CHLD = 9,
	SIL_RT = 10,
	SIL_SYS = 11,
};

enum sk_action {
	SK_DROP = 0,
	SK_PASS = 1,
};

enum sk_pacing {
	SK_PACING_NONE = 0,
	SK_PACING_NEEDED = 1,
	SK_PACING_FQ = 2,
};

enum sk_psock_state_bits {
	SK_PSOCK_TX_ENABLED = 0,
	SK_PSOCK_RX_STRP_ENABLED = 1,
};

enum sk_rst_reason {
	SK_RST_REASON_NOT_SPECIFIED = 0,
	SK_RST_REASON_NO_SOCKET = 1,
	SK_RST_REASON_TCP_INVALID_ACK_SEQUENCE = 2,
	SK_RST_REASON_TCP_RFC7323_PAWS = 3,
	SK_RST_REASON_TCP_TOO_OLD_ACK = 4,
	SK_RST_REASON_TCP_ACK_UNSENT_DATA = 5,
	SK_RST_REASON_TCP_FLAGS = 6,
	SK_RST_REASON_TCP_OLD_ACK = 7,
	SK_RST_REASON_TCP_ABORT_ON_DATA = 8,
	SK_RST_REASON_TCP_TIMEWAIT_SOCKET = 9,
	SK_RST_REASON_INVALID_SYN = 10,
	SK_RST_REASON_TCP_ABORT_ON_CLOSE = 11,
	SK_RST_REASON_TCP_ABORT_ON_LINGER = 12,
	SK_RST_REASON_TCP_ABORT_ON_MEMORY = 13,
	SK_RST_REASON_TCP_STATE = 14,
	SK_RST_REASON_TCP_KEEPALIVE_TIMEOUT = 15,
	SK_RST_REASON_TCP_DISCONNECT_WITH_DATA = 16,
	SK_RST_REASON_MPTCP_RST_EUNSPEC = 17,
	SK_RST_REASON_MPTCP_RST_EMPTCP = 18,
	SK_RST_REASON_MPTCP_RST_ERESOURCE = 19,
	SK_RST_REASON_MPTCP_RST_EPROHIBIT = 20,
	SK_RST_REASON_MPTCP_RST_EWQ2BIG = 21,
	SK_RST_REASON_MPTCP_RST_EBADPERF = 22,
	SK_RST_REASON_MPTCP_RST_EMIDDLEBOX = 23,
	SK_RST_REASON_ERROR = 24,
	SK_RST_REASON_MAX = 25,
};

enum skb_drop_reason {
	SKB_NOT_DROPPED_YET = 0,
	SKB_CONSUMED = 1,
	SKB_DROP_REASON_NOT_SPECIFIED = 2,
	SKB_DROP_REASON_NO_SOCKET = 3,
	SKB_DROP_REASON_SOCKET_CLOSE = 4,
	SKB_DROP_REASON_SOCKET_FILTER = 5,
	SKB_DROP_REASON_SOCKET_RCVBUFF = 6,
	SKB_DROP_REASON_UNIX_DISCONNECT = 7,
	SKB_DROP_REASON_UNIX_SKIP_OOB = 8,
	SKB_DROP_REASON_PKT_TOO_SMALL = 9,
	SKB_DROP_REASON_TCP_CSUM = 10,
	SKB_DROP_REASON_UDP_CSUM = 11,
	SKB_DROP_REASON_NETFILTER_DROP = 12,
	SKB_DROP_REASON_OTHERHOST = 13,
	SKB_DROP_REASON_IP_CSUM = 14,
	SKB_DROP_REASON_IP_INHDR = 15,
	SKB_DROP_REASON_IP_RPFILTER = 16,
	SKB_DROP_REASON_UNICAST_IN_L2_MULTICAST = 17,
	SKB_DROP_REASON_XFRM_POLICY = 18,
	SKB_DROP_REASON_IP_NOPROTO = 19,
	SKB_DROP_REASON_PROTO_MEM = 20,
	SKB_DROP_REASON_TCP_AUTH_HDR = 21,
	SKB_DROP_REASON_TCP_MD5NOTFOUND = 22,
	SKB_DROP_REASON_TCP_MD5UNEXPECTED = 23,
	SKB_DROP_REASON_TCP_MD5FAILURE = 24,
	SKB_DROP_REASON_TCP_AONOTFOUND = 25,
	SKB_DROP_REASON_TCP_AOUNEXPECTED = 26,
	SKB_DROP_REASON_TCP_AOKEYNOTFOUND = 27,
	SKB_DROP_REASON_TCP_AOFAILURE = 28,
	SKB_DROP_REASON_SOCKET_BACKLOG = 29,
	SKB_DROP_REASON_TCP_FLAGS = 30,
	SKB_DROP_REASON_TCP_ABORT_ON_DATA = 31,
	SKB_DROP_REASON_TCP_ZEROWINDOW = 32,
	SKB_DROP_REASON_TCP_OLD_DATA = 33,
	SKB_DROP_REASON_TCP_OVERWINDOW = 34,
	SKB_DROP_REASON_TCP_OFOMERGE = 35,
	SKB_DROP_REASON_TCP_RFC7323_PAWS = 36,
	SKB_DROP_REASON_TCP_RFC7323_PAWS_ACK = 37,
	SKB_DROP_REASON_TCP_RFC7323_TW_PAWS = 38,
	SKB_DROP_REASON_TCP_RFC7323_TSECR = 39,
	SKB_DROP_REASON_TCP_LISTEN_OVERFLOW = 40,
	SKB_DROP_REASON_TCP_OLD_SEQUENCE = 41,
	SKB_DROP_REASON_TCP_INVALID_SEQUENCE = 42,
	SKB_DROP_REASON_TCP_INVALID_END_SEQUENCE = 43,
	SKB_DROP_REASON_TCP_INVALID_ACK_SEQUENCE = 44,
	SKB_DROP_REASON_TCP_RESET = 45,
	SKB_DROP_REASON_TCP_INVALID_SYN = 46,
	SKB_DROP_REASON_TCP_CLOSE = 47,
	SKB_DROP_REASON_TCP_FASTOPEN = 48,
	SKB_DROP_REASON_TCP_OLD_ACK = 49,
	SKB_DROP_REASON_TCP_TOO_OLD_ACK = 50,
	SKB_DROP_REASON_TCP_ACK_UNSENT_DATA = 51,
	SKB_DROP_REASON_TCP_OFO_QUEUE_PRUNE = 52,
	SKB_DROP_REASON_TCP_OFO_DROP = 53,
	SKB_DROP_REASON_IP_OUTNOROUTES = 54,
	SKB_DROP_REASON_BPF_CGROUP_EGRESS = 55,
	SKB_DROP_REASON_IPV6DISABLED = 56,
	SKB_DROP_REASON_NEIGH_CREATEFAIL = 57,
	SKB_DROP_REASON_NEIGH_FAILED = 58,
	SKB_DROP_REASON_NEIGH_QUEUEFULL = 59,
	SKB_DROP_REASON_NEIGH_DEAD = 60,
	SKB_DROP_REASON_NEIGH_HH_FILLFAIL = 61,
	SKB_DROP_REASON_TC_EGRESS = 62,
	SKB_DROP_REASON_SECURITY_HOOK = 63,
	SKB_DROP_REASON_QDISC_DROP = 64,
	SKB_DROP_REASON_QDISC_OVERLIMIT = 65,
	SKB_DROP_REASON_QDISC_CONGESTED = 66,
	SKB_DROP_REASON_CAKE_FLOOD = 67,
	SKB_DROP_REASON_FQ_BAND_LIMIT = 68,
	SKB_DROP_REASON_FQ_HORIZON_LIMIT = 69,
	SKB_DROP_REASON_FQ_FLOW_LIMIT = 70,
	SKB_DROP_REASON_CPU_BACKLOG = 71,
	SKB_DROP_REASON_XDP = 72,
	SKB_DROP_REASON_TC_INGRESS = 73,
	SKB_DROP_REASON_UNHANDLED_PROTO = 74,
	SKB_DROP_REASON_SKB_CSUM = 75,
	SKB_DROP_REASON_SKB_GSO_SEG = 76,
	SKB_DROP_REASON_SKB_UCOPY_FAULT = 77,
	SKB_DROP_REASON_DEV_HDR = 78,
	SKB_DROP_REASON_DEV_READY = 79,
	SKB_DROP_REASON_FULL_RING = 80,
	SKB_DROP_REASON_NOMEM = 81,
	SKB_DROP_REASON_HDR_TRUNC = 82,
	SKB_DROP_REASON_TAP_FILTER = 83,
	SKB_DROP_REASON_TAP_TXFILTER = 84,
	SKB_DROP_REASON_ICMP_CSUM = 85,
	SKB_DROP_REASON_INVALID_PROTO = 86,
	SKB_DROP_REASON_IP_INADDRERRORS = 87,
	SKB_DROP_REASON_IP_INNOROUTES = 88,
	SKB_DROP_REASON_IP_LOCAL_SOURCE = 89,
	SKB_DROP_REASON_IP_INVALID_SOURCE = 90,
	SKB_DROP_REASON_IP_LOCALNET = 91,
	SKB_DROP_REASON_IP_INVALID_DEST = 92,
	SKB_DROP_REASON_PKT_TOO_BIG = 93,
	SKB_DROP_REASON_DUP_FRAG = 94,
	SKB_DROP_REASON_FRAG_REASM_TIMEOUT = 95,
	SKB_DROP_REASON_FRAG_TOO_FAR = 96,
	SKB_DROP_REASON_TCP_MINTTL = 97,
	SKB_DROP_REASON_IPV6_BAD_EXTHDR = 98,
	SKB_DROP_REASON_IPV6_NDISC_FRAG = 99,
	SKB_DROP_REASON_IPV6_NDISC_HOP_LIMIT = 100,
	SKB_DROP_REASON_IPV6_NDISC_BAD_CODE = 101,
	SKB_DROP_REASON_IPV6_NDISC_BAD_OPTIONS = 102,
	SKB_DROP_REASON_IPV6_NDISC_NS_OTHERHOST = 103,
	SKB_DROP_REASON_QUEUE_PURGE = 104,
	SKB_DROP_REASON_TC_COOKIE_ERROR = 105,
	SKB_DROP_REASON_PACKET_SOCK_ERROR = 106,
	SKB_DROP_REASON_TC_CHAIN_NOTFOUND = 107,
	SKB_DROP_REASON_TC_RECLASSIFY_LOOP = 108,
	SKB_DROP_REASON_VXLAN_INVALID_HDR = 109,
	SKB_DROP_REASON_VXLAN_VNI_NOT_FOUND = 110,
	SKB_DROP_REASON_MAC_INVALID_SOURCE = 111,
	SKB_DROP_REASON_VXLAN_ENTRY_EXISTS = 112,
	SKB_DROP_REASON_NO_TX_TARGET = 113,
	SKB_DROP_REASON_IP_TUNNEL_ECN = 114,
	SKB_DROP_REASON_TUNNEL_TXINFO = 115,
	SKB_DROP_REASON_LOCAL_MAC = 116,
	SKB_DROP_REASON_ARP_PVLAN_DISABLE = 117,
	SKB_DROP_REASON_MAC_IEEE_MAC_CONTROL = 118,
	SKB_DROP_REASON_BRIDGE_INGRESS_STP_STATE = 119,
	SKB_DROP_REASON_CAN_RX_INVALID_FRAME = 120,
	SKB_DROP_REASON_CANFD_RX_INVALID_FRAME = 121,
	SKB_DROP_REASON_CANXL_RX_INVALID_FRAME = 122,
	SKB_DROP_REASON_PFMEMALLOC = 123,
	SKB_DROP_REASON_DUALPI2_STEP_DROP = 124,
	SKB_DROP_REASON_PSP_INPUT = 125,
	SKB_DROP_REASON_PSP_OUTPUT = 126,
	SKB_DROP_REASON_MAX = 127,
	SKB_DROP_REASON_SUBSYS_MASK = 4294901760,
};

enum skb_drop_reason_subsys {
	SKB_DROP_REASON_SUBSYS_CORE = 0,
	SKB_DROP_REASON_SUBSYS_MAC80211_UNUSABLE = 1,
	SKB_DROP_REASON_SUBSYS_OPENVSWITCH = 2,
	SKB_DROP_REASON_SUBSYS_NUM = 3,
};

enum skb_ext_id {
	SKB_EXT_BRIDGE_NF = 0,
	SKB_EXT_NUM = 1,
};

enum skb_tstamp_type {
	SKB_CLOCK_REALTIME = 0,
	SKB_CLOCK_MONOTONIC = 1,
	SKB_CLOCK_TAI = 2,
	__SKB_CLOCK_MAX = 2,
};

enum sknetlink_groups {
	SKNLGRP_NONE = 0,
	SKNLGRP_INET_TCP_DESTROY = 1,
	SKNLGRP_INET_UDP_DESTROY = 2,
	SKNLGRP_INET6_TCP_DESTROY = 3,
	SKNLGRP_INET6_UDP_DESTROY = 4,
	__SKNLGRP_MAX = 5,
};

enum slab_flags {
	SL_locked = 0,
	SL_partial = 9,
	SL_pfmemalloc = 8,
};

enum slab_stat_type {
	SL_ALL = 0,
	SL_PARTIAL = 1,
	SL_CPU = 2,
	SL_OBJECTS = 3,
	SL_TOTAL = 4,
};

enum slab_state {
	DOWN___2 = 0,
	PARTIAL = 1,
	UP___2 = 2,
	FULL = 3,
};

enum smbios_attr_enum {
	SMBIOS_ATTR_NONE = 0,
	SMBIOS_ATTR_LABEL_SHOW = 1,
	SMBIOS_ATTR_INSTANCE_SHOW = 2,
};

enum smcwd_call {
	SMCWD_INIT = 0,
	SMCWD_SET_TIMEOUT = 1,
	SMCWD_ENABLE = 2,
	SMCWD_PET = 3,
	SMCWD_GET_TIMELEFT = 4,
};

enum smd_channel_state {
	SMD_CHANNEL_CLOSED = 0,
	SMD_CHANNEL_OPENING = 1,
	SMD_CHANNEL_OPENED = 2,
	SMD_CHANNEL_FLUSHING = 3,
	SMD_CHANNEL_CLOSING = 4,
	SMD_CHANNEL_RESET = 5,
	SMD_CHANNEL_RESET_OPENING = 6,
};

enum smt_mitigations {
	SMT_MITIGATIONS_OFF = 0,
	SMT_MITIGATIONS_AUTO = 1,
	SMT_MITIGATIONS_ON = 2,
};

enum snoop_when {
	SUBMIT = 0,
	COMPLETE___2 = 1,
};

enum soc_type {
	SOC_ARCH_EXYNOS3250 = 1,
	SOC_ARCH_EXYNOS4210 = 2,
	SOC_ARCH_EXYNOS4412 = 3,
	SOC_ARCH_EXYNOS5250 = 4,
	SOC_ARCH_EXYNOS5260 = 5,
	SOC_ARCH_EXYNOS5420 = 6,
	SOC_ARCH_EXYNOS5420_TRIMINFO = 7,
	SOC_ARCH_EXYNOS5433 = 8,
	SOC_ARCH_EXYNOS7 = 9,
};

enum sock_flags {
	SOCK_DEAD = 0,
	SOCK_DONE = 1,
	SOCK_URGINLINE = 2,
	SOCK_KEEPOPEN = 3,
	SOCK_LINGER = 4,
	SOCK_DESTROY = 5,
	SOCK_BROADCAST = 6,
	SOCK_TIMESTAMP = 7,
	SOCK_ZAPPED = 8,
	SOCK_USE_WRITE_QUEUE = 9,
	SOCK_DBG = 10,
	SOCK_RCVTSTAMP = 11,
	SOCK_RCVTSTAMPNS = 12,
	SOCK_LOCALROUTE = 13,
	SOCK_MEMALLOC = 14,
	SOCK_TIMESTAMPING_RX_SOFTWARE = 15,
	SOCK_FASYNC = 16,
	SOCK_RXQ_OVFL = 17,
	SOCK_ZEROCOPY = 18,
	SOCK_WIFI_STATUS = 19,
	SOCK_NOFCS = 20,
	SOCK_FILTER_LOCKED = 21,
	SOCK_SELECT_ERR_QUEUE = 22,
	SOCK_RCU_FREE = 23,
	SOCK_TXTIME = 24,
	SOCK_XDP = 25,
	SOCK_TSTAMP_NEW = 26,
	SOCK_RCVMARK = 27,
	SOCK_RCVPRIORITY = 28,
	SOCK_TIMESTAMPING_ANY = 29,
};

enum sock_shutdown_cmd {
	SHUT_RD = 0,
	SHUT_WR = 1,
	SHUT_RDWR = 2,
};

enum sock_type {
	SOCK_STREAM = 1,
	SOCK_DGRAM = 2,
	SOCK_RAW = 3,
	SOCK_RDM = 4,
	SOCK_SEQPACKET = 5,
	SOCK_DCCP = 6,
	SOCK_PACKET = 10,
};

enum socket_flags {
	SOCKWQ_ASYNC_NOSPACE = 0,
	SOCKWQ_ASYNC_WAITDATA = 1,
	SOCK_NOSPACE = 2,
	SOCK_SUPPORT_ZC = 3,
	SOCK_CUSTOM_SOCKOPT = 4,
};

enum special_kfunc_type {
	KF_bpf_obj_new_impl = 0,
	KF_bpf_obj_drop_impl = 1,
	KF_bpf_refcount_acquire_impl = 2,
	KF_bpf_list_push_front_impl = 3,
	KF_bpf_list_push_back_impl = 4,
	KF_bpf_list_pop_front = 5,
	KF_bpf_list_pop_back = 6,
	KF_bpf_list_front = 7,
	KF_bpf_list_back = 8,
	KF_bpf_cast_to_kern_ctx = 9,
	KF_bpf_rdonly_cast = 10,
	KF_bpf_rcu_read_lock = 11,
	KF_bpf_rcu_read_unlock = 12,
	KF_bpf_rbtree_remove = 13,
	KF_bpf_rbtree_add_impl = 14,
	KF_bpf_rbtree_first = 15,
	KF_bpf_rbtree_root = 16,
	KF_bpf_rbtree_left = 17,
	KF_bpf_rbtree_right = 18,
	KF_bpf_dynptr_from_skb = 19,
	KF_bpf_dynptr_from_xdp = 20,
	KF_bpf_dynptr_from_skb_meta = 21,
	KF_bpf_xdp_pull_data = 22,
	KF_bpf_dynptr_slice = 23,
	KF_bpf_dynptr_slice_rdwr = 24,
	KF_bpf_dynptr_clone = 25,
	KF_bpf_percpu_obj_new_impl = 26,
	KF_bpf_percpu_obj_drop_impl = 27,
	KF_bpf_throw = 28,
	KF_bpf_wq_set_callback_impl = 29,
	KF_bpf_preempt_disable = 30,
	KF_bpf_preempt_enable = 31,
	KF_bpf_iter_css_task_new = 32,
	KF_bpf_session_cookie = 33,
	KF_bpf_get_kmem_cache = 34,
	KF_bpf_local_irq_save = 35,
	KF_bpf_local_irq_restore = 36,
	KF_bpf_iter_num_new = 37,
	KF_bpf_iter_num_next = 38,
	KF_bpf_iter_num_destroy = 39,
	KF_bpf_set_dentry_xattr = 40,
	KF_bpf_remove_dentry_xattr = 41,
	KF_bpf_res_spin_lock = 42,
	KF_bpf_res_spin_unlock = 43,
	KF_bpf_res_spin_lock_irqsave = 44,
	KF_bpf_res_spin_unlock_irqrestore = 45,
	KF___bpf_trap = 46,
	KF_bpf_task_work_schedule_signal_impl = 47,
	KF_bpf_task_work_schedule_resume_impl = 48,
};

enum spectre_v4_policy {
	SPECTRE_V4_POLICY_MITIGATION_DYNAMIC = 0,
	SPECTRE_V4_POLICY_MITIGATION_ENABLED = 1,
	SPECTRE_V4_POLICY_MITIGATION_DISABLED = 2,
};

enum spi_mem_data_dir {
	SPI_MEM_NO_DATA = 0,
	SPI_MEM_DATA_IN = 1,
	SPI_MEM_DATA_OUT = 2,
};

enum spi_nor_cmd_ext {
	SPI_NOR_EXT_NONE = 0,
	SPI_NOR_EXT_REPEAT = 1,
	SPI_NOR_EXT_INVERT = 2,
	SPI_NOR_EXT_HEX = 3,
};

enum spi_nor_option_flags {
	SNOR_F_HAS_SR_TB = 1,
	SNOR_F_NO_OP_CHIP_ERASE = 2,
	SNOR_F_BROKEN_RESET = 4,
	SNOR_F_4B_OPCODES = 8,
	SNOR_F_HAS_4BAIT = 16,
	SNOR_F_HAS_LOCK = 32,
	SNOR_F_HAS_16BIT_SR = 64,
	SNOR_F_NO_READ_CR = 128,
	SNOR_F_HAS_SR_TB_BIT6 = 256,
	SNOR_F_HAS_4BIT_BP = 512,
	SNOR_F_HAS_SR_BP3_BIT6 = 1024,
	SNOR_F_IO_MODE_EN_VOLATILE = 2048,
	SNOR_F_SOFT_RESET = 4096,
	SNOR_F_SWP_IS_VOLATILE = 8192,
	SNOR_F_RWW = 16384,
	SNOR_F_ECC = 32768,
	SNOR_F_NO_WP = 65536,
	SNOR_F_SWAP16 = 131072,
};

enum spi_nor_pp_command_index {
	SNOR_CMD_PP = 0,
	SNOR_CMD_PP_1_1_4 = 1,
	SNOR_CMD_PP_1_4_4 = 2,
	SNOR_CMD_PP_4_4_4 = 3,
	SNOR_CMD_PP_1_1_8 = 4,
	SNOR_CMD_PP_1_8_8 = 5,
	SNOR_CMD_PP_8_8_8 = 6,
	SNOR_CMD_PP_8_8_8_DTR = 7,
	SNOR_CMD_PP_MAX = 8,
};

enum spi_nor_protocol {
	SNOR_PROTO_1_1_1 = 65793,
	SNOR_PROTO_1_1_2 = 65794,
	SNOR_PROTO_1_1_4 = 65796,
	SNOR_PROTO_1_1_8 = 65800,
	SNOR_PROTO_1_2_2 = 66050,
	SNOR_PROTO_1_4_4 = 66564,
	SNOR_PROTO_1_8_8 = 67592,
	SNOR_PROTO_2_2_2 = 131586,
	SNOR_PROTO_4_4_4 = 263172,
	SNOR_PROTO_8_8_8 = 526344,
	SNOR_PROTO_1_1_1_DTR = 16843009,
	SNOR_PROTO_1_2_2_DTR = 16843266,
	SNOR_PROTO_1_4_4_DTR = 16843780,
	SNOR_PROTO_1_8_8_DTR = 16844808,
	SNOR_PROTO_8_8_8_DTR = 17303560,
};

enum spi_nor_read_command_index {
	SNOR_CMD_READ = 0,
	SNOR_CMD_READ_FAST = 1,
	SNOR_CMD_READ_1_1_1_DTR = 2,
	SNOR_CMD_READ_1_1_2 = 3,
	SNOR_CMD_READ_1_2_2 = 4,
	SNOR_CMD_READ_2_2_2 = 5,
	SNOR_CMD_READ_1_2_2_DTR = 6,
	SNOR_CMD_READ_1_1_4 = 7,
	SNOR_CMD_READ_1_4_4 = 8,
	SNOR_CMD_READ_4_4_4 = 9,
	SNOR_CMD_READ_1_4_4_DTR = 10,
	SNOR_CMD_READ_1_1_8 = 11,
	SNOR_CMD_READ_1_8_8 = 12,
	SNOR_CMD_READ_8_8_8 = 13,
	SNOR_CMD_READ_1_8_8_DTR = 14,
	SNOR_CMD_READ_8_8_8_DTR = 15,
	SNOR_CMD_READ_MAX = 16,
};

enum spmi_boost_byp_registers {
	SPMI_BOOST_BYP_REG_CURRENT_LIMIT = 75,
};

enum spmi_boost_registers {
	SPMI_BOOST_REG_CURRENT_LIMIT = 74,
};

enum spmi_common_control_register_index {
	SPMI_COMMON_IDX_VOLTAGE_RANGE = 0,
	SPMI_COMMON_IDX_VOLTAGE_SET = 1,
	SPMI_COMMON_IDX_MODE = 5,
	SPMI_COMMON_IDX_ENABLE = 6,
};

enum spmi_common_regulator_registers {
	SPMI_COMMON_REG_DIG_MAJOR_REV = 1,
	SPMI_COMMON_REG_TYPE = 4,
	SPMI_COMMON_REG_SUBTYPE = 5,
	SPMI_COMMON_REG_VOLTAGE_RANGE = 64,
	SPMI_COMMON_REG_VOLTAGE_SET = 65,
	SPMI_COMMON_REG_MODE = 69,
	SPMI_COMMON_REG_ENABLE = 70,
	SPMI_COMMON_REG_PULL_DOWN = 72,
	SPMI_COMMON_REG_SOFT_START = 76,
	SPMI_COMMON_REG_STEP_CTRL = 97,
};

enum spmi_ftsmps426_regulator_registers {
	SPMI_FTSMPS426_REG_VOLTAGE_LSB = 64,
	SPMI_FTSMPS426_REG_VOLTAGE_MSB = 65,
	SPMI_FTSMPS426_REG_VOLTAGE_ULS_LSB = 104,
	SPMI_FTSMPS426_REG_VOLTAGE_ULS_MSB = 105,
};

enum spmi_hfsmps_regulator_registers {
	SPMI_HFSMPS_REG_STEP_CTRL = 60,
	SPMI_HFSMPS_REG_PULL_DOWN = 160,
};

enum spmi_regulator_logical_type {
	SPMI_REGULATOR_LOGICAL_TYPE_SMPS = 0,
	SPMI_REGULATOR_LOGICAL_TYPE_LDO = 1,
	SPMI_REGULATOR_LOGICAL_TYPE_VS = 2,
	SPMI_REGULATOR_LOGICAL_TYPE_BOOST = 3,
	SPMI_REGULATOR_LOGICAL_TYPE_FTSMPS = 4,
	SPMI_REGULATOR_LOGICAL_TYPE_BOOST_BYP = 5,
	SPMI_REGULATOR_LOGICAL_TYPE_LN_LDO = 6,
	SPMI_REGULATOR_LOGICAL_TYPE_ULT_LO_SMPS = 7,
	SPMI_REGULATOR_LOGICAL_TYPE_ULT_HO_SMPS = 8,
	SPMI_REGULATOR_LOGICAL_TYPE_ULT_LDO = 9,
	SPMI_REGULATOR_LOGICAL_TYPE_FTSMPS426 = 10,
	SPMI_REGULATOR_LOGICAL_TYPE_HFS430 = 11,
	SPMI_REGULATOR_LOGICAL_TYPE_FTSMPS3 = 12,
	SPMI_REGULATOR_LOGICAL_TYPE_LDO_510 = 13,
	SPMI_REGULATOR_LOGICAL_TYPE_HFSMPS = 14,
};

enum spmi_regulator_subtype {
	SPMI_REGULATOR_SUBTYPE_GP_CTL = 8,
	SPMI_REGULATOR_SUBTYPE_RF_CTL = 9,
	SPMI_REGULATOR_SUBTYPE_N50 = 1,
	SPMI_REGULATOR_SUBTYPE_N150 = 2,
	SPMI_REGULATOR_SUBTYPE_N300 = 3,
	SPMI_REGULATOR_SUBTYPE_N600 = 4,
	SPMI_REGULATOR_SUBTYPE_N1200 = 5,
	SPMI_REGULATOR_SUBTYPE_N600_ST = 6,
	SPMI_REGULATOR_SUBTYPE_N1200_ST = 7,
	SPMI_REGULATOR_SUBTYPE_N900_ST = 20,
	SPMI_REGULATOR_SUBTYPE_N300_ST = 21,
	SPMI_REGULATOR_SUBTYPE_P50 = 8,
	SPMI_REGULATOR_SUBTYPE_P150 = 9,
	SPMI_REGULATOR_SUBTYPE_P300 = 10,
	SPMI_REGULATOR_SUBTYPE_P600 = 11,
	SPMI_REGULATOR_SUBTYPE_P1200 = 12,
	SPMI_REGULATOR_SUBTYPE_LN = 16,
	SPMI_REGULATOR_SUBTYPE_LV_P50 = 40,
	SPMI_REGULATOR_SUBTYPE_LV_P150 = 41,
	SPMI_REGULATOR_SUBTYPE_LV_P300 = 42,
	SPMI_REGULATOR_SUBTYPE_LV_P600 = 43,
	SPMI_REGULATOR_SUBTYPE_LV_P1200 = 44,
	SPMI_REGULATOR_SUBTYPE_LV_P450 = 45,
	SPMI_REGULATOR_SUBTYPE_HT_N300_ST = 48,
	SPMI_REGULATOR_SUBTYPE_HT_N600_ST = 49,
	SPMI_REGULATOR_SUBTYPE_HT_N1200_ST = 50,
	SPMI_REGULATOR_SUBTYPE_HT_LVP150 = 59,
	SPMI_REGULATOR_SUBTYPE_HT_LVP300 = 60,
	SPMI_REGULATOR_SUBTYPE_L660_N300_ST = 66,
	SPMI_REGULATOR_SUBTYPE_L660_N600_ST = 67,
	SPMI_REGULATOR_SUBTYPE_L660_P50 = 70,
	SPMI_REGULATOR_SUBTYPE_L660_P150 = 71,
	SPMI_REGULATOR_SUBTYPE_L660_P600 = 73,
	SPMI_REGULATOR_SUBTYPE_L660_LVP150 = 77,
	SPMI_REGULATOR_SUBTYPE_L660_LVP600 = 79,
	SPMI_REGULATOR_SUBTYPE_LV100 = 1,
	SPMI_REGULATOR_SUBTYPE_LV300 = 2,
	SPMI_REGULATOR_SUBTYPE_MV300 = 8,
	SPMI_REGULATOR_SUBTYPE_MV500 = 9,
	SPMI_REGULATOR_SUBTYPE_HDMI = 16,
	SPMI_REGULATOR_SUBTYPE_OTG = 17,
	SPMI_REGULATOR_SUBTYPE_5V_BOOST = 1,
	SPMI_REGULATOR_SUBTYPE_FTS_CTL = 8,
	SPMI_REGULATOR_SUBTYPE_FTS2p5_CTL = 9,
	SPMI_REGULATOR_SUBTYPE_FTS426_CTL = 10,
	SPMI_REGULATOR_SUBTYPE_BB_2A = 1,
	SPMI_REGULATOR_SUBTYPE_ULT_HF_CTL1 = 13,
	SPMI_REGULATOR_SUBTYPE_ULT_HF_CTL2 = 14,
	SPMI_REGULATOR_SUBTYPE_ULT_HF_CTL3 = 15,
	SPMI_REGULATOR_SUBTYPE_ULT_HF_CTL4 = 16,
	SPMI_REGULATOR_SUBTYPE_HFS430 = 10,
	SPMI_REGULATOR_SUBTYPE_HT_P150 = 53,
	SPMI_REGULATOR_SUBTYPE_HT_P600 = 61,
	SPMI_REGULATOR_SUBTYPE_HFSMPS_510 = 10,
	SPMI_REGULATOR_SUBTYPE_FTSMPS_510 = 11,
	SPMI_REGULATOR_SUBTYPE_LV_P150_510 = 113,
	SPMI_REGULATOR_SUBTYPE_LV_P300_510 = 114,
	SPMI_REGULATOR_SUBTYPE_LV_P600_510 = 115,
	SPMI_REGULATOR_SUBTYPE_N300_510 = 106,
	SPMI_REGULATOR_SUBTYPE_N600_510 = 107,
	SPMI_REGULATOR_SUBTYPE_N1200_510 = 108,
	SPMI_REGULATOR_SUBTYPE_MV_P50_510 = 122,
	SPMI_REGULATOR_SUBTYPE_MV_P150_510 = 123,
	SPMI_REGULATOR_SUBTYPE_MV_P600_510 = 125,
};

enum spmi_regulator_type {
	SPMI_REGULATOR_TYPE_BUCK = 3,
	SPMI_REGULATOR_TYPE_LDO = 4,
	SPMI_REGULATOR_TYPE_VS = 5,
	SPMI_REGULATOR_TYPE_BOOST = 27,
	SPMI_REGULATOR_TYPE_FTS = 28,
	SPMI_REGULATOR_TYPE_BOOST_BYP = 31,
	SPMI_REGULATOR_TYPE_ULT_LDO = 33,
	SPMI_REGULATOR_TYPE_ULT_BUCK = 34,
};

enum spmi_saw3_registers {
	SAW3_SECURE = 0,
	SAW3_ID = 4,
	SAW3_SPM_STS = 12,
	SAW3_AVS_STS = 16,
	SAW3_PMIC_STS = 20,
	SAW3_RST = 24,
	SAW3_VCTL = 28,
	SAW3_AVS_CTL = 32,
	SAW3_AVS_LIMIT = 36,
	SAW3_AVS_DLY = 40,
	SAW3_AVS_HYSTERESIS = 44,
	SAW3_SPM_STS2 = 56,
	SAW3_SPM_PMIC_DATA_3 = 76,
	SAW3_VERSION = 4048,
};

enum spmi_vs_registers {
	SPMI_VS_REG_OCP = 74,
	SPMI_VS_REG_SOFT_START = 76,
};

enum spmi_vs_soft_start_str {
	SPMI_VS_SOFT_START_STR_0P05_UA = 0,
	SPMI_VS_SOFT_START_STR_0P25_UA = 1,
	SPMI_VS_SOFT_START_STR_0P55_UA = 2,
	SPMI_VS_SOFT_START_STR_0P75_UA = 3,
	SPMI_VS_SOFT_START_STR_HW_DEFAULT = 4,
};

enum squashfs_param {
	Opt_errors___3 = 0,
	Opt_threads = 1,
};

enum sr_loc_attr {
	SR_LOC_MEMORY = 0,
	SR_LOC_LOADED = 1,
	SR_LOC_MAPPED = 2,
	SR_LOC_XLATED = 4,
	SR_LOC_SPECIAL = 8,
};

enum sr_retry_flags {
	IORING_RECV_RETRY = 32768,
	IORING_RECV_PARTIAL_MAP = 16384,
	IORING_RECV_MSHOT_CAP = 8192,
	IORING_RECV_MSHOT_LIM = 4096,
	IORING_RECV_MSHOT_DONE = 2048,
	IORING_RECV_RETRY_CLEAR = 49152,
	IORING_RECV_NO_RETRY = 59392,
};

enum ssp_clkdelay {
	SSP_FEEDBACK_CLK_DELAY_NONE = 0,
	SSP_FEEDBACK_CLK_DELAY_1T = 1,
	SSP_FEEDBACK_CLK_DELAY_2T = 2,
	SSP_FEEDBACK_CLK_DELAY_3T = 3,
	SSP_FEEDBACK_CLK_DELAY_4T = 4,
	SSP_FEEDBACK_CLK_DELAY_5T = 5,
	SSP_FEEDBACK_CLK_DELAY_6T = 6,
	SSP_FEEDBACK_CLK_DELAY_7T = 7,
};

enum ssp_data_size {
	SSP_DATA_BITS_4 = 3,
	SSP_DATA_BITS_5 = 4,
	SSP_DATA_BITS_6 = 5,
	SSP_DATA_BITS_7 = 6,
	SSP_DATA_BITS_8 = 7,
	SSP_DATA_BITS_9 = 8,
	SSP_DATA_BITS_10 = 9,
	SSP_DATA_BITS_11 = 10,
	SSP_DATA_BITS_12 = 11,
	SSP_DATA_BITS_13 = 12,
	SSP_DATA_BITS_14 = 13,
	SSP_DATA_BITS_15 = 14,
	SSP_DATA_BITS_16 = 15,
	SSP_DATA_BITS_17 = 16,
	SSP_DATA_BITS_18 = 17,
	SSP_DATA_BITS_19 = 18,
	SSP_DATA_BITS_20 = 19,
	SSP_DATA_BITS_21 = 20,
	SSP_DATA_BITS_22 = 21,
	SSP_DATA_BITS_23 = 22,
	SSP_DATA_BITS_24 = 23,
	SSP_DATA_BITS_25 = 24,
	SSP_DATA_BITS_26 = 25,
	SSP_DATA_BITS_27 = 26,
	SSP_DATA_BITS_28 = 27,
	SSP_DATA_BITS_29 = 28,
	SSP_DATA_BITS_30 = 29,
	SSP_DATA_BITS_31 = 30,
	SSP_DATA_BITS_32 = 31,
};

enum ssp_duplex {
	SSP_MICROWIRE_CHANNEL_FULL_DUPLEX = 0,
	SSP_MICROWIRE_CHANNEL_HALF_DUPLEX = 1,
};

enum ssp_hierarchy {
	SSP_MASTER = 0,
	SSP_SLAVE = 1,
};

enum ssp_interface {
	SSP_INTERFACE_MOTOROLA_SPI = 0,
	SSP_INTERFACE_TI_SYNC_SERIAL = 1,
	SSP_INTERFACE_NATIONAL_MICROWIRE = 2,
	SSP_INTERFACE_UNIDIRECTIONAL = 3,
};

enum ssp_loopback {
	LOOPBACK_DISABLED = 0,
	LOOPBACK_ENABLED = 1,
};

enum ssp_microwire_ctrl_len {
	SSP_BITS_4 = 3,
	SSP_BITS_5 = 4,
	SSP_BITS_6 = 5,
	SSP_BITS_7 = 6,
	SSP_BITS_8 = 7,
	SSP_BITS_9 = 8,
	SSP_BITS_10 = 9,
	SSP_BITS_11 = 10,
	SSP_BITS_12 = 11,
	SSP_BITS_13 = 12,
	SSP_BITS_14 = 13,
	SSP_BITS_15 = 14,
	SSP_BITS_16 = 15,
	SSP_BITS_17 = 16,
	SSP_BITS_18 = 17,
	SSP_BITS_19 = 18,
	SSP_BITS_20 = 19,
	SSP_BITS_21 = 20,
	SSP_BITS_22 = 21,
	SSP_BITS_23 = 22,
	SSP_BITS_24 = 23,
	SSP_BITS_25 = 24,
	SSP_BITS_26 = 25,
	SSP_BITS_27 = 26,
	SSP_BITS_28 = 27,
	SSP_BITS_29 = 28,
	SSP_BITS_30 = 29,
	SSP_BITS_31 = 30,
	SSP_BITS_32 = 31,
};

enum ssp_microwire_wait_state {
	SSP_MWIRE_WAIT_ZERO = 0,
	SSP_MWIRE_WAIT_ONE = 1,
};

enum ssp_mode {
	INTERRUPT_TRANSFER = 0,
	POLLING_TRANSFER = 1,
	DMA_TRANSFER = 2,
};

enum ssp_reading {
	READING_NULL = 0,
	READING_U8 = 1,
	READING_U16 = 2,
	READING_U32 = 3,
};

enum ssp_rx_endian {
	SSP_RX_MSB = 0,
	SSP_RX_LSB = 1,
};

enum ssp_rx_level_trig {
	SSP_RX_1_OR_MORE_ELEM = 0,
	SSP_RX_4_OR_MORE_ELEM = 1,
	SSP_RX_8_OR_MORE_ELEM = 2,
	SSP_RX_16_OR_MORE_ELEM = 3,
	SSP_RX_32_OR_MORE_ELEM = 4,
};

enum ssp_spi_clk_phase {
	SSP_CLK_FIRST_EDGE = 0,
	SSP_CLK_SECOND_EDGE = 1,
};

enum ssp_spi_clk_pol {
	SSP_CLK_POL_IDLE_LOW = 0,
	SSP_CLK_POL_IDLE_HIGH = 1,
};

enum ssp_tx_endian {
	SSP_TX_MSB = 0,
	SSP_TX_LSB = 1,
};

enum ssp_tx_level_trig {
	SSP_TX_1_OR_MORE_EMPTY_LOC = 0,
	SSP_TX_4_OR_MORE_EMPTY_LOC = 1,
	SSP_TX_8_OR_MORE_EMPTY_LOC = 2,
	SSP_TX_16_OR_MORE_EMPTY_LOC = 3,
	SSP_TX_32_OR_MORE_EMPTY_LOC = 4,
};

enum ssp_writing {
	WRITING_NULL = 0,
	WRITING_U8 = 1,
	WRITING_U16 = 2,
	WRITING_U32 = 3,
};

enum ssusb_uwk_vers {
	SSUSB_UWK_V1 = 1,
	SSUSB_UWK_V2 = 2,
	SSUSB_UWK_V1_1 = 101,
	SSUSB_UWK_V1_2 = 102,
	SSUSB_UWK_V1_3 = 103,
	SSUSB_UWK_V1_4 = 104,
	SSUSB_UWK_V1_5 = 105,
	SSUSB_UWK_V1_6 = 106,
};

enum ssusb_uwk_vers___2 {
	SSUSB_UWK_V1___2 = 1,
	SSUSB_UWK_V2___2 = 2,
	SSUSB_UWK_V1_1___2 = 101,
	SSUSB_UWK_V1_2___2 = 102,
	SSUSB_UWK_V1_3___2 = 103,
	SSUSB_UWK_V1_5___2 = 105,
	SSUSB_UWK_V1_6___2 = 106,
};

enum stat_group {
	STAT_READ = 0,
	STAT_WRITE = 1,
	STAT_DISCARD = 2,
	STAT_FLUSH = 3,
	NR_STAT_GROUPS = 4,
};

enum stat_item {
	ALLOC_PCS = 0,
	ALLOC_FASTPATH = 1,
	ALLOC_SLOWPATH = 2,
	FREE_PCS = 3,
	FREE_RCU_SHEAF = 4,
	FREE_RCU_SHEAF_FAIL = 5,
	FREE_FASTPATH = 6,
	FREE_SLOWPATH = 7,
	FREE_FROZEN = 8,
	FREE_ADD_PARTIAL = 9,
	FREE_REMOVE_PARTIAL = 10,
	ALLOC_FROM_PARTIAL = 11,
	ALLOC_SLAB = 12,
	ALLOC_REFILL = 13,
	ALLOC_NODE_MISMATCH = 14,
	FREE_SLAB = 15,
	CPUSLAB_FLUSH = 16,
	DEACTIVATE_FULL = 17,
	DEACTIVATE_EMPTY = 18,
	DEACTIVATE_TO_HEAD = 19,
	DEACTIVATE_TO_TAIL = 20,
	DEACTIVATE_REMOTE_FREES = 21,
	DEACTIVATE_BYPASS = 22,
	ORDER_FALLBACK = 23,
	CMPXCHG_DOUBLE_CPU_FAIL = 24,
	CMPXCHG_DOUBLE_FAIL = 25,
	CPU_PARTIAL_ALLOC = 26,
	CPU_PARTIAL_FREE = 27,
	CPU_PARTIAL_NODE = 28,
	CPU_PARTIAL_DRAIN = 29,
	SHEAF_FLUSH = 30,
	SHEAF_REFILL = 31,
	SHEAF_ALLOC = 32,
	SHEAF_FREE = 33,
	BARN_GET = 34,
	BARN_GET_FAIL = 35,
	BARN_PUT = 36,
	BARN_PUT_FAIL = 37,
	SHEAF_PREFILL_FAST = 38,
	SHEAF_PREFILL_SLOW = 39,
	SHEAF_PREFILL_OVERSIZE = 40,
	SHEAF_RETURN_FAST = 41,
	SHEAF_RETURN_SLOW = 42,
	NR_SLUB_STAT_ITEMS = 43,
};

enum state {
	Start = 0,
	Collect = 1,
	GotHeader = 2,
	SkipIt = 3,
	GotName = 4,
	CopyFile = 5,
	GotSymlink = 6,
	Reset = 7,
};

enum state_protect_how4 {
	SP4_NONE = 0,
	SP4_MACH_CRED = 1,
	SP4_SSV = 2,
};

enum status_css {
	CSS_TCPUDPCSOK = 128,
	CSS_ISUDP = 64,
	CSS_ISTCP = 32,
	CSS_ISIPFRAG = 16,
	CSS_ISIPV6 = 8,
	CSS_IPV4CSUMOK = 4,
	CSS_ISIPV4 = 2,
	CSS_LINK_BIT = 1,
};

enum store_type {
	wr_invalid = 0,
	wr_new_root = 1,
	wr_store_root = 2,
	wr_exact_fit = 3,
	wr_spanning_store = 4,
	wr_split_store = 5,
	wr_rebalance = 6,
	wr_append = 7,
	wr_node_store = 8,
	wr_slot_store = 9,
};

enum stratix10_svc_command_code {
	COMMAND_NOOP = 0,
	COMMAND_RECONFIG = 1,
	COMMAND_RECONFIG_DATA_SUBMIT = 2,
	COMMAND_RECONFIG_DATA_CLAIM = 3,
	COMMAND_RECONFIG_STATUS = 4,
	COMMAND_RSU_STATUS = 10,
	COMMAND_RSU_UPDATE = 11,
	COMMAND_RSU_NOTIFY = 12,
	COMMAND_RSU_RETRY = 13,
	COMMAND_RSU_MAX_RETRY = 14,
	COMMAND_RSU_DCMF_VERSION = 15,
	COMMAND_RSU_DCMF_STATUS = 16,
	COMMAND_FIRMWARE_VERSION = 17,
	COMMAND_FCS_REQUEST_SERVICE = 20,
	COMMAND_FCS_SEND_CERTIFICATE = 21,
	COMMAND_FCS_GET_PROVISION_DATA = 22,
	COMMAND_FCS_DATA_ENCRYPTION = 23,
	COMMAND_FCS_DATA_DECRYPTION = 24,
	COMMAND_FCS_RANDOM_NUMBER_GEN = 25,
	COMMAND_POLL_SERVICE_STATUS = 40,
	COMMAND_MBOX_SEND_CMD = 100,
	COMMAND_SMC_SVC_VERSION = 200,
};

enum streamid_type {
	STREAMID_TYPE_RESERVED = 0,
	STREAMID_TYPE_NULL = 1,
	STREAMID_TYPE_SMAC = 2,
};

enum streamid_vlan_tagged {
	STREAMID_VLAN_RESERVED = 0,
	STREAMID_VLAN_TAGGED = 1,
	STREAMID_VLAN_UNTAGGED = 2,
	STREAMID_VLAN_ALL = 3,
};

enum string_size_units {
	STRING_UNITS_10 = 0,
	STRING_UNITS_2 = 1,
	STRING_UNITS_MASK = 1,
	STRING_UNITS_NO_SPACE = 1073741824,
	STRING_UNITS_NO_BYTES = 2147483648,
};

enum stripetype4 {
	STRIPE_SPARSE = 1,
	STRIPE_DENSE = 2,
};

enum sum_check_flags {
	SUM_CHECK_P_RESULT = 1,
	SUM_CHECK_Q_RESULT = 2,
};

enum sunxi_desc_bias_voltage {
	BIAS_VOLTAGE_NONE = 0,
	BIAS_VOLTAGE_GRP_CONFIG = 1,
	BIAS_VOLTAGE_PIO_POW_MODE_SEL = 2,
	BIAS_VOLTAGE_PIO_POW_MODE_CTL = 3,
};

enum super_iter_flags_t {
	SUPER_ITER_EXCL = 1,
	SUPER_ITER_UNLOCKED = 2,
	SUPER_ITER_REVERSE = 4,
};

enum support_mode {
	ALLOW_LEGACY = 0,
	DENY_LEGACY = 1,
};

enum suspend_stat_step {
	SUSPEND_WORKING = 0,
	SUSPEND_FREEZE = 1,
	SUSPEND_PREPARE = 2,
	SUSPEND_SUSPEND = 3,
	SUSPEND_SUSPEND_LATE = 4,
	SUSPEND_SUSPEND_NOIRQ = 5,
	SUSPEND_RESUME_NOIRQ = 6,
	SUSPEND_RESUME_EARLY = 7,
	SUSPEND_RESUME = 8,
};

enum svc_auth_status {
	SVC_GARBAGE = 1,
	SVC_VALID = 2,
	SVC_NEGATIVE = 3,
	SVC_OK = 4,
	SVC_DROP = 5,
	SVC_CLOSE = 6,
	SVC_DENIED = 7,
	SVC_PENDING = 8,
	SVC_COMPLETE = 9,
};

enum sw_activity {
	OFF___3 = 0,
	BLINK_ON = 1,
	BLINK_OFF = 2,
};

enum swap_cluster_flags {
	CLUSTER_FLAG_NONE = 0,
	CLUSTER_FLAG_FREE = 1,
	CLUSTER_FLAG_NONFULL = 2,
	CLUSTER_FLAG_FRAG = 3,
	CLUSTER_FLAG_USABLE = 3,
	CLUSTER_FLAG_FULL = 4,
	CLUSTER_FLAG_DISCARD = 5,
	CLUSTER_FLAG_MAX = 6,
};

enum switchdev_attr_id {
	SWITCHDEV_ATTR_ID_UNDEFINED = 0,
	SWITCHDEV_ATTR_ID_PORT_STP_STATE = 1,
	SWITCHDEV_ATTR_ID_PORT_MST_STATE = 2,
	SWITCHDEV_ATTR_ID_PORT_BRIDGE_FLAGS = 3,
	SWITCHDEV_ATTR_ID_PORT_PRE_BRIDGE_FLAGS = 4,
	SWITCHDEV_ATTR_ID_PORT_MROUTER = 5,
	SWITCHDEV_ATTR_ID_BRIDGE_AGEING_TIME = 6,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_FILTERING = 7,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_PROTOCOL = 8,
	SWITCHDEV_ATTR_ID_BRIDGE_MC_DISABLED = 9,
	SWITCHDEV_ATTR_ID_BRIDGE_MROUTER = 10,
	SWITCHDEV_ATTR_ID_BRIDGE_MST = 11,
	SWITCHDEV_ATTR_ID_MRP_PORT_ROLE = 12,
	SWITCHDEV_ATTR_ID_VLAN_MSTI = 13,
};

enum switchdev_notifier_type {
	SWITCHDEV_FDB_ADD_TO_BRIDGE = 1,
	SWITCHDEV_FDB_DEL_TO_BRIDGE = 2,
	SWITCHDEV_FDB_ADD_TO_DEVICE = 3,
	SWITCHDEV_FDB_DEL_TO_DEVICE = 4,
	SWITCHDEV_FDB_OFFLOADED = 5,
	SWITCHDEV_FDB_FLUSH_TO_BRIDGE = 6,
	SWITCHDEV_PORT_OBJ_ADD = 7,
	SWITCHDEV_PORT_OBJ_DEL = 8,
	SWITCHDEV_PORT_ATTR_SET = 9,
	SWITCHDEV_VXLAN_FDB_ADD_TO_BRIDGE = 10,
	SWITCHDEV_VXLAN_FDB_DEL_TO_BRIDGE = 11,
	SWITCHDEV_VXLAN_FDB_ADD_TO_DEVICE = 12,
	SWITCHDEV_VXLAN_FDB_DEL_TO_DEVICE = 13,
	SWITCHDEV_VXLAN_FDB_OFFLOADED = 14,
	SWITCHDEV_BRPORT_OFFLOADED = 15,
	SWITCHDEV_BRPORT_UNOFFLOADED = 16,
	SWITCHDEV_BRPORT_REPLAY = 17,
};

enum switchdev_obj_id {
	SWITCHDEV_OBJ_ID_UNDEFINED = 0,
	SWITCHDEV_OBJ_ID_PORT_VLAN = 1,
	SWITCHDEV_OBJ_ID_PORT_MDB = 2,
	SWITCHDEV_OBJ_ID_HOST_MDB = 3,
	SWITCHDEV_OBJ_ID_MRP = 4,
	SWITCHDEV_OBJ_ID_RING_TEST_MRP = 5,
	SWITCHDEV_OBJ_ID_RING_ROLE_MRP = 6,
	SWITCHDEV_OBJ_ID_RING_STATE_MRP = 7,
	SWITCHDEV_OBJ_ID_IN_TEST_MRP = 8,
	SWITCHDEV_OBJ_ID_IN_ROLE_MRP = 9,
	SWITCHDEV_OBJ_ID_IN_STATE_MRP = 10,
};

enum swxilim_bits {
	SWXILIM_2100_MA = 0,
	SWXILIM_2600_MA = 1,
	SWXILIM_3000_MA = 2,
	SWXILIM_4500_MA = 3,
};

enum sys_off_mode {
	SYS_OFF_MODE_POWER_OFF_PREPARE = 0,
	SYS_OFF_MODE_POWER_OFF = 1,
	SYS_OFF_MODE_RESTART_PREPARE = 2,
	SYS_OFF_MODE_RESTART = 3,
};

enum sys_powerdown {
	SYS_AFTR = 0,
	SYS_LPA = 1,
	SYS_SLEEP = 2,
	NUM_SYS_POWERDOWN = 3,
};

enum sysc_clocks {
	SYSC_FCK = 0,
	SYSC_ICK = 1,
	SYSC_OPTFCK0 = 2,
	SYSC_OPTFCK1 = 3,
	SYSC_OPTFCK2 = 4,
	SYSC_OPTFCK3 = 5,
	SYSC_OPTFCK4 = 6,
	SYSC_OPTFCK5 = 7,
	SYSC_OPTFCK6 = 8,
	SYSC_OPTFCK7 = 9,
	SYSC_MAX_CLOCKS = 10,
};

enum sysc_registers {
	SYSC_REVISION = 0,
	SYSC_SYSCONFIG = 1,
	SYSC_SYSSTATUS = 2,
	SYSC_MAX_REGS = 3,
};

enum sysc_soc {
	SOC_UNKNOWN = 0,
	SOC_2420 = 1,
	SOC_2430 = 2,
	SOC_3430 = 3,
	SOC_AM35 = 4,
	SOC_3630 = 5,
	SOC_4430 = 6,
	SOC_4460 = 7,
	SOC_4470 = 8,
	SOC_5430 = 9,
	SOC_AM3 = 10,
	SOC_AM4 = 11,
	SOC_DRA7 = 12,
};

enum sysctl_writes_mode {
	SYSCTL_WRITES_LEGACY = -1,
	SYSCTL_WRITES_WARN = 0,
	SYSCTL_WRITES_STRICT = 1,
};

enum system_states {
	SYSTEM_BOOTING = 0,
	SYSTEM_SCHEDULING = 1,
	SYSTEM_FREEING_INITMEM = 2,
	SYSTEM_RUNNING = 3,
	SYSTEM_HALT = 4,
	SYSTEM_POWER_OFF = 5,
	SYSTEM_RESTART = 6,
	SYSTEM_SUSPEND = 7,
};

enum t10_dif_type {
	T10_PI_TYPE0_PROTECTION = 0,
	T10_PI_TYPE1_PROTECTION = 1,
	T10_PI_TYPE2_PROTECTION = 2,
	T10_PI_TYPE3_PROTECTION = 3,
};

enum ta_cmd {
	TA_CMD_BNXT_FASTBOOT = 0,
	TA_CMD_BNXT_COPY_COREDUMP = 3,
};

enum tap_delay_type {
	PM_TAPDELAY_INPUT = 0,
	PM_TAPDELAY_OUTPUT = 1,
};

enum task_attribute {
	TASK_ATTR_SIMPLE = 0,
	TASK_ATTR_HOQ = 1,
	TASK_ATTR_ORDERED = 2,
	TASK_ATTR_ACA = 4,
};

enum task_disposition {
	TASK_IS_DONE = 0,
	TASK_IS_ABORTED = 1,
	TASK_IS_AT_LU = 2,
	TASK_IS_NOT_AT_LU = 3,
	TASK_ABORT_FAILED = 4,
};

enum task_work_notify_mode {
	TWA_NONE = 0,
	TWA_RESUME = 1,
	TWA_SIGNAL = 2,
	TWA_SIGNAL_NO_IPI = 3,
	TWA_NMI_CURRENT = 4,
};

enum tc_fifo_command {
	TC_FIFO_REPLACE = 0,
	TC_FIFO_DESTROY = 1,
	TC_FIFO_STATS = 2,
};

enum tc_link_layer {
	TC_LINKLAYER_UNAWARE = 0,
	TC_LINKLAYER_ETHERNET = 1,
	TC_LINKLAYER_ATM = 2,
};

enum tc_mq_command {
	TC_MQ_CREATE = 0,
	TC_MQ_DESTROY = 1,
	TC_MQ_STATS = 2,
	TC_MQ_GRAFT = 3,
};

enum tc_root_command {
	TC_ROOT_GRAFT = 0,
};

enum tc_setup_type {
	TC_QUERY_CAPS = 0,
	TC_SETUP_QDISC_MQPRIO = 1,
	TC_SETUP_CLSU32 = 2,
	TC_SETUP_CLSFLOWER = 3,
	TC_SETUP_CLSMATCHALL = 4,
	TC_SETUP_CLSBPF = 5,
	TC_SETUP_BLOCK = 6,
	TC_SETUP_QDISC_CBS = 7,
	TC_SETUP_QDISC_RED = 8,
	TC_SETUP_QDISC_PRIO = 9,
	TC_SETUP_QDISC_MQ = 10,
	TC_SETUP_QDISC_ETF = 11,
	TC_SETUP_ROOT_QDISC = 12,
	TC_SETUP_QDISC_GRED = 13,
	TC_SETUP_QDISC_TAPRIO = 14,
	TC_SETUP_FT = 15,
	TC_SETUP_QDISC_ETS = 16,
	TC_SETUP_QDISC_TBF = 17,
	TC_SETUP_QDISC_FIFO = 18,
	TC_SETUP_QDISC_HTB = 19,
	TC_SETUP_ACT = 20,
};

enum tc_taprio_qopt_cmd {
	TAPRIO_CMD_REPLACE = 0,
	TAPRIO_CMD_DESTROY = 1,
	TAPRIO_CMD_STATS = 2,
	TAPRIO_CMD_QUEUE_STATS = 3,
};

enum tc_tbf_command {
	TC_TBF_REPLACE = 0,
	TC_TBF_DESTROY = 1,
	TC_TBF_STATS = 2,
	TC_TBF_GRAFT = 3,
};

enum tca_id {
	TCA_ID_UNSPEC = 0,
	TCA_ID_POLICE = 1,
	TCA_ID_GACT = 5,
	TCA_ID_IPT = 6,
	TCA_ID_PEDIT = 7,
	TCA_ID_MIRRED = 8,
	TCA_ID_NAT = 9,
	TCA_ID_XT = 10,
	TCA_ID_SKBEDIT = 11,
	TCA_ID_VLAN = 12,
	TCA_ID_BPF = 13,
	TCA_ID_CONNMARK = 14,
	TCA_ID_SKBMOD = 15,
	TCA_ID_CSUM = 16,
	TCA_ID_TUNNEL_KEY = 17,
	TCA_ID_SIMP = 22,
	TCA_ID_IFE = 25,
	TCA_ID_SAMPLE = 26,
	TCA_ID_CTINFO = 27,
	TCA_ID_MPLS = 28,
	TCA_ID_CT = 29,
	TCA_ID_GATE = 30,
	__TCA_ID_MAX = 255,
};

enum tcf_proto_ops_flags {
	TCF_PROTO_OPS_DOIT_UNLOCKED = 1,
};

enum tcp_accecn_option {
	TCP_ACCECN_OPTION_DISABLED = 0,
	TCP_ACCECN_OPTION_MINIMUM = 1,
	TCP_ACCECN_OPTION_FULL = 2,
};

enum tcp_ca_ack_event_flags {
	CA_ACK_SLOWPATH = 1,
	CA_ACK_WIN_UPDATE = 2,
	CA_ACK_ECE = 4,
};

enum tcp_ca_event {
	CA_EVENT_TX_START = 0,
	CA_EVENT_CWND_RESTART = 1,
	CA_EVENT_COMPLETE_CWR = 2,
	CA_EVENT_LOSS = 3,
	CA_EVENT_ECN_NO_CE = 4,
	CA_EVENT_ECN_IS_CE = 5,
};

enum tcp_ca_state {
	TCP_CA_Open = 0,
	TCP_CA_Disorder = 1,
	TCP_CA_CWR = 2,
	TCP_CA_Recovery = 3,
	TCP_CA_Loss = 4,
};

enum tcp_chrono {
	TCP_CHRONO_UNSPEC = 0,
	TCP_CHRONO_BUSY = 1,
	TCP_CHRONO_RWND_LIMITED = 2,
	TCP_CHRONO_SNDBUF_LIMITED = 3,
	__TCP_CHRONO_MAX = 4,
};

enum tcp_ecn_mode {
	TCP_ECN_IN_NOECN_OUT_NOECN = 0,
	TCP_ECN_IN_ECN_OUT_ECN = 1,
	TCP_ECN_IN_ECN_OUT_NOECN = 2,
	TCP_ECN_IN_ACCECN_OUT_ACCECN = 3,
	TCP_ECN_IN_ACCECN_OUT_ECN = 4,
	TCP_ECN_IN_ACCECN_OUT_NOECN = 5,
};

enum tcp_fastopen_client_fail {
	TFO_STATUS_UNSPEC = 0,
	TFO_COOKIE_UNAVAILABLE = 1,
	TFO_DATA_NOT_ACKED = 2,
	TFO_SYN_RETRANSMITTED = 3,
};

enum tcp_metric_index {
	TCP_METRIC_RTT = 0,
	TCP_METRIC_RTTVAR = 1,
	TCP_METRIC_SSTHRESH = 2,
	TCP_METRIC_CWND = 3,
	TCP_METRIC_REORDERING = 4,
	TCP_METRIC_RTT_US = 5,
	TCP_METRIC_RTTVAR_US = 6,
	__TCP_METRIC_MAX = 7,
};

enum tcp_queue {
	TCP_FRAG_IN_WRITE_QUEUE = 0,
	TCP_FRAG_IN_RTX_QUEUE = 1,
};

enum tcp_seq_states {
	TCP_SEQ_STATE_LISTENING = 0,
	TCP_SEQ_STATE_ESTABLISHED = 1,
};

enum tcp_skb_cb_sacked_flags {
	TCPCB_SACKED_ACKED = 1,
	TCPCB_SACKED_RETRANS = 2,
	TCPCB_LOST = 4,
	TCPCB_TAGBITS = 7,
	TCPCB_REPAIRED = 16,
	TCPCB_EVER_RETRANS = 128,
	TCPCB_RETRANS = 146,
};

enum tcp_synack_type {
	TCP_SYNACK_NORMAL = 0,
	TCP_SYNACK_FASTOPEN = 1,
	TCP_SYNACK_COOKIE = 2,
};

enum tcp_tw_status {
	TCP_TW_SUCCESS = 0,
	TCP_TW_RST = 1,
	TCP_TW_ACK = 2,
	TCP_TW_SYN = 3,
	TCP_TW_ACK_OOW = 4,
};

enum tcpa_event_types {
	PREBOOT = 0,
	POST_CODE = 1,
	UNUSED = 2,
	NO_ACTION = 3,
	SEPARATOR = 4,
	ACTION = 5,
	EVENT_TAG = 6,
	SCRTM_CONTENTS = 7,
	SCRTM_VERSION = 8,
	CPU_MICROCODE = 9,
	PLATFORM_CONFIG_FLAGS = 10,
	TABLE_OF_DEVICES = 11,
	COMPACT_HASH = 12,
	IPL = 13,
	IPL_PARTITION_DATA = 14,
	NONHOST_CODE = 15,
	NONHOST_CONFIG = 16,
	NONHOST_INFO = 17,
};

enum tcpa_pc_event_ids {
	SMBIOS = 1,
	BIS_CERT = 2,
	POST_BIOS_ROM = 3,
	ESCD = 4,
	CMOS = 5,
	NVRAM = 6,
	OPTION_ROM_EXEC = 7,
	OPTION_ROM_CONFIG = 8,
	OPTION_ROM_MICROCODE = 10,
	S_CRTM_VERSION = 11,
	S_CRTM_CONTENTS = 12,
	POST_CONTENTS = 13,
	HOST_TABLE_OF_DEVICES = 14,
};

enum tcx_action_base {
	TCX_NEXT = -1,
	TCX_PASS = 0,
	TCX_DROP = 2,
	TCX_REDIRECT = 7,
};

enum tee_dma_heap_id {
	TEE_DMA_HEAP_SECURE_VIDEO_PLAY = 1,
	TEE_DMA_HEAP_TRUSTED_UI = 2,
	TEE_DMA_HEAP_SECURE_VIDEO_RECORD = 3,
};

enum tegra264_cbb_fabric_ids {
	T264_SYSTEM_CBB_FABRIC_ID = 0,
	T264_TOP_0_CBB_FABRIC_ID = 1,
	T264_VISION_CBB_FABRIC_ID = 2,
	T264_DISP_USB_CBB_FABRIC_ID = 3,
	T264_UPHY0_CBB_FABRIC_ID = 4,
	T264_RSVD0_FABRIC_ID = 5,
	T264_RSVD1_FABRIC_ID = 6,
	T264_RSVD2_FABRIC_ID = 7,
	T264_RSVD3_FABRIC_ID = 8,
	T264_RSVD4_FABRIC_ID = 9,
	T264_RSVD5_FABRIC_ID = 10,
	T264_AON_FABRIC_ID = 11,
	T264_PSC_FABRIC_ID = 12,
	T264_OESP_FABRIC_ID = 13,
	T264_APE_FABRIC_ID = 14,
	T264_BPMP_FABRIC_ID = 15,
	T264_RCE_0_FABRIC_ID = 16,
	T264_RCE_1_FABRIC_ID = 17,
	T264_RSVD6_FABRIC_ID = 18,
	T264_DCE_FABRIC_ID = 19,
	T264_FSI_FABRIC_ID = 20,
	T264_ISC_FABRIC_ID = 21,
	T264_SB_FABRIC_ID = 22,
	T264_ISC_CPU_FABRIC_ID = 23,
	T264_RSVD7_FABRIC_ID = 24,
};

enum tegra_dfll_pmu_if {
	TEGRA_DFLL_PMU_I2C = 0,
	TEGRA_DFLL_PMU_PWM = 1,
};

enum tegra_hte_type {
	HTE_TEGRA_TYPE_GPIO = 1,
	HTE_TEGRA_TYPE_LIC = 2,
};

enum tegra_icc_client_type {
	TEGRA_ICC_NONE = 0,
	TEGRA_ICC_NISO = 1,
	TEGRA_ICC_ISO_DISPLAY = 2,
	TEGRA_ICC_ISO_VI = 3,
	TEGRA_ICC_ISO_AUDIO = 4,
	TEGRA_ICC_ISO_VIFAL = 5,
};

enum tegra_io_pad {
	TEGRA_IO_PAD_AUDIO = 0,
	TEGRA_IO_PAD_AUDIO_HV = 1,
	TEGRA_IO_PAD_BB = 2,
	TEGRA_IO_PAD_CAM = 3,
	TEGRA_IO_PAD_COMP = 4,
	TEGRA_IO_PAD_CONN = 5,
	TEGRA_IO_PAD_CSIA = 6,
	TEGRA_IO_PAD_CSIB = 7,
	TEGRA_IO_PAD_CSIC = 8,
	TEGRA_IO_PAD_CSID = 9,
	TEGRA_IO_PAD_CSIE = 10,
	TEGRA_IO_PAD_CSIF = 11,
	TEGRA_IO_PAD_CSIG = 12,
	TEGRA_IO_PAD_CSIH = 13,
	TEGRA_IO_PAD_DAP3 = 14,
	TEGRA_IO_PAD_DAP5 = 15,
	TEGRA_IO_PAD_DBG = 16,
	TEGRA_IO_PAD_DEBUG_NONAO = 17,
	TEGRA_IO_PAD_DMIC = 18,
	TEGRA_IO_PAD_DMIC_HV = 19,
	TEGRA_IO_PAD_DP = 20,
	TEGRA_IO_PAD_DSI = 21,
	TEGRA_IO_PAD_DSIB = 22,
	TEGRA_IO_PAD_DSIC = 23,
	TEGRA_IO_PAD_DSID = 24,
	TEGRA_IO_PAD_EDP = 25,
	TEGRA_IO_PAD_EMMC = 26,
	TEGRA_IO_PAD_EMMC2 = 27,
	TEGRA_IO_PAD_EQOS = 28,
	TEGRA_IO_PAD_GPIO = 29,
	TEGRA_IO_PAD_GP_PWM2 = 30,
	TEGRA_IO_PAD_GP_PWM3 = 31,
	TEGRA_IO_PAD_HDMI = 32,
	TEGRA_IO_PAD_HDMI_DP0 = 33,
	TEGRA_IO_PAD_HDMI_DP1 = 34,
	TEGRA_IO_PAD_HDMI_DP2 = 35,
	TEGRA_IO_PAD_HDMI_DP3 = 36,
	TEGRA_IO_PAD_HSIC = 37,
	TEGRA_IO_PAD_HV = 38,
	TEGRA_IO_PAD_LVDS = 39,
	TEGRA_IO_PAD_MIPI_BIAS = 40,
	TEGRA_IO_PAD_NAND = 41,
	TEGRA_IO_PAD_PEX_BIAS = 42,
	TEGRA_IO_PAD_PEX_CLK_BIAS = 43,
	TEGRA_IO_PAD_PEX_CLK1 = 44,
	TEGRA_IO_PAD_PEX_CLK2 = 45,
	TEGRA_IO_PAD_PEX_CLK3 = 46,
	TEGRA_IO_PAD_PEX_CLK_2_BIAS = 47,
	TEGRA_IO_PAD_PEX_CLK_2 = 48,
	TEGRA_IO_PAD_PEX_CNTRL = 49,
	TEGRA_IO_PAD_PEX_CTL2 = 50,
	TEGRA_IO_PAD_PEX_L0_RST = 51,
	TEGRA_IO_PAD_PEX_L1_RST = 52,
	TEGRA_IO_PAD_PEX_L5_RST = 53,
	TEGRA_IO_PAD_PWR_CTL = 54,
	TEGRA_IO_PAD_SDMMC1 = 55,
	TEGRA_IO_PAD_SDMMC1_HV = 56,
	TEGRA_IO_PAD_SDMMC2 = 57,
	TEGRA_IO_PAD_SDMMC2_HV = 58,
	TEGRA_IO_PAD_SDMMC3 = 59,
	TEGRA_IO_PAD_SDMMC3_HV = 60,
	TEGRA_IO_PAD_SDMMC4 = 61,
	TEGRA_IO_PAD_SOC_GPIO10 = 62,
	TEGRA_IO_PAD_SOC_GPIO12 = 63,
	TEGRA_IO_PAD_SOC_GPIO13 = 64,
	TEGRA_IO_PAD_SOC_GPIO53 = 65,
	TEGRA_IO_PAD_SPI = 66,
	TEGRA_IO_PAD_SPI_HV = 67,
	TEGRA_IO_PAD_SYS_DDC = 68,
	TEGRA_IO_PAD_UART = 69,
	TEGRA_IO_PAD_UART4 = 70,
	TEGRA_IO_PAD_UART5 = 71,
	TEGRA_IO_PAD_UFS = 72,
	TEGRA_IO_PAD_USB0 = 73,
	TEGRA_IO_PAD_USB1 = 74,
	TEGRA_IO_PAD_USB2 = 75,
	TEGRA_IO_PAD_USB3 = 76,
	TEGRA_IO_PAD_USB_BIAS = 77,
	TEGRA_IO_PAD_AO_HV = 78,
};

enum tegra_ivc_state {
	TEGRA_IVC_STATE_ESTABLISHED = 0,
	TEGRA_IVC_STATE_SYNC = 1,
	TEGRA_IVC_STATE_ACK = 2,
};

enum tegra_pinconf_param {
	TEGRA_PINCONF_PARAM_PULL = 0,
	TEGRA_PINCONF_PARAM_TRISTATE = 1,
	TEGRA_PINCONF_PARAM_ENABLE_INPUT = 2,
	TEGRA_PINCONF_PARAM_OPEN_DRAIN = 3,
	TEGRA_PINCONF_PARAM_LOCK = 4,
	TEGRA_PINCONF_PARAM_IORESET = 5,
	TEGRA_PINCONF_PARAM_RCV_SEL = 6,
	TEGRA_PINCONF_PARAM_HIGH_SPEED_MODE = 7,
	TEGRA_PINCONF_PARAM_SCHMITT = 8,
	TEGRA_PINCONF_PARAM_LOW_POWER_MODE = 9,
	TEGRA_PINCONF_PARAM_DRIVE_DOWN_STRENGTH = 10,
	TEGRA_PINCONF_PARAM_DRIVE_UP_STRENGTH = 11,
	TEGRA_PINCONF_PARAM_SLEW_RATE_FALLING = 12,
	TEGRA_PINCONF_PARAM_SLEW_RATE_RISING = 13,
	TEGRA_PINCONF_PARAM_DRIVE_TYPE = 14,
	TEGRA_PINCONF_PARAM_GPIO_MODE = 15,
};

enum tegra_platform {
	TEGRA_PLATFORM_SILICON = 0,
	TEGRA_PLATFORM_QT = 1,
	TEGRA_PLATFORM_SYSTEM_FPGA = 2,
	TEGRA_PLATFORM_UNIT_FPGA = 3,
	TEGRA_PLATFORM_ASIM_QT = 4,
	TEGRA_PLATFORM_ASIM_LINSIM = 5,
	TEGRA_PLATFORM_DSIM_ASIM_LINSIM = 6,
	TEGRA_PLATFORM_VERIFICATION_SIMULATION = 7,
	TEGRA_PLATFORM_VDK = 8,
	TEGRA_PLATFORM_VSP = 9,
	TEGRA_PLATFORM_MAX = 10,
};

enum tegra_revision {
	TEGRA_REVISION_UNKNOWN = 0,
	TEGRA_REVISION_A01 = 1,
	TEGRA_REVISION_A02 = 2,
	TEGRA_REVISION_A03 = 3,
	TEGRA_REVISION_A03p = 4,
	TEGRA_REVISION_A04 = 5,
	TEGRA_REVISION_MAX = 6,
};

enum tegra_super_gen {
	gen4 = 4,
	gen5 = 5,
};

enum tegra_suspend_mode {
	TEGRA_SUSPEND_NONE = 0,
	TEGRA_SUSPEND_LP2 = 1,
	TEGRA_SUSPEND_LP1 = 2,
	TEGRA_SUSPEND_LP0 = 3,
	TEGRA_MAX_SUSPEND_MODE = 4,
	TEGRA_SUSPEND_NOT_READY = 5,
};

enum tegra_xusb_mbox_cmd {
	MBOX_CMD_MSG_ENABLED = 1,
	MBOX_CMD_INC_FALC_CLOCK = 2,
	MBOX_CMD_DEC_FALC_CLOCK = 3,
	MBOX_CMD_INC_SSPI_CLOCK = 4,
	MBOX_CMD_DEC_SSPI_CLOCK = 5,
	MBOX_CMD_SET_BW = 6,
	MBOX_CMD_SET_SS_PWR_GATING = 7,
	MBOX_CMD_SET_SS_PWR_UNGATING = 8,
	MBOX_CMD_SAVE_DFE_CTLE_CTX = 9,
	MBOX_CMD_AIRPLANE_MODE_ENABLED = 10,
	MBOX_CMD_AIRPLANE_MODE_DISABLED = 11,
	MBOX_CMD_START_HSIC_IDLE = 12,
	MBOX_CMD_STOP_HSIC_IDLE = 13,
	MBOX_CMD_DBC_WAKE_STACK = 14,
	MBOX_CMD_HSIC_PRETEND_CONNECT = 15,
	MBOX_CMD_RESET_SSPI = 16,
	MBOX_CMD_DISABLE_SS_LFPS_DETECTION = 17,
	MBOX_CMD_ENABLE_SS_LFPS_DETECTION = 18,
	MBOX_CMD_MAX = 19,
	MBOX_CMD_ACK = 128,
	MBOX_CMD_NAK = 129,
};

enum tegra_xusb_padctl_param {
	TEGRA_XUSB_PADCTL_IDDQ = 0,
};

enum thermal_device_mode {
	THERMAL_DEVICE_DISABLED = 0,
	THERMAL_DEVICE_ENABLED = 1,
};

enum thermal_genl_attr {
	THERMAL_GENL_ATTR_UNSPEC = 0,
	THERMAL_GENL_ATTR_TZ = 1,
	THERMAL_GENL_ATTR_TZ_ID = 2,
	THERMAL_GENL_ATTR_TZ_TEMP = 3,
	THERMAL_GENL_ATTR_TZ_TRIP = 4,
	THERMAL_GENL_ATTR_TZ_TRIP_ID = 5,
	THERMAL_GENL_ATTR_TZ_TRIP_TYPE = 6,
	THERMAL_GENL_ATTR_TZ_TRIP_TEMP = 7,
	THERMAL_GENL_ATTR_TZ_TRIP_HYST = 8,
	THERMAL_GENL_ATTR_TZ_MODE = 9,
	THERMAL_GENL_ATTR_TZ_NAME = 10,
	THERMAL_GENL_ATTR_TZ_CDEV_WEIGHT = 11,
	THERMAL_GENL_ATTR_TZ_GOV = 12,
	THERMAL_GENL_ATTR_TZ_GOV_NAME = 13,
	THERMAL_GENL_ATTR_CDEV = 14,
	THERMAL_GENL_ATTR_CDEV_ID = 15,
	THERMAL_GENL_ATTR_CDEV_CUR_STATE = 16,
	THERMAL_GENL_ATTR_CDEV_MAX_STATE = 17,
	THERMAL_GENL_ATTR_CDEV_NAME = 18,
	THERMAL_GENL_ATTR_GOV_NAME = 19,
	THERMAL_GENL_ATTR_CPU_CAPABILITY = 20,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_ID = 21,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_PERFORMANCE = 22,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_EFFICIENCY = 23,
	THERMAL_GENL_ATTR_THRESHOLD = 24,
	THERMAL_GENL_ATTR_THRESHOLD_TEMP = 25,
	THERMAL_GENL_ATTR_THRESHOLD_DIRECTION = 26,
	THERMAL_GENL_ATTR_TZ_PREV_TEMP = 27,
	__THERMAL_GENL_ATTR_MAX = 28,
};

enum thermal_genl_event {
	THERMAL_GENL_EVENT_UNSPEC = 0,
	THERMAL_GENL_EVENT_TZ_CREATE = 1,
	THERMAL_GENL_EVENT_TZ_DELETE = 2,
	THERMAL_GENL_EVENT_TZ_DISABLE = 3,
	THERMAL_GENL_EVENT_TZ_ENABLE = 4,
	THERMAL_GENL_EVENT_TZ_TRIP_UP = 5,
	THERMAL_GENL_EVENT_TZ_TRIP_DOWN = 6,
	THERMAL_GENL_EVENT_TZ_TRIP_CHANGE = 7,
	THERMAL_GENL_EVENT_TZ_TRIP_ADD = 8,
	THERMAL_GENL_EVENT_TZ_TRIP_DELETE = 9,
	THERMAL_GENL_EVENT_CDEV_ADD = 10,
	THERMAL_GENL_EVENT_CDEV_DELETE = 11,
	THERMAL_GENL_EVENT_CDEV_STATE_UPDATE = 12,
	THERMAL_GENL_EVENT_TZ_GOV_CHANGE = 13,
	THERMAL_GENL_EVENT_CPU_CAPABILITY_CHANGE = 14,
	THERMAL_GENL_EVENT_THRESHOLD_ADD = 15,
	THERMAL_GENL_EVENT_THRESHOLD_DELETE = 16,
	THERMAL_GENL_EVENT_THRESHOLD_FLUSH = 17,
	THERMAL_GENL_EVENT_THRESHOLD_UP = 18,
	THERMAL_GENL_EVENT_THRESHOLD_DOWN = 19,
	__THERMAL_GENL_EVENT_MAX = 20,
};

enum thermal_genl_multicast_groups {
	THERMAL_GENL_SAMPLING_GROUP = 0,
	THERMAL_GENL_EVENT_GROUP = 1,
	THERMAL_GENL_MAX_GROUP = 1,
};

enum thermal_genl_sampling {
	THERMAL_GENL_SAMPLING_TEMP = 0,
	__THERMAL_GENL_SAMPLING_MAX = 1,
};

enum thermal_notify_event {
	THERMAL_EVENT_UNSPECIFIED = 0,
	THERMAL_EVENT_TEMP_SAMPLE = 1,
	THERMAL_TRIP_VIOLATED = 2,
	THERMAL_TRIP_CHANGED = 3,
	THERMAL_DEVICE_DOWN = 4,
	THERMAL_DEVICE_UP = 5,
	THERMAL_DEVICE_POWER_CAPABILITY_CHANGED = 6,
	THERMAL_TABLE_CHANGED = 7,
	THERMAL_EVENT_KEEP_ALIVE = 8,
	THERMAL_TZ_BIND_CDEV = 9,
	THERMAL_TZ_UNBIND_CDEV = 10,
	THERMAL_INSTANCE_WEIGHT_CHANGED = 11,
	THERMAL_TZ_RESUME = 12,
	THERMAL_TZ_ADD_THRESHOLD = 13,
	THERMAL_TZ_DEL_THRESHOLD = 14,
	THERMAL_TZ_FLUSH_THRESHOLDS = 15,
};

enum thermal_trend {
	THERMAL_TREND_STABLE = 0,
	THERMAL_TREND_RAISING = 1,
	THERMAL_TREND_DROPPING = 2,
};

enum thermal_trip_type {
	THERMAL_TRIP_ACTIVE = 0,
	THERMAL_TRIP_PASSIVE = 1,
	THERMAL_TRIP_HOT = 2,
	THERMAL_TRIP_CRITICAL = 3,
};

enum ti_sysc_module_type {
	TI_SYSC_OMAP2 = 0,
	TI_SYSC_OMAP2_TIMER = 1,
	TI_SYSC_OMAP3_SHAM = 2,
	TI_SYSC_OMAP3_AES = 3,
	TI_SYSC_OMAP4 = 4,
	TI_SYSC_OMAP4_TIMER = 5,
	TI_SYSC_OMAP4_SIMPLE = 6,
	TI_SYSC_OMAP34XX_SR = 7,
	TI_SYSC_OMAP36XX_SR = 8,
	TI_SYSC_OMAP4_SR = 9,
	TI_SYSC_OMAP4_MCASP = 10,
	TI_SYSC_OMAP4_USB_HOST_FS = 11,
	TI_SYSC_DRA7_MCAN = 12,
	TI_SYSC_PRUSS = 13,
};

enum tick_broadcast_mode {
	TICK_BROADCAST_OFF = 0,
	TICK_BROADCAST_ON = 1,
	TICK_BROADCAST_FORCE = 2,
};

enum tick_broadcast_state {
	TICK_BROADCAST_EXIT = 0,
	TICK_BROADCAST_ENTER = 1,
};

enum tick_dep_bits {
	TICK_DEP_BIT_POSIX_TIMER = 0,
	TICK_DEP_BIT_PERF_EVENTS = 1,
	TICK_DEP_BIT_SCHED = 2,
	TICK_DEP_BIT_CLOCK_UNSTABLE = 3,
	TICK_DEP_BIT_RCU = 4,
	TICK_DEP_BIT_RCU_EXP = 5,
};

enum tick_device_mode {
	TICKDEV_MODE_PERIODIC = 0,
	TICKDEV_MODE_ONESHOT = 1,
};

enum timekeeper_ids {
	TIMEKEEPER_CORE = 0,
	TIMEKEEPERS_MAX = 1,
};

enum timekeeping_adv_mode {
	TK_ADV_TICK = 0,
	TK_ADV_FREQ = 1,
};

enum timespec_type {
	TT_NONE = 0,
	TT_NATIVE = 1,
	TT_COMPAT = 2,
};

enum tis_access {
	TPM_ACCESS_VALID = 128,
	TPM_ACCESS_ACTIVE_LOCALITY = 32,
	TPM_ACCESS_REQUEST_PENDING = 4,
	TPM_ACCESS_REQUEST_USE = 2,
};

enum tis_defaults {
	TIS_SHORT_TIMEOUT = 750,
	TIS_LONG_TIMEOUT = 2000,
};

enum tis_status {
	TPM_STS_VALID = 128,
	TPM_STS_COMMAND_READY = 64,
	TPM_STS_GO = 32,
	TPM_STS_DATA_AVAIL = 16,
	TPM_STS_DATA_EXPECT = 8,
};

enum tk_offsets {
	TK_OFFS_REAL = 0,
	TK_OFFS_BOOT = 1,
	TK_OFFS_TAI = 2,
	TK_OFFS_MAX = 3,
};

enum topology_type {
	TYPE_INVALID = 0,
	TYPE_MUX = 1,
	TYPE_PLL = 2,
	TYPE_FIXEDFACTOR = 3,
	TYPE_DIV1 = 4,
	TYPE_DIV2 = 5,
	TYPE_GATE = 6,
};

enum tp_type {
	TYPE1 = 0,
	TYPE2 = 1,
	TYPE3 = 2,
	TYPE4 = 3,
};

enum tpacket_versions {
	TPACKET_V1 = 0,
	TPACKET_V2 = 1,
	TPACKET_V3 = 2,
};

enum tph_mem_type {
	TPH_MEM_TYPE_VM = 0,
	TPH_MEM_TYPE_PM = 1,
};

enum tpm2_capabilities {
	TPM2_CAP_HANDLES = 1,
	TPM2_CAP_COMMANDS = 2,
	TPM2_CAP_PCRS = 5,
	TPM2_CAP_TPM_PROPERTIES = 6,
};

enum tpm2_cc_attrs {
	TPM2_CC_ATTR_CHANDLES = 25,
	TPM2_CC_ATTR_RHANDLE = 28,
	TPM2_CC_ATTR_VENDOR = 29,
};

enum tpm2_command_codes {
	TPM2_CC_FIRST = 287,
	TPM2_CC_HIERARCHY_CONTROL = 289,
	TPM2_CC_HIERARCHY_CHANGE_AUTH = 297,
	TPM2_CC_CREATE_PRIMARY = 305,
	TPM2_CC_SEQUENCE_COMPLETE = 318,
	TPM2_CC_SELF_TEST = 323,
	TPM2_CC_STARTUP = 324,
	TPM2_CC_SHUTDOWN = 325,
	TPM2_CC_NV_READ = 334,
	TPM2_CC_CREATE = 339,
	TPM2_CC_LOAD = 343,
	TPM2_CC_SEQUENCE_UPDATE = 348,
	TPM2_CC_UNSEAL = 350,
	TPM2_CC_CONTEXT_LOAD = 353,
	TPM2_CC_CONTEXT_SAVE = 354,
	TPM2_CC_FLUSH_CONTEXT = 357,
	TPM2_CC_READ_PUBLIC = 371,
	TPM2_CC_START_AUTH_SESS = 374,
	TPM2_CC_VERIFY_SIGNATURE = 375,
	TPM2_CC_GET_CAPABILITY = 378,
	TPM2_CC_GET_RANDOM = 379,
	TPM2_CC_PCR_READ = 382,
	TPM2_CC_PCR_EXTEND = 386,
	TPM2_CC_EVENT_SEQUENCE_COMPLETE = 389,
	TPM2_CC_HASH_SEQUENCE_START = 390,
	TPM2_CC_CREATE_LOADED = 401,
	TPM2_CC_LAST = 403,
};

enum tpm2_const {
	TPM2_PLATFORM_PCR = 24,
	TPM2_PCR_SELECT_MIN = 3,
};

enum tpm2_durations {
	TPM2_DURATION_SHORT = 20,
	TPM2_DURATION_LONG = 2000,
	TPM2_DURATION_DEFAULT = 120000,
};

enum tpm2_handle_types {
	TPM2_HT_HMAC_SESSION = 33554432,
	TPM2_HT_POLICY_SESSION = 50331648,
	TPM2_HT_TRANSIENT = 2147483648,
};

enum tpm2_permanent_handles {
	TPM2_RH_NULL = 1073741831,
	TPM2_RS_PW = 1073741833,
};

enum tpm2_properties {
	TPM_PT_TOTAL_COMMANDS = 297,
};

enum tpm2_return_codes {
	TPM2_RC_SUCCESS = 0,
	TPM2_RC_HASH = 131,
	TPM2_RC_HANDLE = 139,
	TPM2_RC_INTEGRITY = 159,
	TPM2_RC_INITIALIZE = 256,
	TPM2_RC_FAILURE = 257,
	TPM2_RC_DISABLED = 288,
	TPM2_RC_UPGRADE = 301,
	TPM2_RC_COMMAND_CODE = 323,
	TPM2_RC_TESTING = 2314,
	TPM2_RC_REFERENCE_H0 = 2320,
	TPM2_RC_RETRY = 2338,
	TPM2_RC_SESSION_MEMORY = 2307,
};

enum tpm2_session_attributes {
	TPM2_SA_CONTINUE_SESSION = 1,
	TPM2_SA_AUDIT_EXCLUSIVE = 2,
	TPM2_SA_AUDIT_RESET = 8,
	TPM2_SA_DECRYPT = 32,
	TPM2_SA_ENCRYPT = 64,
	TPM2_SA_AUDIT = 128,
};

enum tpm2_startup_types {
	TPM2_SU_CLEAR = 0,
	TPM2_SU_STATE = 1,
};

enum tpm2_structures {
	TPM2_ST_NO_SESSIONS = 32769,
	TPM2_ST_SESSIONS = 32770,
	TPM2_ST_CREATION = 32801,
};

enum tpm2_timeouts {
	TPM2_TIMEOUT_A = 750,
	TPM2_TIMEOUT_B = 4000,
	TPM2_TIMEOUT_C = 200,
	TPM2_TIMEOUT_D = 30,
};

enum tpm_algorithms {
	TPM_ALG_ERROR = 0,
	TPM_ALG_SHA1 = 4,
	TPM_ALG_AES = 6,
	TPM_ALG_KEYEDHASH = 8,
	TPM_ALG_SHA256 = 11,
	TPM_ALG_SHA384 = 12,
	TPM_ALG_SHA512 = 13,
	TPM_ALG_NULL = 16,
	TPM_ALG_SM3_256 = 18,
	TPM_ALG_ECC = 35,
	TPM_ALG_CFB = 67,
};

enum tpm_buf_flags {
	TPM_BUF_OVERFLOW = 1,
	TPM_BUF_TPM2B = 2,
	TPM_BUF_BOUNDARY_ERROR = 4,
};

enum tpm_capabilities {
	TPM_CAP_FLAG = 4,
	TPM_CAP_PROP = 5,
	TPM_CAP_VERSION_1_1 = 6,
	TPM_CAP_VERSION_1_2 = 26,
};

enum tpm_chip_flags {
	TPM_CHIP_FLAG_BOOTSTRAPPED = 1,
	TPM_CHIP_FLAG_TPM2 = 2,
	TPM_CHIP_FLAG_IRQ = 4,
	TPM_CHIP_FLAG_VIRTUAL = 8,
	TPM_CHIP_FLAG_HAVE_TIMEOUTS = 16,
	TPM_CHIP_FLAG_ALWAYS_POWERED = 32,
	TPM_CHIP_FLAG_FIRMWARE_POWER_MANAGED = 64,
	TPM_CHIP_FLAG_FIRMWARE_UPGRADE = 128,
	TPM_CHIP_FLAG_SUSPENDED = 256,
	TPM_CHIP_FLAG_HWRNG_DISABLED = 512,
	TPM_CHIP_FLAG_DISABLE = 1024,
	TPM_CHIP_FLAG_SYNC = 2048,
};

enum tpm_duration {
	TPM_SHORT = 0,
	TPM_MEDIUM = 1,
	TPM_LONG = 2,
	TPM_LONG_LONG = 3,
	TPM_UNDEFINED = 4,
	TPM_NUM_DURATIONS = 4,
};

enum tpm_sub_capabilities {
	TPM_CAP_PROP_PCR = 257,
	TPM_CAP_PROP_MANUFACTURER = 259,
	TPM_CAP_FLAG_PERM = 264,
	TPM_CAP_FLAG_VOL = 265,
	TPM_CAP_PROP_OWNER = 273,
	TPM_CAP_PROP_TIS_TIMEOUT = 277,
	TPM_CAP_PROP_TIS_DURATION = 288,
};

enum tpm_timeout {
	TPM_TIMEOUT = 5,
	TPM_TIMEOUT_RETRY = 100,
	TPM_TIMEOUT_RANGE_US = 300,
	TPM_TIMEOUT_POLL = 1,
	TPM_TIMEOUT_USECS_MIN = 100,
	TPM_TIMEOUT_USECS_MAX = 500,
};

enum track_item {
	TRACK_ALLOC = 0,
	TRACK_FREE = 1,
};

enum trans_regime {
	TR_EL10 = 0,
	TR_EL20 = 1,
	TR_EL2 = 2,
};

enum translation_map {
	LAT1_MAP = 0,
	GRAF_MAP = 1,
	IBMPC_MAP = 2,
	USER_MAP = 3,
	FIRST_MAP = 0,
	LAST_MAP = 3,
};

enum transparent_hugepage_flag {
	TRANSPARENT_HUGEPAGE_UNSUPPORTED = 0,
	TRANSPARENT_HUGEPAGE_FLAG = 1,
	TRANSPARENT_HUGEPAGE_REQ_MADV_FLAG = 2,
	TRANSPARENT_HUGEPAGE_DEFRAG_DIRECT_FLAG = 3,
	TRANSPARENT_HUGEPAGE_DEFRAG_KSWAPD_FLAG = 4,
	TRANSPARENT_HUGEPAGE_DEFRAG_KSWAPD_OR_MADV_FLAG = 5,
	TRANSPARENT_HUGEPAGE_DEFRAG_REQ_MADV_FLAG = 6,
	TRANSPARENT_HUGEPAGE_DEFRAG_KHUGEPAGED_FLAG = 7,
	TRANSPARENT_HUGEPAGE_USE_ZERO_PAGE_FLAG = 8,
};

enum trap_behaviour {
	BEHAVE_HANDLE_LOCALLY = 0,
	BEHAVE_FORWARD_READ = 1,
	BEHAVE_FORWARD_WRITE = 2,
	BEHAVE_FORWARD_RW = 3,
	BEHAVE_FORWARD_IN_HOST_EL0 = 4,
};

enum tre_type {
	HIDMA_TRE_MEMCPY = 3,
	HIDMA_TRE_MEMSET = 4,
};

enum tsens_irq_type {
	LOWER = 0,
	UPPER = 1,
	CRITICAL = 2,
};

enum tsens_ver {
	VER_0 = 0,
	VER_0_1 = 1,
	VER_1_X = 2,
	VER_1_X_NO_RPM = 3,
	VER_2_X = 4,
	VER_2_X_NO_RPM = 5,
};

enum tsq_enum {
	TSQ_THROTTLED = 0,
	TSQ_QUEUED = 1,
	TCP_TSQ_DEFERRED = 2,
	TCP_WRITE_TIMER_DEFERRED = 3,
	TCP_DELACK_TIMER_DEFERRED = 4,
	TCP_MTU_REDUCED_DEFERRED = 5,
	TCP_ACK_DEFERRED = 6,
};

enum tsq_flags {
	TSQF_THROTTLED = 1,
	TSQF_QUEUED = 2,
	TCPF_TSQ_DEFERRED = 4,
	TCPF_WRITE_TIMER_DEFERRED = 8,
	TCPF_DELACK_TIMER_DEFERRED = 16,
	TCPF_MTU_REDUCED_DEFERRED = 32,
	TCPF_ACK_DEFERRED = 64,
};

enum ttu_flags {
	TTU_SPLIT_HUGE_PMD = 4,
	TTU_IGNORE_MLOCK = 8,
	TTU_SYNC = 16,
	TTU_HWPOISON = 32,
	TTU_BATCH_FLUSH = 64,
	TTU_RMAP_LOCKED = 128,
};

enum tty_driver_flag {
	TTY_DRIVER_INSTALLED = 1,
	TTY_DRIVER_RESET_TERMIOS = 2,
	TTY_DRIVER_REAL_RAW = 4,
	TTY_DRIVER_DYNAMIC_DEV = 8,
	TTY_DRIVER_DEVPTS_MEM = 16,
	TTY_DRIVER_HARDWARE_BREAK = 32,
	TTY_DRIVER_DYNAMIC_ALLOC = 64,
	TTY_DRIVER_UNNUMBERED_NODE = 128,
};

enum tty_driver_subtype {
	SYSTEM_TYPE_TTY = 1,
	SYSTEM_TYPE_CONSOLE = 2,
	SYSTEM_TYPE_SYSCONS = 3,
	SYSTEM_TYPE_SYSPTMX = 4,
	PTY_TYPE_MASTER = 1,
	PTY_TYPE_SLAVE = 2,
	SERIAL_TYPE_NORMAL = 1,
};

enum tty_driver_type {
	TTY_DRIVER_TYPE_SYSTEM = 0,
	TTY_DRIVER_TYPE_CONSOLE = 1,
	TTY_DRIVER_TYPE_SERIAL = 2,
	TTY_DRIVER_TYPE_PTY = 3,
	TTY_DRIVER_TYPE_SCC = 4,
	TTY_DRIVER_TYPE_SYSCONS = 5,
};

enum tty_flow_change {
	TTY_FLOW_NO_CHANGE = 0,
	TTY_THROTTLE_SAFE = 1,
	TTY_UNTHROTTLE_SAFE = 2,
};

enum tty_struct_flags {
	TTY_THROTTLED = 0,
	TTY_IO_ERROR = 1,
	TTY_OTHER_CLOSED = 2,
	TTY_EXCLUSIVE = 3,
	TTY_DO_WRITE_WAKEUP = 4,
	TTY_LDISC_OPEN = 5,
	TTY_PTY_LOCK = 6,
	TTY_NO_WRITE_SPLIT = 7,
	TTY_HUPPED = 8,
	TTY_HUPPING = 9,
	TTY_LDISC_CHANGING = 10,
	TTY_LDISC_HALTED = 11,
};

enum tunable_id {
	ETHTOOL_ID_UNSPEC = 0,
	ETHTOOL_RX_COPYBREAK = 1,
	ETHTOOL_TX_COPYBREAK = 2,
	ETHTOOL_PFC_PREVENTION_TOUT = 3,
	ETHTOOL_TX_COPYBREAK_BUF_SIZE = 4,
	__ETHTOOL_TUNABLE_COUNT = 5,
};

enum tunable_type_id {
	ETHTOOL_TUNABLE_UNSPEC = 0,
	ETHTOOL_TUNABLE_U8 = 1,
	ETHTOOL_TUNABLE_U16 = 2,
	ETHTOOL_TUNABLE_U32 = 3,
	ETHTOOL_TUNABLE_U64 = 4,
	ETHTOOL_TUNABLE_STRING = 5,
	ETHTOOL_TUNABLE_S8 = 6,
	ETHTOOL_TUNABLE_S16 = 7,
	ETHTOOL_TUNABLE_S32 = 8,
	ETHTOOL_TUNABLE_S64 = 9,
};

enum tva_type {
	TVA_SMAPS = 0,
	TVA_PAGEFAULT = 1,
	TVA_KHUGEPAGED = 2,
	TVA_FORCED_COLLAPSE = 3,
};

enum tx_queue_prio {
	TX_QUEUE_PRIO_HIGH = 0,
	TX_QUEUE_PRIO_LOW = 1,
};

enum tx_stats_reg_offset {
	TX_OCTS = 0,
	TX_UCAST = 1,
	TX_BCAST = 2,
	TX_MCAST = 3,
	TX_DROP = 4,
	TX_STATS_ENUM_LAST = 5,
};

enum txtime_flags {
	SOF_TXTIME_DEADLINE_MODE = 1,
	SOF_TXTIME_REPORT_ERRORS = 2,
	SOF_TXTIME_FLAGS_LAST = 2,
	SOF_TXTIME_FLAGS_MASK = 3,
};

enum u2_phy_params {
	U2P_EYE_VRT = 0,
	U2P_EYE_TERM = 1,
	U2P_EFUSE_EN = 2,
	U2P_EFUSE_INTR = 3,
	U2P_DISCTH = 4,
	U2P_PRE_EMPHASIS = 5,
};

enum u3_phy_params {
	U3P_EFUSE_EN = 0,
	U3P_EFUSE_INTR = 1,
	U3P_EFUSE_TX_IMP = 2,
	U3P_EFUSE_RX_IMP = 3,
};

enum uart_iotype {
	UPIO_UNKNOWN = -1,
	UPIO_PORT = 0,
	UPIO_HUB6 = 1,
	UPIO_MEM = 2,
	UPIO_MEM32 = 3,
	UPIO_AU = 4,
	UPIO_TSI = 5,
	UPIO_MEM32BE = 6,
	UPIO_MEM16 = 7,
};

enum uart_pm_state {
	UART_PM_STATE_ON = 0,
	UART_PM_STATE_OFF = 3,
	UART_PM_STATE_UNDEFINED = 4,
};

enum uclamp_id {
	UCLAMP_MIN = 0,
	UCLAMP_MAX = 1,
	UCLAMP_CNT = 2,
};

enum ucount_type {
	UCOUNT_USER_NAMESPACES = 0,
	UCOUNT_PID_NAMESPACES = 1,
	UCOUNT_UTS_NAMESPACES = 2,
	UCOUNT_IPC_NAMESPACES = 3,
	UCOUNT_NET_NAMESPACES = 4,
	UCOUNT_MNT_NAMESPACES = 5,
	UCOUNT_CGROUP_NAMESPACES = 6,
	UCOUNT_TIME_NAMESPACES = 7,
	UCOUNT_INOTIFY_INSTANCES = 8,
	UCOUNT_INOTIFY_WATCHES = 9,
	UCOUNT_FANOTIFY_GROUPS = 10,
	UCOUNT_FANOTIFY_MARKS = 11,
	UCOUNT_COUNTS = 12,
};

enum udma_chan_state {
	UDMA_CHAN_IS_IDLE = 0,
	UDMA_CHAN_IS_ACTIVE = 1,
	UDMA_CHAN_IS_TERMINATING = 2,
};

enum udma_mmr {
	MMR_GCFG = 0,
	MMR_BCHANRT = 1,
	MMR_RCHANRT = 2,
	MMR_TCHANRT = 3,
	MMR_LAST = 4,
};

enum udma_rm_range {
	RM_RANGE_BCHAN = 0,
	RM_RANGE_TCHAN = 1,
	RM_RANGE_RCHAN = 2,
	RM_RANGE_RFLOW = 3,
	RM_RANGE_TFLOW = 4,
	RM_RANGE_LAST = 5,
};

enum udma_tp_level {
	UDMA_TP_NORMAL = 0,
	UDMA_TP_HIGH = 1,
	UDMA_TP_ULTRAHIGH = 2,
	UDMA_TP_LAST = 3,
};

enum udp_tunnel_nic_info_flags {
	UDP_TUNNEL_NIC_INFO_OPEN_ONLY = 1,
	UDP_TUNNEL_NIC_INFO_IPV4_ONLY = 2,
	UDP_TUNNEL_NIC_INFO_STATIC_IANA_VXLAN = 4,
};

enum ufs_bsg_msg_code {
	UPIU_TRANSACTION_UIC_CMD = 31,
	UPIU_TRANSACTION_ARPMB_CMD = 32,
};

enum ufs_dev_pwr_mode {
	UFS_ACTIVE_PWR_MODE = 1,
	UFS_SLEEP_PWR_MODE = 2,
	UFS_POWERDOWN_PWR_MODE = 3,
	UFS_DEEPSLEEP_PWR_MODE = 4,
};

enum ufs_event_type {
	UFS_EVT_PA_ERR = 0,
	UFS_EVT_DL_ERR = 1,
	UFS_EVT_NL_ERR = 2,
	UFS_EVT_TL_ERR = 3,
	UFS_EVT_DME_ERR = 4,
	UFS_EVT_AUTO_HIBERN8_ERR = 5,
	UFS_EVT_FATAL_ERR = 6,
	UFS_EVT_LINK_STARTUP_FAIL = 7,
	UFS_EVT_RESUME_ERR = 8,
	UFS_EVT_SUSPEND_ERR = 9,
	UFS_EVT_WL_SUSP_ERR = 10,
	UFS_EVT_WL_RES_ERR = 11,
	UFS_EVT_DEV_RESET = 12,
	UFS_EVT_HOST_RESET = 13,
	UFS_EVT_ABORT = 14,
	UFS_EVT_CNT = 15,
};

enum ufs_hid_defrag_operation {
	HID_ANALYSIS_AND_DEFRAG_DISABLE = 0,
	HID_ANALYSIS_ENABLE = 1,
	HID_ANALYSIS_AND_DEFRAG_ENABLE = 2,
};

enum ufs_hid_state {
	HID_IDLE = 0,
	ANALYSIS_IN_PROGRESS = 1,
	DEFRAG_REQUIRED = 2,
	DEFRAG_IN_PROGRESS = 3,
	DEFRAG_COMPLETED = 4,
	DEFRAG_NOT_REQUIRED = 5,
	NUM_UFS_HID_STATES = 6,
};

enum ufs_hs_gear_rate {
	PA_HS_MODE_A = 1,
	PA_HS_MODE_B = 2,
};

enum ufs_hs_gear_tag {
	UFS_HS_DONT_CHANGE = 0,
	UFS_HS_G1 = 1,
	UFS_HS_G2 = 2,
	UFS_HS_G3 = 3,
	UFS_HS_G4 = 4,
	UFS_HS_G5 = 5,
};

enum ufs_lanes {
	UFS_LANE_DONT_CHANGE = 0,
	UFS_LANE_1 = 1,
	UFS_LANE_2 = 2,
};

enum ufs_lu_wp_type {
	UFS_LU_NO_WP = 0,
	UFS_LU_POWER_ON_WP = 1,
	UFS_LU_PERM_WP = 2,
};

enum ufs_notify_change_status {
	PRE_CHANGE = 0,
	POST_CHANGE = 1,
};

enum ufs_pa_pwr_mode {
	FAST_MODE = 1,
	SLOW_MODE = 2,
	FASTAUTO_MODE = 4,
	SLOWAUTO_MODE = 5,
	UNCHANGED = 7,
};

enum ufs_pm_level {
	UFS_PM_LVL_0 = 0,
	UFS_PM_LVL_1 = 1,
	UFS_PM_LVL_2 = 2,
	UFS_PM_LVL_3 = 3,
	UFS_PM_LVL_4 = 4,
	UFS_PM_LVL_5 = 5,
	UFS_PM_LVL_6 = 6,
	UFS_PM_LVL_MAX = 7,
};

enum ufs_pm_op {
	UFS_RUNTIME_PM = 0,
	UFS_SYSTEM_PM = 1,
	UFS_SHUTDOWN_PM = 2,
};

enum ufs_pwm_gear_tag {
	UFS_PWM_DONT_CHANGE = 0,
	UFS_PWM_G1 = 1,
	UFS_PWM_G2 = 2,
	UFS_PWM_G3 = 3,
	UFS_PWM_G4 = 4,
	UFS_PWM_G5 = 5,
	UFS_PWM_G6 = 6,
	UFS_PWM_G7 = 7,
};

enum ufs_ref_clk_freq {
	REF_CLK_FREQ_19_2_MHZ = 0,
	REF_CLK_FREQ_26_MHZ = 1,
	REF_CLK_FREQ_38_4_MHZ = 2,
	REF_CLK_FREQ_52_MHZ = 3,
	REF_CLK_FREQ_INVAL = -1,
};

enum ufs_rpmb_op_type {
	UFS_RPMB_WRITE_KEY = 1,
	UFS_RPMB_READ_CNT = 2,
	UFS_RPMB_WRITE = 3,
	UFS_RPMB_READ = 4,
	UFS_RPMB_READ_RESP = 5,
	UFS_RPMB_SEC_CONF_WRITE = 6,
	UFS_RPMB_SEC_CONF_READ = 7,
	UFS_RPMB_PURGE_ENABLE = 8,
	UFS_RPMB_PURGE_STATUS_READ = 9,
};

enum ufs_rtc_time {
	UFS_RTC_RELATIVE = 0,
	UFS_RTC_ABSOLUTE = 1,
};

enum ufs_trace_str_t {
	UFS_CMD_SEND = 0,
	UFS_CMD_COMP = 1,
	UFS_DEV_COMP = 2,
	UFS_QUERY_SEND = 3,
	UFS_QUERY_COMP = 4,
	UFS_QUERY_ERR = 5,
	UFS_TM_SEND = 6,
	UFS_TM_COMP = 7,
	UFS_TM_ERR = 8,
};

enum ufs_trace_tsf_t {
	UFS_TSF_CDB = 0,
	UFS_TSF_OSF = 1,
	UFS_TSF_TM_INPUT = 2,
	UFS_TSF_TM_OUTPUT = 3,
};

enum ufshcd_caps {
	UFSHCD_CAP_CLK_GATING = 1,
	UFSHCD_CAP_HIBERN8_WITH_CLK_GATING = 2,
	UFSHCD_CAP_CLK_SCALING = 4,
	UFSHCD_CAP_AUTO_BKOPS_SUSPEND = 8,
	UFSHCD_CAP_INTR_AGGR = 16,
	UFSHCD_CAP_KEEP_AUTO_BKOPS_ENABLED_EXCEPT_SUSPEND = 32,
	UFSHCD_CAP_RPM_AUTOSUSPEND = 64,
	UFSHCD_CAP_WB_EN = 128,
	UFSHCD_CAP_CRYPTO = 256,
	UFSHCD_CAP_AGGR_POWER_COLLAPSE = 512,
	UFSHCD_CAP_DEEPSLEEP = 1024,
	UFSHCD_CAP_TEMP_NOTIF = 2048,
	UFSHCD_CAP_WB_WITH_CLK_SCALING = 4096,
};

enum ufshcd_mcq_opr {
	OPR_SQD = 0,
	OPR_SQIS = 1,
	OPR_CQD = 2,
	OPR_CQIS = 3,
	OPR_MAX = 4,
};

enum ufshcd_quirks {
	UFSHCD_QUIRK_BROKEN_INTR_AGGR = 1,
	UFSHCD_QUIRK_DELAY_BEFORE_DME_CMDS = 2,
	UFSHCD_QUIRK_BROKEN_LCC = 4,
	UFSHCD_QUIRK_BROKEN_PA_RXHSUNTERMCAP = 8,
	UFSHCD_QUIRK_DME_PEER_ACCESS_AUTO_MODE = 16,
	UFSHCD_QUIRK_BROKEN_UFS_HCI_VERSION = 32,
	UFSHCI_QUIRK_BROKEN_REQ_LIST_CLR = 64,
	UFSHCI_QUIRK_SKIP_RESET_INTR_AGGR = 128,
	UFSHCI_QUIRK_BROKEN_HCE = 256,
	UFSHCD_QUIRK_PRDT_BYTE_GRAN = 512,
	UFSHCD_QUIRK_BROKEN_OCS_FATAL_ERROR = 1024,
	UFSHCD_QUIRK_BROKEN_AUTO_HIBERN8 = 2048,
	UFSHCI_QUIRK_SKIP_MANUAL_WB_FLUSH_CTRL = 4096,
	UFSHCD_QUIRK_SKIP_DEF_UNIPRO_TIMEOUT_SETTING = 8192,
	UFSHCD_QUIRK_BROKEN_UIC_CMD = 32768,
	UFSHCD_QUIRK_SKIP_PH_CONFIGURATION = 65536,
	UFSHCD_QUIRK_HIBERN_FASTAUTO = 262144,
	UFSHCD_QUIRK_REINIT_AFTER_MAX_GEAR_SWITCH = 524288,
	UFSHCD_QUIRK_MCQ_BROKEN_INTR = 1048576,
	UFSHCD_QUIRK_MCQ_BROKEN_RTC = 2097152,
	UFSHCD_QUIRK_CUSTOM_CRYPTO_PROFILE = 4194304,
	UFSHCD_QUIRK_BROKEN_CRYPTO_ENABLE = 8388608,
	UFSHCD_QUIRK_KEYS_IN_PRDT = 16777216,
	UFSHCD_QUIRK_BROKEN_LSDBS_CAP = 33554432,
	UFSHCD_QUIRK_PERFORM_LINK_STARTUP_ONCE = 67108864,
};

enum ufshcd_state {
	UFSHCD_STATE_RESET = 0,
	UFSHCD_STATE_OPERATIONAL = 1,
	UFSHCD_STATE_EH_SCHEDULED_NON_FATAL = 2,
	UFSHCD_STATE_EH_SCHEDULED_FATAL = 3,
	UFSHCD_STATE_ERROR = 4,
};

enum uic_cmd_dme {
	UIC_CMD_DME_GET = 1,
	UIC_CMD_DME_SET = 2,
	UIC_CMD_DME_PEER_GET = 3,
	UIC_CMD_DME_PEER_SET = 4,
	UIC_CMD_DME_POWERON = 16,
	UIC_CMD_DME_POWEROFF = 17,
	UIC_CMD_DME_ENABLE = 18,
	UIC_CMD_DME_RESET = 20,
	UIC_CMD_DME_END_PT_RST = 21,
	UIC_CMD_DME_LINK_STARTUP = 22,
	UIC_CMD_DME_HIBER_ENTER = 23,
	UIC_CMD_DME_HIBER_EXIT = 24,
	UIC_CMD_DME_TEST_MODE = 26,
};

enum uic_link_state {
	UIC_LINK_OFF_STATE = 0,
	UIC_LINK_ACTIVE_STATE = 1,
	UIC_LINK_HIBERN8_STATE = 2,
	UIC_LINK_BROKEN_STATE = 3,
};

enum umh_disable_depth {
	UMH_ENABLED = 0,
	UMH_FREEZING = 1,
	UMH_DISABLED = 2,
};

enum umount_tree_flags {
	UMOUNT_SYNC = 1,
	UMOUNT_PROPAGATE = 2,
	UMOUNT_CONNECTED = 4,
};

enum uniphier_clk_type {
	UNIPHIER_CLK_TYPE_CPUGEAR = 0,
	UNIPHIER_CLK_TYPE_FIXED_FACTOR = 1,
	UNIPHIER_CLK_TYPE_FIXED_RATE = 2,
	UNIPHIER_CLK_TYPE_GATE = 3,
	UNIPHIER_CLK_TYPE_MUX = 4,
};

enum uniphier_pin_drv_type {
	UNIPHIER_PIN_DRV_1BIT = 0,
	UNIPHIER_PIN_DRV_2BIT = 1,
	UNIPHIER_PIN_DRV_3BIT = 2,
	UNIPHIER_PIN_DRV_FIXED4 = 3,
	UNIPHIER_PIN_DRV_FIXED5 = 4,
	UNIPHIER_PIN_DRV_FIXED8 = 5,
	UNIPHIER_PIN_DRV_NONE = 6,
};

enum uniphier_pin_pull_dir {
	UNIPHIER_PIN_PULL_UP = 0,
	UNIPHIER_PIN_PULL_DOWN = 1,
	UNIPHIER_PIN_PULL_UP_FIXED = 2,
	UNIPHIER_PIN_PULL_DOWN_FIXED = 3,
	UNIPHIER_PIN_PULL_NONE = 4,
};

enum unit_desc_param {
	UNIT_DESC_PARAM_LEN = 0,
	UNIT_DESC_PARAM_TYPE = 1,
	UNIT_DESC_PARAM_UNIT_INDEX = 2,
	UNIT_DESC_PARAM_LU_ENABLE = 3,
	UNIT_DESC_PARAM_BOOT_LUN_ID = 4,
	UNIT_DESC_PARAM_LU_WR_PROTECT = 5,
	UNIT_DESC_PARAM_LU_Q_DEPTH = 6,
	UNIT_DESC_PARAM_PSA_SENSITIVE = 7,
	UNIT_DESC_PARAM_MEM_TYPE = 8,
	UNIT_DESC_PARAM_DATA_RELIABILITY = 9,
	UNIT_DESC_PARAM_LOGICAL_BLK_SIZE = 10,
	UNIT_DESC_PARAM_LOGICAL_BLK_COUNT = 11,
	UNIT_DESC_PARAM_ERASE_BLK_SIZE = 19,
	UNIT_DESC_PARAM_PROVISIONING_TYPE = 23,
	UNIT_DESC_PARAM_PHY_MEM_RSRC_CNT = 24,
	UNIT_DESC_PARAM_CTX_CAPABILITIES = 32,
	UNIT_DESC_PARAM_LARGE_UNIT_SIZE_M1 = 34,
	UNIT_DESC_PARAM_HPB_LU_MAX_ACTIVE_RGNS = 35,
	UNIT_DESC_PARAM_HPB_PIN_RGN_START_OFF = 37,
	UNIT_DESC_PARAM_HPB_NUM_PIN_RGNS = 39,
	UNIT_DESC_PARAM_WB_BUF_ALLOC_UNITS = 41,
};

enum unix_vertex_index {
	UNIX_VERTEX_INDEX_MARK1 = 0,
	UNIX_VERTEX_INDEX_MARK2 = 1,
	UNIX_VERTEX_INDEX_START = 2,
};

enum upiu_request_transaction {
	UPIU_TRANSACTION_NOP_OUT = 0,
	UPIU_TRANSACTION_COMMAND = 1,
	UPIU_TRANSACTION_DATA_OUT = 2,
	UPIU_TRANSACTION_TASK_REQ = 4,
	UPIU_TRANSACTION_QUERY_REQ = 22,
};

enum upiu_response_transaction {
	UPIU_TRANSACTION_NOP_IN = 32,
	UPIU_TRANSACTION_RESPONSE = 33,
	UPIU_TRANSACTION_DATA_IN = 34,
	UPIU_TRANSACTION_TASK_RSP = 36,
	UPIU_TRANSACTION_READY_XFER = 49,
	UPIU_TRANSACTION_QUERY_RSP = 54,
	UPIU_TRANSACTION_REJECT_UPIU = 63,
};

enum usb3503_mode {
	USB3503_MODE_UNKNOWN = 0,
	USB3503_MODE_HUB = 1,
	USB3503_MODE_STANDBY = 2,
	USB3503_MODE_BYPASS = 3,
};

enum usb3_link_state {
	USB3_LPM_U0 = 0,
	USB3_LPM_U1 = 1,
	USB3_LPM_U2 = 2,
	USB3_LPM_U3 = 3,
};

enum usb_charger_state {
	USB_CHARGER_DEFAULT = 0,
	USB_CHARGER_PRESENT = 1,
	USB_CHARGER_ABSENT = 2,
};

enum usb_charger_type {
	UNKNOWN_TYPE = 0,
	SDP_TYPE = 1,
	DCP_TYPE = 2,
	CDP_TYPE = 3,
	ACA_TYPE = 4,
};

enum usb_chg_state {
	USB_CHG_STATE_UNDEFINED = 0,
	USB_CHG_STATE_WAIT_FOR_DCD = 1,
	USB_CHG_STATE_DCD_DONE = 2,
	USB_CHG_STATE_PRIMARY_DONE = 3,
	USB_CHG_STATE_SECONDARY_DONE = 4,
	USB_CHG_STATE_DETECTED = 5,
};

enum usb_chg_type {
	USB_CHG_TYPE_NONE = 0,
	USB_CHG_TYPE_PD = 1,
	USB_CHG_TYPE_C = 2,
	USB_CHG_TYPE_PROPRIETARY = 3,
	USB_CHG_TYPE_BC12_DCP = 4,
	USB_CHG_TYPE_BC12_CDP = 5,
	USB_CHG_TYPE_BC12_SDP = 6,
	USB_CHG_TYPE_OTHER = 7,
	USB_CHG_TYPE_VBUS = 8,
	USB_CHG_TYPE_UNKNOWN = 9,
	USB_CHG_TYPE_DEDICATED = 10,
};

enum usb_data_roles {
	DR_NONE = 0,
	DR_HOST = 1,
	DR_DEVICE = 2,
};

enum usb_dev_authorize_policy {
	USB_DEVICE_AUTHORIZE_NONE = 0,
	USB_DEVICE_AUTHORIZE_ALL = 1,
	USB_DEVICE_AUTHORIZE_INTERNAL = 2,
};

enum usb_device_speed {
	USB_SPEED_UNKNOWN = 0,
	USB_SPEED_LOW = 1,
	USB_SPEED_FULL = 2,
	USB_SPEED_HIGH = 3,
	USB_SPEED_WIRELESS = 4,
	USB_SPEED_SUPER = 5,
	USB_SPEED_SUPER_PLUS = 6,
};

enum usb_device_state {
	USB_STATE_NOTATTACHED = 0,
	USB_STATE_ATTACHED = 1,
	USB_STATE_POWERED = 2,
	USB_STATE_RECONNECTING = 3,
	USB_STATE_UNAUTHENTICATED = 4,
	USB_STATE_DEFAULT = 5,
	USB_STATE_ADDRESS = 6,
	USB_STATE_CONFIGURED = 7,
	USB_STATE_SUSPENDED = 8,
};

enum usb_dr_mode {
	USB_DR_MODE_UNKNOWN = 0,
	USB_DR_MODE_HOST = 1,
	USB_DR_MODE_PERIPHERAL = 2,
	USB_DR_MODE_OTG = 3,
};

enum usb_interface_condition {
	USB_INTERFACE_UNBOUND = 0,
	USB_INTERFACE_BINDING = 1,
	USB_INTERFACE_BOUND = 2,
	USB_INTERFACE_UNBINDING = 3,
};

enum usb_led_event {
	USB_LED_EVENT_HOST = 0,
	USB_LED_EVENT_GADGET = 1,
};

enum usb_link_tunnel_mode {
	USB_LINK_UNKNOWN = 0,
	USB_LINK_NATIVE = 1,
	USB_LINK_TUNNELED = 2,
};

enum usb_otg_state {
	OTG_STATE_UNDEFINED = 0,
	OTG_STATE_B_IDLE = 1,
	OTG_STATE_B_SRP_INIT = 2,
	OTG_STATE_B_PERIPHERAL = 3,
	OTG_STATE_B_WAIT_ACON = 4,
	OTG_STATE_B_HOST = 5,
	OTG_STATE_A_IDLE = 6,
	OTG_STATE_A_WAIT_VRISE = 7,
	OTG_STATE_A_WAIT_BCON = 8,
	OTG_STATE_A_HOST = 9,
	OTG_STATE_A_SUSPEND = 10,
	OTG_STATE_A_PERIPHERAL = 11,
	OTG_STATE_A_WAIT_VFALL = 12,
	OTG_STATE_A_VBUS_ERR = 13,
};

enum usb_pd_control_mux {
	USB_PD_CTRL_MUX_NO_CHANGE = 0,
	USB_PD_CTRL_MUX_NONE = 1,
	USB_PD_CTRL_MUX_USB = 2,
	USB_PD_CTRL_MUX_DP = 3,
	USB_PD_CTRL_MUX_DOCK = 4,
	USB_PD_CTRL_MUX_AUTO = 5,
	USB_PD_CTRL_MUX_COUNT = 6,
};

enum usb_pd_control_role {
	USB_PD_CTRL_ROLE_NO_CHANGE = 0,
	USB_PD_CTRL_ROLE_TOGGLE_ON = 1,
	USB_PD_CTRL_ROLE_TOGGLE_OFF = 2,
	USB_PD_CTRL_ROLE_FORCE_SINK = 3,
	USB_PD_CTRL_ROLE_FORCE_SOURCE = 4,
	USB_PD_CTRL_ROLE_FREEZE = 5,
	USB_PD_CTRL_ROLE_COUNT = 6,
};

enum usb_pd_control_swap {
	USB_PD_CTRL_SWAP_NONE = 0,
	USB_PD_CTRL_SWAP_DATA = 1,
	USB_PD_CTRL_SWAP_POWER = 2,
	USB_PD_CTRL_SWAP_VCONN = 3,
	USB_PD_CTRL_SWAP_COUNT = 4,
};

enum usb_phy_events {
	USB_EVENT_NONE = 0,
	USB_EVENT_VBUS = 1,
	USB_EVENT_ID = 2,
	USB_EVENT_CHARGER = 3,
	USB_EVENT_ENUMERATED = 4,
};

enum usb_phy_interface {
	USBPHY_INTERFACE_MODE_UNKNOWN = 0,
	USBPHY_INTERFACE_MODE_UTMI = 1,
	USBPHY_INTERFACE_MODE_UTMIW = 2,
	USBPHY_INTERFACE_MODE_ULPI = 3,
	USBPHY_INTERFACE_MODE_SERIAL = 4,
	USBPHY_INTERFACE_MODE_HSIC = 5,
};

enum usb_phy_type {
	USB_PHY_TYPE_UNDEFINED = 0,
	USB_PHY_TYPE_USB2 = 1,
	USB_PHY_TYPE_USB3 = 2,
};

enum usb_port_connect_type {
	USB_PORT_CONNECT_TYPE_UNKNOWN = 0,
	USB_PORT_CONNECT_TYPE_HOT_PLUG = 1,
	USB_PORT_CONNECT_TYPE_HARD_WIRED = 2,
	USB_PORT_NOT_USED = 3,
};

enum usb_role {
	USB_ROLE_NONE = 0,
	USB_ROLE_HOST = 1,
	USB_ROLE_DEVICE = 2,
};

enum usb_ssp_rate {
	USB_SSP_GEN_UNKNOWN = 0,
	USB_SSP_GEN_2x1 = 1,
	USB_SSP_GEN_1x2 = 2,
	USB_SSP_GEN_2x2 = 3,
};

enum usb_wireless_status {
	USB_WIRELESS_STATUS_NA = 0,
	USB_WIRELESS_STATUS_DISCONNECTED = 1,
	USB_WIRELESS_STATUS_CONNECTED = 2,
};

enum utf16_endian {
	UTF16_HOST_ENDIAN = 0,
	UTF16_LITTLE_ENDIAN = 1,
	UTF16_BIG_ENDIAN = 2,
};

enum utf8_normalization {
	UTF8_NFDI = 0,
	UTF8_NFDICF = 1,
	UTF8_NMAX = 2,
};

enum utp_data_direction {
	UTP_NO_DATA_TRANSFER = 0,
	UTP_HOST_TO_DEVICE = 1,
	UTP_DEVICE_TO_HOST = 2,
};

enum utp_ocs {
	OCS_SUCCESS = 0,
	OCS_INVALID_CMD_TABLE_ATTR = 1,
	OCS_INVALID_PRDT_ATTR = 2,
	OCS_MISMATCH_DATA_BUF_SIZE = 3,
	OCS_MISMATCH_RESP_UPIU_SIZE = 4,
	OCS_PEER_COMM_FAILURE = 5,
	OCS_ABORTED = 6,
	OCS_FATAL_ERROR = 7,
	OCS_DEVICE_FATAL_ERROR = 8,
	OCS_INVALID_CRYPTO_CONFIG = 9,
	OCS_GENERAL_CRYPTO_ERROR = 10,
	OCS_INVALID_COMMAND_STATUS = 15,
};

enum uts_proc {
	UTS_PROC_ARCH = 0,
	UTS_PROC_OSTYPE = 1,
	UTS_PROC_OSRELEASE = 2,
	UTS_PROC_VERSION = 3,
	UTS_PROC_HOSTNAME = 4,
	UTS_PROC_DOMAINNAME = 5,
};

enum v4l2_fwnode_bus_type {
	V4L2_FWNODE_BUS_TYPE_GUESS = 0,
	V4L2_FWNODE_BUS_TYPE_CSI2_CPHY = 1,
	V4L2_FWNODE_BUS_TYPE_CSI1 = 2,
	V4L2_FWNODE_BUS_TYPE_CCP2 = 3,
	V4L2_FWNODE_BUS_TYPE_CSI2_DPHY = 4,
	V4L2_FWNODE_BUS_TYPE_PARALLEL = 5,
	V4L2_FWNODE_BUS_TYPE_BT656 = 6,
	V4L2_FWNODE_BUS_TYPE_DPI = 7,
	NR_OF_V4L2_FWNODE_BUS_TYPE = 8,
};

enum vc3_clk {
	VC3_REF = 0,
	VC3_SE1 = 1,
	VC3_SE2 = 2,
	VC3_SE3 = 3,
	VC3_DIFF1 = 4,
	VC3_DIFF2 = 5,
};

enum vc3_clk_mux {
	VC3_SE1_MUX = 0,
	VC3_SE2_MUX = 1,
	VC3_SE3_MUX = 2,
	VC3_DIFF1_MUX = 3,
	VC3_DIFF2_MUX = 4,
};

enum vc3_pfd {
	VC3_PFD1 = 0,
	VC3_PFD2 = 1,
	VC3_PFD3 = 2,
};

enum vc3_pll {
	VC3_PLL1 = 0,
	VC3_PLL2 = 1,
	VC3_PLL3 = 2,
};

enum vc5_model {
	IDT_VC5_5P49V5923 = 0,
	IDT_VC5_5P49V5925 = 1,
	IDT_VC5_5P49V5933 = 2,
	IDT_VC5_5P49V5935 = 3,
	IDT_VC6_5P49V60 = 4,
	IDT_VC6_5P49V6901 = 5,
	IDT_VC6_5P49V6965 = 6,
	IDT_VC6_5P49V6975 = 7,
};

enum vc_ctl_state {
	ESnormal = 0,
	ESesc = 1,
	ESsquare = 2,
	ESgetpars = 3,
	ESfunckey = 4,
	EShash = 5,
	ESsetG0 = 6,
	ESsetG1 = 7,
	ESpercent = 8,
	EScsiignore = 9,
	ESnonstd = 10,
	ESpalette = 11,
	ESosc = 12,
	ESANSI_first = 12,
	ESapc = 13,
	ESpm = 14,
	ESdcs = 15,
	ESANSI_last = 15,
};

enum vc_intensity {
	VCI_HALF_BRIGHT = 0,
	VCI_NORMAL = 1,
	VCI_BOLD = 2,
	VCI_MASK = 3,
};

enum vco_freq_range {
	VCO_LOW = 700000000,
	VCO_MID = 1200000000,
	VCO_HIGH = 2200000000,
	VCO_HIGH_HIGH = 3100000000,
	VCO_MAX = 4000000000,
};

enum vcpu_sysreg {
	__INVALID_SYSREG__ = 0,
	MPIDR_EL1 = 1,
	CLIDR_EL1 = 2,
	CSSELR_EL1 = 3,
	TPIDR_EL0 = 4,
	TPIDRRO_EL0 = 5,
	TPIDR_EL1 = 6,
	CNTKCTL_EL1 = 7,
	PAR_EL1 = 8,
	MDCCINT_EL1 = 9,
	OSLSR_EL1 = 10,
	DISR_EL1 = 11,
	PMCR_EL0 = 12,
	PMSELR_EL0 = 13,
	PMEVCNTR0_EL0 = 14,
	PMEVCNTR30_EL0 = 44,
	PMCCNTR_EL0 = 45,
	PMEVTYPER0_EL0 = 46,
	PMEVTYPER30_EL0 = 76,
	PMCCFILTR_EL0 = 77,
	PMCNTENSET_EL0 = 78,
	PMINTENSET_EL1 = 79,
	PMOVSSET_EL0 = 80,
	PMUSERENR_EL0 = 81,
	APIAKEYLO_EL1 = 82,
	APIAKEYHI_EL1 = 83,
	APIBKEYLO_EL1 = 84,
	APIBKEYHI_EL1 = 85,
	APDAKEYLO_EL1 = 86,
	APDAKEYHI_EL1 = 87,
	APDBKEYLO_EL1 = 88,
	APDBKEYHI_EL1 = 89,
	APGAKEYLO_EL1 = 90,
	APGAKEYHI_EL1 = 91,
	RGSR_EL1 = 92,
	GCR_EL1 = 93,
	TFSRE0_EL1 = 94,
	POR_EL0 = 95,
	SVCR = 96,
	FPMR = 97,
	DACR32_EL2 = 98,
	IFSR32_EL2 = 99,
	FPEXC32_EL2 = 100,
	DBGVCR32_EL2 = 101,
	SCTLR_EL2 = 102,
	ACTLR_EL2 = 103,
	CPTR_EL2 = 104,
	HACR_EL2 = 105,
	ZCR_EL2 = 106,
	TTBR0_EL2 = 107,
	TTBR1_EL2 = 108,
	TCR_EL2 = 109,
	PIRE0_EL2 = 110,
	PIR_EL2 = 111,
	POR_EL2 = 112,
	SPSR_EL2 = 113,
	ELR_EL2 = 114,
	AFSR0_EL2 = 115,
	AFSR1_EL2 = 116,
	ESR_EL2 = 117,
	FAR_EL2 = 118,
	HPFAR_EL2 = 119,
	MAIR_EL2 = 120,
	AMAIR_EL2 = 121,
	VBAR_EL2 = 122,
	RVBAR_EL2 = 123,
	CONTEXTIDR_EL2 = 124,
	SP_EL2 = 125,
	CNTHP_CTL_EL2 = 126,
	CNTHP_CVAL_EL2 = 127,
	CNTHV_CTL_EL2 = 128,
	CNTHV_CVAL_EL2 = 129,
	__SANITISED_REG_START__ = 130,
	__after___SANITISED_REG_START__ = 129,
	TCR2_EL2 = 130,
	SCTLR2_EL2 = 131,
	MDCR_EL2 = 132,
	CNTHCTL_EL2 = 133,
	__VNCR_START__ = 134,
	__after___VNCR_START__ = 133,
	__before_SCTLR_EL1 = 134,
	SCTLR_EL1 = 168,
	__after_SCTLR_EL1 = 168,
	__before_ACTLR_EL1 = 169,
	ACTLR_EL1 = 169,
	__after_ACTLR_EL1 = 169,
	__before_CPACR_EL1 = 170,
	CPACR_EL1 = 166,
	__after_CPACR_EL1 = 169,
	__before_ZCR_EL1 = 170,
	ZCR_EL1 = 194,
	__after_ZCR_EL1 = 194,
	__before_TTBR0_EL1 = 195,
	TTBR0_EL1 = 198,
	__after_TTBR0_EL1 = 198,
	__before_TTBR1_EL1 = 199,
	TTBR1_EL1 = 200,
	__after_TTBR1_EL1 = 200,
	__before_TCR_EL1 = 201,
	TCR_EL1 = 170,
	__after_TCR_EL1 = 200,
	__before_TCR2_EL1 = 201,
	TCR2_EL1 = 212,
	__after_TCR2_EL1 = 212,
	__before_SCTLR2_EL1 = 213,
	SCTLR2_EL1 = 213,
	__after_SCTLR2_EL1 = 213,
	__before_ESR_EL1 = 214,
	ESR_EL1 = 173,
	__after_ESR_EL1 = 213,
	__before_AFSR0_EL1 = 214,
	AFSR0_EL1 = 171,
	__after_AFSR0_EL1 = 213,
	__before_AFSR1_EL1 = 214,
	AFSR1_EL1 = 172,
	__after_AFSR1_EL1 = 213,
	__before_FAR_EL1 = 214,
	FAR_EL1 = 202,
	__after_FAR_EL1 = 213,
	__before_MAIR_EL1 = 214,
	MAIR_EL1 = 174,
	__after_MAIR_EL1 = 213,
	__before_VBAR_EL1 = 214,
	VBAR_EL1 = 208,
	__after_VBAR_EL1 = 213,
	__before_CONTEXTIDR_EL1 = 214,
	CONTEXTIDR_EL1 = 167,
	__after_CONTEXTIDR_EL1 = 213,
	__before_AMAIR_EL1 = 214,
	AMAIR_EL1 = 175,
	__after_AMAIR_EL1 = 213,
	__before_MDSCR_EL1 = 214,
	MDSCR_EL1 = 177,
	__after_MDSCR_EL1 = 213,
	__before_ELR_EL1 = 214,
	ELR_EL1 = 204,
	__after_ELR_EL1 = 213,
	__before_SP_EL1 = 214,
	SP_EL1 = 206,
	__after_SP_EL1 = 213,
	__before_SPSR_EL1 = 214,
	SPSR_EL1 = 178,
	__after_SPSR_EL1 = 213,
	__before_TFSR_EL1 = 214,
	TFSR_EL1 = 184,
	__after_TFSR_EL1 = 213,
	__before_VPIDR_EL2 = 214,
	VPIDR_EL2 = 151,
	__after_VPIDR_EL2 = 213,
	__before_VMPIDR_EL2 = 214,
	VMPIDR_EL2 = 144,
	__after_VMPIDR_EL2 = 213,
	__before_HCR_EL2 = 214,
	HCR_EL2 = 149,
	__after_HCR_EL2 = 213,
	__before_HSTR_EL2 = 214,
	HSTR_EL2 = 150,
	__after_HSTR_EL2 = 213,
	__before_VTTBR_EL2 = 214,
	VTTBR_EL2 = 138,
	__after_VTTBR_EL2 = 213,
	__before_VTCR_EL2 = 214,
	VTCR_EL2 = 142,
	__after_VTCR_EL2 = 213,
	__before_TPIDR_EL2 = 214,
	TPIDR_EL2 = 152,
	__after_TPIDR_EL2 = 213,
	__before_HCRX_EL2 = 214,
	HCRX_EL2 = 154,
	__after_HCRX_EL2 = 213,
	__before_PIR_EL1 = 214,
	PIR_EL1 = 218,
	__after_PIR_EL1 = 218,
	__before_PIRE0_EL1 = 219,
	PIRE0_EL1 = 216,
	__after_PIRE0_EL1 = 218,
	__before_POR_EL1 = 219,
	POR_EL1 = 219,
	__after_POR_EL1 = 219,
	__before_VDISR_EL2 = 220,
	VDISR_EL2 = 294,
	__after_VDISR_EL2 = 294,
	__before_VSESR_EL2 = 295,
	VSESR_EL2 = 295,
	__after_VSESR_EL2 = 295,
	__before_HFGRTR_EL2 = 296,
	HFGRTR_EL2 = 189,
	__after_HFGRTR_EL2 = 295,
	__before_HFGWTR_EL2 = 296,
	HFGWTR_EL2 = 190,
	__after_HFGWTR_EL2 = 295,
	__before_HFGITR_EL2 = 296,
	HFGITR_EL2 = 191,
	__after_HFGITR_EL2 = 295,
	__before_HDFGRTR_EL2 = 296,
	HDFGRTR_EL2 = 192,
	__after_HDFGRTR_EL2 = 295,
	__before_HDFGWTR_EL2 = 296,
	HDFGWTR_EL2 = 193,
	__after_HDFGWTR_EL2 = 295,
	__before_HAFGRTR_EL2 = 296,
	HAFGRTR_EL2 = 195,
	__after_HAFGRTR_EL2 = 295,
	__before_HFGRTR2_EL2 = 296,
	HFGRTR2_EL2 = 222,
	__after_HFGRTR2_EL2 = 295,
	__before_HFGWTR2_EL2 = 296,
	HFGWTR2_EL2 = 223,
	__after_HFGWTR2_EL2 = 295,
	__before_HFGITR2_EL2 = 296,
	HFGITR2_EL2 = 232,
	__after_HFGITR2_EL2 = 295,
	__before_HDFGRTR2_EL2 = 296,
	HDFGRTR2_EL2 = 186,
	__after_HDFGRTR2_EL2 = 295,
	__before_HDFGWTR2_EL2 = 296,
	HDFGWTR2_EL2 = 188,
	__after_HDFGWTR2_EL2 = 295,
	__before_VNCR_EL2 = 296,
	VNCR_EL2 = 156,
	__after_VNCR_EL2 = 295,
	__before_CNTVOFF_EL2 = 296,
	CNTVOFF_EL2 = 146,
	__after_CNTVOFF_EL2 = 295,
	__before_CNTV_CVAL_EL0 = 296,
	CNTV_CVAL_EL0 = 179,
	__after_CNTV_CVAL_EL0 = 295,
	__before_CNTV_CTL_EL0 = 296,
	CNTV_CTL_EL0 = 180,
	__after_CNTV_CTL_EL0 = 295,
	__before_CNTP_CVAL_EL0 = 296,
	CNTP_CVAL_EL0 = 181,
	__after_CNTP_CVAL_EL0 = 295,
	__before_CNTP_CTL_EL0 = 296,
	CNTP_CTL_EL0 = 182,
	__after_CNTP_CTL_EL0 = 295,
	__before_ICH_LR0_EL2 = 296,
	ICH_LR0_EL2 = 262,
	__after_ICH_LR0_EL2 = 295,
	__before_ICH_LR1_EL2 = 296,
	ICH_LR1_EL2 = 263,
	__after_ICH_LR1_EL2 = 295,
	__before_ICH_LR2_EL2 = 296,
	ICH_LR2_EL2 = 264,
	__after_ICH_LR2_EL2 = 295,
	__before_ICH_LR3_EL2 = 296,
	ICH_LR3_EL2 = 265,
	__after_ICH_LR3_EL2 = 295,
	__before_ICH_LR4_EL2 = 296,
	ICH_LR4_EL2 = 266,
	__after_ICH_LR4_EL2 = 295,
	__before_ICH_LR5_EL2 = 296,
	ICH_LR5_EL2 = 267,
	__after_ICH_LR5_EL2 = 295,
	__before_ICH_LR6_EL2 = 296,
	ICH_LR6_EL2 = 268,
	__after_ICH_LR6_EL2 = 295,
	__before_ICH_LR7_EL2 = 296,
	ICH_LR7_EL2 = 269,
	__after_ICH_LR7_EL2 = 295,
	__before_ICH_LR8_EL2 = 296,
	ICH_LR8_EL2 = 270,
	__after_ICH_LR8_EL2 = 295,
	__before_ICH_LR9_EL2 = 296,
	ICH_LR9_EL2 = 271,
	__after_ICH_LR9_EL2 = 295,
	__before_ICH_LR10_EL2 = 296,
	ICH_LR10_EL2 = 272,
	__after_ICH_LR10_EL2 = 295,
	__before_ICH_LR11_EL2 = 296,
	ICH_LR11_EL2 = 273,
	__after_ICH_LR11_EL2 = 295,
	__before_ICH_LR12_EL2 = 296,
	ICH_LR12_EL2 = 274,
	__after_ICH_LR12_EL2 = 295,
	__before_ICH_LR13_EL2 = 296,
	ICH_LR13_EL2 = 275,
	__after_ICH_LR13_EL2 = 295,
	__before_ICH_LR14_EL2 = 296,
	ICH_LR14_EL2 = 276,
	__after_ICH_LR14_EL2 = 295,
	__before_ICH_LR15_EL2 = 296,
	ICH_LR15_EL2 = 277,
	__after_ICH_LR15_EL2 = 295,
	__before_ICH_AP0R0_EL2 = 296,
	ICH_AP0R0_EL2 = 278,
	__after_ICH_AP0R0_EL2 = 295,
	__before_ICH_AP0R1_EL2 = 296,
	ICH_AP0R1_EL2 = 279,
	__after_ICH_AP0R1_EL2 = 295,
	__before_ICH_AP0R2_EL2 = 296,
	ICH_AP0R2_EL2 = 280,
	__after_ICH_AP0R2_EL2 = 295,
	__before_ICH_AP0R3_EL2 = 296,
	ICH_AP0R3_EL2 = 281,
	__after_ICH_AP0R3_EL2 = 295,
	__before_ICH_AP1R0_EL2 = 296,
	ICH_AP1R0_EL2 = 282,
	__after_ICH_AP1R0_EL2 = 295,
	__before_ICH_AP1R1_EL2 = 296,
	ICH_AP1R1_EL2 = 283,
	__after_ICH_AP1R1_EL2 = 295,
	__before_ICH_AP1R2_EL2 = 296,
	ICH_AP1R2_EL2 = 284,
	__after_ICH_AP1R2_EL2 = 295,
	__before_ICH_AP1R3_EL2 = 296,
	ICH_AP1R3_EL2 = 285,
	__after_ICH_AP1R3_EL2 = 295,
	__before_ICH_HCR_EL2 = 296,
	ICH_HCR_EL2 = 286,
	__after_ICH_HCR_EL2 = 295,
	__before_ICH_VMCR_EL2 = 296,
	ICH_VMCR_EL2 = 287,
	__after_ICH_VMCR_EL2 = 295,
	NR_SYS_REGS = 296,
};

enum vdso_abi {
	VDSO_ABI_AA64 = 0,
	VDSO_ABI_AA32 = 1,
};

enum vdso_clock_mode {
	VDSO_CLOCKMODE_NONE = 0,
	VDSO_CLOCKMODE_ARCHTIMER = 1,
	VDSO_CLOCKMODE_ARCHTIMER_NOCOMPAT = 2,
	VDSO_CLOCKMODE_MAX = 3,
	VDSO_CLOCKMODE_TIMENS = 2147483647,
};

enum vdso_pages {
	VDSO_TIME_PAGE_OFFSET = 0,
	VDSO_TIMENS_PAGE_OFFSET = 1,
	VDSO_RNG_PAGE_OFFSET = 2,
	VDSO_ARCH_PAGES_START = 3,
	VDSO_ARCH_PAGES_END = 3,
	VDSO_NR_PAGES = 4,
};

enum vec_type {
	ARM64_VEC_SVE = 0,
	ARM64_VEC_SME = 1,
	ARM64_VEC_MAX = 2,
};

enum verifier_phase {
	CHECK_META = 0,
	CHECK_TYPE = 1,
};

enum vesa_blank_mode {
	VESA_NO_BLANKING = 0,
	VESA_VSYNC_SUSPEND = 1,
	VESA_HSYNC_SUSPEND = 2,
	VESA_POWERDOWN = 3,
	VESA_BLANK_MAX = 3,
};

enum vfio_device_mig_state {
	VFIO_DEVICE_STATE_ERROR = 0,
	VFIO_DEVICE_STATE_STOP = 1,
	VFIO_DEVICE_STATE_RUNNING = 2,
	VFIO_DEVICE_STATE_STOP_COPY = 3,
	VFIO_DEVICE_STATE_RESUMING = 4,
	VFIO_DEVICE_STATE_RUNNING_P2P = 5,
	VFIO_DEVICE_STATE_PRE_COPY = 6,
	VFIO_DEVICE_STATE_PRE_COPY_P2P = 7,
	VFIO_DEVICE_STATE_NR = 8,
};

enum vfio_group_type {
	VFIO_IOMMU = 0,
	VFIO_EMULATED_IOMMU = 1,
	VFIO_NO_IOMMU = 2,
};

enum vgic_irq_config {
	VGIC_CONFIG_EDGE = 0,
	VGIC_CONFIG_LEVEL = 1,
};

enum vgic_type {
	VGIC_V2 = 0,
	VGIC_V3 = 1,
	VGIC_V5 = 2,
};

enum virtio_balloon_config_read {
	VIRTIO_BALLOON_CONFIG_READ_CMD_ID = 0,
};

enum virtio_balloon_vq {
	VIRTIO_BALLOON_VQ_INFLATE = 0,
	VIRTIO_BALLOON_VQ_DEFLATE = 1,
	VIRTIO_BALLOON_VQ_STATS = 2,
	VIRTIO_BALLOON_VQ_FREE_PAGE = 3,
	VIRTIO_BALLOON_VQ_REPORTING = 4,
	VIRTIO_BALLOON_VQ_MAX = 5,
};

enum virtnet_xmit_type {
	VIRTNET_XMIT_TYPE_SKB = 0,
	VIRTNET_XMIT_TYPE_SKB_ORPHAN = 1,
	VIRTNET_XMIT_TYPE_XDP = 2,
	VIRTNET_XMIT_TYPE_XSK = 3,
};

enum visit_state {
	NOT_VISITED = 0,
	VISITED = 1,
	RESOLVED = 2,
};

enum vlan_flags {
	VLAN_FLAG_REORDER_HDR = 1,
	VLAN_FLAG_GVRP = 2,
	VLAN_FLAG_LOOSE_BINDING = 4,
	VLAN_FLAG_MVRP = 8,
	VLAN_FLAG_BRIDGE_BINDING = 16,
};

enum vlan_protos {
	VLAN_PROTO_8021Q = 0,
	VLAN_PROTO_8021AD = 1,
	VLAN_PROTO_NUM = 2,
};

enum vm_event_item {
	PGPGIN = 0,
	PGPGOUT = 1,
	PSWPIN = 2,
	PSWPOUT = 3,
	PGALLOC_DMA = 4,
	PGALLOC_DMA32 = 5,
	PGALLOC_NORMAL = 6,
	PGALLOC_MOVABLE = 7,
	ALLOCSTALL_DMA = 8,
	ALLOCSTALL_DMA32 = 9,
	ALLOCSTALL_NORMAL = 10,
	ALLOCSTALL_MOVABLE = 11,
	PGSCAN_SKIP_DMA = 12,
	PGSCAN_SKIP_DMA32 = 13,
	PGSCAN_SKIP_NORMAL = 14,
	PGSCAN_SKIP_MOVABLE = 15,
	PGFREE = 16,
	PGACTIVATE = 17,
	PGDEACTIVATE = 18,
	PGLAZYFREE = 19,
	PGFAULT = 20,
	PGMAJFAULT = 21,
	PGLAZYFREED = 22,
	PGREFILL = 23,
	PGREUSE = 24,
	PGSTEAL_KSWAPD = 25,
	PGSTEAL_DIRECT = 26,
	PGSTEAL_KHUGEPAGED = 27,
	PGSTEAL_PROACTIVE = 28,
	PGSCAN_KSWAPD = 29,
	PGSCAN_DIRECT = 30,
	PGSCAN_KHUGEPAGED = 31,
	PGSCAN_PROACTIVE = 32,
	PGSCAN_DIRECT_THROTTLE = 33,
	PGSCAN_ANON = 34,
	PGSCAN_FILE = 35,
	PGSTEAL_ANON = 36,
	PGSTEAL_FILE = 37,
	PGSCAN_ZONE_RECLAIM_SUCCESS = 38,
	PGSCAN_ZONE_RECLAIM_FAILED = 39,
	PGINODESTEAL = 40,
	SLABS_SCANNED = 41,
	KSWAPD_INODESTEAL = 42,
	KSWAPD_LOW_WMARK_HIT_QUICKLY = 43,
	KSWAPD_HIGH_WMARK_HIT_QUICKLY = 44,
	PAGEOUTRUN = 45,
	PGROTATED = 46,
	DROP_PAGECACHE = 47,
	DROP_SLAB = 48,
	OOM_KILL = 49,
	NUMA_PTE_UPDATES = 50,
	NUMA_HUGE_PTE_UPDATES = 51,
	NUMA_HINT_FAULTS = 52,
	NUMA_HINT_FAULTS_LOCAL = 53,
	NUMA_PAGE_MIGRATE = 54,
	PGMIGRATE_SUCCESS = 55,
	PGMIGRATE_FAIL = 56,
	THP_MIGRATION_SUCCESS = 57,
	THP_MIGRATION_FAIL = 58,
	THP_MIGRATION_SPLIT = 59,
	COMPACTMIGRATE_SCANNED = 60,
	COMPACTFREE_SCANNED = 61,
	COMPACTISOLATED = 62,
	COMPACTSTALL = 63,
	COMPACTFAIL = 64,
	COMPACTSUCCESS = 65,
	KCOMPACTD_WAKE = 66,
	KCOMPACTD_MIGRATE_SCANNED = 67,
	KCOMPACTD_FREE_SCANNED = 68,
	HTLB_BUDDY_PGALLOC = 69,
	HTLB_BUDDY_PGALLOC_FAIL = 70,
	CMA_ALLOC_SUCCESS = 71,
	CMA_ALLOC_FAIL = 72,
	UNEVICTABLE_PGCULLED = 73,
	UNEVICTABLE_PGSCANNED = 74,
	UNEVICTABLE_PGRESCUED = 75,
	UNEVICTABLE_PGMLOCKED = 76,
	UNEVICTABLE_PGMUNLOCKED = 77,
	UNEVICTABLE_PGCLEARED = 78,
	UNEVICTABLE_PGSTRANDED = 79,
	THP_FAULT_ALLOC = 80,
	THP_FAULT_FALLBACK = 81,
	THP_FAULT_FALLBACK_CHARGE = 82,
	THP_COLLAPSE_ALLOC = 83,
	THP_COLLAPSE_ALLOC_FAILED = 84,
	THP_FILE_ALLOC = 85,
	THP_FILE_FALLBACK = 86,
	THP_FILE_FALLBACK_CHARGE = 87,
	THP_FILE_MAPPED = 88,
	THP_SPLIT_PAGE = 89,
	THP_SPLIT_PAGE_FAILED = 90,
	THP_DEFERRED_SPLIT_PAGE = 91,
	THP_UNDERUSED_SPLIT_PAGE = 92,
	THP_SPLIT_PMD = 93,
	THP_SCAN_EXCEED_NONE_PTE = 94,
	THP_SCAN_EXCEED_SWAP_PTE = 95,
	THP_SCAN_EXCEED_SHARED_PTE = 96,
	THP_ZERO_PAGE_ALLOC = 97,
	THP_ZERO_PAGE_ALLOC_FAILED = 98,
	THP_SWPOUT = 99,
	THP_SWPOUT_FALLBACK = 100,
	BALLOON_INFLATE = 101,
	BALLOON_DEFLATE = 102,
	BALLOON_MIGRATE = 103,
	SWAP_RA = 104,
	SWAP_RA_HIT = 105,
	SWPIN_ZERO = 106,
	SWPOUT_ZERO = 107,
	KSM_SWPIN_COPY = 108,
	COW_KSM = 109,
	NR_VM_EVENT_ITEMS = 110,
};

enum vm_fault_reason {
	VM_FAULT_OOM = 1,
	VM_FAULT_SIGBUS = 2,
	VM_FAULT_MAJOR = 4,
	VM_FAULT_HWPOISON = 16,
	VM_FAULT_HWPOISON_LARGE = 32,
	VM_FAULT_SIGSEGV = 64,
	VM_FAULT_NOPAGE = 256,
	VM_FAULT_LOCKED = 512,
	VM_FAULT_RETRY = 1024,
	VM_FAULT_FALLBACK = 2048,
	VM_FAULT_DONE_COW = 4096,
	VM_FAULT_NEEDDSYNC = 8192,
	VM_FAULT_COMPLETED = 16384,
	VM_FAULT_HINDEX_MASK = 983040,
};

enum vm_stat_item {
	NR_DIRTY_THRESHOLD = 0,
	NR_DIRTY_BG_THRESHOLD = 1,
	NR_MEMMAP_PAGES = 2,
	NR_MEMMAP_BOOT_PAGES = 3,
	NR_VM_STAT_ITEMS = 4,
};

enum vma_merge_state {
	VMA_MERGE_START = 0,
	VMA_MERGE_ERROR_NOMEM = 1,
	VMA_MERGE_NOMERGE = 2,
	VMA_MERGE_SUCCESS = 3,
};

enum vma_resv_mode {
	VMA_NEEDS_RESV = 0,
	VMA_COMMIT_RESV = 1,
	VMA_END_RESV = 2,
	VMA_ADD_RESV = 3,
	VMA_DEL_RESV = 4,
};

enum vmpressure_levels {
	VMPRESSURE_LOW = 0,
	VMPRESSURE_MEDIUM = 1,
	VMPRESSURE_CRITICAL = 2,
	VMPRESSURE_NUM_LEVELS = 3,
};

enum vmpressure_modes {
	VMPRESSURE_NO_PASSTHROUGH = 0,
	VMPRESSURE_HIERARCHY = 1,
	VMPRESSURE_LOCAL = 2,
	VMPRESSURE_NUM_MODES = 3,
};

enum vmscan_throttle_state {
	VMSCAN_THROTTLE_WRITEBACK = 0,
	VMSCAN_THROTTLE_ISOLATED = 1,
	VMSCAN_THROTTLE_NOPROGRESS = 2,
	VMSCAN_THROTTLE_CONGESTED = 3,
	NR_VMSCAN_THROTTLE = 4,
};

enum voltage_change_dir {
	NO_CHANGE = 0,
	DOWN___3 = 1,
	UP___3 = 2,
};

enum vp_vq_vector_policy {
	VP_VQ_VECTOR_POLICY_EACH = 0,
	VP_VQ_VECTOR_POLICY_SHARED_SLOW = 1,
	VP_VQ_VECTOR_POLICY_SHARED = 2,
};

enum vsc85xx_global_phy {
	VSC88XX_BASE_ADDR = 0,
};

enum wb_reason {
	WB_REASON_BACKGROUND = 0,
	WB_REASON_VMSCAN = 1,
	WB_REASON_SYNC = 2,
	WB_REASON_PERIODIC = 3,
	WB_REASON_LAPTOP_TIMER = 4,
	WB_REASON_FS_FREE_SPACE = 5,
	WB_REASON_FORKER_THREAD = 6,
	WB_REASON_FOREIGN_FLUSH = 7,
	WB_REASON_MAX = 8,
};

enum wb_resize_en {
	WB_RESIZE_EN_IDLE = 0,
	WB_RESIZE_EN_DECREASE = 1,
	WB_RESIZE_EN_INCREASE = 2,
};

enum wb_resize_hint {
	WB_RESIZE_HINT_KEEP = 0,
	WB_RESIZE_HINT_DECREASE = 1,
	WB_RESIZE_HINT_INCREASE = 2,
};

enum wb_resize_status {
	WB_RESIZE_STATUS_IDLE = 0,
	WB_RESIZE_STATUS_IN_PROGRESS = 1,
	WB_RESIZE_STATUS_COMPLETE_SUCCESS = 2,
	WB_RESIZE_STATUS_GENERAL_FAILURE = 3,
};

enum wb_stat_item {
	WB_RECLAIMABLE = 0,
	WB_WRITEBACK = 1,
	WB_DIRTIED = 2,
	WB_WRITTEN = 3,
	NR_WB_STAT_ITEMS = 4,
};

enum wb_state {
	WB_registered = 0,
	WB_writeback_running = 1,
	WB_has_dirty_io = 2,
	WB_start_all = 3,
};

enum why_no_delegation4 {
	WND4_NOT_WANTED = 0,
	WND4_CONTENTION = 1,
	WND4_RESOURCE = 2,
	WND4_NOT_SUPP_FTYPE = 3,
	WND4_WRITE_DELEG_NOT_SUPP_FTYPE = 4,
	WND4_NOT_SUPP_UPGRADE = 5,
	WND4_NOT_SUPP_DOWNGRADE = 6,
	WND4_CANCELLED = 7,
	WND4_IS_DIR = 8,
};

enum work_bits {
	WORK_STRUCT_PENDING_BIT = 0,
	WORK_STRUCT_INACTIVE_BIT = 1,
	WORK_STRUCT_PWQ_BIT = 2,
	WORK_STRUCT_LINKED_BIT = 3,
	WORK_STRUCT_FLAG_BITS = 4,
	WORK_STRUCT_COLOR_SHIFT = 4,
	WORK_STRUCT_COLOR_BITS = 4,
	WORK_STRUCT_PWQ_SHIFT = 8,
	WORK_OFFQ_FLAG_SHIFT = 4,
	WORK_OFFQ_BH_BIT = 4,
	WORK_OFFQ_FLAG_END = 5,
	WORK_OFFQ_FLAG_BITS = 1,
	WORK_OFFQ_DISABLE_SHIFT = 5,
	WORK_OFFQ_DISABLE_BITS = 16,
	WORK_OFFQ_POOL_SHIFT = 21,
	WORK_OFFQ_LEFT = 43,
	WORK_OFFQ_POOL_BITS = 31,
};

enum work_cancel_flags {
	WORK_CANCEL_DELAYED = 1,
	WORK_CANCEL_DISABLE = 2,
};

enum work_flags {
	WORK_STRUCT_PENDING = 1,
	WORK_STRUCT_INACTIVE = 2,
	WORK_STRUCT_PWQ = 4,
	WORK_STRUCT_LINKED = 8,
	WORK_STRUCT_STATIC = 0,
};

enum worker_flags {
	WORKER_DIE = 2,
	WORKER_IDLE = 4,
	WORKER_PREP = 8,
	WORKER_CPU_INTENSIVE = 64,
	WORKER_UNBOUND = 128,
	WORKER_REBOUND = 256,
	WORKER_NOT_RUNNING = 456,
};

enum worker_pool_flags {
	POOL_BH = 1,
	POOL_MANAGER_ACTIVE = 2,
	POOL_DISASSOCIATED = 4,
	POOL_BH_DRAINING = 8,
};

enum wq_affn_scope {
	WQ_AFFN_DFL = 0,
	WQ_AFFN_CPU = 1,
	WQ_AFFN_SMT = 2,
	WQ_AFFN_CACHE = 3,
	WQ_AFFN_NUMA = 4,
	WQ_AFFN_SYSTEM = 5,
	WQ_AFFN_NR_TYPES = 6,
};

enum wq_consts {
	WQ_MAX_ACTIVE = 2048,
	WQ_UNBOUND_MAX_ACTIVE = 2048,
	WQ_DFL_ACTIVE = 1024,
	WQ_DFL_MIN_ACTIVE = 8,
};

enum wq_flags {
	WQ_BH = 1,
	WQ_UNBOUND = 2,
	WQ_FREEZABLE = 4,
	WQ_MEM_RECLAIM = 8,
	WQ_HIGHPRI = 16,
	WQ_CPU_INTENSIVE = 32,
	WQ_SYSFS = 64,
	WQ_POWER_EFFICIENT = 128,
	WQ_PERCPU = 256,
	__WQ_DESTROYING = 32768,
	__WQ_DRAINING = 65536,
	__WQ_ORDERED = 131072,
	__WQ_LEGACY = 262144,
	__WQ_BH_ALLOWS = 273,
};

enum wq_internal_consts {
	NR_STD_WORKER_POOLS = 2,
	UNBOUND_POOL_HASH_ORDER = 6,
	BUSY_WORKER_HASH_ORDER = 6,
	MAX_IDLE_WORKERS_RATIO = 4,
	IDLE_WORKER_TIMEOUT = 75000,
	MAYDAY_INITIAL_TIMEOUT = 2,
	MAYDAY_INTERVAL = 25,
	CREATE_COOLDOWN = 250,
	RESCUER_NICE_LEVEL = -20,
	HIGHPRI_NICE_LEVEL = -20,
	WQ_NAME_LEN = 32,
	WORKER_ID_LEN = 42,
};

enum wq_misc_consts {
	WORK_NR_COLORS = 16,
	WORK_CPU_UNBOUND = 512,
	WORK_BUSY_PENDING = 1,
	WORK_BUSY_RUNNING = 2,
	WORKER_DESC_LEN = 32,
};

enum writeback_sync_modes {
	WB_SYNC_NONE = 0,
	WB_SYNC_ALL = 1,
};

enum xa_lock_type {
	XA_LOCK_IRQ = 1,
	XA_LOCK_BH = 2,
};

enum xb_req_state {
	xb_req_state_queued = 0,
	xb_req_state_wait_reply = 1,
	xb_req_state_got_reply = 2,
	xb_req_state_aborted = 3,
};

enum xdp_action {
	XDP_ABORTED = 0,
	XDP_DROP = 1,
	XDP_PASS = 2,
	XDP_TX = 3,
	XDP_REDIRECT = 4,
};

enum xdp_buff_flags {
	XDP_FLAGS_HAS_FRAGS = 1,
	XDP_FLAGS_FRAGS_PF_MEMALLOC = 2,
	XDP_FLAGS_FRAGS_UNREADABLE = 4,
};

enum xdp_mem_type {
	MEM_TYPE_PAGE_SHARED = 0,
	MEM_TYPE_PAGE_ORDER0 = 1,
	MEM_TYPE_PAGE_POOL = 2,
	MEM_TYPE_XSK_BUFF_POOL = 3,
	MEM_TYPE_MAX = 4,
};

enum xdp_rss_hash_type {
	XDP_RSS_L3_IPV4 = 1,
	XDP_RSS_L3_IPV6 = 2,
	XDP_RSS_L3_DYNHDR = 4,
	XDP_RSS_L4 = 8,
	XDP_RSS_L4_TCP = 16,
	XDP_RSS_L4_UDP = 32,
	XDP_RSS_L4_SCTP = 64,
	XDP_RSS_L4_IPSEC = 128,
	XDP_RSS_L4_ICMP = 256,
	XDP_RSS_TYPE_NONE = 0,
	XDP_RSS_TYPE_L2 = 0,
	XDP_RSS_TYPE_L3_IPV4 = 1,
	XDP_RSS_TYPE_L3_IPV6 = 2,
	XDP_RSS_TYPE_L3_IPV4_OPT = 5,
	XDP_RSS_TYPE_L3_IPV6_EX = 6,
	XDP_RSS_TYPE_L4_ANY = 8,
	XDP_RSS_TYPE_L4_IPV4_TCP = 25,
	XDP_RSS_TYPE_L4_IPV4_UDP = 41,
	XDP_RSS_TYPE_L4_IPV4_SCTP = 73,
	XDP_RSS_TYPE_L4_IPV4_IPSEC = 137,
	XDP_RSS_TYPE_L4_IPV4_ICMP = 265,
	XDP_RSS_TYPE_L4_IPV6_TCP = 26,
	XDP_RSS_TYPE_L4_IPV6_UDP = 42,
	XDP_RSS_TYPE_L4_IPV6_SCTP = 74,
	XDP_RSS_TYPE_L4_IPV6_IPSEC = 138,
	XDP_RSS_TYPE_L4_IPV6_ICMP = 266,
	XDP_RSS_TYPE_L4_IPV6_TCP_EX = 30,
	XDP_RSS_TYPE_L4_IPV6_UDP_EX = 46,
	XDP_RSS_TYPE_L4_IPV6_SCTP_EX = 78,
};

enum xdp_rx_metadata {
	XDP_METADATA_KFUNC_RX_TIMESTAMP = 0,
	XDP_METADATA_KFUNC_RX_HASH = 1,
	XDP_METADATA_KFUNC_RX_VLAN_TAG = 2,
	MAX_XDP_METADATA_KFUNC = 3,
};

enum xen_domain_type {
	XEN_NATIVE = 0,
	XEN_PV_DOMAIN = 1,
	XEN_HVM_DOMAIN = 2,
};

enum xen_irq_type {
	IRQT_UNBOUND = 0,
	IRQT_PIRQ = 1,
	IRQT_VIRQ = 2,
	IRQT_IPI = 3,
	IRQT_EVTCHN = 4,
};

enum xenbus_state {
	XenbusStateUnknown = 0,
	XenbusStateInitialising = 1,
	XenbusStateInitWait = 2,
	XenbusStateInitialised = 3,
	XenbusStateConnected = 4,
	XenbusStateClosing = 5,
	XenbusStateClosed = 6,
	XenbusStateReconfiguring = 7,
	XenbusStateReconfigured = 8,
};

enum xenstore_init {
	XS_UNKNOWN = 0,
	XS_PV = 1,
	XS_HVM = 2,
	XS_LOCAL = 3,
};

enum xfer_buf_dir {
	TO_XFER_BUF = 0,
	FROM_XFER_BUF = 1,
};

enum xfrm_replay_mode {
	XFRM_REPLAY_MODE_LEGACY = 0,
	XFRM_REPLAY_MODE_BMP = 1,
	XFRM_REPLAY_MODE_ESN = 2,
};

enum xgbe_an {
	XGBE_AN_READY = 0,
	XGBE_AN_PAGE_RECEIVED = 1,
	XGBE_AN_INCOMPAT_LINK = 2,
	XGBE_AN_COMPLETE = 3,
	XGBE_AN_NO_LINK = 4,
	XGBE_AN_ERROR = 5,
};

enum xgbe_an_mode {
	XGBE_AN_MODE_CL73 = 0,
	XGBE_AN_MODE_CL73_REDRV = 1,
	XGBE_AN_MODE_CL37 = 2,
	XGBE_AN_MODE_CL37_SGMII = 3,
	XGBE_AN_MODE_NONE = 4,
};

enum xgbe_conn_type {
	XGBE_CONN_TYPE_NONE = 0,
	XGBE_CONN_TYPE_SFP = 1,
	XGBE_CONN_TYPE_MDIO = 2,
	XGBE_CONN_TYPE_RSVD1 = 3,
	XGBE_CONN_TYPE_BACKPLANE = 4,
	XGBE_CONN_TYPE_MAX = 5,
};

enum xgbe_ecc_sec {
	XGBE_ECC_SEC_TX = 0,
	XGBE_ECC_SEC_RX = 1,
	XGBE_ECC_SEC_DESC = 2,
};

enum xgbe_i2c_cmd {
	XGBE_I2C_CMD_READ = 0,
	XGBE_I2C_CMD_WRITE = 1,
};

enum xgbe_int {
	XGMAC_INT_DMA_CH_SR_TI = 0,
	XGMAC_INT_DMA_CH_SR_TPS = 1,
	XGMAC_INT_DMA_CH_SR_TBU = 2,
	XGMAC_INT_DMA_CH_SR_RI = 3,
	XGMAC_INT_DMA_CH_SR_RBU = 4,
	XGMAC_INT_DMA_CH_SR_RPS = 5,
	XGMAC_INT_DMA_CH_SR_TI_RI = 6,
	XGMAC_INT_DMA_CH_SR_FBE = 7,
	XGMAC_INT_DMA_ALL = 8,
};

enum xgbe_mb_cmd {
	XGBE_MB_CMD_POWER_OFF = 0,
	XGBE_MB_CMD_SET_1G = 1,
	XGBE_MB_CMD_SET_2_5G = 2,
	XGBE_MB_CMD_SET_10G_SFI = 3,
	XGBE_MB_CMD_SET_10G_KR = 4,
	XGBE_MB_CMD_RRC = 5,
};

enum xgbe_mb_subcmd {
	XGBE_MB_SUBCMD_NONE = 0,
	XGBE_MB_SUBCMD_RX_ADAP = 1,
	XGBE_MB_SUBCMD_ACTIVE = 0,
	XGBE_MB_SUBCMD_PASSIVE_1M = 1,
	XGBE_MB_SUBCMD_PASSIVE_3M = 2,
	XGBE_MB_SUBCMD_PASSIVE_OTHER = 3,
	XGBE_MB_SUBCMD_10MBITS = 0,
	XGBE_MB_SUBCMD_100MBITS = 1,
	XGBE_MB_SUBCMD_1G_SGMII = 2,
	XGBE_MB_SUBCMD_1G_KX = 3,
};

enum xgbe_mdio_mode {
	XGBE_MDIO_MODE_NONE = 0,
	XGBE_MDIO_MODE_CL22 = 1,
	XGBE_MDIO_MODE_CL45 = 2,
};

enum xgbe_mdio_reset {
	XGBE_MDIO_RESET_NONE = 0,
	XGBE_MDIO_RESET_I2C_GPIO = 1,
	XGBE_MDIO_RESET_INT_GPIO = 2,
	XGBE_MDIO_RESET_MAX = 3,
};

enum xgbe_mode {
	XGBE_MODE_KX_1000 = 0,
	XGBE_MODE_KX_2500 = 1,
	XGBE_MODE_KR = 2,
	XGBE_MODE_X = 3,
	XGBE_MODE_SGMII_10 = 4,
	XGBE_MODE_SGMII_100 = 5,
	XGBE_MODE_SGMII_1000 = 6,
	XGBE_MODE_SFI = 7,
	XGBE_MODE_UNKNOWN = 8,
};

enum xgbe_phy_redrv_if {
	XGBE_PHY_REDRV_IF_MDIO = 0,
	XGBE_PHY_REDRV_IF_I2C = 1,
	XGBE_PHY_REDRV_IF_MAX = 2,
};

enum xgbe_phy_redrv_mode {
	XGBE_PHY_REDRV_MODE_CX = 5,
	XGBE_PHY_REDRV_MODE_SR = 9,
};

enum xgbe_phy_redrv_model {
	XGBE_PHY_REDRV_MODEL_4223 = 0,
	XGBE_PHY_REDRV_MODEL_4227 = 1,
	XGBE_PHY_REDRV_MODEL_MAX = 2,
};

enum xgbe_port_mode {
	XGBE_PORT_MODE_RSVD = 0,
	XGBE_PORT_MODE_BACKPLANE = 1,
	XGBE_PORT_MODE_BACKPLANE_2500 = 2,
	XGBE_PORT_MODE_1000BASE_T = 3,
	XGBE_PORT_MODE_1000BASE_X = 4,
	XGBE_PORT_MODE_NBASE_T = 5,
	XGBE_PORT_MODE_10GBASE_T = 6,
	XGBE_PORT_MODE_10GBASE_R = 7,
	XGBE_PORT_MODE_SFP = 8,
	XGBE_PORT_MODE_BACKPLANE_NO_AUTONEG = 9,
	XGBE_PORT_MODE_MAX = 10,
};

enum xgbe_rx {
	XGBE_RX_BPA = 0,
	XGBE_RX_XNP = 1,
	XGBE_RX_COMPLETE = 2,
	XGBE_RX_ERROR = 3,
};

enum xgbe_sfp_base {
	XGBE_SFP_BASE_UNKNOWN = 0,
	XGBE_SFP_BASE_1000_T = 1,
	XGBE_SFP_BASE_1000_SX = 2,
	XGBE_SFP_BASE_1000_LX = 3,
	XGBE_SFP_BASE_1000_CX = 4,
	XGBE_SFP_BASE_10000_SR = 5,
	XGBE_SFP_BASE_10000_LR = 6,
	XGBE_SFP_BASE_10000_LRM = 7,
	XGBE_SFP_BASE_10000_ER = 8,
	XGBE_SFP_BASE_10000_CR = 9,
};

enum xgbe_sfp_cable {
	XGBE_SFP_CABLE_UNKNOWN = 0,
	XGBE_SFP_CABLE_ACTIVE = 1,
	XGBE_SFP_CABLE_PASSIVE = 2,
	XGBE_SFP_CABLE_FIBER = 3,
};

enum xgbe_sfp_comm {
	XGBE_SFP_COMM_DIRECT = 0,
	XGBE_SFP_COMM_PCA9545 = 1,
};

enum xgbe_sfp_speed {
	XGBE_SFP_SPEED_UNKNOWN = 0,
	XGBE_SFP_SPEED_100_1000 = 1,
	XGBE_SFP_SPEED_1000 = 2,
	XGBE_SFP_SPEED_10000 = 3,
};

enum xgbe_speed {
	XGBE_SPEED_1000 = 0,
	XGBE_SPEED_2500 = 1,
	XGBE_SPEED_10000 = 2,
	XGBE_SPEEDS = 3,
};

enum xgbe_speedset {
	XGBE_SPEEDSET_1000_10000 = 0,
	XGBE_SPEEDSET_2500_10000 = 1,
};

enum xgbe_state {
	XGBE_DOWN = 0,
	XGBE_LINK_INIT = 1,
	XGBE_LINK_ERR = 2,
	XGBE_STOPPED = 3,
};

enum xgbe_xpcs_access {
	XGBE_XPCS_ACCESS_V1 = 0,
	XGBE_XPCS_ACCESS_V2 = 1,
	XGBE_XPCS_ACCESS_V3 = 2,
};

enum xgene_ahci_version {
	XGENE_AHCI_V1 = 1,
	XGENE_AHCI_V2 = 2,
};

enum xgene_cle_cmd_type {
	CLE_CMD_WR = 1,
	CLE_CMD_RD = 2,
	CLE_CMD_AVL_ADD = 8,
	CLE_CMD_AVL_DEL = 16,
	CLE_CMD_AVL_SRCH = 32,
};

enum xgene_cle_dram_type {
	PKT_RAM = 0,
	RSS_IDT = 1,
	RSS_IPV4_HASH_SKEY = 2,
	PTREE_RAM = 12,
	AVL_RAM = 13,
	DB_RAM = 14,
};

enum xgene_cle_ipv4_rss_hashtype {
	RSS_IPV4_8B = 0,
	RSS_IPV4_12B = 1,
};

enum xgene_cle_node_type {
	INV = 0,
	KN = 1,
	EWDN = 2,
	RES_NODE = 3,
};

enum xgene_cle_parser {
	PARSER0 = 0,
	PARSER1 = 1,
	PARSER2 = 2,
	PARSER_ALL = 3,
};

enum xgene_cle_prot_type {
	XGENE_CLE_TCP = 0,
	XGENE_CLE_UDP = 1,
	XGENE_CLE_ESP = 2,
	XGENE_CLE_OTHER = 3,
};

enum xgene_cle_prot_version {
	XGENE_CLE_IPV4 = 0,
};

enum xgene_cle_ptree_dbptrs {
	DB_RES_DROP = 0,
	DB_RES_DEF = 1,
	DB_RES_ACCEPT = 2,
	DB_MAX_PTRS = 3,
};

enum xgene_enet_buf_len {
	SIZE_2K = 2048,
	SIZE_4K = 4096,
	SIZE_16K = 16384,
};

enum xgene_enet_cmd {
	XGENE_ENET_WR_CMD = 2147483648,
	XGENE_ENET_RD_CMD = 1073741824,
};

enum xgene_enet_err_code {
	HBF_READ_DATA = 3,
	HBF_LL_READ = 4,
	BAD_WORK_MSG = 6,
	BUFPOOL_TIMEOUT = 15,
	INGRESS_CRC = 16,
	INGRESS_CHECKSUM = 17,
	INGRESS_TRUNC_FRAME = 18,
	INGRESS_PKT_LEN = 19,
	INGRESS_PKT_UNDER = 20,
	INGRESS_FIFO_OVERRUN = 21,
	INGRESS_CHECKSUM_COMPUTE = 26,
	ERR_CODE_INVALID = 27,
};

enum xgene_enet_id {
	XGENE_ENET1 = 1,
	XGENE_ENET2 = 2,
};

enum xgene_enet_ring_bufnum {
	RING_BUFNUM_REGULAR = 0,
	RING_BUFNUM_BUFPOOL = 32,
	RING_BUFNUM_INVALID = 33,
};

enum xgene_enet_ring_cfgsize {
	RING_CFGSIZE_512B = 0,
	RING_CFGSIZE_2KB = 1,
	RING_CFGSIZE_16KB = 2,
	RING_CFGSIZE_64KB = 3,
	RING_CFGSIZE_512KB = 4,
	RING_CFGSIZE_INVALID = 5,
};

enum xgene_enet_ring_type {
	RING_DISABLED = 0,
	RING_REGULAR = 1,
	RING_BUFPOOL = 2,
};

enum xgene_enet_rm {
	RM0 = 0,
	RM1 = 1,
	RM3 = 3,
};

enum xgene_mdio_id {
	XGENE_MDIO_RGMII = 1,
	XGENE_MDIO_XFI = 2,
};

enum xgene_phy_mode {
	MODE_SATA = 0,
	MODE_SGMII = 1,
	MODE_PCIE = 2,
	MODE_USB = 3,
	MODE_XFI = 4,
	MODE_MAX = 5,
};

enum xgene_phy_speed {
	PHY_SPEED_10 = 0,
	PHY_SPEED_100 = 1,
	PHY_SPEED_1000 = 2,
};

enum xgene_pll_type {
	PLL_TYPE_PCP = 0,
	PLL_TYPE_SOC = 1,
};

enum xgene_ring_owner {
	RING_OWNER_ETH0 = 0,
	RING_OWNER_ETH1 = 1,
	RING_OWNER_CPU = 15,
	RING_OWNER_INVALID = 16,
};

enum xhci_cancelled_td_status {
	TD_DIRTY = 0,
	TD_HALTED = 1,
	TD_CLEARING_CACHE = 2,
	TD_CLEARING_CACHE_DEFERRED = 3,
	TD_CLEARED = 4,
};

enum xhci_ep_reset_type {
	EP_HARD_RESET = 0,
	EP_SOFT_RESET = 1,
};

enum xhci_overhead_type {
	LS_OVERHEAD_TYPE = 0,
	FS_OVERHEAD_TYPE = 1,
	HS_OVERHEAD_TYPE = 2,
};

enum xhci_ring_type {
	TYPE_CTRL = 0,
	TYPE_ISOC = 1,
	TYPE_BULK = 2,
	TYPE_INTR = 3,
	TYPE_STREAM = 4,
	TYPE_COMMAND = 5,
	TYPE_EVENT = 6,
};

enum xhci_setup_dev {
	SETUP_CONTEXT_ONLY = 0,
	SETUP_CONTEXT_ADDRESS = 1,
};

enum xhci_sideband_notify_type {
	XHCI_SIDEBAND_XFER_RING_FREE = 0,
};

enum xhci_sideband_type {
	XHCI_SIDEBAND_AUDIO = 0,
	XHCI_SIDEBAND_VENDOR = 1,
};

enum xprt_transports {
	XPRT_TRANSPORT_UDP = 17,
	XPRT_TRANSPORT_TCP = 6,
	XPRT_TRANSPORT_BC_TCP = -2147483642,
	XPRT_TRANSPORT_RDMA = 256,
	XPRT_TRANSPORT_BC_RDMA = -2147483392,
	XPRT_TRANSPORT_LOCAL = 257,
	XPRT_TRANSPORT_TCP_TLS = 258,
};

enum xprt_xid_rb_cmp {
	XID_RB_EQUAL = 0,
	XID_RB_LEFT = 1,
	XID_RB_RIGHT = 2,
};

enum xprtsec_policies {
	RPC_XPRTSEC_NONE = 0,
	RPC_XPRTSEC_TLS_ANON = 1,
	RPC_XPRTSEC_TLS_X509 = 2,
};

enum xps_map_type {
	XPS_CPUS = 0,
	XPS_RXQS = 1,
	XPS_MAPS_MAX = 2,
};

enum xsd_sockmsg_type {
	XS_CONTROL = 0,
	XS_DIRECTORY = 1,
	XS_READ = 2,
	XS_GET_PERMS = 3,
	XS_WATCH = 4,
	XS_UNWATCH = 5,
	XS_TRANSACTION_START = 6,
	XS_TRANSACTION_END = 7,
	XS_INTRODUCE = 8,
	XS_RELEASE = 9,
	XS_GET_DOMAIN_PATH = 10,
	XS_WRITE = 11,
	XS_MKDIR = 12,
	XS_RM = 13,
	XS_SET_PERMS = 14,
	XS_WATCH_EVENT = 15,
	XS_ERROR = 16,
	XS_IS_DOMAIN_INTRODUCED = 17,
	XS_RESUME = 18,
	XS_SET_TARGET = 19,
	XS_RESET_WATCHES = 21,
	XS_DIRECTORY_PART = 22,
	XS_TYPE_COUNT = 23,
	XS_INVALID = 65535,
};

enum xz_check {
	XZ_CHECK_NONE = 0,
	XZ_CHECK_CRC32 = 1,
	XZ_CHECK_CRC64 = 4,
	XZ_CHECK_SHA256 = 10,
};

enum xz_mode {
	XZ_SINGLE = 0,
	XZ_PREALLOC = 1,
	XZ_DYNALLOC = 2,
};

enum xz_ret {
	XZ_OK = 0,
	XZ_STREAM_END = 1,
	XZ_UNSUPPORTED_CHECK = 2,
	XZ_MEM_ERROR = 3,
	XZ_MEMLIMIT_ERROR = 4,
	XZ_FORMAT_ERROR = 5,
	XZ_OPTIONS_ERROR = 6,
	XZ_DATA_ERROR = 7,
	XZ_BUF_ERROR = 8,
};

enum yukon_ec_rev {
	CHIP_REV_YU_EC_A1 = 0,
	CHIP_REV_YU_EC_A2 = 1,
	CHIP_REV_YU_EC_A3 = 2,
};

enum yukon_ec_u_rev {
	CHIP_REV_YU_EC_U_A0 = 1,
	CHIP_REV_YU_EC_U_A1 = 2,
	CHIP_REV_YU_EC_U_B0 = 3,
	CHIP_REV_YU_EC_U_B1 = 5,
};

enum yukon_ex_rev {
	CHIP_REV_YU_EX_A0 = 1,
	CHIP_REV_YU_EX_B0 = 2,
};

enum yukon_fe_p_rev {
	CHIP_REV_YU_FE2_A0 = 0,
};

enum yukon_prm_rev {
	CHIP_REV_YU_PRM_Z1 = 1,
	CHIP_REV_YU_PRM_A0 = 2,
};

enum yukon_supr_rev {
	CHIP_REV_YU_SU_A0 = 0,
	CHIP_REV_YU_SU_B0 = 1,
	CHIP_REV_YU_SU_B1 = 3,
};

enum yukon_xl_rev {
	CHIP_REV_YU_XL_A0 = 0,
	CHIP_REV_YU_XL_A1 = 1,
	CHIP_REV_YU_XL_A2 = 2,
	CHIP_REV_YU_XL_A3 = 3,
};

enum zone_flags {
	ZONE_BOOSTED_WATERMARK = 0,
	ZONE_RECLAIM_ACTIVE = 1,
	ZONE_BELOW_HIGH = 2,
};

enum zone_stat_item {
	NR_FREE_PAGES = 0,
	NR_FREE_PAGES_BLOCKS = 1,
	NR_ZONE_LRU_BASE = 2,
	NR_ZONE_INACTIVE_ANON = 2,
	NR_ZONE_ACTIVE_ANON = 3,
	NR_ZONE_INACTIVE_FILE = 4,
	NR_ZONE_ACTIVE_FILE = 5,
	NR_ZONE_UNEVICTABLE = 6,
	NR_ZONE_WRITE_PENDING = 7,
	NR_MLOCK = 8,
	NR_FREE_CMA_PAGES = 9,
	NR_VM_ZONE_STAT_ITEMS = 10,
};

enum zone_type {
	ZONE_DMA = 0,
	ZONE_DMA32 = 1,
	ZONE_NORMAL = 2,
	ZONE_MOVABLE = 3,
	__MAX_NR_ZONES = 4,
};

enum zone_watermarks {
	WMARK_MIN = 0,
	WMARK_LOW = 1,
	WMARK_HIGH = 2,
	WMARK_PROMO = 3,
	NR_WMARK = 4,
};

enum zynqmp_pm_request_ack {
	ZYNQMP_PM_REQUEST_ACK_NO = 1,
	ZYNQMP_PM_REQUEST_ACK_BLOCKING = 2,
	ZYNQMP_PM_REQUEST_ACK_NON_BLOCKING = 3,
};

enum zynqmp_pm_reset_action {
	PM_RESET_ACTION_RELEASE = 0,
	PM_RESET_ACTION_ASSERT = 1,
	PM_RESET_ACTION_PULSE = 2,
};

enum zynqmp_pm_shutdown_subtype {
	ZYNQMP_PM_SHUTDOWN_SUBTYPE_SUBSYSTEM = 0,
	ZYNQMP_PM_SHUTDOWN_SUBTYPE_PS_ONLY = 1,
	ZYNQMP_PM_SHUTDOWN_SUBTYPE_SYSTEM = 2,
};

enum zynqmp_pm_shutdown_type {
	ZYNQMP_PM_SHUTDOWN_TYPE_SHUTDOWN = 0,
	ZYNQMP_PM_SHUTDOWN_TYPE_RESET = 1,
	ZYNQMP_PM_SHUTDOWN_TYPE_SETSCOPE_ONLY = 2,
};

enum zynqmp_pm_suspend_reason {
	SUSPEND_POWER_REQUEST = 201,
	SUSPEND_ALERT = 202,
	SUSPEND_SYSTEM_SHUTDOWN = 203,
};

typedef _Bool bool;

typedef char acpi_bus_id[8];

typedef char acpi_device_class[20];

typedef char acpi_device_name[40];

typedef char *acpi_string;

typedef const char (* const ethnl_string_array_t)[32];

typedef int __kernel_clockid_t;

typedef int __kernel_daddr_t;

typedef int __kernel_ipc_pid_t;

typedef int __kernel_key_t;

typedef int __kernel_mqd_t;

typedef int __kernel_pid_t;

typedef int __kernel_rwf_t;

typedef int __kernel_timer_t;

typedef int __s32;

typedef int class_get_unused_fd_t;

typedef __kernel_clockid_t clockid_t;

typedef __s32 s32;

typedef s32 compat_clock_t;

typedef s32 compat_daddr_t;

typedef s32 compat_int_t;

typedef s32 compat_key_t;

typedef s32 compat_long_t;

typedef s32 compat_off_t;

typedef s32 compat_pid_t;

typedef s32 compat_ssize_t;

typedef s32 compat_timer_t;

typedef int cydp_t;

typedef s32 dma_cookie_t;

typedef int ext4_grpblk_t;

typedef int folio_walk_flags_t;

typedef int fpb_t;

typedef int fpi_t;

typedef int initcall_entry_t;

typedef s32 int32_t;

typedef int32_t key_serial_t;

typedef __kernel_key_t key_t;

typedef int mhp_t;

typedef int mm_id_mapcount_t;

typedef int mpi_size_t;

typedef __kernel_mqd_t mqd_t;

typedef s32 old_time32_t;

typedef int pci_power_t;

typedef __kernel_pid_t pid_t;

typedef int rmap_t;

typedef __kernel_rwf_t rwf_t;

typedef int suspend_state_t;

typedef __kernel_timer_t timer_t;

typedef long __kernel_long_t;

typedef __kernel_long_t __kernel_clock_t;

typedef __kernel_long_t __kernel_off_t;

typedef __kernel_long_t __kernel_old_time_t;

typedef __kernel_long_t __kernel_ptrdiff_t;

typedef __kernel_long_t __kernel_ssize_t;

typedef __kernel_long_t __kernel_suseconds_t;

typedef __kernel_clock_t clock_t;

typedef long intptr_t;

typedef long mpi_limb_signed_t;

typedef __kernel_off_t off_t;

typedef volatile long prel64_t;

typedef __kernel_ptrdiff_t ptrdiff_t;

typedef __kernel_ssize_t ssize_t;

typedef __kernel_suseconds_t suseconds_t;

typedef long long __s64;

typedef __s64 Elf64_Sxword;

typedef __s64 s64;

typedef s64 int64_t;

typedef int64_t S64;

typedef long long __kernel_loff_t;

typedef long long __kernel_time64_t;

typedef s64 compat_loff_t;

typedef s64 compat_s64;

typedef s64 ktime_t;

typedef __kernel_loff_t loff_t;

typedef long long qsize_t;

typedef __s64 time64_t;

typedef short __s16;

typedef __s16 s16;

typedef s16 int16_t;

typedef int16_t S16;

typedef signed char __s8;

typedef __s8 s8;

typedef s8 int8_t;

typedef unsigned __int128 __u128;

typedef unsigned __int128 __uint128_t;

typedef __u128 u128;

typedef u128 freelist_full_t;

typedef freelist_full_t pcp_op_T__;

typedef unsigned char __u8;

typedef __u8 u8;

typedef u8 uint8_t;

typedef uint8_t BYTE;

typedef unsigned char Byte;

typedef uint8_t U8;

typedef u8 acpi_adr_space_type;

typedef u8 blk_status_t;

typedef unsigned char cc_t;

typedef u8 dscp_t;

typedef u8 efi_bool_t;

typedef u8 enet_addr_t[6];

typedef u8 rmap_age_t;

typedef unsigned char u_char;

typedef u8 u_int8_t;

typedef unsigned char uch;

typedef const unsigned char utf8leaf_t;

typedef const unsigned char utf8trie_t;

typedef __u8 virtio_net_ctrl_ack;

typedef uint8_t xen_domain_handle_t[16];

typedef unsigned int __u32;

typedef __u32 Elf32_Addr;

typedef __u32 Elf32_Off;

typedef __u32 Elf32_Word;

typedef __u32 Elf64_Word;

typedef unsigned int FSE_CTable;

typedef unsigned int FSE_DTable;

typedef __u32 u32;

typedef u32 uint32_t;

typedef uint32_t U32;

typedef U32 HUF_DTable;

typedef unsigned int IPos;

typedef unsigned int OM_uint32;

typedef unsigned int RING_IDX;

typedef unsigned int UHWtype;

typedef uint32_t XENCONS_RING_IDX;

typedef uint32_t XENSTORE_RING_IDX;

typedef __u32 __be32;

typedef u32 __compat_gid32_t;

typedef u32 __compat_uid32_t;

typedef __u32 __dw;

typedef __u32 __hc32;

typedef u32 __kernel_dev_t;

typedef unsigned int __kernel_gid32_t;

typedef unsigned int __kernel_gid_t;

typedef unsigned int __kernel_mode_t;

typedef unsigned int __kernel_old_dev_t;

typedef unsigned int __kernel_uid32_t;

typedef unsigned int __kernel_uid_t;

typedef __u32 __le32;

typedef unsigned int __poll_t;

typedef __u32 __portpair;

typedef __u32 __rpmsg32;

typedef __u32 __virtio32;

typedef __u32 __wsum;

typedef u32 acpi_event_status;

typedef u32 acpi_mutex_handle;

typedef u32 acpi_name;

typedef u32 acpi_object_type;

typedef u32 acpi_rsdesc_size;

typedef u32 acpi_status;

typedef unsigned int acr_flags_t;

typedef u32 arm_v7s_iopte;

typedef unsigned int autofs_wqt_t;

typedef unsigned int blk_features_t;

typedef unsigned int blk_flags_t;

typedef unsigned int blk_insert_t;

typedef unsigned int blk_mode_t;

typedef __u32 blk_mq_req_flags_t;

typedef __u32 blk_opf_t;

typedef unsigned int blk_qc_t;

typedef u32 compat_aio_context_t;

typedef u32 compat_caddr_t;

typedef u32 compat_dev_t;

typedef unsigned int compat_elf_greg_t;

typedef compat_elf_greg_t compat_elf_gregset_t[18];

typedef u32 compat_ino_t;

typedef u32 compat_old_sigset_t;

typedef u32 compat_sigset_word;

typedef u32 compat_size_t;

typedef u32 compat_uint_t;

typedef u32 compat_ulong_t;

typedef u32 compat_uptr_t;

typedef u32 cppi5_tr_flags_t;

typedef u32 depot_flags_t;

typedef u32 depot_stack_handle_t;

typedef __kernel_dev_t dev_t;

typedef uint32_t drbg_flag_t;

typedef u32 efi_cc_event_algorithm_bitmap_t;

typedef u32 efi_cc_event_log_bitmap_t;

typedef u32 efi_cc_event_log_format_t;

typedef u32 efi_cc_mr_index_t;

typedef u32 efi_tcg2_event_log_format;

typedef u32 errseq_t;

typedef uint32_t event_word_t;

typedef uint32_t evtchn_port_t;

typedef unsigned int ext4_group_t;

typedef __u32 ext4_lblk_t;

typedef __be32 fdt32_t;

typedef unsigned int fgf_t;

typedef unsigned int fmode_t;

typedef unsigned int fop_flags_t;

typedef unsigned int gfp_t;

typedef __kernel_gid32_t gid_t;

typedef uint32_t grant_handle_t;

typedef uint32_t grant_ref_t;

typedef unsigned int ioasid_t;

typedef unsigned int iov_iter_extraction_t;

typedef unsigned int isolate_mode_t;

typedef unsigned int kasan_vmalloc_flags_t;

typedef uint32_t key_perm_t;

typedef unsigned int mm_id_t;

typedef unsigned int mmc_pm_flag_t;

typedef __kernel_mode_t mode_t;

typedef u32 nlink_t;

typedef u32 note_buf_t[106];

typedef __u32 nvme_submit_flags_t;

typedef unsigned int pci_channel_state_t;

typedef unsigned int pci_ers_result_t;

typedef unsigned int pgtbl_mod_mask;

typedef u32 phandle;

typedef unsigned int pipe_index_t;

typedef unsigned int pkvm_handle_t;

typedef __kernel_uid32_t projid_t;

typedef __kernel_uid32_t qid_t;

typedef U32 rankValCol_t[13];

typedef __u32 req_flags_t;

typedef u32 rpc_authflavor_t;

typedef __be32 rpc_fraghdr;

typedef unsigned int sk_buff_data_t;

typedef unsigned int slab_flags_t;

typedef unsigned int speed_t;

typedef unsigned int t_key;

typedef unsigned int tcflag_t;

typedef unsigned int tid_t;

typedef unsigned int uInt;

typedef unsigned int u_int;

typedef u32 u_int32_t;

typedef __kernel_uid32_t uid_t;

typedef unsigned int uint;

typedef u32 unicode_t;

typedef unsigned int upstat_t;

typedef u32 usb_port_location_t;

typedef unsigned int vm_fault_t;

typedef unsigned int xa_mark_t;

typedef u32 xdp_features_t;

typedef unsigned int zap_flags_t;

typedef unsigned long __kernel_ulong_t;

typedef __kernel_ulong_t __kernel_size_t;

typedef __kernel_size_t size_t;

typedef size_t BitContainerType;

typedef size_t HUF_CElt;

typedef unsigned long mpi_limb_t;

typedef mpi_limb_t UWtype;

typedef __kernel_ulong_t aio_context_t;

typedef unsigned long cycles_t;

typedef unsigned long efi_status_t;

typedef unsigned long elf_greg_t;

typedef elf_greg_t elf_gregset_t[34];

typedef unsigned long hva_t;

typedef __kernel_ulong_t ino_t;

typedef unsigned long irq_hw_number_t;

typedef unsigned long kernel_ulong_t;

typedef unsigned long kimage_entry_t;

typedef mpi_limb_t *mpi_ptr_t;

typedef unsigned long netmem_ref;

typedef unsigned long old_sigset_t;

typedef unsigned long pte_marker;

typedef unsigned long uLong;

typedef unsigned long u_long;

typedef unsigned long uintptr_t;

typedef unsigned long ulg;

typedef unsigned long ulong;

typedef uintptr_t uptrval;

typedef unsigned long vm_flags_t;

typedef unsigned long long __u64;

typedef __u64 Elf64_Addr;

typedef __u64 Elf64_Off;

typedef __u64 Elf64_Xword;

typedef __u64 u64;

typedef u64 uint64_t;

typedef uint64_t U64;

typedef U64 ZSTD_VecMask;

typedef __u64 __addrpair;

typedef __u64 __be64;

typedef __u64 __le64;

typedef __u64 __virtio64;

typedef u64 acpi_bus_address;

typedef u64 acpi_integer;

typedef u64 acpi_io_address;

typedef u64 acpi_physical_address;

typedef u64 acpi_size;

typedef u64 arm_lpae_iopte;

typedef u64 async_cookie_t;

typedef __u64 blist_flags_t;

typedef u64 blkcnt_t;

typedef uint64_t blkif_sector_t;

typedef u64 clientid4;

typedef u64 compat_u64;

typedef u64 dma_addr_t;

typedef u64 efi_physical_addr_t;

typedef unsigned long long ext4_fsblk_t;

typedef __be64 fdt64_t;

typedef u64 gfn_t;

typedef u64 gpa_t;

typedef u64 hfn_t;

typedef u64 hpa_t;

typedef u64 io_req_flags_t;

typedef hfn_t kvm_pfn_t;

typedef u64 kvm_pte_t;

typedef kvm_pte_t *kvm_pteref_t;

typedef kvm_pte_t __attribute__((btf_type_tag("rcu"))) *kvm_pteref_t___2;

typedef unsigned long long llu;

typedef u64 netdev_features_t;

typedef u64 ptdesc_t;

typedef ptdesc_t p4dval_t;

typedef u64 pci_bus_addr_t;

typedef uint64_t xen_ulong_t;

typedef ptdesc_t pgdval_t;

typedef u64 phys_addr_t;

typedef u64 phys_cpuid_t;

typedef ptdesc_t pmdval_t;

typedef ptdesc_t pteval_t;

typedef ptdesc_t pudval_t;

typedef phys_addr_t resource_size_t;

typedef u64 sci_t;

typedef u64 sector_t;

typedef __u64 timeu64_t;

typedef u64 upf_t;

typedef uint64_t xen_pfn_t;

typedef uint64_t vli_type;

typedef unsigned short __u16;

typedef __u16 Elf32_Half;

typedef __u16 Elf64_Half;

typedef unsigned short ush;

typedef ush Pos;

typedef __u16 u16;

typedef u16 uint16_t;

typedef uint16_t U16;

typedef __u16 __be16;

typedef u16 __compat_gid16_t;

typedef u16 __compat_gid_t;

typedef u16 __compat_uid16_t;

typedef u16 __compat_uid_t;

typedef __u16 __hc16;

typedef unsigned short __kernel_gid16_t;

typedef unsigned short __kernel_old_gid_t;

typedef unsigned short __kernel_old_uid_t;

typedef unsigned short __kernel_sa_family_t;

typedef unsigned short __kernel_uid16_t;

typedef __u16 __le16;

typedef __u16 __rpmsg16;

typedef __u16 __sum16;

typedef __u16 __virtio16;

typedef u16 acpi_owner_id;

typedef u16 acpi_rs_length;

typedef uint16_t blkif_vdev_t;

typedef __u16 comp_t;

typedef u16 compat_ipc_pid_t;

typedef u16 compat_mode_t;

typedef u16 compat_ushort_t;

typedef uint16_t domid_t;

typedef u16 efi_char16_t;

typedef __kernel_gid16_t gid16_t;

typedef uint16_t grant_status_t;

typedef __kernel_old_gid_t old_gid_t;

typedef __kernel_old_uid_t old_uid_t;

typedef unsigned short pci_bus_flags_t;

typedef unsigned short pci_dev_flags_t;

typedef __kernel_sa_family_t sa_family_t;

typedef u16 u_int16_t;

typedef unsigned short u_short;

typedef u16 ucs2_char_t;

typedef __kernel_uid16_t uid16_t;

typedef __u16 uio_meta_flags_t;

typedef unsigned short umode_t;

typedef unsigned short ushort;

typedef u16 wchar_t;

typedef struct {
	BitContainerType bitContainer;
	unsigned int bitPos;
	char *startPtr;
	char *ptr;
	char *endPtr;
} BIT_CStream_t;

typedef struct {
	BitContainerType bitContainer;
	unsigned int bitsConsumed;
	const char *ptr;
	const char *start;
	const char *limitPtr;
} BIT_DStream_t;

typedef struct {
	size_t nbSequences;
	size_t blockSize;
	size_t litSize;
} BlockSummary;

typedef struct {
	BYTE maxTableLog;
	BYTE tableType;
	BYTE tableLog;
	BYTE reserved;
} DTableDesc;

typedef struct {
	size_t estLitSize;
	size_t estBlockSize;
} EstimatedBlockSize;

typedef struct {
	unsigned int events[1024];
	size_t nbEvents;
} Fingerprint;

typedef struct {
	Fingerprint pastEvents;
	Fingerprint newEvents;
} FPStats;

typedef struct {
	ptrdiff_t value;
	const void *stateTable;
	const void *symbolTT;
	unsigned int stateLog;
} FSE_CState_t;

typedef struct {
	size_t state;
	const void *table;
} FSE_DState_t;

typedef struct {
	U16 tableLog;
	U16 fastMode;
} FSE_DTableHeader;

typedef struct {
	short ncount[256];
} FSE_DecompressWksp;

typedef struct {
	unsigned short newState;
	unsigned char symbol;
	unsigned char nbBits;
} FSE_decode_t;

typedef struct {
	int deltaFindState;
	U32 deltaNbBits;
} FSE_symbolCompressionTransform;

typedef struct {
	size_t bitContainer[2];
	size_t bitPos[2];
	BYTE *startPtr;
	BYTE *ptr;
	BYTE *endPtr;
} HUF_CStream_t;

typedef struct {
	BYTE tableLog;
	BYTE maxSymbolValue;
	BYTE unused[6];
} HUF_CTableHeader;

typedef struct {
	FSE_CTable CTable[59];
	U32 scratchBuffer[41];
	unsigned int count[13];
	S16 norm[13];
} HUF_CompressWeightsWksp;

typedef struct {
	BYTE nbBits;
	BYTE byte;
} HUF_DEltX1;

typedef struct {
	U16 sequence;
	BYTE nbBits;
	BYTE length;
} HUF_DEltX2;

typedef struct {
	const BYTE *ip[4];
	BYTE *op[4];
	U64 bits[4];
	const void *dt;
	const BYTE *ilowest;
	BYTE *oend;
	const BYTE *iend[4];
} HUF_DecompressFastArgs;

typedef struct {
	U32 rankVal[13];
	U32 rankStart[13];
	U32 statsWksp[219];
	BYTE symbols[256];
	BYTE huffWeight[256];
} HUF_ReadDTableX1_Workspace;

typedef struct {
	BYTE symbol;
} sortedSymbol_t;

typedef struct {
	rankValCol_t rankVal[12];
	U32 rankStats[13];
	U32 rankStart0[15];
	sortedSymbol_t sortedSymbol[256];
	BYTE weightList[256];
	U32 calleeWksp[219];
} HUF_ReadDTableX2_Workspace;

typedef struct {
	HUF_CompressWeightsWksp wksp;
	BYTE bitsToWeight[13];
	BYTE huffWeight[255];
} HUF_WriteCTableWksp;

struct nodeElt_s {
	U32 count;
	U16 parent;
	BYTE byte;
	BYTE nbBits;
};

typedef struct nodeElt_s nodeElt;

typedef nodeElt huffNodeTable[512];

typedef struct {
	U16 base;
	U16 curr;
} rankPos;

typedef struct {
	huffNodeTable huffNodeTbl;
	rankPos rankPosition[192];
} HUF_buildCTable_wksp_tables;

typedef struct {
	unsigned int count[256];
	HUF_CElt CTable[257];
	union {
		HUF_buildCTable_wksp_tables buildCTable_wksp;
		HUF_WriteCTableWksp writeCTable_wksp;
		U32 hist_wksp[1024];
	} wksps;
} HUF_compress_tables_t;

struct buffer_head;

typedef struct {
	__le32 *p;
	__le32 key;
	struct buffer_head *bh;
} Indirect;

typedef struct {
	const uint8_t *externalDict;
	size_t extDictSize;
	const uint8_t *prefixEnd;
	size_t prefixSize;
} LZ4_streamDecode_t_internal;

typedef union {
	unsigned long long table[4];
	LZ4_streamDecode_t_internal internal_donotuse;
} LZ4_streamDecode_t;

typedef struct {
	U32 offset;
	U32 litLength;
	U32 matchLength;
} rawSeq;

typedef struct {
	rawSeq *seq;
	size_t pos;
	size_t posInSequence;
	size_t size;
	size_t capacity;
} RawSeqStore_t;

struct folio;

typedef struct {
	struct folio *v;
} Sector;

typedef struct {
	unsigned int offset;
	unsigned int litLength;
	unsigned int matchLength;
	unsigned int rep;
} ZSTD_Sequence;

typedef struct {
	int collectSequences;
	ZSTD_Sequence *seqStart;
	size_t seqIndex;
	size_t maxSequences;
} SeqCollector;

struct SeqDef_s;

typedef struct SeqDef_s SeqDef;

typedef struct {
	SeqDef *sequencesStart;
	SeqDef *sequences;
	BYTE *litStart;
	BYTE *lit;
	BYTE *llCode;
	BYTE *mlCode;
	BYTE *ofCode;
	size_t maxNbSeq;
	size_t maxNbLit;
	ZSTD_longLengthType_e longLengthType;
	U32 longLengthPos;
} SeqStore_t;

typedef struct {
	S16 norm[53];
	U32 wksp[285];
} ZSTD_BuildCTableWksp;

struct ZSTD_DDict_s;

typedef struct ZSTD_DDict_s ZSTD_DDict;

typedef struct {
	const ZSTD_DDict **ddictPtrTable;
	size_t ddictPtrTableSize;
	size_t ddictPtrCount;
} ZSTD_DDictHashSet;

typedef struct {
	unsigned long long frameContentSize;
	unsigned long long windowSize;
	unsigned int blockSizeMax;
	ZSTD_FrameType_e frameType;
	unsigned int headerSize;
	unsigned int dictID;
	unsigned int checksumFlag;
	unsigned int _reserved1;
	unsigned int _reserved2;
} ZSTD_FrameHeader;

typedef struct {
	unsigned int longOffsetShare;
	unsigned int maxNbAdditionalBits;
} ZSTD_OffsetInfo;

typedef struct {
	U32 litLength;
	U32 matchLength;
} ZSTD_SequenceLength;

typedef struct {
	U32 idx;
	U32 posInSequence;
	size_t posInSrc;
} ZSTD_SequencePosition;

typedef struct {
	SymbolEncodingType_e hType;
	BYTE hufDesBuffer[128];
	size_t hufDesSize;
} ZSTD_hufCTablesMetadata_t;

typedef struct {
	SymbolEncodingType_e llType;
	SymbolEncodingType_e ofType;
	SymbolEncodingType_e mlType;
	BYTE fseTablesBuffer[133];
	size_t fseTablesSize;
	size_t lastCountSize;
} ZSTD_fseCTablesMetadata_t;

typedef struct {
	ZSTD_hufCTablesMetadata_t hufMetadata;
	ZSTD_fseCTablesMetadata_t fseMetadata;
} ZSTD_entropyCTablesMetadata_t;

typedef struct {
	SeqStore_t fullSeqStoreChunk;
	SeqStore_t firstHalfSeqStore;
	SeqStore_t secondHalfSeqStore;
	SeqStore_t currSeqStore;
	SeqStore_t nextSeqStore;
	U32 partitions[196];
	ZSTD_entropyCTablesMetadata_t entropyMetadata;
} ZSTD_blockSplitCtx;

typedef struct {
	HUF_CElt CTable[257];
	HUF_repeat repeatMode;
} ZSTD_hufCTables_t;

typedef struct {
	FSE_CTable offcodeCTable[193];
	FSE_CTable matchlengthCTable[363];
	FSE_CTable litlengthCTable[329];
	FSE_repeat offcode_repeatMode;
	FSE_repeat matchlength_repeatMode;
	FSE_repeat litlength_repeatMode;
} ZSTD_fseCTables_t;

typedef struct {
	ZSTD_hufCTables_t huf;
	ZSTD_fseCTables_t fse;
} ZSTD_entropyCTables_t;

typedef struct {
	ZSTD_entropyCTables_t entropy;
	U32 rep[3];
} ZSTD_compressedBlockState_t;

typedef struct {
	const BYTE *nextSrc;
	const BYTE *base;
	const BYTE *dictBase;
	U32 dictLimit;
	U32 lowLimit;
	U32 nbOverflowCorrections;
} ZSTD_window_t;

typedef struct {
	U32 off;
	U32 len;
} ZSTD_match_t;

typedef struct {
	int price;
	U32 off;
	U32 mlen;
	U32 litlen;
	U32 rep[3];
} ZSTD_optimal_t;

typedef struct {
	unsigned int *litFreq;
	unsigned int *litLengthFreq;
	unsigned int *matchLengthFreq;
	unsigned int *offCodeFreq;
	ZSTD_match_t *matchTable;
	ZSTD_optimal_t *priceTable;
	U32 litSum;
	U32 litLengthSum;
	U32 matchLengthSum;
	U32 offCodeSum;
	U32 litSumBasePrice;
	U32 litLengthSumBasePrice;
	U32 matchLengthSumBasePrice;
	U32 offCodeSumBasePrice;
	ZSTD_OptPrice_e priceType;
	const ZSTD_entropyCTables_t *symbolCosts;
	ZSTD_ParamSwitch_e literalCompressionMode;
} optState_t;

typedef struct {
	unsigned int windowLog;
	unsigned int chainLog;
	unsigned int hashLog;
	unsigned int searchLog;
	unsigned int minMatch;
	unsigned int targetLength;
	ZSTD_strategy strategy;
} ZSTD_compressionParameters;

struct ZSTD_MatchState_t;

typedef struct ZSTD_MatchState_t ZSTD_MatchState_t;

struct ZSTD_MatchState_t {
	ZSTD_window_t window;
	U32 loadedDictEnd;
	U32 nextToUpdate;
	U32 hashLog3;
	U32 rowHashLog;
	BYTE *tagTable;
	U32 hashCache[8];
	U64 hashSalt;
	U32 hashSaltEntropy;
	U32 *hashTable;
	U32 *hashTable3;
	U32 *chainTable;
	int forceNonContiguous;
	int dedicatedDictSearch;
	optState_t opt;
	const ZSTD_MatchState_t *dictMatchState;
	ZSTD_compressionParameters cParams;
	const RawSeqStore_t *ldmSeqStore;
	int prefetchCDictTables;
	int lazySkipping;
};

typedef struct {
	ZSTD_compressedBlockState_t *prevCBlock;
	ZSTD_compressedBlockState_t *nextCBlock;
	ZSTD_MatchState_t matchState;
} ZSTD_blockState_t;

typedef struct {
	size_t error;
	int lowerBound;
	int upperBound;
} ZSTD_bounds;

typedef void * (*ZSTD_allocFunction)(void *, size_t);

typedef void (*ZSTD_freeFunction)(void *, void *);

typedef struct {
	ZSTD_allocFunction customAlloc;
	ZSTD_freeFunction customFree;
	void *opaque;
} ZSTD_customMem;

typedef struct {
	void *workspace;
	void *workspaceEnd;
	void *objectEnd;
	void *tableEnd;
	void *tableValidEnd;
	void *allocStart;
	void *initOnceStart;
	BYTE allocFailed;
	int workspaceOversizedDuration;
	ZSTD_cwksp_alloc_phase_e phase;
	ZSTD_cwksp_static_alloc_e isStatic;
} ZSTD_cwksp;

typedef struct {
	U16 nextState;
	BYTE nbAdditionalBits;
	BYTE nbBits;
	U32 baseValue;
} ZSTD_seqSymbol;

typedef struct {
	ZSTD_seqSymbol LLTable[513];
	ZSTD_seqSymbol OFTable[257];
	ZSTD_seqSymbol MLTable[513];
	HUF_DTable hufTable[4097];
	U32 rep[3];
	U32 workspace[157];
} ZSTD_entropyDTables_t;

typedef struct {
	int contentSizeFlag;
	int checksumFlag;
	int noDictIDFlag;
} ZSTD_frameParameters;

typedef struct {
	unsigned long long ingested;
	unsigned long long consumed;
	unsigned long long produced;
	unsigned long long flushed;
	unsigned int currentJobID;
	unsigned int nbActiveWorkers;
} ZSTD_frameProgression;

typedef struct {
	size_t nbBlocks;
	size_t compressedSize;
	unsigned long long decompressedBound;
} ZSTD_frameSizeInfo;

typedef struct {
	size_t state;
	const ZSTD_seqSymbol *table;
} ZSTD_fseState;

struct ZSTD_CDict_s;

typedef struct ZSTD_CDict_s ZSTD_CDict;

typedef struct {
	void *dictBuffer;
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
	ZSTD_CDict *cdict;
} ZSTD_localDict;

typedef struct {
	RawSeqStore_t seqStore;
	U32 startPosInBlock;
	U32 endPosInBlock;
	U32 offset;
} ZSTD_optLdm_t;

typedef struct {
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
} ZSTD_parameters;

typedef struct {
	U32 fastMode;
	U32 tableLog;
} ZSTD_seqSymbol_header;

typedef struct {
	U32 LLtype;
	U32 Offtype;
	U32 MLtype;
	size_t size;
	size_t lastCountSize;
	int longOffsets;
} ZSTD_symbolEncodingTypeStats_t;

typedef struct {
	union {
		char *p;
		uint64_t q;
	};
} __guest_handle_char;

typedef struct {
	union {
		evtchn_port_t *p;
		uint64_t q;
	};
} __guest_handle_evtchn_port_t;

typedef struct {
	union {
		int *p;
		uint64_t q;
	};
} __guest_handle_int;

typedef struct {
	union {
		unsigned char *p;
		uint64_t q;
	};
} __guest_handle_uchar;

typedef struct {
	union {
		uint32_t *p;
		uint64_t q;
	};
} __guest_handle_uint32_t;

typedef struct {
	union {
		uint64_t *p;
		uint64_t q;
	};
} __guest_handle_uint64_t;

struct vcpu_runstate_info;

typedef struct {
	union {
		struct vcpu_runstate_info *p;
		uint64_t q;
	};
} __guest_handle_vcpu_runstate_info;

typedef struct {
	union {
		void *p;
		uint64_t q;
	};
} __guest_handle_void;

typedef struct {
	union {
		xen_pfn_t *p;
		uint64_t q;
	};
} __guest_handle_xen_pfn_t;

struct xen_processor_csd;

typedef struct {
	union {
		struct xen_processor_csd *p;
		uint64_t q;
	};
} __guest_handle_xen_processor_csd;

struct xen_processor_cx;

typedef struct {
	union {
		struct xen_processor_cx *p;
		uint64_t q;
	};
} __guest_handle_xen_processor_cx;

struct xen_processor_px;

typedef struct {
	union {
		struct xen_processor_px *p;
		uint64_t q;
	};
} __guest_handle_xen_processor_px;

typedef struct {
	union {
		xen_ulong_t *p;
		uint64_t q;
	};
} __guest_handle_xen_ulong_t;

typedef struct {
	unsigned long fds_bits[16];
} __kernel_fd_set;

typedef struct {
	int val[2];
} __kernel_fsid_t;

typedef struct {
	U32 tableTime;
	U32 decode256Time;
} algo_time_t;

typedef struct {
	s64 counter;
} atomic64_t;

typedef atomic64_t atomic_long_t;

typedef struct {
	int counter;
} atomic_t;

typedef struct {
	__be64 a;
	__be64 b;
} be128;

typedef struct {
	blockType_e blockType;
	U32 lastBlock;
	U32 origSize;
} blockProperties_t;

typedef struct {
	union {
		void *kernel;
		void __attribute__((btf_type_tag("user"))) *user;
	};
	bool is_kernel: 1;
} sockptr_t;

typedef sockptr_t bpfptr_t;

struct permanent_flags_t {
	__be16 tag;
	u8 disable;
	u8 ownership;
	u8 deactivated;
	u8 readPubek;
	u8 disableOwnerClear;
	u8 allowMaintenance;
	u8 physicalPresenceLifetimeLock;
	u8 physicalPresenceHWEnable;
	u8 physicalPresenceCMDEnable;
	u8 CEKPUsed;
	u8 TPMpost;
	u8 TPMpostLock;
	u8 FIPS;
	u8 operator;
	u8 enableRevokeEK;
	u8 nvLocked;
	u8 readSRKPub;
	u8 tpmEstablished;
	u8 maintenanceDone;
	u8 disableFullDALogicInfo;
};

struct stclear_flags_t {
	__be16 tag;
	u8 deactivated;
	u8 disableForceClear;
	u8 physicalPresence;
	u8 physicalPresenceLock;
	u8 bGlobalLock;
} __attribute__((packed));

struct tpm1_version {
	u8 major;
	u8 minor;
	u8 rev_major;
	u8 rev_minor;
};

struct tpm1_version2 {
	__be16 tag;
	struct tpm1_version version;
};

struct timeout_t {
	__be32 a;
	__be32 b;
	__be32 c;
	__be32 d;
};

struct duration_t {
	__be32 tpm_short;
	__be32 tpm_medium;
	__be32 tpm_long;
};

typedef union {
	struct permanent_flags_t perm_flags;
	struct stclear_flags_t stclear_flags;
	__u8 owned;
	__be32 num_pcrs;
	struct tpm1_version version1;
	struct tpm1_version2 version2;
	__be32 manufacturer_id;
	struct timeout_t timeout;
	struct duration_t duration;
} cap_t;

typedef struct {
	unsigned int interval;
	unsigned int timeout;
} cisco_proto;

typedef struct {
	void *lock;
} class_console_lock_t;

struct raw_spinlock;

typedef struct raw_spinlock raw_spinlock_t;

typedef struct {
	raw_spinlock_t *lock;
	raw_spinlock_t *lock2;
} class_double_raw_spinlock_t;

struct rq;

typedef struct {
	struct rq *lock;
	struct rq *lock2;
} class_double_rq_lock_t;

struct gpio_generic_chip;

typedef struct {
	struct gpio_generic_chip *lock;
	unsigned long flags;
} class_gpio_generic_lock_irqsave_t;

typedef struct {
	void *lock;
} class_irq_t;

struct irq_desc;

typedef struct {
	struct irq_desc *lock;
	unsigned long flags;
	bool bus;
} class_irqdesc_lock_t;

typedef struct {
	void *lock;
	unsigned long flags;
} class_irqsave_t;

typedef struct {
	void *lock;
} class_mount_locked_reader_t;

typedef struct {
	void *lock;
} class_mount_writer_t;

struct device;

typedef struct {
	struct device *lock;
} class_msi_descs_lock_t;

typedef struct {
	void *lock;
} class_namespace_excl_t;

typedef struct {
	void *lock;
} class_namespace_shared_t;

typedef struct {
	void *lock;
} class_pagefault_t;

struct perf_cpu_context;

struct perf_event_context;

typedef struct {
	struct perf_cpu_context *cpuctx;
	struct perf_event_context *ctx;
} class_perf_ctx_lock_t;

typedef struct {
	void *lock;
} class_preempt_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_irq_t;

typedef struct {
	raw_spinlock_t *lock;
	unsigned long flags;
} class_raw_spinlock_irqsave_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_t;

typedef struct {
	void *lock;
} class_rcu_t;

typedef struct {
	void *lock;
} class_rcu_tasks_trace_t;

struct qspinlock {
	union {
		atomic_t val;
		struct {
			u8 locked;
			u8 pending;
		};
		struct {
			u16 locked_pending;
			u16 tail;
		};
	};
};

typedef struct qspinlock arch_spinlock_t;

struct qrwlock {
	union {
		atomic_t cnts;
		struct {
			u8 wlocked;
			u8 __lstate[3];
		};
	};
	arch_spinlock_t wait_lock;
};

typedef struct qrwlock arch_rwlock_t;

typedef struct {
	arch_rwlock_t raw_lock;
} rwlock_t;

typedef struct {
	rwlock_t *lock;
	unsigned long flags;
} class_read_lock_irqsave_t;

typedef struct {
	rwlock_t *lock;
} class_read_lock_t;

struct pin_cookie {};

struct rq_flags {
	unsigned long flags;
	struct pin_cookie cookie;
	unsigned int clock_update_flags;
};

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irq_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irqsave_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_t;

struct spinlock;

typedef struct spinlock spinlock_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_bh_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_irq_t;

typedef struct {
	spinlock_t *lock;
	unsigned long flags;
} class_spinlock_irqsave_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_t;

struct srcu_struct;

typedef struct {
	struct srcu_struct *lock;
	int idx;
} class_srcu_t;

struct task_struct;

typedef struct {
	struct task_struct *lock;
	struct rq *rq;
	struct rq_flags rf;
} class_task_rq_lock_t;

struct tty_struct;

typedef struct {
	struct tty_struct *lock;
} class_tty_port_tty_t;

struct uart_port;

typedef struct {
	struct uart_port *lock;
	unsigned long flags;
} class_uart_port_lock_irqsave_t;

typedef struct {
	rwlock_t *lock;
} class_write_lock_irq_t;

typedef struct {
	rwlock_t *lock;
	unsigned long flags;
} class_write_lock_irqsave_t;

typedef struct {
	rwlock_t *lock;
} class_write_lock_t;

typedef struct {
	unsigned char op;
	unsigned char bits;
	unsigned short val;
} code;

typedef __kernel_fsid_t compat_fsid_t;

typedef struct {
	compat_sigset_word sig[2];
} compat_sigset_t;

typedef struct {
	unsigned long bits[1];
} dma_cap_mask_t;

typedef struct {
	u64 length;
	u64 data;
} efi_capsule_block_desc_t;

typedef struct {
	__u8 b[16];
} guid_t;

typedef guid_t efi_guid_t;

typedef struct {
	efi_guid_t guid;
	u32 headersize;
	u32 flags;
	u32 imagesize;
} efi_capsule_header_t;

typedef struct {
	u8 major;
	u8 minor;
} efi_cc_version_t;

typedef struct {
	u8 type;
	u8 sub_type;
} efi_cc_type_t;

typedef struct {
	u8 size;
	efi_cc_version_t structure_version;
	efi_cc_version_t protocol_version;
	efi_cc_event_algorithm_bitmap_t hash_algorithm_bitmap;
	efi_cc_event_log_bitmap_t supported_event_logs;
	efi_cc_type_t cc_type;
} efi_cc_boot_service_cap_t;

typedef struct {
	efi_guid_t guid;
	u32 table;
} efi_config_table_32_t;

typedef struct {
	efi_guid_t guid;
	u64 table;
} efi_config_table_64_t;

typedef union {
	struct {
		efi_guid_t guid;
		void *table;
	};
	efi_config_table_32_t mixed_mode;
} efi_config_table_t;

typedef struct {
	efi_guid_t guid;
	unsigned long *ptr;
	const char name[16];
} efi_config_table_type_t;

typedef struct {
	u16 year;
	u8 month;
	u8 day;
	u8 hour;
	u8 minute;
	u8 second;
	u8 pad1;
	u32 nanosecond;
	s16 timezone;
	u8 daylight;
	u8 pad2;
} efi_time_t;

typedef struct {
	u64 size;
	u64 file_size;
	u64 phys_size;
	efi_time_t create_time;
	efi_time_t last_access_time;
	efi_time_t modification_time;
	__u64 attribute;
	efi_char16_t filename[0];
} efi_file_info_t;

typedef struct {
	u32 red_mask;
	u32 green_mask;
	u32 blue_mask;
	u32 reserved_mask;
} efi_pixel_bitmask_t;

typedef struct {
	u32 version;
	u32 horizontal_resolution;
	u32 vertical_resolution;
	int pixel_format;
	efi_pixel_bitmask_t pixel_information;
	u32 pixels_per_scan_line;
} efi_graphics_output_mode_info_t;

typedef struct {
	u16 scan_code;
	efi_char16_t unicode_char;
} efi_input_key_t;

typedef struct {
	u32 attributes;
	u16 file_path_list_length;
	u8 variable_data[0];
} __attribute__((packed)) efi_load_option_t;

struct efi_generic_dev_path;

typedef struct efi_generic_dev_path efi_device_path_protocol_t;

typedef struct {
	u32 attributes;
	u16 file_path_list_length;
	const efi_char16_t *description;
	const efi_device_path_protocol_t *file_path_list;
	u32 optional_data_size;
	const void *optional_data;
} efi_load_option_unpacked_t;

typedef void *efi_handle_t;

typedef struct {
	u64 signature;
	u32 revision;
	u32 headersize;
	u32 crc32;
	u32 reserved;
} efi_table_hdr_t;

typedef struct {
	u32 resolution;
	u32 accuracy;
	u8 sets_to_zero;
} efi_time_cap_t;

typedef efi_status_t efi_get_time_t(efi_time_t *, efi_time_cap_t *);

typedef efi_status_t efi_set_time_t(efi_time_t *);

typedef efi_status_t efi_get_wakeup_time_t(efi_bool_t *, efi_bool_t *, efi_time_t *);

typedef efi_status_t efi_set_wakeup_time_t(efi_bool_t, efi_time_t *);

typedef struct {
	u32 type;
	u32 pad;
	u64 phys_addr;
	u64 virt_addr;
	u64 num_pages;
	u64 attribute;
} efi_memory_desc_t;

typedef efi_status_t efi_set_virtual_address_map_t(unsigned long, unsigned long, u32, efi_memory_desc_t *);

typedef efi_status_t efi_get_variable_t(efi_char16_t *, efi_guid_t *, u32 *, unsigned long *, void *);

typedef efi_status_t efi_get_next_variable_t(unsigned long *, efi_char16_t *, efi_guid_t *);

typedef efi_status_t efi_set_variable_t(efi_char16_t *, efi_guid_t *, u32, unsigned long, void *);

typedef efi_status_t efi_get_next_high_mono_count_t(u32 *);

typedef void efi_reset_system_t(int, efi_status_t, unsigned long, efi_char16_t *);

typedef efi_status_t efi_update_capsule_t(efi_capsule_header_t **, unsigned long, unsigned long);

typedef efi_status_t efi_query_capsule_caps_t(efi_capsule_header_t **, unsigned long, u64 *, int *);

typedef efi_status_t efi_query_variable_info_t(u32, u64 *, u64 *, u64 *);

typedef struct {
	efi_table_hdr_t hdr;
	u32 get_time;
	u32 set_time;
	u32 get_wakeup_time;
	u32 set_wakeup_time;
	u32 set_virtual_address_map;
	u32 convert_pointer;
	u32 get_variable;
	u32 get_next_variable;
	u32 set_variable;
	u32 get_next_high_mono_count;
	u32 reset_system;
	u32 update_capsule;
	u32 query_capsule_caps;
	u32 query_variable_info;
} efi_runtime_services_32_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		efi_get_time_t *get_time;
		efi_set_time_t *set_time;
		efi_get_wakeup_time_t *get_wakeup_time;
		efi_set_wakeup_time_t *set_wakeup_time;
		efi_set_virtual_address_map_t *set_virtual_address_map;
		void *convert_pointer;
		efi_get_variable_t *get_variable;
		efi_get_next_variable_t *get_next_variable;
		efi_set_variable_t *set_variable;
		efi_get_next_high_mono_count_t *get_next_high_mono_count;
		efi_reset_system_t *reset_system;
		efi_update_capsule_t *update_capsule;
		efi_query_capsule_caps_t *query_capsule_caps;
		efi_query_variable_info_t *query_variable_info;
	};
	efi_runtime_services_32_t mixed_mode;
} efi_runtime_services_t;

typedef struct {
	efi_table_hdr_t hdr;
	u32 fw_vendor;
	u32 fw_revision;
	u32 con_in_handle;
	u32 con_in;
	u32 con_out_handle;
	u32 con_out;
	u32 stderr_handle;
	u32 stderr;
	u32 runtime;
	u32 boottime;
	u32 nr_tables;
	u32 tables;
} efi_system_table_32_t;

union efi_simple_text_input_protocol;

typedef union efi_simple_text_input_protocol efi_simple_text_input_protocol_t;

union efi_simple_text_output_protocol;

typedef union efi_simple_text_output_protocol efi_simple_text_output_protocol_t;

union efi_boot_services;

typedef union efi_boot_services efi_boot_services_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		unsigned long fw_vendor;
		u32 fw_revision;
		unsigned long con_in_handle;
		efi_simple_text_input_protocol_t *con_in;
		unsigned long con_out_handle;
		efi_simple_text_output_protocol_t *con_out;
		unsigned long stderr_handle;
		unsigned long stderr;
		efi_runtime_services_t *runtime;
		efi_boot_services_t *boottime;
		unsigned long nr_tables;
		unsigned long tables;
	};
	efi_system_table_32_t mixed_mode;
} efi_system_table_t;

typedef union {
	struct {
		u32 revision;
		efi_handle_t parent_handle;
		efi_system_table_t *system_table;
		efi_handle_t device_handle;
		void *file_path;
		void *reserved;
		u32 load_options_size;
		void *load_options;
		void *image_base;
		__u64 image_size;
		unsigned int image_code_type;
		unsigned int image_data_type;
		efi_status_t (*unload)(efi_handle_t);
	};
	struct {
		u32 revision;
		u32 parent_handle;
		u32 system_table;
		u32 device_handle;
		u32 file_path;
		u32 reserved;
		u32 load_options_size;
		u32 load_options;
		u32 image_base;
		__u64 image_size;
		u32 image_code_type;
		u32 image_data_type;
		u32 unload;
	} mixed_mode;
} efi_loaded_image_t;

typedef struct {
	u32 version;
	u32 num_entries;
	u32 desc_size;
	u32 flags;
	efi_memory_desc_t entry[0];
} efi_memory_attributes_table_t;

typedef struct {
	u32 read;
	u32 write;
} efi_pci_io_protocol_access_32_t;

typedef struct {
	void *read;
	void *write;
} efi_pci_io_protocol_access_t;

union efi_pci_io_protocol;

typedef union efi_pci_io_protocol efi_pci_io_protocol_t;

typedef efi_status_t (*efi_pci_io_protocol_cfg_t)(efi_pci_io_protocol_t *, EFI_PCI_IO_PROTOCOL_WIDTH, u32, unsigned long, void *);

typedef struct {
	efi_pci_io_protocol_cfg_t read;
	efi_pci_io_protocol_cfg_t write;
} efi_pci_io_protocol_config_access_t;

typedef struct {
	u16 version;
	u16 length;
	u32 runtime_services_supported;
} efi_rt_properties_table_t;

typedef struct {
	__le16 e_tag;
	__le16 e_perm;
	__le32 e_id;
} ext4_acl_entry;

typedef struct {
	__le32 a_version;
} ext4_acl_header;

typedef __kernel_fd_set fd_set;

typedef struct {
	unsigned long *in;
	unsigned long *out;
	unsigned long *ex;
	unsigned long *res_in;
	unsigned long *res_out;
	unsigned long *res_ex;
} fd_set_bits;

typedef struct {
	atomic64_t refcnt;
} file_ref_t;

typedef struct {
	unsigned int t391;
	unsigned int t392;
	unsigned int n391;
	unsigned int n392;
	unsigned int n393;
	unsigned short lmi;
	unsigned short dce;
} fr_proto;

typedef struct {
	unsigned int dlci;
} fr_proto_pvc;

typedef struct {
	unsigned int dlci;
	char master[16];
} fr_proto_pvc_info;

typedef union {
	struct {
		void *freelist;
		unsigned long counter;
	};
	freelist_full_t full;
} freelist_aba_t;

typedef struct {
	unsigned long v;
} freeptr_t;

typedef struct {
	unsigned long key[2];
} hsiphash_key_t;

typedef struct {
	unsigned int __softirq_pending;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} irq_cpustat_t;

typedef struct {
	u64 val;
} kernel_cap_t;

typedef struct {
	gid_t val;
} kgid_t;

typedef struct {
	projid_t val;
} kprojid_t;

typedef struct {
	uid_t val;
} kuid_t;

typedef struct {
	U32 offset;
	U32 checksum;
} ldmEntry_t;

typedef struct {
	const BYTE *split;
	U32 hash;
	U32 checksum;
	ldmEntry_t *bucket;
} ldmMatchCandidate_t;

typedef struct {
	ZSTD_ParamSwitch_e enableLdm;
	U32 hashLog;
	U32 bucketSizeLog;
	U32 minMatchLength;
	U32 hashRateLog;
	U32 windowLog;
} ldmParams_t;

typedef struct {
	U64 rolling;
	U64 stopMask;
} ldmRollingHashState_t;

typedef struct {
	ZSTD_window_t window;
	ldmEntry_t *hashTable;
	U32 loadedDictEnd;
	BYTE *bucketOffsets;
	size_t splitIndices[64];
	ldmMatchCandidate_t matchCandidates[64];
} ldmState_t;

typedef struct {
	__le64 b;
	__le64 a;
} le128;

typedef struct {
	atomic_long_t a;
} local_t;

typedef struct {
	local_t a;
} local64_t;

typedef struct {} local_lock_t;

typedef struct {
	u8 acquired;
} local_trylock_t;

typedef union {
	unsigned long x[1];
} map_word;

typedef struct {
	unsigned long f;
} memdesc_flags_t;

struct refcount_struct {
	atomic_t refs;
};

typedef struct refcount_struct refcount_t;

typedef struct {
	atomic64_t id;
	void *sigpage;
	refcount_t pinned;
	void *vdso;
	unsigned long flags;
	u8 pkey_allocation_map;
} mm_context_t;

typedef struct {
	unsigned long __mm_flags[1];
} mm_flags_t;

typedef struct {} netdevice_tracker;

typedef struct {} netns_tracker;

typedef struct {
	char data[8];
} nfs4_verifier;

typedef struct {
	unsigned long bits[1];
} nodemask_t;

typedef struct {
	p4dval_t p4d;
} p4d_t;

typedef struct {
	u64 pme;
} pagemap_entry_t;

struct raw_spinlock {
	arch_spinlock_t raw_lock;
};

typedef struct {
	pgdval_t pgd;
} pgd_t;

typedef struct {
	ptdesc_t pgprot;
} pgprot_t;

typedef struct {
	pmdval_t pmd;
} pmd_t;

typedef struct {
	unsigned long bits[4];
} pnp_irq_mask_t;

struct net;

typedef struct {
	struct net __attribute__((btf_type_tag("rcu"))) *net;
} possible_net_t;

typedef struct {
	pteval_t pte;
} pte_t;

typedef struct {
	pudval_t pud;
} pud_t;

typedef struct {
	unsigned short encoding;
	unsigned short parity;
} raw_hdlc_proto;

typedef struct {
	atomic_t refcnt;
} rcuref_t;

typedef struct {
	size_t written;
	size_t count;
	union {
		char __attribute__((btf_type_tag("user"))) *buf;
		void *data;
	} arg;
	int error;
} read_descriptor_t;

struct encoded_page;

struct page;

typedef union {
	struct page **pages;
	struct folio **folios;
	struct encoded_page **encoded_pages;
} release_pages_arg;

typedef struct {
	BIT_DStream_t DStream;
	ZSTD_fseState stateLL;
	ZSTD_fseState stateOffb;
	ZSTD_fseState stateML;
	size_t prevOffset[3];
} seqState_t;

typedef struct {
	U32 *splitLocations;
	size_t idx;
} seqStoreSplits;

typedef struct {
	size_t litLength;
	size_t matchLength;
	size_t offset;
} seq_t;

struct seqcount {
	unsigned int sequence;
};

typedef struct seqcount seqcount_t;

typedef struct {
	seqcount_t seqcount;
} seqcount_latch_t;

struct seqcount_spinlock {
	seqcount_t seqcount;
};

typedef struct seqcount_spinlock seqcount_spinlock_t;

struct spinlock {
	union {
		struct raw_spinlock rlock;
	};
};

typedef struct {
	seqcount_spinlock_t seqcount;
	spinlock_t lock;
} seqlock_t;

typedef struct {
	unsigned long sig[1];
} sigset_t;

typedef struct {
	u64 key[2];
} siphash_key_t;

struct list_head {
	struct list_head *next;
	struct list_head *prev;
};

struct wait_queue_head {
	spinlock_t lock;
	struct list_head head;
};

typedef struct wait_queue_head wait_queue_head_t;

typedef struct {
	spinlock_t slock;
	int owned;
	wait_queue_head_t wq;
} socket_lock_t;

typedef struct {
	char *from;
	char *to;
} substring_t;

typedef struct {
	unsigned long val;
} swp_entry_t;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	unsigned short loopback;
} sync_serial_settings;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	unsigned short loopback;
	unsigned int slot_map;
} te1_settings;

typedef struct {
	local64_t v;
} u64_stats_t;

typedef struct {
	u64 m_low;
	u64 m_high;
} uint128_t;

typedef struct {
	__u8 b[16];
} uuid_t;

typedef struct {
	unsigned short dce;
	unsigned int modulo;
	unsigned int window;
	unsigned int t1;
	unsigned int t2;
	unsigned int n2;
} x25_hdlc_proto;

typedef struct {
	gid_t val;
} vfsgid_t;

typedef struct {
	uid_t val;
} vfsuid_t;

typedef ZSTD_compressionParameters zstd_compression_parameters;

typedef ZSTD_customMem zstd_custom_mem;

typedef ZSTD_FrameHeader zstd_frame_header;

typedef ZSTD_parameters zstd_parameters;

typedef ZSTD_Sequence zstd_sequence;

struct IOV_111 {
	u8 maxVFsSupported;
	u8 numVFsEnabled;
	u8 requestorId;
	u8 reserved[5];
};

struct IO_REQUEST_INFO {
	u64 ldStartBlock;
	u32 numBlocks;
	u16 ldTgtId;
	u8 isRead;
	__le16 devHandle;
	u8 pd_interface;
	u64 pdBlock;
	u8 fpOkForIo;
	u8 IoforUnevenSpan;
	u8 start_span;
	u8 do_fp_rlbypass;
	u64 start_row;
	u8 span_arm;
	u8 pd_after_lb;
	u16 r1_alt_dev_handle;
	bool ra_capable;
	u8 data_arms;
};

struct LD_LOAD_BALANCE_INFO {
	u8 loadBalanceFlag;
	u8 reserved1;
	atomic_t scsi_pending_cmds[256];
	u64 last_accessed_block[256];
};

struct megasas_cmd_fusion;

struct STREAM_DETECT {
	u64 next_seq_lba;
	struct megasas_cmd_fusion *first_cmd_fusion;
	struct megasas_cmd_fusion *last_cmd_fusion;
	u32 count_cmds_in_stream;
	u16 num_sges_in_group;
	u8 is_read;
	u8 group_depth;
	bool group_flush;
	u8 reserved[7];
};

struct LD_STREAM_DETECT {
	bool write_back;
	bool fp_write_enabled;
	bool members_ssds;
	bool fp_cache_bypass_capable;
	u32 mru_bit_map;
	struct STREAM_DETECT stream_track[8];
};

struct _LD_SPAN_SET {
	u64 log_start_lba;
	u64 log_end_lba;
	u64 span_row_start;
	u64 span_row_end;
	u64 data_strip_start;
	u64 data_strip_end;
	u64 data_row_start;
	u64 data_row_end;
	u8 strip_offset[8];
	u32 span_row_data_width;
	u32 diff;
	u32 reserved[2];
};

typedef struct _LD_SPAN_SET LD_SPAN_SET;

struct LOG_BLOCK_SPAN_INFO {
	LD_SPAN_SET span_set[8];
};

typedef struct LOG_BLOCK_SPAN_INFO LD_SPAN_INFO;

typedef struct LOG_BLOCK_SPAN_INFO *PLD_SPAN_INFO;

struct MEGASAS_RAID_MFA_IO_REQUEST_DESCRIPTOR {
	u32 RequestFlags: 8;
	u32 MessageAddress1: 24;
	u32 MessageAddress2;
};

struct MPI2_DEFAULT_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 DescriptorTypeDependent;
};

struct MPI2_HIGH_PRIORITY_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 Reserved1;
};

struct MPI2_SCSI_IO_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 DevHandle;
};

struct MPI2_SCSI_TARGET_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 IoIndex;
};

struct MPI2_RAID_ACCEL_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 Reserved;
};

union MEGASAS_REQUEST_DESCRIPTOR_UNION {
	struct MPI2_DEFAULT_REQUEST_DESCRIPTOR Default;
	struct MPI2_HIGH_PRIORITY_REQUEST_DESCRIPTOR HighPriority;
	struct MPI2_SCSI_IO_REQUEST_DESCRIPTOR SCSIIO;
	struct MPI2_SCSI_TARGET_REQUEST_DESCRIPTOR SCSITarget;
	struct MPI2_RAID_ACCEL_REQUEST_DESCRIPTOR RAIDAccelerator;
	struct MEGASAS_RAID_MFA_IO_REQUEST_DESCRIPTOR MFAIo;
	union {
		struct {
			__le32 low;
			__le32 high;
		} u;
		__le64 Words;
	};
};

struct MPI25_IEEE_SGE_CHAIN64 {
	__le64 Address;
	__le32 Length;
	__le16 Reserved1;
	u8 NextChainOffset;
	u8 Flags;
};

struct MPI2_ADDRESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le32 ReplyFrameAddress;
};

struct MPI2_DEFAULT_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 DescriptorTypeDependent1;
	__le32 DescriptorTypeDependent2;
};

struct MPI2_IEEE_SGE_CHAIN32 {
	__le32 Address;
	__le32 FlagsLength;
};

struct MPI2_IEEE_SGE_CHAIN64 {
	__le64 Address;
	__le32 Length;
	__le16 Reserved1;
	u8 Reserved2;
	u8 Flags;
};

union MPI2_IEEE_SGE_CHAIN_UNION {
	struct MPI2_IEEE_SGE_CHAIN32 Chain32;
	struct MPI2_IEEE_SGE_CHAIN64 Chain64;
};

struct MPI2_IEEE_SGE_SIMPLE32 {
	__le32 Address;
	__le32 FlagsLength;
};

struct MPI2_IEEE_SGE_SIMPLE64 {
	__le64 Address;
	__le32 Length;
	__le16 Reserved1;
	u8 Reserved2;
	u8 Flags;
};

union MPI2_IEEE_SGE_SIMPLE_UNION {
	struct MPI2_IEEE_SGE_SIMPLE32 Simple32;
	struct MPI2_IEEE_SGE_SIMPLE64 Simple64;
};

struct MPI2_IOC_INIT_RDPQ_ARRAY_ENTRY {
	u64 RDPQBaseAddress;
	u32 Reserved1;
	u32 Reserved2;
};

struct MPI2_IOC_INIT_REQUEST {
	u8 WhoInit;
	u8 Reserved1;
	u8 ChainOffset;
	u8 Function;
	__le16 Reserved2;
	u8 Reserved3;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	__le16 Reserved4;
	__le16 MsgVersion;
	__le16 HeaderVersion;
	u32 Reserved5;
	__le16 Reserved6;
	u8 HostPageSize;
	u8 HostMSIxVectors;
	__le16 Reserved8;
	__le16 SystemRequestFrameSize;
	__le16 ReplyDescriptorPostQueueDepth;
	__le16 ReplyFreeQueueDepth;
	__le32 SenseBufferAddressHigh;
	__le32 SystemReplyAddressHigh;
	__le64 SystemRequestFrameBaseAddress;
	__le64 ReplyDescriptorPostQueueAddress;
	__le64 ReplyFreeQueueAddress;
	__le64 TimeStamp;
};

struct MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le32 Reserved;
};

struct MPI2_SCSI_IO_CDB_EEDP32 {
	u8 CDB[20];
	__be32 PrimaryReferenceTag;
	__be16 PrimaryApplicationTag;
	__be16 PrimaryApplicationTagMask;
	__le32 TransferLength;
};

struct MPI2_SGE_SIMPLE_UNION {
	__le32 FlagsLength;
	union {
		__le32 Address32;
		__le64 Address64;
	} u;
};

union MPI2_SCSI_IO_CDB_UNION {
	u8 CDB32[32];
	struct MPI2_SCSI_IO_CDB_EEDP32 EEDP32;
	struct MPI2_SGE_SIMPLE_UNION SGE;
};

struct RAID_CONTEXT {
	u8 type: 4;
	u8 nseg: 4;
	u8 resvd0;
	__le16 timeout_value;
	u8 reg_lock_flags;
	u8 resvd1;
	__le16 virtual_disk_tgt_id;
	__le64 reg_lock_row_lba;
	__le32 reg_lock_length;
	__le16 next_lmid;
	u8 ex_status;
	u8 status;
	u8 raid_flags;
	u8 num_sge;
	__le16 config_seq_num;
	u8 span_arm;
	u8 priority;
	u8 num_sge_ext;
	u8 resvd2;
};

struct RAID_CONTEXT_G35 {
	u16 nseg_type;
	u16 timeout_value;
	u16 routing_flags;
	u16 virtual_disk_tgt_id;
	__le64 reg_lock_row_lba;
	u32 reg_lock_length;
	union {
		u16 rmw_op_index;
		u16 peer_smid;
		u16 r56_arm_map;
	} flow_specific;
	u8 ex_status;
	u8 status;
	u8 raid_flags;
	u8 span_arm;
	u16 config_seq_num;
	union {
		struct {
			u16 num_sge: 12;
			u16 reserved: 3;
			u16 stream_detected: 1;
		} bits;
		u8 bytes[2];
	} u;
	u8 resvd2[2];
};

union RAID_CONTEXT_UNION {
	struct RAID_CONTEXT raid_context;
	struct RAID_CONTEXT_G35 raid_context_g35;
};

struct MPI2_SGE_CHAIN_UNION {
	__le16 Length;
	u8 NextChainOffset;
	u8 Flags;
	union {
		__le32 Address32;
		__le64 Address64;
	} u;
};

union MPI2_SGE_IO_UNION {
	struct MPI2_SGE_SIMPLE_UNION MpiSimple;
	struct MPI2_SGE_CHAIN_UNION MpiChain;
	union MPI2_IEEE_SGE_SIMPLE_UNION IeeeSimple;
	union MPI2_IEEE_SGE_CHAIN_UNION IeeeChain;
};

struct MPI2_RAID_SCSI_IO_REQUEST {
	__le16 DevHandle;
	u8 ChainOffset;
	u8 Function;
	__le16 Reserved1;
	u8 Reserved2;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	__le16 Reserved3;
	__le32 SenseBufferLowAddress;
	__le16 SGLFlags;
	u8 SenseBufferLength;
	u8 Reserved4;
	u8 SGLOffset0;
	u8 SGLOffset1;
	u8 SGLOffset2;
	u8 SGLOffset3;
	__le32 SkipCount;
	__le32 DataLength;
	__le32 BidirectionalDataLength;
	__le16 IoFlags;
	__le16 EEDPFlags;
	__le32 EEDPBlockSize;
	__le32 SecondaryReferenceTag;
	__le16 SecondaryApplicationTag;
	__le16 ApplicationTagTranslationMask;
	u8 LUN[8];
	__le32 Control;
	union MPI2_SCSI_IO_CDB_UNION CDB;
	union RAID_CONTEXT_UNION RaidContext;
	union {
		union MPI2_SGE_IO_UNION SGL;
		struct {
			struct {} __empty_SGLs;
			union MPI2_SGE_IO_UNION SGLs[0];
		};
	};
};

struct MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 TaskTag;
	__le16 Reserved1;
};

struct MPI2_TARGETASSIST_SUCCESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	u8 SequenceNumber;
	u8 Reserved1;
	__le16 IoIndex;
};

struct MPI2_TARGET_COMMAND_BUFFER_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	u8 VP_ID;
	u8 Flags;
	__le16 InitiatorDevHandle;
	__le16 IoIndex;
};

union MPI2_REPLY_DESCRIPTORS_UNION {
	struct MPI2_DEFAULT_REPLY_DESCRIPTOR Default;
	struct MPI2_ADDRESS_REPLY_DESCRIPTOR AddressReply;
	struct MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR SCSIIOSuccess;
	struct MPI2_TARGETASSIST_SUCCESS_REPLY_DESCRIPTOR TargetAssistSuccess;
	struct MPI2_TARGET_COMMAND_BUFFER_REPLY_DESCRIPTOR TargetCommandBuffer;
	struct MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR RAIDAcceleratorSuccess;
	__le64 Words;
};

struct MPI2_SCSI_TASK_MANAGE_REPLY {
	u16 DevHandle;
	u8 MsgLength;
	u8 Function;
	u8 ResponseCode;
	u8 TaskType;
	u8 Reserved1;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	u16 Reserved2;
	u16 Reserved3;
	u16 IOCStatus;
	u32 IOCLogInfo;
	u32 TerminationCount;
	u32 ResponseInfo;
};

struct MPI2_SCSI_TASK_MANAGE_REQUEST {
	u16 DevHandle;
	u8 ChainOffset;
	u8 Function;
	u8 Reserved1;
	u8 TaskType;
	u8 Reserved2;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	u16 Reserved3;
	u8 LUN[8];
	u32 Reserved4[7];
	u16 TaskMID;
	u16 Reserved5;
};

struct MR_ARRAY_INFO {
	__le16 pd[32];
};

struct MR_CPU_AFFINITY_MASK {
	union {
		struct {
			u8 hw_path: 1;
			u8 cpu0: 1;
			u8 cpu1: 1;
			u8 cpu2: 1;
			u8 cpu3: 1;
			u8 reserved: 3;
		};
		u8 core_mask;
	};
};

struct MR_CTRL_HB_HOST_MEM {
	struct {
		u32 fwCounter;
		struct {
			u32 debugmode: 1;
			u32 reserved: 31;
		} debug;
		u32 reserved_fw[6];
		u32 driverCounter;
		u32 reserved_driver[7];
	} HB;
	u8 pad[960];
};

struct MR_DEV_HANDLE_INFO {
	__le16 curDevHdl;
	u8 validHandles;
	u8 interfaceType;
	__le16 devHandle[2];
};

struct MR_IO_AFFINITY {
	union {
		struct {
			struct MR_CPU_AFFINITY_MASK pdRead;
			struct MR_CPU_AFFINITY_MASK pdWrite;
			struct MR_CPU_AFFINITY_MASK ldRead;
			struct MR_CPU_AFFINITY_MASK ldWrite;
		};
		u32 word;
	};
	u8 maxCores;
	u8 reserved[3];
};

struct MR_LD_RAID {
	struct {
		u32 fpCapable: 1;
		u32 ra_capable: 1;
		u32 reserved5: 2;
		u32 ldPiMode: 4;
		u32 pdPiMode: 4;
		u32 encryptionType: 8;
		u32 fpWriteCapable: 1;
		u32 fpReadCapable: 1;
		u32 fpWriteAcrossStripe: 1;
		u32 fpReadAcrossStripe: 1;
		u32 fpNonRWCapable: 1;
		u32 tmCapable: 1;
		u32 fpBypassRegionLock: 1;
		u32 disable_coalescing: 1;
		u32 fp_rmw_capable: 1;
		u32 fp_cache_bypass_capable: 1;
		u32 reserved4: 2;
	} capability;
	__le32 reserved6;
	__le64 size;
	u8 spanDepth;
	u8 level;
	u8 stripeShift;
	u8 rowSize;
	u8 rowDataSize;
	u8 writeMode;
	u8 PRL;
	u8 SRL;
	__le16 targetId;
	u8 ldState;
	u8 regTypeReqOnWrite;
	u8 modFactor;
	u8 regTypeReqOnRead;
	__le16 seqNum;
	struct {
		u32 ldSyncRequired: 1;
		u32 regTypeReqOnReadIsValid: 1;
		u32 isEPD: 1;
		u32 enableSLDOnAllRWIOs: 1;
		u32 reserved: 28;
	} flags;
	u8 LUN[8];
	u8 fpIoTimeoutForLd;
	u8 ld_accept_priority_type;
	u8 reserved2[2];
	u32 logical_block_length;
	struct {
		u32 ld_pi_exp: 4;
		u32 ld_logical_block_exp: 4;
		u32 reserved1: 24;
	};
	struct MR_IO_AFFINITY cpuAffinity;
	u8 reserved3[64];
};

struct MR_LD_SPAN {
	__le64 startBlk;
	__le64 numBlks;
	__le16 arrayRef;
	u8 spanRowSize;
	u8 spanRowDataSize;
	u8 reserved[4];
};

struct MR_QUAD_ELEMENT {
	__le64 logStart;
	__le64 logEnd;
	__le64 offsetInSpan;
	__le32 diff;
	__le32 reserved1;
};

struct MR_SPAN_INFO {
	__le32 noElements;
	__le32 reserved1;
	struct MR_QUAD_ELEMENT quad[8];
};

struct MR_SPAN_BLOCK_INFO {
	__le64 num_rows;
	struct MR_LD_SPAN span;
	struct MR_SPAN_INFO block_span_info;
};

struct MR_LD_SPAN_MAP {
	struct MR_LD_RAID ldRaid;
	u8 dataArmMap[32];
	struct MR_SPAN_BLOCK_INFO spanBlock[8];
};

struct MR_DRV_RAID_MAP {
	__le32 totalSize;
	union {
		struct {
			__le32 maxLd;
			__le32 maxSpanDepth;
			__le32 maxRowSize;
			__le32 maxPdCount;
			__le32 maxArrays;
		} validationInfo;
		__le32 version[5];
	};
	u8 fpPdIoTimeoutSec;
	u8 reserved2[7];
	__le16 ldCount;
	__le16 arCount;
	__le16 spanCount;
	__le16 reserve3;
	struct MR_DEV_HANDLE_INFO devHndlInfo[512];
	u16 ldTgtIdToLd[512];
	struct MR_ARRAY_INFO arMapInfo[512];
	struct MR_LD_SPAN_MAP ldSpanMap[0];
};

struct MR_DRV_RAID_MAP_ALL {
	struct MR_DRV_RAID_MAP raidMap;
	struct MR_LD_SPAN_MAP ldSpanMap[512];
};

struct MR_DRV_SYSTEM_INFO {
	u8 infoVersion;
	u8 systemIdLength;
	u16 reserved0;
	u8 systemId[64];
	u8 reserved[1980];
};

struct MR_FW_RAID_MAP {
	__le32 totalSize;
	union {
		struct {
			__le32 maxLd;
			__le32 maxSpanDepth;
			__le32 maxRowSize;
			__le32 maxPdCount;
			__le32 maxArrays;
		} validationInfo;
		__le32 version[5];
	};
	__le32 ldCount;
	__le32 Reserved1;
	u8 ldTgtIdToLd[128];
	u8 fpPdIoTimeoutSec;
	u8 reserved2[7];
	struct MR_ARRAY_INFO arMapInfo[128];
	struct MR_DEV_HANDLE_INFO devHndlInfo[256];
	struct MR_LD_SPAN_MAP ldSpanMap[0];
};

struct MR_FW_RAID_MAP_ALL {
	struct MR_FW_RAID_MAP raidMap;
	struct MR_LD_SPAN_MAP ldSpanMap[64];
};

struct MR_RAID_MAP_DESC_TABLE {
	u32 raid_map_desc_type;
	u32 raid_map_desc_offset;
	u32 raid_map_desc_buffer_size;
	u32 raid_map_desc_elements;
};

struct MR_FW_RAID_MAP_DYNAMIC {
	u32 raid_map_size;
	u32 desc_table_offset;
	u32 desc_table_size;
	u32 desc_table_num_elements;
	u64 reserved1;
	u32 reserved2[3];
	u8 fp_pd_io_timeout_sec;
	u8 reserved3[3];
	u32 rmw_fp_seq_num;
	u16 ld_count;
	u16 ar_count;
	u16 span_count;
	u16 reserved4[3];
	union {
		struct {
			struct MR_DEV_HANDLE_INFO *dev_hndl_info;
			u16 *ld_tgt_id_to_ld;
			struct MR_ARRAY_INFO *ar_map_info;
			struct MR_LD_SPAN_MAP *ld_span_map;
		};
		u64 ptr_structure_size[4];
	};
	struct MR_RAID_MAP_DESC_TABLE raid_map_desc_table[4];
	u32 raid_map_desc_data[0];
};

struct MR_FW_RAID_MAP_EXT {
	u32 reserved;
	union {
		struct {
			u32 maxLd;
			u32 maxSpanDepth;
			u32 maxRowSize;
			u32 maxPdCount;
			u32 maxArrays;
		} validationInfo;
		u32 version[5];
	};
	u8 fpPdIoTimeoutSec;
	u8 reserved2[7];
	__le16 ldCount;
	__le16 arCount;
	__le16 spanCount;
	__le16 reserve3;
	struct MR_DEV_HANDLE_INFO devHndlInfo[256];
	u8 ldTgtIdToLd[256];
	struct MR_ARRAY_INFO arMapInfo[256];
	struct MR_LD_SPAN_MAP ldSpanMap[256];
};

struct MR_HOST_DEVICE_LIST_ENTRY {
	struct {
		union {
			struct {
				u8 is_sys_pd: 1;
				u8 reserved: 7;
			} bits;
			u8 byte;
		} u;
	} flags;
	u8 scsi_type;
	__le16 target_id;
	u8 reserved[4];
	__le64 sas_addr[2];
};

struct MR_HOST_DEVICE_LIST {
	__le32 size;
	__le32 count;
	__le32 reserved[2];
	struct MR_HOST_DEVICE_LIST_ENTRY host_device_list[0];
};

union MR_LD_REF {
	struct {
		u8 targetId;
		u8 reserved;
		__le16 seqNum;
	};
	__le32 ref;
};

struct MR_LD_LIST {
	__le32 ldCount;
	__le32 reserved;
	struct {
		union MR_LD_REF ref;
		u8 state;
		u8 reserved[3];
		__le64 size;
	} ldList[256];
};

struct MR_LD_TARGETID_LIST {
	__le32 size;
	__le32 count;
	u8 pad[3];
	u8 targetId[256];
};

struct MR_LD_TARGET_SYNC {
	u8 targetId;
	u8 reserved;
	__le16 seqNum;
};

struct MR_LD_VF_MAP {
	u32 size;
	union MR_LD_REF ref;
	u8 ldVfCount;
	u8 reserved[6];
	u8 policy[0];
};

struct MR_LD_VF_AFFILIATION {
	u32 size;
	u8 ldCount;
	u8 vfCount;
	u8 thisVf;
	u8 reserved[9];
	struct MR_LD_VF_MAP map[1];
};

struct MR_LD_VF_MAP_111 {
	u8 targetId;
	u8 reserved[3];
	u8 policy[8];
};

struct MR_LD_VF_AFFILIATION_111 {
	u8 vdCount;
	u8 vfCount;
	u8 thisVf;
	u8 reserved[5];
	struct MR_LD_VF_MAP_111 map[64];
};

struct MR_PD_ADDRESS {
	__le16 deviceId;
	u16 enclDeviceId;
	union {
		struct {
			u8 enclIndex;
			u8 slotNumber;
		} mrPdAddress;
		struct {
			u8 enclPosition;
			u8 enclConnectorIndex;
		} mrEnclAddress;
	};
	u8 scsiDevType;
	union {
		u8 connectedPortBitmap;
		u8 connectedPortNumbers;
	};
	u64 sasAddr[2];
};

struct MR_PD_CFG_SEQ {
	u16 seqNum;
	u16 devHandle;
	struct {
		u8 tmCapable: 1;
		u8 reserved: 7;
	} capability;
	u8 reserved;
	u16 pd_target_id;
};

struct MR_PD_CFG_SEQ_NUM_SYNC {
	__le32 size;
	__le32 count;
	struct MR_PD_CFG_SEQ seq[0];
};

union MR_PD_DDF_TYPE {
	struct {
		union {
			struct {
				u16 forcedPDGUID: 1;
				u16 inVD: 1;
				u16 isGlobalSpare: 1;
				u16 isSpare: 1;
				u16 isForeign: 1;
				u16 reserved: 7;
				u16 intf: 4;
			} pdType;
			u16 type;
		};
		u16 reserved;
	} ddf;
	struct {
		u32 reserved;
	} nonDisk;
	u32 type;
};

union MR_PD_REF {
	struct {
		u16 deviceId;
		u16 seqNum;
	} mrPdRef;
	u32 ref;
};

union MR_PROGRESS {
	struct {
		u16 progress;
		union {
			u16 elapsedSecs;
			u16 elapsedSecsForLastPercent;
		};
	} mrProgress;
	u32 w;
};

struct MR_PD_PROGRESS {
	struct {
		u32 rbld: 1;
		u32 patrol: 1;
		u32 clear: 1;
		u32 copyBack: 1;
		u32 erase: 1;
		u32 locate: 1;
		u32 reserved: 26;
	} active;
	union MR_PROGRESS rbld;
	union MR_PROGRESS patrol;
	union {
		union MR_PROGRESS clear;
		union MR_PROGRESS erase;
	};
	struct {
		u32 rbld: 1;
		u32 patrol: 1;
		u32 clear: 1;
		u32 copyBack: 1;
		u32 erase: 1;
		u32 reserved: 27;
	} pause;
	union MR_PROGRESS reserved[3];
};

struct MR_PD_INFO {
	union MR_PD_REF ref;
	u8 inquiryData[96];
	u8 vpdPage83[64];
	u8 notSupported;
	u8 scsiDevType;
	union {
		u8 connectedPortBitmap;
		u8 connectedPortNumbers;
	};
	u8 deviceSpeed;
	u32 mediaErrCount;
	u32 otherErrCount;
	u32 predFailCount;
	u32 lastPredFailEventSeqNum;
	u16 fwState;
	u8 disabledForRemoval;
	u8 linkSpeed;
	union MR_PD_DDF_TYPE state;
	struct {
		u8 count;
		u8 isPathBroken: 4;
		u8 reserved3: 3;
		u8 widePortCapable: 1;
		u8 connectorIndex[2];
		u8 reserved[4];
		u64 sasAddr[2];
		u8 reserved2[16];
	} pathInfo;
	u64 rawSize;
	u64 nonCoercedSize;
	u64 coercedSize;
	u16 enclDeviceId;
	u8 enclIndex;
	union {
		u8 slotNumber;
		u8 enclConnectorIndex;
	};
	struct MR_PD_PROGRESS progInfo;
	u8 badBlockTableFull;
	u8 unusableInCurrentConfig;
	u8 vpdPage83Ext[64];
	u8 powerState;
	u8 enclPosition;
	u32 allowedOps;
	u16 copyBackPartnerId;
	u16 enclPartnerDeviceId;
	struct {
		u16 fdeCapable: 1;
		u16 fdeEnabled: 1;
		u16 secured: 1;
		u16 locked: 1;
		u16 foreign: 1;
		u16 needsEKM: 1;
		u16 reserved: 10;
	} security;
	u8 mediaType;
	u8 notCertified;
	u8 bridgeVendor[8];
	u8 bridgeProductIdentification[16];
	u8 bridgeProductRevisionLevel[4];
	u8 satBridgeExists;
	u8 interfaceType;
	u8 temperature;
	u8 emulatedBlockSize;
	u16 userDataBlockSize;
	u16 reserved2;
	struct {
		u32 piType: 3;
		u32 piFormatted: 1;
		u32 piEligible: 1;
		u32 NCQ: 1;
		u32 WCE: 1;
		u32 commissionedSpare: 1;
		u32 emergencySpare: 1;
		u32 ineligibleForSSCD: 1;
		u32 ineligibleForLd: 1;
		u32 useSSEraseType: 1;
		u32 wceUnchanged: 1;
		u32 supportScsiUnmap: 1;
		u32 reserved: 18;
	} properties;
	u64 shieldDiagCompletionTime;
	u8 shieldCounter;
	u8 linkSpeedOther;
	u8 reserved4[2];
	struct {
		u32 bbmErrCountSupported: 1;
		u32 bbmErrCount: 31;
	} bbmErr;
	u8 reserved1[84];
} __attribute__((packed));

struct MR_PD_LIST {
	__le32 size;
	__le32 count;
	struct MR_PD_ADDRESS addr[1];
};

struct MR_PRIV_DEVICE {
	bool is_tm_capable;
	bool tm_busy;
	atomic_t sdev_priv_busy;
	atomic_t r1_ldio_hint;
	u8 interface_type;
	u8 task_abort_tmo;
	u8 target_reset_tmo;
};

struct MR_SNAPDUMP_PROPERTIES {
	u8 offload_num;
	u8 max_num_supported;
	u8 cur_num_supported;
	u8 trigger_min_num_sec_before_ocr;
	u8 reserved[12];
};

struct MR_TARGET_PROPERTIES {
	u32 max_io_size_kb;
	u32 device_qdepth;
	u32 sector_size;
	u8 reset_tmo;
	u8 reserved[499];
};

struct MR_TM_REQUEST {
	char request[128];
};

struct MR_TM_REPLY {
	char reply[128];
};

struct MR_TASK_MANAGE_REQUEST {
	struct MR_TM_REQUEST TmRequest;
	union {
		struct {
			u32 isTMForLD: 1;
			u32 isTMForPD: 1;
			u32 reserved1: 30;
			u32 reserved2;
		} tmReqFlags;
		struct MR_TM_REPLY TMReply;
	};
};

struct hlist_node {
	struct hlist_node *next;
	struct hlist_node **pprev;
};

struct sk_buff;

struct sk_buff_list {
	struct sk_buff *next;
	struct sk_buff *prev;
};

struct sk_buff_head {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
		};
		struct sk_buff_list list;
	};
	__u32 qlen;
	spinlock_t lock;
};

struct qdisc_skb_head {
	struct sk_buff *head;
	struct sk_buff *tail;
	__u32 qlen;
	spinlock_t lock;
};

struct u64_stats_sync {};

struct gnet_stats_basic_sync {
	u64_stats_t bytes;
	u64_stats_t packets;
	struct u64_stats_sync syncp;
};

struct gnet_stats_queue {
	__u32 qlen;
	__u32 backlog;
	__u32 drops;
	__u32 requeues;
	__u32 overlimits;
};

struct callback_head {
	struct callback_head *next;
	void (*func)(struct callback_head *);
};

struct lock_class_key {};

struct Qdisc_ops;

struct qdisc_size_table;

struct netdev_queue;

struct net_rate_estimator;

struct Qdisc {
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	unsigned int flags;
	u32 limit;
	const struct Qdisc_ops *ops;
	struct qdisc_size_table __attribute__((btf_type_tag("rcu"))) *stab;
	struct hlist_node hash;
	u32 handle;
	u32 parent;
	struct netdev_queue *dev_queue;
	struct net_rate_estimator __attribute__((btf_type_tag("rcu"))) *rate_est;
	struct gnet_stats_basic_sync __attribute__((btf_type_tag("percpu"))) *cpu_bstats;
	struct gnet_stats_queue __attribute__((btf_type_tag("percpu"))) *cpu_qstats;
	int pad;
	refcount_t refcnt;
	long: 64;
	long: 64;
	long: 64;
	struct sk_buff_head gso_skb;
	struct qdisc_skb_head q;
	struct gnet_stats_basic_sync bstats;
	struct gnet_stats_queue qstats;
	int owner;
	unsigned long state;
	unsigned long state2;
	struct Qdisc *next_sched;
	struct sk_buff_head skb_bad_txq;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t busylock;
	spinlock_t seqlock;
	struct callback_head rcu;
	netdevice_tracker dev_tracker;
	struct lock_class_key root_lock_key;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long privdata[0];
};

struct Qdisc_class_common {
	u32 classid;
	unsigned int filter_cnt;
	struct hlist_node hnode;
};

struct hlist_head;

struct Qdisc_class_hash {
	struct hlist_head *hash;
	unsigned int hashsize;
	unsigned int hashmask;
	unsigned int hashelems;
};

struct tcmsg;

struct netlink_ext_ack;

struct nlattr;

struct qdisc_walker;

struct tcf_block;

struct gnet_dump;

struct Qdisc_class_ops {
	unsigned int flags;
	struct netdev_queue * (*select_queue)(struct Qdisc *, struct tcmsg *);
	int (*graft)(struct Qdisc *, unsigned long, struct Qdisc *, struct Qdisc **, struct netlink_ext_ack *);
	struct Qdisc * (*leaf)(struct Qdisc *, unsigned long);
	void (*qlen_notify)(struct Qdisc *, unsigned long);
	unsigned long (*find)(struct Qdisc *, u32);
	int (*change)(struct Qdisc *, u32, u32, struct nlattr **, unsigned long *, struct netlink_ext_ack *);
	int (*delete)(struct Qdisc *, unsigned long, struct netlink_ext_ack *);
	void (*walk)(struct Qdisc *, struct qdisc_walker *);
	struct tcf_block * (*tcf_block)(struct Qdisc *, unsigned long, struct netlink_ext_ack *);
	unsigned long (*bind_tcf)(struct Qdisc *, unsigned long, u32);
	void (*unbind_tcf)(struct Qdisc *, unsigned long);
	int (*dump)(struct Qdisc *, unsigned long, struct sk_buff *, struct tcmsg *);
	int (*dump_stats)(struct Qdisc *, unsigned long, struct gnet_dump *);
};

struct module;

struct Qdisc_ops {
	struct Qdisc_ops *next;
	const struct Qdisc_class_ops *cl_ops;
	char id[16];
	int priv_size;
	unsigned int static_flags;
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	struct sk_buff * (*peek)(struct Qdisc *);
	int (*init)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*reset)(struct Qdisc *);
	void (*destroy)(struct Qdisc *);
	int (*change)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*attach)(struct Qdisc *);
	int (*change_tx_queue_len)(struct Qdisc *, unsigned int);
	void (*change_real_num_tx)(struct Qdisc *, unsigned int);
	int (*dump)(struct Qdisc *, struct sk_buff *);
	int (*dump_stats)(struct Qdisc *, struct gnet_dump *);
	void (*ingress_block_set)(struct Qdisc *, u32);
	void (*egress_block_set)(struct Qdisc *, u32);
	u32 (*ingress_block_get)(struct Qdisc *);
	u32 (*egress_block_get)(struct Qdisc *);
	struct module *owner;
};

struct optimistic_spin_queue {
	atomic_t tail;
};

struct mutex {
	atomic_long_t owner;
	raw_spinlock_t wait_lock;
	struct optimistic_spin_queue osq;
	struct list_head wait_list;
};

struct kref {
	refcount_t refcount;
};

struct swait_queue_head {
	raw_spinlock_t lock;
	struct list_head task_list;
};

struct completion {
	unsigned int done;
	struct swait_queue_head wait;
};

struct blk_mq_queue_map {
	unsigned int *mq_map;
	unsigned int nr_queues;
	unsigned int queue_offset;
};

struct lockdep_map {};

struct srcu_ctr;

struct srcu_data;

struct srcu_usage;

struct srcu_struct {
	struct srcu_ctr __attribute__((btf_type_tag("percpu"))) *srcu_ctrp;
	struct srcu_data __attribute__((btf_type_tag("percpu"))) *sda;
	struct lockdep_map dep_map;
	struct srcu_usage *srcu_sup;
};

struct rw_semaphore {
	atomic_long_t count;
	atomic_long_t owner;
	struct optimistic_spin_queue osq;
	raw_spinlock_t wait_lock;
	struct list_head wait_list;
};

struct blk_mq_ops;

struct blk_mq_tags;

struct blk_mq_tag_set {
	const struct blk_mq_ops *ops;
	struct blk_mq_queue_map map[3];
	unsigned int nr_maps;
	unsigned int nr_hw_queues;
	unsigned int queue_depth;
	unsigned int reserved_tags;
	unsigned int cmd_size;
	int numa_node;
	unsigned int timeout;
	unsigned int flags;
	void *driver_data;
	struct blk_mq_tags **tags;
	struct blk_mq_tags *shared_tags;
	struct mutex tag_list_lock;
	struct list_head tag_list;
	struct srcu_struct *srcu;
	struct srcu_struct tags_srcu;
	struct rw_semaphore update_nr_hwq_lock;
};

struct kset;

struct kobj_type;

struct kernfs_node;

struct kobject {
	const char *name;
	struct list_head entry;
	struct kobject *parent;
	struct kset *kset;
	const struct kobj_type *ktype;
	struct kernfs_node *sd;
	struct kref kref;
	unsigned int state_initialized: 1;
	unsigned int state_in_sysfs: 1;
	unsigned int state_add_uevent_sent: 1;
	unsigned int state_remove_uevent_sent: 1;
	unsigned int uevent_suppress: 1;
};

struct dev_links_info {
	struct list_head suppliers;
	struct list_head consumers;
	struct list_head defer_sync;
	enum dl_dev_state status;
};

struct pm_message {
	int event;
};

typedef struct pm_message pm_message_t;

struct rb_node {
	unsigned long __rb_parent_color;
	struct rb_node *rb_right;
	struct rb_node *rb_left;
};

struct timerqueue_node {
	struct rb_node node;
	ktime_t expires;
};

struct hrtimer_clock_base;

struct hrtimer {
	struct timerqueue_node node;
	ktime_t _softexpires;
	enum hrtimer_restart (*function)(struct hrtimer *);
	struct hrtimer_clock_base *base;
	u8 state;
	u8 is_rel;
	u8 is_soft;
	u8 is_hard;
};

struct work_struct;

typedef void (*work_func_t)(struct work_struct *);

struct work_struct {
	atomic_long_t data;
	struct list_head entry;
	work_func_t func;
};

struct wakeup_source;

struct wake_irq;

struct pm_subsys_data;

struct dev_pm_qos;

struct dev_pm_info {
	pm_message_t power_state;
	bool can_wakeup: 1;
	bool async_suspend: 1;
	bool in_dpm_list: 1;
	bool is_prepared: 1;
	bool is_suspended: 1;
	bool is_noirq_suspended: 1;
	bool is_late_suspended: 1;
	bool no_pm: 1;
	bool early_init: 1;
	bool direct_complete: 1;
	u32 driver_flags;
	spinlock_t lock;
	struct list_head entry;
	struct completion completion;
	struct wakeup_source *wakeup;
	bool wakeup_path: 1;
	bool syscore: 1;
	bool no_pm_callbacks: 1;
	bool work_in_progress: 1;
	bool smart_suspend: 1;
	bool must_resume: 1;
	bool may_skip_resume: 1;
	bool strict_midlayer: 1;
	struct hrtimer suspend_timer;
	u64 timer_expires;
	struct work_struct work;
	wait_queue_head_t wait_queue;
	struct wake_irq *wakeirq;
	atomic_t usage_count;
	atomic_t child_count;
	unsigned int disable_depth: 3;
	bool idle_notification: 1;
	bool request_pending: 1;
	bool deferred_resume: 1;
	bool needs_force_resume: 1;
	bool runtime_auto: 1;
	bool ignore_children: 1;
	bool no_callbacks: 1;
	bool irq_safe: 1;
	bool use_autosuspend: 1;
	bool timer_autosuspends: 1;
	bool memalloc_noio: 1;
	unsigned int links_count;
	enum rpm_request request;
	enum rpm_status runtime_status;
	enum rpm_status last_status;
	int runtime_error;
	int autosuspend_delay;
	u64 last_busy;
	u64 active_time;
	u64 suspended_time;
	u64 accounting_timestamp;
	struct pm_subsys_data *subsys_data;
	void (*set_latency_tolerance)(struct device *, s32);
	struct dev_pm_qos *qos;
	bool detach_power_off: 1;
};

struct irq_domain;

struct msi_device_data;

struct dev_msi_info {
	struct irq_domain *domain;
	struct msi_device_data *data;
};

struct dev_archdata {};

struct device_private;

struct device_type;

struct bus_type;

struct device_driver;

struct dev_pm_domain;

struct em_perf_domain;

struct dev_pin_info;

struct dma_map_ops;

struct bus_dma_region;

struct device_dma_parameters;

struct dma_coherent_mem;

struct cma;

struct io_tlb_mem;

struct device_node;

struct fwnode_handle;

struct class;

struct attribute_group;

struct iommu_group;

struct dev_iommu;

struct device_physical_location;

struct device {
	struct kobject kobj;
	struct device *parent;
	struct device_private *p;
	const char *init_name;
	const struct device_type *type;
	const struct bus_type *bus;
	struct device_driver *driver;
	void *platform_data;
	void *driver_data;
	struct mutex mutex;
	struct dev_links_info links;
	struct dev_pm_info power;
	struct dev_pm_domain *pm_domain;
	struct em_perf_domain *em_pd;
	struct dev_pin_info *pins;
	struct dev_msi_info msi;
	const struct dma_map_ops *dma_ops;
	u64 *dma_mask;
	u64 coherent_dma_mask;
	u64 bus_dma_limit;
	const struct bus_dma_region *dma_range_map;
	struct device_dma_parameters *dma_parms;
	struct list_head dma_pools;
	struct dma_coherent_mem *dma_mem;
	struct cma *cma_area;
	struct io_tlb_mem *dma_io_tlb_mem;
	struct dev_archdata archdata;
	struct device_node *of_node;
	struct fwnode_handle *fwnode;
	int numa_node;
	dev_t devt;
	u32 id;
	spinlock_t devres_lock;
	struct list_head devres_head;
	const struct class *class;
	const struct attribute_group **groups;
	void (*release)(struct device *);
	struct iommu_group *iommu_group;
	struct dev_iommu *iommu;
	struct device_physical_location *physical_location;
	enum device_removable removable;
	bool offline_disabled: 1;
	bool offline: 1;
	bool of_node_reused: 1;
	bool state_synced: 1;
	bool can_match: 1;
	bool dma_coherent: 1;
	bool dma_skip_sync: 1;
	bool dma_iommu: 1;
};

struct scsi_host_template;

struct scsi_transport_template;

struct workqueue_struct;

struct Scsi_Host {
	struct list_head __devices;
	struct list_head __targets;
	struct list_head starved_list;
	spinlock_t default_lock;
	spinlock_t *host_lock;
	struct mutex scan_mutex;
	struct list_head eh_abort_list;
	struct list_head eh_cmd_q;
	struct task_struct *ehandler;
	struct completion *eh_action;
	wait_queue_head_t host_wait;
	const struct scsi_host_template *hostt;
	struct scsi_transport_template *transportt;
	struct kref tagset_refcnt;
	struct completion tagset_freed;
	struct blk_mq_tag_set tag_set;
	atomic_t host_blocked;
	unsigned int host_failed;
	unsigned int host_eh_scheduled;
	unsigned int host_no;
	int eh_deadline;
	unsigned long last_reset;
	unsigned int max_channel;
	unsigned int max_id;
	u64 max_lun;
	unsigned int unique_id;
	unsigned short max_cmd_len;
	int this_id;
	int can_queue;
	short cmd_per_lun;
	unsigned short sg_tablesize;
	unsigned short sg_prot_tablesize;
	unsigned int max_sectors;
	unsigned int opt_sectors;
	unsigned int max_segment_size;
	unsigned int dma_alignment;
	unsigned long dma_boundary;
	unsigned long virt_boundary_mask;
	unsigned int nr_hw_queues;
	unsigned int nr_maps;
	unsigned int active_mode: 2;
	unsigned int host_self_blocked: 1;
	unsigned int reverse_ordering: 1;
	unsigned int tmf_in_progress: 1;
	unsigned int async_scan: 1;
	unsigned int eh_noresume: 1;
	unsigned int no_write_same: 1;
	unsigned int host_tagset: 1;
	unsigned int queuecommand_may_block: 1;
	unsigned int short_inquiry: 1;
	unsigned int no_scsi2_lun_in_cdb: 1;
	struct workqueue_struct *work_q;
	struct workqueue_struct *tmf_work_q;
	unsigned int max_host_blocked;
	unsigned int prot_capabilities;
	unsigned char prot_guard_type;
	unsigned long base;
	unsigned long io_port;
	unsigned char n_io_port;
	unsigned char dma_channel;
	unsigned int irq;
	enum scsi_host_state shost_state;
	struct device shost_gendev;
	struct device shost_dev;
	void *shost_data;
	struct device *dma_dev;
	int rpm_autosuspend_delay;
	unsigned long hostdata[0];
};

struct SeqDef_s {
	U32 offBase;
	U16 litLength;
	U16 mlBase;
};

typedef size_t (*ZSTD_sequenceProducer_F)(void *, ZSTD_Sequence *, size_t, const void *, size_t, const void *, size_t, int, size_t);

struct ZSTD_CCtx_params_s {
	ZSTD_format_e format;
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
	int compressionLevel;
	int forceWindow;
	size_t targetCBlockSize;
	int srcSizeHint;
	ZSTD_dictAttachPref_e attachDictPref;
	ZSTD_ParamSwitch_e literalCompressionMode;
	int nbWorkers;
	size_t jobSize;
	int overlapLog;
	int rsyncable;
	ldmParams_t ldmParams;
	int enableDedicatedDictSearch;
	ZSTD_bufferMode_e inBufferMode;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_SequenceFormat_e blockDelimiters;
	int validateSequences;
	ZSTD_ParamSwitch_e postBlockSplitter;
	int preBlockSplitter_level;
	size_t maxBlockSize;
	ZSTD_ParamSwitch_e useRowMatchFinder;
	int deterministicRefPrefix;
	ZSTD_customMem customMem;
	ZSTD_ParamSwitch_e prefetchCDictTables;
	int enableMatchFinderFallback;
	void *extSeqProdState;
	ZSTD_sequenceProducer_F extSeqProdFunc;
	ZSTD_ParamSwitch_e searchForExternalRepcodes;
};

typedef struct ZSTD_CCtx_params_s ZSTD_CCtx_params;

struct xxh64_state {
	uint64_t total_len;
	uint64_t v1;
	uint64_t v2;
	uint64_t v3;
	uint64_t v4;
	uint64_t mem64[4];
	uint32_t memsize;
};

struct POOL_ctx_s;

typedef struct POOL_ctx_s ZSTD_threadPool;

struct ZSTD_inBuffer_s {
	const void *src;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_inBuffer_s ZSTD_inBuffer;

struct ZSTD_prefixDict_s {
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
};

typedef struct ZSTD_prefixDict_s ZSTD_prefixDict;

struct ZSTD_CCtx_s {
	ZSTD_compressionStage_e stage;
	int cParamsChanged;
	int bmi2;
	ZSTD_CCtx_params requestedParams;
	ZSTD_CCtx_params appliedParams;
	ZSTD_CCtx_params simpleApiParams;
	U32 dictID;
	size_t dictContentSize;
	ZSTD_cwksp workspace;
	size_t blockSizeMax;
	unsigned long long pledgedSrcSizePlusOne;
	unsigned long long consumedSrcSize;
	unsigned long long producedCSize;
	struct xxh64_state xxhState;
	ZSTD_customMem customMem;
	ZSTD_threadPool *pool;
	size_t staticSize;
	SeqCollector seqCollector;
	int isFirstBlock;
	int initialized;
	SeqStore_t seqStore;
	ldmState_t ldmState;
	rawSeq *ldmSequences;
	size_t maxNbLdmSequences;
	RawSeqStore_t externSeqStore;
	ZSTD_blockState_t blockState;
	void *tmpWorkspace;
	size_t tmpWkspSize;
	ZSTD_buffered_policy_e bufferedPolicy;
	char *inBuff;
	size_t inBuffSize;
	size_t inToCompress;
	size_t inBuffPos;
	size_t inBuffTarget;
	char *outBuff;
	size_t outBuffSize;
	size_t outBuffContentSize;
	size_t outBuffFlushedSize;
	ZSTD_cStreamStage streamStage;
	U32 frameEnded;
	ZSTD_inBuffer expectedInBuffer;
	size_t stableIn_notConsumed;
	size_t expectedOutBufferSize;
	ZSTD_localDict localDict;
	const ZSTD_CDict *cdict;
	ZSTD_prefixDict prefixDict;
	ZSTD_blockSplitCtx blockSplitCtx;
	ZSTD_Sequence *extSeqBuf;
	size_t extSeqBufCapacity;
};

typedef struct ZSTD_CCtx_s ZSTD_CCtx;

typedef ZSTD_CCtx ZSTD_CStream;

typedef ZSTD_CCtx zstd_cctx;

typedef ZSTD_CStream zstd_cstream;

struct ZSTD_CDict_s {
	const void *dictContent;
	size_t dictContentSize;
	ZSTD_dictContentType_e dictContentType;
	U32 *entropyWorkspace;
	ZSTD_cwksp workspace;
	ZSTD_MatchState_t matchState;
	ZSTD_compressedBlockState_t cBlockState;
	ZSTD_customMem customMem;
	U32 dictID;
	int compressionLevel;
	ZSTD_ParamSwitch_e useRowMatchFinder;
};

typedef ZSTD_CDict zstd_cdict;

struct ZSTD_outBuffer_s {
	void *dst;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_outBuffer_s ZSTD_outBuffer;

struct ZSTD_DCtx_s {
	const ZSTD_seqSymbol *LLTptr;
	const ZSTD_seqSymbol *MLTptr;
	const ZSTD_seqSymbol *OFTptr;
	const HUF_DTable *HUFptr;
	ZSTD_entropyDTables_t entropy;
	U32 workspace[640];
	const void *previousDstEnd;
	const void *prefixStart;
	const void *virtualStart;
	const void *dictEnd;
	size_t expected;
	ZSTD_FrameHeader fParams;
	U64 processedCSize;
	U64 decodedSize;
	blockType_e bType;
	ZSTD_dStage stage;
	U32 litEntropy;
	U32 fseEntropy;
	struct xxh64_state xxhState;
	size_t headerSize;
	ZSTD_format_e format;
	ZSTD_forceIgnoreChecksum_e forceIgnoreChecksum;
	U32 validateChecksum;
	const BYTE *litPtr;
	ZSTD_customMem customMem;
	size_t litSize;
	size_t rleSize;
	size_t staticSize;
	int isFrameDecompression;
	ZSTD_DDict *ddictLocal;
	const ZSTD_DDict *ddict;
	U32 dictID;
	int ddictIsCold;
	ZSTD_dictUses_e dictUses;
	ZSTD_DDictHashSet *ddictSet;
	ZSTD_refMultipleDDicts_e refMultipleDDicts;
	int disableHufAsm;
	int maxBlockSizeParam;
	ZSTD_dStreamStage streamStage;
	char *inBuff;
	size_t inBuffSize;
	size_t inPos;
	size_t maxWindowSize;
	char *outBuff;
	size_t outBuffSize;
	size_t outStart;
	size_t outEnd;
	size_t lhSize;
	U32 hostageByte;
	int noForwardProgress;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_outBuffer expectedOutBuffer;
	BYTE *litBuffer;
	const BYTE *litBufferEnd;
	ZSTD_litLocation_e litBufferLocation;
	BYTE litExtraBuffer[65568];
	BYTE headerBuffer[18];
	size_t oversizedDuration;
};

typedef struct ZSTD_DCtx_s ZSTD_DCtx;

typedef ZSTD_DCtx ZSTD_DStream;

typedef ZSTD_DCtx zstd_dctx;

typedef ZSTD_DStream zstd_dstream;

struct ZSTD_DDict_s {
	void *dictBuffer;
	const void *dictContent;
	size_t dictSize;
	ZSTD_entropyDTables_t entropy;
	U32 dictID;
	U32 entropyPresent;
	ZSTD_customMem cMem;
};

typedef ZSTD_DDict zstd_ddict;

typedef ZSTD_inBuffer zstd_in_buffer;

typedef ZSTD_outBuffer zstd_out_buffer;

union _MFI_CAPABILITIES {
	struct {
		u32 support_fp_remote_lun: 1;
		u32 support_additional_msix: 1;
		u32 support_fastpath_wb: 1;
		u32 support_max_255lds: 1;
		u32 support_ndrive_r1_lb: 1;
		u32 support_core_affinity: 1;
		u32 security_protocol_cmds_fw: 1;
		u32 support_ext_queue_depth: 1;
		u32 support_ext_io_size: 1;
		u32 support_vfid_in_ioframe: 1;
		u32 support_fp_rlbypass: 1;
		u32 support_qd_throttling: 1;
		u32 support_pd_map_target_id: 1;
		u32 support_64bit_mode: 1;
		u32 support_nvme_passthru: 1;
		u32 support_fw_exposed_dev_list: 1;
		u32 support_memdump: 1;
		u32 reserved: 15;
	} mfi_capabilities;
	__le32 reg;
};

typedef union _MFI_CAPABILITIES MFI_CAPABILITIES;

struct __aio_sigset {
	const sigset_t __attribute__((btf_type_tag("user"))) *sigmask;
	size_t sigsetsize;
};

struct llist_node {
	struct llist_node *next;
};

struct __call_single_node {
	struct llist_node llist;
	union {
		unsigned int u_flags;
		atomic_t a_flags;
	};
	u16 src;
	u16 dst;
};

typedef void (*smp_call_func_t)(void *);

struct __call_single_data {
	struct __call_single_node node;
	smp_call_func_t func;
	void *info;
};

typedef struct __call_single_data call_single_data_t;

struct idr;

struct __class_idr {
	struct idr *idr;
	int id;
};

typedef struct __class_idr class_idr_alloc_t;

struct cpumask;

struct __cmp_key {
	const struct cpumask *cpus;
	struct cpumask ***masks;
	int node;
	int cpu;
	int w;
};

struct __compat_aio_sigset {
	compat_uptr_t sigmask;
	compat_size_t sigsetsize;
};

struct __extcon_info {
	unsigned int type;
	unsigned int id;
	const char *name;
};

struct __fat_dirent {
	long d_ino;
	__kernel_off_t d_off;
	unsigned short d_reclen;
	char d_name[256];
};

struct __fb_timings {
	u32 dclk;
	u32 hfreq;
	u32 vfreq;
	u32 hactive;
	u32 vactive;
	u32 hblank;
	u32 vblank;
	u32 htotal;
	u32 vtotal;
};

union __fpsimd_vreg {
	__uint128_t raw;
	struct {
		u64 lo;
		u64 hi;
	};
};

struct arm64_ftr_reg;

struct __ftr_reg_entry {
	u32 sys_id;
	struct arm64_ftr_reg *reg;
};

struct genradix_root;

struct __genradix {
	struct genradix_root *root;
};

struct pmu;

struct cgroup;

struct __group_key {
	int cpu;
	struct pmu *pmu;
	struct cgroup *cgroup;
};

struct sha256_block_state {
	u32 h[8];
};

struct __sha256_ctx {
	struct sha256_block_state state;
	u64 bytecount;
	u8 buf[64];
};

struct __hmac_sha256_ctx {
	struct __sha256_ctx sha_ctx;
	struct sha256_block_state ostate;
};

struct __hmac_sha256_key {
	struct sha256_block_state istate;
	struct sha256_block_state ostate;
};

struct sha512_block_state {
	u64 h[8];
};

struct __sha512_ctx {
	struct sha512_block_state state;
	u64 bytecount_lo;
	u64 bytecount_hi;
	u8 buf[128];
};

struct __hmac_sha512_ctx {
	struct __sha512_ctx sha_ctx;
	struct sha512_block_state ostate;
};

struct __hmac_sha512_key {
	struct sha512_block_state istate;
	struct sha512_block_state ostate;
};

struct __kernel_timespec {
	__kernel_time64_t tv_sec;
	long long tv_nsec;
};

struct __kernel_itimerspec {
	struct __kernel_timespec it_interval;
	struct __kernel_timespec it_value;
};

struct __kernel_old_timeval {
	__kernel_long_t tv_sec;
	__kernel_long_t tv_usec;
};

struct __kernel_old_itimerval {
	struct __kernel_old_timeval it_interval;
	struct __kernel_old_timeval it_value;
};

struct __kernel_old_timespec {
	__kernel_old_time_t tv_sec;
	long tv_nsec;
};

struct __kernel_sock_timeval {
	__s64 tv_sec;
	__s64 tv_usec;
};

struct __kernel_sockaddr_storage {
	union {
		struct {
			__kernel_sa_family_t ss_family;
			char __data[126];
		};
		void *__align;
	};
};

struct __kernel_timex_timeval {
	__kernel_time64_t tv_sec;
	long long tv_usec;
};

struct __kernel_timex {
	unsigned int modes;
	long long offset;
	long long freq;
	long long maxerror;
	long long esterror;
	int status;
	long long constant;
	long long precision;
	long long tolerance;
	struct __kernel_timex_timeval time;
	long long tick;
	long long ppsfreq;
	long long jitter;
	int shift;
	long long stabil;
	long long jitcnt;
	long long calcnt;
	long long errcnt;
	long long stbcnt;
	int tai;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct __kfifo {
	unsigned int in;
	unsigned int out;
	unsigned int mask;
	unsigned int esize;
	void *data;
};

struct qm_cgr_wr_parm {
	__be32 word;
};

struct qm_cgr_cs_thres {
	__be16 word;
};

struct __qm_mc_cgr {
	struct qm_cgr_wr_parm wr_parm_g;
	struct qm_cgr_wr_parm wr_parm_y;
	struct qm_cgr_wr_parm wr_parm_r;
	u8 wr_en_g;
	u8 wr_en_y;
	u8 wr_en_r;
	u8 cscn_en;
	union {
		struct {
			__be16 cscn_targ_upd_ctrl;
			__be16 cscn_targ_dcp_low;
		};
		__be32 cscn_targ;
	};
	u8 cstd_en;
	u8 cs;
	struct qm_cgr_cs_thres cs_thres;
	u8 mode;
} __attribute__((packed));

struct __qm_mcr_querycongestion {
	u32 state[8];
};

union sigval {
	int sival_int;
	void __attribute__((btf_type_tag("user"))) *sival_ptr;
};

typedef union sigval sigval_t;

union __sifields {
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
	} _kill;
	struct {
		__kernel_timer_t _tid;
		int _overrun;
		sigval_t _sigval;
		int _sys_private;
	} _timer;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		sigval_t _sigval;
	} _rt;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		int _status;
		__kernel_clock_t _utime;
		__kernel_clock_t _stime;
	} _sigchld;
	struct {
		void __attribute__((btf_type_tag("user"))) *_addr;
		union {
			int _trapno;
			short _addr_lsb;
			struct {
				char _dummy_bnd[8];
				void __attribute__((btf_type_tag("user"))) *_lower;
				void __attribute__((btf_type_tag("user"))) *_upper;
			} _addr_bnd;
			struct {
				char _dummy_pkey[8];
				__u32 _pkey;
			} _addr_pkey;
			struct {
				unsigned long _data;
				__u32 _type;
				__u32 _flags;
			} _perf;
		};
	} _sigfault;
	struct {
		long _band;
		int _fd;
	} _sigpoll;
	struct {
		void __attribute__((btf_type_tag("user"))) *_call_addr;
		int _syscall;
		unsigned int _arch;
	} _sigsys;
};

struct bpf_flow_keys;

struct bpf_sock;

struct __sk_buff {
	__u32 len;
	__u32 pkt_type;
	__u32 mark;
	__u32 queue_mapping;
	__u32 protocol;
	__u32 vlan_present;
	__u32 vlan_tci;
	__u32 vlan_proto;
	__u32 priority;
	__u32 ingress_ifindex;
	__u32 ifindex;
	__u32 tc_index;
	__u32 cb[5];
	__u32 hash;
	__u32 tc_classid;
	__u32 data;
	__u32 data_end;
	__u32 napi_id;
	__u32 family;
	__u32 remote_ip4;
	__u32 local_ip4;
	__u32 remote_ip6[4];
	__u32 local_ip6[4];
	__u32 remote_port;
	__u32 local_port;
	__u32 data_meta;
	union {
		struct bpf_flow_keys *flow_keys;
	};
	__u64 tstamp;
	__u32 wire_len;
	__u32 gso_segs;
	union {
		struct bpf_sock *sk;
	};
	__u32 gso_size;
	__u8 tstamp_type;
	__u64 hwtstamp;
};

struct dentry;

struct __track_dentry_update_args {
	struct dentry *dentry;
	int op;
};

struct __track_range_args {
	ext4_lblk_t start;
	ext4_lblk_t end;
};

union __u128_halves {
	u128 full;
	struct {
		u64 low;
		u64 high;
	};
};

struct __user_cap_data_struct {
	__u32 effective;
	__u32 permitted;
	__u32 inheritable;
};

typedef struct __user_cap_data_struct __attribute__((btf_type_tag("user"))) *cap_user_data_t;

struct __user_cap_header_struct {
	__u32 version;
	int pid;
};

typedef struct __user_cap_header_struct *cap_user_header_t;

struct __va_list {
	void *__stack;
	void *__gr_top;
	void *__vr_top;
	int __gr_offs;
	int __vr_offs;
};

typedef __builtin_va_list va_list;

struct _aarch64_ctx {
	__u32 magic;
	__u32 size;
};

struct _arg_GO {
	u8 chan;
	u32 addr;
	unsigned int ns;
};

struct _arg_LPEND {
	enum pl330_cond cond;
	bool forever;
	unsigned int loop;
	u8 bjump;
};

struct _ccu_mult {
	unsigned long mult;
	unsigned long min;
	unsigned long max;
};

struct _ccu_nk {
	unsigned long n;
	unsigned long min_n;
	unsigned long max_n;
	unsigned long k;
	unsigned long min_k;
	unsigned long max_k;
};

struct _ccu_nkm {
	unsigned long n;
	unsigned long min_n;
	unsigned long max_n;
	unsigned long k;
	unsigned long min_k;
	unsigned long max_k;
	unsigned long m;
	unsigned long min_m;
	unsigned long max_m;
};

struct _ccu_nkmp {
	unsigned long n;
	unsigned long min_n;
	unsigned long max_n;
	unsigned long k;
	unsigned long min_k;
	unsigned long max_k;
	unsigned long m;
	unsigned long min_m;
	unsigned long max_m;
	unsigned long p;
	unsigned long min_p;
	unsigned long max_p;
};

struct _ccu_nm {
	unsigned long n;
	unsigned long min_n;
	unsigned long max_n;
	unsigned long m;
	unsigned long min_m;
	unsigned long max_m;
};

struct _flow_keys_digest_data {
	__be16 n_proto;
	u8 ip_proto;
	u8 padding;
	__be32 ports;
	__be32 src;
	__be32 dst;
};

struct _gpiochip_for_each_data {
	const char **label;
	unsigned int *i;
};

typedef struct _gpiochip_for_each_data class__gpiochip_for_each_data_t;

struct _gpt_entry_attributes {
	u64 required_to_function: 1;
	u64 reserved: 47;
	u64 type_guid_specific: 16;
};

typedef struct _gpt_entry_attributes gpt_entry_attributes;

struct _gpt_entry {
	efi_guid_t partition_type_guid;
	efi_guid_t unique_partition_guid;
	__le64 starting_lba;
	__le64 ending_lba;
	gpt_entry_attributes attributes;
	__le16 partition_name[36];
};

typedef struct _gpt_entry gpt_entry;

struct _gpt_header {
	__le64 signature;
	__le32 revision;
	__le32 header_size;
	__le32 header_crc32;
	__le32 reserved1;
	__le64 my_lba;
	__le64 alternate_lba;
	__le64 first_usable_lba;
	__le64 last_usable_lba;
	efi_guid_t disk_guid;
	__le64 partition_entry_lba;
	__le32 num_partition_entries;
	__le32 sizeof_partition_entry;
	__le32 partition_entry_array_crc32;
} __attribute__((packed));

typedef struct _gpt_header gpt_header;

struct _gpt_mbr_record {
	u8 boot_indicator;
	u8 start_head;
	u8 start_sector;
	u8 start_track;
	u8 os_type;
	u8 end_head;
	u8 end_sector;
	u8 end_track;
	__le32 starting_lba;
	__le32 size_in_lba;
};

typedef struct _gpt_mbr_record gpt_mbr_record;

struct kvm_io_device_ops;

struct kvm_io_device {
	const struct kvm_io_device_ops *ops;
};

struct eventfd_ctx;

struct _ioeventfd {
	struct list_head list;
	u64 addr;
	int length;
	struct eventfd_ctx *eventfd;
	u64 datamatch;
	struct kvm_io_device dev;
	u8 bus_idx;
	bool wildcard;
};

struct kvm_stats_desc {
	__u32 flags;
	__s16 exponent;
	__u16 size;
	__u32 offset;
	__u32 bucket_size;
	char name[0];
};

struct _kvm_stats_desc {
	struct kvm_stats_desc desc;
	char name[48];
};

struct _legacy_mbr {
	u8 boot_code[440];
	__le32 unique_mbr_signature;
	__le16 unknown;
	gpt_mbr_record partition_record[4];
	__le16 signature;
} __attribute__((packed));

typedef struct _legacy_mbr legacy_mbr;

struct dma_pl330_desc;

struct _pl330_req {
	u32 mc_bus;
	void *mc_cpu;
	struct dma_pl330_desc *desc;
};

struct _pl330_tbd {
	bool reset_dmac;
	bool reset_mngr;
	u8 reset_chan;
};

struct _scpi_sensor_info {
	__le16 sensor_id;
	u8 class;
	u8 trigger_type;
	char name[20];
};

struct _xfer_spec {
	u32 ccr;
	struct dma_pl330_desc *desc;
};

struct spi_controller;

struct clk;

struct a3700_spi {
	struct spi_controller *host;
	void *base;
	struct clk *clk;
	unsigned int irq;
	unsigned int flags;
	bool xmit_data;
	const u8 *tx_buf;
	u8 *rx_buf;
	size_t buf_len;
	u8 byte_len;
	u32 wait_mask;
	struct completion done;
};

struct aarch64_insn_patch {
	void **text_addrs;
	u32 *new_insns;
	int insn_cnt;
	atomic_t cpu_count;
};

struct reg_sequence;

struct acc_desc {
	unsigned int enable_reg;
	u32 enable_mask;
	struct reg_sequence *config;
	struct reg_sequence *settings;
	int num_regs_per_fuse;
};

struct access_coordinate {
	unsigned int read_bandwidth;
	unsigned int write_bandwidth;
	unsigned int read_latency;
	unsigned int write_latency;
};

struct acct_v3 {
	char ac_flag;
	char ac_version;
	__u16 ac_tty;
	__u32 ac_exitcode;
	__u32 ac_uid;
	__u32 ac_gid;
	__u32 ac_pid;
	__u32 ac_ppid;
	__u32 ac_btime;
	__u32 ac_etime;
	comp_t ac_utime;
	comp_t ac_stime;
	comp_t ac_mem;
	comp_t ac_io;
	comp_t ac_rw;
	comp_t ac_minflt;
	comp_t ac_majflt;
	comp_t ac_swaps;
	char ac_comm[16];
};

typedef struct acct_v3 acct_t;

struct ack_sample {
	u32 pkts_acked;
	s32 rtt_us;
	u32 in_flight;
};

struct crypto_tfm;

struct cipher_alg {
	unsigned int cia_min_keysize;
	unsigned int cia_max_keysize;
	int (*cia_setkey)(struct crypto_tfm *, const u8 *, unsigned int);
	void (*cia_encrypt)(struct crypto_tfm *, u8 *, const u8 *);
	void (*cia_decrypt)(struct crypto_tfm *, u8 *, const u8 *);
};

struct crypto_type;

struct crypto_alg {
	struct list_head cra_list;
	struct list_head cra_users;
	u32 cra_flags;
	unsigned int cra_blocksize;
	unsigned int cra_ctxsize;
	unsigned int cra_alignmask;
	unsigned int cra_reqsize;
	int cra_priority;
	refcount_t cra_refcnt;
	char cra_name[128];
	char cra_driver_name[128];
	const struct crypto_type *cra_type;
	union {
		struct cipher_alg cipher;
	} cra_u;
	int (*cra_init)(struct crypto_tfm *);
	void (*cra_exit)(struct crypto_tfm *);
	void (*cra_destroy)(struct crypto_alg *);
	struct module *cra_module;
};

struct comp_alg_common {
	struct crypto_alg base;
};

struct acomp_req;

struct crypto_acomp;

struct acomp_alg {
	int (*compress)(struct acomp_req *);
	int (*decompress)(struct acomp_req *);
	int (*init)(struct crypto_acomp *);
	void (*exit)(struct crypto_acomp *);
	union {
		struct {
			struct crypto_alg base;
		};
		struct comp_alg_common calg;
	};
};

typedef void (*crypto_completion_t)(void *, int);

struct crypto_async_request {
	struct list_head list;
	crypto_completion_t complete;
	void *data;
	struct crypto_tfm *tfm;
	u32 flags;
};

struct scatterlist {
	unsigned long page_link;
	unsigned int offset;
	unsigned int length;
	dma_addr_t dma_address;
	unsigned int dma_length;
	unsigned int dma_flags;
};

struct acomp_req_chain {
	crypto_completion_t compl;
	void *data;
	struct scatterlist ssg;
	struct scatterlist dsg;
	union {
		const u8 *src;
		struct folio *sfolio;
	};
	union {
		u8 *dst;
		struct folio *dfolio;
	};
	u32 flags;
};

struct acomp_req {
	struct crypto_async_request base;
	union {
		struct scatterlist *src;
		const u8 *svirt;
	};
	union {
		struct scatterlist *dst;
		u8 *dvirt;
	};
	unsigned int slen;
	unsigned int dlen;
	struct acomp_req_chain chain;
	void *__ctx[0];
};

union crypto_no_such_thing;

struct scatter_walk {
	union {
		void * const addr;
		union crypto_no_such_thing *__addr;
	};
	struct scatterlist *sg;
	unsigned int offset;
};

struct acomp_walk {
	union {
		struct {
			struct {
				const void * const addr;
			} virt;
		} src;
		struct scatter_walk in;
	};
	union {
		struct {
			struct {
				void * const addr;
			} virt;
		} dst;
		struct scatter_walk out;
	};
	unsigned int slen;
	unsigned int dlen;
	int flags;
};

struct power_supply;

union power_supply_propval;

struct power_supply_desc {
	const char *name;
	enum power_supply_type type;
	u8 charge_behaviours;
	u32 charge_types;
	u32 usb_types;
	const enum power_supply_property *properties;
	size_t num_properties;
	int (*get_property)(struct power_supply *, enum power_supply_property, union power_supply_propval *);
	int (*set_property)(struct power_supply *, enum power_supply_property, const union power_supply_propval *);
	int (*property_is_writeable)(struct power_supply *, enum power_supply_property);
	void (*external_power_changed)(struct power_supply *);
	bool no_thermal;
	int use_for_apm;
};

struct notifier_block;

typedef int (*notifier_fn_t)(struct notifier_block *, unsigned long, void *);

struct notifier_block {
	notifier_fn_t notifier_call;
	struct notifier_block __attribute__((btf_type_tag("rcu"))) *next;
	int priority;
};

struct acpi_device;

struct acpi_ac {
	struct power_supply *charger;
	struct power_supply_desc charger_desc;
	struct acpi_device *device;
	unsigned long long state;
	struct notifier_block battery_nb;
};

struct acpi_address16_attribute {
	u16 granularity;
	u16 minimum;
	u16 maximum;
	u16 translation_offset;
	u16 address_length;
};

struct acpi_address32_attribute {
	u32 granularity;
	u32 minimum;
	u32 maximum;
	u32 translation_offset;
	u32 address_length;
};

struct acpi_address64_attribute {
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
};

struct acpi_namespace_node;

struct acpi_address_range {
	struct acpi_address_range *next;
	struct acpi_namespace_node *region_node;
	acpi_physical_address start_address;
	acpi_physical_address end_address;
};

struct acpi_apmt_node {
	u16 length;
	u8 flags;
	u8 type;
	u32 id;
	u64 inst_primary;
	u32 inst_secondary;
	u64 base_address0;
	u64 base_address1;
	u32 ovflw_irq;
	u32 reserved;
	u32 ovflw_irq_flags;
	u32 proc_affinity;
	u32 impl_id;
} __attribute__((packed));

struct acpi_battery {
	struct mutex lock;
	struct mutex update_lock;
	struct power_supply *bat;
	struct power_supply_desc bat_desc;
	struct acpi_device *device;
	struct notifier_block pm_nb;
	struct list_head list;
	unsigned long update_time;
	int revision;
	int rate_now;
	int capacity_now;
	int voltage_now;
	int design_capacity;
	int full_charge_capacity;
	int technology;
	int design_voltage;
	int design_capacity_warning;
	int design_capacity_low;
	int cycle_count;
	int measurement_accuracy;
	int max_sampling_time;
	int min_sampling_time;
	int max_averaging_interval;
	int min_averaging_interval;
	int capacity_granularity_1;
	int capacity_granularity_2;
	int alarm;
	char model_number[64];
	char serial_number[64];
	char type[64];
	char oem_info[64];
	int state;
	int power_unit;
	unsigned long flags;
};

struct acpi_battery_hook {
	const char *name;
	int (*add_battery)(struct power_supply *, struct acpi_battery_hook *);
	int (*remove_battery)(struct power_supply *, struct acpi_battery_hook *);
	struct list_head list;
};

struct acpi_bert_region {
	u32 block_status;
	u32 raw_data_offset;
	u32 raw_data_length;
	u32 data_length;
	u32 error_severity;
};

struct acpi_buffer {
	acpi_size length;
	void *pointer;
};

struct acpi_bus_event {
	struct list_head node;
	acpi_device_class device_class;
	acpi_bus_id bus_id;
	u32 type;
	u32 data;
};

struct acpi_bus_type {
	struct list_head list;
	const char *name;
	bool (*match)(struct device *);
	struct acpi_device * (*find_companion)(struct device *);
	void (*setup)(struct device *);
};

struct input_dev;

struct acpi_button {
	unsigned int type;
	struct input_dev *input;
	char phys[32];
	unsigned long pushed;
	int last_state;
	ktime_t last_time;
	bool suspended;
	bool lid_state_initialized;
};

struct acpi_cdat_header {
	u8 type;
	u8 reserved;
	u16 length;
};

struct acpi_cedt_header {
	u8 type;
	u8 reserved;
	u16 length;
};

struct acpi_cedt_cfmws {
	struct acpi_cedt_header header;
	u32 reserved1;
	u64 base_hpa;
	u64 window_size;
	u8 interleave_ways;
	u8 interleave_arithmetic;
	u16 reserved2;
	u32 granularity;
	u16 restrictions;
	u16 qtg_id;
	u32 interleave_targets[0];
} __attribute__((packed));

struct acpi_comment_node {
	char *comment;
	struct acpi_comment_node *next;
};

struct acpi_common_descriptor {
	void *common_pointer;
	u8 descriptor_type;
};

struct acpi_common_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
};

struct acpi_connection_info {
	u8 *connection;
	u16 length;
	u8 access_length;
};

union acpi_parse_object;

struct acpi_control_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u16 opcode;
	union acpi_parse_object *predicate_op;
	u8 *aml_predicate_start;
	u8 *package_end;
	u64 loop_timeout;
};

struct acpi_create_field_info {
	struct acpi_namespace_node *region_node;
	struct acpi_namespace_node *field_node;
	struct acpi_namespace_node *register_node;
	struct acpi_namespace_node *data_register_node;
	struct acpi_namespace_node *connection_node;
	u8 *resource_buffer;
	u32 bank_value;
	u32 field_bit_position;
	u32 field_bit_length;
	u16 resource_length;
	u16 pin_number_index;
	u8 field_flags;
	u8 attribute;
	u8 field_type;
	u8 access_length;
};

struct acpi_csrt_group {
	u32 length;
	u32 vendor_id;
	u32 subvendor_id;
	u16 device_id;
	u16 subdevice_id;
	u16 revision;
	u16 reserved;
	u32 shared_info_length;
};

struct acpi_csrt_shared_info {
	u16 major_version;
	u16 minor_version;
	u32 mmio_base_low;
	u32 mmio_base_high;
	u32 gsi_interrupt;
	u8 interrupt_polarity;
	u8 interrupt_mode;
	u8 num_channels;
	u8 dma_address_width;
	u16 base_request_line;
	u16 num_handshake_signals;
	u32 max_block_size;
};

struct attribute {
	const char *name;
	umode_t mode;
};

struct address_space;

struct file;

struct vm_area_struct;

struct bin_attribute {
	struct attribute attr;
	size_t size;
	void *private;
	struct address_space * (*f_mapping)(void);
	ssize_t (*read)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	loff_t (*llseek)(struct file *, struct kobject *, const struct bin_attribute *, loff_t, int);
	int (*mmap)(struct file *, struct kobject *, const struct bin_attribute *, struct vm_area_struct *);
};

struct acpi_data_attr {
	struct bin_attribute attr;
	u64 addr;
};

typedef void *acpi_handle;

struct fwnode_operations;

struct fwnode_handle {
	struct fwnode_handle *secondary;
	const struct fwnode_operations *ops;
	struct device *dev;
	struct list_head suppliers;
	struct list_head consumers;
	u8 flags;
};

union acpi_object;

struct acpi_device_data {
	const union acpi_object *pointer;
	struct list_head properties;
	const union acpi_object *of_compatible;
	struct list_head subnodes;
};

struct acpi_data_node {
	struct list_head sibling;
	const char *name;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct fwnode_handle *parent;
	struct acpi_device_data data;
	struct kobject kobj;
	struct completion kobj_done;
};

struct acpi_data_node_attr {
	struct attribute attr;
	ssize_t (*show)(struct acpi_data_node *, char *);
	ssize_t (*store)(struct acpi_data_node *, const char *, size_t);
};

struct acpi_data_obj {
	char *name;
	int (*fn)(void *, struct acpi_data_attr *);
};

struct acpi_data_table_mapping {
	void *pointer;
};

struct acpi_dep_data {
	struct list_head node;
	acpi_handle supplier;
	acpi_handle consumer;
	bool honor_dep;
	bool met;
	bool free_when_met;
};

union acpi_operand_object;

struct acpi_object_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
};

struct acpi_object_integer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 fill[3];
	u64 value;
};

struct acpi_object_string {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	char *pointer;
	u32 length;
};

struct acpi_object_buffer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 *pointer;
	u32 length;
	u32 aml_length;
	u8 *aml_start;
	struct acpi_namespace_node *node;
};

struct acpi_object_package {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	union acpi_operand_object **elements;
	u8 *aml_start;
	u32 aml_length;
	u32 count;
};

struct acpi_object_event {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	void *os_semaphore;
};

struct acpi_walk_state;

typedef acpi_status (*acpi_internal_method)(struct acpi_walk_state *);

struct acpi_object_method {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 info_flags;
	u8 param_count;
	u8 sync_level;
	union acpi_operand_object *mutex;
	union acpi_operand_object *node;
	u8 *aml_start;
	union {
		acpi_internal_method implementation;
		union acpi_operand_object *handler;
	} dispatch;
	u32 aml_length;
	acpi_owner_id owner_id;
	u8 thread_count;
};

struct acpi_thread_state;

struct acpi_object_mutex {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 sync_level;
	u16 acquisition_depth;
	void *os_mutex;
	u64 thread_id;
	struct acpi_thread_state *owner_thread;
	union acpi_operand_object *prev;
	union acpi_operand_object *next;
	struct acpi_namespace_node *node;
	u8 original_sync_level;
};

struct acpi_object_region {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler;
	union acpi_operand_object *next;
	acpi_physical_address address;
	u32 length;
	void *pointer;
};

struct acpi_object_notify_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
};

struct acpi_gpe_block_info;

struct acpi_object_device {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	struct acpi_gpe_block_info *gpe_block;
};

struct acpi_object_power_resource {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	u32 system_level;
	u32 resource_order;
};

struct acpi_object_processor {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 proc_id;
	u8 length;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	acpi_io_address address;
};

struct acpi_object_thermal_zone {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
};

struct acpi_object_field_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
};

struct acpi_object_region_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u16 resource_length;
	union acpi_operand_object *region_obj;
	u8 *resource_buffer;
	u16 pin_number_index;
	u8 *internal_pcc_buffer;
};

struct acpi_object_buffer_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u8 is_create_field;
	union acpi_operand_object *buffer_obj;
};

struct acpi_object_bank_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8