#ifndef _ASM_X86_CPUFEATUREMASKS_H
#define _ASM_X86_CPUFEATUREMASKS_H

/*
 * REQUIRED features:
 *
 *    FPU PSE MSR PAE CX8 PGE CMOV FXSR XMM XMM2 LM NOPL ALWAYS CPUID
 */
#define REQUIRED_MASK0	0x0700a169U
#define REQUIRED_MASK1	0x20000000U
#define REQUIRED_MASK2	0x00000000U
#define REQUIRED_MASK3	0x02300000U
#define REQUIRED_MASK4	0x00000000U
#define REQUIRED_MASK5	0x00000000U
#define REQUIRED_MASK6	0x00000000U
#define REQUIRED_MASK7	0x00000000U
#define REQUIRED_MASK8	0x00000000U
#define REQUIRED_MASK9	0x00000000U
#define REQUIRED_MASK10	0x00000000U
#define REQUIRED_MASK11	0x00000000U
#define REQUIRED_MASK12	0x00000000U
#define REQUIRED_MASK13	0x00000000U
#define REQUIRED_MASK14	0x00000000U
#define REQUIRED_MASK15	0x00000000U
#define REQUIRED_MASK16	0x00000000U
#define REQUIRED_MASK17	0x00000000U
#define REQUIRED_MASK18	0x00000000U
#define REQUIRED_MASK19	0x00000000U
#define REQUIRED_MASK20	0x00000000U
#define REQUIRED_MASK21	0x00000000U

#define REQUIRED_MASK_BIT_SET(x)			\
	((						\
		((x) >> 5) ==  0 ? REQUIRED_MASK0 :	\
		((x) >> 5) ==  1 ? REQUIRED_MASK1 :	\
		((x) >> 5) ==  3 ? REQUIRED_MASK3 : 0	\
	) & (1U << ((x) & 31)))

/*
 * DISABLED features:
 *
 *    VME K6_MTRR CYRIX_ARR CENTAUR_MCR XENPV TDX_GUEST SGX USER_SHSTK LAM
 *    ENQCMD SEV_SNP
 */
#define DISABLED_MASK0	0x00000002U
#define DISABLED_MASK1	0x00000000U
#define DISABLED_MASK2	0x00000000U
#define DISABLED_MASK3	0x0000000eU
#define DISABLED_MASK4	0x00000000U
#define DISABLED_MASK5	0x00000000U
#define DISABLED_MASK6	0x00000000U
#define DISABLED_MASK7	0x00000000U
#define DISABLED_MASK8	0x00410000U
#define DISABLED_MASK9	0x00000004U
#define DISABLED_MASK10	0x00000000U
#define DISABLED_MASK11	0x00800000U
#define DISABLED_MASK12	0x04000000U
#define DISABLED_MASK13	0x00000000U
#define DISABLED_MASK14	0x00000000U
#define DISABLED_MASK15	0x00000000U
#define DISABLED_MASK16	0x20000000U
#define DISABLED_MASK17	0x00000000U
#define DISABLED_MASK18	0x00000000U
#define DISABLED_MASK19	0x00000010U
#define DISABLED_MASK20	0x00000000U
#define DISABLED_MASK21	0x00000000U

#define DISABLED_MASK_BIT_SET(x)			\
	((						\
		((x) >> 5) ==  0 ? DISABLED_MASK0 :	\
		((x) >> 5) ==  3 ? DISABLED_MASK3 :	\
		((x) >> 5) ==  8 ? DISABLED_MASK8 :	\
		((x) >> 5) ==  9 ? DISABLED_MASK9 :	\
		((x) >> 5) == 11 ? DISABLED_MASK11 :	\
		((x) >> 5) == 12 ? DISABLED_MASK12 :	\
		((x) >> 5) == 16 ? DISABLED_MASK16 :	\
		((x) >> 5) == 19 ? DISABLED_MASK19 : 0	\
	) & (1U << ((x) & 31)))

#endif /* _ASM_X86_CPUFEATUREMASKS_H */
