# The PEP 484 type hints stub file for the _analysis module.
#
# Generated by SIP 6.12.0


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtGui
from PyQt6 import QtXml
from PyQt6 import QtNetwork
from PyQt6 import QtWidgets
from PyQt6 import QtSql
from PyQt6 import QtPrintSupport
from PyQt6 import QtPositioning
from PyQt6 import QtSerialPort
from qgis import _core

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class QgsAnalysis(PyQt6.sip.wrapper):

    @staticmethod
    def geometryCheckRegistry() -> typing.Optional['QgsGeometryCheckRegistry']: ...
    @staticmethod
    def instance() -> typing.Optional['QgsAnalysis']: ...


class QgsGcpGeometryTransformer(_core.QgsAbstractGeometryTransformer):

    @typing.overload
    def __init__(self, gcpTransformer: typing.Optional['QgsGcpTransformerInterface']) -> None: ...
    @typing.overload
    def __init__(self, method: 'QgsGcpTransformerInterface.TransformMethod', sourceCoordinates: collections.abc.Iterable[_core.QgsPointXY], destinationCoordinates: collections.abc.Iterable[_core.QgsPointXY]) -> None: ...

    def setGcpTransformer(self, transformer: typing.Optional['QgsGcpTransformerInterface']) -> None: ...
    def gcpTransformer(self) -> typing.Optional['QgsGcpTransformerInterface']: ...
    def transform(self, geometry: _core.QgsGeometry, feedback: typing.Optional[_core.QgsFeedback] = ...) -> typing.Tuple[_core.QgsGeometry, bool]: ...
    def transformPoint(self, x: float, y: float, z: float, m: float) -> typing.Tuple[bool, float, float, float, float]: ...


class QgsGcpPoint(PyQt6.sip.wrapper):

    class PointType(enum.Enum):
        Source = ... # type: QgsGcpPoint.PointType
        Destination = ... # type: QgsGcpPoint.PointType

    @typing.overload
    def __init__(self, sourcePoint: _core.QgsPointXY, destinationPoint: _core.QgsPointXY, destinationPointCrs: _core.QgsCoordinateReferenceSystem, enabled: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGcpPoint') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def setEnabled(self, enabled: bool) -> None: ...
    def isEnabled(self) -> bool: ...
    def transformedDestinationPoint(self, targetCrs: _core.QgsCoordinateReferenceSystem, context: _core.QgsCoordinateTransformContext) -> _core.QgsPointXY: ...
    def setDestinationPointCrs(self, crs: _core.QgsCoordinateReferenceSystem) -> None: ...
    def destinationPointCrs(self) -> _core.QgsCoordinateReferenceSystem: ...
    def setDestinationPoint(self, point: _core.QgsPointXY) -> None: ...
    def destinationPoint(self) -> _core.QgsPointXY: ...
    def setSourcePoint(self, point: _core.QgsPointXY) -> None: ...
    def sourcePoint(self) -> _core.QgsPointXY: ...


class QgsGcpTransformerInterface(PyQt6.sip.wrapper):

    class TransformMethod(enum.IntEnum):
        Linear = ... # type: QgsGcpTransformerInterface.TransformMethod
        Helmert = ... # type: QgsGcpTransformerInterface.TransformMethod
        PolynomialOrder1 = ... # type: QgsGcpTransformerInterface.TransformMethod
        PolynomialOrder2 = ... # type: QgsGcpTransformerInterface.TransformMethod
        PolynomialOrder3 = ... # type: QgsGcpTransformerInterface.TransformMethod
        ThinPlateSpline = ... # type: QgsGcpTransformerInterface.TransformMethod
        Projective = ... # type: QgsGcpTransformerInterface.TransformMethod
        InvalidTransform = ... # type: QgsGcpTransformerInterface.TransformMethod

    staticMetaObject = ... # type: QtCore.QMetaObject

    def __init__(self) -> None: ...

    @staticmethod
    def createFromParameters(method: 'QgsGcpTransformerInterface.TransformMethod', sourceCoordinates: collections.abc.Iterable[_core.QgsPointXY], destinationCoordinates: collections.abc.Iterable[_core.QgsPointXY]) -> typing.Optional['QgsGcpTransformerInterface']: ...
    @staticmethod
    def create(method: 'QgsGcpTransformerInterface.TransformMethod') -> typing.Optional['QgsGcpTransformerInterface']: ...
    @staticmethod
    def methodToString(method: 'QgsGcpTransformerInterface.TransformMethod') -> str: ...
    def transform(self, x: float, y: float, inverseTransform: bool = ...) -> typing.Tuple[bool, float, float]: ...
    def method(self) -> 'QgsGcpTransformerInterface.TransformMethod': ...
    def minimumGcpCount(self) -> int: ...
    def updateParametersFromGcps(self, sourceCoordinates: collections.abc.Iterable[_core.QgsPointXY], destinationCoordinates: collections.abc.Iterable[_core.QgsPointXY], invertYAxis: bool = ...) -> bool: ...
    def clone(self) -> typing.Optional['QgsGcpTransformerInterface']: ...


class QgsVectorWarper(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, method: QgsGcpTransformerInterface.TransformMethod, points: collections.abc.Iterable[QgsGcpPoint], destinationCrs: _core.QgsCoordinateReferenceSystem) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVectorWarper') -> None: ...

    def error(self) -> str: ...
    def transformFeatures(self, iterator: _core.QgsFeatureIterator, sink: typing.Optional[_core.QgsFeatureSink], context: _core.QgsCoordinateTransformContext, feedback: typing.Optional[_core.QgsFeedback] = ...) -> bool: ...


class QgsVectorWarperTask(_core.QgsTask):

    class Result(enum.Enum):
        Success = ... # type: QgsVectorWarperTask.Result
        Canceled = ... # type: QgsVectorWarperTask.Result
        Error = ... # type: QgsVectorWarperTask.Result

    def __init__(self, method: QgsGcpTransformerInterface.TransformMethod, points: collections.abc.Iterable[QgsGcpPoint], destinationCrs: _core.QgsCoordinateReferenceSystem, layer: typing.Optional[_core.QgsVectorLayer], fileName: typing.Optional[str]) -> None: ...

    def run(self) -> bool: ...
    def errorMessage(self) -> str: ...
    def result(self) -> 'QgsVectorWarperTask.Result': ...
    def cancel(self) -> None: ...


class QgsGridFileWriter(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, interpolator: typing.Optional['QgsInterpolator'], outputPath: typing.Optional[str], extent: _core.QgsRectangle, nCols: int, nRows: int) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGridFileWriter') -> None: ...

    def noDataValue(self) -> float: ...
    def setNoDataValue(self, noDataValue: float) -> None: ...
    def creationOptions(self) -> list[str]: ...
    def setCreationOptions(self, options: collections.abc.Iterable[typing.Optional[str]]) -> None: ...
    def writeFile(self, feedback: typing.Optional[_core.QgsFeedback] = ...) -> int: ...


class QgsInterpolator(PyQt6.sip.wrapper):

    class Result(enum.IntEnum):
        Success = ... # type: QgsInterpolator.Result
        Canceled = ... # type: QgsInterpolator.Result
        InvalidSource = ... # type: QgsInterpolator.Result
        FeatureGeometryError = ... # type: QgsInterpolator.Result

    class ValueSource(enum.IntEnum):
        Attribute = ... # type: QgsInterpolator.ValueSource
        Z = ... # type: QgsInterpolator.ValueSource
        M = ... # type: QgsInterpolator.ValueSource

    class SourceType(enum.IntEnum):
        Points = ... # type: QgsInterpolator.SourceType
        StructureLines = ... # type: QgsInterpolator.SourceType
        BreakLines = ... # type: QgsInterpolator.SourceType

    class LayerData(PyQt6.sip.wrapper):

        interpolationAttribute = ... # type: int
        source = ... # type: _core.QgsFeatureSource
        sourceType = ... # type: 'QgsInterpolator.SourceType'
        transformContext = ... # type: _core.QgsCoordinateTransformContext
        valueSource = ... # type: 'QgsInterpolator.ValueSource'

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsInterpolator.LayerData') -> None: ...

    @typing.overload
    def __init__(self, layerData: collections.abc.Iterable['QgsInterpolator.LayerData']) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsInterpolator') -> None: ...

    def cacheBaseData(self, feedback: typing.Optional[_core.QgsFeedback] = ...) -> 'QgsInterpolator.Result': ...
    def interpolatePoint(self, x: float, y: float, feedback: typing.Optional[_core.QgsFeedback] = ...) -> typing.Tuple[int, float]: ...


class QgsIDWInterpolator(QgsInterpolator):

    @typing.overload
    def __init__(self, layerData: collections.abc.Iterable[QgsInterpolator.LayerData]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsIDWInterpolator') -> None: ...

    def distanceCoefficient(self) -> float: ...
    def setDistanceCoefficient(self, coefficient: float) -> None: ...
    def interpolatePoint(self, x: float, y: float, feedback: typing.Optional[_core.QgsFeedback] = ...) -> typing.Tuple[int, float]: ...


class QgsInterpolatorVertexData(PyQt6.sip.wrapper):

    x = ... # type: float
    y = ... # type: float
    z = ... # type: float

    @typing.overload
    def __init__(self, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsInterpolatorVertexData') -> None: ...


class QgsTinInterpolator(QgsInterpolator):

    class TinInterpolation(enum.IntEnum):
        Linear = ... # type: QgsTinInterpolator.TinInterpolation
        CloughTocher = ... # type: QgsTinInterpolator.TinInterpolation

    @typing.overload
    def __init__(self, inputData: collections.abc.Iterable[QgsInterpolator.LayerData], interpolation: 'QgsTinInterpolator.TinInterpolation' = ..., feedback: typing.Optional[_core.QgsFeedback] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTinInterpolator') -> None: ...

    def setTriangulationSink(self, sink: typing.Optional[_core.QgsFeatureSink]) -> None: ...
    @staticmethod
    def triangulationFields() -> _core.QgsFields: ...
    def interpolatePoint(self, x: float, y: float, feedback: typing.Optional[_core.QgsFeedback]) -> typing.Tuple[int, float]: ...


class QgsMeshContours(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, layer: typing.Optional[_core.QgsMeshLayer]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMeshContours') -> None: ...

    def exportPolygons(self, index: _core.QgsMeshDatasetIndex, min_value: float, max_value: float, method: _core.QgsMeshRendererScalarSettings.DataResamplingMethod, feedback: typing.Optional[_core.QgsFeedback] = ...) -> _core.QgsGeometry: ...
    def exportLines(self, index: _core.QgsMeshDatasetIndex, value: float, method: _core.QgsMeshRendererScalarSettings.DataResamplingMethod, feedback: typing.Optional[_core.QgsFeedback] = ...) -> _core.QgsGeometry: ...


class QgsMeshTriangulation(QtCore.QObject):

    def __init__(self) -> None: ...

    def setCrs(self, crs: _core.QgsCoordinateReferenceSystem) -> None: ...
    def triangulatedMesh(self, feedback: typing.Optional[_core.QgsFeedback] = ...) -> _core.QgsMesh: ...
    def addVertex(self, vertex: _core.QgsPoint) -> int: ...
    def addBreakLines(self, lineFeatureIterator: _core.QgsFeatureIterator, valueAttribute: int, transformContext: _core.QgsCoordinateTransform, feedback: typing.Optional[_core.QgsFeedback] = ..., featureCount: int = ...) -> bool: ...
    def addVertices(self, vertexFeatureIterator: _core.QgsFeatureIterator, valueAttribute: int, transform: _core.QgsCoordinateTransform, feedback: typing.Optional[_core.QgsFeedback] = ..., featureCount: int = ...) -> bool: ...


class QgsMeshZValueDatasetGroup(_core.QgsMeshDatasetGroup):

    def __init__(self, datasetGroupName: typing.Optional[str], mesh: _core.QgsMesh) -> None: ...

    def writeXml(self, doc: QtXml.QDomDocument, context: _core.QgsReadWriteContext) -> QtXml.QDomElement: ...
    def type(self) -> _core.QgsMeshDatasetGroup.Type: ...
    def dataset(self, index: int) -> typing.Optional[_core.QgsMeshDataset]: ...
    def datasetCount(self) -> int: ...
    def datasetMetadata(self, datasetIndex: int) -> _core.QgsMeshDatasetMetadata: ...
    def initialize(self) -> None: ...


class QgsMeshEditingDelaunayTriangulation(_core.QgsMeshAdvancedEditing):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMeshEditingDelaunayTriangulation') -> None: ...

    def text(self) -> str: ...


class QgsGraphEdge(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGraphEdge') -> None: ...

    def fromVertex(self) -> int: ...
    def toVertex(self) -> int: ...
    def strategies(self) -> list[typing.Any]: ...
    def cost(self, strategyIndex: int) -> typing.Any: ...


class QgsGraphVertex(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, point: _core.QgsPointXY) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGraphVertex') -> None: ...

    def point(self) -> _core.QgsPointXY: ...
    def outgoingEdges(self) -> list[int]: ...
    def incomingEdges(self) -> list[int]: ...


class QgsGraph(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGraph') -> None: ...

    def hasVertex(self, index: int) -> bool: ...
    def hasEdge(self, index: int) -> bool: ...
    def findOppositeEdge(self, index: int) -> int: ...
    def findVertex(self, pt: _core.QgsPointXY) -> int: ...
    def removeEdge(self, index: int) -> None: ...
    def edge(self, idx: int) -> QgsGraphEdge: ...
    def edgeCount(self) -> int: ...
    def removeVertex(self, index: int) -> None: ...
    def vertex(self, idx: int) -> QgsGraphVertex: ...
    def vertexCount(self) -> int: ...
    def addEdge(self, fromVertexIdx: int, toVertexIdx: int, strategies: collections.abc.Iterable[typing.Any]) -> int: ...
    def addVertex(self, pt: _core.QgsPointXY) -> int: ...


class QgsGraphAnalyzer(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGraphAnalyzer') -> None: ...

    @staticmethod
    def shortestTree(source: typing.Optional[QgsGraph], startVertexIdx: int, criterionNum: int) -> typing.Optional[QgsGraph]: ...
    @staticmethod
    def dijkstra(source: typing.Optional[QgsGraph], startVertexIdx: int, criterionNum: int, resultTree: typing.Optional[collections.abc.Iterable[int]] = ..., resultCost: typing.Optional[collections.abc.Iterable[float]] = ...) -> list: ...


class QgsGraphBuilderInterface(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, crs: _core.QgsCoordinateReferenceSystem, ctfEnabled: bool = ..., topologyTolerance: float = ..., ellipsoidID: typing.Optional[str] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGraphBuilderInterface') -> None: ...

    def addEdge(self, pt1id: int, pt1: _core.QgsPointXY, pt2id: int, pt2: _core.QgsPointXY, strategies: collections.abc.Iterable[typing.Any]) -> None: ...
    def addVertex(self, id: int, pt: _core.QgsPointXY) -> None: ...
    def distanceArea(self) -> typing.Optional[_core.QgsDistanceArea]: ...
    def topologyTolerance(self) -> float: ...
    def coordinateTransformationEnabled(self) -> bool: ...
    def destinationCrs(self) -> _core.QgsCoordinateReferenceSystem: ...


class QgsGraphBuilder(QgsGraphBuilderInterface):

    def __init__(self, crs: _core.QgsCoordinateReferenceSystem, otfEnabled: bool = ..., topologyTolerance: float = ..., ellipsoidID: typing.Optional[str] = ...) -> None: ...

    def takeGraph(self) -> typing.Optional[QgsGraph]: ...
    def graph(self) -> QgsGraph: ...
    def addEdge(self, pt1id: int, pt1: _core.QgsPointXY, pt2id: int, pt2: _core.QgsPointXY, prop: collections.abc.Iterable[typing.Any]) -> None: ...
    def addVertex(self, id: int, pt: _core.QgsPointXY) -> None: ...


class QgsGraphDirector(QtCore.QObject):

    def __init__(self) -> None: ...

    def name(self) -> str: ...
    def addStrategy(self, prop: typing.Optional['QgsNetworkStrategy']) -> None: ...
    def makeGraph(self, builder: typing.Optional[QgsGraphBuilderInterface], additionalPoints: collections.abc.Iterable[_core.QgsPointXY], feedback: typing.Optional[_core.QgsFeedback] = ...) -> list[_core.QgsPointXY]: ...


class QgsNetworkStrategy(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsNetworkStrategy') -> None: ...

    def cost(self, distance: float, f: _core.QgsFeature) -> typing.Any: ...
    def requiredAttributes(self) -> typing.Any: ...


class QgsNetworkDistanceStrategy(QgsNetworkStrategy):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsNetworkDistanceStrategy') -> None: ...

    def cost(self, distance: float, a1: _core.QgsFeature) -> typing.Any: ...


class QgsNetworkSpeedStrategy(QgsNetworkStrategy):

    @typing.overload
    def __init__(self, attributeId: int, defaultValue: float, toMetricFactor: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsNetworkSpeedStrategy') -> None: ...

    def requiredAttributes(self) -> typing.Any: ...
    def cost(self, distance: float, f: _core.QgsFeature) -> typing.Any: ...


class QgsVectorLayerDirector(QgsGraphDirector):

    class Direction(enum.IntEnum):
        DirectionForward = ... # type: QgsVectorLayerDirector.Direction
        DirectionBackward = ... # type: QgsVectorLayerDirector.Direction
        DirectionBoth = ... # type: QgsVectorLayerDirector.Direction

    def __init__(self, source: typing.Optional[_core.QgsFeatureSource], directionFieldId: int, directDirectionValue: typing.Optional[str], reverseDirectionValue: typing.Optional[str], bothDirectionValue: typing.Optional[str], defaultDirection: 'QgsVectorLayerDirector.Direction') -> None: ...

    def name(self) -> str: ...
    def makeGraph(self, builder: typing.Optional[QgsGraphBuilderInterface], additionalPoints: collections.abc.Iterable[_core.QgsPointXY], feedback: typing.Optional[_core.QgsFeedback] = ...) -> list[_core.QgsPointXY]: ...


class QgsBatchGeocodeAlgorithm(_core.QgsProcessingFeatureBasedAlgorithm):

    def __init__(self, geocoder: typing.Optional[_core.QgsGeocoderInterface]) -> None: ...

    def outputWkbType(self, inputWkbType: _core.Qgis.WkbType) -> _core.Qgis.WkbType: ...
    def outputFields(self, inputFields: _core.QgsFields) -> _core.QgsFields: ...
    def outputCrs(self, inputCrs: _core.QgsCoordinateReferenceSystem) -> _core.QgsCoordinateReferenceSystem: ...
    def processFeature(self, feature: _core.QgsFeature, a1: _core.QgsProcessingContext, feedback: typing.Optional[_core.QgsProcessingFeedback]) -> list[_core.QgsFeature]: ...
    def prepareAlgorithm(self, parameters: dict[typing.Optional[str], typing.Any], context: _core.QgsProcessingContext, feedback: typing.Optional[_core.QgsProcessingFeedback]) -> bool: ...
    def outputName(self) -> str: ...
    def supportInPlaceEdit(self, layer: typing.Optional[_core.QgsMapLayer]) -> bool: ...
    def inputLayerTypes(self) -> list[int]: ...
    def groupId(self) -> str: ...
    def group(self) -> str: ...
    def tags(self) -> list[str]: ...
    def initParameters(self, configuration: dict[typing.Optional[str], typing.Any] = ...) -> None: ...


class QgsNativeAlgorithms(_core.QgsProcessingProvider):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def loadAlgorithms(self) -> None: ...
    def flags(self) -> _core.Qgis.ProcessingProviderFlag: ...
    def supportsNonFileBasedOutput(self) -> bool: ...
    def name(self) -> str: ...
    def helpId(self) -> str: ...
    def id(self) -> str: ...
    def svgIconPath(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...


class QgsAlignRaster(PyQt6.sip.wrapper):

    class RasterInfo(PyQt6.sip.wrapper):

        def __init__(self, layerpath: typing.Optional[str]) -> None: ...

        def identify(self, mx: float, my: float) -> float: ...
        def dump(self) -> None: ...
        def origin(self) -> QtCore.QPointF: ...
        def extent(self) -> _core.QgsRectangle: ...
        def gridOffset(self) -> QtCore.QPointF: ...
        def cellSize(self) -> QtCore.QSizeF: ...
        def bandCount(self) -> int: ...
        def rasterSize(self) -> QtCore.QSize: ...
        def crs(self) -> str: ...
        def isValid(self) -> bool: ...

    class ProgressHandler(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAlignRaster.ProgressHandler') -> None: ...

        def progress(self, complete: float) -> bool: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAlignRaster') -> None: ...

    @staticmethod
    def suggestedWarpOutput(info: 'QgsAlignRaster.RasterInfo', destWkt: typing.Optional[str], cellSize: typing.Optional[QtCore.QSizeF] = ..., gridOffset: typing.Optional[QtCore.QPointF] = ..., rect: typing.Optional[_core.QgsRectangle] = ...) -> bool: ...
    def createAndWarp(self, raster: _core.QgsAlignRasterData.RasterItem) -> bool: ...
    def suggestedReferenceLayer(self) -> int: ...
    def dump(self) -> None: ...
    def errorMessage(self) -> str: ...
    def run(self) -> bool: ...
    def alignedRasterExtent(self) -> _core.QgsRectangle: ...
    def alignedRasterSize(self) -> QtCore.QSize: ...
    def checkInputParameters(self) -> bool: ...
    @typing.overload
    def setParametersFromRaster(self, rasterInfo: 'QgsAlignRaster.RasterInfo', customCRSWkt: typing.Optional[str] = ..., customCellSize: QtCore.QSizeF = ..., customGridOffset: QtCore.QPointF = ...) -> bool: ...
    @typing.overload
    def setParametersFromRaster(self, filename: typing.Optional[str], customCRSWkt: typing.Optional[str] = ..., customCellSize: QtCore.QSizeF = ..., customGridOffset: QtCore.QPointF = ...) -> bool: ...
    def clipExtent(self) -> _core.QgsRectangle: ...
    @typing.overload
    def setClipExtent(self, xmin: float, ymin: float, xmax: float, ymax: float) -> None: ...
    @typing.overload
    def setClipExtent(self, extent: _core.QgsRectangle) -> None: ...
    def destinationCrs(self) -> str: ...
    def setDestinationCrs(self, crsWkt: typing.Optional[str]) -> None: ...
    def cellSize(self) -> QtCore.QSizeF: ...
    @typing.overload
    def setCellSize(self, x: float, y: float) -> None: ...
    @typing.overload
    def setCellSize(self, size: QtCore.QSizeF) -> None: ...
    def gridOffset(self) -> QtCore.QPointF: ...
    def setGridOffset(self, offset: QtCore.QPointF) -> None: ...
    def rasters(self) -> list[_core.QgsAlignRasterData.RasterItem]: ...
    def setRasters(self, list: collections.abc.Iterable[_core.QgsAlignRasterData.RasterItem]) -> None: ...
    def progressHandler(self) -> typing.Optional['QgsAlignRaster.ProgressHandler']: ...
    def setProgressHandler(self, progressHandler: typing.Optional['QgsAlignRaster.ProgressHandler']) -> None: ...


class QgsNineCellFilter(PyQt6.sip.wrapper):

    class Result(enum.IntEnum):
        Success = ... # type: QgsNineCellFilter.Result
        InputLayerError = ... # type: QgsNineCellFilter.Result
        DriverError = ... # type: QgsNineCellFilter.Result
        CreateOutputError = ... # type: QgsNineCellFilter.Result
        InputBandError = ... # type: QgsNineCellFilter.Result
        OutputBandError = ... # type: QgsNineCellFilter.Result
        RasterSizeError = ... # type: QgsNineCellFilter.Result
        Canceled = ... # type: QgsNineCellFilter.Result

    @typing.overload
    def __init__(self, inputFile: typing.Optional[str], outputFile: typing.Optional[str], outputFormat: typing.Optional[str]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsNineCellFilter') -> None: ...

    def processNineCellWindow(self) -> typing.Tuple[float, typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float]]: ...
    def creationOptions(self) -> list[str]: ...
    def setCreationOptions(self, options: collections.abc.Iterable[typing.Optional[str]]) -> None: ...
    def setOutputNodataValue(self, value: float) -> None: ...
    def outputNodataValue(self) -> float: ...
    def setInputNodataValue(self, value: float) -> None: ...
    def inputNodataValue(self) -> float: ...
    def setZFactor(self, factor: float) -> None: ...
    def zFactor(self) -> float: ...
    def setCellSizeY(self, size: float) -> None: ...
    def cellSizeY(self) -> float: ...
    def setCellSizeX(self, size: float) -> None: ...
    def cellSizeX(self) -> float: ...
    def processRaster(self, feedback: typing.Optional[_core.QgsFeedback] = ...) -> 'QgsNineCellFilter.Result': ...


class QgsDerivativeFilter(QgsNineCellFilter):

    @typing.overload
    def __init__(self, inputFile: typing.Optional[str], outputFile: typing.Optional[str], outputFormat: typing.Optional[str]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDerivativeFilter') -> None: ...

    def calcFirstDerY(self, x11: float, x21: float, x31: float, x12: float, x22: float, x32: float, x13: float, x23: float, x33: float) -> float: ...
    def calcFirstDerX(self, x11: float, x21: float, x31: float, x12: float, x22: float, x32: float, x13: float, x23: float, x33: float) -> float: ...
    def processNineCellWindow(self) -> typing.Tuple[float, typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float]]: ...


class QgsAspectFilter(QgsDerivativeFilter):

    @typing.overload
    def __init__(self, inputFile: typing.Optional[str], outputFile: typing.Optional[str], outputFormat: typing.Optional[str]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAspectFilter') -> None: ...

    def processNineCellWindow(self) -> typing.Tuple[float, typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float]]: ...


class QgsHillshadeFilter(QgsDerivativeFilter):

    @typing.overload
    def __init__(self, inputFile: typing.Optional[str], outputFile: typing.Optional[str], outputFormat: typing.Optional[str], lightAzimuth: float = ..., lightAngle: float = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsHillshadeFilter') -> None: ...

    def setLightAngle(self, angle: float) -> None: ...
    def lightAngle(self) -> float: ...
    def setLightAzimuth(self, azimuth: float) -> None: ...
    def lightAzimuth(self) -> float: ...
    def processNineCellWindow(self) -> typing.Tuple[float, typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float]]: ...


class QgsKernelDensityEstimation(PyQt6.sip.wrapper):

    class Result(enum.IntEnum):
        Success = ... # type: QgsKernelDensityEstimation.Result
        DriverError = ... # type: QgsKernelDensityEstimation.Result
        InvalidParameters = ... # type: QgsKernelDensityEstimation.Result
        FileCreationError = ... # type: QgsKernelDensityEstimation.Result
        RasterIoError = ... # type: QgsKernelDensityEstimation.Result

    class OutputValues(enum.IntEnum):
        Raw = ... # type: QgsKernelDensityEstimation.OutputValues
        Scaled = ... # type: QgsKernelDensityEstimation.OutputValues

    class KernelShape(enum.IntEnum):
        Quartic = ... # type: QgsKernelDensityEstimation.KernelShape
        Triangular = ... # type: QgsKernelDensityEstimation.KernelShape
        Uniform = ... # type: QgsKernelDensityEstimation.KernelShape
        Triweight = ... # type: QgsKernelDensityEstimation.KernelShape
        Epanechnikov = ... # type: QgsKernelDensityEstimation.KernelShape

    class Parameters(PyQt6.sip.wrapper):

        decayRatio = ... # type: float
        outputValues = ... # type: 'QgsKernelDensityEstimation.OutputValues'
        pixelSize = ... # type: float
        radius = ... # type: float
        radiusField = ... # type: typing.Optional[str]
        shape = ... # type: 'QgsKernelDensityEstimation.KernelShape'
        source = ... # type: _core.QgsFeatureSource
        weightField = ... # type: typing.Optional[str]

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsKernelDensityEstimation.Parameters') -> None: ...

    def __init__(self, parameters: 'QgsKernelDensityEstimation.Parameters', outputFile: typing.Optional[str], outputFormat: typing.Optional[str]) -> None: ...

    def finalise(self) -> 'QgsKernelDensityEstimation.Result': ...
    def addFeature(self, feature: _core.QgsFeature) -> 'QgsKernelDensityEstimation.Result': ...
    def prepare(self) -> 'QgsKernelDensityEstimation.Result': ...
    def run(self) -> 'QgsKernelDensityEstimation.Result': ...


class QgsRasterCalcNode(PyQt6.sip.wrapper):

    class Operator(enum.IntEnum):
        opPLUS = ... # type: QgsRasterCalcNode.Operator
        opMINUS = ... # type: QgsRasterCalcNode.Operator
        opMUL = ... # type: QgsRasterCalcNode.Operator
        opDIV = ... # type: QgsRasterCalcNode.Operator
        opPOW = ... # type: QgsRasterCalcNode.Operator
        opSQRT = ... # type: QgsRasterCalcNode.Operator
        opSIN = ... # type: QgsRasterCalcNode.Operator
        opCOS = ... # type: QgsRasterCalcNode.Operator
        opTAN = ... # type: QgsRasterCalcNode.Operator
        opASIN = ... # type: QgsRasterCalcNode.Operator
        opACOS = ... # type: QgsRasterCalcNode.Operator
        opATAN = ... # type: QgsRasterCalcNode.Operator
        opEQ = ... # type: QgsRasterCalcNode.Operator
        opNE = ... # type: QgsRasterCalcNode.Operator
        opGT = ... # type: QgsRasterCalcNode.Operator
        opLT = ... # type: QgsRasterCalcNode.Operator
        opGE = ... # type: QgsRasterCalcNode.Operator
        opLE = ... # type: QgsRasterCalcNode.Operator
        opAND = ... # type: QgsRasterCalcNode.Operator
        opOR = ... # type: QgsRasterCalcNode.Operator
        opSIGN = ... # type: QgsRasterCalcNode.Operator
        opLOG = ... # type: QgsRasterCalcNode.Operator
        opLOG10 = ... # type: QgsRasterCalcNode.Operator
        opABS = ... # type: QgsRasterCalcNode.Operator
        opMAX = ... # type: QgsRasterCalcNode.Operator
        opMIN = ... # type: QgsRasterCalcNode.Operator
        opNONE = ... # type: QgsRasterCalcNode.Operator

    class Type(enum.IntEnum):
        tOperator = ... # type: QgsRasterCalcNode.Type
        tNumber = ... # type: QgsRasterCalcNode.Type
        tRasterRef = ... # type: QgsRasterCalcNode.Type
        tMatrix = ... # type: QgsRasterCalcNode.Type
        tFunction = ... # type: QgsRasterCalcNode.Type

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, number: float) -> None: ...
    @typing.overload
    def __init__(self, matrix: typing.Optional['QgsRasterMatrix']) -> None: ...
    @typing.overload
    def __init__(self, op: 'QgsRasterCalcNode.Operator', left: typing.Optional['QgsRasterCalcNode'], right: typing.Optional['QgsRasterCalcNode']) -> None: ...
    @typing.overload
    def __init__(self, functionName: typing.Optional[str], functionArgs: collections.abc.Iterable['QgsRasterCalcNode']) -> None: ...
    @typing.overload
    def __init__(self, rasterName: typing.Optional[str]) -> None: ...

    def cleanRasterReferences(self) -> list[str]: ...
    def referencedLayerNames(self) -> list[str]: ...
    @staticmethod
    def parseRasterCalcString(str: typing.Optional[str], parserErrorMsg: typing.Optional[str]) -> typing.Optional['QgsRasterCalcNode']: ...
    def findNodes(self, type: 'QgsRasterCalcNode.Type') -> list['QgsRasterCalcNode']: ...
    def toString(self, cStyle: bool = ...) -> str: ...
    def setRight(self, right: typing.Optional['QgsRasterCalcNode']) -> None: ...
    def setLeft(self, left: typing.Optional['QgsRasterCalcNode']) -> None: ...
    def type(self) -> 'QgsRasterCalcNode.Type': ...


class QgsRasterCalculatorEntry(PyQt6.sip.wrapper):

    bandNumber = ... # type: int
    raster = ... # type: _core.QgsRasterLayer
    ref = ... # type: typing.Optional[str]

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRasterCalculatorEntry') -> None: ...

    @staticmethod
    def rasterEntries() -> list['QgsRasterCalculatorEntry']: ...


class QgsRasterCalculator(PyQt6.sip.wrapper):

    class Result(enum.IntEnum):
        Success = ... # type: QgsRasterCalculator.Result
        CreateOutputError = ... # type: QgsRasterCalculator.Result
        InputLayerError = ... # type: QgsRasterCalculator.Result
        Canceled = ... # type: QgsRasterCalculator.Result
        ParserError = ... # type: QgsRasterCalculator.Result
        MemoryError = ... # type: QgsRasterCalculator.Result
        BandError = ... # type: QgsRasterCalculator.Result
        CalculationError = ... # type: QgsRasterCalculator.Result

    @typing.overload
    def __init__(self, formulaString: typing.Optional[str], outputFile: typing.Optional[str], outputFormat: typing.Optional[str], outputExtent: _core.QgsRectangle, outputCrs: _core.QgsCoordinateReferenceSystem, nOutputColumns: int, nOutputRows: int, rasterEntries: collections.abc.Iterable[QgsRasterCalculatorEntry], transformContext: _core.QgsCoordinateTransformContext) -> None: ...
    @typing.overload
    def __init__(self, formulaString: typing.Optional[str], outputFile: typing.Optional[str], outputFormat: typing.Optional[str], outputExtent: _core.QgsRectangle, nOutputColumns: int, nOutputRows: int, rasterEntries: collections.abc.Iterable[QgsRasterCalculatorEntry], transformContext: _core.QgsCoordinateTransformContext) -> None: ...
    @typing.overload
    @deprecated("""""")
    def __init__(self, formulaString: typing.Optional[str], outputFile: typing.Optional[str], outputFormat: typing.Optional[str], outputExtent: _core.QgsRectangle, outputCrs: _core.QgsCoordinateReferenceSystem, nOutputColumns: int, nOutputRows: int, rasterEntries: collections.abc.Iterable[QgsRasterCalculatorEntry]) -> None: ...
    @typing.overload
    @deprecated("""""")
    def __init__(self, formulaString: typing.Optional[str], outputFile: typing.Optional[str], outputFormat: typing.Optional[str], outputExtent: _core.QgsRectangle, nOutputColumns: int, nOutputRows: int, rasterEntries: collections.abc.Iterable[QgsRasterCalculatorEntry]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRasterCalculator') -> None: ...

    def noDataValue(self) -> float: ...
    def setNoDataValue(self, noDataValue: float) -> None: ...
    def creationOptions(self) -> list[str]: ...
    def setCreationOptions(self, options: collections.abc.Iterable[typing.Optional[str]]) -> None: ...
    def lastError(self) -> str: ...
    def processCalculation(self, feedback: typing.Optional[_core.QgsFeedback] = ...) -> 'QgsRasterCalculator.Result': ...


class QgsRasterMatrix(PyQt6.sip.wrapper):

    class OneArgOperator(enum.IntEnum):
        opSQRT = ... # type: QgsRasterMatrix.OneArgOperator
        opSIN = ... # type: QgsRasterMatrix.OneArgOperator
        opCOS = ... # type: QgsRasterMatrix.OneArgOperator
        opTAN = ... # type: QgsRasterMatrix.OneArgOperator
        opASIN = ... # type: QgsRasterMatrix.OneArgOperator
        opACOS = ... # type: QgsRasterMatrix.OneArgOperator
        opATAN = ... # type: QgsRasterMatrix.OneArgOperator
        opSIGN = ... # type: QgsRasterMatrix.OneArgOperator
        opLOG = ... # type: QgsRasterMatrix.OneArgOperator
        opLOG10 = ... # type: QgsRasterMatrix.OneArgOperator
        opABS = ... # type: QgsRasterMatrix.OneArgOperator

    class TwoArgOperator(enum.IntEnum):
        opPLUS = ... # type: QgsRasterMatrix.TwoArgOperator
        opMINUS = ... # type: QgsRasterMatrix.TwoArgOperator
        opMUL = ... # type: QgsRasterMatrix.TwoArgOperator
        opDIV = ... # type: QgsRasterMatrix.TwoArgOperator
        opPOW = ... # type: QgsRasterMatrix.TwoArgOperator
        opEQ = ... # type: QgsRasterMatrix.TwoArgOperator
        opNE = ... # type: QgsRasterMatrix.TwoArgOperator
        opGT = ... # type: QgsRasterMatrix.TwoArgOperator
        opLT = ... # type: QgsRasterMatrix.TwoArgOperator
        opGE = ... # type: QgsRasterMatrix.TwoArgOperator
        opLE = ... # type: QgsRasterMatrix.TwoArgOperator
        opAND = ... # type: QgsRasterMatrix.TwoArgOperator
        opOR = ... # type: QgsRasterMatrix.TwoArgOperator
        opMIN = ... # type: QgsRasterMatrix.TwoArgOperator
        opMAX = ... # type: QgsRasterMatrix.TwoArgOperator

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, m: 'QgsRasterMatrix') -> None: ...

    def absoluteValue(self) -> bool: ...
    def log10(self) -> bool: ...
    def log(self) -> bool: ...
    def changeSign(self) -> bool: ...
    def atangens(self) -> bool: ...
    def tangens(self) -> bool: ...
    def acosinus(self) -> bool: ...
    def cosinus(self) -> bool: ...
    def asinus(self) -> bool: ...
    def sinus(self) -> bool: ...
    def squareRoot(self) -> bool: ...
    def min(self, other: 'QgsRasterMatrix') -> bool: ...
    def max(self, other: 'QgsRasterMatrix') -> bool: ...
    def logicalOr(self, other: 'QgsRasterMatrix') -> bool: ...
    def logicalAnd(self, other: 'QgsRasterMatrix') -> bool: ...
    def lesserEqual(self, other: 'QgsRasterMatrix') -> bool: ...
    def greaterEqual(self, other: 'QgsRasterMatrix') -> bool: ...
    def lesserThan(self, other: 'QgsRasterMatrix') -> bool: ...
    def greaterThan(self, other: 'QgsRasterMatrix') -> bool: ...
    def notEqual(self, other: 'QgsRasterMatrix') -> bool: ...
    def equal(self, other: 'QgsRasterMatrix') -> bool: ...
    def power(self, other: 'QgsRasterMatrix') -> bool: ...
    def divide(self, other: 'QgsRasterMatrix') -> bool: ...
    def multiply(self, other: 'QgsRasterMatrix') -> bool: ...
    def subtract(self, other: 'QgsRasterMatrix') -> bool: ...
    def add(self, other: 'QgsRasterMatrix') -> bool: ...
    def setNodataValue(self, d: float) -> None: ...
    def nodataValue(self) -> float: ...
    def nRows(self) -> int: ...
    def nColumns(self) -> int: ...
    def setData(self, cols: int, rows: int, nodataValue: float) -> typing.Optional[float]: ...
    def number(self) -> float: ...
    def isNumber(self) -> bool: ...


class QgsRelief(PyQt6.sip.wrapper):

    class ReliefColor(PyQt6.sip.wrapper):

        color = ... # type: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]
        maxElevation = ... # type: float
        minElevation = ... # type: float

        @typing.overload
        def __init__(self, c: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int], min: float, max: float) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsRelief.ReliefColor') -> None: ...

    def __init__(self, inputFile: typing.Optional[str], outputFile: typing.Optional[str], outputFormat: typing.Optional[str]) -> None: ...

    def exportFrequencyDistributionToCsv(self, file: typing.Optional[str]) -> bool: ...
    def calculateOptimizedReliefClasses(self) -> list['QgsRelief.ReliefColor']: ...
    def setReliefColors(self, c: collections.abc.Iterable['QgsRelief.ReliefColor']) -> None: ...
    def reliefColors(self) -> list['QgsRelief.ReliefColor']: ...
    def addReliefColorClass(self, color: 'QgsRelief.ReliefColor') -> None: ...
    def clearReliefColors(self) -> None: ...
    def setZFactor(self, factor: float) -> None: ...
    def zFactor(self) -> float: ...
    def processRaster(self, feedback: typing.Optional[_core.QgsFeedback] = ...) -> int: ...


class QgsRuggednessFilter(QgsNineCellFilter):

    @typing.overload
    def __init__(self, inputFile: typing.Optional[str], outputFile: typing.Optional[str], outputFormat: typing.Optional[str]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRuggednessFilter') -> None: ...

    def processNineCellWindow(self) -> typing.Tuple[float, typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float]]: ...


class QgsSlopeFilter(QgsDerivativeFilter):

    @typing.overload
    def __init__(self, inputFile: typing.Optional[str], outputFile: typing.Optional[str], outputFormat: typing.Optional[str]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSlopeFilter') -> None: ...

    def processNineCellWindow(self) -> typing.Tuple[float, typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float]]: ...


class QgsTotalCurvatureFilter(QgsNineCellFilter):

    @typing.overload
    def __init__(self, inputFile: typing.Optional[str], outputFile: typing.Optional[str], outputFormat: typing.Optional[str]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTotalCurvatureFilter') -> None: ...

    def processNineCellWindow(self) -> typing.Tuple[float, typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float], typing.Optional[float]]: ...


class QgsFeaturePool(_core.QgsFeatureSink):

    def __init__(self, layer: typing.Optional[_core.QgsVectorLayer]) -> None: ...

    def removeFeature(self, featureId: int) -> None: ...
    def refreshCache(self, feature: _core.QgsFeature, origFeature: _core.QgsFeature) -> None: ...
    def insertFeature(self, feature: _core.QgsFeature, skipLock: bool = ...) -> None: ...
    def layerName(self) -> str: ...
    def crs(self) -> _core.QgsCoordinateReferenceSystem: ...
    def geometryType(self) -> _core.Qgis.GeometryType: ...
    def layerId(self) -> str: ...
    def layer(self) -> typing.Optional[_core.QgsVectorLayer]: ...
    def deleteFeature(self, fid: int) -> None: ...
    def updateFeature(self, feature: _core.QgsFeature) -> None: ...
    def getFeature(self, id: int, feature: _core.QgsFeature) -> bool: ...


class QgsGeometryCheck(PyQt6.sip.wrapper):

    class Flag(enum.IntEnum):
        AvailableInValidation = ... # type: QgsGeometryCheck.Flag

    class Result(enum.IntEnum):
        Success = ... # type: QgsGeometryCheck.Result
        Canceled = ... # type: QgsGeometryCheck.Result
        DuplicatedUniqueId = ... # type: QgsGeometryCheck.Result
        InvalidReferenceLayer = ... # type: QgsGeometryCheck.Result
        GeometryOverlayError = ... # type: QgsGeometryCheck.Result

    class CheckType(enum.IntEnum):
        FeatureNodeCheck = ... # type: QgsGeometryCheck.CheckType
        FeatureCheck = ... # type: QgsGeometryCheck.CheckType
        LayerCheck = ... # type: QgsGeometryCheck.CheckType

    class ChangeType(enum.IntEnum):
        ChangeAdded = ... # type: QgsGeometryCheck.ChangeType
        ChangeRemoved = ... # type: QgsGeometryCheck.ChangeType
        ChangeChanged = ... # type: QgsGeometryCheck.ChangeType

    class ChangeWhat(enum.IntEnum):
        ChangeFeature = ... # type: QgsGeometryCheck.ChangeWhat
        ChangePart = ... # type: QgsGeometryCheck.ChangeWhat
        ChangeRing = ... # type: QgsGeometryCheck.ChangeWhat
        ChangeNode = ... # type: QgsGeometryCheck.ChangeWhat

    class LayerFeatureIds(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsGeometryCheck.LayerFeatureIds') -> None: ...

    class Change(PyQt6.sip.wrapper):

        type = ... # type: 'QgsGeometryCheck.ChangeType'
        vidx = ... # type: _core.QgsVertexId
        what = ... # type: 'QgsGeometryCheck.ChangeWhat'

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, _what: 'QgsGeometryCheck.ChangeWhat', _type: 'QgsGeometryCheck.ChangeType', _vidx: _core.QgsVertexId = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsGeometryCheck.Change') -> None: ...

        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, context: typing.Optional['QgsGeometryCheckContext'], configuration: dict[typing.Optional[str], typing.Any]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheck') -> None: ...

    def context(self) -> typing.Optional['QgsGeometryCheckContext']: ...
    def checkType(self) -> 'QgsGeometryCheck.CheckType': ...
    def id(self) -> str: ...
    def description(self) -> str: ...
    @deprecated("""""")
    def resolutionMethods(self) -> list[str]: ...
    def availableResolutionMethods(self) -> list['QgsGeometryCheckResolutionMethod']: ...
    def collectErrors(self, featurePools: typing.Any, errors: collections.abc.Iterable['QgsGeometryCheckError'], messages: collections.abc.Iterable[typing.Optional[str]], feedback: typing.Optional[_core.QgsFeedback], ids: 'QgsGeometryCheck.LayerFeatureIds' = ...) -> typing.Tuple['QgsGeometryCheck.Result', list['QgsGeometryCheckError'], list[str]]: ...
    def flags(self) -> 'QgsGeometryCheck.Flag': ...
    def compatibleGeometryTypes(self) -> list[_core.Qgis.GeometryType]: ...
    def isCompatible(self, layer: typing.Optional[_core.QgsVectorLayer]) -> bool: ...
    def prepare(self, context: typing.Optional['QgsGeometryCheckContext'], configuration: dict[typing.Optional[str], typing.Any]) -> None: ...


class QgsGeometryCheckResolutionMethod(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, id: int, name: typing.Optional[str], description: typing.Optional[str], isStable: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheckResolutionMethod') -> None: ...

    def description(self) -> str: ...
    def name(self) -> str: ...
    def isStable(self) -> bool: ...
    def id(self) -> int: ...


class QgsGeometryCheckContext(PyQt6.sip.wrapper):

    mapCrs = ... # type: _core.QgsCoordinateReferenceSystem
    reducedTolerance = ... # type: float
    tolerance = ... # type: float
    transformContext = ... # type: _core.QgsCoordinateTransformContext
    uniqueIdFieldIndex = ... # type: int

    def __init__(self, precision: int, mapCrs: _core.QgsCoordinateReferenceSystem, transformContext: _core.QgsCoordinateTransformContext, mProject: typing.Optional[_core.QgsProject] = ..., uniqueIdFieldIndex: int = ...) -> None: ...

    def project(self) -> typing.Optional[_core.QgsProject]: ...


class QgsGeometryCheckError(PyQt6.sip.wrapper):

    class ValueType(enum.IntEnum):
        ValueLength = ... # type: QgsGeometryCheckError.ValueType
        ValueArea = ... # type: QgsGeometryCheckError.ValueType
        ValueOther = ... # type: QgsGeometryCheckError.ValueType

    class Status(enum.IntEnum):
        StatusPending = ... # type: QgsGeometryCheckError.Status
        StatusFixFailed = ... # type: QgsGeometryCheckError.Status
        StatusFixed = ... # type: QgsGeometryCheckError.Status
        StatusObsolete = ... # type: QgsGeometryCheckError.Status

    @typing.overload
    def __init__(self, check: typing.Optional[QgsGeometryCheck], layerFeature: 'QgsGeometryCheckerUtils.LayerFeature', errorLocation: _core.QgsPointXY, vidx: _core.QgsVertexId = ..., value: typing.Any = ..., valueType: 'QgsGeometryCheckError.ValueType' = ...) -> None: ...
    @typing.overload
    def __init__(self, check: typing.Optional[QgsGeometryCheck], layerId: typing.Optional[str], featureId: int, geometry: _core.QgsGeometry, errorLocation: _core.QgsPointXY, vidx: _core.QgsVertexId = ..., value: typing.Any = ..., valueType: 'QgsGeometryCheckError.ValueType' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheckError') -> None: ...

    def icon(self) -> QtGui.QIcon: ...
    def update(self, other: typing.Optional['QgsGeometryCheckError']) -> None: ...
    def closeMatch(self, a0: typing.Optional['QgsGeometryCheckError']) -> bool: ...
    def isEqual(self, other: typing.Optional['QgsGeometryCheckError']) -> bool: ...
    def setObsolete(self) -> None: ...
    def setFixFailed(self, reason: typing.Optional[str]) -> None: ...
    def setFixed(self, method: int) -> None: ...
    def resolutionMessage(self) -> str: ...
    def status(self) -> 'QgsGeometryCheckError.Status': ...
    def vidx(self) -> _core.QgsVertexId: ...
    def valueType(self) -> 'QgsGeometryCheckError.ValueType': ...
    def value(self) -> typing.Any: ...
    def location(self) -> _core.QgsPointXY: ...
    def description(self) -> str: ...
    def affectedAreaBBox(self) -> _core.QgsRectangle: ...
    def contextBoundingBox(self) -> _core.QgsRectangle: ...
    def geometry(self) -> _core.QgsGeometry: ...
    def featureId(self) -> int: ...
    def layerId(self) -> str: ...
    def check(self) -> typing.Optional[QgsGeometryCheck]: ...


class QgsGeometryCheckerUtils(PyQt6.sip.wrapper):

    class LayerFeature(PyQt6.sip.wrapper):

        @typing.overload
        def __init__(self, pool: typing.Optional[QgsFeaturePool], feature: _core.QgsFeature, context: typing.Optional[QgsGeometryCheckContext], useMapCrs: bool) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsGeometryCheckerUtils.LayerFeature') -> None: ...

        def useMapCrs(self) -> bool: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def id(self) -> str: ...
        def geometry(self) -> _core.QgsGeometry: ...
        def layerId(self) -> str: ...
        def feature(self) -> _core.QgsFeature: ...

    class LayerFeatures(PyQt6.sip.wrapper):

        def __init__(self, a0: 'QgsGeometryCheckerUtils.LayerFeatures') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheckerUtils') -> None: ...


class QgsGeometryCheckFactory(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheckFactory') -> None: ...

    def checkType(self) -> QgsGeometryCheck.CheckType: ...
    def flags(self) -> QgsGeometryCheck.Flag: ...
    def isCompatible(self, layer: typing.Optional[_core.QgsVectorLayer]) -> bool: ...
    def description(self) -> str: ...
    def id(self) -> str: ...
    def createGeometryCheck(self, context: typing.Optional[QgsGeometryCheckContext], configuration: dict[typing.Optional[str], typing.Any]) -> typing.Optional[QgsGeometryCheck]: ...


class QgsGeometryCheckRegistry(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheckRegistry') -> None: ...

    def registerGeometryCheck(self, checkFactory: typing.Optional[QgsGeometryCheckFactory]) -> None: ...
    def geometryCheckFactories(self, layer: typing.Optional[_core.QgsVectorLayer], type: QgsGeometryCheck.CheckType, flags: QgsGeometryCheck.Flag = ...) -> list[QgsGeometryCheckFactory]: ...
    def geometryCheck(self, checkId: typing.Optional[str], context: typing.Optional[QgsGeometryCheckContext], geometryCheckConfig: dict[typing.Optional[str], typing.Any]) -> typing.Optional[QgsGeometryCheck]: ...


class QgsSingleGeometryCheckError(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, check: typing.Optional['QgsSingleGeometryCheck'], geometry: _core.QgsGeometry, errorLocation: _core.QgsGeometry, vertexId: _core.QgsVertexId = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSingleGeometryCheckError') -> None: ...

    def vertexId(self) -> _core.QgsVertexId: ...
    def errorLocation(self) -> _core.QgsGeometry: ...
    def check(self) -> typing.Optional['QgsSingleGeometryCheck']: ...
    def description(self) -> str: ...
    def isEqual(self, other: typing.Optional['QgsSingleGeometryCheckError']) -> bool: ...
    def update(self, other: typing.Optional['QgsSingleGeometryCheckError']) -> None: ...


class QgsGeometryCheckErrorSingle(QgsGeometryCheckError):

    @typing.overload
    def __init__(self, singleError: typing.Optional[QgsSingleGeometryCheckError], layerFeature: QgsGeometryCheckerUtils.LayerFeature) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheckErrorSingle') -> None: ...

    def singleError(self) -> typing.Optional[QgsSingleGeometryCheckError]: ...


class QgsSingleGeometryCheck(QgsGeometryCheck):

    @typing.overload
    def __init__(self, context: typing.Optional[QgsGeometryCheckContext], configuration: dict[typing.Optional[str], typing.Any]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSingleGeometryCheck') -> None: ...

    def processGeometry(self, geometry: _core.QgsGeometry) -> list[QgsSingleGeometryCheckError]: ...
    def collectErrors(self, featurePools: typing.Any, errors: collections.abc.Iterable[QgsGeometryCheckError], messages: collections.abc.Iterable[typing.Optional[str]], feedback: typing.Optional[_core.QgsFeedback] = ..., ids: QgsGeometryCheck.LayerFeatureIds = ...) -> QgsGeometryCheck.Result: ...


class QgsGeometrySnapper(QtCore.QObject):

    class SnapMode(enum.IntEnum):
        PreferNodes = ... # type: QgsGeometrySnapper.SnapMode
        PreferClosest = ... # type: QgsGeometrySnapper.SnapMode
        PreferNodesNoExtraVertices = ... # type: QgsGeometrySnapper.SnapMode
        PreferClosestNoExtraVertices = ... # type: QgsGeometrySnapper.SnapMode
        EndPointPreferNodes = ... # type: QgsGeometrySnapper.SnapMode
        EndPointPreferClosest = ... # type: QgsGeometrySnapper.SnapMode
        EndPointToEndPoint = ... # type: QgsGeometrySnapper.SnapMode

    def __init__(self, referenceSource: typing.Optional[_core.QgsFeatureSource]) -> None: ...

    featureSnapped: typing.ClassVar[QtCore.pyqtSignal]
    def snapFeatures(self, features: collections.abc.Iterable[_core.QgsFeature], snapTolerance: float, mode: 'QgsGeometrySnapper.SnapMode' = ...) -> list[_core.QgsFeature]: ...
    @typing.overload
    def snapGeometry(self, geometry: _core.QgsGeometry, snapTolerance: float, mode: 'QgsGeometrySnapper.SnapMode' = ...) -> _core.QgsGeometry: ...
    @typing.overload
    @staticmethod
    def snapGeometry(geometry: _core.QgsGeometry, snapTolerance: float, referenceGeometries: collections.abc.Iterable[_core.QgsGeometry], mode: 'QgsGeometrySnapper.SnapMode' = ...) -> _core.QgsGeometry: ...


class QgsInternalGeometrySnapper(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, snapTolerance: float, mode: QgsGeometrySnapper.SnapMode = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsInternalGeometrySnapper') -> None: ...

    def snappedGeometries(self) -> typing.Any: ...
    def snapFeature(self, feature: _core.QgsFeature) -> _core.QgsGeometry: ...


class QgsGeometrySnapperSingleSource(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometrySnapperSingleSource') -> None: ...

    @staticmethod
    def run(source: _core.QgsFeatureSource, sink: _core.QgsFeatureSink, thresh: float, feedback: typing.Optional[_core.QgsFeedback]) -> int: ...


class QgsZonalStatistics(PyQt6.sip.wrapper):

    @typing.overload
    def __init__(self, polygonLayer: typing.Optional[_core.QgsVectorLayer], rasterLayer: typing.Optional[_core.QgsRasterLayer], attributePrefix: typing.Optional[str] = ..., rasterBand: int = ..., stats: _core.Qgis.ZonalStatistic = ...) -> None: ...
    @typing.overload
    def __init__(self, polygonLayer: typing.Optional[_core.QgsVectorLayer], rasterInterface: typing.Optional[_core.QgsRasterInterface], rasterCrs: _core.QgsCoordinateReferenceSystem, rasterUnitsPerPixelX: float, rasterUnitsPerPixelY: float, attributePrefix: typing.Optional[str] = ..., rasterBand: int = ..., stats: _core.Qgis.ZonalStatistic = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsZonalStatistics') -> None: ...

    @staticmethod
    def shortName(statistic: _core.Qgis.ZonalStatistic) -> str: ...
    @staticmethod
    def displayName(statistic: _core.Qgis.ZonalStatistic) -> str: ...
    @typing.overload
    def calculateStatistics(self, feedback: typing.Optional[_core.QgsFeedback]) -> _core.Qgis.ZonalStatisticResult: ...
    @typing.overload
    @staticmethod
    def calculateStatistics(rasterInterface: typing.Optional[_core.QgsRasterInterface], geometry: _core.QgsGeometry, cellSizeX: float, cellSizeY: float, rasterBand: int, statistics: _core.Qgis.ZonalStatistic) -> dict[int, typing.Any]: ...
