# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_jade_global_optspecs
	string join \n mount-point= v/verbose h/help V/version
end

function __fish_jade_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_jade_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_jade_using_subcommand
	set -l cmd (__fish_jade_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c jade -n "__fish_jade_needs_command" -l mount-point -d 'root directory' -r -F
complete -c jade -n "__fish_jade_needs_command" -s v -l verbose
complete -c jade -n "__fish_jade_needs_command" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_needs_command" -s V -l version -d 'Print version'
complete -c jade -n "__fish_jade_needs_command" -f -a "config"
complete -c jade -n "__fish_jade_needs_command" -f -a "partition"
complete -c jade -n "__fish_jade_needs_command" -f -a "install-base"
complete -c jade -n "__fish_jade_needs_command" -f -a "genfstab"
complete -c jade -n "__fish_jade_needs_command" -f -a "bootloader"
complete -c jade -n "__fish_jade_needs_command" -f -a "locale"
complete -c jade -n "__fish_jade_needs_command" -f -a "networking"
complete -c jade -n "__fish_jade_needs_command" -f -a "users"
complete -c jade -n "__fish_jade_needs_command" -f -a "flatpak"
complete -c jade -n "__fish_jade_needs_command" -f -a "desktops"
complete -c jade -n "__fish_jade_needs_command" -f -a "completions"
complete -c jade -n "__fish_jade_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jade -n "__fish_jade_using_subcommand config" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand partition" -l mode -r -f -a "auto\t''
manual\t''"
complete -c jade -n "__fish_jade_using_subcommand partition" -l device -r -F
complete -c jade -n "__fish_jade_using_subcommand partition" -l efi
complete -c jade -n "__fish_jade_using_subcommand partition" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand install-base" -l kernel -r
complete -c jade -n "__fish_jade_using_subcommand install-base" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand genfstab" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand bootloader" -l loader-type -r
complete -c jade -n "__fish_jade_using_subcommand bootloader" -l device -r -F
complete -c jade -n "__fish_jade_using_subcommand bootloader" -l removable
complete -c jade -n "__fish_jade_using_subcommand bootloader" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand locale" -l keyboard -r
complete -c jade -n "__fish_jade_using_subcommand locale" -l timezone -r
complete -c jade -n "__fish_jade_using_subcommand locale" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand networking" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand users; and not __fish_seen_subcommand_from new-user root-password help" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand users; and not __fish_seen_subcommand_from new-user root-password help" -f -a "new-user"
complete -c jade -n "__fish_jade_using_subcommand users; and not __fish_seen_subcommand_from new-user root-password help" -f -a "root-password"
complete -c jade -n "__fish_jade_using_subcommand users; and not __fish_seen_subcommand_from new-user root-password help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jade -n "__fish_jade_using_subcommand users; and __fish_seen_subcommand_from new-user" -l shell -r
complete -c jade -n "__fish_jade_using_subcommand users; and __fish_seen_subcommand_from new-user" -l hasroot
complete -c jade -n "__fish_jade_using_subcommand users; and __fish_seen_subcommand_from new-user" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand users; and __fish_seen_subcommand_from root-password" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand users; and __fish_seen_subcommand_from help" -f -a "new-user"
complete -c jade -n "__fish_jade_using_subcommand users; and __fish_seen_subcommand_from help" -f -a "root-password"
complete -c jade -n "__fish_jade_using_subcommand users; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jade -n "__fish_jade_using_subcommand flatpak" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand desktops" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand completions" -s h -l help -d 'Print help'
complete -c jade -n "__fish_jade_using_subcommand help; and not __fish_seen_subcommand_from config partition install-base genfstab bootloader locale networking users flatpak desktops completions help" -f -a "config"
complete -c jade -n "__fish_jade_using_subcommand help; and not __fish_seen_subcommand_from config partition install-base genfstab bootloader locale networking users flatpak desktops completions help" -f -a "partition"
complete -c jade -n "__fish_jade_using_subcommand help; and not __fish_seen_subcommand_from config partition install-base genfstab bootloader locale networking users flatpak desktops completions help" -f -a "install-base"
complete -c jade -n "__fish_jade_using_subcommand help; and not __fish_seen_subcommand_from config partition install-base genfstab bootloader locale networking users flatpak desktops completions help" -f -a "genfstab"
complete -c jade -n "__fish_jade_using_subcommand help; and not __fish_seen_subcommand_from config partition install-base genfstab bootloader locale networking users flatpak desktops completions help" -f -a "bootloader"
complete -c jade -n "__fish_jade_using_subcommand help; and not __fish_seen_subcommand_from config partition install-base genfstab bootloader locale networking users flatpak desktops completions help" -f -a "locale"
complete -c jade -n "__fish_jade_using_subcommand help; and not __fish_seen_subcommand_from config partition install-base genfstab bootloader locale networking users flatpak desktops completions help" -f -a "networking"
complete -c jade -n "__fish_jade_using_subcommand help; and not __fish_seen_subcommand_from config partition install-base genfstab bootloader locale networking users flatpak desktops completions help" -f -a "users"
complete -c jade -n "__fish_jade_using_subcommand help; and not __fish_seen_subcommand_from config partition install-base genfstab bootloader locale networking users flatpak desktops completions help" -f -a "flatpak"
complete -c jade -n "__fish_jade_using_subcommand help; and not __fish_seen_subcommand_from config partition install-base genfstab bootloader locale networking users flatpak desktops completions help" -f -a "desktops"
complete -c jade -n "__fish_jade_using_subcommand help; and not __fish_seen_subcommand_from config partition install-base genfstab bootloader locale networking users flatpak desktops completions help" -f -a "completions"
complete -c jade -n "__fish_jade_using_subcommand help; and not __fish_seen_subcommand_from config partition install-base genfstab bootloader locale networking users flatpak desktops completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jade -n "__fish_jade_using_subcommand help; and __fish_seen_subcommand_from users" -f -a "new-user"
complete -c jade -n "__fish_jade_using_subcommand help; and __fish_seen_subcommand_from users" -f -a "root-password"
