
#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#include <orc/orc.h>
#include <orc-test/orctest.h>


int error = FALSE;

int
main (int argc, char *argv[])
{
  int i;
  int j;
  OrcOpcodeSet *opcode_set;
  OrcTarget *targets[20];
  int n_targets = 0;
  
  /* List of all known target names */
  const char *target_names[] = {
    "avx",
    "sse",
    "mmx",
    "altivec",
    "arm",
    "neon",
    "c64x-c",
    "mips",
    "riscv",
    "lsx",
    "lasx",
    "c",
    NULL
  };

  orc_init();
  orc_test_init();

  /* Try to get each target - only add if it exists and is available */
  for (i = 0; target_names[i] != NULL; i++) {
    OrcTarget *target = orc_target_get_by_name(target_names[i]);
    if (target != NULL) {
      targets[n_targets] = target;
      n_targets++;
    }
  }

  printf("<!-- generated by %s -->\n\n", __FILE__);
  printf("| Opcode Name |");
  for(j=0;j<n_targets;j++){
    printf(" %s |", orc_target_get_name(targets[j]));
  }
  printf("\n|-------------|");
  for(j=0;j<n_targets;j++){
    printf("-----|");
  }
  printf("\n");

  opcode_set = orc_opcode_set_get ("sys");

  for(i=0;i<opcode_set->n_opcodes;i++){
    printf("| %s |", opcode_set->opcodes[i].name);
    for(j=0;j<n_targets;j++){
      /* Check if a rule exists with all flags enabled to detect any rule implementation */
      OrcRule *rule = orc_target_get_rule(targets[j], &opcode_set->opcodes[i], 0xFFFFFFFF);
      
      if (rule) {
        printf(" yes |");
      } else {
        printf(" <span style=\"background-color: red; color: white; padding: 2px 4px;\">no</span> |");
      }
    }
    printf("\n");
  }

  return 0;
}

