# - Try to find libxkbcommon.
#
# Copyright (C) 2014, 2025 Igalia S.L.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1.  Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
# 2.  Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND ITS CONTRIBUTORS ``AS
# IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR ITS
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
# OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#[=======================================================================[.rst:
FindXkbCommon
-------------

Find the libxkbcommon headers and library.


Imported Targets
^^^^^^^^^^^^^^^^

``XkbCommon::XkbCommon``
  The libxkbcommon library, if found.

Result Variables
^^^^^^^^^^^^^^^^

``XkbCommon_FOUND``
  the if (the requested version of) libxkbcommon is available.

#]=======================================================================]

if (DEFINED XkbCommon_FIND_VERSION)
    set(XkbCommon_PKG_CONFIG_SPEC "xkbcommon>=${XkbCommon_FIND_VERSION}")
else ()
    set(XkbCommon_PKG_CONFIG_SPEC "xkbcommon")
endif ()

find_package(PkgConfig QUIET)
pkg_check_modules(XkbCommon QUIET IMPORTED_TARGET "${XkbCommon_PKG_CONFIG_SPEC}")

if (TARGET PkgConfig::XkbCommon AND NOT TARGET XkbCommon::XkbCommon)
    add_library(XkbCommon::XkbCommon INTERFACE IMPORTED GLOBAL)
    set_property(TARGET XkbCommon::XkbCommon PROPERTY
        INTERFACE_LINK_LIBRARIES PkgConfig::XkbCommon
    )
endif ()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(XkbCommon
    REQUIRED_VARS XkbCommon_VERSION
)
