#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-D8nyRkFsM43Ce8EH9s3JHD
key:                  arch-hs-0.12.1-D8nyRkFsM43Ce8EH9s3JHD
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  af86b70d8f4fc14c21cc9a2c18848129
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-D8nyRkFsM43Ce8EH9s3JHD
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.10.3.0 Diff-0.5-yETzKh0qtuDUuvJdOns8X
    aeson-2.1.2.1-GojnAvr1Jep10WUNi5H1Pi
    algebraic-graphs-0.7-J6zQywoEVrzAk0rClbBWfi
    arch-web-0.3.2-2GlaTJfbWXa40CyxRhu0fL base-4.18.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-252yfbtdylIFaQqQ0JKO9q
    conduit-extra-1.3.8-E4AHXAfmerjKj7JfHrF3lm containers-0.6.7
    deepseq-1.4.8.1 directory-1.3.8.5 filepath-1.4.300.1
    hackage-db-2.1.3-2ZUTFAVxVFb5Trgi7AH796
    http-client-0.7.19-ITPZXASBEGHLmOi4NfdGY8
    http-client-tls-0.3.6.4-2TpGPIcpPZAJDvilQsJ18b
    megaparsec-9.7.0-Fzm61TdpQu7Cpey7aoa8J9
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw
    neat-interpolation-0.5.1.4-LgltL8bGunlFCtvssaeg3T
    optparse-simple-0.1.1.4-K7gkA6F0Uma98WX87Fkx0
    polysemy-1.9.2.0-3JqrQ4y8prk3b8sHTyJTQx
    prettyprinter-1.7.1-KtmqmFkRxIvL2FcrwTTeTo
    prettyprinter-ansi-terminal-1.1.3-LcajTeMLJmqJgHikO6kzwA
    servant-client-0.20.3.0-4oEbmWCYhwn8ZD2C1b9D6B
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8
    tar-conduit-0.4.1-ItFxRFhPpU87LJVMXnYjvs template-haskell-2.20.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

