#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hxt-regex-xmlschema
version:              9.2.0.7
visibility:           public
id:                   hxt-regex-xmlschema-9.2.0.7-2NjKW7kmcZk6EGvDPVRXd6
key:                  hxt-regex-xmlschema-9.2.0.7-2NjKW7kmcZk6EGvDPVRXd6
license:              MIT
copyright:            Copyright (c) 2010- Uwe Schmidt
maintainer:           Uwe Schmidt <uwe@fh-wedel.de>
author:               Uwe Schmidt
stability:            stable
homepage:
    http://www.haskell.org/haskellwiki/Regular_expressions_for_XML_Schema

synopsis:
    A regular expression library for W3C XML Schema regular expressions

description:
    This library supports full W3C XML Schema regular expressions
    inclusive all Unicode character sets and blocks.
    The complete grammar can be found under <http://www.w3.org/TR/xmlschema11-2/#regexs>.
    It is implemented by the technique of derivations of regular expressions.

    The W3C syntax is extended to support not only union of regular sets,
    but also intersection, set difference, exor.
    Matching of subexpressions is also supported.

    The library can be used for constricting lightweight scanners and tokenizers.
    It is a standalone library, no external regex libraries are used.

    Extensions in 9.2: The library does nor only support String'\''s, but also
    ByteString'\''s and Text in strict and lazy variants

category:             Text
abi:                  5bad04cbfc0e6822b798797269c35f58
exposed:              True
exposed-modules:
    Text.Regex.Glob.Generic Text.Regex.Glob.Generic.RegexParser
    Text.Regex.Glob.String Text.Regex.XMLSchema.Generic
    Text.Regex.XMLSchema.Generic.Matching
    Text.Regex.XMLSchema.Generic.Regex
    Text.Regex.XMLSchema.Generic.RegexParser
    Text.Regex.XMLSchema.Generic.StringLike Text.Regex.XMLSchema.String

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hxt-regex-xmlschema-9.2.0.7
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hxt-regex-xmlschema-9.2.0.7
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hxt-regex-xmlschema-9.2.0.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hxt-regex-xmlschema
hs-libraries:         HShxt-regex-xmlschema-9.2.0.7-2NjKW7kmcZk6EGvDPVRXd6
depends:
    base-4.18.2.1 bytestring-0.11.5.3
    hxt-charproperties-9.5.0.0-3A2zqKQJ6DvFE2hsaAu0Wc parsec-3.1.16.1
    text-2.0.2

haddock-interfaces:
    /usr/share/doc/haskell-hxt-regex-xmlschema/html/hxt-regex-xmlschema.haddock

haddock-html:         /usr/share/doc/haskell-hxt-regex-xmlschema/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

