#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-pandoc-z-xml-light
version:              3.4
package-name:         pandoc
lib-name:             xml-light
id:                   pandoc-3.4-AzB4oTaQNwfAvsiWez3c09-xml-light
key:                  pandoc-3.4-AzB4oTaQNwfAvsiWez3c09-xml-light
license:              GPL-2.0-or-later
copyright:            (c) 2006-2024 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  32d289d7026b396d442e240f15b34cff
exposed-modules:
    Text.Pandoc.XML.Light Text.Pandoc.XML.Light.Output
    Text.Pandoc.XML.Light.Proc Text.Pandoc.XML.Light.Types

import-dirs:          /usr/lib/ghc-9.6.6/site-local/pandoc-3.4
library-dirs:         /usr/lib/ghc-9.6.6/site-local/pandoc-3.4
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/pandoc-3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.4-AzB4oTaQNwfAvsiWez3c09-xml-light
depends:
    base-4.18.2.1 containers-0.6.7 text-2.0.2
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    xml-conduit-1.9.1.4-4ApAZ67Z6lCGy52B3tehMj
    xml-types-0.3.8-ISf6rjkeTjSFXsXdIGBwau

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pandoc
version:              3.4
visibility:           public
id:                   pandoc-3.4-Cjq4EKby3bd7HRkWuDvz7v
key:                  pandoc-3.4-Cjq4EKby3bd7HRkWuDvz7v
license:              GPL-2.0-or-later
copyright:            (c) 2006-2024 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  97549673bdfd64d2ccf08d5420588e6a
exposed:              True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.Chunks
    Text.Pandoc.Citeproc Text.Pandoc.Class Text.Pandoc.Class.IO
    Text.Pandoc.Data Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Filter Text.Pandoc.Format
    Text.Pandoc.Highlighting Text.Pandoc.ImageSize Text.Pandoc.Logging
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Process
    Text.Pandoc.Readers Text.Pandoc.Readers.BibTeX
    Text.Pandoc.Readers.CSV Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.Creole Text.Pandoc.Readers.CslJson
    Text.Pandoc.Readers.Djot Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.Docx Text.Pandoc.Readers.DokuWiki
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.EndNote
    Text.Pandoc.Readers.FB2 Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.Ipynb
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.Jira
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.Man
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.ODT Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RIS
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.RTF
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Typst Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.Scripting Text.Pandoc.SelfContained Text.Pandoc.Shared
    Text.Pandoc.Slides Text.Pandoc.Sources Text.Pandoc.Templates
    Text.Pandoc.Transforms Text.Pandoc.Translations
    Text.Pandoc.Translations.Types Text.Pandoc.UTF8 Text.Pandoc.Version
    Text.Pandoc.Writers Text.Pandoc.Writers.ANSI
    Text.Pandoc.Writers.AnnotatedTable Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.BibTeX Text.Pandoc.Writers.ChunkedHTML
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.CslJson Text.Pandoc.Writers.Djot
    Text.Pandoc.Writers.DocBook Text.Pandoc.Writers.Docx
    Text.Pandoc.Writers.DokuWiki Text.Pandoc.Writers.EPUB
    Text.Pandoc.Writers.FB2 Text.Pandoc.Writers.HTML
    Text.Pandoc.Writers.Haddock Text.Pandoc.Writers.ICML
    Text.Pandoc.Writers.Ipynb Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.Jira Text.Pandoc.Writers.LaTeX
    Text.Pandoc.Writers.Man Text.Pandoc.Writers.Markdown
    Text.Pandoc.Writers.Math Text.Pandoc.Writers.MediaWiki
    Text.Pandoc.Writers.Ms Text.Pandoc.Writers.Muse
    Text.Pandoc.Writers.Native Text.Pandoc.Writers.ODT
    Text.Pandoc.Writers.OOXML Text.Pandoc.Writers.OPML
    Text.Pandoc.Writers.OpenDocument Text.Pandoc.Writers.Org
    Text.Pandoc.Writers.Powerpoint Text.Pandoc.Writers.RST
    Text.Pandoc.Writers.RTF Text.Pandoc.Writers.Shared
    Text.Pandoc.Writers.TEI Text.Pandoc.Writers.Texinfo
    Text.Pandoc.Writers.Textile Text.Pandoc.Writers.Typst
    Text.Pandoc.Writers.XWiki Text.Pandoc.Writers.ZimWiki
    Text.Pandoc.XML

hidden-modules:
    Text.Pandoc.App.CommandLineOptions Text.Pandoc.App.Input
    Text.Pandoc.App.Opt Text.Pandoc.App.OutputSettings
    Text.Pandoc.Class.CommonState Text.Pandoc.Class.PandocMonad
    Text.Pandoc.Class.PandocIO Text.Pandoc.Class.PandocPure
    Text.Pandoc.Class.Sandbox Text.Pandoc.Filter.Environment
    Text.Pandoc.Filter.JSON Text.Pandoc.Parsing.Capabilities
    Text.Pandoc.Parsing.Citations Text.Pandoc.Parsing.General
    Text.Pandoc.Parsing.GridTable Text.Pandoc.Parsing.Lists
    Text.Pandoc.Parsing.Math Text.Pandoc.Parsing.Smart
    Text.Pandoc.Parsing.State Text.Pandoc.Parsing.Future
    Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
    Text.Pandoc.Readers.Docx.Parse
    Text.Pandoc.Readers.Docx.Parse.Styles Text.Pandoc.Readers.Docx.Util
    Text.Pandoc.Readers.Docx.Symbols Text.Pandoc.Readers.Docx.Fields
    Text.Pandoc.Readers.HTML.Parsing Text.Pandoc.Readers.HTML.Table
    Text.Pandoc.Readers.HTML.TagCategories
    Text.Pandoc.Readers.HTML.Types Text.Pandoc.Readers.LaTeX.Inline
    Text.Pandoc.Readers.LaTeX.Citation Text.Pandoc.Readers.LaTeX.Lang
    Text.Pandoc.Readers.LaTeX.Macro Text.Pandoc.Readers.LaTeX.Math
    Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.LaTeX.SIunitx
    Text.Pandoc.Readers.LaTeX.Table Text.Pandoc.Readers.Typst.Parsing
    Text.Pandoc.Readers.Typst.Math Text.Pandoc.Readers.ODT.Base
    Text.Pandoc.Readers.ODT.Namespaces
    Text.Pandoc.Readers.ODT.StyleReader
    Text.Pandoc.Readers.ODT.ContentReader
    Text.Pandoc.Readers.ODT.Generic.Fallible
    Text.Pandoc.Readers.ODT.Generic.SetMap
    Text.Pandoc.Readers.ODT.Generic.Utils
    Text.Pandoc.Readers.ODT.Generic.Namespaces
    Text.Pandoc.Readers.ODT.Generic.XMLConverter
    Text.Pandoc.Readers.ODT.Arrows.State
    Text.Pandoc.Readers.ODT.Arrows.Utils
    Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
    Text.Pandoc.Readers.Org.DocumentTree
    Text.Pandoc.Readers.Org.ExportSettings
    Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
    Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
    Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Metadata
    Text.Pandoc.Readers.Roff Text.Pandoc.Writers.Docx.OpenXML
    Text.Pandoc.Writers.Docx.StyleMap Text.Pandoc.Writers.Docx.Table
    Text.Pandoc.Writers.Docx.Types Text.Pandoc.Writers.GridTable
    Text.Pandoc.Writers.JATS.References Text.Pandoc.Writers.JATS.Table
    Text.Pandoc.Writers.JATS.Types Text.Pandoc.Writers.LaTeX.Caption
    Text.Pandoc.Writers.LaTeX.Notes Text.Pandoc.Writers.LaTeX.Table
    Text.Pandoc.Writers.LaTeX.Lang Text.Pandoc.Writers.LaTeX.Types
    Text.Pandoc.Writers.LaTeX.Citation Text.Pandoc.Writers.LaTeX.Util
    Text.Pandoc.Writers.Markdown.Table
    Text.Pandoc.Writers.Markdown.Types
    Text.Pandoc.Writers.Markdown.Inline Text.Pandoc.Writers.Roff
    Text.Pandoc.Writers.Blaze
    Text.Pandoc.Writers.Powerpoint.Presentation
    Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Char
    Text.Pandoc.TeX Text.Pandoc.URI Text.Pandoc.CSS Text.Pandoc.CSV
    Text.Pandoc.RoffChar Text.Pandoc.UUID Text.Pandoc.Image
    Text.Pandoc.Citeproc.BibTeX Text.Pandoc.Citeproc.Name
    Text.Pandoc.Citeproc.CslJson Text.Pandoc.Citeproc.Data
    Text.Pandoc.Citeproc.Locator Text.Pandoc.Citeproc.MetaValue
    Text.Pandoc.Citeproc.Util Paths_pandoc

import-dirs:          /usr/lib/ghc-9.6.6/site-local/pandoc-3.4
library-dirs:         /usr/lib/ghc-9.6.6/site-local/pandoc-3.4
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/pandoc-3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.4-Cjq4EKby3bd7HRkWuDvz7v
depends:
    Glob-0.10.2-AkNemguOk3X5pWzckA4YZJ
    JuicyPixels-3.3.9-BZDz0HtZCmpDqP3uHNcdhf
    SHA-1.6.4.4-KRZJCS52poaHfqPlW5b8Sg
    aeson-2.1.2.1-GojnAvr1Jep10WUNi5H1Pi
    aeson-pretty-0.8.10-CQgtmRgYKKmDAUdx88Og8E array-0.5.6.0
    attoparsec-0.14.4-8gkbEkDkw506qTMOo0v2nm base-4.18.2.1
    base64-bytestring-1.2.1.0-DIdtXjiFLF0sICzGCxvgr binary-0.8.9.1
    blaze-html-0.9.2.0-1747vvTiFgL3mVhTAPflSj
    blaze-markup-0.8.3.0-HpRZXcaallq6cQxvG0d1r8 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-3fPl2hvou1nDiCO1iE2i5z
    citeproc-0.8.1.1-HiFo28yG2GL22Ajj97jiCf
    commonmark-0.2.6.1-AFyWZFKNc0cCLBasjsgiue
    commonmark-extensions-0.2.5.5-DwZ7ll7vAlW5lAUZnqjmju
    commonmark-pandoc-0.2.2.3-IZb1CpXfDm2BJzfrj4CsLd containers-0.6.7
    crypton-connection-0.4.5-2c10WiKFU3L73agHYaksHE
    crypton-x509-system-1.6.7-AlhozJnZLRBLBROfMMJw3u
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz deepseq-1.4.8.1
    directory-1.3.8.5 djot-0.1.2.3-HXRRsG1AbzMZDArvYl8w7
    doclayout-0.5-G2Wm2VuIsgJ2QywWYn7p6r
    doctemplates-0.11.0.1-4C1WX7z3ar72eiZn8lfdV0
    emojis-0.1.4.1-VOXDtaadLD4hNN8sCPzYl exceptions-0.10.7
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    gridtables-0.1.1.0-EV443V3UxZB3rKLqAiBFRG
    haddock-library-1.11.0-1hjqyuYC4gZ5fYUMDdPuds
    http-client-0.7.19-ITPZXASBEGHLmOi4NfdGY8
    http-client-tls-0.3.6.4-2TpGPIcpPZAJDvilQsJ18b
    http-types-0.12.4-AM56akyPNdKBTyuGfrlHOS
    ipynb-0.2-HRRCBGCdwBPcBmaJ8W25v
    jira-wiki-markup-1.5.1-4U0K4voB4o1DNCAMmJmtYy
    mime-types-0.1.2.0-2lnuHjhOzQ4DFNhuFJ9ART mtl-2.3.1
    network-3.1.4.0-8n0F06kM1hW6KWRJNaBKOe
    network-uri-2.6.4.2-69jfmnohyG88ZQKNy7a5sS
    pandoc-3.4-AzB4oTaQNwfAvsiWez3c09-xml-light
    pandoc-types-1.23.1-84C04huNeQE19kRVi0p0kr parsec-3.1.16.1
    pretty-1.1.3.6 pretty-show-1.10-EXsS4VwIV5tJ56gbmVdfrR
    process-1.6.19.0 random-1.2.1.3-6SxnlPLCqt06GlpnYLfwZm
    safe-0.3.21-6ywRAlXnRFuBscoqJeUz3o
    scientific-0.3.8.0-3zIJLnW8aJ66FNwcOaEmTV
    skylighting-0.14.3-AddMPW6f3CK7ibP8GReFAn
    skylighting-core-0.14.3-7mhH9r2pWCw3xU0g23Jkur
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8 syb-0.7.3-7GPFF4ffw0kLXaCjDkD2wt
    tagsoup-0.14.8-7NiSWLVr0pz5UlKWFZNHUS
    temporary-1.3-DmygwHaZA8GJCfyTYb6Tkl
    texmath-0.12.8.11-56Bt1Nz1IDS2mN7WpfMOoT text-2.0.2
    text-conversions-0.3.1.1-K1Yt8b0G42m5WYfZmJLFVT time-1.12.2
    tls-2.0.6-HHKVvNcSfLyJGme2UrIiax typst-0.6-LXG7NY8AhcN5XkrJNkuzsd
    unicode-collation-0.1.3.6-JSBcmSrCkYr8kT1XHjvyN0
    unicode-transforms-0.4.0.1-6C8M98Uj8qbEfETc6Lwbgj unix-2.8.4.0
    vector-0.13.2.0-L5lYsWFgdBEAgjlr9nnpMP
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    yaml-0.11.11.2-GyIObvMByN0941lpfsiwCu
    zip-archive-0.4.3.2-D5z4MdzfSf9r1oyri6gCT
    zlib-0.7.0.0-5otxZx3SVlrUZcbECZKz5

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

