#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 scotty
version:              0.22
visibility:           public
id:                   scotty-0.22-3WnOxCoD7CN6xHpsnX0XHH
key:                  scotty-0.22-3WnOxCoD7CN6xHpsnX0XHH
license:              BSD-3-Clause
copyright:            (c) 2012-Present, Andrew Farmer and the Scotty contributors
maintainer:           The Scotty maintainers
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- pathParam &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  8b486cedc953296d1519ad988dbb8157
exposed:              True
exposed-modules:
    Web.Scotty Web.Scotty.Cookie Web.Scotty.Internal.Types
    Web.Scotty.Trans Web.Scotty.Trans.Strict

hidden-modules:
    Web.Scotty.Action Web.Scotty.Body Web.Scotty.Route
    Web.Scotty.Trans.Lazy Web.Scotty.Util

import-dirs:          /usr/lib/ghc-9.6.6/site-local/scotty-0.22
library-dirs:         /usr/lib/ghc-9.6.6/site-local/scotty-0.22
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/scotty-0.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scotty
hs-libraries:         HSscotty-0.22-3WnOxCoD7CN6xHpsnX0XHH
depends:
    aeson-2.1.2.1-GojnAvr1Jep10WUNi5H1Pi base-4.18.2.1
    blaze-builder-0.4.4.1-KJNFYglh6UuC57b0V7Eyim bytestring-0.11.5.3
    case-insensitive-1.2.1.0-3fPl2hvou1nDiCO1iE2i5z
    cookie-0.5.0-Dqi2dsQ09KG8Z0mbWITxu5
    data-default-class-0.1.2.2-CDKXYK1wrFx3d5as0Pbjkc exceptions-0.10.7
    http-types-0.12.4-AM56akyPNdKBTyuGfrlHOS
    monad-control-1.0.3.1-JNSSe1yK184K4km57LK5G2 mtl-2.3.1
    network-3.1.4.0-8n0F06kM1hW6KWRJNaBKOe
    regex-compat-0.95.2.2-DwcD5qxZGc67j8Pwq49pag
    resourcet-1.2.6-BDQ4bs2ZkKrFMSf2ISkWBx stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.6.1.0
    transformers-base-0.4.6-IFFPlbMue7bJmNu16qahDQ
    unliftio-0.2.25.1-IdlKKcTSqjp7zAgGJLE7Xd
    wai-3.2.4-DrO6v22Rmno6pXUhKStSuj
    wai-extra-3.1.18-1cKRYsHDvT8fkYumb3esL
    warp-3.4.0-HpC7vpiyF2eriPYOziTRJ

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

