#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.50.3
visibility:           public
id:                   hledger-1.50.3-EkI72Z3OtoeJQtHOHYve1t
key:                  hledger-1.50.3-EkI72Z3OtoeJQtHOHYve1t
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  9eb38a380090c5469b408f62ae618ea5
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Setup Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-1.50.3
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-1.50.3
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-1.50.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.50.3-EkI72Z3OtoeJQtHOHYve1t
depends:
    Decimal-0.5.2-Ee0YaQP1EcK8GFHRFQrAau Diff-0.5-yETzKh0qtuDUuvJdOns8X
    aeson-2.1.2.1-GojnAvr1Jep10WUNi5H1Pi
    ansi-terminal-1.0.2-99kMoKqjfKvAwKECL4LpDt base-4.18.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    containers-0.6.7 data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz
    directory-1.3.8.5 extra-1.7.16-3o8MjPiNQTlLg74BSenHLy
    filepath-1.4.300.1 githash-0.1.6.3-4qZQLgXLtE3IVCVa8zq2mC
    hashable-1.4.7.0-DKTv0aQgcZmBEMi2BPTV4Z haskeline-0.8.2.1
    hledger-lib-1.50.3-DQUG6e8H4CM9AlnTyq6wvA
    http-client-0.7.19-ITPZXASBEGHLmOi4NfdGY8
    http-types-0.12.4-AM56akyPNdKBTyuGfrlHOS
    lucid-2.11.20250303-mIfSyYQWD8L0pbvgCqca8
    math-functions-0.3.4.4-LDnJq54zodn2casmhUMe9e
    megaparsec-9.7.0-Fzm61TdpQu7Cpey7aoa8J9
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    modern-uri-0.3.6.1-IwjiwRk8dF03FTPer57pKX mtl-2.3.1
    process-1.6.19.0 regex-tdfa-1.3.2.5-ATqtlBuPETHJOcVIKuiav2
    req-3.13.4-DyWJPphJym2FpXfyQ7o9pb
    safe-0.3.21-6ywRAlXnRFuBscoqJeUz3o
    shakespeare-2.1.7-ApGKvgcgjcbHs7XYUEyo0A
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8
    tabular-0.2.2.8-Ly9fepE9sHFB2l1Bgv9bkV
    tasty-1.5.2-K3PchMZYxV2JdxeMIpuhjP
    temporary-1.3-DmygwHaZA8GJCfyTYb6Tkl text-2.0.2
    text-ansi-0.3.0.1-CMvVq24ygYaI9xjVVpJ35L time-1.12.2
    timeit-2.0-DwmItJuhuSm6aktMh1S1ZM transformers-0.6.1.0
    unordered-containers-0.2.20.1-50qrTxmoJy9AxZ7OdMnycu
    utf8-string-1.0.2-6mVuGO0K0TVHYD6zuQNk2y
    utility-ht-0.0.17.2-FCtUbDIssee2G1L1Lv2g90
    wizards-1.0.3-EMndOhiYuHdGTEqrX5mo0v

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

