#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-5alqKupEYWA8t04q4jzWZu
key:                  postgrest-10.0.0-5alqKupEYWA8t04q4jzWZu
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  6e2072d3681d09761b9b80e94bab9b80
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-5alqKupEYWA8t04q4jzWZu
depends:
    HTTP-4000.4.1-Ly7mWNR2wStKTaMfBZ435s
    Ranged-sets-0.5.0-3OiUJNRw2np5jF12vHFw5I
    aeson-2.1.2.1-GojnAvr1Jep10WUNi5H1Pi
    auto-update-0.1.6-9ryA5SLAC8xHZnIgVWhrWD base-4.18.2.1
    base64-bytestring-1.2.1.0-DIdtXjiFLF0sICzGCxvgr bytestring-0.11.5.3
    case-insensitive-1.2.1.0-3fPl2hvou1nDiCO1iE2i5z
    cassava-0.5.4.1-I5H7lXHpRMwDMqqRDQwXhI
    configurator-pg-0.2.11-IHuq5ZDrGHcBrclCBJi8hS containers-0.6.7
    contravariant-extras-0.3.5.4-3woyg6AJRP6Lk666ZeP5zR
    cookie-0.5.0-Dqi2dsQ09KG8Z0mbWITxu5 directory-1.3.8.5
    either-5.0.3-LXBywpYsrH13GkjtmaGjK1
    gitrev-1.3.1-HjgHeGOzFY1JvYhlt8eDSs
    hasql-1.5.0.5-D13dwG1Hnoj5UOBosN4Mcc
    hasql-dynamic-statements-0.3.1.1-3KxL6xXFafg5OkAOOAtHCk
    hasql-notifications-0.2.0.5-1dpUctTVyay3DdEG4r8MDm
    hasql-pool-0.5.2.2-HxfrSKcGj0MQHhb0GROcK
    hasql-transaction-1.0.1.1-BmgVJCtyClDsf99umbbnq
    heredoc-0.2.0.0-6fzsisYvDUd6tBbd4jIzIt
    http-types-0.12.4-AM56akyPNdKBTyuGfrlHOS
    insert-ordered-containers-0.2.5.3-Dukg6b3O0oB3rj9hcuMQqG
    interpolatedstring-perl6-1.0.2-87l2USw2aPw6Ltci0fauDV
    jose-0.10-8MoFUQjohBKB2fWreJYd9V lens-5.3.3-HAYf6JaG0qX5o8D7xn9NgM
    lens-aeson-1.2.3-FAgRYVuU5157AZ98ZS6OOm mtl-2.3.1
    network-3.1.4.0-8n0F06kM1hW6KWRJNaBKOe
    network-uri-2.6.4.2-69jfmnohyG88ZQKNy7a5sS
    optparse-applicative-0.18.1.0-AbA9pm273O8LTotNJ1t1CE
    parsec-3.1.16.1 protolude-0.3.5-7SWbne44JkdFiBIH3eNLnc
    regex-tdfa-1.3.2.5-ATqtlBuPETHJOcVIKuiav2
    retry-0.9.3.1-HEvs5AQWwJi8IsgEJKYYst
    scientific-0.3.8.0-3zIJLnW8aJ66FNwcOaEmTV
    swagger2-2.8.10-Fm97ws82YhV4MJk54EC85t text-2.0.2 time-1.12.2
    unix-2.8.4.0 unordered-containers-0.2.20.1-50qrTxmoJy9AxZ7OdMnycu
    vault-0.3.1.5-1WesiFbrgeBJ6Pz5D8LxKa
    vector-0.13.2.0-L5lYsWFgdBEAgjlr9nnpMP
    wai-3.2.4-DrO6v22Rmno6pXUhKStSuj
    wai-cors-0.2.7-El0NDX5Zn1eHjnX2LhYzcA
    wai-extra-3.1.18-1cKRYsHDvT8fkYumb3esL
    wai-logger-2.5.0-DJcZLrYZUmgA3l0XNoCO69
    warp-3.4.0-HpC7vpiyF2eriPYOziTRJ

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

