#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-2Bi1kQ6dpL0C0u22GVLCUp
key:                  arch-hs-0.12.1-2Bi1kQ6dpL0C0u22GVLCUp
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  92486926adf08a74b04d051280ecb40c
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-2Bi1kQ6dpL0C0u22GVLCUp
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.10.3.0 Diff-0.5-LvDn2Q3VCdHFITtPH7S2dt
    aeson-2.2.0.0-Hqy1Zqe0ZE81dk2L20icmH
    algebraic-graphs-0.7-HNNdq6GmhV4IA6X9YdiK7U
    arch-web-0.3.2-9PCbvBIVYoz903bNUTaysy base-4.18.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-CwUx671uWmDAcHwxI0YYDy
    conduit-extra-1.3.8-GHF5wYhQp30HUaLAtCbs0G containers-0.6.7
    deepseq-1.4.8.1 directory-1.3.8.5 filepath-1.4.300.1
    hackage-db-2.1.3-ESbX3HWdcJNHIqTI1okzmh
    http-client-0.7.19-HYRPxJ1velFCbteX9ut4f6
    http-client-tls-0.3.6.4-ILttD7UGaFL2zbr7B8I43g
    megaparsec-9.7.0-EBrXuyfSuyTIUi7T8Ua8UQ
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw
    neat-interpolation-0.5.1.4-1PcEeHNuvewIWj7sRVWPyB
    optparse-simple-0.1.1.4-nMfLE5JFMwFEfYqENPwyu
    polysemy-1.9.2.0-E8GqxGnfvm7LmeTYNegj9c
    prettyprinter-1.7.1-LgLGkLn2CvpBXnv6jAGI5w
    prettyprinter-ansi-terminal-1.1.3-3YHuZgfqQpP5I7Y91Adm4o
    servant-client-0.20.3.0-H8EwQt1tF7VBmKDs451vhE
    split-0.2.5-8jaYNHp3QVW6mrtuSFwro6
    tar-conduit-0.4.1-IbFnJAoRSSZ5e98idSZxu0 template-haskell-2.20.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

