/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import java.io.InterruptedIOException;
import org.a11y.brlapi.ConnectException;
import org.a11y.brlapi.ConnectionBase;
import org.a11y.brlapi.ConnectionSettings;
import org.a11y.brlapi.DisplaySize;
import org.a11y.brlapi.Parameters;

public class Connection
extends ConnectionBase {
    private Parameters connectionParameters = null;

    public Connection(ConnectionSettings connectionSettings) throws ConnectException {
        super(connectionSettings);
    }

    public int getCellCount() {
        DisplaySize displaySize = this.getDisplaySize();
        return displaySize.getWidth() * displaySize.getHeight();
    }

    public int enterTtyMode(int n) {
        return this.enterTtyMode(n, null);
    }

    public int enterTtyMode(String string) {
        return this.enterTtyMode(-1, string);
    }

    public int enterTtyMode() {
        return this.enterTtyMode(null);
    }

    public void enterTtyModeWithPath(int[] nArray, String string) {
        this.enterTtyModeWithPath(string, nArray);
    }

    public void enterTtyModeWithPath(int ... nArray) {
        this.enterTtyModeWithPath(null, nArray);
    }

    public final long readKey() throws InterruptedIOException {
        return this.readKey(true);
    }

    public void write(byte[] byArray) {
        int n = this.getCellCount();
        if (byArray.length != n) {
            byte[] byArray2 = new byte[n];
            while (n > byArray.length) {
                byArray2[--n] = 0;
            }
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        this.writeDots(byArray);
    }

    public void write(int n, String string) {
        if (string != null) {
            int n2 = this.getCellCount();
            StringBuilder stringBuilder = new StringBuilder(string);
            while (stringBuilder.length() < n2) {
                stringBuilder.append(' ');
            }
            string = stringBuilder.toString();
            if (string.length() > n2) {
                string = string.substring(0, n2);
            }
        }
        this.writeText(n, string);
    }

    public void write(String string, int n) {
        this.write(n, string);
    }

    public void write(int n) {
        this.write(n, null);
    }

    public void write(String string) {
        this.write(-1, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameters getParameters() {
        Connection connection = this;
        synchronized (connection) {
            if (this.connectionParameters == null) {
                this.connectionParameters = new Parameters(this);
            }
        }
        return this.connectionParameters;
    }
}

