#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-DSisYBREzQ8LTwFaB4nUa2
key:                  gitit-0.15.1.2-DSisYBREzQ8LTwFaB4nUa2
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  01c03d2b8cbfcdb5d9732b6aa32a3a8a
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-DSisYBREzQ8LTwFaB4nUa2
depends:
    HStringTemplate-0.8.8-ACHp6I1W0x75jJ230zcM0u
    HTTP-4000.4.1-9QKOH3moG66E3gEMmY9ujp
    SHA-1.6.4.4-KRZJCS52poaHfqPlW5b8Sg
    aeson-2.1.2.1-CpIoOLI7lIpJkSqSOmDN9y base-4.18.2.1
    base64-bytestring-1.2.1.0-AZbYiNuTo1lLfA6t4c9Fhh
    blaze-html-0.9.2.0-5pCa6Zd2ytCBxKPCiAVcIx bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.8.5
    doctemplates-0.11.0.1-FbE5pAm9pT9IYBZ2Oe97Y2
    feed-1.3.2.1-4qTBGuAxtGJGGo2NCAKV3s filepath-1.4.300.1
    filestore-0.6.5.1-4fGXGafM4vn3DfBp90lepj ghc-9.6.6
    ghc-paths-0.1.0.12-JSGGj7CcxjZ2Iy0LlOG5cZ
    happstack-server-7.9.3-3zzuzE4wnty2Ke4haceqjA
    hoauth2-2.14.0-DaCVyDpXxKl9BEI9jxEDQE
    hslogger-1.3.2.0-1NkMetVZZQxCHjmQHJSTJK
    http-client-tls-0.3.6.4-GXwyMNGv8mPI3u8Rlj5noc
    http-conduit-2.3.9.1-4fv8UoY8zTlKlPGaK7tn4g
    json-0.10-CVmt8wAUbKLCRDBxbUg8QP mtl-2.3.1
    network-3.1.4.0-JRitsFhJ8rKGUNW13KrLgQ
    network-bsd-2.8.1.0-D7anFlGqSCnK99qTn3SolU
    network-uri-2.6.4.2-ImBkmHhWmdwGJdqs22FerI
    old-locale-1.0.0.7-Gunit3UBy5P9OGDVFY5MhC
    old-time-1.1.0.4-3lD0LwNFkdkGhWCMuxpBlx
    pandoc-3.5-55SkYSUzRIiB5PVZOvExG3
    pandoc-types-1.23.1-8LyhSCLdqfo18RNKTPAafp parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.19.0
    random-1.2.1.3-LIVoFEqTBeMDojO1AYDBLj
    recaptcha-0.1.0.4-Giqw7y5EBNv9hchYrP8iVJ
    safe-0.3.21-7oQO4KcgDWt1YhK3ifcAwa
    skylighting-0.14.3-v6qfnt4yoq3ZY4MtMNSf8
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8 syb-0.7.3-MvqtDDcT2PHyhdKWhEKAp
    tagsoup-0.14.8-DBaP5fMg0izLpBRp0VL2HR
    temporary-1.3-29RL4tTXoFB72QSCtJnhBC text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-ABUb28LEu2c8RUJdcl5zx0
    url-2.1.3-FnoMg0Amz5x5iDNEWuwHDq
    utf8-string-1.0.2-GrV0vD7epd2Fw38ZtPT1hv
    uuid-1.3.16-8QEdndSNqxbGO60kyYYcsS xhtml-3000.2.2.1
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    xml-conduit-1.9.1.4-AWUHrHEyod1C1UJeqVfDQt
    xml-types-0.3.8-ISf6rjkeTjSFXsXdIGBwau
    xss-sanitize-0.3.7.2-8cNHDGVpLwFLDuj2Azhm7R
    zlib-0.7.0.0-H0rgJT2cf7y1jpEf30oLpw

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

