#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-2yqBwniypIAE9WkZulqSYk
key:                  gitit-0.15.1.2-2yqBwniypIAE9WkZulqSYk
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  1c5ea711b0fa2bc1dcf9f757b379fb46
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-2yqBwniypIAE9WkZulqSYk
depends:
    HStringTemplate-0.8.8-CjxFjayIGZYI8nj3tTZckO
    HTTP-4000.4.1-LiE2KGoUj7cHY0TLoqm68A
    SHA-1.6.4.4-KRZJCS52poaHfqPlW5b8Sg
    aeson-2.2.0.0-Hqy1Zqe0ZE81dk2L20icmH base-4.18.2.1
    base64-bytestring-1.2.1.0-LrCtfbXf96jILPXKH7KAXZ
    blaze-html-0.9.2.0-AqjQr4Ps51QD51ybemU3ZY bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.8.5
    doctemplates-0.11.0.1-HvoxNiGSiQEAkgF4uIK5Hl
    feed-1.3.2.1-1GhmSKXm1QFKSLqW7NL51K filepath-1.4.300.1
    filestore-0.6.5.1-FiXzJcvHPa7DptyOD25JdV ghc-9.6.6
    ghc-paths-0.1.0.12-JSGGj7CcxjZ2Iy0LlOG5cZ
    happstack-server-7.9.3-2SF1icxCSBb3vdMfika2iQ
    hoauth2-2.14.0-5SPAc5luVEH4UiJCJoX8cX
    hslogger-1.3.2.0-IyqwOFGVXOR57mWYE4psSE
    http-client-tls-0.3.6.4-ILttD7UGaFL2zbr7B8I43g
    http-conduit-2.3.9.1-4XCjseDTPMR1cOfyxjAQAe
    json-0.10-Ix3cJnfMrt84nrYZAgyGJ mtl-2.3.1
    network-3.1.4.0-xB4epdb1XO3ZKzAxljM4X
    network-bsd-2.8.1.0-FViALY8rbUn98btsHnSUKD
    network-uri-2.6.4.2-1aRZPUfkmMD8JwUJF5GqMA
    old-locale-1.0.0.7-Gunit3UBy5P9OGDVFY5MhC
    old-time-1.1.0.4-3lD0LwNFkdkGhWCMuxpBlx
    pandoc-3.5-5SF7KFwug7mFO7qlpyjx0e
    pandoc-types-1.23.1-CJH803wvmoH5NkoCOHPWhx parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.19.0
    random-1.2.1.3-6l1YOhgkyj83HD6td8a68Q
    recaptcha-0.1.0.4-JvLwYjM0QbpFxLAq0JHjvp
    safe-0.3.21-KkG5O6k2axl5FoNYEbOYS8
    skylighting-0.14.3-AFjprEBMEWgB4aVqA4d61N
    split-0.2.5-8jaYNHp3QVW6mrtuSFwro6 syb-0.7.3-GhxEKVO9aRZHddME5iK0hL
    tagsoup-0.14.8-4K1YWE9FoiC3G64iorq40t
    temporary-1.3-GTgxkhi2PMM37jgbXakJ3s text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-9OHYoBsOYu66vNFfAm8FOr
    url-2.1.3-7Kl4E3eXP9D927NfHGnLmQ
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    uuid-1.3.16-1rdJ16rKpapCuGGJEV1Hir xhtml-3000.2.2.1
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    xml-conduit-1.9.1.4-6YUKnRkiQ5NBAoTmcKCArn
    xml-types-0.3.8-ISf6rjkeTjSFXsXdIGBwau
    xss-sanitize-0.3.7.2-ChnRiWcYoX01TL0SXbGH9m
    zlib-0.7.0.0-KycIpdUZG34Fi5Aj6BOrFq

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

