#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arithmoi
version:              0.13.2.0
visibility:           public
id:                   arithmoi-0.13.2.0-59AFmTvILSo7UOaKgVK86L
key:                  arithmoi-0.13.2.0-59AFmTvILSo7UOaKgVK86L
license:              MIT
copyright:
    (c) 2016-2021 Andrew Lelechenko, 2016-2019 Carter Schonwald, 2011 Daniel Fischer

maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:               Andrew Lelechenko, Daniel Fischer
homepage:             https://github.com/Bodigrim/arithmoi
synopsis:             Efficient basic number-theoretic functions.
description:
    A library of basic functionality needed for
    number-theoretic calculations. The aim of this library
    is to provide efficient implementations of the functions.
    Primes and related things (totients, factorisation),
    powers (integer roots and tests, modular exponentiation).

category:             Math, Algorithms, Number Theory
abi:                  f8b0d1a60e1c393200772a05e1aa35fb
exposed:              True
exposed-modules:
    Math.NumberTheory.ArithmeticFunctions
    Math.NumberTheory.ArithmeticFunctions.Inverse
    Math.NumberTheory.ArithmeticFunctions.Mertens
    Math.NumberTheory.ArithmeticFunctions.Moebius
    Math.NumberTheory.ArithmeticFunctions.NFreedom
    Math.NumberTheory.ArithmeticFunctions.SieveBlock
    Math.NumberTheory.Curves.Montgomery Math.NumberTheory.Diophantine
    Math.NumberTheory.DirichletCharacters
    Math.NumberTheory.Euclidean.Coprimes Math.NumberTheory.Moduli
    Math.NumberTheory.Moduli.Cbrt Math.NumberTheory.Moduli.Chinese
    Math.NumberTheory.Moduli.Class Math.NumberTheory.Moduli.Equations
    Math.NumberTheory.Moduli.Multiplicative
    Math.NumberTheory.Moduli.Singleton Math.NumberTheory.Moduli.Sqrt
    Math.NumberTheory.MoebiusInversion Math.NumberTheory.Prefactored
    Math.NumberTheory.Primes Math.NumberTheory.Primes.Counting
    Math.NumberTheory.Primes.IntSet Math.NumberTheory.Primes.Testing
    Math.NumberTheory.Quadratic.EisensteinIntegers
    Math.NumberTheory.Quadratic.GaussianIntegers
    Math.NumberTheory.Recurrences
    Math.NumberTheory.Recurrences.Bilinear
    Math.NumberTheory.Recurrences.Linear
    Math.NumberTheory.SmoothNumbers Math.NumberTheory.Zeta

hidden-modules:
    Math.NumberTheory.ArithmeticFunctions.Class
    Math.NumberTheory.ArithmeticFunctions.Standard
    Math.NumberTheory.Moduli.Internal
    Math.NumberTheory.Moduli.JacobiSymbol
    Math.NumberTheory.Moduli.SomeMod
    Math.NumberTheory.Primes.Counting.Approximate
    Math.NumberTheory.Primes.Counting.Impl
    Math.NumberTheory.Primes.Factorisation.Montgomery
    Math.NumberTheory.Primes.Factorisation.TrialDivision
    Math.NumberTheory.Primes.Sieve.Eratosthenes
    Math.NumberTheory.Primes.Sieve.Indexing
    Math.NumberTheory.Primes.Small
    Math.NumberTheory.Primes.Testing.Certified
    Math.NumberTheory.Primes.Testing.Probabilistic
    Math.NumberTheory.Primes.Types
    Math.NumberTheory.Recurrences.Pentagonal
    Math.NumberTheory.RootsOfUnity Math.NumberTheory.Utils
    Math.NumberTheory.Utils.DirichletSeries
    Math.NumberTheory.Utils.FromIntegral
    Math.NumberTheory.Utils.Hyperbola Math.NumberTheory.Zeta.Dirichlet
    Math.NumberTheory.Zeta.Hurwitz Math.NumberTheory.Zeta.Riemann
    Math.NumberTheory.Zeta.Utils

import-dirs:          /usr/lib/ghc-9.6.6/site-local/arithmoi-0.13.2.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/arithmoi-0.13.2.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/arithmoi-0.13.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-arithmoi
hs-libraries:         HSarithmoi-0.13.2.0-59AFmTvILSo7UOaKgVK86L
depends:
    base-4.18.2.1 bitvec-1.1.5.0-2hC1G34fm4D80nTSaXKdsx
    chimera-0.4.1.0-3nthmfbAHPDG7nj8peFMYj
    constraints-0.14.2-5Hasiz3qGyu5OkYwKIAmXY containers-0.6.7
    deepseq-1.4.8.1 exact-pi-0.5.0.2-Fgw2apyh1eCCeHrXqzobgV
    ghc-bignum-1.3 infinite-list-0.1.2-FdB6Xev5mO691BUO3V7cPB
    integer-logarithms-1.0.4-CFxTakyA1gmKMtDwn6V7ef
    integer-roots-1.0.3.0-LbF5VhPWOi686FK780A1f3
    mod-0.2.1.0-JSQHZIKeeI1K094sxFiRuC
    random-1.2.1.3-6SxnlPLCqt06GlpnYLfwZm
    semirings-0.7-8162LSCg6NF8rsK4aoGRyq transformers-0.6.1.0
    vector-0.13.2.0-L5lYsWFgdBEAgjlr9nnpMP

haddock-interfaces:   /usr/share/doc/haskell-arithmoi/html/arithmoi.haddock
haddock-html:         /usr/share/doc/haskell-arithmoi/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

