#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 brick
version:              0.71.1
visibility:           public
id:                   brick-0.71.1-JdfqlrLwBnj3lBHnnleSGu
key:                  brick-0.71.1-JdfqlrLwBnj3lBHnnleSGu
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2022
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  931c12a126772e9d60cf31c62204e660
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Main Brick.Themes Brick.Types Brick.Util
    Brick.Widgets.Border Brick.Widgets.Border.Style
    Brick.Widgets.Center Brick.Widgets.Core Brick.Widgets.Dialog
    Brick.Widgets.Edit Brick.Widgets.FileBrowser Brick.Widgets.List
    Brick.Widgets.ProgressBar Brick.Widgets.Table Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.Internal
    Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.6.6/site-local/brick-0.71.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/brick-0.71.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/brick-0.71.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick0.71
hs-libraries:         HSbrick-0.71.1-JdfqlrLwBnj3lBHnnleSGu
depends:
    base-4.18.2.1 bytestring-0.11.5.3
    config-ini-0.2.7.0-5rOA8LDN0M5875w00vUrt7 containers-0.6.7
    contravariant-1.5.5-JUOgBPNZkO18h7ix7HMuaW
    data-clist-0.2-Cqe5zddSI1ZLOdEgu4pAL1 deepseq-1.4.8.1
    directory-1.3.8.5 dlist-1.0-B7D1vsARFiIHVaGk5CGbYO
    exceptions-0.10.7 filepath-1.4.300.1
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-mtl-0.2.1.0-Ewo8HmKpWhTASatFX3KZGS
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw stm-2.5.1.0
    template-haskell-2.20.0.0 text-2.0.2
    text-zipper-0.13-I9xIkAkNCdFHOF70IpFfXX transformers-0.6.1.0
    unix-2.8.4.0 vector-0.13.2.0-L5lYsWFgdBEAgjlr9nnpMP
    vty-5.39-3q0L5E3i3hsCVn6rztsT8c
    word-wrap-0.5-6fKuMGuR3bG4X1sVAx8Q29

haddock-interfaces:   /usr/share/doc/haskell-brick0.71/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick0.71/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

