#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 config-ini
version:              0.2.7.0
visibility:           public
id:                   config-ini-0.2.7.0-3OteIIBEOeqGioWIhNZStF
key:                  config-ini-0.2.7.0-3OteIIBEOeqGioWIhNZStF
license:              BSD-3-Clause
copyright:            ©2018 Getty Ritter
maintainer:           Getty Ritter <config-ini@infinitenegativeutility.com>
author:               Getty Ritter <config-ini@infinitenegativeutility.com>
homepage:             https://github.com/aisamanra/config-ini
synopsis:             A library for simple INI-based configuration files.
description:
    The @config-ini@ library is a set of small monadic languages
    for writing simple configuration languages with convenient,
    human-readable error messages.

    > parseConfig :: IniParser (Text, Int, Bool)
    > parseConfig = section "NETWORK" $ do
    >   user <- field        "user"
    >   port <- fieldOf      "port" number
    >   enc  <- fieldFlagDef "encryption" True
    >   return (user, port, enc)

category:             Configuration
abi:                  ccc3c7d35584bc54b054ebeabbb65ba2
exposed:              True
exposed-modules:
    Data.Ini.Config Data.Ini.Config.Bidir Data.Ini.Config.Raw

import-dirs:          /usr/lib/ghc-9.6.6/site-local/config-ini-0.2.7.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/config-ini-0.2.7.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/config-ini-0.2.7.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-config-ini
hs-libraries:         HSconfig-ini-0.2.7.0-3OteIIBEOeqGioWIhNZStF
depends:
    base-4.18.2.1 containers-0.6.7
    megaparsec-9.7.0-EBrXuyfSuyTIUi7T8Ua8UQ text-2.0.2
    transformers-0.6.1.0
    unordered-containers-0.2.20.1-1hrud2F05KV7Rz7RsKTZ5O

haddock-interfaces:   /usr/share/doc/haskell-config-ini/html/config-ini.haddock
haddock-html:         /usr/share/doc/haskell-config-ini/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

