#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 filepath-bytestring
version:              1.5.2.0.2
visibility:           public
id:                   filepath-bytestring-1.5.2.0.2-EJEtvqUwKGx3fhrUQW1qkx
key:                  filepath-bytestring-1.5.2.0.2-EJEtvqUwKGx3fhrUQW1qkx
license:              BSD-3-Clause
copyright:
    Neil Mitchell 2005-2019
    Joey Hess 2019-2021

maintainer:           Joey Hess <id@joeyh.name>
author:               Neil Mitchell <ndmitchell@gmail.com>
synopsis:
    Library for manipulating RawFilePaths in a cross platform way.

description:
    This package provides functionality for manipulating @RawFilePath@
    values. It can be used as a drop in replacement for the filepath library
    to get the benefits of using ByteStrings. It provides three modules:

    * "System.FilePath.Posix.ByteString" manipulates POSIX\/Linux style @RawFilePath@ values (with @\/@ as the path separator).

    * "System.FilePath.Windows.ByteString" manipulates Windows style @RawFilePath@ values (with either @\\@ or @\/@ as the path separator, and deals with drives).

    * "System.FilePath.ByteString" is an alias for the module appropriate to your platform.

    All three modules provide the same API, and the same documentation (calling out differences in the different variants).

    This package is now deprecated, since filepath 1.4.100.0 provides an
    OsPath type that is based on a bytestring. See
    https://hasufell.github.io/posts/2022-06-29-fixing-haskell-filepaths.html

category:             System
abi:                  7faad473ff15fd3ba1b45b33a131ee9a
exposed:              True
exposed-modules:
    System.FilePath.ByteString System.FilePath.Posix.ByteString
    System.FilePath.Windows.ByteString

import-dirs:          /usr/lib/ghc-9.6.6/site-local/filepath-bytestring-1.5.2.0.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/filepath-bytestring-1.5.2.0.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/filepath-bytestring-1.5.2.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-filepath-bytestring
hs-libraries:         HSfilepath-bytestring-1.5.2.0.2-EJEtvqUwKGx3fhrUQW1qkx
depends:
    base-4.18.2.1 bytestring-0.11.5.3 filepath-1.4.300.1 unix-2.8.4.0

haddock-interfaces:
    /usr/share/doc/haskell-filepath-bytestring/html/filepath-bytestring.haddock

haddock-html:         /usr/share/doc/haskell-filepath-bytestring/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

