#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hashable
version:              1.4.7.0
visibility:           public
id:                   hashable-1.4.7.0-1GSULm1uRgQBgX6mu6tvYD
key:                  hashable-1.4.7.0-1GSULm1uRgQBgX6mu6tvYD
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Milan Straka <fox@ucw.cz>
    Johan Tibell <johan.tibell@gmail.com>

stability:            Provisional
homepage:             http://github.com/haskell-unordered-containers/hashable
synopsis:             A class for types that can be converted to a hash value
description:
    This package defines a class, '\''Hashable'\'', for types that can be converted to a hash value.
    This class exists for the benefit of hashing-based data structures.
    The package provides instances for basic types and a way to combine hash values.

    '\''Hashable'\'' is intended exclusively for use in in-memory data structures.

    '\''Hashable'\'' does /not/ have a fixed standard.
    This allows it to improve over time.

    Because it does not have a fixed standard, different computers or computers on different versions of the code will observe different hash values.
    As such, '\''hashable'\'' is not recommended for use other than in-memory datastructures.
    Specifically, '\''hashable'\'' is not intended for network use or in applications which persist hashed values.
    For stable hashing use named hashes: sha256, crc32, xxhash etc.

category:             Data
abi:                  66c0584eb92e4da7c79e78ffea7e73a2
exposed:              True
exposed-modules:
    Data.Hashable Data.Hashable.Generic Data.Hashable.Lifted

hidden-modules:
    Data.Hashable.Class Data.Hashable.FFI
    Data.Hashable.Generic.Instances Data.Hashable.Imports
    Data.Hashable.LowLevel Data.Hashable.Mix Data.Hashable.XXH3

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hashable-1.4.7.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hashable-1.4.7.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hashable-1.4.7.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hashable
hs-libraries:         HShashable-1.4.7.0-1GSULm1uRgQBgX6mu6tvYD
includes:             HsHashable.h HsXXHash.h xxhash.h
depends:
    base-4.18.2.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.1
    filepath-1.4.300.1 ghc-bignum-1.3 ghc-prim-0.10.0
    os-string-2.0.8-D0wNnGg8ZcR9R5RCvHxlBy text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-hashable/html/hashable.haddock
haddock-html:         /usr/share/doc/haskell-hashable/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

