#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.51.2
visibility:           public
id:                   hledger-lib-1.51.2-GHZoWop2PXO2xzvMmGKvTd
key:                  hledger-lib-1.51.2-GHZoWop2PXO2xzvMmGKvTd
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  3a7ea7a3b64f36f9709cc64927dea30d
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.BalanceData Hledger.Data.Balancing
    Hledger.Data.Currency Hledger.Data.Dates Hledger.Data.DayPartition
    Hledger.Data.Errors Hledger.Data.Journal Hledger.Data.JournalChecks
    Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period Hledger.Data.PeriodData
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Hledger.Write.Beancount Hledger.Write.Csv Hledger.Write.Html
    Hledger.Write.Html.Attribute Hledger.Write.Html.Blaze
    Hledger.Write.Html.HtmlCommon Hledger.Write.Html.Lucid
    Hledger.Write.Ods Hledger.Write.Spreadsheet Text.Tabular.AsciiWide
    Text.WideString

hidden-modules:       Paths_hledger_lib
import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-lib-1.51.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-lib-1.51.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-lib-1.51.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.51.2-GHZoWop2PXO2xzvMmGKvTd
depends:
    Decimal-0.5.2-LTTKXS6uNcn3lj0JriESvl
    Glob-0.10.2-FFUARUINQX9K4f2r91vRK8
    aeson-2.2.0.0-Hqy1Zqe0ZE81dk2L20icmH
    aeson-pretty-0.8.10-eT1JM8BphwIKZ7kNgAtSZ
    ansi-terminal-1.1-IMcNZ5h2aza3c3hvu2tQms array-0.5.6.0
    base-4.18.2.1 blaze-html-0.9.2.0-AqjQr4Ps51QD51ybemU3ZY
    blaze-markup-0.8.3.0-K7wUMOM5SyIFeEdepQMdjc bytestring-0.11.5.3
    call-stack-0.4.0-2bP2isqo6m56I7hpBeHX0O
    cassava-0.5.4.1-10TjIuvMZgmC1Daoo8YXOm
    cassava-megaparsec-2.1.1-BjXCrozgjEp2NHqI4p9cxW
    cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    colour-2.3.6-3w6KTKXw4UOJxMlHZXmqB6 containers-0.6.7
    data-default-0.7.1.3-Ihbp7WFUy146w4K1utdfXl deepseq-1.4.8.1
    directory-1.3.8.5 doclayout-0.5-41hL3oGVC8JBKrRw4BZMrm
    encoding-0.10.2-EdZ7MFMrmgc7ih7Za3MbL7
    extra-1.7.16-1R70WzmZutyIjhcnCYje37
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    hashtables-1.4.2-CndPy8fya8qDgMvOb3mdos
    lucid-2.11.20250303-K6g6EvbE7Ue4YCDhz9bqif
    megaparsec-9.7.0-EBrXuyfSuyTIUi7T8Ua8UQ
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw mtl-2.3.1
    parser-combinators-1.3.1-8aQ8dKOwDVmFxT1S1WvW6m
    pretty-simple-4.1.4.0-KsmntfqOFYi4PAX7tMhvIo process-1.6.19.0
    regex-tdfa-1.3.2.5-IyWFwjfcdby2Ov14zG8K3o
    safe-0.3.21-KkG5O6k2axl5FoNYEbOYS8
    tabular-0.2.2.8-Ly9fepE9sHFB2l1Bgv9bkV
    tasty-1.5.2-9G3Kf1f0lGYDWNQy5BbNrN
    tasty-hunit-0.10.2-IM2Egl7oguPC2MIxuBFD1F template-haskell-2.20.0.0
    terminal-size-0.3.4-RfZxi4foNwK9w669pzI7h text-2.0.2
    these-1.2.1-7cZGVd7UTfy2HKT7yUNRZL time-1.12.2
    timeit-2.0-DwmItJuhuSm6aktMh1S1ZM transformers-0.6.1.0
    uglymemo-0.1.0.1-9CTAG7WaUP4YIMm3gIN93
    unordered-containers-0.2.20.1-1hrud2F05KV7Rz7RsKTZ5O
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

