#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-39zNHDOvyzR8WzE4iBQG8r
key:                  hOpenPGP-2.10.1-39zNHDOvyzR8WzE4iBQG8r
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  f322c1adcaf230437745f6183eb1f683
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-39zNHDOvyzR8WzE4iBQG8r
depends:
    aeson-2.2.0.0-Hqy1Zqe0ZE81dk2L20icmH
    asn1-encoding-0.9.6-AvYB4EqU5FZ22SW1977wl2
    attoparsec-0.14.4-8hLS1m777hPFjiaInp95BL base-4.18.2.1
    base16-bytestring-1.0.2.0-6gPusxqn90AJxFEjBUebK6
    bifunctors-5.6.2-I7pgRA67vmLKXPFLDlBNmR binary-0.8.9.1
    binary-conduit-1.3.1-D2HERwCAm7CAQcpQOsz2qy bytestring-0.11.5.3
    bz2-1.0.1.1-xOYhlnAhNs4tONLsWJA1Q
    conduit-1.3.6.1-CwUx671uWmDAcHwxI0YYDy
    conduit-extra-1.3.8-GHF5wYhQp30HUaLAtCbs0G containers-0.6.7
    crypto-cipher-types-0.0.9-KR6SDml7aC01N7sg8RBO5C
    crypton-1.0.4-37TsNQoV8Vb5042LlXS4MC
    errors-2.3.0-H76Wa2t4B4P9Ei4dSqi6yk
    hashable-1.4.7.0-LSmBhr9Bt59DsIlhOBFmCL
    incremental-parser-0.5.1-1zwpOfUiS8m4RRTulft9e5
    ixset-typed-0.5.1.0-FRJruE64YnsCHUeANZiSmL
    lens-5.3.3-KFcjpRU85K93uhgNXhcmM2
    memory-0.18.0-6zo36PbRecTK4fqbBnx0f5
    monad-loops-0.4.3-LG7facWXNYz9W52syv7lz8
    nettle-0.3.1.1-DuwdlQIRX7hBXjJiv7OWDZ
    network-uri-2.6.4.2-1aRZPUfkmMD8JwUJF5GqMA
    openpgp-asciiarmor-0.1.2-9YRT9EeRJ0GgjENao5jxN
    prettyprinter-1.7.1-LgLGkLn2CvpBXnv6jAGI5w
    resourcet-1.2.6-JtO0n9rtgTt543EMYn7K77
    split-0.2.5-8jaYNHp3QVW6mrtuSFwro6 text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-8XUEctZKps57K6Zw5siYoh
    transformers-0.6.1.0 unliftio-core-0.2.1.0-6sOpIonHj8t5wIbPhWbPHY
    unordered-containers-0.2.20.1-1hrud2F05KV7Rz7RsKTZ5O
    zlib-0.7.0.0-KycIpdUZG34Fi5Aj6BOrFq

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

