#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 indexed-list-literals
version:              0.2.1.3
visibility:           public
id:                   indexed-list-literals-0.2.1.3-hUa7YDtlcMJ0HP4wcjgq3
key:                  indexed-list-literals-0.2.1.3-hUa7YDtlcMJ0HP4wcjgq3
license:              BSD-3-Clause
maintainer:           dmillardurrant@gmail.com
author:               David Millar-Durrant
homepage:             https://github.com/davidm-d/indexed-list-literals
synopsis:             Type safe indexed list literals
description:
    This is an incredibly simple library, which makes writing lists where the length is known at compile time a little bit nicer.

    If you write a function with the signature

    > vector :: ILL input length output => input -> Vector length output
    then

    > v :: Vector 3 Int
    > v = vector (1,2,3)
    >
    > x :: Vector 0 Double
    > x = vector $ ZeroTuple @Double
    >
    > y :: Vector 1 Double
    > y = vector (Only 1)
    >
    > z :: Vector 2 String
    > z = vector ("Hello", "World")

    If want matrix literals you can write a function

    > matrix :: (ILL row width ty, ILL matrix height row) => matrix -> Matrix width height ty
    then

    > a :: Matrix 0 0 Bool
    > a = matrix $ ZeroTuple @(ZeroTuple Bool)
    >
    > b :: Matrix 1 2 String
    > b = matrix $ Only ("Hello","World")
    >
    > c :: Matrix 4 5 Double
    > c = matrix ((1,2,3,0,0)
    >            ,(4,5,6,0,0)
    >            ,(7,8,9,0,0)
    >            ,(0,0,0,0,0))
    The full code is in test\/Docs.hs

    This only supports literals of length up to 20, though that can be easily extended using the code generator in src\/Data\/IndexedListLiterals.hs

category:             Data
abi:                  0ab00e98a9271a0cc5038fbcb7e74df5
exposed:              True
exposed-modules:      Data.IndexedListLiterals
import-dirs:          /usr/lib/ghc-9.6.6/site-local/indexed-list-literals-0.2.1.3
library-dirs:         /usr/lib/ghc-9.6.6/site-local/indexed-list-literals-0.2.1.3
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/indexed-list-literals-0.2.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-indexed-list-literals
hs-libraries:         HSindexed-list-literals-0.2.1.3-hUa7YDtlcMJ0HP4wcjgq3
depends:              Only-0.1-DItEcvi68ww8z5TVixWVcj base-4.18.2.1
haddock-interfaces:
    /usr/share/doc/haskell-indexed-list-literals/html/indexed-list-literals.haddock

haddock-html:         /usr/share/doc/haskell-indexed-list-literals/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

