#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lattices
version:              2.2.1
visibility:           public
id:                   lattices-2.2.1-FcZyCvRPwOJ7u0nl3WzYfr
key:                  lattices-2.2.1-FcZyCvRPwOJ7u0nl3WzYfr
license:              BSD-3-Clause
copyright:
    (C) 2010-2015 Maximilian Bolingbroke, 2016-2019 Oleg Grenrus

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Maximilian Bolingbroke <batterseapower@hotmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             http://github.com/phadej/lattices/
synopsis:
    Fine-grained library for constructing and manipulating lattices

description:
    In mathematics, a lattice is a partially ordered set in which every two
    elements @x@ and @y@ have a unique supremum (also called a least upper bound, join, or @x /\\ y@)
    and a unique infimum (also called a greatest lower bound, meet, or @x \\/ y@).

    This package provide type-classes for different lattice types, as well
    as a class for the partial order.

category:             Math
abi:                  f35391746996e83e37c9cfbb2df92419
exposed:              True
exposed-modules:
    Algebra.Heyting Algebra.Heyting.Free Algebra.Heyting.Free.Expr
    Algebra.Lattice Algebra.Lattice.Divisibility
    Algebra.Lattice.Dropped Algebra.Lattice.Free
    Algebra.Lattice.Free.Final Algebra.Lattice.Levitated
    Algebra.Lattice.Lexicographic Algebra.Lattice.Lifted
    Algebra.Lattice.M2 Algebra.Lattice.M3 Algebra.Lattice.N5
    Algebra.Lattice.Op Algebra.Lattice.Ordered Algebra.Lattice.Unicode
    Algebra.Lattice.Wide Algebra.Lattice.ZeroHalfOne Algebra.PartialOrd
    Algebra.PartialOrd.Instances

import-dirs:          /usr/lib/ghc-9.6.6/site-local/lattices-2.2.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/lattices-2.2.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/lattices-2.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lattices
hs-libraries:         HSlattices-2.2.1-FcZyCvRPwOJ7u0nl3WzYfr
depends:
    QuickCheck-2.15.0.1-7BzLIlrrsyUAWv4ugiuXtJ base-4.18.2.1
    containers-0.6.7 deepseq-1.4.8.1
    hashable-1.4.7.0-LSmBhr9Bt59DsIlhOBFmCL
    integer-logarithms-1.0.4-8Ben0DpeHg77Ru0gDOUMAj
    tagged-0.8.9-2fCpivRH6QIGdlOWfdc5ig transformers-0.6.1.0
    universe-base-1.1.4-5L0bnD3IP7926cXT83DyGY
    universe-reverse-instances-1.1.2-AHnOPET1O4H6lj0JC0Eme8
    unordered-containers-0.2.20.1-1hrud2F05KV7Rz7RsKTZ5O

haddock-interfaces:   /usr/share/doc/haskell-lattices/html/lattices.haddock
haddock-html:         /usr/share/doc/haskell-lattices/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

