#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp-test
version:              0.16.0.0
visibility:           public
id:                   lsp-test-0.16.0.0-3Fu8ftRNO55InjK8uQpKjB
key:                  lsp-test-0.16.0.0-3Fu8ftRNO55InjK8uQpKjB
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  fc4ca4ae0fe9be03370662e0de765984
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.1-8aQ8dKOwDVmFxT1S1WvW6m:Control.Applicative.Combinators,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.2.0-K9OndWmpckOBcJ8ZS2591j:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Message from lsp-types-2.0.2.0-K9OndWmpckOBcJ8ZS2591j:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.2.0-K9OndWmpckOBcJ8ZS2591j:Language.LSP.Protocol.Types,
    Language.LSP.Test

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.6.6/site-local/lsp-test-0.16.0.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/lsp-test-0.16.0.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/lsp-test-0.16.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test
hs-libraries:         HSlsp-test-0.16.0.0-3Fu8ftRNO55InjK8uQpKjB
depends:
    Diff-0.5-LvDn2Q3VCdHFITtPH7S2dt Glob-0.10.2-FFUARUINQX9K4f2r91vRK8
    aeson-2.2.0.0-Hqy1Zqe0ZE81dk2L20icmH
    aeson-pretty-0.8.10-eT1JM8BphwIKZ7kNgAtSZ
    ansi-terminal-1.1-IMcNZ5h2aza3c3hvu2tQms
    async-2.2.5-BOONqED6PxbDsY8XxcvMc4 base-4.18.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-E4gc6H4PEp9IHp9m40mldi
    conduit-1.3.6.1-CwUx671uWmDAcHwxI0YYDy
    conduit-parse-0.2.1.1-HXjGdWuWiZZL47qR99moUZ containers-0.6.7
    data-default-0.7.1.3-Ihbp7WFUy146w4K1utdfXl directory-1.3.8.5
    exceptions-0.10.7 filepath-1.4.300.1
    lens-5.3.3-KFcjpRU85K93uhgNXhcmM2
    lens-aeson-1.2.3-IGOeyaYbe2MKgOFlXw7TlQ
    lsp-2.2.0.0-8xJnLrvCaqxFP1VN2WNi9Q
    lsp-types-2.0.2.0-K9OndWmpckOBcJ8ZS2591j mtl-2.3.1
    parser-combinators-1.3.1-8aQ8dKOwDVmFxT1S1WvW6m process-1.6.19.0
    row-types-1.0.1.2-G7SBy9BaO17HsNcCjxHTSG
    some-1.0.6-APNUyWBz8dU4KJ0cJBNGqi text-2.0.2 time-1.12.2
    transformers-0.6.1.0 unix-2.8.4.0

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

