#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-pandoc-z-xml-light
version:              3.5
package-name:         pandoc
lib-name:             xml-light
id:                   pandoc-3.5-9i311jbXKhvBSwM4oIpRiJ-xml-light
key:                  pandoc-3.5-9i311jbXKhvBSwM4oIpRiJ-xml-light
license:              GPL-2.0-or-later
copyright:            (c) 2006-2024 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  2af21c9104cbc4f7794cabd660c17cc6
exposed-modules:
    Text.Pandoc.XML.Light Text.Pandoc.XML.Light.Output
    Text.Pandoc.XML.Light.Proc Text.Pandoc.XML.Light.Types

import-dirs:          /usr/lib/ghc-9.6.6/site-local/pandoc-3.5
library-dirs:         /usr/lib/ghc-9.6.6/site-local/pandoc-3.5
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/pandoc-3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.5-9i311jbXKhvBSwM4oIpRiJ-xml-light
depends:
    base-4.18.2.1 containers-0.6.7 text-2.0.2
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    xml-conduit-1.9.1.4-6YUKnRkiQ5NBAoTmcKCArn
    xml-types-0.3.8-ISf6rjkeTjSFXsXdIGBwau

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pandoc
version:              3.5
visibility:           public
id:                   pandoc-3.5-5SF7KFwug7mFO7qlpyjx0e
key:                  pandoc-3.5-5SF7KFwug7mFO7qlpyjx0e
license:              GPL-2.0-or-later
copyright:            (c) 2006-2024 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  b2339ea6212fdaefd96da9d0a541ec25
exposed:              True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.Chunks
    Text.Pandoc.Citeproc Text.Pandoc.Class Text.Pandoc.Class.IO
    Text.Pandoc.Data Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Filter Text.Pandoc.Format
    Text.Pandoc.Highlighting Text.Pandoc.ImageSize Text.Pandoc.Logging
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Process
    Text.Pandoc.Readers Text.Pandoc.Readers.BibTeX
    Text.Pandoc.Readers.CSV Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.Creole Text.Pandoc.Readers.CslJson
    Text.Pandoc.Readers.Djot Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.Docx Text.Pandoc.Readers.DokuWiki
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.EndNote
    Text.Pandoc.Readers.FB2 Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.Ipynb
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.Jira
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.Man
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.ODT Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RIS
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.RTF
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Typst Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.Scripting Text.Pandoc.SelfContained Text.Pandoc.Shared
    Text.Pandoc.Slides Text.Pandoc.Sources Text.Pandoc.Templates
    Text.Pandoc.Transforms Text.Pandoc.Translations
    Text.Pandoc.Translations.Types Text.Pandoc.UTF8 Text.Pandoc.Version
    Text.Pandoc.Writers Text.Pandoc.Writers.ANSI
    Text.Pandoc.Writers.AnnotatedTable Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.BibTeX Text.Pandoc.Writers.ChunkedHTML
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.CslJson Text.Pandoc.Writers.Djot
    Text.Pandoc.Writers.DocBook Text.Pandoc.Writers.Docx
    Text.Pandoc.Writers.DokuWiki Text.Pandoc.Writers.EPUB
    Text.Pandoc.Writers.FB2 Text.Pandoc.Writers.HTML
    Text.Pandoc.Writers.Haddock Text.Pandoc.Writers.ICML
    Text.Pandoc.Writers.Ipynb Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.Jira Text.Pandoc.Writers.LaTeX
    Text.Pandoc.Writers.Man Text.Pandoc.Writers.Markdown
    Text.Pandoc.Writers.Math Text.Pandoc.Writers.MediaWiki
    Text.Pandoc.Writers.Ms Text.Pandoc.Writers.Muse
    Text.Pandoc.Writers.Native Text.Pandoc.Writers.ODT
    Text.Pandoc.Writers.OOXML Text.Pandoc.Writers.OPML
    Text.Pandoc.Writers.OpenDocument Text.Pandoc.Writers.Org
    Text.Pandoc.Writers.Powerpoint Text.Pandoc.Writers.RST
    Text.Pandoc.Writers.RTF Text.Pandoc.Writers.Shared
    Text.Pandoc.Writers.TEI Text.Pandoc.Writers.Texinfo
    Text.Pandoc.Writers.Textile Text.Pandoc.Writers.Typst
    Text.Pandoc.Writers.XWiki Text.Pandoc.Writers.ZimWiki
    Text.Pandoc.XML

hidden-modules:
    Text.Pandoc.App.CommandLineOptions Text.Pandoc.App.Input
    Text.Pandoc.App.Opt Text.Pandoc.App.OutputSettings
    Text.Pandoc.Class.CommonState Text.Pandoc.Class.PandocMonad
    Text.Pandoc.Class.PandocIO Text.Pandoc.Class.PandocPure
    Text.Pandoc.Class.Sandbox Text.Pandoc.Filter.Environment
    Text.Pandoc.Filter.JSON Text.Pandoc.Parsing.Capabilities
    Text.Pandoc.Parsing.Citations Text.Pandoc.Parsing.General
    Text.Pandoc.Parsing.GridTable Text.Pandoc.Parsing.Lists
    Text.Pandoc.Parsing.Math Text.Pandoc.Parsing.Smart
    Text.Pandoc.Parsing.State Text.Pandoc.Parsing.Future
    Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
    Text.Pandoc.Readers.Docx.Parse
    Text.Pandoc.Readers.Docx.Parse.Styles Text.Pandoc.Readers.Docx.Util
    Text.Pandoc.Readers.Docx.Symbols Text.Pandoc.Readers.Docx.Fields
    Text.Pandoc.Readers.HTML.Parsing Text.Pandoc.Readers.HTML.Table
    Text.Pandoc.Readers.HTML.TagCategories
    Text.Pandoc.Readers.HTML.Types Text.Pandoc.Readers.LaTeX.Inline
    Text.Pandoc.Readers.LaTeX.Citation Text.Pandoc.Readers.LaTeX.Lang
    Text.Pandoc.Readers.LaTeX.Macro Text.Pandoc.Readers.LaTeX.Math
    Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.LaTeX.SIunitx
    Text.Pandoc.Readers.LaTeX.Table Text.Pandoc.Readers.Typst.Parsing
    Text.Pandoc.Readers.Typst.Math Text.Pandoc.Readers.ODT.Base
    Text.Pandoc.Readers.ODT.Namespaces
    Text.Pandoc.Readers.ODT.StyleReader
    Text.Pandoc.Readers.ODT.ContentReader
    Text.Pandoc.Readers.ODT.Generic.Fallible
    Text.Pandoc.Readers.ODT.Generic.SetMap
    Text.Pandoc.Readers.ODT.Generic.Utils
    Text.Pandoc.Readers.ODT.Generic.Namespaces
    Text.Pandoc.Readers.ODT.Generic.XMLConverter
    Text.Pandoc.Readers.ODT.Arrows.State
    Text.Pandoc.Readers.ODT.Arrows.Utils
    Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
    Text.Pandoc.Readers.Org.DocumentTree
    Text.Pandoc.Readers.Org.ExportSettings
    Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
    Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
    Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Metadata
    Text.Pandoc.Readers.Roff Text.Pandoc.Writers.Docx.OpenXML
    Text.Pandoc.Writers.Docx.StyleMap Text.Pandoc.Writers.Docx.Table
    Text.Pandoc.Writers.Docx.Types Text.Pandoc.Writers.GridTable
    Text.Pandoc.Writers.JATS.References Text.Pandoc.Writers.JATS.Table
    Text.Pandoc.Writers.JATS.Types Text.Pandoc.Writers.LaTeX.Caption
    Text.Pandoc.Writers.LaTeX.Notes Text.Pandoc.Writers.LaTeX.Table
    Text.Pandoc.Writers.LaTeX.Lang Text.Pandoc.Writers.LaTeX.Types
    Text.Pandoc.Writers.LaTeX.Citation Text.Pandoc.Writers.LaTeX.Util
    Text.Pandoc.Writers.Markdown.Table
    Text.Pandoc.Writers.Markdown.Types
    Text.Pandoc.Writers.Markdown.Inline Text.Pandoc.Writers.Roff
    Text.Pandoc.Writers.Blaze
    Text.Pandoc.Writers.Powerpoint.Presentation
    Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Char
    Text.Pandoc.TeX Text.Pandoc.URI Text.Pandoc.CSS Text.Pandoc.CSV
    Text.Pandoc.RoffChar Text.Pandoc.UUID Text.Pandoc.Image
    Text.Pandoc.Citeproc.BibTeX Text.Pandoc.Citeproc.Name
    Text.Pandoc.Citeproc.CslJson Text.Pandoc.Citeproc.Data
    Text.Pandoc.Citeproc.Locator Text.Pandoc.Citeproc.MetaValue
    Text.Pandoc.Citeproc.Util Paths_pandoc

import-dirs:          /usr/lib/ghc-9.6.6/site-local/pandoc-3.5
library-dirs:         /usr/lib/ghc-9.6.6/site-local/pandoc-3.5
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/pandoc-3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.5-5SF7KFwug7mFO7qlpyjx0e
depends:
    Glob-0.10.2-FFUARUINQX9K4f2r91vRK8
    JuicyPixels-3.3.9-GISM4Yt9dk2EbAfOdiZKVk
    aeson-2.2.0.0-Hqy1Zqe0ZE81dk2L20icmH
    aeson-pretty-0.8.10-eT1JM8BphwIKZ7kNgAtSZ array-0.5.6.0
    attoparsec-0.14.4-8hLS1m777hPFjiaInp95BL base-4.18.2.1
    base64-bytestring-1.2.1.0-LrCtfbXf96jILPXKH7KAXZ binary-0.8.9.1
    blaze-html-0.9.2.0-AqjQr4Ps51QD51ybemU3ZY
    blaze-markup-0.8.3.0-K7wUMOM5SyIFeEdepQMdjc bytestring-0.11.5.3
    case-insensitive-1.2.1.0-8PStX6cixKCLkUJoPuARL
    citeproc-0.8.1.1-DisSnEiBI6mEK5rOO8Jfdl
    commonmark-0.2.6.1-LSg85G5A71G6Q2ztLpSg1b
    commonmark-extensions-0.2.5.6-HkVxUzqZVWj8D1wI5s2rG0
    commonmark-pandoc-0.2.2.3-1zeVUnp7Ki25OQe4DnJ5qz containers-0.6.7
    crypton-1.0.4-37TsNQoV8Vb5042LlXS4MC
    crypton-connection-0.4.5-DTz7yZVBJnuCgw6I1Owenb
    crypton-x509-system-1.6.7-2Kdke0WqqG48j3LOWpMUjq
    data-default-0.7.1.3-Ihbp7WFUy146w4K1utdfXl deepseq-1.4.8.1
    directory-1.3.8.5 djot-0.1.2.3-KO7B1U81cdZ1SoFhctNpVE
    doclayout-0.5-41hL3oGVC8JBKrRw4BZMrm
    doctemplates-0.11.0.1-HvoxNiGSiQEAkgF4uIK5Hl
    emojis-0.1.4.1-L7mOnPsQOMB2xPGhke4egp exceptions-0.10.7
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    gridtables-0.1.1.0-Ke65Z4JT8gVF24x6S1GYIl
    haddock-library-1.11.0-DYHgLB2m8Dy427pk0WSXWJ
    http-client-0.7.19-HYRPxJ1velFCbteX9ut4f6
    http-client-tls-0.3.6.4-ILttD7UGaFL2zbr7B8I43g
    http-types-0.12.4-2YF0olXF9itCctWavExzmH
    ipynb-0.2-L7XKY7VF6asHpGgNOGo9IK
    jira-wiki-markup-1.5.1-21uMQQeHEje6CH8sSLe0tx
    mime-types-0.1.2.0-2lnuHjhOzQ4DFNhuFJ9ART mtl-2.3.1
    network-3.1.4.0-xB4epdb1XO3ZKzAxljM4X
    network-uri-2.6.4.2-1aRZPUfkmMD8JwUJF5GqMA
    pandoc-3.5-9i311jbXKhvBSwM4oIpRiJ-xml-light
    pandoc-types-1.23.1-CJH803wvmoH5NkoCOHPWhx parsec-3.1.16.1
    pretty-1.1.3.6 pretty-show-1.10-EXsS4VwIV5tJ56gbmVdfrR
    process-1.6.19.0 random-1.2.1.3-6l1YOhgkyj83HD6td8a68Q
    safe-0.3.21-KkG5O6k2axl5FoNYEbOYS8
    scientific-0.3.8.0-E8K90IhCZpR98POp8HwlML
    skylighting-0.14.3-AFjprEBMEWgB4aVqA4d61N
    skylighting-core-0.14.3-6ZvJN2No0Oj3j9qCnjgXmz
    split-0.2.5-8jaYNHp3QVW6mrtuSFwro6 syb-0.7.3-GhxEKVO9aRZHddME5iK0hL
    tagsoup-0.14.8-4K1YWE9FoiC3G64iorq40t
    temporary-1.3-GTgxkhi2PMM37jgbXakJ3s
    texmath-0.12.8.11-4PmgsZ3olBC4ZVcmta7gkJ text-2.0.2
    text-conversions-0.3.1.1-6DZCNMO9sKqCKg7SEIDt6f time-1.12.2
    tls-2.0.6-JDpPGrffkyAB1IreS7llis typst-0.6-9OBtECweB3AGy31FvCFNSG
    unicode-collation-0.1.3.6-5OOuBDlpdzYHB17Nl2ilP6
    unicode-transforms-0.4.0.1-5ZQlt781Pd6Lx82F3jfMR unix-2.8.4.0
    vector-0.13.2.0-DULMVARQ1CU3TLBOg9xkS6
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    yaml-0.11.11.2-7sI7sa5XZN9728orpxXF0B
    zip-archive-0.4.3.2-3OlgacNpbfo3qkGuC5EwFI
    zlib-0.7.0.0-KycIpdUZG34Fi5Aj6BOrFq

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

