#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pandoc-lua-marshal
version:              0.2.9
visibility:           public
id:                   pandoc-lua-marshal-0.2.9-GJdxVc4mzOA5xGZtJhRvZb
key:                  pandoc-lua-marshal-0.2.9-GJdxVc4mzOA5xGZtJhRvZb
license:              MIT
copyright:            © 2017-2024 Albert Krewinkel, John MacFarlane
maintainer:           Albert Krewinkel <albert@zeitkraut.de>
author:               Albert Krewinkel, John MacFarlane
homepage:             https://github.com/pandoc/pandoc-lua-marshal
synopsis:             Use pandoc types in Lua
description:
    This package provides functions to marshal and unmarshal
    pandoc document types to and from Lua.

    The values of most types are pushed to pandoc as "userdata"
    objects that wrap a stable pointer to the Haskell value;
    these objects come with methods to access and modify their
    properties.

    Sequences are pushed as normal Lua tables, but are
    augmented with convenience functions.

category:             Foreign
abi:                  f8000f6c707d2debe3d4b52832176f18
exposed:              True
exposed-modules:
    Text.Pandoc.Lua.Marshal.AST Text.Pandoc.Lua.Marshal.Alignment
    Text.Pandoc.Lua.Marshal.Attr Text.Pandoc.Lua.Marshal.Block
    Text.Pandoc.Lua.Marshal.Cell Text.Pandoc.Lua.Marshal.Citation
    Text.Pandoc.Lua.Marshal.CitationMode
    Text.Pandoc.Lua.Marshal.Content Text.Pandoc.Lua.Marshal.Filter
    Text.Pandoc.Lua.Marshal.Format Text.Pandoc.Lua.Marshal.Inline
    Text.Pandoc.Lua.Marshal.List Text.Pandoc.Lua.Marshal.ListAttributes
    Text.Pandoc.Lua.Marshal.MathType Text.Pandoc.Lua.Marshal.MetaValue
    Text.Pandoc.Lua.Marshal.Pandoc Text.Pandoc.Lua.Marshal.QuoteType
    Text.Pandoc.Lua.Marshal.Row Text.Pandoc.Lua.Marshal.SimpleTable
    Text.Pandoc.Lua.Marshal.TableFoot Text.Pandoc.Lua.Marshal.TableHead
    Text.Pandoc.Lua.Marshal.TableParts

hidden-modules:
    Text.Pandoc.Lua.Marshal.Shared Text.Pandoc.Lua.Topdown
    Text.Pandoc.Lua.SpliceList Text.Pandoc.Lua.Walk

import-dirs:          /usr/lib/ghc-9.6.6/site-local/pandoc-lua-marshal-0.2.9
library-dirs:         /usr/lib/ghc-9.6.6/site-local/pandoc-lua-marshal-0.2.9
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/pandoc-lua-marshal-0.2.9
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc-lua-marshal
hs-libraries:         HSpandoc-lua-marshal-0.2.9-GJdxVc4mzOA5xGZtJhRvZb
depends:
    aeson-2.1.2.1-GojnAvr1Jep10WUNi5H1Pi base-4.18.2.1
    bytestring-0.11.5.3 containers-0.6.7 exceptions-0.10.7
    hslua-2.3.0-AIYoFrxEfNp4l0Epo8ciVq
    hslua-list-1.1.4-8z81DILtRHw6GXhp4f5B7Y
    hslua-marshalling-2.3.1-2wvb5zI3Ais62iyLUWMiUH
    pandoc-types-1.23.1-84C04huNeQE19kRVi0p0kr
    safe-0.3.21-6ywRAlXnRFuBscoqJeUz3o text-2.0.2

haddock-interfaces:
    /usr/share/doc/haskell-pandoc-lua-marshal/html/pandoc-lua-marshal.haddock

haddock-html:         /usr/share/doc/haskell-pandoc-lua-marshal/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

