#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 semialign
version:              1.3.1
visibility:           public
id:                   semialign-1.3.1-DoVdMtq8mk6Ls5lMHwS9fd
key:                  semialign-1.3.1-DoVdMtq8mk6Ls5lMHwS9fd
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  00599b6282f719b1b4a39c31382e5e05
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.6.6/site-local/semialign-1.3.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/semialign-1.3.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/semialign-1.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.3.1-DoVdMtq8mk6Ls5lMHwS9fd
depends:
    base-4.18.2.1 containers-0.6.7
    hashable-1.4.7.0-LSmBhr9Bt59DsIlhOBFmCL
    indexed-traversable-0.1.4-8j5HZpShpE5BqFup9Ojenr
    indexed-traversable-instances-0.1.2-374J1rYhHw0Kpx61mHJVEj
    semigroupoids-6.0.1-B2NUsmSrfw0IdKSQnEwzO0
    tagged-0.8.9-2fCpivRH6QIGdlOWfdc5ig
    these-1.2.1-7cZGVd7UTfy2HKT7yUNRZL transformers-0.6.1.0
    unordered-containers-0.2.20.1-1hrud2F05KV7Rz7RsKTZ5O
    vector-0.13.2.0-DULMVARQ1CU3TLBOg9xkS6

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

