#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 servant-swagger
version:              1.2.1
visibility:           public
id:                   servant-swagger-1.2.1-AI1hHaunaJX5uF2QvLugk6
key:                  servant-swagger-1.2.1-AI1hHaunaJX5uF2QvLugk6
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           haskell-servant-maintainers@googlegroups.com
author:               Servant Contributors
homepage:
    https://github.com/haskell-servant/servant/tree/master/servant-swagger#readme

synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  e9d3f43f3109bce9d99116d5b4929a4f
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.6.6/site-local/servant-swagger-1.2.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/servant-swagger-1.2.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/servant-swagger-1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-servant-swagger
hs-libraries:         HSservant-swagger-1.2.1-AI1hHaunaJX5uF2QvLugk6
depends:
    QuickCheck-2.15.0.1-1xFq7rzYyJMIIsLto0YgsS
    aeson-2.1.2.1-CpIoOLI7lIpJkSqSOmDN9y
    aeson-pretty-0.8.10-BjxB783FV8e8YPhrNbMs4J base-4.18.2.1
    base-compat-0.14.1-4heBy5B59ewBpEOwRrJlc4 bytestring-0.11.5.3
    hspec-2.11.4-8QgnQwrEho14jh62SRkWei
    http-media-0.8.1.1-ESBCw4Dvl5R7GQFVDBq0Rc
    insert-ordered-containers-0.2.5.3-F3ZWofUloJ3FcOrvJbOGyb
    lens-5.3.3-GI3kNGpcyiIBMdla72MFoB
    servant-0.20.3.0-EGizVGIAZ794yRWvR5V6rz
    singleton-bool-0.1.8-FBR3WTqmpe756ZKoVuyK7L
    swagger2-2.8.10-9b9lcZWIuur8JMkaDITY9o text-2.0.2
    unordered-containers-0.2.20.1-L0jiELAFLwP1g4FZscm3B5

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

