#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 snap-core
version:              1.0.5.1
visibility:           public
id:                   snap-core-1.0.5.1-EcEyF8Xhnwt7tybZaiLfoJ
key:                  snap-core-1.0.5.1-EcEyF8Xhnwt7tybZaiLfoJ
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             Snap: A Haskell Web Framework (core interfaces and types)
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    This library contains the core definitions and types for the Snap framework,
    including:

    1. Primitive types and functions for HTTP (requests, responses, cookies,
    post/query parameters, etc)

    2. A monad for programming web handlers called \"Snap\", which allows:

    * Stateful access to the HTTP request and response objects

    * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
    to handle requests and chaining handlers together

    * Early termination of the computation if you know early what you want
    to return and want to prevent further monadic processing

    /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core".

category:             Web, Snap, IO-Streams
abi:                  ea4f66384d6d2431257a6cea28d52831
exposed:              True
exposed-modules:
    Snap.Core Snap.Internal.Core Snap.Internal.Debug
    Snap.Internal.Http.Types Snap.Internal.Parsing
    Snap.Internal.Util.FileServe Snap.Test Snap.Types.Headers
    Snap.Util.CORS Snap.Util.FileServe Snap.Util.FileUploads
    Snap.Util.GZip Snap.Util.Proxy

hidden-modules:
    Snap.Internal.Instances Snap.Internal.Routing
    Snap.Internal.Test.RequestBuilder Snap.Internal.Test.Assertions
    Snap.Internal.Util.FileUploads

import-dirs:          /usr/lib/ghc-9.6.6/site-local/snap-core-1.0.5.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/snap-core-1.0.5.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/snap-core-1.0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-snap-core
hs-libraries:         HSsnap-core-1.0.5.1-EcEyF8Xhnwt7tybZaiLfoJ
depends:
    HUnit-1.6.2.0-IE0oFrOTEOHIkscEaBk8om
    attoparsec-0.14.4-8gkbEkDkw506qTMOo0v2nm base-4.18.2.1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-3fPl2hvou1nDiCO1iE2i5z
    containers-0.6.7 directory-1.3.8.5 filepath-1.4.300.1
    hashable-1.4.7.0-DKTv0aQgcZmBEMi2BPTV4Z
    io-streams-1.5.2.2-GBIxq3Y3ahG4K7ipZI07Kf
    lifted-base-0.2.3.12-Hi5wZUtfsE6DzwMEBNTci6
    monad-control-1.0.3.1-JNSSe1yK184K4km57LK5G2 mtl-2.3.1
    network-3.1.4.0-8n0F06kM1hW6KWRJNaBKOe
    network-uri-2.6.4.2-69jfmnohyG88ZQKNy7a5sS
    old-locale-1.0.0.7-Gunit3UBy5P9OGDVFY5MhC
    random-1.2.1.3-6SxnlPLCqt06GlpnYLfwZm
    readable-0.3.1-OTyE2OgXqD6GxjciePDxk
    regex-posix-0.96.0.2-LsCmj8tXKerCmkZ6TKO5qF text-2.0.2 time-1.12.2
    transformers-0.6.1.0 transformers-base-0.4.6-IFFPlbMue7bJmNu16qahDQ
    unix-compat-0.7.4.1-FrCbkIkHqC8LnfXFaiVUhh
    unordered-containers-0.2.20.1-50qrTxmoJy9AxZ7OdMnycu
    vector-0.13.2.0-L5lYsWFgdBEAgjlr9nnpMP

haddock-interfaces:   /usr/share/doc/haskell-snap-core/html/snap-core.haddock
haddock-html:         /usr/share/doc/haskell-snap-core/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

