#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-sapic
version:              1.10.0
visibility:           public
id:                   tamarin-prover-sapic-1.10.0-HJRVcOLrrMzIWKPgyUbp2T
key:                  tamarin-prover-sapic-1.10.0-HJRVcOLrrMzIWKPgyUbp2T
license:              LicenseRef-GPL
copyright:
    Robert Künnemann, Alexander Dax, CISPA-Helmholtz-Centre Saarbrücken, 2019

maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Alexander Dax <alexander.dax@cispa.saarland>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Library for input processes in SAPIC calculus for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides a translation from processes stated in the SAPIC calculus into multiset rewrite rules.

category:             Theorem Provers
abi:                  863239eb081c02b375c4073cb1f0813d
exposed:              True
exposed-modules:
    Sapic Sapic.Annotation Sapic.Basetranslation Sapic.Bindings
    Sapic.Compression Sapic.Exceptions Sapic.Facts Sapic.LetDestructors
    Sapic.Locks Sapic.ProcessUtils Sapic.ProgressFunction
    Sapic.ProgressTranslation Sapic.ReliableChannelTranslation
    Sapic.Report Sapic.SecretChannels Sapic.States Sapic.Typing
    Sapic.Warnings

import-dirs:          /usr/lib/ghc-9.6.6/site-local/tamarin-prover-sapic-1.10.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/tamarin-prover-sapic-1.10.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/tamarin-prover-sapic-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-sapic
hs-libraries:         HStamarin-prover-sapic-1.10.0-HJRVcOLrrMzIWKPgyUbp2T
depends:
    aeson-2.2.0.0-Hqy1Zqe0ZE81dk2L20icmH
    aeson-pretty-0.8.10-eT1JM8BphwIKZ7kNgAtSZ base-4.18.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.1
    dlist-1.0-D18k2majPPWIDTEXbjYF0E exceptions-0.10.7
    fclabels-2.0.5.1-FjiFhZPCJ4d7WCE5Hbs1ET mtl-2.3.1
    parallel-3.2.2.0-4GFGhbl8Ae06nPoqdIyBUD parsec-3.1.16.1
    process-1.6.19.0 raw-strings-qq-1.1-HgsCJbBD5QVLggpDhmUWHl
    safe-0.3.21-KkG5O6k2axl5FoNYEbOYS8
    tamarin-prover-term-1.10.0-DyDW1t62HaM9yQKIJp9NWQ
    tamarin-prover-theory-1.10.0-FISZ0yFoQbtJZJfLjJW8pz
    tamarin-prover-utils-1.10.0-Gv3ExdQ60EpBb0I0m1wL8M text-2.0.2
    transformers-0.6.1.0 uniplate-1.6.13-6cQFcK4O53s462e3dy0IK1

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-sapic/html/tamarin-prover-sapic.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-sapic/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

