#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-utils
version:              1.10.0
visibility:           public
id:                   tamarin-prover-utils-1.10.0-Gv3ExdQ60EpBb0I0m1wL8M
key:                  tamarin-prover-utils-1.10.0-Gv3ExdQ60EpBb0I0m1wL8M
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Cas Cremers <cremers@cispa.de>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Utility library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

category:             Theorem Provers
abi:                  b84a43e64443297083e7da3a34df79c0
exposed:              True
exposed-modules:
    Control.Basics Control.Monad.Bind Control.Monad.Disj
    Control.Monad.Fresh Control.Monad.Trans.FastFresh
    Control.Monad.Trans.PreciseFresh Data.Color Data.DAG.Simple
    Debug.Trace.EnvTracer Debug.Trace.Ignore Extension.Data.ByteString
    Extension.Data.Label Extension.Data.Monoid Extension.Prelude
    Logic.Connectives System.Timing Text.Dot Text.PrettyPrint.Class
    Text.PrettyPrint.Highlight Text.PrettyPrint.Html Text.Unicode
    Utils.Misc

hidden-modules:
    Control.Monad.Fresh.Class Control.Monad.Trans.Disj
    Control.Monad.Disj.Class

import-dirs:          /usr/lib/ghc-9.6.6/site-local/tamarin-prover-utils-1.10.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/tamarin-prover-utils-1.10.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/tamarin-prover-utils-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-utils
hs-libraries:         HStamarin-prover-utils-1.10.0-Gv3ExdQ60EpBb0I0m1wL8M
depends:
    SHA-1.6.4.4-KRZJCS52poaHfqPlW5b8Sg base-4.18.2.1
    base64-bytestring-1.2.1.0-LrCtfbXf96jILPXKH7KAXZ binary-0.8.9.1
    blaze-builder-0.4.4.1-Hto81bisFYkHXSmpZG8kx7 bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.1 dlist-1.0-D18k2majPPWIDTEXbjYF0E
    exceptions-0.10.7 fclabels-2.0.5.1-FjiFhZPCJ4d7WCE5Hbs1ET
    graphviz-2999.20.2.1-Jg8BpNJ429GLNyO963AqMO
    list-t-1.0.5.7-KNkAQwr885vDpbJMkmq1cM mtl-2.3.1 pretty-1.1.3.6
    safe-0.3.21-KkG5O6k2axl5FoNYEbOYS8
    split-0.2.5-8jaYNHp3QVW6mrtuSFwro6 syb-0.7.3-GhxEKVO9aRZHddME5iK0hL
    text-2.0.2 time-1.12.2 transformers-0.6.1.0

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-utils/html/tamarin-prover-utils.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-utils/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

