#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 vector-builder
version:              0.3.8.6
visibility:           public
id:                   vector-builder-0.3.8.6-32So85AZwydG0DnwgNZuJF
key:                  vector-builder-0.3.8.6-32So85AZwydG0DnwgNZuJF
license:              MIT
copyright:            (c) 2016, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/vector-builder
synopsis:             Vector builder
description:
    An API for efficient and convenient construction of vectors.
    It provides the composable `Builder` abstraction, which has instances of the `Monoid` and `Semigroup` classes.

    [Usage]

    First you use the `Builder` abstraction to specify the structure of the vector.
    Then you execute the builder to actually produce the vector.

    [Example]

    The following code shows how you can efficiently concatenate different datastructures into a single immutable vector:

    >
    >import qualified Data.Vector as A
    >import qualified VectorBuilder.Builder as B
    >import qualified VectorBuilder.Vector as C
    >
    >
    >myVector :: A.Vector a -> [a] -> a -> A.Vector a
    >myVector vector list element =
    >  C.build builder
    >  where
    >    builder =
    >      B.vector vector <>
    >      B.foldable list <>
    >      B.singleton element

category:             Vector
abi:                  76b2f212de1639dc0a4e02c79d7bb3ee
exposed:              True
exposed-modules:
    VectorBuilder.Alternative VectorBuilder.Builder
    VectorBuilder.MVector VectorBuilder.MonadPlus VectorBuilder.Vector

hidden-modules:
    VectorBuilder.Core.Builder VectorBuilder.Core.Update
    VectorBuilder.Prelude

import-dirs:          /usr/lib/ghc-9.6.6/site-local/vector-builder-0.3.8.6
library-dirs:         /usr/lib/ghc-9.6.6/site-local/vector-builder-0.3.8.6
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/vector-builder-0.3.8.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vector-builder
hs-libraries:         HSvector-builder-0.3.8.6-32So85AZwydG0DnwgNZuJF
depends:              base-4.18.2.1 vector-0.13.2.0-L5lYsWFgdBEAgjlr9nnpMP
haddock-interfaces:
    /usr/share/doc/haskell-vector-builder/html/vector-builder.haddock

haddock-html:         /usr/share/doc/haskell-vector-builder/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

