#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 vty
version:              5.39
visibility:           public
id:                   vty-5.39-HvtHXsdGpHNIMfH8NHPrYb
key:                  vty-5.39-HvtHXsdGpHNIMfH8NHPrYb
license:              BSD-3-Clause
maintainer:           Jonathan Daugherty (cygnus@foobox.com)
author:               AUTHORS
homepage:             https://github.com/jtdaugherty/vty
synopsis:             A simple terminal UI library
description:
    vty is terminal GUI library in the niche of ncurses. It is intended to
    be easy to use and to provide good support for common terminal types.

    See the @vty-examples@ package as well as the program
    @examples/interactive_terminal_test.hs@ included in the @vty@
    repository for examples on how to use the library.

    Import the @Graphics.Vty@ convenience module to get access to the core
    parts of the library.

    &#169; 2006-2007 Stefan O'\''Rear; BSD3 license.

    &#169; Corey O'\''Connor; BSD3 license.

    &#169; Jonathan Daugherty; BSD3 license.

category:             User Interfaces
abi:                  a23ef4d0608d85079277805536af174c
exposed:              True
exposed-modules:
    Data.Terminfo.Eval Data.Terminfo.Parse Graphics.Text.Width
    Graphics.Vty Graphics.Vty.Attributes Graphics.Vty.Attributes.Color
    Graphics.Vty.Attributes.Color240 Graphics.Vty.Config
    Graphics.Vty.Debug Graphics.Vty.DisplayAttributes
    Graphics.Vty.Error Graphics.Vty.Image Graphics.Vty.Image.Internal
    Graphics.Vty.Inline Graphics.Vty.Inline.Unsafe Graphics.Vty.Input
    Graphics.Vty.Input.Classify Graphics.Vty.Input.Classify.Parse
    Graphics.Vty.Input.Classify.Types Graphics.Vty.Input.Events
    Graphics.Vty.Input.Focus Graphics.Vty.Input.Loop
    Graphics.Vty.Input.Mouse Graphics.Vty.Input.Paste
    Graphics.Vty.Input.Terminfo Graphics.Vty.Output
    Graphics.Vty.Output.Interface Graphics.Vty.Output.Mock
    Graphics.Vty.Output.TerminfoBased Graphics.Vty.Output.XTermColor
    Graphics.Vty.Picture Graphics.Vty.PictureToSpans Graphics.Vty.Span
    Graphics.Vty.UnicodeWidthTable.IO
    Graphics.Vty.UnicodeWidthTable.Install
    Graphics.Vty.UnicodeWidthTable.Query
    Graphics.Vty.UnicodeWidthTable.Types

hidden-modules:       Graphics.Vty.Input.Terminfo.ANSIVT
import-dirs:          /usr/lib/ghc-9.6.6/site-local/vty-5.39
library-dirs:         /usr/lib/ghc-9.6.6/site-local/vty-5.39
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/vty-5.39
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vty5
hs-libraries:         HSvty-5.39-HvtHXsdGpHNIMfH8NHPrYb
depends:
    ansi-terminal-1.1-IMcNZ5h2aza3c3hvu2tQms base-4.18.2.1
    binary-0.8.9.1 blaze-builder-0.4.4.1-Hto81bisFYkHXSmpZG8kx7
    bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.1
    directory-1.3.8.5 filepath-1.4.300.1
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-mtl-0.2.1.0-Ewo8HmKpWhTASatFX3KZGS
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw mtl-2.3.1
    parsec-3.1.16.1 stm-2.5.1.0 terminfo-0.4.1.6 text-2.0.2
    transformers-0.6.1.0 unix-2.8.4.0
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    vector-0.13.2.0-DULMVARQ1CU3TLBOg9xkS6

haddock-interfaces:   /usr/share/doc/haskell-vty5/html/vty.haddock
haddock-html:         /usr/share/doc/haskell-vty5/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

