#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.51.1
visibility:           public
id:                   hledger-1.51.1-I51AfN4EY4P3Ji1R1h33rs
key:                  hledger-1.51.1-I51AfN4EY4P3Ji1R1h33rs
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  cdb9e46303b77cf4c6d6cb9058f5ccda
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Setup Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-1.51.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-1.51.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-1.51.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.51.1-I51AfN4EY4P3Ji1R1h33rs
depends:
    Decimal-0.5.2-1QLMM6hywMmG42YT7nD3xx
    Diff-0.5-8gj4s2z6jOl7FPRCGftIez
    aeson-2.1.2.1-CpIoOLI7lIpJkSqSOmDN9y
    ansi-terminal-1.0.2-8AlL5ra8Vsx5bOLC8RDvPh base-4.18.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    containers-0.6.7 data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz
    directory-1.3.8.5 extra-1.7.16-IkudFHstV64EKMSGT8IWWb
    filepath-1.4.300.1 githash-0.1.6.3-L5VTSr5LQebIEYHHLt617w
    hashable-1.4.7.0-1GSULm1uRgQBgX6mu6tvYD haskeline-0.8.2.1
    hledger-lib-1.51.1-HrRw4SAjiq35xNyP9b6ko5
    http-client-0.7.19-9XP2fRtq348Edv4XKGE8tD
    http-types-0.12.4-E9He9FXy4rKITKDtg1mhVt
    lucid-2.11.20250303-2DU0tzsivWAatyw5ZOVax
    math-functions-0.3.4.4-ISK9KPJw6XgFAhCTgWxhOZ
    megaparsec-9.7.0-CJUMznUvVaqA9LkZfHNyDE
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    modern-uri-0.3.6.1-Fr6OaKthQTjHVJ2Unps2DR mtl-2.3.1
    process-1.6.19.0 regex-tdfa-1.3.2.5-EWGvfiHhNcof6jXGuIJ2K
    req-3.13.4-JjEa1GVDefl9Wlg0cI4xYv
    safe-0.3.21-7oQO4KcgDWt1YhK3ifcAwa
    shakespeare-2.1.7-EQa3S9NEyAK816psNg58s0
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8
    tabular-0.2.2.8-Ly9fepE9sHFB2l1Bgv9bkV
    tasty-1.5.2-C3yI3pzTEHWEDVqwlNW4dB
    temporary-1.3-29RL4tTXoFB72QSCtJnhBC text-2.0.2
    text-ansi-0.3.0.1-KaLU9eplqCfLQaPnBFLU7v time-1.12.2
    timeit-2.0-DwmItJuhuSm6aktMh1S1ZM transformers-0.6.1.0
    unordered-containers-0.2.20.1-L0jiELAFLwP1g4FZscm3B5
    utf8-string-1.0.2-GrV0vD7epd2Fw38ZtPT1hv
    utility-ht-0.0.17.2-9ryTCp5DXpz5HmwvPaZxIP
    wizards-1.0.3-EMndOhiYuHdGTEqrX5mo0v

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

