#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-iadd
version:              1.3.22
visibility:           public
id:                   hledger-iadd-1.3.22-6QdTLJxAPkZBavq6fFpf6a
key:                  hledger-iadd-1.3.22-6QdTLJxAPkZBavq6fFpf6a
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  8836efb551e9147ed49274ffd2d9e234
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-iadd-1.3.22
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-iadd-1.3.22
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-iadd-1.3.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.22-6QdTLJxAPkZBavq6fFpf6a
depends:
    base-4.18.2.1 brick-2.5-1qsgILJuKNvEePmXl5tusR containers-0.6.7
    directory-1.3.8.5 free-5.2-CP2SAI6deNWCXG1eD5QmMc
    hledger-lib-1.51.1-HrRw4SAjiq35xNyP9b6ko5
    megaparsec-9.7.0-CJUMznUvVaqA9LkZfHNyDE
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-mtl-0.2.1.0-Ewo8HmKpWhTASatFX3KZGS
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw
    optparse-applicative-0.18.1.0-BnGHnrTdK6d4c7MmJxSY0G text-2.0.2
    text-zipper-0.13-6en0cnvMMd57tWWE0scrPW time-1.12.2
    transformers-0.6.1.0
    unordered-containers-0.2.20.1-L0jiELAFLwP1g4FZscm3B5
    vector-0.13.2.0-eGaPlIkScLKlfBYQuI3vH
    vty-6.2-6mvUoRDa0zgJSFHbiRIfKy
    xdg-basedir-0.2.2-DLaKUfv1JJAFBfkP0BUklH

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

