#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.51.1
visibility:           public
id:                   hledger-web-1.51.1-1IL2Wi7B7mO4C7EN3YZCUE
key:                  hledger-web-1.51.1-1IL2Wi7B7mO4C7EN3YZCUE
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  624e6205feffb0834e1ef62c897a6224
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.App Hledger.Web.Application
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Main Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Test
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common

hidden-modules:       Paths_hledger_web
import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-web-1.51.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-web-1.51.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-web-1.51.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.51.1-1IL2Wi7B7mO4C7EN3YZCUE
depends:
    Decimal-0.5.2-1QLMM6hywMmG42YT7nD3xx
    aeson-2.1.2.1-CpIoOLI7lIpJkSqSOmDN9y base-4.18.2.1
    base64-1.0-JLGAYoBYKh9AtfiRX9PRIQ
    blaze-html-0.9.2.0-5pCa6Zd2ytCBxKPCiAVcIx
    blaze-markup-0.8.3.0-JJ5r8tycCxXJkM0kXa0ha9 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-KNymwxzPyypAOJSQGx0ioI
    clientsession-0.9.3.0-F81IgejuppZIVdHDsmZ7W4
    cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    conduit-1.3.6.1-5afbFXdQmpuHK8N5OCErlh
    conduit-extra-1.3.8-Dg42smPzbiF4Nemzj9bTg6 containers-0.6.7
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz directory-1.3.8.5
    extra-1.7.16-IkudFHstV64EKMSGT8IWWb
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    githash-0.1.6.3-L5VTSr5LQebIEYHHLt617w
    hjsmin-0.2.1-DJkPitA070X2jhBSAPswR5
    hledger-1.51.1-I51AfN4EY4P3Ji1R1h33rs
    hledger-lib-1.51.1-HrRw4SAjiq35xNyP9b6ko5
    hspec-2.11.4-8QgnQwrEho14jh62SRkWei
    http-client-0.7.19-9XP2fRtq348Edv4XKGE8tD
    http-conduit-2.3.9.1-4fv8UoY8zTlKlPGaK7tn4g
    http-types-0.12.4-E9He9FXy4rKITKDtg1mhVt
    megaparsec-9.7.0-CJUMznUvVaqA9LkZfHNyDE mtl-2.3.1
    network-3.1.4.0-JRitsFhJ8rKGUNW13KrLgQ
    safe-0.3.21-7oQO4KcgDWt1YhK3ifcAwa
    shakespeare-2.1.7-EQa3S9NEyAK816psNg58s0 template-haskell-2.20.0.0
    text-2.0.2 time-1.12.2 transformers-0.6.1.0
    unix-compat-0.7.4.1-4zbVOVPfIKMI5a8vIMtFDq
    unordered-containers-0.2.20.1-L0jiELAFLwP1g4FZscm3B5
    utf8-string-1.0.2-GrV0vD7epd2Fw38ZtPT1hv
    wai-3.2.4-DggAE0S6Fb43aX3BIvUJ63
    wai-cors-0.2.7-JB1BAwklGsc8BcDTxFL8JZ
    wai-extra-3.1.18-1ANzYYqVephHj2C1lo6Zwk
    wai-handler-launch-3.0.3.1-BTo9YWlJbOYI3up6MSkXvf
    warp-3.4.0-EMEx6bSExsO4TCzNcPaO2H
    yaml-0.11.11.2-HJgRwey6BMIIq0hOFQKRBa
    yesod-1.6.2.1-2a4TBVtomshJ2OI7T9r0Bp
    yesod-core-1.6.27.1-KtBa6Xls8994lQw12Q4B1F
    yesod-form-1.7.9-GUMlEsGVy6YAaQxgbLNWHz
    yesod-static-1.6.1.0-3qfjjxIJZN3r519Uk6gYp
    yesod-test-1.6.23-6vs8MdYkMkc1BeBxKAtQsl

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

