#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.51.2
visibility:           public
id:                   hledger-web-1.51.2-E9zUHsokCNi4PVM4rAbnGD
key:                  hledger-web-1.51.2-E9zUHsokCNi4PVM4rAbnGD
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  a733ef2b0c4a6a57f76d5f3a37160c6a
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.App Hledger.Web.Application
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Main Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Test
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common

hidden-modules:       Paths_hledger_web
import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-web-1.51.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-web-1.51.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-web-1.51.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.51.2-E9zUHsokCNi4PVM4rAbnGD
depends:
    Decimal-0.5.2-LTTKXS6uNcn3lj0JriESvl
    aeson-2.2.0.0-Hqy1Zqe0ZE81dk2L20icmH base-4.18.2.1
    base64-1.0-BEEcJ9ahFTB7TMDRZSMMVS
    blaze-html-0.9.2.0-AqjQr4Ps51QD51ybemU3ZY
    blaze-markup-0.8.3.0-K7wUMOM5SyIFeEdepQMdjc bytestring-0.11.5.3
    case-insensitive-1.2.1.0-8PStX6cixKCLkUJoPuARL
    clientsession-0.9.3.0-7Qaz243uinzAxbsZKCsGvF
    cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    conduit-1.3.6.1-CwUx671uWmDAcHwxI0YYDy
    conduit-extra-1.3.8-GHF5wYhQp30HUaLAtCbs0G containers-0.6.7
    data-default-0.7.1.3-Ihbp7WFUy146w4K1utdfXl directory-1.3.8.5
    extra-1.7.16-1R70WzmZutyIjhcnCYje37
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    githash-0.1.6.3-H2sTNFq8vkvGJUVF6fEtqH
    hjsmin-0.2.1-HYwv4TdXWrWI0wPbhFRf6t
    hledger-1.51.2-2VTjqrh643LKPcflU9yxD7
    hledger-lib-1.51.2-GHZoWop2PXO2xzvMmGKvTd
    hspec-2.11.4-CWeOi2KzKG1CBMKEfCTCPN
    http-client-0.7.19-HYRPxJ1velFCbteX9ut4f6
    http-conduit-2.3.9.1-4XCjseDTPMR1cOfyxjAQAe
    http-types-0.12.4-2YF0olXF9itCctWavExzmH
    megaparsec-9.7.0-EBrXuyfSuyTIUi7T8Ua8UQ mtl-2.3.1
    network-3.1.4.0-xB4epdb1XO3ZKzAxljM4X
    safe-0.3.21-KkG5O6k2axl5FoNYEbOYS8
    shakespeare-2.1.7-2tYm0ZnKNHbCMeQLiFCieX template-haskell-2.20.0.0
    text-2.0.2 time-1.12.2 transformers-0.6.1.0
    unix-compat-0.7.4.1-A9X47MkwTFf6xepaAigQ6V
    unordered-containers-0.2.20.1-1hrud2F05KV7Rz7RsKTZ5O
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    wai-3.2.4-BLc210LwMQhDvJHRqgIjev
    wai-cors-0.2.7-HTuGYjzQGCg8ySuvRnaB6R
    wai-extra-3.1.18-2NqKPuFl5Jd2v0if4D3Rrq
    wai-handler-launch-3.0.3.1-7NhVs0MXrhfiQ9tNvohnY
    warp-3.4.0-Js0YTJVu1i5Lh7vUHNAyGE
    yaml-0.11.11.2-7sI7sa5XZN9728orpxXF0B
    yesod-1.6.2.1-EHYiX6Nr14y39EVzLgET13
    yesod-core-1.6.27.1-4gpTrKJARZw1tOAQMfFW4B
    yesod-form-1.7.9-4CfkicQN4Gh1BZtbFMO3Cs
    yesod-static-1.6.1.0-CDZ9YjgWo1B9bXFdMNk8io
    yesod-test-1.6.23-8slwnHoUEeGChe9YChHvvL

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

