/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.linux_loongarch64;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.loongarch64.LOONGARCH64ThreadContext;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.loongarch64.LOONGARCH64CurrentFrameGuess;
import sun.jvm.hotspot.runtime.loongarch64.LOONGARCH64Frame;
import sun.jvm.hotspot.runtime.loongarch64.LOONGARCH64RegisterMap;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class LinuxLOONGARCH64JavaThreadPDAccess
implements JavaThreadPDAccess {
    private static AddressField lastJavaFPField;
    private static AddressField osThreadField;
    private static CIntegerField osThreadThreadIDField;
    private static final long GUESS_SCAN_RANGE = 131072L;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JavaThread");
        osThreadField = type.getAddressField("_osthread");
        Type anchorType = db.lookupType("JavaFrameAnchor");
        lastJavaFPField = anchorType.getAddressField("_last_Java_fp");
        Type osThreadType = db.lookupType("OSThread");
        osThreadThreadIDField = osThreadType.getCIntegerField("_thread_id");
    }

    @Override
    public Address getLastJavaFP(Address addr) {
        return lastJavaFPField.getValue(addr.addOffsetTo(JavaThread.getAnchorField().getOffset()));
    }

    @Override
    public Address getLastJavaPC(Address addr) {
        return null;
    }

    @Override
    public Address getBaseOfStackPointer(Address addr) {
        return null;
    }

    @Override
    public Frame getLastFramePD(JavaThread thread, Address addr) {
        Address fp = thread.getLastJavaFP();
        if (fp == null) {
            return null;
        }
        return new LOONGARCH64Frame(thread.getLastJavaSP(), fp);
    }

    @Override
    public RegisterMap newRegisterMap(JavaThread thread, boolean updateMap) {
        return new LOONGARCH64RegisterMap(thread, updateMap);
    }

    @Override
    public Frame getCurrentFrameGuess(JavaThread thread, Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        LOONGARCH64ThreadContext context = (LOONGARCH64ThreadContext)t.getContext();
        LOONGARCH64CurrentFrameGuess guesser = new LOONGARCH64CurrentFrameGuess(context, thread);
        if (!guesser.run(131072L)) {
            return null;
        }
        if (guesser.getPC() == null) {
            return new LOONGARCH64Frame(guesser.getSP(), guesser.getFP());
        }
        return new LOONGARCH64Frame(guesser.getSP(), guesser.getFP(), guesser.getPC());
    }

    @Override
    public void printThreadIDOn(Address addr, PrintStream tty) {
        tty.print(this.getThreadProxy(addr));
    }

    @Override
    public void printInfoOn(Address threadAddr, PrintStream tty) {
        tty.print("Thread id: ");
        this.printThreadIDOn(threadAddr, tty);
    }

    @Override
    public Address getLastSP(Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        LOONGARCH64ThreadContext context = (LOONGARCH64ThreadContext)t.getContext();
        return context.getRegisterAsAddress(3);
    }

    @Override
    public ThreadProxy getThreadProxy(Address addr) {
        Address osThreadAddr = osThreadField.getValue(addr);
        Address threadIdAddr = osThreadAddr.addOffsetTo(osThreadThreadIDField.getOffset());
        JVMDebugger debugger = VM.getVM().getDebugger();
        return debugger.getThreadForIdentifierAddress(threadIdAddr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                LinuxLOONGARCH64JavaThreadPDAccess.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

