#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-D3vI96hVAEYBbAQhqvvd3a
key:                  postgrest-10.0.0-D3vI96hVAEYBbAQhqvvd3a
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  e08e7724ed4ceb3647a670c559b27fcc
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-D3vI96hVAEYBbAQhqvvd3a
depends:
    HTTP-4000.4.1-9QKOH3moG66E3gEMmY9ujp
    Ranged-sets-0.5.0-5fYHVyilgY156rYCvfuKjK
    aeson-2.1.2.1-CpIoOLI7lIpJkSqSOmDN9y
    auto-update-0.1.6-88T3ReDBoup7kx6uceSFG6 base-4.18.2.1
    base64-bytestring-1.2.1.0-AZbYiNuTo1lLfA6t4c9Fhh
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-KNymwxzPyypAOJSQGx0ioI
    cassava-0.5.4.1-1CM8h0noLla7Uv16d8t4LK
    configurator-pg-0.2.11-3RMnKtFMdwvFKQpX4kWTYs containers-0.6.7
    contravariant-extras-0.3.5.4-3woyg6AJRP6Lk666ZeP5zR
    cookie-0.5.0-Dqi2dsQ09KG8Z0mbWITxu5 directory-1.3.8.5
    either-5.0.3-AwsJObJJa5t15rwL7Wjn2s
    gitrev-1.3.1-HjgHeGOzFY1JvYhlt8eDSs
    hasql-1.5.0.5-D56QxJSATLi7EO6Br9LDFG
    hasql-dynamic-statements-0.3.1.1-FAKaH6psqzZE4bEbLNsnz1
    hasql-notifications-0.2.0.5-HWsTSc6EM28E6Mho3HnUgG
    hasql-pool-0.5.2.2-E9pZt3MsMInGPVym8tUiYi
    hasql-transaction-1.0.1.1-Il4qgXOnyoL5xvlkWio9Z0
    heredoc-0.2.0.0-6fzsisYvDUd6tBbd4jIzIt
    http-types-0.12.4-E9He9FXy4rKITKDtg1mhVt
    insert-ordered-containers-0.2.5.3-F3ZWofUloJ3FcOrvJbOGyb
    interpolatedstring-perl6-1.0.2-4X8gKESgkusGvrFCaCKhPw
    jose-0.10-LUAtlKCTZ05K5mlnF0xFHK lens-5.3.3-GI3kNGpcyiIBMdla72MFoB
    lens-aeson-1.2.3-4ImEZjcSS5v7sGC7rUGMR2 mtl-2.3.1
    network-3.1.4.0-JRitsFhJ8rKGUNW13KrLgQ
    network-uri-2.6.4.2-ImBkmHhWmdwGJdqs22FerI
    optparse-applicative-0.18.1.0-BnGHnrTdK6d4c7MmJxSY0G
    parsec-3.1.16.1 protolude-0.3.5-8b84v0Z1fvfD2c2SvK9yLZ
    regex-tdfa-1.3.2.5-EWGvfiHhNcof6jXGuIJ2K
    retry-0.9.3.1-FYTMxXzp6ILABIm5Dm7RjL
    scientific-0.3.8.0-JR5ijS18eRDLRLPoHGHkyW
    swagger2-2.8.10-9b9lcZWIuur8JMkaDITY9o text-2.0.2 time-1.12.2
    unix-2.8.4.0 unordered-containers-0.2.20.1-L0jiELAFLwP1g4FZscm3B5
    vault-0.3.1.5-A9Ty7yzuPZlIa80zuSIl14
    vector-0.13.2.0-eGaPlIkScLKlfBYQuI3vH
    wai-3.2.4-DggAE0S6Fb43aX3BIvUJ63
    wai-cors-0.2.7-JB1BAwklGsc8BcDTxFL8JZ
    wai-extra-3.1.18-1ANzYYqVephHj2C1lo6Zwk
    wai-logger-2.5.0-VBPNbjn5lcBUCsraseoRs
    warp-3.4.0-EMEx6bSExsO4TCzNcPaO2H

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

