#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-ADwIixtUWNqFYsZ5XoGLaA
key:                  postgrest-10.0.0-ADwIixtUWNqFYsZ5XoGLaA
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  9c65265b2eb00e92e71d35e226bfccbe
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-ADwIixtUWNqFYsZ5XoGLaA
depends:
    HTTP-4000.4.1-LiE2KGoUj7cHY0TLoqm68A
    Ranged-sets-0.5.0-9GELwxUU4Sj5RFRSmMG6bM
    aeson-2.2.0.0-Hqy1Zqe0ZE81dk2L20icmH
    auto-update-0.1.6-KtJVhP9gwX02GwwOhHipKc base-4.18.2.1
    base64-bytestring-1.2.1.0-LrCtfbXf96jILPXKH7KAXZ
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-8PStX6cixKCLkUJoPuARL
    cassava-0.5.4.1-10TjIuvMZgmC1Daoo8YXOm
    configurator-pg-0.2.11-72w4q0Ipz3o87ndRd1LuWu containers-0.6.7
    contravariant-extras-0.3.5.4-3woyg6AJRP6Lk666ZeP5zR
    cookie-0.5.0-Dqi2dsQ09KG8Z0mbWITxu5 directory-1.3.8.5
    either-5.0.3-LFDQNuYi3b17Cn6amrgDNI
    gitrev-1.3.1-HjgHeGOzFY1JvYhlt8eDSs
    hasql-1.5.0.5-HIijPd3ZS3D1HWHalr6GlS
    hasql-dynamic-statements-0.3.1.1-K8ITVAtQrlv5QuIfXy3gpB
    hasql-notifications-0.2.0.5-2H1HNdBy51S7UmvzH2ZvPJ
    hasql-pool-0.5.2.2-BVmXDZkqSoaAut2P07H9yo
    hasql-transaction-1.0.1.1-Ezcxoqc1IVeB4IVbAaIZvQ
    heredoc-0.2.0.0-6fzsisYvDUd6tBbd4jIzIt
    http-types-0.12.4-2YF0olXF9itCctWavExzmH
    insert-ordered-containers-0.2.5.3-DsP9o4odHsNK4GfkJjY1YB
    interpolatedstring-perl6-1.0.2-CFdEUAd82gUGaDGiVSzLNg
    jose-0.10-DbYEn359Ch73VitiNf0Elv lens-5.3.3-KFcjpRU85K93uhgNXhcmM2
    lens-aeson-1.2.3-IGOeyaYbe2MKgOFlXw7TlQ mtl-2.3.1
    network-3.1.4.0-xB4epdb1XO3ZKzAxljM4X
    network-uri-2.6.4.2-1aRZPUfkmMD8JwUJF5GqMA
    optparse-applicative-0.18.1.0-EZi3UgmTFLmKW119EQEIXK
    parsec-3.1.16.1 protolude-0.3.5-CC7ap1L0oE44piTkkdp9KR
    regex-tdfa-1.3.2.5-IyWFwjfcdby2Ov14zG8K3o
    retry-0.9.3.1-HM6wU7gRvnkCjjxIf9Mqp3
    scientific-0.3.8.0-E8K90IhCZpR98POp8HwlML
    swagger2-2.8.10-6MydNcASQr5I2Xpcp3YmZb text-2.0.2 time-1.12.2
    unix-2.8.4.0 unordered-containers-0.2.20.1-1hrud2F05KV7Rz7RsKTZ5O
    vault-0.3.1.5-BxUCdgn4AEk2ZyHGBzL9yO
    vector-0.13.2.0-DULMVARQ1CU3TLBOg9xkS6
    wai-3.2.4-BLc210LwMQhDvJHRqgIjev
    wai-cors-0.2.7-HTuGYjzQGCg8ySuvRnaB6R
    wai-extra-3.1.18-2NqKPuFl5Jd2v0if4D3Rrq
    wai-logger-2.5.0-7XRbr5ukpDX4gn1KareYel
    warp-3.4.0-Js0YTJVu1i5Lh7vUHNAyGE

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

