# The PEP 484 type hints stub file for the QtHelp module.
#
# Generated by SIP 6.15.1.dev0+g7378531ef.d20251220
#
# Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt5.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt5.sip

from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5 import QtWidgets

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., Any], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class QCompressedHelpInfo(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QCompressedHelpInfo') -> None: ...

    def isNull(self) -> bool: ...
    @staticmethod
    def fromCompressedHelpFile(documentationFileName: str|None) -> 'QCompressedHelpInfo': ...
    def version(self) -> QtCore.QVersionNumber: ...
    def component(self) -> str: ...
    def namespaceName(self) -> str: ...
    def swap(self, other: 'QCompressedHelpInfo') -> None: ...


class QHelpContentItem(PyQt5.sipsimplewrapper):

    def childPosition(self, child: 'QHelpContentItem|None') -> int: ...
    def parent(self) -> 'QHelpContentItem|None': ...
    def row(self) -> int: ...
    def url(self) -> QtCore.QUrl: ...
    def title(self) -> str: ...
    def childCount(self) -> int: ...
    def child(self, row: int) -> 'QHelpContentItem|None': ...


class QHelpContentModel(QtCore.QAbstractItemModel):

    contentsCreated: typing.ClassVar[QtCore.pyqtSignal]
    contentsCreationStarted: typing.ClassVar[QtCore.pyqtSignal]
    def isCreatingContents(self) -> bool: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def contentItemAt(self, index: QtCore.QModelIndex) -> QHelpContentItem|None: ...
    def createContents(self, customFilterName: str|None) -> None: ...


class QHelpContentWidget(QtWidgets.QTreeView):

    linkActivated: typing.ClassVar[QtCore.pyqtSignal]
    def indexOf(self, link: QtCore.QUrl) -> QtCore.QModelIndex: ...


class QHelpEngineCore(QtCore.QObject):

    def __init__(self, collectionFile: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    @typing.overload
    def documentsForKeyword(self, keyword: str|None) -> list['QHelpLink']: ...
    @typing.overload
    def documentsForKeyword(self, keyword: str|None, filterName: str|None) -> list['QHelpLink']: ...
    @typing.overload
    def documentsForIdentifier(self, id: str|None) -> list['QHelpLink']: ...
    @typing.overload
    def documentsForIdentifier(self, id: str|None, filterName: str|None) -> list['QHelpLink']: ...
    def usesFilterEngine(self) -> bool: ...
    def setUsesFilterEngine(self, uses: bool) -> None: ...
    def filterEngine(self) -> 'QHelpFilterEngine|None': ...
    readersAboutToBeInvalidated: typing.ClassVar[QtCore.pyqtSignal]
    warning: typing.ClassVar[QtCore.pyqtSignal]
    currentFilterChanged: typing.ClassVar[QtCore.pyqtSignal]
    setupFinished: typing.ClassVar[QtCore.pyqtSignal]
    setupStarted: typing.ClassVar[QtCore.pyqtSignal]
    def setAutoSaveFilter(self, save: bool) -> None: ...
    def autoSaveFilter(self) -> bool: ...
    def error(self) -> str: ...
    @staticmethod
    def metaData(documentationFileName: str|None, name: str|None) -> typing.Any: ...
    def setCustomValue(self, key: str|None, value: typing.Any) -> bool: ...
    def customValue(self, key: str|None, defaultValue: typing.Any = ...) -> typing.Any: ...
    def removeCustomValue(self, key: str|None) -> bool: ...
    def linksForKeyword(self, keyword: str|None) -> dict[str, QtCore.QUrl]: ...
    def linksForIdentifier(self, id: str|None) -> dict[str, QtCore.QUrl]: ...
    def fileData(self, url: QtCore.QUrl) -> QtCore.QByteArray: ...
    def findFile(self, url: QtCore.QUrl) -> QtCore.QUrl: ...
    @typing.overload
    def files(self, namespaceName: str|None, filterAttributes: collections.abc.Iterable[str|None], extensionFilter: str|None = ...) -> list[QtCore.QUrl]: ...
    @typing.overload
    def files(self, namespaceName: str|None, filterName: str|None, extensionFilter: str|None = ...) -> list[QtCore.QUrl]: ...
    def filterAttributeSets(self, namespaceName: str|None) -> list[list[str]]: ...
    def registeredDocumentations(self) -> list[str]: ...
    def setCurrentFilter(self, filterName: str|None) -> None: ...
    def currentFilter(self) -> str: ...
    @typing.overload
    def filterAttributes(self) -> list[str]: ...
    @typing.overload
    def filterAttributes(self, filterName: str|None) -> list[str]: ...
    def addCustomFilter(self, filterName: str|None, attributes: collections.abc.Iterable[str|None]) -> bool: ...
    def removeCustomFilter(self, filterName: str|None) -> bool: ...
    def customFilters(self) -> list[str]: ...
    def documentationFileName(self, namespaceName: str|None) -> str: ...
    def unregisterDocumentation(self, namespaceName: str|None) -> bool: ...
    def registerDocumentation(self, documentationFileName: str|None) -> bool: ...
    @staticmethod
    def namespaceName(documentationFileName: str|None) -> str: ...
    def copyCollectionFile(self, fileName: str|None) -> bool: ...
    def setCollectionFile(self, fileName: str|None) -> None: ...
    def collectionFile(self) -> str: ...
    def setupData(self) -> bool: ...


class QHelpEngine(QHelpEngineCore):

    def __init__(self, collectionFile: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    def searchEngine(self) -> 'QHelpSearchEngine|None': ...
    def indexWidget(self) -> 'QHelpIndexWidget|None': ...
    def contentWidget(self) -> QHelpContentWidget|None: ...
    def indexModel(self) -> 'QHelpIndexModel|None': ...
    def contentModel(self) -> QHelpContentModel|None: ...


class QHelpFilterData(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QHelpFilterData') -> None: ...

    def __ne__(self, other: object): ...
    def versions(self) -> list[QtCore.QVersionNumber]: ...
    def components(self) -> list[str]: ...
    def setVersions(self, versions: collections.abc.Iterable[QtCore.QVersionNumber]) -> None: ...
    def setComponents(self, components: collections.abc.Iterable[str|None]) -> None: ...
    def swap(self, other: 'QHelpFilterData') -> None: ...
    def __eq__(self, other: object): ...


class QHelpFilterEngine(QtCore.QObject):

    @typing.overload
    def indices(self) -> list[str]: ...
    @typing.overload
    def indices(self, filterName: str|None) -> list[str]: ...
    def availableVersions(self) -> list[QtCore.QVersionNumber]: ...
    filterActivated: typing.ClassVar[QtCore.pyqtSignal]
    def namespacesForFilter(self, filterName: str|None) -> list[str]: ...
    def removeFilter(self, filterName: str|None) -> bool: ...
    def setFilterData(self, filterName: str|None, filterData: QHelpFilterData) -> bool: ...
    def filterData(self, filterName: str|None) -> QHelpFilterData: ...
    def availableComponents(self) -> list[str]: ...
    def setActiveFilter(self, filterName: str|None) -> bool: ...
    def activeFilter(self) -> str: ...
    def filters(self) -> list[str]: ...
    def namespaceToVersion(self) -> dict[str, QtCore.QVersionNumber]: ...
    def namespaceToComponent(self) -> dict[str, str]: ...


class QHelpFilterSettingsWidget(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    def applySettings(self, filterEngine: QHelpFilterEngine|None) -> bool: ...
    def readSettings(self, filterEngine: QHelpFilterEngine|None) -> None: ...
    def setAvailableVersions(self, versions: collections.abc.Iterable[QtCore.QVersionNumber]) -> None: ...
    def setAvailableComponents(self, components: collections.abc.Iterable[str|None]) -> None: ...


class QHelpIndexModel(QtCore.QStringListModel):

    indexCreated: typing.ClassVar[QtCore.pyqtSignal]
    indexCreationStarted: typing.ClassVar[QtCore.pyqtSignal]
    def isCreatingIndex(self) -> bool: ...
    def linksForKeyword(self, keyword: str|None) -> dict[str, QtCore.QUrl]: ...
    def filter(self, filter: str|None, wildcard: str|None = ...) -> QtCore.QModelIndex: ...
    def createIndex(self, customFilterName: str|None) -> None: ...
    def helpEngine(self) -> QHelpEngineCore|None: ...


class QHelpIndexWidget(QtWidgets.QListView):

    documentsActivated: typing.ClassVar[QtCore.pyqtSignal]
    documentActivated: typing.ClassVar[QtCore.pyqtSignal]
    def activateCurrentItem(self) -> None: ...
    def filterIndices(self, filter: str|None, wildcard: str|None = ...) -> None: ...
    linksActivated: typing.ClassVar[QtCore.pyqtSignal]
    linkActivated: typing.ClassVar[QtCore.pyqtSignal]


class QHelpLink(PyQt5.sipsimplewrapper):

    title = ... # type: str|None
    url = ... # type: QtCore.QUrl

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QHelpLink') -> None: ...


class QHelpSearchQuery(PyQt5.sipsimplewrapper):

    class FieldName(int):
        DEFAULT = ... # type: QHelpSearchQuery.FieldName
        FUZZY = ... # type: QHelpSearchQuery.FieldName
        WITHOUT = ... # type: QHelpSearchQuery.FieldName
        PHRASE = ... # type: QHelpSearchQuery.FieldName
        ALL = ... # type: QHelpSearchQuery.FieldName
        ATLEAST = ... # type: QHelpSearchQuery.FieldName

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, field: 'QHelpSearchQuery.FieldName', wordList: collections.abc.Iterable[str|None]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QHelpSearchQuery') -> None: ...


class QHelpSearchEngine(QtCore.QObject):

    def __init__(self, helpEngine: QHelpEngineCore|None, parent: QtCore.QObject|None = ...) -> None: ...

    def searchInput(self) -> str: ...
    def searchResults(self, start: int, end: int) -> list['QHelpSearchResult']: ...
    def searchResultCount(self) -> int: ...
    searchingFinished: typing.ClassVar[QtCore.pyqtSignal]
    searchingStarted: typing.ClassVar[QtCore.pyqtSignal]
    indexingFinished: typing.ClassVar[QtCore.pyqtSignal]
    indexingStarted: typing.ClassVar[QtCore.pyqtSignal]
    def cancelSearching(self) -> None: ...
    @typing.overload
    def search(self, queryList: collections.abc.Iterable[QHelpSearchQuery]) -> None: ...
    @typing.overload
    def search(self, searchInput: str|None) -> None: ...
    def cancelIndexing(self) -> None: ...
    def reindexDocumentation(self) -> None: ...
    def hits(self, start: int, end: int) -> list[tuple[str, str]]: ...
    def hitCount(self) -> int: ...
    def resultWidget(self) -> 'QHelpSearchResultWidget|None': ...
    def queryWidget(self) -> 'QHelpSearchQueryWidget|None': ...
    def query(self) -> list[QHelpSearchQuery]: ...


class QHelpSearchResult(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QHelpSearchResult') -> None: ...
    @typing.overload
    def __init__(self, url: QtCore.QUrl, title: str|None, snippet: str|None) -> None: ...

    def snippet(self) -> str: ...
    def url(self) -> QtCore.QUrl: ...
    def title(self) -> str: ...


class QHelpSearchQueryWidget(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    def setSearchInput(self, searchInput: str|None) -> None: ...
    def searchInput(self) -> str: ...
    def setCompactMode(self, on: bool) -> None: ...
    def isCompactMode(self) -> bool: ...
    search: typing.ClassVar[QtCore.pyqtSignal]
    def collapseExtendedSearch(self) -> None: ...
    def expandExtendedSearch(self) -> None: ...
    def setQuery(self, queryList: collections.abc.Iterable[QHelpSearchQuery]) -> None: ...
    def query(self) -> list[QHelpSearchQuery]: ...


class QHelpSearchResultWidget(QtWidgets.QWidget):

    requestShowLink: typing.ClassVar[QtCore.pyqtSignal]
    def linkAt(self, point: QtCore.QPoint) -> QtCore.QUrl: ...
