# The PEP 484 type hints stub file for the Qt3DRender module.
#
# Generated by SIP 6.15.1.dev0+g7378531ef.d20251220
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6-3D.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtGui
from PyQt6 import Qt3DCore
from PyQt6 import QtOpenGL

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class API(enum.Enum):
    OpenGL = ... # type: API
    Vulkan = ... # type: API
    DirectX = ... # type: API
    Metal = ... # type: API
    RHI = ... # type: API
    Null = ... # type: API


class QAbstractLight(Qt3DCore.QComponent):

    class Type(enum.Enum):
        PointLight = ... # type: QAbstractLight.Type
        DirectionalLight = ... # type: QAbstractLight.Type
        SpotLight = ... # type: QAbstractLight.Type

    intensityChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setIntensity(self, intensity: float) -> None: ...
    def setColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def intensity(self) -> float: ...
    def color(self) -> QtGui.QColor: ...
    def type(self) -> 'QAbstractLight.Type': ...


class QAbstractRayCaster(Qt3DCore.QComponent):

    class FilterMode(enum.Enum):
        AcceptAnyMatchingLayers = ... # type: QAbstractRayCaster.FilterMode
        AcceptAllMatchingLayers = ... # type: QAbstractRayCaster.FilterMode
        DiscardAnyMatchingLayers = ... # type: QAbstractRayCaster.FilterMode
        DiscardAllMatchingLayers = ... # type: QAbstractRayCaster.FilterMode

    class RunMode(enum.Enum):
        Continuous = ... # type: QAbstractRayCaster.RunMode
        SingleShot = ... # type: QAbstractRayCaster.RunMode

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    filterModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    hitsChanged: typing.ClassVar[QtCore.pyqtSignal]
    runModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setFilterMode(self, filterMode: 'QAbstractRayCaster.FilterMode') -> None: ...
    def setRunMode(self, runMode: 'QAbstractRayCaster.RunMode') -> None: ...
    def layers(self) -> list['QLayer']: ...
    def removeLayer(self, layer: 'QLayer|None') -> None: ...
    def addLayer(self, layer: 'QLayer|None') -> None: ...
    def hits(self) -> list['QRayCasterHit']: ...
    def filterMode(self) -> 'QAbstractRayCaster.FilterMode': ...
    def runMode(self) -> 'QAbstractRayCaster.RunMode': ...


class QAbstractTexture(Qt3DCore.QNode):

    class HandleType(enum.Enum):
        NoHandle = ... # type: QAbstractTexture.HandleType
        OpenGLTextureId = ... # type: QAbstractTexture.HandleType
        RHITextureId = ... # type: QAbstractTexture.HandleType

    class ComparisonMode(enum.Enum):
        CompareRefToTexture = ... # type: QAbstractTexture.ComparisonMode
        CompareNone = ... # type: QAbstractTexture.ComparisonMode

    class ComparisonFunction(enum.Enum):
        CompareLessEqual = ... # type: QAbstractTexture.ComparisonFunction
        CompareGreaterEqual = ... # type: QAbstractTexture.ComparisonFunction
        CompareLess = ... # type: QAbstractTexture.ComparisonFunction
        CompareGreater = ... # type: QAbstractTexture.ComparisonFunction
        CompareEqual = ... # type: QAbstractTexture.ComparisonFunction
        CommpareNotEqual = ... # type: QAbstractTexture.ComparisonFunction
        CompareAlways = ... # type: QAbstractTexture.ComparisonFunction
        CompareNever = ... # type: QAbstractTexture.ComparisonFunction

    class CubeMapFace(enum.Enum):
        CubeMapPositiveX = ... # type: QAbstractTexture.CubeMapFace
        CubeMapNegativeX = ... # type: QAbstractTexture.CubeMapFace
        CubeMapPositiveY = ... # type: QAbstractTexture.CubeMapFace
        CubeMapNegativeY = ... # type: QAbstractTexture.CubeMapFace
        CubeMapPositiveZ = ... # type: QAbstractTexture.CubeMapFace
        CubeMapNegativeZ = ... # type: QAbstractTexture.CubeMapFace
        AllFaces = ... # type: QAbstractTexture.CubeMapFace

    class Filter(enum.Enum):
        Nearest = ... # type: QAbstractTexture.Filter
        Linear = ... # type: QAbstractTexture.Filter
        NearestMipMapNearest = ... # type: QAbstractTexture.Filter
        NearestMipMapLinear = ... # type: QAbstractTexture.Filter
        LinearMipMapNearest = ... # type: QAbstractTexture.Filter
        LinearMipMapLinear = ... # type: QAbstractTexture.Filter

    class TextureFormat(enum.Enum):
        NoFormat = ... # type: QAbstractTexture.TextureFormat
        Automatic = ... # type: QAbstractTexture.TextureFormat
        R8_UNorm = ... # type: QAbstractTexture.TextureFormat
        RG8_UNorm = ... # type: QAbstractTexture.TextureFormat
        RGB8_UNorm = ... # type: QAbstractTexture.TextureFormat
        RGBA8_UNorm = ... # type: QAbstractTexture.TextureFormat
        R16_UNorm = ... # type: QAbstractTexture.TextureFormat
        RG16_UNorm = ... # type: QAbstractTexture.TextureFormat
        RGB16_UNorm = ... # type: QAbstractTexture.TextureFormat
        RGBA16_UNorm = ... # type: QAbstractTexture.TextureFormat
        R8_SNorm = ... # type: QAbstractTexture.TextureFormat
        RG8_SNorm = ... # type: QAbstractTexture.TextureFormat
        RGB8_SNorm = ... # type: QAbstractTexture.TextureFormat
        RGBA8_SNorm = ... # type: QAbstractTexture.TextureFormat
        R16_SNorm = ... # type: QAbstractTexture.TextureFormat
        RG16_SNorm = ... # type: QAbstractTexture.TextureFormat
        RGB16_SNorm = ... # type: QAbstractTexture.TextureFormat
        RGBA16_SNorm = ... # type: QAbstractTexture.TextureFormat
        R8U = ... # type: QAbstractTexture.TextureFormat
        RG8U = ... # type: QAbstractTexture.TextureFormat
        RGB8U = ... # type: QAbstractTexture.TextureFormat
        RGBA8U = ... # type: QAbstractTexture.TextureFormat
        R16U = ... # type: QAbstractTexture.TextureFormat
        RG16U = ... # type: QAbstractTexture.TextureFormat
        RGB16U = ... # type: QAbstractTexture.TextureFormat
        RGBA16U = ... # type: QAbstractTexture.TextureFormat
        R32U = ... # type: QAbstractTexture.TextureFormat
        RG32U = ... # type: QAbstractTexture.TextureFormat
        RGB32U = ... # type: QAbstractTexture.TextureFormat
        RGBA32U = ... # type: QAbstractTexture.TextureFormat
        R8I = ... # type: QAbstractTexture.TextureFormat
        RG8I = ... # type: QAbstractTexture.TextureFormat
        RGB8I = ... # type: QAbstractTexture.TextureFormat
        RGBA8I = ... # type: QAbstractTexture.TextureFormat
        R16I = ... # type: QAbstractTexture.TextureFormat
        RG16I = ... # type: QAbstractTexture.TextureFormat
        RGB16I = ... # type: QAbstractTexture.TextureFormat
        RGBA16I = ... # type: QAbstractTexture.TextureFormat
        R32I = ... # type: QAbstractTexture.TextureFormat
        RG32I = ... # type: QAbstractTexture.TextureFormat
        RGB32I = ... # type: QAbstractTexture.TextureFormat
        RGBA32I = ... # type: QAbstractTexture.TextureFormat
        R16F = ... # type: QAbstractTexture.TextureFormat
        RG16F = ... # type: QAbstractTexture.TextureFormat
        RGB16F = ... # type: QAbstractTexture.TextureFormat
        RGBA16F = ... # type: QAbstractTexture.TextureFormat
        R32F = ... # type: QAbstractTexture.TextureFormat
        RG32F = ... # type: QAbstractTexture.TextureFormat
        RGB32F = ... # type: QAbstractTexture.TextureFormat
        RGBA32F = ... # type: QAbstractTexture.TextureFormat
        RGB9E5 = ... # type: QAbstractTexture.TextureFormat
        RG11B10F = ... # type: QAbstractTexture.TextureFormat
        RG3B2 = ... # type: QAbstractTexture.TextureFormat
        R5G6B5 = ... # type: QAbstractTexture.TextureFormat
        RGB5A1 = ... # type: QAbstractTexture.TextureFormat
        RGBA4 = ... # type: QAbstractTexture.TextureFormat
        RGB10A2 = ... # type: QAbstractTexture.TextureFormat
        D16 = ... # type: QAbstractTexture.TextureFormat
        D24 = ... # type: QAbstractTexture.TextureFormat
        D24S8 = ... # type: QAbstractTexture.TextureFormat
        D32 = ... # type: QAbstractTexture.TextureFormat
        D32F = ... # type: QAbstractTexture.TextureFormat
        D32FS8X24 = ... # type: QAbstractTexture.TextureFormat
        RGB_DXT1 = ... # type: QAbstractTexture.TextureFormat
        RGBA_DXT1 = ... # type: QAbstractTexture.TextureFormat
        RGBA_DXT3 = ... # type: QAbstractTexture.TextureFormat
        RGBA_DXT5 = ... # type: QAbstractTexture.TextureFormat
        R_ATI1N_UNorm = ... # type: QAbstractTexture.TextureFormat
        R_ATI1N_SNorm = ... # type: QAbstractTexture.TextureFormat
        RG_ATI2N_UNorm = ... # type: QAbstractTexture.TextureFormat
        RG_ATI2N_SNorm = ... # type: QAbstractTexture.TextureFormat
        RGB_BP_UNSIGNED_FLOAT = ... # type: QAbstractTexture.TextureFormat
        RGB_BP_SIGNED_FLOAT = ... # type: QAbstractTexture.TextureFormat
        RGB_BP_UNorm = ... # type: QAbstractTexture.TextureFormat
        R11_EAC_UNorm = ... # type: QAbstractTexture.TextureFormat
        R11_EAC_SNorm = ... # type: QAbstractTexture.TextureFormat
        RG11_EAC_UNorm = ... # type: QAbstractTexture.TextureFormat
        RG11_EAC_SNorm = ... # type: QAbstractTexture.TextureFormat
        RGB8_ETC2 = ... # type: QAbstractTexture.TextureFormat
        SRGB8_ETC2 = ... # type: QAbstractTexture.TextureFormat
        RGB8_PunchThrough_Alpha1_ETC2 = ... # type: QAbstractTexture.TextureFormat
        SRGB8_PunchThrough_Alpha1_ETC2 = ... # type: QAbstractTexture.TextureFormat
        RGBA8_ETC2_EAC = ... # type: QAbstractTexture.TextureFormat
        SRGB8_Alpha8_ETC2_EAC = ... # type: QAbstractTexture.TextureFormat
        RGB8_ETC1 = ... # type: QAbstractTexture.TextureFormat
        SRGB8 = ... # type: QAbstractTexture.TextureFormat
        SRGB8_Alpha8 = ... # type: QAbstractTexture.TextureFormat
        SRGB_DXT1 = ... # type: QAbstractTexture.TextureFormat
        SRGB_Alpha_DXT1 = ... # type: QAbstractTexture.TextureFormat
        SRGB_Alpha_DXT3 = ... # type: QAbstractTexture.TextureFormat
        SRGB_Alpha_DXT5 = ... # type: QAbstractTexture.TextureFormat
        SRGB_BP_UNorm = ... # type: QAbstractTexture.TextureFormat
        DepthFormat = ... # type: QAbstractTexture.TextureFormat
        AlphaFormat = ... # type: QAbstractTexture.TextureFormat
        RGBFormat = ... # type: QAbstractTexture.TextureFormat
        RGBAFormat = ... # type: QAbstractTexture.TextureFormat
        LuminanceFormat = ... # type: QAbstractTexture.TextureFormat
        LuminanceAlphaFormat = ... # type: QAbstractTexture.TextureFormat
        RGB10A2U = ... # type: QAbstractTexture.TextureFormat

    class Target(enum.Enum):
        TargetAutomatic = ... # type: QAbstractTexture.Target
        Target1D = ... # type: QAbstractTexture.Target
        Target1DArray = ... # type: QAbstractTexture.Target
        Target2D = ... # type: QAbstractTexture.Target
        Target2DArray = ... # type: QAbstractTexture.Target
        Target3D = ... # type: QAbstractTexture.Target
        TargetCubeMap = ... # type: QAbstractTexture.Target
        TargetCubeMapArray = ... # type: QAbstractTexture.Target
        Target2DMultisample = ... # type: QAbstractTexture.Target
        Target2DMultisampleArray = ... # type: QAbstractTexture.Target
        TargetRectangle = ... # type: QAbstractTexture.Target
        TargetBuffer = ... # type: QAbstractTexture.Target

    class Status(enum.Enum):
        None_ = ... # type: QAbstractTexture.Status
        Loading = ... # type: QAbstractTexture.Status
        Ready = ... # type: QAbstractTexture.Status
        Error = ... # type: QAbstractTexture.Status

    @typing.overload
    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...
    @typing.overload
    def __init__(self, target: 'QAbstractTexture.Target', parent: Qt3DCore.QNode|None = ...) -> None: ...

    def updateData(self, update: 'QTextureDataUpdate') -> None: ...
    mipLevelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    handleChanged: typing.ClassVar[QtCore.pyqtSignal]
    handleTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def handle(self) -> typing.Any: ...
    def handleType(self) -> 'QAbstractTexture.HandleType': ...
    def setStatus(self, status: 'QAbstractTexture.Status') -> None: ...
    samplesChanged: typing.ClassVar[QtCore.pyqtSignal]
    layersChanged: typing.ClassVar[QtCore.pyqtSignal]
    comparisonModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    comparisonFunctionChanged: typing.ClassVar[QtCore.pyqtSignal]
    maximumAnisotropyChanged: typing.ClassVar[QtCore.pyqtSignal]
    minificationFilterChanged: typing.ClassVar[QtCore.pyqtSignal]
    magnificationFilterChanged: typing.ClassVar[QtCore.pyqtSignal]
    depthChanged: typing.ClassVar[QtCore.pyqtSignal]
    heightChanged: typing.ClassVar[QtCore.pyqtSignal]
    widthChanged: typing.ClassVar[QtCore.pyqtSignal]
    generateMipMapsChanged: typing.ClassVar[QtCore.pyqtSignal]
    statusChanged: typing.ClassVar[QtCore.pyqtSignal]
    formatChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setMipLevels(self, mipLevels: int) -> None: ...
    def setSamples(self, samples: int) -> None: ...
    def setLayers(self, layers: int) -> None: ...
    def setComparisonMode(self, mode: 'QAbstractTexture.ComparisonMode') -> None: ...
    def setComparisonFunction(self, function: 'QAbstractTexture.ComparisonFunction') -> None: ...
    def setMaximumAnisotropy(self, anisotropy: float) -> None: ...
    def setMagnificationFilter(self, f: 'QAbstractTexture.Filter') -> None: ...
    def setMinificationFilter(self, f: 'QAbstractTexture.Filter') -> None: ...
    def setDepth(self, depth: int) -> None: ...
    def setHeight(self, height: int) -> None: ...
    def setWidth(self, width: int) -> None: ...
    def setGenerateMipMaps(self, gen: bool) -> None: ...
    def setFormat(self, format: 'QAbstractTexture.TextureFormat') -> None: ...
    def mipLevels(self) -> int: ...
    def samples(self) -> int: ...
    def layers(self) -> int: ...
    def depth(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def comparisonMode(self) -> 'QAbstractTexture.ComparisonMode': ...
    def comparisonFunction(self) -> 'QAbstractTexture.ComparisonFunction': ...
    def maximumAnisotropy(self) -> float: ...
    def magnificationFilter(self) -> 'QAbstractTexture.Filter': ...
    def minificationFilter(self) -> 'QAbstractTexture.Filter': ...
    def setSize(self, width: int, height: int = ..., depth: int = ...) -> None: ...
    def wrapMode(self) -> 'QTextureWrapMode|None': ...
    def setWrapMode(self, wrapMode: 'QTextureWrapMode') -> None: ...
    def textureImages(self) -> list['QAbstractTextureImage']: ...
    def removeTextureImage(self, textureImage: 'QAbstractTextureImage|None') -> None: ...
    def addTextureImage(self, textureImage: 'QAbstractTextureImage|None') -> None: ...
    def status(self) -> 'QAbstractTexture.Status': ...
    def generateMipMaps(self) -> bool: ...
    def format(self) -> 'QAbstractTexture.TextureFormat': ...
    def target(self) -> 'QAbstractTexture.Target': ...


class QAbstractTextureImage(Qt3DCore.QNode):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def dataGenerator(self) -> 'QTextureImageDataGenerator': ...
    def notifyDataGeneratorChanged(self) -> None: ...
    faceChanged: typing.ClassVar[QtCore.pyqtSignal]
    layerChanged: typing.ClassVar[QtCore.pyqtSignal]
    mipLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setFace(self, face: 'QAbstractTexture.CubeMapFace') -> None: ...
    def setLayer(self, layer: int) -> None: ...
    def setMipLevel(self, level: int) -> None: ...
    def face(self) -> 'QAbstractTexture.CubeMapFace': ...
    def layer(self) -> int: ...
    def mipLevel(self) -> int: ...


class QRenderState(Qt3DCore.QNode): ...


class QAlphaCoverage('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QAlphaTest('QRenderState'):

    class AlphaFunction(enum.Enum):
        Never = ... # type: QAlphaTest.AlphaFunction
        Always = ... # type: QAlphaTest.AlphaFunction
        Less = ... # type: QAlphaTest.AlphaFunction
        LessOrEqual = ... # type: QAlphaTest.AlphaFunction
        Equal = ... # type: QAlphaTest.AlphaFunction
        GreaterOrEqual = ... # type: QAlphaTest.AlphaFunction
        Greater = ... # type: QAlphaTest.AlphaFunction
        NotEqual = ... # type: QAlphaTest.AlphaFunction

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    referenceValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    alphaFunctionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setReferenceValue(self, referenceValue: float) -> None: ...
    def setAlphaFunction(self, alphaFunction: 'QAlphaTest.AlphaFunction') -> None: ...
    def referenceValue(self) -> float: ...
    def alphaFunction(self) -> 'QAlphaTest.AlphaFunction': ...


class QBlendEquation('QRenderState'):

    class BlendFunction(enum.Enum):
        Add = ... # type: QBlendEquation.BlendFunction
        Subtract = ... # type: QBlendEquation.BlendFunction
        ReverseSubtract = ... # type: QBlendEquation.BlendFunction
        Min = ... # type: QBlendEquation.BlendFunction
        Max = ... # type: QBlendEquation.BlendFunction

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    blendFunctionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setBlendFunction(self, blendFunction: 'QBlendEquation.BlendFunction') -> None: ...
    def blendFunction(self) -> 'QBlendEquation.BlendFunction': ...


class QBlendEquationArguments('QRenderState'):

    class Blending(enum.Enum):
        Zero = ... # type: QBlendEquationArguments.Blending
        One = ... # type: QBlendEquationArguments.Blending
        SourceColor = ... # type: QBlendEquationArguments.Blending
        SourceAlpha = ... # type: QBlendEquationArguments.Blending
        Source1Alpha = ... # type: QBlendEquationArguments.Blending
        Source1Color = ... # type: QBlendEquationArguments.Blending
        DestinationColor = ... # type: QBlendEquationArguments.Blending
        DestinationAlpha = ... # type: QBlendEquationArguments.Blending
        SourceAlphaSaturate = ... # type: QBlendEquationArguments.Blending
        ConstantColor = ... # type: QBlendEquationArguments.Blending
        ConstantAlpha = ... # type: QBlendEquationArguments.Blending
        OneMinusSourceColor = ... # type: QBlendEquationArguments.Blending
        OneMinusSourceAlpha = ... # type: QBlendEquationArguments.Blending
        OneMinusDestinationAlpha = ... # type: QBlendEquationArguments.Blending
        OneMinusDestinationColor = ... # type: QBlendEquationArguments.Blending
        OneMinusConstantColor = ... # type: QBlendEquationArguments.Blending
        OneMinusConstantAlpha = ... # type: QBlendEquationArguments.Blending
        OneMinusSource1Alpha = ... # type: QBlendEquationArguments.Blending
        OneMinusSource1Color0 = ... # type: QBlendEquationArguments.Blending
        OneMinusSource1Color = ... # type: QBlendEquationArguments.Blending

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    bufferIndexChanged: typing.ClassVar[QtCore.pyqtSignal]
    destinationRgbaChanged: typing.ClassVar[QtCore.pyqtSignal]
    sourceRgbaChanged: typing.ClassVar[QtCore.pyqtSignal]
    destinationAlphaChanged: typing.ClassVar[QtCore.pyqtSignal]
    destinationRgbChanged: typing.ClassVar[QtCore.pyqtSignal]
    sourceAlphaChanged: typing.ClassVar[QtCore.pyqtSignal]
    sourceRgbChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setBufferIndex(self, index: int) -> None: ...
    def setDestinationRgba(self, destinationRgba: 'QBlendEquationArguments.Blending') -> None: ...
    def setSourceRgba(self, sourceRgba: 'QBlendEquationArguments.Blending') -> None: ...
    def setDestinationAlpha(self, destinationAlpha: 'QBlendEquationArguments.Blending') -> None: ...
    def setSourceAlpha(self, sourceAlpha: 'QBlendEquationArguments.Blending') -> None: ...
    def setDestinationRgb(self, destinationRgb: 'QBlendEquationArguments.Blending') -> None: ...
    def setSourceRgb(self, sourceRgb: 'QBlendEquationArguments.Blending') -> None: ...
    def bufferIndex(self) -> int: ...
    def destinationAlpha(self) -> 'QBlendEquationArguments.Blending': ...
    def sourceAlpha(self) -> 'QBlendEquationArguments.Blending': ...
    def destinationRgb(self) -> 'QBlendEquationArguments.Blending': ...
    def sourceRgb(self) -> 'QBlendEquationArguments.Blending': ...


class QFrameGraphNode(Qt3DCore.QNode):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def parentFrameGraphNode(self) -> 'QFrameGraphNode|None': ...


class QBlitFramebuffer('QFrameGraphNode'):

    class InterpolationMethod(enum.Enum):
        Nearest = ... # type: QBlitFramebuffer.InterpolationMethod
        Linear = ... # type: QBlitFramebuffer.InterpolationMethod

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    interpolationMethodChanged: typing.ClassVar[QtCore.pyqtSignal]
    destinationAttachmentPointChanged: typing.ClassVar[QtCore.pyqtSignal]
    sourceAttachmentPointChanged: typing.ClassVar[QtCore.pyqtSignal]
    destinationRectChanged: typing.ClassVar[QtCore.pyqtSignal]
    sourceRectChanged: typing.ClassVar[QtCore.pyqtSignal]
    destinationChanged: typing.ClassVar[QtCore.pyqtSignal]
    sourceChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setInterpolationMethod(self, interpolationMethod: 'QBlitFramebuffer.InterpolationMethod') -> None: ...
    def setDestinationAttachmentPoint(self, destinationAttachmentPoint: 'QRenderTargetOutput.AttachmentPoint') -> None: ...
    def setSourceAttachmentPoint(self, sourceAttachmentPoint: 'QRenderTargetOutput.AttachmentPoint') -> None: ...
    def setDestinationRect(self, destinationRect: QtCore.QRectF) -> None: ...
    def setSourceRect(self, sourceRect: QtCore.QRectF) -> None: ...
    def setDestination(self, destination: 'QRenderTarget|None') -> None: ...
    def setSource(self, source: 'QRenderTarget|None') -> None: ...
    def interpolationMethod(self) -> 'QBlitFramebuffer.InterpolationMethod': ...
    def destinationAttachmentPoint(self) -> 'QRenderTargetOutput.AttachmentPoint': ...
    def sourceAttachmentPoint(self) -> 'QRenderTargetOutput.AttachmentPoint': ...
    def destinationRect(self) -> QtCore.QRectF: ...
    def sourceRect(self) -> QtCore.QRectF: ...
    def destination(self) -> 'QRenderTarget|None': ...
    def source(self) -> 'QRenderTarget|None': ...


class QCamera(Qt3DCore.QEntity):

    class CameraTranslationOption(enum.Enum):
        TranslateViewCenter = ... # type: QCamera.CameraTranslationOption
        DontTranslateViewCenter = ... # type: QCamera.CameraTranslationOption

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def viewEntity(self, entity: Qt3DCore.QEntity|None) -> None: ...
    def viewSphere(self, center: QtGui.QVector3D, radius: float) -> None: ...
    def viewAll(self) -> None: ...
    exposureChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setExposure(self, exposure: float) -> None: ...
    def exposure(self) -> float: ...
    viewMatrixChanged: typing.ClassVar[QtCore.pyqtSignal]
    viewVectorChanged: typing.ClassVar[QtCore.pyqtSignal]
    viewCenterChanged: typing.ClassVar[QtCore.pyqtSignal]
    upVectorChanged: typing.ClassVar[QtCore.pyqtSignal]
    positionChanged: typing.ClassVar[QtCore.pyqtSignal]
    projectionMatrixChanged: typing.ClassVar[QtCore.pyqtSignal]
    topChanged: typing.ClassVar[QtCore.pyqtSignal]
    bottomChanged: typing.ClassVar[QtCore.pyqtSignal]
    rightChanged: typing.ClassVar[QtCore.pyqtSignal]
    leftChanged: typing.ClassVar[QtCore.pyqtSignal]
    aspectRatioChanged: typing.ClassVar[QtCore.pyqtSignal]
    fieldOfViewChanged: typing.ClassVar[QtCore.pyqtSignal]
    farPlaneChanged: typing.ClassVar[QtCore.pyqtSignal]
    nearPlaneChanged: typing.ClassVar[QtCore.pyqtSignal]
    projectionTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setViewCenter(self, viewCenter: QtGui.QVector3D) -> None: ...
    def setUpVector(self, upVector: QtGui.QVector3D) -> None: ...
    def setPosition(self, position: QtGui.QVector3D) -> None: ...
    def setProjectionMatrix(self, projectionMatrix: QtGui.QMatrix4x4) -> None: ...
    def setTop(self, top: float) -> None: ...
    def setBottom(self, bottom: float) -> None: ...
    def setRight(self, right: float) -> None: ...
    def setLeft(self, left: float) -> None: ...
    def setAspectRatio(self, aspectRatio: float) -> None: ...
    def setFieldOfView(self, fieldOfView: float) -> None: ...
    def setFarPlane(self, farPlane: float) -> None: ...
    def setNearPlane(self, nearPlane: float) -> None: ...
    def setProjectionType(self, type: 'QCameraLens.ProjectionType') -> None: ...
    def viewMatrix(self) -> QtGui.QMatrix4x4: ...
    def viewVector(self) -> QtGui.QVector3D: ...
    def viewCenter(self) -> QtGui.QVector3D: ...
    def upVector(self) -> QtGui.QVector3D: ...
    def position(self) -> QtGui.QVector3D: ...
    def projectionMatrix(self) -> QtGui.QMatrix4x4: ...
    def top(self) -> float: ...
    def bottom(self) -> float: ...
    def right(self) -> float: ...
    def left(self) -> float: ...
    def aspectRatio(self) -> float: ...
    def fieldOfView(self) -> float: ...
    def farPlane(self) -> float: ...
    def nearPlane(self) -> float: ...
    def projectionType(self) -> 'QCameraLens.ProjectionType': ...
    def rotateAboutViewCenter(self, q: QtGui.QQuaternion) -> None: ...
    def rotate(self, q: QtGui.QQuaternion) -> None: ...
    def rollAboutViewCenter(self, angle: float) -> None: ...
    @typing.overload
    def panAboutViewCenter(self, angle: float) -> None: ...
    @typing.overload
    def panAboutViewCenter(self, angle: float, axis: QtGui.QVector3D) -> None: ...
    def tiltAboutViewCenter(self, angle: float) -> None: ...
    def roll(self, angle: float) -> None: ...
    @typing.overload
    def pan(self, angle: float) -> None: ...
    @typing.overload
    def pan(self, angle: float, axis: QtGui.QVector3D) -> None: ...
    def tilt(self, angle: float) -> None: ...
    def translateWorld(self, vWorld: QtGui.QVector3D, option: 'QCamera.CameraTranslationOption' = ...) -> None: ...
    def translate(self, vLocal: QtGui.QVector3D, option: 'QCamera.CameraTranslationOption' = ...) -> None: ...
    def rotation(self, angle: float, axis: QtGui.QVector3D) -> QtGui.QQuaternion: ...
    def rollRotation(self, angle: float) -> QtGui.QQuaternion: ...
    def panRotation(self, angle: float) -> QtGui.QQuaternion: ...
    def tiltRotation(self, angle: float) -> QtGui.QQuaternion: ...
    def transform(self) -> Qt3DCore.QTransform|None: ...
    def lens(self) -> 'QCameraLens|None': ...


class QCameraLens(Qt3DCore.QComponent):

    class ProjectionType(enum.Enum):
        OrthographicProjection = ... # type: QCameraLens.ProjectionType
        PerspectiveProjection = ... # type: QCameraLens.ProjectionType
        FrustumProjection = ... # type: QCameraLens.ProjectionType
        CustomProjection = ... # type: QCameraLens.ProjectionType

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    viewSphere: typing.ClassVar[QtCore.pyqtSignal]
    def viewEntity(self, entityId: Qt3DCore.QNodeId, cameraId: Qt3DCore.QNodeId) -> None: ...
    def viewAll(self, cameraId: Qt3DCore.QNodeId) -> None: ...
    exposureChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setExposure(self, exposure: float) -> None: ...
    def exposure(self) -> float: ...
    projectionMatrixChanged: typing.ClassVar[QtCore.pyqtSignal]
    topChanged: typing.ClassVar[QtCore.pyqtSignal]
    bottomChanged: typing.ClassVar[QtCore.pyqtSignal]
    rightChanged: typing.ClassVar[QtCore.pyqtSignal]
    leftChanged: typing.ClassVar[QtCore.pyqtSignal]
    aspectRatioChanged: typing.ClassVar[QtCore.pyqtSignal]
    fieldOfViewChanged: typing.ClassVar[QtCore.pyqtSignal]
    farPlaneChanged: typing.ClassVar[QtCore.pyqtSignal]
    nearPlaneChanged: typing.ClassVar[QtCore.pyqtSignal]
    projectionTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setProjectionMatrix(self, projectionMatrix: QtGui.QMatrix4x4) -> None: ...
    def setTop(self, top: float) -> None: ...
    def setBottom(self, bottom: float) -> None: ...
    def setRight(self, right: float) -> None: ...
    def setLeft(self, left: float) -> None: ...
    def setAspectRatio(self, aspectRatio: float) -> None: ...
    def setFieldOfView(self, fieldOfView: float) -> None: ...
    def setFarPlane(self, farPlane: float) -> None: ...
    def setNearPlane(self, nearPlane: float) -> None: ...
    def setProjectionType(self, projectionType: 'QCameraLens.ProjectionType') -> None: ...
    def setPerspectiveProjection(self, fieldOfView: float, aspect: float, nearPlane: float, farPlane: float) -> None: ...
    def setFrustumProjection(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
    def setOrthographicProjection(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
    def projectionMatrix(self) -> QtGui.QMatrix4x4: ...
    def top(self) -> float: ...
    def bottom(self) -> float: ...
    def right(self) -> float: ...
    def left(self) -> float: ...
    def aspectRatio(self) -> float: ...
    def fieldOfView(self) -> float: ...
    def farPlane(self) -> float: ...
    def nearPlane(self) -> float: ...
    def projectionType(self) -> 'QCameraLens.ProjectionType': ...


class QCameraSelector('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    cameraChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setCamera(self, camera: Qt3DCore.QEntity|None) -> None: ...
    def camera(self) -> Qt3DCore.QEntity|None: ...


class QClearBuffers('QFrameGraphNode'):

    class BufferType(enum.Enum):
        None_ = ... # type: QClearBuffers.BufferType
        ColorBuffer = ... # type: QClearBuffers.BufferType
        DepthBuffer = ... # type: QClearBuffers.BufferType
        StencilBuffer = ... # type: QClearBuffers.BufferType
        DepthStencilBuffer = ... # type: QClearBuffers.BufferType
        ColorDepthBuffer = ... # type: QClearBuffers.BufferType
        ColorDepthStencilBuffer = ... # type: QClearBuffers.BufferType
        AllBuffers = ... # type: QClearBuffers.BufferType

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    colorBufferChanged: typing.ClassVar[QtCore.pyqtSignal]
    clearStencilValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    clearDepthValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    clearColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    buffersChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setColorBuffer(self, buffer: 'QRenderTargetOutput|None') -> None: ...
    def setClearStencilValue(self, clearStencilValue: int) -> None: ...
    def setClearDepthValue(self, clearDepthValue: float) -> None: ...
    def setClearColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setBuffers(self, buffers: 'QClearBuffers.BufferType') -> None: ...
    def colorBuffer(self) -> 'QRenderTargetOutput|None': ...
    def clearStencilValue(self) -> int: ...
    def clearDepthValue(self) -> float: ...
    def clearColor(self) -> QtGui.QColor: ...
    def buffers(self) -> 'QClearBuffers.BufferType': ...


class QClipPlane('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    distanceChanged: typing.ClassVar[QtCore.pyqtSignal]
    normalChanged: typing.ClassVar[QtCore.pyqtSignal]
    planeIndexChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setDistance(self, a0: float) -> None: ...
    def setNormal(self, a0: QtGui.QVector3D) -> None: ...
    def setPlaneIndex(self, a0: int) -> None: ...
    def distance(self) -> float: ...
    def normal(self) -> QtGui.QVector3D: ...
    def planeIndex(self) -> int: ...


class QComputeCommand(Qt3DCore.QComponent):

    class RunType(enum.Enum):
        Continuous = ... # type: QComputeCommand.RunType
        Manual = ... # type: QComputeCommand.RunType

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    runTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    @typing.overload
    def trigger(self, frameCount: int = ...) -> None: ...
    @typing.overload
    def trigger(self, workGroupX: int, workGroupY: int, workGroupZ: int, frameCount: int = ...) -> None: ...
    def setRunType(self, runType: 'QComputeCommand.RunType') -> None: ...
    def runType(self) -> 'QComputeCommand.RunType': ...
    workGroupZChanged: typing.ClassVar[QtCore.pyqtSignal]
    workGroupYChanged: typing.ClassVar[QtCore.pyqtSignal]
    workGroupXChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setWorkGroupZ(self, workGroupZ: int) -> None: ...
    def setWorkGroupY(self, workGroupY: int) -> None: ...
    def setWorkGroupX(self, workGroupX: int) -> None: ...
    def workGroupZ(self) -> int: ...
    def workGroupY(self) -> int: ...
    def workGroupX(self) -> int: ...


class QColorMask('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    alphaMaskedChanged: typing.ClassVar[QtCore.pyqtSignal]
    blueMaskedChanged: typing.ClassVar[QtCore.pyqtSignal]
    greenMaskedChanged: typing.ClassVar[QtCore.pyqtSignal]
    redMaskedChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setAlphaMasked(self, alphaMasked: bool) -> None: ...
    def setBlueMasked(self, blueMasked: bool) -> None: ...
    def setGreenMasked(self, greenMasked: bool) -> None: ...
    def setRedMasked(self, redMasked: bool) -> None: ...
    def isAlphaMasked(self) -> bool: ...
    def isBlueMasked(self) -> bool: ...
    def isGreenMasked(self) -> bool: ...
    def isRedMasked(self) -> bool: ...


class QCullFace('QRenderState'):

    class CullingMode(enum.Enum):
        NoCulling = ... # type: QCullFace.CullingMode
        Front = ... # type: QCullFace.CullingMode
        Back = ... # type: QCullFace.CullingMode
        FrontAndBack = ... # type: QCullFace.CullingMode

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    modeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setMode(self, mode: 'QCullFace.CullingMode') -> None: ...
    def mode(self) -> 'QCullFace.CullingMode': ...


class QDepthRange('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    farValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    nearValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setFarValue(self, value: float) -> None: ...
    def setNearValue(self, value: float) -> None: ...
    def farValue(self) -> float: ...
    def nearValue(self) -> float: ...


class QDepthTest('QRenderState'):

    class DepthFunction(enum.Enum):
        Never = ... # type: QDepthTest.DepthFunction
        Always = ... # type: QDepthTest.DepthFunction
        Less = ... # type: QDepthTest.DepthFunction
        LessOrEqual = ... # type: QDepthTest.DepthFunction
        Equal = ... # type: QDepthTest.DepthFunction
        GreaterOrEqual = ... # type: QDepthTest.DepthFunction
        Greater = ... # type: QDepthTest.DepthFunction
        NotEqual = ... # type: QDepthTest.DepthFunction

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    depthFunctionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setDepthFunction(self, depthFunction: 'QDepthTest.DepthFunction') -> None: ...
    def depthFunction(self) -> 'QDepthTest.DepthFunction': ...


class QDirectionalLight('QAbstractLight'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    worldDirectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setWorldDirection(self, worldDirection: QtGui.QVector3D) -> None: ...
    def worldDirection(self) -> QtGui.QVector3D: ...


class QDispatchCompute('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    workGroupZChanged: typing.ClassVar[QtCore.pyqtSignal]
    workGroupYChanged: typing.ClassVar[QtCore.pyqtSignal]
    workGroupXChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setWorkGroupZ(self, workGroupZ: int) -> None: ...
    def setWorkGroupY(self, workGroupY: int) -> None: ...
    def setWorkGroupX(self, workGroupX: int) -> None: ...
    def workGroupZ(self) -> int: ...
    def workGroupY(self) -> int: ...
    def workGroupX(self) -> int: ...


class QDithering('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QEffect(Qt3DCore.QNode):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def techniques(self) -> list['QTechnique']: ...
    def removeTechnique(self, t: 'QTechnique|None') -> None: ...
    def addTechnique(self, t: 'QTechnique|None') -> None: ...
    def parameters(self) -> list['QParameter']: ...
    def removeParameter(self, parameter: 'QParameter|None') -> None: ...
    def addParameter(self, parameter: 'QParameter|None') -> None: ...


class QEnvironmentLight(Qt3DCore.QComponent):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    specularChanged: typing.ClassVar[QtCore.pyqtSignal]
    irradianceChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSpecular(self, specular: 'QAbstractTexture|None') -> None: ...
    def setIrradiance(self, irradiance: 'QAbstractTexture|None') -> None: ...
    def specular(self) -> 'QAbstractTexture|None': ...
    def irradiance(self) -> 'QAbstractTexture|None': ...


class QFilterKey(Qt3DCore.QNode):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    valueChanged: typing.ClassVar[QtCore.pyqtSignal]
    nameChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setName(self, customType: str|None) -> None: ...
    def setValue(self, value: typing.Any) -> None: ...
    def name(self) -> str: ...
    def value(self) -> typing.Any: ...


class QFrontFace('QRenderState'):

    class WindingDirection(enum.Enum):
        ClockWise = ... # type: QFrontFace.WindingDirection
        CounterClockWise = ... # type: QFrontFace.WindingDirection

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    directionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setDirection(self, direction: 'QFrontFace.WindingDirection') -> None: ...
    def direction(self) -> 'QFrontFace.WindingDirection': ...


class QFrustumCulling('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QGeometryRenderer(Qt3DCore.QBoundingVolume):

    class PrimitiveType(enum.Enum):
        Points = ... # type: QGeometryRenderer.PrimitiveType
        Lines = ... # type: QGeometryRenderer.PrimitiveType
        LineLoop = ... # type: QGeometryRenderer.PrimitiveType
        LineStrip = ... # type: QGeometryRenderer.PrimitiveType
        Triangles = ... # type: QGeometryRenderer.PrimitiveType
        TriangleStrip = ... # type: QGeometryRenderer.PrimitiveType
        TriangleFan = ... # type: QGeometryRenderer.PrimitiveType
        LinesAdjacency = ... # type: QGeometryRenderer.PrimitiveType
        TrianglesAdjacency = ... # type: QGeometryRenderer.PrimitiveType
        LineStripAdjacency = ... # type: QGeometryRenderer.PrimitiveType
        TriangleStripAdjacency = ... # type: QGeometryRenderer.PrimitiveType
        Patches = ... # type: QGeometryRenderer.PrimitiveType

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    sortIndexChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSortIndex(self, sortIndex: float) -> None: ...
    def sortIndex(self) -> float: ...
    indexBufferByteOffsetChanged: typing.ClassVar[QtCore.pyqtSignal]
    primitiveTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    geometryChanged: typing.ClassVar[QtCore.pyqtSignal]
    primitiveRestartEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    verticesPerPatchChanged: typing.ClassVar[QtCore.pyqtSignal]
    restartIndexValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstVertexChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstInstanceChanged: typing.ClassVar[QtCore.pyqtSignal]
    indexOffsetChanged: typing.ClassVar[QtCore.pyqtSignal]
    vertexCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    instanceCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setIndexBufferByteOffset(self, offset: int) -> None: ...
    def setPrimitiveType(self, primitiveType: 'QGeometryRenderer.PrimitiveType') -> None: ...
    def setGeometry(self, geometry: Qt3DCore.QGeometry|None) -> None: ...
    def setPrimitiveRestartEnabled(self, enabled: bool) -> None: ...
    def setVerticesPerPatch(self, verticesPerPatch: int) -> None: ...
    def setRestartIndexValue(self, index: int) -> None: ...
    def setFirstVertex(self, firstVertex: int) -> None: ...
    def setFirstInstance(self, firstInstance: int) -> None: ...
    def setIndexOffset(self, indexOffset: int) -> None: ...
    def setVertexCount(self, vertexCount: int) -> None: ...
    def setInstanceCount(self, instanceCount: int) -> None: ...
    def indexBufferByteOffset(self) -> int: ...
    def primitiveType(self) -> 'QGeometryRenderer.PrimitiveType': ...
    def geometry(self) -> Qt3DCore.QGeometry|None: ...
    def primitiveRestartEnabled(self) -> bool: ...
    def verticesPerPatch(self) -> int: ...
    def restartIndexValue(self) -> int: ...
    def firstVertex(self) -> int: ...
    def firstInstance(self) -> int: ...
    def indexOffset(self) -> int: ...
    def vertexCount(self) -> int: ...
    def instanceCount(self) -> int: ...


class QGraphicsApiFilter(QtCore.QObject):

    class OpenGLProfile(enum.Enum):
        NoProfile = ... # type: QGraphicsApiFilter.OpenGLProfile
        CoreProfile = ... # type: QGraphicsApiFilter.OpenGLProfile
        CompatibilityProfile = ... # type: QGraphicsApiFilter.OpenGLProfile

    class Api(enum.Enum):
        OpenGLES = ... # type: QGraphicsApiFilter.Api
        OpenGL = ... # type: QGraphicsApiFilter.Api
        Vulkan = ... # type: QGraphicsApiFilter.Api
        DirectX = ... # type: QGraphicsApiFilter.Api
        RHI = ... # type: QGraphicsApiFilter.Api

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    graphicsApiFilterChanged: typing.ClassVar[QtCore.pyqtSignal]
    vendorChanged: typing.ClassVar[QtCore.pyqtSignal]
    extensionsChanged: typing.ClassVar[QtCore.pyqtSignal]
    majorVersionChanged: typing.ClassVar[QtCore.pyqtSignal]
    minorVersionChanged: typing.ClassVar[QtCore.pyqtSignal]
    profileChanged: typing.ClassVar[QtCore.pyqtSignal]
    apiChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setVendor(self, vendor: str|None) -> None: ...
    def setExtensions(self, extensions: collections.abc.Iterable[str|None]) -> None: ...
    def setMajorVersion(self, majorVersion: int) -> None: ...
    def setMinorVersion(self, minorVersion: int) -> None: ...
    def setProfile(self, profile: 'QGraphicsApiFilter.OpenGLProfile') -> None: ...
    def setApi(self, api: 'QGraphicsApiFilter.Api') -> None: ...
    def vendor(self) -> str: ...
    def extensions(self) -> list[str]: ...
    def majorVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    def profile(self) -> 'QGraphicsApiFilter.OpenGLProfile': ...
    def api(self) -> 'QGraphicsApiFilter.Api': ...


class QLayer(Qt3DCore.QComponent):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    recursiveChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setRecursive(self, recursive: bool) -> None: ...
    def recursive(self) -> bool: ...


class QLayerFilter('QFrameGraphNode'):

    class FilterMode(enum.Enum):
        AcceptAnyMatchingLayers = ... # type: QLayerFilter.FilterMode
        AcceptAllMatchingLayers = ... # type: QLayerFilter.FilterMode
        DiscardAnyMatchingLayers = ... # type: QLayerFilter.FilterMode
        DiscardAllMatchingLayers = ... # type: QLayerFilter.FilterMode

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    filterModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setFilterMode(self, filterMode: 'QLayerFilter.FilterMode') -> None: ...
    def filterMode(self) -> 'QLayerFilter.FilterMode': ...
    def layers(self) -> list['QLayer']: ...
    def removeLayer(self, layer: 'QLayer|None') -> None: ...
    def addLayer(self, layer: 'QLayer|None') -> None: ...


class QLevelOfDetail(Qt3DCore.QComponent):

    class ThresholdType(enum.Enum):
        DistanceToCameraThreshold = ... # type: QLevelOfDetail.ThresholdType
        ProjectedScreenPixelSizeThreshold = ... # type: QLevelOfDetail.ThresholdType

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    volumeOverrideChanged: typing.ClassVar[QtCore.pyqtSignal]
    thresholdsChanged: typing.ClassVar[QtCore.pyqtSignal]
    thresholdTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    currentIndexChanged: typing.ClassVar[QtCore.pyqtSignal]
    cameraChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setVolumeOverride(self, volumeOverride: 'QLevelOfDetailBoundingSphere') -> None: ...
    def setThresholds(self, thresholds: collections.abc.Iterable[float]) -> None: ...
    def setThresholdType(self, thresholdType: 'QLevelOfDetail.ThresholdType') -> None: ...
    def setCurrentIndex(self, currentIndex: int) -> None: ...
    def setCamera(self, camera: 'QCamera|None') -> None: ...
    def createBoundingSphere(self, center: QtGui.QVector3D, radius: float) -> 'QLevelOfDetailBoundingSphere': ...
    def volumeOverride(self) -> 'QLevelOfDetailBoundingSphere': ...
    def thresholds(self) -> list[float]: ...
    def thresholdType(self) -> 'QLevelOfDetail.ThresholdType': ...
    def currentIndex(self) -> int: ...
    def camera(self) -> 'QCamera|None': ...


class QLevelOfDetailBoundingSphere(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self, center: QtGui.QVector3D = ..., radius: float = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QLevelOfDetailBoundingSphere') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def isEmpty(self) -> bool: ...
    def radius(self) -> float: ...
    def center(self) -> QtGui.QVector3D: ...


class QLevelOfDetailSwitch('QLevelOfDetail'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QLineWidth('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    smoothChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSmooth(self, enabled: bool) -> None: ...
    def setValue(self, value: float) -> None: ...
    def smooth(self) -> bool: ...
    def value(self) -> float: ...


class QMaterial(Qt3DCore.QComponent):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    effectChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setEffect(self, effect: 'QEffect|None') -> None: ...
    def parameters(self) -> list['QParameter']: ...
    def removeParameter(self, parameter: 'QParameter|None') -> None: ...
    def addParameter(self, parameter: 'QParameter|None') -> None: ...
    def effect(self) -> 'QEffect|None': ...


class QMemoryBarrier('QFrameGraphNode'):

    class Operation(enum.Enum):
        None_ = ... # type: QMemoryBarrier.Operation
        VertexAttributeArray = ... # type: QMemoryBarrier.Operation
        ElementArray = ... # type: QMemoryBarrier.Operation
        Uniform = ... # type: QMemoryBarrier.Operation
        TextureFetch = ... # type: QMemoryBarrier.Operation
        ShaderImageAccess = ... # type: QMemoryBarrier.Operation
        Command = ... # type: QMemoryBarrier.Operation
        PixelBuffer = ... # type: QMemoryBarrier.Operation
        TextureUpdate = ... # type: QMemoryBarrier.Operation
        BufferUpdate = ... # type: QMemoryBarrier.Operation
        FrameBuffer = ... # type: QMemoryBarrier.Operation
        TransformFeedback = ... # type: QMemoryBarrier.Operation
        AtomicCounter = ... # type: QMemoryBarrier.Operation
        ShaderStorage = ... # type: QMemoryBarrier.Operation
        QueryBuffer = ... # type: QMemoryBarrier.Operation
        All = ... # type: QMemoryBarrier.Operation

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    waitOperationsChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setWaitOperations(self, operations: 'QMemoryBarrier.Operation') -> None: ...
    def waitOperations(self) -> 'QMemoryBarrier.Operation': ...


class QMesh('QGeometryRenderer'):

    class Status(enum.Enum):
        None_ = ... # type: QMesh.Status
        Loading = ... # type: QMesh.Status
        Ready = ... # type: QMesh.Status
        Error = ... # type: QMesh.Status

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    statusChanged: typing.ClassVar[QtCore.pyqtSignal]
    def status(self) -> 'QMesh.Status': ...
    meshNameChanged: typing.ClassVar[QtCore.pyqtSignal]
    sourceChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setMeshName(self, meshName: str|None) -> None: ...
    def setSource(self, source: QtCore.QUrl) -> None: ...
    def meshName(self) -> str: ...
    def source(self) -> QtCore.QUrl: ...


class QMultiSampleAntiAliasing('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QNoDepthMask('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QNoDraw('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QNoPicking('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QObjectPicker(Qt3DCore.QComponent):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    priorityChanged: typing.ClassVar[QtCore.pyqtSignal]
    containsMouseChanged: typing.ClassVar[QtCore.pyqtSignal]
    pressedChanged: typing.ClassVar[QtCore.pyqtSignal]
    dragEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    hoverEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    exited: typing.ClassVar[QtCore.pyqtSignal]
    entered: typing.ClassVar[QtCore.pyqtSignal]
    moved: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    def setPriority(self, priority: int) -> None: ...
    def setDragEnabled(self, dragEnabled: bool) -> None: ...
    def setHoverEnabled(self, hoverEnabled: bool) -> None: ...
    def priority(self) -> int: ...
    def isPressed(self) -> bool: ...
    def containsMouse(self) -> bool: ...
    def isDragEnabled(self) -> bool: ...
    def isHoverEnabled(self) -> bool: ...


class QPaintedTextureImage('QAbstractTextureImage'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def paint(self, painter: QtGui.QPainter|None) -> None: ...
    sizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    heightChanged: typing.ClassVar[QtCore.pyqtSignal]
    widthChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSize(self, size: QtCore.QSize) -> None: ...
    def setHeight(self, h: int) -> None: ...
    def setWidth(self, w: int) -> None: ...
    def update(self, rect: QtCore.QRect = ...) -> None: ...
    def size(self) -> QtCore.QSize: ...
    def height(self) -> int: ...
    def width(self) -> int: ...


class QParameter(Qt3DCore.QNode):

    @typing.overload
    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...
    @typing.overload
    def __init__(self, name: str|None, value: typing.Any, parent: Qt3DCore.QNode|None = ...) -> None: ...
    @typing.overload
    def __init__(self, name: str|None, texture: 'QAbstractTexture|None', parent: Qt3DCore.QNode|None = ...) -> None: ...

    nameChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setValue(self, dv: typing.Any) -> None: ...
    def setName(self, name: str|None) -> None: ...
    def value(self) -> typing.Any: ...
    def name(self) -> str: ...


class QPickEvent(QtCore.QObject):

    class Modifiers(enum.Enum):
        NoModifier = ... # type: QPickEvent.Modifiers
        ShiftModifier = ... # type: QPickEvent.Modifiers
        ControlModifier = ... # type: QPickEvent.Modifiers
        AltModifier = ... # type: QPickEvent.Modifiers
        MetaModifier = ... # type: QPickEvent.Modifiers
        KeypadModifier = ... # type: QPickEvent.Modifiers

    class Buttons(enum.Enum):
        LeftButton = ... # type: QPickEvent.Buttons
        RightButton = ... # type: QPickEvent.Buttons
        MiddleButton = ... # type: QPickEvent.Buttons
        BackButton = ... # type: QPickEvent.Buttons
        NoButton = ... # type: QPickEvent.Buttons

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, position: QtCore.QPointF, worldIntersection: QtGui.QVector3D, localIntersection: QtGui.QVector3D, distance: float) -> None: ...
    @typing.overload
    def __init__(self, position: QtCore.QPointF, worldIntersection: QtGui.QVector3D, localIntersection: QtGui.QVector3D, distance: float, button: 'QPickEvent.Buttons', buttons: int, modifiers: int) -> None: ...

    def entity(self) -> Qt3DCore.QEntity|None: ...
    def viewport(self) -> 'QViewport|None': ...
    def modifiers(self) -> int: ...
    def buttons(self) -> int: ...
    def button(self) -> 'QPickEvent.Buttons': ...
    acceptedChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setAccepted(self, accepted: bool) -> None: ...
    def localIntersection(self) -> QtGui.QVector3D: ...
    def worldIntersection(self) -> QtGui.QVector3D: ...
    def distance(self) -> float: ...
    def position(self) -> QtCore.QPointF: ...
    def isAccepted(self) -> bool: ...


class QPickingProxy(Qt3DCore.QBoundingVolume):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QPickingSettings(Qt3DCore.QNode):

    class FaceOrientationPickingMode(enum.Enum):
        FrontFace = ... # type: QPickingSettings.FaceOrientationPickingMode
        BackFace = ... # type: QPickingSettings.FaceOrientationPickingMode
        FrontAndBackFace = ... # type: QPickingSettings.FaceOrientationPickingMode

    class PickResultMode(enum.Enum):
        NearestPick = ... # type: QPickingSettings.PickResultMode
        AllPicks = ... # type: QPickingSettings.PickResultMode
        NearestPriorityPick = ... # type: QPickingSettings.PickResultMode

    class PickMethod(enum.Enum):
        BoundingVolumePicking = ... # type: QPickingSettings.PickMethod
        TrianglePicking = ... # type: QPickingSettings.PickMethod
        LinePicking = ... # type: QPickingSettings.PickMethod
        PointPicking = ... # type: QPickingSettings.PickMethod
        PrimitivePicking = ... # type: QPickingSettings.PickMethod

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    worldSpaceToleranceChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setWorldSpaceTolerance(self, worldSpaceTolerance: float) -> None: ...
    def worldSpaceTolerance(self) -> float: ...
    faceOrientationPickingModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setFaceOrientationPickingMode(self, faceOrientationPickingMode: 'QPickingSettings.FaceOrientationPickingMode') -> None: ...
    def faceOrientationPickingMode(self) -> 'QPickingSettings.FaceOrientationPickingMode': ...
    pickResultModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    pickMethodChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setPickResultMode(self, pickResultMode: 'QPickingSettings.PickResultMode') -> None: ...
    def setPickMethod(self, pickMethod: 'QPickingSettings.PickMethod') -> None: ...
    def pickResultMode(self) -> 'QPickingSettings.PickResultMode': ...
    def pickMethod(self) -> 'QPickingSettings.PickMethod': ...


class QPickLineEvent('QPickEvent'):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, position: QtCore.QPointF, worldIntersection: QtGui.QVector3D, localIntersection: QtGui.QVector3D, distance: float, edgeIndex: int, vertex1Index: int, vertex2Index: int, button: 'QPickEvent.Buttons', buttons: int, modifiers: int) -> None: ...

    def vertex2Index(self) -> int: ...
    def vertex1Index(self) -> int: ...
    def edgeIndex(self) -> int: ...


class QPickPointEvent('QPickEvent'):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, position: QtCore.QPointF, worldIntersection: QtGui.QVector3D, localIntersection: QtGui.QVector3D, distance: float, pointIndex: int, button: 'QPickEvent.Buttons', buttons: int, modifiers: int) -> None: ...

    def pointIndex(self) -> int: ...


class QPickTriangleEvent('QPickEvent'):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, position: QtCore.QPointF, worldIntersection: QtGui.QVector3D, localIntersection: QtGui.QVector3D, distance: float, triangleIndex: int, vertex1Index: int, vertex2Index: int, vertex3Index: int) -> None: ...
    @typing.overload
    def __init__(self, position: QtCore.QPointF, worldIntersection: QtGui.QVector3D, localIntersection: QtGui.QVector3D, distance: float, triangleIndex: int, vertex1Index: int, vertex2Index: int, vertex3Index: int, button: 'QPickEvent.Buttons', buttons: int, modifiers: int, uvw: QtGui.QVector3D) -> None: ...

    def uvw(self) -> QtGui.QVector3D: ...
    def vertex3Index(self) -> int: ...
    def vertex2Index(self) -> int: ...
    def vertex1Index(self) -> int: ...
    def triangleIndex(self) -> int: ...


class QPointLight('QAbstractLight'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    quadraticAttenuationChanged: typing.ClassVar[QtCore.pyqtSignal]
    linearAttenuationChanged: typing.ClassVar[QtCore.pyqtSignal]
    constantAttenuationChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setQuadraticAttenuation(self, value: float) -> None: ...
    def setLinearAttenuation(self, value: float) -> None: ...
    def setConstantAttenuation(self, value: float) -> None: ...
    def quadraticAttenuation(self) -> float: ...
    def linearAttenuation(self) -> float: ...
    def constantAttenuation(self) -> float: ...


class QPointSize('QRenderState'):

    class SizeMode(enum.Enum):
        Fixed = ... # type: QPointSize.SizeMode
        Programmable = ... # type: QPointSize.SizeMode

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    valueChanged: typing.ClassVar[QtCore.pyqtSignal]
    sizeModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setValue(self, value: float) -> None: ...
    def setSizeMode(self, sizeMode: 'QPointSize.SizeMode') -> None: ...
    def value(self) -> float: ...
    def sizeMode(self) -> 'QPointSize.SizeMode': ...


class QPolygonOffset('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    depthStepsChanged: typing.ClassVar[QtCore.pyqtSignal]
    scaleFactorChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setDepthSteps(self, depthSteps: float) -> None: ...
    def setScaleFactor(self, scaleFactor: float) -> None: ...
    def depthSteps(self) -> float: ...
    def scaleFactor(self) -> float: ...


class QProximityFilter('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    distanceThresholdChanged: typing.ClassVar[QtCore.pyqtSignal]
    entityChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setDistanceThreshold(self, distanceThreshold: float) -> None: ...
    def setEntity(self, entity: Qt3DCore.QEntity|None) -> None: ...
    def distanceThreshold(self) -> float: ...
    def entity(self) -> Qt3DCore.QEntity|None: ...


class QRasterMode('QRenderState'):

    class FaceMode(enum.Enum):
        Front = ... # type: QRasterMode.FaceMode
        Back = ... # type: QRasterMode.FaceMode
        FrontAndBack = ... # type: QRasterMode.FaceMode

    class RasterMode(enum.Enum):
        Points = ... # type: QRasterMode.RasterMode
        Lines = ... # type: QRasterMode.RasterMode
        Fill = ... # type: QRasterMode.RasterMode

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    faceModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    rasterModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setFaceMode(self, faceMode: 'QRasterMode.FaceMode') -> None: ...
    def setRasterMode(self, rasterMode: 'QRasterMode.RasterMode') -> None: ...
    def faceMode(self) -> 'QRasterMode.FaceMode': ...
    def rasterMode(self) -> 'QRasterMode.RasterMode': ...


class QRayCaster('QAbstractRayCaster'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    lengthChanged: typing.ClassVar[QtCore.pyqtSignal]
    directionChanged: typing.ClassVar[QtCore.pyqtSignal]
    originChanged: typing.ClassVar[QtCore.pyqtSignal]
    @typing.overload
    def trigger(self) -> None: ...
    @typing.overload
    def trigger(self, origin: QtGui.QVector3D, direction: QtGui.QVector3D, length: float) -> None: ...
    def setLength(self, length: float) -> None: ...
    def setDirection(self, direction: QtGui.QVector3D) -> None: ...
    def setOrigin(self, origin: QtGui.QVector3D) -> None: ...
    def length(self) -> float: ...
    def direction(self) -> QtGui.QVector3D: ...
    def origin(self) -> QtGui.QVector3D: ...


class QRayCasterHit(PyQt6.sip.simplewrapper):

    class HitType(enum.Enum):
        TriangleHit = ... # type: QRayCasterHit.HitType
        LineHit = ... # type: QRayCasterHit.HitType
        PointHit = ... # type: QRayCasterHit.HitType
        EntityHit = ... # type: QRayCasterHit.HitType

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, type: 'QRayCasterHit.HitType', id: Qt3DCore.QNodeId, distance: float, localIntersect: QtGui.QVector3D, worldIntersect: QtGui.QVector3D, primitiveIndex: int, v1: int, v2: int, v3: int) -> None: ...
    @typing.overload
    def __init__(self, other: 'QRayCasterHit') -> None: ...

    def vertex3Index(self) -> int: ...
    def vertex2Index(self) -> int: ...
    def vertex1Index(self) -> int: ...
    def primitiveIndex(self) -> int: ...
    def worldIntersection(self) -> QtGui.QVector3D: ...
    def localIntersection(self) -> QtGui.QVector3D: ...
    def distance(self) -> float: ...
    def entity(self) -> Qt3DCore.QEntity|None: ...
    def entityId(self) -> Qt3DCore.QNodeId: ...
    def type(self) -> 'QRayCasterHit.HitType': ...


class Render(PyQt6.sip.simplewrapper): ...


class QRenderAspect(Qt3DCore.QAbstractAspect):

    class SubmissionType(enum.Enum):
        Automatic = ... # type: QRenderAspect.SubmissionType
        Manual = ... # type: QRenderAspect.SubmissionType

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, submissionType: 'QRenderAspect.SubmissionType', parent: QtCore.QObject|None = ...) -> None: ...


class QRenderCapabilities(QtCore.QObject):

    class Profile(enum.Enum):
        NoProfile = ... # type: QRenderCapabilities.Profile
        CoreProfile = ... # type: QRenderCapabilities.Profile
        CompatibilityProfile = ... # type: QRenderCapabilities.Profile

    class API(enum.Enum):
        OpenGL = ... # type: QRenderCapabilities.API
        OpenGLES = ... # type: QRenderCapabilities.API
        Vulkan = ... # type: QRenderCapabilities.API
        DirectX = ... # type: QRenderCapabilities.API
        RHI = ... # type: QRenderCapabilities.API

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def maxComputeSharedMemorySize(self) -> int: ...
    def maxComputeInvocations(self) -> int: ...
    def maxWorkGroupSizeZ(self) -> int: ...
    def maxWorkGroupSizeY(self) -> int: ...
    def maxWorkGroupSizeX(self) -> int: ...
    def maxWorkGroupCountZ(self) -> int: ...
    def maxWorkGroupCountY(self) -> int: ...
    def maxWorkGroupCountX(self) -> int: ...
    def supportsCompute(self) -> bool: ...
    def maxImageUnits(self) -> int: ...
    def supportsImageStore(self) -> bool: ...
    def maxSSBOBindings(self) -> int: ...
    def maxSSBOSize(self) -> int: ...
    def supportsSSBO(self) -> bool: ...
    def maxUBOBindings(self) -> int: ...
    def maxUBOSize(self) -> int: ...
    def supportsUBO(self) -> bool: ...
    def maxTextureLayers(self) -> int: ...
    def maxTextureUnits(self) -> int: ...
    def maxTextureSize(self) -> int: ...
    def maxSamples(self) -> int: ...
    def glslVersion(self) -> str: ...
    def driverVersion(self) -> str: ...
    def renderer(self) -> str: ...
    def vendor(self) -> str: ...
    def extensions(self) -> list[str]: ...
    def minorVersion(self) -> int: ...
    def majorVersion(self) -> int: ...
    def profile(self) -> 'QRenderCapabilities.Profile': ...
    def api(self) -> 'QRenderCapabilities.API': ...
    def isValid(self) -> bool: ...


class QRenderCaptureReply(QtCore.QObject):

    completed: typing.ClassVar[QtCore.pyqtSignal]
    def saveImage(self, fileName: str|None) -> bool: ...
    def isComplete(self) -> bool: ...
    def image(self) -> QtGui.QImage: ...


class QRenderCapture('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    @typing.overload
    def requestCapture(self, captureId: int) -> 'QRenderCaptureReply|None': ...
    @typing.overload
    def requestCapture(self) -> 'QRenderCaptureReply|None': ...
    @typing.overload
    def requestCapture(self, rect: QtCore.QRect) -> 'QRenderCaptureReply|None': ...


class QRenderPass(Qt3DCore.QNode):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    shaderProgramChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setShaderProgram(self, shaderProgram: 'QShaderProgram|None') -> None: ...
    def parameters(self) -> list['QParameter']: ...
    def removeParameter(self, p: 'QParameter|None') -> None: ...
    def addParameter(self, p: 'QParameter|None') -> None: ...
    def renderStates(self) -> list['QRenderState']: ...
    def removeRenderState(self, state: 'QRenderState|None') -> None: ...
    def addRenderState(self, state: 'QRenderState|None') -> None: ...
    def filterKeys(self) -> list['QFilterKey']: ...
    def removeFilterKey(self, filterKey: 'QFilterKey|None') -> None: ...
    def addFilterKey(self, filterKey: 'QFilterKey|None') -> None: ...
    def shaderProgram(self) -> 'QShaderProgram|None': ...


class QRenderPassFilter('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def parameters(self) -> list['QParameter']: ...
    def removeParameter(self, parameter: 'QParameter|None') -> None: ...
    def addParameter(self, parameter: 'QParameter|None') -> None: ...
    def removeMatch(self, filterKey: 'QFilterKey|None') -> None: ...
    def addMatch(self, filterKey: 'QFilterKey|None') -> None: ...
    def matchAny(self) -> list['QFilterKey']: ...


class QRenderSettings(Qt3DCore.QComponent):

    class RenderPolicy(enum.Enum):
        OnDemand = ... # type: QRenderSettings.RenderPolicy
        Always = ... # type: QRenderSettings.RenderPolicy

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    renderPolicyChanged: typing.ClassVar[QtCore.pyqtSignal]
    activeFrameGraphChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setRenderPolicy(self, renderPolicy: 'QRenderSettings.RenderPolicy') -> None: ...
    def setActiveFrameGraph(self, activeFrameGraph: 'QFrameGraphNode|None') -> None: ...
    def renderCapabilities(self) -> 'QRenderCapabilities|None': ...
    def renderPolicy(self) -> 'QRenderSettings.RenderPolicy': ...
    def activeFrameGraph(self) -> 'QFrameGraphNode|None': ...
    def pickingSettings(self) -> 'QPickingSettings|None': ...


class QRenderStateSet('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def renderStates(self) -> list['QRenderState']: ...
    def removeRenderState(self, state: 'QRenderState|None') -> None: ...
    def addRenderState(self, state: 'QRenderState|None') -> None: ...


class QRenderSurfaceSelector('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    surfacePixelRatioChanged: typing.ClassVar[QtCore.pyqtSignal]
    externalRenderTargetSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    surfaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSurfacePixelRatio(self, ratio: float) -> None: ...
    def setSurface(self, surfaceObject: QtCore.QObject|None) -> None: ...
    def setExternalRenderTargetSize(self, size: QtCore.QSize) -> None: ...
    def surfacePixelRatio(self) -> float: ...
    def externalRenderTargetSize(self) -> QtCore.QSize: ...
    def surface(self) -> QtCore.QObject|None: ...


class QRenderTarget(Qt3DCore.QComponent):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def outputs(self) -> list['QRenderTargetOutput']: ...
    def removeOutput(self, output: 'QRenderTargetOutput|None') -> None: ...
    def addOutput(self, output: 'QRenderTargetOutput|None') -> None: ...


class QRenderTargetOutput(Qt3DCore.QNode):

    class AttachmentPoint(enum.Enum):
        Color0 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color1 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color2 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color3 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color4 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color5 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color6 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color7 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color8 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color9 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color10 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color11 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color12 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color13 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color14 = ... # type: QRenderTargetOutput.AttachmentPoint
        Color15 = ... # type: QRenderTargetOutput.AttachmentPoint
        Depth = ... # type: QRenderTargetOutput.AttachmentPoint
        Stencil = ... # type: QRenderTargetOutput.AttachmentPoint
        DepthStencil = ... # type: QRenderTargetOutput.AttachmentPoint
        Left = ... # type: QRenderTargetOutput.AttachmentPoint
        Right = ... # type: QRenderTargetOutput.AttachmentPoint

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    faceChanged: typing.ClassVar[QtCore.pyqtSignal]
    layerChanged: typing.ClassVar[QtCore.pyqtSignal]
    mipLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureChanged: typing.ClassVar[QtCore.pyqtSignal]
    attachmentPointChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setFace(self, face: 'QAbstractTexture.CubeMapFace') -> None: ...
    def setLayer(self, layer: int) -> None: ...
    def setMipLevel(self, level: int) -> None: ...
    def setTexture(self, texture: 'QAbstractTexture|None') -> None: ...
    def setAttachmentPoint(self, attachmentPoint: 'QRenderTargetOutput.AttachmentPoint') -> None: ...
    def face(self) -> 'QAbstractTexture.CubeMapFace': ...
    def layer(self) -> int: ...
    def mipLevel(self) -> int: ...
    def texture(self) -> 'QAbstractTexture|None': ...
    def attachmentPoint(self) -> 'QRenderTargetOutput.AttachmentPoint': ...


class QRenderTargetSelector('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    targetChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setTarget(self, target: 'QRenderTarget|None') -> None: ...
    def target(self) -> 'QRenderTarget|None': ...


class QSceneLoader(Qt3DCore.QComponent):

    class ComponentType(enum.Enum):
        UnknownComponent = ... # type: QSceneLoader.ComponentType
        GeometryRendererComponent = ... # type: QSceneLoader.ComponentType
        TransformComponent = ... # type: QSceneLoader.ComponentType
        MaterialComponent = ... # type: QSceneLoader.ComponentType
        LightComponent = ... # type: QSceneLoader.ComponentType
        CameraLensComponent = ... # type: QSceneLoader.ComponentType

    class Status(enum.Enum):
        None_ = ... # type: QSceneLoader.Status
        Loading = ... # type: QSceneLoader.Status
        Ready = ... # type: QSceneLoader.Status
        Error = ... # type: QSceneLoader.Status

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def component(self, entityName: str|None, componentType: 'QSceneLoader.ComponentType') -> Qt3DCore.QComponent|None: ...
    def entityNames(self) -> list[str]: ...
    def entity(self, entityName: str|None) -> Qt3DCore.QEntity|None: ...
    statusChanged: typing.ClassVar[QtCore.pyqtSignal]
    sourceChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSource(self, arg: QtCore.QUrl) -> None: ...
    def status(self) -> 'QSceneLoader.Status': ...
    def source(self) -> QtCore.QUrl: ...


class QScissorTest('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    heightChanged: typing.ClassVar[QtCore.pyqtSignal]
    widthChanged: typing.ClassVar[QtCore.pyqtSignal]
    bottomChanged: typing.ClassVar[QtCore.pyqtSignal]
    leftChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setHeight(self, height: int) -> None: ...
    def setWidth(self, width: int) -> None: ...
    def setBottom(self, bottom: int) -> None: ...
    def setLeft(self, left: int) -> None: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def bottom(self) -> int: ...
    def left(self) -> int: ...


class QScreenRayCaster('QAbstractRayCaster'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    positionChanged: typing.ClassVar[QtCore.pyqtSignal]
    @typing.overload
    def trigger(self) -> None: ...
    @typing.overload
    def trigger(self, position: QtCore.QPoint) -> None: ...
    def setPosition(self, position: QtCore.QPoint) -> None: ...
    def position(self) -> QtCore.QPoint: ...


class QSeamlessCubemap('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QSetFence('QFrameGraphNode'):

    class HandleType(enum.Enum):
        NoHandle = ... # type: QSetFence.HandleType
        OpenGLFenceId = ... # type: QSetFence.HandleType

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    handleChanged: typing.ClassVar[QtCore.pyqtSignal]
    handleTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def handle(self) -> typing.Any: ...
    def handleType(self) -> 'QSetFence.HandleType': ...


class PropertyReaderInterface(PyQt6.sip.simplewrapper):

    def readProperty(self, v: typing.Any) -> typing.Any: ...


class QShaderData(Qt3DCore.QComponent):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def event(self, event: QtCore.QEvent|None) -> bool: ...
    def propertyReader(self) -> 'PropertyReaderInterface': ...


class QShaderImage(Qt3DCore.QNode):

    class ImageFormat(enum.Enum):
        NoFormat = ... # type: QShaderImage.ImageFormat
        Automatic = ... # type: QShaderImage.ImageFormat
        R8_UNorm = ... # type: QShaderImage.ImageFormat
        RG8_UNorm = ... # type: QShaderImage.ImageFormat
        RGBA8_UNorm = ... # type: QShaderImage.ImageFormat
        R16_UNorm = ... # type: QShaderImage.ImageFormat
        RG16_UNorm = ... # type: QShaderImage.ImageFormat
        RGBA16_UNorm = ... # type: QShaderImage.ImageFormat
        R8_SNorm = ... # type: QShaderImage.ImageFormat
        RG8_SNorm = ... # type: QShaderImage.ImageFormat
        RGBA8_SNorm = ... # type: QShaderImage.ImageFormat
        R16_SNorm = ... # type: QShaderImage.ImageFormat
        RG16_SNorm = ... # type: QShaderImage.ImageFormat
        RGBA16_SNorm = ... # type: QShaderImage.ImageFormat
        R8U = ... # type: QShaderImage.ImageFormat
        RG8U = ... # type: QShaderImage.ImageFormat
        RGBA8U = ... # type: QShaderImage.ImageFormat
        R16U = ... # type: QShaderImage.ImageFormat
        RG16U = ... # type: QShaderImage.ImageFormat
        RGBA16U = ... # type: QShaderImage.ImageFormat
        R32U = ... # type: QShaderImage.ImageFormat
        RG32U = ... # type: QShaderImage.ImageFormat
        RGBA32U = ... # type: QShaderImage.ImageFormat
        R8I = ... # type: QShaderImage.ImageFormat
        RG8I = ... # type: QShaderImage.ImageFormat
        RGBA8I = ... # type: QShaderImage.ImageFormat
        R16I = ... # type: QShaderImage.ImageFormat
        RG16I = ... # type: QShaderImage.ImageFormat
        RGBA16I = ... # type: QShaderImage.ImageFormat
        R32I = ... # type: QShaderImage.ImageFormat
        RG32I = ... # type: QShaderImage.ImageFormat
        RGBA32I = ... # type: QShaderImage.ImageFormat
        R16F = ... # type: QShaderImage.ImageFormat
        RG16F = ... # type: QShaderImage.ImageFormat
        RGBA16F = ... # type: QShaderImage.ImageFormat
        R32F = ... # type: QShaderImage.ImageFormat
        RG32F = ... # type: QShaderImage.ImageFormat
        RGBA32F = ... # type: QShaderImage.ImageFormat
        RG11B10F = ... # type: QShaderImage.ImageFormat
        RGB10A2 = ... # type: QShaderImage.ImageFormat
        RGB10A2U = ... # type: QShaderImage.ImageFormat

    class Access(enum.Enum):
        ReadOnly = ... # type: QShaderImage.Access
        WriteOnly = ... # type: QShaderImage.Access
        ReadWrite = ... # type: QShaderImage.Access

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    formatChanged: typing.ClassVar[QtCore.pyqtSignal]
    accessChanged: typing.ClassVar[QtCore.pyqtSignal]
    layerChanged: typing.ClassVar[QtCore.pyqtSignal]
    mipLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    layeredChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setFormat(self, format: 'QShaderImage.ImageFormat') -> None: ...
    def setAccess(self, access: 'QShaderImage.Access') -> None: ...
    def setLayer(self, layer: int) -> None: ...
    def setMipLevel(self, mipLevel: int) -> None: ...
    def setLayered(self, layered: bool) -> None: ...
    def setTexture(self, texture: 'QAbstractTexture|None') -> None: ...
    def format(self) -> 'QShaderImage.ImageFormat': ...
    def access(self) -> 'QShaderImage.Access': ...
    def layer(self) -> int: ...
    def mipLevel(self) -> int: ...
    def layered(self) -> bool: ...
    def texture(self) -> 'QAbstractTexture|None': ...


class QShaderProgram(Qt3DCore.QNode):

    class Format(enum.Enum):
        GLSL = ... # type: QShaderProgram.Format
        SPIRV = ... # type: QShaderProgram.Format

    class Status(enum.Enum):
        NotReady = ... # type: QShaderProgram.Status
        Ready = ... # type: QShaderProgram.Status
        Error = ... # type: QShaderProgram.Status

    class ShaderType(enum.Enum):
        Vertex = ... # type: QShaderProgram.ShaderType
        Fragment = ... # type: QShaderProgram.ShaderType
        TessellationControl = ... # type: QShaderProgram.ShaderType
        TessellationEvaluation = ... # type: QShaderProgram.ShaderType
        Geometry = ... # type: QShaderProgram.ShaderType
        Compute = ... # type: QShaderProgram.ShaderType

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    formatChanged: typing.ClassVar[QtCore.pyqtSignal]
    def format(self) -> 'QShaderProgram.Format': ...
    def setFormat(self, format: 'QShaderProgram.Format') -> None: ...
    statusChanged: typing.ClassVar[QtCore.pyqtSignal]
    logChanged: typing.ClassVar[QtCore.pyqtSignal]
    def status(self) -> 'QShaderProgram.Status': ...
    def log(self) -> str: ...
    computeShaderCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    fragmentShaderCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    geometryShaderCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    tessellationEvaluationShaderCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    tessellationControlShaderCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    vertexShaderCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setComputeShaderCode(self, computeShaderCode: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def setFragmentShaderCode(self, fragmentShaderCode: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def setGeometryShaderCode(self, geometryShaderCode: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def setTessellationEvaluationShaderCode(self, tessellationEvaluationShaderCode: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def setTessellationControlShaderCode(self, tessellationControlShaderCode: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def setVertexShaderCode(self, vertexShaderCode: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    @staticmethod
    def loadSource(sourceUrl: QtCore.QUrl) -> QtCore.QByteArray: ...
    def shaderCode(self, type: 'QShaderProgram.ShaderType') -> QtCore.QByteArray: ...
    def setShaderCode(self, type: 'QShaderProgram.ShaderType', shaderCode: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def computeShaderCode(self) -> QtCore.QByteArray: ...
    def fragmentShaderCode(self) -> QtCore.QByteArray: ...
    def geometryShaderCode(self) -> QtCore.QByteArray: ...
    def tessellationEvaluationShaderCode(self) -> QtCore.QByteArray: ...
    def tessellationControlShaderCode(self) -> QtCore.QByteArray: ...
    def vertexShaderCode(self) -> QtCore.QByteArray: ...


class QShaderProgramBuilder(Qt3DCore.QNode):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    computeShaderCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    fragmentShaderCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    geometryShaderCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    tessellationEvaluationShaderCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    tessellationControlShaderCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    vertexShaderCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def computeShaderCode(self) -> QtCore.QByteArray: ...
    def fragmentShaderCode(self) -> QtCore.QByteArray: ...
    def geometryShaderCode(self) -> QtCore.QByteArray: ...
    def tessellationEvaluationShaderCode(self) -> QtCore.QByteArray: ...
    def tessellationControlShaderCode(self) -> QtCore.QByteArray: ...
    def vertexShaderCode(self) -> QtCore.QByteArray: ...
    computeShaderGraphChanged: typing.ClassVar[QtCore.pyqtSignal]
    fragmentShaderGraphChanged: typing.ClassVar[QtCore.pyqtSignal]
    geometryShaderGraphChanged: typing.ClassVar[QtCore.pyqtSignal]
    tessellationEvaluationShaderGraphChanged: typing.ClassVar[QtCore.pyqtSignal]
    tessellationControlShaderGraphChanged: typing.ClassVar[QtCore.pyqtSignal]
    vertexShaderGraphChanged: typing.ClassVar[QtCore.pyqtSignal]
    enabledLayersChanged: typing.ClassVar[QtCore.pyqtSignal]
    shaderProgramChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setComputeShaderGraph(self, computeShaderGraph: QtCore.QUrl) -> None: ...
    def setFragmentShaderGraph(self, fragmentShaderGraph: QtCore.QUrl) -> None: ...
    def setGeometryShaderGraph(self, geometryShaderGraph: QtCore.QUrl) -> None: ...
    def setTessellationEvaluationShaderGraph(self, tessellationEvaluationShaderGraph: QtCore.QUrl) -> None: ...
    def setTessellationControlShaderGraph(self, tessellationControlShaderGraph: QtCore.QUrl) -> None: ...
    def setVertexShaderGraph(self, vertexShaderGraph: QtCore.QUrl) -> None: ...
    def setEnabledLayers(self, layers: collections.abc.Iterable[str|None]) -> None: ...
    def setShaderProgram(self, program: 'QShaderProgram|None') -> None: ...
    def computeShaderGraph(self) -> QtCore.QUrl: ...
    def fragmentShaderGraph(self) -> QtCore.QUrl: ...
    def geometryShaderGraph(self) -> QtCore.QUrl: ...
    def tessellationEvaluationShaderGraph(self) -> QtCore.QUrl: ...
    def tessellationControlShaderGraph(self) -> QtCore.QUrl: ...
    def vertexShaderGraph(self) -> QtCore.QUrl: ...
    def enabledLayers(self) -> list[str]: ...
    def shaderProgram(self) -> 'QShaderProgram|None': ...


class QSortPolicy('QFrameGraphNode'):

    class SortType(enum.Enum):
        StateChangeCost = ... # type: QSortPolicy.SortType
        BackToFront = ... # type: QSortPolicy.SortType
        Material = ... # type: QSortPolicy.SortType
        FrontToBack = ... # type: QSortPolicy.SortType
        Texture = ... # type: QSortPolicy.SortType
        Uniform = ... # type: QSortPolicy.SortType

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    sortTypesChanged: typing.ClassVar[QtCore.pyqtSignal]
    @typing.overload
    def setSortTypes(self, sortTypes: collections.abc.Iterable[QSortPolicy.SortType]) -> None: ...
    @typing.overload
    def setSortTypes(self, sortTypesInt: collections.abc.Iterable[int]) -> None: ...
    def sortTypesInt(self) -> list[int]: ...
    def sortTypes(self) -> list[QSortPolicy.SortType]: ...


class QSpotLight('QAbstractLight'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    cutOffAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    localDirectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    quadraticAttenuationChanged: typing.ClassVar[QtCore.pyqtSignal]
    linearAttenuationChanged: typing.ClassVar[QtCore.pyqtSignal]
    constantAttenuationChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setCutOffAngle(self, cutOffAngle: float) -> None: ...
    def setLocalDirection(self, localDirection: QtGui.QVector3D) -> None: ...
    def setQuadraticAttenuation(self, value: float) -> None: ...
    def setLinearAttenuation(self, value: float) -> None: ...
    def setConstantAttenuation(self, value: float) -> None: ...
    def quadraticAttenuation(self) -> float: ...
    def linearAttenuation(self) -> float: ...
    def constantAttenuation(self) -> float: ...
    def cutOffAngle(self) -> float: ...
    def localDirection(self) -> QtGui.QVector3D: ...


class QStencilMask('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    backOutputMaskChanged: typing.ClassVar[QtCore.pyqtSignal]
    frontOutputMaskChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setBackOutputMask(self, backOutputMask: int) -> None: ...
    def setFrontOutputMask(self, frontOutputMask: int) -> None: ...
    def backOutputMask(self) -> int: ...
    def frontOutputMask(self) -> int: ...


class QStencilOperation('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def back(self) -> 'QStencilOperationArguments|None': ...
    def front(self) -> 'QStencilOperationArguments|None': ...


class QStencilOperationArguments(QtCore.QObject):

    class Operation(enum.Enum):
        Zero = ... # type: QStencilOperationArguments.Operation
        Keep = ... # type: QStencilOperationArguments.Operation
        Replace = ... # type: QStencilOperationArguments.Operation
        Increment = ... # type: QStencilOperationArguments.Operation
        Decrement = ... # type: QStencilOperationArguments.Operation
        IncrementWrap = ... # type: QStencilOperationArguments.Operation
        DecrementWrap = ... # type: QStencilOperationArguments.Operation
        Invert = ... # type: QStencilOperationArguments.Operation

    class FaceMode(enum.Enum):
        Front = ... # type: QStencilOperationArguments.FaceMode
        Back = ... # type: QStencilOperationArguments.FaceMode
        FrontAndBack = ... # type: QStencilOperationArguments.FaceMode

    faceModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    allTestsPassOperationChanged: typing.ClassVar[QtCore.pyqtSignal]
    depthTestFailureOperationChanged: typing.ClassVar[QtCore.pyqtSignal]
    stencilTestFailureOperationChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setAllTestsPassOperation(self, operation: 'QStencilOperationArguments.Operation') -> None: ...
    def setDepthTestFailureOperation(self, operation: 'QStencilOperationArguments.Operation') -> None: ...
    def setStencilTestFailureOperation(self, operation: 'QStencilOperationArguments.Operation') -> None: ...
    def allTestsPassOperation(self) -> 'QStencilOperationArguments.Operation': ...
    def depthTestFailureOperation(self) -> 'QStencilOperationArguments.Operation': ...
    def stencilTestFailureOperation(self) -> 'QStencilOperationArguments.Operation': ...
    def faceMode(self) -> 'QStencilOperationArguments.FaceMode': ...


class QStencilTest('QRenderState'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def back(self) -> 'QStencilTestArguments|None': ...
    def front(self) -> 'QStencilTestArguments|None': ...


class QStencilTestArguments(QtCore.QObject):

    class StencilFunction(enum.Enum):
        Never = ... # type: QStencilTestArguments.StencilFunction
        Always = ... # type: QStencilTestArguments.StencilFunction
        Less = ... # type: QStencilTestArguments.StencilFunction
        LessOrEqual = ... # type: QStencilTestArguments.StencilFunction
        Equal = ... # type: QStencilTestArguments.StencilFunction
        GreaterOrEqual = ... # type: QStencilTestArguments.StencilFunction
        Greater = ... # type: QStencilTestArguments.StencilFunction
        NotEqual = ... # type: QStencilTestArguments.StencilFunction

    class StencilFaceMode(enum.Enum):
        Front = ... # type: QStencilTestArguments.StencilFaceMode
        Back = ... # type: QStencilTestArguments.StencilFaceMode
        FrontAndBack = ... # type: QStencilTestArguments.StencilFaceMode

    faceModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    referenceValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    stencilFunctionChanged: typing.ClassVar[QtCore.pyqtSignal]
    comparisonMaskChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setStencilFunction(self, stencilFunction: 'QStencilTestArguments.StencilFunction') -> None: ...
    def setReferenceValue(self, referenceValue: int) -> None: ...
    def setComparisonMask(self, comparisonMask: int) -> None: ...
    def faceMode(self) -> 'QStencilTestArguments.StencilFaceMode': ...
    def stencilFunction(self) -> 'QStencilTestArguments.StencilFunction': ...
    def referenceValue(self) -> int: ...
    def comparisonMask(self) -> int: ...


class QSubtreeEnabler('QFrameGraphNode'):

    class Enablement(enum.Enum):
        Persistent = ... # type: QSubtreeEnabler.Enablement
        SingleShot = ... # type: QSubtreeEnabler.Enablement

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    enablementChanged: typing.ClassVar[QtCore.pyqtSignal]
    def requestUpdate(self) -> None: ...
    def setEnablement(self, enablement: 'QSubtreeEnabler.Enablement') -> None: ...
    def enablement(self) -> 'QSubtreeEnabler.Enablement': ...


class QTechnique(Qt3DCore.QNode):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def graphicsApiFilter(self) -> 'QGraphicsApiFilter|None': ...
    def renderPasses(self) -> list['QRenderPass']: ...
    def removeRenderPass(self, pass_: 'QRenderPass|None') -> None: ...
    def addRenderPass(self, pass_: 'QRenderPass|None') -> None: ...
    def parameters(self) -> list['QParameter']: ...
    def removeParameter(self, p: 'QParameter|None') -> None: ...
    def addParameter(self, p: 'QParameter|None') -> None: ...
    def filterKeys(self) -> list['QFilterKey']: ...
    def removeFilterKey(self, filterKey: 'QFilterKey|None') -> None: ...
    def addFilterKey(self, filterKey: 'QFilterKey|None') -> None: ...


class QTechniqueFilter('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    def parameters(self) -> list['QParameter']: ...
    def removeParameter(self, p: 'QParameter|None') -> None: ...
    def addParameter(self, p: 'QParameter|None') -> None: ...
    def removeMatch(self, filterKey: 'QFilterKey|None') -> None: ...
    def addMatch(self, filterKey: 'QFilterKey|None') -> None: ...
    def matchAll(self) -> list['QFilterKey']: ...


class QTexture1D('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QTexture1DArray('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QTexture2D('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QTexture2DArray('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QTexture3D('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QTextureCubeMap('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QTextureCubeMapArray('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QTexture2DMultisample('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QTexture2DMultisampleArray('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QTextureRectangle('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QTextureBuffer('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...


class QTextureLoader('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    mirroredChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setMirrored(self, mirrored: bool) -> None: ...
    def isMirrored(self) -> bool: ...
    sourceChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSource(self, source: QtCore.QUrl) -> None: ...
    def source(self) -> QtCore.QUrl: ...


class QSharedGLTexture('QAbstractTexture'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    textureIdChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setTextureId(self, id: int) -> None: ...
    def textureId(self) -> int: ...


class QTextureData(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextureData') -> None: ...

    def addImageData(self, imageData: 'QTextureImageData') -> None: ...
    def imageData(self) -> list[QTextureImageData]: ...
    def setComparisonMode(self, comparisonMode: 'QAbstractTexture.ComparisonMode') -> None: ...
    def comparisonMode(self) -> 'QAbstractTexture.ComparisonMode': ...
    def setComparisonFunction(self, comparisonFunction: 'QAbstractTexture.ComparisonFunction') -> None: ...
    def comparisonFunction(self) -> 'QAbstractTexture.ComparisonFunction': ...
    def setWrapModeZ(self, wrapModeZ: 'QTextureWrapMode.WrapMode') -> None: ...
    def wrapModeZ(self) -> 'QTextureWrapMode.WrapMode': ...
    def setWrapModeY(self, wrapModeY: 'QTextureWrapMode.WrapMode') -> None: ...
    def wrapModeY(self) -> 'QTextureWrapMode.WrapMode': ...
    def setWrapModeX(self, wrapModeX: 'QTextureWrapMode.WrapMode') -> None: ...
    def wrapModeX(self) -> 'QTextureWrapMode.WrapMode': ...
    def setMagnificationFilter(self, filter: 'QAbstractTexture.Filter') -> None: ...
    def magnificationFilter(self) -> 'QAbstractTexture.Filter': ...
    def setMinificationFilter(self, filter: 'QAbstractTexture.Filter') -> None: ...
    def minificationFilter(self) -> 'QAbstractTexture.Filter': ...
    def setMaximumAnisotropy(self, maximumAnisotropy: float) -> None: ...
    def maximumAnisotropy(self) -> float: ...
    def setAutoMipMapGenerationEnabled(self, isAutoMipMapGenerationEnabled: bool) -> None: ...
    def isAutoMipMapGenerationEnabled(self) -> bool: ...
    def setLayers(self, layers: int) -> None: ...
    def layers(self) -> int: ...
    def setDepth(self, depth: int) -> None: ...
    def depth(self) -> int: ...
    def setHeight(self, height: int) -> None: ...
    def height(self) -> int: ...
    def setWidth(self, width: int) -> None: ...
    def width(self) -> int: ...
    def setFormat(self, a0: 'QAbstractTexture.TextureFormat') -> None: ...
    def format(self) -> 'QAbstractTexture.TextureFormat': ...
    def setTarget(self, target: 'QAbstractTexture.Target') -> None: ...
    def target(self) -> 'QAbstractTexture.Target': ...


class QTextureDataUpdate(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QTextureDataUpdate') -> None: ...

    def __eq__(self, other: object): ...
    def __ne__(self, other: object): ...
    def setData(self, data: 'QTextureImageData') -> None: ...
    def setFace(self, face: 'QAbstractTexture.CubeMapFace') -> None: ...
    def setMipLevel(self, mipLevel: int) -> None: ...
    def setLayer(self, layer: int) -> None: ...
    def setZ(self, z: int) -> None: ...
    def setY(self, y: int) -> None: ...
    def setX(self, x: int) -> None: ...
    def data(self) -> 'QTextureImageData': ...
    def face(self) -> 'QAbstractTexture.CubeMapFace': ...
    def mipLevel(self) -> int: ...
    def layer(self) -> int: ...
    def z(self) -> int: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def swap(self, other: 'QTextureDataUpdate') -> None: ...


class QTextureImage('QAbstractTextureImage'):

    class Status(enum.Enum):
        None_ = ... # type: QTextureImage.Status
        Loading = ... # type: QTextureImage.Status
        Ready = ... # type: QTextureImage.Status
        Error = ... # type: QTextureImage.Status

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    mirroredChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setMirrored(self, mirrored: bool) -> None: ...
    def isMirrored(self) -> bool: ...
    def setStatus(self, status: 'QTextureImage.Status') -> None: ...
    statusChanged: typing.ClassVar[QtCore.pyqtSignal]
    sourceChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSource(self, source: QtCore.QUrl) -> None: ...
    def status(self) -> 'QTextureImage.Status': ...
    def source(self) -> QtCore.QUrl: ...


class QTextureImageData(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextureImageData') -> None: ...

    def setAlignment(self, alignment: int) -> None: ...
    def alignment(self) -> int: ...
    def data(self, layer: int = ..., face: int = ..., mipmapLevel: int = ...) -> QtCore.QByteArray: ...
    def setData(self, data: QtCore.QByteArray|bytes|bytearray|memoryview, blockSize: int, isCompressed: bool = ...) -> None: ...
    def setImage(self, a0: QtGui.QImage) -> None: ...
    def setPixelType(self, pixelType: QtOpenGL.QOpenGLTexture.PixelType) -> None: ...
    def setPixelFormat(self, pixelFormat: QtOpenGL.QOpenGLTexture.PixelFormat) -> None: ...
    def setFormat(self, format: QtOpenGL.QOpenGLTexture.TextureFormat) -> None: ...
    def setTarget(self, target: QtOpenGL.QOpenGLTexture.Target) -> None: ...
    def pixelType(self) -> QtOpenGL.QOpenGLTexture.PixelType: ...
    def pixelFormat(self) -> QtOpenGL.QOpenGLTexture.PixelFormat: ...
    def format(self) -> QtOpenGL.QOpenGLTexture.TextureFormat: ...
    def target(self) -> QtOpenGL.QOpenGLTexture.Target: ...
    def setFaces(self, faces: int) -> None: ...
    def setMipLevels(self, mipLevels: int) -> None: ...
    def setLayers(self, layers: int) -> None: ...
    def setDepth(self, depth: int) -> None: ...
    def setHeight(self, height: int) -> None: ...
    def setWidth(self, width: int) -> None: ...
    def faces(self) -> int: ...
    def mipLevels(self) -> int: ...
    def layers(self) -> int: ...
    def depth(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def isCompressed(self) -> bool: ...
    def cleanup(self) -> None: ...


class QTextureImageDataGenerator(Qt3DCore.QAbstractFunctor):

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def __call__(self) -> 'QTextureImageData': ...


class QTextureWrapMode(QtCore.QObject):

    class WrapMode(enum.Enum):
        Repeat = ... # type: QTextureWrapMode.WrapMode
        MirroredRepeat = ... # type: QTextureWrapMode.WrapMode
        ClampToEdge = ... # type: QTextureWrapMode.WrapMode
        ClampToBorder = ... # type: QTextureWrapMode.WrapMode

    @typing.overload
    def __init__(self, wrapMode: 'QTextureWrapMode.WrapMode' = ..., parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, x: 'QTextureWrapMode.WrapMode', y: 'QTextureWrapMode.WrapMode', z: 'QTextureWrapMode.WrapMode', parent: QtCore.QObject|None = ...) -> None: ...

    zChanged: typing.ClassVar[QtCore.pyqtSignal]
    yChanged: typing.ClassVar[QtCore.pyqtSignal]
    xChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setZ(self, z: 'QTextureWrapMode.WrapMode') -> None: ...
    def setY(self, y: 'QTextureWrapMode.WrapMode') -> None: ...
    def setX(self, x: 'QTextureWrapMode.WrapMode') -> None: ...
    def z(self) -> 'QTextureWrapMode.WrapMode': ...
    def y(self) -> 'QTextureWrapMode.WrapMode': ...
    def x(self) -> 'QTextureWrapMode.WrapMode': ...


class QViewport('QFrameGraphNode'):

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    gammaChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setGamma(self, gamma: float) -> None: ...
    def gamma(self) -> float: ...
    normalizedRectChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setNormalizedRect(self, normalizedRect: QtCore.QRectF) -> None: ...
    def normalizedRect(self) -> QtCore.QRectF: ...


class QWaitFence('QFrameGraphNode'):

    class HandleType(enum.Enum):
        NoHandle = ... # type: QWaitFence.HandleType
        OpenGLFenceId = ... # type: QWaitFence.HandleType

    def __init__(self, parent: Qt3DCore.QNode|None = ...) -> None: ...

    handleChanged: typing.ClassVar[QtCore.pyqtSignal]
    handleTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    timeoutChanged: typing.ClassVar[QtCore.pyqtSignal]
    waitOnCPUChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setTimeout(self, timeout: int) -> None: ...
    def timeout(self) -> int: ...
    def setWaitOnCPU(self, waitOnCPU: bool) -> None: ...
    def waitOnCPU(self) -> bool: ...
    def handle(self) -> typing.Any: ...
    def handleType(self) -> 'QWaitFence.HandleType': ...
    def setHandle(self, handle: typing.Any) -> None: ...
    def setHandleType(self, type: 'QWaitFence.HandleType') -> None: ...
