# The PEP 484 type hints stub file for the QtWebEngineCore module.
#
# Generated by SIP 6.15.1.dev0+g7378531ef.d20251220
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6-WebEngine.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtGui
from PyQt6 import QtNetwork
from PyQt6 import QtWebChannel

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class QWebEngineCertificateError(PyQt6.sip.simplewrapper):

    class Type(enum.Enum):
        Ok = ... # type: QWebEngineCertificateError.Type
        SslPinnedKeyNotInCertificateChain = ... # type: QWebEngineCertificateError.Type
        CertificateCommonNameInvalid = ... # type: QWebEngineCertificateError.Type
        CertificateDateInvalid = ... # type: QWebEngineCertificateError.Type
        CertificateAuthorityInvalid = ... # type: QWebEngineCertificateError.Type
        CertificateContainsErrors = ... # type: QWebEngineCertificateError.Type
        CertificateNoRevocationMechanism = ... # type: QWebEngineCertificateError.Type
        CertificateUnableToCheckRevocation = ... # type: QWebEngineCertificateError.Type
        CertificateRevoked = ... # type: QWebEngineCertificateError.Type
        CertificateInvalid = ... # type: QWebEngineCertificateError.Type
        CertificateWeakSignatureAlgorithm = ... # type: QWebEngineCertificateError.Type
        CertificateNonUniqueName = ... # type: QWebEngineCertificateError.Type
        CertificateWeakKey = ... # type: QWebEngineCertificateError.Type
        CertificateNameConstraintViolation = ... # type: QWebEngineCertificateError.Type
        CertificateValidityTooLong = ... # type: QWebEngineCertificateError.Type
        CertificateTransparencyRequired = ... # type: QWebEngineCertificateError.Type
        CertificateSymantecLegacy = ... # type: QWebEngineCertificateError.Type
        CertificateKnownInterceptionBlocked = ... # type: QWebEngineCertificateError.Type
        SslObsoleteVersion = ... # type: QWebEngineCertificateError.Type

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QWebEngineCertificateError') -> None: ...

    def isMainFrame(self) -> bool: ...
    def acceptCertificate(self) -> None: ...
    def description(self) -> str: ...
    def type(self) -> 'QWebEngineCertificateError.Type': ...
    def certificateChain(self) -> list[QtNetwork.QSslCertificate]: ...
    def rejectCertificate(self) -> None: ...
    def defer(self) -> None: ...
    def isOverridable(self) -> bool: ...
    def url(self) -> QtCore.QUrl: ...


class QWebEngineClientCertificateSelection(PyQt6.sip.simplewrapper):

    def __init__(self, a0: 'QWebEngineClientCertificateSelection') -> None: ...

    def certificates(self) -> list[QtNetwork.QSslCertificate]: ...
    def selectNone(self) -> None: ...
    def select(self, certificate: QtNetwork.QSslCertificate) -> None: ...
    def host(self) -> QtCore.QUrl: ...


class QWebEngineClientCertificateStore(PyQt6.sip.simplewrapper):

    def certificates(self) -> list[QtNetwork.QSslCertificate]: ...
    def clear(self) -> None: ...
    def remove(self, certificate: QtNetwork.QSslCertificate) -> None: ...
    def add(self, certificate: QtNetwork.QSslCertificate, privateKey: QtNetwork.QSslKey) -> None: ...


class QWebEngineClientHints(QtCore.QObject):

    def setFormFactors(self, a0: collections.abc.Iterable[str|None]) -> None: ...
    def formFactors(self) -> list[str]: ...
    def resetAll(self) -> None: ...
    def setAllClientHintsEnabled(self, enabled: bool) -> None: ...
    def isAllClientHintsEnabled(self) -> bool: ...
    def setIsWow64(self, a0: bool) -> None: ...
    def setFullVersionList(self, a0: dict[str|None, typing.Any]) -> None: ...
    def setBitness(self, a0: str|None) -> None: ...
    def setPlatformVersion(self, a0: str|None) -> None: ...
    def setFullVersion(self, a0: str|None) -> None: ...
    def setIsMobile(self, a0: bool) -> None: ...
    def setModel(self, a0: str|None) -> None: ...
    def setPlatform(self, a0: str|None) -> None: ...
    def setArch(self, a0: str|None) -> None: ...
    def isWow64(self) -> bool: ...
    def fullVersionList(self) -> dict[str, typing.Any]: ...
    def bitness(self) -> str: ...
    def platformVersion(self) -> str: ...
    def fullVersion(self) -> str: ...
    def isMobile(self) -> bool: ...
    def model(self) -> str: ...
    def platform(self) -> str: ...
    def arch(self) -> str: ...


class QWebEngineContextMenuRequest(QtCore.QObject):

    class EditFlag(enum.Flag):
        CanUndo = ... # type: QWebEngineContextMenuRequest.EditFlag
        CanRedo = ... # type: QWebEngineContextMenuRequest.EditFlag
        CanCut = ... # type: QWebEngineContextMenuRequest.EditFlag
        CanCopy = ... # type: QWebEngineContextMenuRequest.EditFlag
        CanPaste = ... # type: QWebEngineContextMenuRequest.EditFlag
        CanDelete = ... # type: QWebEngineContextMenuRequest.EditFlag
        CanSelectAll = ... # type: QWebEngineContextMenuRequest.EditFlag
        CanTranslate = ... # type: QWebEngineContextMenuRequest.EditFlag
        CanEditRichly = ... # type: QWebEngineContextMenuRequest.EditFlag

    class MediaFlag(enum.Flag):
        MediaInError = ... # type: QWebEngineContextMenuRequest.MediaFlag
        MediaPaused = ... # type: QWebEngineContextMenuRequest.MediaFlag
        MediaMuted = ... # type: QWebEngineContextMenuRequest.MediaFlag
        MediaLoop = ... # type: QWebEngineContextMenuRequest.MediaFlag
        MediaCanSave = ... # type: QWebEngineContextMenuRequest.MediaFlag
        MediaHasAudio = ... # type: QWebEngineContextMenuRequest.MediaFlag
        MediaCanToggleControls = ... # type: QWebEngineContextMenuRequest.MediaFlag
        MediaControls = ... # type: QWebEngineContextMenuRequest.MediaFlag
        MediaCanPrint = ... # type: QWebEngineContextMenuRequest.MediaFlag
        MediaCanRotate = ... # type: QWebEngineContextMenuRequest.MediaFlag

    class MediaType(enum.Enum):
        MediaTypeNone = ... # type: QWebEngineContextMenuRequest.MediaType
        MediaTypeImage = ... # type: QWebEngineContextMenuRequest.MediaType
        MediaTypeVideo = ... # type: QWebEngineContextMenuRequest.MediaType
        MediaTypeAudio = ... # type: QWebEngineContextMenuRequest.MediaType
        MediaTypeCanvas = ... # type: QWebEngineContextMenuRequest.MediaType
        MediaTypeFile = ... # type: QWebEngineContextMenuRequest.MediaType
        MediaTypePlugin = ... # type: QWebEngineContextMenuRequest.MediaType

    def editFlags(self) -> 'QWebEngineContextMenuRequest.EditFlag': ...
    def mediaFlags(self) -> 'QWebEngineContextMenuRequest.MediaFlag': ...
    def setAccepted(self, accepted: bool) -> None: ...
    def isAccepted(self) -> bool: ...
    def spellCheckerSuggestions(self) -> list[str]: ...
    def misspelledWord(self) -> str: ...
    def isContentEditable(self) -> bool: ...
    def mediaType(self) -> 'QWebEngineContextMenuRequest.MediaType': ...
    def mediaUrl(self) -> QtCore.QUrl: ...
    def linkUrl(self) -> QtCore.QUrl: ...
    def linkText(self) -> str: ...
    def selectedText(self) -> str: ...
    def position(self) -> QtCore.QPoint: ...


class QWebEngineCookieStore(QtCore.QObject):

    class FilterRequest(PyQt6.sip.simplewrapper):

        firstPartyUrl = ... # type: QtCore.QUrl
        origin = ... # type: QtCore.QUrl
        thirdParty = ... # type: bool

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWebEngineCookieStore.FilterRequest') -> None: ...

    def setCookieFilter(self, filterCallback: collections.abc.Callable[[FilterRequest], bool] = ...) -> None: ...
    cookieRemoved: typing.ClassVar[QtCore.pyqtSignal]
    cookieAdded: typing.ClassVar[QtCore.pyqtSignal]
    def loadAllCookies(self) -> None: ...
    def deleteAllCookies(self) -> None: ...
    def deleteSessionCookies(self) -> None: ...
    def deleteCookie(self, cookie: QtNetwork.QNetworkCookie, origin: QtCore.QUrl = ...) -> None: ...
    def setCookie(self, cookie: QtNetwork.QNetworkCookie, origin: QtCore.QUrl = ...) -> None: ...


class QWebEngineDesktopMediaRequest(PyQt6.sip.simplewrapper):

    def cancel(self) -> None: ...
    def selectWindow(self, index: QtCore.QModelIndex) -> None: ...
    def selectScreen(self, index: QtCore.QModelIndex) -> None: ...
    def windowsModel(self) -> QtCore.QAbstractListModel|None: ...
    def screensModel(self) -> QtCore.QAbstractListModel|None: ...


class QWebEngineDownloadRequest(QtCore.QObject):

    class DownloadInterruptReason(enum.Enum):
        NoReason = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        FileFailed = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        FileAccessDenied = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        FileNoSpace = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        FileNameTooLong = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        FileTooLarge = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        FileVirusInfected = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        FileTransientError = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        FileBlocked = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        FileSecurityCheckFailed = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        FileTooShort = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        FileHashMismatch = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        NetworkFailed = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        NetworkTimeout = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        NetworkDisconnected = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        NetworkServerDown = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        NetworkInvalidRequest = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        ServerFailed = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        ServerBadContent = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        ServerUnauthorized = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        ServerCertProblem = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        ServerForbidden = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        ServerUnreachable = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason
        UserCanceled = ... # type: QWebEngineDownloadRequest.DownloadInterruptReason

    class SavePageFormat(enum.Enum):
        UnknownSaveFormat = ... # type: QWebEngineDownloadRequest.SavePageFormat
        SingleHtmlSaveFormat = ... # type: QWebEngineDownloadRequest.SavePageFormat
        CompleteHtmlSaveFormat = ... # type: QWebEngineDownloadRequest.SavePageFormat
        MimeHtmlSaveFormat = ... # type: QWebEngineDownloadRequest.SavePageFormat

    class DownloadState(enum.Enum):
        DownloadRequested = ... # type: QWebEngineDownloadRequest.DownloadState
        DownloadInProgress = ... # type: QWebEngineDownloadRequest.DownloadState
        DownloadCompleted = ... # type: QWebEngineDownloadRequest.DownloadState
        DownloadCancelled = ... # type: QWebEngineDownloadRequest.DownloadState
        DownloadInterrupted = ... # type: QWebEngineDownloadRequest.DownloadState

    downloadFileNameChanged: typing.ClassVar[QtCore.pyqtSignal]
    downloadDirectoryChanged: typing.ClassVar[QtCore.pyqtSignal]
    isPausedChanged: typing.ClassVar[QtCore.pyqtSignal]
    isFinishedChanged: typing.ClassVar[QtCore.pyqtSignal]
    interruptReasonChanged: typing.ClassVar[QtCore.pyqtSignal]
    totalBytesChanged: typing.ClassVar[QtCore.pyqtSignal]
    receivedBytesChanged: typing.ClassVar[QtCore.pyqtSignal]
    savePageFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    stateChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setDownloadFileName(self, fileName: str|None) -> None: ...
    def downloadFileName(self) -> str: ...
    def setDownloadDirectory(self, directory: str|None) -> None: ...
    def downloadDirectory(self) -> str: ...
    def suggestedFileName(self) -> str: ...
    def page(self) -> 'QWebEnginePage|None': ...
    def isSavePageDownload(self) -> bool: ...
    def isPaused(self) -> bool: ...
    def interruptReasonString(self) -> str: ...
    def interruptReason(self) -> 'QWebEngineDownloadRequest.DownloadInterruptReason': ...
    def setSavePageFormat(self, format: 'QWebEngineDownloadRequest.SavePageFormat') -> None: ...
    def savePageFormat(self) -> 'QWebEngineDownloadRequest.SavePageFormat': ...
    def mimeType(self) -> str: ...
    def resume(self) -> None: ...
    def pause(self) -> None: ...
    def cancel(self) -> None: ...
    def accept(self) -> None: ...
    def isFinished(self) -> bool: ...
    def url(self) -> QtCore.QUrl: ...
    def receivedBytes(self) -> int: ...
    def totalBytes(self) -> int: ...
    def state(self) -> 'QWebEngineDownloadRequest.DownloadState': ...
    def id(self) -> int: ...


class QWebEngineExtensionInfo(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QWebEngineExtensionInfo') -> None: ...

    def isInstalled(self) -> bool: ...
    def isLoaded(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def actionPopupUrl(self) -> QtCore.QUrl: ...
    def error(self) -> str: ...
    def path(self) -> str: ...
    def description(self) -> str: ...
    def id(self) -> str: ...
    def name(self) -> str: ...
    def swap(self, other: 'QWebEngineExtensionInfo') -> None: ...


class QWebEngineExtensionManager(QtCore.QObject):

    def event(self, e: QtCore.QEvent|None) -> bool: ...
    uninstallFinished: typing.ClassVar[QtCore.pyqtSignal]
    unloadFinished: typing.ClassVar[QtCore.pyqtSignal]
    installFinished: typing.ClassVar[QtCore.pyqtSignal]
    loadFinished: typing.ClassVar[QtCore.pyqtSignal]
    def extensions(self) -> list[QWebEngineExtensionInfo]: ...
    def installPath(self) -> str: ...
    def setExtensionEnabled(self, extension: QWebEngineExtensionInfo, enabled: bool) -> None: ...
    def uninstallExtension(self, extension: QWebEngineExtensionInfo) -> None: ...
    def unloadExtension(self, extension: QWebEngineExtensionInfo) -> None: ...
    def installExtension(self, path: str|None) -> None: ...
    def loadExtension(self, path: str|None) -> None: ...


class QWebEngineFileSystemAccessRequest(PyQt6.sip.simplewrapper):

    class HandleType(enum.Enum):
        File = ... # type: QWebEngineFileSystemAccessRequest.HandleType
        Directory = ... # type: QWebEngineFileSystemAccessRequest.HandleType

    class AccessFlag(enum.Flag):
        Read = ... # type: QWebEngineFileSystemAccessRequest.AccessFlag
        Write = ... # type: QWebEngineFileSystemAccessRequest.AccessFlag

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QWebEngineFileSystemAccessRequest') -> None: ...

    def __eq__(self, other: object): ...
    def __ne__(self, other: object): ...
    def accessFlags(self) -> 'QWebEngineFileSystemAccessRequest.AccessFlag': ...
    def handleType(self) -> 'QWebEngineFileSystemAccessRequest.HandleType': ...
    def filePath(self) -> QtCore.QUrl: ...
    def origin(self) -> QtCore.QUrl: ...
    def reject(self) -> None: ...
    def accept(self) -> None: ...
    def swap(self, other: 'QWebEngineFileSystemAccessRequest') -> None: ...


class QWebEngineFindTextResult(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QWebEngineFindTextResult') -> None: ...

    def activeMatch(self) -> int: ...
    def numberOfMatches(self) -> int: ...


class QWebEngineFrame(PyQt6.sip.simplewrapper):

    def __eq__(self, other: object): ...
    def __ne__(self, other: object): ...
    @typing.overload
    def printToPdf(self, filePath: str|None) -> None: ...
    @typing.overload
    def printToPdf(self, callback: collections.abc.Callable[[QtCore.QByteArray|bytes|bytearray|memoryview], None]) -> None: ...
    @typing.overload
    def runJavaScript(self, script: str|None, worldId: int = ...) -> None: ...
    @typing.overload
    def runJavaScript(self, script: str|None, callback: collections.abc.Callable[[typing.Any], None]) -> None: ...
    @typing.overload
    def runJavaScript(self, script: str|None, worldId: int, callback: collections.abc.Callable[[typing.Any], None]) -> None: ...
    def isMainFrame(self) -> bool: ...
    def size(self) -> QtCore.QSizeF: ...
    def url(self) -> QtCore.QUrl: ...
    def children(self) -> list['QWebEngineFrame']: ...
    def htmlName(self) -> str: ...
    def name(self) -> str: ...
    def isValid(self) -> bool: ...


class QWebEngineFullScreenRequest(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QWebEngineFullScreenRequest') -> None: ...

    def origin(self) -> QtCore.QUrl: ...
    def toggleOn(self) -> bool: ...
    def accept(self) -> None: ...
    def reject(self) -> None: ...


class QWebEngineGlobalSettings(PyQt6.sip.simplewrapper):

    class SecureDnsMode(enum.Enum):
        SystemOnly = ... # type: QWebEngineGlobalSettings.SecureDnsMode
        SecureWithFallback = ... # type: QWebEngineGlobalSettings.SecureDnsMode
        SecureOnly = ... # type: QWebEngineGlobalSettings.SecureDnsMode

    class DnsMode(PyQt6.sip.simplewrapper):

        secureMode = ... # type: 'QWebEngineGlobalSettings.SecureDnsMode'
        serverTemplates = ... # type: collections.abc.Iterable[str|None]

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWebEngineGlobalSettings.DnsMode') -> None: ...


class QWebEngineHistoryItem(PyQt6.sip.simplewrapper):

    def __init__(self, other: 'QWebEngineHistoryItem') -> None: ...

    def swap(self, other: 'QWebEngineHistoryItem') -> None: ...
    def isValid(self) -> bool: ...
    def iconUrl(self) -> QtCore.QUrl: ...
    def lastVisited(self) -> QtCore.QDateTime: ...
    def title(self) -> str: ...
    def url(self) -> QtCore.QUrl: ...
    def originalUrl(self) -> QtCore.QUrl: ...


class QWebEngineHistoryModel(QtCore.QAbstractListModel):

    class Roles(enum.Enum):
        UrlRole = ... # type: QWebEngineHistoryModel.Roles
        TitleRole = ... # type: QWebEngineHistoryModel.Roles
        OffsetRole = ... # type: QWebEngineHistoryModel.Roles
        IconUrlRole = ... # type: QWebEngineHistoryModel.Roles

    def reset(self) -> None: ...
    def roleNames(self) -> dict[int, QtCore.QByteArray]: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...


class QWebEngineHistory(QtCore.QObject):

    def forwardItemsModel(self) -> QWebEngineHistoryModel|None: ...
    def backItemsModel(self) -> QWebEngineHistoryModel|None: ...
    def itemsModel(self) -> QWebEngineHistoryModel|None: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def currentItemIndex(self) -> int: ...
    def itemAt(self, i: int) -> QWebEngineHistoryItem: ...
    def forwardItem(self) -> QWebEngineHistoryItem: ...
    def currentItem(self) -> QWebEngineHistoryItem: ...
    def backItem(self) -> QWebEngineHistoryItem: ...
    def goToItem(self, item: QWebEngineHistoryItem) -> None: ...
    def forward(self) -> None: ...
    def back(self) -> None: ...
    def canGoForward(self) -> bool: ...
    def canGoBack(self) -> bool: ...
    def forwardItems(self, maxItems: int) -> list[QWebEngineHistoryItem]: ...
    def backItems(self, maxItems: int) -> list[QWebEngineHistoryItem]: ...
    def items(self) -> list[QWebEngineHistoryItem]: ...
    def clear(self) -> None: ...


class QWebEngineHttpRequest(PyQt6.sip.simplewrapper):

    class Method(enum.Enum):
        Get = ... # type: QWebEngineHttpRequest.Method
        Post = ... # type: QWebEngineHttpRequest.Method

    @typing.overload
    def __init__(self, url: QtCore.QUrl = ..., method: 'QWebEngineHttpRequest.Method' = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QWebEngineHttpRequest') -> None: ...

    def headers(self) -> list[QtCore.QByteArray]: ...
    def unsetHeader(self, headerName: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def setHeader(self, headerName: QtCore.QByteArray|bytes|bytearray|memoryview, value: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def header(self, headerName: QtCore.QByteArray|bytes|bytearray|memoryview) -> QtCore.QByteArray: ...
    def hasHeader(self, headerName: QtCore.QByteArray|bytes|bytearray|memoryview) -> bool: ...
    def setPostData(self, postData: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def postData(self) -> QtCore.QByteArray: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def url(self) -> QtCore.QUrl: ...
    def setMethod(self, method: 'QWebEngineHttpRequest.Method') -> None: ...
    def method(self) -> 'QWebEngineHttpRequest.Method': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def swap(self, other: 'QWebEngineHttpRequest') -> None: ...
    @staticmethod
    def postRequest(url: QtCore.QUrl, postData: dict[str|None, str|None]) -> 'QWebEngineHttpRequest': ...


class QWebEngineLoadingInfo(PyQt6.sip.simplewrapper):

    class ErrorDomain(enum.Enum):
        NoErrorDomain = ... # type: QWebEngineLoadingInfo.ErrorDomain
        InternalErrorDomain = ... # type: QWebEngineLoadingInfo.ErrorDomain
        ConnectionErrorDomain = ... # type: QWebEngineLoadingInfo.ErrorDomain
        CertificateErrorDomain = ... # type: QWebEngineLoadingInfo.ErrorDomain
        HttpErrorDomain = ... # type: QWebEngineLoadingInfo.ErrorDomain
        FtpErrorDomain = ... # type: QWebEngineLoadingInfo.ErrorDomain
        DnsErrorDomain = ... # type: QWebEngineLoadingInfo.ErrorDomain
        HttpStatusCodeDomain = ... # type: QWebEngineLoadingInfo.ErrorDomain

    class LoadStatus(enum.Enum):
        LoadStartedStatus = ... # type: QWebEngineLoadingInfo.LoadStatus
        LoadStoppedStatus = ... # type: QWebEngineLoadingInfo.LoadStatus
        LoadSucceededStatus = ... # type: QWebEngineLoadingInfo.LoadStatus
        LoadFailedStatus = ... # type: QWebEngineLoadingInfo.LoadStatus

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QWebEngineLoadingInfo') -> None: ...

    def isDownload(self) -> bool: ...
    def responseHeaders(self) -> dict[QtCore.QByteArray, list[QtCore.QByteArray]]: ...
    def errorCode(self) -> int: ...
    def errorDomain(self) -> 'QWebEngineLoadingInfo.ErrorDomain': ...
    def errorString(self) -> str: ...
    def status(self) -> 'QWebEngineLoadingInfo.LoadStatus': ...
    def isErrorPage(self) -> bool: ...
    def url(self) -> QtCore.QUrl: ...


class QWebEngineNavigationRequest(QtCore.QObject):

    class NavigationType(enum.Enum):
        LinkClickedNavigation = ... # type: QWebEngineNavigationRequest.NavigationType
        TypedNavigation = ... # type: QWebEngineNavigationRequest.NavigationType
        FormSubmittedNavigation = ... # type: QWebEngineNavigationRequest.NavigationType
        BackForwardNavigation = ... # type: QWebEngineNavigationRequest.NavigationType
        ReloadNavigation = ... # type: QWebEngineNavigationRequest.NavigationType
        OtherNavigation = ... # type: QWebEngineNavigationRequest.NavigationType
        RedirectNavigation = ... # type: QWebEngineNavigationRequest.NavigationType

    actionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def hasFormData(self) -> bool: ...
    def reject(self) -> None: ...
    def accept(self) -> None: ...
    def navigationType(self) -> 'QWebEngineNavigationRequest.NavigationType': ...
    def isMainFrame(self) -> bool: ...
    def url(self) -> QtCore.QUrl: ...


class QWebEngineNewWindowRequest(QtCore.QObject):

    class DestinationType(enum.Enum):
        InNewWindow = ... # type: QWebEngineNewWindowRequest.DestinationType
        InNewTab = ... # type: QWebEngineNewWindowRequest.DestinationType
        InNewDialog = ... # type: QWebEngineNewWindowRequest.DestinationType
        InNewBackgroundTab = ... # type: QWebEngineNewWindowRequest.DestinationType

    def openIn(self, a0: 'QWebEnginePage|None') -> None: ...
    def isUserInitiated(self) -> bool: ...
    def requestedGeometry(self) -> QtCore.QRect: ...
    def requestedUrl(self) -> QtCore.QUrl: ...
    def destination(self) -> 'QWebEngineNewWindowRequest.DestinationType': ...


class QWebEngineNotification(QtCore.QObject):

    closed: typing.ClassVar[QtCore.pyqtSignal]
    def close(self) -> None: ...
    def click(self) -> None: ...
    def show(self) -> None: ...
    def direction(self) -> QtCore.Qt.LayoutDirection: ...
    def language(self) -> str: ...
    def tag(self) -> str: ...
    def message(self) -> str: ...
    def title(self) -> str: ...
    def icon(self) -> QtGui.QImage: ...
    def origin(self) -> QtCore.QUrl: ...
    def matches(self, other: 'QWebEngineNotification|None') -> bool: ...


class QWebEnginePage(QtCore.QObject):

    class LifecycleState(enum.Enum):
        Active = ... # type: QWebEnginePage.LifecycleState
        Frozen = ... # type: QWebEnginePage.LifecycleState
        Discarded = ... # type: QWebEnginePage.LifecycleState

    class RenderProcessTerminationStatus(enum.Enum):
        NormalTerminationStatus = ... # type: QWebEnginePage.RenderProcessTerminationStatus
        AbnormalTerminationStatus = ... # type: QWebEnginePage.RenderProcessTerminationStatus
        CrashedTerminationStatus = ... # type: QWebEnginePage.RenderProcessTerminationStatus
        KilledTerminationStatus = ... # type: QWebEnginePage.RenderProcessTerminationStatus

    class NavigationType(enum.Enum):
        NavigationTypeLinkClicked = ... # type: QWebEnginePage.NavigationType
        NavigationTypeTyped = ... # type: QWebEnginePage.NavigationType
        NavigationTypeFormSubmitted = ... # type: QWebEnginePage.NavigationType
        NavigationTypeBackForward = ... # type: QWebEnginePage.NavigationType
        NavigationTypeReload = ... # type: QWebEnginePage.NavigationType
        NavigationTypeRedirect = ... # type: QWebEnginePage.NavigationType
        NavigationTypeOther = ... # type: QWebEnginePage.NavigationType

    class JavaScriptConsoleMessageLevel(enum.Enum):
        InfoMessageLevel = ... # type: QWebEnginePage.JavaScriptConsoleMessageLevel
        WarningMessageLevel = ... # type: QWebEnginePage.JavaScriptConsoleMessageLevel
        ErrorMessageLevel = ... # type: QWebEnginePage.JavaScriptConsoleMessageLevel

    class FileSelectionMode(enum.Enum):
        FileSelectOpen = ... # type: QWebEnginePage.FileSelectionMode
        FileSelectOpenMultiple = ... # type: QWebEnginePage.FileSelectionMode
        FileSelectUploadFolder = ... # type: QWebEnginePage.FileSelectionMode
        FileSelectSave = ... # type: QWebEnginePage.FileSelectionMode

    class Feature(enum.Enum):
        Notifications = ... # type: QWebEnginePage.Feature
        Geolocation = ... # type: QWebEnginePage.Feature
        MediaAudioCapture = ... # type: QWebEnginePage.Feature
        MediaVideoCapture = ... # type: QWebEnginePage.Feature
        MediaAudioVideoCapture = ... # type: QWebEnginePage.Feature
        MouseLock = ... # type: QWebEnginePage.Feature
        DesktopVideoCapture = ... # type: QWebEnginePage.Feature
        DesktopAudioVideoCapture = ... # type: QWebEnginePage.Feature
        ClipboardReadWrite = ... # type: QWebEnginePage.Feature
        LocalFontsAccess = ... # type: QWebEnginePage.Feature

    class PermissionPolicy(enum.Enum):
        PermissionUnknown = ... # type: QWebEnginePage.PermissionPolicy
        PermissionGrantedByUser = ... # type: QWebEnginePage.PermissionPolicy
        PermissionDeniedByUser = ... # type: QWebEnginePage.PermissionPolicy

    class WebWindowType(enum.Enum):
        WebBrowserWindow = ... # type: QWebEnginePage.WebWindowType
        WebBrowserTab = ... # type: QWebEnginePage.WebWindowType
        WebDialog = ... # type: QWebEnginePage.WebWindowType
        WebBrowserBackgroundTab = ... # type: QWebEnginePage.WebWindowType

    class FindFlag(enum.Flag):
        FindBackward = ... # type: QWebEnginePage.FindFlag
        FindCaseSensitively = ... # type: QWebEnginePage.FindFlag

    class WebAction(enum.Enum):
        NoWebAction = ... # type: QWebEnginePage.WebAction
        Back = ... # type: QWebEnginePage.WebAction
        Forward = ... # type: QWebEnginePage.WebAction
        Stop = ... # type: QWebEnginePage.WebAction
        Reload = ... # type: QWebEnginePage.WebAction
        Cut = ... # type: QWebEnginePage.WebAction
        Copy = ... # type: QWebEnginePage.WebAction
        Paste = ... # type: QWebEnginePage.WebAction
        Undo = ... # type: QWebEnginePage.WebAction
        Redo = ... # type: QWebEnginePage.WebAction
        SelectAll = ... # type: QWebEnginePage.WebAction
        ReloadAndBypassCache = ... # type: QWebEnginePage.WebAction
        PasteAndMatchStyle = ... # type: QWebEnginePage.WebAction
        OpenLinkInThisWindow = ... # type: QWebEnginePage.WebAction
        OpenLinkInNewWindow = ... # type: QWebEnginePage.WebAction
        OpenLinkInNewTab = ... # type: QWebEnginePage.WebAction
        CopyLinkToClipboard = ... # type: QWebEnginePage.WebAction
        DownloadLinkToDisk = ... # type: QWebEnginePage.WebAction
        CopyImageToClipboard = ... # type: QWebEnginePage.WebAction
        CopyImageUrlToClipboard = ... # type: QWebEnginePage.WebAction
        DownloadImageToDisk = ... # type: QWebEnginePage.WebAction
        CopyMediaUrlToClipboard = ... # type: QWebEnginePage.WebAction
        ToggleMediaControls = ... # type: QWebEnginePage.WebAction
        ToggleMediaLoop = ... # type: QWebEnginePage.WebAction
        ToggleMediaPlayPause = ... # type: QWebEnginePage.WebAction
        ToggleMediaMute = ... # type: QWebEnginePage.WebAction
        DownloadMediaToDisk = ... # type: QWebEnginePage.WebAction
        InspectElement = ... # type: QWebEnginePage.WebAction
        ExitFullScreen = ... # type: QWebEnginePage.WebAction
        RequestClose = ... # type: QWebEnginePage.WebAction
        Unselect = ... # type: QWebEnginePage.WebAction
        SavePage = ... # type: QWebEnginePage.WebAction
        OpenLinkInNewBackgroundTab = ... # type: QWebEnginePage.WebAction
        ViewSource = ... # type: QWebEnginePage.WebAction
        ToggleBold = ... # type: QWebEnginePage.WebAction
        ToggleItalic = ... # type: QWebEnginePage.WebAction
        ToggleUnderline = ... # type: QWebEnginePage.WebAction
        ToggleStrikethrough = ... # type: QWebEnginePage.WebAction
        AlignLeft = ... # type: QWebEnginePage.WebAction
        AlignCenter = ... # type: QWebEnginePage.WebAction
        AlignRight = ... # type: QWebEnginePage.WebAction
        AlignJustified = ... # type: QWebEnginePage.WebAction
        Indent = ... # type: QWebEnginePage.WebAction
        Outdent = ... # type: QWebEnginePage.WebAction
        InsertOrderedList = ... # type: QWebEnginePage.WebAction
        InsertUnorderedList = ... # type: QWebEnginePage.WebAction
        ChangeTextDirectionLTR = ... # type: QWebEnginePage.WebAction
        ChangeTextDirectionRTL = ... # type: QWebEnginePage.WebAction

    @typing.overload
    def __init__(self, profile: 'QWebEngineProfile|None', parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    printRequestedByFrame: typing.ClassVar[QtCore.pyqtSignal]
    zoomFactorChanged: typing.ClassVar[QtCore.pyqtSignal]
    permissionRequested: typing.ClassVar[QtCore.pyqtSignal]
    def findFrameByName(self, name: QtCore.QByteArray|bytes|bytearray|memoryview|str|None) -> QWebEngineFrame|None: ...
    def mainFrame(self) -> QWebEngineFrame: ...
    webAuthUxRequested: typing.ClassVar[QtCore.pyqtSignal]
    desktopMediaRequested: typing.ClassVar[QtCore.pyqtSignal]
    def devToolsId(self) -> str: ...
    fileSystemAccessRequested: typing.ClassVar[QtCore.pyqtSignal]
    newWindowRequested: typing.ClassVar[QtCore.pyqtSignal]
    navigationRequested: typing.ClassVar[QtCore.pyqtSignal]
    certificateError: typing.ClassVar[QtCore.pyqtSignal]
    loadingChanged: typing.ClassVar[QtCore.pyqtSignal]
    @typing.overload
    def printToPdf(self, filePath: str|None, pageLayout: QtGui.QPageLayout = ..., ranges: QtGui.QPageRanges = ...) -> None: ...
    @typing.overload
    def printToPdf(self, resultCallback: collections.abc.Callable[[QtCore.QByteArray|bytes|bytearray|memoryview], None], pageLayout: QtGui.QPageLayout = ..., ranges: QtGui.QPageRanges = ...) -> None: ...
    def setWebChannel(self, a0: QtWebChannel.QWebChannel|None, worldId: int = ...) -> None: ...
    @typing.overload
    def runJavaScript(self, scriptSource: str|None, worldId: int = ..., resultCallback: collections.abc.Callable[[typing.Any], None] = ...) -> None: ...
    @typing.overload
    def runJavaScript(self, scriptSource: str|None, resultCallback: collections.abc.Callable[[typing.Any], None]) -> None: ...
    def toPlainText(self, resultCallback: collections.abc.Callable[[str|None], None]) -> None: ...
    def toHtml(self, resultCallback: collections.abc.Callable[[str|None], None]) -> None: ...
    def isLoading(self) -> bool: ...
    def findText(self, subString: str|None, options: 'QWebEnginePage.FindFlag' = ..., resultCallback: collections.abc.Callable[[bool], None] = ...) -> None: ...
    renderProcessPidChanged: typing.ClassVar[QtCore.pyqtSignal]
    def renderProcessPid(self) -> int: ...
    findTextFinished: typing.ClassVar[QtCore.pyqtSignal]
    recommendedStateChanged: typing.ClassVar[QtCore.pyqtSignal]
    lifecycleStateChanged: typing.ClassVar[QtCore.pyqtSignal]
    visibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setVisible(self, visible: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def recommendedState(self) -> 'QWebEnginePage.LifecycleState': ...
    def setLifecycleState(self, state: 'QWebEnginePage.LifecycleState') -> None: ...
    def lifecycleState(self) -> 'QWebEnginePage.LifecycleState': ...
    def setUrlRequestInterceptor(self, interceptor: 'QWebEngineUrlRequestInterceptor|None') -> None: ...
    printRequested: typing.ClassVar[QtCore.pyqtSignal]
    selectClientCertificate: typing.ClassVar[QtCore.pyqtSignal]
    registerProtocolHandlerRequested: typing.ClassVar[QtCore.pyqtSignal]
    quotaRequested: typing.ClassVar[QtCore.pyqtSignal]
    def devToolsPage(self) -> 'QWebEnginePage|None': ...
    def setDevToolsPage(self, page: 'QWebEnginePage|None') -> None: ...
    def inspectedPage(self) -> 'QWebEnginePage|None': ...
    def setInspectedPage(self, page: 'QWebEnginePage|None') -> None: ...
    def download(self, url: QtCore.QUrl, filename: str|None = ...) -> None: ...
    def save(self, filePath: str|None, format: QWebEngineDownloadRequest.SavePageFormat = ...) -> None: ...
    def replaceMisspelledWord(self, replacement: str|None) -> None: ...
    pdfPrintingFinished: typing.ClassVar[QtCore.pyqtSignal]
    recentlyAudibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    audioMutedChanged: typing.ClassVar[QtCore.pyqtSignal]
    contentsSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    scrollPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    iconChanged: typing.ClassVar[QtCore.pyqtSignal]
    def recentlyAudible(self) -> bool: ...
    def setAudioMuted(self, muted: bool) -> None: ...
    def isAudioMuted(self) -> bool: ...
    def contentsSize(self) -> QtCore.QSizeF: ...
    def scrollPosition(self) -> QtCore.QPointF: ...
    def icon(self) -> QtGui.QIcon: ...
    renderProcessTerminated: typing.ClassVar[QtCore.pyqtSignal]
    fullScreenRequested: typing.ClassVar[QtCore.pyqtSignal]
    def setBackgroundColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def acceptNavigationRequest(self, url: QtCore.QUrl, type: 'QWebEnginePage.NavigationType', isMainFrame: bool) -> bool: ...
    def webChannel(self) -> QtWebChannel.QWebChannel|None: ...
    def scripts(self) -> 'QWebEngineScriptCollection': ...
    def profile(self) -> 'QWebEngineProfile|None': ...
    def javaScriptConsoleMessage(self, level: 'QWebEnginePage.JavaScriptConsoleMessageLevel', message: str|None, lineNumber: int, sourceID: str|None) -> None: ...
    def javaScriptPrompt(self, securityOrigin: QtCore.QUrl, msg: str|None, defaultValue: str|None) -> typing.Tuple[bool, str]: ...
    def javaScriptConfirm(self, securityOrigin: QtCore.QUrl, msg: str|None) -> bool: ...
    def javaScriptAlert(self, securityOrigin: QtCore.QUrl, msg: str|None) -> None: ...
    def chooseFiles(self, mode: 'QWebEnginePage.FileSelectionMode', oldFiles: collections.abc.Iterable[str|None], acceptedMimeTypes: collections.abc.Iterable[str|None]) -> list[str]: ...
    def createWindow(self, type: 'QWebEnginePage.WebWindowType') -> 'QWebEnginePage|None': ...
    iconUrlChanged: typing.ClassVar[QtCore.pyqtSignal]
    urlChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleChanged: typing.ClassVar[QtCore.pyqtSignal]
    proxyAuthenticationRequired: typing.ClassVar[QtCore.pyqtSignal]
    authenticationRequired: typing.ClassVar[QtCore.pyqtSignal]
    featurePermissionRequestCanceled: typing.ClassVar[QtCore.pyqtSignal]
    featurePermissionRequested: typing.ClassVar[QtCore.pyqtSignal]
    windowCloseRequested: typing.ClassVar[QtCore.pyqtSignal]
    geometryChangeRequested: typing.ClassVar[QtCore.pyqtSignal]
    selectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    linkHovered: typing.ClassVar[QtCore.pyqtSignal]
    loadFinished: typing.ClassVar[QtCore.pyqtSignal]
    loadProgress: typing.ClassVar[QtCore.pyqtSignal]
    loadStarted: typing.ClassVar[QtCore.pyqtSignal]
    def settings(self) -> 'QWebEngineSettings|None': ...
    def setZoomFactor(self, factor: float) -> None: ...
    def zoomFactor(self) -> float: ...
    def iconUrl(self) -> QtCore.QUrl: ...
    def requestedUrl(self) -> QtCore.QUrl: ...
    def url(self) -> QtCore.QUrl: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def title(self) -> str: ...
    def setContent(self, data: QtCore.QByteArray|bytes|bytearray|memoryview, mimeType: str|None = ..., baseUrl: QtCore.QUrl = ...) -> None: ...
    def setHtml(self, html: str|None, baseUrl: QtCore.QUrl = ...) -> None: ...
    @typing.overload
    def load(self, url: QtCore.QUrl) -> None: ...
    @typing.overload
    def load(self, request: QWebEngineHttpRequest) -> None: ...
    def setFeaturePermission(self, securityOrigin: QtCore.QUrl, feature: 'QWebEnginePage.Feature', policy: 'QWebEnginePage.PermissionPolicy') -> None: ...
    def event(self, a0: QtCore.QEvent|None) -> bool: ...
    def triggerAction(self, action: 'QWebEnginePage.WebAction', checked: bool = ...) -> None: ...
    def action(self, action: 'QWebEnginePage.WebAction') -> QtGui.QAction|None: ...
    def selectedText(self) -> str: ...
    def hasSelection(self) -> bool: ...
    def history(self) -> QWebEngineHistory|None: ...


class QWebEnginePermission(PyQt6.sip.simplewrapper):

    class State(enum.Enum):
        Invalid = ... # type: QWebEnginePermission.State
        Ask = ... # type: QWebEnginePermission.State
        Granted = ... # type: QWebEnginePermission.State
        Denied = ... # type: QWebEnginePermission.State

    class PermissionType(enum.Enum):
        Unsupported = ... # type: QWebEnginePermission.PermissionType
        MediaAudioCapture = ... # type: QWebEnginePermission.PermissionType
        MediaVideoCapture = ... # type: QWebEnginePermission.PermissionType
        MediaAudioVideoCapture = ... # type: QWebEnginePermission.PermissionType
        DesktopVideoCapture = ... # type: QWebEnginePermission.PermissionType
        DesktopAudioVideoCapture = ... # type: QWebEnginePermission.PermissionType
        MouseLock = ... # type: QWebEnginePermission.PermissionType
        Notifications = ... # type: QWebEnginePermission.PermissionType
        Geolocation = ... # type: QWebEnginePermission.PermissionType
        ClipboardReadWrite = ... # type: QWebEnginePermission.PermissionType
        LocalFontsAccess = ... # type: QWebEnginePermission.PermissionType

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QWebEnginePermission') -> None: ...

    def __eq__(self, other: object): ...
    def __ne__(self, other: object): ...
    @staticmethod
    def isPersistent(permissionType: 'QWebEnginePermission.PermissionType') -> bool: ...
    def reset(self) -> None: ...
    def deny(self) -> None: ...
    def grant(self) -> None: ...
    def isValid(self) -> bool: ...
    def state(self) -> 'QWebEnginePermission.State': ...
    def permissionType(self) -> 'QWebEnginePermission.PermissionType': ...
    def origin(self) -> QtCore.QUrl: ...
    def swap(self, other: 'QWebEnginePermission') -> None: ...


class QWebEngineProfile(QtCore.QObject):

    class PersistentPermissionsPolicy(enum.Enum):
        AskEveryTime = ... # type: QWebEngineProfile.PersistentPermissionsPolicy
        StoreInMemory = ... # type: QWebEngineProfile.PersistentPermissionsPolicy
        StoreOnDisk = ... # type: QWebEngineProfile.PersistentPermissionsPolicy

    class PersistentCookiesPolicy(enum.Enum):
        NoPersistentCookies = ... # type: QWebEngineProfile.PersistentCookiesPolicy
        AllowPersistentCookies = ... # type: QWebEngineProfile.PersistentCookiesPolicy
        ForcePersistentCookies = ... # type: QWebEngineProfile.PersistentCookiesPolicy

    class HttpCacheType(enum.Enum):
        MemoryHttpCache = ... # type: QWebEngineProfile.HttpCacheType
        DiskHttpCache = ... # type: QWebEngineProfile.HttpCacheType
        NoCache = ... # type: QWebEngineProfile.HttpCacheType

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, name: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    def extensionManager(self) -> QWebEngineExtensionManager|None: ...
    def additionalTrustedCertificates(self) -> list[QtNetwork.QSslCertificate]: ...
    def listPermissionsForPermissionType(self, permissionType: QWebEnginePermission.PermissionType) -> list[QWebEnginePermission]: ...
    def listPermissionsForOrigin(self, securityOrigin: QtCore.QUrl) -> list[QWebEnginePermission]: ...
    def listAllPermissions(self) -> list[QWebEnginePermission]: ...
    def queryPermission(self, securityOrigin: QtCore.QUrl, permissionType: QWebEnginePermission.PermissionType) -> QWebEnginePermission: ...
    def clientHints(self) -> QWebEngineClientHints|None: ...
    def setPersistentPermissionsPolicy(self, a0: 'QWebEngineProfile.PersistentPermissionsPolicy') -> None: ...
    def persistentPermissionsPolicy(self) -> 'QWebEngineProfile.PersistentPermissionsPolicy': ...
    def setPushServiceEnabled(self, enabled: bool) -> None: ...
    def isPushServiceEnabled(self) -> bool: ...
    def requestIconForIconURL(self, url: QtCore.QUrl, desiredSizeInPixel: int, iconAvailableCallback: collections.abc.Callable[[QtGui.QIcon, QtCore.QUrl], None]) -> None: ...
    def requestIconForPageURL(self, url: QtCore.QUrl, desiredSizeInPixel: int, iconAvailableCallback: collections.abc.Callable[[QtGui.QIcon, QtCore.QUrl, QtCore.QUrl], None]) -> None: ...
    def clientCertificateStore(self) -> QWebEngineClientCertificateStore|None: ...
    def setNotificationPresenter(self, a0: collections.abc.Callable[[QWebEngineNotification], None]) -> None: ...
    def setDownloadPath(self, path: str|None) -> None: ...
    def downloadPath(self) -> str: ...
    def isSpellCheckEnabled(self) -> bool: ...
    def setSpellCheckEnabled(self, enabled: bool) -> None: ...
    def spellCheckLanguages(self) -> list[str]: ...
    def setSpellCheckLanguages(self, languages: collections.abc.Iterable[str|None]) -> None: ...
    def clearHttpCache(self) -> None: ...
    def removeAllUrlSchemeHandlers(self) -> None: ...
    def removeUrlSchemeHandler(self, a0: 'QWebEngineUrlSchemeHandler|None') -> None: ...
    def removeUrlScheme(self, scheme: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def installUrlSchemeHandler(self, scheme: QtCore.QByteArray|bytes|bytearray|memoryview, a1: 'QWebEngineUrlSchemeHandler|None') -> None: ...
    def urlSchemeHandler(self, a0: QtCore.QByteArray|bytes|bytearray|memoryview) -> 'QWebEngineUrlSchemeHandler|None': ...
    def setUrlRequestInterceptor(self, interceptor: 'QWebEngineUrlRequestInterceptor|None') -> None: ...
    def cookieStore(self) -> QWebEngineCookieStore|None: ...
    def httpAcceptLanguage(self) -> str: ...
    def setHttpAcceptLanguage(self, httpAcceptLanguage: str|None) -> None: ...
    clearHttpCacheCompleted: typing.ClassVar[QtCore.pyqtSignal]
    downloadRequested: typing.ClassVar[QtCore.pyqtSignal]
    @staticmethod
    def defaultProfile() -> 'QWebEngineProfile|None': ...
    def scripts(self) -> 'QWebEngineScriptCollection|None': ...
    def settings(self) -> 'QWebEngineSettings|None': ...
    def visitedLinksContainsUrl(self, url: QtCore.QUrl) -> bool: ...
    def clearVisitedLinks(self, urls: collections.abc.Iterable[QtCore.QUrl]) -> None: ...
    def clearAllVisitedLinks(self) -> None: ...
    def setHttpCacheMaximumSize(self, maxSize: int) -> None: ...
    def httpCacheMaximumSize(self) -> int: ...
    def setPersistentCookiesPolicy(self, a0: 'QWebEngineProfile.PersistentCookiesPolicy') -> None: ...
    def persistentCookiesPolicy(self) -> 'QWebEngineProfile.PersistentCookiesPolicy': ...
    def setHttpCacheType(self, a0: 'QWebEngineProfile.HttpCacheType') -> None: ...
    def httpCacheType(self) -> 'QWebEngineProfile.HttpCacheType': ...
    def setHttpUserAgent(self, userAgent: str|None) -> None: ...
    def httpUserAgent(self) -> str: ...
    def setCachePath(self, path: str|None) -> None: ...
    def cachePath(self) -> str: ...
    def setPersistentStoragePath(self, path: str|None) -> None: ...
    def persistentStoragePath(self) -> str: ...
    def isOffTheRecord(self) -> bool: ...
    def storageName(self) -> str: ...


class QWebEngineProfileBuilder(PyQt6.sip.simplewrapper):

    def setAdditionalTrustedCertificates(self, additionalTrustedCertificates: collections.abc.Iterable[QtNetwork.QSslCertificate]) -> 'QWebEngineProfileBuilder': ...
    def setPersistentPermissionsPolicy(self, persistentPermissionPolicy: QWebEngineProfile.PersistentPermissionsPolicy) -> 'QWebEngineProfileBuilder': ...
    def setHttpCacheMaximumSize(self, maxSizeInBytes: int) -> 'QWebEngineProfileBuilder': ...
    def setPersistentCookiesPolicy(self, persistentCookiesPolicy: QWebEngineProfile.PersistentCookiesPolicy) -> 'QWebEngineProfileBuilder': ...
    def setHttpCacheType(self, httpCacheType: QWebEngineProfile.HttpCacheType) -> 'QWebEngineProfileBuilder': ...
    def setCachePath(self, path: str|None) -> 'QWebEngineProfileBuilder': ...
    def setPersistentStoragePath(self, path: str|None) -> 'QWebEngineProfileBuilder': ...
    @staticmethod
    def createOffTheRecordProfile(parent: QtCore.QObject|None = ...) -> QWebEngineProfile|None: ...
    def createProfile(self, storageName: str|None, parent: QtCore.QObject|None = ...) -> QWebEngineProfile|None: ...


class QWebEngineQuotaRequest(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QWebEngineQuotaRequest') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def requestedSize(self) -> int: ...
    def origin(self) -> QtCore.QUrl: ...
    def reject(self) -> None: ...
    def accept(self) -> None: ...


class QWebEngineRegisterProtocolHandlerRequest(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QWebEngineRegisterProtocolHandlerRequest') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def scheme(self) -> str: ...
    def origin(self) -> QtCore.QUrl: ...
    def reject(self) -> None: ...
    def accept(self) -> None: ...


class QWebEngineScript(PyQt6.sip.simplewrapper):

    class ScriptWorldId(enum.IntEnum):
        MainWorld = ... # type: QWebEngineScript.ScriptWorldId
        ApplicationWorld = ... # type: QWebEngineScript.ScriptWorldId
        UserWorld = ... # type: QWebEngineScript.ScriptWorldId

    class InjectionPoint(enum.Enum):
        Deferred = ... # type: QWebEngineScript.InjectionPoint
        DocumentReady = ... # type: QWebEngineScript.InjectionPoint
        DocumentCreation = ... # type: QWebEngineScript.InjectionPoint

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QWebEngineScript') -> None: ...

    def setSourceUrl(self, url: QtCore.QUrl) -> None: ...
    def sourceUrl(self) -> QtCore.QUrl: ...
    def swap(self, other: 'QWebEngineScript') -> None: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def setRunsOnSubFrames(self, on: bool) -> None: ...
    def runsOnSubFrames(self) -> bool: ...
    def setWorldId(self, a0: int) -> None: ...
    def worldId(self) -> int: ...
    def setInjectionPoint(self, a0: 'QWebEngineScript.InjectionPoint') -> None: ...
    def injectionPoint(self) -> 'QWebEngineScript.InjectionPoint': ...
    def setSourceCode(self, a0: str|None) -> None: ...
    def sourceCode(self) -> str: ...
    def setName(self, a0: str|None) -> None: ...
    def name(self) -> str: ...


class QWebEngineScriptCollection(PyQt6.sip.simplewrapper):

    def find(self, name: str|None) -> list[QWebEngineScript]: ...
    def toList(self) -> list[QWebEngineScript]: ...
    def clear(self) -> None: ...
    def remove(self, a0: QWebEngineScript) -> bool: ...
    @typing.overload
    def insert(self, a0: QWebEngineScript) -> None: ...
    @typing.overload
    def insert(self, list: collections.abc.Iterable[QWebEngineScript]) -> None: ...
    def contains(self, value: QWebEngineScript) -> bool: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def isEmpty(self) -> bool: ...


class QWebEngineSettings(PyQt6.sip.simplewrapper):

    class ImageAnimationPolicy(enum.Enum):
        Allow = ... # type: QWebEngineSettings.ImageAnimationPolicy
        AnimateOnce = ... # type: QWebEngineSettings.ImageAnimationPolicy
        Disallow = ... # type: QWebEngineSettings.ImageAnimationPolicy

    class UnknownUrlSchemePolicy(enum.Enum):
        DisallowUnknownUrlSchemes = ... # type: QWebEngineSettings.UnknownUrlSchemePolicy
        AllowUnknownUrlSchemesFromUserInteraction = ... # type: QWebEngineSettings.UnknownUrlSchemePolicy
        AllowAllUnknownUrlSchemes = ... # type: QWebEngineSettings.UnknownUrlSchemePolicy

    class FontSize(enum.Enum):
        MinimumFontSize = ... # type: QWebEngineSettings.FontSize
        MinimumLogicalFontSize = ... # type: QWebEngineSettings.FontSize
        DefaultFontSize = ... # type: QWebEngineSettings.FontSize
        DefaultFixedFontSize = ... # type: QWebEngineSettings.FontSize

    class WebAttribute(enum.Enum):
        AutoLoadImages = ... # type: QWebEngineSettings.WebAttribute
        JavascriptEnabled = ... # type: QWebEngineSettings.WebAttribute
        JavascriptCanOpenWindows = ... # type: QWebEngineSettings.WebAttribute
        JavascriptCanAccessClipboard = ... # type: QWebEngineSettings.WebAttribute
        LinksIncludedInFocusChain = ... # type: QWebEngineSettings.WebAttribute
        LocalStorageEnabled = ... # type: QWebEngineSettings.WebAttribute
        LocalContentCanAccessRemoteUrls = ... # type: QWebEngineSettings.WebAttribute
        XSSAuditingEnabled = ... # type: QWebEngineSettings.WebAttribute
        SpatialNavigationEnabled = ... # type: QWebEngineSettings.WebAttribute
        LocalContentCanAccessFileUrls = ... # type: QWebEngineSettings.WebAttribute
        HyperlinkAuditingEnabled = ... # type: QWebEngineSettings.WebAttribute
        ScrollAnimatorEnabled = ... # type: QWebEngineSettings.WebAttribute
        ErrorPageEnabled = ... # type: QWebEngineSettings.WebAttribute
        PluginsEnabled = ... # type: QWebEngineSettings.WebAttribute
        FullScreenSupportEnabled = ... # type: QWebEngineSettings.WebAttribute
        ScreenCaptureEnabled = ... # type: QWebEngineSettings.WebAttribute
        WebGLEnabled = ... # type: QWebEngineSettings.WebAttribute
        Accelerated2dCanvasEnabled = ... # type: QWebEngineSettings.WebAttribute
        AutoLoadIconsForPage = ... # type: QWebEngineSettings.WebAttribute
        TouchIconsEnabled = ... # type: QWebEngineSettings.WebAttribute
        FocusOnNavigationEnabled = ... # type: QWebEngineSettings.WebAttribute
        PrintElementBackgrounds = ... # type: QWebEngineSettings.WebAttribute
        AllowRunningInsecureContent = ... # type: QWebEngineSettings.WebAttribute
        AllowGeolocationOnInsecureOrigins = ... # type: QWebEngineSettings.WebAttribute
        AllowWindowActivationFromJavaScript = ... # type: QWebEngineSettings.WebAttribute
        ShowScrollBars = ... # type: QWebEngineSettings.WebAttribute
        PlaybackRequiresUserGesture = ... # type: QWebEngineSettings.WebAttribute
        WebRTCPublicInterfacesOnly = ... # type: QWebEngineSettings.WebAttribute
        JavascriptCanPaste = ... # type: QWebEngineSettings.WebAttribute
        DnsPrefetchEnabled = ... # type: QWebEngineSettings.WebAttribute
        PdfViewerEnabled = ... # type: QWebEngineSettings.WebAttribute
        NavigateOnDropEnabled = ... # type: QWebEngineSettings.WebAttribute
        ReadingFromCanvasEnabled = ... # type: QWebEngineSettings.WebAttribute
        ForceDarkMode = ... # type: QWebEngineSettings.WebAttribute
        PrintHeaderAndFooter = ... # type: QWebEngineSettings.WebAttribute
        PreferCSSMarginsForPrinting = ... # type: QWebEngineSettings.WebAttribute
        TouchEventsApiEnabled = ... # type: QWebEngineSettings.WebAttribute
        BackForwardCacheEnabled = ... # type: QWebEngineSettings.WebAttribute

    class FontFamily(enum.Enum):
        StandardFont = ... # type: QWebEngineSettings.FontFamily
        FixedFont = ... # type: QWebEngineSettings.FontFamily
        SerifFont = ... # type: QWebEngineSettings.FontFamily
        SansSerifFont = ... # type: QWebEngineSettings.FontFamily
        CursiveFont = ... # type: QWebEngineSettings.FontFamily
        FantasyFont = ... # type: QWebEngineSettings.FontFamily
        PictographFont = ... # type: QWebEngineSettings.FontFamily

    def resetImageAnimationPolicy(self) -> None: ...
    def imageAnimationPolicy(self) -> 'QWebEngineSettings.ImageAnimationPolicy': ...
    def setImageAnimationPolicy(self, policy: 'QWebEngineSettings.ImageAnimationPolicy') -> None: ...
    def resetUnknownUrlSchemePolicy(self) -> None: ...
    def setUnknownUrlSchemePolicy(self, policy: 'QWebEngineSettings.UnknownUrlSchemePolicy') -> None: ...
    def unknownUrlSchemePolicy(self) -> 'QWebEngineSettings.UnknownUrlSchemePolicy': ...
    def defaultTextEncoding(self) -> str: ...
    def setDefaultTextEncoding(self, encoding: str|None) -> None: ...
    def resetAttribute(self, attr: 'QWebEngineSettings.WebAttribute') -> None: ...
    def testAttribute(self, attr: 'QWebEngineSettings.WebAttribute') -> bool: ...
    def setAttribute(self, attr: 'QWebEngineSettings.WebAttribute', on: bool) -> None: ...
    def resetFontSize(self, type: 'QWebEngineSettings.FontSize') -> None: ...
    def fontSize(self, type: 'QWebEngineSettings.FontSize') -> int: ...
    def setFontSize(self, type: 'QWebEngineSettings.FontSize', size: int) -> None: ...
    def resetFontFamily(self, which: 'QWebEngineSettings.FontFamily') -> None: ...
    def fontFamily(self, which: 'QWebEngineSettings.FontFamily') -> str: ...
    def setFontFamily(self, which: 'QWebEngineSettings.FontFamily', family: str|None) -> None: ...


class QWebEngineUrlRequestInfo(PyQt6.sip.simplewrapper):

    class NavigationType(enum.Enum):
        NavigationTypeLink = ... # type: QWebEngineUrlRequestInfo.NavigationType
        NavigationTypeTyped = ... # type: QWebEngineUrlRequestInfo.NavigationType
        NavigationTypeFormSubmitted = ... # type: QWebEngineUrlRequestInfo.NavigationType
        NavigationTypeBackForward = ... # type: QWebEngineUrlRequestInfo.NavigationType
        NavigationTypeReload = ... # type: QWebEngineUrlRequestInfo.NavigationType
        NavigationTypeRedirect = ... # type: QWebEngineUrlRequestInfo.NavigationType
        NavigationTypeOther = ... # type: QWebEngineUrlRequestInfo.NavigationType

    class ResourceType(enum.Enum):
        ResourceTypeMainFrame = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeSubFrame = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeStylesheet = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeScript = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeImage = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeFontResource = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeSubResource = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeObject = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeMedia = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeWorker = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeSharedWorker = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypePrefetch = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeFavicon = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeXhr = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypePing = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeServiceWorker = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeUnknown = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeCspReport = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypePluginResource = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeNavigationPreloadMainFrame = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeNavigationPreloadSubFrame = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeWebSocket = ... # type: QWebEngineUrlRequestInfo.ResourceType
        ResourceTypeJson = ... # type: QWebEngineUrlRequestInfo.ResourceType

    def isDownload(self) -> bool: ...
    def requestBody(self) -> QtCore.QIODevice|None: ...
    def httpHeaders(self) -> dict[QtCore.QByteArray, QtCore.QByteArray]: ...
    def initiator(self) -> QtCore.QUrl: ...
    def setHttpHeader(self, name: QtCore.QByteArray|bytes|bytearray|memoryview, value: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def redirect(self, url: QtCore.QUrl) -> None: ...
    def block(self, shouldBlock: bool) -> None: ...
    def requestMethod(self) -> QtCore.QByteArray: ...
    def firstPartyUrl(self) -> QtCore.QUrl: ...
    def requestUrl(self) -> QtCore.QUrl: ...
    def navigationType(self) -> 'QWebEngineUrlRequestInfo.NavigationType': ...
    def resourceType(self) -> 'QWebEngineUrlRequestInfo.ResourceType': ...


class QWebEngineUrlRequestInterceptor(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def interceptRequest(self, info: QWebEngineUrlRequestInfo) -> None: ...


class QWebEngineUrlRequestJob(QtCore.QObject):

    class Error(enum.Enum):
        NoError = ... # type: QWebEngineUrlRequestJob.Error
        UrlNotFound = ... # type: QWebEngineUrlRequestJob.Error
        UrlInvalid = ... # type: QWebEngineUrlRequestJob.Error
        RequestAborted = ... # type: QWebEngineUrlRequestJob.Error
        RequestDenied = ... # type: QWebEngineUrlRequestJob.Error
        RequestFailed = ... # type: QWebEngineUrlRequestJob.Error

    def requestBody(self) -> QtCore.QIODevice|None: ...
    def setAdditionalResponseHeaders(self, additionalResponseHeaders: dict[QtCore.QByteArray|bytes|bytearray|memoryview, collections.abc.Sequence[QtCore.QByteArray|bytes|bytearray|memoryview]]) -> None: ...
    def requestHeaders(self) -> dict[QtCore.QByteArray, QtCore.QByteArray]: ...
    def initiator(self) -> QtCore.QUrl: ...
    def redirect(self, url: QtCore.QUrl) -> None: ...
    def fail(self, error: 'QWebEngineUrlRequestJob.Error') -> None: ...
    def reply(self, contentType: QtCore.QByteArray|bytes|bytearray|memoryview, device: QtCore.QIODevice|None) -> None: ...
    def requestMethod(self) -> QtCore.QByteArray: ...
    def requestUrl(self) -> QtCore.QUrl: ...


class QWebEngineUrlScheme(PyQt6.sip.simplewrapper):

    class Flag(enum.Flag):
        SecureScheme = ... # type: QWebEngineUrlScheme.Flag
        LocalScheme = ... # type: QWebEngineUrlScheme.Flag
        LocalAccessAllowed = ... # type: QWebEngineUrlScheme.Flag
        NoAccessAllowed = ... # type: QWebEngineUrlScheme.Flag
        ServiceWorkersAllowed = ... # type: QWebEngineUrlScheme.Flag
        ViewSourceAllowed = ... # type: QWebEngineUrlScheme.Flag
        ContentSecurityPolicyIgnored = ... # type: QWebEngineUrlScheme.Flag
        CorsEnabled = ... # type: QWebEngineUrlScheme.Flag
        FetchApiAllowed = ... # type: QWebEngineUrlScheme.Flag

    class SpecialPort(enum.Enum):
        PortUnspecified = ... # type: QWebEngineUrlScheme.SpecialPort

    class Syntax(enum.Enum):
        HostPortAndUserInformation = ... # type: QWebEngineUrlScheme.Syntax
        HostAndPort = ... # type: QWebEngineUrlScheme.Syntax
        Host = ... # type: QWebEngineUrlScheme.Syntax
        Path = ... # type: QWebEngineUrlScheme.Syntax

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    @typing.overload
    def __init__(self, that: 'QWebEngineUrlScheme') -> None: ...

    @staticmethod
    def schemeByName(name: QtCore.QByteArray|bytes|bytearray|memoryview) -> 'QWebEngineUrlScheme': ...
    @staticmethod
    def registerScheme(scheme: 'QWebEngineUrlScheme') -> None: ...
    def setFlags(self, newValue: 'QWebEngineUrlScheme.Flag') -> None: ...
    def flags(self) -> 'QWebEngineUrlScheme.Flag': ...
    def setDefaultPort(self, newValue: int) -> None: ...
    def defaultPort(self) -> int: ...
    def setSyntax(self, newValue: 'QWebEngineUrlScheme.Syntax') -> None: ...
    def syntax(self) -> 'QWebEngineUrlScheme.Syntax': ...
    def setName(self, newValue: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def name(self) -> QtCore.QByteArray: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QWebEngineUrlSchemeHandler(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def requestStarted(self, a0: QWebEngineUrlRequestJob|None) -> None: ...


class QWebEngineWebAuthUxRequest(QtCore.QObject):

    class RequestFailureReason(enum.Enum):
        Timeout = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason
        KeyNotRegistered = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason
        KeyAlreadyRegistered = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason
        SoftPinBlock = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason
        HardPinBlock = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason
        AuthenticatorRemovedDuringPinEntry = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason
        AuthenticatorMissingResidentKeys = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason
        AuthenticatorMissingUserVerification = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason
        AuthenticatorMissingLargeBlob = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason
        NoCommonAlgorithms = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason
        StorageFull = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason
        UserConsentDenied = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason
        WinUserCancelled = ... # type: QWebEngineWebAuthUxRequest.RequestFailureReason

    class PinEntryError(enum.Enum):
        NoError = ... # type: QWebEngineWebAuthUxRequest.PinEntryError
        InternalUvLocked = ... # type: QWebEngineWebAuthUxRequest.PinEntryError
        WrongPin = ... # type: QWebEngineWebAuthUxRequest.PinEntryError
        TooShort = ... # type: QWebEngineWebAuthUxRequest.PinEntryError
        InvalidCharacters = ... # type: QWebEngineWebAuthUxRequest.PinEntryError
        SameAsCurrentPin = ... # type: QWebEngineWebAuthUxRequest.PinEntryError

    class PinEntryReason(enum.Enum):
        Set = ... # type: QWebEngineWebAuthUxRequest.PinEntryReason
        Change = ... # type: QWebEngineWebAuthUxRequest.PinEntryReason
        Challenge = ... # type: QWebEngineWebAuthUxRequest.PinEntryReason

    class WebAuthUxState(enum.Enum):
        NotStarted = ... # type: QWebEngineWebAuthUxRequest.WebAuthUxState
        SelectAccount = ... # type: QWebEngineWebAuthUxRequest.WebAuthUxState
        CollectPin = ... # type: QWebEngineWebAuthUxRequest.WebAuthUxState
        FinishTokenCollection = ... # type: QWebEngineWebAuthUxRequest.WebAuthUxState
        RequestFailed = ... # type: QWebEngineWebAuthUxRequest.WebAuthUxState
        Cancelled = ... # type: QWebEngineWebAuthUxRequest.WebAuthUxState
        Completed = ... # type: QWebEngineWebAuthUxRequest.WebAuthUxState

    def setPin(self, pin: str|None) -> None: ...
    def setSelectedAccount(self, selectedAccount: str|None) -> None: ...
    def retry(self) -> None: ...
    def cancel(self) -> None: ...
    stateChanged: typing.ClassVar[QtCore.pyqtSignal]
    def requestFailureReason(self) -> 'QWebEngineWebAuthUxRequest.RequestFailureReason': ...
    def state(self) -> 'QWebEngineWebAuthUxRequest.WebAuthUxState': ...
    def pinRequest(self) -> 'QWebEngineWebAuthPinRequest': ...
    def relyingPartyId(self) -> str: ...
    def userNames(self) -> list[str]: ...


class QWebEngineWebAuthPinRequest(PyQt6.sip.simplewrapper):

    error = ... # type: QWebEngineWebAuthUxRequest.PinEntryError
    minPinLength = ... # type: int
    reason = ... # type: QWebEngineWebAuthUxRequest.PinEntryReason
    remainingAttempts = ... # type: int

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QWebEngineWebAuthPinRequest') -> None: ...


PYQT_WEBENGINE_VERSION = ... # type: int
PYQT_WEBENGINE_VERSION_STR = ... # type: str


def qWebEngineGetDomainAndRegistry(url: QtCore.QUrl) -> str: ...
def qWebEngineProcessName() -> str: ...
def qWebEngineChromiumSecurityPatchVersion() -> str: ...
def qWebEngineChromiumVersion() -> str: ...
def qWebEngineVersion() -> str: ...
