# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "15.2.1",
                "commands": r"cc",
                "args": r"-mabi=lp64d, -march=loongarch64, -mlsx, -O2, -pipe, -fexceptions, -mcmodel=medium, -Wp,-D_FORTIFY_SOURCE=3, -Wformat, -Werror=format-security, -fstack-clash-protection, -fno-omit-frame-pointer, -g, -ffile-prefix-map=/build/python-scipy/src=/usr/src/debug/python-scipy",
                "linker args": r"-Wl,-O1, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -mabi=lp64d, -march=loongarch64, -mlsx, -O2, -pipe, -fexceptions, -mcmodel=medium, -Wp,-D_FORTIFY_SOURCE=3, -Wformat, -Werror=format-security, -fstack-clash-protection, -fno-omit-frame-pointer, -g, -ffile-prefix-map=/build/python-scipy/src=/usr/src/debug/python-scipy",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.2.4",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "15.2.1",
                "commands": r"c++",
                "args": r"-mabi=lp64d, -march=loongarch64, -mlsx, -O2, -pipe, -fexceptions, -mcmodel=medium, -Wp,-D_FORTIFY_SOURCE=3, -Wformat, -Werror=format-security, -fstack-clash-protection, -fno-omit-frame-pointer, -Wp,-D_GLIBCXX_ASSERTIONS, -g, -ffile-prefix-map=/build/python-scipy/src=/usr/src/debug/python-scipy",
                "linker args": r"-Wl,-O1, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -mabi=lp64d, -march=loongarch64, -mlsx, -O2, -pipe, -fexceptions, -mcmodel=medium, -Wp,-D_FORTIFY_SOURCE=3, -Wformat, -Werror=format-security, -fstack-clash-protection, -fno-omit-frame-pointer, -Wp,-D_GLIBCXX_ASSERTIONS, -g, -ffile-prefix-map=/build/python-scipy/src=/usr/src/debug/python-scipy",
            },
            "fortran": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "15.2.1",
                "commands": r"gfortran",
                "args": r"-mabi=lp64d, -march=loongarch64, -mlsx, -O2, -pipe, -fexceptions, -mcmodel=medium, -Wp,-D_FORTIFY_SOURCE=3, -fstack-clash-protection, -fno-omit-frame-pointer, -g, -ffile-prefix-map=/build/python-scipy/src=/usr/src/debug/python-scipy",
                "linker args": r"-Wl,-O1, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -mabi=lp64d, -march=loongarch64, -mlsx, -O2, -pipe, -fexceptions, -mcmodel=medium, -Wp,-D_FORTIFY_SOURCE=3, -fstack-clash-protection, -fno-omit-frame-pointer, -g, -ffile-prefix-map=/build/python-scipy/src=/usr/src/debug/python-scipy",
            },
            "pythran": {
                "version": r"0.18.1",
                "include directory": r"../../../../../usr/lib/python3.14/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"loongarch64",
                "family": r"loongarch64",
                "endian": r"little",
                "system": r"linux",
            },
            "build": {
                "cpu": r"loongarch64",
                "family": r"loongarch64",
                "endian": r"little",
                "system": r"linux",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "blas",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.12.0",
                "detection method": "pkgconfig",
                "include directory": r"/usr/include",
                "lib directory": r"/usr/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/usr/lib/pkgconfig",
                "has ilp64": bool(r"False".lower().replace('false', '')),
            },
            "lapack": {
                "name": "lapack",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.12.0",
                "detection method": "pkgconfig",
                "include directory": r"/usr/include",
                "lib directory": r"/usr/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/usr/lib/pkgconfig",
                "has ilp64": bool(r"False".lower().replace('false', '')),
            },
            "pybind11": {
                "name": "pybind11",
                "version": "3.0.1",
                "detection method": "pkgconfig",
                "include directory": r"/usr/lib/pkgconfig/../python3.14/site-packages/pybind11/share/pkgconfig/../..//include",
            },
        },
        "Python Information": {
            "path": r"/usr/bin/python",
            "version": "3.14",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Examples
    --------
    >>> import scipy
    >>> scipy.show_config()
    ... # formatted output is printed to the console

    >>> config_dict = scipy.show_config(mode='dicts')
    >>> list(config_dict.keys())
    ['Compilers', 'Machine Information', 'Build Dependencies', 'Python Information']

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
