/* Generated by wayland-scanner 1.24.0 */

#ifndef XX_TEXT_INPUT_UNSTABLE_V3_ENUM_PROTOCOL_H
#define XX_TEXT_INPUT_UNSTABLE_V3_ENUM_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef XX_TEXT_INPUT_V3_CHANGE_CAUSE_ENUM
#define XX_TEXT_INPUT_V3_CHANGE_CAUSE_ENUM
/**
 * @ingroup iface_xx_text_input_v3
 * text change reason
 *
 * Reason for the change of surrounding text or cursor posision.
 */
enum xx_text_input_v3_change_cause {
	/**
	 * input method caused the change
	 */
	XX_TEXT_INPUT_V3_CHANGE_CAUSE_INPUT_METHOD = 0,
	/**
	 * something else than the input method caused the change
	 */
	XX_TEXT_INPUT_V3_CHANGE_CAUSE_OTHER = 1,
};
#endif /* XX_TEXT_INPUT_V3_CHANGE_CAUSE_ENUM */

#ifndef XX_TEXT_INPUT_V3_CONTENT_HINT_ENUM
#define XX_TEXT_INPUT_V3_CONTENT_HINT_ENUM
/**
 * @ingroup iface_xx_text_input_v3
 * content hint
 *
 * Content hint is a bitmask to allow to modify the behavior of the text
 * input.
 */
enum xx_text_input_v3_content_hint {
	/**
	 * no special behavior
	 */
	XX_TEXT_INPUT_V3_CONTENT_HINT_NONE = 0x0,
	/**
	 * suggest word completions
	 */
	XX_TEXT_INPUT_V3_CONTENT_HINT_COMPLETION = 0x1,
	/**
	 * suggest word corrections
	 */
	XX_TEXT_INPUT_V3_CONTENT_HINT_SPELLCHECK = 0x2,
	/**
	 * switch to uppercase letters at the start of a sentence
	 */
	XX_TEXT_INPUT_V3_CONTENT_HINT_AUTO_CAPITALIZATION = 0x4,
	/**
	 * prefer lowercase letters
	 */
	XX_TEXT_INPUT_V3_CONTENT_HINT_LOWERCASE = 0x8,
	/**
	 * prefer uppercase letters
	 */
	XX_TEXT_INPUT_V3_CONTENT_HINT_UPPERCASE = 0x10,
	/**
	 * prefer casing for titles and headings (can be language dependent)
	 */
	XX_TEXT_INPUT_V3_CONTENT_HINT_TITLECASE = 0x20,
	/**
	 * characters should be hidden
	 */
	XX_TEXT_INPUT_V3_CONTENT_HINT_HIDDEN_TEXT = 0x40,
	/**
	 * typed text should not be stored
	 */
	XX_TEXT_INPUT_V3_CONTENT_HINT_SENSITIVE_DATA = 0x80,
	/**
	 * just Latin characters should be entered
	 */
	XX_TEXT_INPUT_V3_CONTENT_HINT_LATIN = 0x100,
	/**
	 * the text input is multiline
	 */
	XX_TEXT_INPUT_V3_CONTENT_HINT_MULTILINE = 0x200,
};
#endif /* XX_TEXT_INPUT_V3_CONTENT_HINT_ENUM */

#ifndef XX_TEXT_INPUT_V3_CONTENT_PURPOSE_ENUM
#define XX_TEXT_INPUT_V3_CONTENT_PURPOSE_ENUM
/**
 * @ingroup iface_xx_text_input_v3
 * content purpose
 *
 * The content purpose allows to specify the primary purpose of a text
 * input.
 *
 * This allows an input method to show special purpose input panels with
 * extra characters or to disallow some characters.
 */
enum xx_text_input_v3_content_purpose {
	/**
	 * default input, allowing all characters
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_NORMAL = 0,
	/**
	 * allow only alphabetic characters
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_ALPHA = 1,
	/**
	 * allow only digits
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_DIGITS = 2,
	/**
	 * input a number (including decimal separator and sign)
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_NUMBER = 3,
	/**
	 * input a phone number
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_PHONE = 4,
	/**
	 * input an URL
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_URL = 5,
	/**
	 * input an email address
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_EMAIL = 6,
	/**
	 * input a name of a person
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_NAME = 7,
	/**
	 * input a password (combine with sensitive_data hint)
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_PASSWORD = 8,
	/**
	 * input is a numeric password (combine with sensitive_data hint)
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_PIN = 9,
	/**
	 * input a date
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_DATE = 10,
	/**
	 * input a time
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_TIME = 11,
	/**
	 * input a date and time
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_DATETIME = 12,
	/**
	 * input for a terminal
	 */
	XX_TEXT_INPUT_V3_CONTENT_PURPOSE_TERMINAL = 13,
};
#endif /* XX_TEXT_INPUT_V3_CONTENT_PURPOSE_ENUM */

#ifdef  __cplusplus
}
#endif

#endif
